/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.compute.extensions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import org.jclouds.aws.ec2.AWSEC2Api;
import org.jclouds.aws.util.AWSUtils;
import org.jclouds.collect.Memoized;
import org.jclouds.compute.functions.GroupNamingConvention;
import org.jclouds.domain.Location;
import org.jclouds.ec2.compute.domain.RegionAndName;
import org.jclouds.ec2.compute.domain.RegionNameAndIngressRules;
import org.jclouds.ec2.compute.extensions.EC2SecurityGroupExtension;
import org.jclouds.ec2.domain.SecurityGroup;
import org.jclouds.location.Region;
import org.jclouds.net.domain.IpPermission;
import org.jclouds.net.domain.IpProtocol;

public class AWSEC2SecurityGroupExtension
extends EC2SecurityGroupExtension {
    protected final AWSEC2Api client;
    protected final Function<String, String> groupNameToId;

    @Inject
    public AWSEC2SecurityGroupExtension(AWSEC2Api client, @Named(value="jclouds.user-threads") ListeningExecutorService userExecutor, @Region Supplier<Set<String>> regions, Function<SecurityGroup, org.jclouds.compute.domain.SecurityGroup> groupConverter, @Memoized Supplier<Set<? extends Location>> locations, @Named(value="SECURITY") LoadingCache<RegionAndName, String> groupCreator, GroupNamingConvention.Factory namingConvention, @Named(value="SECGROUP_NAME_TO_ID") Function<String, String> groupNameToId) {
        super(client, userExecutor, regions, groupConverter, locations, groupCreator, namingConvention);
        this.client = Preconditions.checkNotNull(client, "client");
        this.groupNameToId = Preconditions.checkNotNull(groupNameToId, "groupNameToId");
    }

    @Override
    public org.jclouds.compute.domain.SecurityGroup createSecurityGroup(String name, String region) {
        String markerGroup = this.namingConvention.create().sharedNameForGroup(name);
        RegionNameAndIngressRules regionAndName = new RegionNameAndIngressRules(region, markerGroup, new int[0], false, null);
        this.groupCreator.getUnchecked(regionAndName);
        String groupId = this.groupNameToId.apply(regionAndName.slashEncode());
        return this.getSecurityGroupById(regionAndName.getRegion() + "/" + groupId);
    }

    @Override
    public org.jclouds.compute.domain.SecurityGroup getSecurityGroupById(String id) {
        Preconditions.checkNotNull(id, "id");
        String[] parts = AWSUtils.parseHandle(id);
        String region = parts[0];
        String groupId = parts[1];
        Set<SecurityGroup> rawGroups = this.client.getSecurityGroupApi().get().describeSecurityGroupsInRegionById(region, groupId);
        return (org.jclouds.compute.domain.SecurityGroup)Iterables.getOnlyElement(Iterables.transform(Iterables.filter(rawGroups, Predicates.notNull()), this.groupConverter));
    }

    @Override
    public boolean removeSecurityGroup(String id) {
        Preconditions.checkNotNull(id, "id");
        String[] parts = AWSUtils.parseHandle(id);
        String region = parts[0];
        String groupId = parts[1];
        SecurityGroup group = Iterables.getFirst(this.client.getSecurityGroupApi().get().describeSecurityGroupsInRegionById(region, groupId), null);
        if (group != null) {
            this.client.getSecurityGroupApi().get().deleteSecurityGroupInRegionById(region, groupId);
            this.groupCreator.invalidate(new RegionNameAndIngressRules(region, group.getName(), null, false, null));
            return true;
        }
        for (Map.Entry cachedSg : this.groupCreator.asMap().entrySet()) {
            if (!groupId.equals(cachedSg.getValue())) continue;
            this.groupCreator.invalidate(cachedSg.getKey());
            break;
        }
        return false;
    }

    @Override
    public org.jclouds.compute.domain.SecurityGroup addIpPermission(IpPermission ipPermission, org.jclouds.compute.domain.SecurityGroup group) {
        String region = AWSUtils.getRegionFromLocationOrNull(group.getLocation());
        String id = group.getProviderId();
        this.client.getSecurityGroupApi().get().authorizeSecurityGroupIngressInRegion(region, id, ipPermission);
        return this.getSecurityGroupById(group.getId());
    }

    @Override
    public org.jclouds.compute.domain.SecurityGroup addIpPermission(IpProtocol protocol, int startPort, int endPort, Multimap<String, String> tenantIdGroupNamePairs, Iterable<String> ipRanges, Iterable<String> groupIds, org.jclouds.compute.domain.SecurityGroup group) {
        String region = AWSUtils.getRegionFromLocationOrNull(group.getLocation());
        String id = group.getProviderId();
        IpPermission.Builder builder = IpPermission.builder();
        builder.ipProtocol(protocol);
        builder.fromPort(startPort);
        builder.toPort(endPort);
        if (!Iterables.isEmpty(ipRanges)) {
            for (String cidr : ipRanges) {
                builder.cidrBlock(cidr);
            }
        }
        if (!tenantIdGroupNamePairs.isEmpty()) {
            for (String userId : tenantIdGroupNamePairs.keySet()) {
                for (String groupString : tenantIdGroupNamePairs.get(userId)) {
                    String[] parts = AWSUtils.parseHandle(groupString);
                    String groupId = parts[1];
                    builder.tenantIdGroupNamePair(userId, groupId);
                }
            }
        }
        this.client.getSecurityGroupApi().get().authorizeSecurityGroupIngressInRegion(region, id, builder.build());
        return this.getSecurityGroupById(group.getId());
    }

    @Override
    public org.jclouds.compute.domain.SecurityGroup removeIpPermission(IpPermission ipPermission, org.jclouds.compute.domain.SecurityGroup group) {
        String region = AWSUtils.getRegionFromLocationOrNull(group.getLocation());
        String id = group.getProviderId();
        this.client.getSecurityGroupApi().get().revokeSecurityGroupIngressInRegion(region, id, ipPermission);
        return this.getSecurityGroupById(group.getId());
    }

    @Override
    public org.jclouds.compute.domain.SecurityGroup removeIpPermission(IpProtocol protocol, int startPort, int endPort, Multimap<String, String> tenantIdGroupNamePairs, Iterable<String> ipRanges, Iterable<String> groupIds, org.jclouds.compute.domain.SecurityGroup group) {
        String region = AWSUtils.getRegionFromLocationOrNull(group.getLocation());
        String id = group.getProviderId();
        IpPermission.Builder builder = IpPermission.builder();
        builder.ipProtocol(protocol);
        builder.fromPort(startPort);
        builder.toPort(endPort);
        if (!Iterables.isEmpty(ipRanges)) {
            for (String cidr : ipRanges) {
                builder.cidrBlock(cidr);
            }
        }
        if (!tenantIdGroupNamePairs.isEmpty()) {
            for (String userId : tenantIdGroupNamePairs.keySet()) {
                for (String groupString : tenantIdGroupNamePairs.get(userId)) {
                    String[] parts = AWSUtils.parseHandle(groupString);
                    String groupId = parts[1];
                    builder.tenantIdGroupNamePair(userId, groupId);
                }
            }
        }
        this.client.getSecurityGroupApi().get().revokeSecurityGroupIngressInRegion(region, id, builder.build());
        return this.getSecurityGroupById(group.getId());
    }

    @Override
    public boolean supportsTenantIdGroupNamePairs() {
        return false;
    }

    @Override
    public boolean supportsTenantIdGroupIdPairs() {
        return true;
    }
}

