/*
 * Decompiled with CFR 0.152.
 */
package com.parablu;

import java.io.IOException;
import java.io.InputStream;
import java.util.function.LongConsumer;

public class ProgressInputStream
extends InputStream {
    private final InputStream inputStream;
    private final LongConsumer progressCallback;
    private long bytesRead;

    public ProgressInputStream(InputStream inputStream, LongConsumer progressCallback) {
        this.inputStream = inputStream;
        this.progressCallback = progressCallback;
        this.bytesRead = 0L;
    }

    @Override
    public int read() throws IOException {
        int data = this.inputStream.read();
        if (data != -1) {
            ++this.bytesRead;
            this.progressCallback.accept(1L);
        }
        return data;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int bytesReadThisTime = this.inputStream.read(b, off, len);
        if (bytesReadThisTime != -1) {
            this.bytesRead += (long)bytesReadThisTime;
            this.progressCallback.accept(bytesReadThisTime);
        }
        return bytesReadThisTime;
    }

    @Override
    public long skip(long n) throws IOException {
        long bytesSkipped = this.inputStream.skip(n);
        this.bytesRead += bytesSkipped;
        this.progressCallback.accept(bytesSkipped);
        return bytesSkipped;
    }

    @Override
    public int available() throws IOException {
        return this.inputStream.available();
    }

    @Override
    public void close() throws IOException {
        this.inputStream.close();
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.inputStream.mark(readlimit);
    }

    @Override
    public synchronized void reset() throws IOException {
        this.inputStream.reset();
    }

    @Override
    public boolean markSupported() {
        return this.inputStream.markSupported();
    }

    public long getBytesRead() {
        return this.bytesRead;
    }
}

