/*
 * Decompiled with CFR 0.152.
 */
package com.parablu;

import java.io.ByteArrayInputStream;
import java.util.function.LongConsumer;

public class ProgressByteArrayInputStream
extends ByteArrayInputStream {
    private LongConsumer progressCallback;
    private long readBytes = 0L;
    private long totalBytes = 0L;

    public ProgressByteArrayInputStream(byte[] buf, LongConsumer progressCallback) {
        super(buf);
        this.progressCallback = progressCallback;
        this.totalBytes = buf.length;
    }

    public ProgressByteArrayInputStream(byte[] buf, int offset, int length, LongConsumer progressCallback) {
        super(buf, offset, length);
        this.progressCallback = progressCallback;
        this.totalBytes = length;
    }

    @Override
    public synchronized int read(byte[] b, int off, int len) {
        int count = super.read(b, off, len);
        if (count > 0) {
            this.readBytes += (long)count;
            this.progressCallback.accept(this.readBytes);
        }
        return count;
    }

    @Override
    public synchronized int read() {
        int value = super.read();
        if (value >= 0) {
            ++this.readBytes;
            this.progressCallback.accept(this.readBytes);
        }
        return value;
    }

    @Override
    public synchronized long skip(long n) {
        long skipped = super.skip(n);
        if (skipped > 0L) {
            this.readBytes += skipped;
            this.progressCallback.accept(this.readBytes);
        }
        return skipped;
    }

    @Override
    public synchronized void reset() {
        super.reset();
        this.readBytes = this.totalBytes - (long)this.available();
    }
}

