/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.msal4j;

import com.microsoft.aad.msal4j.ClaimsRequest;
import com.microsoft.aad.msal4j.IApiParameters;
import com.microsoft.aad.msal4j.IUserAssertion;
import com.microsoft.aad.msal4j.ParameterValidationUtils;
import com.microsoft.aad.msal4j.UserAssertion;
import java.util.Set;
import lombok.NonNull;

public class OnBehalfOfParameters
implements IApiParameters {
    @NonNull
    private Set<String> scopes;
    private ClaimsRequest claims;
    @NonNull
    private IUserAssertion userAssertion;

    private static OnBehalfOfParametersBuilder builder() {
        return new OnBehalfOfParametersBuilder();
    }

    public static OnBehalfOfParametersBuilder builder(Set<String> scopes, UserAssertion userAssertion) {
        ParameterValidationUtils.validateNotEmpty("scopes", scopes);
        return OnBehalfOfParameters.builder().scopes(scopes).userAssertion(userAssertion);
    }

    @Override
    @NonNull
    public Set<String> scopes() {
        return this.scopes;
    }

    @Override
    public ClaimsRequest claims() {
        return this.claims;
    }

    @NonNull
    public IUserAssertion userAssertion() {
        return this.userAssertion;
    }

    private OnBehalfOfParameters(@NonNull Set<String> scopes, ClaimsRequest claims, @NonNull IUserAssertion userAssertion) {
        if (scopes == null) {
            throw new NullPointerException("scopes is marked @NonNull but is null");
        }
        if (userAssertion == null) {
            throw new NullPointerException("userAssertion is marked @NonNull but is null");
        }
        this.scopes = scopes;
        this.claims = claims;
        this.userAssertion = userAssertion;
    }

    public static class OnBehalfOfParametersBuilder {
        private Set<String> scopes;
        private ClaimsRequest claims;
        private IUserAssertion userAssertion;

        OnBehalfOfParametersBuilder() {
        }

        public OnBehalfOfParametersBuilder scopes(Set<String> scopes) {
            this.scopes = scopes;
            return this;
        }

        public OnBehalfOfParametersBuilder claims(ClaimsRequest claims) {
            this.claims = claims;
            return this;
        }

        public OnBehalfOfParametersBuilder userAssertion(IUserAssertion userAssertion) {
            this.userAssertion = userAssertion;
            return this;
        }

        public OnBehalfOfParameters build() {
            return new OnBehalfOfParameters(this.scopes, this.claims, this.userAssertion);
        }

        public String toString() {
            return "OnBehalfOfParameters.OnBehalfOfParametersBuilder(scopes=" + this.scopes + ", claims=" + this.claims + ", userAssertion=" + this.userAssertion + ")";
        }
    }
}

