/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.core;

import com.google.gson.JsonElement;
import com.microsoft.graph.authentication.IAuthenticationProvider;
import com.microsoft.graph.content.BatchRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.CustomRequestBuilder;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.CoreHttpProvider;
import com.microsoft.graph.http.IHttpProvider;
import com.microsoft.graph.httpcore.HttpClients;
import com.microsoft.graph.logger.DefaultLogger;
import com.microsoft.graph.logger.ILogger;
import com.microsoft.graph.serializer.DefaultSerializer;
import com.microsoft.graph.serializer.ISerializer;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collections;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import okhttp3.OkHttpClient;
import okhttp3.Request;

public class BaseClient<nativeRequestType>
implements IBaseClient<nativeRequestType> {
    public static final String DEFAULT_GRAPH_ENDPOINT = "https://graph.microsoft.com/v1.0";
    private String endpoint;
    private IHttpProvider<nativeRequestType> httpProvider;
    private ILogger logger;
    private ISerializer serializer;

    protected BaseClient() {
    }

    @Override
    @Nonnull
    public String getServiceRoot() {
        if (this.endpoint == null) {
            this.endpoint = DEFAULT_GRAPH_ENDPOINT;
        }
        return this.endpoint;
    }

    @Override
    public void setServiceRoot(@Nonnull String value) {
        Objects.requireNonNull(value, "value parameter cannot be null");
        this.endpoint = String.valueOf(value);
    }

    @Override
    @Nonnull
    public <T> CustomRequestBuilder<T> customRequest(@Nonnull String url, @Nonnull Class<T> responseType) {
        Objects.requireNonNull(url, "url parameter cannot be null");
        Objects.requireNonNull(responseType, "responseType parameter cannot be null");
        return new CustomRequestBuilder<T>(this.getServiceRoot() + url, this, null, responseType);
    }

    @Override
    @Nonnull
    public CustomRequestBuilder<JsonElement> customRequest(@Nonnull String url) {
        return this.customRequest(url, JsonElement.class);
    }

    @Override
    @Nonnull
    public BatchRequestBuilder batch() {
        return new BatchRequestBuilder(this.getServiceRoot() + "/$batch", this, Collections.emptyList());
    }

    @Nonnull
    public static Builder<OkHttpClient, Request> builder() {
        return BaseClient.builder(OkHttpClient.class, Request.class);
    }

    @Nonnull
    public static <nativeClient, nativeRequest> Builder<nativeClient, nativeRequest> builder(@Nonnull Class<nativeClient> nativeClientClass, @Nonnull Class<nativeRequest> nativeRequestClass) {
        return new Builder();
    }

    @Override
    @Nullable
    public IHttpProvider<nativeRequestType> getHttpProvider() {
        return this.httpProvider;
    }

    @Override
    @Nullable
    @SuppressFBWarnings
    public ILogger getLogger() {
        return this.logger;
    }

    @Override
    @Nullable
    public ISerializer getSerializer() {
        return this.serializer;
    }

    protected void setLogger(@Nonnull ILogger logger) {
        Objects.requireNonNull(logger, "parameter logger cannot be null");
        this.logger = logger;
    }

    protected void setHttpProvider(@Nonnull IHttpProvider<nativeRequestType> httpProvider) {
        Objects.requireNonNull(httpProvider, "parameter httpProvider cannot be null");
        this.httpProvider = httpProvider;
    }

    public void setSerializer(@Nonnull ISerializer serializer) {
        Objects.requireNonNull(serializer, "parameter serializer cannot be null");
        this.serializer = serializer;
    }

    @Override
    @Nullable
    public String getServiceSDKVersion() {
        return null;
    }

    public static class Builder<httpClientType, nativeRequestType> {
        private ISerializer serializer;
        private IHttpProvider<nativeRequestType> httpProvider;
        private ILogger logger;
        private httpClientType httpClient;
        private IAuthenticationProvider auth;

        private IAuthenticationProvider getAuthenticationProvider() {
            if (this.auth == null) {
                throw new NullPointerException("auth");
            }
            return this.auth;
        }

        private ILogger getLogger() {
            if (this.logger == null) {
                return new DefaultLogger();
            }
            return this.logger;
        }

        private ISerializer getSerializer() {
            if (this.serializer == null) {
                return new DefaultSerializer(this.getLogger());
            }
            return this.serializer;
        }

        private httpClientType getHttpClient() {
            if (this.httpClient == null) {
                return (httpClientType)HttpClients.createDefault(this.getAuthenticationProvider());
            }
            return this.httpClient;
        }

        private IHttpProvider<nativeRequestType> getHttpProvider() {
            if (this.httpProvider == null) {
                return new CoreHttpProvider(this.getSerializer(), this.getLogger(), (OkHttpClient)this.getHttpClient());
            }
            return this.httpProvider;
        }

        @Nonnull
        public Builder<httpClientType, nativeRequestType> serializer(@Nonnull ISerializer serializer) {
            Objects.requireNonNull(serializer, "parameter serializer cannot be null");
            this.serializer = serializer;
            return this;
        }

        @Nonnull
        public Builder<httpClientType, nativeRequestType> httpProvider(@Nonnull IHttpProvider<nativeRequestType> httpProvider) {
            Objects.requireNonNull(httpProvider, "parameter httpProvider cannot be null");
            this.httpProvider = httpProvider;
            return this;
        }

        @Nonnull
        @SuppressFBWarnings
        public Builder<httpClientType, nativeRequestType> logger(@Nonnull ILogger logger) {
            Objects.requireNonNull(logger, "parameter logger cannot be null");
            this.logger = logger;
            return this;
        }

        @Nonnull
        public Builder<httpClientType, nativeRequestType> httpClient(@Nonnull httpClientType client) {
            Objects.requireNonNull(client, "parameter client cannot be null");
            this.httpClient = client;
            return this;
        }

        @Nonnull
        public Builder<httpClientType, nativeRequestType> authenticationProvider(@Nonnull IAuthenticationProvider auth) {
            Objects.requireNonNull(auth, "parameter auth cannot be null");
            this.auth = auth;
            return this;
        }

        @Nonnull
        protected <ClientType extends BaseClient<nativeRequestType>> ClientType buildClient(@Nonnull ClientType instance) throws ClientException {
            Objects.requireNonNull(instance, "The instance cannot be null");
            instance.setHttpProvider(this.getHttpProvider());
            instance.setLogger(this.getLogger());
            instance.setSerializer(this.getSerializer());
            return instance;
        }

        @Nonnull
        public IBaseClient<nativeRequestType> buildClient() throws ClientException {
            return this.buildClient(new BaseClient());
        }
    }
}

