/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.security.requests;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.security.models.DataSourceContainer;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DataSourceContainerRequest
extends BaseRequest<DataSourceContainer> {
    public DataSourceContainerRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions, @Nonnull Class<? extends DataSourceContainer> responseClass) {
        super(requestUrl, client, requestOptions, responseClass);
    }

    public DataSourceContainerRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, DataSourceContainer.class);
    }

    @Nonnull
    public CompletableFuture<DataSourceContainer> getAsync() {
        return this.sendAsync(HttpMethod.GET, null);
    }

    @Nullable
    public DataSourceContainer get() throws ClientException {
        return (DataSourceContainer)this.send(HttpMethod.GET, null);
    }

    @Nonnull
    public CompletableFuture<DataSourceContainer> deleteAsync() {
        return this.sendAsync(HttpMethod.DELETE, null);
    }

    @Nullable
    public DataSourceContainer delete() throws ClientException {
        return (DataSourceContainer)this.send(HttpMethod.DELETE, null);
    }

    @Nonnull
    public CompletableFuture<DataSourceContainer> patchAsync(@Nonnull DataSourceContainer sourceDataSourceContainer) {
        return this.sendAsync(HttpMethod.PATCH, sourceDataSourceContainer);
    }

    @Nullable
    public DataSourceContainer patch(@Nonnull DataSourceContainer sourceDataSourceContainer) throws ClientException {
        return (DataSourceContainer)this.send(HttpMethod.PATCH, sourceDataSourceContainer);
    }

    @Nonnull
    public CompletableFuture<DataSourceContainer> postAsync(@Nonnull DataSourceContainer newDataSourceContainer) {
        return this.sendAsync(HttpMethod.POST, newDataSourceContainer);
    }

    @Nullable
    public DataSourceContainer post(@Nonnull DataSourceContainer newDataSourceContainer) throws ClientException {
        return (DataSourceContainer)this.send(HttpMethod.POST, newDataSourceContainer);
    }

    @Nonnull
    public CompletableFuture<DataSourceContainer> putAsync(@Nonnull DataSourceContainer newDataSourceContainer) {
        return this.sendAsync(HttpMethod.PUT, newDataSourceContainer);
    }

    @Nullable
    public DataSourceContainer put(@Nonnull DataSourceContainer newDataSourceContainer) throws ClientException {
        return (DataSourceContainer)this.send(HttpMethod.PUT, newDataSourceContainer);
    }

    @Nonnull
    public DataSourceContainerRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public DataSourceContainerRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }
}

