/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseReferenceRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.models.MobileAppCategory;
import com.microsoft.graph.options.Option;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class MobileAppCategoryReferenceRequest
extends BaseReferenceRequest<MobileAppCategory> {
    public MobileAppCategoryReferenceRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, MobileAppCategory.class);
    }

    @Nonnull
    public MobileAppCategoryReferenceRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public MobileAppCategoryReferenceRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }

    @Nonnull
    public CompletableFuture<MobileAppCategory> putAsync(@Nonnull MobileAppCategory srcMobileAppCategory) {
        JsonObject payload = new JsonObject();
        payload.add("@odata.id", (JsonElement)new JsonPrimitive(this.getClient().getServiceRoot() + "/deviceAppManagement/mobileAppCategories/" + srcMobileAppCategory.id));
        return this.sendAsync(HttpMethod.PUT, payload);
    }

    @Nullable
    public MobileAppCategory put(@Nonnull MobileAppCategory srcMobileAppCategory) throws ClientException {
        JsonObject payload = new JsonObject();
        payload.add("@odata.id", (JsonElement)new JsonPrimitive(this.getClient().getServiceRoot() + "/deviceAppManagement/mobileAppCategories/" + srcMobileAppCategory.id));
        return (MobileAppCategory)this.send(HttpMethod.PUT, payload);
    }
}

