/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseEntityCollectionRequest;
import com.microsoft.graph.models.GroupSetting;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.requests.GroupSettingCollectionPage;
import com.microsoft.graph.requests.GroupSettingCollectionRequestBuilder;
import com.microsoft.graph.requests.GroupSettingCollectionResponse;
import com.microsoft.graph.requests.GroupSettingRequestBuilder;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class GroupSettingCollectionRequest
extends BaseEntityCollectionRequest<GroupSetting, GroupSettingCollectionResponse, GroupSettingCollectionPage> {
    public GroupSettingCollectionRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, GroupSettingCollectionResponse.class, GroupSettingCollectionPage.class, GroupSettingCollectionRequestBuilder.class);
    }

    @Nonnull
    public CompletableFuture<GroupSetting> postAsync(@Nonnull GroupSetting newGroupSetting) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new GroupSettingRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).postAsync(newGroupSetting);
    }

    @Nonnull
    public GroupSetting post(@Nonnull GroupSetting newGroupSetting) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new GroupSettingRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newGroupSetting);
    }

    @Nonnull
    public GroupSettingCollectionRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }

    @Nonnull
    public GroupSettingCollectionRequest filter(@Nonnull String value) {
        this.addFilterOption(value);
        return this;
    }

    @Nonnull
    public GroupSettingCollectionRequest orderBy(@Nonnull String value) {
        this.addOrderByOption(value);
        return this;
    }

    @Nonnull
    public GroupSettingCollectionRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public GroupSettingCollectionRequest top(int value) {
        this.addTopOption(value);
        return this;
    }

    @Nonnull
    public GroupSettingCollectionRequest count(boolean value) {
        this.addCountOption(value);
        return this;
    }

    @Nonnull
    public GroupSettingCollectionRequest count() {
        this.addCountOption(true);
        return this;
    }

    @Nonnull
    public GroupSettingCollectionRequest skip(int value) {
        this.addSkipOption(value);
        return this;
    }

    @Nonnull
    public GroupSettingCollectionRequest skipToken(@Nonnull String skipToken) {
        this.addSkipTokenOption(skipToken);
        return this;
    }
}

