/*
 * Decompiled with CFR 0.152.
 */
package org.linguafranca.pwdb.base;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.linguafranca.pwdb.Database;
import org.linguafranca.pwdb.Entry;
import org.linguafranca.pwdb.Group;
import org.linguafranca.pwdb.Icon;

public abstract class AbstractGroup<D extends Database<D, G, E, I>, G extends AbstractGroup<D, G, E, I>, E extends Entry<D, G, E, I>, I extends Icon>
implements Group<D, G, E, I> {
    @Override
    public List<? extends G> findGroups(String group1) {
        ArrayList<AbstractGroup> result = new ArrayList<AbstractGroup>();
        for (AbstractGroup g : this.getGroups()) {
            if (!g.getName().equals(group1)) continue;
            result.add(g);
        }
        return result;
    }

    @Override
    public List<? extends E> findEntries(String find, boolean recursive) {
        ArrayList result = new ArrayList(this.getEntries().size());
        if (this.isRecycleBin()) {
            return result;
        }
        for (Entry entry : this.getEntries()) {
            if (!entry.match(find)) continue;
            result.add(entry);
        }
        if (recursive) {
            for (AbstractGroup group : this.getGroups()) {
                result.addAll(group.findEntries(find, true));
            }
        }
        return result;
    }

    @Override
    public List<? extends E> findEntries(Entry.Matcher matcher, boolean recursive) {
        ArrayList result = new ArrayList(this.getEntries().size());
        if (this.isRecycleBin()) {
            return result;
        }
        for (Entry entry : this.getEntries()) {
            if (!entry.match(matcher)) continue;
            result.add(entry);
        }
        if (recursive) {
            for (AbstractGroup group : this.getGroups()) {
                result.addAll(group.findEntries(matcher, true));
            }
        }
        return result;
    }

    @Override
    public void copy(Group<? extends Database, ? extends Group, ? extends Entry, ? extends Icon> parent) {
        for (Group group : parent.getGroups()) {
            AbstractGroup addedGroup = (AbstractGroup)this.addGroup(this.getDatabase().newGroup(group));
            addedGroup.copy(group);
        }
        for (Entry entry : parent.getEntries()) {
            this.addEntry(this.getDatabase().newEntry(entry));
        }
    }

    @Override
    public String getPath() {
        Stack<AbstractGroup> parents = new Stack<AbstractGroup>();
        AbstractGroup<D, G, E, I> parent = this;
        parents.push(this);
        while ((parent = parent.getParent()) != null) {
            parents.push(parent);
        }
        String result = "/";
        while (parents.size() > 0) {
            result = result + ((Group)parents.pop()).getName() + "/";
        }
        return result;
    }

    public String toString() {
        return this.getPath();
    }
}

