/*
 * Decompiled with CFR 0.152.
 */
package org.spongycastle.crypto.tls;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.SecureRandom;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.spongycastle.crypto.Digest;
import org.spongycastle.crypto.prng.RandomGenerator;
import org.spongycastle.crypto.tls.AbstractTlsContext;
import org.spongycastle.crypto.tls.ByteQueue;
import org.spongycastle.crypto.tls.ByteQueueInputStream;
import org.spongycastle.crypto.tls.ByteQueueOutputStream;
import org.spongycastle.crypto.tls.Certificate;
import org.spongycastle.crypto.tls.MaxFragmentLength;
import org.spongycastle.crypto.tls.ProtocolVersion;
import org.spongycastle.crypto.tls.RecordStream;
import org.spongycastle.crypto.tls.SecurityParameters;
import org.spongycastle.crypto.tls.SessionParameters;
import org.spongycastle.crypto.tls.SupplementalDataEntry;
import org.spongycastle.crypto.tls.TlsContext;
import org.spongycastle.crypto.tls.TlsExtensionsUtils;
import org.spongycastle.crypto.tls.TlsFatalAlert;
import org.spongycastle.crypto.tls.TlsHandshakeHash;
import org.spongycastle.crypto.tls.TlsInputStream;
import org.spongycastle.crypto.tls.TlsKeyExchange;
import org.spongycastle.crypto.tls.TlsOutputStream;
import org.spongycastle.crypto.tls.TlsPeer;
import org.spongycastle.crypto.tls.TlsSession;
import org.spongycastle.crypto.tls.TlsSessionImpl;
import org.spongycastle.crypto.tls.TlsUtils;
import org.spongycastle.util.Arrays;
import org.spongycastle.util.Integers;

public abstract class TlsProtocol {
    protected static final Integer EXT_RenegotiationInfo = Integers.valueOf(65281);
    protected static final Integer EXT_SessionTicket = Integers.valueOf(35);
    private static final String TLS_ERROR_MESSAGE = "Internal TLS error, this could be an attack";
    protected static final short CS_START = 0;
    protected static final short CS_CLIENT_HELLO = 1;
    protected static final short CS_SERVER_HELLO = 2;
    protected static final short CS_SERVER_SUPPLEMENTAL_DATA = 3;
    protected static final short CS_SERVER_CERTIFICATE = 4;
    protected static final short CS_CERTIFICATE_STATUS = 5;
    protected static final short CS_SERVER_KEY_EXCHANGE = 6;
    protected static final short CS_CERTIFICATE_REQUEST = 7;
    protected static final short CS_SERVER_HELLO_DONE = 8;
    protected static final short CS_CLIENT_SUPPLEMENTAL_DATA = 9;
    protected static final short CS_CLIENT_CERTIFICATE = 10;
    protected static final short CS_CLIENT_KEY_EXCHANGE = 11;
    protected static final short CS_CERTIFICATE_VERIFY = 12;
    protected static final short CS_CLIENT_FINISHED = 13;
    protected static final short CS_SERVER_SESSION_TICKET = 14;
    protected static final short CS_SERVER_FINISHED = 15;
    protected static final short CS_END = 16;
    private ByteQueue applicationDataQueue = new ByteQueue();
    private ByteQueue alertQueue = new ByteQueue(2);
    private ByteQueue handshakeQueue = new ByteQueue();
    RecordStream recordStream;
    protected SecureRandom secureRandom;
    private TlsInputStream tlsInputStream = null;
    private TlsOutputStream tlsOutputStream = null;
    private volatile boolean closed = false;
    private volatile boolean failedWithError = false;
    private volatile boolean appDataReady = false;
    private volatile boolean splitApplicationDataRecords = true;
    private byte[] expected_verify_data = null;
    protected TlsSession tlsSession = null;
    protected SessionParameters sessionParameters = null;
    protected SecurityParameters securityParameters = null;
    protected Certificate peerCertificate = null;
    protected int[] offeredCipherSuites = null;
    protected short[] offeredCompressionMethods = null;
    protected Hashtable clientExtensions = null;
    protected Hashtable serverExtensions = null;
    protected short connection_state = 0;
    protected boolean resumedSession = false;
    protected boolean receivedChangeCipherSpec = false;
    protected boolean secure_renegotiation = false;
    protected boolean allowCertificateStatus = false;
    protected boolean expectSessionTicket = false;
    protected boolean blocking;
    protected ByteQueueInputStream inputBuffers;
    protected ByteQueueOutputStream outputBuffer;

    public TlsProtocol(InputStream input, OutputStream output, SecureRandom secureRandom) {
        this.blocking = true;
        this.recordStream = new RecordStream(this, input, output);
        this.secureRandom = secureRandom;
    }

    public TlsProtocol(SecureRandom secureRandom) {
        this.blocking = false;
        this.inputBuffers = new ByteQueueInputStream();
        this.outputBuffer = new ByteQueueOutputStream();
        this.recordStream = new RecordStream(this, this.inputBuffers, this.outputBuffer);
        this.secureRandom = secureRandom;
    }

    protected abstract TlsContext getContext();

    abstract AbstractTlsContext getContextAdmin();

    protected abstract TlsPeer getPeer();

    protected void handleChangeCipherSpecMessage() throws IOException {
    }

    protected abstract void handleHandshakeMessage(short var1, byte[] var2) throws IOException;

    protected void handleWarningMessage(short description) throws IOException {
    }

    protected void applyMaxFragmentLengthExtension() throws IOException {
        if (this.securityParameters.maxFragmentLength >= 0) {
            if (!MaxFragmentLength.isValid(this.securityParameters.maxFragmentLength)) {
                throw new TlsFatalAlert(80);
            }
            int plainTextLimit = 1 << 8 + this.securityParameters.maxFragmentLength;
            this.recordStream.setPlaintextLimit(plainTextLimit);
        }
    }

    protected void checkReceivedChangeCipherSpec(boolean expected) throws IOException {
        if (expected != this.receivedChangeCipherSpec) {
            throw new TlsFatalAlert(10);
        }
    }

    protected void cleanupHandshake() {
        if (this.expected_verify_data != null) {
            Arrays.fill(this.expected_verify_data, (byte)0);
            this.expected_verify_data = null;
        }
        this.securityParameters.clear();
        this.peerCertificate = null;
        this.offeredCipherSuites = null;
        this.offeredCompressionMethods = null;
        this.clientExtensions = null;
        this.serverExtensions = null;
        this.resumedSession = false;
        this.receivedChangeCipherSpec = false;
        this.secure_renegotiation = false;
        this.allowCertificateStatus = false;
        this.expectSessionTicket = false;
    }

    protected void blockForHandshake() throws IOException {
        if (this.blocking) {
            while (this.connection_state != 16) {
                if (this.closed) {
                    // empty if block
                }
                this.safeReadRecord();
            }
        }
    }

    protected void completeHandshake() throws IOException {
        try {
            this.recordStream.finaliseHandshake();
            boolean bl = this.splitApplicationDataRecords = !TlsUtils.isTLSv11(this.getContext());
            if (!this.appDataReady) {
                this.appDataReady = true;
                if (this.blocking) {
                    this.tlsInputStream = new TlsInputStream(this);
                    this.tlsOutputStream = new TlsOutputStream(this);
                }
            }
            if (this.tlsSession != null) {
                if (this.sessionParameters == null) {
                    this.sessionParameters = new SessionParameters.Builder().setCipherSuite(this.securityParameters.getCipherSuite()).setCompressionAlgorithm(this.securityParameters.getCompressionAlgorithm()).setMasterSecret(this.securityParameters.getMasterSecret()).setPeerCertificate(this.peerCertificate).setPSKIdentity(this.securityParameters.getPSKIdentity()).setSRPIdentity(this.securityParameters.getSRPIdentity()).setServerExtensions(this.serverExtensions).build();
                    this.tlsSession = new TlsSessionImpl(this.tlsSession.getSessionID(), this.sessionParameters);
                }
                this.getContextAdmin().setResumableSession(this.tlsSession);
            }
            this.getPeer().notifyHandshakeComplete();
        }
        finally {
            this.cleanupHandshake();
        }
    }

    protected void processRecord(short protocol, byte[] buf, int offset, int len) throws IOException {
        switch (protocol) {
            case 21: {
                this.alertQueue.addData(buf, offset, len);
                this.processAlert();
                break;
            }
            case 23: {
                if (!this.appDataReady) {
                    throw new TlsFatalAlert(10);
                }
                this.applicationDataQueue.addData(buf, offset, len);
                this.processApplicationData();
                break;
            }
            case 20: {
                this.processChangeCipherSpec(buf, offset, len);
                break;
            }
            case 22: {
                this.handshakeQueue.addData(buf, offset, len);
                this.processHandshake();
                break;
            }
            case 24: {
                if (this.appDataReady) break;
                throw new TlsFatalAlert(10);
            }
        }
    }

    private void processHandshake() throws IOException {
        boolean read;
        do {
            read = false;
            if (this.handshakeQueue.available() < 4) continue;
            byte[] beginning = new byte[4];
            this.handshakeQueue.read(beginning, 0, 4, 0);
            short type = TlsUtils.readUint8(beginning, 0);
            int len = TlsUtils.readUint24(beginning, 1);
            if (this.handshakeQueue.available() < len + 4) continue;
            byte[] buf = this.handshakeQueue.removeData(len, 4);
            this.checkReceivedChangeCipherSpec(this.connection_state == 16 || type == 20);
            switch (type) {
                case 0: {
                    break;
                }
                case 20: {
                    TlsContext ctx = this.getContext();
                    if (this.expected_verify_data == null && ctx.getSecurityParameters().getMasterSecret() != null) {
                        this.expected_verify_data = this.createVerifyData(!ctx.isServer());
                    }
                }
                default: {
                    this.recordStream.updateHandshakeData(beginning, 0, 4);
                    this.recordStream.updateHandshakeData(buf, 0, len);
                }
            }
            this.handleHandshakeMessage(type, buf);
            read = true;
        } while (read);
    }

    private void processApplicationData() {
    }

    private void processAlert() throws IOException {
        while (this.alertQueue.available() >= 2) {
            byte[] tmp = this.alertQueue.removeData(2, 0);
            short level = tmp[0];
            short description = tmp[1];
            this.getPeer().notifyAlertReceived(level, description);
            if (level == 2) {
                this.invalidateSession();
                this.failedWithError = true;
                this.closed = true;
                this.recordStream.safeClose();
                throw new IOException(TLS_ERROR_MESSAGE);
            }
            if (description == 0) {
                this.handleClose(false);
            }
            this.handleWarningMessage(description);
        }
    }

    private void processChangeCipherSpec(byte[] buf, int off, int len) throws IOException {
        for (int i = 0; i < len; ++i) {
            short message = TlsUtils.readUint8(buf, off + i);
            if (message != 1) {
                throw new TlsFatalAlert(50);
            }
            if (this.receivedChangeCipherSpec || this.alertQueue.available() > 0 || this.handshakeQueue.available() > 0) {
                throw new TlsFatalAlert(10);
            }
            this.recordStream.receivedReadCipherSpec();
            this.receivedChangeCipherSpec = true;
            this.handleChangeCipherSpecMessage();
        }
    }

    protected int applicationDataAvailable() {
        return this.applicationDataQueue.available();
    }

    protected int readApplicationData(byte[] buf, int offset, int len) throws IOException {
        if (len < 1) {
            return 0;
        }
        while (this.applicationDataQueue.available() == 0) {
            if (this.closed) {
                if (this.failedWithError) {
                    throw new IOException(TLS_ERROR_MESSAGE);
                }
                return -1;
            }
            this.safeReadRecord();
        }
        len = Math.min(len, this.applicationDataQueue.available());
        this.applicationDataQueue.removeData(buf, offset, len, 0);
        return len;
    }

    protected void safeReadRecord() throws IOException {
        try {
            if (!this.recordStream.readRecord()) {
                throw new EOFException();
            }
        }
        catch (TlsFatalAlert e) {
            if (!this.closed) {
                this.failWithError((short)2, e.getAlertDescription(), "Failed to read record", e);
            }
            throw e;
        }
        catch (IOException e) {
            if (!this.closed) {
                this.failWithError((short)2, (short)80, "Failed to read record", e);
            }
            throw e;
        }
        catch (RuntimeException e) {
            if (!this.closed) {
                this.failWithError((short)2, (short)80, "Failed to read record", e);
            }
            throw e;
        }
    }

    protected void safeWriteRecord(short type, byte[] buf, int offset, int len) throws IOException {
        try {
            this.recordStream.writeRecord(type, buf, offset, len);
        }
        catch (TlsFatalAlert e) {
            if (!this.closed) {
                this.failWithError((short)2, e.getAlertDescription(), "Failed to write record", e);
            }
            throw e;
        }
        catch (IOException e) {
            if (!this.closed) {
                this.failWithError((short)2, (short)80, "Failed to write record", e);
            }
            throw e;
        }
        catch (RuntimeException e) {
            if (!this.closed) {
                this.failWithError((short)2, (short)80, "Failed to write record", e);
            }
            throw e;
        }
    }

    protected void writeData(byte[] buf, int offset, int len) throws IOException {
        if (this.closed) {
            if (this.failedWithError) {
                throw new IOException(TLS_ERROR_MESSAGE);
            }
            throw new IOException("Sorry, connection has been closed, you cannot write more data");
        }
        while (len > 0) {
            if (this.splitApplicationDataRecords) {
                this.safeWriteRecord((short)23, buf, offset, 1);
                ++offset;
                --len;
            }
            if (len <= 0) continue;
            int toWrite = Math.min(len, this.recordStream.getPlaintextLimit());
            this.safeWriteRecord((short)23, buf, offset, toWrite);
            offset += toWrite;
            len -= toWrite;
        }
    }

    protected void writeHandshakeMessage(byte[] buf, int off, int len) throws IOException {
        while (len > 0) {
            int toWrite = Math.min(len, this.recordStream.getPlaintextLimit());
            this.safeWriteRecord((short)22, buf, off, toWrite);
            off += toWrite;
            len -= toWrite;
        }
    }

    public OutputStream getOutputStream() {
        if (!this.blocking) {
            throw new IllegalStateException("Cannot use OutputStream in non-blocking mode! Use offerOutput() instead.");
        }
        return this.tlsOutputStream;
    }

    public InputStream getInputStream() {
        if (!this.blocking) {
            throw new IllegalStateException("Cannot use InputStream in non-blocking mode! Use offerInput() instead.");
        }
        return this.tlsInputStream;
    }

    public void offerInput(byte[] input) throws IOException {
        if (this.blocking) {
            throw new IllegalStateException("Cannot use offerInput() in blocking mode! Use getInputStream() instead.");
        }
        if (this.closed) {
            throw new IOException("Connection is closed, cannot accept any more input");
        }
        this.inputBuffers.addBytes(input);
        while (this.inputBuffers.available() >= 5) {
            byte[] header = new byte[5];
            this.inputBuffers.peek(header);
            int totalLength = TlsUtils.readUint16(header, 3) + 5;
            if (this.inputBuffers.available() < totalLength) break;
            this.safeReadRecord();
        }
    }

    public int getAvailableInputBytes() {
        if (this.blocking) {
            throw new IllegalStateException("Cannot use getAvailableInputBytes() in blocking mode! Use getInputStream().available() instead.");
        }
        return this.applicationDataAvailable();
    }

    public int readInput(byte[] buffer, int offset, int length) {
        if (this.blocking) {
            throw new IllegalStateException("Cannot use readInput() in blocking mode! Use getInputStream() instead.");
        }
        try {
            return this.readApplicationData(buffer, offset, Math.min(length, this.applicationDataAvailable()));
        }
        catch (IOException e) {
            throw new RuntimeException(e.toString());
        }
    }

    public void offerOutput(byte[] buffer, int offset, int length) throws IOException {
        if (this.blocking) {
            throw new IllegalStateException("Cannot use offerOutput() in blocking mode! Use getOutputStream() instead.");
        }
        if (!this.appDataReady) {
            throw new IOException("Application data cannot be sent until the handshake is complete!");
        }
        this.writeData(buffer, offset, length);
    }

    public int getAvailableOutputBytes() {
        if (this.blocking) {
            throw new IllegalStateException("Cannot use getAvailableOutputBytes() in blocking mode! Use getOutputStream() instead.");
        }
        return this.outputBuffer.getBuffer().available();
    }

    public int readOutput(byte[] buffer, int offset, int length) {
        if (this.blocking) {
            throw new IllegalStateException("Cannot use readOutput() in blocking mode! Use getOutputStream() instead.");
        }
        int bytesToRead = Math.min(this.getAvailableOutputBytes(), length);
        this.outputBuffer.getBuffer().removeData(buffer, offset, bytesToRead, 0);
        return bytesToRead;
    }

    protected void failWithError(short alertLevel, short alertDescription, String message, Throwable cause) throws IOException {
        if (!this.closed) {
            this.closed = true;
            if (alertLevel == 2) {
                this.invalidateSession();
                this.failedWithError = true;
            }
            this.raiseAlert(alertLevel, alertDescription, message, cause);
            this.recordStream.safeClose();
            if (alertLevel != 2) {
                return;
            }
        }
        throw new IOException(TLS_ERROR_MESSAGE);
    }

    protected void invalidateSession() {
        if (this.sessionParameters != null) {
            this.sessionParameters.clear();
            this.sessionParameters = null;
        }
        if (this.tlsSession != null) {
            this.tlsSession.invalidate();
            this.tlsSession = null;
        }
    }

    protected void processFinishedMessage(ByteArrayInputStream buf) throws IOException {
        if (this.expected_verify_data == null) {
            throw new TlsFatalAlert(80);
        }
        byte[] verify_data = TlsUtils.readFully(this.expected_verify_data.length, (InputStream)buf);
        TlsProtocol.assertEmpty(buf);
        if (!Arrays.constantTimeAreEqual(this.expected_verify_data, verify_data)) {
            throw new TlsFatalAlert(51);
        }
    }

    protected void raiseAlert(short alertLevel, short alertDescription, String message, Throwable cause) throws IOException {
        this.getPeer().notifyAlertRaised(alertLevel, alertDescription, message, cause);
        byte[] error = new byte[]{(byte)alertLevel, (byte)alertDescription};
        this.safeWriteRecord((short)21, error, 0, 2);
    }

    protected void raiseWarning(short alertDescription, String message) throws IOException {
        this.raiseAlert((short)1, alertDescription, message, null);
    }

    protected void sendCertificateMessage(Certificate certificate) throws IOException {
        ProtocolVersion serverVersion;
        TlsContext context;
        if (certificate == null) {
            certificate = Certificate.EMPTY_CHAIN;
        }
        if (certificate.isEmpty() && !(context = this.getContext()).isServer() && (serverVersion = this.getContext().getServerVersion()).isSSL()) {
            String errorMessage = serverVersion.toString() + " client didn't provide credentials";
            this.raiseWarning((short)41, errorMessage);
            return;
        }
        HandshakeMessage message = new HandshakeMessage(11);
        certificate.encode(message);
        message.writeToRecordStream();
    }

    protected void sendChangeCipherSpecMessage() throws IOException {
        byte[] message = new byte[]{1};
        this.safeWriteRecord((short)20, message, 0, message.length);
        this.recordStream.sentWriteCipherSpec();
    }

    protected void sendFinishedMessage() throws IOException {
        byte[] verify_data = this.createVerifyData(this.getContext().isServer());
        HandshakeMessage message = new HandshakeMessage(20, verify_data.length);
        message.write(verify_data);
        message.writeToRecordStream();
    }

    protected void sendSupplementalDataMessage(Vector supplementalData) throws IOException {
        HandshakeMessage message = new HandshakeMessage(23);
        TlsProtocol.writeSupplementalData(message, supplementalData);
        message.writeToRecordStream();
    }

    protected byte[] createVerifyData(boolean isServer) {
        TlsContext context = this.getContext();
        String asciiLabel = isServer ? "server finished" : "client finished";
        byte[] sslSender = isServer ? TlsUtils.SSL_SERVER : TlsUtils.SSL_CLIENT;
        byte[] hash = TlsProtocol.getCurrentPRFHash(context, this.recordStream.getHandshakeHash(), sslSender);
        return TlsUtils.calculateVerifyData(context, asciiLabel, hash);
    }

    public void close() throws IOException {
        this.handleClose(true);
    }

    protected void handleClose(boolean user_canceled) throws IOException {
        if (!this.closed) {
            if (user_canceled && !this.appDataReady) {
                this.raiseWarning((short)90, "User canceled handshake");
            }
            this.failWithError((short)1, (short)0, "Connection closed", null);
        }
    }

    protected void flush() throws IOException {
        this.recordStream.flush();
    }

    public boolean isClosed() {
        return this.closed;
    }

    protected short processMaxFragmentLengthExtension(Hashtable clientExtensions, Hashtable serverExtensions, short alertDescription) throws IOException {
        short maxFragmentLength = TlsExtensionsUtils.getMaxFragmentLengthExtension(serverExtensions);
        if (maxFragmentLength >= 0 && (!MaxFragmentLength.isValid(maxFragmentLength) || !this.resumedSession && maxFragmentLength != TlsExtensionsUtils.getMaxFragmentLengthExtension(clientExtensions))) {
            throw new TlsFatalAlert(alertDescription);
        }
        return maxFragmentLength;
    }

    protected void refuseRenegotiation() throws IOException {
        if (TlsUtils.isSSL(this.getContext())) {
            throw new TlsFatalAlert(40);
        }
        this.raiseWarning((short)100, "Renegotiation not supported");
    }

    protected static void assertEmpty(ByteArrayInputStream buf) throws IOException {
        if (buf.available() > 0) {
            throw new TlsFatalAlert(50);
        }
    }

    protected static byte[] createRandomBlock(boolean useGMTUnixTime, RandomGenerator randomGenerator) {
        byte[] result = new byte[32];
        randomGenerator.nextBytes(result);
        if (useGMTUnixTime) {
            TlsUtils.writeGMTUnixTime(result, 0);
        }
        return result;
    }

    protected static byte[] createRenegotiationInfo(byte[] renegotiated_connection) throws IOException {
        return TlsUtils.encodeOpaque8(renegotiated_connection);
    }

    protected static void establishMasterSecret(TlsContext context, TlsKeyExchange keyExchange) throws IOException {
        byte[] pre_master_secret = keyExchange.generatePremasterSecret();
        try {
            context.getSecurityParameters().masterSecret = TlsUtils.calculateMasterSecret(context, pre_master_secret);
        }
        finally {
            if (pre_master_secret != null) {
                Arrays.fill(pre_master_secret, (byte)0);
            }
        }
    }

    protected static byte[] getCurrentPRFHash(TlsContext context, TlsHandshakeHash handshakeHash, byte[] sslSender) {
        Digest d = handshakeHash.forkPRFHash();
        if (sslSender != null && TlsUtils.isSSL(context)) {
            d.update(sslSender, 0, sslSender.length);
        }
        byte[] bs = new byte[d.getDigestSize()];
        d.doFinal(bs, 0);
        return bs;
    }

    protected static Hashtable readExtensions(ByteArrayInputStream input) throws IOException {
        if (input.available() < 1) {
            return null;
        }
        byte[] extBytes = TlsUtils.readOpaque16(input);
        TlsProtocol.assertEmpty(input);
        ByteArrayInputStream buf = new ByteArrayInputStream(extBytes);
        Hashtable<Integer, byte[]> extensions = new Hashtable<Integer, byte[]>();
        while (buf.available() > 0) {
            byte[] extension_data;
            Integer extension_type = Integers.valueOf(TlsUtils.readUint16(buf));
            if (null == extensions.put(extension_type, extension_data = TlsUtils.readOpaque16(buf))) continue;
            throw new TlsFatalAlert(47);
        }
        return extensions;
    }

    protected static Vector readSupplementalDataMessage(ByteArrayInputStream input) throws IOException {
        byte[] supp_data = TlsUtils.readOpaque24(input);
        TlsProtocol.assertEmpty(input);
        ByteArrayInputStream buf = new ByteArrayInputStream(supp_data);
        Vector<SupplementalDataEntry> supplementalData = new Vector<SupplementalDataEntry>();
        while (buf.available() > 0) {
            int supp_data_type = TlsUtils.readUint16(buf);
            byte[] data = TlsUtils.readOpaque16(buf);
            supplementalData.addElement(new SupplementalDataEntry(supp_data_type, data));
        }
        return supplementalData;
    }

    protected static void writeExtensions(OutputStream output, Hashtable extensions) throws IOException {
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        Enumeration keys = extensions.keys();
        while (keys.hasMoreElements()) {
            Integer key = (Integer)keys.nextElement();
            int extension_type = key;
            byte[] extension_data = (byte[])extensions.get(key);
            TlsUtils.checkUint16(extension_type);
            TlsUtils.writeUint16(extension_type, buf);
            TlsUtils.writeOpaque16(extension_data, buf);
        }
        byte[] extBytes = buf.toByteArray();
        TlsUtils.writeOpaque16(extBytes, output);
    }

    protected static void writeSupplementalData(OutputStream output, Vector supplementalData) throws IOException {
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        for (int i = 0; i < supplementalData.size(); ++i) {
            SupplementalDataEntry entry = (SupplementalDataEntry)supplementalData.elementAt(i);
            int supp_data_type = entry.getDataType();
            TlsUtils.checkUint16(supp_data_type);
            TlsUtils.writeUint16(supp_data_type, buf);
            TlsUtils.writeOpaque16(entry.getData(), buf);
        }
        byte[] supp_data = buf.toByteArray();
        TlsUtils.writeOpaque24(supp_data, output);
    }

    protected static int getPRFAlgorithm(TlsContext context, int ciphersuite) throws IOException {
        boolean isTLSv12 = TlsUtils.isTLSv12(context);
        switch (ciphersuite) {
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 156: 
            case 158: 
            case 160: 
            case 162: 
            case 164: 
            case 168: 
            case 170: 
            case 172: 
            case 186: 
            case 187: 
            case 188: 
            case 189: 
            case 190: 
            case 191: 
            case 192: 
            case 193: 
            case 194: 
            case 195: 
            case 196: 
            case 197: 
            case 49187: 
            case 49189: 
            case 49191: 
            case 49193: 
            case 49195: 
            case 49197: 
            case 49199: 
            case 49201: 
            case 49266: 
            case 49268: 
            case 49270: 
            case 49272: 
            case 49274: 
            case 49276: 
            case 49278: 
            case 49280: 
            case 49282: 
            case 49284: 
            case 49286: 
            case 49288: 
            case 49290: 
            case 49292: 
            case 49294: 
            case 49296: 
            case 49298: 
            case 49308: 
            case 49309: 
            case 49310: 
            case 49311: 
            case 49312: 
            case 49313: 
            case 49314: 
            case 49315: 
            case 49316: 
            case 49317: 
            case 49318: 
            case 49319: 
            case 49320: 
            case 49321: 
            case 49322: 
            case 49323: 
            case 49324: 
            case 49325: 
            case 49326: 
            case 49327: 
            case 52243: 
            case 52244: 
            case 52245: {
                if (isTLSv12) {
                    return 1;
                }
                throw new TlsFatalAlert(47);
            }
            case 157: 
            case 159: 
            case 161: 
            case 163: 
            case 165: 
            case 169: 
            case 171: 
            case 173: 
            case 49188: 
            case 49190: 
            case 49192: 
            case 49194: 
            case 49196: 
            case 49198: 
            case 49200: 
            case 49202: 
            case 49267: 
            case 49269: 
            case 49271: 
            case 49273: 
            case 49275: 
            case 49277: 
            case 49279: 
            case 49281: 
            case 49283: 
            case 49285: 
            case 49287: 
            case 49289: 
            case 49291: 
            case 49293: 
            case 49295: 
            case 49297: 
            case 49299: {
                if (isTLSv12) {
                    return 2;
                }
                throw new TlsFatalAlert(47);
            }
            case 175: 
            case 177: 
            case 179: 
            case 181: 
            case 183: 
            case 185: 
            case 49208: 
            case 49211: 
            case 49301: 
            case 49303: 
            case 49305: 
            case 49307: {
                if (isTLSv12) {
                    return 2;
                }
                return 0;
            }
        }
        if (isTLSv12) {
            return 1;
        }
        return 0;
    }

    class HandshakeMessage
    extends ByteArrayOutputStream {
        HandshakeMessage(short handshakeType) throws IOException {
            this(handshakeType, 60);
        }

        HandshakeMessage(short handshakeType, int length) throws IOException {
            super(length + 4);
            TlsUtils.writeUint8(handshakeType, (OutputStream)this);
            this.count += 3;
        }

        void writeToRecordStream() throws IOException {
            int length = this.count - 4;
            TlsUtils.checkUint24(length);
            TlsUtils.writeUint24(length, this.buf, 1);
            TlsProtocol.this.writeHandshakeMessage(this.buf, 0, this.count);
            this.buf = null;
        }
    }
}

