/*
 * Decompiled with CFR 0.152.
 */
package com.azure.identity;

import com.azure.identity.AadCredentialBuilderBase;
import com.azure.identity.DeviceCodeCredential;
import com.azure.identity.DeviceCodeInfo;
import com.azure.identity.implementation.AuthenticationRecord;
import java.util.function.Consumer;

public class DeviceCodeCredentialBuilder
extends AadCredentialBuilderBase<DeviceCodeCredentialBuilder> {
    private Consumer<DeviceCodeInfo> challengeConsumer = deviceCodeInfo -> System.out.println(deviceCodeInfo.getMessage());
    private boolean automaticAuthentication = true;

    public DeviceCodeCredentialBuilder challengeConsumer(Consumer<DeviceCodeInfo> challengeConsumer) {
        this.challengeConsumer = challengeConsumer;
        return this;
    }

    DeviceCodeCredentialBuilder allowUnencryptedCache() {
        this.identityClientOptions.setAllowUnencryptedCache(true);
        return this;
    }

    DeviceCodeCredentialBuilder enablePersistentCache() {
        this.identityClientOptions.enablePersistentCache();
        return this;
    }

    DeviceCodeCredentialBuilder authenticationRecord(AuthenticationRecord authenticationRecord) {
        this.identityClientOptions.setAuthenticationRecord(authenticationRecord);
        return this;
    }

    DeviceCodeCredentialBuilder disableAutomaticAuthentication() {
        this.automaticAuthentication = false;
        return this;
    }

    public DeviceCodeCredential build() {
        String clientId = this.clientId != null ? this.clientId : "04b07795-8ddb-461a-bbee-02f9e1bf7b46";
        return new DeviceCodeCredential(clientId, this.tenantId, this.challengeConsumer, this.automaticAuthentication, this.identityClientOptions);
    }
}

