import requests

def is_website_running(url):
    try:
        response = requests.get(url)
        return response.status_code == 200
    except requests.exceptions.RequestException as e:
        print(e)
        return False

# Example usage:
website_url = "https://chambal.parablu.com/paracloud/healthcheck/"
if is_website_running(website_url):
    print("Website is running.")
else:
    print("Website is not running.")
