from flask import Blueprint
from flask import render_template
from Opcenter import CloudName


main = Blueprint('main',__name__)


@main.route('/')
def home():
    return render_template('home/index.html')
    # return "Hello World"




@main.route('/deleteMachines')
def deleteMachines():
    machines = []  # Initialize an empty list to store machine details
    
    # Fetch machine details from your database or data source
    CloudDetails = CloudName.find()
    for machine in CloudDetails:
        machines.append({
            'name': machine['HostName'],
            'type': machine['CloudName']
            # Add more attributes as needed
        })
    
    # print(machines)
    return render_template('/dashboard/delete_machines.html', machines=machines)

    # return "Hello World"


@main.route('/deleteSelectedCloudNames', methods=['POST'])
def deleteSelectedCloudNames():
    cloudNames = request.json  # Get the selected cloud names from the request body

    # Perform the deletion of the selected cloud names from the database
    for cloudName in cloudNames:
        # Perform your deletion logic here
        print(f"Deleting {cloudName} from the database")

    return jsonify(message='Selected cloud names deleted successfully')

