/*
 * Decompiled with CFR 0.152.
 */
package com.parablu;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;

public class ReadFile {
    private static final int ENTRIES_PER_SHEET = 50;

    public static void main(String[] args) {
        if (args.length == 1) {
            String folderPath = args[0];
            Path folder = Paths.get(folderPath, new String[0]);
            if (Files.exists(folder, new LinkOption[0]) && Files.isDirectory(folder, new LinkOption[0])) {
                try {
                    Files.walkFileTree(folder, new FileVisitor(folder));
                }
                catch (IOException e) {
                    System.out.println("Finding problem going in this folder " + folderPath);
                    System.out.println(e.getMessage());
                }
            } else {
                System.out.println("This folder is not present");
            }
        } else {
            System.out.println("Please give proper folder path");
        }
    }

    private static String convertSize(long size) {
        String[] units = new String[]{"B", "KB", "MB", "GB"};
        int unitIndex = 0;
        double fileSize = size;
        while (fileSize >= 1024.0 && unitIndex < units.length - 1) {
            fileSize /= 1024.0;
            ++unitIndex;
        }
        return String.format("%.2f %s", fileSize, units[unitIndex]);
    }

    private static class FileVisitor
    extends SimpleFileVisitor<Path> {
        private final Path rootFolder;
        private int entryCount;

        public FileVisitor(Path rootFolder) {
            this.rootFolder = rootFolder;
            this.entryCount = 0;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            if (attrs.isRegularFile()) {
                File sysFile = file.toFile();
                String fileName = file.getFileName().toString();
                String filePath = file.getParent().toString();
                try {
                    String fileSize = ReadFile.convertSize(attrs.size());
                    System.out.println(sysFile.getAbsolutePath());
                    ++this.entryCount;
                    if (this.entryCount >= 50) {
                        this.entryCount = 0;
                    }
                }
                catch (Exception e) {
                    System.out.println("Error occurred while processing the file: " + fileName + " with the file path" + " " + filePath);
                    System.out.println(e.getMessage());
                }
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
            System.out.println("Failed to visit the file: " + file);
            System.out.println(exc.getMessage());
            return FileVisitResult.CONTINUE;
        }
    }
}

