/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.cms;

import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import org.bouncycastle.asn1.cms.SubjectKeyIdentifier;

public class RecipientIdentifier
implements DEREncodable {
    public DEREncodable id;

    public RecipientIdentifier(IssuerAndSerialNumber issuerAndSerialNumber) {
        this.setId(issuerAndSerialNumber);
    }

    public RecipientIdentifier(SubjectKeyIdentifier subjectKeyIdentifier) {
        this.setId(subjectKeyIdentifier);
    }

    public RecipientIdentifier(DEREncodable dEREncodable) {
        this.id = dEREncodable instanceof BERTaggedObject ? SubjectKeyIdentifier.getInstance(((BERTaggedObject)dEREncodable).getObject()) : IssuerAndSerialNumber.getInstance(dEREncodable);
    }

    public RecipientIdentifier(RecipientIdentifier recipientIdentifier) {
        this.id = recipientIdentifier.id;
    }

    public static RecipientIdentifier getInstance(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof RecipientIdentifier) {
            return (RecipientIdentifier)object;
        }
        if (object instanceof DEREncodable) {
            return new RecipientIdentifier((DEREncodable)object);
        }
        if (object instanceof BERTaggedObject) {
            return RecipientIdentifier.getInstance(((BERTaggedObject)object).getObject());
        }
        throw new IllegalArgumentException("Invalid RecipientIdentifier");
    }

    public static RecipientIdentifier newInstance(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof RecipientIdentifier) {
            return new RecipientIdentifier((RecipientIdentifier)object);
        }
        if (object instanceof DEREncodable) {
            return new RecipientIdentifier((DEREncodable)object);
        }
        if (object instanceof BERTaggedObject) {
            return RecipientIdentifier.getInstance(((BERTaggedObject)object).getObject());
        }
        throw new IllegalArgumentException("Invalid RecipientIdentifier");
    }

    public DEREncodable getId() {
        return this.id;
    }

    private void setId(IssuerAndSerialNumber issuerAndSerialNumber) {
        this.id = issuerAndSerialNumber;
    }

    private void setId(SubjectKeyIdentifier subjectKeyIdentifier) {
        this.id = subjectKeyIdentifier;
    }

    public DERObject getDERObject() {
        if (this.id instanceof IssuerAndSerialNumber) {
            return this.id.getDERObject();
        }
        return new BERTaggedObject(0, this.id.getDERObject());
    }
}

