from .Dependencies.Utilities.util import *
from .Dependencies.Filters.filters import *
from Opcenter import config

app = Flask(__name__)

bcrypt = Bcrypt(app)

app.config['SECRET_KEY'] = "IAMTHEDESTROYER"

@app.route("/")
def home():
    return redirect(url_for('authentication_blueprint.login'))


app.config['PERMANENT_SESSION_LIFETIME'] = timedelta(minutes=20)




# Define an error handler for 500 errors
@app.errorhandler(500)
def internal_server_error(e):
    tb = traceback.format_exc()
    print(f"Exception occurred:\n{tb}")
    print(e)
    # Redirect the user to the error page with a 500 status code
    return render_template('dashboard/errorpage.html', error_code=500), 500

# Define an error handler for 404 errors
@app.errorhandler(404)
def page_not_found(e):
    tb = traceback.format_exc()
    print(f"Exception occurred:\n{tb}")
    print(e)
    # Redirect the user to the error page with a 404 status code
    return render_template('dashboard/errorpage.html', error_code=404), 404

@app.errorhandler(Exception)
def handle_exception(e):
    # Render the error.html template with the error message
    tb = traceback.format_exc()
    print(f"Exception occurred:\n{tb}")
    print(e)
    print("This is the error printinf from line 77")
    return render_template('dashboard/errorpage.html', error_code=str(e)), 500

@app.errorhandler(UnboundLocalError)
def handle_unbound_local_error(e):
    tb = traceback.format_exc()
    print(f"Exception occurred:\n{tb}")
    print(e)
    return render_template('dashboard/errorpage.html', error_code='UnboundLocalError: ' + "Internal Issue"), 500

@app.errorhandler(FileNotFoundError)
def handle_file_not_found_error(e):
    tb = traceback.format_exc()
    print(f"Exception occurred:\n{tb}")
    print(e)
    # Render the error.html template with the error message
    return render_template('dashboard/errorpage.html', error_code="File Not Found"), 404
    

#Initializing Filters for Jinja
app.jinja_env.filters['merge_dicts'] = merge_dicts
app.jinja_env.filters['filesize_fmt1'] = filesize_fmt1
app.jinja_env.filters['filesize_fmt'] = filesize_fmt
app.jinja_env.filters['add_space'] = add_space
app.jinja_env.filters['format_date2'] = format_date2
app.jinja_env.filters['format_date'] = format_date
app.jinja_env.filters['lstrip_zero'] = lstrip_zero
app.jinja_env.filters['gb_to_tb'] = gb_to_tb
app.jinja_env.filters['kb_to_tb'] = kb_to_tb
app.jinja_env.filters['bytes_to_gb'] = bytes_to_gb
app.jinja_env.filters['add_comma'] = add_comma
app.jinja_env.filters['capitalize_first_letter'] = capitalize_first_letter


from .Apps.Authetication.routes import auth_blueprint
# from Opcenter.apps.main.routes import main
from .Apps.Dashboard.routes import admin
from .Apps.ApplicationView.routes import application
from .Apps.SystemView.routes import systemviewRoute
from .Apps.SystemView.modal import systemviewModal
from .Apps.Notes.routes import notes


app.register_blueprint(auth_blueprint)
app.register_blueprint(application)
app.register_blueprint(admin)
app.register_blueprint(systemviewRoute)
app.register_blueprint(systemviewModal)
app.register_blueprint(notes)