from ...Dependencies.Utilities.util import *

def kbToGb(value):
    kbValue = int(value)
    gb = kbValue / (1024 * 1024)
    return gb


def lstrip_zero(value):
    return str(value).lstrip('0')

def bytes_to_gb(bytes):
    totalMb = int(bytes)
    totalGb = totalMb/1024
    print("The total value of totalMB is")
    print(totalMb)
    if totalGb > 0:
        return str(round(totalGb,2)) + " GB"
    else:
        return bytes


def format_date(date_str):
    date_obj = datetime.strptime(date_str, '%Y/%m/%d %H:%M:%S')
    formatted_date = datetime.strftime(date_obj, '%d %b %Y %H:%M')
    return formatted_date

def add_space(value):
    digits = ''.join(filter(str.isdigit, value))
    letter = ''.join(filter(str.isalpha, value))
    return f"{digits} {letter}"

def filesize_fmt(value):
    size_in_bytes = float(value.split()[0])
    value = float(size_in_bytes)
    units = ['B', 'KB', 'MB', 'GB']
    for unit in units:
        if value < 1024.0:
            return f"{value:.2f} {unit}"
        value /= 1024.0
    return f"{value:.2f} {units[-1]}"


def filesize_fmt1(value):
    value = float(value)
    units = ['MB', 'GB']
    for unit in units:
        if value < 1024.0:
            return f"{value:.2f} {unit}"
        value /= 1024.0
    return f"{value:.2f} {units[-1]}"



def format_date2(date_str):
    date_str = date_str.replace('IST', '+0530')
    date_obj = datetime.strptime(date_str, '%a %b %d %H:%M:%S %z %Y')
    formatted_date2 = datetime.strftime(date_obj, '%b %d %Y %H:%M')
    return formatted_date2
 

def add_comma(value):
    if isinstance(value, int) and value >= 1000:
        value_str = str(value)
        return '{},{}'.format(value_str[:-3], value_str[-3:])
    return value


def gb_to_tb(value):
    if isinstance(value, str) and value.endswith(' GB'):
        gb_value = float(value[:-3])
        if gb_value > 1024:
            tb_value = gb_value / 1024
            return '{:.2f} TB'.format(tb_value)
    return value

def kb_to_tb(value):
    if isinstance(value, str):
        kb_value = float(value[:-3])
        if kb_value > 1024:
            mb_value = kb_value / 1024
            if mb_value > 1024:
                gb_value = mb_value / 1024
                if gb_value > 1024:
                    tb_value = gb_value / 1024
                    return '{:.2f} TB'.format(tb_value)
                else:
                    return '{:.2f} GB'.format(gb_value)
            else:
                return '{:.2f} MB'.format(mb_value)
    return value

def merge_dicts(d1, d2):
    """
    Merges two dictionaries.
    """
    return {**d1, **d2}


def capitalize_first_letter(value):
    if value:
        return value[0].upper() + value[1:]
    return ''
