from ...Dependencies.Utilities.util import *
from ...Dependencies.MongoConnection.mongoConnect import *

def convert_to_ist(timestamp_str):
    # Define the time zones
    ist_tz = pytz.timezone('Asia/Kolkata')  # Indian Standard Time

    # Parse the input timestamp string
    timestamp = parser.parse(timestamp_str)

    # Check if the time zone is IST
    if timestamp.tzinfo == ist_tz:
        return timestamp_str

    # Convert to IST
    timestamp = timestamp.replace(tzinfo=pytz.utc).astimezone(ist_tz)

    # Format the timestamp back to string
    ist_timestamp_str = timestamp.strftime("%a %b %d %H:%M:%S IST %Y")
    return ist_timestamp_str


def compareDateWithDays(dateA, dateB,time):
    date_format = "%b %d %Y %H:%M"
    dateAvalue = datetime.strptime(dateA, date_format)
    dateBvalue = datetime.strptime(dateB, date_format)
    difference = dateAvalue - dateBvalue
    if difference.days >= time:
        my_logger.info("I am in this line 2639")
        ColorValue = "red"         
    else:
        my_logger.info("I am in this line 2642")
        ColorValue = "darkgreen"    
    return ColorValue


def compareDate(date,duration):
    date = date.replace('IST', '+0530')
    date_obj = datetime.strptime(date, '%a %b %d %H:%M:%S %z %Y')
    formatted_date2 = datetime.strftime(date_obj, '%b %d %Y %H:%M')
    # last_update = datetime.strptime(date, "%a %b %d %H:%M:%S %Z %Y"
    my_logger.info("The value of the formated date")
    my_logger.info(formatted_date2)

    last_update = datetime.strptime(formatted_date2,"%b %d %Y %H:%M")

    current_date = datetime.now()

    difference = current_date - last_update
    if difference > timedelta(days=duration):
        my_logger.info("The time is older then the 3 days")
        return True
    else:
        my_logger.info("The time is not older then the 3 days")
        return False


def findSystemName(cloudName):
    my_logger.info("the value of the cloudname is : ")
    my_logger.info(cloudName)

    cloudTable = CloudName.find_one({'CloudName':cloudName})
    systemName = cloudTable.get("System Name")
    return systemName


def findHostNameWithSystem(clientName):
    CloudMainDetails = MongoCollectionInstance.getCloudMainDetailsByClientDocument(clientName)
    SystemName = CloudMainDetails.get("System Name")
    return SystemName


def convertToBytes(parabluSize):
    valueparabluSize = parabluSize[-1]
    parabluSize = float(parabluSize[:-1])
    value = []

    if(valueparabluSize == "T"):
        parabluSizeBytes = parabluSize * 1024 * 1024 *1024
        value.append(parabluSizeBytes)
        value.append(str(parabluSize)+"TB")

    elif(valueparabluSize == "G"):
        parabluSizeBytes = parabluSize * 1024 * 1024
        value.append(parabluSizeBytes)
        value.append(str(parabluSize)+"GB")

    elif(valueparabluSize == "M"):
        parabluSizeBytes = parabluSize * 1024
        value.append(parabluSizeBytes)
        value.append(str(parabluSize)+"MB")

    else:
        value.append(0)
        value.append("N/A")

    return value


def calculatePercentage(valueA,valueB):
    calculatedPercentage = (100 * valueA)/valueB
    return calculatedPercentage


def wireTigerConvert(value):
    wireTigerSize = value.split()
    wireTigerSizeinBytes = int(wireTigerSize[0])
    gb_value = "0 bytes"
    bytes_value = wireTigerSizeinBytes
    color_value =  wireTigerSizeinBytes /(1024 * 1024 * 1024)
    if bytes_value < 1024:
        gb_value = str(bytes_value) +" bytes"
        
    elif bytes_value < 1024 * 1024:
        gb_value = f"{bytes_value / 1024:.2f} KB"
        
    elif bytes_value < 1024 * 1024 * 1024:
        gb_value = f"{bytes_value / (1024 * 1024):.2f} MB"
    else:
        gb_value = f"{bytes_value / (1024 * 1024 * 1024):.2f} GB"

    return gb_value
    

def wireTigerConvertColorStatus(value):
    status = "red"
    wireTigerSize = value.split()
    wireTigerSizeinBytes = int(wireTigerSize[0])
    gb_value = "0 bytes"
    bytes_value = wireTigerSizeinBytes
    color_value =  wireTigerSizeinBytes /(1024 * 1024 * 1024)
    if bytes_value < 1024:
        gb_value = str(bytes_value) +" bytes"
        
    elif bytes_value < 1024 * 1024:
        gb_value = f"{bytes_value / 1024:.2f} KB"
        
    elif bytes_value < 1024 * 1024 * 1024:
        gb_value = f"{bytes_value / (1024 * 1024):.2f} MB"
    else:
        gb_value = f"{bytes_value / (1024 * 1024 * 1024):.2f} GB"
    print("color value ====================================================")
    print(color_value)
    if color_value > 20:
        status = "red"
    else:
        status = "green"

    return status


def convert_to_bytes(size):
    if size[-1].upper() == 'G':
        bytes_value = int(float(size[:-1])) * 1024**3
    elif size[-1].upper() == 'M':
        bytes_value = int(float(size[:-1])) * 1024**2
    elif size[-1].upper() == 'K':
        bytes_value = int(float(size[:-1])) * 1024
    else:
        bytes_value = int(size)
    return bytes_value


def convert_to_bytes2(size):
    size_parts = size.split()
    value = float(size_parts[0])
    unit = size_parts[1]

    # Define the conversion factors
    unit_conversion = {
        'B': 1,
        'KB': 1024,
        'MB': 1024**2,
        'GB': 1024**3,
        'TB': 1024**4,
        'K': 1024,
        'G': 1024**3,
        'M': 1024**2
    }

    # Convert the value to bytes
    bytes_value = value * unit_conversion[unit]

    return bytes_value