import requests

def is_website_running(url):
    try:
        response = requests.get(url)
        return response.status_code == 200
    except requests.exceptions.RequestException as e:
        print(e)
        return False

# Example usage:
website_url = "https://chambal.parablu.com/paracloud/healthcheck/"
if is_website_running(website_url):
    print("Website is running.")
else:
    print("Website is not running.")



def is_site_up(host):
    try:
        response_time = ping3.ping(host, timeout=2)  # Set the timeout value in seconds
        if response_time is not None:
            print(f"Site is UP! Response Time: {response_time} ms")
        else:
            print("Site is DOWN.")
    except ping3.exceptions.PingError:
        print("Site is DOWN.")
