/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.email.system.security.cryptography;

import com.aspose.email.internal.b.zaf;
import com.aspose.email.internal.b.zar;
import com.aspose.email.internal.b.zr;
import com.aspose.email.internal.m.zb;
import com.aspose.email.internal.u.zi;
import com.aspose.email.internal.v.zf;
import com.aspose.email.internal.v.zg;
import com.aspose.email.internal.v.zh;
import com.aspose.email.internal.v.zu;
import com.aspose.email.internal.v.zv;
import com.aspose.email.system.DateTime;
import com.aspose.email.system.collections.IEnumerator;
import com.aspose.email.system.exceptions.ArgumentException;
import com.aspose.email.system.exceptions.ArgumentNullException;
import com.aspose.email.system.exceptions.ArgumentOutOfRangeException;
import com.aspose.email.system.exceptions.CryptographicException;
import com.aspose.email.system.exceptions.CryptographicUnexpectedOperationException;
import com.aspose.email.system.security.cryptography.X509Certificate2;

public class X509Certificate2Collection
extends zh {
    static String[] a = new String[]{zr.a()};

    public X509Certificate2Collection() {
    }

    public X509Certificate2Collection(X509Certificate2Collection certificates) {
        this.addRange(certificates);
    }

    public X509Certificate2Collection(X509Certificate2 certificate) {
        this.add(certificate);
    }

    public X509Certificate2Collection(X509Certificate2[] certificates) {
        this.addRange(certificates);
    }

    @Override
    public X509Certificate2 get_Item(int index) {
        if (index < 0) {
            throw new ArgumentOutOfRangeException("negative index");
        }
        if (index >= this.getInnerList().size()) {
            throw new ArgumentOutOfRangeException("index >= Count");
        }
        return (X509Certificate2)this.getInnerList().get_Item(index);
    }

    public void set_Item(int index, X509Certificate2 value) {
        this.getInnerList().set_Item(index, value);
    }

    public int add(X509Certificate2 certificate) {
        if (certificate == null) {
            throw new ArgumentNullException("certificate");
        }
        return this.getInnerList().addItem(certificate);
    }

    public void addRange(X509Certificate2[] certificates) {
        if (certificates == null) {
            throw new ArgumentNullException("certificates");
        }
        for (int i = 0; i < certificates.length; ++i) {
            this.getInnerList().addItem(certificates[i]);
        }
    }

    public void addRange(X509Certificate2Collection certificates) {
        if (certificates == null) {
            throw new ArgumentNullException("certificates");
        }
        this.getInnerList().addRange(certificates);
    }

    public boolean contains(X509Certificate2 certificate) {
        if (certificate == null) {
            throw new ArgumentNullException("certificate");
        }
        for (X509Certificate2 x509Certificate2 : this.getInnerList()) {
            if (!x509Certificate2.equals(certificate)) continue;
            return true;
        }
        return false;
    }

    public byte[] export(int contentType) {
        return this.export(contentType, null);
    }

    public byte[] export(int contentType, String password) {
        switch (contentType) {
            case 1: 
            case 2: 
            case 3: {
                if (this.size() <= 0) break;
                return this.get_Item(this.size() - 1).export(contentType, password);
            }
            case 5: {
                break;
            }
            case 4: {
                break;
            }
            default: {
                String string = zar.a("Cannot export certificate(s) to the '{0}' format", new Object[]{com.aspose.email.internal.hg.zb.a(contentType)});
                throw new CryptographicException(string);
            }
        }
        return null;
    }

    public X509Certificate2Collection find(int findType, Object findValue, boolean validOnly) {
        if (findValue == null) {
            throw new ArgumentNullException("findValue");
        }
        String string = zar.a;
        String string2 = zar.a;
        int n = 0;
        DateTime dateTime = DateTime.MinValue.Clone();
        switch (findType) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 14: {
                try {
                    string = (String)findValue;
                    break;
                }
                catch (RuntimeException runtimeException) {
                    String string3 = zar.a("Invalid find value type '{0}', expected '{1}'.", zaf.a(findValue), "string");
                    throw new CryptographicException(string3, runtimeException);
                }
            }
            case 10: 
            case 11: 
            case 12: {
                try {
                    string2 = (String)findValue;
                }
                catch (RuntimeException runtimeException) {
                    String string4 = zar.a("Invalid find value type '{0}', expected '{1}'.", zaf.a(findValue), "X509KeyUsageFlags");
                    throw new CryptographicException(string4, runtimeException);
                }
                try {
                    zi.c(string2);
                    break;
                }
                catch (CryptographicUnexpectedOperationException cryptographicUnexpectedOperationException) {
                    String string5 = zar.a("Invalid OID value '{0}'.", new Object[]{string2});
                    throw new ArgumentException("findValue", string5);
                }
            }
            case 13: {
                try {
                    n = (Integer)findValue;
                    break;
                }
                catch (RuntimeException runtimeException) {
                    String string6 = zar.a("Invalid find value type '{0}', expected '{1}'.", zaf.a(findValue), "X509KeyUsageFlags");
                    throw new CryptographicException(string6, runtimeException);
                }
            }
            case 6: 
            case 7: 
            case 8: {
                try {
                    com.aspose.email.internal.hg.zb.d(findValue, DateTime.class).CloneTo(dateTime);
                    break;
                }
                catch (RuntimeException runtimeException) {
                    String string7 = zar.a("Invalid find value type '{0}', expected '{1}'.", zaf.a(findValue), "X509DateTime");
                    throw new CryptographicException(string7, runtimeException);
                }
            }
            default: {
                String string8 = zar.a("Invalid find type '{0}'.", new Object[]{com.aspose.email.internal.hg.zb.a(findType)});
                throw new CryptographicException(string8);
            }
        }
        zb zb2 = zb.c();
        X509Certificate2Collection x509Certificate2Collection = new X509Certificate2Collection();
        for (X509Certificate2 x509Certificate2 : this.getInnerList()) {
            boolean bl = false;
            block12 : switch (findType) {
                case 0: {
                    bl = zar.c(string, x509Certificate2.getThumbprint(), true, zb2) == 0 || zar.c(string, x509Certificate2.getCertHashString(), true, zb2) == 0;
                    break;
                }
                case 1: {
                    String[] stringArray;
                    for (String string9 : stringArray = zar.a(x509Certificate2.getSubjectName().a(true), a, 1)) {
                        int n2 = zar.d(string9, '=');
                        boolean bl2 = bl = zar.a(string9, string, n2, (short)3) >= 0;
                        if (bl) break block12;
                    }
                    break;
                }
                case 2: {
                    bl = zar.c(string, x509Certificate2.getSubject(), true, zb2) == 0;
                    break;
                }
                case 3: {
                    String[] stringArray = x509Certificate2.getNameInfo(0, true);
                    bl = zar.g((String)stringArray, string, (short)3) >= 0;
                    break;
                }
                case 4: {
                    bl = zar.c(string, x509Certificate2.getIssuer(), true, zb2) == 0;
                    break;
                }
                case 5: {
                    bl = zar.c(string, x509Certificate2.get_SerialNumber(), true, zb2) == 0;
                    break;
                }
                case 9: {
                    break;
                }
                case 14: {
                    zv zv2 = (zv)((Object)com.aspose.email.internal.hg.zb.a(x509Certificate2.getExtensions().a("2.5.29.14"), zv.class));
                    if (zv2 == null) break;
                    bl = zar.c(string, zv2.c(), true, zb2) == 0;
                    break;
                }
                case 10: {
                    bl = x509Certificate2.getExtensions().size() == 0;
                    break;
                }
                case 11: {
                    break;
                }
                case 12: {
                    bl = x509Certificate2.getExtensions().a(string2) != null;
                    break;
                }
                case 13: {
                    zu zu2 = (zu)((Object)com.aspose.email.internal.hg.zb.a(x509Certificate2.getExtensions().a("2.5.29.15"), zu.class));
                    if (zu2 == null) {
                        bl = true;
                        break;
                    }
                    bl = (zu2.c() & n) == n;
                    break;
                }
                case 6: {
                    bl = DateTime.op_GreaterThanOrEqual(dateTime, x509Certificate2.getNotBefore()) && DateTime.op_LessThanOrEqual(dateTime, x509Certificate2.getNotAfter());
                    break;
                }
                case 7: {
                    bl = DateTime.op_LessThan(dateTime, x509Certificate2.getNotBefore());
                    break;
                }
                case 8: {
                    bl = DateTime.op_GreaterThan(dateTime, x509Certificate2.getNotAfter());
                }
            }
            if (!bl) continue;
            if (validOnly) {
                try {
                    if (!x509Certificate2.verify()) continue;
                    x509Certificate2Collection.add(x509Certificate2);
                }
                catch (RuntimeException runtimeException) {}
                continue;
            }
            x509Certificate2Collection.add(x509Certificate2);
        }
        return x509Certificate2Collection;
    }

    @Override
    public IEnumerator iterator() {
        return new zg(this);
    }

    public void import_(byte[] rawData) {
        X509Certificate2 x509Certificate2 = new X509Certificate2();
        x509Certificate2.import_(rawData);
        this.add(x509Certificate2);
    }

    public void import_(byte[] rawData, String password, int keyStorageFlags) {
        X509Certificate2 x509Certificate2 = new X509Certificate2();
        x509Certificate2.import_(rawData, password, keyStorageFlags);
        this.add(x509Certificate2);
    }

    public void import_(String fileName) {
        X509Certificate2 x509Certificate2 = new X509Certificate2();
        x509Certificate2.import_(fileName);
        this.add(x509Certificate2);
    }

    public void import_(String fileName, String password, int keyStorageFlags) {
        X509Certificate2 x509Certificate2 = new X509Certificate2();
        x509Certificate2.import_(fileName, password, keyStorageFlags);
        this.add(x509Certificate2);
    }

    public void insert(int index, X509Certificate2 certificate) {
        if (certificate == null) {
            throw new ArgumentNullException("certificate");
        }
        if (index < 0) {
            throw new ArgumentOutOfRangeException("negative index");
        }
        if (index >= this.getInnerList().size()) {
            throw new ArgumentOutOfRangeException("index >= Count");
        }
        this.getInnerList().insertItem(index, certificate);
    }

    public void remove(X509Certificate2 certificate) {
        if (certificate == null) {
            throw new ArgumentNullException("certificate");
        }
        for (int i = 0; i < this.getInnerList().size(); ++i) {
            zf zf2 = (zf)this.getInnerList().get_Item(i);
            if (!zf2.equals(certificate)) continue;
            this.getInnerList().removeAt(i);
            return;
        }
    }

    public void removeRange(X509Certificate2[] certificates) {
        if (certificates == null) {
            throw new ArgumentNullException("certificate");
        }
        for (X509Certificate2 x509Certificate2 : certificates) {
            this.remove(x509Certificate2);
        }
    }

    public void removeRange(X509Certificate2Collection certificates) {
        if (certificates == null) {
            throw new ArgumentNullException("certificate");
        }
        for (X509Certificate2 x509Certificate2 : certificates) {
            this.remove(x509Certificate2);
        }
    }
}

