/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.email.system;

import com.aspose.email.internal.b.zaa;
import com.aspose.email.internal.b.zf;
import com.aspose.email.internal.b.zq;
import com.aspose.email.internal.b.zz;
import com.aspose.email.internal.y.zt;
import com.aspose.email.system.Struct;
import com.aspose.email.system.exceptions.ArgumentException;
import com.aspose.email.system.exceptions.ArgumentNullException;
import com.aspose.email.system.exceptions.ArgumentOutOfRangeException;
import com.aspose.email.system.exceptions.FormatException;
import com.aspose.email.system.exceptions.OverflowException;
import java.math.BigDecimal;
import java.math.BigInteger;

public class TimeSpan
extends Struct<TimeSpan>
implements Comparable<TimeSpan> {
    public static TimeSpan MaxValue = new TimeSpan(Long.MAX_VALUE);
    public static TimeSpan MinValue = new TimeSpan(Long.MIN_VALUE);
    public static TimeSpan Zero = new TimeSpan(0L);
    public static final long TicksPerDay = 864000000000L;
    public static final long TicksPerHour = 36000000000L;
    public static final long TicksPerMillisecond = 10000L;
    public static final long TicksPerMinute = 600000000L;
    public static final long TicksPerSecond = 10000000L;
    private long a;

    public TimeSpan() {
    }

    public TimeSpan(long ticks) {
        this.a = ticks;
    }

    public TimeSpan(int hours, int minutes, int seconds) {
        long[] lArray = new long[]{this.a};
        TimeSpan.a(0, hours, minutes, seconds, 0, true, lArray);
        this.a = lArray[0];
    }

    public TimeSpan(int days, int hours, int minutes, int seconds) {
        long[] lArray = new long[]{this.a};
        TimeSpan.a(days, hours, minutes, seconds, 0, true, lArray);
        this.a = lArray[0];
    }

    public TimeSpan(int days, int hours, int minutes, int seconds, int milliseconds) {
        long[] lArray = new long[]{this.a};
        TimeSpan.a(days, hours, minutes, seconds, milliseconds, true, lArray);
        this.a = lArray[0];
    }

    static boolean a(int n, int n2, int n3, int n4, int n5, boolean bl, long[] lArray) {
        int n6 = n2 * 3600;
        int n7 = n3 * 60;
        long l = (long)(n6 + n7 + n4) * 1000L + (long)n5;
        l *= 10000L;
        lArray[0] = 0L;
        boolean bl2 = false;
        if (n > 0) {
            long l2;
            long l3 = 864000000000L * (long)n;
            bl2 = l < 0L ? (l2 = l) > (l += l3) : (l += l3) < 0L;
        } else if (n < 0) {
            long l4 = 864000000000L * (long)n;
            if (l <= 0L) {
                bl2 = (l += l4) > 0L;
            } else {
                long l5;
                boolean bl3 = bl2 = (l += l4) > (l5 = l);
            }
        }
        if (bl2) {
            if (bl) {
                throw new ArgumentOutOfRangeException("The timespan is too big or too small.");
            }
            return false;
        }
        lArray[0] = l;
        return true;
    }

    public int getDays() {
        return (int)(this.a / 864000000000L);
    }

    public int getHours() {
        return (int)(this.a % 864000000000L / 36000000000L);
    }

    public int getMilliseconds() {
        return (int)(this.a % 10000000L / 10000L);
    }

    public int getMinutes() {
        return (int)(this.a % 36000000000L / 600000000L);
    }

    public int getSeconds() {
        return (int)(this.a % 600000000L / 10000000L);
    }

    public long getTicks() {
        return this.a;
    }

    public double getTotalDays() {
        return (double)this.a / 8.64E11;
    }

    public double getTotalHours() {
        return (double)this.a / 3.6E10;
    }

    public double getTotalMilliseconds() {
        return (double)this.a / 10000.0;
    }

    public double getTotalMinutes() {
        return (double)this.a / 6.0E8;
    }

    public double getTotalSeconds() {
        return (double)this.a / 1.0E7;
    }

    public TimeSpan add(TimeSpan ts) {
        BigInteger bigInteger = BigInteger.valueOf(ts.getTicks());
        if ((bigInteger = bigInteger.add(BigInteger.valueOf(this.a))).compareTo(BigInteger.valueOf(Long.MAX_VALUE)) > 0) {
            throw new OverflowException("Resulting timespan is too big.");
        }
        return new TimeSpan(bigInteger.longValue());
    }

    public static int compare(TimeSpan t1, TimeSpan t2) {
        if (t1.a < t2.a) {
            return -1;
        }
        if (t1.a > t2.a) {
            return 1;
        }
        return 0;
    }

    @Override
    public int compareTo(TimeSpan value) {
        if (value == null) {
            return 1;
        }
        return TimeSpan.compare(this.Clone(), value.Clone());
    }

    public boolean equals(TimeSpan obj) {
        if (obj == null) {
            return false;
        }
        return obj.a == this.a;
    }

    public TimeSpan duration() {
        BigInteger bigInteger = BigInteger.valueOf(this.a);
        if ((bigInteger = bigInteger.abs()).compareTo(BigInteger.valueOf(Long.MAX_VALUE)) > 0 || bigInteger.compareTo(BigInteger.valueOf(Long.MIN_VALUE)) < 0) {
            throw new OverflowException("This TimeSpan value is MinValue so you cannot get the duration.");
        }
        return new TimeSpan(bigInteger.longValue());
    }

    public boolean equals(Object value) {
        if (!(value instanceof TimeSpan)) {
            return false;
        }
        return this.a == ((TimeSpan)value).a;
    }

    public static boolean equals(TimeSpan t1, TimeSpan t2) {
        return t1.a == t2.a;
    }

    public static TimeSpan fromDays(double value) {
        return TimeSpan.a(value, 864000000000L);
    }

    public static TimeSpan fromHours(double value) {
        return TimeSpan.a(value, 36000000000L);
    }

    public static TimeSpan fromMinutes(double value) {
        return TimeSpan.a(value, 600000000L);
    }

    public static TimeSpan fromSeconds(double value) {
        return TimeSpan.a(value, 10000000L);
    }

    public static TimeSpan fromMilliseconds(double value) {
        return TimeSpan.a(value, 10000L);
    }

    private static TimeSpan a(double d, long l) {
        if (zq.b(d)) {
            throw new ArgumentException("Value cannot be NaN.", "value");
        }
        if (zq.c(d) || zq.d(d) || d < (double)MinValue.getTicks() || d > (double)MaxValue.getTicks()) {
            throw new OverflowException("Outside range [MinValue,MaxValue]");
        }
        BigDecimal bigDecimal = BigDecimal.valueOf(d *= (double)(l / 10000L)).setScale(0, 4);
        if ((bigDecimal = bigDecimal.multiply(BigDecimal.valueOf(10000L))).compareTo(BigDecimal.valueOf(Long.MAX_VALUE)) > 0 || bigDecimal.compareTo(BigDecimal.valueOf(Long.MIN_VALUE)) < 0) {
            throw new OverflowException("Resulting timespan is too big.");
        }
        return new TimeSpan(bigDecimal.longValue());
    }

    public static TimeSpan fromTicks(long value) {
        return new TimeSpan(value);
    }

    public int hashCode() {
        return zaa.a(this.a);
    }

    public TimeSpan negate() {
        if (this.a == TimeSpan.MinValue.a) {
            throw new OverflowException("This TimeSpan value is MinValue and cannot be negated.");
        }
        return new TimeSpan(-this.a);
    }

    public static TimeSpan parse(String s) {
        if (s == null) {
            throw new ArgumentNullException("s");
        }
        TimeSpan timeSpan = new TimeSpan();
        za za2 = new za(s);
        TimeSpan[] timeSpanArray = new TimeSpan[]{timeSpan};
        za2.a(false, timeSpanArray);
        timeSpanArray[0].CloneTo(timeSpan);
        return timeSpan;
    }

    public static boolean tryParse(String s, TimeSpan[] result) {
        if (s == null) {
            Zero.CloneTo(result[0]);
            return false;
        }
        za za2 = new za(s);
        return za2.a(true, result);
    }

    public TimeSpan subtract(TimeSpan ts) {
        BigInteger bigInteger = BigInteger.valueOf(this.a);
        if ((bigInteger = bigInteger.subtract(BigInteger.valueOf(ts.getTicks()))).compareTo(BigInteger.valueOf(Long.MIN_VALUE)) < 0) {
            throw new OverflowException("Resulting timespan is too big.");
        }
        return new TimeSpan(bigInteger.longValue());
    }

    public String toString() {
        zt zt2 = new zt(14);
        if (this.a < 0L) {
            zt2.a('-');
        }
        if (this.getDays() != 0) {
            zt2.c(Math.abs(this.getDays()));
            zt2.a('.');
        }
        zt2.a(zz.a(Math.abs(this.getHours()), "D2"));
        zt2.a(':');
        zt2.a(zz.a(Math.abs(this.getMinutes()), "D2"));
        zt2.a(':');
        zt2.a(zz.a(Math.abs(this.getSeconds()), "D2"));
        int n = (int)Math.abs(this.a % 10000000L);
        if (n != 0) {
            zt2.a('.');
            zt2.a(zz.a(n, "D7"));
        }
        return zt2.toString();
    }

    public static TimeSpan op_Addition(TimeSpan t1, TimeSpan t2) {
        if (t1 == null || t2 == null) {
            return null;
        }
        return t1.add(t2.Clone());
    }

    public static boolean op_Equality(TimeSpan t1, TimeSpan t2) {
        return t1.a == t2.a;
    }

    public static boolean op_GreaterThan(TimeSpan t1, TimeSpan t2) {
        if (t1 == null || t2 == null) {
            return false;
        }
        return t1.a > t2.a;
    }

    public static boolean op_GreaterThanOrEqual(TimeSpan t1, TimeSpan t2) {
        if (t1 == null || t2 == null) {
            return false;
        }
        return t1.a >= t2.a;
    }

    public static boolean op_Inequality(TimeSpan t1, TimeSpan t2) {
        return t1.a != t2.a;
    }

    public static boolean op_LessThan(TimeSpan t1, TimeSpan t2) {
        if (t1 == null || t2 == null) {
            return false;
        }
        return t1.a < t2.a;
    }

    public static boolean op_LessThanOrEqual(TimeSpan t1, TimeSpan t2) {
        if (t1 == null || t2 == null) {
            return false;
        }
        return t1.a <= t2.a;
    }

    public static TimeSpan op_Subtraction(TimeSpan t1, TimeSpan t2) {
        if (t1 == null || t2 == null) {
            return null;
        }
        return t1.subtract(t2.Clone());
    }

    public static TimeSpan op_UnaryNegation(TimeSpan t) {
        return t.negate();
    }

    public static TimeSpan op_UnaryPlus(TimeSpan t) {
        return t;
    }

    @Override
    public void CloneTo(TimeSpan that) {
        that.a = this.a;
    }

    @Override
    public TimeSpan Clone() {
        TimeSpan timeSpan = new TimeSpan();
        this.CloneTo(timeSpan);
        return timeSpan;
    }

    public Object clone() {
        return this.Clone();
    }

    public static TimeSpan fromJava(long ticks) {
        return new TimeSpan(ticks);
    }

    public static long toJava(TimeSpan timeSpan) {
        if (timeSpan == null) {
            return 0L;
        }
        return timeSpan.a;
    }

    public static double toMilliseconds(TimeSpan timeSpan) {
        if (timeSpan == null) {
            return 0.0;
        }
        return timeSpan.getTotalMilliseconds();
    }

    private static class za {
        private String a;
        private int b = 0;
        private int c;
        private int d;

        public za(String string) {
            this.a = string;
            this.c = this.a.length();
        }

        public boolean a() {
            return this.b >= this.c;
        }

        private void b() {
            while (!this.a() && zf.c(this.a, this.b)) {
                ++this.b;
            }
        }

        private boolean c() {
            boolean bl = false;
            if (!this.a() && this.a.charAt(this.b) == '-') {
                bl = true;
                ++this.b;
            }
            return bl;
        }

        private int a(boolean bl) {
            if (bl && this.a()) {
                return 0;
            }
            long l = 0L;
            int n = 0;
            while (!this.a() && zf.b(this.a, this.b)) {
                if ((l = l * 10L + (long)this.a.charAt(this.b) - 48L) > Integer.MAX_VALUE) {
                    this.a(2);
                    break;
                }
                ++this.b;
                ++n;
            }
            if (!bl && n == 0) {
                this.a(1);
            }
            return (int)l;
        }

        private boolean d() {
            if (this.a()) {
                return false;
            }
            if (this.a.charAt(this.b) == '.') {
                ++this.b;
                return true;
            }
            return false;
        }

        private void b(boolean bl) {
            if (!this.a()) {
                if (this.a.charAt(this.b) == ':') {
                    ++this.b;
                } else if (!bl) {
                    this.a(1);
                }
            }
        }

        private long e() {
            long l = 0L;
            boolean bl = false;
            for (long i = 1000000L; i > 0L && !this.a() && zf.b(this.a, this.b); i /= 10L) {
                l += (long)(this.a.charAt(this.b) - 48) * i;
                ++this.b;
                bl = true;
            }
            if (!bl) {
                this.a(1);
            }
            return l;
        }

        private void a(int n) {
            if (this.d != 0) {
                return;
            }
            this.d = n;
        }

        private boolean a(int n, int n2, int n3, boolean bl) {
            if (this.d == 2 || n > 23 || n2 > 59 || n3 > 59) {
                if (bl) {
                    return false;
                }
                throw new OverflowException("Invalid time data.");
            }
            if (this.d == 1) {
                if (bl) {
                    return false;
                }
                throw new FormatException("Invalid format for TimeSpan.Parse.");
            }
            return true;
        }

        public boolean a(boolean bl, TimeSpan[] timeSpanArray) {
            int n = 0;
            Zero.CloneTo(timeSpanArray[0]);
            this.b();
            boolean bl2 = this.c();
            int n2 = this.a(false);
            if (this.d()) {
                n = this.a(true);
            } else if (!this.a()) {
                n = n2;
                n2 = 0;
            }
            this.b(false);
            int n3 = this.b;
            int n4 = this.a(true);
            int n5 = 0;
            if (n3 < this.b) {
                this.b(true);
                n5 = this.a(true);
            }
            long l = this.d() ? this.e() : 0L;
            this.b();
            if (!this.a()) {
                this.a(1);
            }
            if (!this.a(n, n4, n5, bl)) {
                return false;
            }
            long l2 = 0L;
            long[] lArray = new long[]{l2};
            boolean bl3 = !TimeSpan.a(n2, n, n4, n5, 0, false, lArray);
            l2 = lArray[0];
            if (bl3) {
                return false;
            }
            BigInteger bigInteger = BigInteger.valueOf(l);
            BigInteger bigInteger2 = BigInteger.valueOf(l2);
            bigInteger2 = bl2 ? bigInteger2.negate().subtract(bigInteger) : bigInteger2.add(bigInteger);
            if (bigInteger2.compareTo(BigInteger.valueOf(Long.MAX_VALUE)) > 0 || bigInteger2.compareTo(BigInteger.valueOf(Long.MIN_VALUE)) < 0) {
                if (bl) {
                    return false;
                }
                throw new OverflowException();
            }
            l2 = bigInteger2.longValue();
            timeSpanArray[0] = new TimeSpan(l2);
            return true;
        }
    }
}

