/*
 * Decompiled with CFR 0.152.
 */
package com.pg.sync.service.impl;

import com.microsoft.graph.requests.GraphServiceClient;
import com.parablu.pcbd.dao.ExternalStorageBackupFileDao;
import com.parablu.pcbd.dao.FileRevisionDao;
import com.parablu.pcbd.domain.ChunkDetail;
import com.parablu.pcbd.domain.ChunkFile;
import com.parablu.pcbd.domain.Cloud;
import com.parablu.pcbd.domain.CloudCustomisableDetails;
import com.parablu.pcbd.domain.ConsolidatedImage;
import com.parablu.pcbd.domain.FileRevision;
import com.parablu.pcbd.domain.SyncPolicy;
import com.parablu.pcbd.domain.User;
import com.pg.controller.Graph;
import com.pg.dao.FileDao;
import com.pg.domain.BackupFile;
import com.pg.domain.FileInfo;
import com.pg.element.FileStatusElement;
import com.pg.encryption.service.FileEncryptionService;
import com.pg.exception.BaseException;
import com.pg.helper.constant.GeneralHelperConstant;
import com.pg.helper.constant.PCHelperConstant;
import com.pg.service.CloudSupportService;
import com.pg.service.UtilService;
import com.pg.service.impl.BaseUploadService;
import com.pg.sync.service.SyncCloudUploadService;
import com.pg.util.FileUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bson.types.ObjectId;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.OptimisticLockingFailureException;
import org.springframework.util.CollectionUtils;

public class SyncCloudUploadServiceImpl
extends BaseUploadService
implements SyncCloudUploadService {
    private static Logger logger = LogManager.getLogger(SyncCloudUploadServiceImpl.class);
    private FileDao fileDao;
    private ExternalStorageBackupFileDao externalStorageBackupFileDao;
    @Autowired
    private FileEncryptionService fileEncryptionService;
    @Autowired
    private UtilService utilService;
    @Autowired
    private CloudSupportService cloudUploadService;
    private FileRevisionDao fileRevisionDao;

    public void setFileDao(FileDao fileDao) {
        this.fileDao = fileDao;
    }

    public void setExternalStorageBackupFileDao(ExternalStorageBackupFileDao externalStorageBackupFileDao) {
        this.externalStorageBackupFileDao = externalStorageBackupFileDao;
    }

    public void setFileRevisionDao(FileRevisionDao fileRevisionDao) {
        this.fileRevisionDao = fileRevisionDao;
    }

    public void setFileEncryptionService(FileEncryptionService fileEncryptionService) {
        this.fileEncryptionService = fileEncryptionService;
    }

    public void setCloudUploadService(CloudSupportService cloudUploadService) {
        this.cloudUploadService = cloudUploadService;
    }

    public void setUtilService(UtilService utilService) {
        this.utilService = utilService;
    }

    @Override
    public boolean uploadAllSyncFilesToCloud(String cloudName, FileInfo fileInfo, String gatewayName, Cloud cloudTemp) {
        List list;
        boolean uploadSuccess;
        Cloud cloud = cloudTemp;
        logger.debug("  INSIDE uploadAllSyncFilesToLocalStorage ..... " + fileInfo.getFileName());
        String deviceTempPath = PCHelperConstant.getPropertyFileValueDefaultSyncUploadPath((String)cloudName) + fileInfo.getDeviceUUID();
        String batchId = fileInfo.getBatchId();
        logger.debug("@#@#@#Inside uploadAllChunksToCloud ..... " + batchId);
        if (!StringUtils.isEmpty((String)batchId)) {
            deviceTempPath = PCHelperConstant.getPropertyFileValueDefaultSyncUploadPath((String)cloudName) + fileInfo.getDeviceUUID() + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + batchId;
        }
        logger.debug(fileInfo.getId() + "--@#@#@#Inside uploadAllChunksToCloud path ..... " + deviceTempPath);
        String chunkFilePath = deviceTempPath + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + "chunk";
        BackupFile backupFile = new BackupFile();
        backupFile.setChunkFiles(new ArrayList());
        backupFile.setFileName(fileInfo.getFileName());
        backupFile.setFilePath(fileInfo.getFilePath());
        backupFile.setMd5(fileInfo.getMd5());
        backupFile.setSize(fileInfo.getSize().longValue());
        backupFile.setCompressed(fileInfo.isCompressed());
        String dedupVal = this.getDedupValue(fileInfo.getUserName());
        String syncId = fileInfo.getId();
        if (fileInfo.getId().contains("DEDUPED-FILE-")) {
            syncId = fileInfo.getId().replaceAll("DEDUPED-FILE-", "");
        }
        backupFile.setBackupId(new ObjectId(syncId));
        FileRevision fileRevisionById = this.getFileRevisionById(syncId);
        if (fileRevisionById == null) {
            logger.debug("File revision is empty for ID :" + syncId + "... is empty so send true to delete file in local db");
            return true;
        }
        backupFile.setDeviceUUID(fileInfo.getDeviceUUID());
        if (StringUtils.isEmpty((String)fileInfo.getDedupBackupId())) {
            cloud = this.utilService.getCloud(cloud.getCloudId());
            uploadSuccess = this.uploadAllChunksToCloud(cloudName, fileInfo, gatewayName, chunkFilePath, backupFile, cloud, fileInfo.getUserName(), dedupVal);
        } else {
            list = this.utilService.getSyncFileIfExists(fileInfo.getDedupBackupId());
            if (CollectionUtils.isEmpty(list)) {
                logger.debug("@#@#@#INside dedupification list empty..... false");
                return false;
            }
            backupFile.setChunkFiles(list);
            uploadSuccess = true;
        }
        backupFile.setDedupBackupId(fileInfo.getDedupBackupId());
        list = backupFile.getChunkFiles();
        Collections.sort(list, new Comparator<com.pg.domain.ChunkFile>(this){

            @Override
            public int compare(com.pg.domain.ChunkFile d1, com.pg.domain.ChunkFile d2) {
                return d1.getFileName().compareTo(d2.getFileName());
            }
        });
        backupFile.setChunkFiles(list);
        ArrayList<ChunkFile> refList = new ArrayList<ChunkFile>();
        for (com.pg.domain.ChunkFile chunkFile : list) {
            ChunkFile file = new ChunkFile();
            BeanUtils.copyProperties((Object)chunkFile, (Object)file);
            refList.add(file);
        }
        if (uploadSuccess) {
            this.updateSyncRevisionTable(cloudName, backupFile.getBackupId().toString(), "ES");
            logger.debug("  Before calling saveSyncFileInfo " + backupFile.getFilePath());
            this.utilService.saveSyncFileInfo(1, cloudName, fileInfo.getUserName(), backupFile);
            logger.debug("  After calling saveSyncFileInfo ");
        }
        return uploadSuccess;
    }

    private String getDedupValue(String userName) {
        String dedupVal = null;
        User user = this.utilService.getUserInfoByName(1, userName);
        if (user != null) {
            SyncPolicy syncPolicy = this.utilService.getSyncPolicy(1, user.getSyncPolicyName());
            dedupVal = syncPolicy.getDedup();
        }
        logger.debug(" dedup value .... " + dedupVal);
        return dedupVal;
    }

    @Override
    public void removeBackupFromTempDb(Cloud cloud, ObjectId backupId) {
        logger.debug("...Removing file from backup pg " + backupId.toString());
        this.utilService.removeBackupFromTempDb(cloud, backupId, true);
    }

    private FileRevision getFileRevisionById(String syncRevisionId) {
        return this.fileRevisionDao.getFileRevisionById(1, new ObjectId(syncRevisionId));
    }

    private boolean uploadFileToCloud(String cloudName, File file, String deviceUUID, BackupFile fileInfo, String gatewayName, boolean nonChunkable, boolean uploadSuccess, Cloud cloud, String userName, String batchId, String dedupType, FileInfo localFileInfo) throws BaseException {
        FileStatusElement fileStatusElement;
        File encryptedFile;
        int occurance = StringUtils.countMatches((String)file.getName(), (String)".");
        String md5 = SyncCloudUploadServiceImpl.getMd5FromFileName(file.getName(), occurance);
        String fileName = file.getName();
        long fileSize = file.length();
        String pathname = PCHelperConstant.getParabluFolderBasePath() + cloudName + "/sync-upload/" + deviceUUID + GeneralHelperConstant.CLOUD_PATH_SEPARATOR;
        if (!StringUtils.isEmpty((String)batchId)) {
            pathname = pathname + batchId + GeneralHelperConstant.CLOUD_PATH_SEPARATOR;
        }
        this.createFoldersForUpload(pathname);
        String encryptedFileName = file.getName() + "." + fileInfo.getBackupId().toString();
        User user = this.utilService.getUserInfoByName(1, userName);
        if (!StringUtils.isEmpty((String)PCHelperConstant.getPropertyFileValueEncryptionEnabled()) && "true".equals(PCHelperConstant.getPropertyFileValueEncryptionEnabled())) {
            encryptedFile = new File(pathname + "encrypted/" + encryptedFileName);
            String syncUniqueKey = "d8e87c0927539672f54462c837be0b7f";
            logger.debug("before encryption ... " + file.getPath());
            String saltKey = this.utilService.getEncryptionKey(1, "sync");
            encryptedFile = this.fileEncryptionService.encrypt(saltKey, syncUniqueKey, file, encryptedFile);
            logger.debug(encryptedFileName + "after Encryption........^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^");
        } else {
            encryptedFile = file;
            logger.debug("fileName...." + encryptedFile.getName());
        }
        if (!encryptedFile.exists()) {
            logger.debug("File not exists so check chunk exists ");
            logger.debug(md5 + "...md5");
            String dedupVal = this.getDedupValue(userName);
            ChunkDetail chunkDetail = this.externalStorageBackupFileDao.getChunkDetailForMd51(1, md5, dedupVal, userName, true, false);
            if (chunkDetail == null) {
                logger.debug("................chunk detail is empty for userName " + userName + " so search with userName case insesitive...........");
                chunkDetail = this.externalStorageBackupFileDao.getChunkDetailForMd51(1, md5, dedupVal, userName, true, true);
            }
            if (chunkDetail != null) {
                logger.debug(md5 + "......... CHUNK EXISTS ........................................");
                com.pg.domain.ChunkFile chunkFile = new com.pg.domain.ChunkFile();
                chunkFile.setFileName(fileName);
                chunkFile.setMd5(md5);
                chunkFile.setfSPath(chunkFile.getCloudStoragePath());
                chunkFile.setFileId(fileName);
                chunkFile.setSize(Long.valueOf(fileSize));
                chunkFile.setUploadedTimeStamp(System.currentTimeMillis());
                chunkFile.setCloudStoragePath(chunkFile.getCloudStoragePath());
                chunkFile.setProductType("SYNC");
                fileInfo.getChunkFiles().add(chunkFile);
                int refCount = chunkDetail.getRefCount() + 1;
                chunkDetail.setRefCount(refCount);
                this.externalStorageBackupFileDao.saveChunkDetail(1, chunkDetail);
                uploadSuccess = true;
            } else {
                logger.debug("....chunk also null so return false.......");
                uploadSuccess = false;
            }
            return uploadSuccess;
        }
        logger.debug(" BEFORE UPLOAD FILE .... " + pathname);
        String lastStoragePathForSameFile = "";
        lastStoragePathForSameFile = this.getLastStoragePath(fileInfo, lastStoragePathForSameFile);
        GraphServiceClient<Request> graphClient = null;
        OkHttpClient okHttpClient = null;
        boolean isODBEnabled = this.isODBEnabled(cloud.getCloudCustomisableDetails());
        if (isODBEnabled && cloud.getGraphApiEnabled() == 1) {
            graphClient = Graph.getInstance().getGraphClient();
            okHttpClient = Graph.getInstance().getOkHttpClient();
        }
        if (!(fileStatusElement = this.cloudUploadService.uploadToCloud(cloud, null, encryptedFile, user, true, lastStoragePathForSameFile, null, fileInfo, gatewayName, false, graphClient, okHttpClient)).isUploadStatus()) {
            encryptedFile.delete();
            return false;
        }
        String encodedFileName = this.convertStringTOBase64(encryptedFile.getName()).replaceAll("/", "_");
        logger.debug(" AFTER UPLOAD FILE .... " + fileStatusElement.isUploadStatus());
        String encodedNameInCloud = this.convertStringTOBase64(this.removeIdFromChunkName(fileInfo.getId(), encryptedFile)).replaceAll("/", "_");
        if (StringUtils.isNotEmpty((String)fileStatusElement.getEncodedFileName())) {
            encodedNameInCloud = fileStatusElement.getEncodedFileName();
        }
        logger.debug(".......encodedNameInCloud....." + encodedNameInCloud);
        try {
            com.pg.domain.ChunkFile chunkFile = new com.pg.domain.ChunkFile();
            chunkFile.setFileName(encryptedFileName);
            chunkFile.setMd5(md5);
            chunkFile.setFileId(fileStatusElement.getFileId());
            chunkFile.setFileSource(fileName);
            chunkFile.setfSPath(encodedFileName);
            chunkFile.setEncodedName(encodedNameInCloud);
            chunkFile.setSize(Long.valueOf(file.length()));
            chunkFile.setProductType("SYNC");
            if (!StringUtils.isEmpty((String)fileStatusElement.getOdbLoginId())) {
                chunkFile.setOdbLoginId(fileStatusElement.getOdbLoginId());
            }
            chunkFile.setCloudStoragePath(fileStatusElement.getCloudStoragePath());
            fileInfo.setCloudStoragePath(fileStatusElement.getCloudStoragePath());
            chunkFile.setUploadedTimeStamp(System.currentTimeMillis());
            fileInfo.getChunkFiles().add(chunkFile);
            ChunkFile chunkFileRef = new ChunkFile();
            BeanUtils.copyProperties((Object)chunkFile, (Object)chunkFileRef);
            long chunkSize = encryptedFile.length() / 1024L;
            this.updateRefChunks(chunkFileRef, localFileInfo, this.externalStorageBackupFileDao, null, dedupType, userName, false, false, deviceUUID, cloud, chunkSize, gatewayName, user.getOdbLoginId(), user.getOdbDriveid());
        }
        catch (Exception e) {
            logger.error(" JSON EXEPTION " + String.valueOf(e));
        }
        encryptedFile.delete();
        return fileStatusElement.isUploadStatus();
    }

    private String removeIdFromChunkName(String bkpFileId, File encryptedFile) {
        String encryptedFileName = encryptedFile.getName();
        try {
            logger.debug(encryptedFileName + ">>>>>>>>>>>>>>> BEFORE...." + encryptedFileName);
            if (encryptedFileName.contains("." + bkpFileId)) {
                encryptedFileName = encryptedFileName.replaceAll("." + bkpFileId, "");
            }
            logger.debug(encryptedFileName);
            if (encryptedFileName.contains("_")) {
                encryptedFileName = encryptedFileName.substring(0, encryptedFileName.indexOf("_"));
            }
        }
        catch (Exception e) {
            logger.error("error in Encoding the chunk name " + encryptedFileName + e.getMessage());
            logger.trace(String.valueOf(e));
        }
        return encryptedFileName;
    }

    private String getLastStoragePath(BackupFile fileInfo, String lastStoragePathForSameFile) {
        String lastStoragePathForSameFileTemp = lastStoragePathForSameFile;
        List files = fileInfo.getChunkFiles();
        if (!CollectionUtils.isEmpty((Collection)files)) {
            Collections.sort(files, new Comparator<com.pg.domain.ChunkFile>(this){

                @Override
                public int compare(com.pg.domain.ChunkFile c1, com.pg.domain.ChunkFile c2) {
                    long t1 = c1.getUploadedTimeStamp();
                    long t2 = c2.getUploadedTimeStamp();
                    if (t2 > t1) {
                        return 1;
                    }
                    if (t1 > t2) {
                        return -1;
                    }
                    return 0;
                }
            });
            com.pg.domain.ChunkFile chunkFile = (com.pg.domain.ChunkFile)files.get(0);
            lastStoragePathForSameFileTemp = chunkFile.getCloudStoragePath();
        }
        return lastStoragePathForSameFileTemp;
    }

    private String convertStringTOBase64(String name) {
        String base64EncodeString = null;
        if (name != null) {
            byte[] bytes = DigestUtils.md5((String)name);
            byte[] bytesEncoded = Base64.encodeBase64((byte[])bytes);
            base64EncodeString = new String(bytesEncoded);
            base64EncodeString = base64EncodeString.substring(0, base64EncodeString.length() - 2);
            logger.debug("ecncoded value for given string is " + base64EncodeString);
        }
        return base64EncodeString;
    }

    private void updateRefChunks(String userName, Cloud cloud, String dedupVal, String md5, ChunkDetail chunkDetail) {
        try {
            int refCount = chunkDetail.getRefCount() + 1;
            chunkDetail.setRefCount(refCount);
            this.externalStorageBackupFileDao.saveChunkDetail(cloud.getCloudId(), chunkDetail);
            logger.debug(refCount + " Chunk updated succcessfully  .........." + chunkDetail.getCloudChunkName());
        }
        catch (OptimisticLockingFailureException e) {
            logger.trace(String.valueOf((Object)e));
            logger.error("Exception while updating ref chunks :" + String.valueOf((Object)e));
            int maxTries = 5;
            int count = 0;
            while (true) {
                try {
                    Thread.sleep(2000L);
                    logger.debug(" retry chunk update ..............." + md5);
                    ChunkDetail chunkDetailObj = this.externalStorageBackupFileDao.getChunkDetailForMd51(1, md5, dedupVal, userName, true, false);
                    if (chunkDetailObj == null) {
                        logger.debug("................chunk detail is empty for userName " + userName + " so search with userName case insesitive...........");
                        chunkDetailObj = this.externalStorageBackupFileDao.getChunkDetailForMd51(1, md5, dedupVal, userName, true, true);
                    }
                    int refCount = chunkDetailObj.getRefCount() + 1;
                    chunkDetailObj.setRefCount(refCount);
                    this.externalStorageBackupFileDao.saveChunkDetail(1, chunkDetailObj);
                }
                catch (Exception ex) {
                    logger.trace(String.valueOf(ex));
                    logger.error(" ex ..." + ex.getMessage());
                    if (++count != maxTries) continue;
                }
                break;
            }
        }
    }

    private boolean uploadAllChunksToCloud(String cloudName, FileInfo fileInfo, String gatewayName, String chunkFilePath, BackupFile backupFile, Cloud cloud, String userName, String dedupType) {
        boolean uploadSuccess = false;
        String batchId = fileInfo.getBatchId();
        if (StringUtils.isEmpty((String)PCHelperConstant.getPropertyFileValueEncryptionEnabled()) || !"true".equals(PCHelperConstant.getPropertyFileValueEncryptionEnabled())) {
            String filePath = this.mergeAllChunksAndCreateSingleFile(fileInfo, chunkFilePath, cloudName);
            File file = new File(filePath);
            long fileSize = file.length();
            logger.debug(fileSize + "Cloud upload  FILE started inside no encryption..... " + file.getName());
            uploadSuccess = this.uploadFileToCloud(cloudName, fileInfo, gatewayName, backupFile, file.getName(), file, fileSize, cloud, userName, batchId, dedupType);
            return uploadSuccess;
        }
        for (Object fileName : fileInfo.getChunkFiles()) {
            File file = new File(chunkFilePath + "/" + (String)fileName);
            long fileSize = file.length();
            logger.debug(" file before........................................................................." + (String)fileName);
            int occurance = StringUtils.countMatches((String)fileName, (String)".");
            String md5 = SyncCloudUploadServiceImpl.getMd5FromFileName((String)fileName, occurance);
            if (occurance <= 1 && occurance == 0) {
                fileName = (String)fileName + "." + backupFile.getBackupId().toString();
            }
            logger.debug(md5 + "......... file after........................................................................." + (String)fileName);
            String dedupVal = this.getDedupValue(userName);
            ChunkDetail chunkDetail = this.externalStorageBackupFileDao.getChunkDetailForMd51(1, md5, dedupVal, userName, true, false);
            if (chunkDetail == null) {
                logger.debug("................chunk detail is empty for userName " + userName + " so search with userName case insesitive...........");
                chunkDetail = this.externalStorageBackupFileDao.getChunkDetailForMd51(1, md5, dedupVal, userName, true, true);
            }
            if (chunkDetail != null) {
                logger.debug(md5 + "......... CHUNK EXISTS ........................................");
                com.pg.domain.ChunkFile chunkFile = new com.pg.domain.ChunkFile();
                chunkFile.setFileName((String)fileName);
                chunkFile.setMd5(md5);
                chunkFile.setfSPath(chunkFile.getCloudStoragePath());
                chunkFile.setFileId((String)fileName);
                chunkFile.setSize(Long.valueOf(file.length()));
                chunkFile.setUploadedTimeStamp(System.currentTimeMillis());
                chunkFile.setCloudStoragePath(chunkFile.getCloudStoragePath());
                chunkFile.setProductType("SYNC");
                backupFile.getChunkFiles().add(chunkFile);
                int refCount = chunkDetail.getRefCount() + 1;
                chunkDetail.setRefCount(refCount);
                this.externalStorageBackupFileDao.saveChunkDetail(1, chunkDetail);
                uploadSuccess = true;
                continue;
            }
            Object fileNameVal = fileName;
            logger.debug(fileSize + " aaa Cloud upload  FILE started ..... . path ... " + chunkFilePath + " batchid .... " + batchId);
            boolean uploadStatus = this.uploadFileToCloud(cloudName, fileInfo, gatewayName, backupFile, (String)fileNameVal, file, fileSize, cloud, userName, batchId, dedupType);
            logger.debug(" after uploading ................. " + uploadStatus);
            if (!uploadStatus) {
                logger.debug("....upload failed so return false");
                return false;
            }
            uploadSuccess = uploadStatus;
        }
        return uploadSuccess;
    }

    private static String getMd5FromFileName(String fileName, int occurance) {
        String md5 = "";
        if (occurance == 1 && !fileName.startsWith("part")) {
            md5 = fileName.substring(0, fileName.lastIndexOf(46));
        } else if (occurance == 1 && fileName.startsWith("part")) {
            md5 = fileName.substring(fileName.lastIndexOf(46) + 1);
        } else if (occurance == 0) {
            md5 = fileName;
        } else if (occurance > 1) {
            md5 = fileName.substring(fileName.indexOf(46) + 1, fileName.lastIndexOf(46));
        }
        if (StringUtils.isNotEmpty((String)md5) && md5.contains("_")) {
            md5 = md5.substring(0, md5.lastIndexOf("_"));
        }
        return md5;
    }

    private String mergeAllChunksAndCreateSingleFile(FileInfo fileInfo, String chunkFilePath, String cloudName) {
        logger.debug("inside merge into a single file............");
        String deviceTempPath = PCHelperConstant.getPropertyFileValueDefaultUploadPath((String)cloudName) + fileInfo.getDeviceUUID();
        String destinationPath = deviceTempPath + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + "merge" + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + fileInfo.getFileName();
        FileUtils.merge((List)fileInfo.getChunkFiles(), (String)chunkFilePath, (String)destinationPath);
        return destinationPath;
    }

    private boolean uploadFileToCloud(String cloudName, FileInfo fileInfo, String gatewayName, BackupFile backupFile, String fileName, File file, long fileSize, Cloud cloud, String userName, String batchId, String dedupType) {
        boolean uploadSuccess = false;
        logger.debug("throttle limit not reached");
        try {
            uploadSuccess = this.uploadFileToCloud(cloudName, file, fileInfo.getDeviceUUID(), backupFile, gatewayName, false, uploadSuccess, cloud, userName, batchId, dedupType, fileInfo);
        }
        catch (Exception e) {
            BackupFile backupFileObj;
            logger.trace(String.valueOf(e));
            logger.error("Exception While Uploading File to Cloud :" + e.getMessage());
            logger.debug(" UNABLE TO UPLOAD FILES ..... " + file.getName());
            if (!StringUtils.isEmpty((String)fileInfo.getPrevBackupId()) && (backupFileObj = this.fileDao.getSyncFile("", cloudName, fileInfo.getPrevBackupId(), gatewayName)) != null) {
                for (com.pg.domain.ChunkFile chunkFile : backupFileObj.getChunkFiles()) {
                    if (!fileName.equals(chunkFile.getFileName())) continue;
                    backupFile.getChunkFiles().add(chunkFile);
                }
            }
            uploadSuccess = false;
        }
        return uploadSuccess;
    }

    @Override
    public void deleteUploadedFiles(FileInfo fileInfo, String cloudName, String gatewayName) {
        this.fileDao.deleteSyncFile(fileInfo, cloudName, gatewayName);
    }

    @Override
    public long getThreadSize(String cloudName) {
        return this.fileDao.getThreadSize(cloudName);
    }

    private void updateSyncRevisionTable(String cloudName, String syncRevisionId, String storagePlace) {
        this.fileRevisionDao.updateExternalStorageStatusOfFile(1, cloudName, new ObjectId(syncRevisionId), storagePlace);
        logger.debug("INSIDE update sync table after upload to external storage ..... ");
    }

    @Override
    public void deleteFile(Cloud cloud, BackupFile backupFile) {
        this.cloudUploadService.deleteFile(cloud, backupFile);
    }

    @Override
    public FileInfo getFileFromPG(String cloudName, String id, boolean sync) {
        return this.fileDao.getFileFromPG("", cloudName, id, sync);
    }

    @Override
    public List<FileInfo> getFilesForUpload(String cloudName) {
        return this.fileDao.getFilesForSyncUpload(cloudName);
    }

    @Override
    public void deleteUploadedFiles(FileInfo fileInfo, String cloudName) {
        this.fileDao.deleteSyncFile(fileInfo, cloudName);
    }

    @Override
    public ConsolidatedImage getConsolImgbyFilenameDevicepathandUsername(int cloudId, String fileName, String filePath, String userName) {
        return this.fileDao.getConsolImgbyFilenameDevicepathandUsername(cloudId, fileName, filePath, userName);
    }

    @Override
    public boolean isRevisionExistforConsId(int cloudId, ObjectId consolidatedImageId) {
        return this.fileRevisionDao.getLatestRevision(cloudId, "", consolidatedImageId) != null;
    }

    @Override
    public void moveSyncFailedFilesToBkpQueueAndDelete(String cloudName, FileInfo fileInfo) {
        this.fileDao.moveFailedFilesToBkpQueueAndDeleteInLocalForSync(fileInfo, cloudName, true);
    }

    private boolean isODBEnabled(List<CloudCustomisableDetails> licenseDetails) {
        boolean isODBEnabled = false;
        for (CloudCustomisableDetails license : licenseDetails) {
            if (license == null || !"ODB Enabled".equalsIgnoreCase(license.getName())) continue;
            isODBEnabled = true;
            break;
        }
        return isODBEnabled;
    }
}

