/*
 * Decompiled with CFR 0.152.
 */
package com.pg.service.impl;

import com.azure.core.credential.TokenCredential;
import com.azure.core.http.ProxyOptions;
import com.azure.core.util.HttpClientOptions;
import com.azure.identity.ClientSecretCredential;
import com.azure.identity.ClientSecretCredentialBuilder;
import com.microsoft.graph.authentication.IAuthenticationProvider;
import com.microsoft.graph.authentication.TokenCredentialAuthProvider;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.GraphServiceException;
import com.microsoft.graph.httpcore.HttpClients;
import com.microsoft.graph.models.Drive;
import com.microsoft.graph.models.DriveItem;
import com.microsoft.graph.models.DriveSearchParameterSet;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.requests.DriveCollectionPage;
import com.microsoft.graph.requests.DriveCollectionRequest;
import com.microsoft.graph.requests.DriveCollectionRequestBuilder;
import com.microsoft.graph.requests.DriveItemRequestBuilder;
import com.microsoft.graph.requests.DriveRequestBuilder;
import com.microsoft.graph.requests.DriveSearchCollectionPage;
import com.microsoft.graph.requests.DriveSearchCollectionRequest;
import com.microsoft.graph.requests.GraphServiceClient;
import com.microsoft.graph.requests.UserRequestBuilder;
import com.pg.controller.Graph;
import com.pg.element.FileDownloadElement;
import com.pg.element.PciAuthorizationTokenElement;
import com.pg.helper.constant.PCHelperConstant;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import okhttp3.Authenticator;
import okhttp3.Credentials;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.Route;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.DefaultHttpResponseFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Office365DownloadServiceImplData {
    private static final String BEARER = "Bearer ";
    private Response result;
    private String deviceUUID;
    private String downloadUrl;
    private String proxyUserName;
    private String password;
    private String host;
    private int port;
    private String driveId;
    private String accountId;
    private String userName;
    private GraphServiceClient<Request> graphClient;
    private String fileItemId;
    private FileDownloadElement fileDownloadElement;
    private String oneDriveUniqueFolderName;
    private int downloadStatusCode;
    private PciAuthorizationTokenElement authorizationTokenElement;
    private static Logger logger = LogManager.getLogger(Office365DownloadServiceImplData.class);

    public Office365DownloadServiceImplData(String proxyUserName, String password, String host, int port) {
        this.proxyUserName = proxyUserName;
        this.password = password;
        this.host = host;
        this.port = port;
    }

    public Office365DownloadServiceImplData() {
    }

    protected Response executeDownload() throws ClientProtocolException, IOException {
        logger.debug(" ............new path................." + this.downloadUrl);
        HttpGet httpGet = new HttpGet(this.downloadUrl);
        httpGet.addHeader("Accept", "application/json;odata=verbose");
        httpGet.addHeader("Content-Type", "*/*");
        if (!StringUtils.isEmpty((String)PCHelperConstant.getODBDecorationValue())) {
            httpGet.addHeader("User-Agent", PCHelperConstant.getODBDecorationValue());
            logger.debug("..add retry THROTTLE_DECOR..............." + PCHelperConstant.getODBDecorationValue());
        }
        if (StringUtils.isEmpty((String)this.proxyUserName) || StringUtils.isEmpty((String)this.password) || StringUtils.isEmpty((String)this.host) || this.port <= 0) {
            logger.debug(" without proxy ....");
            OkHttpClient okHttpClient = Office365DownloadServiceImplData.getOkHttpClient();
            Request request = new Request.Builder().url(this.downloadUrl).addHeader("Accept", "application/json;odata=verbose").addHeader("Content-Type", "*/*").build();
            this.result = okHttpClient.newCall(request).execute();
        } else {
            logger.debug(" using proxy ....");
            OkHttpClient okHttpClient = Office365DownloadServiceImplData.getOkHttpClient();
            Request request = new Request.Builder().url(this.downloadUrl).addHeader("Accept", "application/json;odata=verbose").addHeader("Content-Type", "*/*").build();
            this.result = okHttpClient.newCall(request).execute();
        }
        logger.debug("...Inside execute..." + this.result.code());
        return this.result;
    }

    protected Response executeDownloadUsingGraph() throws IOException, ClientProtocolException {
        try {
            HttpGet httpGet = new HttpGet(this.downloadUrl);
            httpGet.addHeader("Accept", "application/json;odata=verbose");
            httpGet.addHeader("Content-Type", "*/*");
            if (!StringUtils.isEmpty((String)PCHelperConstant.getODBDecorationValue())) {
                httpGet.addHeader("User-Agent", PCHelperConstant.getODBDecorationValue());
                logger.debug("..add retry THROTTLE_DECOR..............." + PCHelperConstant.getODBDecorationValue());
            }
            if (StringUtils.isEmpty((String)this.proxyUserName) || StringUtils.isEmpty((String)this.password) || StringUtils.isEmpty((String)this.host) || this.port <= 0) {
                logger.debug(" without proxy ....");
                OkHttpClient okHttpClient = Office365DownloadServiceImplData.getOkHttpClient();
                Request request = new Request.Builder().url(this.downloadUrl).addHeader("Accept", "application/json;odata=verbose").addHeader("Content-Type", "*/*").build();
                this.result = okHttpClient.newCall(request).execute();
            } else {
                logger.debug(" using proxy ....");
                OkHttpClient okHttpClient = Office365DownloadServiceImplData.getOkHttpClient();
                Request request = new Request.Builder().url(this.downloadUrl).addHeader("Accept", "application/json;odata=verbose").addHeader("Content-Type", "*/*").build();
                this.result = okHttpClient.newCall(request).execute();
            }
            logger.debug(this.downloadUrl + "...Inside execute..." + this.result.code());
        }
        catch (GraphServiceException e) {
            logger.error("... failed graph exception ... " + e.getResponseCode());
            DefaultHttpResponseFactory defaultHttpResponseFactory = new DefaultHttpResponseFactory();
        }
        return this.result;
    }

    protected FileDownloadElement executeDownloadUsingGraphClient() throws IOException, ClientProtocolException {
        this.fileDownloadElement = new FileDownloadElement();
        try {
            logger.debug("before execute request in graph client..." + this.downloadUrl);
            InputStream inputStream = (InputStream)Graph.getInstance().getGraphClient().customRequest(this.downloadUrl, InputStream.class).buildRequest(new Option[0]).get();
            this.fileDownloadElement.setDownloadStatuscode(200);
            this.fileDownloadElement.setInputStream(inputStream);
            this.fileDownloadElement.setReasonPhrase("OK");
        }
        catch (IllegalStateException ee) {
            logger.error(" illegal state in graph client...");
            this.fileDownloadElement.setDownloadStatuscode(400);
            this.fileDownloadElement.setReasonPhrase(ee.getMessage());
        }
        catch (GraphServiceException e) {
            this.fileDownloadElement.setDownloadStatuscode(e.getResponseCode());
            this.fileDownloadElement.setReasonPhrase(e.getResponseMessage());
            logger.debug("GraphService exception:" + e.getResponseCode());
        }
        catch (ClientException ee) {
            ee.printStackTrace();
            logger.debug("ClientException exception:" + ee.getMessage());
            this.fileDownloadElement.setDownloadStatuscode(400);
            this.fileDownloadElement.setReasonPhrase(ee.getMessage());
        }
        return this.fileDownloadElement;
    }

    public String getPBFolderItemId() {
        String pbFolderItemId = "";
        try {
            logger.debug(".....get user account id...." + this.accountId);
            UserRequestBuilder users = Graph.getInstance().getGraphClient().users(this.accountId);
            DriveCollectionRequestBuilder drives = users.drives();
            DriveCollectionRequest buildRequests = (DriveCollectionRequest)drives.buildRequest(new Option[0]);
            DriveCollectionPage DriveCollectionPages = (DriveCollectionPage)buildRequests.get();
            for (Drive drive : DriveCollectionPages.getCurrentPage()) {
                if (!Office365DownloadServiceImplData.isPBDrive(drive.webUrl)) continue;
                this.driveId = pbFolderItemId = drive.id;
            }
        }
        catch (GraphServiceException e) {
            logger.error("GraphServiceException", (Throwable)e);
            if (e.getResponseCode() == 401) {
                pbFolderItemId = "401";
            }
        }
        catch (ClientException ee) {
            try {
                Thread.sleep(20000L);
                logger.debug("....wait for 2 sec and retry...");
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return this.getPBFolderItemId();
        }
        catch (Exception e) {
            logger.error("graph exception to get id:", (Throwable)e);
        }
        logger.debug("driveId:" + this.driveId);
        return pbFolderItemId;
    }

    protected String searchFileItemInOneDrive(String fileName, String driveId) {
        String fileItemId = "";
        try {
            DriveSearchParameterSet searchset = new DriveSearchParameterSet();
            searchset.q = fileName;
            logger.debug("...filesearch......" + fileName + "....driveid..." + driveId);
            DriveSearchCollectionPage search = (DriveSearchCollectionPage)((DriveSearchCollectionRequest)Graph.getInstance().getGraphClient().drives(driveId).search(searchset).buildRequest(new Option[0])).get();
            if (search == null) {
                logger.debug("search not found.....");
                return "404";
            }
            for (DriveItem driveItem : search.getCurrentPage()) {
                logger.debug(driveItem.id + "..itemid and name....." + driveItem.name + "...accountid...." + this.accountId);
                this.fileItemId = driveItem.id;
                fileItemId = driveItem.id;
                this.driveId = driveId;
                this.getFileItem(this.accountId, driveId, fileItemId);
                if (!StringUtils.isNotEmpty((String)fileItemId)) continue;
                break;
            }
        }
        catch (GraphServiceException e) {
            logger.error("GraphServiceException", (Throwable)e);
            if (e.getResponseCode() == 401) {
                fileItemId = "401";
            }
        }
        catch (Exception e) {
            logger.error("graph exception to searchFileItemInOneDrive :" + e.getMessage());
        }
        logger.debug("search result exis:" + fileItemId);
        return fileItemId;
    }

    protected String searchFileItemInOneDrive(String fileName) {
        String fileItemId = "";
        try {
            DriveSearchParameterSet searchset = new DriveSearchParameterSet();
            searchset.q = fileName;
            logger.debug("...filesearch......" + fileName + "....driveid..." + this.driveId);
            DriveSearchCollectionPage search = (DriveSearchCollectionPage)((DriveSearchCollectionRequest)Graph.getInstance().getGraphClient().drives(this.driveId).search(searchset).buildRequest(new Option[0])).get();
            if (search == null) {
                logger.debug("search not found.....");
                return "404";
            }
            for (DriveItem driveItem : search.getCurrentPage()) {
                logger.debug(driveItem.id + "..itemid and name....." + driveItem.name + "...accountid...." + this.accountId);
                this.fileItemId = driveItem.id;
                fileItemId = driveItem.id;
                this.getFileItem(this.accountId, this.driveId, fileItemId);
                if (!StringUtils.isNotEmpty((String)fileItemId)) continue;
                break;
            }
        }
        catch (GraphServiceException e) {
            logger.error("GraphServiceException", (Throwable)e);
            fileItemId = "";
            if (e.getResponseCode() == 401) {
                fileItemId = "401";
            }
        }
        catch (ClientException ee) {
            fileItemId = "";
            logger.error("GraphServiceException", (Throwable)ee);
        }
        catch (Exception e) {
            fileItemId = "";
            logger.error("graph exception to get id:", (Throwable)e);
        }
        logger.debug("search result exis:" + fileItemId);
        return fileItemId;
    }

    protected void getFileItem(String accId, String driveId, String fileId) throws IOException {
        try {
            DriveItem driveItem = ((DriveItemRequestBuilder)((DriveRequestBuilder)Graph.getInstance().getGraphClient().users(accId).drives().byId(driveId)).items().byId(fileId)).buildRequest(new Option[0]).get();
            if (driveItem == null || driveItem.id == null) {
                logger.debug("driveItem object is null...");
                return;
            }
            logger.debug("get file item result:" + String.valueOf(driveItem.parentReference));
            if (driveItem.parentReference != null) {
                String folderPath = driveItem.parentReference.path;
                logger.debug("folderPath..." + folderPath);
                if (!StringUtils.isEmpty((String)folderPath) && folderPath.contains("/root:/")) {
                    int firstIndex = folderPath.indexOf("/root:/");
                    folderPath = folderPath.substring(firstIndex).substring(7);
                    this.oneDriveUniqueFolderName = folderPath = Arrays.asList(folderPath.split("/")).get(0);
                    logger.debug("unique folder path..." + this.oneDriveUniqueFolderName);
                }
            }
        }
        catch (GraphServiceException e) {
            logger.debug("exception...." + e.getMessage());
            if (e.getResponseCode() == 401) {
                logger.error("un authorized........" + e.getResponseMessage());
            }
            throw e;
        }
        catch (ClientException ee) {
            try {
                Thread.sleep(20000L);
                logger.debug("....wait for 2 sec and retry...");
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.getFileItem(accId, driveId, fileId);
        }
    }

    private static boolean isPBDrive(String webUrl) {
        boolean pbDrive = false;
        try {
            String docLibraryName = webUrl.substring(webUrl.lastIndexOf("/") + 1);
            if (!StringUtils.isEmpty((String)docLibraryName) && docLibraryName.equalsIgnoreCase("PB")) {
                pbDrive = true;
            }
        }
        catch (Exception e) {
            logger.error(webUrl + "...unable to get drive .... " + e.getMessage());
            pbDrive = false;
        }
        return pbDrive;
    }

    public Response getResult() {
        return this.result;
    }

    public void setResult(Response result) {
        this.result = result;
    }

    public PciAuthorizationTokenElement getToken() {
        return this.authorizationTokenElement;
    }

    public void setToken(PciAuthorizationTokenElement authorizationTokenElement) {
        this.authorizationTokenElement = authorizationTokenElement;
    }

    public String getDeviceUUID() {
        return this.deviceUUID;
    }

    public void setDeviceUUID(String deviceUUID) {
        this.deviceUUID = deviceUUID;
    }

    public String getDownloadUrl() {
        return this.downloadUrl;
    }

    public void setDownloadUrl(String downloadUrl) {
        this.downloadUrl = downloadUrl;
    }

    public String getDriveId() {
        return this.driveId;
    }

    public void setDriveId(String driveId) {
        this.driveId = driveId;
    }

    public GraphServiceClient<Request> getGraphClient() {
        return this.graphClient;
    }

    public void setGraphClient(GraphServiceClient<Request> graphClient) {
        this.graphClient = graphClient;
    }

    public String getFileItemId() {
        return this.fileItemId;
    }

    public void setFileItemId(String fileItemId) {
        this.fileItemId = fileItemId;
    }

    public String getOneDriveUniqueFolderName() {
        return this.oneDriveUniqueFolderName;
    }

    public void setOneDriveUniqueFolderName(String oneDriveUniqueFolderName) {
        this.oneDriveUniqueFolderName = oneDriveUniqueFolderName;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public FileDownloadElement getFileDownloadElement() {
        return this.fileDownloadElement;
    }

    public void setFileDownloadElement(FileDownloadElement fileDownloadElement) {
        this.fileDownloadElement = fileDownloadElement;
    }

    public int getDownloadStatusCode() {
        return this.downloadStatusCode;
    }

    public void setDownloadStatusCode(int downloadStatusCode) {
        this.downloadStatusCode = downloadStatusCode;
    }

    public static OkHttpClient getOkHttpClient() {
        String authorityHost = "https://login.microsoftonline.com";
        ClientSecretCredential clientSecretCredential = ((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)new ClientSecretCredentialBuilder().clientId(PCHelperConstant.getMSClientId())).clientSecret(PCHelperConstant.getMSClientSecret()).tenantId(PCHelperConstant.getMSTenantId())).authorityHost(authorityHost)).build();
        ArrayList<String> scopes = new ArrayList<String>();
        scopes.add("https://graph.microsoft.com/.default");
        TokenCredentialAuthProvider tokenCredAuthProvider = new TokenCredentialAuthProvider(scopes, (TokenCredential)clientSecretCredential);
        OkHttpClient httpClient = null;
        if (!StringUtils.isEmpty((String)PCHelperConstant.getProxyHost()) && PCHelperConstant.getProxyPort() != 0) {
            Authenticator proxyAuthenticator = new Authenticator(){

                public Request authenticate(Route route, Response response) throws IOException {
                    String credential = Credentials.basic((String)PCHelperConstant.getProxyUserName(), (String)PCHelperConstant.getProxyPassword());
                    return response.request().newBuilder().header("Proxy-Authorization", credential).build();
                }
            };
            httpClient = HttpClients.createDefault((IAuthenticationProvider)tokenCredAuthProvider).newBuilder().proxy(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(PCHelperConstant.getProxyHost(), PCHelperConstant.getProxyPort()))).proxyAuthenticator(proxyAuthenticator).build();
        } else {
            httpClient = HttpClients.createDefault((IAuthenticationProvider)tokenCredAuthProvider).newBuilder().build();
        }
        return httpClient;
    }

    private GraphServiceClient<Request> getGraphClient(int cloudId) {
        String authorityHost = "https://login.microsoftonline.com";
        logger.debug("...helper constant ...." + PCHelperConstant.getMSClientId());
        GraphServiceClient graphClient = null;
        if (!StringUtils.isEmpty((String)PCHelperConstant.getProxyHost()) && PCHelperConstant.getProxyPort() != 0) {
            logger.debug("....using proxy latest......");
            InetSocketAddress proxyInetAddress = new InetSocketAddress(PCHelperConstant.getProxyHost(), PCHelperConstant.getProxyPort());
            logger.debug("....using proxy latest before createDefault 1bb......" + PCHelperConstant.getProxyHost() + "..pwd..." + PCHelperConstant.getProxyPort());
            ProxyOptions proxyOptions = new ProxyOptions(ProxyOptions.Type.HTTP, new InetSocketAddress(PCHelperConstant.getProxyHost(), PCHelperConstant.getProxyPort()));
            HttpClientOptions clientOptions = new HttpClientOptions();
            clientOptions.setProxyOptions(proxyOptions);
            logger.debug("....using proxy latest before createDefault 2a with host latest");
            ClientSecretCredential clientSecretCredential = ((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)new ClientSecretCredentialBuilder().clientId(PCHelperConstant.getMSClientId())).clientSecret(PCHelperConstant.getMSClientSecret()).tenantId(PCHelperConstant.getMSTenantId())).proxyOptions(proxyOptions)).authorityHost(authorityHost)).build();
            ArrayList<String> scopes = new ArrayList<String>();
            scopes.add("https://graph.microsoft.com/.default");
            TokenCredentialAuthProvider tokenCredAuthProvider = new TokenCredentialAuthProvider(scopes, (TokenCredential)clientSecretCredential);
            OkHttpClient httpClient = null;
            Proxy proxy = new Proxy(Proxy.Type.HTTP, proxyInetAddress);
            logger.debug("....using proxy latest before createDefault 3a");
            httpClient = HttpClients.createDefault((IAuthenticationProvider)tokenCredAuthProvider).newBuilder().proxy(proxy).build();
            logger.debug("....using proxy latest before createDefault 4");
            graphClient = GraphServiceClient.builder().authenticationProvider((IAuthenticationProvider)tokenCredAuthProvider).httpClient((Object)httpClient).buildClient();
            logger.debug("....using proxy latest before createDefault 5");
        } else {
            ClientSecretCredential clientSecretCredential = ((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)new ClientSecretCredentialBuilder().clientId(PCHelperConstant.getMSClientId())).clientSecret(PCHelperConstant.getMSClientSecret()).tenantId(PCHelperConstant.getMSTenantId())).authorityHost(authorityHost)).build();
            ArrayList<String> scopes = new ArrayList<String>();
            scopes.add("https://graph.microsoft.com/.default");
            TokenCredentialAuthProvider tokenCredAuthProvider = new TokenCredentialAuthProvider(scopes, (TokenCredential)clientSecretCredential);
            OkHttpClient okhttpClient = HttpClients.createDefault((IAuthenticationProvider)tokenCredAuthProvider).newBuilder().connectTimeout(Duration.ofMinutes(PCHelperConstant.getGraphTimeoutInMins())).readTimeout(Duration.ofMinutes(PCHelperConstant.getGraphTimeoutInMins())).callTimeout(Duration.ofMinutes(PCHelperConstant.getGraphTimeoutInMins())).retryOnConnectionFailure(true).build();
            graphClient = GraphServiceClient.builder().authenticationProvider((IAuthenticationProvider)tokenCredAuthProvider).httpClient((Object)okhttpClient).buildClient();
        }
        return graphClient;
    }
}

