/*
 * Decompiled with CFR 0.152.
 */
package com.pg.service.impl;

import com.pg.element.LocalFileSystemElement;
import com.pg.helper.constant.PCHelperConstant;
import com.pg.httpclient.util.HttpClientUtil;
import com.pg.service.LocalFileSystemService;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import jcifs.smb.NtlmPasswordAuthentication;
import jcifs.smb.SmbFile;
import jcifs.smb.SmbFileOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class LocalFileSystemServiceImpl
implements LocalFileSystemService {
    private static Logger logger = LogManager.getLogger(LocalFileSystemServiceImpl.class);

    @Override
    public void writeFilesToLocalFS(String cloudName, File encryptedFile, String userName) {
        LocalFileSystemElement localFileSystemElement = this.getLocalFSDetailsFromParacloud(cloudName);
        if (localFileSystemElement == null) {
            return;
        }
        String userNameForAuth = localFileSystemElement.getFileServerUserName();
        String passwordForAuth = localFileSystemElement.getFileServerPassword();
        String ipAddress = localFileSystemElement.getFileServerPath();
        String sharedFolder = "Parablu/" + userName;
        String fileName = encryptedFile.getName();
        String path = ipAddress + "/" + sharedFolder;
        logger.debug("user name for auth....." + userNameForAuth + "passwd for auth.....:" + passwordForAuth);
        NtlmPasswordAuthentication auth = new NtlmPasswordAuthentication("", userNameForAuth, passwordForAuth);
        try {
            logger.debug(" PATH TO WRITE LOCAL FS........ :" + path);
            SmbFile smbFile = new SmbFile(path + "/" + fileName, auth);
            SmbFile folderPath = new SmbFile(path, auth);
            if (!folderPath.exists()) {
                folderPath.mkdirs();
            }
            SmbFileOutputStream smbfos = new SmbFileOutputStream(smbFile);
            FileInputStream fileInputStream = new FileInputStream(encryptedFile);
            smbfos.write(IOUtils.toByteArray((InputStream)fileInputStream));
            logger.debug("Local FileSystem write Completed!!!!!");
            smbfos.close();
        }
        catch (Exception e) {
            logger.trace(String.valueOf(e));
            logger.error("Exception While Writting Files to Local FS :" + e.getMessage());
        }
    }

    private LocalFileSystemElement getLocalFSDetailsFromParacloud(String cloudName) {
        HttpComponentsClientHttpRequestFactory reqFactory = HttpClientUtil.getHttpRequestFactory();
        RestTemplate restTemplate = new RestTemplate((ClientHttpRequestFactory)reqFactory);
        ArrayList<MappingJackson2HttpMessageConverter> messageConverters = new ArrayList<MappingJackson2HttpMessageConverter>();
        messageConverters.add(new MappingJackson2HttpMessageConverter());
        restTemplate.setMessageConverters(messageConverters);
        HttpHeaders headers = new HttpHeaders();
        HttpEntity entity = new HttpEntity((Object)"parameters", (MultiValueMap)headers);
        logger.debug("cloud NAME inside get local file fs details IS:" + cloudName);
        String url = PCHelperConstant.getPropertyFileValueForParacloudUrl() + "/paracloud/cloud/" + cloudName + "/get/localfs/details";
        ResponseEntity result = restTemplate.exchange(url, HttpMethod.GET, entity, LocalFileSystemElement.class, new Object[0]);
        return (LocalFileSystemElement)result.getBody();
    }
}

