/*
 * Decompiled with CFR 0.152.
 */
package com.pg.odb.util;

import com.microsoft.graph.http.GraphServiceException;
import com.parablu.pcbd.dao.RetryPolicyDao;
import com.parablu.pcbd.domain.RetryPolicyTable;
import com.pg.helper.constant.PCHelperConstant;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.List;
import net.jodah.failsafe.Failsafe;
import net.jodah.failsafe.Policy;
import net.jodah.failsafe.RetryPolicy;
import net.jodah.failsafe.function.CheckedSupplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RetryPolicyFactory {
    private static Logger logger = LogManager.getLogger(RetryPolicyFactory.class);
    private RetryPolicy<Object> failSafePolicy;
    private RetryPolicyDao retryPolicyDao;

    public RetryPolicy<Object> getFailSafePolicy() {
        RetryPolicyTable policy = this.retryPolicyDao.getRetryPolicy(1, PCHelperConstant.RETRY_POLICY_OPERATION.GRAPHCALLS.toString());
        this.failSafePolicy = (RetryPolicy)((RetryPolicy)new RetryPolicy().handle(GraphServiceException.class)).onRetry(event -> this.handleRetry((GraphServiceException)event.getLastFailure())).onFailure(event -> logger.error("Retries exhausted. Last error: {}", (Object)event.getFailure().getMessage()));
        switch (policy.getBackoffType()) {
            case "NONE": {
                break;
            }
            case "FIXED": {
                this.failSafePolicy.withDelay(Duration.ofSeconds(policy.getDelayInSecs()));
                break;
            }
            case "RANDOM": {
                this.failSafePolicy.withDelay(policy.getRandomMinValInSecs(), policy.getRandomMaxValInSecs(), ChronoUnit.SECONDS);
                break;
            }
            case "EXPONENTIAL": {
                this.failSafePolicy.withBackoff(policy.getDelayInSecs(), policy.getExponentialMaxSleepInSecs(), ChronoUnit.SECONDS, policy.getExponentialFactor());
                break;
            }
            default: {
                this.failSafePolicy.withDelay(policy.getDelayInSecs(), policy.getDelayInSecs(), ChronoUnit.SECONDS);
            }
        }
        if (policy.getMaxDurationInSecs() != 0L) {
            this.failSafePolicy.withMaxDuration(Duration.ofSeconds(policy.getMaxDurationInSecs()));
        }
        if (policy.getMaxRetries() != 0) {
            this.failSafePolicy.withMaxRetries(policy.getMaxRetries());
        }
        if (policy.getJitterInSecs() != 0 && policy.getBackoffType() != BACKOFF_TYPES.RANDOM.toString()) {
            this.failSafePolicy.withJitter(Duration.ofSeconds(policy.getJitterInSecs()));
        }
        this.failSafePolicy.handleResultIf(result -> result instanceof String && result.equals("429"));
        this.failSafePolicy.handle(Exception.class);
        logger.debug("$$PVN.....policyType:" + policy.getPolicyName());
        return this.failSafePolicy;
    }

    private void handleRetry(GraphServiceException exception) {
        int statusCode = exception.getResponseCode();
        if (statusCode == 429) {
            List headers = exception.getResponseHeaders();
            if (headers != null && !headers.isEmpty()) {
                try {
                    int retrySeconds = 60;
                    try {
                        retrySeconds = Integer.parseInt((String)headers.get(0));
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                    logger.warn((String)headers.get(0) + "....Received HTTP 429 Too Many Requests. Retrying after {} seconds...", (Object)retrySeconds);
                    Thread.sleep((long)retrySeconds * 1000L);
                }
                catch (InterruptedException | NumberFormatException e) {
                    logger.error("Failed to parse or sleep for Retry-After: {}", (Object)headers, (Object)e);
                    Thread.currentThread().interrupt();
                }
            } else {
                logger.warn("Received HTTP 429 Too Many Requests, but no Retry-After header. Using default backoff.");
            }
        }
    }

    public <R> R executeWithRetry(CheckedSupplier<R> supplier, RetryPolicy<R> retryPolicy) {
        return (R)Failsafe.with((Policy[])new RetryPolicy[]{retryPolicy}).get(supplier);
    }

    public <R> R executeWithRetry(CheckedSupplier<R> supplier) {
        if (this.failSafePolicy == null) {
            this.getFailSafePolicy();
        }
        return (R)Failsafe.with((Policy[])new RetryPolicy[]{this.failSafePolicy}).get(supplier);
    }

    public RetryPolicyDao getRetryPolicyDao() {
        return this.retryPolicyDao;
    }

    public void setRetryPolicyDao(RetryPolicyDao retryPolicyDao) {
        this.retryPolicyDao = retryPolicyDao;
    }

    static enum BACKOFF_TYPES {
        NONE,
        FIXED,
        RANDOM,
        EXPONENTIAL;

    }
}

