/*
 * Decompiled with CFR 0.152.
 */
package com.pg.odb.util;

import com.parablu.pcbd.dao.UserDao;
import com.parablu.pcbd.domain.User;
import com.pg.odb.util.OneDriveUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

public class LocalDriveUtil {
    public static final int MAX_FILE_COUNT = 10000;
    @Autowired
    private UserDao userDao;
    private static LocalDriveUtil singleton = new LocalDriveUtil();
    private static Logger logger = LogManager.getLogger(OneDriveUtil.class);
    Map<String, Object> userObjectMap = new ConcurrentHashMap<String, Object>();

    private LocalDriveUtil() {
    }

    public static LocalDriveUtil getInstance() {
        return singleton;
    }

    public int getMaxFileCount() {
        return 10000;
    }

    public synchronized String getNextFolderPath(String userName, boolean isSync, String cloudName, String bkpPath, String filePath, int filesInFoldercount) {
        User user = this.userDao.getUserInfoByName(1, cloudName, userName);
        String lastCloudStoragePath = isSync ? user.getCloudSyncStoragePath() : user.getCloudBkpStoragePath();
        String newFolder = "";
        if (this.getFolderPathCount(bkpPath + "/" + userName + "/" + lastCloudStoragePath) >= 10000) {
            ArrayList<Integer> folderNameList = this.splitPathAndGetFolderDepth(lastCloudStoragePath);
            newFolder = this.checkOneDriveStoragePathAndCount(folderNameList, filesInFoldercount);
        } else {
            newFolder = lastCloudStoragePath;
        }
        logger.debug("newfilePath.....change here to filepath new......." + newFolder + "...oldpath...." + (String)filePath + "....." + filesInFoldercount);
        File newPath = new File(bkpPath + "/" + userName + "/" + newFolder);
        if (!newPath.exists()) {
            newPath.mkdirs();
        }
        this.userDao.updateUserStoragePath(1, userName, newFolder, isSync);
        filePath = bkpPath + "/" + userName + "/" + newFolder;
        lastCloudStoragePath = newFolder;
        return lastCloudStoragePath;
    }

    private String checkOneDriveStoragePathAndCount(ArrayList<Integer> folderNameList, int count) {
        int countTemp = count;
        Object cloudStoragePath = "";
        int folderDepthSize = folderNameList.size();
        int folderValue = folderNameList.get(0);
        if (folderDepthSize == 1 && folderValue <= 900) {
            logger.debug("Folder DEpth Size 1 folder value>>>>>>" + folderValue);
            if (countTemp < 10000) {
                cloudStoragePath = String.valueOf(folderValue);
                logger.debug("Folder DEpth Size 1 folder value count less than 500>>>>>>." + countTemp);
            } else if (folderValue < 900) {
                countTemp = 0;
                folderNameList.set(0, folderValue + 1);
                cloudStoragePath = String.valueOf(folderValue + 1);
                logger.debug("count >= MAX_FILE_COUNT ........... " + (String)cloudStoragePath);
            } else if (folderValue >= 900) {
                folderNameList.clear();
                countTemp = 0;
                folderNameList.add(0, 1);
                folderNameList.add(1, 1);
                cloudStoragePath = "1/1";
                logger.debug("folderValue >= 900 ........... " + (String)cloudStoragePath);
            }
            ++countTemp;
        } else {
            int lastFolder = folderNameList.get(folderDepthSize - 1);
            int previousFolder = 0;
            if (folderDepthSize > 1) {
                previousFolder = folderNameList.get(folderDepthSize - 2);
            }
            if (lastFolder <= 900) {
                if (countTemp < 10000) {
                    cloudStoragePath = String.valueOf(previousFolder + "/" + lastFolder);
                    logger.debug("else count < MAX_FILE_COUNT ........... " + (String)cloudStoragePath);
                } else if (lastFolder < 900) {
                    countTemp = 0;
                    folderNameList.set(folderDepthSize - 1, lastFolder + 1);
                    cloudStoragePath = String.valueOf(previousFolder + "/" + ++lastFolder);
                    logger.debug("else count >= MAX_FILE_COUNT ........... " + (String)cloudStoragePath);
                } else if (lastFolder >= 900) {
                    countTemp = 0;
                    folderNameList.set(folderDepthSize - 1, 1);
                    if (folderDepthSize > 1) {
                        folderNameList.set(folderDepthSize - 2, previousFolder + 1);
                    }
                    cloudStoragePath = ++previousFolder + "/1";
                    logger.debug("else lastFolder >= 900 ........... " + (String)cloudStoragePath);
                }
            } else if (lastFolder >= 900) {
                countTemp = 0;
                folderNameList.set(folderDepthSize - 1, 1);
                if (folderDepthSize > 1) {
                    folderNameList.set(folderDepthSize - 2, previousFolder + 1);
                }
                cloudStoragePath = ++previousFolder + "/1";
                logger.debug("else lastFolder >= 900 ........... " + (String)cloudStoragePath);
            }
            ++countTemp;
        }
        logger.debug("10000 max size " + (String)cloudStoragePath + " endo of method ........" + countTemp);
        return cloudStoragePath;
    }

    private ArrayList<Integer> splitPathAndGetFolderDepth(String cloudStoragePath) {
        ArrayList<Integer> pathListNumbers = new ArrayList<Integer>();
        if (!StringUtils.isEmpty((Object)cloudStoragePath)) {
            String[] pathList;
            for (String path : pathList = cloudStoragePath.split("/")) {
                pathListNumbers.add(Integer.parseInt(path));
            }
        }
        return pathListNumbers;
    }

    private int getFolderPathCount(String filePath) {
        int filesInFoldercount = 0;
        File folderPath = new File(filePath);
        if (folderPath.exists()) {
            filesInFoldercount = folderPath.list().length;
        }
        logger.debug("...folderpath and count ..." + filePath + "....count..." + filesInFoldercount);
        return filesInFoldercount;
    }
}

