/*
 * Decompiled with CFR 0.152.
 */
package com.pg.httpclient.util;

import com.pg.helper.constant.PCHelperConstant;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.ssl.DefaultHostnameVerifier;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactory;
import org.apache.hc.core5.http.config.Registry;
import org.apache.hc.core5.http.config.RegistryBuilder;
import org.apache.hc.core5.ssl.SSLContextBuilder;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;

public class HttpClientUtil {
    private static Logger logger = LogManager.getLogger(HttpClientUtil.class);

    private HttpClientUtil() {
    }

    public static CloseableHttpClient getSSlConnection() {
        if (!PCHelperConstant.getPropertyFileValueSslAuthEnabled().isEmpty() && "false".equalsIgnoreCase(PCHelperConstant.getPropertyFileValueSslAuthEnabled())) {
            try {
                SSLContext sslContext = SSLContextBuilder.create().loadTrustMaterial((chain, authType) -> true).build();
                DefaultHostnameVerifier hostnameVerifier = new DefaultHostnameVerifier();
                SSLConnectionSocketFactory sslSocketFactory = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)hostnameVerifier);
                Registry registry = RegistryBuilder.create().register("https", (Object)sslSocketFactory).build();
                PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager(registry);
                connectionManager.setMaxTotal(50);
                connectionManager.setDefaultMaxPerRoute(5);
                connectionManager.setValidateAfterInactivity((TimeValue)Timeout.ofSeconds((long)5L));
                return HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connectionManager).build();
            }
            catch (KeyManagementException e) {
                logger.trace("KeyManagementException: " + String.valueOf(e));
                e.printStackTrace();
            }
            catch (NoSuchAlgorithmException e) {
                logger.trace("NoSuchAlgorithmException: " + String.valueOf(e));
                e.printStackTrace();
            }
            catch (KeyStoreException e) {
                logger.trace("KeyStoreException: " + String.valueOf(e));
                e.printStackTrace();
            }
        } else {
            return HttpClients.createDefault();
        }
        return HttpClients.createDefault();
    }

    public static HttpComponentsClientHttpRequestFactory getHttpRequestFactory() {
        HttpComponentsClientHttpRequestFactory requestFactory = new HttpComponentsClientHttpRequestFactory();
        if (!PCHelperConstant.getPropertyFileValueSslAuthEnabled().isEmpty() && "false".equalsIgnoreCase(PCHelperConstant.getPropertyFileValueSslAuthEnabled())) {
            try {
                SSLContext sslContext = SSLContextBuilder.create().loadTrustMaterial((chain, authType) -> true).build();
                SSLConnectionSocketFactory sslSocketFactory = new SSLConnectionSocketFactory(sslContext, (hostname, session) -> true);
                Registry registry = RegistryBuilder.create().register("https", (Object)sslSocketFactory).build();
                PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager(registry);
                connectionManager.setMaxTotal(50);
                connectionManager.setDefaultMaxPerRoute(5);
                connectionManager.setValidateAfterInactivity((TimeValue)Timeout.ofSeconds((long)5L));
                CloseableHttpClient httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connectionManager).build();
                requestFactory = new HttpComponentsClientHttpRequestFactory((HttpClient)httpClient);
                return requestFactory;
            }
            catch (Exception e) {
                logger.trace("Exception: " + String.valueOf(e));
            }
        }
        return requestFactory;
    }
}

