/*
 * Decompiled with CFR 0.152.
 */
package com.pg.controller;

import com.google.api.client.repackaged.org.apache.commons.codec.binary.Base64;
import com.parablu.helper.clamavhelper.CheckClamAV;
import com.parablu.pcbd.dao.ExternalStorageBackupFileDao;
import com.parablu.pcbd.dao.SyncBackUpImageDAO;
import com.parablu.pcbd.dao.UserDao;
import com.parablu.pcbd.dao.UserSyncOverViewDao;
import com.parablu.pcbd.dao.impl.DeviceDaoImpl;
import com.parablu.pcbd.domain.AuditHistory;
import com.parablu.pcbd.domain.BackUpImage;
import com.parablu.pcbd.domain.ChunkDetail;
import com.parablu.pcbd.domain.ChunkFile;
import com.parablu.pcbd.domain.Cloud;
import com.parablu.pcbd.domain.CloudCustomisableDetails;
import com.parablu.pcbd.domain.ConsolidatedImage;
import com.parablu.pcbd.domain.Device;
import com.parablu.pcbd.domain.FileRevision;
import com.parablu.pcbd.domain.InclusionFilter;
import com.parablu.pcbd.domain.MiniCloud;
import com.parablu.pcbd.domain.RwSampleFileInfo;
import com.parablu.pcbd.domain.SearchIndex;
import com.parablu.pcbd.domain.SyncPolicy;
import com.parablu.pcbd.domain.User;
import com.parablu.pcbd.domain.UserSyncOverView;
import com.pg.controller.BaseController;
import com.pg.dao.SyncFileDao;
import com.pg.domain.BackupFile;
import com.pg.domain.FileInfo;
import com.pg.element.BluKryptElement;
import com.pg.element.ChunkFileElement;
import com.pg.element.SyncFileElement;
import com.pg.helper.constant.GeneralHelperConstant;
import com.pg.helper.constant.PCHelperConstant;
import com.pg.helper.utils.MD5Generator;
import com.pg.httpclient.util.HttpClientUtil;
import com.pg.service.ChunkableUploadService;
import com.pg.service.UploadService;
import com.pg.service.UtilService;
import com.pg.sync.service.SyncUploadService;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFilePermission;
import java.security.MessageDigest;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.zip.GZIPInputStream;
import org.apache.commons.codec.binary.Base64InputStream;
import org.apache.commons.fileupload.MultipartStream;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.entity.mime.MultipartEntityBuilder;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.http.client.ClientProtocolException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bson.types.ObjectId;
import org.json.JSONObject;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.OptimisticLockingFailureException;
import org.springframework.jms.UncategorizedJmsException;
import org.springframework.stereotype.Controller;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class SyncUploadController
extends BaseController {
    private static Logger logger = LogManager.getLogger(SyncUploadController.class);
    @Autowired
    private UploadService uploadService;
    @Autowired
    private UtilService utilService;
    @Autowired
    private ChunkableUploadService chunkableUploadService;
    @Autowired
    private SyncUploadService syncUploadService;
    @Autowired
    private DeviceDaoImpl deviceDaoImpl;
    @Autowired
    private SyncBackUpImageDAO syncBackUpImageDAO;
    @Autowired
    private UserDao userDao;
    @Autowired
    private UserSyncOverViewDao userSyncOverViewDao;
    @Autowired
    private ExternalStorageBackupFileDao externalStorageBackupFileDao;
    @Autowired
    private SyncFileDao syncFileDao;
    private static final String USER_STORAGE_LIMIT_REACHED = " --- User Storage limit reached --- ";
    private static final String AFTER_INSERT_ENTRY_FOR_SYNC = "  After insertEntryForSync ...";
    private static final String UNABLE_TO_GET_BACKUPID_FROM_EBMS = "Unable to get backupid from EBMS .. ";
    private static final String END_OF_ADD_SEARCH_INDEX = " End of Add search index ..........................";
    private static final String ERROR_WHILE_WRITE_CHUNK_FILES = "@@@@ Error while trying to write chunk files  ";
    private static final String END_OF_SAVE_TO_ONE_DRIVE = "End of save to one drive  ";
    private static final String PORTAL = "Portal";
    private static final String CMDLINE = "command line";
    private static final String AV_SCAN_ENABLED = "AV Scan Enabled";
    private static final int FILE_SIZE_4GB = 4000;
    private static final String PARABLU_GROUP = "parablu";

    public void setSyncFileDao(SyncFileDao syncFileDao) {
        this.syncFileDao = syncFileDao;
    }

    @RequestMapping(value={"/cloud/{cloudName}/sync/cmd/new/upload/file/"}, method={RequestMethod.POST})
    public ModelAndView uploadFileCommandLine(HttpServletRequest request, HttpServletResponse httpResponse) {
        logger.debug("@@@Inside sync file upload from cmd line....  ");
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        try {
            String userName = request.getHeader("userName");
            String cloudName = request.getHeader("cloudName");
            userName = this.encodeBase64UTFString(userName);
            logger.debug("encoded userName={}", (Object)userName);
            MultipartHttpServletRequest multipartHttpServletRequest = (MultipartHttpServletRequest)request;
            MultipartFile file = multipartHttpServletRequest.getFile("file");
            logger.debug("file name to be uploaded in server={}", (Object)file.getOriginalFilename());
            String pathName = PCHelperConstant.getPropertyFileValueParacloudMountPoint() + cloudName + "/sync-upload/Portal/" + userName + GeneralHelperConstant.CLOUD_PATH_SEPARATOR;
            logger.debug("pathName where file is being saved={}", (Object)pathName);
            File directory = new File(pathName);
            if (!directory.exists()) {
                directory.mkdirs();
                Path path = Paths.get(pathName, new String[0]);
                Files.setPosixFilePermissions(path, Files.getPosixFilePermissions(path, new LinkOption[0]));
                Files.setOwner(path, Files.getOwner(path, new LinkOption[0]));
                Files.getFileAttributeView(path, PosixFileAttributeView.class, new LinkOption[0]).setGroup(FileSystems.getDefault().getUserPrincipalLookupService().lookupPrincipalByGroupName(PARABLU_GROUP));
                HashSet<PosixFilePermission> permissions = new HashSet<PosixFilePermission>();
                permissions.add(PosixFilePermission.OWNER_READ);
                permissions.add(PosixFilePermission.OWNER_WRITE);
                permissions.add(PosixFilePermission.OWNER_EXECUTE);
                permissions.add(PosixFilePermission.GROUP_READ);
                permissions.add(PosixFilePermission.GROUP_WRITE);
                permissions.add(PosixFilePermission.GROUP_EXECUTE);
                permissions.add(PosixFilePermission.OTHERS_READ);
                permissions.add(PosixFilePermission.OTHERS_EXECUTE);
                Files.setPosixFilePermissions(path, permissions);
            }
            InputStream inputStream = file.getInputStream();
            byte[] data = new byte[inputStream.available()];
            inputStream.read(data);
            FileOutputStream outputStream = new FileOutputStream(pathName + "/" + file.getOriginalFilename());
            outputStream.write(data);
            outputStream.flush();
            outputStream.close();
            httpResponse.setStatus(202);
            modelAndView.addObject("status", (Object)true);
            return modelAndView;
        }
        catch (Exception e) {
            logger.error("error while uploading a file to server from command line={}", (Throwable)e);
            httpResponse.setStatus(400);
            modelAndView.addObject("status", (Object)false);
            return modelAndView;
        }
    }

    @RequestMapping(value={"/sync/upload/file/"}, method={RequestMethod.POST})
    public void uploadFileLatest(HttpServletRequest request, HttpServletResponse httpResponse) {
        logger.debug("@@@Inside sync file upload ....  ");
        try {
            BluKryptElement bluKryptElement = this.getBluKryptElementValues(request);
            logger.debug("@@@before calling check machine storage......");
            String fileSizeInString = request.getParameter("file-size");
            boolean isMachineStorageReached = this.checkMachineStorage(fileSizeInString);
            if (isMachineStorageReached) {
                httpResponse.setStatus(507);
                logger.error(bluKryptElement.getUserName() + USER_STORAGE_LIMIT_REACHED);
                return;
            }
            int cloudId = 1;
            Cloud cloud = this.utilService.getCloud(cloudId);
            boolean isSearchEnabled = false;
            if (cloud.getContentSearchEnabled() == 1) {
                SyncPolicy syncPolicy = this.syncUploadService.getSyncPolicyForUser(cloudId, bluKryptElement.getUserName());
                boolean isFileAllowed = SyncUploadController.checkForExtensions(bluKryptElement.getFileName(), syncPolicy.getSearchInclusionFilter(), syncPolicy.getSearchFilterType());
                if (syncPolicy.isContentIndexEnabled() && isFileAllowed) {
                    isSearchEnabled = true;
                }
            }
            MultipartHttpServletRequest multipartHttpServletRequest = (MultipartHttpServletRequest)request;
            MultipartFile file = multipartHttpServletRequest.getFile("file");
            InputStream inputStream = file.getInputStream();
            String checkSum = request.getParameter("fileMD5");
            ChunkFileElement chunkFileElement = new ChunkFileElement();
            ArrayList<String> list = new ArrayList<String>();
            list.add(checkSum);
            chunkFileElement.setFileChunks(list);
            chunkFileElement.setFileCompletePath(bluKryptElement.getFileCompletePath());
            chunkFileElement.setFileName(checkSum);
            chunkFileElement.setMd5checksum(checkSum);
            chunkFileElement.setDeviceUUID(bluKryptElement.getDeviceUUID());
            String fsPath = SyncUploadController.getFsPath(checkSum);
            String indexPath = null;
            if (isSearchEnabled) {
                indexPath = SyncUploadController.getPropertyFileValueParabluFolderBasePath(bluKryptElement.getCloudName()) + "ParaBlu" + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + fsPath;
            }
            this.uploadFile(bluKryptElement, inputStream, chunkFileElement, indexPath, null);
            httpResponse.setStatus(200);
            if (CollectionUtils.isEmpty(list)) {
                list.add(checkSum);
            }
            logger.debug("  Before insertEntryForSync ..." + bluKryptElement.getFilePath());
            boolean isfileInfected = false;
            FileRevision revision = this.insertEntryForSync(cloudId, request, bluKryptElement, isfileInfected);
            String syncRevisionId = revision.getId().toString();
            ConsolidatedImage consolidatedImage = revision.getConsolidatedImage();
            String consolidatedImageId = consolidatedImage.getId().toString();
            logger.debug(consolidatedImageId + AFTER_INSERT_ENTRY_FOR_SYNC + syncRevisionId);
            if (syncRevisionId != null) {
                FileInfo fileInfo = this.getFileInfo(bluKryptElement, syncRevisionId, list);
                fileInfo.setSize(bluKryptElement.getFileSize());
                fileInfo.setMd5(checkSum);
                boolean uploadSuccess = this.uploadService.saveFileInfoForSync(bluKryptElement.getCloudName(), bluKryptElement.getGatewayName(), fileInfo);
                if (!uploadSuccess) {
                    this.uploadService.removeSyncFile(cloudId, syncRevisionId, consolidatedImageId);
                    logger.error(UNABLE_TO_GET_BACKUPID_FROM_EBMS);
                    httpResponse.setStatus(500);
                } else {
                    httpResponse.setStatus(200);
                }
            } else {
                logger.error(UNABLE_TO_GET_BACKUPID_FROM_EBMS);
                httpResponse.setStatus(500);
            }
            if (isSearchEnabled) {
                SearchIndex index = this.formSearchIndex(1, bluKryptElement, consolidatedImage.getId(), consolidatedImage.isMiniCloud(), fsPath);
                this.utilService.addFileToTable(index, bluKryptElement.getCloudName());
                logger.debug(END_OF_ADD_SEARCH_INDEX);
            }
            this.closeInputStreamIfExists(request);
        }
        catch (Exception e) {
            httpResponse.setStatus(500);
            logger.error(ERROR_WHILE_WRITE_CHUNK_FILES + e.getMessage());
            logger.trace(String.valueOf(e));
        }
        logger.debug(END_OF_SAVE_TO_ONE_DRIVE);
    }

    private static boolean checkForExtensions(String fileName, List<InclusionFilter> inclusionFilters, String filterType) {
        logger.debug("..... check for ext&^&^&...." + fileName);
        boolean allow = false;
        if (CollectionUtils.isEmpty(inclusionFilters)) {
            return true;
        }
        HashSet<String> filterExclusionExtensions = new HashSet<String>();
        HashSet<String> filterInclusionExtensions = new HashSet<String>();
        HashSet<String> defaultFilterExclusionExtensions = new HashSet<String>();
        if (!StringUtils.isEmpty((String)PCHelperConstant.getSearchExclusionExtName())) {
            String[] extensions;
            for (String ext : extensions = PCHelperConstant.getSearchExclusionExtName().split(",")) {
                ext = ext.toLowerCase();
                logger.debug("....default exclusion ..." + ext);
                defaultFilterExclusionExtensions.add(ext);
            }
        }
        for (InclusionFilter inclusionFilter : inclusionFilters) {
            String[] extensions;
            if (inclusionFilter == null) continue;
            if (filterType.equalsIgnoreCase("exclusion")) {
                for (String ext : extensions = inclusionFilter.getExtensionName().split(",")) {
                    ext = ext.toLowerCase();
                    logger.debug("....filterExclusionExtensions  ..." + ext);
                    filterExclusionExtensions.add(ext);
                }
                continue;
            }
            for (String ext : extensions = inclusionFilter.getExtensionName().split(",")) {
                ext = ext.toLowerCase();
                logger.debug("....filterInclusionExtensions  ..." + ext);
                filterInclusionExtensions.add(ext);
            }
        }
        if (defaultFilterExclusionExtensions.size() > 0 && defaultFilterExclusionExtensions.contains(FilenameUtils.getExtension((String)fileName.toLowerCase()))) {
            logger.error("... ext added in default exclusion list...");
            return false;
        }
        boolean allowAllextensions = filterInclusionExtensions.contains("all");
        if (allowAllextensions) {
            logger.debug("... allowAllextensions...");
            return true;
        }
        if (filterExclusionExtensions.size() > 0 && !filterExclusionExtensions.contains(FilenameUtils.getExtension((String)fileName.toLowerCase()))) {
            allow = true;
            logger.debug("... filterExclusionExtensions true...");
        } else if (filterInclusionExtensions.size() > 0 && filterInclusionExtensions.contains(FilenameUtils.getExtension((String)fileName.toLowerCase()))) {
            logger.debug("... filterInclusionExtensions true...");
            allow = true;
        }
        return allow;
    }

    private void uploadFile(BluKryptElement bluKryptElement, InputStream inputStream, ChunkFileElement chunkFileElement, String indexPath, String batchId) {
        this.chunkableUploadService.uploadChunkableFileForSync(bluKryptElement, inputStream, chunkFileElement, indexPath, batchId);
    }

    private Map<String, String> uploadFileUsingPortal(String cloudName, BluKryptElement bluKryptElement, InputStream inputStream, ChunkFileElement chunkFileElement, String indexPath, String fileTmpPath) throws InterruptedException {
        return this.chunkableUploadService.uploadChunkableFileForSyncPortal(cloudName, bluKryptElement, inputStream, chunkFileElement, true, indexPath, fileTmpPath);
    }

    private String checkNWThrottleAndUploadFileForChunks(BluKryptElement bluKryptElement, InputStream inputStream, ChunkFileElement chunkFileElement, String backupId, String nextChunkFileName) throws InterruptedException {
        String nextChunkFileNameTemp = nextChunkFileName;
        if (StringUtils.isEmpty((String)backupId)) {
            nextChunkFileNameTemp = this.chunkableUploadService.uploadChunkableFileForSync(bluKryptElement, inputStream, chunkFileElement, null, null);
        }
        return nextChunkFileNameTemp;
    }

    @RequestMapping(value={"/sync/upload/file/chunks/"}, method={RequestMethod.POST})
    public void uploadFileChunks(HttpServletRequest request, HttpServletResponse httpResponse) {
        try {
            logger.debug("Entering uploadFileChunks ......  ");
            BluKryptElement bluKryptElement = this.getBluKryptElementValues(request);
            MultipartHttpServletRequest multipartHttpServletRequest = (MultipartHttpServletRequest)request;
            InputStream inputStream = null;
            try {
                MultipartFile file = multipartHttpServletRequest.getFile("file");
                inputStream = file.getInputStream();
            }
            catch (IOException e) {
                logger.error("Error trying to get inpustream " + e.getMessage());
                logger.trace(String.valueOf(e));
            }
            ChunkFileElement chunkFileElement = this.getChunkFileElementFromRequestHeader(request);
            String backupId = request.getParameter("backupId");
            String originalFileName = request.getParameter("originalFileName");
            bluKryptElement.setFileName(originalFileName);
            String nextChunkFileName = "-1";
            String fileSizeInString = request.getParameter("file-size");
            boolean isMachineStorageReached = this.checkMachineStorage(fileSizeInString);
            if (isMachineStorageReached) {
                httpResponse.setStatus(507);
                logger.error(bluKryptElement.getUserName() + USER_STORAGE_LIMIT_REACHED);
                return;
            }
            nextChunkFileName = this.checkNWThrottleAndUploadFileForChunks(bluKryptElement, inputStream, chunkFileElement, backupId, nextChunkFileName);
            logger.debug(" NEXT CHUNK file name  ...." + nextChunkFileName);
            boolean isfileInfected = false;
            if ("-1".equals(nextChunkFileName)) {
                this.uploadFileExternalStorage(request, httpResponse, isfileInfected);
            }
            httpResponse.setHeader("nextChunk", nextChunkFileName);
            httpResponse.setStatus(200);
            this.closeInputStreamIfExists(request);
        }
        catch (Exception e) {
            httpResponse.setStatus(500);
            logger.trace(String.valueOf(e));
            logger.error(ERROR_WHILE_WRITE_CHUNK_FILES + String.valueOf(e));
        }
        logger.debug("@@@@ End of Uploading all chunks file drive  ");
    }

    public void uploadFileExternalStorage(HttpServletRequest request, HttpServletResponse httpResponse, boolean isfileInfected) {
        logger.debug("Entering uploadFileChunks ......  ");
        try {
            BluKryptElement bluKryptElement = this.getBluKryptElementValues(request);
            String fileChunkNames = request.getParameter("fileChunkNames");
            ArrayList<String> list = new ArrayList<String>(Arrays.asList(fileChunkNames.split(",")));
            logger.debug("check machine storage info..........................");
            String fileSizeInString = request.getParameter("file-size");
            boolean isMachineStorageReached = this.checkMachineStorage(fileSizeInString);
            if (isMachineStorageReached) {
                httpResponse.setStatus(507);
                logger.error(bluKryptElement.getUserName() + USER_STORAGE_LIMIT_REACHED);
                return;
            }
            boolean isUserStorageLimitReached = this.checkIfUserStorageLimitReached(request, bluKryptElement.getCloudName(), bluKryptElement.getUserName());
            if (isUserStorageLimitReached) {
                httpResponse.setStatus(449);
                logger.error(bluKryptElement.getUserName() + USER_STORAGE_LIMIT_REACHED);
                return;
            }
            int cloudId = 1;
            FileRevision revision = this.insertEntryForSync(cloudId, request, bluKryptElement, isfileInfected);
            String newSyncId = revision.getId().toString();
            if (newSyncId != null) {
                boolean uploadSuccess;
                String sizeString;
                FileInfo fileInfo = this.getFileInfo(bluKryptElement, newSyncId, list);
                String md5 = request.getParameter("fileMD5");
                if (!StringUtils.isEmpty((String)md5)) {
                    fileInfo.setMd5(md5);
                }
                if (!StringUtils.isEmpty((String)(sizeString = request.getParameter("file-size")))) {
                    long fileSize = Long.parseLong(sizeString);
                    fileInfo.setSize(Long.valueOf(fileSize));
                }
                if (!(uploadSuccess = this.uploadService.saveFileInfoForSync(bluKryptElement.getCloudName(), bluKryptElement.getGatewayName(), fileInfo))) {
                    this.uploadService.removeSyncFile(cloudId, newSyncId, revision.getConsolidatedImage().getId().toString());
                    logger.error(UNABLE_TO_GET_BACKUPID_FROM_EBMS);
                    httpResponse.setStatus(500);
                } else {
                    httpResponse.setStatus(200);
                }
            } else {
                httpResponse.setStatus(500);
            }
            logger.debug("@@@@ End of upload files to one drive  ");
        }
        catch (Exception e) {
            httpResponse.setStatus(500);
            logger.trace(String.valueOf(e));
            logger.error(ERROR_WHILE_WRITE_CHUNK_FILES + e.getMessage());
        }
    }

    private boolean checkMachineStorage(String fileSizeInString) {
        File file = new File(PCHelperConstant.getPropertyFileValueParacloudMountPoint());
        long incomingFileSize = 0L;
        if (!StringUtils.isEmpty((String)fileSizeInString)) {
            incomingFileSize = Long.valueOf(fileSizeInString);
        }
        long availableSpaceInServer = file.getFreeSpace();
        logger.debug("Total space for this machine.." + file.getTotalSpace() + "FREE_SIZE" + file.getFreeSpace() + "incoming File Size:" + incomingFileSize);
        if (availableSpaceInServer - incomingFileSize <= 0L) {
            logger.debug("Space in server is exceeded........");
            return true;
        }
        return false;
    }

    private boolean checkMachineStorageForPortalSync(BluKryptElement bluKryptElement) {
        File file = new File(PCHelperConstant.getPropertyFileValueParacloudMountPoint());
        long incomingFileSize = bluKryptElement.getFileSize();
        long availableSpaceInServer = file.getFreeSpace();
        logger.debug("Total space for this machine --- " + file.getTotalSpace() + " --- FREE_SIZE --- " + file.getFreeSpace() + " --- Incoming File Size : " + incomingFileSize);
        if (availableSpaceInServer - incomingFileSize <= 0L) {
            logger.debug("--- Space in server has exceeded ---");
            return true;
        }
        return false;
    }

    @RequestMapping(value={"/sync/ping/"}, method={RequestMethod.GET})
    public void pingCloud(HttpServletRequest request, HttpServletResponse response) {
        logger.debug("Entering Privacy Gateway ping  ");
        response.setStatus(200);
    }

    @RequestMapping(value={"/sync/delete/file"}, method={RequestMethod.GET})
    public void deleteFile(HttpServletRequest request, HttpServletResponse response) {
        logger.debug("Entering /sync/delete/file   ");
        try {
            String cloudName = request.getParameter("cloudName");
            String userName = request.getParameter("userName");
            String gatewayName = request.getParameter("gatewayName");
            String backupId = request.getParameter("backupId");
            if (StringUtils.isEmpty((String)backupId)) {
                response.setStatus(400);
                return;
            }
            BackupFile backupFile = this.uploadService.getBackupFile(userName, cloudName, backupId, gatewayName);
            if (backupFile == null) {
                response.setStatus(400);
                return;
            }
            this.uploadService.deleteBackupFile(userName, cloudName, backupId, gatewayName);
            response.setStatus(200);
        }
        catch (Exception e) {
            response.setStatus(500);
            logger.error("@@@@ Error while trying to delete files  " + String.valueOf(e));
        }
    }

    @RequestMapping(value={"/cloud/{cloudName}/sync/portal/upload/cancel/"}, method={RequestMethod.POST})
    public void cancelFileLatest(@PathVariable(value="cloudName") String cloudName, HttpServletRequest request, HttpServletResponse httpResponse) {
        logger.debug("Inside portal/sync cancel file upload ....  " + request.getHeader("is-folder"));
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        try {
            BluKryptElement bluKryptElement = this.getBluKryptElementValues(request);
            bluKryptElement.setDeviceUUID(PORTAL);
            bluKryptElement.setOsType("Windows");
            logger.debug("before canceling upload......");
            boolean isSpecialCharsInFileName = false;
            char[] cArray = "/*\":<>".toCharArray();
            int n = cArray.length;
            for (int i = 0; i < n; ++i) {
                Character c = Character.valueOf(cArray[i]);
                if (!bluKryptElement.getFileName().contains(c.toString())) continue;
                isSpecialCharsInFileName = true;
                break;
            }
            if (isSpecialCharsInFileName) {
                logger.debug(" File name contains special characters .... ");
                httpResponse.setStatus(406);
                return;
            }
            String checkSum = request.getHeader("fileMD5");
            ChunkFileElement chunkFileElement = new ChunkFileElement();
            ArrayList<String> list = new ArrayList<String>();
            list.add(checkSum);
            chunkFileElement.setFileChunks(list);
            chunkFileElement.setFileCompletePath(bluKryptElement.getFileCompletePath());
            chunkFileElement.setFileName(checkSum);
            chunkFileElement.setMd5checksum(checkSum);
            chunkFileElement.setDeviceUUID(bluKryptElement.getDeviceUUID());
            String fsPath = SyncUploadController.getFsPath(checkSum);
            bluKryptElement.setCloudName(cloudName);
            String indexPath = SyncUploadController.getPropertyFileValueParabluFolderBasePath(cloudName) + "ParaBlu" + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + fsPath;
            boolean success = this.chunkableUploadService.cancelSyncFileUpload(cloudName, bluKryptElement, chunkFileElement, indexPath);
            if (success) {
                httpResponse.setStatus(200);
            } else {
                httpResponse.setStatus(507);
            }
        }
        catch (Exception e) {
            httpResponse.setStatus(500);
            logger.trace(String.valueOf(e));
            logger.error("@@@@ Error canceling file upload  " + e.getMessage());
        }
        logger.debug("End of canceling file upload ");
    }

    private FileRevision insertEntryForSync(int cloudId, Map<String, String> headerMap, BluKryptElement bluKryptElement, Cloud cloud, boolean isfileInfected) {
        SyncFileElement syncFileElement = new SyncFileElement();
        syncFileElement.setFileName(headerMap.get("file-name"));
        syncFileElement.setMetaData(headerMap.get("meta-data"));
        syncFileElement.setFileCompletePath(headerMap.get("file-path"));
        String compressionStatus = headerMap.get("isCompressed");
        boolean isCompressed = false;
        if (!StringUtils.isEmpty((String)compressionStatus)) {
            isCompressed = Boolean.parseBoolean(compressionStatus);
        }
        syncFileElement.setExists(Boolean.valueOf(headerMap.get("is-exists")).booleanValue());
        syncFileElement.setFolder(Boolean.valueOf(headerMap.get("is-folder")).booleanValue());
        syncFileElement.setMd5checksum(headerMap.get("fileMD5"));
        syncFileElement.setSize(headerMap.get("file-size"));
        String fileModifiedTimestamp = headerMap.get("modified");
        syncFileElement.setLastModifiedTimestamp(Long.valueOf(fileModifiedTimestamp).longValue());
        syncFileElement.setUserName(bluKryptElement.getUserName());
        syncFileElement.setGatewayName(bluKryptElement.getGatewayName());
        int miniCloudId = 0;
        String deviceUUID = headerMap.get("deviceUUID");
        FileRevision revision = null;
        try {
            revision = this.syncUploadService.insertSyncEntryForFile(cloudId, bluKryptElement.getCloudName(), cloud, syncFileElement, miniCloudId, deviceUUID, isCompressed, isfileInfected);
        }
        catch (Exception e) {
            logger.trace(String.valueOf(e));
            logger.error("Exception While Inserting Entry For Sync :" + e.getMessage());
        }
        return revision;
    }

    private FileRevision insertEntryForSync(int cloudId, HttpServletRequest request, BluKryptElement bluKryptElement, boolean isFileInfected) {
        SyncFileElement syncFileElement = new SyncFileElement();
        syncFileElement.setFileName(request.getParameter("file-name"));
        syncFileElement.setMetaData(request.getParameter("meta-data"));
        syncFileElement.setFileCompletePath(request.getParameter("file-path"));
        syncFileElement.setExists(Boolean.valueOf(request.getParameter("is-exists")).booleanValue());
        syncFileElement.setFolder(Boolean.valueOf(request.getParameter("is-folder")).booleanValue());
        syncFileElement.setMd5checksum(request.getParameter("fileMD5"));
        syncFileElement.setSize(request.getParameter("file-size"));
        String fileModifiedTimestamp = request.getParameter("modified");
        syncFileElement.setLastModifiedTimestamp(Long.valueOf(fileModifiedTimestamp).longValue());
        syncFileElement.setUserName(bluKryptElement.getUserName());
        int miniCloudId = 0;
        String deviceUUID = request.getParameter("deviceUUID");
        Cloud cloud = this.utilService.getCloud(cloudId);
        FileRevision revision = null;
        boolean isCompressed = false;
        try {
            revision = this.syncUploadService.insertSyncEntryForFile(cloudId, bluKryptElement.getCloudName(), cloud, syncFileElement, miniCloudId, deviceUUID, isCompressed, isFileInfected);
        }
        catch (Exception e) {
            logger.trace(String.valueOf(e));
            logger.error("Exception While Inserting Entry For Sync ::" + e.getMessage());
        }
        return revision;
    }

    private String insertEntryForSyncUsingHeaderVals(HttpServletRequest request, Cloud cloud, String md5, BluKryptElement bluKryptElement, String encodedFileName, String encodedFilePath, boolean isFileInfected, User user, MiniCloud miniCloud) {
        String parentFilePathTemp;
        String deviceUUID;
        BackUpImage backUpImageNew = new BackUpImage();
        long currentTime = System.currentTimeMillis();
        Object syncRevisionId = null;
        String status = PCHelperConstant.REVISION_STATUS.ADDED.toString();
        boolean isPathInsideMC = this.isPathInsideMC(cloud.getCloudId(), bluKryptElement.getFileCompletePath());
        String userNameVal = bluKryptElement.getUserName();
        if (isPathInsideMC) {
            userNameVal = "";
        }
        if (PORTAL.equals(deviceUUID = request.getParameter("deviceUUID"))) {
            deviceUUID = "0000000000";
        }
        String devicePath = parentFilePathTemp = bluKryptElement.getFileCompletePath();
        if (parentFilePathTemp.endsWith("/")) {
            int lastIndex = parentFilePathTemp.lastIndexOf(47);
            devicePath = parentFilePathTemp.substring(0, lastIndex);
        }
        bluKryptElement.setFileCompletePath(devicePath);
        logger.debug(isPathInsideMC + "--- Complete path and filename --- " + bluKryptElement.getFileCompletePath() + " --- " + bluKryptElement.getFileName());
        backUpImageNew.setFileName(bluKryptElement.getFileName());
        backUpImageNew.setDevicePath(devicePath);
        backUpImageNew.setPresent(true);
        backUpImageNew.setSizeInBytes(bluKryptElement.getFileSize().longValue());
        backUpImageNew.setSize(this.getSizeInKb(bluKryptElement.getFileSize()));
        backUpImageNew.setCrawlStartTimestamp(currentTime);
        backUpImageNew.setLastServerModifiedTime(currentTime);
        backUpImageNew.setMd5Checksum(md5);
        backUpImageNew.setFolder(Boolean.parseBoolean(request.getParameter("is-folder")));
        logger.debug("--- Backup Image New Device UUID --- " + deviceUUID);
        backUpImageNew.setDeviceUUID(PORTAL);
        backUpImageNew.setFileInfected(isFileInfected);
        backUpImageNew.setGatewayName(bluKryptElement.getGatewayName());
        backUpImageNew.setSync(true);
        BackUpImage backUpImage = this.syncBackUpImageDAO.getBackUpImageDBRecordByDevicePath(cloud.getCloudId(), userNameVal, cloud.getCloudName(), bluKryptElement.getFileCompletePath(), bluKryptElement.getFileName(), user, miniCloud);
        double storageUtilized = 0.0;
        if (backUpImage != null) {
            if (backUpImage.isPresent()) {
                if (backUpImage.getMd5Checksum().equalsIgnoreCase(backUpImageNew.getMd5Checksum())) {
                    return "DEDUPED_FILE-" + isPathInsideMC;
                }
                status = PCHelperConstant.REVISION_STATUS.MODIFIED.toString();
                logger.debug("--- BackUpFile already exists and is present, setting status to MODIFIED ---");
            }
            try {
                File fileObj = new File(bluKryptElement.getFileCompletePath());
                BackUpImage folderImage = null;
                String[] paths = bluKryptElement.getFileCompletePath().split(File.separator.equals("\\") ? "\\\\" : "/");
                Object currentPath = "";
                for (String path : paths) {
                    if (StringUtils.isEmpty((String)currentPath)) {
                        currentPath = path;
                    } else {
                        folderImage = this.syncBackUpImageDAO.getExistingBackUpImageDBRecordByDevicePathForFolderLatest(cloud.getCloudId(), userNameVal, cloud.getCloudName(), (String)currentPath, path, user, miniCloud);
                        if (folderImage != null && !folderImage.isPresent()) {
                            logger.debug("--- Folder exists but is deleted --- " + folderImage.isPresent());
                            this.syncBackUpImageDAO.updateDeletedFolder(cloud.getCloudId(), folderImage.getId(), user, miniCloud);
                        }
                        currentPath = (String)currentPath + "/" + path;
                    }
                    logger.debug("--- Current path --- " + (String)currentPath);
                }
            }
            catch (Exception e) {
                logger.error("--- Exception while trying to restore deleted folders --- " + e.getMessage());
            }
            backUpImageNew.setStatus(status);
            this.handleVersioning(cloud, backUpImageNew, bluKryptElement.getUserName(), userNameVal, user, miniCloud);
        } else {
            backUpImageNew.setStatus(status);
        }
        logger.debug("--- Updating storage for sync user --- " + String.valueOf(user));
        long fileSizeInKB = (long)Math.ceil((double)bluKryptElement.getFileSize().longValue() / 1024.0);
        if (user != null) {
            UserSyncOverView userSyncOverView = user.getUserSyncOverView();
            logger.debug("--- Updating storage for sync user --- " + String.valueOf(userSyncOverView));
            if (userSyncOverView != null) {
                storageUtilized = userSyncOverView.getStorageUtilized();
                storageUtilized += (double)fileSizeInKB;
            } else {
                userSyncOverView = new UserSyncOverView();
                storageUtilized = fileSizeInKB;
            }
            userSyncOverView.setStorageUtilized(storageUtilized);
            this.userSyncOverViewDao.saveUserSyncOverViewToDB(cloud.getCloudId(), userSyncOverView);
        }
        backUpImageNew.setUserName(bluKryptElement.getUserName());
        File fileObj = new File(bluKryptElement.getFileCompletePath());
        BackUpImage folderPath = this.syncBackUpImageDAO.getExistingBackUpImageDBRecordByDevicePathForFolder(cloud.getCloudId(), userNameVal, cloud.getCloudName(), fileObj.getParent(), fileObj.getName(), user, miniCloud);
        logger.debug("--- Parent and file name --- " + fileObj.getParent() + " --- " + fileObj.getName());
        if (folderPath == null) {
            String[] paths = bluKryptElement.getFileCompletePath().split(File.separator.equals("\\") ? "\\\\" : "/");
            Object currentPath = "";
            for (String path : paths) {
                if (StringUtils.isEmpty((String)currentPath)) {
                    currentPath = path;
                } else {
                    folderPath = this.syncBackUpImageDAO.getExistingBackUpImageDBRecordByDevicePathForFolder(cloud.getCloudId(), userNameVal, cloud.getCloudName(), (String)currentPath, path, user, miniCloud);
                    if (folderPath == null) {
                        BackUpImage folderImage = new BackUpImage();
                        BeanUtils.copyProperties((Object)backUpImageNew, (Object)folderImage);
                        folderImage.setFolder(true);
                        folderImage.setDevicePath((String)currentPath);
                        folderImage.setFileName(path);
                        folderImage.setStatus(PCHelperConstant.REVISION_STATUS.ADDED.toString());
                        this.syncBackUpImageDAO.saveToBackUpImageDB(cloud.getCloudId(), folderImage, user, miniCloud);
                    }
                    currentPath = (String)currentPath + "/" + path;
                }
                logger.debug("--- Current path --- " + (String)currentPath);
            }
        }
        this.syncBackUpImageDAO.saveToBackUpImageDB(cloud.getCloudId(), backUpImageNew, user, miniCloud);
        this.updateModifiedTimeStamp(cloud.getCloudId(), bluKryptElement.getUserName(), cloud.getCloudName(), bluKryptElement.getFileCompletePath(), currentTime, user, miniCloud, isPathInsideMC);
        return backUpImageNew.getId().toString() + "-" + isPathInsideMC;
    }

    private void handleVersioning(Cloud cloud, BackUpImage backUpImage, String userName, String userNameVal, User user, MiniCloud miniCloud) {
        SyncPolicy syncPolicy;
        logger.debug("--- Inside handle versioning for sync backup image ---");
        if (cloud.getVersioningEnabled() == 0) {
            return;
        }
        int maxVersionsAllowed = 0;
        User userByName = this.userDao.getUserByName(cloud.getCloudId(), userName);
        if (userByName != null && !StringUtils.isEmpty((String)userByName.getSyncPolicyName()) && (syncPolicy = this.userDao.getSyncPolicyByPolicyName(cloud.getCloudId(), userByName.getSyncPolicyName())) != null) {
            maxVersionsAllowed = syncPolicy.getMaxVersions();
        }
        if (maxVersionsAllowed == 0 || maxVersionsAllowed == -1) {
            return;
        }
        long versionCount = this.syncBackUpImageDAO.getCountOfVersionsForFile(cloud.getCloudId(), backUpImage, user, miniCloud);
        if (versionCount < (long)maxVersionsAllowed) {
            return;
        }
        List backUpImagesList = this.syncBackUpImageDAO.getVersions(cloud.getCloudId(), cloud.getCloudName(), userNameVal, backUpImage.getFileName(), backUpImage.getDevicePath(), user, miniCloud);
        List backUpImagesSorted = backUpImagesList.stream().sorted(Comparator.comparing(BackUpImage::getLastServerModifiedTime)).collect(Collectors.toList());
        for (BackUpImage sortedBackUpImage : backUpImagesSorted) {
            logger.debug("BackUpImage : " + String.valueOf(sortedBackUpImage.getId()) + " status : " + sortedBackUpImage.getStatus() + " current number of versions : " + versionCount);
            if ((long)maxVersionsAllowed > versionCount && maxVersionsAllowed != 0) {
                if (!sortedBackUpImage.getStatus().equalsIgnoreCase("DELETED") && !sortedBackUpImage.getStatus().equalsIgnoreCase("RESTORED")) break;
                this.removeSyncBackUpImage(sortedBackUpImage, cloud.getCloudId(), cloud.getCloudName(), user, miniCloud);
            }
            if (sortedBackUpImage.isBusy()) {
                logger.debug("BackUpImage is busy, will not delete : " + String.valueOf(sortedBackUpImage.getId()));
                continue;
            }
            if (!sortedBackUpImage.getStatus().equalsIgnoreCase("DELETED") && !sortedBackUpImage.getStatus().equalsIgnoreCase("RESTORED")) {
                UserSyncOverView userSyncOverView;
                this.removeSyncBackUpImage(sortedBackUpImage, cloud.getCloudId(), cloud.getCloudName(), user, miniCloud);
                --versionCount;
                if (user == null || (userSyncOverView = user.getUserSyncOverView()) == null) continue;
                double storageUtilized = userSyncOverView.getStorageUtilized();
                userSyncOverView.setStorageUtilized(storageUtilized -= (double)backUpImage.getSize());
                this.userSyncOverViewDao.saveUserSyncOverViewToDB(cloud.getCloudId(), userSyncOverView);
                continue;
            }
            this.removeSyncBackUpImage(sortedBackUpImage, cloud.getCloudId(), cloud.getCloudName(), user, miniCloud);
        }
    }

    private void removeSyncBackUpImage(BackUpImage backUpImage, int cloudId, String cloudName, User user, MiniCloud miniCloud) {
        this.syncBackUpImageDAO.deleteBackUpImageRevision(cloudId, backUpImage, user, miniCloud);
        if (!backUpImage.getStatus().equalsIgnoreCase("DELETED") && !backUpImage.getStatus().equalsIgnoreCase("RESTORED")) {
            List chunkFiles = backUpImage.getChunkFiles();
            for (ChunkFile chunkFile : chunkFiles) {
                String dedupVal = this.getDedupValue(backUpImage.getUserName());
                ChunkDetail chunkDetail = null;
                this.utilService.getChunkDetailByBkpImageUploadTimeAndChunkUploadedTime(backUpImage.getUserName(), dedupVal, chunkFile.getMd5(), backUpImage.getLastServerModifiedTime(), chunkDetail, false);
                if (chunkDetail == null) {
                    logger.debug("................chunk detail is empty for userName " + backUpImage.getUserName() + " so search with userName case insesitive...........");
                    chunkDetail = this.utilService.getChunkDetailByBkpImageUploadTimeAndChunkUploadedTime(backUpImage.getUserName(), dedupVal, chunkFile.getMd5(), backUpImage.getLastServerModifiedTime(), chunkDetail, true);
                }
                if (chunkDetail == null) continue;
                try {
                    chunkDetail.setRefCount(chunkDetail.getRefCount() - 1);
                    this.externalStorageBackupFileDao.saveChunkDetail(cloudId, chunkDetail);
                    logger.debug("--- Chunk details updated successfully ---");
                }
                catch (OptimisticLockingFailureException e) {
                    int count = 0;
                    int maxRetries = PCHelperConstant.getMaxRetryForChunkUpdate();
                    while (true) {
                        try {
                            logger.debug("--- Retry chunk detail update --- " + chunkFile.getMd5() + " --- Retry count ---" + count);
                            ChunkDetail chunkDetailRetry = this.externalStorageBackupFileDao.getChunkDetailForMd5AndUserName(cloudId, chunkDetail.getMd5(), chunkDetail.getUserName());
                            chunkDetailRetry.setRefCount(chunkDetailRetry.getRefCount() - 1);
                            this.externalStorageBackupFileDao.saveChunkDetail(cloudId, chunkDetailRetry);
                        }
                        catch (Exception ex) {
                            logger.error("--- Exception during retry chunk details update --- " + ex.getMessage());
                            logger.trace("--- Exception stack trace --- ", (Throwable)ex);
                            if (++count != maxRetries) continue;
                        }
                        break;
                    }
                    logger.error("--- Exception while handling version for Image --- " + e.getMessage());
                    logger.trace("--- Exception stack trace --- ", (Throwable)e);
                }
            }
        }
    }

    private String getDedupValue(String userName) {
        String dedupVal = null;
        User user = this.utilService.getUserInfoByName(1, userName);
        if (user != null) {
            SyncPolicy syncPolicy = this.utilService.getSyncPolicy(1, user.getSyncPolicyName());
            dedupVal = syncPolicy.getDedup();
        }
        logger.debug(" dedup value .... " + dedupVal);
        return dedupVal;
    }

    private void updateModifiedTimeStamp(int cloudId, String userName, String cloudName, String tempPath, long time, User user, MiniCloud miniCloud, boolean isPathInsideMC) {
        String[] params;
        if (isPathInsideMC) {
            userName = null;
            user = null;
        }
        String path = tempPath;
        while (!path.isEmpty() && path != "" && (params = path.split("/")).length > 1) {
            String fName = params[params.length - 1];
            String fPath = path.substring(0, path.length() - (fName.length() + 1));
            BackUpImage iFile = isPathInsideMC ? this.syncBackUpImageDAO.getBackUpImageDBRecordByDevicePath(cloudId, null, cloudName, fPath, fName, null, miniCloud) : this.syncBackUpImageDAO.getBackUpImageDBRecordByDevicePath(cloudId, userName, cloudName, fPath, fName, user, miniCloud);
            if (iFile == null || !iFile.isFolder() || !iFile.isPresent()) break;
            iFile.setLastServerModifiedTime(time);
            this.syncBackUpImageDAO.saveToBackUpImageDB(cloudId, iFile, user, miniCloud);
            path = fPath;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkIfUserStorageLimitReached(HttpServletRequest request, String cloudName, String userName) {
        logger.debug("checkIfUserStorageLimitReached for backup ..... ");
        CloseableHttpClient httpclient = HttpClientUtil.getSSlConnection();
        Object connManager = null;
        String url = PCHelperConstant.getPropertyFileValueForParacloudUrl() + "/paracloud/cloud/" + cloudName + "/userStorage/limitReached/" + userName + "/";
        HttpPost httpPost = new HttpPost(url);
        boolean isUserStorageLimitReached = false;
        try {
            Header[] headerarr;
            MultipartEntityBuilder entity = MultipartEntityBuilder.create();
            String fileSize = request.getParameter("file-size");
            entity.addTextBody("token", request.getParameter("token"));
            entity.addTextBody("file-size", fileSize);
            HttpEntity entity1 = entity.build();
            httpPost.setEntity(entity1);
            CloseableHttpResponse response = httpclient.execute((ClassicHttpRequest)httpPost);
            for (Header header : headerarr = response.getHeaders()) {
                if (!"isUserStorageLimitReached".equals(header.getName())) continue;
                logger.debug("Recieved isUserStorageLimitReached for file ..... " + header.getValue());
                isUserStorageLimitReached = Boolean.parseBoolean(header.getValue());
            }
        }
        catch (Exception e) {
            logger.trace(String.valueOf(e));
            logger.error("Exception While Checking User Storage Limit :" + e.getMessage());
        }
        return isUserStorageLimitReached;
    }

    protected SearchIndex formSearchIndex(int cloudId, BluKryptElement bluKryptElement, ObjectId consId, boolean isFileUnderMC, String fsPath) {
        SearchIndex searchIndex = new SearchIndex();
        searchIndex.setCloudId(cloudId);
        searchIndex.setConsolidatedImageId(consId);
        searchIndex.setPresent(true);
        searchIndex.setSync(true);
        searchIndex.setCloudName(bluKryptElement.getCloudName());
        searchIndex.setAbstractFolderUrl(bluKryptElement.getFileCompletePath());
        searchIndex.setFileName(bluKryptElement.getFileName());
        searchIndex.setFolder(false);
        searchIndex.setSize(String.valueOf(bluKryptElement.getFileSize()));
        searchIndex.setLastModifiedTime(String.valueOf(System.currentTimeMillis()));
        searchIndex.setFsPath(fsPath);
        searchIndex.setMiniCloud(isFileUnderMC);
        searchIndex.setUserName(bluKryptElement.getUserName());
        searchIndex.setStatus("ACTIVE");
        return searchIndex;
    }

    public static String getFsPath(String md5) {
        SimpleDateFormat sdfDate = new SimpleDateFormat("dd-MM-yyyy");
        Date date = new Date();
        String baseFolder = sdfDate.format(date) + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + String.valueOf(date.getTime());
        String fileName = md5;
        return baseFolder + fileName;
    }

    public static String getPropertyFileValueParabluFolderBasePath(String cloudName) {
        return PCHelperConstant.getPropertyFileValueParacloudMountPoint() + cloudName + "/f/";
    }

    protected void tranferFileFromStream(InputStream inputStream, File intermediateFile) {
        byte[] b = new byte[4096];
        FileOutputStream outstream = null;
        try {
            int buff;
            MessageDigest md = MessageDigest.getInstance("MD5");
            intermediateFile.createNewFile();
            logger.debug(intermediateFile.length() + "  tranferFileFromStream  ................ " + intermediateFile.getPath());
            outstream = new FileOutputStream(intermediateFile);
            while ((buff = inputStream.read(b)) != -1) {
                outstream.write(b, 0, buff);
                md.update(b, 0, buff);
            }
            outstream.close();
            logger.debug(intermediateFile.length() + " after  tranferFileFromStream  ................ ");
        }
        catch (Exception e) {
            logger.trace(String.valueOf(e));
            logger.error("Exception While Transfering File From Stream :" + e.getMessage());
        }
    }

    private boolean isPathInsideMC(int cloudId, String path) {
        String mcNameFromPath = SyncUploadController.getMCName(path);
        if (StringUtils.isEmpty((String)mcNameFromPath)) {
            return false;
        }
        List cloudElementList = this.syncFileDao.getAllMiniClouds(cloudId);
        boolean isPathInsideMC = false;
        for (MiniCloud miniCloudElement : cloudElementList) {
            if (!mcNameFromPath.equalsIgnoreCase(miniCloudElement.getMiniCloudName())) continue;
            isPathInsideMC = true;
            break;
        }
        return isPathInsideMC;
    }

    private static String getMCName(String path) {
        String mcName = "";
        try {
            String[] list = path.split("/");
            if (list != null && list.length == 1) {
                return "";
            }
            mcName = list[1];
        }
        catch (Exception exception) {
            // empty catch block
        }
        return mcName;
    }

    @RequestMapping(value={"/sync/upload/files/all"}, method={RequestMethod.POST})
    public void uploadMultiPartFiles(HttpServletRequest request, HttpServletResponse httpResponse) {
        logger.debug("Start multipart file.........");
        String boundary = "--PARABLUEOF";
        byte[] bryBytes = boundary.getBytes();
        BufferedInputStream in = null;
        try {
            in = new BufferedInputStream((InputStream)request.getInputStream(), 10240);
            logger.debug("file stream ........." + String.valueOf(in));
            boolean skipInfectedFile = false;
            boolean addAudit = true;
            ArrayList<ChunkFileElement> chunkFileElementList = new ArrayList<ChunkFileElement>();
            MultipartStream multipartStream = new MultipartStream((InputStream)in, bryBytes, 4096);
            boolean nextPart = multipartStream.skipPreamble();
            logger.debug(" nextpart ...... " + nextPart + "<<<<<<<<<");
            int i = 1;
            boolean isSyncRecorded = false;
            Cloud cloud = null;
            while (nextPart) {
                BluKryptElement bluKryptElement;
                SyncPolicy syncPolicy;
                String header = multipartStream.readHeaders();
                logger.debug(header + " header:" + i);
                Map<String, String> headerMap = SyncUploadController.parseHeader(header);
                if (!isSyncRecorded) {
                    isSyncRecorded = true;
                }
                httpResponse.setStatus(500);
                if (cloud == null) {
                    cloud = this.utilService.getCloud(1);
                }
                if ((syncPolicy = this.syncUploadService.getSyncPolicyForUser(1, (bluKryptElement = this.getBluKryptElementValuesStr(headerMap)).getUserName())).isEnableAVScan() && this.isClamAVScanEnabled(cloud) && !CheckClamAV.isclamAVAvaiable()) {
                    logger.debug("CheckClamAV s not running...");
                    httpResponse.setStatus(500);
                    return;
                }
                if (syncPolicy.isEnableAVScan() && this.isClamAVScanEnabled(cloud)) {
                    this.upload(headerMap, multipartStream, httpResponse, i, cloud, skipInfectedFile, addAudit, chunkFileElementList);
                } else {
                    this.upload(headerMap, multipartStream, httpResponse, i, cloud);
                }
                nextPart = multipartStream.readBoundary();
                ++i;
            }
        }
        catch (Exception e) {
            this.closeInputStreamIfExists(request);
            logger.trace(String.valueOf(e));
            logger.error("Exception When Uploading Multipart Files :" + e.getMessage());
        }
        logger.debug("End multipart file.........");
    }

    private void upload(Map<String, String> headerMap, MultipartStream multipartStream, HttpServletResponse httpResponse, int uploadCount, Cloud cloud, boolean skipInfectedFile, boolean addAudit, List<ChunkFileElement> ChunkFileElementList) {
        String syncRevisionId = "";
        String consolidatedImageId = "";
        int cloudId = 1;
        try {
            SyncPolicy syncPolicy;
            BluKryptElement bluKryptElement = this.getBluKryptElementValuesStr(headerMap);
            String fileSizeInString = headerMap.get("file-size");
            String chunkFilechecksum = headerMap.get("chunkFileMD5");
            String chunkFileName = headerMap.get("chunkFileName");
            String batchId = headerMap.get("backupBatchId");
            String isChunkOfAFile = "false";
            String checkSum = headerMap.get("fileMD5");
            String isNormalFile = "true";
            if (headerMap.get("isAChunkFile") != null) {
                isChunkOfAFile = headerMap.get("isAChunkFile");
            }
            if (headerMap.get("isNormalFile") != null) {
                isNormalFile = headerMap.get("isNormalFile");
            }
            ArrayList<String> list = new ArrayList<String>();
            logger.debug("@@@before calling check machine storage......" + checkSum);
            boolean isMachineStorageReached = this.checkMachineStorage(fileSizeInString);
            if (isMachineStorageReached) {
                httpResponse.setStatus(507);
                logger.error(bluKryptElement.getUserName() + USER_STORAGE_LIMIT_REACHED);
                return;
            }
            String cloudName = bluKryptElement.getCloudName();
            String fileName = bluKryptElement.getFileName();
            logger.debug("$$$$$$before checking user storage$$$$$" + fileName);
            double fileSizeInMb = this.getSizeinMb(Long.parseLong(headerMap.get("file-size")));
            logger.debug("$$$$$$ fileSizeInMb $$$$$$" + fileSizeInMb);
            boolean isUserStorageLimitReached = this.utilService.isSyncUserStorageLimitReached(1, fileSizeInMb, bluKryptElement.getUserName(), cloudName);
            if (isUserStorageLimitReached) {
                httpResponse.setStatus(449);
                this.sendWarningMail(headerMap, this.utilService.userSyncStorageLimit(cloudId, bluKryptElement.getUserName()));
                logger.error(bluKryptElement.getUserName() + USER_STORAGE_LIMIT_REACHED);
                return;
            }
            File tempFilePath = Boolean.parseBoolean(isNormalFile) ? this.createFileInSyncPath(headerMap, cloudName, fileName) : this.createFileInSyncPath(headerMap, cloudName, chunkFileName);
            FileOutputStream restoreFileOutput = new FileOutputStream(tempFilePath);
            multipartStream.readBodyData((OutputStream)restoreFileOutput);
            restoreFileOutput.flush();
            ((OutputStream)restoreFileOutput).close();
            ChunkFileElement chunkFileElement = new ChunkFileElement();
            list.add(checkSum);
            chunkFileElement.setFileChunks(list);
            chunkFileElement.setFileCompletePath(bluKryptElement.getFileCompletePath());
            chunkFileElement.setFileName(checkSum);
            chunkFileElement.setMd5checksum(checkSum);
            chunkFileElement.setDeviceUUID(bluKryptElement.getDeviceUUID());
            boolean isSearchEnabled = false;
            if (cloud.getContentSearchEnabled() == 1 && (syncPolicy = this.syncUploadService.getSyncPolicyForUser(cloudId, bluKryptElement.getUserName())).isContentIndexEnabled()) {
                isSearchEnabled = true;
            }
            String fsPath = SyncUploadController.getFsPath(checkSum);
            String indexPath = null;
            if (isSearchEnabled) {
                indexPath = SyncUploadController.getPropertyFileValueParabluFolderBasePath(bluKryptElement.getCloudName()) + "ParaBlu" + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + fsPath;
                logger.debug("index path" + indexPath);
            }
            boolean isfileInfected = false;
            chunkFileElement = this.createChunkFileElement(bluKryptElement, chunkFilechecksum, chunkFileName, checkSum, list);
            ChunkFileElementList.add(chunkFileElement);
            if (CollectionUtils.isEmpty(list)) {
                list.add(checkSum);
            }
            String deviceTempPath = PCHelperConstant.getPropertyFileValueDefaultSyncUploadPath((String)cloudName) + headerMap.get("deviceUUID") + "/" + batchId;
            File uploadSyncPath = new File(deviceTempPath);
            if (Boolean.parseBoolean(isChunkOfAFile)) {
                logger.debug("$$$$$$$$$$$Inside a chunk file upload so return>>>>>>>>");
                return;
            }
            if (!Boolean.parseBoolean(isChunkOfAFile) && !Boolean.parseBoolean(isNormalFile)) {
                list.clear();
                logger.debug("");
                StringWriter writer = new StringWriter();
                IOUtils.copy((InputStream)new Base64InputStream((InputStream)new FileInputStream(tempFilePath), false), (Writer)writer);
                String chunkList = writer.toString();
                logger.debug("inside else ...." + chunkList);
                list = new ArrayList<String>(Arrays.asList(chunkList.split(",")));
                logger.debug("inside else ...." + String.valueOf(list));
                if (tempFilePath.getName().equals("chunkvalues")) {
                    tempFilePath.delete();
                }
            }
            if (CollectionUtils.isEmpty(list)) {
                list.add(checkSum);
            }
            MessageDigest md = MessageDigest.getInstance("MD5");
            File[] filesList = uploadSyncPath.listFiles();
            File tempFolder = new File(String.valueOf(uploadSyncPath.getAbsoluteFile()) + "/temp");
            File tempFile = new File(tempFolder.getAbsolutePath() + "/" + fileName);
            this.createTempFile(md, filesList, tempFolder, tempFile, Boolean.parseBoolean(isNormalFile));
            Base64InputStream inputStream1 = new Base64InputStream((InputStream)new FileInputStream(tempFile), false);
            byte[] bytes = IOUtils.toByteArray((InputStream)inputStream1);
            SyncPolicy syncPolicy2 = this.syncUploadService.getSyncPolicyForUser(cloudId, bluKryptElement.getUserName());
            if (fileSizeInMb <= 4000.0 && syncPolicy2.isEnableAVScan() && this.isClamAVScanEnabled(cloud)) {
                isfileInfected = CheckClamAV.isFileInfected((File)tempFile);
            }
            if (isfileInfected) {
                logger.error("......******fileInfected***********........." + fileName);
                Device device = this.deviceDaoImpl.getDeviceInfoByUUID(cloudId, cloudName, bluKryptElement.getDeviceUUID());
                this.addAuditHitsory(cloudName, bluKryptElement, device.getDeviceName());
                try {
                    if (tempFile.exists()) {
                        tempFile.delete();
                    }
                    for (File file : filesList) {
                        if (!file.isFile() || !file.exists()) continue;
                        file.delete();
                    }
                    httpResponse.setStatus(200);
                    return;
                }
                catch (Exception e) {
                    logger.error("......*****************.........");
                    e.printStackTrace();
                    return;
                }
            }
            try {
                if (tempFile.exists()) {
                    tempFile.delete();
                }
            }
            catch (Exception e) {
                logger.error("......*****************.........");
                e.printStackTrace();
            }
            File[] filesList1 = uploadSyncPath.listFiles();
            filesList1 = this.sortBasedOnTime(filesList1);
            logger.debug("........filesList......." + filesList1.length);
            for (File file : filesList1) {
                logger.debug("..inside filesList....." + file.getAbsolutePath());
                if (!file.isFile()) continue;
                Base64InputStream inputStream = new Base64InputStream((InputStream)new FileInputStream(file), false);
                ChunkFileElement chunkFileElement1 = null;
                logger.debug("..inside ChunkFileElementList....." + ChunkFileElementList.size());
                for (ChunkFileElement ChunkFileElement2 : ChunkFileElementList) {
                    logger.debug("..inside ChunkFileElementList....." + ChunkFileElement2.getFileName() + "...." + file.getName());
                    if ((!ChunkFileElement2.getFileName().equals(file.getName()) || Boolean.parseBoolean(isNormalFile)) && !Boolean.parseBoolean(isNormalFile)) continue;
                    logger.debug("inside match ......");
                    chunkFileElement1 = ChunkFileElement2;
                }
                this.uploadFile(bluKryptElement, (InputStream)inputStream, chunkFileElement1, indexPath, batchId);
                try {
                    if (file.exists()) {
                        logger.debug("delete file.............." + file.getAbsolutePath());
                    }
                }
                catch (Exception e) {
                    logger.error("......*****************.........");
                    e.printStackTrace();
                }
                httpResponse.setStatus(200);
                logger.debug("inside else ...." + String.valueOf(list));
                logger.debug("  Before insertEntryForSync ..." + bluKryptElement.getFilePath());
            }
            FileRevision revision = this.insertEntryForSync(cloudId, headerMap, bluKryptElement, cloud, isfileInfected);
            syncRevisionId = revision.getId().toString();
            ConsolidatedImage consolidatedImage = revision.getConsolidatedImage();
            consolidatedImageId = consolidatedImage.getId().toString();
            logger.debug(consolidatedImage.isFileInfected() + " isfileInfected..............." + isfileInfected);
            logger.debug(consolidatedImageId + AFTER_INSERT_ENTRY_FOR_SYNC + syncRevisionId);
            if (syncRevisionId != null) {
                if (CollectionUtils.isEmpty(list)) {
                    list.add(checkSum);
                }
                FileInfo fileInfo = this.getFileInfo(bluKryptElement, syncRevisionId, list);
                fileInfo.setSize(bluKryptElement.getFileSize());
                fileInfo.setMd5(checkSum);
                fileInfo.setBatchId(batchId);
                fileInfo.setCompressed(revision.isCompressed());
                boolean uploadSuccess = this.uploadService.saveFileInfoForSync(bluKryptElement.getCloudName(), bluKryptElement.getGatewayName(), fileInfo);
                if (!uploadSuccess) {
                    this.uploadService.removeSyncFile(cloudId, syncRevisionId, consolidatedImageId);
                    logger.error(UNABLE_TO_GET_BACKUPID_FROM_EBMS);
                    httpResponse.setStatus(500);
                } else {
                    httpResponse.setStatus(200);
                }
            } else {
                logger.error(UNABLE_TO_GET_BACKUPID_FROM_EBMS);
                httpResponse.setStatus(500);
            }
            if (isSearchEnabled) {
                SearchIndex index = this.formSearchIndex(1, bluKryptElement, consolidatedImage.getId(), consolidatedImage.isMiniCloud(), fsPath);
                this.utilService.addFileToTable(index, bluKryptElement.getCloudName());
                logger.debug(END_OF_ADD_SEARCH_INDEX);
            }
        }
        catch (UncategorizedJmsException jmsException) {
            logger.error(" JMSException connection refused exception upload ....... " + syncRevisionId);
            logger.trace(String.valueOf((Object)jmsException));
            this.utilService.deleteRevision(cloudId, syncRevisionId, consolidatedImageId);
            httpResponse.setStatus(500);
        }
        catch (Exception e) {
            httpResponse.setStatus(500);
            logger.trace(String.valueOf(e));
            logger.error(ERROR_WHILE_WRITE_CHUNK_FILES + e.getMessage());
            e.printStackTrace();
        }
        logger.debug(END_OF_SAVE_TO_ONE_DRIVE);
    }

    private File[] sortBasedOnTime(File[] filesList1) {
        Arrays.sort(filesList1, new Comparator<File>(this){

            @Override
            public int compare(File f1, File f2) {
                return Long.compare(f1.lastModified(), f2.lastModified());
            }
        });
        return filesList1;
    }

    private void upload(Map<String, String> headerMap, MultipartStream multipartStream, HttpServletResponse httpResponse, int uploadCount, Cloud cloud) {
        String syncRevisionId = "";
        String consolidatedImageId = "";
        int cloudId = 1;
        try {
            SyncPolicy syncPolicy;
            BluKryptElement bluKryptElement = this.getBluKryptElementValuesStr(headerMap);
            String fileSizeInString = headerMap.get("file-size");
            String chunkFilechecksum = headerMap.get("chunkFileMD5");
            String chunkFileName = headerMap.get("chunkFileName");
            String batchId = headerMap.get("backupBatchId");
            String isChunkOfAFile = "false";
            String checkSum = headerMap.get("fileMD5");
            String isNormalFile = "true";
            if (headerMap.get("isAChunkFile") != null) {
                isChunkOfAFile = headerMap.get("isAChunkFile");
            }
            if (headerMap.get("isNormalFile") != null) {
                isNormalFile = headerMap.get("isNormalFile");
            }
            logger.debug("@@@before calling check machine storage......");
            boolean isMachineStorageReached = this.checkMachineStorage(fileSizeInString);
            if (isMachineStorageReached) {
                httpResponse.setStatus(507);
                logger.error(bluKryptElement.getUserName() + USER_STORAGE_LIMIT_REACHED);
                return;
            }
            String cloudName = bluKryptElement.getCloudName();
            String fileName = bluKryptElement.getFileName();
            logger.debug("$$$$$$before checking user storage$$$$$");
            double fileSizeInMb = this.getSizeinMb(Long.parseLong(headerMap.get("file-size")));
            logger.debug("$$$$$$ fileSizeInMb $$$$$$" + fileSizeInMb);
            boolean isUserStorageLimitReached = this.utilService.isSyncUserStorageLimitReached(1, fileSizeInMb, bluKryptElement.getUserName(), cloudName);
            if (isUserStorageLimitReached) {
                httpResponse.setStatus(449);
                this.sendWarningMail(headerMap, this.utilService.userSyncStorageLimit(cloudId, bluKryptElement.getUserName()));
                logger.error(bluKryptElement.getUserName() + USER_STORAGE_LIMIT_REACHED);
                return;
            }
            File tempFilePath = this.createFileInSyncPath(headerMap, cloudName, fileName);
            FileOutputStream restoreFileOutput = new FileOutputStream(tempFilePath);
            multipartStream.readBodyData((OutputStream)restoreFileOutput);
            restoreFileOutput.flush();
            ((OutputStream)restoreFileOutput).close();
            Base64InputStream inputStream = new Base64InputStream((InputStream)new FileInputStream(tempFilePath), false);
            ChunkFileElement chunkFileElement = new ChunkFileElement();
            ArrayList<String> list = new ArrayList<String>();
            list.add(checkSum);
            chunkFileElement.setFileChunks(list);
            chunkFileElement.setFileCompletePath(bluKryptElement.getFileCompletePath());
            chunkFileElement.setFileName(checkSum);
            chunkFileElement.setMd5checksum(checkSum);
            chunkFileElement.setDeviceUUID(bluKryptElement.getDeviceUUID());
            boolean isSearchEnabled = false;
            if (cloud.getContentSearchEnabled() == 1 && (syncPolicy = this.syncUploadService.getSyncPolicyForUser(cloudId, bluKryptElement.getUserName())).isContentIndexEnabled()) {
                isSearchEnabled = true;
            }
            String fsPath = SyncUploadController.getFsPath(checkSum);
            String indexPath = null;
            if (isSearchEnabled) {
                indexPath = SyncUploadController.getPropertyFileValueParabluFolderBasePath(bluKryptElement.getCloudName()) + "ParaBlu" + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + fsPath;
                logger.debug("index path" + indexPath);
            }
            if (Boolean.parseBoolean(isChunkOfAFile) || Boolean.parseBoolean(isNormalFile)) {
                chunkFileElement = this.createChunkFileElement(bluKryptElement, chunkFilechecksum, chunkFileName, checkSum, list);
                this.uploadFile(bluKryptElement, (InputStream)inputStream, chunkFileElement, indexPath, batchId);
            } else {
                list.clear();
                StringWriter writer = new StringWriter();
                IOUtils.copy((InputStream)inputStream, (Writer)writer);
                String chunkList = writer.toString();
                list = new ArrayList<String>(Arrays.asList(chunkList.split(",")));
            }
            if (inputStream != null) {
                inputStream.close();
                if (tempFilePath.exists()) {
                    tempFilePath.delete();
                }
            }
            httpResponse.setStatus(200);
            if (CollectionUtils.isEmpty(list)) {
                list.add(checkSum);
            }
            logger.debug("  Before insertEntryForSync ..." + bluKryptElement.getFilePath());
            if (Boolean.parseBoolean(isChunkOfAFile)) {
                logger.debug("$$$$$$$$$$$Inside a chunk file upload so return>>>>>>>>");
                return;
            }
            boolean isfileInfected = false;
            FileRevision revision = this.insertEntryForSync(cloudId, headerMap, bluKryptElement, cloud, isfileInfected);
            syncRevisionId = revision.getId().toString();
            ConsolidatedImage consolidatedImage = revision.getConsolidatedImage();
            consolidatedImageId = consolidatedImage.getId().toString();
            logger.debug(consolidatedImage.isFileInfected() + " isfileInfected..............." + isfileInfected);
            logger.debug(consolidatedImageId + AFTER_INSERT_ENTRY_FOR_SYNC + syncRevisionId);
            if (syncRevisionId != null) {
                FileInfo fileInfo = this.getFileInfo(bluKryptElement, syncRevisionId, list);
                fileInfo.setSize(bluKryptElement.getFileSize());
                fileInfo.setMd5(checkSum);
                fileInfo.setBatchId(batchId);
                fileInfo.setCompressed(revision.isCompressed());
                boolean uploadSuccess = this.uploadService.saveFileInfoForSync(bluKryptElement.getCloudName(), bluKryptElement.getGatewayName(), fileInfo);
                if (!uploadSuccess) {
                    this.uploadService.removeSyncFile(cloudId, syncRevisionId, consolidatedImageId);
                    logger.error(UNABLE_TO_GET_BACKUPID_FROM_EBMS);
                    httpResponse.setStatus(500);
                } else {
                    httpResponse.setStatus(200);
                }
            } else {
                logger.error(UNABLE_TO_GET_BACKUPID_FROM_EBMS);
                httpResponse.setStatus(500);
            }
            if (isSearchEnabled) {
                SearchIndex index = this.formSearchIndex(1, bluKryptElement, consolidatedImage.getId(), consolidatedImage.isMiniCloud(), fsPath);
                this.utilService.addFileToTable(index, bluKryptElement.getCloudName());
                logger.debug(END_OF_ADD_SEARCH_INDEX);
            }
        }
        catch (UncategorizedJmsException jmsException) {
            logger.error(" JMSException connection refused exception upload ....... " + syncRevisionId);
            logger.trace(String.valueOf((Object)jmsException));
            this.utilService.deleteRevision(cloudId, syncRevisionId, consolidatedImageId);
            httpResponse.setStatus(500);
        }
        catch (Exception e) {
            httpResponse.setStatus(500);
            logger.trace(String.valueOf(e));
            logger.error(ERROR_WHILE_WRITE_CHUNK_FILES + e.getMessage());
            e.printStackTrace();
        }
        logger.debug(END_OF_SAVE_TO_ONE_DRIVE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createTempFile(MessageDigest md, File[] filesList, File tempFolder, File tempFile, Boolean isNormalFile) throws IOException, FileNotFoundException {
        tempFolder.mkdirs();
        if (tempFile.exists()) {
            tempFile.delete();
        }
        tempFile.createNewFile();
        for (File file : filesList) {
            if (!file.isFile()) continue;
            logger.debug("..before write ....." + file.getAbsolutePath());
            Object gZIPInputStream = new Base64InputStream((InputStream)new FileInputStream(file), false);
            FileOutputStream fileOutputStream = null;
            try {
                fileOutputStream = new FileOutputStream(tempFile, true);
                if (!isNormalFile.booleanValue()) {
                    gZIPInputStream = new GZIPInputStream((InputStream)gZIPInputStream);
                }
                byte[] b = new byte[4096];
                int buff = -1;
                while ((buff = ((InputStream)gZIPInputStream).read(b)) != -1) {
                    fileOutputStream.write(b, 0, buff);
                    md.update(b, 0, buff);
                }
                logger.debug("..after write ....." + file.getAbsolutePath());
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                logger.debug("Exception", (Throwable)e);
                tempFile.delete();
            }
            catch (IOException e) {
                e.printStackTrace();
                logger.debug("Exception", (Throwable)e);
                tempFile.delete();
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.trace(String.valueOf(e));
                logger.error("Exception While Transfering File From Stream :" + e.getMessage());
            }
            finally {
                IOUtils.closeQuietly((InputStream)gZIPInputStream);
                fileOutputStream.close();
            }
        }
    }

    private static boolean scanFilecontent(byte[] temporary) {
        boolean ifFileInfected = CheckClamAV.isFileInfected((byte[])temporary);
        if (ifFileInfected) {
            logger.debug("File is infected...");
        } else {
            logger.debug("File is  not infectedinfected...");
        }
        return ifFileInfected;
    }

    private double getSizeinMb(long size) {
        long filesizeInKB = (long)Math.ceil((double)size / 1024.0);
        double m = (double)filesizeInKB / 1024.0;
        logger.debug("$$$$$$Size----$$$$$" + m);
        DecimalFormat dec = new DecimalFormat("0.00");
        return Double.parseDouble(dec.format(m));
    }

    private long getSizeInKb(long size) {
        return (long)Math.ceil((double)size / 1024.0);
    }

    private File createFileInSyncPath(Map<String, String> headerMap, String cloudName, String fileName) throws IOException {
        String batchId = headerMap.get("backupBatchId");
        String deviceTempPath = PCHelperConstant.getPropertyFileValueDefaultSyncUploadPath((String)cloudName) + headerMap.get("deviceUUID") + "/" + batchId;
        File uploadSyncPath = new File(deviceTempPath);
        uploadSyncPath.mkdirs();
        String filePath = String.valueOf(uploadSyncPath) + "/" + fileName;
        logger.debug(" *******************" + filePath);
        File tempFilePath = new File(filePath);
        if (!tempFilePath.exists()) {
            tempFilePath.createNewFile();
        }
        return tempFilePath;
    }

    private void cleanBackupBatchFolder(Map<String, String> headerMap, String cloudName) {
        try {
            String batchId = headerMap.get("backupBatchId");
            String deviceTempPath = PCHelperConstant.getPropertyFileValueDefaultSyncUploadPath((String)cloudName) + headerMap.get("deviceUUID") + "/" + batchId;
            File uploadSyncPath = new File(deviceTempPath);
            if (uploadSyncPath.exists()) {
                File[] filesList;
                for (File file : filesList = uploadSyncPath.listFiles()) {
                    file.delete();
                }
            }
        }
        catch (Exception e) {
            logger.error("error to delete old files ....", (Throwable)e);
            e.printStackTrace();
        }
    }

    private ChunkFileElement createChunkFileElement(BluKryptElement bluKryptElement, String chunkFilechecksum, String chunkFileName, String checkSum, List<String> list) {
        ChunkFileElement chunkFileElement = new ChunkFileElement();
        if (CollectionUtils.isEmpty(list)) {
            logger.debug("List is empty sooo adding md5checksum" + checkSum);
            list.add(checkSum);
        }
        chunkFileElement.setFileChunks(list);
        chunkFileElement.setFileCompletePath(bluKryptElement.getFileCompletePath());
        chunkFileElement.setFileName(checkSum);
        chunkFileElement.setMd5checksum(checkSum);
        chunkFileElement.setDeviceUUID(bluKryptElement.getDeviceUUID());
        if (!StringUtils.isEmpty((String)chunkFilechecksum)) {
            chunkFileElement.setMd5checksum(chunkFilechecksum);
            chunkFileElement.setFileChunks(list);
            chunkFileElement.setFileCompletePath(chunkFileName);
            chunkFileElement.setFileName(chunkFileName);
            chunkFileElement.setDeviceUUID(bluKryptElement.getDeviceUUID());
        }
        return chunkFileElement;
    }

    private static String getValue(HttpServletRequest request, String paramValue) {
        if (!StringUtils.isEmpty((String)request.getParameter(paramValue))) {
            return request.getParameter(paramValue);
        }
        return request.getHeader(paramValue);
    }

    protected String decodeBase64UTFString(String encodedString) {
        String decodedString = encodedString;
        try {
            decodedString = new String(Base64.decodeBase64((String)encodedString), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            logger.trace(String.valueOf(e));
            logger.error(e.getMessage());
            logger.debug("UnsupportedEncodingException", (Throwable)e);
        }
        return decodedString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/cloud/{cloudName}/sync/portal/new/upload/file/"}, method={RequestMethod.POST})
    public ModelAndView uploadPortalFileLatest(@PathVariable(value="cloudName") String cloudName, @RequestBody BluKryptElement bluKryptElement, HttpServletRequest request, HttpServletResponse httpResponse) {
        logger.debug("Inside new portal/sync file upload --- Is folder? ---  " + request.getHeader("is-folder"));
        String syncBackUpImageId = "";
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        int cloudId = 0;
        InputStream inputStream = null;
        Boolean isCmdLineExecution = false;
        User user = null;
        MiniCloud miniCloud = null;
        String encodedFileName = null;
        String encodedFilePath = null;
        String remoteAddre = null;
        try {
            logger.debug("--- BluKrypt Element --- " + bluKryptElement.toString());
            String fileTmpPath = bluKryptElement.getFileTmpPath();
            logger.debug("Portal upload get modified time --- " + bluKryptElement.getModified() + " --- Inside portal/sync file upload path --- " + fileTmpPath);
            logger.debug("isCmdLineExecution={}", (Object)isCmdLineExecution);
            remoteAddre = request.getRemoteAddr();
            logger.debug("ip address={}", (Object)remoteAddre);
            isCmdLineExecution = Boolean.parseBoolean(request.getHeader("isCmdLineExecution"));
            File uploadedFile = new File(fileTmpPath);
            inputStream = new FileInputStream(fileTmpPath);
            logger.debug("Inside portal/sync after reading stream");
            Cloud cloud = this.utilService.getCloud(1);
            if (cloud != null) {
                bluKryptElement.setVersionsToKeep(Integer.toString(cloud.getVersioningEnabled()));
                cloudId = cloud.getCloudId();
            }
            encodedFileName = bluKryptElement.getFileName();
            encodedFilePath = bluKryptElement.getFileCompletePath();
            if (StringUtils.isNotEmpty((String)encodedFileName)) {
                logger.debug("Encoded file name --- " + encodedFileName);
                bluKryptElement.setFileName(this.decodeBase64UTFString(encodedFileName));
                logger.debug("Decoded file name --- " + bluKryptElement.getFileName());
            }
            if (StringUtils.isNotEmpty((String)encodedFilePath)) {
                logger.debug("Encoded complete file path --- " + encodedFilePath);
                bluKryptElement.setFileCompletePath(this.decodeBase64UTFString(encodedFilePath));
                logger.debug("Decoded complete file path --- " + bluKryptElement.getFileCompletePath());
            }
            bluKryptElement.setFilePath(bluKryptElement.getFileCompletePath());
            logger.debug("BluKrypt Element file path before conditional check --- " + bluKryptElement.getFilePath());
            if (!StringUtils.isEmpty((String)bluKryptElement.getFilePath()) && bluKryptElement.getFilePath().endsWith("/")) {
                bluKryptElement.setFilePath(bluKryptElement.getFilePath().substring(0, bluKryptElement.getFilePath().length() - 1));
            }
            logger.debug("BluKrypt Element file path after modification --- " + bluKryptElement.getFilePath());
            String deviceUUID = SyncUploadController.getValue(request, "deviceUUID");
            String osType = SyncUploadController.getValue(request, "osType");
            logger.debug("--- Device UUID from header --- " + deviceUUID);
            if (deviceUUID != null && osType != null) {
                bluKryptElement.setDeviceUUID(deviceUUID);
                bluKryptElement.setOsType(osType);
            } else {
                if (isCmdLineExecution.booleanValue()) {
                    bluKryptElement.setDeviceUUID(CMDLINE);
                } else {
                    bluKryptElement.setDeviceUUID(PORTAL);
                }
                bluKryptElement.setOsType("Windows");
            }
            logger.debug("--- Device UUID new --- " + bluKryptElement.getDeviceUUID());
            logger.debug("--- Before check for machine storage --- Gateway name --- " + bluKryptElement.getGatewayName());
            boolean isMachineStorageReached = this.checkMachineStorageForPortalSync(bluKryptElement);
            if (isMachineStorageReached) {
                httpResponse.setStatus(507);
                logger.error("--- UserName --- " + bluKryptElement.getUserName() + USER_STORAGE_LIMIT_REACHED);
                ModelAndView modelAndView2 = null;
                return modelAndView2;
            }
            double fileSizeInMb = this.getSizeinMb(bluKryptElement.getFileSize());
            logger.debug("--- File Size in MB --- " + fileSizeInMb);
            boolean isUserStorageLimitReached = this.utilService.isSyncUserStorageLimitReached(1, fileSizeInMb, bluKryptElement.getUserName(), cloudName);
            if (isUserStorageLimitReached) {
                httpResponse.setStatus(449);
                logger.error("--- UserName --- " + bluKryptElement.getUserName() + USER_STORAGE_LIMIT_REACHED);
                ModelAndView modelAndView3 = null;
                return modelAndView3;
            }
            boolean fileUnderMC = false;
            logger.debug(request.getHeader("mcName") + "...fileUnderMC...." + request.getHeader("fileUnderMC"));
            if (request.getHeader("fileUnderMC") != null) {
                fileUnderMC = Boolean.parseBoolean(request.getHeader("fileUnderMC"));
            }
            if (fileUnderMC) {
                if (request.getHeader("mcName") != null && (miniCloud = this.syncUploadService.getMiniCloudByName(cloudId, request.getHeader("mcName"))) != null && !miniCloud.isAllowUpload()) {
                    httpResponse.setStatus(405);
                    logger.error(bluKryptElement.getUserName() + "..minicloud upload limit reached...");
                    this.saveAuditHistory(bluKryptElement.getFileName(), bluKryptElement.getFileCompletePath(), bluKryptElement.getUserName(), cloud, isCmdLineExecution, remoteAddre);
                    ModelAndView e = null;
                    return e;
                }
            } else {
                user = this.userDao.getUserByName(cloudId, bluKryptElement.getUserName());
            }
            boolean isSpecialCharsInFileName = false;
            char[] e = "/*\":<>".toCharArray();
            int n = e.length;
            for (int i = 0; i < n; ++i) {
                Character c = Character.valueOf(e[i]);
                if (!bluKryptElement.getFileName().contains(c.toString())) continue;
                isSpecialCharsInFileName = true;
                break;
            }
            if (isSpecialCharsInFileName) {
                logger.debug("--- File name contains special characters ---");
                httpResponse.setStatus(406);
                e = null;
                return e;
            }
            String checkSum = UUID.randomUUID().toString();
            ChunkFileElement chunkFileElement = new ChunkFileElement();
            ArrayList<String> list = new ArrayList<String>();
            chunkFileElement.setFileChunks(list);
            chunkFileElement.setFileCompletePath(bluKryptElement.getFileCompletePath());
            chunkFileElement.setFileName(checkSum);
            chunkFileElement.setMd5checksum(checkSum);
            chunkFileElement.setDeviceUUID(bluKryptElement.getDeviceUUID());
            String fsPath = SyncUploadController.getFsPath(checkSum);
            bluKryptElement.setCloudName(cloudName);
            boolean isSearchEnabled = false;
            SyncPolicy syncPolicy = this.syncUploadService.getSyncPolicyForUser(cloudId, bluKryptElement.getUserName());
            if (cloud != null && cloud.getContentSearchEnabled() == 1) {
                boolean isFileAllowed = SyncUploadController.checkForExtensions(bluKryptElement.getFileName(), syncPolicy.getSearchInclusionFilter(), syncPolicy.getSearchFilterType());
                if (syncPolicy.isContentIndexEnabled() && isFileAllowed) {
                    isSearchEnabled = true;
                }
            }
            String indexPath = null;
            if (isSearchEnabled) {
                indexPath = SyncUploadController.getPropertyFileValueParabluFolderBasePath(cloudName) + "ParaBlu" + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + fsPath;
            }
            boolean isFileInfected = false;
            boolean ifFileInfected = false;
            if (fileSizeInMb <= 4000.0 && syncPolicy.isEnableAVScan() && this.isClamAVScanEnabled(cloud)) {
                if (CheckClamAV.isclamAVAvaiable()) {
                    ifFileInfected = CheckClamAV.isFileInfected((File)uploadedFile);
                } else {
                    logger.debug("CheckClamAV s not running...");
                    httpResponse.setStatus(500);
                    ModelAndView modelAndView4 = null;
                    return modelAndView4;
                }
            }
            if (ifFileInfected) {
                httpResponse.setStatus(451);
                Path path = Paths.get(fileTmpPath, new String[0]);
                try {
                    Files.deleteIfExists(path);
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
                if (isCmdLineExecution.booleanValue()) {
                    this.addAuditHitsory(cloudName, bluKryptElement, "command line(" + remoteAddre + ")");
                } else {
                    this.addAuditHitsory(cloudName, bluKryptElement, "PORTAL");
                }
                ModelAndView e2 = null;
                return e2;
            }
            Map<String, String> chunkNameAndChecksum = this.uploadFileUsingPortal(cloudName, bluKryptElement, inputStream, chunkFileElement, indexPath, fileTmpPath);
            if (chunkNameAndChecksum != null && !chunkNameAndChecksum.isEmpty()) {
                ArrayList<String> chunkList = new ArrayList<String>(chunkNameAndChecksum.keySet());
                if (chunkList.size() > 1) {
                    String chunks = StringUtils.join(chunkList, (char)',') + ",";
                    checkSum = MD5Generator.generateMD5OfString((String)chunks);
                } else if (!chunkList.isEmpty()) {
                    checkSum = (String)chunkList.get(0);
                }
            }
            logger.debug("..............isFileInfected.............." + isFileInfected);
            httpResponse.setStatus(200);
            logger.debug(checkSum + "  Before insertEntryForSync portal ..." + bluKryptElement.getFilePath());
            String insertResult = this.insertEntryForSyncUsingHeaderVals(request, cloud, checkSum, bluKryptElement, encodedFileName, encodedFilePath, isFileInfected, user, miniCloud);
            String[] vals = insertResult.split("-");
            syncBackUpImageId = vals[0];
            boolean isFileUnderMC = Boolean.parseBoolean(vals[1]);
            if (chunkNameAndChecksum.size() > 1) {
                for (Map.Entry<String, String> entry : chunkNameAndChecksum.entrySet()) {
                    logger.debug(entry.getKey() + " .........after chunk............ " + entry.getValue());
                    list.add(entry.getKey() + "." + syncBackUpImageId);
                }
            } else {
                for (Map.Entry<String, String> entry : chunkNameAndChecksum.entrySet()) {
                    logger.debug(entry.getKey() + " .........after chunk............ " + entry.getValue());
                    list.add(entry.getKey());
                }
            }
            if (syncBackUpImageId != null) {
                logger.debug("--- Sync BackUpImage Id --- " + syncBackUpImageId);
                if ("DEDUPED_FILE".equalsIgnoreCase(syncBackUpImageId)) {
                    modelAndView.addObject((Object)bluKryptElement);
                    httpResponse.setStatus(448);
                } else {
                    logger.debug("--- Before save sync BackUpImage Id --- " + syncBackUpImageId);
                    FileInfo fileInfo = this.getFileInfo(bluKryptElement, syncBackUpImageId, list);
                    fileInfo.setMd5(checkSum);
                    fileInfo.setCompressed(false);
                    fileInfo.setSync(true);
                    logger.debug("--- File Info Id --- " + fileInfo.getId());
                    boolean uploadSuccess = this.uploadService.saveFileInfoForSync(cloudName, bluKryptElement.getGatewayName(), fileInfo);
                    if (!uploadSuccess) {
                        logger.debug("--- Upload was not successful ---");
                        this.uploadService.removeSyncBackUpImage(cloudId, syncBackUpImageId);
                        logger.error(UNABLE_TO_GET_BACKUPID_FROM_EBMS);
                        httpResponse.setStatus(500);
                    } else {
                        logger.debug("--- Inside else ---");
                        long fileSizeInKB = (long)Math.ceil((double)bluKryptElement.getFileSize().longValue() / 1024.0);
                        this.utilService.saveSyncOverview(1, fileSizeInKB, 0L, 0L, 0L);
                        modelAndView.addObject((Object)bluKryptElement);
                        httpResponse.setStatus(200);
                        if (isSearchEnabled) {
                            SearchIndex index = this.formSearchIndex(1, bluKryptElement, new ObjectId(syncBackUpImageId), isFileUnderMC, fsPath);
                            this.utilService.addFileToTable(index, bluKryptElement.getCloudName());
                            logger.debug(END_OF_ADD_SEARCH_INDEX);
                        }
                        this.saveAuditHistoryFileUpload(cloud, bluKryptElement, miniCloud, isCmdLineExecution, remoteAddre);
                    }
                }
                httpResponse.setHeader("syncRevisionId", syncBackUpImageId);
                inputStream.close();
            } else {
                logger.error(UNABLE_TO_GET_BACKUPID_FROM_EBMS);
                httpResponse.setStatus(500);
            }
            this.closeInputStreamIfExists(request);
            logger.debug(" End of close stream ..........................");
        }
        catch (Exception e) {
            logger.debug("--- Exception Stack Trace : ", (Throwable)e);
            e.printStackTrace();
            httpResponse.setStatus(500);
            logger.trace(String.valueOf(e));
            logger.error(ERROR_WHILE_WRITE_CHUNK_FILES + e.getMessage());
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    logger.trace(" exception .. " + String.valueOf(e));
                    logger.error(".. error trying to close stream ..." + e.getMessage());
                }
            }
        }
        logger.debug(END_OF_SAVE_TO_ONE_DRIVE);
        return modelAndView;
    }

    private void saveAuditHistory(String fileName, String filePath, String loginUserName, Cloud cloud, boolean isCmdLineExecution, String remoteAddre) {
        if (!StringUtils.isEmpty((String)loginUserName)) {
            AuditHistory auditHistory = new AuditHistory();
            StringBuilder action = new StringBuilder("uploaded a file but failed due to minicloud size limit reached");
            auditHistory.setAction(action.toString());
            auditHistory.setActionByUserName(loginUserName);
            auditHistory.setActionOnObject(" (" + filePath + fileName + ") ");
            auditHistory.setTimestamp(System.currentTimeMillis());
            if (isCmdLineExecution) {
                auditHistory.setActionUsingObject("command line(" + remoteAddre + ")");
            } else {
                auditHistory.setActionUsingObject(PORTAL);
            }
            auditHistory.setActionType(107);
            logger.debug("Action type" + auditHistory.getActionType());
            if (filePath.substring(8).startsWith("_mc_")) {
                auditHistory.setMiniCloud(true);
                auditHistory.setMcName(SyncUploadController.getMCName(filePath).substring(4));
                auditHistory.setActionOnObject(filePath + "/" + fileName + " inside minicloud " + SyncUploadController.getMCName(filePath).substring(4));
            }
            this.utilService.saveAudit(cloud.getCloudId(), auditHistory);
        }
    }

    private void saveAuditHistoryFileUpload(Cloud cloud, BluKryptElement bluKryptElement, MiniCloud miniCloud, Boolean isCmdLineExecution, String remoteAddre) {
        AuditHistory auditHistory = new AuditHistory();
        String actionOnUser = bluKryptElement.getFilePath() + "/" + bluKryptElement.getFileName();
        if (miniCloud != null && !StringUtils.isEmpty((String)miniCloud.getMiniCloudName())) {
            String mcName = miniCloud.getMiniCloudName();
            if (mcName.startsWith("_mc_")) {
                mcName = mcName.replaceFirst("_mc_", "");
            }
            actionOnUser = actionOnUser + " inside minicloud " + mcName;
            auditHistory.setMiniCloud(true);
            auditHistory.setMcName(mcName);
        }
        auditHistory.setAction("uploaded");
        auditHistory.setActionByUserName(bluKryptElement.getUserName());
        auditHistory.setActionOnObject(actionOnUser);
        auditHistory.setTimestamp(System.currentTimeMillis());
        if (isCmdLineExecution.booleanValue()) {
            auditHistory.setActionUsingObject("command line(" + remoteAddre + ")");
        } else {
            auditHistory.setActionUsingObject(PORTAL);
        }
        auditHistory.setFileCompletePath(bluKryptElement.getFileCompletePath());
        auditHistory.setActionType(3);
        this.utilService.saveAudit(cloud.getCloudId(), auditHistory);
    }

    private void addAuditHitsory(String cloudName, BluKryptElement bluKryptElement, String deviceName) throws UnsupportedEncodingException, IOException, ClientProtocolException {
        CloseableHttpClient httpclient = HttpClientUtil.getSSlConnection();
        String url = PCHelperConstant.getPropertyFileValueForParacloudUrl() + "/paracloud/cloud/" + cloudName + "/sync/portal/upload/audit";
        logger.debug("INSIDEinsert for sync ..... " + url);
        HttpPost httpPost = new HttpPost(url);
        MultipartEntityBuilder entity = MultipartEntityBuilder.create();
        entity.addTextBody("action", "ABCD");
        entity.addTextBody("userName", bluKryptElement.getUserName());
        entity.addTextBody("fileName", bluKryptElement.getFileName());
        entity.addTextBody("filePath", bluKryptElement.getFilePath());
        entity.addTextBody("deviceName", deviceName);
        HttpEntity entity1 = entity.build();
        httpPost.setEntity(entity1);
        logger.debug(bluKryptElement.getFileName() + "INSIDEinsert for sync ..... " + url + "  ...encodedFileName.." + bluKryptElement.getFileCompletePath());
        logger.debug(bluKryptElement.getUserName() + "INSIDEinsert for sync .....   ...encodedFileName..");
        CloseableHttpResponse response = httpclient.execute((ClassicHttpRequest)httpPost);
    }

    private void sendWarningMail(Map<String, String> headerMap, double userStorageQuata) {
        try {
            BluKryptElement bluKryptElement = this.getBluKryptElementValuesStr(headerMap);
            String url = PCHelperConstant.getPropertyFileValueForParacloudUrl() + "/paracloud/cloud/" + bluKryptElement.getCloudName() + "/mail";
            CloseableHttpClient httpclient = HttpClientUtil.getSSlConnection();
            HttpPost httpPost = new HttpPost(url);
            httpPost.setHeader("Content-Type", (Object)"application/json");
            httpPost.setHeader("isInternalCall", (Object)"true");
            JSONObject emailDetails = new JSONObject();
            emailDetails.put("actionBy", (Object)bluKryptElement.getUserName());
            emailDetails.put("action", (Object)"sync-limit-reached");
            emailDetails.put("actionOn", (Object)bluKryptElement.getUserName());
            emailDetails.put("customMailMessage", (Object)String.valueOf(userStorageQuata));
            emailDetails.put("toAdmins", true);
            StringEntity params = new StringEntity(emailDetails.toString());
            httpPost.setEntity((HttpEntity)params);
            CloseableHttpResponse response = httpclient.execute((ClassicHttpRequest)httpPost);
            logger.debug("Send mail result status code :", (Object)response);
        }
        catch (IOException e) {
            logger.trace(String.valueOf(e));
            logger.error("Exception :", (Object)e.getMessage());
        }
    }

    protected String encodeBase64UTFString(String string) {
        String encodedString = string;
        try {
            encodedString = new String(Base64.encodeBase64String((byte[])string.getBytes()));
        }
        catch (Exception e) {
            logger.trace(String.valueOf(e));
            logger.error(e.getMessage());
            logger.debug("UnsupportedEncodingException", (Throwable)e);
        }
        return encodedString;
    }

    private boolean isClamAVScanEnabled(Cloud cl) {
        boolean isClamAVScanEnabled = false;
        List list = cl.getCloudCustomisableDetails();
        list.removeAll(Collections.singleton(null));
        if (!CollectionUtils.isEmpty((Collection)list)) {
            for (CloudCustomisableDetails cloudPluginDetails : list) {
                if (cloudPluginDetails == null || StringUtils.isEmpty((String)cloudPluginDetails.getName()) || !AV_SCAN_ENABLED.equalsIgnoreCase(cloudPluginDetails.getName())) continue;
                isClamAVScanEnabled = true;
                break;
            }
        }
        logger.debug("is ClamAV Scan Enabled...." + isClamAVScanEnabled);
        return isClamAVScanEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"versions/{versionNumber}/clouds/{cloudName}/rwsample/upload/file/"}, method={RequestMethod.POST})
    public void uploadRWSampleFiles(@PathVariable(value="versionNumber") String versionNumber1, @PathVariable(value="cloudName") String cloudName, HttpServletRequest request, HttpServletResponse httpResponse) {
        logger.debug("Inside /rwsample/upload/file/ ------  ");
        File file = null;
        try {
            String filePath = request.getHeader("file-path");
            long count = this.syncUploadService.getRWSampleFilesCount(1);
            if (StringUtils.isEmpty((String)filePath)) {
                httpResponse.setStatus(507);
                return;
            }
            if (count >= 50L) {
                httpResponse.setStatus(417);
                return;
            }
            filePath = this.decodeBase64UTFString(filePath);
            file = new File(filePath);
            logger.debug("file  " + file.getAbsolutePath());
            String md5Checksum = MD5Generator.generateMD5OfFile((File)file);
            RwSampleFileInfo rwSampleFileInfo = new RwSampleFileInfo();
            rwSampleFileInfo.setFileName(file.getName());
            rwSampleFileInfo.setMd5Checksum(md5Checksum);
            rwSampleFileInfo.setTimestamp(System.currentTimeMillis());
            this.syncUploadService.saveRWSampleFile(1, rwSampleFileInfo);
            httpResponse.setStatus(200);
        }
        catch (Exception e) {
            logger.debug("--- Exception Stack Trace : ", (Throwable)e);
            e.printStackTrace();
            httpResponse.setStatus(500);
            logger.trace(String.valueOf(e));
            logger.error(ERROR_WHILE_WRITE_CHUNK_FILES + e.getMessage());
        }
        finally {
            if (file != null && file.exists()) {
                file.delete();
            }
        }
    }
}

