/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.graphsdk.entities;

import com.parablu.graphsdk.entities.GraphErrorResponse;
import java.util.Optional;

public class GraphResponse<A> {
    private final A value;
    private final GraphErrorResponse error;

    GraphResponse(Builder<A> values) {
        this.value = values.value;
        this.error = values.error;
    }

    public Optional<A> value() {
        return Optional.ofNullable(this.value);
    }

    public Optional<GraphErrorResponse> error() {
        return Optional.ofNullable(this.error);
    }

    public static class Builder<A> {
        private A value = null;
        private GraphErrorResponse error = null;

        public Builder<A> setError(GraphErrorResponse error) {
            this.error = error;
            return this;
        }

        public Builder<A> setValue(A value) {
            this.value = value;
            return this;
        }

        public GraphResponse<A> build() {
            return new GraphResponse(this);
        }
    }
}

