/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.cloudbackup;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.microsoft.graph.http.GraphServiceException;
import com.microsoft.graph.models.Drive;
import com.microsoft.graph.models.User;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.GraphServiceClient;
import com.microsoft.graph.requests.UserCollectionPage;
import com.microsoft.graph.requests.UserCollectionRequest;
import com.parablu.cloudbackup.CloudBackupStorageBridge;
import com.parablu.cloudbackup.UploadStatus;
import com.parablu.pcbd.domain.BackUpImage;
import com.parablu.pcbd.domain.BackupBatch;
import com.parablu.pcbd.domain.Cloud;
import com.parablu.pcbd.domain.CloudCustomisableDetails;
import com.parablu.pcbd.domain.Components;
import com.parablu.pcbd.domain.Device;
import com.parablu.pcbd.domain.DeviceBackupOverView;
import com.parablu.pcbd.domain.EWSAppSetting;
import com.parablu.pcbd.domain.MSAppSetting;
import com.parablu.pcbd.domain.ODBBackupBatch;
import com.parablu.pcbd.domain.OfficeBackupPolicy;
import com.pg.controller.BaseController;
import com.pg.controller.Graph;
import com.pg.domain.BackupAttempt;
import com.pg.domain.DriveFileInfo;
import com.pg.exception.BaseException;
import com.pg.exception.OverloadLimitReachedException;
import com.pg.exception.UserStorageLimitReachedException;
import com.pg.helper.constant.PCHelperConstant;
import com.pg.helper.utils.MemoryStore;
import com.pg.httpclient.util.HttpClientUtil;
import com.pg.service.ComponentSettingService;
import com.pg.service.JobConfigService;
import com.pg.service.UtilService;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import okhttp3.Request;
import org.apache.commons.collections.map.HashedMap;
import org.apache.commons.lang.StringUtils;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bson.types.ObjectId;
import org.json.JSONObject;
import org.springframework.beans.BeanUtils;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PropertiesLoaderUtils;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.util.CollectionUtils;

public enum StorageService {
    GETINST;

    private static final String IS_TOMCAT_RUNNING = "isTomcatRunning";
    private static final String BACKUP = "BACKUP";
    private static final String COMPLETED = "COMPLETED";
    private static final String STOPPED_BACKUP_ERROR_CODE = "1209";
    private static final String PAUSED_BACKUP_ERROR_CODE = "1208";
    public static final String INTERRUPTED_STATUS = "INTERRUPTED";
    public static final int STATUS_LICENSE_ACTIVE = 1500;
    public static final int STATUS_LICENSE_EXPIRED = 1501;
    private static final String STARTED = "STARTED";
    static final Logger logger;
    CloudBackupStorageBridge uploadService;
    UtilService utilServiceObj;
    ComponentSettingService componentSettingServiceObj;
    JobConfigService jobConfigServiceObj;
    volatile boolean shutdown = false;
    static final String BASE_FOLDER = "Files/";
    private Set<String> fileUnderProcess = new HashSet<String>();
    private Set<String> deviceUUIDUnderProcess = new HashSet<String>();
    private TimerTask backupTimerTask = null;
    private Timer backupTimer = null;
    private Set<String> batchUnderProcess = new HashSet<String>();
    private static List<ODBBackupBatch> batchList;
    private static List<DriveFileInfo> batchFilesList;
    private static final String DEVICEUUID_O365MAP_IN_MEMSTORE = "deviceUUIDo365MapInMemstore";

    public boolean initialize(CloudBackupStorageBridge uploadService, UtilService utilService, ComponentSettingService componentSettingService, JobConfigService jobConfigService) {
        try {
            logger.debug("Storage service!");
            this.uploadService = uploadService;
            this.utilServiceObj = utilService;
            this.componentSettingServiceObj = componentSettingService;
            this.jobConfigServiceObj = jobConfigService;
            logger.info("response handler started");
        }
        catch (Exception e) {
            logger.error("Failed to start the consumer! " + e.getMessage(), (Throwable)e);
            return false;
        }
        return true;
    }

    private boolean isSharePointBackupEnabled(Cloud cl) {
        boolean isSharePointBackupEnabled = false;
        List list = cl.getCloudCustomisableDetails();
        list.removeAll(Collections.singleton(null));
        if (!org.apache.commons.collections.CollectionUtils.isEmpty((Collection)list)) {
            for (CloudCustomisableDetails cloudPluginDetails : list) {
                if (cloudPluginDetails == null || StringUtils.isEmpty((String)cloudPluginDetails.getName()) || !"Sharepoint Backup Enabled".equalsIgnoreCase(cloudPluginDetails.getName())) continue;
                isSharePointBackupEnabled = true;
                break;
            }
        }
        return isSharePointBackupEnabled;
    }

    public void run() {
        logger.debug("....starting storageservice .....");
        Cloud cloud = this.utilServiceObj.getCloud(1);
        boolean isExchangeBackupEnabled = this.isExchangeBackupEnabled(cloud);
        boolean isOneDriveForBusinessBackupEnabled = this.isOneDriveForBusinessBackupEnabled(cloud);
        boolean isSharePointBackupEnabled = this.isSharePointBackupEnabled(cloud);
        boolean success = false;
        do {
            logger.debug("...try graphclient....");
            try {
                Graph graph = Graph.getInstance();
                ((UserCollectionRequest)graph.getGraphClient().users().buildRequest(new Option[0])).get();
                success = true;
            }
            catch (Exception e) {
                String msg;
                String string = msg = e.getMessage() == null ? "" : e.getMessage();
                if (!msg.contains("Cannot invoke \"com.microsoft.graph.requests.GraphServiceClient.users()\"")) {
                    logger.error("Unexpected error probing Graph.users():", (Throwable)e);
                    break;
                }
                logger.error("Graph client invalid\u2014resetting and will retry in 5 minutes", (Throwable)e);
                Graph.resetInstance();
                if (StringUtils.isEmpty((String)PCHelperConstant.getMSTenantId()) || !PCHelperConstant.getMSTenantId().matches("^[0-9a-fA-F-]{36}$")) {
                    logger.debug("....invalid tenantId....." + PCHelperConstant.getMSTenantId());
                    MSAppSetting msAppSetting = this.utilServiceObj.getMSAppSettingsDetails(1);
                    if (msAppSetting != null) {
                        logger.debug(msAppSetting.getTenantId() + "....msAppSetting1...>" + msAppSetting.getClientId());
                        PCHelperConstant.setMSClientId((String)msAppSetting.getClientId());
                        PCHelperConstant.setMSClientSecret((String)msAppSetting.getClientSecretKey());
                        PCHelperConstant.setMSTenantId((String)msAppSetting.getTenantId());
                        PCHelperConstant.setMSSharePointUrl((String)msAppSetting.getClientTokenURL());
                    }
                }
                try {
                    TimeUnit.MINUTES.sleep(5L);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    logger.warn("Interrupted while waiting to retry Graph client init", (Throwable)ie);
                    break;
                }
            }
        } while (!success);
        if (isOneDriveForBusinessBackupEnabled || isExchangeBackupEnabled || isSharePointBackupEnabled) {
            logger.debug("Storage service has started running! - " + Thread.currentThread().getName());
            logger.debug(isSharePointBackupEnabled + "...inside while loop check....onedrive.. " + isOneDriveForBusinessBackupEnabled + "..exchange.." + isExchangeBackupEnabled);
            ThreadFactoryBuilder factoryBuilder = new ThreadFactoryBuilder().setNameFormat("o365Bkp-%d");
            ExecutorService executor = null;
            try {
                this.setThreads();
                long threadSize = PCHelperConstant.getPGOverloadLimit();
                logger.debug("...threads...." + threadSize);
                int cloudId = cloud.getCloudId();
                do {
                    if (threadSize > 0L) continue;
                    logger.debug("......wait for pgoverload feq check mins and retry.." + PCHelperConstant.getPGOverloadLimitFreqCheck());
                    Thread.sleep(PCHelperConstant.getPGOverloadLimitFreqCheck() * 60000);
                    List<ODBBackupBatch> batchListVal = this.getBatchFromList(cloudId, true, true);
                    for (ODBBackupBatch odbBackupBatch : batchListVal) {
                        String batchId = odbBackupBatch.getId().toString();
                        BackupBatch backupBatch = this.utilServiceObj.getBackupBatchById(cloudId, batchId);
                        if (backupBatch == null) continue;
                        String policyName = odbBackupBatch.getOdbPolicyName();
                        int errorCode = 0;
                        errorCode = this.getPrevBatchErrorCode(cloud, batchId);
                        logger.debug("errorrcode...." + errorCode);
                        if (errorCode == 1208) continue;
                        logger.debug(errorCode + "...errorcode for item.... " + batchId);
                        this.utilServiceObj.updateDeferedBatchStatusInOdServer(odbBackupBatch.getId(), policyName);
                        this.updateBatchAndOverview(cloudId, backupBatch.getId(), INTERRUPTED_STATUS, backupBatch.getDeviceUUID(), 1996);
                        this.updateBatchAttempt(cloudId, backupBatch, false, false, true, false);
                    }
                    this.setThreads();
                    threadSize = PCHelperConstant.getPGOverloadLimit();
                } while (threadSize <= 0L);
                int threadSizeVal = (int)threadSize;
                executor = Executors.newFixedThreadPool(threadSizeVal, factoryBuilder.build());
                batchList = this.getBatchFromList(cloudId, false, false);
                ExecutorCompletionService<String> pool = new ExecutorCompletionService<String>(executor);
                this.checkThreadStatusAndStartUpload(cloud, executor, pool);
                for (int i = 0; i < threadSizeVal; ++i) {
                    logger.debug("Creating thread for first time>>>>>>>>> i value::" + i);
                    this.callUploadFiles(cloud, executor, pool);
                }
                logger.debug(" exit upload part..........");
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error(" exception in backup upload job......." + e.getMessage());
                logger.trace("exception in backup upload job ......." + String.valueOf(e));
            }
            logger.debug("Done!");
        }
    }

    private void setThreads() {
        Properties props = null;
        try {
            String pgOverloadLimitFreqCheckStr;
            long threadSize;
            String threadstr;
            ClassPathResource resource = new ClassPathResource("privacygateway.properties");
            props = PropertiesLoaderUtils.loadProperties((Resource)resource);
            logger.debug(".....componentn name ..... " + props.getProperty("componentName"));
            Components components = this.componentSettingServiceObj.getComponents(props.getProperty("componentName"), 1);
            logger.debug("getting components properties from db of" + components.getComponentName());
            Map componentProperties = components.getComponentsProperties();
            if (componentProperties.containsKey("pgOverloadLimit") && !StringUtils.isEmpty((String)(threadstr = (String)componentProperties.get("pgOverloadLimit")))) {
                threadSize = Integer.parseInt(threadstr);
                logger.debug("...threads from collectionpgoverload ...." + threadSize);
                PCHelperConstant.setPGOverloadLimit((String)("" + threadSize));
            }
            if (componentProperties.containsKey("pgOverLoadLimitFreqCheck") && !StringUtils.isEmpty((String)(pgOverloadLimitFreqCheckStr = (String)componentProperties.get("pgOverLoadLimitFreqCheck")))) {
                logger.debug("...val for pgOverloadLimitFreqCheckStr ...." + pgOverloadLimitFreqCheckStr);
                PCHelperConstant.setPGOverloadLimitFreqCheck((String)pgOverloadLimitFreqCheckStr);
            }
            if (componentProperties.containsKey("graphTimeoutInMins")) {
                PCHelperConstant.setGraphTimeoutInMins((String)((String)componentProperties.get("graphTimeoutInMins")));
                int mins = 30;
                String minsstr = (String)componentProperties.get("graphTimeoutInMins");
                if (!StringUtils.isEmpty((String)minsstr)) {
                    mins = Integer.parseInt(minsstr);
                    logger.debug("...setGraphTimeoutInMins ...." + mins);
                    PCHelperConstant.setGraphTimeoutInMins((String)("" + mins));
                }
            }
            if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)PCHelperConstant.getComponentName())) {
                PCHelperConstant.setComponentName((String)components.getComponentName());
            }
            if (componentProperties.containsKey("officeDownloadThreads")) {
                String threadstr2 = (String)componentProperties.get("officeDownloadThreads");
                if (!StringUtils.isEmpty((String)threadstr2)) {
                    threadSize = Integer.parseInt(threadstr2);
                    logger.debug("...threads from db for offfice ...." + threadSize);
                    PCHelperConstant.setOfficeThreadsValue((String)("" + threadSize));
                }
            } else {
                PCHelperConstant.setOfficeThreadsValue((String)"2");
            }
        }
        catch (Exception ee) {
            ee.printStackTrace();
            logger.error("...error trying to get threads..." + ee.getMessage());
        }
    }

    private boolean isExchangeBackupEnabled(Cloud cl) {
        boolean isExpiredFileDeleteEnabled = false;
        List list = cl.getCloudCustomisableDetails();
        list.removeAll(Collections.singleton(null));
        if (!org.apache.commons.collections.CollectionUtils.isEmpty((Collection)list)) {
            for (CloudCustomisableDetails cloudPluginDetails : list) {
                if (cloudPluginDetails == null || StringUtils.isEmpty((String)cloudPluginDetails.getName()) || !"Exchange Backup Enabled".equalsIgnoreCase(cloudPluginDetails.getName())) continue;
                isExpiredFileDeleteEnabled = true;
                break;
            }
        }
        return isExpiredFileDeleteEnabled;
    }

    private boolean isOneDriveForBusinessBackupEnabled(Cloud cl) {
        boolean isExpiredFileDeleteEnabled = false;
        List list = cl.getCloudCustomisableDetails();
        list.removeAll(Collections.singleton(null));
        if (!org.apache.commons.collections.CollectionUtils.isEmpty((Collection)list)) {
            for (CloudCustomisableDetails cloudPluginDetails : list) {
                if (cloudPluginDetails == null || StringUtils.isEmpty((String)cloudPluginDetails.getName()) || !"OneDrive Backup Enabled".equalsIgnoreCase(cloudPluginDetails.getName())) continue;
                isExpiredFileDeleteEnabled = true;
                break;
            }
        }
        return isExpiredFileDeleteEnabled;
    }

    private void callUploadFiles(Cloud cloud, ExecutorService executor, CompletionService<String> pool) {
        BaseController.printLogs("Files to backup ............... :", PCHelperConstant.isBrevityLogging());
        Runnable uploadJob = () -> this.uploadFiles(cloud, executor, pool);
        pool.submit(uploadJob, "");
    }

    private void uploadFiles(Cloud cloud, ExecutorService executor, CompletionService<String> pool) {
        BaseController.printLogs("....inside while loop..........", PCHelperConstant.isBrevityLogging());
        ODBBackupBatch backupBatch = null;
        try {
            backupBatch = this.getBackupBatchFromOneDriveServer();
            if (backupBatch != null) {
                this.processMessage(backupBatch, cloud, executor);
                logger.error(String.valueOf(backupBatch.getId()) + " %%%%%%% upload completed for file ...." + backupBatch.getUserName());
            }
            if (!CollectionUtils.isEmpty(batchList)) {
                logger.debug("Thread ready for next File .... " + batchList.size());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("exception inside storageservice .... " + e.getMessage());
            logger.trace("exception inside storageservice ...." + String.valueOf(e));
        }
        if (backupBatch != null && backupBatch.getId() != null) {
            this.batchUnderProcess.remove(backupBatch.getId().toString());
            this.deviceUUIDUnderProcess.remove(backupBatch.getDeviceUUID());
        }
        logger.error("no files to upload so wait and then retry>>>>");
        try {
            Thread.sleep(10000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.callUploadFiles(cloud, executor, pool);
    }

    private synchronized boolean isBackupAllowed(String deviceUUIDForBkp) {
        Map<String, Long> deviceUUIDMap = new HashMap<String, Long>();
        boolean allowBackup = false;
        if (PCHelperConstant.getPGOverloadLimit() <= 0) {
            logger.error("...device overload limit reached ..... " + PCHelperConstant.getPGOverloadLimit());
            return allowBackup;
        }
        if (MemoryStore.get((String)DEVICEUUID_O365MAP_IN_MEMSTORE) == null) {
            StorageService.updateDeviceMap(deviceUUIDForBkp, deviceUUIDMap);
            logger.debug("$$$$$$NewdeviceUUID First Time map initializtion  ........... " + deviceUUIDForBkp);
            return true;
        }
        deviceUUIDMap = (Map)MemoryStore.get((String)DEVICEUUID_O365MAP_IN_MEMSTORE);
        if (deviceUUIDMap.containsKey(deviceUUIDForBkp) || deviceUUIDMap.size() < PCHelperConstant.getPGOverloadLimit()) {
            StorageService.updateDeviceMap(deviceUUIDForBkp, deviceUUIDMap);
            allowBackup = true;
        }
        if (!allowBackup) {
            logger.debug("&&&%%% PG OVERLOAD Limit Reached  size........... " + deviceUUIDMap.size());
        } else {
            StorageService.updateDeviceMap(deviceUUIDForBkp, deviceUUIDMap);
            logger.debug("###@@@ NewdeviceUUID added for PG .......... " + deviceUUIDMap.size() + "...." + deviceUUIDForBkp);
        }
        return allowBackup;
    }

    private static void updateDeviceMap(String deviceUUIDForBackup, Map<String, Long> deviceUUIDMap) {
        deviceUUIDMap.put(deviceUUIDForBackup, System.currentTimeMillis());
        MemoryStore.add((String)DEVICEUUID_O365MAP_IN_MEMSTORE, deviceUUIDMap);
    }

    private int getPrevBatchErrorCode(Cloud cloud, String batchId) {
        int errorCode = 0;
        BackupBatch prevBkpBatch = this.utilServiceObj.getBackupBatchById(cloud.getCloudId(), batchId);
        if (prevBkpBatch != null && StringUtils.isNotEmpty((String)prevBkpBatch.getErrorCode()) && (prevBkpBatch.getErrorCode().equals(STOPPED_BACKUP_ERROR_CODE) || prevBkpBatch.getErrorCode().equals(PAUSED_BACKUP_ERROR_CODE))) {
            errorCode = prevBkpBatch.getErrorCode().equals(STOPPED_BACKUP_ERROR_CODE) ? 1209 : 1208;
            logger.debug(errorCode + ".....batch status current..." + prevBkpBatch.getErrorCode());
        }
        return errorCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processMessage(ODBBackupBatch odbbackupBatch, Cloud cloudval, ExecutorService executor) {
        String action;
        NotifierEmailBodyElement notifierEmailBodyElement;
        boolean isTomcatRunning = true;
        if (MemoryStore.get((String)IS_TOMCAT_RUNNING) != null) {
            isTomcatRunning = (Boolean)MemoryStore.get((String)IS_TOMCAT_RUNNING);
        }
        if (!isTomcatRunning) {
            logger.error("....tomcat is stopping so no process of files.......");
            return;
        }
        try {
            Thread.sleep(TimeUnit.SECONDS.toMillis(5L));
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        ODBBackupBatch odbbackupBatchExists = this.utilServiceObj.getODBBackupBatch(cloudval.getCloudId(), odbbackupBatch.getId(), odbbackupBatch.getOdbPolicyName());
        if (odbbackupBatchExists == null) {
            logger.debug(".....batch is already processed...." + odbbackupBatch.getId().toString());
            return;
        }
        final BackupBatch backupBatch = new BackupBatch();
        BeanUtils.copyProperties((Object)odbbackupBatch, (Object)backupBatch);
        backupBatch.setBatchStartTimestamp(odbbackupBatch.getBatchStartTimestamp());
        backupBatch.setId(odbbackupBatch.getId());
        String policyName = backupBatch.getOdbPolicyName();
        String batchId = backupBatch.getId().toString();
        int cloudId = cloudval.getCloudId();
        DeviceBackupOverView deviceBackupOverView = this.utilServiceObj.getDeviceBkpOverviewForDeviceUUID(cloudval.getCloudId(), backupBatch.getDeviceUUID());
        long batchStartTime = odbbackupBatch.getBatchStartTimestamp();
        BackupBatch pbBkpBatch = this.utilServiceObj.getBackupBatchById(cloudval.getCloudId(), batchId);
        logger.debug(batchId + ".. files to process backup for id latest..... " + String.valueOf(pbBkpBatch));
        boolean fullBackup = false;
        if (pbBkpBatch != null) {
            logger.debug(fullBackup + "******" + pbBkpBatch.isFullBackup() + "......" + pbBkpBatch.getStatus() + ".. batch details..... " + pbBkpBatch.getNoOfFiles() + "...." + pbBkpBatch.getUploadedFiles());
            fullBackup = pbBkpBatch.isFullBackup();
            if (pbBkpBatch.getStatus().equalsIgnoreCase(BackupBatch.STATUS.SCANNING.toString())) {
                pbBkpBatch = null;
            }
        } else {
            logger.debug(".. batch details null..... ");
        }
        int uploadedFiles = 0;
        int overAllPrevFiles = 0;
        long totalNoOfFiles = 0L;
        if (pbBkpBatch != null) {
            logger.debug(pbBkpBatch.getNoOfFiles() + ".. files to process backup for id..... " + pbBkpBatch.getUploadedFiles());
            if (!StringUtils.isEmpty((String)pbBkpBatch.getUploadedFiles())) {
                String[] parts = pbBkpBatch.getUploadedFiles().split("/");
                try {
                    uploadedFiles = Integer.parseInt(parts[0]);
                    overAllPrevFiles = Integer.parseInt(parts[1]);
                }
                catch (Exception e) {
                    logger.trace("Exception  :" + String.valueOf(e));
                    logger.error("Exception  :" + e.getMessage());
                }
            }
        }
        logger.debug(uploadedFiles + "...overall files latest .... " + overAllPrevFiles);
        totalNoOfFiles = pbBkpBatch != null && pbBkpBatch.getNoOfFiles() > 0L ? (long)overAllPrevFiles : this.uploadService.getTotalFilesCountByBatchId(cloudval.getCloudId(), batchId, backupBatch.getDeviceUUID());
        if (totalNoOfFiles < 0L) {
            totalNoOfFiles = this.uploadService.getTotalFilesCountByBatchId(cloudval.getCloudId(), batchId, backupBatch.getDeviceUUID());
        }
        if (pbBkpBatch == null) {
            long failedFilesCount = this.utilServiceObj.getTotaFailedlFilesFromPrevBackup(backupBatch.getDeviceUUID());
            logger.debug(failedFilesCount + "....total size to upload fdf.&*&ss*... " + totalNoOfFiles);
            if (failedFilesCount > 0L) {
                totalNoOfFiles += failedFilesCount;
            }
            logger.debug(totalNoOfFiles + "....total attempt totalNoOfFiles to upload fdf.&*&*... " + totalNoOfFiles);
            List<DriveFileInfo> failedFiles = this.uploadService.getFailedFiles(backupBatch.getDeviceUUID());
            if (!org.apache.commons.collections.CollectionUtils.isEmpty(failedFiles)) {
                for (DriveFileInfo driveFileInfo : failedFiles) {
                    driveFileInfo.setBackupBatchId(batchId);
                    driveFileInfo.setFailedFile(true);
                    try {
                        this.utilServiceObj.saveDriveFileInfo(driveFileInfo);
                        ++totalNoOfFiles;
                    }
                    catch (DuplicateKeyException duplicateKeyException) {}
                }
            }
        }
        String uploadedSizeStr = "0";
        if (pbBkpBatch != null) {
            backupBatch.setTotalSizeToUpload(pbBkpBatch.getTotalSizeToUpload());
            backupBatch.setBatchStartTimestamp(pbBkpBatch.getBatchStartTimestamp());
            batchStartTime = pbBkpBatch.getBatchStartTimestamp();
            uploadedSizeStr = pbBkpBatch.getUploadedSize();
        }
        backupBatch.setTotalNoOfFiles("" + totalNoOfFiles);
        boolean isFirstAttempt = false;
        if (pbBkpBatch == null) {
            isFirstAttempt = true;
        }
        com.parablu.pcbd.domain.User userObj = this.utilServiceObj.getUserInfoByName(1, backupBatch.getUserName());
        int unassErrorCode = 0;
        try {
            unassErrorCode = Integer.parseInt(backupBatch.getErrorCode());
            if (userObj != null && userObj.isBackupTargetAssigned() && !userObj.isFailedMailBox()) {
                logger.debug("..user assigned back....");
                unassErrorCode = 0;
            }
        }
        catch (Exception driveFileInfo) {
            // empty catch block
        }
        logger.debug(uploadedFiles + ".....fileinfobkpafter..." + uploadedSizeStr + "..batchid..." + batchId + "....." + backupBatch.getId().toString());
        BackupBatch stBatch = this.startBackupBatch(backupBatch, cloudval, uploadedFiles, totalNoOfFiles, unassErrorCode, batchStartTime, fullBackup, uploadedSizeStr);
        boolean startOp = true;
        boolean overLoad = false;
        if (PCHelperConstant.getPGOverloadLimit() <= 0) {
            overLoad = true;
        }
        int licenseCode = this.vaildatedLicensceStatus(cloudval);
        boolean licenseExpired = false;
        if (licenseCode == 1501) {
            licenseExpired = true;
        }
        this.updateBatchAttempt(cloudval.getCloudId(), stBatch, isFirstAttempt, startOp, overLoad, licenseExpired);
        isFirstAttempt = false;
        startOp = false;
        int errorCode = 0;
        if (unassErrorCode > 0) {
            errorCode = unassErrorCode;
        }
        boolean isMail = false;
        boolean allFilesCompleted = false;
        boolean isSharePoint = false;
        Device device = this.utilServiceObj.getDeviceForUUID(cloudval.getCloudId(), backupBatch.getDeviceUUID());
        String driveId = "";
        if (Device.TYPE.ONEDRIVE.toString().equalsIgnoreCase(deviceBackupOverView.getOsType())) {
            driveId = this.getDriveIdForUser(userObj.getEmailId());
        }
        if ((pbBkpBatch = this.utilServiceObj.getBackupBatchById(cloudval.getCloudId(), batchId)) != null && pbBkpBatch.getTotalNoOfFiles().equalsIgnoreCase("0")) {
            this.utilServiceObj.updateTotalNoOFFiles(cloudval.getCloudId(), batchId, totalNoOfFiles);
        }
        if (deviceBackupOverView == null) {
            logger.debug(" No overview so create deviceoverview backup ...." + backupBatch.getDeviceUUID());
            this.utilServiceObj.saveDeviceBackupOverView(cloudId, device);
            deviceBackupOverView = this.utilServiceObj.getDeviceBkpOverviewForDeviceUUID(cloudval.getCloudId(), backupBatch.getDeviceUUID());
        }
        if (!StringUtils.isEmpty((String)deviceBackupOverView.getDeviceType()) && deviceBackupOverView.getDeviceType().equalsIgnoreCase(Device.TYPE.OUTLOOK.name())) {
            isMail = true;
        }
        if (!StringUtils.isEmpty((String)deviceBackupOverView.getDeviceType()) && deviceBackupOverView.getDeviceType().equalsIgnoreCase(Device.TYPE.SHAREPOINT.name())) {
            isSharePoint = true;
        }
        String token = "";
        if (isMail) {
            try {
                EWSAppSetting appSetting = this.utilServiceObj.getEwsAppSettingDetail(1);
                if (appSetting != null) {
                    token = this.getEWSTokenFromDb(1);
                    if (StringUtils.isEmpty((String)token)) {
                        logger.debug("..token empty  so wait for 1 min...");
                        Thread.sleep(6000L);
                    }
                    token = this.getEWSTokenFromDb(1);
                }
            }
            catch (Exception e) {
                logger.error("...unable to get ews token....");
            }
        }
        final AtomicInteger threadNumber = new AtomicInteger(1);
        ThreadFactory threadFactory = new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = new Thread(r);
                thread.setName(backupBatch.getUserName() + "-" + threadNumber.getAndIncrement());
                thread.setUncaughtExceptionHandler((t, e) -> logger.error("Uncaught exception in thread " + t.getName() + ": " + e.getMessage()));
                return thread;
            }
        };
        logger.debug(batchId + "....fileinoflist before....." + batchId);
        batchId = backupBatch.getId().toString();
        try {
            Thread.sleep(TimeUnit.SECONDS.toMillis(10L));
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
        logger.debug(batchId + "....fileinoflist AFTER....." + batchId);
        List<DriveFileInfo> fileInfoList = this.getDriveFileInfoFromListForBatchId(cloudval.getCloudId(), backupBatch.getId().toString(), backupBatch.getDeviceUUID());
        logger.debug(batchId + "....fileinoflist....." + fileInfoList.size());
        String batchIdVal = batchId;
        do {
            String driveIdVal = driveId;
            int threadsForBkp = 1;
            if (PCHelperConstant.getNoOfO365BkpThreads() > 2) {
                threadsForBkp = PCHelperConstant.getNoOfO365BkpThreads();
            }
            if (!backupBatch.isLatestBatch()) {
                threadsForBkp = 1;
            }
            logger.debug(PCHelperConstant.getNoOfO365BkpThreads() + "....threads for Bkp....." + fileInfoList.size());
            ExecutorService executorService = Executors.newFixedThreadPool(threadsForBkp, threadFactory);
            ExecutorCompletionService<Void> completionService = new ExecutorCompletionService<Void>(executorService);
            String tokenVal = token;
            if (!userObj.isOnedriveBkpEnabled() && device != null && Device.TYPE.ONEDRIVE.toString().equalsIgnoreCase(device.getOsType())) {
                errorCode = 1209;
            } else if (!userObj.isExchangeBkpEnabled() && device != null && Device.TYPE.OUTLOOK.toString().equalsIgnoreCase(device.getOsType())) {
                errorCode = 1209;
            } else if (!userObj.isSite() && device != null && Device.TYPE.SHAREPOINT.toString().equalsIgnoreCase(device.getOsType())) {
                errorCode = 1209;
            }
            if (errorCode <= 0) {
                for (DriveFileInfo driveFileInfo : fileInfoList) {
                    completionService.submit(() -> {
                        this.uploadBatchFiles(batchIdVal, driveFileInfo, cloudval, backupBatch, odbbackupBatch.getOdbPolicyName(), userObj, driveIdVal, driveFileInfo.isFullBackup(), backupBatch.getOfficeBackupPolicy().isCreateMailLinkEnabled(), device, tokenVal);
                        return null;
                    });
                }
                boolean shouldShutdown = false;
                try {
                    for (int i = 0; i < fileInfoList.size(); ++i) {
                        Future future = completionService.take();
                        try {
                            future.get();
                            continue;
                        }
                        catch (ExecutionException e) {
                            logger.error("Exception in downloading latest: " + e.getCause().getMessage());
                            if (e.getCause().getMessage().contains("user storage limit reached")) {
                                errorCode = 1981;
                            } else if (e.getCause().getMessage().contains("storage limit reached")) {
                                errorCode = 1996;
                            }
                            logger.debug("...error code ...." + errorCode);
                            shouldShutdown = true;
                        }
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                finally {
                    if (shouldShutdown) {
                        logger.error("Shutting down executor service due to task failure.");
                        executorService.shutdownNow();
                    } else {
                        executorService.shutdown();
                    }
                }
            } else {
                logger.debug("error code: " + errorCode);
                break;
            }
            logger.debug(".....iteration completed..." + allFilesCompleted + "...." + errorCode);
            if (errorCode > 0) {
                logger.debug(".....iteration completed because of errorcode ..." + allFilesCompleted + "...." + errorCode);
                break;
            }
            pbBkpBatch = this.utilServiceObj.getBackupBatchById(cloudval.getCloudId(), batchId);
            if (pbBkpBatch != null) {
                errorCode = StringUtils.isEmpty((String)pbBkpBatch.getErrorCode()) ? 0 : Integer.parseInt(pbBkpBatch.getErrorCode());
            }
            if (errorCode <= 0 && org.apache.commons.collections.CollectionUtils.isEmpty(fileInfoList = this.getDriveFileInfoFromListForBatchId(cloudval.getCloudId(), batchId, device.getDeviceUUID()))) {
                allFilesCompleted = true;
            }
            logger.debug(".....iteration completed1..." + allFilesCompleted + "...." + errorCode);
            if (errorCode <= 0) continue;
            logger.debug(".....iteration completed12..." + allFilesCompleted + "...." + errorCode);
            break;
        } while (!allFilesCompleted);
        if (allFilesCompleted && errorCode != Integer.parseInt(STOPPED_BACKUP_ERROR_CODE) && errorCode != Integer.parseInt(PAUSED_BACKUP_ERROR_CODE)) {
            BaseController.printLogs("......allfilescompleted.......", PCHelperConstant.isBrevityLogging());
            this.uploadService.deleteBatchFromOdServer(backupBatch.getId(), policyName);
            this.updateBatchAndOverview(cloudval.getCloudId(), backupBatch.getId(), COMPLETED, backupBatch.getDeviceUUID(), errorCode);
            logger.debug(backupBatch.getTotalNoOfFiles() + "..  completed...." + String.valueOf(backupBatch.getId()));
            if (deviceBackupOverView != null && StringUtils.isEmpty((String)deviceBackupOverView.getLastSuccessfulBkp())) {
                notifierEmailBodyElement = new NotifierEmailBodyElement(this);
                notifierEmailBodyElement.setCloudName(cloudval.getCloudName());
                notifierEmailBodyElement.setDeviceName(deviceBackupOverView.getDeviceName());
                notifierEmailBodyElement.setNoOfFilesBackedUp(backupBatch.getTotalNoOfFiles());
                logger.debug("...before mail..." + backupBatch.getTotalNoOfFiles());
                BackupBatch batch = this.utilServiceObj.getBackupBatchById(cloudval.getCloudId(), batchId);
                if (batch != null) {
                    logger.debug("...before mail batch..." + batch.getTotalNoOfFiles());
                    notifierEmailBodyElement.setNoOfFilesBackedUp(batch.getTotalNoOfFiles());
                }
                if (!StringUtils.isEmpty((String)batch.getUploadedSize())) {
                    notifierEmailBodyElement.setTotalBackupSize(StorageService.formatFileSize(Long.parseLong(batch.getUploadedSize())));
                } else {
                    notifierEmailBodyElement.setTotalBackupSize("0");
                }
                action = "first-backup-completed";
                if (isSharePoint) {
                    action = "site-first-backup-completed";
                }
                this.sendEmail(action, deviceBackupOverView.getUserName(), deviceBackupOverView.getUserName(), deviceBackupOverView.getEmailId(), notifierEmailBodyElement, deviceBackupOverView.getDeviceUUID(), isSharePoint, deviceBackupOverView.getUserName());
            }
            this.updateBatchAttempt(cloudId, backupBatch, isFirstAttempt, startOp, overLoad, licenseExpired);
            long uploadedSize = 0L;
            if (!StringUtils.isEmpty((String)backupBatch.getUploadedSize())) {
                uploadedSize = Long.parseLong(backupBatch.getUploadedSize());
            }
            logger.debug("...batchunderprocess....." + batchId);
            this.batchUnderProcess.remove(batchId);
            this.deviceUUIDUnderProcess.remove(backupBatch.getDeviceUUID());
        }
        logger.debug("....error code..... " + errorCode);
        if (errorCode == Integer.parseInt(STOPPED_BACKUP_ERROR_CODE)) {
            logger.debug("......STOPPED_BACKUP_ERROR_CODE.......");
            this.uploadService.deleteBatchFromOdServer(backupBatch.getId(), policyName);
            this.utilServiceObj.updatePrevDeviceDeltaToken(cloudval.getCloudId(), backupBatch.getDeviceUUID());
            this.updateBatchAndOverview(cloudval.getCloudId(), backupBatch.getId(), "ABORTED", backupBatch.getDeviceUUID(), errorCode);
            this.batchUnderProcess.remove(batchId);
            this.deviceUUIDUnderProcess.remove(backupBatch.getDeviceUUID());
            long uploadedSize = 0L;
            if (!StringUtils.isEmpty((String)backupBatch.getUploadedSize())) {
                uploadedSize = Long.parseLong(backupBatch.getUploadedSize());
            }
            this.updateBatchAttempt(cloudId, backupBatch, isFirstAttempt, startOp, overLoad, licenseExpired);
        } else if (errorCode == 449 || errorCode == 1981) {
            logger.debug("... http limit reached..... ");
            this.uploadService.deleteBatchFromOdServer(backupBatch.getId(), policyName);
            this.updateBatchAndOverview(cloudval.getCloudId(), backupBatch.getId(), "ABORTED", backupBatch.getDeviceUUID(), 1981);
            this.batchUnderProcess.remove(batchId);
            this.deviceUUIDUnderProcess.remove(backupBatch.getDeviceUUID());
            long uploadedSize = 0L;
            if (!StringUtils.isEmpty((String)backupBatch.getUploadedSize())) {
                uploadedSize = Long.parseLong(backupBatch.getUploadedSize());
            }
            logger.debug("....user storage limit reached ss... ");
            this.updateBatchAttempt(cloudId, backupBatch, isFirstAttempt, startOp, overLoad, licenseExpired);
        } else if (errorCode == 1501) {
            logger.debug("... Cloud license Expired1..... ");
            this.utilServiceObj.updateLicenseExpiredBatchStatusInOdServer(backupBatch.getId(), policyName);
            this.updateBatchAndOverview(cloudval.getCloudId(), backupBatch.getId(), INTERRUPTED_STATUS, backupBatch.getDeviceUUID(), errorCode);
            this.batchUnderProcess.remove(batchId);
            this.deviceUUIDUnderProcess.remove(backupBatch.getDeviceUUID());
            logger.debug("... Cloud license Expired2..... ");
            this.updateBatchAttempt(cloudId, backupBatch, isFirstAttempt, startOp, overLoad, licenseExpired);
        } else if (errorCode == 1996) {
            logger.debug("... overload limit reached .... ");
            this.utilServiceObj.updateDeferedBatchStatusInOdServer(backupBatch.getId(), policyName);
            this.updateBatchAndOverview(cloudval.getCloudId(), backupBatch.getId(), INTERRUPTED_STATUS, backupBatch.getDeviceUUID(), 1996);
            this.batchUnderProcess.remove(batchId);
            this.deviceUUIDUnderProcess.remove(backupBatch.getDeviceUUID());
            this.updateBatchAttempt(cloudId, backupBatch, isFirstAttempt, startOp, overLoad, licenseExpired);
            logger.debug("... overload limit reached .updated ... ");
        } else if (errorCode == Integer.parseInt(PAUSED_BACKUP_ERROR_CODE)) {
            logger.debug("... PAUSED_BACKUP_ERROR_CODE..... ");
            this.utilServiceObj.updateBatchStatusInOdServer(backupBatch.getId(), policyName);
            this.updateBatchAndOverview(cloudval.getCloudId(), backupBatch.getId(), "PAUSED", backupBatch.getDeviceUUID(), errorCode);
            this.batchUnderProcess.remove(batchId);
            this.deviceUUIDUnderProcess.remove(backupBatch.getDeviceUUID());
            long uploadedSize = 0L;
            if (!StringUtils.isEmpty((String)backupBatch.getUploadedSize())) {
                uploadedSize = Long.parseLong(backupBatch.getUploadedSize());
            }
            this.updateBatchAttempt(cloudId, backupBatch, isFirstAttempt, startOp, overLoad, licenseExpired);
        } else if (unassErrorCode == 543 || unassErrorCode == 544) {
            logger.debug("... Target unassigned..... ");
            this.uploadService.deleteBatchFromOdServer(backupBatch.getId(), policyName);
            this.updateBatchAndOverview(cloudval.getCloudId(), backupBatch.getId(), INTERRUPTED_STATUS, backupBatch.getDeviceUUID(), unassErrorCode);
            this.batchUnderProcess.remove(batchId);
            this.deviceUUIDUnderProcess.remove(backupBatch.getDeviceUUID());
            long uploadedSize = 0L;
            if (!StringUtils.isEmpty((String)backupBatch.getUploadedSize())) {
                uploadedSize = Long.parseLong(backupBatch.getUploadedSize());
            }
            logger.debug("... Target unassigned... ");
            this.updateBatchAttempt(cloudId, backupBatch, isFirstAttempt, startOp, overLoad, licenseExpired);
        } else if (!allFilesCompleted && StringUtils.isEmpty((String)backupBatch.getTotalNoOfFiles())) {
            logger.debug("... !allFilesCompleted && StringUtils.isEmpty(backupBatch.getTotalNoOfFiles())..... ");
            fileInfoList = this.getDriveFileInfoFromListForBatchId(cloudval.getCloudId(), batchId, device.getDeviceUUID());
            if (org.apache.commons.collections.CollectionUtils.isEmpty(fileInfoList)) {
                this.uploadService.deleteBatchFromOdServer(backupBatch.getId(), policyName);
                this.batchUnderProcess.remove(batchId);
                this.deviceUUIDUnderProcess.remove(backupBatch.getDeviceUUID());
                this.updateBatchAndOverview(cloudval.getCloudId(), backupBatch.getId(), COMPLETED, backupBatch.getDeviceUUID(), errorCode);
                if (deviceBackupOverView != null && StringUtils.isEmpty((String)deviceBackupOverView.getLastSuccessfulBkp())) {
                    notifierEmailBodyElement = new NotifierEmailBodyElement(this);
                    notifierEmailBodyElement.setCloudName(cloudval.getCloudName());
                    notifierEmailBodyElement.setDeviceName(deviceBackupOverView.getDeviceName());
                    logger.debug("...before mail1..." + backupBatch.getTotalNoOfFiles());
                    BackupBatch batch = this.utilServiceObj.getBackupBatchById(cloudval.getCloudId(), batchId);
                    if (batch != null) {
                        logger.debug("...before mail batch f..." + batch.getTotalNoOfFiles());
                        notifierEmailBodyElement.setNoOfFilesBackedUp(batch.getTotalNoOfFiles());
                    }
                    if (!StringUtils.isEmpty((String)batch.getUploadedSize())) {
                        notifierEmailBodyElement.setTotalBackupSize(StorageService.formatFileSize(Long.parseLong(batch.getUploadedSize())));
                    } else {
                        notifierEmailBodyElement.setTotalBackupSize("0");
                    }
                    action = "first-backup-completed";
                    if (isSharePoint) {
                        action = "site-first-backup-completed";
                    }
                    this.sendEmail(action, deviceBackupOverView.getUserName(), deviceBackupOverView.getUserName(), deviceBackupOverView.getEmailId(), notifierEmailBodyElement, deviceBackupOverView.getDeviceUUID(), isSharePoint, deviceBackupOverView.getUserName());
                }
                long uploadedSize = 0L;
                if (!StringUtils.isEmpty((String)backupBatch.getUploadedSize())) {
                    uploadedSize = Long.parseLong(backupBatch.getUploadedSize());
                }
                this.updateBatchAttempt(cloudId, backupBatch, isFirstAttempt, startOp, overLoad, licenseExpired);
            }
        }
        this.utilServiceObj.deleteEventHubForDeviceUUID(cloudval.getCloudId(), backupBatch.getDeviceUUID(), "START_BACKUP");
        boolean isMailAlreadySent = deviceBackupOverView.isStorageLimitMailSent();
        if (isMailAlreadySent) {
            logger.debug("...update mail status.... ");
            this.utilServiceObj.updateUserLimitMailSent(cloudval.getCloudId(), deviceBackupOverView.getDeviceUUID(), false);
        }
    }

    private void uploadBatchFiles(String batchId, DriveFileInfo item, Cloud cloudval, BackupBatch backupBatch, String policyName, com.parablu.pcbd.domain.User user, String driveId, boolean fullBkp, boolean mailLinkGen, Device device, String token) {
        String destCollection = device.getDestCollection();
        String deviceUUID = device.getDeviceUUID();
        int cloudId = cloudval.getCloudId();
        item.setBackupBatchId(batchId);
        BackupBatch pbBkpBatch = this.utilServiceObj.getBackupBatchById(cloudval.getCloudId(), batchId);
        int errorCode = 0;
        if (pbBkpBatch != null) {
            errorCode = StringUtils.isEmpty((String)pbBkpBatch.getErrorCode()) ? 0 : Integer.parseInt(pbBkpBatch.getErrorCode());
        }
        if (item.isMail() && !item.isFullBackup()) {
            try {
                boolean fileAlreadyExists = false;
                logger.debug(item.isInPlaceArchive() + "..item-path...." + item.getItemPath());
                if (item.isInPlaceArchive()) {
                    fileAlreadyExists = true;
                } else {
                    BackUpImage bkpImage = this.utilServiceObj.getBackupImageForItemId(cloudId, item.getItemId(), destCollection, deviceUUID);
                    if (bkpImage != null) {
                        BackUpImage imageDeletedold = this.utilServiceObj.getBackupImageForItemIdWOStatus(cloudId, item.getItemId(), destCollection, deviceUUID);
                        fileAlreadyExists = imageDeletedold != null && item.getItemPath().equalsIgnoreCase(bkpImage.getDevicePath()) && (!mailLinkGen || bkpImage.isMailLinkGenerated());
                    }
                }
                if (fileAlreadyExists) {
                    logger.debug(item.getId().toString() + "...mail-exists...." + item.getUserName() + "...." + fileAlreadyExists + "...");
                    this.updateBackupBatch(backupBatch, cloudval, 1, 0L, item);
                    this.uploadService.removeDriveItem(item.getId().toString(), item.isMail(), deviceUUID);
                    return;
                }
            }
            catch (Exception e) {
                logger.error("---unable to check mail dup...");
            }
        }
        logger.debug(item.getId().toString() + "...mail-exists..later1.." + item.getUserName() + "...." + item.getItemPath());
        boolean isTomcatRunning = true;
        if (MemoryStore.get((String)IS_TOMCAT_RUNNING) != null) {
            isTomcatRunning = (Boolean)MemoryStore.get((String)IS_TOMCAT_RUNNING);
        }
        if (!isTomcatRunning) {
            logger.debug("......server is stopping...");
            errorCode = 1207;
            return;
        }
        DeviceBackupOverView deviceBackupOverView = this.utilServiceObj.getDeviceBkpOverviewForDeviceUUID(cloudval.getCloudId(), backupBatch.getDeviceUUID());
        double fileSizeInMb = this.getFileSizeInMb(item.getSize());
        boolean isUserStorageLimitReached = this.utilServiceObj.isUserO365StorageLimitReached(1, fileSizeInMb, backupBatch.getUserName(), backupBatch.getDeviceUUID());
        BaseController.printLogs(fileSizeInMb + "....is user Storage limit reached ..." + isUserStorageLimitReached, PCHelperConstant.isBrevityLogging());
        if (isUserStorageLimitReached) {
            int userSizeAllowed = 0;
            if (device != null && device.getDeviceType().equalsIgnoreCase(Device.TYPE.ONEDRIVE.name())) {
                userSizeAllowed = backupBatch.getOfficeBackupPolicy().getUserSizeAllowed();
            }
            if (device != null && device.getDeviceType().equalsIgnoreCase(Device.TYPE.OUTLOOK.name())) {
                userSizeAllowed = backupBatch.getOfficeBackupPolicy().getUserSizeAllowed();
            }
            logger.debug(".... user Storage limit reached ...");
            boolean isMailAlreadySent = deviceBackupOverView.isStorageLimitMailSent();
            if (!isMailAlreadySent) {
                this.sendWarningMail(cloudval.getCloudName(), backupBatch.getUserName(), userSizeAllowed, deviceBackupOverView.getDeviceName());
                this.utilServiceObj.updateUserLimitMailSent(cloudval.getCloudId(), deviceBackupOverView.getDeviceUUID(), true);
            }
            logger.error(backupBatch.getUserName() + ".... User Storage limit reached ..... ");
            errorCode = 449;
            logger.error("....stop the backup HTTP_USER_STORAGE_LIMIT_REACHED .....");
            this.updateBatchAndOverview(cloudval.getCloudId(), backupBatch.getId(), INTERRUPTED_STATUS, backupBatch.getDeviceUUID(), 1981);
        }
        if (errorCode == 0) {
            errorCode = this.getPrevBatchErrorCode(cloudval, batchId);
        }
        logger.debug(errorCode + "...errorcode for item.... " + batchId);
        if (errorCode == 449) {
            throw new UserStorageLimitReachedException("user storage limit reached", errorCode);
        }
        int licenseCode = this.vaildatedLicensceStatus(cloudval);
        errorCode = licenseCode == 1501 ? licenseCode : 0;
        OfficeBackupPolicy backupPolicy = null;
        user = this.utilServiceObj.getUserInfoByName(cloudId, user.getUserName());
        if (deviceBackupOverView != null && Device.TYPE.ONEDRIVE.toString().equalsIgnoreCase(deviceBackupOverView.getOsType())) {
            backupPolicy = this.utilServiceObj.getOfficeBackupPolicy(cloudId, user.getOneDrivePolicyName(), "ODB");
        } else if (deviceBackupOverView != null && Device.TYPE.OUTLOOK.toString().equalsIgnoreCase(deviceBackupOverView.getOsType())) {
            backupPolicy = this.utilServiceObj.getOfficeBackupPolicy(cloudId, user.getExchangePolicyName(), "Exchange");
        } else if (deviceBackupOverView != null && Device.TYPE.SHAREPOINT.toString().equalsIgnoreCase(deviceBackupOverView.getOsType())) {
            backupPolicy = this.utilServiceObj.getOfficeBackupPolicy(cloudId, user.getSpPolicyName(), "Sharepoint");
        }
        if (!PCHelperConstant.getComponentName().equalsIgnoreCase(backupPolicy.getMsAppBluKrypt())) {
            logger.debug(PCHelperConstant.getComponentName() + "...wrong policy blukrypt...." + backupPolicy.getMsAppBluKrypt());
            logger.debug("....... overload limit reached for current threads.. .... ");
            throw new OverloadLimitReachedException("storage limit reached", errorCode);
        }
        logger.debug(errorCode + "....license code ...." + licenseCode);
        if (errorCode > 0) {
            throw new BaseException("custom error", errorCode);
        }
        logger.debug(batchId + "...inside while loop after msg ... " + String.valueOf(item));
        int statuscode = 200;
        UploadStatus status = null;
        if (PCHelperConstant.getPGOverloadLimit() <= 0) {
            logger.debug("....... overload limit reached for current threads.. .... ");
            throw new OverloadLimitReachedException("storage limit reached", errorCode);
        }
        if (errorCode <= 0) {
            try {
                status = this.downloadFile(item, user, driveId, token);
                statuscode = status.getStatus();
            }
            catch (Exception e) {
                logger.error("Failed to handle the message!", (Throwable)e);
                this.fileUnderProcess.remove(item.getItemId());
            }
            if (status != null) {
                item.setSize(Long.valueOf(status.getFileSize()));
            }
            logger.debug(statuscode + ".... before deleting batchid check..... " + String.valueOf(backupBatch.getId()) + "...size..." + item.getSize());
            if (statuscode != 200) {
                logger.debug(item.isFailedFile() + "...failed case statuscode...." + statuscode);
                if (statuscode == 555) {
                    this.updateBackupBatchFailedFile(backupBatch, cloudval, 0, 0L);
                    this.utilServiceObj.removeFailedFile(item.getId().toString());
                } else {
                    if (statuscode != 409) {
                        this.updateTotalCount(cloudval.getCloudId(), backupBatch);
                        this.updateBackupBatch(backupBatch, cloudval, 0, 0L, item);
                    }
                    logger.debug(item.isFailedFile() + "...failed case latest1 statuscode...." + statuscode + "...fullbkp..." + fullBkp);
                    if (statuscode == 409) {
                        this.utilServiceObj.removeFailedFile(item.getId().toString());
                        if (fullBkp) {
                            this.updateBackupBatch(backupBatch, cloudval, 1, item.getSize(), item);
                        } else {
                            this.updateBackupBatch(backupBatch, cloudval, 0, 0L, item);
                            this.updateTotalCount(cloudval.getCloudId(), backupBatch);
                        }
                    } else {
                        this.uploadService.addFailedFiles(item, policyName);
                    }
                }
            } else {
                this.updateBackupBatch(backupBatch, cloudval, 1, item.getSize(), item);
            }
            this.uploadService.removeDriveItem(item.getId().toString(), item.isMail(), deviceUUID);
            if (item.isPrevDeltaItem()) {
                this.utilServiceObj.removeFileInfoForPrevDeltaItem(item.getId().toString());
            }
            logger.debug(".. batch id completed...." + String.valueOf(backupBatch.getId()));
        }
    }

    public void updateTotalCount(int cloudId, BackupBatch backupBatch) {
        this.utilServiceObj.updateBackupBatchTotalCount(cloudId, backupBatch.getId().toString());
    }

    List<DriveFileInfo> getOneDriveFileInfoFromListForBatchId(int cloudId, String batchId, String deviceUUID) {
        List<DriveFileInfo> list = this.uploadService.getOneDriveFileInfoFromListForBatchId(cloudId, batchId, deviceUUID);
        if (org.apache.commons.collections.CollectionUtils.isEmpty(list)) {
            return new ArrayList<DriveFileInfo>();
        }
        return list;
    }

    private UploadStatus downloadFile(DriveFileInfo item, com.parablu.pcbd.domain.User user, String driveId, String token) throws InterruptedException, ExecutionException {
        logger.debug("Message started! : " + Thread.currentThread().getName() + " ...  " + item.getItemId() + "....." + item.getParentItemId());
        int statuscode = 0;
        UploadStatus uploadStatus = null;
        try {
            if (item.getOperation().equalsIgnoreCase("FILE") && !item.isFolder()) {
                HashedMap arguments = new HashedMap();
                arguments.put("itemID", item.getItemId());
                arguments.put("parentItemID", item.getParentItemId());
                logger.debug(item.getBackupBatchId() + "...from info.. " + item.getParentItemId());
                arguments.put("messageID", item.getItemId());
                arguments.put("backupBatchId", item.getBackupBatchId());
                arguments.put("userName", item.getUserName());
                arguments.put("deviceUUID", item.getDeviceUUID());
                arguments.put("isSharePoint", item.isSharePoint());
                logger.debug(item.isMail() + "..$$$$ calculated path is " + item.getItemPath());
                arguments.put("file-path", item.getItemPath());
                arguments.put("file-name", item.getItemName());
                arguments.put("driveFileInfoId", item.getId().toString());
                arguments.put("isFullBackup", item.isFullBackup());
                arguments.put("isMail", item.isMail());
                arguments.put("isContact", item.isContact());
                arguments.put("isTasks", item.isTasks());
                arguments.put("isCalendar", item.isCalendar());
                arguments.put("versionId", item.getVersionId());
                arguments.put("isInPlaceArchive", item.isInPlaceArchive());
                if (StringUtils.isEmpty((String)item.getUserMailId())) {
                    item.setUserMailId(user.getEmailId());
                }
                arguments.put("versionId", item.getVersionId());
                arguments.put("userMailId", item.getUserMailId());
                arguments.put("token", token);
                arguments.put("siteId", item.getSiteId());
                arguments.put("listId", item.getListId());
                arguments.put("driveId", driveId);
                arguments.put("o365LastModifiedTime", item.getO365LastModifiedTime());
                if (item.isCalendar() || item.isMail() || item.isTasks() || item.isContact() || item.isInPlaceArchive()) {
                    arguments.put("graphUserId", item.getGraphUserId());
                }
                do {
                    CompletableFuture<UploadStatus> notifyService;
                    if (((uploadStatus = (notifyService = this.uploadService.notifyService((Map<String, ? super Object>)arguments, null, user)).get()).getStatus() != 0 || uploadStatus.getStatus() != 200 || uploadStatus.getStatus() != 234 || uploadStatus.getStatus() != 409) && uploadStatus.getStatus() != 200) {
                        logger.debug(item.getItemName() + "....differror code..." + uploadStatus.getStatus());
                    }
                    if (uploadStatus.getStatus() != 0) continue;
                    logger.debug("... error code is 0...sleep for 10 sec and retry.... ");
                    Thread.sleep(10000L);
                } while (uploadStatus.getStatus() == 0);
                logger.debug("...............UPPLOAD STATUS ............... " + uploadStatus.getStatus());
                if (uploadStatus.getStatus() == 409) {
                    logger.debug("...............409 UPPLOAD STATUS ............... ");
                    statuscode = 234;
                }
                if (uploadStatus.getStatus() == 234) {
                    statuscode = uploadStatus.getStatus();
                }
                if (uploadStatus != null && uploadStatus.getStatus() == 200) {
                    statuscode = uploadStatus.getStatus();
                } else {
                    logger.debug("..$%$%$%$%.file failed......" + item.getItemName());
                }
            }
            logger.debug(this.shutdown + ".... item processed v... " + item.getItemName() + "....");
            logger.debug(".... item processed path and subject... " + item.getSubject() + "...." + item.getItemPath());
        }
        catch (GraphServiceException e) {
            logger.error("... error response codecheck .... " + e.getResponseCode());
            if (e.getResponseCode() == 429 || e.getResponseCode() == 401) {
                logger.debug(".... retry .. after 2 mins.. ");
                Thread.sleep(120000L);
                uploadStatus = this.downloadFile(item, user, driveId, token);
            }
        }
        catch (Exception ee) {
            ee.printStackTrace();
            logger.error(item.getItemName() + "... unable to catch exception during download 1... " + ee.getMessage());
        }
        if (uploadStatus == null) {
            uploadStatus = new UploadStatus(item.getItemId(), false, 234, 0L);
        }
        return uploadStatus;
    }

    private double getFileSizeInMb(Long fileSize) {
        if (fileSize == null) {
            return 0.0;
        }
        long filesizeInKB = (long)Math.ceil((double)fileSize.longValue() / 1024.0);
        return StorageService.getSizeinMb(filesizeInKB);
    }

    public static double getSizeinMb(long size) {
        double m = (double)size / 1024.0;
        DecimalFormat dec = new DecimalFormat("0.00");
        return Double.parseDouble(dec.format(m));
    }

    private void sendWarningMail(String cloudName, String userName, double userStorageQuata, String deviceName) {
        try {
            logger.debug(".. user limit reached mail start....");
            String url = PCHelperConstant.getPropertyFileValueForParacloudUrl() + "/paracloud/cloud/" + cloudName + "/mail";
            CloseableHttpClient httpclient = HttpClientUtil.getSSlConnection();
            HttpPost httpPost = new HttpPost(url);
            httpPost.setHeader("Content-Type", (Object)"application/json");
            httpPost.setHeader("isInternalCall", (Object)"true");
            JSONObject emailDetails = new JSONObject();
            emailDetails.put("actionBy", (Object)userName);
            emailDetails.put("action", (Object)"backup-limit-reached");
            emailDetails.put("actionOn", (Object)userName);
            emailDetails.put("deviceName", (Object)deviceName);
            emailDetails.put("customMailMessage", (Object)String.valueOf(userStorageQuata));
            emailDetails.put("toAdmins", true);
            emailDetails.put("toUser", true);
            StringEntity params = new StringEntity(emailDetails.toString());
            httpPost.setEntity((HttpEntity)params);
            CloseableHttpResponse response = httpclient.execute((ClassicHttpRequest)httpPost);
            logger.debug("user limit reached mail Send mail result status code :", (Object)response);
        }
        catch (IOException e) {
            logger.trace(String.valueOf(e));
            logger.error("Exception :", (Object)e.getMessage());
        }
    }

    private void sendEmail(String action, String actionOn, String actionBy, String emailId, NotifierEmailBodyElement bodyElement, String deviceUUID, boolean isSharepoint, String siteName) {
        try {
            if (isSharepoint) {
                logger.debug(bodyElement.getNoOfFilesBackedUp() + ".. first email12 completion...." + bodyElement.getTotalBackupSize());
                String url = PCHelperConstant.getPropertyFileValueForParacloudUrl().trim() + "/paracloud/cloud/" + bodyElement.getCloudName() + "/sites/mail";
                logger.debug(bodyElement.getNoOfFilesBackedUp() + ".. first email url with dev details s...." + url);
                CloseableHttpClient httpclient = HttpClientUtil.getSSlConnection();
                HttpPost httpPost = new HttpPost(url);
                httpPost.setHeader("Content-Type", (Object)"application/json");
                httpPost.setHeader("isInternalCall", (Object)"true");
                httpPost.setHeader("bkupsDone", (Object)String.valueOf(bodyElement.getNoOfFilesBackedUp()));
                JSONObject emailDetails = new JSONObject();
                emailDetails.put("actionBy", (Object)actionBy);
                emailDetails.put("action", (Object)action);
                emailDetails.put("actionOn", (Object)actionOn);
                emailDetails.put("toUser", true);
                emailDetails.put("deviceUUID", (Object)deviceUUID);
                emailDetails.put("userName", (Object)siteName);
                emailDetails.put("customMailMessage", (Object)String.valueOf(bodyElement.getTotalBackupSize()));
                emailDetails.put("deviceName", (Object)String.valueOf(bodyElement.getDeviceName()));
                emailDetails.put("totalStorageUtilized", (Object)String.valueOf(bodyElement.getTotalBackupSize()));
                emailDetails.put("bkupsDone", (Object)String.valueOf(bodyElement.getNoOfFilesBackedUp()));
                emailDetails.put("toAdmins", true);
                StringEntity params = new StringEntity(emailDetails.toString());
                httpPost.setEntity((HttpEntity)params);
                CloseableHttpResponse response = httpclient.execute((ClassicHttpRequest)httpPost);
                logger.debug("Send mail result status code :", (Object)response);
            } else {
                logger.debug(bodyElement.getNoOfFilesBackedUp() + ".. first email12 completion...." + bodyElement.getTotalBackupSize());
                String url = PCHelperConstant.getPropertyFileValueForParacloudUrl().trim() + "/paracloud/cloud/" + bodyElement.getCloudName() + "/mail";
                logger.debug(bodyElement.getNoOfFilesBackedUp() + ".. first email url with dev details s...." + url);
                CloseableHttpClient httpclient = HttpClientUtil.getSSlConnection();
                HttpPost httpPost = new HttpPost(url);
                httpPost.setHeader("Content-Type", (Object)"application/json");
                httpPost.setHeader("isInternalCall", (Object)"true");
                httpPost.setHeader("bkupsDone", (Object)String.valueOf(bodyElement.getNoOfFilesBackedUp()));
                JSONObject emailDetails = new JSONObject();
                emailDetails.put("actionBy", (Object)actionBy);
                emailDetails.put("action", (Object)action);
                emailDetails.put("actionOn", (Object)actionOn);
                emailDetails.put("toUser", true);
                emailDetails.put("deviceUUID", (Object)deviceUUID);
                emailDetails.put("customMailMessage", (Object)String.valueOf(bodyElement.getTotalBackupSize()));
                emailDetails.put("deviceName", (Object)String.valueOf(bodyElement.getDeviceName()));
                emailDetails.put("totalStorageUtilized", (Object)String.valueOf(bodyElement.getTotalBackupSize()));
                emailDetails.put("bkupsDone", (Object)String.valueOf(bodyElement.getNoOfFilesBackedUp()));
                emailDetails.put("toAdmins", true);
                StringEntity params = new StringEntity(emailDetails.toString());
                httpPost.setEntity((HttpEntity)params);
                CloseableHttpResponse response = httpclient.execute((ClassicHttpRequest)httpPost);
                logger.debug("Send mail result status code :", (Object)response);
            }
        }
        catch (IOException e) {
            logger.trace(String.valueOf(e));
            logger.error("Exception :", (Object)e.getMessage());
        }
    }

    private static String formatFileSize(long size) {
        if (size <= 0L) {
            return "0";
        }
        String[] units = new String[]{"B", "KB", "MB", "GB", "TB"};
        int digitGroups = (int)(Math.log10(size) / Math.log10(1024.0));
        return new DecimalFormat("#,##0.#").format((double)size / Math.pow(1024.0, digitGroups)) + " " + units[digitGroups];
    }

    private synchronized ODBBackupBatch getBackupBatchFromOneDriveServer() {
        ODBBackupBatch backupBatch;
        int cloudId = 1;
        BaseController.printLogs("... inside getBackupBatchFromOneDriveServer... ", PCHelperConstant.isBrevityLogging());
        if (org.apache.commons.collections.CollectionUtils.isEmpty(batchList)) {
            this.sleep7();
            batchList = this.getBatchFromList(cloudId, false, false);
            if (org.apache.commons.collections.CollectionUtils.isEmpty(batchList)) {
                try {
                    BaseController.printLogs("...batch Completed ... ", PCHelperConstant.isBrevityLogging());
                    Thread.sleep(10000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                return null;
            }
        }
        if ((backupBatch = batchList.get(0)) != null) {
            if (this.batchUnderProcess.contains(backupBatch.getId().toString()) || this.deviceUUIDUnderProcess.contains(backupBatch.getDeviceUUID())) {
                batchList.remove(backupBatch);
                return this.getBackupBatchFromOneDriveServer();
            }
            batchList.remove(backupBatch);
            this.batchUnderProcess.add(backupBatch.getId().toString());
            this.deviceUUIDUnderProcess.add(backupBatch.getDeviceUUID());
        }
        logger.debug("...after bkp batch list size....." + batchList.size());
        return backupBatch;
    }

    public void checkThreadStatusAndStartUpload(final Cloud cloud, final ExecutorService executor, final CompletionService<String> pool) {
        if (this.backupTimer == null) {
            this.backupTimer = new Timer();
        }
        if (this.backupTimerTask == null) {
            this.backupTimerTask = new TimerTask(){

                @Override
                public void run() {
                    try {
                        BaseController.printLogs("Check the task is completed>>>>>>>>", PCHelperConstant.isBrevityLogging());
                        Future future = pool.take();
                        if (future.isDone()) {
                            BaseController.printLogs("Thread is completed so assign new task>>>>>>>>>>>", PCHelperConstant.isBrevityLogging());
                            StorageService.this.callUploadFiles(cloud, executor, pool);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        logger.error("Error in checkThreadStatusAndStartUpload", (Throwable)e);
                        logger.trace(String.valueOf(e));
                    }
                }
            };
            this.backupTimer.schedule(this.backupTimerTask, 1000L, 1000L);
        }
    }

    private List<ODBBackupBatch> getBatchFromList(int cloudId, boolean pgOVerLoadLimit, boolean retryDeferredBatch) {
        List<OfficeBackupPolicy> list = this.utilServiceObj.getPolicyForBluKrypt(cloudId);
        if (pgOVerLoadLimit) {
            batchList = new ArrayList<ODBBackupBatch>();
        }
        for (OfficeBackupPolicy oneDriveBackupPolicy : list) {
            List<ODBBackupBatch> batchListVal = this.uploadService.getODBBatchList(cloudId, oneDriveBackupPolicy.getPolicyName(), retryDeferredBatch);
            logger.debug(oneDriveBackupPolicy.getPolicyName() + "...policyandfiles.." + batchListVal.size());
            if (batchList == null) {
                batchList = new ArrayList<ODBBackupBatch>();
            }
            Collections.sort(batchListVal, Comparator.comparing(ODBBackupBatch::getBatchStartTimestamp));
            for (ODBBackupBatch backupBatch : batchListVal) {
                com.parablu.pcbd.domain.User userObj;
                Device device;
                ODBBackupBatch newBackupBatch = new ODBBackupBatch();
                BeanUtils.copyProperties((Object)backupBatch, (Object)newBackupBatch);
                newBackupBatch.setOdbPolicyName(oneDriveBackupPolicy.getPolicyName());
                newBackupBatch.setOfficeBackupPolicy(oneDriveBackupPolicy);
                boolean odbEnabled = false;
                if (!StringUtils.isEmpty((String)oneDriveBackupPolicy.getMsAppBluKrypt()) && PCHelperConstant.getComponentName().equalsIgnoreCase(oneDriveBackupPolicy.getMsAppBluKrypt())) {
                    odbEnabled = true;
                }
                boolean mailEnabled = false;
                if (!StringUtils.isEmpty((String)oneDriveBackupPolicy.getMsAppBluKrypt()) && PCHelperConstant.getComponentName().equalsIgnoreCase(oneDriveBackupPolicy.getMsAppBluKrypt())) {
                    mailEnabled = true;
                }
                boolean spEnabled = false;
                if (!StringUtils.isEmpty((String)oneDriveBackupPolicy.getMsAppBluKrypt()) && PCHelperConstant.getComponentName().equalsIgnoreCase(oneDriveBackupPolicy.getMsAppBluKrypt())) {
                    spEnabled = true;
                }
                if ((device = this.utilServiceObj.getDeviceForUUID(cloudId, backupBatch.getDeviceUUID())) == null || (userObj = this.utilServiceObj.getUserInfoByName(cloudId, backupBatch.getUserName())) == null) continue;
                if (odbEnabled && device != null && Device.TYPE.ONEDRIVE.toString().equalsIgnoreCase(device.getOsType())) {
                    batchList.add(newBackupBatch);
                    continue;
                }
                if (mailEnabled && device != null && Device.TYPE.OUTLOOK.toString().equalsIgnoreCase(device.getOsType())) {
                    batchList.add(newBackupBatch);
                    continue;
                }
                if (!spEnabled || device == null || !Device.TYPE.SHAREPOINT.toString().equalsIgnoreCase(device.getOsType())) continue;
                batchList.add(newBackupBatch);
            }
        }
        if (org.apache.commons.collections.CollectionUtils.isEmpty(batchList)) {
            batchList = new ArrayList<ODBBackupBatch>();
        } else {
            Collections.sort(batchList, Comparator.comparing(ODBBackupBatch::getBatchStartTimestamp));
        }
        int j = 0;
        for (ODBBackupBatch batch : batchList) {
            logger.debug(j + "...batchorder...." + batch.getUserName() + "...." + batch.getDeviceUUID());
            ++j;
        }
        logger.debug("......batchlisttoprocess....." + batchList.size());
        return batchList;
    }

    private void updateBatchAndOverview(int cloudId, ObjectId backupBatchId, String status, String deviceUUID, int errorCode) {
        this.utilServiceObj.updateBackupBatch(cloudId, backupBatchId, status, errorCode);
        Device device = this.utilServiceObj.getDeviceForUUID(cloudId, deviceUUID);
        BackupBatch backupBatch = this.utilServiceObj.getBackupBatchById(cloudId, backupBatchId.toString());
        backupBatch.setStatus(status);
        this.updateBackupOverview(cloudId, BACKUP, deviceUUID, device, backupBatch, errorCode);
    }

    private void sleep7() {
        try {
            BaseController.printLogs("... going to sleep for 20 sec..", PCHelperConstant.isBrevityLogging());
            Thread.sleep(20000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void shutdown() {
        this.shutdown = true;
    }

    private List<DriveFileInfo> getDriveFileInfoFromListForBatchId(int cloudId, String batchId, String deviceUUID) {
        List<DriveFileInfo> list = this.uploadService.getDriveFileInfoFromListForBatchId(cloudId, batchId, deviceUUID);
        if (org.apache.commons.collections.CollectionUtils.isEmpty(list)) {
            return new ArrayList<DriveFileInfo>();
        }
        return list;
    }

    public void updateBackupBatch(BackupBatch backupBatchOdb, Cloud cloud, int uploadedFiles, Long size, DriveFileInfo item) {
        logger.debug("calling backup Batch ..." + backupBatchOdb.getNoOfFiles());
        try {
            int cloudId = cloud.getCloudId();
            if (size == null) {
                size = 0L;
            }
            this.utilServiceObj.updateBackupBatch(cloudId, backupBatchOdb.getId().toString(), uploadedFiles, size);
            BackupBatch backupBatch = this.utilServiceObj.getBackupBatchById(cloudId, backupBatchOdb.getId().toString());
            if (!StringUtils.isEmpty((String)backupBatch.getUploadedFiles())) {
                String[] parts = backupBatch.getUploadedFiles().split("/");
                try {
                    Integer uploadedFilesLast = Integer.parseInt(parts[0]);
                    Integer totalUploaded = Integer.parseInt(parts[1]);
                    logger.debug("...uploadedfiles..." + uploadedFilesLast + "/" + totalUploaded);
                    if (uploadedFilesLast > totalUploaded) {
                        this.utilServiceObj.updateBackupBatch(cloudId, backupBatchOdb.getId().toString(), -1, -size.longValue());
                        this.uploadService.removeDriveItem(item.getId().toString(), item.isMail(), backupBatchOdb.getDeviceUUID());
                        return;
                    }
                }
                catch (Exception e) {
                    logger.trace("Exception  :" + String.valueOf(e));
                    logger.error("Exception  :" + e.getMessage());
                }
            }
            this.utilServiceObj.updateBackupAttempt(cloudId, backupBatch.getUploadedFiles(), backupBatchOdb.getId().toString());
            this.utilServiceObj.updateUplodedFilesInBackupOverView(cloudId, backupBatchOdb.getDeviceUUID(), uploadedFiles, size, backupBatchOdb.getTotalSizeToUpload());
            logger.debug("[backupBatch][" + backupBatchOdb.getUserName() + "][" + backupBatchOdb.getDeviceUUID() + "][" + String.valueOf(backupBatchOdb.getId()) + "][" + backupBatchOdb.getStatus() + "][" + backupBatchOdb.getBatchStartTimestamp() + "][" + backupBatchOdb.getBatchEndTimestamp() + "]");
        }
        catch (Exception e) {
            logger.trace("Error failed to save backupBatch ..." + String.valueOf(e));
            logger.error("Error failed to save backupBatch ..." + e.getMessage());
        }
        logger.debug("end of calling backup Batch ...");
    }

    public void updateBackupBatchFailedFile(BackupBatch backupBatchOdb, Cloud cloud, int uploadedFiles, Long size) {
        logger.debug("calling backup updateBackupBatchFailedFile ..." + backupBatchOdb.getNoOfFiles());
        try {
            int cloudId = cloud.getCloudId();
            if (size == null) {
                size = 0L;
            }
            this.utilServiceObj.updateBackupBatchFailedFile(cloudId, backupBatchOdb.getId().toString(), uploadedFiles, size);
            this.utilServiceObj.updateUplodedFilesInBackupOverView(cloudId, backupBatchOdb.getDeviceUUID(), uploadedFiles, size, backupBatchOdb.getTotalSizeToUpload());
            logger.debug("[backupBatch][" + backupBatchOdb.getUserName() + "][" + backupBatchOdb.getDeviceUUID() + "][" + String.valueOf(backupBatchOdb.getId()) + "][" + backupBatchOdb.getStatus() + "][" + backupBatchOdb.getBatchStartTimestamp() + "][" + backupBatchOdb.getBatchEndTimestamp() + "]");
        }
        catch (Exception e) {
            logger.trace("Error failed to save backupBatch ..." + String.valueOf(e));
            logger.error("Error failed to save backupBatch ..." + e.getMessage());
        }
        logger.debug("end of calling backup Batch ...");
    }

    private void updateBackupOverview(int cloudId, String jobType, String deviceUUID, Device device, BackupBatch backupBatch, int errorCode) {
        logger.debug(".... job type..... " + jobType);
        if (BACKUP.equalsIgnoreCase(jobType)) {
            DeviceBackupOverView overView = this.utilServiceObj.getDeviceBkpOverviewForDeviceUUID(cloudId, deviceUUID);
            if (overView == null) {
                logger.debug(" No device backup ....");
                this.utilServiceObj.saveDeviceBackupOverView(cloudId, device);
            } else {
                logger.debug(String.valueOf(backupBatch) + " update device backup ...." + backupBatch.getBatchStartTimestamp());
                if (StringUtils.isEmpty((String)overView.getFirstBkpStartTime())) {
                    String firstBkpStartTime = this.getDateInFormat(backupBatch.getBatchStartTimestamp());
                    overView.setFirstBkpStartTime(firstBkpStartTime);
                }
                String lastBkpStartTime = this.getDateInFormat(backupBatch.getBatchStartTimestamp());
                overView.setLastBkpStartTime(lastBkpStartTime);
                if (backupBatch.getBatchEndTimestamp() > 0L) {
                    overView.setLastBkpEndTime(this.getDateInFormat(backupBatch.getBatchEndTimestamp()));
                } else {
                    overView.setLastBkpEndTime(this.getDateInFormat(System.currentTimeMillis()));
                }
                overView.setLastBkpStatus(backupBatch.getStatus());
                overView.setTotalNoOfFiles(backupBatch.getTotalNoOfFiles());
                logger.debug("TotalNoOfFiles : " + backupBatch.getTotalNoOfFiles() + " UploadedFiles : " + backupBatch.getUploadedFiles());
                overView.setNoOfFilesRemaining(this.getNoOfFilesRemaining(backupBatch.getTotalNoOfFiles(), backupBatch.getUploadedFiles()));
                logger.debug(overView.getNoOfSuccessfulBackups() + "Backup/Restore Status*" + backupBatch.getStatus() + "**");
                logger.debug(errorCode + "...noofsuccessfulbkps... " + overView.getNoOfSuccessfulBackups());
                if (COMPLETED.equalsIgnoreCase(backupBatch.getStatus())) {
                    String lastSuccessfulBkp = this.getDateInFormat(backupBatch.getBatchEndTimestamp());
                    overView.setLastSuccessfulBkp(lastSuccessfulBkp);
                    overView.setLastSuccessfulBackupStartTime(backupBatch.getBatchStartTimestamp());
                    overView.setLastSuccessfulBackupEndTime(backupBatch.getBatchEndTimestamp());
                    logger.debug(device.getUserName() + " @#@# Backup  Completed ........." + device.getDeviceName());
                    logger.debug("...totalfilllll....." + backupBatch.getUploadedFiles() + "..." + backupBatch.getTotalNoOfFiles());
                    long noOfSuccessfulBackups = overView.getNoOfSuccessfulBackups();
                    overView.setNoOfSuccessfulBackups(noOfSuccessfulBackups + 1L);
                    if (StringUtils.isEmpty((String)overView.getFirstBkpEndTime())) {
                        logger.debug(" ..firstbkp empty....");
                        Long firstBkpEndTime = this.utilServiceObj.getFirstBackupEndDate(cloudId, device.getUserName(), device.getDeviceUUID());
                        logger.debug(" ..firstbkp empty...." + firstBkpEndTime);
                        if (firstBkpEndTime != null) {
                            String firstSuccessfulEndBkp = this.getDateInFormat(firstBkpEndTime);
                            overView.setFirstBkpEndTime(firstSuccessfulEndBkp);
                        } else {
                            overView.setFirstBkpEndTime(lastSuccessfulBkp);
                        }
                        if (StringUtils.isNotEmpty((String)backupBatch.getUploadedSize())) {
                            overView.setFirstFullBkpTotalSizeOfFiles(Long.parseLong(backupBatch.getUploadedSize()) / 1024L);
                        } else {
                            overView.setFirstFullBkpTotalSizeOfFiles(0L);
                        }
                        overView.setFirstFullBkpNoOfFiles(this.getActualUploadedFiles(backupBatch.getUploadedFiles()));
                    }
                    if (StringUtils.isNotEmpty((String)backupBatch.getUploadedSize())) {
                        overView.setLastSucessfulBkpTotalSizeOfFiles(Long.parseLong(backupBatch.getUploadedSize()) / 1024L);
                    } else {
                        overView.setLastSucessfulBkpTotalSizeOfFiles(0L);
                    }
                    overView.setLastSucessfulBkpNoOfFiles(this.getActualUploadedFiles(backupBatch.getUploadedFiles()));
                    overView.setCurrentlyRunningBkpNoOfFiles(0L);
                    overView.setCurrentlyRunningBkpTotalSizeOfFiles(0L);
                }
                overView.setReason(backupBatch.getErrorCode());
                if (!StringUtils.isEmpty((String)backupBatch.getStatus()) && backupBatch.getStatus().equals("ABORTED")) {
                    overView.setCurrentlyRunningBkpNoOfFiles(0L);
                    overView.setCurrentlyRunningBkpTotalSizeOfFiles(0L);
                }
                overView.setTotalSizeToUpload(backupBatch.getTotalSizeToUpload());
                logger.debug("...end noofsuccessfulbkps... " + overView.getNoOfSuccessfulBackups());
                this.utilServiceObj.updateDeviceBackupOverView(cloudId, overView);
            }
        }
    }

    long getActualUploadedFiles(String uploadedFiles) {
        if (StringUtils.isEmpty((String)uploadedFiles)) {
            uploadedFiles = "0/0";
        }
        String[] parts = uploadedFiles.split("/");
        return Long.parseLong(parts[0]);
    }

    public BackupBatch startBackupBatch(BackupBatch backupBatchOdb, Cloud cloud, int uploadedFiles, long totalFiles, int errorCode, long batchStartTimestamp, boolean fullBackup, String uploadedSize) {
        String cloudName = cloud.getCloudName();
        logger.debug(uploadedSize + "calling start backup Batch ..." + uploadedFiles);
        BackupBatch backupBatch = new BackupBatch();
        try {
            int tot;
            int cloudId = cloud.getCloudId();
            cloudName = cloud.getCloudName();
            String jobType = BACKUP;
            String totalNoOfFiles = "" + backupBatchOdb.getNoOfFiles();
            String deviceUUID = backupBatchOdb.getDeviceUUID();
            logger.debug(" ************ " + backupBatchOdb.getErrorCode());
            Device device = this.utilServiceObj.getDeviceForUUID(cloudId, deviceUUID);
            if (!StringUtils.isEmpty((String)totalNoOfFiles) && (long)(tot = Integer.parseInt(totalNoOfFiles)) < totalFiles) {
                totalNoOfFiles = "" + totalFiles;
            }
            backupBatch.setId(backupBatchOdb.getId());
            backupBatch.setUserName(backupBatchOdb.getUserName());
            backupBatch.setDeviceName(backupBatchOdb.getDeviceName());
            backupBatch.setDeviceUUID(deviceUUID);
            backupBatch.setStatus(STARTED);
            backupBatch.setJobType(jobType);
            backupBatch.setBatchStartTimestamp(batchStartTimestamp);
            backupBatch.setTotalNoOfFiles(totalNoOfFiles);
            backupBatch.setUploadedFiles(uploadedFiles + "/" + totalNoOfFiles);
            backupBatch.setDeviceName(device.getDeviceName());
            backupBatch.setBatchEndTimestamp(System.currentTimeMillis());
            backupBatch.setNoOfFiles(totalFiles);
            backupBatch.setErrorCode(backupBatchOdb.getErrorCode());
            backupBatch.setUploadedSize(uploadedSize);
            backupBatch.setTotalSizeToUpload(backupBatchOdb.getTotalSizeToUpload());
            backupBatch.setFullBackup(fullBackup);
            this.utilServiceObj.saveBackupBatch(cloudId, backupBatch);
            logger.debug(backupBatchOdb.getErrorCode() + ".... sleep for 7 sec..." + backupBatch.getBatchStartTimestamp());
            logger.debug("[backupBatch][" + backupBatch.getUserName() + "][" + backupBatch.getDeviceUUID() + "][" + String.valueOf(backupBatch.getId()) + "][" + backupBatch.getStatus() + "][" + backupBatch.getBatchStartTimestamp() + "][" + backupBatch.getBatchEndTimestamp() + "]");
            logger.debug(" before updateoverview..");
            this.updateBackupOverview(cloudId, jobType, deviceUUID, device, backupBatch, errorCode);
            this.utilServiceObj.deleteEventHubForDeviceUUID(cloudId, deviceUUID, "START_BACKUP");
            logger.debug(" after updateoverview..");
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.trace("Error failed to save backupBatch ..." + String.valueOf(e));
            logger.error("Error failed to save backupBatch ..." + e.getMessage());
        }
        logger.debug("end of calling method backup Batch ...");
        return backupBatch;
    }

    private void updateBatchAttempt(int cloudId, BackupBatch batch, boolean isFirstAttempt, boolean startOp, boolean overLoad, boolean licenseExpired) {
        block33: {
            try {
                BackupBatch backupBatch = this.utilServiceObj.getBackupBatchById(cloudId, batch.getId().toString());
                if (backupBatch != null) {
                    logger.debug(isFirstAttempt + "........updateBatchAttempt.status........" + backupBatch.getStatus());
                    String batchId = backupBatch.getId().toString();
                    if (isFirstAttempt) {
                        BackupAttempt attempt = new BackupAttempt();
                        BeanUtils.copyProperties((Object)backupBatch, (Object)attempt);
                        attempt.setBatchId(batchId);
                        attempt.setStatus(STARTED);
                        attempt.setBatchStartTimestamp(System.currentTimeMillis());
                        attempt.setId(null);
                        attempt.setErrorCode("0");
                        this.utilServiceObj.saveBackupAttempt(cloudId, attempt);
                        break block33;
                    }
                    if (overLoad || licenseExpired) {
                        BackupAttempt bkpAttempt = this.utilServiceObj.getLastBackupAttemptById(cloudId, batchId);
                        logger.debug(backupBatch.getErrorCode() + "........overLoad........" + String.valueOf(bkpAttempt));
                        if (bkpAttempt != null && ("SCANNING".equalsIgnoreCase(bkpAttempt.getStatus()) || INTERRUPTED_STATUS.equalsIgnoreCase(bkpAttempt.getStatus()))) {
                            logger.debug("....stats Type..." + bkpAttempt.getStatus());
                            bkpAttempt.setBatchEndTimestamp(System.currentTimeMillis());
                            BackupAttempt attempt = new BackupAttempt();
                            BeanUtils.copyProperties((Object)backupBatch, (Object)attempt);
                            attempt.setBatchId(batchId);
                            attempt.setId(null);
                            attempt.setBatchStartTimestamp(System.currentTimeMillis());
                            attempt.setErrorCode("1996");
                            attempt.setStatus(INTERRUPTED_STATUS);
                            attempt.setBatchEndTimestamp(System.currentTimeMillis());
                            attempt.setNoOfFiles(0L);
                            attempt.setTotalNoOfFiles(0L);
                            Object currentUploadedFilesStatus = "";
                            int uploadedFiles = 0;
                            int updatedUploadedFiles = 0;
                            if (StringUtils.isEmpty((String)attempt.getUploadedFiles())) {
                                currentUploadedFilesStatus = uploadedFiles + "/" + attempt.getTotalNoOfFiles();
                            } else {
                                String[] parts = backupBatch.getUploadedFiles().split("/");
                                try {
                                    Integer prevBkpFiles = Integer.parseInt(parts[0]);
                                    if (prevBkpFiles != null) {
                                        updatedUploadedFiles = uploadedFiles + prevBkpFiles;
                                    }
                                    currentUploadedFilesStatus = updatedUploadedFiles + "/" + attempt.getTotalNoOfFiles();
                                }
                                catch (Exception e) {
                                    logger.trace("Exception  :" + String.valueOf(e));
                                    logger.error("Exception  :" + e.getMessage());
                                }
                            }
                            logger.debug(backupBatch.getUploadedFiles() + ".......currentUploadedFilesStatus......" + (String)currentUploadedFilesStatus);
                            logger.debug(String.valueOf(attempt.getId()) + ".......currentUploadedFilesStatus backupbatch......" + backupBatch.getStatus());
                            attempt.setUploadedFiles(backupBatch.getUploadedFiles());
                            attempt.setUploadedSize(backupBatch.getUploadedSize());
                            attempt.setStatus(backupBatch.getStatus());
                            this.utilServiceObj.saveBackupAttempt(cloudId, attempt);
                            logger.debug("....SCANNING Type completed...");
                            break block33;
                        }
                        if (bkpAttempt != null) {
                            logger.debug(backupBatch.getUploadedFiles() + "........overLoad.attempt......." + bkpAttempt.getUploadedSize());
                            if (licenseExpired) {
                                bkpAttempt.setErrorCode("1501");
                            } else if ("PAUSED".equalsIgnoreCase(backupBatch.getStatus())) {
                                bkpAttempt.setErrorCode(backupBatch.getErrorCode());
                            } else {
                                bkpAttempt.setErrorCode("1996");
                            }
                            bkpAttempt.setUploadedSize(bkpAttempt.getUploadedSize());
                            bkpAttempt.setStatus(INTERRUPTED_STATUS);
                            bkpAttempt.setBatchEndTimestamp(System.currentTimeMillis());
                            bkpAttempt.setUploadedFiles(backupBatch.getUploadedFiles());
                            this.utilServiceObj.saveBackupAttempt(cloudId, bkpAttempt);
                        }
                        break block33;
                    }
                    if (!backupBatch.getStatus().equals(STARTED)) {
                        BackupAttempt bkpAttempt = this.utilServiceObj.getLastBackupAttemptById(cloudId, batchId);
                        logger.debug(backupBatch.getErrorCode() + ".........attempt vla........" + bkpAttempt.toString());
                        if (bkpAttempt != null) {
                            if (bkpAttempt.getStatus().equalsIgnoreCase("SCANNING")) {
                                bkpAttempt.setErrorCode("0");
                            } else {
                                bkpAttempt.setErrorCode(backupBatch.getErrorCode());
                            }
                            bkpAttempt.setUploadedSize(backupBatch.getUploadedSize());
                            bkpAttempt.setStatus(backupBatch.getStatus());
                            bkpAttempt.setBatchEndTimestamp(System.currentTimeMillis());
                            bkpAttempt.setUploadedFiles(backupBatch.getUploadedFiles());
                            bkpAttempt.setUploadedSize(backupBatch.getUploadedSize());
                            this.utilServiceObj.saveBackupAttempt(cloudId, bkpAttempt);
                        }
                        if (bkpAttempt != null && startOp && bkpAttempt.getStatus().equalsIgnoreCase(STARTED)) {
                            logger.debug("...update code ..." + backupBatch.getErrorCode());
                            this.utilServiceObj.updateAttemptForRestart(cloudId, bkpAttempt.getId(), backupBatch.getErrorCode());
                        }
                        break block33;
                    }
                    BackupAttempt attempt = this.utilServiceObj.getLastBackupAttemptById(cloudId, batchId);
                    logger.debug(startOp + "..." + attempt.getStatus() + ".........attempt..new logic......" + attempt.toString());
                    if (attempt != null) {
                        BackupAttempt lastBkpAttempt = new BackupAttempt();
                        BeanUtils.copyProperties((Object)backupBatch, (Object)lastBkpAttempt);
                        lastBkpAttempt.setBatchStartTimestamp(System.currentTimeMillis());
                        lastBkpAttempt.setBatchEndTimestamp(System.currentTimeMillis());
                        lastBkpAttempt.setNoOfFiles(0L);
                        lastBkpAttempt.setTotalNoOfFiles(0L);
                        lastBkpAttempt.setBatchId(batchId);
                        lastBkpAttempt.setId(null);
                        Object currentUploadedFilesStatus = "";
                        int uploadedFiles = 0;
                        int updatedUploadedFiles = 0;
                        if (StringUtils.isEmpty((String)lastBkpAttempt.getUploadedFiles())) {
                            currentUploadedFilesStatus = uploadedFiles + "/" + lastBkpAttempt.getTotalNoOfFiles();
                        } else {
                            String[] parts = backupBatch.getUploadedFiles().split("/");
                            try {
                                Integer prevBkpFiles = Integer.parseInt(parts[0]);
                                if (prevBkpFiles != null) {
                                    updatedUploadedFiles = uploadedFiles + prevBkpFiles;
                                }
                                currentUploadedFilesStatus = updatedUploadedFiles + "/" + lastBkpAttempt.getTotalNoOfFiles();
                            }
                            catch (Exception e) {
                                logger.trace("Exception  :" + String.valueOf(e));
                                logger.error("Exception  :" + e.getMessage());
                            }
                        }
                        logger.debug(backupBatch.getUploadedFiles() + ".......currentUploadedFilesStatus......" + (String)currentUploadedFilesStatus);
                        logger.debug(String.valueOf(lastBkpAttempt.getId()) + ".......currentUploadedFilesStatus backupbatch......" + backupBatch.getStatus());
                        lastBkpAttempt.setUploadedFiles(backupBatch.getUploadedFiles());
                        lastBkpAttempt.setUploadedSize(backupBatch.getUploadedSize());
                        lastBkpAttempt.setStatus(backupBatch.getStatus());
                        this.utilServiceObj.saveBackupAttempt(cloudId, lastBkpAttempt);
                    }
                    if (attempt == null || !startOp || !attempt.getStatus().equalsIgnoreCase(STARTED)) break block33;
                    logger.debug("....inside interrupted....." + batchId);
                    List<BackupAttempt> list = this.utilServiceObj.getLastTwoBackupAttemptById(cloudId, batchId);
                    boolean prevPause = false;
                    if (!org.apache.commons.collections.CollectionUtils.isEmpty(list)) {
                        try {
                            BackupAttempt backupAttemptOne = list.get(0);
                            BackupAttempt backupAttempt = list.get(2);
                            logger.debug(backupAttempt.getId().toString() + "...attempt first..." + backupAttempt.getStatus());
                            if (backupAttempt.getStatus().equalsIgnoreCase("PAUSED")) {
                                prevPause = true;
                            }
                            if (backupAttemptOne != null && prevPause) {
                                this.utilServiceObj.removebkpAttempt(cloudId, backupAttemptOne.getId());
                            }
                        }
                        catch (Exception e) {
                            logger.error("....unable to search....." + e.getMessage());
                        }
                    }
                    if (!prevPause) {
                        this.utilServiceObj.updateAttemptForRestart(cloudId, attempt.getId(), backupBatch.getErrorCode());
                    }
                    break block33;
                }
                logger.debug("...else attempt..... ");
            }
            catch (Exception e) {
                logger.trace("Error failed to save BackupAttempt ..." + String.valueOf(e));
                logger.error("Error failed to save BackupAttempt ..." + String.valueOf(e));
            }
        }
    }

    private String getNoOfFilesRemaining(String totalNoOfFilesFromBatch, String uploadedFilesBatchTemp) {
        Object uploadedFilesBatch = uploadedFilesBatchTemp;
        Integer noOfFilesRemaining = 0;
        logger.debug(" Files ********************** " + (String)uploadedFilesBatch);
        if (StringUtils.isEmpty((String)uploadedFilesBatch)) {
            uploadedFilesBatch = "0/" + totalNoOfFilesFromBatch;
        }
        String[] parts = ((String)uploadedFilesBatch).split("/");
        try {
            Integer actualNoOfFiles = Integer.parseInt(parts[1]);
            Integer noOfFilesBackedup = Integer.parseInt(parts[0]);
            noOfFilesRemaining = actualNoOfFiles - noOfFilesBackedup;
        }
        catch (Exception e) {
            logger.trace("Exception  :" + String.valueOf(e));
            logger.error("Exception  :" + e.getMessage());
        }
        return noOfFilesRemaining.toString();
    }

    private String getDateInFormat(Long deviceCreatedDate) {
        SimpleDateFormat df2 = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss");
        Date dateD = new Date(deviceCreatedDate);
        return df2.format(dateD);
    }

    private int vaildatedLicensceStatus(Cloud cloud) {
        if (cloud.getValidityPeriod() >= System.currentTimeMillis() && cloud.getStatusCode().equals("ACTIVE")) {
            return 1500;
        }
        return 1501;
    }

    private String getDriveIdForUser(String emailId) {
        Drive drive = null;
        try {
            GraphServiceClient<Request> graphClient = Graph.getInstance().getGraphClient();
            ArrayList<QueryOption> requestOptions = new ArrayList<QueryOption>();
            requestOptions.add(new QueryOption("$filter", (Object)("mail eq '" + emailId + "'")));
            UserCollectionPage iUserCollectionPage = (UserCollectionPage)((UserCollectionRequest)graphClient.users().buildRequest(requestOptions)).top(1).get();
            String userId = "";
            for (User userObj : iUserCollectionPage.getCurrentPage()) {
                logger.debug(userObj.userPrincipalName + "... vals..." + userObj.givenName);
                userId = userObj.id;
            }
            logger.debug(userId + ".. get drive1 for user given name.... " + emailId);
            int retryDrive = 0;
            do {
                drive = StorageService.getDrive(graphClient, userId);
                logger.debug(++retryDrive + "....drive for user...." + String.valueOf(drive));
                Thread.sleep(10000L);
            } while (retryDrive < 5 && drive == null || drive == null);
            if (drive != null) {
                logger.debug(emailId + "....drive id for user ... " + drive.id);
                return drive.id;
            }
        }
        catch (GraphServiceException e) {
            logger.error(" ... error trying to get token ..." + e.getResponseCode());
            if (e.getResponseCode() == 401) {
                logger.debug("..sleep for 90 sec...");
                try {
                    Thread.sleep(90000L);
                    return this.getDriveIdForUser(emailId);
                }
                catch (InterruptedException interruptedException) {
                }
            } else if (e.getResponseCode() == 404) {
                logger.error("... not able to access resource check right user token is mapped .... " + emailId);
            }
        }
        catch (Exception ee) {
            logger.error(".... exception......" + ee.getMessage());
        }
        return null;
    }

    private static Drive getDrive(GraphServiceClient<Request> graphClient, String userId) {
        Drive drive = graphClient.users(userId).drive().buildRequest(new Option[0]).get();
        return drive;
    }

    public String getEWSTokenFromDb(int cloudId) {
        String token = this.utilServiceObj.getEWSToken(cloudId);
        return token;
    }

    static {
        logger = LogManager.getLogger(StorageService.class);
        batchList = null;
        batchFilesList = null;
    }

    class NotifierEmailBodyElement {
        private int cloudId;
        private String cloudName;
        private String userName;
        private String deviceName;
        private String restoreDeviceName;
        private String restoreFolder;
        private String noOfFilesBackedUp;
        private String totalBackupSize;
        private boolean notifyAllAdmins;

        NotifierEmailBodyElement(StorageService this$0) {
        }

        public String getDeviceName() {
            return this.deviceName;
        }

        public void setDeviceName(String deviceName) {
            this.deviceName = deviceName;
        }

        public String getRestoreDeviceName() {
            return this.restoreDeviceName;
        }

        public void setRestoreDeviceName(String restoreDeviceName) {
            this.restoreDeviceName = restoreDeviceName;
        }

        public String getRestoreFolder() {
            return this.restoreFolder;
        }

        public void setRestoreFolder(String restoreFolder) {
            this.restoreFolder = restoreFolder;
        }

        public String getTotalBackupSize() {
            return this.totalBackupSize;
        }

        public void setTotalBackupSize(String totalBackupSize) {
            this.totalBackupSize = totalBackupSize;
        }

        public String getNoOfFilesBackedUp() {
            return this.noOfFilesBackedUp;
        }

        public void setNoOfFilesBackedUp(String noOfFilesBackedUp) {
            this.noOfFilesBackedUp = noOfFilesBackedUp;
        }

        public boolean isNotifyAllAdmins() {
            return this.notifyAllAdmins;
        }

        public void setNotifyAllAdmins(boolean notifyAllAdmins) {
            this.notifyAllAdmins = notifyAllAdmins;
        }

        public String getUserName() {
            return this.userName;
        }

        public void setUserName(String userName) {
            this.userName = userName;
        }

        public int getCloudId() {
            return this.cloudId;
        }

        public void setCloudId(int cloudId) {
            this.cloudId = cloudId;
        }

        public String getCloudName() {
            return this.cloudName;
        }

        public void setCloudName(String cloudName) {
            this.cloudName = cloudName;
        }
    }
}

