/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.cloudbackup;

import com.google.api.client.repackaged.org.apache.commons.codec.binary.Base64;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.microsoft.graph.http.GraphServiceException;
import com.microsoft.graph.models.DriveItem;
import com.microsoft.graph.models.User;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.ListCollectionPage;
import com.microsoft.graph.requests.ListCollectionRequest;
import com.microsoft.graph.requests.ListCollectionRequestBuilder;
import com.microsoft.graph.requests.UserCollectionPage;
import com.microsoft.graph.requests.UserCollectionRequest;
import com.parablu.cloudbackup.CloudBackupStorageBridge;
import com.parablu.pcbd.dao.ExternalStorageBackupFileDao;
import com.parablu.pcbd.domain.BackUpImage;
import com.parablu.pcbd.domain.BackupBatch;
import com.parablu.pcbd.domain.BackupPolicy;
import com.parablu.pcbd.domain.Cloud;
import com.parablu.pcbd.domain.CloudCustomisableDetails;
import com.parablu.pcbd.domain.Device;
import com.parablu.pcbd.domain.DeviceBackupOverView;
import com.parablu.pcbd.domain.EWSAppSetting;
import com.parablu.pcbd.domain.MailInfo;
import com.parablu.pcbd.domain.OfficeBackupPolicy;
import com.parablu.pcbd.domain.PrivacyGateway;
import com.parablu.pcbd.domain.PstBatchDetail;
import com.parablu.pcbd.domain.RestoreBackUpImage;
import com.parablu.pcbd.domain.RestoreEvents;
import com.parablu.pcbd.domain.RestoreHistory;
import com.parablu.pcbd.domain.RestoreProgressEvents;
import com.pg.controller.BaseController;
import com.pg.controller.C2CGraphClient;
import com.pg.controller.Graph;
import com.pg.dao.BackupFileDao;
import com.pg.domain.BackupFile;
import com.pg.domain.FileInfo;
import com.pg.domain.OfficeRestoreFileInfo;
import com.pg.element.RestorePoint;
import com.pg.exception.RestoreEventDeletedException;
import com.pg.helper.constant.GeneralHelperConstant;
import com.pg.helper.constant.PCHelperConstant;
import com.pg.helper.utils.MemoryStore;
import com.pg.httpclient.util.HttpClientUtil;
import com.pg.odb.util.OneDriveUtil;
import com.pg.paracloud.to.DownloadFileTO;
import com.pg.paracloud.to.DownloadTO;
import com.pg.service.DownloadService;
import com.pg.service.UtilService;
import com.pg.sync.service.SyncDownloadService;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.invoke.CallSite;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CompletionService;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import microsoft.exchange.webservices.data.core.ExchangeService;
import microsoft.exchange.webservices.data.core.enumeration.misc.ConnectingIdType;
import microsoft.exchange.webservices.data.core.enumeration.misc.ExchangeVersion;
import microsoft.exchange.webservices.data.core.enumeration.property.WellKnownFolderName;
import microsoft.exchange.webservices.data.core.enumeration.search.FolderTraversal;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceLocalException;
import microsoft.exchange.webservices.data.core.exception.service.remote.ServiceRequestException;
import microsoft.exchange.webservices.data.core.service.folder.Folder;
import microsoft.exchange.webservices.data.misc.ImpersonatedUserId;
import microsoft.exchange.webservices.data.property.complex.FolderId;
import microsoft.exchange.webservices.data.property.complex.Mailbox;
import microsoft.exchange.webservices.data.search.FindFoldersResults;
import microsoft.exchange.webservices.data.search.FolderView;
import okhttp3.Call;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.collections.map.HashedMap;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bson.types.ObjectId;
import org.json.JSONObject;
import org.springframework.beans.BeanUtils;
import org.springframework.util.CollectionUtils;

public enum OfficeRestoreService {
    GETINST;

    private static final String IN_PLACE_ARCHIVE = "In-Place Archive";
    public static final String DD_MMM_YYYY_HH_MM_SS = "dd-MMM-yyyy HH:mm:ss";
    private static final String BACKUP = "BACKUP";
    private static final String COMPLETED = "COMPLETED";
    private static final String RESOURCE = "https://outlook.office365.com";
    private static final String AUTHORITY = "https://login.microsoftonline.com/";
    private static final String EWS_URL = "https://outlook.office365.com/EWS/Exchange.asmx";
    private static final String VERSION = "(Version-";
    private static final String STOPPED_BACKUP_ERROR_CODE = "1207";
    private static final String PAUSED_BACKUP_ERROR_CODE = "1992";
    private static final String STARTED = "STARTED";
    static final Logger logger;
    ExternalStorageBackupFileDao externalStorageBackupFileDao;
    CloudBackupStorageBridge uploadService;
    UtilService utilServiceObj;
    SyncDownloadService syncDownloadService;
    DownloadService downloadService;
    BackupFileDao backupFileDao;
    volatile boolean shutdown = false;
    static final String BASE_FOLDER = "Files/";
    private Set<String> fileUnderProcess = new HashSet<String>();
    private TimerTask backupTimerTask = null;
    private Timer backupTimer = null;
    private Set<String> batchUnderProcess = new HashSet<String>();
    private static List<RestoreEvents> batchList;
    private String ewsToken = null;
    private static final String IS_TOMCAT_RUNNING = "isTomcatRunning";

    public boolean initialize(CloudBackupStorageBridge uploadService, UtilService utilService, SyncDownloadService syncDownloadServiceObj, DownloadService downloadServiceObj, BackupFileDao backupFileDao, ExternalStorageBackupFileDao externalStorageBackupFileDao) {
        try {
            logger.debug("OffilceRestore service!");
            this.uploadService = uploadService;
            this.utilServiceObj = utilService;
            this.syncDownloadService = syncDownloadServiceObj;
            this.downloadService = downloadServiceObj;
            this.backupFileDao = backupFileDao;
            this.externalStorageBackupFileDao = externalStorageBackupFileDao;
            logger.info("response handler started");
        }
        catch (Exception e) {
            logger.error("Failed to start the consumer! " + e.getMessage(), (Throwable)e);
            return false;
        }
        return true;
    }

    public void run() {
        try {
            Thread.sleep(TimeUnit.SECONDS.toMillis(30L));
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
        Cloud cloud = this.utilServiceObj.getCloud(1);
        boolean isExchangeBackupEnabled = this.isExchangeBackupEnabled(cloud);
        boolean isOneDriveForBusinessBackupEnabled = this.isOneDriveForBusinessBackupEnabled(cloud);
        logger.debug("Office service...." + isOneDriveForBusinessBackupEnabled);
        logger.debug("Restore service has started running! - " + Thread.currentThread().getName());
        logger.debug(isExchangeBackupEnabled + "...inside while loop check....odb .." + isOneDriveForBusinessBackupEnabled);
        ExecutorService executor = null;
        try {
            long threadSize = PCHelperConstant.getThreadLimit();
            if (threadSize == 0L) {
                threadSize = 5L;
            }
            logger.debug(" threads val........" + threadSize);
            int threadSizeVal = (int)threadSize;
            executor = Executors.newFixedThreadPool(threadSizeVal);
            batchList = this.utilServiceObj.getRestoreEventsForBlukrypt(cloud.getCloudId(), PCHelperConstant.getComponentName(), true);
            ExecutorCompletionService<String> pool = new ExecutorCompletionService<String>(executor);
            this.checkThreadStatusAndStartUpload(cloud, executor, pool);
            for (int i = 0; i < threadSizeVal; ++i) {
                logger.debug("Creating thread for first time>>>>>>>>> i value::" + i);
                this.callRestoreFiles(cloud, executor, pool);
            }
            logger.debug(" exit upload part..........");
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(" exception in backup upload job......." + e.getMessage());
            logger.trace("exception in backup upload job ......." + String.valueOf(e));
        }
        logger.debug("Done!");
    }

    private boolean isExchangeBackupEnabled(Cloud cl) {
        boolean isExpiredFileDeleteEnabled = false;
        List list = cl.getCloudCustomisableDetails();
        list.removeAll(Collections.singleton(null));
        if (!org.apache.commons.collections.CollectionUtils.isEmpty((Collection)list)) {
            for (CloudCustomisableDetails cloudPluginDetails : list) {
                if (cloudPluginDetails == null || StringUtils.isEmpty((String)cloudPluginDetails.getName()) || !"Exchange Backup Enabled".equalsIgnoreCase(cloudPluginDetails.getName())) continue;
                isExpiredFileDeleteEnabled = true;
                break;
            }
        }
        return isExpiredFileDeleteEnabled;
    }

    private boolean isOneDriveForBusinessBackupEnabled(Cloud cl) {
        boolean isExpiredFileDeleteEnabled = false;
        List list = cl.getCloudCustomisableDetails();
        list.removeAll(Collections.singleton(null));
        if (!org.apache.commons.collections.CollectionUtils.isEmpty((Collection)list)) {
            for (CloudCustomisableDetails cloudPluginDetails : list) {
                if (cloudPluginDetails == null || StringUtils.isEmpty((String)cloudPluginDetails.getName()) || !"OneDrive Backup Enabled".equalsIgnoreCase(cloudPluginDetails.getName())) continue;
                isExpiredFileDeleteEnabled = true;
                break;
            }
        }
        return isExpiredFileDeleteEnabled;
    }

    private void callRestoreFiles(Cloud cloud, ExecutorService executor, CompletionService<String> pool) {
        BaseController.printLogs("Files to restore ............... :", PCHelperConstant.isBrevityLogging());
        Runnable uploadJob = () -> this.restoreFiles(cloud, executor, pool);
        pool.submit(uploadJob, "");
    }

    private void restoreFiles(Cloud cloud, ExecutorService executor, CompletionService<String> pool) {
        logger.debug("....inside while loop restore..........");
        RestoreEvents restoreEvents = null;
        try {
            restoreEvents = this.assignBlukryptRestoreEvent(true);
            if (restoreEvents != null && restoreEvents.isMsRestore()) {
                Device device;
                RestoreProgressEvents restoreProgressEvents;
                logger.debug(restoreEvents.isInPlaceRestore() + "....inside while isMsRestore.........." + restoreEvents.isMsRestore());
                BackupBatch backupBatch = new BackupBatch();
                BeanUtils.copyProperties((Object)restoreEvents, (Object)backupBatch);
                backupBatch.setDeviceUUID(restoreEvents.getActionOnDeviceUUID());
                backupBatch.setId(restoreEvents.getId());
                int cloudId = cloud.getCloudId();
                BackupBatch pbBkpBatch = this.utilServiceObj.getBackupBatchById(cloudId, backupBatch.getId().toString());
                backupBatch.setUserName(restoreEvents.getActionBy());
                backupBatch.setMsBatch(true);
                if (pbBkpBatch == null) {
                    this.startBackupBatch(backupBatch, cloud, 0);
                }
                if ((restoreProgressEvents = this.utilServiceObj.getRestoreProgresByDeviceUUID(cloudId, backupBatch.getDeviceUUID(), restoreEvents.getActionBy())) == null) {
                    restoreProgressEvents = new RestoreProgressEvents();
                } else {
                    restoreProgressEvents.setId(restoreProgressEvents.getId());
                }
                String restorePointId = restoreEvents.getRestorePointId();
                if (StringUtils.isEmpty((String)restorePointId)) {
                    device = this.utilServiceObj.getDeviceForUUID(cloudId, restoreEvents.getActionOnDeviceUUID());
                    RestorePoint restorePoint = this.uploadService.getLatestRestorePoint(device);
                    restorePointId = restorePoint.getId();
                }
                restoreProgressEvents.setMsRestore(true);
                restoreProgressEvents.setDeviceUUID(backupBatch.getDeviceUUID());
                restoreProgressEvents.setUserName(restoreEvents.getActionBy());
                restoreProgressEvents.setBatchId(backupBatch.getId().toString());
                this.utilServiceObj.saveRestoreProgressForDevice(cloudId, restoreProgressEvents);
                device = this.utilServiceObj.getDeviceForUUID(cloudId, backupBatch.getDeviceUUID());
                if (Device.TYPE.OUTLOOK.name().equals(device.getDeviceType())) {
                    restoreSessionId = this.uploadService.restoretMailboxProtectionUnitsByDirectoryObjectId(device, restoreEvents.isInPlaceRestore(), restorePointId);
                    restoreProgressEvents.setMsRestore(true);
                    this.utilServiceObj.updaterestoreSessionIdForBatch(cloudId, backupBatch, restoreSessionId);
                    this.uploadService.waitForRestoreCompletion(restoreSessionId, backupBatch, cloudId, device.getDeviceType());
                } else if (Device.TYPE.ONEDRIVE.name().equals(device.getDeviceType())) {
                    restoreSessionId = this.uploadService.restoreOdbProtectionUnitsByDirectoryObjectId(device, restoreEvents.isInPlaceRestore(), restorePointId);
                    restoreProgressEvents.setMsRestore(true);
                    this.utilServiceObj.updaterestoreSessionIdForBatch(cloudId, backupBatch, restoreSessionId);
                    this.uploadService.waitForRestoreCompletion(restoreSessionId, backupBatch, cloudId, device.getDeviceType());
                    String restoreSiteWebUrl = this.uploadService.getRestoredSiteId(restoreSessionId, Device.TYPE.ONEDRIVE.name());
                    if (!StringUtils.isEmpty((String)restoreSiteWebUrl)) {
                        this.utilServiceObj.updateSiteUrl(cloudId, backupBatch, restoreSiteWebUrl);
                    }
                } else if (Device.TYPE.SHAREPOINT.name().equals(device.getDeviceType())) {
                    restoreSessionId = this.uploadService.restoreSPProtectionUnitsByDirectoryObjectId(device, restoreEvents.isInPlaceRestore(), restorePointId);
                    restoreProgressEvents.setMsRestore(true);
                    this.utilServiceObj.updaterestoreSessionIdForBatch(cloudId, backupBatch, restoreSessionId);
                    this.uploadService.waitForRestoreCompletion(restoreSessionId, backupBatch, cloudId, device.getDeviceType());
                    String restoreSiteWebUrl = this.uploadService.getRestoredSiteId(restoreSessionId, Device.TYPE.SHAREPOINT.name());
                    if (!StringUtils.isEmpty((String)restoreSiteWebUrl)) {
                        this.utilServiceObj.updateSiteUrl(cloudId, backupBatch, restoreSiteWebUrl);
                    }
                }
                this.utilServiceObj.removeRestoreProgress(cloudId, restoreEvents.getDestinationDeviceUUID());
                this.utilServiceObj.deleteRestoreEventForDeviceUUID(cloudId, restoreEvents.getDestinationDeviceUUID(), "");
                this.batchUnderProcess.remove(backupBatch.getId().toString());
                this.updateBatchAndOverview(cloud.getCloudId(), backupBatch.getId(), COMPLETED, backupBatch.getDeviceUUID(), 0, 0, 0L);
                logger.debug("......restore msbatch.....");
            } else {
                if (restoreEvents != null && StringUtils.isNotBlank((String)restoreEvents.getDestinationDeviceUUID())) {
                    this.restoreBatch(restoreEvents, cloud);
                    logger.error(restoreEvents.getActionOnDeviceUUID() + " %%%%%%% restore completed for file ....");
                }
                if (restoreEvents != null && restoreEvents.getEventType() == null && StringUtils.isBlank((String)restoreEvents.getDestinationDeviceUUID())) {
                    logger.debug("starting export as pst for the restore event");
                    this.downloadPst(restoreEvents, cloud);
                }
                if (restoreEvents != null && restoreEvents.getEventType() != null && restoreEvents.getEventType().equalsIgnoreCase("LARGE_FILE_DOWNLOAD")) {
                    logger.debug("inside large file download...");
                    this.initiateBrowserDownload(cloud, restoreEvents);
                } else {
                    BaseController.printLogs("... no events for restore...", PCHelperConstant.isBrevityLogging());
                }
                if (!CollectionUtils.isEmpty(batchList)) {
                    logger.debug("Thread ready for next File .... " + batchList.size());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("exception inside storageservice .... ", (Throwable)e);
            logger.trace("exception inside storageservice ...." + String.valueOf(e));
        }
        if (restoreEvents != null && restoreEvents.getId() != null) {
            this.batchUnderProcess.remove(restoreEvents.getId().toString());
        }
        BaseController.printLogs("no files to upload so wait and then retry>>>>", PCHelperConstant.isBrevityLogging());
        logger.error("no files to upload so wait and then retry>>>>");
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.callRestoreFiles(cloud, executor, pool);
    }

    static String decodeBase64UTFString(String encodedString) {
        String decodedString = encodedString;
        try {
            decodedString = new String(Base64.decodeBase64((String)encodedString), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            logger.debug("UnsupportedEncodingException......" + e.getMessage());
        }
        return decodedString;
    }

    public void restoreBatch(RestoreEvents restoreEvents, Cloud cloudval) {
        String deviceName;
        Device device2;
        List<OfficeRestoreFileInfo> fileInfoList;
        int cloudId = cloudval.getCloudId();
        logger.debug("... inside-restore ....." + String.valueOf(restoreEvents.getId()));
        String deviceUUID = restoreEvents.getActionOnDeviceUUID();
        BackupBatch backupBatch = new BackupBatch();
        BeanUtils.copyProperties((Object)restoreEvents, (Object)backupBatch);
        backupBatch.setId(restoreEvents.getId());
        String policyName = backupBatch.getOdbPolicyName();
        backupBatch.setUserName(restoreEvents.getActionBy());
        BackupBatch pbBkpBatch = this.utilServiceObj.getBackupBatchById(cloudval.getCloudId(), backupBatch.getId().toString());
        String destinationUserIdForOneDriveRestore = restoreEvents.getDestinationUserIdForOneDriveRestore();
        int uploadedFiles = 0;
        boolean c2cRestore = false;
        if (restoreEvents.getOfficePolicyName() != null && restoreEvents.getOfficePolicyName().equalsIgnoreCase("pb-endpoint-to-onedrive-restore")) {
            c2cRestore = true;
        }
        if (pbBkpBatch != null) {
            String[] parts = pbBkpBatch.getUploadedFiles().split("/");
            try {
                uploadedFiles = Integer.parseInt(parts[0]);
            }
            catch (Exception e) {
                logger.trace("Exception  :" + String.valueOf(e));
                logger.error("Exception  :" + e.getMessage());
            }
            logger.debug(pbBkpBatch.getUploadedSize() + "....prev files ... " + uploadedFiles);
        }
        logger.debug("....prev files ... " + uploadedFiles);
        Device device = this.utilServiceObj.getDeviceForUUID(cloudId, deviceUUID);
        boolean isOutlookDevice = false;
        boolean isSPDevice = false;
        ExchangeService service = null;
        Map<Object, Object> existingFolders = new HashMap();
        if (device.getDeviceType().equalsIgnoreCase(Device.TYPE.SHAREPOINT.name())) {
            isSPDevice = true;
        }
        if (isSPDevice) {
            String decodedDeviceUUId = OfficeRestoreService.decodeBase64UTFString(restoreEvents.getDestinationDeviceUUID());
            logger.debug("...desitnationuuuid...." + decodedDeviceUUId);
        }
        if (device.getDeviceType().equalsIgnoreCase(Device.TYPE.BACKUP.name()) && StringUtils.isEmpty((String)restoreEvents.getDestinationPath())) {
            restoreEvents.setDestinationPath("EndPointRestore/" + device.getDeviceName() + "/" + OfficeRestoreService.getDateInFormat(System.currentTimeMillis()));
        }
        if (device.getDeviceType().equalsIgnoreCase(Device.TYPE.OUTLOOK.name())) {
            isOutlookDevice = true;
            logger.debug("....before getting ews app....");
            EWSAppSetting appSetting = this.utilServiceObj.getEwsAppSettingDetail(cloudId);
            logger.debug("....before getting ews app....");
            this.getEWSAccesToken(appSetting, false);
            String token = this.ewsToken;
            logger.debug("....after1..." + device.getUserName());
            com.parablu.pcbd.domain.User userObj = this.utilServiceObj.getUserInfoByName(1, device.getUserName());
            logger.debug("....after2 latest..." + String.valueOf(userObj));
            String userMail = userObj.getEmailId();
            if (!StringUtils.isEmpty((String)userMail)) {
                appSetting.setAccountId(userMail);
            }
            logger.debug("....after4..." + appSetting.getAccountId());
            service = OfficeRestoreService.getAuthenticatedService(token, appSetting.getAccountId());
            logger.debug("....after5..." + appSetting.getAccountId());
            existingFolders = this.getExistingFolders(service, userMail);
            logger.debug("....after6...");
        }
        String cloudName = cloudval.getCloudName();
        String userName = restoreEvents.getUserName();
        BackUpImage backupImage = null;
        if (userName == null) {
            return;
        }
        logger.debug("....after5...");
        if (!restoreEvents.isDevice()) {
            backupImage = this.downloadService.getBackupImageForId(cloudval.getCloudId(), device, restoreEvents.getFileInfo().getId());
            logger.debug(backupImage.getFileName() + "....after6..." + backupImage.isPresent() + "..." + backupImage.getDevicePath());
            logger.debug(backupImage.getId().toString() + "....after6a...");
            if (isOutlookDevice && !backupImage.isPresent()) {
                backupImage = this.downloadService.getPresentBackupImageForFilePathNameMd5(cloudId, device, backupImage);
            }
            if (backupImage == null) {
                logger.error("...... no file to restore....");
                return;
            }
        }
        logger.debug("....after7...");
        boolean isFolder = false;
        boolean isDevice = false;
        Object restoreFolder = "";
        if (restoreEvents.isDevice()) {
            isDevice = true;
        } else if (backupImage.isFolder()) {
            if (!StringUtils.isEmpty((String)backupImage.getFileName()) && StringUtils.isEmpty((String)backupImage.getDevicePath()) && backupImage.getFileName().equalsIgnoreCase("Files")) {
                isDevice = true;
            } else {
                isFolder = true;
            }
        }
        boolean singleFileRestore = false;
        boolean folderRestore = false;
        logger.debug("......device or folder or file..." + isDevice + "...." + isFolder);
        if (isDevice) {
            restoreFolder = "All Folders";
        } else if (isFolder) {
            restoreFolder = backupImage.getDevicePath() + "/" + backupImage.getFileName();
            folderRestore = true;
        } else {
            restoreFolder = backupImage.getFileName();
            singleFileRestore = true;
        }
        if (((String)restoreFolder).startsWith("null/")) {
            restoreFolder = ((String)restoreFolder).replaceAll("null/", "");
        }
        HashSet<String> folderSet = new HashSet<String>();
        if (pbBkpBatch == null) {
            RestoreBackUpImage restoreBackUpImage = new RestoreBackUpImage();
            if (backupImage != null) {
                BeanUtils.copyProperties((Object)backupImage, (Object)restoreBackUpImage);
            }
            this.updateAllFilesforRestore(restoreEvents, cloudval, cloudId, device, cloudName, userName, restoreBackUpImage, isFolder, isDevice, folderSet, false);
            if (isOutlookDevice && restoreEvents.isRestoreDeletedFiles()) {
                this.updateAllFilesforRestore(restoreEvents, cloudval, cloudId, device, cloudName, userName, restoreBackUpImage, isFolder, isDevice, folderSet, restoreEvents.isRestoreDeletedFiles());
            }
        }
        if (org.apache.commons.collections.CollectionUtils.isEmpty(fileInfoList = this.getOfficeRestoreFileInfoFromListForBatchId(1, restoreEvents.getId().toString()))) {
            fileInfoList = new ArrayList<OfficeRestoreFileInfo>();
            logger.debug(".... no files to process for batch ... ");
        }
        logger.debug(".....deviceuser and type...." + device.getUserName() + "...." + device.getDeviceType());
        OfficeBackupPolicy officeBackupPolicy = this.utilServiceObj.getOfficeBackupPolicyForUser(cloudId, device.getUserName(), device.getDeviceType());
        boolean createMailLinkEnabled = false;
        boolean isInPlaceArchiveBackupEnabled = this.isInPlaceArchiveBackupEnabled(cloudval.getCloudCustomisableDetails());
        if (!isInPlaceArchiveBackupEnabled && officeBackupPolicy != null) {
            officeBackupPolicy.setInPlaceMailArchiveEnabled(false);
        }
        if (officeBackupPolicy != null && device.getOsType().equalsIgnoreCase(Device.TYPE.OUTLOOK.name())) {
            createMailLinkEnabled = officeBackupPolicy.isCreateMailLinkEnabled();
        }
        long totalSizeToUpload = 0L;
        long totalNumberOfFiles = 0L;
        AtomicLong restoredSize = new AtomicLong(0L);
        AtomicLong newRestoredSize = new AtomicLong(0L);
        logger.debug(totalNumberOfFiles + "....total size to restore fdf.&*&*... " + totalSizeToUpload);
        backupBatch.setTotalSizeToUpload(totalSizeToUpload);
        if (pbBkpBatch != null) {
            backupBatch.setTotalSizeToUpload(pbBkpBatch.getTotalSizeToUpload());
            backupBatch.setTotalNoOfFiles(pbBkpBatch.getTotalNoOfFiles());
            backupBatch.setBatchStartTimestamp(pbBkpBatch.getBatchStartTimestamp());
            backupBatch.setUploadedSize(pbBkpBatch.getUploadedSize());
            restoredSize.set(pbBkpBatch.getUploadedSize() != null ? Long.valueOf(pbBkpBatch.getUploadedSize()) : 0L);
        } else {
            Object path = restoreFolder;
            if (((String)restoreFolder).equalsIgnoreCase("All Folders")) {
                path = "";
            }
            if (isDevice || backupImage.isFolder()) {
                String restoreDataBefore = String.valueOf(restoreEvents.getRestoreDataBefore());
                long[] longObj = this.utilServiceObj.getLatestRestorableSizeRecursive(cloudId, cloudName, device, (String)path, restoreDataBefore, restoreEvents.isRestoreDeletedFiles(), isOutlookDevice);
                totalSizeToUpload += longObj[0];
                totalNumberOfFiles += longObj[1];
            } else {
                totalSizeToUpload = backupImage.getSize();
                totalNumberOfFiles = 1L;
            }
            if (device.getOsType().equalsIgnoreCase(Device.TYPE.OUTLOOK.name())) {
                totalSizeToUpload /= 1024L;
            }
            backupBatch.setTotalNoOfFiles("" + totalNumberOfFiles);
        }
        backupBatch.setDeviceUUID(device.getDeviceUUID());
        this.startBackupBatch(backupBatch, cloudval, uploadedFiles);
        logger.debug(totalSizeToUpload + ".... ss before save history...." + backupBatch.getUserName());
        String restorePath = "";
        boolean restoredInDiffPath = false;
        if (restoreEvents.isInPlaceRestore()) {
            restorePath = "In place Restore";
            restoredInDiffPath = true;
        } else {
            restorePath = restoreEvents.getDestinationPath();
        }
        String destinationDeviceUUID = restoreEvents.getDestinationDeviceUUID();
        logger.debug("..... device before restore..... " + destinationDeviceUUID);
        Device destDevice = null;
        if (isSPDevice) {
            logger.debug("..dest device...." + userName);
            destDevice = this.utilServiceObj.getDeviceForUUID(cloudId, restoreEvents.getDestinationDeviceUUID());
        } else {
            destDevice = this.utilServiceObj.getDeviceForUUID(cloudId, restoreEvents.getDestinationDeviceUUID());
        }
        logger.debug("..... device after..... " + String.valueOf(destDevice));
        logger.debug(".....#restoreFolder# 1..." + (String)restoreFolder);
        backupBatch.setId(restoreEvents.getId());
        NotifierEmailBodyElement notifierEmailBodyElement = new NotifierEmailBodyElement(this);
        notifierEmailBodyElement.setDeviceName(device.getDeviceName());
        notifierEmailBodyElement.setRestoreFolder((String)restoreFolder);
        com.parablu.pcbd.domain.User user = this.utilServiceObj.getUserInfoByName(cloudId, userName);
        this.saveRestoreHistory(cloudId, (String)restoreFolder, backupBatch, "" + totalSizeToUpload, restorePath, restoredInDiffPath, device, destDevice, cloudName, notifierEmailBodyElement, user, destinationUserIdForOneDriveRestore);
        logger.debug(".....#restoreFolder# 2..." + String.valueOf(restoreEvents.getId()) + "...batch..." + String.valueOf(backupBatch));
        int totalNoOfFilesToRestore = Integer.parseInt(backupBatch.getTotalNoOfFiles());
        this.saveRestoreProgress(cloudId, device.getDeviceUUID(), fileInfoList, restoreEvents.getActionBy(), restoreEvents.getId().toString(), totalNoOfFilesToRestore, uploadedFiles);
        logger.debug(restoreEvents.getActionOnDeviceUUID() + "....deviceuuid..." + restoreEvents.getDestinationDeviceUUID());
        RestoreProgressEvents restoreProgressEvents = this.utilServiceObj.getRestoreProgresByDeviceUUID(cloudId, device.getDeviceUUID(), restoreEvents.getActionBy());
        logger.debug(restoreProgressEvents.getRestoredFiles() + "....after save history ...." + fileInfoList.size());
        int errorCode = 0;
        Iterator<OfficeRestoreFileInfo> iterator = fileInfoList.iterator();
        Iterator<OfficeRestoreFileInfo> iterator1 = fileInfoList.iterator();
        AtomicInteger restoredFiles = new AtomicInteger((int)restoreProgressEvents.getRestoredFiles());
        restoredSize = new AtomicLong(Long.valueOf(backupBatch.getUploadedSize() == null ? "0" : backupBatch.getUploadedSize()));
        String currentRestorePath = "";
        long currentFolderRestoredFiles = 0L;
        boolean isBatchStopped = false;
        boolean isFoldersCreated = false;
        ThreadFactoryBuilder factoryBuilder = new ThreadFactoryBuilder().setNameFormat("c2cupload-$$%d$$");
        ExecutorService multiPartUploadService = Executors.newFixedThreadPool(10, factoryBuilder.build());
        ExecutorCompletionService<BackupFile> pool = new ExecutorCompletionService<BackupFile>(multiPartUploadService);
        Object backupTimerTask = null;
        Object backupTimer = null;
        Device destDeviceObj = destDevice;
        if (device.getDeviceType().equalsIgnoreCase(Device.TYPE.BACKUP.name())) {
            Runnable runnable = () -> {
                Device device2;
                this.utilServiceObj.updateRapidRestoreProgress(cloudId, device.getDeviceUUID(), restoreEvents.getActionBy(), "", 0L, STARTED);
                BackUpImage backupImage1 = null;
                Object currentRestorePathForLink = "";
                String user1 = restoreEvents.getUserName();
                String driveUserName = "";
                String driveId = "";
                long totalNoOfRapidRestoredFiles = 0L;
                String userName1 = restoreEvents.getUserName();
                if (!restoreEvents.isDevice() && (backupImage1 = this.downloadService.getBackupImageForId(cloudval.getCloudId(), device, restoreEvents.getFileInfo().getId())) == null) {
                    logger.debug("...... no file to restore....");
                    return;
                }
                if (!restoreEvents.getActionOnDeviceUUID().equalsIgnoreCase(restoreEvents.getDestinationDeviceUUID()) && (device2 = this.utilServiceObj.getDeviceForUUID(cloudId, restoreEvents.getDestinationDeviceUUID())) != null) {
                    driveUserName = device2.getUserName();
                }
                logger.debug("**************devusername*******" + driveUserName);
                if (StringUtils.isNotEmpty((String)destinationUserIdForOneDriveRestore)) {
                    driveUserName = destinationUserIdForOneDriveRestore;
                }
                logger.debug("**************devusername1*******" + driveUserName);
                if (StringUtils.isEmpty((String)driveUserName)) {
                    driveUserName = userName1;
                }
                com.parablu.pcbd.domain.User destUser = this.utilServiceObj.getUserInfoByName(cloudId, driveUserName);
                logger.debug(String.valueOf(destUser) + "**************devusername2*******" + userName1);
                driveId = OneDriveUtil.getDriveForC2CUser(cloudId, destUser.getEmailId());
                if (driveId.equalsIgnoreCase("404")) {
                    this.utilServiceObj.updateRapidRestoreProgress(cloudId, device.getDeviceUUID(), restoreEvents.getActionBy(), "", 0L, "FAILED");
                    return;
                }
                while (iterator1.hasNext()) {
                    OfficeRestoreFileInfo item = (OfficeRestoreFileInfo)iterator1.next();
                    RestoreEvents restoreEventsObj = this.utilServiceObj.getRestoreEventByUUID(cloudId, restoreEvents.getActionOnDeviceUUID());
                    if (restoreEventsObj == null) {
                        logger.error("... cancel the restore....");
                        break;
                    }
                    logger.debug(backupBatch.getId().toString() + "...inside while loop after msg ... " + String.valueOf(item));
                    try {
                        List<BackUpImage> backupImagesFolderFile = new ArrayList<BackUpImage>();
                        if (restoreEvents.isDevice() || backupImage1.isFolder()) {
                            if (StringUtils.isNotEmpty((String)item.getFilePath())) {
                                skipval = new AtomicInteger(0);
                                logger.debug("....files2  ..." + item.getFilePath());
                                backupImagesFolderFile = this.utilServiceObj.getRestBackupFilesForGivenPathfromBackupImage(cloudId, cloudName, item.getFilePath() + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + item.getFileName(), destDeviceObj, String.valueOf(restoreEvents.getRestoreDataBefore()), restoreEvents.isRestoreDeletedFiles(), false, skipval);
                                logger.debug("....files2 completed ..." + item.getFilePath());
                            } else {
                                skipval = new AtomicInteger(0);
                                logger.debug("...." + device.getDeviceUUID() + "....files3  ..." + item.getFilePath() + "...." + item.getFileName());
                                backupImagesFolderFile = this.utilServiceObj.getRestBackupFilesForGivenPathfromBackupImage(cloudId, cloudName, item.getFileName(), destDeviceObj, String.valueOf(restoreEvents.getRestoreDataBefore()), restoreEvents.isRestoreDeletedFiles(), false, skipval);
                                logger.debug("....files3 completed  ..." + item.getFilePath() + "...." + item.getFileName());
                            }
                        } else {
                            BackUpImage restoreBackUpImage = new BackUpImage();
                            BeanUtils.copyProperties((Object)backupImage1, (Object)restoreBackUpImage);
                            backupImagesFolderFile.add(restoreBackUpImage);
                        }
                        logger.debug("backupImagesFolderFile list pvn:" + backupImagesFolderFile.size());
                        Iterator fileListIterator = backupImagesFolderFile.iterator();
                        while (fileListIterator.hasNext()) {
                            try {
                                Device device22;
                                BackUpImage bkpImage = (BackUpImage)fileListIterator.next();
                                if (bkpImage.isFolder() || "DELETED".equalsIgnoreCase(bkpImage.getStatus())) continue;
                                bkpImage.setSize(bkpImage.getSize() * 1024L);
                                BackupFile backupFile = this.utilServiceObj.getBackupFileForId(cloudval.getCloudId(), userName1, device, bkpImage.getId().toString());
                                logger.debug(backupFile.getFileName() + "...trying to download ... " + backupFile.getFilePath());
                                Object path = backupFile.getFilePath();
                                if (!StringUtils.isEmpty((String)restoreEvents.getDestinationPath())) {
                                    String customPath = restoreEvents.getDestinationPath();
                                    if (customPath.startsWith("/")) {
                                        customPath = customPath.substring(1);
                                    }
                                    customPath = FilenameUtils.separatorsToUnix((String)customPath);
                                    customPath = customPath.replaceAll("//", "/");
                                    logger.debug(restoreEvents.isDevice() + "....eventsss..." + restoreEvents.getFileInfo().isFolder());
                                    logger.debug("...beforecustompath..." + customPath);
                                    customPath = customPath.replaceAll(" ", "%20");
                                    logger.debug("...aftercustompath..." + customPath);
                                    if (restoreEvents.isDevice()) {
                                        path = customPath + "/" + (String)path;
                                    } else if (restoreEvents.getFileInfo() != null && !restoreEvents.getFileInfo().isFolder()) {
                                        path = customPath;
                                    } else if (restoreEvents.getFileInfo() != null && restoreEvents.getFileInfo().isFolder()) {
                                        logger.debug("..folderest.....");
                                        if (backupImage1 != null) {
                                            logger.debug((String)path + "..folderest1....." + backupImage1.getFileName());
                                            String finalPath = ((String)path).substring(((String)path).indexOf(backupImage1.getFileName()));
                                            logger.debug(".....final path ....." + finalPath.trim());
                                            path = customPath + "/" + finalPath;
                                        }
                                    }
                                }
                                String drivUserName = user1;
                                if (!restoreEvents.getActionOnDeviceUUID().equalsIgnoreCase(restoreEvents.getDestinationDeviceUUID()) && (device22 = this.utilServiceObj.getDeviceForUUID(cloudId, restoreEvents.getDestinationDeviceUUID())) != null) {
                                    drivUserName = device22.getUserName();
                                }
                                if (StringUtils.isNotEmpty((String)destinationUserIdForOneDriveRestore)) {
                                    drivUserName = destinationUserIdForOneDriveRestore;
                                }
                                logger.debug(" destination user name:" + drivUserName + restoreEvents.isInPlaceRestore() + "..... beforepath...." + (String)path);
                                if (restoreEvents.isInPlaceRestore()) {
                                    path = ((String)path).replaceFirst("Files", "");
                                }
                                this.createLinkUrlInOnedrive(deviceUUID, user1, bkpImage, (String)path, destUser.getEmailId(), driveId);
                                logger.debug(".......devpath1..." + (String)currentRestorePathForLink + "...." + backupFile.getFilePath());
                                currentRestorePathForLink = backupFile.getFilePath() + "/" + backupFile.getFileName();
                                if (++totalNoOfRapidRestoredFiles % 10L != 0L && Integer.valueOf(backupBatch.getTotalNoOfFiles()) >= 10) continue;
                                this.utilServiceObj.updateRapidRestoreProgress(cloudId, device.getDeviceUUID(), restoreEvents.getActionBy(), (String)currentRestorePathForLink, totalNoOfRapidRestoredFiles, STARTED);
                            }
                            catch (Exception e) {
                                logger.error("exception downloading...", (Throwable)e);
                            }
                        }
                        this.utilServiceObj.updateRapidRestoreProgress(cloudId, device.getDeviceUUID(), restoreEvents.getActionBy(), (String)currentRestorePathForLink, totalNoOfRapidRestoredFiles, STARTED);
                    }
                    catch (Exception e) {
                        logger.error("Failed to handle the message!", (Throwable)e);
                        this.fileUnderProcess.remove(item.getBackupId().toString());
                    }
                }
                this.utilServiceObj.updateRapidRestoreProgress(cloudId, device.getDeviceUUID(), restoreEvents.getActionBy(), "-", totalNoOfRapidRestoredFiles, COMPLETED);
                logger.debug(".. batch id completed for link creation...." + String.valueOf(backupBatch.getId()));
            };
            new Thread(runnable).start();
        }
        String driveUserName = "";
        if (!restoreEvents.getActionOnDeviceUUID().equalsIgnoreCase(restoreEvents.getDestinationDeviceUUID()) && (device2 = this.utilServiceObj.getDeviceForUUID(cloudId, restoreEvents.getDestinationDeviceUUID())) != null) {
            driveUserName = device2.getUserName();
        }
        logger.debug(restoreEvents.getActionOnDeviceUUID() + ".....getActionOnDeviceUUID...." + restoreEvents.getDestinationDeviceUUID());
        logger.debug(".....dirveusername...." + driveUserName);
        if (StringUtils.isNotEmpty((String)destinationUserIdForOneDriveRestore)) {
            driveUserName = destinationUserIdForOneDriveRestore;
        }
        if (StringUtils.isEmpty((String)driveUserName) && (device2 = this.utilServiceObj.getDeviceForUUID(cloudId, restoreEvents.getDestinationDeviceUUID())) != null) {
            driveUserName = device2.getUserName();
        }
        com.parablu.pcbd.domain.User destUser = this.utilServiceObj.getUserInfoByName(cloudId, driveUserName);
        logger.debug(".....user device check...." + driveUserName);
        if (destUser != null && isSPDevice) {
            destUser = this.utilServiceObj.getUserInfoByName(cloudId, driveUserName);
            deviceName = OfficeRestoreService.decodeBase64UTFString(restoreEvents.getDestinationDeviceUUID());
            logger.debug("...device name check...." + deviceName);
            if (!StringUtils.isEmpty((String)deviceName)) {
                user = this.utilServiceObj.getUserSite(cloudId, deviceName);
            }
        }
        if (destUser == null && isSPDevice) {
            destUser = this.utilServiceObj.getUserInfoByName(cloudId, driveUserName);
            deviceName = OfficeRestoreService.decodeBase64UTFString(restoreEvents.getDestinationDeviceUUID());
            logger.debug("...device name check...." + deviceName);
            if (!StringUtils.isEmpty((String)deviceName)) {
                destUser = user = this.utilServiceObj.getUserSite(cloudId, deviceName);
            }
        }
        if (user == null && isSPDevice) {
            Device device22 = this.utilServiceObj.getDeviceForUUID(cloudId, restoreEvents.getDestinationDeviceUUID());
            logger.debug("...device name check...." + String.valueOf(device22));
            if (device22 != null) {
                destUser = user = this.utilServiceObj.getUserInfoByName(cloudId, device22.getUserName());
            }
        }
        String driveId = "";
        String pbDriveIdforSource = "";
        AtomicInteger submittedTasks = new AtomicInteger(0);
        AtomicInteger completedTasks = new AtomicInteger(0);
        StringBuilder restoringFileName = new StringBuilder();
        if (!isSPDevice && (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)cloudval.getCloudCredentials()) || c2cRestore)) {
            driveId = c2cRestore ? OneDriveUtil.getDriveForC2CUser(cloudId, destUser.getEmailId()) : OneDriveUtil.getDriveForUser(cloudId, destUser.getEmailId());
            String emailId = user.getEmailId();
            if (!StringUtils.isEmpty((String)user.getOdbLoginId())) {
                emailId = user.getOdbLoginId();
            }
            if (!StringUtils.isEmpty((String)user.getDestOdbLoginId())) {
                emailId = user.getDestOdbLoginId();
            }
            pbDriveIdforSource = OneDriveUtil.getPBFolderItemIdWithErrorCodeRestore(emailId);
            if (driveId.equalsIgnoreCase("404")) {
                isBatchStopped = true;
                errorCode = 404;
            }
        }
        this.checkC2CUploadStatus(pool, backupTimerTask, backupTimer, restoredFiles, restoredSize, completedTasks, restoringFileName);
        while (iterator.hasNext() && !isBatchStopped) {
            OfficeRestoreFileInfo item = iterator.next();
            RestoreEvents restoreEventsObj = this.utilServiceObj.getRestoreEventByUUID(cloudId, restoreEvents.getActionOnDeviceUUID());
            if (restoreEventsObj == null) {
                logger.error("... cancel the restore...." + restoreEvents.getActionOnDeviceUUID());
                errorCode = 1207;
                isBatchStopped = true;
                continue;
            }
            pbBkpBatch = this.utilServiceObj.getBackupBatchById(cloudval.getCloudId(), backupBatch.getId().toString());
            if (pbBkpBatch != null && StringUtils.isNotEmpty((String)pbBkpBatch.getErrorCode()) && (pbBkpBatch.getErrorCode().equals(STOPPED_BACKUP_ERROR_CODE) || pbBkpBatch.getErrorCode().equals(PAUSED_BACKUP_ERROR_CODE))) {
                errorCode = pbBkpBatch.getErrorCode().equals(STOPPED_BACKUP_ERROR_CODE) ? Integer.parseInt(STOPPED_BACKUP_ERROR_CODE) : Integer.parseInt(PAUSED_BACKUP_ERROR_CODE);
                if (errorCode > 0) break;
                logger.debug(".....batch status current..." + pbBkpBatch.getErrorCode());
            }
            logger.debug(backupBatch.getId().toString() + "...inside while loop after msg ... " + String.valueOf(item));
            try {
                List<Object> backupImagesFolderFile = new ArrayList<BackUpImage>();
                AtomicInteger skipNum = new AtomicInteger();
                boolean downloadCompleted = false;
                int skipValue = (int)restoreProgressEvents.getRestoredFilesForFolder();
                while (!downloadCompleted) {
                    if (isDevice || isFolder) {
                        skipNum.set(skipValue);
                        if (StringUtils.isNotEmpty((String)item.getFilePath())) {
                            logger.debug(skipValue + "....files2  ..." + item.getFilePath());
                            backupImagesFolderFile = this.utilServiceObj.getRestBackupFilesForGivenPathfromBackupImage(cloudId, cloudName, item.getFilePath() + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + item.getFileName(), device, String.valueOf(restoreEvents.getRestoreDataBefore()), restoreEvents.isRestoreDeletedFiles(), isOutlookDevice, skipNum);
                            logger.debug("....files2 completed ..." + item.getFilePath());
                        } else {
                            logger.debug(userName + "...." + device.getDeviceUUID() + "....files3  ..." + item.getFilePath() + "...." + item.getFileName());
                            backupImagesFolderFile = this.utilServiceObj.getRestBackupFilesForGivenPathfromBackupImage(cloudId, cloudName, item.getFileName(), device, String.valueOf(restoreEvents.getRestoreDataBefore()), restoreEvents.isRestoreDeletedFiles(), isOutlookDevice, skipNum);
                            logger.debug("....files3 completed  ..." + item.getFilePath() + "...." + item.getFileName());
                        }
                        skipValue = skipNum.get();
                        logger.debug("skipValue:" + skipValue + "..filePath:" + item.getFilePath() + "/" + item.getFileName() + "....foldersandsize...." + backupImagesFolderFile.size());
                    } else {
                        BackUpImage restoreBackUpImage = new BackUpImage();
                        BeanUtils.copyProperties((Object)backupImage, (Object)restoreBackUpImage);
                        backupImagesFolderFile.add(restoreBackUpImage);
                        downloadCompleted = true;
                    }
                    if (backupImagesFolderFile.size() == 0) {
                        downloadCompleted = true;
                        skipValue = 0;
                        restoreProgressEvents.setRestoredFilesForFolder(0L);
                        continue;
                    }
                    Iterator fileListIterator = backupImagesFolderFile.iterator();
                    if (restoreEventsObj == null) {
                        logger.error("... cancel the restore....");
                        errorCode = 1207;
                        isBatchStopped = true;
                        downloadCompleted = true;
                        continue;
                    }
                    while (fileListIterator.hasNext()) {
                        try {
                            restoreEventsObj = this.utilServiceObj.getRestoreEventByUUID(cloudId, restoreEvents.getActionOnDeviceUUID());
                            if (restoreEventsObj == null) {
                                logger.error("... cancel the restore....");
                                errorCode = 1207;
                                isBatchStopped = true;
                                downloadCompleted = true;
                                break;
                            }
                            boolean isFileRestored = false;
                            BackUpImage bkpImage = (BackUpImage)fileListIterator.next();
                            boolean isTomcatRunning = true;
                            if (MemoryStore.get((String)IS_TOMCAT_RUNNING) != null) {
                                isTomcatRunning = (Boolean)MemoryStore.get((String)IS_TOMCAT_RUNNING);
                            }
                            if (!isTomcatRunning) {
                                logger.error("....tomcat is stopping so do not restore files.......");
                                Thread.sleep(TimeUnit.MINUTES.toMillis(3L));
                                return;
                            }
                            logger.debug("...restore fileval...." + bkpImage.getStatus() + "....." + restoreEvents.isRestoreDeletedFiles());
                            if ("DELETED".equalsIgnoreCase(bkpImage.getStatus())) {
                                logger.debug("...skipping deleted mails...." + bkpImage.getDevicePath() + ".." + bkpImage.getFileName());
                            }
                            if (bkpImage.isFolder() || !restoreEvents.isRestoreDeletedFiles() && "DELETED".equalsIgnoreCase(bkpImage.getStatus())) continue;
                            BackupFile backupFile = this.utilServiceObj.getBackupFileForId(cloudval.getCloudId(), userName, bkpImage.getId().toString());
                            backupFile.setOdItemId(bkpImage.getOdItemId());
                            if (!backupFile.getId().equalsIgnoreCase(bkpImage.getId().toString())) {
                                bkpImage = this.utilServiceObj.getBackupImageFile(cloudId, backupFile.getId(), destDeviceObj);
                            }
                            logger.debug(item.getBackupId() + "....oditemid..." + bkpImage.getOdItemId() + "..." + destDevice.getDestCollection());
                            logger.debug(item.getFileName() + "...trying to download ... " + backupFile.getEwsId());
                            logger.debug("....folderrestore...." + folderRestore);
                            if (isOutlookDevice) {
                                String userMail;
                                path = backupFile.getFilePath();
                                if (!StringUtils.isEmpty((String)restoreEvents.getDestinationPath())) {
                                    customPath = restoreEvents.getDestinationPath();
                                    if (customPath.startsWith("/")) {
                                        customPath = customPath.substring(1);
                                    }
                                    customPath = FilenameUtils.separatorsToUnix((String)customPath);
                                    customPath = customPath.replaceAll("//", "/");
                                    logger.debug(restoreEvents.isDevice() + "....eventsss..." + restoreEvents.getFileInfo().isFolder());
                                    if (restoreEvents.isDevice()) {
                                        path = customPath + "/" + (String)path;
                                    } else if (restoreEvents.getFileInfo() != null && !restoreEvents.getFileInfo().isFolder()) {
                                        path = customPath;
                                    } else if (restoreEvents.getFileInfo() != null && restoreEvents.getFileInfo().isFolder()) {
                                        logger.debug("..folderest.....");
                                        if (backupImage != null) {
                                            logger.debug("..folderest1....." + backupImage.getFileName());
                                            finalPath = ((String)path).substring(((String)path).indexOf(backupImage.getFileName()));
                                            logger.debug(customPath + ".....final path ....." + finalPath.trim());
                                            path = customPath + "/" + finalPath;
                                        }
                                    }
                                }
                                userName = backupFile.getUserName();
                                com.parablu.pcbd.domain.User userObj = this.utilServiceObj.getUserInfoByName(1, userName);
                                String mailUserName = userMail = userObj.getEmailId();
                                if (!restoreEvents.getActionOnDeviceUUID().equalsIgnoreCase(restoreEvents.getDestinationDeviceUUID())) {
                                    Device device23 = this.utilServiceObj.getDeviceForUUID(cloudId, restoreEvents.getDestinationDeviceUUID());
                                    logger.debug("...diff user mail..." + restoreEvents.getDestinationDeviceUUID());
                                    if (device23 != null) {
                                        userObj = this.utilServiceObj.getUserInfoByName(1, device23.getUserName());
                                        mailUserName = userMail = userObj.getEmailId();
                                    }
                                }
                                logger.debug("....find user mail...." + mailUserName);
                                String userId = this.getUserId(mailUserName);
                                logger.debug(backupFile.getOdItemId() + ".....DOWNLOADCHUNKS1...." + (String)path + "..." + isFoldersCreated);
                                String idForFolder = "";
                                boolean caltaskCont = false;
                                if (((String)path).contains("To Do")) {
                                    caltaskCont = true;
                                } else if (((String)path).contains("Contacts")) {
                                    caltaskCont = true;
                                } else if (((String)path).contains("Calendar")) {
                                    caltaskCont = true;
                                }
                                logger.debug(caltaskCont + "....folderrestore...." + folderRestore);
                                if (!isFoldersCreated && !caltaskCont) {
                                    Object exiFolder = "";
                                    if (!StringUtils.isEmpty((String)restoreEvents.getDestinationPath())) {
                                        logger.debug("..foldercreation1....." + restoreEvents.getDestinationPath());
                                        String customPath = restoreEvents.getDestinationPath();
                                        customPath = FilenameUtils.separatorsToUnix((String)customPath);
                                        customPath = customPath.replaceAll("//", "/");
                                        if (customPath.startsWith("/")) {
                                            customPath = customPath.substring(1);
                                        }
                                        customPath = FilenameUtils.separatorsToUnix((String)customPath);
                                        customPath = customPath.replaceAll("//", "/");
                                        customPath = StringEscapeUtils.unescapeHtml3((String)customPath);
                                        if (restoreEvents.isDevice()) {
                                            exiFolder = customPath + "/" + (String)exiFolder;
                                            logger.debug("..foldercreation1..device restore...");
                                        } else if (restoreEvents.getFileInfo() != null && !restoreEvents.getFileInfo().isFolder()) {
                                            exiFolder = customPath;
                                            logger.debug("..foldercreation1..not folder...");
                                        } else if (restoreEvents.getFileInfo() != null && restoreEvents.getFileInfo().isFolder()) {
                                            logger.debug("..foldercreation1..folder...");
                                            logger.debug("..folderest22.....");
                                            if (backupImage != null) {
                                                path = backupFile.getFilePath();
                                                logger.debug("..folderest33....." + backupImage.getFileName());
                                                String finalPath = ((String)path).substring(((String)path).indexOf(backupImage.getFileName()));
                                                logger.debug(".....final path ....." + finalPath.trim());
                                                exiFolder = customPath + "/" + finalPath;
                                                path = customPath + "/" + finalPath;
                                            }
                                        }
                                    }
                                    if (StringUtils.isEmpty((String)exiFolder) && restoreEvents.isInPlaceRestore()) {
                                        exiFolder = bkpImage.getDevicePath();
                                    }
                                    if (StringUtils.isEmpty((String)exiFolder) && backupImage.isFolder()) {
                                        exiFolder = bkpImage.getFileName();
                                    }
                                    logger.debug("....exifolder-values1.." + (String)exiFolder);
                                    if (((String)exiFolder).contains("Calendar/")) {
                                        exiFolder = "Calendar";
                                    }
                                    do {
                                        try {
                                            EWSAppSetting appSetting = this.utilServiceObj.getEwsAppSettingDetail(cloudId);
                                            this.getEWSAccesToken(appSetting, false);
                                            String token = this.ewsToken;
                                            logger.debug(mailUserName + "...got-ewstoken...." + token);
                                            service = OfficeRestoreService.getAuthenticatedService(token, mailUserName);
                                            idForFolder = OfficeRestoreService.getKeyFromValue(existingFolders, (String)exiFolder);
                                            if (StringUtils.isEmpty((String)idForFolder)) {
                                                logger.debug("....create folder....." + (String)exiFolder);
                                                this.createFoldersInMail(service, existingFolders, (String)exiFolder, mailUserName, officeBackupPolicy.isInPlaceMailArchiveEnabled());
                                                existingFolders = new HashMap();
                                                existingFolders = this.getExistingFolders(service, mailUserName, officeBackupPolicy.isInPlaceMailArchiveEnabled());
                                                idForFolder = OfficeRestoreService.getKeyFromValue(existingFolders, (String)exiFolder);
                                            }
                                        }
                                        catch (Exception e) {
                                            logger.error("....unable to create folder so retry....");
                                            this.createFoldersInMail(service, existingFolders, (String)exiFolder, mailUserName, officeBackupPolicy.isInPlaceMailArchiveEnabled());
                                            existingFolders = new HashMap();
                                            existingFolders = this.getExistingFolders(service, mailUserName, officeBackupPolicy.isInPlaceMailArchiveEnabled());
                                            idForFolder = OfficeRestoreService.getKeyFromValue(existingFolders, (String)exiFolder);
                                        }
                                        logger.debug("... exist id exists .. " + idForFolder);
                                        isFoldersCreated = true;
                                        if (existingFolders.size() != 0) continue;
                                        logger.debug("....no folders for user check user license..." + userName);
                                        break;
                                    } while (StringUtils.isEmpty((String)idForFolder));
                                }
                                if (((String)path).contains("To Do") || ((String)path).contains("Contacts") || ((String)path).contains("Calendar")) {
                                    if (((String)path).contains("Contacts")) {
                                        logger.debug("... trying to restore contacts ....");
                                        isFileRestored = this.syncDownloadService.inPlaceRestoreForContactFromCloud(cloudval, userName, mailUserName, backupFile, device.getDestCollection(), bkpImage.getOdItemId());
                                    } else if (((String)path).contains("Calendar")) {
                                        logger.debug("... trying to restore Calendar ....");
                                        boolean differentDest = false;
                                        if (!destDevice.getDeviceName().equalsIgnoreCase(device.getDeviceName())) {
                                            differentDest = true;
                                        }
                                        isFileRestored = this.syncDownloadService.inPlaceRestoreForCalendarFromCloud(cloudval, userName, mailUserName, backupFile, device.getDestCollection(), bkpImage.getOdItemId(), differentDest);
                                    } else {
                                        logger.debug(backupFile.getTaskListId() + ".. trying to restore tasks..... " + bkpImage.getTaskListId());
                                        boolean differentDest = false;
                                        if (!destDevice.getDeviceName().equalsIgnoreCase(device.getDeviceName())) {
                                            differentDest = true;
                                        }
                                        backupFile.setTaskListId(bkpImage.getTaskListId());
                                        isFileRestored = this.syncDownloadService.inPlaceRestoreForTasksFromCloud(cloudval, userName, mailUserName, backupFile, device.getDestCollection(), bkpImage.getOdItemId(), differentDest, bkpImage.getAttachments(), (String)path);
                                    }
                                } else {
                                    logger.debug("...insideoutlook...." + officeBackupPolicy.isInPlaceMailArchiveEnabled());
                                    idForFolder = OfficeRestoreService.getKeyFromValue(existingFolders, (String)path);
                                    if (StringUtils.isEmpty((String)idForFolder)) {
                                        logger.debug("..idforfolder is empty so create..." + (String)path);
                                        try {
                                            existingFolders = this.getExistingFolders(service, mailUserName, officeBackupPolicy.isInPlaceMailArchiveEnabled());
                                            idForFolder = OfficeRestoreService.getKeyFromValue(existingFolders, (String)path);
                                            if (StringUtils.isEmpty((String)idForFolder)) {
                                                this.createFoldersInMail(service, existingFolders, (String)path, mailUserName, officeBackupPolicy.isInPlaceMailArchiveEnabled());
                                                existingFolders = new HashMap();
                                                existingFolders = this.getExistingFolders(service, mailUserName, officeBackupPolicy.isInPlaceMailArchiveEnabled());
                                                idForFolder = OfficeRestoreService.getKeyFromValue(existingFolders, (String)path);
                                            }
                                        }
                                        catch (Exception e) {
                                            this.createFoldersInMail(service, existingFolders, (String)path, mailUserName, officeBackupPolicy.isInPlaceMailArchiveEnabled());
                                            existingFolders = new HashMap();
                                            existingFolders = this.getExistingFolders(service, mailUserName, officeBackupPolicy.isInPlaceMailArchiveEnabled());
                                            idForFolder = OfficeRestoreService.getKeyFromValue(existingFolders, (String)path);
                                        }
                                    }
                                    if (StringUtils.isEmpty((String)idForFolder)) {
                                        isFileRestored = false;
                                    } else {
                                        logger.debug(idForFolder + "..." + (String)path + "..DOWNLOADCHUNKS for user...." + userName + "..." + mailUserName + "....." + restoreEvents.isRestoreLinks());
                                        isFileRestored = this.syncDownloadService.inPlaceRestoreForExchangeFromCloud(cloudval, userName, mailUserName, backupFile, idForFolder, device.getDestCollection(), createMailLinkEnabled, userId, restoreEvents.isRestoreLinks(), officeBackupPolicy, bkpImage.getOdItemId(), false, restoreEvents.isInPlaceRestore(), (String)path, restoreEvents);
                                    }
                                }
                            } else if (isSPDevice) {
                                Device device24;
                                ListCollectionRequestBuilder nextListPage;
                                List currentListPageVal;
                                downloadCompleted = true;
                                path = backupFile.getFilePath();
                                ArrayList<String> listIds = new ArrayList<String>();
                                HashMap<String, String> listMap = new HashMap<String, String>();
                                String listId = "";
                                try {
                                    String siteId = user.getSiteId();
                                    ListCollectionPage listCollectionPage = (ListCollectionPage)((ListCollectionRequest)Graph.getInstance().getGraphClient().sites(siteId).lists().buildRequest(new Option[0])).get();
                                    List currentListPageVal2 = null;
                                    ListCollectionRequestBuilder nextListPage2 = (ListCollectionRequestBuilder)listCollectionPage.getNextPage();
                                    do {
                                        currentListPageVal2 = listCollectionPage.getCurrentPage();
                                        for (com.microsoft.graph.models.List list : listCollectionPage.getCurrentPage()) {
                                            logger.debug(">>>>SITE>>>>" + list.name);
                                            if (!"documentLibrary".equals(list.list.template)) continue;
                                            listIds.add(list.id);
                                            listMap.put(list.id, list.name);
                                            logger.debug((String)path + "%%%%" + list.name + "....list.." + list.displayName + ".." + list.id);
                                            if (!((String)path).startsWith("/" + list.name) && !((String)path).startsWith(list.name)) continue;
                                            listId = list.id;
                                        }
                                        nextListPage2 = (ListCollectionRequestBuilder)listCollectionPage.getNextPage();
                                        if (nextListPage2 == null) continue;
                                        listCollectionPage = (ListCollectionPage)((ListCollectionRequest)nextListPage2.buildRequest(new Option[0])).get();
                                    } while (StringUtils.isEmpty((String)siteId) && currentListPageVal2.size() > 0 && nextListPage2 != null && listCollectionPage != null && nextListPage2 != null);
                                }
                                catch (Exception e) {
                                    logger.debug("..error..." + e.getMessage());
                                }
                                if (!singleFileRestore) {
                                    path = ((String)path).replaceFirst("Shared Documents", "");
                                    path = ((String)path).replaceFirst("/Shared Documents", "");
                                }
                                logger.debug(restoreEvents.getDestinationPath() + "#@$#$@#$@#$@#$@" + (String)path);
                                if (!StringUtils.isEmpty((String)restoreEvents.getDestinationPath())) {
                                    String customPath = restoreEvents.getDestinationPath();
                                    listIds = new ArrayList();
                                    listMap = new HashMap();
                                    listId = "";
                                    String listNameForFileRestore = "";
                                    try {
                                        String siteId = user.getSiteId();
                                        ListCollectionPage listCollectionPage = (ListCollectionPage)((ListCollectionRequest)Graph.getInstance().getGraphClient().sites(siteId).lists().buildRequest(new Option[0])).get();
                                        currentListPageVal = null;
                                        nextListPage = (ListCollectionRequestBuilder)listCollectionPage.getNextPage();
                                        do {
                                            currentListPageVal = listCollectionPage.getCurrentPage();
                                            for (com.microsoft.graph.models.List list : listCollectionPage.getCurrentPage()) {
                                                if (!"documentLibrary".equals(list.list.template)) continue;
                                                listIds.add(list.id);
                                                listMap.put(list.id, list.name);
                                                logger.debug(customPath + "%%%%" + list.name + "....list.." + list.displayName + ".." + list.id);
                                                if (!customPath.startsWith("/" + list.name) && !customPath.startsWith(list.name)) continue;
                                                listId = list.id;
                                                logger.debug(".....listrestore...." + customPath);
                                                if (!singleFileRestore) {
                                                    customPath = customPath.replaceFirst("/" + list.name, "");
                                                } else {
                                                    listNameForFileRestore = list.name;
                                                }
                                                logger.debug(".....listrestore12...." + customPath);
                                                break;
                                            }
                                            if ((nextListPage = (ListCollectionRequestBuilder)listCollectionPage.getNextPage()) == null) continue;
                                            listCollectionPage = (ListCollectionPage)((ListCollectionRequest)nextListPage.buildRequest(new Option[0])).get();
                                        } while (StringUtils.isEmpty((String)siteId) && currentListPageVal.size() > 0 && nextListPage != null && listCollectionPage != null && nextListPage != null);
                                    }
                                    catch (Exception e) {
                                        logger.debug("..error..." + e.getMessage());
                                    }
                                    logger.debug("...beforecustompath..." + customPath);
                                    if (customPath.startsWith("/")) {
                                        customPath = customPath.substring(1);
                                    }
                                    logger.debug("...beforecustompath1..." + customPath);
                                    customPath = StringEscapeUtils.unescapeHtml3((String)customPath);
                                    customPath = FilenameUtils.separatorsToUnix((String)customPath);
                                    customPath = customPath.replaceAll("//", "/");
                                    logger.debug(restoreEvents.isDevice() + "....eventsss..." + restoreEvents.getFileInfo().isFolder());
                                    logger.debug("...beforecustompath2..." + customPath);
                                    if (!singleFileRestore) {
                                        customPath = customPath.replaceFirst("Shared Documents", "");
                                        customPath = customPath.replaceFirst("/Shared Documents", "");
                                    } else {
                                        logger.debug(listNameForFileRestore + "...beforecustompath2a..." + customPath);
                                        if (!StringUtils.isEmpty((String)customPath)) {
                                            customPath = customPath.startsWith("/") ? customPath.replaceFirst("/" + listNameForFileRestore, "") : customPath.replaceFirst(listNameForFileRestore, "");
                                            logger.debug(listNameForFileRestore + "...beforecustompath2ab..." + customPath);
                                        }
                                    }
                                    logger.debug("...beforecustompath3..." + customPath);
                                    customPath = customPath.replaceAll(" ", "%20");
                                    logger.debug("...aftercustompath..." + customPath);
                                    if (restoreEvents.isDevice()) {
                                        path = customPath + "/";
                                        logger.debug("....device-level-restore....." + (String)path);
                                    } else if (restoreEvents.getFileInfo() != null && !restoreEvents.getFileInfo().isFolder()) {
                                        path = customPath;
                                    } else if (restoreEvents.getFileInfo() != null && restoreEvents.getFileInfo().isFolder()) {
                                        logger.debug("..folderest.....");
                                        if (backupImage != null) {
                                            logger.debug("..folderest1....." + backupImage.getFileName());
                                            Object finalPath = path;
                                            try {
                                                finalPath = ((String)path).substring(((String)path).indexOf(backupImage.getFileName()));
                                            }
                                            catch (StringIndexOutOfBoundsException listCollectionPage) {
                                                // empty catch block
                                            }
                                            logger.debug(".....final path ....." + ((String)finalPath).trim());
                                            path = customPath + "/";
                                        }
                                    }
                                }
                                String drivUserName = userName;
                                String siteId = user.getSiteId();
                                String siteName = user.getUserName();
                                if (!restoreEvents.getActionOnDeviceUUID().equalsIgnoreCase(restoreEvents.getDestinationDeviceUUID()) && (device24 = this.utilServiceObj.getDeviceForUUID(cloudId, restoreEvents.getDestinationDeviceUUID())) != null) {
                                    drivUserName = device24.getUserName();
                                    com.parablu.pcbd.domain.User userVal = this.utilServiceObj.getUserInfoByName(cloudId, drivUserName);
                                    logger.debug(drivUserName + "..... userval...." + userVal.getSiteId());
                                    siteId = userVal.getSiteId();
                                    siteName = user.getUserName();
                                }
                                logger.debug(restoreEvents.isInPlaceRestore() + "..... beforepath...." + (String)path);
                                if (restoreEvents.isInPlaceRestore()) {
                                    path = bkpImage.getDevicePath();
                                    listIds = new ArrayList();
                                    listMap = new HashMap();
                                    listId = "";
                                    try {
                                        siteId = user.getSiteId();
                                        ListCollectionPage listCollectionPage = (ListCollectionPage)((ListCollectionRequest)Graph.getInstance().getGraphClient().sites(siteId).lists().buildRequest(new Option[0])).get();
                                        currentListPageVal = null;
                                        nextListPage = (ListCollectionRequestBuilder)listCollectionPage.getNextPage();
                                        do {
                                            currentListPageVal = listCollectionPage.getCurrentPage();
                                            for (com.microsoft.graph.models.List list : listCollectionPage.getCurrentPage()) {
                                                if (!"documentLibrary".equals(list.list.template)) continue;
                                                listIds.add(list.id);
                                                listMap.put(list.id, list.name);
                                                logger.debug((String)path + "%%%%" + list.name + "....list.." + list.displayName + ".." + list.id);
                                                if (!((String)path).startsWith(list.name)) continue;
                                                listId = list.id;
                                                path = ((String)path).replaceFirst(list.name, "");
                                            }
                                            nextListPage = (ListCollectionRequestBuilder)listCollectionPage.getNextPage();
                                            if (nextListPage == null) continue;
                                            listCollectionPage = (ListCollectionPage)((ListCollectionRequest)nextListPage.buildRequest(new Option[0])).get();
                                        } while (StringUtils.isEmpty((String)siteId) && currentListPageVal.size() > 0 && nextListPage != null && listCollectionPage != null && nextListPage != null);
                                    }
                                    catch (Exception e) {
                                        logger.debug("..error..." + e.getMessage());
                                    }
                                    path = ((String)path).replaceFirst("Files", "");
                                    path = ((String)path).replaceFirst(siteName, "");
                                    path = ((String)path).replaceFirst("/Documents", "");
                                    path = ((String)path).replaceFirst("Shared Documents", "");
                                }
                                logger.debug(listId + "..... afterpath...." + (String)path);
                                if (bkpImage != null && StringUtils.isEmpty((String)bkpImage.getStoragePlace())) {
                                    FileInfo fileInfo = this.downloadService.getFileFromPG(cloudId, userName, backupFile.getId().toString());
                                    logger.debug(user.getUserName() + ".....inPlaceRestoreForSPFromPg  file is in pg....." + (String)path);
                                    isFileRestored = this.syncDownloadService.inPlaceRestoreForSPFromPg(cloudval, backupFile, fileInfo, (String)path, drivUserName, siteId, listId, restoreEvents.isInPlaceRestore(), singleFileRestore, folderRestore, (String)restoreFolder);
                                } else {
                                    logger.debug("..... file is in cloud....." + (String)path);
                                    isFileRestored = this.syncDownloadService.inPlaceRestoreForOndriveFromCloud(cloudval, backupFile, (String)path, drivUserName, siteId, false, "SP", pool, listId, restoreEvents.isInPlaceRestore(), pbDriveIdforSource, singleFileRestore, folderRestore, (String)restoreFolder, submittedTasks, restoreEvents);
                                }
                            } else {
                                Device device25;
                                downloadCompleted = true;
                                path = backupFile.getFilePath();
                                if (!StringUtils.isEmpty((String)restoreEvents.getDestinationPath())) {
                                    customPath = restoreEvents.getDestinationPath();
                                    logger.debug("***getDestinationPath****" + customPath);
                                    if (customPath.startsWith("/")) {
                                        customPath = customPath.substring(1);
                                    }
                                    logger.debug("***getDestinationPath1****" + customPath);
                                    customPath = FilenameUtils.separatorsToUnix((String)customPath);
                                    customPath = customPath.replaceAll("//", "/");
                                    logger.debug("***getDestinationPath2****" + customPath);
                                    logger.debug(restoreEvents.isDevice() + "....eventsss..." + restoreEvents.getFileInfo().isFolder());
                                    customPath = StringEscapeUtils.unescapeHtml3((String)customPath);
                                    logger.debug("***getDestinationPath3****" + customPath);
                                    logger.debug("...beforecustompath..." + customPath);
                                    customPath = StringEscapeUtils.unescapeHtml3((String)customPath);
                                    logger.debug("...aftercustompath..." + customPath);
                                    if (restoreEvents.isDevice()) {
                                        path = customPath + "/" + (String)path;
                                    } else if (restoreEvents.getFileInfo() != null && !restoreEvents.getFileInfo().isFolder()) {
                                        path = customPath;
                                    } else if (restoreEvents.getFileInfo() != null && restoreEvents.getFileInfo().isFolder()) {
                                        logger.debug("..folderest.....");
                                        if (backupImage != null) {
                                            logger.debug("..folderest1....." + backupImage.getFileName());
                                            finalPath = ((String)path).substring(((String)path).indexOf(backupImage.getFileName()));
                                            logger.debug(".....final path ....." + finalPath.trim());
                                            finalPath = finalPath.trim();
                                            path = customPath + "/" + finalPath;
                                        }
                                    }
                                }
                                String drivUserName = userName;
                                if (!restoreEvents.getActionOnDeviceUUID().equalsIgnoreCase(restoreEvents.getDestinationDeviceUUID()) && (device25 = this.utilServiceObj.getDeviceForUUID(cloudId, restoreEvents.getDestinationDeviceUUID())) != null) {
                                    drivUserName = device25.getUserName();
                                }
                                logger.debug(restoreEvents.isInPlaceRestore() + "..... beforepath...." + (String)path);
                                if (restoreEvents.isInPlaceRestore()) {
                                    path = ((String)path).replaceFirst("Files", "");
                                }
                                logger.debug("..... afterpath...." + (String)path);
                                if (bkpImage != null && StringUtils.isEmpty((String)bkpImage.getStoragePlace())) {
                                    FileInfo fileInfo = this.downloadService.getFileFromPG(cloudId, userName, backupFile.getId().toString());
                                    logger.debug(driveId + "..... file is in pg....." + (String)path);
                                    isFileRestored = this.syncDownloadService.inPlaceRestoreForOndriveFromPg(cloudval, backupFile, fileInfo, (String)path, drivUserName, driveId, c2cRestore, officeBackupPolicy, restoreEvents.isRestoreLinks(), false, restoreEvents.isInPlaceRestore(), pool, submittedTasks, restoreEvents);
                                } else {
                                    logger.debug("..... file is in cloud....." + (String)path);
                                    isFileRestored = this.syncDownloadService.inPlaceRestoreForOndriveFromCloud(cloudval, backupFile, (String)path, drivUserName, driveId, c2cRestore, "OD", pool, "", restoreEvents.isInPlaceRestore(), pbDriveIdforSource, singleFileRestore, folderRestore, (String)restoreFolder, submittedTasks, restoreEvents);
                                }
                                if (c2cRestore) {
                                    this.deleteLinkFileIfExists((String)path, backupFile.getFileName(), driveId);
                                }
                            }
                            logger.debug(isFileRestored + ".......devpath1..." + currentRestorePath + "...." + backupFile.getFilePath());
                            if ((isOutlookDevice || isSPDevice) && isFileRestored) {
                                restoredFiles.incrementAndGet();
                                logger.debug(newRestoredSize.get() + "...before startrestorestatus1...." + restoredSize.get() + "....add.." + bkpImage.getSizeInBytes());
                                restoredSize.get();
                                restoredSize.addAndGet(bkpImage.getSizeInBytes());
                                newRestoredSize.addAndGet(bkpImage.getSizeInBytes());
                                logger.debug(newRestoredSize.get() + "...before startrestorestatus2...." + restoredSize.get());
                                if (backupFile.getBackupId() != null) {
                                    logger.debug("...before startrestorestatus3...." + backupFile.getBackupId().toString());
                                }
                            }
                            currentFolderRestoredFiles = skipValue;
                            currentRestorePath = backupFile.getFilePath();
                            logger.debug(newRestoredSize.get() + "...before startrestorestatus3...." + String.valueOf(restoredFiles) + "...." + restoredSize.get() + "...id..." + bkpImage.getId().toString() + "...." + bkpImage.getSizeInBytes());
                            if (restoredFiles.get() % 3 != 0 && totalNoOfFilesToRestore - restoredFiles.get() >= 3) continue;
                            this.utilServiceObj.updateRestoreProgress(cloudId, restoredFiles.get(), (int)restoredSize.get(), currentFolderRestoredFiles, currentRestorePath, deviceUUID, backupFile.getFileName(), restoreEvents.getActionBy());
                        }
                        catch (RestoreEventDeletedException ee) {
                            logger.error("....restoreevent deleted....." + ee.getMessage());
                        }
                        catch (Exception e) {
                            logger.error("exception downloading...", (Throwable)e);
                        }
                    }
                    currentFolderRestoredFiles = skipValue;
                    this.utilServiceObj.updateRestoreProgress(cloudId, restoredFiles.get(), (int)restoredSize.get(), currentFolderRestoredFiles, currentRestorePath, deviceUUID, "", restoreEvents.getActionBy());
                    this.utilServiceObj.updateBackupBatchForRestore(cloudId, String.valueOf(backupBatch.getId()), restoredFiles.get(), restoredSize.get());
                    ++skipValue;
                }
            }
            catch (Exception e) {
                logger.error("Failed to handle the message!", (Throwable)e);
                this.fileUnderProcess.remove(item.getBackupId().toString());
            }
            logger.debug(uploadedFiles + ".... before deleting batchid check..... " + String.valueOf(backupBatch.getId()));
            this.utilServiceObj.removeOfficeRestoreDriveItem(cloudId, item.getId());
            logger.debug(String.valueOf(item.getId()) + ".. batch id completed...." + String.valueOf(backupBatch.getId()));
            if (iterator.hasNext()) continue;
            while (submittedTasks.get() > completedTasks.get()) {
                logger.debug("c2c upload is still happening so wait...");
                try {
                    Thread.sleep(1000L);
                    if (restoredFiles.get() % 3 != 0 && totalNoOfFilesToRestore - restoredFiles.get() >= 3) continue;
                    this.utilServiceObj.updateRestoreProgress(cloudId, restoredFiles.get(), (int)restoredSize.get(), currentFolderRestoredFiles, currentRestorePath, deviceUUID, restoringFileName.toString(), restoreEvents.getActionBy());
                }
                catch (Exception e) {
                    logger.error("Exception getting the updated count and file:", (Throwable)e);
                    e.printStackTrace();
                }
            }
            backupTimer = null;
            backupTimerTask = null;
            this.utilServiceObj.removeRestoreProgress(cloudId, restoreEvents.getDestinationDeviceUUID());
            this.utilServiceObj.deleteRestoreEventForDeviceUUID(cloudId, restoreEvents.getDestinationDeviceUUID(), policyName);
            this.batchUnderProcess.remove(backupBatch.getId().toString());
            this.updateBatchAndOverview(cloudval.getCloudId(), backupBatch.getId(), COMPLETED, backupBatch.getDeviceUUID(), errorCode, restoredFiles.get(), restoredSize.get());
            DeviceBackupOverView overView = this.utilServiceObj.getDeviceBkpOverviewForDeviceUUID(cloudId, deviceUUID);
            long noOfSuccessfulRestores = overView.getNoOfSuccessfulRestores();
            overView.setNoOfSuccessfulRestores(noOfSuccessfulRestores + 1L);
            this.utilServiceObj.updateDeviceBackupOverView(cloudId, overView);
            logger.debug(backupBatch.getTotalNoOfFiles() + "..  completed...." + String.valueOf(backupBatch.getId()));
        }
        logger.debug("....error code..... " + errorCode);
        if (isBatchStopped) {
            for (OfficeRestoreFileInfo item : fileInfoList) {
                this.utilServiceObj.removeOfficeRestoreDriveItem(cloudId, item.getId());
            }
            this.utilServiceObj.deleteMailRestoreBatch(cloudId, backupBatch.getId(), policyName);
            this.updateBatchAndOverview(cloudval.getCloudId(), backupBatch.getId(), "ABORTED", backupBatch.getDeviceUUID(), errorCode, restoredFiles.get(), restoredSize.get());
            this.batchUnderProcess.remove(backupBatch.getId().toString());
        } else if (org.apache.commons.collections.CollectionUtils.isEmpty(fileInfoList)) {
            this.utilServiceObj.deleteMailRestoreBatch(cloudId, backupBatch.getId(), policyName);
            this.batchUnderProcess.remove(backupBatch.getId().toString());
            logger.debug(backupBatch.getDeviceUUID() + ".... update batch ... " + String.valueOf(backupBatch.getId()));
            this.updateBatchAndOverview(cloudval.getCloudId(), backupBatch.getId(), COMPLETED, backupBatch.getDeviceUUID(), errorCode, restoredFiles.get(), restoredSize.get());
            this.utilServiceObj.removeRestoreProgress(cloudId, restoreEvents.getDestinationDeviceUUID());
        } else {
            logger.debug(".. debug bug .. 2450 .." + org.apache.commons.collections.CollectionUtils.isEmpty(fileInfoList));
        }
        BackupBatch batch = this.utilServiceObj.getBackupBatchById(cloudval.getCloudId(), backupBatch.getId().toString());
        if (batch != null) {
            logger.debug("....restored size..... " + batch.getUploadedSize());
            logger.debug(".....#restoreFolder#..." + (String)restoreFolder);
            this.saveRestoreHistory(cloudId, (String)restoreFolder, batch, batch.getUploadedSize(), restorePath, restoredInDiffPath, device, destDevice, "", null, null, destinationUserIdForOneDriveRestore);
        }
        this.utilServiceObj.deleteRestoreEventForDeviceUUID(cloudId, restoreEvents.getDestinationDeviceUUID(), policyName);
        this.utilServiceObj.removeRestoreProgress(cloudId, restoreEvents.getActionOnDeviceUUID());
        logger.debug("....deletedevents..... " + restoreEvents.getDestinationDeviceUUID() + "..." + restoreEvents.getActionOnDeviceUUID());
    }

    public void checkC2CUploadStatus(final CompletionService<BackupFile> pool, TimerTask backupTimerTask, Timer backupTimer, final AtomicInteger restoredFiles, final AtomicLong restoredSize, final AtomicInteger completedTasks, final StringBuilder restoringFile) {
        if (backupTimer == null) {
            backupTimer = new Timer();
        }
        if (backupTimerTask == null) {
            backupTimerTask = new TimerTask(this){

                @Override
                public void run() {
                    try {
                        Future result = pool.take();
                        if (result.isDone()) {
                            BackupFile file = (BackupFile)result.get();
                            if (StringUtils.isNotEmpty((String)file.getFileName())) {
                                restoringFile.setLength(0);
                                restoringFile.append(file.getFileName());
                                restoredFiles.incrementAndGet();
                                restoredSize.set(restoredSize.get() + file.getSizeInBytes());
                            }
                            completedTasks.incrementAndGet();
                            logger.debug("c2c upload is done so wait for the next one >>>>>>>>>>>");
                        }
                    }
                    catch (Exception e) {
                        logger.error("Error in checkThreadStatusAndStartUpload", (Throwable)e);
                        logger.trace(String.valueOf(e));
                    }
                }
            };
            backupTimer.schedule(backupTimerTask, 1000L, 1000L);
        }
    }

    private void deleteLinkFileIfExists(String path, String fileName, String driveId) {
        try {
            path = path.replaceAll(":", "_Drive");
            path = path.replaceAll("#", "_HASH");
            path = path.replaceAll("%", "_PERCENTAGE");
            OneDriveUtil.getC2CGraphClient().customRequest("/drives/" + driveId + "/root:/" + path + "/" + fileName + ".url", DriveItem.class).buildRequest(new Option[0]).delete();
        }
        catch (GraphServiceException ee) {
            logger.debug("....item not found...", (Throwable)ee);
        }
    }

    protected String encodeBase64UTFString(String value) {
        String encodedString = value;
        try {
            encodedString = new String(Base64.encodeBase64((byte[])value.getBytes()), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            logger.trace(String.valueOf(e));
            logger.error(e.getMessage());
            logger.debug("UnsupportedEncodingException", (Throwable)e);
        }
        return encodedString;
    }

    private void createLinkUrlInOnedrive(String deviceUUID, String userName, BackUpImage bkpImage, String path, String drivUserName, String driveId) {
        String redirectURL = PCHelperConstant.getPropertyFileValueForParacloudUrl() + "/portal/viewFile/" + this.encodeBase64UTFString(userName) + "/" + this.encodeBase64UTFString(deviceUUID) + "/" + this.encodeBase64UTFString(bkpImage.getId().toString()) + "/cmFwaWRSZXN0b3Jl/bm9EZXZpY2VQYXRo";
        Object fileUrl = "";
        if (StringUtils.isEmpty((String)driveId)) {
            driveId = OneDriveUtil.getDriveForC2CUser(1, drivUserName);
        }
        if (bkpImage.getDevicePath().equalsIgnoreCase("Files")) {
            fileUrl = "https://graph.microsoft.com/v1.0/drives/" + driveId + "/root/children/" + bkpImage.getFileName() + ".url/content";
        } else {
            path = path.replaceAll(":", "_Drive");
            path = path.replaceAll("#", "_HASH");
            path = path.replaceAll("%(?!20)", "_PERCENTAGE");
            fileUrl = "https://graph.microsoft.com/v1.0/drives/" + driveId + "/root:/" + path + "/" + bkpImage.getFileName() + ".url:/content";
        }
        logger.debug(bkpImage.getFileName() + "....file and url...." + (String)fileUrl);
        logger.debug("....new redirect url Ttest...." + redirectURL);
        String bodyContent = "[InternetShortcut]\nURL=" + redirectURL;
        RequestBody body = RequestBody.create((byte[])bodyContent.getBytes());
        Request request = new Request.Builder().url((String)fileUrl).put(body).build();
        Call call = C2CGraphClient.getInstance().getOkHttpClient().newCall(request);
        try {
            Response response = call.execute();
            int responseCode = response.code();
            logger.debug(".....responsecode...." + responseCode);
        }
        catch (GraphServiceException e) {
            e.printStackTrace();
            logger.error(".....error in creating link to ...");
        }
        catch (IOException ee) {
            ee.printStackTrace();
        }
        logger.debug("..... afterpath...." + path);
    }

    private static String getDateInFormat(Long deviceCreatedDate) {
        String dateStringFormat = "";
        if (deviceCreatedDate == null || deviceCreatedDate == 0L) {
            return dateStringFormat;
        }
        try {
            SimpleDateFormat df2 = new SimpleDateFormat(DD_MMM_YYYY_HH_MM_SS);
            Date dateD = new Date(deviceCreatedDate);
            dateStringFormat = df2.format(dateD).replaceAll(":", ".");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return dateStringFormat;
    }

    private void updateAllFilesforRestore(RestoreEvents restoreEvents, Cloud cloudval, int cloudId, Device device, String cloudName, String userName, RestoreBackUpImage backupImage, boolean isFolder, boolean isDevice, Set<String> folderSet, boolean isRestoreDeletedMail) {
        if (isFolder) {
            logger.debug(isRestoreDeletedMail + "...issFOLDER .backupFile..." + String.valueOf(backupImage.getId()));
            ArrayList<RestoreBackUpImage> backupImages = new ArrayList<RestoreBackUpImage>();
            backupImages.add(backupImage);
            if (!StringUtils.isEmpty((String)backupImage.getDevicePath())) {
                logger.debug("... filespath not empty ...");
                this.downloadService.getAllFolderChildrenByDevicePathLatest(cloudName, userName, backupImage.getDevicePath() + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + backupImage.getFileName(), device, cloudId, backupImages, isRestoreDeletedMail);
            } else {
                logger.debug(isRestoreDeletedMail + "... filespath empty ...");
                this.downloadService.getAllFolderChildrenByDevicePathLatest(cloudName, userName, backupImage.getFileName(), device, cloudId, backupImages, isRestoreDeletedMail);
            }
            logger.debug(".....isfolder files... " + backupImages.size());
            this.updateFilesForRestore(restoreEvents, cloudId, device, cloudName, userName, backupImages, restoreEvents.getRestoreDataBefore(), folderSet);
        } else if (isDevice) {
            ArrayList<RestoreBackUpImage> backupImagesList = new ArrayList<RestoreBackUpImage>();
            List<RestoreBackUpImage> backupImages = this.downloadService.getBaseFoldersForDeviceLatest(cloudval.getCloudId(), device);
            backupImagesList.addAll(backupImages);
            logger.debug("..... isDEVICE basefolderss... " + backupImagesList.size());
            for (RestoreBackUpImage backupImageObj : backupImages) {
                if (!StringUtils.isEmpty((String)backupImageObj.getDevicePath())) {
                    logger.debug("... filespath not empty ...");
                    this.downloadService.getAllFolderChildrenByDevicePathLatest(cloudName, userName, backupImageObj.getDevicePath() + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + backupImageObj.getFileName(), device, cloudId, backupImagesList, isRestoreDeletedMail);
                    continue;
                }
                logger.debug("... filespath empty ...");
                this.downloadService.getAllFolderChildrenByDevicePathLatest(cloudName, userName, backupImageObj.getFileName(), device, cloudId, backupImagesList, isRestoreDeletedMail);
            }
            this.updateFilesForRestore(restoreEvents, cloudId, device, cloudName, userName, backupImagesList, restoreEvents.getRestoreDataBefore(), folderSet);
        } else {
            logger.debug(String.valueOf(device) + "....isFILEEEE.lastservermodified check..... " + device.getDestCollection());
            BackupFile backupFile = this.utilServiceObj.getBackupFileForId(cloudval.getCloudId(), userName, device, restoreEvents.getFileInfo().getId());
            logger.debug(String.valueOf(device) + "....isFILEEEE.lastservermodified check..... " + device.getDestCollection());
            logger.debug("..file restore ... " + restoreEvents.isRestoreAllVersions());
            if (restoreEvents.isRestoreAllVersions()) {
                this.storeRestoreElementsForAllVersions(restoreEvents, cloudId, device, backupImage);
            } else {
                boolean restoreAllowed = true;
                if (restoreEvents.getRestoreDataBefore() > 0L && backupFile.getLastServerModifiedTime() > restoreEvents.getRestoreDataBefore()) {
                    restoreAllowed = false;
                }
                if (restoreAllowed) {
                    OfficeRestoreFileInfo officeRestoreFileInfo = new OfficeRestoreFileInfo();
                    officeRestoreFileInfo.setBackupId(backupFile.getBackupId().toString());
                    officeRestoreFileInfo.setFileName(backupImage.getFileName());
                    officeRestoreFileInfo.setRestoreEventId(restoreEvents.getId().toString());
                    officeRestoreFileInfo.setOdItemId(backupImage.getOdItemId());
                    officeRestoreFileInfo.setFilePath(backupImage.getDevicePath());
                    officeRestoreFileInfo.setSize(backupImage.getSize() * 1024L);
                    officeRestoreFileInfo.setDeviceUUID(backupImage.getDeviceUUID());
                    folderSet.add(backupFile.getFilePath());
                    this.utilServiceObj.saveOfficeRestoreFileInfo(cloudId, officeRestoreFileInfo);
                }
            }
        }
    }

    long getTotalSize(List<OfficeRestoreFileInfo> fileInfoList) {
        long totalSize = 0L;
        for (OfficeRestoreFileInfo fileInfo : fileInfoList) {
            totalSize += fileInfo.getSize();
        }
        return totalSize;
    }

    void saveRestoreProgress(int cloudId, String deviceUUID, List<OfficeRestoreFileInfo> fileInfoList, String actionBy, String batchId, int totalNoOfFilesForRestore, long restoredFiles) {
        RestoreProgressEvents restoreProgressEvents = this.utilServiceObj.getRestoreProgresByDeviceUUID(cloudId, deviceUUID, actionBy);
        if (restoreProgressEvents == null) {
            restoreProgressEvents = new RestoreProgressEvents();
        } else {
            restoreProgressEvents.setId(restoreProgressEvents.getId());
        }
        restoreProgressEvents.setTotalNoOfFilesForRestore((long)totalNoOfFilesForRestore);
        restoreProgressEvents.setDeviceUUID(deviceUUID);
        restoreProgressEvents.setUserName(actionBy);
        restoreProgressEvents.setRestoredFiles(restoredFiles);
        restoreProgressEvents.setBatchId(batchId);
        this.utilServiceObj.saveRestoreProgressForDevice(cloudId, restoreProgressEvents);
    }

    public static String getKeyFromValue(Map<String, String> folderMap, String value) {
        logger.debug("..checkforFolder...." + value);
        boolean isInPlaceArchiveFolder = value.startsWith(IN_PLACE_ARCHIVE);
        if (value.endsWith("/")) {
            value = value.substring(0, value.lastIndexOf("/"));
        }
        for (String key : folderMap.keySet()) {
            String exitFolderPath = folderMap.get(key);
            if (!exitFolderPath.equals(value)) continue;
            logger.debug(exitFolderPath + "....keyfound...." + key);
            return key;
        }
        logger.debug("...key not found for path...." + value);
        return null;
    }

    public static ExchangeService getAuthenticatedService(String token, String senderAddr) {
        ExchangeService service = null;
        try {
            service = new ExchangeService(ExchangeVersion.Exchange2010_SP2);
            service.getHttpHeaders().put("Authorization", "Bearer " + token);
            service.getHttpHeaders().put("X-AnchorMailbox", senderAddr);
            service.setUrl(new URI(EWS_URL));
            service.setImpersonatedUserId(new ImpersonatedUserId(ConnectingIdType.PrincipalName, senderAddr));
        }
        catch (Exception e) {
            logger.error("... ERRORR...... " + e.getMessage());
        }
        return service;
    }

    private Map<String, String> getExistingFolders(ExchangeService service, String userMail) {
        logger.debug("....getexisting folders....");
        EWSAppSetting appSetting = this.utilServiceObj.getEwsAppSettingDetail(1);
        HashMap<String, String> folderMap = new HashMap<String, String>();
        this.getEWSAccesToken(appSetting, false);
        String token = this.ewsToken;
        boolean success = true;
        int retry = 0;
        do {
            try {
                Folder contactsFolder;
                success = true;
                logger.debug("....getexisting foldersaa....");
                FolderView folderView = new FolderView(100);
                FolderId folderIds = new FolderId(WellKnownFolderName.MsgFolderRoot, new Mailbox(userMail));
                logger.debug("....getexisting foldersbb....");
                try {
                    contactsFolder = Folder.bind((ExchangeService)service, (WellKnownFolderName)WellKnownFolderName.Contacts);
                    folderMap.put(contactsFolder.getId().getUniqueId(), "Contacts");
                }
                catch (Exception e) {
                    logger.error("....unable to get contact folder for user......" + userMail);
                }
                try {
                    contactsFolder = Folder.bind((ExchangeService)service, (WellKnownFolderName)WellKnownFolderName.Calendar);
                    folderMap.put(contactsFolder.getId().getUniqueId(), "Calendar");
                }
                catch (Exception e) {
                    logger.error("....unable to get contact folder for user......" + userMail);
                }
                folderView.setTraversal(FolderTraversal.Deep);
                logger.debug("....getexisting folders1....");
                FindFoldersResults findFolders = service.findFolders(folderIds, folderView);
                logger.debug("....getexisting folders2....");
                for (Folder folder : findFolders.getFolders()) {
                    String parentName;
                    Object folderName = folder.getDisplayName();
                    if (folder.getParentFolderId() != null && !StringUtils.isEmpty((String)(parentName = (String)folderMap.get(folder.getParentFolderId().getUniqueId())))) {
                        folderName = parentName + "/" + (String)folderName;
                    }
                    folderMap.put(folder.getId().getUniqueId(), (String)folderName);
                }
            }
            catch (ServiceLocalException ee) {
                ee.printStackTrace();
                logger.error("....error in getting existing folders...." + ee.getMessage());
            }
            catch (ServiceRequestException e) {
                logger.error(" service request Error ", (Throwable)e);
                this.ewsToken = null;
                success = false;
                ++retry;
                this.getEWSAccesToken(appSetting, true);
                token = this.ewsToken;
                logger.debug("..toekn:" + userMail + ".......token:" + token);
                service = OfficeRestoreService.getAuthenticatedService(token, userMail);
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error(userMail + "... ERRORR...... " + e.getMessage());
                if (!e.getMessage().contains("The SMTP address has no mailbox associated with it")) continue;
                return folderMap;
            }
        } while (!success && retry <= 2);
        return folderMap;
    }

    private void storeRestoreElementsForAllVersions(RestoreEvents restoreEvents, int cloudId, Device device, RestoreBackUpImage backupImage) {
        HashedMap fileVersionMapTemp = new HashedMap();
        List<BackUpImage> backUpImages = this.utilServiceObj.getAllVersionsFromBackupImage(cloudId, backupImage.getDevicePath(), backupImage.getFileName(), device);
        logger.debug(".....versions.... " + backUpImages.size());
        for (BackUpImage backUpImage : backUpImages) {
            String mapKey = backUpImage.getDevicePath() + backUpImage.getFileName();
            if (fileVersionMapTemp.containsKey(mapKey)) {
                String newFileName;
                Long versionVal = (Long)fileVersionMapTemp.get(mapKey);
                fileVersionMapTemp.remove(mapKey);
                long newVersion = versionVal + 1L;
                fileVersionMapTemp.put(mapKey, newVersion);
                if (StringUtils.isNotEmpty((String)FilenameUtils.getExtension((String)backUpImage.getFileName()))) {
                    int lastDot = backUpImage.getFileName().lastIndexOf(46);
                    newFileName = backUpImage.getFileName().substring(0, lastDot) + VERSION + newVersion + ")" + backUpImage.getFileName().substring(lastDot);
                } else {
                    newFileName = backUpImage.getFileName() + VERSION + newVersion + ")";
                }
                logger.debug(".....new file name ... " + newFileName);
                backUpImage.setFileName(newFileName);
                continue;
            }
            fileVersionMapTemp.put(mapKey, 1L);
        }
        for (BackUpImage image : backUpImages) {
            boolean restoreAllowed = true;
            if (restoreEvents.getRestoreDataBefore() > 0L && image.getLastServerModifiedTime() > restoreEvents.getRestoreDataBefore()) {
                restoreAllowed = false;
            }
            if (!restoreAllowed) continue;
            OfficeRestoreFileInfo officeRestoreFileInfo = new OfficeRestoreFileInfo();
            officeRestoreFileInfo.setBackupId(image.getId().toString());
            officeRestoreFileInfo.setFileName(image.getFileName());
            officeRestoreFileInfo.setRestoreEventId(restoreEvents.getId().toString());
            officeRestoreFileInfo.setOdItemId(backupImage.getOdItemId());
            officeRestoreFileInfo.setSize(backupImage.getSize());
            officeRestoreFileInfo.setFilePath(backupImage.getDevicePath());
            this.utilServiceObj.saveOfficeRestoreFileInfo(cloudId, officeRestoreFileInfo);
        }
    }

    private void updateRestoreHistoryValues(BackupBatch backupBatch, Device device, String totalSizeRestore, String destFolder, boolean restoredInDiffPath, RestoreHistory restoreHistoy, Device destDevice) {
        restoreHistoy.setUserName(device.getUserName());
        restoreHistoy.setDeviceName(device.getDeviceName());
        restoreHistoy.setDeviceUUID(device.getDeviceUUID());
        restoreHistoy.setRestoreByDeviceName(destDevice.getDeviceName());
        restoreHistoy.setRestoreByUserName(backupBatch.getUserName());
        restoreHistoy.setRestoreByDeviceUUID(destDevice.getDeviceUUID());
        restoreHistoy.setRestoredSize(totalSizeRestore);
        restoreHistoy.setDestFolder(destFolder);
        restoreHistoy.setRestoredInDiffPath(restoredInDiffPath);
    }

    private void saveRestoreHistory(int cloudId, String restoreFolder, BackupBatch backupBatch, String totalSizeRestore, String destFolder, boolean restoredInDiffPath, Device device, Device destDevice, String cloudName, NotifierEmailBodyElement notifierEmailBodyElement, com.parablu.pcbd.domain.User user1, String destinationOneDriveUserId) {
        RestoreHistory restoreHistoy = new RestoreHistory();
        try {
            if (backupBatch.getId() != null) {
                RestoreHistory history = this.utilServiceObj.getRestoreHistoryById(cloudId, backupBatch.getId());
                if (history == null) {
                    logger.debug(destDevice.getDeviceName() + "...totalSizeRestore...." + totalSizeRestore);
                    BeanUtils.copyProperties((Object)backupBatch, (Object)restoreHistoy);
                    if (!StringUtils.isEmpty((String)restoreFolder)) {
                        restoreHistoy.setRestoreFolder(restoreFolder);
                    }
                    this.updateRestoreHistoryValues(backupBatch, device, totalSizeRestore, destFolder, restoredInDiffPath, restoreHistoy, destDevice);
                    if (StringUtils.isNotEmpty((String)destinationOneDriveUserId)) {
                        restoreHistoy.setRestoreByDeviceName(destinationOneDriveUserId + "'s OneDrive");
                    }
                    this.utilServiceObj.saveRestoreHistory(cloudId, restoreHistoy);
                    this.sendEmailForRestore(cloudId, device, cloudName, notifierEmailBodyElement, user1, destDevice, restoreHistoy.getRestoreByUserName(), backupBatch);
                } else {
                    logger.debug(backupBatch.getUploadedSize() + "......restore history already exists :" + String.valueOf(backupBatch.getId()) + "...." + backupBatch.getStatus());
                    history.setRestoredSize(backupBatch.getUploadedSize());
                    history.setDestFolder(destFolder);
                    restoreHistoy.setRestoredInDiffPath(restoredInDiffPath);
                    this.utilServiceObj.saveRestoreHistory(cloudId, history);
                }
            } else {
                BeanUtils.copyProperties((Object)backupBatch, (Object)restoreHistoy);
                this.updateRestoreHistoryValues(backupBatch, device, totalSizeRestore, destFolder, restoredInDiffPath, restoreHistoy, destDevice);
                if (StringUtils.isNotEmpty((String)destinationOneDriveUserId)) {
                    restoreHistoy.setRestoreByDeviceName(destinationOneDriveUserId);
                }
                this.utilServiceObj.saveRestoreHistory(cloudId, restoreHistoy);
            }
        }
        catch (Exception e) {
            logger.trace("Error failed to saveRestoreHistory..." + String.valueOf(e));
            logger.error("Error failed to saveRestoreHistory ..." + e.getMessage());
        }
    }

    private void sendEmailForRestore(int cloudId, Device device, String cloudName, NotifierEmailBodyElement notifierEmailBodyElement, com.parablu.pcbd.domain.User user1, Device destDevice, String actionBy, BackupBatch backupBatch) {
        try {
            String userName = user1.getUserName();
            logger.debug(device.getUserName() + "...start mail restore... " + userName);
            String emailId = user1.getEmailId();
            String actionOn = device.getUserName();
            notifierEmailBodyElement.setRestoreDeviceName(device.getDeviceName());
            notifierEmailBodyElement.setNotifyAllAdmins(true);
            notifierEmailBodyElement.setUserName(userName);
            notifierEmailBodyElement.setCloudId(cloudId);
            notifierEmailBodyElement.setCloudName(cloudName);
            notifierEmailBodyElement.setDeviceName(destDevice.getDeviceName());
            if (backupBatch.getBatchStartTimestamp() > 0L) {
                notifierEmailBodyElement.setBatchStartTimestamp(backupBatch.getBatchStartTimestamp());
            } else {
                notifierEmailBodyElement.setBatchStartTimestamp(System.currentTimeMillis());
            }
            logger.debug(notifierEmailBodyElement.getBatchStartTimestamp() + "...timestamp..." + backupBatch.getBatchStartTimestamp());
            if (!device.getUserName().equalsIgnoreCase(userName)) {
                com.parablu.pcbd.domain.User user = this.utilServiceObj.getUserInfoByName(cloudId, device.getUserName());
                emailId = user.getEmailId();
            }
            boolean isSharePoint = false;
            if (!StringUtils.isEmpty((String)device.getDeviceType()) && device.getDeviceType().equalsIgnoreCase(Device.TYPE.SHAREPOINT.name())) {
                isSharePoint = true;
            }
            notifierEmailBodyElement.setUserName(userName);
            String action = "restore-initiated";
            if (isSharePoint) {
                action = "site-restore-initiated";
                this.sendSPEmail(action, actionOn, actionBy, emailId, notifierEmailBodyElement, action, destDevice.getUserName(), device.getUserName());
            } else {
                this.sendEmail(action, actionOn, actionBy, emailId, notifierEmailBodyElement, device.getDeviceUUID());
            }
            logger.debug(userName + "...end mail restore... " + emailId);
        }
        catch (Exception e) {
            logger.error("error trying to send mail .." + e.getMessage());
        }
    }

    private void updateFilesForRestore(RestoreEvents restoreEvents, int cloudId, Device device, String cloudName, String userName, List<RestoreBackUpImage> backupImages, long restoreDateBefore, Set<String> folderSet) {
        logger.debug(restoreDateBefore + "....oveall files.. " + backupImages.size());
        if (!org.apache.commons.collections.CollectionUtils.isEmpty(backupImages)) {
            for (RestoreBackUpImage backupImg : backupImages) {
                long serverModifiedTime = backupImg.getLastServerModifiedTime();
                if (restoreDateBefore > 0L && serverModifiedTime > restoreDateBefore) continue;
                if (restoreEvents.isRestoreAllVersions()) {
                    this.storeRestoreElementsForAllVersions(restoreEvents, cloudId, device, backupImg);
                    continue;
                }
                OfficeRestoreFileInfo officeRestoreFileInfo = new OfficeRestoreFileInfo();
                officeRestoreFileInfo.setBackupId(backupImg.getId().toString());
                officeRestoreFileInfo.setRestoreEventId(restoreEvents.getId().toString());
                officeRestoreFileInfo.setFilePath(backupImg.getDevicePath());
                officeRestoreFileInfo.setFileName(backupImg.getFileName());
                officeRestoreFileInfo.setDeviceUUID(backupImg.getDeviceUUID());
                folderSet.add(backupImg.getDevicePath() == null ? backupImg.getFileName() : backupImg.getDevicePath());
                this.utilServiceObj.saveOfficeRestoreFileInfo(cloudId, officeRestoreFileInfo);
            }
        }
    }

    public static double getSizeinMb(long size) {
        double m = (double)size / 1024.0;
        DecimalFormat dec = new DecimalFormat("0.00");
        return Double.parseDouble(dec.format(m));
    }

    private synchronized RestoreEvents getRestoreEventsFromOneDriveServer() {
        int cloudId = 1;
        logger.debug("... inside getRestoreEventsFromOneDriveServer... ");
        if (org.apache.commons.collections.CollectionUtils.isEmpty(batchList) && org.apache.commons.collections.CollectionUtils.isEmpty(batchList = this.getBatchFromList(cloudId))) {
            try {
                logger.debug("...batch Completed ... ");
                Thread.sleep(10000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return null;
        }
        RestoreEvents restoreEvents = batchList.get(0);
        if (restoreEvents != null) {
            if (this.batchUnderProcess.contains(restoreEvents.getId().toString())) {
                batchList.remove(restoreEvents);
                logger.debug(batchList.size() + "..only one 5...");
                if (batchList.size() == 0) {
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                return this.getRestoreEventsFromOneDriveServer();
            }
            batchList.remove(restoreEvents);
            this.batchUnderProcess.add(restoreEvents.getId().toString());
        }
        logger.debug("...after bkp batch list size....." + batchList.size());
        return restoreEvents;
    }

    private synchronized RestoreEvents assignBlukryptRestoreEvent(boolean interruptedRestoresFirst) {
        int cloudId = 1;
        logger.debug("inside assignBlukryptRestoreEvent..... " + PCHelperConstant.getComponentName());
        if (org.apache.commons.collections.CollectionUtils.isEmpty(batchList) && org.apache.commons.collections.CollectionUtils.isEmpty(batchList = this.utilServiceObj.getRestoreEventsForBlukrypt(cloudId, PCHelperConstant.getComponentName(), interruptedRestoresFirst)) && org.apache.commons.collections.CollectionUtils.isEmpty(batchList = this.utilServiceObj.getRestoreEventsForBlukrypt(cloudId, PCHelperConstant.getComponentName(), !interruptedRestoresFirst))) {
            logger.debug("...batch Completed ... ");
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            return null;
        }
        RestoreEvents restoreEvents = batchList.get(0);
        if (restoreEvents != null) {
            if (this.batchUnderProcess.contains(restoreEvents.getId().toString())) {
                logger.debug("the restore event is under process");
                batchList.remove(restoreEvents);
                logger.debug((Object)batchList.size());
                if (batchList.size() == 0) {
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                return this.assignBlukryptRestoreEvent(false);
            }
            batchList.remove(restoreEvents);
            this.batchUnderProcess.add(restoreEvents.getId().toString());
        }
        logger.debug("...after bkp batch list size....." + batchList.size());
        return restoreEvents;
    }

    public void checkThreadStatusAndStartUpload(final Cloud cloud, final ExecutorService executor, final CompletionService<String> pool) {
        if (this.backupTimer == null) {
            this.backupTimer = new Timer();
        }
        if (this.backupTimerTask == null) {
            this.backupTimerTask = new TimerTask(){

                @Override
                public void run() {
                    try {
                        logger.error("Check the task is completed>>>>>>>>");
                        Future future = pool.take();
                        if (future.isDone()) {
                            logger.debug("Thread is completed so assign new task>>>>>>>>>>>");
                            OfficeRestoreService.this.callRestoreFiles(cloud, executor, pool);
                        }
                    }
                    catch (Exception e) {
                        logger.error("Error in checkThreadStatusAndStartUpload", (Throwable)e);
                        logger.trace(String.valueOf(e));
                    }
                }
            };
            this.backupTimer.schedule(this.backupTimerTask, 1000L, 1000L);
        }
    }

    private List<RestoreEvents> getBatchFromList(int cloudId) {
        List<OfficeBackupPolicy> list = this.utilServiceObj.getPolicyForBluKrypt(cloudId);
        List<Object> batchListVal = new ArrayList();
        if (batchList == null) {
            batchList = new ArrayList<RestoreEvents>();
        }
        for (OfficeBackupPolicy oneDriveBackupPolicy : list) {
            batchListVal = this.uploadService.getRestoreEventsList(cloudId, oneDriveBackupPolicy.getPolicyName());
            logger.debug(oneDriveBackupPolicy.getPolicyName() + "...mailrestorebatchsize.." + batchListVal.size(), (Object)PCHelperConstant.isBrevityLogging());
            for (RestoreEvents restoreEvents : batchListVal) {
                Device dev = this.utilServiceObj.getDeviceForUUID(cloudId, restoreEvents.getActionOnDeviceUUID());
                RestoreEvents newevents = new RestoreEvents();
                BeanUtils.copyProperties((Object)restoreEvents, (Object)newevents);
                newevents.setOfficePolicyName(oneDriveBackupPolicy.getPolicyName());
                newevents.setOfficeBackupPolicy(oneDriveBackupPolicy);
                if (dev.getOsType().equals(Device.TYPE.OUTLOOK.toString())) {
                    if (!oneDriveBackupPolicy.getPolicyType().equalsIgnoreCase(OfficeBackupPolicy.TYPE.EXCHANGE.toString())) continue;
                    batchList.add(newevents);
                    continue;
                }
                if (dev.getOsType().equals(Device.TYPE.ONEDRIVE.toString())) {
                    if (!oneDriveBackupPolicy.getPolicyType().equalsIgnoreCase(OfficeBackupPolicy.TYPE.ODB.toString())) continue;
                    batchList.add(newevents);
                    continue;
                }
                if (!dev.getOsType().equals(Device.TYPE.SHAREPOINT.toString()) || !oneDriveBackupPolicy.getPolicyType().equalsIgnoreCase(OfficeBackupPolicy.TYPE.SHAREPOINT.toString())) continue;
                batchList.add(newevents);
            }
        }
        logger.debug("inside getting endpoint to onedrive restore events..");
        List<Object> batchListValC2C = new ArrayList();
        batchListValC2C = this.uploadService.getRestoreEventsList(cloudId, "pb-endpoint-to-onedrive-restore");
        for (RestoreEvents restoreEvents : batchListValC2C) {
            logger.debug("current event:" + restoreEvents.getOfficePolicyName());
            if (!restoreEvents.getOfficePolicyName().equalsIgnoreCase("pb-endpoint-to-onedrive-restore")) continue;
            String string = restoreEvents.getUserName();
            logger.debug("userName:" + string);
            com.parablu.pcbd.domain.User user = this.utilServiceObj.getUserInfoByName(1, string);
            logger.debug(PCHelperConstant.getComponentName() + "...user..." + user.getPolicyName());
            BackupPolicy policy = this.utilServiceObj.getBackupPolicy(1, user.getPolicyName());
            logger.debug("policy..." + policy.getPolicyName() + "..." + policy.getSearchAlgoForPg());
            if (policy.getSearchAlgoForPg().equalsIgnoreCase("PRIORITY")) {
                logger.debug("inside prioirty..." + policy.getPolicyName() + "..." + policy.getSearchAlgoForPg());
                logger.debug("policy..." + ((PrivacyGateway)policy.getPrivacyGateways().get(0)).getGatewayName() + "..." + PCHelperConstant.getComponentName());
                if (!((PrivacyGateway)policy.getPrivacyGateways().get(0)).getGatewayName().equalsIgnoreCase(PCHelperConstant.getComponentName())) continue;
                batchList.add(restoreEvents);
                continue;
            }
            List<PrivacyGateway> gateways = this.utilServiceObj.getAllPrivacyGateways(1);
            String compName = gateways.get(0).getGatewayName();
            if (!PCHelperConstant.getComponentName().equalsIgnoreCase(compName)) continue;
            batchList.add(restoreEvents);
        }
        return batchList;
    }

    private void updateBatchAndOverview(int cloudId, ObjectId backupBatchId, String status, String deviceUUID, int errorCode, int restoredFiles, long restoredSize) {
        this.utilServiceObj.updateBackupBatch(cloudId, backupBatchId, status, errorCode);
        this.utilServiceObj.updateBackupBatchForRestore(cloudId, String.valueOf(backupBatchId), restoredFiles, restoredSize);
    }

    public void shutdown() {
        this.shutdown = true;
    }

    private List<OfficeRestoreFileInfo> getOfficeRestoreFileInfoFromListForBatchId(int cloudId, String batchId) {
        List<OfficeRestoreFileInfo> list = this.utilServiceObj.getOfficeRestoreFileInfoFromListForBatchId(cloudId, batchId);
        if (org.apache.commons.collections.CollectionUtils.isEmpty(list)) {
            return new ArrayList<OfficeRestoreFileInfo>();
        }
        return list;
    }

    public void updateBackupBatch(BackupBatch backupBatchOdb, Cloud cloud, int uploadedFiles, Long size) {
        logger.debug("calling backup Batch ..." + backupBatchOdb.getNoOfFiles());
        try {
            int cloudId = cloud.getCloudId();
            logger.debug(" ************ ");
            this.utilServiceObj.updateBackupBatchForRestore(cloudId, backupBatchOdb.getId().toString(), uploadedFiles, size);
            this.utilServiceObj.updateUplodedFilesInBackupOverView(cloudId, backupBatchOdb.getDeviceUUID(), uploadedFiles, size, backupBatchOdb.getTotalSizeToUpload());
            logger.debug("[backupBatch][" + backupBatchOdb.getUserName() + "][" + backupBatchOdb.getDeviceUUID() + "][" + String.valueOf(backupBatchOdb.getId()) + "][" + backupBatchOdb.getStatus() + "][" + backupBatchOdb.getBatchStartTimestamp() + "][" + backupBatchOdb.getBatchEndTimestamp() + "]");
        }
        catch (Exception e) {
            logger.trace("Error failed to save backupBatch ..." + String.valueOf(e));
            logger.error("Error failed to save backupBatch ..." + e.getMessage());
        }
        logger.debug("end of calling backup Batch ...");
    }

    long getActualUploadedFiles(String uploadedFiles) {
        if (StringUtils.isEmpty((String)uploadedFiles)) {
            uploadedFiles = "0/0";
        }
        String[] parts = uploadedFiles.split("/");
        return Long.parseLong(parts[0]);
    }

    public void startBackupBatch(BackupBatch backupBatchOdb, Cloud cloud, int uploadedFiles) {
        logger.debug("calling start restore backup Batch ...");
        try {
            int cloudId = cloud.getCloudId();
            String jobType = "RESTORE";
            String totalNoOfFiles = "" + backupBatchOdb.getNoOfFiles();
            String deviceUUID = backupBatchOdb.getDeviceUUID();
            Device device = this.utilServiceObj.getDeviceForUUID(cloudId, deviceUUID);
            long startTimeStamp = backupBatchOdb.getBatchStartTimestamp();
            if (startTimeStamp == 0L) {
                startTimeStamp = System.currentTimeMillis();
            }
            BackupBatch backupBatch = new BackupBatch();
            backupBatch.setId(backupBatchOdb.getId());
            backupBatch.setUserName(backupBatchOdb.getUserName());
            backupBatch.setDeviceName(backupBatchOdb.getDeviceName());
            backupBatch.setDeviceUUID(deviceUUID);
            backupBatch.setStatus(STARTED);
            backupBatch.setJobType(jobType);
            backupBatch.setBatchStartTimestamp(startTimeStamp);
            backupBatch.setTotalNoOfFiles(backupBatchOdb.getTotalNoOfFiles());
            backupBatch.setUploadedFiles(uploadedFiles + "/" + totalNoOfFiles);
            if (device != null) {
                backupBatch.setDeviceName(device.getDeviceName());
            }
            backupBatch.setBatchEndTimestamp(System.currentTimeMillis());
            backupBatch.setNoOfFiles(backupBatchOdb.getNoOfFiles());
            backupBatch.setTotalSizeToUpload(backupBatchOdb.getTotalSizeToUpload());
            backupBatch.setUploadedSize(backupBatchOdb.getUploadedSize());
            backupBatch.setMsBatch(backupBatchOdb.isMsBatch());
            this.utilServiceObj.saveBackupBatch(cloudId, backupBatch);
            BeanUtils.copyProperties((Object)backupBatch, (Object)backupBatchOdb);
            logger.debug("[backupBatch][" + backupBatch.getUserName() + "][" + backupBatch.getDeviceUUID() + "][" + String.valueOf(backupBatch.getId()) + "][" + backupBatch.getStatus() + "][" + backupBatch.getBatchStartTimestamp() + "][" + backupBatch.getBatchEndTimestamp() + "]");
            logger.debug(" before updateoverview..");
            this.utilServiceObj.deleteEventHubForDeviceUUID(cloudId, deviceUUID, PCHelperConstant.EVENTHUB_ACTION_STATUS.RESTORE_CREATED.toString());
            logger.debug(" after updateoverview..");
        }
        catch (Exception e) {
            logger.trace("Error failed to save backupBatch ..." + String.valueOf(e));
            logger.error("Error failed to save backupBatch ...{}", (Throwable)e);
        }
        logger.debug("end of calling method backup Batch ...");
    }

    private String gettimeZoneInUTC() {
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"), Locale.getDefault());
        Date currentLocalTime = calendar.getTime();
        logger.debug("currentLocalTime" + String.valueOf(currentLocalTime));
        SimpleDateFormat date = new SimpleDateFormat("Z");
        String localTime = date.format(currentLocalTime);
        logger.debug("GMT" + localTime);
        return localTime;
    }

    private String getDateFromTimeStamp(long timestamp) {
        String bkpEndTime = null;
        try {
            logger.debug("bodyElement.getBatchStartTimestamp()" + timestamp);
            Date date = new Date(timestamp);
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DD_MMM_YYYY_HH_MM_SS);
            bkpEndTime = simpleDateFormat.format(date);
        }
        catch (Exception e1) {
            logger.error("error....", (Throwable)e1);
            e1.printStackTrace();
        }
        return bkpEndTime;
    }

    private void sendEmail(String action, String actionOn, String actionBy, String emailId, NotifierEmailBodyElement bodyElement, String deviceUUID) {
        try {
            logger.debug(bodyElement.getNoOfFilesBackedUp() + ".. first email12 completion...." + bodyElement.getTotalBackupSize());
            String url = PCHelperConstant.getPropertyFileValueForParacloudUrl().trim() + "/paracloud/cloud/" + bodyElement.getCloudName() + "/mail";
            logger.debug(bodyElement.getNoOfFilesBackedUp() + ".. first email url with dev details s...." + url);
            CloseableHttpClient httpclient = HttpClientUtil.getSSlConnection();
            HttpPost httpPost = new HttpPost(url);
            httpPost.setHeader("Content-Type", (Object)"application/json");
            httpPost.setHeader("isInternalCall", (Object)"true");
            httpPost.setHeader("bkupsDone", (Object)String.valueOf(bodyElement.getNoOfFilesBackedUp()));
            JSONObject emailDetails = new JSONObject();
            emailDetails.put("actionBy", (Object)actionBy);
            emailDetails.put("action", (Object)action);
            emailDetails.put("actionOn", (Object)actionOn);
            emailDetails.put("toUser", true);
            emailDetails.put("userName", (Object)bodyElement.getUserName());
            emailDetails.put("deviceUUID", (Object)deviceUUID);
            emailDetails.put("bodyData", (Object)bodyElement.getRestoreDeviceName());
            emailDetails.put("fileName", (Object)bodyElement.getRestoreFolder());
            emailDetails.put("customMailMessage", (Object)String.valueOf(bodyElement.getTotalBackupSize()));
            emailDetails.put("deviceName", (Object)String.valueOf(bodyElement.getDeviceName()));
            emailDetails.put("totalStorageUtilized", (Object)String.valueOf(bodyElement.getTotalBackupSize()));
            emailDetails.put("bkupsDone", (Object)String.valueOf(bodyElement.getNoOfFilesBackedUp()));
            emailDetails.put("toAdmins", true);
            String bkpStartTime = this.getDateFromTimeStamp(bodyElement.getBatchStartTimestamp());
            if (bkpStartTime != null) {
                emailDetails.put("batchStartTime", (Object)(bkpStartTime.toString() + "(GMT" + this.gettimeZoneInUTC() + ")"));
            } else {
                emailDetails.put("batchStartTime", (Object)"");
            }
            StringEntity params = new StringEntity(emailDetails.toString());
            httpPost.setEntity((HttpEntity)params);
            HttpResponse response = httpclient.execute((ClassicHttpRequest)httpPost);
            logger.debug(actionBy + "..Send mail result status code :", (Object)response);
        }
        catch (IOException e) {
            logger.trace(String.valueOf(e));
            logger.error("Exception :", (Object)e.getMessage());
        }
    }

    private void sendSPEmail(String action, String actionOn, String actionBy, String emailId, NotifierEmailBodyElement bodyElement, String deviceUUID, String destUser, String srcUser) {
        try {
            logger.debug(bodyElement.getNoOfFilesBackedUp() + ".. first email12 completion...." + bodyElement.getTotalBackupSize());
            String url = PCHelperConstant.getPropertyFileValueForParacloudUrl().trim() + "/paracloud/cloud/" + bodyElement.getCloudName() + "/sites/mail";
            logger.debug(bodyElement.getNoOfFilesBackedUp() + ".. first email url with dev details s...." + actionBy);
            CloseableHttpClient httpclient = HttpClientUtil.getSSlConnection();
            HttpPost httpPost = new HttpPost(url);
            httpPost.setHeader("Content-Type", (Object)"application/json");
            httpPost.setHeader("isInternalCall", (Object)"true");
            httpPost.setHeader("bkupsDone", (Object)String.valueOf(bodyElement.getNoOfFilesBackedUp()));
            JSONObject emailDetails = new JSONObject();
            emailDetails.put("actionBy", (Object)actionBy);
            emailDetails.put("action", (Object)action);
            emailDetails.put("actionOn", (Object)actionOn);
            emailDetails.put("toUser", true);
            emailDetails.put("userName", (Object)destUser);
            emailDetails.put("deviceUUID", (Object)deviceUUID);
            emailDetails.put("bodyData", (Object)srcUser);
            emailDetails.put("fileName", (Object)bodyElement.getRestoreFolder());
            emailDetails.put("customMailMessage", (Object)String.valueOf(bodyElement.getTotalBackupSize()));
            emailDetails.put("deviceName", (Object)String.valueOf(bodyElement.getDeviceName()));
            emailDetails.put("totalStorageUtilized", (Object)String.valueOf(bodyElement.getTotalBackupSize()));
            emailDetails.put("bkupsDone", (Object)String.valueOf(bodyElement.getNoOfFilesBackedUp()));
            emailDetails.put("toAdmins", true);
            String bkpStartTime = this.getDateFromTimeStamp(bodyElement.getBatchStartTimestamp());
            if (bkpStartTime != null) {
                emailDetails.put("batchStartTime", (Object)(bkpStartTime.toString() + "(GMT" + this.gettimeZoneInUTC() + ")"));
            } else {
                emailDetails.put("batchStartTime", (Object)"");
            }
            StringEntity params = new StringEntity(emailDetails.toString());
            httpPost.setEntity((HttpEntity)params);
            HttpResponse response = httpclient.execute((ClassicHttpRequest)httpPost);
            logger.debug(actionBy + "..Send mail result status code :", (Object)response);
        }
        catch (IOException e) {
            logger.trace(String.valueOf(e));
            logger.error("Exception :", (Object)e.getMessage());
        }
    }

    private String getUserId(String mailUserName) {
        String emailId = mailUserName;
        String userId = "";
        User userFound = null;
        ArrayList<QueryOption> requestOptions = new ArrayList<QueryOption>();
        requestOptions.add(new QueryOption("$filter", (Object)("mail eq '" + emailId + "'")));
        UserCollectionPage iUserCollectionPage = (UserCollectionPage)((UserCollectionRequest)Graph.getInstance().getGraphClient().users().buildRequest(requestOptions)).top(1).get();
        for (User userObjVal : iUserCollectionPage.getCurrentPage()) {
            logger.debug(userObjVal.userPrincipalName + "... user val..." + userObjVal.givenName);
            if (!emailId.equalsIgnoreCase(userObjVal.mail) || !emailId.equalsIgnoreCase(userObjVal.userPrincipalName)) continue;
            userFound = userObjVal;
            break;
        }
        if (userFound == null) {
            for (User user : iUserCollectionPage.getCurrentPage()) {
                if (!emailId.equalsIgnoreCase(user.mail)) continue;
                userFound = user;
                break;
            }
        }
        userId = userFound.id;
        return userId;
    }

    private void getEWSAccesToken(EWSAppSetting ewsAppSetting, boolean getFresh) {
        logger.debug("getEWSAccesToken....");
        try {
            if (getFresh) {
                this.utilServiceObj.updateEWSToken(1);
                this.ewsToken = this.utilServiceObj.getEWSToken(1);
            }
            if (this.ewsToken == null) {
                this.ewsToken = this.utilServiceObj.getEWSToken(1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Error getting ews token......", (Throwable)e);
        }
    }

    public void downloadPst(RestoreEvents restoreEvents, Cloud cloudval) {
        try {
            String loginUserName = restoreEvents.getActionBy();
            String pstName = restoreEvents.getFileInfo().getFilePath();
            if (StringUtils.isNotEmpty((String)pstName)) {
                pstName = OfficeRestoreService.decodeBase64UTFString(pstName);
            }
            logger.debug("login userName={} who is downloading pst file name={}", (Object)loginUserName, (Object)pstName);
            String fileName = restoreEvents.getFileInfo().getFileName();
            String syncRevisionId = restoreEvents.getFileInfo().getId();
            String userName = restoreEvents.getFileInfo().getUserName();
            String sourceDeviceUUID = restoreEvents.getActionOnDeviceUUID();
            boolean isFolder = restoreEvents.getFileInfo().isFolder();
            boolean isrestoreDeletedFile = restoreEvents.isRestoreDeletedFiles();
            boolean isSync = false;
            String batchId = restoreEvents.getFileInfo().getBatchId();
            logger.debug("isrestoreDeletedFile= " + isrestoreDeletedFile);
            int cloudId = 1;
            String backupId = syncRevisionId;
            DownloadFileTO downloadFileTO = new DownloadFileTO();
            downloadFileTO.setCloudName(cloudval.getCloudName());
            downloadFileTO.setGatewayName(restoreEvents.getFileInfo().getGatewayName());
            downloadFileTO.setFileName(fileName);
            downloadFileTO.setUserName(userName);
            downloadFileTO.setBackupID(backupId);
            downloadFileTO.setDeviceUUID(sourceDeviceUUID);
            logger.debug("action=pst download, Filename={}, batchId={}", (Object)downloadFileTO.getFileName(), (Object)batchId);
            logger.debug("download file started for portal backupId={}, pstName={}", (Object)backupId, (Object)pstName);
            String deviceUUID = "Portal";
            Object downloadTO = null;
            if (!StringUtils.isEmpty((String)batchId)) {
                if (!StringUtils.isEmpty((String)pstName)) {
                    downloadFileTO.setFileName(pstName);
                } else {
                    downloadFileTO.setFileName(userName + "_search_results");
                }
            }
            Cloud cloud = this.utilServiceObj.getCloud(1);
            Device device = this.utilServiceObj.getDeviceForUUID(cloudId, sourceDeviceUUID);
            BackUpImage backUpImage = null;
            String dowloadFile = downloadFileTO.getFileName() + ".pst";
            if (!StringUtils.isEmpty((String)backupId)) {
                if (!backupId.contains(",")) {
                    backUpImage = this.utilServiceObj.getBackupImageFile(cloudId, backupId, device);
                    if (backUpImage != null && dowloadFile.equalsIgnoreCase(".pst")) {
                        downloadFileTO.setFileName(backUpImage.getFileName());
                        dowloadFile = backUpImage.getFileName() + ".pst";
                    }
                } else {
                    backUpImage = null;
                    downloadFileTO.setFileName(device.getUserName());
                    dowloadFile = device.getUserName() + ".pst";
                }
            }
            if (backUpImage != null && !backUpImage.isFolder()) {
                dowloadFile = backUpImage.getFileName() + ".pst";
                downloadFileTO.setFileName(backUpImage.getFileName());
            }
            if (!StringUtils.isEmpty((String)pstName)) {
                downloadFileTO.setFileName(pstName);
            }
            this.downloadPstBackupFolderForPortal(downloadFileTO, cloud, batchId, isrestoreDeletedFile, loginUserName, restoreEvents);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("error trying to download folder..." + String.valueOf(e));
        }
        logger.debug(" end of  download file  Completed for portal ....");
    }

    private void downloadPstBackupFolderForPortal(DownloadFileTO downloadFileTO, Cloud cloud, String pstBatchId, boolean isrestoreDeletedFile, String restoreBy, RestoreEvents restoreEvents) {
        String userName = downloadFileTO.getUserName();
        int cloudId = cloud.getCloudId();
        String deviceUUID = downloadFileTO.getDeviceUUID();
        logger.debug(pstBatchId + "..existing deviuuid..." + deviceUUID + "...restoreby..." + restoreBy);
        if (StringUtils.isEmpty((String)deviceUUID) && !StringUtils.isEmpty((String)downloadFileTO.getBackupID()) && !StringUtils.isEmpty((String)(deviceUUID = this.backupFileDao.getDeviceUUIDForId(cloudId, cloud.getCloudName(), userName, downloadFileTO.getBackupID())))) {
            downloadFileTO.setDeviceUUID(deviceUUID);
        }
        Device device = this.utilServiceObj.getDeviceForUUID(cloudId, deviceUUID);
        DownloadTO downloadTO = new DownloadTO("");
        this.downloadPstFileFromCloudForPortal(cloud, downloadFileTO, downloadTO, device, pstBatchId, isrestoreDeletedFile, restoreBy, restoreEvents);
    }

    private void downloadPstFileFromCloudForPortal(Cloud cloud, DownloadFileTO downloadFileTO, DownloadTO downloadTO, Device device, String pstBatchId, boolean isrestoreDeletedFile, String restoreBy, RestoreEvents restoreEvents) {
        String restorePath;
        File restoreFolderPath;
        String deviceUUID = downloadFileTO.getDeviceUUID();
        boolean isSearch = false;
        int cloudId = cloud.getCloudId();
        String cloudName = cloud.getCloudName();
        String userName = downloadFileTO.getUserName();
        String path = PCHelperConstant.getPropertyFileValueParacloudMountPoint() + cloud.getCloudName() + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + "sync-download" + GeneralHelperConstant.CLOUD_PATH_SEPARATOR;
        File tempdownloadDir = new File(path);
        int restoredSize = 0;
        int uploadedFiles = 0;
        BackupBatch backupBatch = new BackupBatch();
        BeanUtils.copyProperties((Object)restoreEvents, (Object)backupBatch);
        backupBatch.setId(restoreEvents.getId());
        backupBatch.setUserName(restoreEvents.getActionBy());
        BackupBatch pbBkpBatch = this.utilServiceObj.getBackupBatchById(cloud.getCloudId(), backupBatch.getId().toString());
        if (pbBkpBatch != null) {
            String[] parts = pbBkpBatch.getUploadedFiles().split("/");
            uploadedFiles = Integer.parseInt(parts[0]);
            logger.debug(pbBkpBatch.getUploadedFiles() + "....prev files ... " + uploadedFiles);
            backupBatch.setTotalSizeToUpload(pbBkpBatch.getTotalSizeToUpload());
            backupBatch.setTotalNoOfFiles(pbBkpBatch.getTotalNoOfFiles());
            backupBatch.setBatchStartTimestamp(pbBkpBatch.getBatchStartTimestamp());
        }
        if (!tempdownloadDir.exists()) {
            tempdownloadDir.mkdirs();
        }
        if (!(restoreFolderPath = new File(restorePath = path + restoreEvents.getId().toString() + GeneralHelperConstant.CLOUD_PATH_SEPARATOR)).exists()) {
            restoreFolderPath.mkdirs();
        }
        String restoreBatchId = restoreEvents.getId().toString();
        String restoreFolder = "";
        String devicePath = downloadFileTO.getFileName();
        logger.debug(devicePath + "Restore folder path is create :" + String.valueOf(restoreFolderPath));
        boolean allFolders = false;
        String deviceSearchUUID = null;
        StringBuffer addStr = new StringBuffer();
        if (StringUtils.isNotEmpty((String)pstBatchId)) {
            isSearch = true;
        }
        if (pstBatchId != null && StringUtils.isNotEmpty((String)restoreEvents.getActionOnDeviceUUID())) {
            deviceSearchUUID = restoreEvents.getActionOnDeviceUUID();
        }
        try {
            int errorCode;
            long folderSize = 0L;
            List<Object> backupImageList = new ArrayList<BackUpImage>();
            ArrayList<BackUpImage> backupImagesList = new ArrayList<BackUpImage>();
            if (!StringUtils.isEmpty((String)downloadFileTO.getBackupID())) {
                String[] backupImgList;
                for (String backupId : backupImgList = downloadFileTO.getBackupID().split(",")) {
                    BackUpImage backupImage = this.externalStorageBackupFileDao.getBackupFileById(cloudId, device, backupId);
                    if (backupImage == null || backupImage.getFileName().equalsIgnoreCase("To Do") || backupImage.getFileName().equalsIgnoreCase("Contacts") || backupImage.getFileName().equalsIgnoreCase("Calendar")) continue;
                    backupImagesList.add(backupImage);
                    logger.debug("...folderstodownload..." + backupImage.getFileName());
                    restoreFolder = backupImage.getFileName();
                    addStr.append(restoreFolder + ",");
                }
                if (backupImgList.length > 1) {
                    String val = addStr.toString();
                    if (val.endsWith(",")) {
                        val = val.substring(0, val.length() - 1);
                    }
                    restoreFolder = val;
                }
            }
            com.parablu.pcbd.domain.User user = this.utilServiceObj.getUserInfoByName(cloudId, restoreBy);
            if (device != null) {
                backupBatch.setDeviceUUID(device.getDeviceUUID());
                backupBatch.setDeviceName(device.getDeviceName());
            } else if (device == null) {
                backupBatch.setDeviceUUID("Global Search (Microsoft Exchange)");
                backupBatch.setDeviceName("Global Search (Microsoft Exchange)");
            }
            String fullyQualifiedPathVal = path + devicePath;
            boolean isPstAborted = false;
            backupImageList = this.getFilteredBackupImageListByGroupingForMail(backupImageList, isrestoreDeletedFile);
            if (pbBkpBatch == null && !org.apache.commons.collections.CollectionUtils.isEmpty(backupImagesList)) {
                for (BackUpImage backupImage : backupImagesList) {
                    ArrayList<BackUpImage> backupImages;
                    backupImageList = new ArrayList();
                    if (!backupImage.isFolder()) {
                        logger.debug("..single mail restore...");
                        backupImages = new ArrayList<BackUpImage>();
                        backupImages.add(backupImage);
                        downloadFileTO.setFileName(backupImage.getFileName());
                        downloadTO.setFileName(backupImage.getFileName());
                        folderSize = this.downloadService.restoreMailForBackupFolder(cloud, downloadFileTO, deviceUUID, path, tempdownloadDir, backupImages, folderSize, restorePath, restoreBatchId, isrestoreDeletedFile, device, backupBatch);
                        continue;
                    }
                    logger.debug("....backupImage..." + String.valueOf(backupImage.getId()));
                    backupImages = new CopyOnWriteArrayList();
                    if (!StringUtils.isEmpty((String)backupImage.getDevicePath())) {
                        logger.debug("....backupImage devicepath not empty..." + backupImage.getDevicePath());
                        this.downloadService.getAllFolderChildrenByDevicePath(cloudName, userName, backupImage.getDevicePath() + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + backupImage.getFileName(), device, cloudId, backupImages, isrestoreDeletedFile);
                    } else {
                        logger.debug("....backupImage devicepath  empty..." + backupImage.getFileName());
                        this.downloadService.getAllFolderChildrenByDevicePath(cloudName, userName, backupImage.getFileName(), device, cloudId, backupImages, isrestoreDeletedFile);
                    }
                    int errorCode2 = this.getBatchErrorCode(cloudId, backupBatch.getId().toString());
                    if (errorCode2 == 1207) {
                        isPstAborted = true;
                        break;
                    }
                    backupImageList.addAll(backupImages);
                    backupImageList.add(backupImage);
                    logger.debug("...filesinpath..." + backupImage.getFileName() + "..." + backupImageList.size());
                    logger.debug("...first Size..." + backupImageList.size());
                    int totalFilesToRestore = 0;
                    ArrayList<CallSite> processedFolders = new ArrayList<CallSite>();
                    if (org.apache.commons.collections.CollectionUtils.isEmpty(backupImageList)) continue;
                    for (BackUpImage backUpImage : backupImageList) {
                        logger.debug(".......processingfolder1..." + backUpImage.getDevicePath() + "/" + backUpImage.getFileName());
                        int skipValue = 0;
                        if (backUpImage.isFolder() && processedFolders.contains(backUpImage.getDevicePath() + "/" + backUpImage.getFileName())) {
                            logger.debug("Already processed the folder so skip:" + backUpImage.getDevicePath() + "/" + backUpImage.getFileName());
                            continue;
                        }
                        List<BackUpImage> backupImagesFolderFile = new ArrayList();
                        ArrayList<BackUpImage> backupImagesFolderFileUnfiltered = new ArrayList<BackUpImage>();
                        int filesInFolder = 0;
                        do {
                            backupImagesFolderFile = new ArrayList();
                            backupImagesFolderFileUnfiltered = new ArrayList();
                            errorCode2 = this.getBatchErrorCode(cloudId, backupBatch.getId().toString());
                            if (errorCode2 == 1207) {
                                isPstAborted = true;
                                break;
                            }
                            if (StringUtils.isNotEmpty((String)backUpImage.getDevicePath())) {
                                logger.debug(backUpImage.getDevicePath() + "....backupImagedata non empty..." + backUpImage.getFileName());
                                backupImagesFolderFile = this.externalStorageBackupFileDao.getBackupFilesForBasePathSkipValue(cloudId, cloudName, userName, device, backUpImage.getDevicePath() + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + backUpImage.getFileName(), skipValue);
                                backupImagesFolderFileUnfiltered.addAll(backupImagesFolderFile);
                            } else {
                                logger.debug(backUpImage.getFileName() + "....backupImagedata  empty..." + backupImage.getFileName());
                                backupImagesFolderFile = this.externalStorageBackupFileDao.getBackupFilesForBasePathSkipValue(cloudId, cloudName, userName, device, backUpImage.getFileName(), skipValue);
                                logger.debug("...devuse..." + device.getDeviceUUID() + "...." + userName + "...." + backupImage.getFileName());
                                backupImagesFolderFileUnfiltered.addAll(backupImagesFolderFile);
                            }
                            if (!org.apache.commons.collections.CollectionUtils.isEmpty(backupImagesFolderFile)) {
                                folderSize = this.downloadService.restoreMailForBackupFolder(cloud, downloadFileTO, deviceUUID, path, tempdownloadDir, backupImagesFolderFile, folderSize, restorePath, restoreBatchId, isrestoreDeletedFile, device, backupBatch);
                            }
                            logger.debug(++skipValue + "....files under path  " + backupImage.getFileName() + "..." + (filesInFolder += backupImagesFolderFile.size()) + "..ubfiltered..." + backupImagesFolderFileUnfiltered.size());
                        } while (!org.apache.commons.collections.CollectionUtils.isEmpty(backupImagesFolderFileUnfiltered));
                        logger.debug(backUpImage.getFileName() + "....foldercompleted...." + filesInFolder + "....totalfilesrestored..." + (totalFilesToRestore += filesInFolder));
                        if (!backUpImage.isFolder()) continue;
                        processedFolders.add((CallSite)((Object)(backUpImage.getDevicePath() + "/" + backUpImage.getFileName())));
                    }
                }
            } else if (pbBkpBatch == null) {
                logger.debug("..pstbatch save....");
                List<PstBatchDetail> pstBatchDetails = this.utilServiceObj.getPstBatchDetails(pstBatchId);
                ArrayList<BackUpImage> backupImages = new ArrayList<BackUpImage>();
                Device pstBatchDevice = null;
                if (!org.apache.commons.collections.CollectionUtils.isEmpty(pstBatchDetails)) {
                    for (PstBatchDetail pstBatchDetail : pstBatchDetails) {
                        pstBatchDevice = this.utilServiceObj.getDeviceForUUID(cloudId, pstBatchDetail.getDeviceUUID());
                        BackUpImage backupImageObj = this.externalStorageBackupFileDao.getBackupFileById(cloudId, pstBatchDevice, pstBatchDetail.getBackupId());
                        if (backupImageObj == null) continue;
                        backupImages.add(backupImageObj);
                    }
                }
                folderSize = this.downloadService.restoreMailForBackupFolder(cloud, downloadFileTO, deviceUUID, path, tempdownloadDir, backupImages, folderSize, restorePath, restoreBatchId, isrestoreDeletedFile, pstBatchDevice, backupBatch);
            }
            long totalNoOfFiles = this.utilServiceObj.countFilesForMailBatchId(cloudId, restoreBatchId);
            if (pbBkpBatch == null) {
                this.startBackupBatch(backupBatch, cloud, uploadedFiles);
                this.saveRestoreHistory(cloudId, restoreFolder, backupBatch, "" + folderSize, devicePath + ".pst", isrestoreDeletedFile, device, device, cloudName, null, user, devicePath + ".pst", isSearch);
                logger.debug(restoreBatchId + "...total no of files-for-restore..." + totalNoOfFiles);
                this.utilServiceObj.updateBackupBatchStatusAndSize(cloud.getCloudId(), backupBatch.getId(), STARTED, folderSize, totalNoOfFiles);
                if (device == null) {
                    this.saveRestoreProgress(cloudId, device, restoreEvents.getActionBy(), restoreEvents.getId().toString(), (int)totalNoOfFiles, (long)uploadedFiles, pstBatchId);
                } else {
                    this.saveRestoreProgress(cloudId, device, restoreEvents.getActionBy(), restoreEvents.getId().toString(), (int)totalNoOfFiles, (long)uploadedFiles, null);
                }
            }
            if ((errorCode = this.getBatchErrorCode(cloudId, backupBatch.getId().toString())) == 1207) {
                this.utilServiceObj.updateAbortBackBatch(cloudId, backupBatch.getId());
                this.utilServiceObj.deletePSTBatch(cloudId, restoreBatchId);
                errorCode = 1207;
                this.utilServiceObj.updateBackupBatch(cloudId, backupBatch.getId(), "ABORTED", errorCode);
                this.utilServiceObj.removeRestoreProgress(cloudId, restoreEvents.getActionOnDeviceUUID());
                this.utilServiceObj.deleteRestoreEventForPst(cloudId, restoreEvents.getId());
                logger.debug("..pst aborted...");
                return;
            }
            logger.debug(restoreEvents.getActionOnDeviceUUID() + "....deviceuuid..." + restoreEvents.getDestinationDeviceUUID());
            RestoreProgressEvents restoreProgressEvents = null;
            restoreProgressEvents = device != null ? this.utilServiceObj.getRestoreProgresByDeviceUUID(cloudId, device.getDeviceUUID(), restoreEvents.getActionBy()) : this.utilServiceObj.getRestoreProgresByDeviceUUID(cloudId, pstBatchId, restoreEvents.getActionBy());
            logger.debug(restoreProgressEvents.getRestoredFiles() + "....after save history ...." + totalNoOfFiles);
            int restoredFiles = (int)restoreProgressEvents.getRestoredFiles();
            try {
                logger.debug("...wait for 10 sec for status update..");
                Thread.sleep(TimeUnit.SECONDS.toMillis(10L));
            }
            catch (InterruptedException e) {
                logger.error("error trying to delete dir .... Exception={}", (Throwable)e);
            }
            AtomicInteger finalRestoredSize = new AtomicInteger(restoredSize);
            AtomicInteger finalRestoredFiles = new AtomicInteger(restoredFiles);
            AtomicLong atomicLong = new AtomicLong(restoredSize);
            if (device != null) {
                this.downloadService.restoreMailsForPst(cloud, null, downloadFileTO, deviceUUID, devicePath, tempdownloadDir, restoreBatchId, restorePath, backupBatch, finalRestoredFiles, finalRestoredSize, null, restoreEvents);
            } else {
                this.downloadService.restoreMailsForPst(cloud, null, downloadFileTO, deviceUUID, devicePath, tempdownloadDir, restoreBatchId, restorePath, backupBatch, finalRestoredFiles, finalRestoredSize, pstBatchId, restoreEvents);
            }
            logger.debug("finalRestoredSize:" + finalRestoredSize.get());
            downloadTO.setSize(folderSize);
            errorCode = this.getBatchErrorCode(cloudId, backupBatch.getId().toString());
            if (errorCode != 1207) {
                BackupBatch batch;
                String fullyQualifiedPath = this.downloadService.createPstLatest(restorePath, fullyQualifiedPathVal, ".pst", user.getUserName());
                logger.debug("Completed ....." + finalRestoredSize.get());
                File pstFile = new File(fullyQualifiedPath);
                logger.debug(fullyQualifiedPath + "...fullPath..." + path);
                logger.debug(pstFile.length() + "...file length...." + fullyQualifiedPath);
                downloadTO.setPath(fullyQualifiedPath);
                atomicLong.set(pstFile.length());
                logger.debug("Final restored size:" + atomicLong.get());
                this.updateBatchAndOverview(cloud.getCloudId(), backupBatch.getId(), COMPLETED, backupBatch.getDeviceUUID(), 0, finalRestoredFiles.get(), atomicLong.get());
                if (device != null) {
                    logger.debug("incrementing the number of successful restores for device backup overview for deviceUIID={}", (Object)deviceUUID);
                    DeviceBackupOverView overView = this.utilServiceObj.getDeviceBkpOverviewForDeviceUUID(cloudId, deviceUUID);
                    long noOfSuccessfulRestores = overView.getNoOfSuccessfulRestores();
                    overView.setNoOfSuccessfulRestores(noOfSuccessfulRestores + 1L);
                    this.utilServiceObj.updateDeviceBackupOverView(cloudId, overView);
                }
                if ((batch = this.utilServiceObj.getBackupBatchById(cloud.getCloudId(), backupBatch.getId().toString())) != null) {
                    this.saveRestoreHistory(cloudId, restoreFolder, batch, "" + atomicLong.get(), devicePath + ".pst", isrestoreDeletedFile, device, device, cloudName, null, user, devicePath + ".pst", isSearch);
                }
                if (device != null) {
                    this.utilServiceObj.removeRestoreProgress(cloudId, restoreEvents.getActionOnDeviceUUID());
                } else {
                    this.utilServiceObj.removeRestoreProgress(cloudId, pstBatchId);
                }
                this.utilServiceObj.deleteRestoreEventForPst(cloudId, restoreEvents.getId());
            } else {
                this.utilServiceObj.updateAbortBackBatch(cloudId, backupBatch.getId());
                this.saveRestoreHistory(cloudId, restoreFolder, backupBatch, "" + folderSize, devicePath + ".pst", isrestoreDeletedFile, device, device, cloudName, null, user, devicePath + ".pst", isSearch);
                if (device != null) {
                    this.utilServiceObj.removeRestoreProgress(cloudId, restoreEvents.getActionOnDeviceUUID());
                } else {
                    this.utilServiceObj.removeRestoreProgress(cloudId, pstBatchId);
                }
                this.utilServiceObj.deleteRestoreEventForPst(cloudId, restoreEvents.getId());
            }
            try {
                logger.debug(new File(restorePath).length() + ".....restore...");
                FileUtils.deleteDirectory((File)new File(restorePath));
            }
            catch (Exception e) {
                logger.error("error trying to delete dir .... Exception={}", (Throwable)e);
            }
            logger.debug("..completed....");
        }
        catch (Exception e) {
            logger.error("Exception={}", (Throwable)e);
        }
    }

    private void saveRestoreHistory(int cloudId, String restoreFolder, BackupBatch backupBatch, String totalSizeRestore, String destFolder, boolean restoredInDiffPath, Device device, Device destDevice, String cloudName, NotifierEmailBodyElement notifierEmailBodyElement, com.parablu.pcbd.domain.User user1, String fileName, boolean isSearch) {
        RestoreHistory restoreHistoy = new RestoreHistory();
        try {
            if (device != null) {
                if (backupBatch.getId() != null) {
                    RestoreHistory history = this.utilServiceObj.getRestoreHistoryById(cloudId, backupBatch.getId());
                    if (history == null) {
                        logger.debug(destDevice.getDeviceName() + "...totalSizeRestore...." + totalSizeRestore);
                        BeanUtils.copyProperties((Object)backupBatch, (Object)restoreHistoy);
                        if (!StringUtils.isEmpty((String)restoreFolder)) {
                            restoreHistoy.setRestoreFolder(restoreFolder);
                        }
                        this.updateRestoreHistoryValues(backupBatch, device, totalSizeRestore, destFolder, restoredInDiffPath, restoreHistoy, destDevice, isSearch);
                        if (null != fileName) {
                            restoreHistoy.setPstRestore(true);
                            restoreHistoy.setPstFileName(fileName);
                            restoreHistoy.setNoOfFiles(backupBatch.getUploadedFiles().split("/").length > 0 ? Long.parseLong(backupBatch.getUploadedFiles().split("/")[0]) : 0L);
                            restoreHistoy.setRestoredSize(backupBatch.getUploadedSize());
                            this.utilServiceObj.saveRestoreHistory(cloudId, restoreHistoy);
                        } else {
                            this.sendEmailForRestore(cloudId, device, cloudName, notifierEmailBodyElement, user1, destDevice, restoreHistoy.getRestoreByUserName());
                            this.utilServiceObj.saveRestoreHistory(cloudId, restoreHistoy);
                        }
                    } else {
                        logger.debug("......restore history already exists :" + String.valueOf(backupBatch.getId()) + "...." + backupBatch.getStatus());
                        history.setDestFolder(destFolder);
                        restoreHistoy.setRestoredInDiffPath(restoredInDiffPath);
                        if (null != fileName) {
                            restoreHistoy.setPstRestore(true);
                            restoreHistoy.setPstFileName(fileName);
                            history.setNoOfFiles(backupBatch.getUploadedFiles().split("/").length > 0 ? Long.parseLong(backupBatch.getUploadedFiles().split("/")[0]) : 0L);
                            history.setRestoredSize(backupBatch.getUploadedSize());
                        }
                        this.utilServiceObj.saveRestoreHistory(cloudId, history);
                    }
                } else {
                    BeanUtils.copyProperties((Object)backupBatch, (Object)restoreHistoy);
                    this.updateRestoreHistoryValues(backupBatch, device, totalSizeRestore, destFolder, restoredInDiffPath, restoreHistoy, destDevice, isSearch);
                    if (null != fileName) {
                        restoreHistoy.setPstRestore(true);
                        restoreHistoy.setPstFileName(fileName);
                        restoreHistoy.setNoOfFiles(backupBatch.getUploadedFiles().split("/").length > 0 ? Long.parseLong(backupBatch.getUploadedFiles().split("/")[0]) : 0L);
                        restoreHistoy.setRestoredSize(backupBatch.getUploadedSize());
                    }
                    this.utilServiceObj.saveRestoreHistory(cloudId, restoreHistoy);
                }
            } else if (device == null && isSearch) {
                if (backupBatch.getId() != null) {
                    RestoreHistory history = this.utilServiceObj.getRestoreHistoryById(cloudId, backupBatch.getId());
                    if (history == null) {
                        BeanUtils.copyProperties((Object)backupBatch, (Object)restoreHistoy);
                        if (!StringUtils.isEmpty((String)restoreFolder)) {
                            restoreHistoy.setRestoreFolder(restoreFolder);
                        }
                        this.updateRestoreHistoryValuesForPst(backupBatch, totalSizeRestore, destFolder, restoredInDiffPath, restoreHistoy, user1);
                        if (null != fileName) {
                            restoreHistoy.setPstRestore(true);
                            restoreHistoy.setPstFileName(fileName);
                            this.utilServiceObj.saveRestoreHistory(cloudId, restoreHistoy);
                        } else {
                            this.sendEmailForRestore(cloudId, device, cloudName, notifierEmailBodyElement, user1, destDevice, restoreHistoy.getRestoreByUserName());
                            this.utilServiceObj.saveRestoreHistory(cloudId, restoreHistoy);
                        }
                    } else {
                        logger.debug("......restore history already exists :" + String.valueOf(backupBatch.getId()) + "...." + backupBatch.getStatus());
                        history.setDestFolder(destFolder);
                        restoreHistoy.setRestoredInDiffPath(restoredInDiffPath);
                        if (null != fileName) {
                            restoreHistoy.setPstRestore(true);
                            restoreHistoy.setPstFileName(fileName);
                        }
                        this.utilServiceObj.saveRestoreHistory(cloudId, history);
                    }
                } else {
                    BeanUtils.copyProperties((Object)backupBatch, (Object)restoreHistoy);
                    this.updateRestoreHistoryValuesForPst(backupBatch, totalSizeRestore, destFolder, restoredInDiffPath, restoreHistoy, user1);
                    if (null != fileName) {
                        restoreHistoy.setPstRestore(true);
                        restoreHistoy.setPstFileName(fileName);
                    }
                    this.utilServiceObj.saveRestoreHistory(cloudId, restoreHistoy);
                }
            }
        }
        catch (Exception e) {
            logger.error("Error failed to saveRestoreHistory e={}", (Throwable)e);
        }
    }

    private void sendEmailForRestore(int cloudId, Device device, String cloudName, NotifierEmailBodyElement notifierEmailBodyElement, com.parablu.pcbd.domain.User user1, Device destDevice, String actionBy) {
        try {
            String userName = user1.getUserName();
            logger.debug(device.getUserName() + "...start mail restore... " + userName);
            String emailId = user1.getEmailId();
            String actionOn = device.getUserName();
            notifierEmailBodyElement.setRestoreDeviceName(device.getDeviceName());
            notifierEmailBodyElement.setNotifyAllAdmins(true);
            notifierEmailBodyElement.setUserName(userName);
            notifierEmailBodyElement.setCloudId(cloudId);
            notifierEmailBodyElement.setCloudName(cloudName);
            notifierEmailBodyElement.setDeviceName(destDevice.getDeviceName());
            if (!device.getUserName().equalsIgnoreCase(userName)) {
                com.parablu.pcbd.domain.User user = this.utilServiceObj.getUserInfoByName(cloudId, device.getUserName());
                emailId = user.getEmailId();
            }
            notifierEmailBodyElement.setUserName(userName);
            this.sendEmail("restore-initiated", actionOn, actionBy, emailId, notifierEmailBodyElement, device.getDeviceUUID());
            logger.debug(userName + "...end mail restore... " + emailId);
        }
        catch (Exception e) {
            logger.error("error trying to send mail .." + e.getMessage());
        }
    }

    private void updateRestoreHistoryValuesForPst(BackupBatch backupBatch, String totalSizeRestore, String destFolder, boolean restoredInDiffPath, RestoreHistory restoreHistoy, com.parablu.pcbd.domain.User user1) {
        restoreHistoy.setUserName(user1.getUserName());
        restoreHistoy.setDeviceName("Global Search (Microsoft Exchange)");
        restoreHistoy.setDeviceUUID("Global Search (Microsoft Exchange)");
        restoreHistoy.setRestoreByDeviceName(backupBatch.getUserName());
        restoreHistoy.setRestoreByUserName(backupBatch.getUserName());
        List<String> restoreByDeviceUUID = this.utilServiceObj.getAllDeviceByUserName(1, user1.getUserName());
        if (restoreByDeviceUUID != null && restoreByDeviceUUID.size() > 0) {
            restoreHistoy.setRestoreByDeviceUUID(restoreByDeviceUUID.get(0));
        } else {
            restoreHistoy.setRestoreByDeviceUUID(backupBatch.getUserName());
        }
        restoreHistoy.setRestoredSize(totalSizeRestore);
        restoreHistoy.setDestFolder(destFolder);
        restoreHistoy.setRestoredInDiffPath(restoredInDiffPath);
    }

    private List<BackUpImage> getFilteredBackupImageListByGroupingForMail(List<BackUpImage> backUpImages, boolean restoreDeletedFiles) {
        logger.debug(restoreDeletedFiles + "...Inside grouping backup images..." + backUpImages.size());
        List<Object> folderBackUpImages = new ArrayList();
        folderBackUpImages = backUpImages.stream().filter(f -> f.isFolder()).collect(Collectors.toList());
        List<Object> fileBackUpImages = new ArrayList();
        fileBackUpImages = backUpImages.stream().filter(f -> !f.isFolder()).collect(Collectors.toList());
        backUpImages = fileBackUpImages;
        Comparator<BackUpImage> compareByName = new Comparator<BackUpImage>(this){

            @Override
            public int compare(BackUpImage o1, BackUpImage o2) {
                return o1.getFileName().compareTo(o2.getFileName());
            }
        };
        Map<String, List<BackUpImage>> foldermap = folderBackUpImages.stream().filter(p -> p.isFolder()).collect(Collectors.groupingBy(BackUpImage::getFileName));
        ArrayList filteredFolderBackUpImages = new ArrayList();
        foldermap.entrySet().stream().forEach(p -> filteredFolderBackUpImages.add(((List)p.getValue()).stream().sorted(Comparator.comparing(BackUpImage::getLastServerModifiedTime).reversed()).findFirst().get()));
        ArrayList<BackUpImage> filteredfolderBackUpImages = new ArrayList<BackUpImage>();
        ArrayList<BackUpImage> delefolderBackUpImages = new ArrayList<BackUpImage>();
        for (BackUpImage filteredBackUpImage : filteredFolderBackUpImages) {
            if (filteredBackUpImage.isPresent()) {
                filteredfolderBackUpImages.add(filteredBackUpImage);
                continue;
            }
            delefolderBackUpImages.add(filteredBackUpImage);
        }
        Collections.sort(filteredfolderBackUpImages, compareByName);
        ArrayList filteredBackUpImages = new ArrayList();
        ArrayList<BackUpImage> filteredBackUpImagesList = new ArrayList<BackUpImage>();
        ArrayList deltedBackUpImages = new ArrayList();
        ArrayList<BackUpImage> deletedBackUpImagesList = new ArrayList<BackUpImage>();
        Map<String, List<BackUpImage>> map = backUpImages.stream().filter(p -> p.getDevicePath() != null).collect(Collectors.groupingBy(BackUpImage::getOdItemId));
        int i = 0;
        map.entrySet().stream().forEach(p -> filteredBackUpImages.add(((List)p.getValue()).stream().sorted(Comparator.comparing(BackUpImage::getLastServerModifiedTime).reversed()).findFirst().get()));
        for (BackUpImage filteredBackUpImage : filteredBackUpImages) {
            if (filteredBackUpImage.isPresent()) {
                ++i;
                filteredBackUpImagesList.add(filteredBackUpImage);
                continue;
            }
            deletedBackUpImagesList.add(filteredBackUpImage);
        }
        logger.debug(deletedBackUpImagesList.size() + "...filtered list ..." + filteredBackUpImagesList.size());
        if (restoreDeletedFiles) {
            backUpImages.stream().filter(p -> p.getDevicePath() == null).collect(Collectors.toList()).stream().collect(Collectors.groupingBy(BackUpImage::getFileName)).entrySet().stream().forEach(p -> deltedBackUpImages.add(((List)p.getValue()).stream().sorted(Comparator.comparing(BackUpImage::getLastServerModifiedTime).reversed()).findFirst().orElse(null)));
            Map<String, Map<String, List<BackUpImage>>> map1 = backUpImages.stream().filter(p -> p.getDevicePath() != null).collect(Collectors.groupingBy(BackUpImage::getDevicePath, Collectors.groupingBy(BackUpImage::getOdItemId)));
            for (Map.Entry<String, Map<String, List<BackUpImage>>> entry : map1.entrySet()) {
                entry.getValue().entrySet().stream().forEach(p -> deltedBackUpImages.add(((List)p.getValue()).stream().sorted(Comparator.comparing(BackUpImage::getLastServerModifiedTime).reversed()).findFirst().orElse(null)));
            }
            logger.debug(deltedBackUpImages.size() + "...delelted..." + deletedBackUpImagesList.size());
            block3: for (BackUpImage bkpimage : deletedBackUpImagesList) {
                for (BackUpImage bkpimage1 : deltedBackUpImages) {
                    if (bkpimage1 == null) continue;
                    if (StringUtils.isEmpty((String)bkpimage1.getFileName())) {
                        bkpimage1.setFileName("");
                    }
                    if (StringUtils.isEmpty((String)bkpimage.getFileName())) {
                        bkpimage.setFileName("");
                    }
                    if (StringUtils.isEmpty((String)bkpimage1.getDevicePath())) {
                        bkpimage1.setDevicePath("");
                    }
                    if (StringUtils.isEmpty((String)bkpimage.getDevicePath())) {
                        bkpimage.setDevicePath("");
                    }
                    if (!bkpimage.getFileName().equals(bkpimage1.getFileName()) || !bkpimage.getDevicePath().equals(bkpimage1.getDevicePath())) continue;
                    bkpimage1.setPresent(false);
                    filteredBackUpImagesList.add(bkpimage1);
                    continue block3;
                }
            }
        }
        filteredBackUpImagesList.stream().sorted(Comparator.comparing(MailInfo::getSentDate, Comparator.nullsLast(Comparator.reverseOrder())));
        ArrayList<BackUpImage> overAllList = new ArrayList<BackUpImage>();
        overAllList.addAll(filteredfolderBackUpImages);
        overAllList.addAll(filteredBackUpImagesList);
        return overAllList;
    }

    private int getBatchErrorCode(int cloudId, String batchId) {
        BackupBatch pbBkpBatch = this.utilServiceObj.getBackupBatchById(cloudId, batchId);
        int errorCode = 0;
        if (pbBkpBatch != null && StringUtils.isNotEmpty((String)pbBkpBatch.getErrorCode()) && (pbBkpBatch.getErrorCode().equals(STOPPED_BACKUP_ERROR_CODE) || pbBkpBatch.getErrorCode().equals(PAUSED_BACKUP_ERROR_CODE))) {
            errorCode = pbBkpBatch.getErrorCode().equals(STOPPED_BACKUP_ERROR_CODE) ? Integer.parseInt(STOPPED_BACKUP_ERROR_CODE) : Integer.parseInt(PAUSED_BACKUP_ERROR_CODE);
        }
        return errorCode;
    }

    void saveRestoreProgress(int cloudId, Device device, String actionBy, String batchId, int totalNoOfFilesForRestore, long restoredFiles, String pstBatchId) {
        RestoreProgressEvents restoreProgressEvents = null;
        restoreProgressEvents = device != null ? this.utilServiceObj.getRestoreProgresByDeviceUUID(cloudId, device.getDeviceUUID(), actionBy) : this.utilServiceObj.getRestoreProgresByDeviceUUID(cloudId, pstBatchId, actionBy);
        if (restoreProgressEvents == null) {
            restoreProgressEvents = new RestoreProgressEvents();
        } else {
            restoreProgressEvents.setId(restoreProgressEvents.getId());
        }
        logger.debug("......existingrestoreprogress...." + String.valueOf(restoreProgressEvents.getId()));
        restoreProgressEvents.setTotalNoOfFilesForRestore((long)totalNoOfFilesForRestore);
        if (null == device) {
            restoreProgressEvents.setDeviceUUID(pstBatchId);
        } else {
            restoreProgressEvents.setDeviceUUID(device.getDeviceUUID());
        }
        restoreProgressEvents.setUserName(actionBy);
        restoreProgressEvents.setRestoredFiles(restoredFiles);
        restoreProgressEvents.setBatchId(batchId);
        this.utilServiceObj.saveRestoreProgressForDevice(cloudId, restoreProgressEvents);
    }

    private Map<String, String> getExistingFolders(ExchangeService service, String userMail, boolean inplace) {
        EWSAppSetting appSetting = this.utilServiceObj.getEwsAppSettingDetail(1);
        this.getEWSAccesToken(appSetting, false);
        String token = this.ewsToken;
        service = OfficeRestoreService.getAuthenticatedService(token, userMail);
        HashMap<String, String> folderMap = new HashMap();
        boolean success = true;
        int retry = 0;
        do {
            try {
                Folder contactsFolder;
                success = true;
                inplace = false;
                if (inplace) {
                    folderMap = OfficeRestoreService.addInPlaceArchiveFolders(service, userMail);
                }
                FolderView folderView = new FolderView(100);
                FolderId folderIds = new FolderId(WellKnownFolderName.MsgFolderRoot, new Mailbox(userMail));
                folderView.setTraversal(FolderTraversal.Deep);
                logger.debug("...before finding the folders");
                FindFoldersResults findFolders = service.findFolders(folderIds, new FolderView(Integer.MAX_VALUE));
                logger.debug("After finding the folders...");
                try {
                    contactsFolder = Folder.bind((ExchangeService)service, (WellKnownFolderName)WellKnownFolderName.Contacts);
                    folderMap.put(contactsFolder.getId().getUniqueId(), "Contacts");
                }
                catch (Exception e) {
                    logger.error("....unable to get contact folder for user......" + userMail);
                }
                try {
                    contactsFolder = Folder.bind((ExchangeService)service, (WellKnownFolderName)WellKnownFolderName.Calendar);
                    folderMap.put(contactsFolder.getId().getUniqueId(), "Calendar");
                }
                catch (Exception e) {
                    logger.error("....unable to get contact folder for user......" + userMail);
                }
                for (Folder folder : findFolders.getFolders()) {
                    String parentName;
                    Object folderName = folder.getDisplayName();
                    if (((String)folderName).equalsIgnoreCase("Calendar") || ((String)folderName).equalsIgnoreCase("Contacts") || ((String)folderName).equalsIgnoreCase("Yammer Root")) continue;
                    if (folder.getParentFolderId() != null && !StringUtils.isEmpty((String)(parentName = (String)folderMap.get(folder.getParentFolderId().getUniqueId())))) {
                        folderName = parentName + "/" + (String)folderName;
                    }
                    folderMap.put(folder.getId().getUniqueId(), (String)folderName);
                    OfficeRestoreService.findAllSubFoldersList(service, folder.getId(), (String)folderName, folderMap);
                }
            }
            catch (ServiceLocalException ee) {
                ee.printStackTrace();
                logger.error("....error in getting existing folders...." + ee.getMessage());
            }
            catch (ServiceRequestException e) {
                logger.error(" service request Error ", (Throwable)e);
                this.ewsToken = null;
                success = false;
                ++retry;
                this.getEWSAccesToken(appSetting, true);
                token = this.ewsToken;
                service = OfficeRestoreService.getAuthenticatedService(token, userMail);
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error(userMail + "... ERRORR...... " + e.getMessage());
                if (!e.getMessage().contains("The SMTP address has no mailbox associated with it")) continue;
                return folderMap;
            }
        } while (!success && retry <= 2);
        return folderMap;
    }

    private static void findAllSubFoldersList(ExchangeService service, FolderId parentFolderId, String parentPath, Map<String, String> existingFolders) {
        try {
            FindFoldersResults foundFolders = service.findFolders(parentFolderId, new FolderView(Integer.MAX_VALUE));
            for (Folder subFolder : foundFolders) {
                Object path = parentPath + "/" + subFolder.getDisplayName();
                for (int i = 0; i < 15; ++i) {
                    if (!((String)path).startsWith("/")) continue;
                    path = ((String)path).replaceFirst("/", "");
                }
                existingFolders.put(subFolder.getId().getUniqueId(), (String)path);
                OfficeRestoreService.findAllSubFoldersList(service, subFolder.getId(), (String)path, existingFolders);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void findAllSubFolders(ExchangeService service, FolderId parentFolderId, String parentPath, Map<String, String> existingFolders) {
        try {
            FindFoldersResults foundFolders = service.findFolders(parentFolderId, new FolderView(Integer.MAX_VALUE));
            for (Folder subFolder : foundFolders) {
                String path = parentPath + "/" + subFolder.getDisplayName();
                existingFolders.put(subFolder.getId().getUniqueId(), "In-Place Archive/" + path);
                OfficeRestoreService.findAllSubFolders(service, subFolder.getId(), path, existingFolders);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void updateRestoreHistoryValues(BackupBatch backupBatch, Device device, String totalSizeRestore, String destFolder, boolean restoredInDiffPath, RestoreHistory restoreHistoy, Device destDevice, boolean isSearch) {
        restoreHistoy.setUserName(device.getUserName());
        if (!isSearch) {
            restoreHistoy.setDeviceName(device.getDeviceName());
        } else {
            restoreHistoy.setDeviceName(device.getDeviceName() + " [Device Search]");
        }
        restoreHistoy.setDeviceUUID(device.getDeviceUUID());
        restoreHistoy.setRestoreByDeviceName(backupBatch.getUserName());
        restoreHistoy.setRestoreByUserName(backupBatch.getUserName());
        restoreHistoy.setRestoreByDeviceUUID(backupBatch.getUserName());
        restoreHistoy.setRestoredSize(totalSizeRestore);
        restoreHistoy.setDestFolder(destFolder);
        restoreHistoy.setRestoredInDiffPath(restoredInDiffPath);
    }

    private boolean isInPlaceArchiveBackupEnabled(List<CloudCustomisableDetails> licenseDetails) {
        boolean isInPlaceArchiveBackupEnabled = false;
        for (CloudCustomisableDetails license : licenseDetails) {
            if (license == null || !"In-Place Archive Enabled".equalsIgnoreCase(license.getName())) continue;
            isInPlaceArchiveBackupEnabled = true;
            break;
        }
        return isInPlaceArchiveBackupEnabled;
    }

    private static Map<String, String> addInPlaceArchiveFolders(ExchangeService service, String userMail) {
        HashedMap existingFolders = new HashedMap();
        Mailbox userMailbox = new Mailbox(userMail);
        String uniqId = "";
        try {
            Folder archfolder = Folder.bind((ExchangeService)service, (WellKnownFolderName)WellKnownFolderName.ArchiveMsgFolderRoot);
            uniqId = archfolder.getId().getUniqueId();
            existingFolders.put(uniqId, IN_PLACE_ARCHIVE);
            FolderId folderId = new FolderId(WellKnownFolderName.ArchiveMsgFolderRoot, userMailbox);
            FindFoldersResults inPlaceFolders = service.findFolders(folderId, new FolderView(Integer.MAX_VALUE));
            for (Folder folder : inPlaceFolders.getFolders()) {
                if (StringUtils.isEmpty((String)folder.getDisplayName()) || "PersonMetadata".equalsIgnoreCase(folder.getDisplayName()) || "Tasks".equalsIgnoreCase(folder.getDisplayName()) || "Calendar".equalsIgnoreCase(folder.getDisplayName())) continue;
                String folderPath = "In-Place Archive/" + folder.getDisplayName();
                existingFolders.put(folder.getId().getUniqueId(), folderPath);
                OfficeRestoreService.findAllSubFolders(service, folder.getId(), folder.getDisplayName(), (Map<String, String>)existingFolders);
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        return existingFolders;
    }

    private void createFoldersInMail(ExchangeService service, Map<String, String> existingFolders, String exiFolder, String userMail, boolean isInplace) {
        logger.debug("..... aaa-exiFolder.... " + exiFolder);
        Path pathsp = Paths.get(exiFolder, new String[0]);
        String[] paths = (String[])StreamSupport.stream(pathsp.spliterator(), false).map(Path::toString).toArray(String[]::new);
        Object checkPath = "";
        boolean isParent = false;
        EWSAppSetting appSetting = this.utilServiceObj.getEwsAppSettingDetail(1);
        this.getEWSAccesToken(appSetting, false);
        String token = this.ewsToken;
        service = OfficeRestoreService.getAuthenticatedService(token, userMail);
        for (String folPath : paths) {
            logger.debug((String)checkPath + "..... aaa .... " + folPath);
            if (!StringUtils.isEmpty((String)checkPath)) {
                checkPath = (String)checkPath + "/" + folPath;
            } else {
                checkPath = folPath;
                isParent = true;
            }
            boolean pathExists = existingFolders.containsValue(checkPath);
            logger.debug((String)checkPath + ".....pathexists.... " + pathExists);
            if (!pathExists) {
                try {
                    existingFolders = new HashMap<String, String>();
                    existingFolders = this.getExistingFolders(service, userMail, isInplace);
                    pathExists = existingFolders.containsValue(checkPath);
                    if (pathExists) continue;
                    if (isParent) {
                        logger.debug("....parent....." + (String)checkPath);
                        Folder folder = new Folder(service);
                        folder.setDisplayName(((String)checkPath).replaceAll("/", ""));
                        Mailbox userMailboxObj = new Mailbox(userMail);
                        FolderId parentId = new FolderId(WellKnownFolderName.MsgFolderRoot, userMailboxObj);
                        service.createFolder(folder, parentId);
                    } else {
                        String parentpath = ((String)checkPath).substring(0, ((String)checkPath).lastIndexOf(47));
                        String child = ((String)checkPath).substring(((String)checkPath).lastIndexOf("/"));
                        logger.debug(parentpath + "....child....." + child);
                        logger.debug(parentpath + "..parentpathandchild.." + child);
                        logger.debug(parentpath + "..parentpathandchild22.." + child);
                        Folder folder = new Folder(service);
                        folder.setDisplayName(child.replaceAll("/", ""));
                        FolderId parentId = new FolderId();
                        String keyFromValue = OfficeRestoreService.getKeyFromValue(existingFolders, parentpath);
                        logger.debug(child + "...createdfolder....." + parentpath + child);
                        logger.debug(keyFromValue + "...wait for 20 sec...");
                        parentId.setUniqueId(keyFromValue);
                        service.createFolder(folder, parentId);
                        logger.debug("...createdfolder1....." + parentpath + child);
                        logger.debug("...wait for 20 sec...");
                    }
                    Thread.sleep(20000L);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                    if (e1.getMessage().contains("The remote server returned an error: (401)Unauthorized")) {
                        this.getEWSAccesToken(appSetting, true);
                        token = this.ewsToken;
                        service = OfficeRestoreService.getAuthenticatedService(token, userMail);
                    }
                    if (e1.getMessage().contains("The SMTP address has no mailbox associated with it")) break;
                    logger.error("... ERRORR...... " + e1.getMessage());
                }
            }
            isParent = false;
        }
    }

    static String getUniquePath(String path, String extension) {
        int i = 1;
        String newPath = path + extension;
        if (new File(newPath).exists()) {
            while (new File(newPath).exists()) {
                newPath = path + "(" + i + ")" + extension;
                ++i;
            }
        }
        return newPath;
    }

    private void initiateBrowserDownload(Cloud cloud, RestoreEvents restoreEvents) {
        DownloadFileTO downloadFileTO = this.getDownloadFileTOFromRestoreEvents(restoreEvents, cloud.getCloudName());
        BackupBatch backupBatch = new BackupBatch();
        BeanUtils.copyProperties((Object)restoreEvents, (Object)backupBatch);
        backupBatch.setId(restoreEvents.getId());
        backupBatch.setUserName(restoreEvents.getActionBy());
        backupBatch.setDeviceUUID(restoreEvents.getActionOnDeviceUUID());
        backupBatch.setDeviceName("File Download");
        this.startBackupBatch(backupBatch, cloud, 0);
        this.saveRestoreProgress(cloud.getCloudId(), restoreEvents.getActionOnDeviceUUID(), null, restoreEvents.getActionBy(), restoreEvents.getId().toString(), 0, 0L);
        if (!downloadFileTO.isFolder()) {
            this.downloadService.downloadBackupFileForPortal(downloadFileTO, cloud, cloud.getCloudName(), null, null, false);
        } else {
            this.downloadService.downloadBackupFolderForPortal(downloadFileTO, cloud, null, null, restoreEvents.isRestoreDeletedFiles(), false);
        }
        this.utilServiceObj.updateBackupBatch(cloud.getCloudId(), restoreEvents.getId(), COMPLETED, 0);
        this.utilServiceObj.deleteRestoreEventForPst(cloud.getCloudId(), restoreEvents.getId());
        this.utilServiceObj.removeBackupBatch(cloud.getCloudId(), restoreEvents.getId());
        NotifierEmailBodyElement notifierEmailBodyElement = new NotifierEmailBodyElement(this);
        notifierEmailBodyElement.setNotifyAllAdmins(false);
        notifierEmailBodyElement.setUserName(downloadFileTO.getUserName());
        notifierEmailBodyElement.setCloudId(cloud.getCloudId());
        notifierEmailBodyElement.setCloudName(cloud.getCloudName());
        notifierEmailBodyElement.setDeviceName(downloadFileTO.getSourceDeviceName());
        String fileName = downloadFileTO.getFileName();
        Object folderName = downloadFileTO.getFilePath();
        if (!StringUtils.isEmpty((String)fileName)) {
            folderName = (String)folderName + "/" + fileName;
        }
        notifierEmailBodyElement.setRestoreFolder((String)folderName);
        String action = "Download-Completed";
        this.sendEmailForBrowserDownload(action, downloadFileTO.getUserName(), downloadFileTO.getActionBy(), "", notifierEmailBodyElement, downloadFileTO.getDeviceUUID());
    }

    private DownloadFileTO getDownloadFileTOFromRestoreEvents(RestoreEvents request, String cloudName) {
        DownloadFileTO downloadFileTO = new DownloadFileTO();
        String filePath = request.getFileInfo().getFilePath();
        if (!StringUtils.isEmpty((String)filePath) && !filePath.startsWith("null")) {
            filePath = OfficeRestoreService.decodeBase64UTFString(filePath);
        }
        String userName = request.getUserName();
        String fileName = request.getFileInfo().getFileName();
        if (!StringUtils.isEmpty((String)fileName)) {
            fileName = OfficeRestoreService.decodeBase64UTFString(request.getFileInfo().getFileName());
        }
        downloadFileTO.setBackupID(request.getFileInfo().getId());
        downloadFileTO.setDeviceUUID(request.getActionOnDeviceUUID());
        downloadFileTO.setFolder(request.getFileInfo().isFolder());
        downloadFileTO.setSync(request.getFileInfo().isSync());
        downloadFileTO.setCloudName(cloudName);
        downloadFileTO.setFileName(fileName);
        downloadFileTO.setFilePath(filePath);
        downloadFileTO.setUserName(userName);
        downloadFileTO.setActionType("download");
        downloadFileTO.setActionBy(request.getActionBy());
        downloadFileTO.setMoveToDownloads(true);
        return downloadFileTO;
    }

    private void sendEmailForFileDownloadCompletion(int cloudId, Device device, String cloudName, NotifierEmailBodyElement notifierEmailBodyElement, com.parablu.pcbd.domain.User user1, Device destDevice, String actionBy, BackupBatch backupBatch) {
        try {
            String userName = user1.getUserName();
            logger.debug(device.getUserName() + "...start mail restore... " + userName);
            String emailId = user1.getEmailId();
            String actionOn = device.getUserName();
            notifierEmailBodyElement.setRestoreDeviceName(device.getDeviceName());
            notifierEmailBodyElement.setNotifyAllAdmins(true);
            notifierEmailBodyElement.setUserName(userName);
            notifierEmailBodyElement.setCloudId(cloudId);
            notifierEmailBodyElement.setCloudName(cloudName);
            notifierEmailBodyElement.setDeviceName(destDevice.getDeviceName());
            if (backupBatch.getBatchStartTimestamp() > 0L) {
                notifierEmailBodyElement.setBatchStartTimestamp(backupBatch.getBatchStartTimestamp());
            } else {
                notifierEmailBodyElement.setBatchStartTimestamp(System.currentTimeMillis());
            }
            logger.debug(notifierEmailBodyElement.getBatchStartTimestamp() + "...timestamp..." + backupBatch.getBatchStartTimestamp());
            if (!device.getUserName().equalsIgnoreCase(userName)) {
                com.parablu.pcbd.domain.User user = this.utilServiceObj.getUserInfoByName(cloudId, device.getUserName());
                emailId = user.getEmailId();
            }
            boolean isSharePoint = false;
            if (!StringUtils.isEmpty((String)device.getDeviceType()) && device.getDeviceType().equalsIgnoreCase(Device.TYPE.SHAREPOINT.name())) {
                isSharePoint = true;
            }
            notifierEmailBodyElement.setUserName(userName);
            String action = "restore-initiated";
            if (isSharePoint) {
                action = "site-restore-initiated";
                this.sendSPEmail(action, actionOn, actionBy, emailId, notifierEmailBodyElement, action, destDevice.getUserName(), device.getUserName());
            } else {
                this.sendEmail(action, actionOn, actionBy, emailId, notifierEmailBodyElement, device.getDeviceUUID());
            }
            logger.debug(userName + "...end mail restore... " + emailId);
        }
        catch (Exception e) {
            logger.error("error trying to send mail .." + e.getMessage());
        }
    }

    private void sendEmailForBrowserDownload(String action, String actionOn, String actionBy, String emailId, NotifierEmailBodyElement bodyElement, String deviceUUID) {
        try {
            String url = PCHelperConstant.getPropertyFileValueForParacloudUrl().trim() + "/paracloud/cloud/" + bodyElement.getCloudName() + "/mail";
            logger.debug(bodyElement.getDeviceName() + ".. first email url with dev details s...." + url);
            CloseableHttpClient httpclient = HttpClientUtil.getSSlConnection();
            HttpPost httpPost = new HttpPost(url);
            httpPost.setHeader("Content-Type", (Object)"application/json");
            httpPost.setHeader("isInternalCall", (Object)"true");
            JSONObject emailDetails = new JSONObject();
            emailDetails.put("actionBy", (Object)actionBy);
            emailDetails.put("action", (Object)action);
            emailDetails.put("actionOn", (Object)actionOn);
            emailDetails.put("toUser", true);
            emailDetails.put("deviceUUID", (Object)deviceUUID);
            emailDetails.put("fileName", (Object)bodyElement.getRestoreFolder());
            emailDetails.put("deviceName", (Object)String.valueOf(bodyElement.getDeviceName()));
            emailDetails.put("toAdmins", false);
            StringEntity params = new StringEntity(emailDetails.toString());
            httpPost.setEntity((HttpEntity)params);
            HttpResponse response = httpclient.execute((ClassicHttpRequest)httpPost);
            logger.debug(actionBy + "..Send mail result status code :", (Object)response);
        }
        catch (IOException e) {
            logger.trace(String.valueOf(e));
            logger.error("Exception :", (Object)e.getMessage());
        }
    }

    static {
        logger = LogManager.getLogger(OfficeRestoreService.class);
        batchList = null;
    }

    class NotifierEmailBodyElement {
        private int cloudId;
        private String cloudName;
        private String userName;
        private String deviceName;
        private String restoreDeviceName;
        private String restoreFolder;
        private String noOfFilesBackedUp;
        private String totalBackupSize;
        private boolean notifyAllAdmins;
        private long batchStartTimestamp;
        private long batchEndTimestamp;

        NotifierEmailBodyElement(OfficeRestoreService this$0) {
        }

        public long getBatchStartTimestamp() {
            return this.batchStartTimestamp;
        }

        public void setBatchStartTimestamp(long batchStartTimestamp) {
            this.batchStartTimestamp = batchStartTimestamp;
        }

        public long getBatchEndTimestamp() {
            return this.batchEndTimestamp;
        }

        public void setBatchEndTimestamp(long batchEndTimestamp) {
            this.batchEndTimestamp = batchEndTimestamp;
        }

        public String getDeviceName() {
            return this.deviceName;
        }

        public void setDeviceName(String deviceName) {
            this.deviceName = deviceName;
        }

        public String getRestoreDeviceName() {
            return this.restoreDeviceName;
        }

        public void setRestoreDeviceName(String restoreDeviceName) {
            this.restoreDeviceName = restoreDeviceName;
        }

        public String getRestoreFolder() {
            return this.restoreFolder;
        }

        public void setRestoreFolder(String restoreFolder) {
            this.restoreFolder = restoreFolder;
        }

        public String getTotalBackupSize() {
            return this.totalBackupSize;
        }

        public void setTotalBackupSize(String totalBackupSize) {
            this.totalBackupSize = totalBackupSize;
        }

        public String getNoOfFilesBackedUp() {
            return this.noOfFilesBackedUp;
        }

        public void setNoOfFilesBackedUp(String noOfFilesBackedUp) {
            this.noOfFilesBackedUp = noOfFilesBackedUp;
        }

        public boolean isNotifyAllAdmins() {
            return this.notifyAllAdmins;
        }

        public void setNotifyAllAdmins(boolean notifyAllAdmins) {
            this.notifyAllAdmins = notifyAllAdmins;
        }

        public String getUserName() {
            return this.userName;
        }

        public void setUserName(String userName) {
            this.userName = userName;
        }

        public int getCloudId() {
            return this.cloudId;
        }

        public void setCloudId(int cloudId) {
            this.cloudId = cloudId;
        }

        public String getCloudName() {
            return this.cloudName;
        }

        public void setCloudName(String cloudName) {
            this.cloudName = cloudName;
        }
    }
}

