/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.bp.service.impl;

import com.parablu.bp.service.NotificationsService;
import com.parablu.paracloud.element.NotificationsTypeElement;
import com.parablu.pcbd.dao.BackupPolicyDao;
import com.parablu.pcbd.dao.NotificationsDao;
import com.parablu.pcbd.dao.UserDao;
import com.parablu.pcbd.domain.BackupPolicy;
import com.parablu.pcbd.domain.Notifications;
import com.parablu.pcbd.domain.NotificationsType;
import com.parablu.pcbd.domain.User;
import com.parablu.pcsd.dao.SyncPolicyDao;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class NotificationsServiceImpl
implements NotificationsService {
    private static Logger logger = LogManager.getLogger(NotificationsServiceImpl.class);
    @Resource
    private NotificationsDao notificationsDao;
    @Resource
    private BackupPolicyDao backupPolicyDao;
    @Resource
    private SyncPolicyDao syncPolicyDao;
    @Resource
    private UserDao userDao;

    public NotificationsDao getNotificationsDao() {
        return this.notificationsDao;
    }

    public void setNotificationsDao(NotificationsDao notificationsDao) {
        this.notificationsDao = notificationsDao;
    }

    public BackupPolicyDao getBackupPolicyDao() {
        return this.backupPolicyDao;
    }

    public void setBackupPolicyDao(BackupPolicyDao backupPolicyDao) {
        this.backupPolicyDao = backupPolicyDao;
    }

    @Override
    public void saveNotificationsType(int cloudId, String cloudName, NotificationsTypeElement notificationsTypeElement) {
        NotificationsType notificationsType = new NotificationsType();
        BeanUtils.copyProperties((Object)notificationsTypeElement, (Object)notificationsType);
        this.notificationsDao.saveNotificationsType(cloudId, cloudName, notificationsType);
    }

    @Override
    public NotificationsTypeElement getNotifications(int cloudId, String cloudName) {
        NotificationsTypeElement notificationsTypeElement = new NotificationsTypeElement();
        NotificationsType notificationsType = this.notificationsDao.getNotifications(cloudId, cloudName);
        notificationsTypeElement.setNotificationsType(notificationsType.getNotificationsType());
        List backupPolicies = this.backupPolicyDao.getAllBackupPolicies(cloudId);
        notificationsTypeElement = this.getPolicyNames(backupPolicies, notificationsTypeElement);
        return notificationsTypeElement;
    }

    private NotificationsTypeElement getPolicyNames(List<BackupPolicy> backupPolicies, NotificationsTypeElement notificationsTypeElement) {
        ArrayList<String> policyNamesList = new ArrayList<String>();
        for (BackupPolicy policy : backupPolicies) {
            String policyName = policy.getPolicyName();
            policyNamesList.add(policyName);
        }
        notificationsTypeElement.setPolicyNames(policyNamesList);
        return notificationsTypeElement;
    }

    @Override
    public void saveNotifications(int cloudId, String cloudName, NotificationsTypeElement notificationsTypeElement) {
        Notifications notifications = new Notifications();
        BeanUtils.copyProperties((Object)notificationsTypeElement, (Object)notifications);
        this.notificationsDao.saveNotifications(cloudId, cloudName, notifications);
    }

    @Override
    public NotificationsTypeElement getusersListForPolicy(int cloudId, String cloudName, String policyName, String policyType) {
        NotificationsTypeElement notificationsTypeElement = new NotificationsTypeElement();
        List userList = "backupPolicy".equalsIgnoreCase(policyType) ? this.userDao.getUsersByBackupPolicyName(cloudId, policyName) : this.userDao.getUsersBySyncPolicyName(cloudId, policyName);
        ArrayList<String> userNames = new ArrayList<String>();
        if (userList != null) {
            for (User user : userList) {
                userNames.add(user.getUserName());
            }
            notificationsTypeElement.setUserNames(userNames);
            return notificationsTypeElement;
        }
        logger.debug("inside policy mapping null^^^^^^^^^^^^^^^^");
        return null;
    }

    @Override
    public List<NotificationsTypeElement> getSavedNotifications(int cloudId, String cloudName) {
        List notifications = this.notificationsDao.getSavedNotifications(cloudId, cloudName);
        ArrayList<NotificationsTypeElement> notificationsTypeElements = new ArrayList<NotificationsTypeElement>();
        for (Notifications notification : notifications) {
            NotificationsTypeElement notificationsTypeElement = new NotificationsTypeElement();
            BeanUtils.copyProperties((Object)notification, (Object)notificationsTypeElement);
            notificationsTypeElement.setId(notification.getId().toString());
            notificationsTypeElements.add(notificationsTypeElement);
        }
        return notificationsTypeElements;
    }

    @Override
    public void updateNotification(int cloudId, String cloudName, String notificationId, NotificationsTypeElement notificationsTypeElement) {
        Notifications notifications = new Notifications();
        BeanUtils.copyProperties((Object)notificationsTypeElement, (Object)notifications);
        this.notificationsDao.updateNotification(cloudId, cloudName, notificationId, notifications);
    }

    @Override
    public void deleteSavedNotificationsById(int cloudId, String cloudName, String notificationsId) {
        this.notificationsDao.deleteNotification(cloudId, cloudName, notificationsId);
    }

    @Override
    public NotificationsTypeElement getSavedNotificationsForId(int cloudId, String cloudName, String notificationId) {
        NotificationsTypeElement notificationsTypeElement = new NotificationsTypeElement();
        Notifications notifications = this.notificationsDao.getSavedNotificationsForId(cloudId, cloudName, notificationId);
        BeanUtils.copyProperties((Object)notifications, (Object)notificationsTypeElement);
        notificationsTypeElement.setId(notifications.getId().toString());
        return notificationsTypeElement;
    }
}

