/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.bp.service.impl;

import com.google.common.base.Joiner;
import com.parablu.bluvault.udc.service.CloudSettingsService;
import com.parablu.bluvault.udc.service.impl.DNSResolverServiceImpl;
import com.parablu.bp.service.BackupPolicyService;
import com.parablu.helper.utils.BackupPolicyDiffFinder;
import com.parablu.packs.constants.OrderConstants;
import com.parablu.paracloud.constant.PCActionTypes;
import com.parablu.paracloud.element.BSPrivacyGatewayElement;
import com.parablu.paracloud.element.BSPrivacyGatewayMappingElement;
import com.parablu.paracloud.element.BackupFolderElement;
import com.parablu.paracloud.element.BackupPolicyElement;
import com.parablu.paracloud.element.BluSyncGroupBackupPolicyElement;
import com.parablu.paracloud.element.BluSyncNoBKPScheduleElement;
import com.parablu.paracloud.element.BluSyncScheduleElement;
import com.parablu.paracloud.element.BluVaultMappingElement;
import com.parablu.paracloud.element.CalloutScriptElement;
import com.parablu.paracloud.element.CloudCapParameter;
import com.parablu.paracloud.element.CloudPropertyElement;
import com.parablu.paracloud.element.DailyUserBackupOverViewElement;
import com.parablu.paracloud.element.EndpointUiDisabledPreferencesElement;
import com.parablu.paracloud.element.EndpointUiPreferencesElement;
import com.parablu.paracloud.element.InclusionFilterElement;
import com.parablu.paracloud.element.NetworkThrottlingElement;
import com.parablu.paracloud.element.PackElement;
import com.parablu.paracloud.element.PolicyStatisticsElement;
import com.parablu.paracloud.element.PrivacyGatewayMappingElement;
import com.parablu.paracloud.element.ScheduleDaysArrayElement;
import com.parablu.paracloud.element.bp.ExcludedFolderElement;
import com.parablu.paracloud.element.bp.SQLBackupFolderElement;
import com.parablu.pcbd.dao.AuditHistoryDao;
import com.parablu.pcbd.dao.BackupFoldersDao;
import com.parablu.pcbd.dao.BackupPolicyDao;
import com.parablu.pcbd.dao.BluVaultDao;
import com.parablu.pcbd.dao.CalloutScriptDao;
import com.parablu.pcbd.dao.CloudDao;
import com.parablu.pcbd.dao.ExcludedFoldersDao;
import com.parablu.pcbd.dao.InclusionFilterDao;
import com.parablu.pcbd.dao.MongoPropertiesDao;
import com.parablu.pcbd.dao.NetworkThrottlingDao;
import com.parablu.pcbd.dao.PrivacyGateWayDao;
import com.parablu.pcbd.dao.ReleaseDao;
import com.parablu.pcbd.dao.SchedulesDao;
import com.parablu.pcbd.dao.UserDao;
import com.parablu.pcbd.dao.UserDefinedFoldersDao;
import com.parablu.pcbd.domain.AuditHistory;
import com.parablu.pcbd.domain.BackupFolders;
import com.parablu.pcbd.domain.BackupPolicy;
import com.parablu.pcbd.domain.BluVault;
import com.parablu.pcbd.domain.CalloutScript;
import com.parablu.pcbd.domain.Cloud;
import com.parablu.pcbd.domain.CloudCredentials;
import com.parablu.pcbd.domain.CloudCustomisableDetails;
import com.parablu.pcbd.domain.CloudProperties;
import com.parablu.pcbd.domain.ExceptionsToExclusionsFolders;
import com.parablu.pcbd.domain.ExcludedFolders;
import com.parablu.pcbd.domain.InclusionFilter;
import com.parablu.pcbd.domain.NetworkThrottling;
import com.parablu.pcbd.domain.NoBkpSchedule;
import com.parablu.pcbd.domain.OPWS;
import com.parablu.pcbd.domain.OfficeBackupPolicy;
import com.parablu.pcbd.domain.Policy;
import com.parablu.pcbd.domain.PrivacyGateway;
import com.parablu.pcbd.domain.Release;
import com.parablu.pcbd.domain.ReportQueryElement;
import com.parablu.pcbd.domain.SQLBackupFolders;
import com.parablu.pcbd.domain.Schedule;
import com.parablu.pcbd.domain.User;
import com.parablu.pcbd.domain.UserDefinedFolders;
import com.parablu.pcsd.dao.SyncPolicyDao;
import com.parablu.pcsd.domain.SyncPolicy;
import com.parablu.report.service.ReportService;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bson.types.ObjectId;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class BackupPolicyServiceImpl
implements BackupPolicyService {
    private static Logger logger = LogManager.getLogger(BackupPolicyServiceImpl.class);
    @Resource
    private BackupPolicyDao backupPolicyDao;
    @Resource
    private BackupFoldersDao backupFoldersDao;
    @Resource
    private CalloutScriptDao calloutScriptDao;
    @Resource
    private SchedulesDao schedulesDao;
    @Resource
    private NetworkThrottlingDao networkThrottlingDao;
    @Resource
    private InclusionFilterDao inclusionFilterDao;
    @Resource
    private PrivacyGateWayDao privacyGateWayDao;
    @Resource
    private UserDefinedFoldersDao userDefinedFoldersDao;
    @Resource
    private ExcludedFoldersDao excludedFoldersDao;
    @Resource
    private ReleaseDao releaseDao;
    @Resource
    private UserDao userDao;
    @Resource
    private BluVaultDao bluVaultDao;
    @Resource
    private AuditHistoryDao auditHistoryDao;
    @Resource
    private CloudDao cloudDao;
    @Autowired
    private CloudSettingsService cloudSettingService;
    @Autowired
    private ReportService reportService;
    @Resource
    private SyncPolicyDao syncPolicyDao;
    @Resource
    private MongoPropertiesDao mongoPropertiesDao;
    @Resource
    DNSResolverServiceImpl dnsResolverService;
    private static final String GATEWAY = "GATEWAY";
    private static final String BLOCK_OFFICE_POLICY_ACTION = " Blocked %s policy name:";
    private static final String SHARE_POINT_PRODUCT = "Sharepoint";

    @Override
    public void saveBackupPolicy(int cloudId, String cloudName, BackupPolicyElement backupPolicyElement, String userName) {
        List<String> backupFolderPaths = this.removeDuplicateFolderpath(backupPolicyElement.getBackupFolderPaths());
        List<String> excludedFolderPaths = this.removeDuplicateFolderpath(backupPolicyElement.getExcludedFolderpaths());
        List<String> excptionsExcludedFolderPaths = this.removeDuplicateFolderpath(backupPolicyElement.getExceptionsToExclusions());
        List<String> sqlBackupFolderPaths = this.removeDuplicateFolderpath(backupPolicyElement.getSqlBackupFolders());
        List calloutScripts = backupPolicyElement.getCalloutScripts();
        String shareDomainType = backupPolicyElement.getShareDomainType();
        List shareDomainIncExclusions = backupPolicyElement.getShareDomainIncExclusions();
        logger.debug(".....before share inclusions...." + shareDomainIncExclusions);
        BackupPolicy existingBackupPolicy = this.backupPolicyDao.getBackupPolicy(cloudId, cloudName, backupPolicyElement.getPolicygroupName());
        String preScanCommand = "";
        if (!org.springframework.util.StringUtils.isEmpty((Object)backupPolicyElement.getPreScanCommand())) {
            String removeExtraSlash = backupPolicyElement.getPreScanCommand().replace("\\\\", "\\");
            preScanCommand = removeExtraSlash.replace("\\ \\", "\\");
        }
        String preBackupCommand = "";
        if (!org.springframework.util.StringUtils.isEmpty((Object)backupPolicyElement.getPreBackupCommand())) {
            String removeExtraSlash = backupPolicyElement.getPreBackupCommand().replace("\\\\", "\\");
            preBackupCommand = removeExtraSlash.replace("\\ \\", "\\");
        }
        String postBackupCommand = "";
        if (!org.springframework.util.StringUtils.isEmpty((Object)backupPolicyElement.getPostBackupCommand())) {
            String removeExtraSlash = backupPolicyElement.getPostBackupCommand().replace("\\\\", "\\");
            postBackupCommand = removeExtraSlash.replace("\\ \\", "\\");
        }
        List scheduleNames = backupPolicyElement.getScheduleNames();
        List noBKPScheduleNames = backupPolicyElement.getNoBkpScheduleNames();
        List networkThrottlingNames = backupPolicyElement.getNetworkThrottlingNames();
        List schedules = this.schedulesDao.getSchedules(cloudId, cloudName, scheduleNames);
        List networkThrottlings = this.networkThrottlingDao.getNetworkThrottlings(cloudId, cloudName, networkThrottlingNames);
        List noBKPSchedules = this.schedulesDao.getNoBKPSchedules(cloudId, cloudName, noBKPScheduleNames);
        List filterNames = backupPolicyElement.getFilterInclusionName();
        ArrayList<String> filterInclusionNames = new ArrayList<String>();
        for (String filter2 : filterNames) {
            filterInclusionNames.add(filter2);
        }
        ArrayList<Object> filters = new ArrayList();
        if (!CollectionUtils.isEmpty((Collection)filterNames)) {
            filters = this.getFiltersbyName(cloudId, cloudName, filterNames);
        }
        List searchfilterNames = backupPolicyElement.getSearchFilterInclusionName();
        ArrayList<Object> searchfilters = new ArrayList();
        if (!CollectionUtils.isEmpty((Collection)searchfilterNames)) {
            searchfilters = this.getFiltersbyName(cloudId, cloudName, searchfilterNames);
        }
        CloudCredentials cloudCredentials = null;
        String changedFields = "";
        BackupPolicyElement existingBackupPolicyElement = new BackupPolicyElement();
        if (!org.springframework.util.StringUtils.isEmpty((Object)backupPolicyElement.getCloudCredential())) {
            cloudCredentials = this.cloudDao.getCloudCredentials(cloudId, backupPolicyElement.getCloudCredential());
        }
        ArrayList<ObjectId> existingBackFoldersList = new ArrayList<ObjectId>();
        ArrayList<ObjectId> existingCalloutScriptList = new ArrayList<ObjectId>();
        ArrayList<String> existingBackupFolderPath = new ArrayList<String>();
        ArrayList<String> existingExcludedFolderPath = new ArrayList<String>();
        ArrayList<String> existingPrivacyGateways = new ArrayList<String>();
        ArrayList<String> existingScheduleNames = new ArrayList<String>();
        ArrayList<String> existingNoBKPScheduleNames = new ArrayList<String>();
        List<Object> existingExceptiontoExclusion = new ArrayList();
        List<Object> existingSQLBackupFoldersList = new ArrayList();
        ArrayList filterInclusionName = new ArrayList();
        if (existingBackupPolicy != null) {
            BeanUtils.copyProperties((Object)existingBackupPolicy, (Object)existingBackupPolicyElement);
            for (Schedule sch : existingBackupPolicy.getSchedules()) {
                existingScheduleNames.add(sch.getScheduleName());
            }
            existingBackupPolicyElement.setScheduleNames(existingScheduleNames);
            if (existingBackupPolicy.getNoBkpSchedules() != null) {
                for (Schedule sch : existingBackupPolicy.getNoBkpSchedules()) {
                    existingNoBKPScheduleNames.add(sch.getScheduleName());
                }
            }
            existingBackupPolicyElement.setNoBkpScheduleNames(existingNoBKPScheduleNames);
            List existingFilters = existingBackupPolicy.getInclusionFilter();
            List existingFilterNames = existingFilters.stream().filter(filter -> Objects.nonNull(filter.getFilterName())).map(filter -> filter.getFilterName()).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(existingFilterNames)) {
                existingBackupPolicyElement.setFilterInclusionName(existingFilterNames);
            } else {
                existingBackupPolicyElement.setFilterInclusionName(new ArrayList());
            }
            existingBackupPolicyElement.setEndpointUiPreferences((List)existingBackupPolicy.getEndpointUiPreferences());
            for (BackupFolders backupFolders : existingBackupPolicy.getBackupFolders()) {
                existingBackFoldersList.add(backupFolders.getId());
                existingBackupFolderPath.add(backupFolders.getFolderPath());
            }
            if (existingBackupPolicy.getExcludedFolders() != null) {
                for (ExcludedFolders excludedFolders : existingBackupPolicy.getExcludedFolders()) {
                    existingExcludedFolderPath.add(excludedFolders.getFolderPath());
                }
            }
            if (org.springframework.util.StringUtils.isEmpty((Object)backupPolicyElement.getExcludedFolderpaths())) {
                backupPolicyElement.setExcludedFolderpaths(new ArrayList());
            }
            if (org.springframework.util.StringUtils.isEmpty((Object)backupPolicyElement.getExceptionsToExclusions())) {
                backupPolicyElement.setExceptionsToExclusions(new ArrayList());
            }
            existingBackupPolicy.getBackupFolders().clear();
            for (CalloutScript script : existingBackupPolicy.getCalloutScripts()) {
                existingCalloutScriptList.add(script.getId());
            }
            existingBackupPolicy.setCalloutScripts(new ArrayList());
            existingBackupPolicy.setCloudCredentials(cloudCredentials);
            existingBackupPolicy.setPreScanCommand(preScanCommand);
            existingBackupPolicy.setPostBackupCommand(postBackupCommand);
            existingBackupPolicy.setPreBackupCommand(preBackupCommand);
            shareDomainIncExclusions = backupPolicyElement.getShareDomainIncExclusions();
            this.backupPolicyDao.saveBackupPolicy(cloudId, cloudName, existingBackupPolicy);
        }
        List<BackupFolders> backupFolders = this.getBackupFolders(cloudId, cloudName, backupPolicyElement, backupFolderPaths);
        List<Object> userExcludedFodlers = new ArrayList();
        if (!org.springframework.util.StringUtils.isEmpty(excludedFolderPaths)) {
            userExcludedFodlers = this.getUserExclusionFolders(cloudId, backupPolicyElement, excludedFolderPaths);
        }
        List<Object> exceptionToExcludedFodlers = new ArrayList();
        if (!org.springframework.util.StringUtils.isEmpty(excptionsExcludedFolderPaths)) {
            exceptionToExcludedFodlers = this.getExceptionsToExclusions(cloudId, backupPolicyElement, excptionsExcludedFolderPaths);
        }
        List<Object> sqlBackupFolders = new ArrayList();
        if (!org.springframework.util.StringUtils.isEmpty(sqlBackupFolderPaths)) {
            sqlBackupFolders = this.getSqlBackupFolders(cloudId, backupPolicyElement, sqlBackupFolderPaths);
        }
        List<CalloutScript> calloutScript = this.getCalloutScripts(cloudId, cloudName, backupPolicyElement, calloutScripts);
        BackupPolicy backupPolicy = new BackupPolicy();
        BeanUtils.copyProperties((Object)backupPolicyElement, (Object)backupPolicy);
        backupPolicy.setPolicyName(backupPolicyElement.getPolicygroupName());
        backupPolicy.setCalloutScripts(new ArrayList());
        backupPolicy.getCalloutScripts().addAll(calloutScript);
        backupPolicy.setBackupFolders(new ArrayList());
        backupPolicy.getBackupFolders().addAll(backupFolders);
        backupPolicy.setNetworkThrottlings(new ArrayList());
        backupPolicy.setSchedules(new ArrayList());
        backupPolicy.setNoBkpSchedules(new ArrayList());
        backupPolicy.getNetworkThrottlings().addAll(networkThrottlings);
        backupPolicy.getSchedules().addAll(schedules);
        backupPolicy.getNoBkpSchedules().addAll(noBKPSchedules);
        backupPolicy.setInclusionFilter(filters);
        backupPolicy.setFilterInclusionName(filterInclusionNames);
        backupPolicy.setSearchInclusionFilter(searchfilters);
        backupPolicy.setShareEnabled(backupPolicyElement.isShareEnabled());
        backupPolicy.setAllowDownload(backupPolicyElement.isAllowDownload());
        backupPolicy.setComplexPassword(backupPolicyElement.isComplexPassword());
        backupPolicy.setShareExpireDateEnable(backupPolicyElement.isShareExpireDateEnable());
        backupPolicy.setHighSecureShareEnabled(backupPolicyElement.isHighSecureShareEnabled());
        backupPolicy.setSearchAlgoForPg(backupPolicyElement.getSearchAlgoForPg());
        backupPolicy.setEndpointUiPreferences(new ArrayList(backupPolicyElement.getEndpointUiPreferences()));
        backupPolicy.setShareDomainType(backupPolicyElement.getShareDomainType());
        backupPolicy.setShareDomainIncExclusions(new ArrayList(backupPolicyElement.getShareDomainIncExclusions()));
        backupPolicy.setEndpointDisabledUiPreferences(new ArrayList(backupPolicyElement.getEndpointDisabledUiPreferences()));
        backupPolicy.setSwitchAgentPassword(backupPolicyElement.isSwitchAgentPassword());
        backupPolicy.setAgentPassword(backupPolicyElement.getAgentPassword());
        backupPolicy.setGoogleAuth(backupPolicyElement.isGoogleAuth());
        backupPolicy.setAllowEndUserTocontrolRestore(backupPolicyElement.isAllowEndUserTocontrolRestore());
        backupPolicy.setShowShareLink(backupPolicyElement.isShowShareLink());
        backupPolicy.setServerUserName(backupPolicyElement.getServerUserName());
        backupPolicy.setServerPassword(backupPolicyElement.getServerPassword());
        backupPolicy.setAutoUpdateAgent(backupPolicyElement.isAutoUpdateAgent());
        backupPolicy.setPolicyType(backupPolicyElement.getPolicyType());
        if (!userExcludedFodlers.isEmpty()) {
            backupPolicy.setExcludedFolders(new ArrayList());
            backupPolicy.getExcludedFolders().addAll(userExcludedFodlers);
        }
        if (!exceptionToExcludedFodlers.isEmpty()) {
            backupPolicy.setExceptionsToExclusions(new ArrayList());
            backupPolicy.getExceptionsToExclusions().addAll(exceptionToExcludedFodlers);
        }
        if (!sqlBackupFolders.isEmpty()) {
            backupPolicy.setSqlBackupFolders(new ArrayList());
            backupPolicy.getSqlBackupFolders().addAll(sqlBackupFolders);
        }
        if (existingBackupPolicy != null) {
            ArrayList ShareDomainIncExclusions;
            ArrayList exceptiontoExclusion;
            backupPolicy.setActive(existingBackupPolicy.isActive());
            if (org.springframework.util.StringUtils.isEmpty((Object)existingBackupPolicy.getPrivacyGateways())) {
                existingBackupPolicy.setPrivacyGateways(new ArrayList());
            } else {
                PrivacyGatewayMappingElement privacyGatewayMappingElement = new PrivacyGatewayMappingElement();
                for (PrivacyGateway pb : existingBackupPolicy.getPrivacyGateways()) {
                    existingPrivacyGateways.add(pb.getGatewayName());
                }
                privacyGatewayMappingElement.setPrivacyGatewayNames(existingPrivacyGateways);
                existingBackupPolicyElement.setPrivacyGatewayMappingElement(privacyGatewayMappingElement);
            }
            BackupPolicyElement tempBackupPolicyElement = new BackupPolicyElement();
            BeanUtils.copyProperties((Object)backupPolicy, (Object)tempBackupPolicyElement);
            List inclusionFilterList = backupPolicy.getInclusionFilter();
            ArrayList<String> incList = new ArrayList<String>();
            for (InclusionFilter inclusionFilter : inclusionFilterList) {
                incList.add(inclusionFilter.getFilterName());
            }
            tempBackupPolicyElement.setFilterInclusionName(incList);
            tempBackupPolicyElement.setBackupFolderPaths(backupFolderPaths);
            if (!org.springframework.util.StringUtils.isEmpty((Object)backupPolicy.getExcludedFolders())) {
                tempBackupPolicyElement.setExcludedFolderpaths(backupPolicy.getExcludedFolders().stream().filter(folder -> Objects.nonNull(folder.getFolderPath())).map(folder -> folder.getFolderPath()).collect(Collectors.toList()));
            }
            if (!CollectionUtils.isEmpty((Collection)backupPolicy.getExceptionsToExclusions())) {
                tempBackupPolicyElement.setExceptionsToExclusions(backupPolicy.getExceptionsToExclusions().stream().filter(folder -> Objects.nonNull(folder.getFolderPath())).map(folder -> folder.getFolderPath()).collect(Collectors.toList()));
            } else {
                exceptiontoExclusion = new ArrayList();
                tempBackupPolicyElement.setExceptionsToExclusions(exceptiontoExclusion);
            }
            if (!CollectionUtils.isEmpty((Collection)backupPolicy.getSqlBackupFolders())) {
                tempBackupPolicyElement.setSqlBackupFolders(backupPolicy.getSqlBackupFolders().stream().filter(folder -> Objects.nonNull(folder.getFolderPath())).map(folder -> folder.getFolderPath()).collect(Collectors.toList()));
            } else {
                ArrayList SqlBackupFolderPaths = new ArrayList();
                tempBackupPolicyElement.setSqlBackupFolders(SqlBackupFolderPaths);
            }
            if (!org.springframework.util.StringUtils.isEmpty(existingBackupFolderPath)) {
                existingBackupPolicyElement.setBackupFolderPaths(existingBackupFolderPath);
            }
            if (!org.springframework.util.StringUtils.isEmpty(existingExcludedFolderPath)) {
                existingBackupPolicyElement.setExcludedFolderpaths(existingExcludedFolderPath);
            }
            if (!CollectionUtils.isEmpty((Collection)existingBackupPolicy.getExceptionsToExclusions())) {
                existingExceptiontoExclusion = existingBackupPolicy.getExceptionsToExclusions().stream().filter(folder -> Objects.nonNull(folder.getFolderPath())).map(folder -> folder.getFolderPath()).collect(Collectors.toList());
                existingBackupPolicyElement.setExceptionsToExclusions(existingExceptiontoExclusion);
            } else {
                exceptiontoExclusion = new ArrayList();
                existingBackupPolicyElement.setExceptionsToExclusions(exceptiontoExclusion);
            }
            if (!CollectionUtils.isEmpty((Collection)existingBackupPolicy.getSqlBackupFolders())) {
                existingSQLBackupFoldersList = existingBackupPolicy.getSqlBackupFolders().stream().filter(folder -> Objects.nonNull(folder.getFolderPath())).map(folder -> folder.getFolderPath()).collect(Collectors.toList());
                existingBackupPolicyElement.setSqlBackupFolders(existingSQLBackupFoldersList);
            } else {
                ArrayList existingSQLBackupFolders = new ArrayList();
                existingBackupPolicyElement.setSqlBackupFolders(existingSQLBackupFolders);
            }
            if (!CollectionUtils.isEmpty((Collection)backupPolicy.getShareDomainIncExclusions())) {
                tempBackupPolicyElement.setShareDomainIncExclusions((List)backupPolicy.getShareDomainIncExclusions());
            } else {
                ShareDomainIncExclusions = new ArrayList();
                tempBackupPolicyElement.setShareDomainIncExclusions(ShareDomainIncExclusions);
            }
            if (!CollectionUtils.isEmpty((Collection)existingBackupPolicy.getShareDomainIncExclusions())) {
                existingBackupPolicyElement.setShareDomainIncExclusions((List)existingBackupPolicy.getShareDomainIncExclusions());
            } else {
                ShareDomainIncExclusions = new ArrayList();
                existingBackupPolicyElement.setShareDomainIncExclusions(ShareDomainIncExclusions);
            }
            tempBackupPolicyElement.setPrivacyGatewayMappingElement(backupPolicyElement.getPrivacyGatewayMappingElement());
            tempBackupPolicyElement.setScheduleNames(scheduleNames);
            tempBackupPolicyElement.setNoBkpScheduleNames(noBKPScheduleNames);
            if (StringUtils.isEmpty((String)existingBackupPolicyElement.getShareDomainType())) {
                existingBackupPolicyElement.setShareDomainType("");
            }
            if (StringUtils.isEmpty((String)tempBackupPolicyElement.getShareDomainType())) {
                tempBackupPolicyElement.setShareDomainType("");
            }
            BackupPolicyDiffFinder backupPolicyDiffFinder = new BackupPolicyDiffFinder();
            changedFields = backupPolicyDiffFinder.findDiff(existingBackupPolicyElement, tempBackupPolicyElement);
        }
        long currentTimeMillis = System.currentTimeMillis();
        if (existingBackupPolicy != null) {
            ObjectId id = existingBackupPolicy.getId();
            boolean statisticsEnabled = existingBackupPolicy.isStatisticsCollectorEnabled();
            BeanUtils.copyProperties((Object)backupPolicy, (Object)existingBackupPolicy);
            existingBackupPolicy.setId(id);
            existingBackupPolicy.setStatisticsCollectorEnabled(statisticsEnabled);
            existingBackupPolicy.getBackupFolders().clear();
            existingBackupPolicy.getBackupFolders().addAll(backupFolders);
            if (!userExcludedFodlers.isEmpty()) {
                existingBackupPolicy.getExcludedFolders().clear();
                existingBackupPolicy.getExcludedFolders().addAll(userExcludedFodlers);
            }
            existingBackupPolicy.setLastModifiedTimestamp(currentTimeMillis);
            this.setPrivacyGateWayElements(cloudId, cloudName, existingBackupPolicy, backupPolicyElement.getPrivacyGatewayMappingElement());
            existingBackupPolicy.setCloudCredentials(cloudCredentials);
            existingBackupPolicy.setInclusionFilter(filters);
            existingBackupPolicy.setSearchInclusionFilter(searchfilters);
            existingBackupPolicy.setEndpointUiPreferences(new ArrayList(backupPolicyElement.getEndpointUiPreferences()));
            existingBackupPolicy.setEndpointDisabledUiPreferences(new ArrayList(backupPolicyElement.getEndpointDisabledUiPreferences()));
            existingBackupPolicy.setShareDomainType(backupPolicyElement.getShareDomainType());
            if (backupPolicyElement.getShareDomainIncExclusions() != null) {
                existingBackupPolicy.setShareDomainIncExclusions(new ArrayList(backupPolicyElement.getShareDomainIncExclusions()));
            } else {
                ArrayList ShareDomainIncExclusions = new ArrayList();
                existingBackupPolicy.setShareDomainIncExclusions(ShareDomainIncExclusions);
            }
            logger.debug("edit policy with endpointDisabledUiPreferences");
            existingBackupPolicy.setPreScanCommand(preScanCommand);
            existingBackupPolicy.setPostBackupCommand(postBackupCommand);
            existingBackupPolicy.setPreBackupCommand(preBackupCommand);
            existingBackupPolicy.setGoogleAuth(backupPolicyElement.isGoogleAuth());
            existingBackupPolicy.setSwitchAgentPassword(backupPolicyElement.isSwitchAgentPassword());
            existingBackupPolicy.setAgentPassword(backupPolicyElement.getAgentPassword());
            existingBackupPolicy.setAllowEndUserTocontrolRestore(backupPolicyElement.isAllowEndUserTocontrolRestore());
            existingBackupPolicy.setShowShareLink(backupPolicyElement.isShowShareLink());
            existingBackupPolicy.setServerUserName(backupPolicyElement.getServerUserName());
            existingBackupPolicy.setServerPassword(backupPolicyElement.getServerPassword());
            existingBackupPolicy.setAutoUpdateAgent(backupPolicyElement.isAutoUpdateAgent());
            existingBackupPolicy.getPacks().addAll(backupPolicyElement.getPack());
            this.backupPolicyDao.saveBackupPolicy(cloudId, cloudName, existingBackupPolicy);
            this.userDao.updateBackupPolicyModifiedTime(cloudId, existingBackupPolicy.getPolicyName());
            if (!org.springframework.util.StringUtils.isEmpty((Object)changedFields)) {
                if (org.springframework.util.StringUtils.isEmpty((Object)backupPolicyElement.getPolicyType())) {
                    this.saveStatisticToDatabase(cloudId, cloudName, " modified backup policy " + backupPolicyElement.getPolicygroupName() + ". The changed fields are " + changedFields, userName, "", PCActionTypes.BACKUP_POLICY_UPDATE.getActionTypeValue());
                } else if (BackupPolicy.TYPE.SERVER.toString().equals(backupPolicyElement.getPolicyType())) {
                    this.saveStatisticToDatabase(cloudId, cloudName, " modified server policy" + backupPolicyElement.getPolicygroupName() + ". The changed fields are " + changedFields, userName, "", PCActionTypes.SERVER_POLICY_UPDATE.getActionTypeValue());
                }
            }
        } else {
            backupPolicy.setLastModifiedTimestamp(currentTimeMillis);
            this.setPrivacyGateWayElements(cloudId, cloudName, backupPolicy, backupPolicyElement.getPrivacyGatewayMappingElement());
            backupPolicy.setCloudCredentials(cloudCredentials);
            logger.debug("save policy with endpointDisabledUiPreferences" + backupPolicy.getShareDomainType() + "..inc." + backupPolicy.getShareDomainIncExclusions());
            backupPolicy.setPreScanCommand(preScanCommand);
            backupPolicy.setPostBackupCommand(postBackupCommand);
            backupPolicy.setPreBackupCommand(preBackupCommand);
            this.backupPolicyDao.saveBackupPolicy(cloudId, cloudName, backupPolicy);
            if (org.springframework.util.StringUtils.isEmpty((Object)backupPolicyElement.getPolicyType())) {
                this.saveStatisticToDatabase(cloudId, cloudName, "created", userName, backupPolicyElement.getPolicygroupName(), PCActionTypes.BACKUP_POLICY_CREATE.getActionTypeValue());
            } else if (BackupPolicy.TYPE.SERVER.toString().equals(backupPolicyElement.getPolicyType())) {
                this.saveStatisticToDatabase(cloudId, cloudName, "created", userName, backupPolicyElement.getPolicygroupName(), PCActionTypes.SERVER_POLICY_CREATE.getActionTypeValue());
            }
        }
        if (!CollectionUtils.isEmpty(existingBackFoldersList)) {
            this.backupFoldersDao.deleteBackupFoldersForPolicyId(cloudId, cloudName, existingBackFoldersList);
        }
    }

    private List<String> removeDuplicateFolderpath(List<String> folderPathList) {
        ArrayList<String> folderPathsInLowerCase = new ArrayList<String>();
        if (!CollectionUtils.isEmpty(folderPathList)) {
            for (String folderPath : folderPathList) {
                String removeExtraSlash = folderPath.replace("\\\\", "\\");
                String removeExtraSlashAndSpace = removeExtraSlash.replace("\\ \\", "\\");
                folderPathsInLowerCase.add(removeExtraSlashAndSpace);
            }
            LinkedHashSet<String> set = new LinkedHashSet<String>();
            set.addAll(folderPathsInLowerCase);
            folderPathsInLowerCase.clear();
            folderPathsInLowerCase.addAll(set);
        }
        return folderPathsInLowerCase;
    }

    private List<BackupFolders> getBackupFolders(int cloudId, String cloudName, BackupPolicyElement backupPolicyElement, List<String> backupFolderPaths) {
        ArrayList<BackupFolders> backupFolders = new ArrayList<BackupFolders>();
        for (String backupFolderPath : backupFolderPaths) {
            BackupFolders backupFoldersObj = this.backupFoldersDao.getBackupFolders(cloudId, cloudName, backupFolderPath);
            if (backupFoldersObj == null) {
                backupFoldersObj = new BackupFolders();
                backupFoldersObj.setFolderPath(backupFolderPath);
                backupFoldersObj.setOs(backupPolicyElement.getOsType());
                this.backupFoldersDao.saveBackupFolders(cloudId, cloudName, backupFoldersObj);
            }
            backupFolders.add(backupFoldersObj);
        }
        return backupFolders;
    }

    private List<ExcludedFolders> getUserExclusionFolders(int cloudId, BackupPolicyElement backupPolicyElement, List<String> userExcludedFoldersPath) {
        ArrayList<ExcludedFolders> userExcludedFoldersList = new ArrayList<ExcludedFolders>();
        for (String backupFolderPath : userExcludedFoldersPath) {
            ExcludedFolders excludedFolders = this.excludedFoldersDao.getExcludedFoldersByPath(cloudId, backupFolderPath);
            if (excludedFolders == null || org.springframework.util.StringUtils.isEmpty((Object)excludedFolders.getFolderPath())) {
                excludedFolders = new ExcludedFolders();
                excludedFolders.setFolderPath(backupFolderPath);
                this.excludedFoldersDao.saveExcludedFolders(cloudId, excludedFolders);
            }
            userExcludedFoldersList.add(excludedFolders);
        }
        return userExcludedFoldersList;
    }

    private List<ExceptionsToExclusionsFolders> getExceptionsToExclusions(int cloudId, BackupPolicyElement backupPolicyElement, List<String> exceptionsToExclusions) {
        ArrayList<ExceptionsToExclusionsFolders> exeptionToExcludedFoldersList = new ArrayList<ExceptionsToExclusionsFolders>();
        for (String exceptionsFolder : exceptionsToExclusions) {
            ExceptionsToExclusionsFolders excludedFolders = this.excludedFoldersDao.getExceptionsToExclusions(cloudId, exceptionsFolder);
            if (excludedFolders == null || org.springframework.util.StringUtils.isEmpty((Object)excludedFolders.getFolderPath())) {
                excludedFolders = new ExceptionsToExclusionsFolders();
                excludedFolders.setFolderPath(exceptionsFolder);
                this.excludedFoldersDao.saveExceptionsToExclusionsFolders(cloudId, excludedFolders);
            }
            exeptionToExcludedFoldersList.add(excludedFolders);
        }
        return exeptionToExcludedFoldersList;
    }

    private List<SQLBackupFolders> getSqlBackupFolders(int cloudId, BackupPolicyElement backupPolicyElement, List<String> sqlBackupFolderPaths) {
        ArrayList<SQLBackupFolders> sqlBackupFolderssList = new ArrayList<SQLBackupFolders>();
        for (String sqlBackupFolder : sqlBackupFolderPaths) {
            SQLBackupFolders sqlBackupFolders = this.excludedFoldersDao.getSqlBackupFolders(cloudId, sqlBackupFolder);
            if (sqlBackupFolders == null || org.springframework.util.StringUtils.isEmpty((Object)sqlBackupFolders.getFolderPath())) {
                sqlBackupFolders = new SQLBackupFolders();
                sqlBackupFolders.setFolderPath(sqlBackupFolder);
                this.excludedFoldersDao.saveSqlBackupFolders(cloudId, sqlBackupFolders);
            }
            sqlBackupFolderssList.add(sqlBackupFolders);
        }
        return sqlBackupFolderssList;
    }

    private List<CalloutScript> getCalloutScripts(int cloudId, String cloudName, BackupPolicyElement backupPolicyElement, List<String> calloutScripts) {
        ArrayList<CalloutScript> calloutScripts1 = new ArrayList<CalloutScript>();
        for (String calloutscriptstr : calloutScripts) {
            CalloutScript calloutScript;
            String[] stringList = calloutscriptstr.split("\\|");
            List<String> argsList = null;
            if (stringList.length > 2) {
                argsList = Arrays.asList(stringList[2].split(","));
            }
            if ((calloutScript = this.calloutScriptDao.getCalloutScript(cloudId, cloudName, stringList[0], argsList)) == null) {
                calloutScript = new CalloutScript();
                calloutScript.setScriptName(stringList[0]);
            }
            calloutScript.setScriptType(stringList[1]);
            calloutScript.setScriptArgs(argsList);
            this.calloutScriptDao.saveCalloutScript(cloudId, cloudName, calloutScript);
            calloutScripts1.add(calloutScript);
        }
        return calloutScripts1;
    }

    @Override
    public BackupPolicyElement getBackupPolicy(int cloudId, String cloudName, String policyName) {
        BackupPolicy backupPolicy = this.backupPolicyDao.getBackupPolicy(cloudId, cloudName, policyName);
        return this.getBackupPolicyElement(cloudId, backupPolicy);
    }

    @Override
    public List<BackupPolicyElement> getAllBackupPolicies(int cloudId, String cloudName) {
        List backupPolicyList = this.backupPolicyDao.getAllBackupPolicies(cloudId);
        ArrayList<BackupPolicyElement> elements = new ArrayList<BackupPolicyElement>();
        for (BackupPolicy backupPolicy : backupPolicyList) {
            BackupPolicyElement element = this.getBackupPolicyElement(cloudId, backupPolicy);
            elements.add(element);
        }
        return elements;
    }

    @Override
    public BackupPolicyElement getBackupPolicyForDevice(int cloudId, String cloudName, String deviceUUID) {
        BackupPolicy backupPolicy = this.backupPolicyDao.getBackupPolicyForDevice(cloudId, cloudName, deviceUUID);
        return this.getBackupPolicyElement(cloudId, backupPolicy);
    }

    private BackupPolicyElement getBackupPolicyElement(int cloudId, BackupPolicy backupPolicy) {
        logger.debug("...get policy element...");
        BackupPolicyElement element = null;
        ArrayList<String> folderPaths = new ArrayList<String>();
        ArrayList<String> userExcludedFolderPaths = new ArrayList<String>();
        ArrayList<String> userExceptionToExcludedFolderPaths = new ArrayList<String>();
        ArrayList<String> sqlBackupFolderPaths = new ArrayList<String>();
        ArrayList<String> scheduleNames = new ArrayList<String>();
        ArrayList<String> NoBKPscheduleNames = new ArrayList<String>();
        ArrayList<String> networkThrottlingNames = new ArrayList<String>();
        ArrayList<String> calloutScriptStrs = new ArrayList<String>();
        if (backupPolicy == null) {
            return null;
        }
        for (Schedule schedule : backupPolicy.getSchedules()) {
            scheduleNames.add(schedule.getScheduleName());
        }
        if (backupPolicy.getNoBkpSchedules() != null) {
            for (Schedule schedule : backupPolicy.getNoBkpSchedules()) {
                NoBKPscheduleNames.add(schedule.getScheduleName());
            }
        }
        for (NetworkThrottling networkThrottling : backupPolicy.getNetworkThrottlings()) {
            networkThrottlingNames.add(networkThrottling.getNetworkThrottlingName());
        }
        for (BackupFolders backupFolder : backupPolicy.getBackupFolders()) {
            BackupFolderElement backupFolderElement = new BackupFolderElement();
            if (backupFolder == null) continue;
            backupFolderElement.setFolderPath(backupFolder.getFolderPath());
            backupFolderElement.setOsType(backupFolder.getOs());
            folderPaths.add(backupFolder.getFolderPath());
        }
        for (Object calloutScript : backupPolicy.getCalloutScripts()) {
            if (calloutScript == null) continue;
            List scriptArgs = calloutScript.getScriptArgs();
            String scriptArgstr = "";
            if (scriptArgs != null) {
                scriptArgstr = Joiner.on((String)",").skipNulls().join((Iterable)scriptArgs);
            }
            calloutScriptStrs.add(calloutScript.getScriptName() + "|" + calloutScript.getScriptType() + "|" + scriptArgstr);
        }
        if (backupPolicy != null) {
            List searchFilterNames;
            ArrayList searchfilters;
            ExcludedFolderElement userExcludedFolderElement;
            element = new BackupPolicyElement();
            List packList = backupPolicy.getPacks();
            BeanUtils.copyProperties((Object)backupPolicy, (Object)element);
            element.setPack(packList);
            element.setPolicygroupName(backupPolicy.getPolicyName());
            element.setBackupFolderPaths(new ArrayList());
            element.getBackupFolderPaths().addAll(folderPaths);
            if (element.getNwFromClientToPGMB() <= 0.0) {
                element.setNwFromClientToPGMB((double)element.getNwFromClientToPG().longValue());
            }
            if (!org.springframework.util.StringUtils.isEmpty((Object)backupPolicy.getExcludedFolders())) {
                for (ExcludedFolders userExcludedFolders : backupPolicy.getExcludedFolders()) {
                    userExcludedFolderElement = new ExcludedFolderElement();
                    if (userExcludedFolders == null) continue;
                    userExcludedFolderElement.setFolderPath(userExcludedFolders.getFolderPath());
                    userExcludedFolderPaths.add(userExcludedFolders.getFolderPath());
                }
                if (!userExcludedFolderPaths.isEmpty()) {
                    element.setExcludedFolderpaths(userExcludedFolderPaths);
                }
            }
            if (!org.springframework.util.StringUtils.isEmpty((Object)backupPolicy.getExceptionsToExclusions())) {
                for (ExcludedFolders userExcludedFolders : backupPolicy.getExceptionsToExclusions()) {
                    userExcludedFolderElement = new ExcludedFolderElement();
                    if (userExcludedFolders == null) continue;
                    userExcludedFolderElement.setFolderPath(userExcludedFolders.getFolderPath());
                    userExceptionToExcludedFolderPaths.add(userExcludedFolders.getFolderPath());
                }
                if (!userExceptionToExcludedFolderPaths.isEmpty()) {
                    element.setExceptionsToExclusions(userExceptionToExcludedFolderPaths);
                }
            }
            if (!org.springframework.util.StringUtils.isEmpty((Object)backupPolicy.getSqlBackupFolders())) {
                for (SQLBackupFolders sqlBackupFolders : backupPolicy.getSqlBackupFolders()) {
                    SQLBackupFolderElement sqlBackupFolderElement = new SQLBackupFolderElement();
                    if (sqlBackupFolders == null) continue;
                    sqlBackupFolderElement.setFolderPath(sqlBackupFolders.getFolderPath());
                    sqlBackupFolderPaths.add(sqlBackupFolders.getFolderPath());
                }
                if (!sqlBackupFolderPaths.isEmpty()) {
                    element.setSqlBackupFolders(sqlBackupFolderPaths);
                }
            }
            element.setCalloutScripts(calloutScriptStrs);
            List filters = backupPolicy.getInclusionFilter();
            List filterNames = filters.stream().filter(filter -> Objects.nonNull(filter.getFilterName())).map(filter -> filter.getFilterName()).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(filterNames)) {
                element.setFilterInclusionName(filterNames);
            }
            if (!CollectionUtils.isEmpty((Collection)(searchfilters = backupPolicy.getSearchInclusionFilter())) && !CollectionUtils.isEmpty(searchFilterNames = searchfilters.stream().filter(filter -> Objects.nonNull(filter.getFilterName())).map(filter -> filter.getFilterName()).collect(Collectors.toList()))) {
                element.setSearchFilterInclusionName(searchFilterNames);
            }
            element.setSearchFilterType(backupPolicy.getSearchFilterType());
            element.setNetworkThrottlingNames(new ArrayList());
            element.setScheduleNames(new ArrayList());
            element.getNetworkThrottlingNames().addAll(networkThrottlingNames);
            element.getScheduleNames().addAll(scheduleNames);
            element.getNoBkpScheduleNames().addAll(NoBKPscheduleNames);
            element.setEndpointUiPreferences((List)backupPolicy.getEndpointUiPreferences());
            logger.debug(backupPolicy.getShareDomainType() + "........inclusion or exclusion " + backupPolicy.getShareDomainIncExclusions());
            element.setShareDomainType(backupPolicy.getShareDomainType());
            element.setShareDomainIncExclusions((List)backupPolicy.getShareDomainIncExclusions());
            ArrayList list = backupPolicy.getPrivacyGateways();
            PrivacyGatewayMappingElement mappingElement = new PrivacyGatewayMappingElement();
            ArrayList<String> pgList = new ArrayList<String>();
            for (PrivacyGateway privacyGateway : list) {
                if (privacyGateway == null) continue;
                mappingElement.setGatewayNwThrottlingName("PGThrottle-name");
                pgList.add(privacyGateway.getGatewayName());
            }
            mappingElement.setPrivacyGatewayNames(new ArrayList());
            mappingElement.setPrivacyGatewayNames(pgList);
            element.setPrivacyGatewayMappingElement(mappingElement);
            element.setSearchAlgoForPg(backupPolicy.getSearchAlgoForPg());
            if (backupPolicy.getCloudCredentials() != null) {
                element.setCloudCredential(backupPolicy.getCloudCredentials().getIdentity());
            }
        }
        return element;
    }

    private BackupPolicyElement loadAllBackupPolicyElements(int cloudId, BackupPolicy backupPolicy) {
        BackupPolicyElement element = null;
        ArrayList<String> scheduleNames = new ArrayList<String>();
        ArrayList<String> fileterNames = new ArrayList<String>();
        ArrayList<String> NoBkpscheduleNames = new ArrayList<String>();
        if (backupPolicy == null) {
            return null;
        }
        for (Schedule schedule : backupPolicy.getSchedules()) {
            scheduleNames.add(schedule.getScheduleName());
        }
        if (backupPolicy.getNoBkpSchedules() != null) {
            for (Schedule schedule : backupPolicy.getNoBkpSchedules()) {
                NoBkpscheduleNames.add(schedule.getScheduleName());
            }
        }
        if (!CollectionUtils.isEmpty((Collection)backupPolicy.getInclusionFilter())) {
            for (InclusionFilter filter : backupPolicy.getInclusionFilter()) {
                if (filter == null || org.springframework.util.StringUtils.isEmpty((Object)filter.getFilterName())) continue;
                fileterNames.add(filter.getFilterName());
            }
        }
        if (backupPolicy != null) {
            element = new BackupPolicyElement();
            BeanUtils.copyProperties((Object)backupPolicy, (Object)element);
            element.setPolicygroupName(backupPolicy.getPolicyName());
            element.setScheduleNames(new ArrayList());
            element.getScheduleNames().addAll(scheduleNames);
            element.setFilterInclusionName(fileterNames);
            element.setNoBkpScheduleNames(new ArrayList());
            element.setNoBkpScheduleNames(NoBkpscheduleNames);
        }
        return element;
    }

    @Override
    public Boolean getBackupPolicy(int cloudId, String cloudName, String policyName, long lastModifiedTime) {
        Boolean isLatestVersion = this.backupPolicyDao.getBackupPolicy(cloudId, cloudName, policyName, lastModifiedTime);
        return isLatestVersion;
    }

    @Override
    public Boolean isPolicyModified(int cloudId, String cloudName, String userName, Long lastModifiedTimeVal) {
        boolean isPolicyModified = false;
        User user = this.userDao.getUserByName(cloudId, userName);
        if (user != null && !org.springframework.util.StringUtils.isEmpty((Object)user.getPolicyName())) {
            long policyModifiedTime;
            long userPolicyModifiedTime = user.getPolicyModifiedTime();
            BackupPolicy bkpPolicy = this.userDao.getBackupPolicyByPolicyName(cloudId, user.getPolicyName());
            if (bkpPolicy != null && (policyModifiedTime = bkpPolicy.getLastModifiedTimestamp()) >= userPolicyModifiedTime) {
                isPolicyModified = true;
                return isPolicyModified;
            }
        }
        return isPolicyModified;
    }

    private void setPrivacyGateWayElements(int cloudId, String cloudName, BackupPolicy backupPolicy, PrivacyGatewayMappingElement privacyGatewayMappingElement) {
        List list = this.privacyGateWayDao.getAllGateways(cloudId);
        backupPolicy.setPrivacyGateways(new ArrayList());
        List pgList = privacyGatewayMappingElement.getPrivacyGatewayNames();
        for (String pgname : pgList) {
            PrivacyGateway gateway = this.getPrivacyGateWay(list, pgname);
            backupPolicy.getPrivacyGateways().add(gateway);
        }
    }

    private PrivacyGateway getPrivacyGateWay(List<PrivacyGateway> pgList, String gateWayName) {
        PrivacyGateway privacyGateway = null;
        for (PrivacyGateway gateway : pgList) {
            if (!gateway.getGatewayName().equals(gateWayName)) continue;
            privacyGateway = gateway;
            break;
        }
        return privacyGateway;
    }

    @Override
    public BluSyncGroupBackupPolicyElement getBluSyncGroupPolicyElement(int cloudId, String cloudName, String userName, String deviceUUID, Cloud cloud) {
        BackupFolderElement backupFolderElement;
        ArrayList searcFilters;
        List filters;
        BluSyncGroupBackupPolicyElement element = new BluSyncGroupBackupPolicyElement();
        User user = this.userDao.getUserByName(cloudId, userName);
        CloudProperties cloudProperties = this.cloudDao.getCloudProperties(cloudId);
        BackupPolicy backupPolicy = this.userDao.getBackupPolicyByPolicyName(cloudId, user.getPolicyName());
        BeanUtils.copyProperties((Object)backupPolicy, (Object)element);
        element.setPolicygroupName(backupPolicy.getPolicyName());
        if (backupPolicy.getCrawlLimit() != 0) {
            element.setCrawlLimit(String.valueOf(backupPolicy.getCrawlLimit()));
        }
        if (backupPolicy.getFileChunkableSize() != 0) {
            element.setFileChunkableSize(String.valueOf(backupPolicy.getFileChunkableSize()));
        }
        if (!CollectionUtils.isEmpty((Collection)(filters = backupPolicy.getInclusionFilter()))) {
            element.setInclusionFilterElement(this.getFilter(filters, backupPolicy.getFilterType(), backupPolicy.isBackupFilesWithoutExtension()));
        }
        if (!CollectionUtils.isEmpty((Collection)(searcFilters = backupPolicy.getSearchInclusionFilter()))) {
            element.setSearchInclusionFilterElement(this.getFilter(searcFilters, backupPolicy.getFilterType(), backupPolicy.isBackupFilesWithoutExtension()));
        }
        List<BluSyncScheduleElement> scheduleElements = this.getScheduleElements(backupPolicy);
        List<BluSyncNoBKPScheduleElement> noBkpScheduleElements = this.getNoBKPScheduleElements(backupPolicy);
        BSPrivacyGatewayMappingElement mappingElement = new BSPrivacyGatewayMappingElement();
        mappingElement.setBsPrivacyGatewayElementsList(new ArrayList());
        if (CollectionUtils.isEmpty((Collection)backupPolicy.getPrivacyGateways())) {
            List privacygateways = this.privacyGateWayDao.getAllGateways(cloudId);
            Iterator iterator = privacygateways.iterator();
            while (iterator.hasNext()) {
                PrivacyGateway childPrivacyGateway = (PrivacyGateway)iterator.next();
                if (!org.springframework.util.StringUtils.isEmpty((Object)childPrivacyGateway.getProductType()) && !"bluvault".equalsIgnoreCase(childPrivacyGateway.getProductType()) && !"both".equalsIgnoreCase(childPrivacyGateway.getProductType())) continue;
                mappingElement.setGatewayNwThrottlingName(GATEWAY);
                BSPrivacyGatewayElement pgelement = new BSPrivacyGatewayElement();
                logger.debug("process =  checking if it is a hosted setup from Mongo properties collection");
                boolean isHostedSetup = this.mongoPropertiesDao.checkHostedSetup(cloudId);
                if (isHostedSetup) {
                    logger.debug("It is a hosted setup getting the public IP for the domain name");
                    String publicIpAddress = this.getIPAddressFromDomain(childPrivacyGateway.getGatewayName(), cloud.getCloudId());
                    if (!org.springframework.util.StringUtils.isEmpty((Object)publicIpAddress)) {
                        pgelement.setName(publicIpAddress);
                    } else {
                        pgelement.setName(childPrivacyGateway.getGatewayName());
                    }
                } else {
                    pgelement.setName(childPrivacyGateway.getGatewayName());
                }
                pgelement.setType(childPrivacyGateway.getType());
                mappingElement.getBsPrivacyGatewayElementsList().add(pgelement);
            }
        } else {
            for (PrivacyGateway gateway : backupPolicy.getPrivacyGateways()) {
                mappingElement.setGatewayNwThrottlingName(GATEWAY);
                if (gateway == null) continue;
                BSPrivacyGatewayElement pgelement = new BSPrivacyGatewayElement();
                logger.debug("process =  checking if it is a hosted setup from Mongo properties collection");
                boolean isHostedSetup = this.mongoPropertiesDao.checkHostedSetup(cloudId);
                if (isHostedSetup) {
                    logger.debug("It is a hosted setup getting the public IP for the domain name");
                    String publicIpAddress = this.getIPAddressFromDomain(gateway.getGatewayName(), cloud.getCloudId());
                    if (!org.springframework.util.StringUtils.isEmpty((Object)publicIpAddress)) {
                        pgelement.setName(publicIpAddress);
                    } else {
                        pgelement.setName(gateway.getGatewayName());
                    }
                } else {
                    pgelement.setName(gateway.getGatewayName());
                }
                pgelement.setType(gateway.getType());
                mappingElement.getBsPrivacyGatewayElementsList().add(pgelement);
            }
        }
        element.setBSPrivacyGatewayMappingElement(mappingElement);
        List<BackupFolderElement> backupFolderElements = this.getBackupFolderElements(backupPolicy);
        List userDefinedFoldersList = this.userDefinedFoldersDao.getAllUserDefinedInclusionFolders(cloudId, cloudName, deviceUUID, userName);
        ArrayList userExcludedFoldersList = backupPolicy.getExcludedFolders();
        ArrayList userExceptionsToExcludedFoldersList = backupPolicy.getExceptionsToExclusions();
        List userDeviceExcludedFoldersList = this.userDefinedFoldersDao.getAllUserDefinedExclusionFolders(cloudId, cloudName, deviceUUID, userName);
        ArrayList sqlBackupFoldersList = backupPolicy.getSqlBackupFolders();
        List<CalloutScriptElement> calloutScriptElements = this.getCalloutScriptElements(backupPolicy);
        if (!CollectionUtils.isEmpty((Collection)userDefinedFoldersList)) {
            for (UserDefinedFolders userDefinedFolders : userDefinedFoldersList) {
                backupFolderElement = new BackupFolderElement();
                backupFolderElement.setFolderPath(userDefinedFolders.getFolderPath());
                backupFolderElements.add(backupFolderElement);
            }
        }
        element.setExcludedFolderPaths(new ArrayList());
        if (!CollectionUtils.isEmpty((Collection)userExcludedFoldersList)) {
            for (Object userExcludedFolders : userExcludedFoldersList) {
                if (userExcludedFolders == null) continue;
                backupFolderElement = new BackupFolderElement();
                backupFolderElement.setFolderPath(userExcludedFolders.getFolderPath());
                element.getExcludedFolderPaths().add(backupFolderElement);
            }
        }
        if (!CollectionUtils.isEmpty((Collection)userDeviceExcludedFoldersList)) {
            for (Object userExcludedFolders : userDeviceExcludedFoldersList) {
                backupFolderElement = new BackupFolderElement();
                backupFolderElement.setFolderPath(userExcludedFolders.getFolderPath());
                element.getExcludedFolderPaths().add(backupFolderElement);
            }
        }
        element.setExceptionsToExclusions(new ArrayList());
        if (!CollectionUtils.isEmpty((Collection)userExceptionsToExcludedFoldersList)) {
            for (Object userExcludedFolders : userExceptionsToExcludedFoldersList) {
                if (userExcludedFolders == null) continue;
                backupFolderElement = new BackupFolderElement();
                backupFolderElement.setFolderPath(userExcludedFolders.getFolderPath());
                element.getExceptionsToExclusions().add(backupFolderElement);
            }
        }
        element.setSqlBackupFolderPaths(new ArrayList());
        boolean isSQLBackupEnabled = this.isSQLBackupEnabled(cloud);
        if (isSQLBackupEnabled && !CollectionUtils.isEmpty((Collection)sqlBackupFoldersList)) {
            for (SQLBackupFolders sqlBackupFolder : sqlBackupFoldersList) {
                if (sqlBackupFolder == null) continue;
                BackupFolderElement backupFolderElement2 = new BackupFolderElement();
                backupFolderElement2.setFolderPath(sqlBackupFolder.getFolderPath());
                element.getSqlBackupFolderPaths().add(backupFolderElement2);
            }
        }
        List<NetworkThrottlingElement> networkThrottlingElements = this.getNetworkThrottlingElements(backupPolicy);
        element.setScheduleElements(scheduleElements);
        element.setNoBkpScheduleElements(noBkpScheduleElements);
        List relealseList = this.releaseDao.getAllCurrentVersions();
        if (relealseList != null && relealseList.isEmpty()) {
            Release release = (Release)relealseList.get(0);
            element.setUiVersion(1);
        }
        element.setStatisticsCollectorEnabled(backupPolicy.isStatisticsCollectorEnabled());
        element.setBackupFolderPaths(backupFolderElements);
        element.setCalloutScriptElements(calloutScriptElements);
        element.setNetworkThrottlingElements(networkThrottlingElements);
        element.setLastModifiedTimestamp(user.getSyncPolicyModifiedTime());
        element.setPolicyRefresh(backupPolicy.getPolicyRefresh());
        if (!org.springframework.util.StringUtils.isEmpty((Object)backupPolicy.getStatisticsRefresh())) {
            element.setStatisticsRefresh(backupPolicy.getStatisticsRefresh());
        } else {
            element.setStatisticsRefresh(backupPolicy.getPolicyRefresh());
        }
        List ebmsMappingsList = this.bluVaultDao.getAllBluVaults(cloudId, cloudName);
        ArrayList<BluVaultMappingElement> ebmsMappingElements = new ArrayList<BluVaultMappingElement>();
        if (!CollectionUtils.isEmpty((Collection)ebmsMappingsList)) {
            for (Object ebmsMapping : ebmsMappingsList) {
                BluVaultMappingElement ebmsMappingElement = new BluVaultMappingElement();
                BeanUtils.copyProperties((Object)ebmsMapping, (Object)ebmsMappingElement);
                ebmsMappingElements.add(ebmsMappingElement);
            }
            element.setBluVaultMappingElements(ebmsMappingElements);
        }
        element.setFullBackupEnabled(backupPolicy.isFullBackupEnabled());
        element.setFullBackupStartDate(backupPolicy.getFullBackupStartDate());
        ArrayList<EndpointUiPreferencesElement> uiPreferenceElements = new ArrayList<EndpointUiPreferencesElement>();
        if (!CollectionUtils.isEmpty((Collection)backupPolicy.getEndpointUiPreferences())) {
            for (String uiPreference : backupPolicy.getEndpointUiPreferences()) {
                EndpointUiPreferencesElement endpointUiPreferencesElement = new EndpointUiPreferencesElement();
                endpointUiPreferencesElement.setEndpointsUiPreferences(uiPreference);
                uiPreferenceElements.add(endpointUiPreferencesElement);
            }
        }
        ArrayList<EndpointUiDisabledPreferencesElement> uiDisabledPreferenceElements = new ArrayList<EndpointUiDisabledPreferencesElement>();
        if (!CollectionUtils.isEmpty((Collection)backupPolicy.getEndpointDisabledUiPreferences())) {
            for (String uiPreference : backupPolicy.getEndpointDisabledUiPreferences()) {
                EndpointUiDisabledPreferencesElement endpointUiDisabledPreferencesElement = new EndpointUiDisabledPreferencesElement();
                endpointUiDisabledPreferencesElement.setEndpointDisabledUiPreferences(uiPreference);
                uiDisabledPreferenceElements.add(endpointUiDisabledPreferencesElement);
            }
        }
        element.setEndpointUiDisabledPreferencesElementList(uiDisabledPreferenceElements);
        element.setEndpointUiPreferencesElementList(uiPreferenceElements);
        logger.debug(backupPolicy.getAgentPassword() + "................." + backupPolicy.isSwitchAgentPassword());
        element.setSwitchAgentPassword(backupPolicy.isSwitchAgentPassword());
        element.setAgentPassword(backupPolicy.getAgentPassword());
        element.setServerPassword(backupPolicy.getServerPassword());
        element.setServerUserName(backupPolicy.getServerUserName());
        logger.debug("..........LogUnaccessedFile........." + cloudProperties.isLogUnaccessedFiles());
        element.setLogUnaccessedFiles(cloudProperties.isLogUnaccessedFiles());
        return element;
    }

    private InclusionFilterElement getFilter(List<InclusionFilter> filters, String filterType, boolean backupFilesWithoutExtension) {
        InclusionFilterElement filterElement = new InclusionFilterElement();
        StringBuilder fileExtensions = new StringBuilder();
        InclusionFilter inclusionFilter = new InclusionFilter();
        inclusionFilter = filters.get(0);
        filterElement.setFilterName(inclusionFilter.getFilterName());
        filterElement.setFilterType(filterType);
        for (InclusionFilter filter : filters) {
            fileExtensions.append(filter.getExtensionName());
            fileExtensions.append(",");
        }
        if (backupFilesWithoutExtension && filterType.equalsIgnoreCase("inclusion")) {
            fileExtensions.append("no_ext");
            fileExtensions.append(",");
        }
        filterElement.setFilters(fileExtensions.toString().replaceAll(",$", ""));
        return filterElement;
    }

    private boolean isSQLBackupEnabled(Cloud cl) {
        boolean isSQLBackupEnabled = false;
        List list = cl.getCloudCustomisableDetails();
        list.removeAll(Collections.singleton(null));
        if (!CollectionUtils.isEmpty((Collection)list)) {
            for (CloudCustomisableDetails cloudPluginDetails : list) {
                if (cloudPluginDetails == null || org.springframework.util.StringUtils.isEmpty((Object)cloudPluginDetails.getName()) || !"SQL Backup Enabled".equalsIgnoreCase(cloudPluginDetails.getName())) continue;
                isSQLBackupEnabled = true;
                break;
            }
        }
        logger.debug("SQL Backup Enabled" + isSQLBackupEnabled);
        return isSQLBackupEnabled;
    }

    private ArrayList<InclusionFilter> getFiltersbyName(int cloudId, String cloudName, List<String> filterNames) {
        ArrayList<InclusionFilter> inclusionFilters = new ArrayList<InclusionFilter>();
        for (String filterName : filterNames) {
            InclusionFilter inclusionFilter = this.inclusionFilterDao.getInclusionFilter(cloudId, cloudName, filterName);
            if (inclusionFilter == null) continue;
            inclusionFilters.add(inclusionFilter);
        }
        return inclusionFilters;
    }

    private List<BackupFolderElement> getBackupFolderElements(BackupPolicy backupPolicy) {
        ArrayList backupFolders = backupPolicy.getBackupFolders();
        ArrayList<BackupFolderElement> backupFolderElements = new ArrayList<BackupFolderElement>();
        for (BackupFolders folders : backupFolders) {
            BackupFolderElement backupFolderElement = new BackupFolderElement();
            backupFolderElement.setFolderPath(folders.getFolderPath());
            backupFolderElement.setOsType(folders.getOs());
            backupFolderElements.add(backupFolderElement);
        }
        return backupFolderElements;
    }

    private List<CalloutScriptElement> getCalloutScriptElements(BackupPolicy backupPolicy) {
        ArrayList calloutScript = backupPolicy.getCalloutScripts();
        ArrayList<CalloutScriptElement> calloutScriptElements = new ArrayList<CalloutScriptElement>();
        for (CalloutScript script : calloutScript) {
            CalloutScriptElement calloutScriptElement = new CalloutScriptElement();
            calloutScriptElement.setScriptName(script.getScriptName());
            calloutScriptElement.setScriptArgs(script.getScriptArgs());
            calloutScriptElement.setScriptType(script.getScriptType());
            calloutScriptElements.add(calloutScriptElement);
        }
        return calloutScriptElements;
    }

    private List<BluSyncScheduleElement> getScheduleElements(BackupPolicy backupPolicy) {
        ArrayList schedules = backupPolicy.getSchedules();
        ArrayList<BluSyncScheduleElement> scheduleElements = new ArrayList<BluSyncScheduleElement>();
        for (Schedule schedule : schedules) {
            BluSyncScheduleElement scheduleElement = new BluSyncScheduleElement();
            BeanUtils.copyProperties((Object)schedule, (Object)scheduleElement);
            List<ScheduleDaysArrayElement> arrayElements = this.getScheduleDays(schedule, scheduleElement);
            scheduleElement.setDayArray(arrayElements);
            scheduleElement.setBackupType(schedule.getBackupType());
            scheduleElements.add(scheduleElement);
        }
        return scheduleElements;
    }

    private List<ScheduleDaysArrayElement> getScheduleDays(Schedule schedule, BluSyncScheduleElement scheduleElement) {
        ArrayList<ScheduleDaysArrayElement> scheduleDaysArrayElements = new ArrayList<ScheduleDaysArrayElement>();
        for (Integer dayArray : schedule.getDayArray()) {
            ScheduleDaysArrayElement daysArrayElement = new ScheduleDaysArrayElement();
            daysArrayElement.setDay(dayArray);
            scheduleDaysArrayElements.add(daysArrayElement);
        }
        return scheduleDaysArrayElements;
    }

    private List<NetworkThrottlingElement> getNetworkThrottlingElements(BackupPolicy backupPolicy) {
        ArrayList<NetworkThrottlingElement> networkThrottlingElements = new ArrayList<NetworkThrottlingElement>();
        ArrayList networkThrottlings = backupPolicy.getNetworkThrottlings();
        for (NetworkThrottling networkThrottling : networkThrottlings) {
            NetworkThrottlingElement networkThrottlingElement = new NetworkThrottlingElement();
            BeanUtils.copyProperties((Object)networkThrottling, (Object)networkThrottlingElement);
            networkThrottlingElement.setEndTime(networkThrottling.getEndTime());
            networkThrottlingElements.add(networkThrottlingElement);
        }
        return networkThrottlingElements;
    }

    @Override
    public void saveOPWS(int cloudId, String cloudName, OPWS opws) {
        this.backupPolicyDao.saveOPWS(cloudId, cloudName, opws);
    }

    @Override
    public long getThreadSize(int cloudId, String cloudName) {
        return this.backupPolicyDao.getThreadSize(cloudId, cloudName);
    }

    private void saveStatisticToDatabase(int cloudId, String cloudName, String action, String actionByUser, String actionOnUser, int actionType) {
        AuditHistory audit = this.auditHistoryDefaultValue(action, actionByUser, actionType);
        audit.setActionOnObject(actionOnUser);
        this.auditHistoryDao.saveAudit(cloudId, cloudName, audit);
    }

    @Override
    public BluSyncGroupBackupPolicyElement getBluSyncGroupPolicyElement(BackupPolicy backupPolicy, int cloudId, String cloudName, String deviceUUID, String userName) {
        BackupFolderElement backupFolderElement;
        ArrayList searcFilters;
        List filters;
        BluSyncGroupBackupPolicyElement element = new BluSyncGroupBackupPolicyElement();
        BeanUtils.copyProperties((Object)backupPolicy, (Object)element);
        element.setPolicygroupName(backupPolicy.getPolicyName());
        if (backupPolicy.getCrawlLimit() != 0) {
            element.setCrawlLimit(String.valueOf(backupPolicy.getCrawlLimit()));
        }
        if (backupPolicy.getFileChunkableSize() != 0) {
            element.setFileChunkableSize(String.valueOf(backupPolicy.getFileChunkableSize()));
        }
        if (!CollectionUtils.isEmpty((Collection)(filters = backupPolicy.getInclusionFilter()))) {
            element.setInclusionFilterElement(this.getFilter(filters, backupPolicy.getFilterType(), backupPolicy.isBackupFilesWithoutExtension()));
        }
        if (!CollectionUtils.isEmpty((Collection)(searcFilters = backupPolicy.getSearchInclusionFilter()))) {
            element.setSearchInclusionFilterElement(this.getFilter(searcFilters, backupPolicy.getFilterType(), backupPolicy.isBackupFilesWithoutExtension()));
        }
        List<BluSyncScheduleElement> scheduleElements = this.getScheduleElements(backupPolicy);
        List<BluSyncNoBKPScheduleElement> noBKPScheduleElements = this.getNoBKPScheduleElements(backupPolicy);
        BSPrivacyGatewayMappingElement mappingElement = new BSPrivacyGatewayMappingElement();
        mappingElement.setBsPrivacyGatewayElementsList(new ArrayList());
        List defaultPGList = this.privacyGateWayDao.getAllGateways(cloudId);
        for (PrivacyGateway gateway : defaultPGList) {
            mappingElement.setGatewayNwThrottlingName(GATEWAY);
            if (gateway == null) continue;
            BSPrivacyGatewayElement pgelement = new BSPrivacyGatewayElement();
            logger.debug("process =  checking if it is a hosted setup from Mongo properties collection");
            boolean isHostedSetup = this.mongoPropertiesDao.checkHostedSetup(cloudId);
            if (isHostedSetup) {
                logger.debug("It is a hosted setup getting the public IP for the domain name");
                Iterator publicIpAddress = this.getIPAddressFromDomain(gateway.getGatewayName(), cloudId);
                if (!org.springframework.util.StringUtils.isEmpty((Object)publicIpAddress)) {
                    pgelement.setName(publicIpAddress);
                } else {
                    pgelement.setName(gateway.getGatewayName());
                }
            } else {
                pgelement.setName(gateway.getGatewayName());
            }
            pgelement.setType(gateway.getType());
            mappingElement.getBsPrivacyGatewayElementsList().add(pgelement);
        }
        element.setBSPrivacyGatewayMappingElement(mappingElement);
        List<BackupFolderElement> backupFolderElements = this.getBackupFolderElements(backupPolicy);
        List userDefinedFoldersList = this.userDefinedFoldersDao.getAllUserDefinedInclusionFolders(cloudId, cloudName, deviceUUID, userName);
        ArrayList userExcludedFoldersList = backupPolicy.getExcludedFolders();
        List<CalloutScriptElement> calloutScriptElements = this.getCalloutScriptElements(backupPolicy);
        if (!CollectionUtils.isEmpty((Collection)userDefinedFoldersList)) {
            for (UserDefinedFolders userDefinedFolders : userDefinedFoldersList) {
                backupFolderElement = new BackupFolderElement();
                backupFolderElement.setFolderPath(userDefinedFolders.getFolderPath());
                backupFolderElements.add(backupFolderElement);
            }
        }
        if (!CollectionUtils.isEmpty((Collection)userExcludedFoldersList)) {
            element.setExcludedFolderPaths(new ArrayList());
            for (ExcludedFolders userExcludedFolders : userExcludedFoldersList) {
                backupFolderElement = new BackupFolderElement();
                backupFolderElement.setFolderPath(userExcludedFolders.getFolderPath());
                element.getExcludedFolderPaths().add(backupFolderElement);
            }
        }
        List<NetworkThrottlingElement> networkThrottlingElements = this.getNetworkThrottlingElements(backupPolicy);
        element.setScheduleElements(scheduleElements);
        element.setNoBkpScheduleElements(noBKPScheduleElements);
        element.setUiVersion(1);
        element.setStatisticsCollectorEnabled(backupPolicy.isStatisticsCollectorEnabled());
        element.setBackupFolderPaths(backupFolderElements);
        element.setCalloutScriptElements(calloutScriptElements);
        element.setNetworkThrottlingElements(networkThrottlingElements);
        if (backupPolicy.getLastModifiedTimestamp() == 0L) {
            element.setLastModifiedTimestamp(0L);
        } else {
            element.setLastModifiedTimestamp(backupPolicy.getLastModifiedTimestamp());
        }
        element.setPolicyRefresh(backupPolicy.getPolicyRefresh());
        if (!org.springframework.util.StringUtils.isEmpty((Object)backupPolicy.getStatisticsRefresh())) {
            element.setStatisticsRefresh(backupPolicy.getStatisticsRefresh());
        } else {
            element.setStatisticsRefresh(backupPolicy.getPolicyRefresh());
        }
        List ebmsMappingsList = this.bluVaultDao.getAllBluVaults(cloudId, cloudName);
        ArrayList<BluVaultMappingElement> ebmsMappingElements = new ArrayList<BluVaultMappingElement>();
        if (!CollectionUtils.isEmpty((Collection)ebmsMappingsList)) {
            for (BluVault ebmsMapping : ebmsMappingsList) {
                BluVaultMappingElement ebmsMappingElement = new BluVaultMappingElement();
                BeanUtils.copyProperties((Object)ebmsMapping, (Object)ebmsMappingElement);
                ebmsMappingElements.add(ebmsMappingElement);
            }
            element.setBluVaultMappingElements(ebmsMappingElements);
        }
        return element;
    }

    @Override
    public List<String> getAllBackupPolicyNames(int cloudId, String cloudName) {
        List backupPolicyList = this.backupPolicyDao.getAllBackupPolicies(cloudId);
        return backupPolicyList.stream().filter(policy -> !org.springframework.util.StringUtils.isEmpty((Object)policy.getPolicyName())).sorted(Comparator.comparing(Policy::getPolicyName)).map(policy -> policy.getPolicyName()).collect(Collectors.toList());
    }

    @Override
    public boolean checkPolicyMappedToUsers(int cloudId, String policyName, String policyType, HttpServletResponse response) {
        boolean isPolicyMapped = this.userDao.checkPolicyMappedToUsers(cloudId, policyName, policyType);
        if (!isPolicyMapped) {
            List allReadOnlyAdmins = this.userDao.getAllReadOnlyAdmins(cloudId);
            CloudPropertyElement cloudPropertyElement = this.cloudSettingService.getCloudPropertyElement(cloudId);
            if (!CollectionUtils.isEmpty((Collection)allReadOnlyAdmins)) {
                ArrayList policyNames = new ArrayList();
                for (User user : allReadOnlyAdmins) {
                    if (!CollectionUtils.isEmpty((Collection)user.getBackupPoliciesAdmin())) {
                        policyNames.addAll(user.getBackupPoliciesAdmin());
                    }
                    if (!CollectionUtils.isEmpty((Collection)user.getSyncPoliciesAdmin())) {
                        policyNames.addAll(user.getSyncPoliciesAdmin());
                    }
                    if (CollectionUtils.isEmpty(policyNames) || policyNames.size() != 1 || !policyNames.contains(policyName)) continue;
                    isPolicyMapped = true;
                    response.setStatus(444);
                    return isPolicyMapped;
                }
            }
            if ("backupPolicy".equalsIgnoreCase(policyType)) {
                if (cloudPropertyElement.getDefaultBkpPolicyName().equals(policyName)) {
                    isPolicyMapped = true;
                    response.setStatus(445);
                    return isPolicyMapped;
                }
            } else if (cloudPropertyElement.getDefaultSyncPolicyName().equals(policyName) || cloudPropertyElement.getDefaultGuestSyncPolicyName().equals(policyName)) {
                isPolicyMapped = true;
                response.setStatus(445);
                return isPolicyMapped;
            }
        } else {
            response.setStatus(333);
        }
        return isPolicyMapped;
    }

    @Override
    public void blockPolicy(int cloudId, String policyName, String userName, String policyType) {
        this.backupPolicyDao.blockPolicy(cloudId, policyName, policyType);
        if ("backupPolicy".equalsIgnoreCase(policyType)) {
            this.saveStatisticToDatabase(cloudId, " Blocked backup policy " + policyName, userName, PCActionTypes.BACKUP_POLICY_BLOCK.getActionTypeValue());
        } else {
            this.saveStatisticToDatabase(cloudId, " Blocked sync policy " + policyName, userName, PCActionTypes.SYNC_POLICY_BLOCK.getActionTypeValue());
        }
    }

    private void saveStatisticToDatabase(int cloudId, String action, String actionByUser, int actionType) {
        AuditHistory audit = this.auditHistoryDefaultValue(action, actionByUser, actionType);
        audit.setActionOnObject("");
        this.auditHistoryDao.saveAuditHistory(cloudId, audit);
    }

    private AuditHistory auditHistoryDefaultValue(String action, String actionByUser, int actionType) {
        AuditHistory audit = new AuditHistory();
        audit.setAction(action);
        audit.setActionByUserName(actionByUser);
        audit.setTimestamp(System.currentTimeMillis());
        if (actionByUser.equals("AUTO_Pack_Manager")) {
            audit.setActionUsingObject("Order Center");
        } else {
            audit.setActionUsingObject("Portal");
        }
        audit.setActionType(actionType);
        return audit;
    }

    @Override
    public BackupPolicy getBackupPolicy(int cloudId, String policyName) {
        return this.userDao.getBackupPolicyByPolicyName(cloudId, policyName);
    }

    @Override
    public List<BackupPolicyElement> loadAllBackupPolicies(int cloudId) {
        List backupPolicyList = this.backupPolicyDao.loadAllBackupPolicies(cloudId);
        ArrayList<BackupPolicyElement> elements = new ArrayList<BackupPolicyElement>();
        for (BackupPolicy backupPolicy : backupPolicyList) {
            BackupPolicyElement element = this.loadAllBackupPolicyElements(cloudId, backupPolicy);
            elements.add(element);
        }
        return elements;
    }

    @Override
    public List<BackupPolicyElement> getAllBackupPoliciesByPagination(int cloudId, int pageNo) {
        List backupPolicyList = this.backupPolicyDao.getAllBackupPoliciesByPagination(cloudId, pageNo);
        ArrayList<BackupPolicyElement> elements = new ArrayList<BackupPolicyElement>();
        for (BackupPolicy backupPolicy : backupPolicyList) {
            logger.debug("....policy names ..." + backupPolicy.getPolicyName());
            BackupPolicyElement element = this.loadAllBackupPolicyElements(cloudId, backupPolicy);
            elements.add(element);
        }
        return elements;
    }

    @Override
    public long loadAllBackupPoliciesCount(int cloudId) {
        return this.backupPolicyDao.loadAllBackupPoliciesCount(cloudId);
    }

    @Override
    public List<BackupPolicyElement> loadLiteBackupPolicies(int cloudId) {
        List backupPolicyList = this.backupPolicyDao.loadLiteBackupPolicies(cloudId);
        ArrayList<BackupPolicyElement> elements = new ArrayList<BackupPolicyElement>();
        for (BackupPolicy backupPolicy : backupPolicyList) {
            BackupPolicyElement element = this.loadAllBackupPolicyElements(cloudId, backupPolicy);
            elements.add(element);
        }
        return elements;
    }

    @Override
    public boolean checkOfficePolicyMappedToUsers(int cloudId, String policyName, HttpServletResponse response, String policyType) {
        boolean isPolicyMapped = this.userDao.checkOfficePolicyMappedToUsers(cloudId, policyName, policyType);
        if (!isPolicyMapped) {
            List allReadOnlyAdmins = this.userDao.getAllReadOnlyAdmins(cloudId);
            CloudPropertyElement cloudPropertyElement = this.cloudSettingService.getCloudPropertyElement(cloudId);
            if (!CollectionUtils.isEmpty((Collection)allReadOnlyAdmins)) {
                ArrayList policyNames = new ArrayList();
                for (User user : allReadOnlyAdmins) {
                    if (!CollectionUtils.isEmpty((Collection)user.getBackupPoliciesAdmin())) {
                        policyNames.addAll(user.getBackupPoliciesAdmin());
                    }
                    if (!CollectionUtils.isEmpty((Collection)user.getSyncPoliciesAdmin())) {
                        policyNames.addAll(user.getSyncPoliciesAdmin());
                    }
                    if (CollectionUtils.isEmpty(policyNames) || policyNames.size() != 1 || !policyNames.contains(policyName)) continue;
                    isPolicyMapped = true;
                    response.setStatus(444);
                    return isPolicyMapped;
                }
            }
            if (policyName.equals(cloudPropertyElement.getDefaultExchangePolicyName()) || policyName.equals(cloudPropertyElement.getDefaultOdbPolicyName()) || policyName.equals(cloudPropertyElement.getDefaultSharepointPolicyName())) {
                isPolicyMapped = true;
                response.setStatus(445);
                return isPolicyMapped;
            }
        } else {
            response.setStatus(333);
        }
        return isPolicyMapped;
    }

    @Override
    public void blockOfficePolicy(int cloudId, String policyName, String userName, String policyType) {
        this.backupPolicyDao.blockOfficePolicy(cloudId, policyName, policyType);
        this.saveStatisticToDatabase(cloudId, String.format(BLOCK_OFFICE_POLICY_ACTION, policyType.equals(SHARE_POINT_PRODUCT) ? "SharePoint Online" : policyType) + policyName, userName, PCActionTypes.O365_BACKUP_POLICY_BLOCK.getActionTypeValue());
    }

    @Override
    public long loadAllBackupPoliciesCount(int cloudId, List<String> policyNames) {
        if (CollectionUtils.isEmpty(policyNames)) {
            return this.backupPolicyDao.loadAllBackupPoliciesCount(cloudId);
        }
        return this.backupPolicyDao.loadAllBackupPoliciesCount(cloudId, policyNames);
    }

    @Override
    public List<BackupPolicyElement> getAllBackupPoliciesByPagination(int cloudId, List<String> policyNames, int skipValue) {
        List backupPolicyList = this.backupPolicyDao.getAllBackupPoliciesByPagination(cloudId, policyNames, skipValue);
        ArrayList<BackupPolicyElement> elements = new ArrayList<BackupPolicyElement>();
        for (BackupPolicy backupPolicy : backupPolicyList) {
            logger.debug("....policy names ..." + backupPolicy.getPolicyName());
            BackupPolicyElement element = this.loadAllBackupPolicyElements(cloudId, backupPolicy);
            elements.add(element);
        }
        return elements;
    }

    @Override
    public long loadAllBackupPoliciesMappingCount(int cloudId, List<String> policyNames) {
        return this.backupPolicyDao.loadAllBackupPoliciesMappingCount(cloudId, policyNames);
    }

    @Override
    public long loadAllOfficeBackupPoliciesMappingCount(int cloudId, List<String> policyNames, String policyType) {
        return this.backupPolicyDao.loadAllOfficeBackupPoliciesMappingCount(cloudId, policyNames, policyType);
    }

    @Override
    public List<PolicyStatisticsElement> getBackupPolicyStatisticsElement(int cloudId, String cloudName, String policyType) {
        List<BackupPolicyElement> backupPolicyElements = this.loadAllBackupPolicies(cloudId);
        if (backupPolicyElements.isEmpty()) {
            backupPolicyElements = new ArrayList<BackupPolicyElement>();
        }
        ReportQueryElement reportQueryElement = new ReportQueryElement();
        List backupOverViewElement = this.reportService.getStorageStatisticsForPolicy(cloudId, reportQueryElement);
        Map<String, List<DailyUserBackupOverViewElement>> backupOverViewElementMap = backupOverViewElement.stream().filter(backupOverViewElement1 -> backupOverViewElement1.getPolicyName() != null).collect(Collectors.groupingBy(DailyUserBackupOverViewElement::getPolicyName));
        ArrayList<PolicyStatisticsElement> responseBackupPolicyElements = new ArrayList<PolicyStatisticsElement>();
        for (BackupPolicyElement backupPolicyElement : backupPolicyElements) {
            PolicyStatisticsElement tempBackupPolicyElement = new PolicyStatisticsElement();
            tempBackupPolicyElement.setMappedUserCount(Long.toString(this.userDao.getBackupPolicyMappedUserCountbyPolicyName(cloudId, backupPolicyElement.getPolicygroupName())));
            long actualStorageUtilized = 0L;
            long totalSizeofDataBackedup = 0L;
            for (Map.Entry<String, List<DailyUserBackupOverViewElement>> entry : backupOverViewElementMap.entrySet()) {
                if (!entry.getKey().equalsIgnoreCase(backupPolicyElement.getPolicygroupName())) continue;
                for (DailyUserBackupOverViewElement element : entry.getValue()) {
                    float actualStorageUtilized1 = Float.parseFloat(element.getActualStorageUtilized().replace(" MB", ""));
                    float totalSizeofDataBackedup1 = Float.parseFloat(element.getStorageUtilized().replace(" MB", ""));
                    actualStorageUtilized += (long)actualStorageUtilized1;
                    totalSizeofDataBackedup += (long)totalSizeofDataBackedup1;
                }
            }
            DecimalFormat df = new DecimalFormat();
            df.setMaximumFractionDigits(2);
            tempBackupPolicyElement.setPolicygroupName(backupPolicyElement.getPolicygroupName());
            if (actualStorageUtilized > 0L) {
                float actualStorageUtilizedInfloat = actualStorageUtilized / 1024L;
                tempBackupPolicyElement.setActualStorageUtilized(Float.parseFloat(df.format(actualStorageUtilizedInfloat)));
            } else {
                tempBackupPolicyElement.setActualStorageUtilized((float)actualStorageUtilized);
            }
            if (totalSizeofDataBackedup > 0L) {
                float totalSizeofDataBackedupInfloat = totalSizeofDataBackedup / 1024L;
                tempBackupPolicyElement.setTotalSizeofDataBackedup(Float.parseFloat(df.format(totalSizeofDataBackedupInfloat)));
            } else {
                tempBackupPolicyElement.setTotalSizeofDataBackedup((float)totalSizeofDataBackedup);
            }
            tempBackupPolicyElement.setProductType("Bluvault");
            responseBackupPolicyElements.add(tempBackupPolicyElement);
        }
        List officeBackupPolicyElement = this.backupPolicyDao.getAllOfficePolicies(cloudId);
        for (OfficeBackupPolicy officeBackupPolicy : officeBackupPolicyElement) {
            PolicyStatisticsElement tempBackupPolicyElement = new PolicyStatisticsElement();
            if (officeBackupPolicy == null || !officeBackupPolicy.isActive()) continue;
            long actualStorageUtilized = 0L;
            long totalSizeofDataBackedup = 0L;
            for (Map.Entry<String, List<DailyUserBackupOverViewElement>> entry : backupOverViewElementMap.entrySet()) {
                if (!entry.getKey().equalsIgnoreCase(officeBackupPolicy.getPolicyName())) continue;
                for (DailyUserBackupOverViewElement element : entry.getValue()) {
                    float actualStorageUtilized1 = Float.parseFloat(element.getActualStorageUtilized().replace(" MB", ""));
                    float totalSizeofDataBackedup1 = Float.parseFloat(element.getStorageUtilized().replace(" MB", ""));
                    actualStorageUtilized += (long)actualStorageUtilized1;
                    totalSizeofDataBackedup += (long)totalSizeofDataBackedup1;
                }
            }
            tempBackupPolicyElement.setMappedUserCount(Long.toString(this.userDao.getODBBackupPolicyMappedUserCountbyPolicyName(cloudId, officeBackupPolicy.getPolicyName(), policyType)));
            tempBackupPolicyElement.setPolicygroupName(officeBackupPolicy.getPolicyName());
            tempBackupPolicyElement.setActualStorageUtilized((float)actualStorageUtilized);
            tempBackupPolicyElement.setTotalSizeofDataBackedup((float)totalSizeofDataBackedup);
            tempBackupPolicyElement.setProductType("Office 365 Backup");
            responseBackupPolicyElements.add(tempBackupPolicyElement);
        }
        List list = this.syncPolicyDao.getAllSyncPolicy(cloudId, cloudName);
        for (SyncPolicy syncPolicy : list) {
            if (syncPolicy == null || syncPolicy.isBlocked()) continue;
            PolicyStatisticsElement tempBackupPolicyElement = new PolicyStatisticsElement();
            tempBackupPolicyElement.setMappedUserCount(Long.toString(this.userDao.getSyncPolicyMappedUserCountbyPolicyName(cloudId, syncPolicy.getPolicyName())));
            tempBackupPolicyElement.setPolicygroupName(syncPolicy.getPolicyName());
            tempBackupPolicyElement.setActualStorageUtilized(0.0f);
            tempBackupPolicyElement.setTotalSizeofDataBackedup(0.0f);
            tempBackupPolicyElement.setProductType("Blusync");
            responseBackupPolicyElements.add(tempBackupPolicyElement);
        }
        return responseBackupPolicyElements;
    }

    private List<BluSyncNoBKPScheduleElement> getNoBKPScheduleElements(BackupPolicy backupPolicy) {
        ArrayList schedules = backupPolicy.getNoBkpSchedules();
        ArrayList<BluSyncNoBKPScheduleElement> scheduleElements = new ArrayList<BluSyncNoBKPScheduleElement>();
        if (!CollectionUtils.isEmpty((Collection)schedules)) {
            for (NoBkpSchedule schedule : schedules) {
                BluSyncNoBKPScheduleElement scheduleElement = new BluSyncNoBKPScheduleElement();
                BeanUtils.copyProperties((Object)schedule, (Object)scheduleElement);
                List<ScheduleDaysArrayElement> arrayElements = this.getNoBkpScheduleDays(schedule, scheduleElement);
                scheduleElement.setDayArray(arrayElements);
                scheduleElement.setBackupType(schedule.getBackupType());
                scheduleElement.setScheduleName(schedule.getScheduleName());
                scheduleElement.setTimeZone(schedule.getTimeZone());
                scheduleElement.setFromTime(schedule.getFromTime());
                scheduleElement.setToTime(schedule.getToTime());
                scheduleElements.add(scheduleElement);
            }
        }
        return scheduleElements;
    }

    private List<ScheduleDaysArrayElement> getNoBkpScheduleDays(NoBkpSchedule schedule, BluSyncNoBKPScheduleElement scheduleElement) {
        ArrayList<ScheduleDaysArrayElement> scheduleDaysArrayElements = new ArrayList<ScheduleDaysArrayElement>();
        for (Integer dayArray : schedule.getDayArray()) {
            ScheduleDaysArrayElement daysArrayElement = new ScheduleDaysArrayElement();
            daysArrayElement.setDay(dayArray);
            scheduleDaysArrayElements.add(daysArrayElement);
        }
        return scheduleDaysArrayElements;
    }

    @Override
    public List<String> filterPolicyNameByProductType(int cloudId, String cloudName, List<String> policyNames, String policyType) {
        List backupPolicies = new ArrayList();
        backupPolicies = this.backupPolicyDao.getAllBackupPoliciesByPagination(cloudId, policyNames, 0);
        return backupPolicies.stream().filter(policy -> policyType.equalsIgnoreCase(policy.getPolicyType())).map(Policy::getPolicyName).collect(Collectors.toList());
    }

    private String getIPAddressFromDomain(String domainName, int cloudId) {
        return this.dnsResolverService.getPublicIp(domainName, cloudId);
    }

    @Override
    public List<BackupPolicy> getAllPolicyDetailFromPolicyName(int cloudId, List<String> policyNames) {
        return this.backupPolicyDao.getAllPolicyDetailFromPolicyName(cloudId, policyNames);
    }

    @Override
    public CloudCapParameter mspCalculateBackupPoliciesParameter(int cloudId) {
        long storageSize = 0L;
        long userCount = 0L;
        long serverCount = 0L;
        List mspBackupPoliciesWithActiveSubscription = this.backupPolicyDao.getMspBackupPoliciesForActiveSubscription(cloudId);
        for (BackupPolicy backupPolicy : mspBackupPoliciesWithActiveSubscription) {
            if (backupPolicy == null || backupPolicy.getPacks() == null || backupPolicy.getPacks().size() <= 0) continue;
            for (PackElement basePack : backupPolicy.getPacks()) {
                if (basePack == null || !basePack.isSubscriptionActive()) continue;
                storageSize += basePack.getStorageSize();
                userCount += (long)basePack.getMinUserCount();
                for (PackElement addonPack : basePack.getAddons()) {
                    if (addonPack == null || !addonPack.isSubscriptionActive()) continue;
                    storageSize += addonPack.getStorageSize();
                    if (addonPack.getSkuCode().startsWith(OrderConstants.SERVER_ADDON)) {
                        serverCount += (long)addonPack.getMinUserCount();
                        continue;
                    }
                    userCount += (long)addonPack.getMinUserCount();
                }
            }
        }
        CloudCapParameter cloudCapParameter = new CloudCapParameter(storageSize * 1000L, serverCount, userCount);
        return cloudCapParameter;
    }

    @Override
    public List<BackupPolicy> getMspBackupPoliciesForActiveSubscription(int cloudId) {
        return this.backupPolicyDao.getMspBackupPoliciesForActiveSubscription(cloudId);
    }
}

