/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.bluvault.udc.service.impl;

import com.google.gson.Gson;
import com.parablu.bluvault.ah.service.AuditHistoryService;
import com.parablu.bluvault.sync.element.SyncOverviewElement;
import com.parablu.bluvault.udc.controller.BaseController;
import com.parablu.bluvault.udc.dto.DeleteDto;
import com.parablu.bluvault.udc.service.AADManagementService;
import com.parablu.bluvault.udc.service.DataAgingService;
import com.parablu.bluvault.udc.service.DeviceManagementService;
import com.parablu.bluvault.udc.service.UserManagementService;
import com.parablu.cloud.security.service.DeviceAndUserSecurityService;
import com.parablu.cloud.security.service.impl.UserValidateService;
import com.parablu.cloud.security.to.CloudLicenseTo;
import com.parablu.helper.exceptions.BaseException;
import com.parablu.helper.exceptions.UserLimitReachedException;
import com.parablu.helper.utils.MD5Generator;
import com.parablu.helper.utils.ObjectDiffFinder;
import com.parablu.mail.service.CloudMailService;
import com.parablu.mt.service.LdapService;
import com.parablu.packs.constants.OrderConstants;
import com.parablu.paracloud.constant.CPHelperConstant;
import com.parablu.paracloud.constant.CloudConfigRegistry;
import com.parablu.paracloud.constant.PCActionTypes;
import com.parablu.paracloud.element.AADUserElement;
import com.parablu.paracloud.element.BackupFolderElement;
import com.parablu.paracloud.element.BackupPoliciesAdminList;
import com.parablu.paracloud.element.BackupPolicyElement;
import com.parablu.paracloud.element.DeviceElement;
import com.parablu.paracloud.element.EmailProps;
import com.parablu.paracloud.element.EmailRecipent;
import com.parablu.paracloud.element.GmailBackupPolicyElement;
import com.parablu.paracloud.element.GmailPoliciesAdminList;
import com.parablu.paracloud.element.GraphUserElement;
import com.parablu.paracloud.element.LdapUserElement;
import com.parablu.paracloud.element.MiniCloudElement;
import com.parablu.paracloud.element.MiniCloudElementList;
import com.parablu.paracloud.element.OdbMappingList;
import com.parablu.paracloud.element.OdbPolicesAdminList;
import com.parablu.paracloud.element.OfficeBackupPolicyElement;
import com.parablu.paracloud.element.PackElement;
import com.parablu.paracloud.element.PrivacyGatewayMappingElement;
import com.parablu.paracloud.element.SearchUserElement;
import com.parablu.paracloud.element.SiteElement;
import com.parablu.paracloud.element.SpPolicesAdminList;
import com.parablu.paracloud.element.SyncPoliciesAdminList;
import com.parablu.paracloud.element.SyncPolicyElement;
import com.parablu.paracloud.element.UserDeviceCommentsElement;
import com.parablu.paracloud.element.UserElement;
import com.parablu.paracloud.element.UserGroupElement;
import com.parablu.paracloud.element.UserListElement;
import com.parablu.paracloud.element.bp.ExcludedFolderElement;
import com.parablu.paracloud.element.response.UserErrorReponse;
import com.parablu.paracloud.util.DateUtil;
import com.parablu.pcbd.dao.AuditHistoryDao;
import com.parablu.pcbd.dao.AuthorizationDao;
import com.parablu.pcbd.dao.BackupBatchDao;
import com.parablu.pcbd.dao.BackupOverViewDao;
import com.parablu.pcbd.dao.BackupPolicyDao;
import com.parablu.pcbd.dao.CloudDao;
import com.parablu.pcbd.dao.DeletedUserDao;
import com.parablu.pcbd.dao.DeviceDao;
import com.parablu.pcbd.dao.FileRevisionDao;
import com.parablu.pcbd.dao.MigrationStatusDao;
import com.parablu.pcbd.dao.MiniCloudDao;
import com.parablu.pcbd.dao.PciAuthorizationTokensDao;
import com.parablu.pcbd.dao.PersonDao;
import com.parablu.pcbd.dao.PortalPropertiesDao;
import com.parablu.pcbd.dao.SearchIndexDao;
import com.parablu.pcbd.dao.UserDao;
import com.parablu.pcbd.dao.UserGroupDao;
import com.parablu.pcbd.dao.UserMiniCloudMappingDao;
import com.parablu.pcbd.domain.AdCredentials;
import com.parablu.pcbd.domain.AuditHistory;
import com.parablu.pcbd.domain.BackupBatch;
import com.parablu.pcbd.domain.BackupFolders;
import com.parablu.pcbd.domain.BackupPolicy;
import com.parablu.pcbd.domain.Cloud;
import com.parablu.pcbd.domain.CloudCustomisableDetails;
import com.parablu.pcbd.domain.CloudProperties;
import com.parablu.pcbd.domain.DailySyncOverView;
import com.parablu.pcbd.domain.DeletedSearchIndex;
import com.parablu.pcbd.domain.DeletedUser;
import com.parablu.pcbd.domain.Device;
import com.parablu.pcbd.domain.DeviceBackupOverView;
import com.parablu.pcbd.domain.ExcludedFolders;
import com.parablu.pcbd.domain.FailedLogin;
import com.parablu.pcbd.domain.GmailBackupPolicy;
import com.parablu.pcbd.domain.GmailProperties;
import com.parablu.pcbd.domain.Group;
import com.parablu.pcbd.domain.MSAppSetting;
import com.parablu.pcbd.domain.MSGraphUserProperties;
import com.parablu.pcbd.domain.MigrationStatus;
import com.parablu.pcbd.domain.MiniCloud;
import com.parablu.pcbd.domain.NetworkThrottling;
import com.parablu.pcbd.domain.OfficeBackupPolicy;
import com.parablu.pcbd.domain.PciAuthorizationTokens;
import com.parablu.pcbd.domain.Person;
import com.parablu.pcbd.domain.Policy;
import com.parablu.pcbd.domain.PortalProperties;
import com.parablu.pcbd.domain.PrivacyGateway;
import com.parablu.pcbd.domain.Schedule;
import com.parablu.pcbd.domain.SharePointProperties;
import com.parablu.pcbd.domain.SyncOverView;
import com.parablu.pcbd.domain.TenantConsentStatus;
import com.parablu.pcbd.domain.User;
import com.parablu.pcbd.domain.UserCloudAccessControl;
import com.parablu.pcbd.domain.UserDeviceAccessControl;
import com.parablu.pcbd.domain.UserDeviceComments;
import com.parablu.pcbd.domain.UserGroup;
import com.parablu.pcsd.dao.SyncPolicyDao;
import com.parablu.pcsd.domain.SyncPolicy;
import jakarta.annotation.Resource;
import jakarta.servlet.http.HttpServletResponse;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base32;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.commons.validator.routines.EmailValidator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bson.types.ObjectId;
import org.joda.time.DateTime;
import org.joda.time.Days;
import org.joda.time.ReadableInstant;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.util.CollectionUtils;

public class UserManagementServiceImpl
extends UserValidateService
implements UserManagementService {
    public static final String DD_MMM_YYYY_HH_MM_SS = "dd-MMM-yyyy HH:mm:ss";
    private static final String ACCOUNT_TYPE = "accountType";
    private static final String ADMIN = "Admin";
    private static final String USER = "User";
    private static final String DELEGATED_ADMIN = "Delegated Administrator";
    private static final String READ_ONLY_ADMIN = "Read Only Admin";
    private static final String PARABLU_GETTING_STARTED_DOWNLOAD_LINK = "https://www.parablu.com/wp-content/uploads/2016/09/Parablu_getting_started.pdf";
    private static final String PARABLU_GETTING_STARTED_PDF = "Parablu getting started.pdf";
    private static final String GUIDE_DIRECTORY = "bkpOverview/GUIDE/";
    private static Logger logger = LogManager.getLogger(UserManagementServiceImpl.class);
    private UserDao userDao;
    private MiniCloudDao miniCloudDao;
    private UserMiniCloudMappingDao userMiniCloudMappingDao;
    private DeviceDao deviceDao;
    private AuthorizationDao authorizationDao;
    private PciAuthorizationTokensDao pciAuthorizationTokensDao;
    private BackupPolicyDao backupPolicyDao;
    private SyncPolicyDao syncPolicyDao;
    private DeletedUserDao deletedUserDao;
    private UserGroupDao userGroupDao;
    private FileRevisionDao fileRevisionDao;
    private PersonDao personDao;
    private MigrationStatusDao migrationStatusDao;
    @Autowired
    private CloudMailService cloudMailService;
    @Autowired
    private AuditHistoryService auditHistoryService;
    @Resource
    private BackupOverViewDao backupOverViewDao;
    @Autowired
    private DeviceManagementService deviceManagementService;
    @Autowired
    private AADManagementService aadManagementService;
    @Autowired
    private DeviceAndUserSecurityService deviceAndUserSecurityService;
    @Resource
    private AuditHistoryDao auditHistoryDao;
    @Autowired
    private LdapService ldapService;
    @Autowired
    private CloudDao cloudDao;
    @Autowired
    private BackupBatchDao backupBatchDao;
    @Autowired
    private PortalPropertiesDao portalPropertiesDao;
    @Autowired
    private DataAgingService dataAgingService;
    @Autowired
    CloudConfigRegistry registry;
    private SearchIndexDao searchIndexDao;
    private static final int NO_OF_HASHES = 5;
    private static final String USER_NOT_FOUND = "User not found.";
    private static final String BASE_EXCEPTION = " BaseException  :";
    private static final String EXCEPTION = " Exception  :";
    private static final String NUMBER_FORMAT_EXCEPTION = "NumberFormatException  ";
    private static final String MM_DD_YYYY_HH_MM_SS = "MM/dd/yyyy HH:mm:ss";
    private static final String SYNC_ENABLED = "Sync Enabled";
    private static final String BACKUP_ENABLED = "Backup Enabled";
    private static final String MSP_LICENSE = "MSP Environment Enabled";
    private static final String gmail_Backup_Enabled = "Gmail Backup Enabled";
    private static final String gdrive_Backup_Enabled = "GDRIVE Backup Enabled";
    private static final int AD_CONNECTION_FAILED = 400;
    private static final String SECRET_KEY = "a9985ebcae81";
    public static final String HH_MM_SS = "HH:mm:ss";
    public static final String DD_MMM_YYYY = "dd-MMM-yyyy";

    public void setDeviceManagementService(DeviceManagementService deviceManagementService) {
        this.deviceManagementService = deviceManagementService;
    }

    public void setDataAgingService(DataAgingService dataAgingService) {
        this.dataAgingService = dataAgingService;
    }

    public PortalPropertiesDao getPortalPropertiesDao() {
        return this.portalPropertiesDao;
    }

    public void setPortalPropertiesDao(PortalPropertiesDao portalPropertiesDao) {
        this.portalPropertiesDao = portalPropertiesDao;
    }

    public void setBackupBatchDao(BackupBatchDao backupBatchDao) {
        this.backupBatchDao = backupBatchDao;
    }

    public void setCloudDao(CloudDao cloudDao) {
        this.cloudDao = cloudDao;
    }

    public void setSearchIndexDao(SearchIndexDao searchIndexDao) {
        this.searchIndexDao = searchIndexDao;
    }

    public void setLdapService(LdapService ldapService) {
        this.ldapService = ldapService;
    }

    public SyncPolicyDao getSyncPolicyDao() {
        return this.syncPolicyDao;
    }

    public void setSyncPolicyDao(SyncPolicyDao syncPolicyDao) {
        this.syncPolicyDao = syncPolicyDao;
    }

    public void setFileRevisionDao(FileRevisionDao fileRevisionDao) {
        this.fileRevisionDao = fileRevisionDao;
    }

    public void setUserGroupDao(UserGroupDao userGroupDao) {
        this.userGroupDao = userGroupDao;
    }

    public MiniCloudDao getMiniCloudDao() {
        return this.miniCloudDao;
    }

    public void setMiniCloudDao(MiniCloudDao miniCloudDao) {
        this.miniCloudDao = miniCloudDao;
    }

    public UserMiniCloudMappingDao getUserMiniCloudMappingDao() {
        return this.userMiniCloudMappingDao;
    }

    public void setUserMiniCloudMappingDao(UserMiniCloudMappingDao userMiniCloudMappingDao) {
        this.userMiniCloudMappingDao = userMiniCloudMappingDao;
    }

    public void setDeviceDao(DeviceDao deviceDao) {
        this.deviceDao = deviceDao;
    }

    public void setAuthorizationDao(AuthorizationDao authorizationDao) {
        this.authorizationDao = authorizationDao;
    }

    public PciAuthorizationTokensDao getPciAuthorizationTokensDao() {
        return this.pciAuthorizationTokensDao;
    }

    public void setPciAuthorizationTokensDao(PciAuthorizationTokensDao pciAuthorizationTokensDao) {
        this.pciAuthorizationTokensDao = pciAuthorizationTokensDao;
    }

    public void setBackupPolicyDao(BackupPolicyDao backupPolicyDao) {
        this.backupPolicyDao = backupPolicyDao;
    }

    public void setPersonDao(PersonDao personDao) {
        this.personDao = personDao;
    }

    public void setUserDao(UserDao userDao) {
        this.userDao = userDao;
    }

    @Override
    public UserElement createUser(int cloudId, String cloudName, UserElement userElement, String currentUserName, String encryptedPassword, boolean ispswdencrypted, boolean sendMail) {
        Cloud cloud;
        boolean isMSPEnv;
        UserElement createdUser;
        String recoveryKey;
        User user;
        UserElement userResponse;
        block12: {
            userResponse = new UserElement();
            user = new User();
            UUID uuid = UUID.randomUUID();
            recoveryKey = String.valueOf(uuid);
            createdUser = null;
            isMSPEnv = false;
            cloud = this.cloudDao.getCloudDetails(cloudName);
            List list = cloud.getCloudCustomisableDetails();
            for (CloudCustomisableDetails customisableDetails : list) {
                if (!MSP_LICENSE.equalsIgnoreCase(customisableDetails.getName())) continue;
                isMSPEnv = true;
            }
            try {
                createdUser = this.createUser(cloudId, cloudName, userElement, false, this.userDao);
                if (createdUser != null) {
                    BeanUtils.copyProperties((Object)createdUser, (Object)userResponse);
                    userResponse.setShareEnabled(createdUser.isShareEnabled());
                    BeanUtils.copyProperties((Object)createdUser, (Object)user);
                    this.deviceDao.updateUserInfoInDeviceBkpOverview(cloudId, user);
                } else {
                    logger.debug("user  creation failed....");
                }
            }
            catch (BaseException e) {
                logger.trace(BASE_EXCEPTION + String.valueOf((Object)e));
                logger.error(BASE_EXCEPTION + e.getMessage());
                if (e.getErrorStatus() != 1200) break block12;
                throw new DataIntegrityViolationException(e.getMessage());
            }
        }
        String recoveryKeyHash = recoveryKey;
        for (int i = 0; i < 5; ++i) {
            recoveryKeyHash = MD5Generator.generateMD5OfString((String)recoveryKeyHash);
        }
        if (StringUtils.isNotEmpty((CharSequence)createdUser.getSecurityRecoveryKey())) {
            recoveryKey = createdUser.getSecurityRecoveryKey();
        }
        String password = encryptedPassword;
        if (ispswdencrypted) {
            password = this.getDecryptePassword(encryptedPassword);
        }
        if (sendMail) {
            String userVal = userElement.getUserName();
            if (isMSPEnv && StringUtils.isEmpty((CharSequence)userElement.getUserType()) && !userElement.isReadOnlyAdmin()) {
                this.sendMSPCreateUserMail(cloud, cloudName, currentUserName, user, password);
            } else if (!isMSPEnv && StringUtils.isEmpty((CharSequence)userElement.getUserType())) {
                this.sendCreateUserMail(cloud, cloudName, currentUserName, userVal, userElement.getEmailId(), recoveryKey, password);
            }
        }
        userResponse.setSecurityRecoveryKey(recoveryKey);
        return userResponse;
    }

    @Override
    public List<UserErrorReponse> createMultipleUsers(Cloud cloud, UserListElement usersListElement, String currentUserName, String policyName, User currentUser) throws Exception {
        String cloudName = cloud.getCloudName();
        int cloudId = cloud.getCloudId();
        List userListElement = usersListElement.getUserList();
        ArrayList<UserErrorReponse> responseUserElementList = new ArrayList<UserErrorReponse>();
        UserErrorReponse errorReponse = new UserErrorReponse();
        User user = null;
        Pattern pattern = Pattern.compile("^.+@.+\\..+$");
        Pattern userNamePattern = Pattern.compile("^[!\\._\\'A-Za-z0-9@.-]{3,104}$");
        ArrayList<String> unsupportedEmailIdCharacters = new ArrayList<String>();
        unsupportedEmailIdCharacters.add("/");
        unsupportedEmailIdCharacters.add("|");
        unsupportedEmailIdCharacters.add("=");
        unsupportedEmailIdCharacters.add("+");
        unsupportedEmailIdCharacters.add("*");
        unsupportedEmailIdCharacters.add("?");
        boolean syncEnabled = false;
        boolean odbBkpEnabled = false;
        boolean exchangeBkpEnabled = false;
        boolean sharePointBkpEnabled = false;
        boolean isMSPEnv = false;
        boolean backupEnabled = false;
        boolean sendSetPasswordLink = false;
        boolean gmailBkpEnabled = false;
        boolean gdriveBkpEnabled = false;
        List list = cloud.getCloudCustomisableDetails();
        List users = this.userDao.getAllUsers(cloudId);
        List<Object> userNames = new ArrayList();
        List<Object> emailIds = new ArrayList();
        try {
            for (CloudCustomisableDetails customisableDetails : list) {
                if (SYNC_ENABLED.equalsIgnoreCase(customisableDetails.getName())) {
                    syncEnabled = true;
                }
                if (BACKUP_ENABLED.equalsIgnoreCase(customisableDetails.getName())) {
                    backupEnabled = true;
                }
                if ("OneDrive Backup Enabled".equalsIgnoreCase(customisableDetails.getName())) {
                    odbBkpEnabled = true;
                }
                if ("Exchange Backup Enabled".equalsIgnoreCase(customisableDetails.getName())) {
                    exchangeBkpEnabled = true;
                }
                if ("Sharepoint Backup Enabled".equalsIgnoreCase(customisableDetails.getName())) {
                    sharePointBkpEnabled = true;
                }
                if (MSP_LICENSE.equalsIgnoreCase(customisableDetails.getName())) {
                    isMSPEnv = true;
                }
                if ("GMAIL Backup Enabled".equalsIgnoreCase(customisableDetails.getName())) {
                    gmailBkpEnabled = true;
                }
                if (!gdrive_Backup_Enabled.equalsIgnoreCase(customisableDetails.getName())) continue;
                gdriveBkpEnabled = true;
            }
            if (!CollectionUtils.isEmpty((Collection)users)) {
                userNames = users.stream().filter(existingUser -> Objects.nonNull(existingUser.getUserName())).map(existingUser -> existingUser.getUserName()).collect(Collectors.toList());
                emailIds = users.stream().filter(existingUser -> Objects.nonNull(existingUser.getEmailId())).map(existingUser -> existingUser.getEmailId()).collect(Collectors.toList());
            }
        }
        catch (Exception e) {
            logger.error("exception e= {}", (Throwable)e);
            e.printStackTrace();
        }
        logger.debug("userListElement={}, usersListElement={}", (Object)userListElement, (Object)usersListElement);
        for (UserElement ue : userListElement) {
            User createdUser;
            block152: {
                UserElement createUserElement;
                String recoveryKey;
                String password;
                block151: {
                    Matcher matcher = pattern.matcher(ue.getEmailId());
                    Matcher userNameMatcher = userNamePattern.matcher(ue.getUserName());
                    errorReponse = new UserErrorReponse();
                    sendSetPasswordLink = false;
                    boolean skip = false;
                    logger.debug("is MSPEnv={}", (Object)isMSPEnv);
                    if (!isMSPEnv) {
                        if ((long)cloud.getNoOfBackupUsersAllowed() <= this.userDao.countOfPresentBackupUsers(cloudId, cloudName, true, true)) {
                            backupEnabled = false;
                        }
                    } else if (isMSPEnv && currentUser.isReadOnlyAdmin()) {
                        BackupPolicy backupPolicy = this.backupPolicyDao.getBackupPolicy(cloudId, cloudName, policyName);
                        int policyUsersAllowed = 0;
                        int policyServersAllowed = 0;
                        long totalNoOfActiveUsers = 0L;
                        long totalNoOfActiveServers = 0L;
                        if (backupPolicy != null && backupPolicy.getPacks() != null && backupPolicy.getPacks().size() > 0) {
                            policyUsersAllowed = this.getUsersCountAllowedFromPack(backupPolicy.getPacks());
                            policyServersAllowed = this.getServersCountAllowedFromPack(backupPolicy.getPacks());
                            logger.debug("total users allowed={}, servers allowed ={} for the given backup policy", (Object)policyUsersAllowed, (Object)policyServersAllowed);
                            List activeUsersAndServers = this.userDao.getAllUsersByBackupPoliciesAdmin(cloud.getCloudId(), currentUser.getBackupPoliciesAdmin());
                            if (activeUsersAndServers != null && activeUsersAndServers.size() > 0) {
                                List backupUsers = activeUsersAndServers.stream().filter(backupUser -> !User.TYPE.SERVER.toString().equalsIgnoreCase(backupUser.getUserType())).collect(Collectors.toList());
                                List serverUsers = activeUsersAndServers.stream().filter(serverUser -> User.TYPE.SERVER.toString().equalsIgnoreCase(serverUser.getUserType())).collect(Collectors.toList());
                                logger.debug("process=calculating totalNoOfActiveUsersAndServers={}, backup users={}, server users={}", (Object)activeUsersAndServers.size(), (Object)backupUsers.size(), (Object)serverUsers.size());
                                totalNoOfActiveUsers = backupUsers.size();
                                totalNoOfActiveServers = serverUsers.size();
                            }
                            if (StringUtils.isEmpty((CharSequence)ue.getUserType())) {
                                backupEnabled = (long)policyUsersAllowed > totalNoOfActiveUsers;
                            } else if (User.TYPE.SERVER.toString().equals(ue.getUserType())) {
                                syncEnabled = false;
                                odbBkpEnabled = false;
                                exchangeBkpEnabled = false;
                                sharePointBkpEnabled = false;
                                backupEnabled = (long)policyServersAllowed > totalNoOfActiveServers;
                            }
                        } else {
                            backupEnabled = false;
                        }
                    }
                    if ((long)cloud.getNoOfSyncUsersAllowed() <= this.userDao.countOfPresentSyncUsers(cloudId, cloudName, true)) {
                        syncEnabled = false;
                    }
                    if ((long)cloud.getNoOfOneDriveUsersAllowed() <= this.userDao.countOfPresentOnedriveUsers(cloudId, true)) {
                        odbBkpEnabled = false;
                    }
                    if ((long)cloud.getNoOfExchangeUsersAllowed() <= this.userDao.countOfPresentExchangeUsers(cloudId, true)) {
                        exchangeBkpEnabled = false;
                    }
                    if ((long)cloud.getNoOfGmailUsersAllowed() <= this.userDao.countOfPresentGmailBackupUsers(cloudId, cloudName, true)) {
                        gmailBkpEnabled = false;
                    }
                    if ((long)cloud.getNoOfGdriveUsersAllowed() <= this.userDao.countOfPresentGdriveBackupUsers(cloudId, cloudName, true)) {
                        gdriveBkpEnabled = false;
                    }
                    if (!(backupEnabled || syncEnabled || odbBkpEnabled || exchangeBkpEnabled || sharePointBkpEnabled || gmailBkpEnabled || gdriveBkpEnabled)) {
                        logger.debug("....no licenses are enabled.. user limit reached...");
                        errorReponse.setUserName(ue.getUserName());
                        errorReponse.setEmailId(ue.getEmailId());
                        errorReponse.setErrorMessage("user limit reached");
                        responseUserElementList.add(errorReponse);
                        continue;
                    }
                    if (StringUtils.isEmpty((CharSequence)ue.getUserName()) || StringUtils.isEmpty((CharSequence)ue.getEmailId())) {
                        errorReponse.setUserName(ue.getUserName());
                        errorReponse.setEmailId(ue.getEmailId());
                        errorReponse.setErrorMessage("User name / Email Id empty");
                        responseUserElementList.add(errorReponse);
                        continue;
                    }
                    if (!matcher.find()) {
                        errorReponse.setUserName(ue.getUserName());
                        errorReponse.setEmailId(ue.getEmailId());
                        errorReponse.setErrorMessage("Invalid Email Id");
                        responseUserElementList.add(errorReponse);
                        continue;
                    }
                    for (String unsupportedEmailIdCharacter : unsupportedEmailIdCharacters) {
                        if (User.TYPE.SERVER.toString().equals(ue.getUserType()) || !ue.getEmailId().contains(unsupportedEmailIdCharacter)) continue;
                        errorReponse.setUserName(ue.getUserName());
                        errorReponse.setEmailId(ue.getEmailId());
                        errorReponse.setErrorMessage("Unsupported character found in email ID");
                        responseUserElementList.add(errorReponse);
                        skip = true;
                        break;
                    }
                    if (skip) continue;
                    if (!User.TYPE.SERVER.toString().equals(ue.getUserType()) && !EmailValidator.getInstance().isValid(ue.getEmailId())) {
                        errorReponse.setUserName(ue.getUserName());
                        errorReponse.setEmailId(ue.getEmailId());
                        errorReponse.setErrorMessage("Unsupported character found in email ID");
                        responseUserElementList.add(errorReponse);
                        continue;
                    }
                    if (!userNameMatcher.find()) {
                        errorReponse.setUserName(ue.getUserName());
                        errorReponse.setEmailId(ue.getEmailId());
                        errorReponse.setErrorMessage("Unsupported character found in user name");
                        responseUserElementList.add(errorReponse);
                        continue;
                    }
                    boolean isGuestUserRemoved = false;
                    if (userNames.contains(ue.getUserName())) {
                        User userFromDB = this.userDao.getUserByUserNameOrEmail(cloudId, ue.getUserName(), ue.getEmailId());
                        if (userFromDB == null) {
                            userFromDB = this.userDao.getUserByUserNameOrEmail(cloudId, ue.getEmailId());
                        }
                        if (userFromDB != null && userFromDB.isGuest()) {
                            isGuestUserRemoved = true;
                            this.userDao.removeUserbyID(cloudId, userFromDB.getUserId().toString());
                        } else {
                            errorReponse.setUserName(ue.getUserName());
                            errorReponse.setEmailId(ue.getEmailId());
                            errorReponse.setErrorMessage("UserName already exist");
                            responseUserElementList.add(errorReponse);
                            continue;
                        }
                    }
                    if (emailIds.contains(ue.getEmailId())) {
                        User userFromDB = this.userDao.getUserByUserNameOrEmail(cloudId, ue.getUserName());
                        if (userFromDB == null) {
                            userFromDB = this.userDao.getUserByUserNameOrEmail(cloudId, ue.getEmailId());
                        }
                        if (userFromDB != null && userFromDB.isGuest()) {
                            isGuestUserRemoved = true;
                            this.userDao.removeUserbyID(cloudId, userFromDB.getUserId().toString());
                        } else if (!isGuestUserRemoved) {
                            errorReponse.setUserName(ue.getUserName());
                            errorReponse.setEmailId(ue.getEmailId());
                            errorReponse.setErrorMessage("Email Id already in use");
                            responseUserElementList.add(errorReponse);
                            continue;
                        }
                    }
                    if (userNames.contains(ue.getUserName())) {
                        User userFromDB = this.userDao.getUserByUserNameOrEmail(cloudId, ue.getUserName());
                        if (userFromDB == null) {
                            userFromDB = this.userDao.getUserByUserNameOrEmail(cloudId, ue.getEmailId());
                        }
                        if (userFromDB != null && userFromDB.isGuest()) {
                            this.userDao.removeUserbyID(cloudId, userFromDB.getUserId().toString());
                            isGuestUserRemoved = true;
                        } else if (!isGuestUserRemoved) {
                            errorReponse.setUserName(ue.getUserName());
                            errorReponse.setEmailId(ue.getEmailId());
                            errorReponse.setErrorMessage("Email Id already in use");
                            responseUserElementList.add(errorReponse);
                            continue;
                        }
                    }
                    if (!StringUtils.isEmpty((CharSequence)ue.getPasswdHash()) && ue.getPasswdHash().length() < 6) {
                        errorReponse.setUserName(ue.getUserName());
                        errorReponse.setEmailId(ue.getEmailId());
                        errorReponse.setErrorMessage("Password is too short. It should have 6 characters or more.");
                        responseUserElementList.add(errorReponse);
                        continue;
                    }
                    if (backupEnabled && !StringUtils.isEmpty((CharSequence)ue.getPolicyName())) {
                        if (currentUser.isReadOnlyAdmin()) {
                            if (!currentUser.getBackupPoliciesAdmin().contains(ue.getPolicyName())) {
                                errorReponse.setUserName(ue.getUserName());
                                errorReponse.setEmailId(ue.getEmailId());
                                errorReponse.setErrorMessage("Backup policy doesn\u2019t exist");
                                responseUserElementList.add(errorReponse);
                                continue;
                            }
                        } else if (!this.backupPolicyDao.checkIfBackupPolicyNameExists(cloudId, ue.getPolicyName())) {
                            errorReponse.setUserName(ue.getUserName());
                            errorReponse.setEmailId(ue.getEmailId());
                            errorReponse.setErrorMessage("Backup policy doesn\u2019t exist");
                            responseUserElementList.add(errorReponse);
                            continue;
                        }
                    }
                    if (syncEnabled && !StringUtils.isEmpty((CharSequence)ue.getSyncPolicyName())) {
                        if (currentUser.isReadOnlyAdmin()) {
                            if (!currentUser.getSyncPoliciesAdmin().contains(ue.getSyncPolicyName())) {
                                errorReponse.setUserName(ue.getUserName());
                                errorReponse.setEmailId(ue.getEmailId());
                                errorReponse.setErrorMessage("Sync policy doesn\u2019t exist");
                                responseUserElementList.add(errorReponse);
                                continue;
                            }
                        } else if (!this.syncPolicyDao.checkIfSyncPolicyNameExists(cloudId, ue.getSyncPolicyName())) {
                            errorReponse.setUserName(ue.getUserName());
                            errorReponse.setEmailId(ue.getEmailId());
                            errorReponse.setErrorMessage("Sync policy doesn\u2019t exist");
                            responseUserElementList.add(errorReponse);
                            continue;
                        }
                    }
                    if (odbBkpEnabled && !StringUtils.isEmpty((CharSequence)ue.getOneDrivePolicyName())) {
                        if (currentUser.isReadOnlyAdmin()) {
                            if (!currentUser.getOdbPoliciesAdmin().contains(ue.getOneDrivePolicyName())) {
                                errorReponse.setUserName(ue.getUserName());
                                errorReponse.setEmailId(ue.getEmailId());
                                errorReponse.setErrorMessage("OneDrive policy doesn\u2019t exist");
                                responseUserElementList.add(errorReponse);
                                continue;
                            }
                        } else if (!this.backupPolicyDao.checkIfODBBackupPolicyNameExists(cloudId, ue.getOneDrivePolicyName())) {
                            errorReponse.setUserName(ue.getUserName());
                            errorReponse.setEmailId(ue.getEmailId());
                            errorReponse.setErrorMessage("OneDrive policy doesn\u2019t exist");
                            responseUserElementList.add(errorReponse);
                            continue;
                        }
                    }
                    if (exchangeBkpEnabled && !StringUtils.isEmpty((CharSequence)ue.getExchangePolicyName())) {
                        if (currentUser.isReadOnlyAdmin()) {
                            if (!currentUser.getOdbPoliciesAdmin().contains(ue.getExchangePolicyName())) {
                                errorReponse.setUserName(ue.getUserName());
                                errorReponse.setEmailId(ue.getEmailId());
                                errorReponse.setErrorMessage("Exchange policy doesn\u2019t exist");
                                responseUserElementList.add(errorReponse);
                                continue;
                            }
                        } else if (!this.backupPolicyDao.checkIfODBBackupPolicyNameExists(cloudId, ue.getExchangePolicyName())) {
                            errorReponse.setUserName(ue.getUserName());
                            errorReponse.setEmailId(ue.getEmailId());
                            errorReponse.setErrorMessage("Exchange policy doesn\u2019t exist");
                            responseUserElementList.add(errorReponse);
                            continue;
                        }
                    }
                    if (sharePointBkpEnabled && !StringUtils.isEmpty((CharSequence)ue.getSpPolicyName())) {
                        if (currentUser.isReadOnlyAdmin()) {
                            if (!currentUser.getOdbPoliciesAdmin().contains(ue.getSpPolicyName())) {
                                errorReponse.setUserName(ue.getUserName());
                                errorReponse.setEmailId(ue.getEmailId());
                                errorReponse.setErrorMessage("Share point policy doesn\u2019t exist");
                                responseUserElementList.add(errorReponse);
                                continue;
                            }
                        } else if (!this.backupPolicyDao.checkIfODBBackupPolicyNameExists(cloudId, ue.getSpPolicyName())) {
                            errorReponse.setUserName(ue.getUserName());
                            errorReponse.setEmailId(ue.getEmailId());
                            errorReponse.setErrorMessage("Share point policy doesn\u2019t exist");
                            responseUserElementList.add(errorReponse);
                            continue;
                        }
                    }
                    if (gmailBkpEnabled && !StringUtils.isEmpty((CharSequence)ue.getGmailPolicyName())) {
                        if (currentUser.isReadOnlyAdmin()) {
                            if (!currentUser.getGmailPoliciesAdmin().contains(ue.getGmailPolicyName())) {
                                errorReponse.setUserName(ue.getUserName());
                                errorReponse.setEmailId(ue.getEmailId());
                                errorReponse.setErrorMessage("Gmail policy doesn\u2019t exist");
                                responseUserElementList.add(errorReponse);
                                continue;
                            }
                        } else if (!this.backupPolicyDao.checkIfGmailBackupPolicyNameExists(cloudId, ue.getGmailPolicyName())) {
                            errorReponse.setUserName(ue.getUserName());
                            errorReponse.setEmailId(ue.getEmailId());
                            errorReponse.setErrorMessage("Gmail policy doesn\u2019t exist");
                            responseUserElementList.add(errorReponse);
                            continue;
                        }
                    }
                    if (gdriveBkpEnabled && !StringUtils.isEmpty((CharSequence)ue.getGdrivePolicyName())) {
                        if (currentUser.isReadOnlyAdmin()) {
                            if (!currentUser.getGmailPoliciesAdmin().contains(ue.getGdrivePolicyName())) {
                                errorReponse.setUserName(ue.getUserName());
                                errorReponse.setEmailId(ue.getEmailId());
                                errorReponse.setErrorMessage("Gdrive policy doesn\u2019t exist");
                                responseUserElementList.add(errorReponse);
                                continue;
                            }
                        } else if (!this.backupPolicyDao.checkIfGmailBackupPolicyNameExists(cloudId, ue.getGdrivePolicyName())) {
                            errorReponse.setUserName(ue.getUserName());
                            errorReponse.setEmailId(ue.getEmailId());
                            errorReponse.setErrorMessage("Gdrive policy doesn\u2019t exist");
                            responseUserElementList.add(errorReponse);
                            continue;
                        }
                    }
                    user = new User();
                    user.setMigratedBy(currentUserName);
                    user.setActive(true);
                    password = null;
                    if (StringUtils.isEmpty((CharSequence)ue.getPasswdHash())) {
                        sendSetPasswordLink = true;
                        password = this.generaterandompswd();
                        logger.debug(password + "pwd........");
                        user.setPasswdHash(this.generatePassWordhash(password));
                    } else {
                        password = ue.getPasswdHash();
                        logger.debug(password + "pwd........");
                        String passwdHash = this.generatePassWordhash(ue.getPasswdHash());
                        user.setPasswdHash(passwdHash);
                    }
                    user.setUserName(ue.getUserName());
                    user.setEmailId(ue.getEmailId());
                    user.setGoogleSecretKey(ue.getGoogleSecretKey());
                    if (currentUser.isReadOnlyAdmin()) {
                        if (backupEnabled) {
                            if (StringUtils.isEmpty((CharSequence)ue.getPolicyName())) {
                                if (currentUser.getBackupPoliciesAdmin() != null && currentUser.getBackupPoliciesAdmin().size() > 0) {
                                    user.setPolicyName((String)currentUser.getBackupPoliciesAdmin().get(0));
                                    user.setBackupEnabled(backupEnabled);
                                }
                            } else {
                                user.setPolicyName(ue.getPolicyName());
                                user.setBackupEnabled(backupEnabled);
                            }
                        }
                        if (syncEnabled) {
                            if (StringUtils.isEmpty((CharSequence)ue.getSyncPolicyName())) {
                                if (currentUser.getSyncPoliciesAdmin() != null && currentUser.getSyncPoliciesAdmin().size() > 0) {
                                    user.setSyncPolicyName((String)currentUser.getSyncPoliciesAdmin().get(0));
                                    user.setSyncEnabled(syncEnabled);
                                }
                            } else {
                                user.setSyncPolicyName(ue.getSyncPolicyName());
                                user.setSyncEnabled(syncEnabled);
                            }
                        }
                        logger.debug(ue.getOneDrivePolicyName() + "....odbpolicyname.... " + this.registry.get(cloudId).getPropertyFileValueDefaultOdbPolicy());
                        if (odbBkpEnabled) {
                            if (StringUtils.isEmpty((CharSequence)ue.getOneDrivePolicyName())) {
                                if (currentUser.getOdbPoliciesAdmin() != null && currentUser.getBackupPoliciesAdmin().size() > 0 && currentUser.getOdbPoliciesAdmin().stream().anyMatch(odbPolicyName -> odbPolicyName.startsWith("ODB_"))) {
                                    Optional<String> oneDrivePolicyName = currentUser.getOdbPoliciesAdmin().stream().filter(odbPolicyName -> odbPolicyName.startsWith("ODB_")).findFirst();
                                    user.setOneDrivePolicyName(oneDrivePolicyName.get());
                                    user.setOnedriveBkpEnabled(odbBkpEnabled);
                                }
                            } else {
                                user.setOneDrivePolicyName(ue.getOneDrivePolicyName());
                                user.setOnedriveBkpEnabled(odbBkpEnabled);
                            }
                        }
                        if (exchangeBkpEnabled) {
                            if (StringUtils.isEmpty((CharSequence)ue.getExchangePolicyName())) {
                                if (currentUser.getOdbPoliciesAdmin() != null && currentUser.getBackupPoliciesAdmin().size() > 0 && currentUser.getOdbPoliciesAdmin().stream().anyMatch(exchangePolicyName -> exchangePolicyName.startsWith("EX_"))) {
                                    Optional<String> exchangePolicyName2 = currentUser.getOdbPoliciesAdmin().stream().filter(exPolicyName -> exPolicyName.startsWith("EX_")).findFirst();
                                    user.setExchangePolicyName(exchangePolicyName2.get());
                                    user.setExchangeBkpEnabled(exchangeBkpEnabled);
                                }
                            } else {
                                user.setExchangePolicyName(ue.getExchangePolicyName());
                                user.setExchangeBkpEnabled(exchangeBkpEnabled);
                            }
                        }
                        if (sharePointBkpEnabled) {
                            if (StringUtils.isEmpty((CharSequence)ue.getSpPolicyName())) {
                                if (currentUser.getOdbPoliciesAdmin() != null && currentUser.getBackupPoliciesAdmin().size() > 0 && currentUser.getOdbPoliciesAdmin().stream().anyMatch(spPolicyName -> spPolicyName.startsWith("SP_"))) {
                                    Optional<String> sharePointPolicyName = currentUser.getOdbPoliciesAdmin().stream().filter(spPolicyName -> spPolicyName.startsWith("SP_")).findFirst();
                                    user.setSpPolicyName(sharePointPolicyName.get());
                                    user.setSharePointBkpEnabled(sharePointBkpEnabled);
                                }
                            } else {
                                user.setSpPolicyName(ue.getSpPolicyName());
                                user.setSharePointBkpEnabled(sharePointBkpEnabled);
                            }
                        }
                        if (gmailBkpEnabled) {
                            if (StringUtils.isEmpty((CharSequence)ue.getGmailPolicyName())) {
                                if (currentUser.getGmailPoliciesAdmin() != null && currentUser.getGmailPoliciesAdmin().size() > 0 && currentUser.getGmailPoliciesAdmin().stream().anyMatch(gmailPolicyName -> gmailPolicyName.startsWith("GMAIL_"))) {
                                    Optional<String> gmailPolicyName1 = currentUser.getGmailPoliciesAdmin().stream().filter(gmailPolicyName -> gmailPolicyName.startsWith("GMAIL_")).findFirst();
                                    user.setGmailPolicyName(gmailPolicyName1.get());
                                    user.setGmailBkpEnabled(gmailBkpEnabled);
                                }
                            } else {
                                user.setGmailPolicyName(ue.getGmailPolicyName());
                                user.setGmailBkpEnabled(gmailBkpEnabled);
                            }
                        }
                        if (gdriveBkpEnabled) {
                            if (StringUtils.isEmpty((CharSequence)ue.getGdrivePolicyName())) {
                                if (currentUser.getGmailPoliciesAdmin() != null && currentUser.getGmailPoliciesAdmin().size() > 0 && currentUser.getGmailPoliciesAdmin().stream().anyMatch(gmailPolicyName -> gmailPolicyName.startsWith("GOOGLE_DRIVE"))) {
                                    Optional<String> gmailPolicyName1 = currentUser.getGmailPoliciesAdmin().stream().filter(gmailPolicyName -> gmailPolicyName.startsWith("GOOGLE_DRIVE")).findFirst();
                                    user.setGdrivePolicyName(gmailPolicyName1.get());
                                    user.setGdriveBkpEnabled(gdriveBkpEnabled);
                                }
                            } else {
                                user.setGdrivePolicyName(ue.getGdrivePolicyName());
                                user.setGdriveBkpEnabled(gdriveBkpEnabled);
                            }
                        }
                    } else {
                        user.setBackupEnabled(backupEnabled);
                        user.setSyncEnabled(syncEnabled);
                        user.setOnedriveBkpEnabled(odbBkpEnabled);
                        user.setExchangeBkpEnabled(exchangeBkpEnabled);
                        user.setSharePointBkpEnabled(sharePointBkpEnabled);
                        user.setGmailBkpEnabled(gmailBkpEnabled);
                        user.setGdriveBkpEnabled(gdriveBkpEnabled);
                        if (backupEnabled) {
                            if (StringUtils.isEmpty((CharSequence)ue.getPolicyName())) {
                                user.setPolicyName(this.registry.get(cloudId).getPropertyFileValueDefaultBkpPolicy());
                            } else {
                                user.setPolicyName(ue.getPolicyName());
                            }
                        }
                        if (syncEnabled) {
                            if (StringUtils.isEmpty((CharSequence)ue.getSyncPolicyName())) {
                                user.setSyncPolicyName(this.registry.get(cloudId).getPropertyFileValueDefaultSyncPolicy());
                            } else {
                                user.setSyncPolicyName(ue.getSyncPolicyName());
                            }
                        }
                        logger.debug(ue.getOneDrivePolicyName() + "....odbpolicyname.... " + this.registry.get(cloudId).getPropertyFileValueDefaultOdbPolicy());
                        if (odbBkpEnabled) {
                            if (StringUtils.isEmpty((CharSequence)ue.getOneDrivePolicyName())) {
                                user.setOneDrivePolicyName(this.registry.get(cloudId).getPropertyFileValueDefaultOdbPolicy());
                            } else {
                                user.setOneDrivePolicyName(ue.getOneDrivePolicyName());
                            }
                        }
                        if (exchangeBkpEnabled) {
                            if (StringUtils.isEmpty((CharSequence)ue.getExchangePolicyName())) {
                                user.setExchangePolicyName(this.registry.get(cloudId).getPropertyFileValueDefaultExchangePolicy());
                            } else {
                                user.setExchangePolicyName(ue.getExchangePolicyName());
                            }
                        }
                        if (sharePointBkpEnabled) {
                            if (StringUtils.isEmpty((CharSequence)ue.getSpPolicyName())) {
                                user.setSpPolicyName(this.registry.get(cloudId).getPropertyFileValueDefaultSpPolicy());
                            } else {
                                user.setSpPolicyName(ue.getSpPolicyName());
                            }
                        }
                        if (gmailBkpEnabled) {
                            if (StringUtils.isEmpty((CharSequence)ue.getGmailPolicyName())) {
                                user.setGmailPolicyName(this.registry.get(cloudId).getDefaultGmailPolicy());
                            } else {
                                user.setGmailPolicyName(ue.getGmailPolicyName());
                            }
                        }
                        if (gdriveBkpEnabled) {
                            if (StringUtils.isEmpty((CharSequence)ue.getGdrivePolicyName())) {
                                user.setGdrivePolicyName(this.registry.get(cloudId).getDefaultGdrivePolicyName());
                            } else {
                                user.setGdrivePolicyName(ue.getGdrivePolicyName());
                            }
                        }
                    }
                    UUID uuid = UUID.randomUUID();
                    recoveryKey = String.valueOf(uuid);
                    user.setSecurityRecoveryKey(recoveryKey);
                    if (!StringUtils.isEmpty((CharSequence)ue.getDepartment())) {
                        user.setDepartment(ue.getDepartment());
                    }
                    if (!StringUtils.isEmpty((CharSequence)ue.getLocation())) {
                        user.setLocation(ue.getLocation());
                    }
                    if (!StringUtils.isEmpty((CharSequence)ue.getDisplayName())) {
                        user.setDisplayName(ue.getDisplayName());
                    }
                    if (!StringUtils.isEmpty((CharSequence)ue.getOdbLoginId())) {
                        user.setOdbLoginId(ue.getOdbLoginId());
                    }
                    user.setFirstLogin(true);
                    user.setCreatedTimestamp(String.valueOf(System.currentTimeMillis()));
                    user.setUserNameLowerCase(ue.getUserName().toLowerCase());
                    user.setSuspended(ue.isSuspended());
                    user.setUserType(ue.getUserType());
                    UserElement userElement = new UserElement();
                    BeanUtils.copyProperties((Object)user, (Object)userElement);
                    createUserElement = null;
                    try {
                        createUserElement = this.createUser(cloudId, cloudName, userElement, false, this.userDao);
                    }
                    catch (BaseException e) {
                        logger.trace(BASE_EXCEPTION + String.valueOf((Object)e));
                        logger.error(BASE_EXCEPTION + e.getMessage());
                        if (e.getErrorStatus() != 1200) break block151;
                        errorReponse.setUserName(ue.getUserName());
                        errorReponse.setEmailId(ue.getEmailId());
                        errorReponse.setErrorMessage("UserName already exist");
                        responseUserElementList.add(errorReponse);
                        continue;
                    }
                }
                if (createUserElement == null) {
                    errorReponse.setUserName(ue.getUserName());
                    errorReponse.setEmailId(ue.getEmailId());
                    errorReponse.setErrorMessage("Unable to create");
                    responseUserElementList.add(errorReponse);
                    continue;
                }
                createdUser = new User();
                BeanUtils.copyProperties((Object)createUserElement, (Object)createdUser);
                try {
                    if (User.TYPE.SERVER.toString().equals(user.getUserType())) {
                        this.sendCreateServerMail(cloud, cloudName, currentUserName, user, password);
                        break block152;
                    }
                    if (!isMSPEnv && StringUtils.isEmpty((CharSequence)user.getUserType())) {
                        this.sendCreateUserMail(cloud, cloudName, currentUserName, user.getUserName(), user.getEmailId(), recoveryKey, password);
                        break block152;
                    }
                    if (!isMSPEnv || !StringUtils.isEmpty((CharSequence)user.getUserType())) break block152;
                    this.sendMSPCreateUserMail(cloud, cloudName, currentUserName, user, password);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    logger.debug("Exception " + String.valueOf(e));
                    errorReponse.setUserName(ue.getUserName());
                    errorReponse.setEmailId(ue.getEmailId());
                    errorReponse.setErrorMessage("Unable to create");
                    responseUserElementList.add(errorReponse);
                    this.userDao.deleteUser(cloudId, cloudName, createdUser);
                    continue;
                }
            }
            this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudName, "created  a new user", currentUserName, createdUser.getUserName(), "Portal", System.currentTimeMillis(), PCActionTypes.USER_CREATE.getActionTypeValue());
            errorReponse.setUserName(ue.getUserName());
            errorReponse.setEmailId(ue.getEmailId());
            errorReponse.setErrorMessage("User created");
            responseUserElementList.add(errorReponse);
            if (!userNames.contains(ue.getUserName())) {
                userNames.add(ue.getUserName());
            }
            if (emailIds.contains(ue.getEmailId())) continue;
            emailIds.add(ue.getEmailId());
        }
        if (!CollectionUtils.isEmpty(responseUserElementList)) {
            ArrayList<UserElement> failedElements = new ArrayList<UserElement>();
            for (UserErrorReponse userError : responseUserElementList) {
                if (StringUtils.isEmpty((CharSequence)userError.getErrorMessage()) || userError.getErrorMessage().equalsIgnoreCase("User created")) continue;
                UserElement element = new UserElement();
                element.setUserName(userError.getUserName());
                element.setStatus(userError.getErrorMessage());
                logger.debug(userError.getUserName() + "..report..." + userError.getErrorMessage());
                failedElements.add(element);
            }
            if (!CollectionUtils.isEmpty(failedElements)) {
                this.createUsersExcelBlockFail(cloudId, failedElements);
            }
        }
        return responseUserElementList;
    }

    private int getUsersCountAllowedFromPack(List<PackElement> packList) {
        int policyUsersAllowed = 0;
        for (PackElement pack : packList) {
            if (!pack.isSubscriptionActive()) continue;
            policyUsersAllowed += pack.getMinUserCount();
            List addons = pack.getAddons();
            if (addons == null || addons.size() <= 0) break;
            for (PackElement addon : addons) {
                if (!addon.isSubscriptionActive() || addon.getSkuCode().contains(OrderConstants.SERVER_ADDON)) continue;
                policyUsersAllowed += addon.getMinUserCount();
            }
        }
        return policyUsersAllowed;
    }

    private int getServersCountAllowedFromPack(List<PackElement> packList) {
        int policyServersAllowed = 0;
        for (PackElement pack : packList) {
            if (!pack.isSubscriptionActive()) continue;
            List addons = pack.getAddons();
            if (addons == null || addons.size() <= 0) break;
            for (PackElement addon : addons) {
                if (!addon.isSubscriptionActive() || !addon.getSkuCode().contains(OrderConstants.SERVER_ADDON)) continue;
                policyServersAllowed += addon.getMinUserCount();
            }
        }
        return policyServersAllowed;
    }

    @Override
    public int validateBackupUserRestrictionsByPolicy(int cloudId, String cloudName, User user) {
        BackupPolicy backupPolicy;
        int policyUsersAllowed = 0;
        long totalNoOfActiveUsers = 0L;
        String policyName = null;
        if (user != null) {
            policyName = user.getPolicyName();
        }
        if ((backupPolicy = this.backupPolicyDao.getBackupPolicy(cloudId, cloudName, policyName)) != null && backupPolicy.getPacks() != null && backupPolicy.getPacks().size() > 0) {
            policyUsersAllowed = this.getUsersCountAllowedFromPack(backupPolicy.getPacks());
            logger.debug("total users allowed={} for the given backup policy", (Object)policyUsersAllowed);
            List activeUsersAndServers = this.userDao.getAllUsersByBackupPoliciesAdmin(cloudId, user.getBackupPoliciesAdmin());
            if (activeUsersAndServers != null && activeUsersAndServers.size() > 0) {
                List backupUsers = activeUsersAndServers.stream().filter(backupUser -> !User.TYPE.SERVER.toString().equalsIgnoreCase(backupUser.getUserType())).collect(Collectors.toList());
                logger.debug("process=calculating totalNoOfActiveUsersAndServers={}, backup users={}", (Object)activeUsersAndServers.size(), (Object)backupUsers.size());
                totalNoOfActiveUsers = backupUsers.size();
            }
            if ((long)policyUsersAllowed <= totalNoOfActiveUsers) {
                return 1525;
            }
            return 1500;
        }
        return 1525;
    }

    @Override
    public int validateBackupServerRestrictionsByPolicy(int cloudId, String cloudName, User user) {
        BackupPolicy backupPolicy;
        int policyServersAllowed = 0;
        long totalNoOfActiveServers = 0L;
        String policyName = null;
        if (user != null) {
            policyName = user.getPolicyName();
        }
        if ((backupPolicy = this.backupPolicyDao.getBackupPolicy(cloudId, cloudName, policyName)) != null && backupPolicy.getPacks() != null && backupPolicy.getPacks().size() > 0) {
            policyServersAllowed = this.getServersCountAllowedFromPack(backupPolicy.getPacks());
            logger.debug("total servers allowed={} for the given backup policy", (Object)policyServersAllowed);
            List activeUsersAndServers = this.userDao.getAllUsersByBackupPoliciesAdmin(cloudId, user.getBackupPoliciesAdmin());
            if (activeUsersAndServers != null && activeUsersAndServers.size() > 0) {
                List backupServers = activeUsersAndServers.stream().filter(backupServerUser -> User.TYPE.SERVER.toString().equalsIgnoreCase(backupServerUser.getUserType())).collect(Collectors.toList());
                logger.debug("process=calculating totalNoOfActiveUsersAndServers={}, server users={}", (Object)activeUsersAndServers.size(), (Object)backupServers.size());
                totalNoOfActiveServers = backupServers.size();
            }
            if ((long)policyServersAllowed <= totalNoOfActiveServers) {
                return 1525;
            }
            return 1500;
        }
        return 1525;
    }

    @Override
    public long countOfPresentUsers(int cloudId) {
        return this.userDao.countOfPresentUsers(cloudId, "", true);
    }

    public void sendCreateUserMail(Cloud cloud, String cloudName, String actionBy, String actionOn, String emailId, String recoveryKey, String password) {
        if (!StringUtils.isEmpty((CharSequence)actionBy)) {
            EmailProps email = new EmailProps();
            email.setAction("create-user");
            email.setActionOn(actionOn);
            email.setActionBy(actionBy);
            email.setCloudName(cloudName);
            email.setUserName(actionOn);
            email.setToAdmins(false);
            email.setCloudURL(this.registry.get(cloud.getCloudId()).getPropertyFileValueCloudUrl() + "/portal/locallogin");
            email.setPassword(password);
            EmailRecipent emailRecipent = new EmailRecipent();
            emailRecipent.setUserName(actionOn);
            emailRecipent.setEmail(emailId);
            ArrayList<EmailRecipent> recipentsList = new ArrayList<EmailRecipent>();
            recipentsList.add(emailRecipent);
            logger.debug("calling email..");
            email.setRecipents(recipentsList);
            this.cloudMailService.sendMail(cloud, email);
        }
    }

    @Override
    public void sendMSPCreateUserMail(Cloud cloud, String cloudName, String actionByName, User actionOnUser, String password) {
        if (!StringUtils.isEmpty((CharSequence)actionByName)) {
            EmailProps email = new EmailProps();
            EmailRecipent emailRecipent = new EmailRecipent();
            ArrayList<EmailRecipent> notifyRecipentsList = new ArrayList<EmailRecipent>();
            ArrayList<Object> recipentsList = new ArrayList<Object>();
            email.setActionOn(actionOnUser.getUserName());
            email.setActionBy(actionByName);
            email.setCloudName(cloudName);
            email.setUserName(actionOnUser.getUserName());
            email.setToAdmins(true);
            email.setToUser(true);
            email.setCloudURL(this.registry.get(cloud.getCloudId()).getPropertyFileValueCloudUrl() + "/portal/locallogin");
            email.setPassword(password);
            List allAdmins = this.userDao.getAllAdmins(1, cloudName);
            for (User adminUser : allAdmins) {
                if (!adminUser.isActive()) continue;
                emailRecipent = new EmailRecipent();
                emailRecipent.setUserName(adminUser.getUserName());
                emailRecipent.setEmail(adminUser.getEmailId());
                notifyRecipentsList.add(emailRecipent);
                logger.debug("...admin...." + adminUser.getUserName());
            }
            ArrayList<String> policyNames = new ArrayList<String>();
            policyNames.add(actionOnUser.getPolicyName());
            List delegatedAdmins = this.userDao.getAllReadOnlyAdminsForPolicyName(1, policyNames);
            for (User delegatedAdmin : delegatedAdmins) {
                if (!delegatedAdmin.isActive()) continue;
                emailRecipent = new EmailRecipent();
                emailRecipent.setUserName(delegatedAdmin.getUserName());
                emailRecipent.setEmail(delegatedAdmin.getEmailId());
                notifyRecipentsList.add(emailRecipent);
                logger.debug("...delegated admin...." + delegatedAdmin.getUserName());
            }
            if (actionOnUser.isReadOnlyAdmin()) {
                try {
                    String fileName;
                    File file;
                    email.setAction("create-msp-customer");
                    if (!StringUtils.isEmpty((CharSequence)actionOnUser.getDisplayName())) {
                        email.setUserName(actionOnUser.getDisplayName());
                        email.setLoginUserName(actionOnUser.getUserName());
                    }
                    String localDirectory = this.registry.get(cloud.getCloudId()).getPropertyFileValueParacloudMountPoint() + GUIDE_DIRECTORY;
                    File directory = new File(localDirectory);
                    logger.debug("action = send customer mail, send mail started");
                    if (!directory.exists()) {
                        logger.debug("action = send customer mail, directory not present hence create {}", (Object)localDirectory);
                        directory.mkdirs();
                    }
                    if (!(file = new File(fileName = localDirectory + PARABLU_GETTING_STARTED_PDF)).exists()) {
                        int bytesRead;
                        logger.debug("action = send customer mail, guide pdf file not present hence create {}", (Object)fileName);
                        HttpURLConnection connection = (HttpURLConnection)new URL(PARABLU_GETTING_STARTED_DOWNLOAD_LINK).openConnection();
                        InputStream inputStream = connection.getInputStream();
                        File parentDir = file.getParentFile();
                        if (!parentDir.exists()) {
                            parentDir.mkdirs();
                        }
                        FileOutputStream outputStream = new FileOutputStream(fileName);
                        byte[] buffer = new byte[1024];
                        while ((bytesRead = inputStream.read(buffer)) != -1) {
                            outputStream.write(buffer, 0, bytesRead);
                        }
                        outputStream.close();
                        inputStream.close();
                    }
                    logger.debug("action = send mail to customer, attach file");
                    email.setAttachFileName(fileName);
                    BackupPolicy backupPolicy = this.backupPolicyDao.getBackupPolicy(1, cloudName, actionOnUser.getPolicyName());
                    if (backupPolicy != null && backupPolicy.getPacks() != null && backupPolicy.getPacks().size() > 0) {
                        String purchasedSku = ((PackElement)backupPolicy.getPacks().get(0)).getSkuCode();
                        logger.debug("The purchased sku by the customer is {}", (Object)purchasedSku);
                        email.setText(purchasedSku);
                    }
                }
                catch (Exception e) {
                    logger.error("There is an exception while downloading the customer getting started guide e=", (Throwable)e);
                }
            } else {
                email.setAction("create-msp-user");
            }
            emailRecipent = new EmailRecipent();
            emailRecipent.setUserName(actionOnUser.getUserName());
            emailRecipent.setEmail(actionOnUser.getEmailId());
            recipentsList.add(emailRecipent);
            HashSet recipentsSet = new HashSet(recipentsList);
            recipentsList.clear();
            recipentsList.addAll(recipentsSet);
            logger.debug("calling email..");
            email.setRecipents(recipentsList);
            email.setNotifyRecipents(notifyRecipentsList);
            this.cloudMailService.sendMail(cloud, email);
        }
    }

    @Override
    public void sendCreateServerMail(Cloud cloud, String cloudName, String actionByName, User actionOnUser, String password) {
        if (!StringUtils.isEmpty((CharSequence)actionByName)) {
            EmailProps email = new EmailProps();
            EmailRecipent emailRecipent = new EmailRecipent();
            ArrayList<EmailRecipent> recipentsList = new ArrayList<EmailRecipent>();
            ArrayList<EmailRecipent> notifyRecipentsList = new ArrayList<EmailRecipent>();
            email.setActionOn(actionOnUser.getUserName());
            email.setLoginUserName(actionOnUser.getUserName());
            email.setActionBy(actionByName);
            email.setCloudName(cloudName);
            email.setUserName(actionOnUser.getDisplayName());
            email.setToAdmins(true);
            email.setToUser(true);
            email.setCloudURL(this.registry.get(cloud.getCloudId()).getPropertyFileValueCloudUrl() + "/portal/locallogin");
            email.setPassword(password);
            List allAdmins = this.userDao.getAllAdmins(1, cloudName);
            for (User adminUser : allAdmins) {
                if (!adminUser.isActive()) continue;
                emailRecipent = new EmailRecipent();
                emailRecipent.setUserName(adminUser.getUserName());
                emailRecipent.setEmail(adminUser.getEmailId());
                notifyRecipentsList.add(emailRecipent);
                logger.debug("...admin...." + adminUser.getUserName());
            }
            ArrayList<String> policyNames = new ArrayList<String>();
            policyNames.add(actionOnUser.getPolicyName());
            List delegatedAdmins = this.userDao.getAllReadOnlyAdminsForPolicyName(1, policyNames);
            for (User delegatedAdmin : delegatedAdmins) {
                if (!delegatedAdmin.isActive()) continue;
                emailRecipent = new EmailRecipent();
                emailRecipent.setUserName(delegatedAdmin.getUserName());
                emailRecipent.setEmail(delegatedAdmin.getEmailId());
                notifyRecipentsList.add(emailRecipent);
                logger.debug("...delegated admin...." + delegatedAdmin.getUserName());
            }
            User actionUser = this.userDao.getUserInfoByName(1, actionByName);
            emailRecipent = new EmailRecipent();
            emailRecipent.setUserName(actionUser.getUserName());
            emailRecipent.setEmail(actionUser.getEmailId());
            recipentsList.add(emailRecipent);
            email.setAction("create-server");
            email.setNotifyRecipents(notifyRecipentsList);
            email.setRecipents(recipentsList);
            logger.debug("calling email..");
            this.cloudMailService.sendMail(cloud, email);
        }
    }

    public void sendMail(Cloud cloud, String cloudName, String currentUserName, String userName, String emailId, String recoveryKey) {
        EmailProps email = new EmailProps();
        email.setAction("new-user-first-time-password-set");
        email.setActionOn(userName);
        email.setDownloadLink(this.registry.get(cloud.getCloudId()).getPropertyFileValueCloudUrl() + "/portal/restPassword?tok=" + recoveryKey + "&user=" + userName + "&cloudname=" + cloudName + "&setpassword=true");
        email.setActionBy(currentUserName);
        email.setCloudName(cloudName);
        email.setToAdmins(false);
        email.setCloudURL(this.registry.get(cloud.getCloudId()).getPropertyFileValueCloudUrl());
        EmailRecipent emailRecipent = new EmailRecipent();
        emailRecipent.setUserName(userName);
        emailRecipent.setEmail(emailId);
        ArrayList<EmailRecipent> recipentsList = new ArrayList<EmailRecipent>();
        recipentsList.add(emailRecipent);
        logger.debug("calling email..");
        email.setRecipents(recipentsList);
        this.cloudMailService.sendMail(cloud, email);
    }

    @Override
    public void multipleUserBlockOrDeleteMail(Cloud cloud, String cloudName, int cloudId, String blockOrDeletedBy, String userName, String emailId, String action) {
        EmailProps email = new EmailProps();
        email.setAction(action);
        email.setActionOn(userName);
        email.setActionBy(blockOrDeletedBy);
        email.setCloudName(cloudName);
        email.setToAdmins(false);
        EmailRecipent emailRecipent = new EmailRecipent();
        emailRecipent.setUserName(userName);
        emailRecipent.setEmail(emailId);
        ArrayList<EmailRecipent> recipentsList = new ArrayList<EmailRecipent>();
        recipentsList.add(emailRecipent);
        logger.debug("calling email..");
        email.setRecipents(recipentsList);
        this.cloudMailService.sendMail(cloud, email);
    }

    @Override
    public List<UserElement> getAllUsers(int cloudId, String cloudName, boolean onlyActiveUsers, boolean site) {
        ArrayList<UserElement> userElementList = new ArrayList<UserElement>();
        List usersList = this.userDao.getAllUsers(cloudId, cloudName, site);
        for (User user : usersList) {
            if (user == null) continue;
            UserElement ue = new UserElement();
            BeanUtils.copyProperties((Object)user, (Object)ue);
            ue.setShareEnabled(user.isShareEnabled());
            BackupPoliciesAdminList backupPolicyList = new BackupPoliciesAdminList();
            if (user.getBackupPoliciesAdmin() != null) {
                backupPolicyList.setBackupPoliciesAdmin(user.getBackupPoliciesAdmin());
                ue.setBackupPoliciesAdminList(backupPolicyList);
            }
            SyncPoliciesAdminList syncPolicyList = new SyncPoliciesAdminList();
            if (user.getSyncPoliciesAdmin() != null) {
                syncPolicyList.setSyncPoliciesAdmin(user.getSyncPoliciesAdmin());
                ue.setSyncPoliciesAdminList(syncPolicyList);
            }
            if (user.isGuest() || user.isSuperAdmin()) continue;
            if (onlyActiveUsers && user.isActive()) {
                userElementList.add(ue);
                continue;
            }
            if (onlyActiveUsers) continue;
            userElementList.add(ue);
        }
        return userElementList;
    }

    @Override
    public UserElement getUserInfo(int cloudId, String cloudName, String userName) {
        ArrayList<MiniCloudElement> cloudElements = new ArrayList<MiniCloudElement>();
        UserElement usrElement = new UserElement();
        User user = this.userDao.getUserInfoByName(cloudId, cloudName, userName);
        if (user != null) {
            logger.debug(userName + "&&@@@$$$$$$@@..sync disabled.....");
            List ucacList = this.userMiniCloudMappingDao.getAccessControlMappingsByUser(cloudId, cloudName, user.getUserId());
            if (!CollectionUtils.isEmpty((Collection)ucacList)) {
                for (UserCloudAccessControl ucac : ucacList) {
                    MiniCloudElement cloudElement = new MiniCloudElement();
                    MiniCloud cloud = this.miniCloudDao.getMiniCloudByID(cloudId, cloudName, ucac.getMiniCloudFK());
                    if (cloud == null) continue;
                    BeanUtils.copyProperties((Object)cloud, (Object)cloudElement);
                    cloudElements.add(cloudElement);
                }
            }
            if (StringUtils.isEmpty((CharSequence)user.getLastModifiedTimestamp())) {
                usrElement.setLastModifiedTimestamp(user.getCreatedTimestamp());
            }
            MiniCloudElementList miniCloudElementList = new MiniCloudElementList();
            miniCloudElementList.setMiniClouds(cloudElements);
            usrElement.setMiniCloudElementList(miniCloudElementList);
            BeanUtils.copyProperties((Object)user, (Object)usrElement);
            usrElement.setShareEnabled(user.isShareEnabled());
            PciAuthorizationTokens authorizationTokens = this.pciAuthorizationTokensDao.getPciAuthorizationTokensForUserId(cloudId, cloudName, user.getUserId());
            if (authorizationTokens != null) {
                usrElement.setExternalStorageAuthorized(true);
            } else {
                usrElement.setExternalStorageAuthorized(false);
            }
            logger.debug(".....policy name.... " + usrElement.getPolicyName() + "...sync..." + usrElement.getSyncPolicyName());
            if (StringUtils.isEmpty((CharSequence)usrElement.getPolicyName()) && StringUtils.isEmpty((CharSequence)usrElement.getSyncPolicyName())) {
                usrElement.setSyncPolicyName(usrElement.getSyncPolicyName());
                usrElement.setPolicyName(usrElement.getPolicyName());
            }
        } else {
            throw new EmptyResultDataAccessException(1);
        }
        return usrElement;
    }

    @Override
    public UserElement getUserInfoLatest(Cloud cloud, String userName) {
        ArrayList<MiniCloudElement> cloudElements = new ArrayList<MiniCloudElement>();
        UserElement usrElement = new UserElement();
        int cloudId = cloud.getCloudId();
        String cloudName = cloud.getCloudName();
        User user = this.userDao.getUserInfoByName(cloudId, cloudName, userName);
        List list = cloud.getCloudCustomisableDetails();
        list.removeAll(Collections.singleton(null));
        boolean isCloudLevelSyncEnabled = this.isCloudLevelSyncEnabled(list);
        if (user != null) {
            List ucacList;
            if (user.isReadOnlyAdmin()) {
                BackupPoliciesAdminList backupPolicyAdminList = new BackupPoliciesAdminList();
                backupPolicyAdminList.setBackupPoliciesAdmin(user.getBackupPoliciesAdmin());
                usrElement.setBackupPoliciesAdminList(backupPolicyAdminList);
                SyncPoliciesAdminList syncPolicyAdminList = new SyncPoliciesAdminList();
                syncPolicyAdminList.setSyncPoliciesAdmin(user.getSyncPoliciesAdmin());
                usrElement.setSyncPoliciesAdminList(syncPolicyAdminList);
                OdbPolicesAdminList odbPolicesAdminList = new OdbPolicesAdminList();
                odbPolicesAdminList.setOdbPoliciesAdminForUser(user.getOdbPoliciesAdmin());
                usrElement.setOdbPoliciesAdminList(odbPolicesAdminList);
                SpPolicesAdminList spPolicesAdminList = new SpPolicesAdminList();
                spPolicesAdminList.setSpPoliciesAdmin(user.getSpPoliciesAdmin());
                usrElement.setSpPoliciesAdminList(spPolicesAdminList);
            }
            logger.debug(userName + "&&@@@$$$$$$@@..sync ....." + isCloudLevelSyncEnabled);
            if (isCloudLevelSyncEnabled && !CollectionUtils.isEmpty((Collection)(ucacList = this.userMiniCloudMappingDao.getAccessControlMappingsByUser(cloudId, cloudName, user.getUserId())))) {
                for (UserCloudAccessControl ucac : ucacList) {
                    MiniCloudElement cloudElement = new MiniCloudElement();
                    MiniCloud mc = this.miniCloudDao.getMiniCloudByID(cloudId, cloudName, ucac.getMiniCloudFK());
                    if (mc == null) continue;
                    BeanUtils.copyProperties((Object)mc, (Object)cloudElement);
                    cloudElements.add(cloudElement);
                }
            }
            if (StringUtils.isEmpty((CharSequence)user.getLastModifiedTimestamp())) {
                usrElement.setLastModifiedTimestamp(user.getCreatedTimestamp());
            }
            MiniCloudElementList miniCloudElementList = new MiniCloudElementList();
            miniCloudElementList.setMiniClouds(cloudElements);
            usrElement.setMiniCloudElementList(miniCloudElementList);
            BeanUtils.copyProperties((Object)user, (Object)usrElement);
            usrElement.setShareEnabled(user.isShareEnabled());
            PciAuthorizationTokens authorizationTokens = this.pciAuthorizationTokensDao.getPciAuthorizationTokensForUserId(cloudId, cloudName, user.getUserId());
            if (authorizationTokens != null) {
                usrElement.setExternalStorageAuthorized(true);
            } else {
                usrElement.setExternalStorageAuthorized(false);
            }
        } else {
            throw new EmptyResultDataAccessException(1);
        }
        logger.debug(".....policy name.... " + usrElement.getPolicyName() + "...sync..." + usrElement.getSyncPolicyName());
        usrElement.setSyncPolicyName(user.getSyncPolicyName());
        usrElement.setPolicyName(user.getPolicyName());
        return usrElement;
    }

    private boolean isCloudLevelSyncEnabled(List<CloudCustomisableDetails> list) {
        for (CloudCustomisableDetails customisableDetails : list) {
            if (!SYNC_ENABLED.equalsIgnoreCase(customisableDetails.getName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public UserElement getUserByUserNameOrEmail(Cloud cloud, String userName) {
        ArrayList<MiniCloudElement> cloudElements = new ArrayList<MiniCloudElement>();
        int cloudId = cloud.getCloudId();
        String cloudName = cloud.getCloudName();
        UserElement usrElement = new UserElement();
        User user = this.userDao.getUserByUserNameOrEmail(cloud.getCloudId(), userName);
        if (user == null && this.isAADEnabled(cloud.getCloudCustomisableDetails())) {
            user = this.userDao.getUserByUserNameOrAADLoginId(cloudId, userName);
        }
        if (user != null) {
            GmailBackupPolicyElement gdriveBackupPolicyElement;
            GmailBackupPolicyElement gmailBackupPolicyElement;
            OfficeBackupPolicyElement officeBackupPolicyElement;
            SyncPolicyElement syncPolicyElement;
            BackupPolicyElement backupPolicyElement;
            logger.debug("...................." + user.isSyncEnabled());
            logger.debug("USer not null :" + user.getUserName());
            List ucacList = this.userMiniCloudMappingDao.getAccessControlMappingsByUser(cloudId, cloud.getCloudName(), user.getUserId());
            if (!CollectionUtils.isEmpty((Collection)ucacList)) {
                for (UserCloudAccessControl ucac : ucacList) {
                    MiniCloudElement cloudElement = new MiniCloudElement();
                    MiniCloud miniCloud = this.miniCloudDao.getMiniCloudByID(cloudId, cloudName, ucac.getMiniCloudFK());
                    if (miniCloud == null) continue;
                    BeanUtils.copyProperties((Object)miniCloud, (Object)cloudElement);
                    cloudElements.add(cloudElement);
                }
            }
            logger.debug(user.getUserName() + ".....loading policy......." + user.isBackupTargetAssigned());
            if (StringUtils.isEmpty((CharSequence)user.getLastModifiedTimestamp())) {
                usrElement.setLastModifiedTimestamp(user.getCreatedTimestamp());
            }
            MiniCloudElementList miniCloudElementList = new MiniCloudElementList();
            miniCloudElementList.setMiniClouds(cloudElements);
            usrElement.setMiniCloudElementList(miniCloudElementList);
            BeanUtils.copyProperties((Object)user, (Object)usrElement);
            usrElement.setShareEnabled(user.isShareEnabled());
            usrElement.setBackupTargetAssigned(user.isBackupTargetAssigned());
            PciAuthorizationTokens authorizationTokens = this.pciAuthorizationTokensDao.getPciAuthorizationTokensForUserId(cloudId, cloudName, user.getUserId());
            if (!StringUtils.isEmpty((CharSequence)usrElement.getPolicyName()) && (backupPolicyElement = this.getBackupPolicyElement(cloudId, this.backupPolicyDao.getBackupPolicy(cloudId, cloudName, user.getPolicyName()))) != null) {
                usrElement.setBackupPolicyElement(this.getBackupPolicyElement(cloudId, this.backupPolicyDao.getBackupPolicy(cloudId, cloudName, user.getPolicyName())));
                usrElement.setBpCanAdminChangeUserPassword(usrElement.getBackupPolicyElement().isCanAdminChangeUserPassword());
                usrElement.setBpCanAdminRestore(usrElement.getBackupPolicyElement().isCanAdminRestore());
                usrElement.setBpCanUserChangePassword(usrElement.getBackupPolicyElement().isCanUserChangePassword());
                usrElement.setBpAllowEndUserTocontrolRestore(usrElement.getBackupPolicyElement().isAllowEndUserTocontrolRestore());
            }
            if (!StringUtils.isEmpty((CharSequence)usrElement.getSyncPolicyName()) && (syncPolicyElement = this.getSyncPolicyElement(cloudId, this.syncPolicyDao.getSyncPolicy(cloudId, cloudName, user.getSyncPolicyName()))) != null) {
                usrElement.setSyncPolicyElement(this.getSyncPolicyElement(cloudId, this.syncPolicyDao.getSyncPolicy(cloudId, cloudName, user.getSyncPolicyName())));
                usrElement.setSyncCanAdminChangeUserPassword(usrElement.getSyncPolicyElement().isCanAdminChangeUserPassword());
                usrElement.setSyncCanAdminRestore(false);
                usrElement.setSyncCanUserChangePassword(usrElement.getSyncPolicyElement().isCanUserChangePassword());
                usrElement.setSyncAllowEndUserTocontrolRestore(usrElement.getSyncPolicyElement().isAllowEndUserTocontrolRestore());
            }
            if (user.isOnedriveBkpEnabled() && !StringUtils.isEmpty((CharSequence)user.getOneDrivePolicyName()) && (officeBackupPolicyElement = this.getOfficeBackupPolicyElement(cloudId, this.userDao.getOfficeBackupPolicyByPolicyName(cloudId, user.getOneDrivePolicyName()))) != null) {
                usrElement.setOfficeBackupPolicyElement(officeBackupPolicyElement);
                usrElement.setOdCanAdminChangeUserPassword(usrElement.getOfficeBackupPolicyElement().isCanAdminChangeUserPassword());
                usrElement.setOdCanAdminRestore(usrElement.getOfficeBackupPolicyElement().isCanAdminRestore());
                usrElement.setOdCanUserChangePassword(usrElement.getOfficeBackupPolicyElement().isCanUserChangePassword());
                usrElement.setOdAllowEndUserTocontrolRestore(false);
            }
            if (user.isExchangeBkpEnabled() && !StringUtils.isEmpty((CharSequence)user.getExchangePolicyName()) && (officeBackupPolicyElement = this.getOfficeBackupPolicyElement(cloudId, this.userDao.getOfficeBackupPolicyByPolicyName(cloudId, user.getExchangePolicyName()))) != null) {
                usrElement.setOfficeBackupPolicyElement(officeBackupPolicyElement);
                usrElement.setExCanAdminChangeUserPassword(usrElement.getOfficeBackupPolicyElement().isCanAdminChangeUserPassword());
                usrElement.setExCanAdminRestore(usrElement.getOfficeBackupPolicyElement().isCanAdminRestore());
                usrElement.setExCanUserChangePassword(usrElement.getOfficeBackupPolicyElement().isCanUserChangePassword());
                usrElement.setExAllowEndUserTocontrolRestore(false);
            }
            if (user.isSite() && !StringUtils.isEmpty((CharSequence)user.getSpPolicyName()) && (officeBackupPolicyElement = this.getOfficeBackupPolicyElement(cloudId, this.userDao.getOfficeBackupPolicyByPolicyName(cloudId, user.getSpPolicyName()))) != null) {
                usrElement.setOfficeBackupPolicyElement(officeBackupPolicyElement);
                usrElement.setSpCanAdminChangeUserPassword(usrElement.getOfficeBackupPolicyElement().isCanAdminChangeUserPassword());
                usrElement.setSpCanAdminRestore(usrElement.getOfficeBackupPolicyElement().isCanAdminRestore());
                usrElement.setSpCanUserChangePassword(usrElement.getOfficeBackupPolicyElement().isCanUserChangePassword());
                usrElement.setSpAllowEndUserTocontrolRestore(false);
            }
            if (user.isGmailBkpEnabled() && (gmailBackupPolicyElement = this.getGmailBackupPolicyElement(cloudId, this.userDao.getGmailBackupPolicy(cloudId, user.getGmailPolicyName(), GmailBackupPolicy.TYPE.GMAIL.getProductType()))) != null) {
                usrElement.setGmailBackupPolicyElement(gmailBackupPolicyElement);
                usrElement.setGmailCanAdminChangeUserPassword(usrElement.getGmailBackupPolicyElement().isCanAdminChangeUserPassword());
                usrElement.setGmailCanAdminRestore(usrElement.getGmailBackupPolicyElement().isCanAdminRestore());
                usrElement.setGmailCanUserChangePassword(usrElement.getGmailBackupPolicyElement().isCanUserChangePassword());
                usrElement.setGmailAllowEndUserTocontrolRestore(false);
            }
            if (user.isGdriveBkpEnabled() && (gdriveBackupPolicyElement = this.getGmailBackupPolicyElement(cloudId, this.userDao.getGmailBackupPolicy(cloudId, user.getGdrivePolicyName(), GmailBackupPolicy.TYPE.GOOGLEDRIVE.getProductType()))) != null) {
                usrElement.setGdriveBackupPolicyElement(gdriveBackupPolicyElement);
                usrElement.setGdriveCanAdminChangeUserPassword(usrElement.getGdriveBackupPolicyElement().isCanAdminChangeUserPassword());
                usrElement.setGdriveCanAdminRestore(usrElement.getGdriveBackupPolicyElement().isCanAdminRestore());
                usrElement.setGdriveCanUserChangePassword(usrElement.getGdriveBackupPolicyElement().isCanUserChangePassword());
                usrElement.setGdriveAllowEndUserTocontrolRestore(false);
            }
            if (user.isReadOnlyAdmin()) {
                BackupPoliciesAdminList backupPolicyAdminList = new BackupPoliciesAdminList();
                backupPolicyAdminList.setBackupPoliciesAdmin(user.getBackupPoliciesAdmin());
                usrElement.setBackupPoliciesAdminList(backupPolicyAdminList);
                SyncPoliciesAdminList syncPolicyAdminList = new SyncPoliciesAdminList();
                syncPolicyAdminList.setSyncPoliciesAdmin(user.getSyncPoliciesAdmin());
                usrElement.setSyncPoliciesAdminList(syncPolicyAdminList);
                OdbPolicesAdminList odbPolicesAdminList = new OdbPolicesAdminList();
                odbPolicesAdminList.setOdbPoliciesAdminForUser(user.getOdbPoliciesAdmin());
                usrElement.setOdbPoliciesAdminList(odbPolicesAdminList);
                SpPolicesAdminList spPolicesAdminList = new SpPolicesAdminList();
                spPolicesAdminList.setSpPoliciesAdmin(user.getSpPoliciesAdmin());
                usrElement.setSpPoliciesAdminList(spPolicesAdminList);
                GmailPoliciesAdminList gmailPolicyAdminList = new GmailPoliciesAdminList();
                gmailPolicyAdminList.setGmailPoliciesAdmin(user.getGmailPoliciesAdmin());
                usrElement.setGmailPoliciesAdminList(gmailPolicyAdminList);
                GmailPoliciesAdminList gdrivePolicyAdminList = new GmailPoliciesAdminList();
                gdrivePolicyAdminList.setGmailPoliciesAdmin(user.getGdrivePoliciesAdmin());
                usrElement.setGdrivePoliciesAdminList(gdrivePolicyAdminList);
            }
            if (authorizationTokens != null) {
                usrElement.setExternalStorageAuthorized(true);
            } else {
                usrElement.setExternalStorageAuthorized(false);
            }
            if (!StringUtils.isEmpty((CharSequence)user.getMigrationStatus()) && User.MIGRATION_STATUS.IN_PROGRESS.toString().equalsIgnoreCase(user.getMigrationStatus())) {
                usrElement.setUserUnderOdbMigration(true);
            }
        } else {
            return null;
        }
        usrElement.setGoogleSecretKey(user.getGoogleSecretKey());
        usrElement.setConsentGiven(user.getConsentGiven());
        logger.debug(".....loading getUserByUserNameOrEmail......." + usrElement.isSyncEnabled());
        return usrElement;
    }

    private BackupPolicyElement getBackupPolicyElement(int cloudId, BackupPolicy backupPolicy) {
        BackupPolicyElement element = null;
        ArrayList<String> folderPaths = new ArrayList<String>();
        ArrayList<String> scheduleNames = new ArrayList<String>();
        ArrayList<String> networkThrottlingNames = new ArrayList<String>();
        ArrayList calloutScriptStrs = new ArrayList();
        if (backupPolicy == null) {
            return null;
        }
        for (Schedule schedule : backupPolicy.getSchedules()) {
            scheduleNames.add(schedule.getScheduleName());
        }
        for (NetworkThrottling networkThrottling : backupPolicy.getNetworkThrottlings()) {
            networkThrottlingNames.add(networkThrottling.getNetworkThrottlingName());
        }
        for (BackupFolders backupFolder : backupPolicy.getBackupFolders()) {
            BackupFolderElement backupFolderElement = new BackupFolderElement();
            if (backupFolder == null) continue;
            backupFolderElement.setFolderPath(backupFolder.getFolderPath());
            backupFolderElement.setOsType(backupFolder.getOs());
            folderPaths.add(backupFolder.getFolderPath());
        }
        if (backupPolicy != null) {
            element = new BackupPolicyElement();
            BeanUtils.copyProperties((Object)backupPolicy, (Object)element);
            element.setPolicygroupName(backupPolicy.getPolicyName());
            element.setExceptionsToExclusions(new ArrayList());
            element.setBackupFolderPaths(new ArrayList());
            element.setSqlBackupFolders(new ArrayList());
            element.getBackupFolderPaths().addAll(folderPaths);
            if (element.getNwFromClientToPGMB() <= 0.0) {
                element.setNwFromClientToPGMB((double)element.getNwFromClientToPG().longValue());
            }
            element.setCalloutScripts(calloutScriptStrs);
            List filters = backupPolicy.getInclusionFilter();
            List<Object> filterNames = new ArrayList();
            if (filters != null) {
                filterNames = filters.stream().filter(filter -> Objects.nonNull(filter.getFilterName())).map(filter -> filter.getFilterName()).collect(Collectors.toList());
                element.setFilterInclusionName(filterNames);
            }
            element.setNetworkThrottlingNames(new ArrayList());
            element.setScheduleNames(new ArrayList());
            element.getNetworkThrottlingNames().addAll(networkThrottlingNames);
            element.getScheduleNames().addAll(scheduleNames);
            element.setEndpointUiPreferences((List)backupPolicy.getEndpointUiPreferences());
            element.setEndpointDisabledUiPreferences(backupPolicy.getEndpointDisabledUiPreferences());
            ArrayList list = backupPolicy.getPrivacyGateways();
            PrivacyGatewayMappingElement mappingElement = new PrivacyGatewayMappingElement();
            ArrayList<String> pgList = new ArrayList<String>();
            for (PrivacyGateway privacyGateway : list) {
                if (privacyGateway == null) continue;
                mappingElement.setGatewayNwThrottlingName("PGThrottle-name");
                pgList.add(privacyGateway.getGatewayName());
            }
            mappingElement.setPrivacyGatewayNames(new ArrayList());
            mappingElement.setPrivacyGatewayNames(pgList);
            element.setPrivacyGatewayMappingElement(mappingElement);
            element.setSearchAlgoForPg(backupPolicy.getSearchAlgoForPg());
            if (backupPolicy.getCloudCredentials() != null) {
                element.setCloudCredential(backupPolicy.getCloudCredentials().getIdentity());
            }
        }
        return element;
    }

    public SyncPolicyElement getSyncPolicyElement(int cloudId, SyncPolicy syncPolicy) {
        ArrayList<String> netWorkThrottlingNames = new ArrayList<String>();
        if (syncPolicy == null) {
            return null;
        }
        for (NetworkThrottling netWorkThrottling : syncPolicy.getNetworkThrottlings()) {
            netWorkThrottlingNames.add(netWorkThrottling.getNetworkThrottlingName());
        }
        SyncPolicyElement element = new SyncPolicyElement();
        BeanUtils.copyProperties((Object)syncPolicy, (Object)element);
        element.setPolicygroupName(syncPolicy.getPolicyName());
        element.setNetworkThrottlingNames(new ArrayList());
        element.getNetworkThrottlingNames().addAll(netWorkThrottlingNames);
        List filters = syncPolicy.getInclusionFilter();
        List<Object> filterNames = new ArrayList();
        if (filters != null) {
            filterNames = filters.stream().filter(filter -> Objects.nonNull(filter.getFilterName())).map(filter -> filter.getFilterName()).collect(Collectors.toList());
            element.setFilterInclusionName(filterNames);
        }
        ArrayList list = syncPolicy.getPrivacyGateways();
        PrivacyGatewayMappingElement mappingElement = new PrivacyGatewayMappingElement();
        if (element.getNwFromClientToPGMB() <= 0.0) {
            element.setNwFromClientToPGMB((double)element.getNwFromClientToPG().longValue());
        }
        if (!CollectionUtils.isEmpty((Collection)list)) {
            ArrayList<String> pgList = new ArrayList<String>();
            for (PrivacyGateway privacyGateway : list) {
                if (privacyGateway == null) continue;
                mappingElement.setGatewayNwThrottlingName("PGThrottle-name");
                pgList.add(privacyGateway.getGatewayName());
            }
            mappingElement.setPrivacyGatewayNames(new ArrayList());
            mappingElement.setPrivacyGatewayNames(pgList);
            element.setPrivacyGatewayMappingElement(mappingElement);
        } else {
            element.setPrivacyGatewayMappingElement(mappingElement);
        }
        if (syncPolicy.getCloudCredentials() != null) {
            element.setCloudCredential(syncPolicy.getCloudCredentials().getIdentity());
        }
        element.setSearchAlgoForPg(syncPolicy.getSearchAlgoForPg());
        element.setEndpointUiPreferences((List)syncPolicy.getEndpointUiPreferences());
        element.setEndpointDisabledUiPreferences(syncPolicy.getEndpointDisabledUiPreferences());
        return element;
    }

    @Override
    public UserElement bulkUpdateUserInfoForMSP(int cloudId, String cloudName, UserElement userElement) {
        UserElement usrResponse = new UserElement();
        boolean isMSPEnv = false;
        List cloudCustomisableDetails = this.cloudDao.getCloudCustomisableDetails(cloudName);
        for (CloudCustomisableDetails cloudCustomisableDetail : cloudCustomisableDetails) {
            if (!MSP_LICENSE.equalsIgnoreCase(cloudCustomisableDetail.getName())) continue;
            isMSPEnv = true;
        }
        User user = this.userDao.getUserInfoByName(cloudId, cloudName, userElement.getUserName());
        if (isMSPEnv) {
            long lastModifiedTime = System.currentTimeMillis();
            ObjectId userId = user.getUserId();
            user.setUserId(userId);
            user.setUserName(userElement.getUserName());
            user.setEmailId(userElement.getEmailId());
            user.setLastModifiedTimestamp(String.valueOf(lastModifiedTime));
            user.setPolicyName(userElement.getPolicyName());
            user.setPolicyModifiedTime(lastModifiedTime);
            user.setSuspended(userElement.isSuspended());
            logger.debug(" @@@@@@@@@@@@@@@ before updated USER .... " + String.valueOf(userId));
        }
        User updatedUser = this.userDao.updateUser(cloudId, cloudName, user);
        this.deviceDao.updateUserInfoInDeviceBkpOverview(cloudId, updatedUser);
        logger.debug(" @@@@@@@@@@@@@@@ updated USER .... " + String.valueOf(updatedUser));
        if (updatedUser != null) {
            BeanUtils.copyProperties((Object)updatedUser, (Object)usrResponse);
        }
        return usrResponse;
    }

    @Override
    public UserElement updateUserInfo(int cloudId, String cloudName, UserElement userElement, String userName) {
        User existingUser;
        GmailPoliciesAdminList gdrivePoliciesAdminList;
        GmailPoliciesAdminList gmailPoliciesAdminList;
        SpPolicesAdminList spPolicesAdminList;
        OdbPolicesAdminList odbPolicyAdminList;
        SyncPoliciesAdminList syncPolicyAdminList;
        BackupPolicy bkpPolicy;
        UserElement usrResponse = new UserElement();
        User user = this.userDao.getUserInfoByName(cloudId, cloudName, userElement.getUserName());
        boolean softBlockEnabled = user.isSoftBlockEnabled();
        ObjectId userId = user.getUserId();
        BeanUtils.copyProperties((Object)userElement, (Object)user);
        user.setSoftBlockEnabled(softBlockEnabled);
        user.setShareEnabled(userElement.isShareEnabled());
        user.setServerBackupEnabled(userElement.isServerBackupEnabled());
        user.setUserId(userId);
        user.setLastModifiedTimestamp(String.valueOf(System.currentTimeMillis()));
        if (StringUtils.isNotEmpty((CharSequence)user.getPolicyName()) && (bkpPolicy = this.userDao.getBackupPolicyByPolicyName(cloudId, user.getPolicyName())) != null && bkpPolicy.isLegalHoldEnabled() && !user.isSuperAdmin()) {
            user.setAdmin(false);
        }
        logger.debug(" @@@@@@@@@@@@@@@ before updated USER .... " + String.valueOf(userId));
        BackupPoliciesAdminList backupPolicyAdminList = userElement.getBackupPoliciesAdminList();
        if (backupPolicyAdminList != null) {
            List backupPoliciesAdmin = backupPolicyAdminList.getBackupPoliciesAdmin();
            user.setBackupPoliciesAdmin(backupPoliciesAdmin);
        }
        if ((syncPolicyAdminList = userElement.getSyncPoliciesAdminList()) != null) {
            List syncPoliciesAdmin = syncPolicyAdminList.getSyncPoliciesAdmin();
            user.setSyncPoliciesAdmin(syncPoliciesAdmin);
        }
        if ((odbPolicyAdminList = userElement.getOdbPoliciesAdminList()) != null) {
            List odbPoliciesAdmin = odbPolicyAdminList.getOdbPoliciesAdminForUser();
            logger.debug("odbpolicies for admin..." + String.valueOf(odbPoliciesAdmin));
            user.setOdbPoliciesAdmin(odbPoliciesAdmin);
        }
        if ((spPolicesAdminList = userElement.getSpPoliciesAdminList()) != null) {
            List spPoliciesAdmin = spPolicesAdminList.getSpPoliciesAdmin();
            logger.debug("spPoliciesAdmin for admin..." + String.valueOf(spPoliciesAdmin));
            user.setSpPoliciesAdmin(spPoliciesAdmin);
        }
        if ((gmailPoliciesAdminList = userElement.getGmailPoliciesAdminList()) != null) {
            List gmailPoliciesAdmin = gmailPoliciesAdminList.getGmailPoliciesAdmin();
            logger.debug("gmailPoliciesAdmin for admin..." + String.valueOf(gmailPoliciesAdmin));
            user.setGmailPoliciesAdmin(gmailPoliciesAdmin);
        }
        if ((gdrivePoliciesAdminList = userElement.getGdrivePoliciesAdminList()) != null) {
            List gmailPoliciesAdmin = gdrivePoliciesAdminList.getGmailPoliciesAdmin();
            logger.debug("gmailPoliciesAdmin for admin..." + String.valueOf(gmailPoliciesAdmin));
            user.setGdrivePoliciesAdmin(gmailPoliciesAdmin);
        }
        if (!(StringUtils.isEmpty((CharSequence)user.getGmailPolicyName()) || StringUtils.isEmpty((CharSequence)(existingUser = this.userDao.getUserInfoByName(cloudId, cloudName, userElement.getUserName())).getGmailPolicyName()) || existingUser.getGmailPolicyName().equalsIgnoreCase(user.getGmailPolicyName()))) {
            this.updateDeviceBackupOverViewForPolicy(cloudId, user);
        }
        if (!(StringUtils.isEmpty((CharSequence)(existingUser = this.userDao.getUserInfoByName(cloudId, cloudName, userElement.getUserName())).getPolicyName()) || StringUtils.isEmpty((CharSequence)user.getPolicyName()) || existingUser.getPolicyName().equalsIgnoreCase(user.getPolicyName()))) {
            user.setPolicyModifiedTime(System.currentTimeMillis());
        }
        if (!StringUtils.isEmpty((CharSequence)existingUser.getOneDrivePolicyName()) && !StringUtils.isEmpty((CharSequence)user.getOneDrivePolicyName())) {
            logger.debug(existingUser.getOneDrivePolicyName() + "....before moving existing batch entries....." + user.getOneDrivePolicyName());
            logger.debug(!StringUtils.isEmpty((CharSequence)existingUser.getOneDrivePolicyName()) + "....before moving existing batch entries1....." + !StringUtils.isEmpty((CharSequence)user.getOneDrivePolicyName()));
            if (!(StringUtils.isEmpty((CharSequence)existingUser.getOneDrivePolicyName()) || StringUtils.isEmpty((CharSequence)user.getOneDrivePolicyName()) || existingUser.getOneDrivePolicyName().equalsIgnoreCase(user.getOneDrivePolicyName()))) {
                logger.debug("...odb...before moving existing batch entries1.....");
                this.userDao.checkandChangePolicyRelatedBackup(existingUser.getOneDrivePolicyName(), user.getOneDrivePolicyName(), user.getUserName());
                logger.debug("..odb..AFTER moving existing batch entries.....");
            }
        }
        if (!(StringUtils.isEmpty((CharSequence)existingUser.getExchangePolicyName()) || StringUtils.isEmpty((CharSequence)user.getExchangePolicyName()) || StringUtils.isEmpty((CharSequence)existingUser.getExchangePolicyName()) || StringUtils.isEmpty((CharSequence)user.getExchangePolicyName()) || existingUser.getExchangePolicyName().equalsIgnoreCase(user.getExchangePolicyName()))) {
            logger.debug("....mail before moving existing batch entries1.....");
            this.userDao.checkandChangePolicyRelatedBackup(existingUser.getExchangePolicyName(), user.getExchangePolicyName(), user.getUserName());
            logger.debug(".... mail AFTER moving existing batch entries.....");
        }
        if (!(StringUtils.isEmpty((CharSequence)existingUser.getSpPolicyName()) || StringUtils.isEmpty((CharSequence)user.getSpPolicyName()) || StringUtils.isEmpty((CharSequence)existingUser.getSpPolicyName()) || StringUtils.isEmpty((CharSequence)user.getSpPolicyName()) || existingUser.getSpPolicyName().equalsIgnoreCase(user.getSpPolicyName()))) {
            logger.debug("....sp before moving existing batch entries1.....");
            this.userDao.checkandChangePolicyRelatedBackup(existingUser.getSpPolicyName(), user.getSpPolicyName(), user.getUserName());
            logger.debug("....sp AFTER moving existing batch entries.....");
        }
        String fieldChanged = this.findUserDiff(existingUser, user);
        User updatedUser = this.userDao.updateUser(cloudId, cloudName, user);
        this.deviceDao.updateUserInfoInDeviceBkpOverview(cloudId, updatedUser);
        logger.debug(" @@@@@@@@@@@@@@@ updated USER .... " + String.valueOf(updatedUser));
        if (updatedUser != null) {
            List ucacList = this.userMiniCloudMappingDao.getAccessControlMappingsByUser(cloudId, cloudName, updatedUser.getUserId());
            logger.debug("mapping found: " + ucacList.size());
            for (UserCloudAccessControl ucac : ucacList) {
                this.userMiniCloudMappingDao.deleteUserCloudAccessControlMapping(cloudId, cloudName, ucac);
            }
            MiniCloudElementList cloudElementLists = userElement.getMiniCloudElementList();
            if (cloudElementLists != null) {
                List cloudElements = cloudElementLists.getMiniClouds();
                ArrayList<MiniCloudElement> cloudElementsForResp = new ArrayList<MiniCloudElement>();
                for (MiniCloudElement cloudElement : cloudElements) {
                    MiniCloud miniCloud = this.miniCloudDao.getMiniCloudByName(cloudId, cloudName, cloudElement.getMiniCloudName());
                    if (miniCloud == null) continue;
                    UserCloudAccessControl accessControl = new UserCloudAccessControl();
                    accessControl.setMiniCloudFK(miniCloud.getId());
                    accessControl.setUserFK(updatedUser.getUserId());
                    this.userMiniCloudMappingDao.saveMiniCloud(cloudId, cloudName, accessControl);
                    MiniCloudElement miniCloudForResp = new MiniCloudElement();
                    BeanUtils.copyProperties((Object)miniCloud, (Object)miniCloudForResp);
                    cloudElementsForResp.add(miniCloudForResp);
                }
                cloudElements.clear();
                cloudElements.addAll(cloudElementsForResp);
                cloudElementLists.setMiniClouds(cloudElements);
            }
            BeanUtils.copyProperties((Object)updatedUser, (Object)usrResponse);
            usrResponse.setShareEnabled(updatedUser.isShareEnabled());
            usrResponse.setMiniCloudElementList(cloudElementLists);
        }
        if (!StringUtils.isEmpty((CharSequence)fieldChanged)) {
            this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudName, "edited the details of user (" + user.getUserName() + "). The changed fields are " + fieldChanged, userName, "", "Portal", System.currentTimeMillis(), PCActionTypes.USER_UPDATE.getActionTypeValue());
        }
        return usrResponse;
    }

    private void updateDeviceBackupOverViewForPolicy(int cloudId, User user) {
        logger.debug("updateDeviceBackupOverViewForPolicy--->one");
        List devices = this.deviceDao.getAllDeviceByUserName(cloudId, user.getUserName());
        if (devices != null && !devices.isEmpty()) {
            for (Device device : devices) {
                logger.debug("devices--->one: " + device.getDeviceName());
                DeviceBackupOverView backupOverView = this.deviceManagementService.getDeviceBkpOverviewForDeviceUUID(cloudId, device.getDeviceUUID());
                if (backupOverView == null) continue;
                backupOverView.setFirstBkpStartTime(null);
                this.backupOverViewDao.saveDeviceBackupOverView(cloudId, backupOverView);
            }
        }
    }

    @Override
    public UserElement deleteUser(int cloudId, String cloudName, String userId) {
        UserElement usrResponse = new UserElement();
        User user = this.userDao.getUserInfo(cloudId, userId);
        if (user == null) {
            throw new BaseException(USER_NOT_FOUND);
        }
        List ucacList = this.userMiniCloudMappingDao.getAccessControlMappingsByUser(cloudId, cloudName, user.getUserId());
        logger.debug("mapping found: " + ucacList.size());
        for (UserCloudAccessControl ucac : ucacList) {
            this.userMiniCloudMappingDao.deleteUserCloudAccessControlMapping(cloudId, cloudName, ucac);
        }
        this.deviceDao.deleteAllDeviceByUser(cloudId, cloudName, user);
        this.deviceDao.deleteAllDeviceBkpoverviewByUser(cloudId, user);
        this.authorizationDao.deleteAllTokensForUser(cloudId, cloudName, user);
        BeanUtils.copyProperties((Object)user, (Object)usrResponse);
        usrResponse.setShareEnabled(user.isShareEnabled());
        this.userDao.deleteUser(cloudId, cloudName, user);
        return usrResponse;
    }

    @Override
    public List<Device> blockUnblockDevicebyUserName(int cloudId, String cloudName, String userName, boolean toBlock) {
        List devices = new ArrayList();
        ArrayList<Device> blockedDevice = new ArrayList<Device>();
        devices = this.deviceDao.getDeviceByUserName(cloudId, userName);
        if (!CollectionUtils.isEmpty(devices)) {
            for (Device device : devices) {
                if (!device.isBlocked() && toBlock) {
                    this.deviceDao.blockUnblockDevice(cloudId, cloudName, device, toBlock);
                    this.deviceDao.updateDeviceStatusInOverview(cloudId, device.getDeviceUUID(), toBlock);
                    if (toBlock) {
                        User user = this.userDao.getUserByName(cloudId, device.getUserName());
                        this.authorizationDao.deleteAuthTokenByUserAndUniqueID(cloudId, user, device.getDeviceUUID());
                    }
                    blockedDevice.add(device);
                    continue;
                }
                if (!device.isBlocked() || toBlock) continue;
                this.deviceDao.blockUnblockDevice(cloudId, cloudName, device, toBlock);
                this.deviceDao.updateDeviceStatusInOverview(cloudId, device.getDeviceUUID(), toBlock);
            }
        }
        return blockedDevice;
    }

    @Override
    public List<UserDeviceAccessControl> getUserDevicesAssignedTo(int cloudId, String cloudName, String userName) {
        List devices = new ArrayList();
        ArrayList<Object> assignedDevices = new ArrayList<UserDeviceAccessControl>();
        try {
            devices = this.deviceDao.getDeviceByUserName(cloudId, userName);
            assignedDevices = new ArrayList();
            for (Device device : devices) {
                List assignedDevice = this.deviceDao.getUserDeviceAccessControl(cloudId, device.getId());
                for (UserDeviceAccessControl ud : assignedDevice) {
                    assignedDevices.add(ud);
                }
            }
        }
        catch (Exception e) {
            logger.error("error to get assigned devices for user ...", (Throwable)e);
        }
        return assignedDevices;
    }

    @Override
    public List<UserDeviceAccessControl> getUserDeviceAccessControlByDeviceID(int cloudId, ObjectId deviceId) {
        return this.deviceDao.getUserDeviceAccessControl(cloudId, deviceId);
    }

    @Override
    public List<UserDeviceAccessControl> getUserDeviceAccessControlByUserID(int cloudId, ObjectId userId) {
        return this.deviceDao.getUserDeviceAccessControlByUserID(cloudId, userId);
    }

    @Override
    public void revokeAssignedDevicesBack(int cloudId, String cloudName, List<UserDeviceAccessControl> devices, String userName) {
        try {
            if (!CollectionUtils.isEmpty(devices)) {
                for (UserDeviceAccessControl userDeviceAccessControl : devices) {
                    this.deviceDao.deleteUserDeviceAccess(cloudId, userDeviceAccessControl.getDeviceFK(), userDeviceAccessControl.getUserFK());
                    Device device = this.deviceDao.getDeviceById(cloudId, userDeviceAccessControl.getDeviceFK());
                    User user = this.userDao.getUserById(cloudId, userDeviceAccessControl.getUserFK());
                    this.deviceManagementService.saveStatisticToDatabase(cloudId, "", "revoke assigned asset", userName, device.getDeviceName() + " to " + user.getUserName(), "Portal", System.currentTimeMillis(), PCActionTypes.MINI_CLOUD_ASSIGN.getActionTypeValue());
                }
            }
        }
        catch (Exception e) {
            logger.error("error to revoke assigned asset ...", (Throwable)e);
        }
    }

    @Override
    public User authenticate(int cloudId, String cloudName, String username, String passowrd) {
        User user = this.userDao.getUserInfoByName(cloudId, cloudName, username);
        if (user == null) {
            throw new BaseException(USER_NOT_FOUND, 401);
        }
        if (StringUtils.isEmpty((CharSequence)user.getPasswdHash()) || !user.getPasswdHash().equals(passowrd)) {
            throw new BaseException("Bad Credentials.", 401);
        }
        if (!user.isActive() && !user.isSuperAdmin()) {
            throw new BaseException("User is not active", 403);
        }
        boolean isMSPEnv = false;
        Cloud cloud = this.cloudDao.getCloudDetails(cloudName);
        List list = cloud.getCloudCustomisableDetails();
        for (CloudCustomisableDetails customisableDetails : list) {
            if (!MSP_LICENSE.equalsIgnoreCase(customisableDetails.getName())) continue;
            isMSPEnv = true;
        }
        BackupPolicy userPolicy = this.backupPolicyDao.getBackupPolicy(cloudId, cloudName, user.getPolicyName());
        if (isMSPEnv && !user.isAdmin() && !userPolicy.isActive()) {
            throw new BaseException("policy is not active", 453);
        }
        return user;
    }

    @Override
    public User authenticateV2(int cloudId, String cloudName, String username) {
        User user = this.userDao.getUserInfoByName(cloudId, cloudName, username);
        if (user == null) {
            throw new BaseException(USER_NOT_FOUND, 401);
        }
        if (!user.isActive()) {
            throw new BaseException("User is not active", 403);
        }
        return user;
    }

    @Override
    public void verifyRecoveryKey(int cloudId, String cloudName, String userName, String key) {
        User user = this.userDao.getUserInfoByName(cloudId, cloudName, userName);
        if (user == null) {
            throw new BaseException(USER_NOT_FOUND);
        }
        String recoveryKey = user.getSecurityRecoveryKey();
        for (int i = 0; i < 5; ++i) {
            recoveryKey = MD5Generator.generateMD5OfString((String)recoveryKey);
        }
        if (recoveryKey.equals(key)) {
            return;
        }
        throw new BaseException("Bad Credentials.");
    }

    @Override
    public User updateUserInfo(int cloudId, String cloudName, User user) {
        this.deviceDao.updateUserInfoInDeviceBkpOverview(cloudId, user);
        return this.userDao.updateUser(cloudId, cloudName, user);
    }

    @Override
    public UserElement validateRecoveryParams(int cloudId, String cloudName, UserElement userElement) {
        String userName = userElement.getUserName();
        String email = userElement.getEmailId();
        User user = this.userDao.getUserInfoByName(cloudId, cloudName, userName);
        if (user != null && userName.equalsIgnoreCase(user.getUserName()) && email.equalsIgnoreCase(user.getEmailId()) && user.isActive()) {
            BeanUtils.copyProperties((Object)user, (Object)userElement);
            userElement.setShareEnabled(user.isShareEnabled());
            return userElement;
        }
        return null;
    }

    @Override
    public User getUserDetails(int cloudId, String cloudName, String userName) {
        return this.userDao.getUserInfoByName(cloudId, cloudName, userName);
    }

    @Override
    public User getUserDetailsbyMail(int cloudId, String cloudName, String userMail) {
        return this.userDao.getUserDetailsbyMail(cloudId, cloudName, userMail);
    }

    @Override
    public List<User> getAllActiveUsers(int cloudId) {
        return this.userDao.getAllActiveUsers(cloudId);
    }

    @Override
    public List<User> getAllUsersDetails(int cloudId, String cloudName, boolean site) {
        return this.userDao.getAllUsers(cloudId, cloudName, site);
    }

    @Override
    public List<User> getAllAdmins(int cloudId, String cloudName) {
        return this.userDao.getAllAdmins(cloudId, cloudName);
    }

    @Override
    public UserElement createUser(int cloudId, String cloudName, User user) {
        UserElement userResponse = new UserElement();
        UUID uuid = UUID.randomUUID();
        String recoveryKey = String.valueOf(uuid);
        user.setSecurityRecoveryKey(recoveryKey);
        user.setActive(true);
        user.setFirstLogin(true);
        user.setUserNameLowerCase(user.getUserName().toLowerCase());
        user.setCreatedTimestamp(String.valueOf(System.currentTimeMillis()));
        UserElement userElement = new UserElement();
        BeanUtils.copyProperties((Object)user, (Object)userElement);
        UserElement createduserElement = this.createUser(cloudId, cloudName, userElement, false, this.userDao);
        if (createduserElement != null) {
            logger.debug(user.isShareEnabled() + "&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&" + createduserElement.isShareEnabled());
            userResponse.setShareEnabled(createduserElement.isShareEnabled());
            BeanUtils.copyProperties((Object)createduserElement, (Object)userResponse);
        }
        String recoveryKeyHash = recoveryKey;
        for (int i = 0; i < 5; ++i) {
            recoveryKeyHash = MD5Generator.generateMD5OfString((String)recoveryKeyHash);
        }
        userResponse.setSecurityRecoveryKey(recoveryKeyHash);
        return userResponse;
    }

    @Override
    public boolean createUserFromLdap(int cloudId, String cloudName, LdapUserElement ldapUserElement, String migratedBy, boolean isSyncEnabled, boolean isBackupEnabled, boolean odbBkpEnabled, boolean exchangeBkpEnabled, boolean gmailBkpEnabled, boolean gdriveBkpEnabled) throws Exception {
        boolean userMigrated = false;
        try {
            User userFromDB = this.userDao.getUserByUserNameOrAADLoginId(cloudId, ldapUserElement.getUserName());
            if (userFromDB == null) {
                userFromDB = this.userDao.getUserByUserNameOrEmail(cloudId, ldapUserElement.getEmailId());
            }
            if (userFromDB != null && userFromDB.isGuest()) {
                this.userDao.removeUserbyID(cloudId, userFromDB.getUserId().toString());
            }
            User user = new User();
            UUID uuid = UUID.randomUUID();
            String recoveryKey = String.valueOf(uuid);
            user.setSecurityRecoveryKey(recoveryKey);
            user.setActive(true);
            user.setAdmin(false);
            user.setBackupEnabled(isBackupEnabled);
            user.setSyncEnabled(isSyncEnabled);
            user.setOnedriveBkpEnabled(odbBkpEnabled);
            user.setExchangeBkpEnabled(exchangeBkpEnabled);
            user.setSharePointBkpEnabled(ldapUserElement.isSharePointBkpEnabled());
            user.setFirstLogin(true);
            user.setShareEnabled(true);
            user.setUserName(ldapUserElement.getUserName());
            user.setEmailId(ldapUserElement.getEmailId());
            user.setCreatedTimestamp(String.valueOf(System.currentTimeMillis()));
            user.setDisplayName(ldapUserElement.getDisplayName());
            user.setMigratedBy(migratedBy);
            user.setLocalUser(false);
            user.setLocation(ldapUserElement.getLocation());
            user.setDepartment(ldapUserElement.getDepartment());
            user.setAccountStatus(ldapUserElement.isAccountStatus());
            user.setUserNameLowerCase(ldapUserElement.getUserName().toLowerCase());
            user.setGmailBkpEnabled(gmailBkpEnabled);
            user.setGdriveBkpEnabled(gdriveBkpEnabled);
            if (!StringUtils.isEmpty((CharSequence)ldapUserElement.getDefaultPolicy())) {
                user.setPolicyName(ldapUserElement.getDefaultPolicy());
            }
            if (!StringUtils.isEmpty((CharSequence)ldapUserElement.getDefaultSyncPolicy())) {
                user.setSyncPolicyName(ldapUserElement.getDefaultSyncPolicy());
            }
            if (!StringUtils.isEmpty((CharSequence)ldapUserElement.getDefaultO365Policy())) {
                user.setOneDrivePolicyName(ldapUserElement.getDefaultO365Policy());
            }
            if (!StringUtils.isEmpty((CharSequence)ldapUserElement.getDefaultODBPolicy())) {
                user.setOneDrivePolicyName(ldapUserElement.getDefaultODBPolicy());
            }
            if (!StringUtils.isEmpty((CharSequence)ldapUserElement.getDefaultExchangePolicy())) {
                user.setExchangePolicyName(ldapUserElement.getDefaultExchangePolicy());
            }
            if (!StringUtils.isEmpty((CharSequence)ldapUserElement.getDefaultSharePointPolicy())) {
                user.setSpPolicyName(ldapUserElement.getDefaultSharePointPolicy());
            }
            if (!StringUtils.isEmpty((CharSequence)ldapUserElement.getDefaultGmailPolicy())) {
                user.setGmailPolicyName(ldapUserElement.getDefaultGmailPolicy());
            }
            if (!StringUtils.isEmpty((CharSequence)ldapUserElement.getDefaultGdrivePolicyName())) {
                user.setGdrivePolicyName(ldapUserElement.getDefaultGdrivePolicyName());
            }
            String googleSecretKey = this.getGoogleSecurityKey();
            logger.debug("googleSecretKey for AAD ....." + googleSecretKey);
            user.setGoogleSecretKey(googleSecretKey);
            UserElement userElement = new UserElement();
            BeanUtils.copyProperties((Object)user, (Object)userElement);
            UserElement createduserElement = this.createUser(cloudId, cloudName, userElement, false, this.userDao);
            if (createduserElement != null) {
                userMigrated = true;
                MigrationStatus migrationStatus = new MigrationStatus();
                migrationStatus.setMigratedBy(migratedBy);
                migrationStatus.setMigratededTimestamp(System.currentTimeMillis());
                migrationStatus.setMigrated(true);
                migrationStatus.setUserName(user.getUserName());
                migrationStatus.setEmailId(user.getEmailId());
                this.migrationStatusDao.saveMigrationStatus(cloudId, migrationStatus);
            }
        }
        catch (Exception e) {
            logger.error(EXCEPTION, (Throwable)e);
            logger.debug(EXCEPTION + e.getMessage());
            throw new Exception(e);
        }
        return userMigrated;
    }

    @Override
    public List<User> getAllShareEnabledActiveUsers(int cloudId, String cloudName) {
        return this.userDao.getAllShareEnabledActiveUsers(cloudId, cloudName);
    }

    @Override
    public void saveFailedLogin(int cloudId, String cloudName, FailedLogin failedLogin) {
        this.userDao.saveFailedLogin(cloudId, cloudName, failedLogin);
    }

    @Override
    public User getUserInfoById(int cloudId, String cloudName, String userId) {
        return this.userDao.getUserInfo(cloudId, userId);
    }

    @Override
    public List<UserElement> searchUsers(int cloudId, String userName, boolean isSite) {
        ArrayList<UserElement> userElementList = new ArrayList<UserElement>();
        ArrayList<String> list = new ArrayList<String>(Arrays.asList(userName.split(",")));
        HashSet<String> removeSet = new HashSet<String>();
        removeSet.addAll(list);
        list.clear();
        list.addAll(removeSet);
        List users = this.userDao.searchUsers(cloudId, list, isSite);
        for (User user : users) {
            if (user == null || isSite && !user.isActive()) continue;
            UserElement ue = new UserElement();
            BeanUtils.copyProperties((Object)user, (Object)ue);
            ue.setShareEnabled(user.isShareEnabled());
            if (ue.isGuest()) continue;
            userElementList.add(ue);
        }
        return userElementList;
    }

    @Override
    public List<UserElement> delegatedAdminSearchUsers(int cloudId, String userName, boolean isSite, List<String> policyNames) {
        ArrayList<UserElement> userElementList = new ArrayList<UserElement>();
        List users = null;
        ArrayList<String> list = new ArrayList<String>(Arrays.asList(userName.split(",")));
        HashSet<String> removeSet = new HashSet<String>();
        removeSet.addAll(list);
        list.clear();
        list.addAll(removeSet);
        logger.debug("users size={} sent in headers which were comma separated", (Object)list.size());
        users = this.userDao.searchUsersForPolicyAdmin(cloudId, list, policyNames, isSite);
        logger.debug("users size={} after filter based on based policy name of delegated admin", (Object)users.size());
        for (User user : users) {
            if (user == null || isSite && !user.isActive()) continue;
            logger.debug("user name={}, found which is under policy list ", (Object)user.getUserName());
            UserElement ue = new UserElement();
            BeanUtils.copyProperties((Object)user, (Object)ue);
            ue.setShareEnabled(user.isShareEnabled());
            if (ue.isGuest()) continue;
            userElementList.add(ue);
        }
        return userElementList;
    }

    @Override
    public List<UserElement> searchUserbyUsernameOrDisplaynameOrEmailId(int cloudId, String userName, boolean onlyActiveUsers, boolean site) {
        ArrayList<UserElement> userElementList = new ArrayList<UserElement>();
        ArrayList<String> list = new ArrayList<String>(Arrays.asList(userName.split(",")));
        HashSet<String> removeSet = new HashSet<String>();
        removeSet.addAll(list);
        list.clear();
        list.addAll(removeSet);
        List users = this.userDao.searchUserbyUsernameOrDisplaynameOrEmailId(cloudId, list, site);
        for (User user : users) {
            if (user == null) continue;
            UserElement ue = new UserElement();
            BeanUtils.copyProperties((Object)user, (Object)ue);
            ue.setShareEnabled(user.isShareEnabled());
            BackupPoliciesAdminList backupPolicyList = new BackupPoliciesAdminList();
            if (user.getBackupPoliciesAdmin() != null) {
                backupPolicyList.setBackupPoliciesAdmin(user.getBackupPoliciesAdmin());
                ue.setBackupPoliciesAdminList(backupPolicyList);
            }
            SyncPoliciesAdminList syncPolicyList = new SyncPoliciesAdminList();
            if (user.getSyncPoliciesAdmin() != null) {
                syncPolicyList.setSyncPoliciesAdmin(user.getSyncPoliciesAdmin());
                ue.setSyncPoliciesAdminList(syncPolicyList);
            }
            if (user.isGuest() || user.isSuperAdmin()) continue;
            if (onlyActiveUsers && user.isActive()) {
                userElementList.add(ue);
                continue;
            }
            if (onlyActiveUsers) continue;
            userElementList.add(ue);
        }
        return userElementList;
    }

    @Override
    public List<UserElement> getAllUsers(int cloudId, int skipValue, boolean site, List<String> policyNames, boolean searchSite) {
        ArrayList<UserElement> userElementList = new ArrayList<UserElement>();
        List usersList = null;
        usersList = this.userDao.getAllUsers(cloudId, "", skipValue, site, "false");
        if (policyNames != null) {
            if (site && searchSite) {
                logger.debug("Getting all sites belonging to the policy of delegated admin logged in");
                usersList = this.userDao.getAllSPSitesForDelegatedAdmin(cloudId, policyNames);
            } else {
                logger.debug("Getting all the users which belongs to the policy of delegated admin logged in");
                usersList = this.userDao.getAllUsers(cloudId, "", skipValue, policyNames);
            }
        }
        if (site && !searchSite) {
            usersList.addAll(this.getExistingSites(cloudId));
        }
        HashSet<String> userSites = new HashSet<String>();
        logger.debug(site + "...e user names list ... " + usersList.size());
        for (User user : usersList) {
            logger.debug(user.isActive() + "... user names ... " + user.getUserName());
            if (site && !user.isActive() || userSites.contains(user.getUserName())) continue;
            userSites.add(user.getUserName());
            UserElement ue = new UserElement();
            BeanUtils.copyProperties((Object)user, (Object)ue);
            ue.setShareEnabled(user.isShareEnabled());
            if (!StringUtils.isEmpty((CharSequence)user.getMigrationStatus()) && User.MIGRATION_STATUS.IN_PROGRESS.toString().equalsIgnoreCase(user.getMigrationStatus())) {
                ue.setUserUnderOdbMigration(true);
            }
            if (ue.isGuest()) continue;
            userElementList.add(ue);
        }
        return userElementList;
    }

    @Override
    public long getAllUsersCount(int cloudId, List<String> policyNames, List<String> syncPolicyNames, List<String> odbPolicyNames, List<String> gmailPolicyNames, List<String> gdrivePolicyNames) {
        return this.userDao.getAllUsersCount(cloudId, policyNames, syncPolicyNames, odbPolicyNames, gmailPolicyNames, gdrivePolicyNames);
    }

    @Override
    public long getAllUsersCount(int cloudId) {
        return this.userDao.getAllUsersCount(cloudId);
    }

    @Override
    public List<UserElement> getAllUsers(int cloudId, int skipValue, User logedInUser, boolean isSite, String pagination) {
        ArrayList<UserElement> userElementList = new ArrayList<UserElement>();
        List usersList = this.userDao.getAllUsers(cloudId, "", skipValue, isSite, pagination);
        logger.debug(" user names list ... " + usersList.size());
        for (User user : usersList) {
            UserElement ue = new UserElement();
            BeanUtils.copyProperties((Object)user, (Object)ue);
            ue.setShareEnabled(user.isShareEnabled());
            if (!ue.isGuest() && !user.isSuperAdmin()) {
                userElementList.add(ue);
            }
            ue.setPasswdHash(null);
            ue.setSecurityRecoveryKey(null);
            ue.setGoogleSecretKey(null);
            ue.setUserNameLowerCase(null);
            ue.setUserPrinicipalName(null);
            ue.setAzureUniqueId(null);
        }
        this.getValidUsers(logedInUser, userElementList, isSite);
        return userElementList;
    }

    @Override
    public List<UserElement> getAllUsersWithoutdevice(int cloudId, int skipValue, List<String> policyNames, boolean showBlockedDevicesBol, String productType) {
        ArrayList<UserElement> userElementList = new ArrayList<UserElement>();
        List loadAllDeviceUserIds = new ArrayList();
        loadAllDeviceUserIds = this.deviceDao.getAllDevices(cloudId);
        boolean backup = true;
        boolean onedrive = true;
        boolean exchange = true;
        boolean gmail = true;
        boolean gdrive = true;
        if (!StringUtils.isEmpty((CharSequence)productType)) {
            if ("BACKUP".equalsIgnoreCase(productType)) {
                onedrive = false;
                exchange = false;
                gmail = false;
                gdrive = false;
            }
            if ("ODB".equalsIgnoreCase(productType)) {
                backup = false;
                exchange = false;
                gmail = false;
                gdrive = false;
            }
            if ("Exchange".equalsIgnoreCase(productType)) {
                onedrive = false;
                backup = false;
                gmail = false;
                gdrive = false;
            }
            if (CPHelperConstant.PARABLU_PRODUCT_TYPE.GMAIL.getProductType().equalsIgnoreCase(productType)) {
                onedrive = false;
                backup = false;
                exchange = false;
                gdrive = false;
            }
            if (CPHelperConstant.PARABLU_PRODUCT_TYPE.GOOGLEDRIVE.getProductType().equalsIgnoreCase(productType)) {
                onedrive = false;
                backup = false;
                exchange = false;
                gmail = false;
            }
        }
        logger.debug(productType + "..show blocked Asset ..." + showBlockedDevicesBol);
        logger.debug(productType + "..show devices ..." + backup + ".." + onedrive + "..." + exchange + "......." + gmail);
        List<Object> userIds = new ArrayList();
        if (backup) {
            userIds = loadAllDeviceUserIds.stream().filter(dev -> !dev.isDeleted() && (!showBlockedDevicesBol || !dev.isBlocked()) && !dev.getDeviceName().contains("Microsoft Exchange") && !dev.getDeviceName().contains("Microsoft OneDrive") && !dev.getDeviceName().contains("Microsoft SharePoint") && !Device.TYPE.SERVER.getProduct().equalsIgnoreCase(dev.getDeviceType()) && !Device.TYPE.GMAIL.getProduct().equalsIgnoreCase(dev.getDeviceType()) && !Device.TYPE.GOOGLEDRIVE.getProduct().equalsIgnoreCase(dev.getDeviceType())).map(dev -> dev.getUserId()).collect(Collectors.toList());
        } else if (exchange) {
            userIds = loadAllDeviceUserIds.stream().filter(dev -> !dev.isDeleted() && (!showBlockedDevicesBol || !dev.isBlocked()) && dev.getDeviceName().contains("Microsoft Exchange")).map(dev -> dev.getUserId()).collect(Collectors.toList());
        } else if (onedrive) {
            userIds = loadAllDeviceUserIds.stream().filter(dev -> !dev.isDeleted() && (!showBlockedDevicesBol || !dev.isBlocked()) && dev.getDeviceName().contains("Microsoft OneDrive")).map(dev -> dev.getUserId()).collect(Collectors.toList());
        } else if (gmail) {
            userIds = loadAllDeviceUserIds.stream().filter(dev -> !dev.isDeleted() && (!showBlockedDevicesBol || !dev.isBlocked()) && dev.getDeviceType().equalsIgnoreCase(Device.TYPE.GMAIL.getProduct())).map(dev -> dev.getUserId()).collect(Collectors.toList());
        } else if (gdrive) {
            userIds = loadAllDeviceUserIds.stream().filter(dev -> !dev.isDeleted() && (!showBlockedDevicesBol || !dev.isBlocked()) && dev.getDeviceType().equalsIgnoreCase(Device.TYPE.GOOGLEDRIVE.getProduct())).map(dev -> dev.getUserId()).collect(Collectors.toList());
        }
        logger.debug("....userIds....." + userIds.size());
        List usersNotConnectedToDevice = new ArrayList();
        usersNotConnectedToDevice = backup ? this.userDao.getUsersNotConnectedToDevice(cloudId, userIds, true) : this.userDao.getOfficeUsersNotConnectedToDevice(cloudId, userIds, productType);
        for (User user : usersNotConnectedToDevice) {
            logger.debug(user.getPolicyName() + " user names ... " + user.getUserName());
            UserElement ue = new UserElement();
            BeanUtils.copyProperties((Object)user, (Object)ue);
            if (backup && !user.isBackupEnabled() || onedrive && !user.isOnedriveBkpEnabled() || exchange && !user.isExchangeBkpEnabled() || gmail && !user.isGmailBkpEnabled() || gdrive && !user.isGdriveBkpEnabled()) continue;
            if (!CollectionUtils.isEmpty(policyNames)) {
                if ("ODB".equals(productType) && !StringUtils.isEmpty((CharSequence)user.getOneDrivePolicyName()) && policyNames.contains(user.getOneDrivePolicyName())) {
                    if (user.isGuest() || user.isSuperAdmin()) continue;
                    userElementList.add(ue);
                    continue;
                }
                if ("BACKUP".equalsIgnoreCase(productType) && !StringUtils.isEmpty((CharSequence)user.getPolicyName()) && policyNames.contains(user.getPolicyName())) {
                    if (user.isGuest() || user.isSuperAdmin()) continue;
                    userElementList.add(ue);
                    continue;
                }
                if ("Exchange".equals(productType) && !StringUtils.isEmpty((CharSequence)user.getExchangePolicyName()) && policyNames.contains(user.getExchangePolicyName())) {
                    if (user.isGuest() || user.isSuperAdmin()) continue;
                    userElementList.add(ue);
                    continue;
                }
                if (CPHelperConstant.PARABLU_PRODUCT_TYPE.GMAIL.getProductType().equals(productType) && !StringUtils.isEmpty((CharSequence)user.getGmailPolicyName()) && policyNames.contains(user.getGmailPolicyName())) {
                    if (user.isGuest() || user.isSuperAdmin()) continue;
                    userElementList.add(ue);
                    continue;
                }
                if (!CPHelperConstant.PARABLU_PRODUCT_TYPE.GOOGLEDRIVE.getProductType().equals(productType) || StringUtils.isEmpty((CharSequence)user.getGdrivePolicyName()) || !policyNames.contains(user.getGdrivePolicyName()) || user.isGuest() || user.isSuperAdmin()) continue;
                userElementList.add(ue);
                continue;
            }
            if (user.isGuest() || user.isSuperAdmin()) continue;
            userElementList.add(ue);
        }
        return userElementList;
    }

    @Override
    public void markUserAsDelete(int cloudId, String cloudName, String userName, String deletedBy, Cloud cloud, String host) {
        User user = this.userDao.getUserInfoByName(cloudId, cloudName, userName);
        if (user == null) {
            throw new BaseException(USER_NOT_FOUND);
        }
        this.revokeAlldevicesassigned(userName, deletedBy, cloudName, cloud, cloudId);
        this.userMiniCloudMappingDao.deleteUserCloudAccessControlMappingWithUserFK(cloudId, cloudName, user.getUserId());
        List serverDevices = this.deviceDao.getAllDevicesByUser(cloudId, user);
        List googleWorkspaceDevices = this.deviceDao.getDeviceByUserNameAndOsType(cloudId, user.getUserName());
        this.deviceDao.markAllDevicesAsDeletedForUser(cloudId, cloudName, user);
        this.authorizationDao.deleteAllTokensForUser(cloudId, cloudName, user);
        user.setDeleted(true);
        this.userDao.updateUser(cloudId, cloudName, user);
        this.deviceDao.markUserAndDeviceAsDeleteInDeviceBkpOverview(cloudId, user);
        if (googleWorkspaceDevices != null && !googleWorkspaceDevices.isEmpty()) {
            logger.debug("call unified for user delete-->{} , host-->{}", (Object)user.getUserName(), (Object)cloudName);
            DeleteDto deleteDto = new DeleteDto();
            deleteDto.setHost(host);
            deleteDto.setType(DeleteDto.TYPE.USER);
            deleteDto.setUserName(user.getUserName());
            this.dataAgingService.deleteDetailsFromUserAndDevice(cloudId, deleteDto);
        }
        this.saveDeletedUser(cloudId, cloudName, userName, user);
        if (User.TYPE.SERVER.toString().equals(user.getUserType())) {
            if (serverDevices != null && serverDevices.size() > 0 && serverDevices.get(0) != null) {
                this.sendServerDeviceBlockDeleteEmail(cloud, "device-deleted", deletedBy, user, ((Device)serverDevices.get(0)).getDeviceName());
            } else {
                this.multipleUserBlockOrDeleteMail(cloud, cloudName, cloudId, deletedBy, user.getUserName(), user.getEmailId(), "user-delete");
            }
        } else {
            this.multipleUserBlockOrDeleteMail(cloud, cloudName, cloudId, deletedBy, user.getUserName(), user.getEmailId(), "user-delete");
        }
    }

    @Override
    public void revokeAlldevicesassigned(String userName, String blockedBy, String cloudName, Cloud cloud, int cloudId) {
        List<UserDeviceAccessControl> userDevicesAssignedTo = this.getUserDevicesAssignedTo(cloudId, cloudName, userName);
        this.revokeAssignedDevicesBack(cloudId, cloudName, userDevicesAssignedTo, blockedBy);
        logger.debug(" userDevicesAssignedTo" + userDevicesAssignedTo.size());
        UserElement userTodelete = this.getUserByUserName(cloud, userName);
        List<UserDeviceAccessControl> assignedDevicesToCurrentUser = this.getUserDeviceAccessControlByUserID(cloudId, userTodelete.getUserId());
        logger.debug("assignedDevicesToCurrentUser" + assignedDevicesToCurrentUser.size());
        this.revokeAssignedDevicesBack(cloudId, cloudName, assignedDevicesToCurrentUser, blockedBy);
    }

    public void saveDeletedUser(int cloudId, String cloudName, String userName, User user) {
        logger.debug("saving deleted user on database");
        DeletedUser deletedUser = new DeletedUser();
        BeanUtils.copyProperties((Object)user, (Object)deletedUser);
        ArrayList<String> deviceUUIDs = new ArrayList<String>();
        List allDevicesForUser = this.deviceDao.getAllDevicesByUser(cloudId, user);
        if (allDevicesForUser != null) {
            for (Device device : allDevicesForUser) {
                if (device == null || device.getDeviceUUID() == null) continue;
                deviceUUIDs.add(device.getDeviceUUID());
            }
        }
        deletedUser.setUserName(userName);
        deletedUser.setLastModifiedTimestamp(String.valueOf(System.currentTimeMillis()));
        deletedUser.setDeviceUUIDs(deviceUUIDs);
        deletedUser.setUserId(user.getUserId());
        this.deletedUserDao.saveDeletedUser(cloudId, cloudName, deletedUser);
        DeletedSearchIndex deletedSearchIndex = new DeletedSearchIndex();
        deletedSearchIndex.setId(new ObjectId());
        deletedSearchIndex.setCloudId(cloudId);
        deletedSearchIndex.setCloudName(cloudName);
        deletedSearchIndex.setUserDelete(true);
        deletedSearchIndex.setUserName(user.getUserName());
        this.searchIndexDao.addDeleteIndex(deletedSearchIndex);
        logger.debug("saved deleted user on database");
    }

    @Override
    public List<DeletedUser> getAllDeletedUsers(int cloudId, String cloudName) {
        return this.deletedUserDao.getAllDeletedUsers(cloudId, cloudName);
    }

    @Override
    public List<User> getAllDeletedUsers(int cloudId) {
        return this.userDao.getAllDeletedUsers(cloudId);
    }

    @Override
    public List<UserElement> getAllDeletedUsersById(int cloudId, String cloudName, List<ObjectId> userIds) {
        ArrayList<UserElement> userElementList = new ArrayList<UserElement>();
        List usersList = this.userDao.getAllDeletedUsersById(cloudId, cloudName, userIds);
        for (User user : usersList) {
            UserElement ue = new UserElement();
            BeanUtils.copyProperties((Object)user, (Object)ue);
            ue.setShareEnabled(user.isShareEnabled());
            userElementList.add(ue);
        }
        return userElementList;
    }

    public void setDeletedUserDao(DeletedUserDao deletedUserDao) {
        this.deletedUserDao = deletedUserDao;
    }

    @Override
    public boolean isUserUnderLegalHold(int cloudId, String userId) {
        User user = this.userDao.getUserInfo(cloudId, userId);
        BackupPolicy backupPolicy = this.userDao.getBackupPolicyByPolicyName(cloudId, user.getPolicyName());
        return backupPolicy != null && backupPolicy.isLegalHoldEnabled();
    }

    @Override
    public boolean isUserUnderLegalHoldForUserNameAndDevice(int cloudId, String userName, String deviceType) {
        OfficeBackupPolicy officeBackupPolicy;
        GmailBackupPolicy gdriveBackupPolicy;
        GmailBackupPolicy gmailBackupPolicy;
        boolean gmailOnLegalHold = false;
        boolean gdriveOnLegalHold = false;
        User user = this.userDao.getUserByName(cloudId, userName);
        if (deviceType.equalsIgnoreCase("Gmail") && StringUtils.isNotBlank((CharSequence)user.getGmailPolicyName()) && ((gmailBackupPolicy = this.userDao.getGoogleWorkspaceBackupPolicyByPolicyName(cloudId, user.getGmailPolicyName())) == null || gmailBackupPolicy.isLegalHoldEnabled())) {
            return true;
        }
        if (deviceType.equalsIgnoreCase("Google Drive") && StringUtils.isNotBlank((CharSequence)user.getGdrivePolicyName()) && ((gdriveBackupPolicy = this.userDao.getGoogleWorkspaceBackupPolicyByPolicyName(cloudId, user.getGdrivePolicyName())) == null || gdriveBackupPolicy.isLegalHoldEnabled())) {
            return true;
        }
        return deviceType.equalsIgnoreCase("OUTLOOK") && StringUtils.isNotBlank((CharSequence)user.getExchangePolicyName()) && ((officeBackupPolicy = this.userDao.getOfficeBackupPolicyByPolicyName(cloudId, user.getExchangePolicyName())) == null || officeBackupPolicy.isLegalHoldEnabled());
    }

    @Override
    public boolean isUserUnderLegalHoldForUserName(int cloudId, String userName) {
        GmailBackupPolicy gdriveBackupPolicy;
        GmailBackupPolicy gmailBackupPolicy;
        boolean userUnderLegalHold = false;
        User user = this.userDao.getUserByName(cloudId, userName);
        BackupPolicy backupPolicy = this.userDao.getBackupPolicyByPolicyName(cloudId, user.getPolicyName());
        if (backupPolicy != null && backupPolicy.isLegalHoldEnabled()) {
            logger.debug("User cannot be admin He/She is under legal hold .......");
            userUnderLegalHold = true;
            return userUnderLegalHold;
        }
        OfficeBackupPolicy officeBackupPolicy = this.userDao.getOfficeBackupPolicyByPolicyName(cloudId, user.getOneDrivePolicyName());
        if (officeBackupPolicy != null && officeBackupPolicy.isLegalHoldEnabled()) {
            logger.debug("User cannot be admin He/She is under legal hold .......");
            userUnderLegalHold = true;
            return userUnderLegalHold;
        }
        officeBackupPolicy = this.userDao.getOfficeBackupPolicyByPolicyName(cloudId, user.getExchangePolicyName());
        if (officeBackupPolicy != null && officeBackupPolicy.isLegalHoldEnabled()) {
            logger.debug("User cannot be admin He/She is under legal hold .......");
            userUnderLegalHold = true;
            return userUnderLegalHold;
        }
        boolean gmailOnLegalHold = false;
        boolean gdriveOnLegalHold = false;
        if (StringUtils.isNotEmpty((CharSequence)user.getGmailPolicyName()) && (gmailBackupPolicy = this.userDao.getGoogleWorkspaceBackupPolicyByPolicyName(cloudId, user.getGmailPolicyName())) != null && gmailBackupPolicy.isLegalHoldEnabled()) {
            gmailOnLegalHold = true;
        }
        if (StringUtils.isNotEmpty((CharSequence)user.getGdrivePolicyName()) && (gdriveBackupPolicy = this.userDao.getGoogleWorkspaceBackupPolicyByPolicyName(cloudId, user.getGdrivePolicyName())) != null && gdriveBackupPolicy.isLegalHoldEnabled()) {
            gdriveOnLegalHold = true;
        }
        if (gmailOnLegalHold || gdriveOnLegalHold) {
            return true;
        }
        if (user.isSite() && (officeBackupPolicy = this.userDao.getOfficeBackupPolicyByPolicyName(cloudId, user.getSpPolicyName())) != null && officeBackupPolicy.isLegalHoldEnabled()) {
            logger.debug("User cannot be admin He/She is under legal hold .......");
            userUnderLegalHold = true;
            return userUnderLegalHold;
        }
        return userUnderLegalHold;
    }

    @Override
    public List<UserElement> getAllLegalHoldUsers(int cloudId, String cloudName) {
        List legalHoldPolicies = this.backupPolicyDao.getAllLegalHoldBackupPolicies(cloudId, cloudName);
        ArrayList<UserElement> legalHoldUserElements = new ArrayList<UserElement>();
        for (BackupPolicy backupPolicy : legalHoldPolicies) {
            List userList = this.userDao.getUsersByBackupPolicyName(cloudId, backupPolicy.getPolicyName());
            for (User user : userList) {
                UserElement element = new UserElement();
                if (user == null) continue;
                BeanUtils.copyProperties((Object)user, (Object)element);
                legalHoldUserElements.add(element);
            }
        }
        return legalHoldUserElements;
    }

    @Override
    public boolean isUserOwnerOfAnyMiniCloud(int cloudId, String userName) {
        List list = this.miniCloudDao.getAllMiniCloudForUser(cloudId, userName);
        return !CollectionUtils.isEmpty((Collection)list);
    }

    @Override
    public boolean checkIfEmailAlreadyExists(int cloudId, String emailId) {
        return this.userDao.checkIfEmailAlreadyExists(cloudId, emailId);
    }

    @Override
    public boolean checkIfEmailAlreadyExistsAsUserName(int cloudId, String emailId) {
        return this.userDao.checkIfEmailAlreadyExistsAsUserName(cloudId, emailId);
    }

    @Override
    public List<User> getAllUsersForNames(int cloudId, List<String> usersNames) {
        return this.userDao.getAllUsersForNames(cloudId, usersNames);
    }

    @Override
    public Group getGroupByName(int cloudId, String groupName) {
        return this.userGroupDao.getGroupByName(cloudId, groupName);
    }

    @Override
    public List<UserGroup> getAllUsersForGroup(int cloudId, String groupName, String groupId) {
        return this.userGroupDao.getAllUsersForGroup(cloudId, null, groupId);
    }

    @Override
    public void saveGroup(int cloudId, List<String> list, String groupName) {
        Group group = this.getGroupByName(cloudId, groupName);
        if (group == null) {
            group = new Group();
            group.setGroupName(groupName);
            this.userGroupDao.saveGroup(cloudId, group, list);
        }
    }

    @Override
    public List<Group> getAllGroups(int cloudId) {
        return this.userGroupDao.getAllGroups(cloudId);
    }

    @Override
    public UserGroupElement getGroupElement(int cloudId, String groupName) {
        UserGroupElement groupElement = new UserGroupElement();
        Group group = this.userGroupDao.getGroupByName(cloudId, groupName);
        StringBuilder userNames = new StringBuilder("");
        if (group != null) {
            groupElement.setGroupName(group.getGroupName());
            List<UserGroup> allUserGroups = this.getAllUsersForGroup(cloudId, null, group.getId().toString());
            for (UserGroup userGroup : allUserGroups) {
                userNames.append(userGroup.getUser().getUserName() + ",");
            }
            if (userNames.length() > 0) {
                userNames.append(userNames.substring(0, userNames.length() - 1));
                groupElement.setAssignedUsers(userNames.toString());
            }
        }
        return groupElement;
    }

    @Override
    public void deleteGroup(int cloudId, Group group) {
        this.userGroupDao.deleteGroup(cloudId, group);
    }

    @Override
    public List<Group> getAllGroups(int cloudId, int skipValue) {
        return this.userGroupDao.getAllGroups(cloudId, skipValue);
    }

    @Override
    public List<Group> searchGroups(int cloudId, String groupName) {
        return this.userGroupDao.searchGroups(cloudId, groupName);
    }

    @Override
    public Group getUserGroup(int cloudId, User user) {
        logger.debug("Group getUserGroup(int cloudId, User user) > BEGIN");
        Group group = this.userGroupDao.getUserGroup(cloudId, user);
        logger.debug("Group getUserGroup(int cloudId, User user) > BEFORE RETURN");
        return group;
    }

    @Override
    public User getAdminUserWithServerBackupEnabled(int cloudId) {
        logger.debug("User getAdminUserWithServerBackupEnableerd(int cloudId) > BEGIN");
        User user = this.userDao.getAdminUserWithServerBackupEnabled(cloudId);
        logger.debug("User getAdminUserWithServerBackupEnableerd(int cloudId) > BEFORE");
        return user;
    }

    @Override
    public User getUserDetailsForEmail(int cloudId, String email) {
        return this.userDao.getUserDetailsForEmail(cloudId, email);
    }

    @Override
    public SyncOverviewElement getSyncOverview(int cloudId) {
        SyncOverView syncOverview = this.fileRevisionDao.getSyncOverview(cloudId);
        SyncOverviewElement syncOverviewElement = new SyncOverviewElement();
        long noOfUsers = this.userDao.countOfPresentSyncUsers(cloudId, "", true);
        syncOverviewElement.setTotalUsers(Long.toString(noOfUsers));
        if (syncOverview != null) {
            syncOverviewElement.setTotalFilesShared(Long.toString(syncOverview.getTotalFilesShared()));
            syncOverviewElement.setTotalFilesDownloaded(Long.toString(syncOverview.getTotalFilesDownloaded()));
            syncOverviewElement.setTotalSizeUploaded(UserManagementServiceImpl.formatFileSize(syncOverview.getTotalSizeUploaded()));
            syncOverviewElement.setTotalSizeDownloaded(UserManagementServiceImpl.formatFileSize(syncOverview.getTotalSizeDownloaded()));
        }
        return syncOverviewElement;
    }

    @Override
    public void saveSyncOverview(int cloudId, long totalSizeUploaded, long totalSizeDownloaded, long filesShared, long filesDownloaded) {
        SyncOverView syncOverview = this.fileRevisionDao.getSyncOverview(cloudId);
        if (syncOverview == null) {
            syncOverview = new SyncOverView();
            syncOverview.setTotalFilesShared(filesShared);
            syncOverview.setTotalSizeUploaded(totalSizeUploaded);
            syncOverview.setTotalFilesDownloaded(totalSizeDownloaded);
            syncOverview.setTotalSizeUploaded(totalSizeUploaded);
        } else {
            syncOverview.setTotalFilesShared(syncOverview.getTotalFilesShared() + filesShared);
            syncOverview.setTotalSizeUploaded(syncOverview.getTotalSizeUploaded() + totalSizeUploaded);
            syncOverview.setTotalFilesDownloaded(syncOverview.getTotalFilesDownloaded() + totalSizeDownloaded);
            syncOverview.setTotalSizeUploaded(syncOverview.getTotalSizeUploaded() + totalSizeUploaded);
        }
        this.fileRevisionDao.saveSyncOverview(cloudId, syncOverview);
        long currentTimeMillis = UserManagementServiceImpl.getStartofDay(System.currentTimeMillis());
        DailySyncOverView dailySyncOverview = this.fileRevisionDao.getDailySyncOverview(cloudId, currentTimeMillis);
        if (dailySyncOverview == null) {
            dailySyncOverview = new DailySyncOverView();
            dailySyncOverview.setTotalFilesShared(filesShared);
            dailySyncOverview.setTotalFilesDownloaded(totalSizeDownloaded);
            dailySyncOverview.setTotalSizeUploaded(totalSizeUploaded);
            dailySyncOverview.setTotalSizeDownloaded(totalSizeDownloaded);
            dailySyncOverview.setOverViewDate(UserManagementServiceImpl.getStartofDay(currentTimeMillis));
        } else {
            dailySyncOverview.setTotalFilesShared(dailySyncOverview.getTotalFilesShared() + filesShared);
            dailySyncOverview.setTotalFilesDownloaded(dailySyncOverview.getTotalFilesDownloaded() + filesDownloaded);
            dailySyncOverview.setTotalSizeUploaded(dailySyncOverview.getTotalSizeUploaded() + totalSizeUploaded);
            dailySyncOverview.setTotalSizeDownloaded(dailySyncOverview.getTotalSizeDownloaded() + totalSizeDownloaded);
            dailySyncOverview.setOverViewDate(UserManagementServiceImpl.getStartofDay(currentTimeMillis));
        }
        this.fileRevisionDao.saveDailySyncOverview(cloudId, dailySyncOverview);
    }

    private static long getStartofDay(long millis) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(millis);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTimeInMillis();
    }

    public static String formatFileSize(long size) {
        double m = (double)size / 1024.0;
        double g = (double)size / 1024.0 / 1024.0;
        double t = (double)size / 1024.0 / 1024.0 / 1024.0;
        DecimalFormat dec = new DecimalFormat("0.00");
        String hrSize = t > 1.0 ? dec.format(t).concat(" TB") : (g > 1.0 ? dec.format(g).concat(" GB") : dec.format(m).concat(" MB"));
        return hrSize;
    }

    @Override
    public void deleteOldSyncOverView(int cloudId) {
        this.fileRevisionDao.deleteOldSyncOverView(cloudId);
    }

    @Override
    public void updateUserLoggedInTime(int cloudId, String userName) {
        this.userDao.updateUserLoggedInTime(cloudId, userName);
    }

    @Override
    public void syncExistingUsersAttributes(Cloud cloud) {
        block31: {
            int cloudId = cloud.getCloudId();
            List allAdcredentials = this.personDao.getAllAdCredentials(cloudId);
            boolean result = this.checkADCredentialsHaveGroupName(allAdcredentials);
            if (!CollectionUtils.isEmpty((Collection)allAdcredentials) && result) {
                logger.debug("allAdcredentials is empty Ad creadentails have no group name don't sync");
                return;
            }
            List ldapUsers = this.userDao.getAllLdapUser(cloud.getCloudId());
            String cloudName = cloud.getCloudName();
            boolean isSoftBlockEnabled = false;
            CloudProperties cloudProperties = this.cloudDao.getCloudProperties(cloudId);
            if (cloudProperties != null && cloudProperties.isSoftBlockEnabled()) {
                isSoftBlockEnabled = true;
            }
            try {
                boolean isBackupEnabled = false;
                boolean isSyncEnabled = false;
                for (CloudCustomisableDetails customisableDetails : cloud.getCloudCustomisableDetails()) {
                    if (customisableDetails.getName().equalsIgnoreCase(SYNC_ENABLED)) {
                        isSyncEnabled = true;
                    }
                    if (!customisableDetails.getName().equalsIgnoreCase(BACKUP_ENABLED)) continue;
                    isBackupEnabled = true;
                }
                for (User userObj : ldapUsers) {
                    String userName = userObj.getUserName();
                    Person userInAD = null;
                    userInAD = StringUtils.isNotEmpty((CharSequence)userObj.getAadLoginId()) ? this.ldapService.getPersonByUserNameForSync(cloudId, userObj.getAadLoginId()) : this.ldapService.getPersonByUserNameForSync(cloudId, userName);
                    User existingUser = this.userDao.getUserByUserNameOrAADLoginId(cloudId, userName);
                    if (userInAD != null) {
                        if (isBackupEnabled && "sync".equalsIgnoreCase(userInAD.getAdGroupType())) {
                            isBackupEnabled = false;
                        }
                        if (isSyncEnabled && "backup".equalsIgnoreCase(userInAD.getAdGroupType())) {
                            isSyncEnabled = false;
                        }
                        logger.debug(userInAD.getAdGroupType() + "...group and licens..." + isBackupEnabled + ".." + isSyncEnabled);
                        boolean isUserLimitReached = this.isUserLimitReached(cloud, cloudId, cloudName);
                        logger.debug("....license check ..... " + isBackupEnabled + "..." + isSyncEnabled + "...." + isUserLimitReached);
                        if ((long)cloud.getNoOfBackupUsersAllowed() <= this.countOfPresentBackupUsers(cloudId, cloudName, true)) {
                            isBackupEnabled = false;
                        }
                        if ((long)cloud.getNoOfSyncUsersAllowed() <= this.countOfPresentSyncUsers(cloudId, cloudName, true)) {
                            isSyncEnabled = false;
                        }
                        if (!(isBackupEnabled || isSyncEnabled || existingUser.isSoftBlockEnabled())) {
                            logger.error("...user limit reached.....");
                            continue;
                        }
                        if (isUserLimitReached && existingUser.isActive() && !existingUser.isBackupEnabled()) {
                            logger.debug("...user limit reached and user is active but license disabled so do not update for user contiue... " + userName);
                            continue;
                        }
                        if (isUserLimitReached && !existingUser.isActive()) {
                            logger.debug("...user limit reached and so do not update for user contiue... " + userName);
                            continue;
                        }
                        boolean accountStatus = userInAD.isAccountStatus();
                        logger.debug(userName + "...UserName : " + userInAD.getFullName() + " acount status " + accountStatus);
                        String department = userInAD.getDepartment();
                        String displayName = userInAD.getDisplayName();
                        String location = userInAD.getLocation();
                        this.updateAdInfoForUser(cloudId, userName, accountStatus, department, displayName, location);
                        if (!accountStatus) {
                            logger.debug("...UserName : " + userInAD.getFullName() + " acount status " + accountStatus + " setting false");
                            if (existingUser.isActive()) {
                                logger.debug("In AD user is not active but user is active so change the status");
                                if (isSoftBlockEnabled) {
                                    if (!existingUser.isSoftBlockEnabled()) {
                                        this.updateUserInfo(cloudId, userName, true, true);
                                    }
                                } else {
                                    this.updateUserInfo(cloudId, userName, false, false);
                                }
                                if (!isSoftBlockEnabled) {
                                    this.saveAuditHistory(cloud, cloudId, userName);
                                }
                            }
                        } else if (!existingUser.isActive()) {
                            logger.debug("In AD user is active but user is not active in db so change the status");
                            this.updateUserInfo(cloudId, userName, false, true);
                            this.saveStatisticToDatabase(cloud, "unblocked", "AUTO", userName, "AD Sync", System.currentTimeMillis(), PCActionTypes.AD_USER_MIGRATION.getActionTypeValue());
                        }
                        this.updateUserInfoLicense(cloudId, userName, isBackupEnabled, isSyncEnabled);
                        if (!isBackupEnabled && !isSyncEnabled && existingUser.isActive()) {
                            if (isSoftBlockEnabled) {
                                if (!existingUser.isSoftBlockEnabled()) {
                                    this.updateUserInfo(cloudId, userName, true, true);
                                }
                            } else {
                                this.updateUserInfo(cloudId, userName, false, false);
                            }
                            if (!isSoftBlockEnabled) {
                                this.saveAuditHistory(cloud, cloudId, userName);
                            }
                        }
                        if (!existingUser.isActive() || isBackupEnabled || isSyncEnabled || !existingUser.isSoftBlockEnabled()) continue;
                        existingUser = this.userDao.getUserByUserNameOrEmail(cloudId, userName);
                        this.updateUserInfo(cloudId, userName, false, true);
                        logger.debug("update ... softblock...");
                        continue;
                    }
                    logger.debug("...User not found in ad and no exception also so block the user..");
                    if (!existingUser.isActive()) continue;
                    boolean softBlockEnabled = false;
                    boolean active = true;
                    if (isSoftBlockEnabled) {
                        if (!existingUser.isSoftBlockEnabled()) {
                            softBlockEnabled = true;
                            this.updateUserInfo(cloud.getCloudId(), userName, softBlockEnabled, active);
                        }
                    } else {
                        active = false;
                        isBackupEnabled = false;
                        isSyncEnabled = false;
                        this.updateUserInfo(cloud.getCloudId(), userName, softBlockEnabled, active);
                    }
                    if (isSoftBlockEnabled) continue;
                    this.saveAuditHistory(cloud, cloudId, userName);
                }
            }
            catch (BaseException e) {
                logger.trace(BASE_EXCEPTION + String.valueOf((Object)e));
                logger.error(BASE_EXCEPTION + e.getMessage());
                if (e == null || e.getErrorStatus() != 400) break block31;
                logger.debug("Ad connection so stop sync failed reason :" + e.getMessage());
                throw e;
            }
        }
    }

    private void updateUserInfo(int cloudId, boolean isBackup, boolean isSync, String userName, boolean softBlockEnabled, boolean active) {
        this.userDao.updateUserInfo(cloudId, isBackup, isSync, userName, softBlockEnabled, active);
    }

    private void updateUserInfoLicense(int cloudId, String userName, boolean isBackupEnabled, boolean isSyncEnabled) {
        this.userDao.updateUserInfoLicense(cloudId, userName, isBackupEnabled, isSyncEnabled);
    }

    private void updateUserInfo(int cloudId, String userName, boolean softBlockEnabled, boolean active) {
        this.userDao.updateUserInfo(cloudId, userName, softBlockEnabled, active);
    }

    private void updateAdInfoForUser(int cloudId, String userName, boolean accountStatus, String department, String displayName, String location) {
        this.userDao.updateAdInfoForUser(cloudId, userName, accountStatus, department, displayName, location);
    }

    private boolean isUserLimitReached(Cloud cloud, int cloudId, String cloudName) {
        boolean backupLimitReached = false;
        boolean syncLimitReached = false;
        boolean isUserLimitReached = false;
        long countOfPresentBackupUsers = this.countOfPresentBackupUsers(cloudId, cloudName, true);
        if ((long)cloud.getNoOfBackupUsersAllowed() <= countOfPresentBackupUsers) {
            backupLimitReached = true;
        }
        long countOfPresentSyncUsers = this.countOfPresentSyncUsers(cloudId, cloudName, true);
        if ((long)cloud.getNoOfSyncUsersAllowed() <= countOfPresentSyncUsers) {
            syncLimitReached = true;
        }
        if (backupLimitReached && syncLimitReached) {
            isUserLimitReached = true;
        }
        logger.debug(".....license numbers....." + countOfPresentBackupUsers + "...." + countOfPresentSyncUsers + "...." + isUserLimitReached);
        return isUserLimitReached;
    }

    private boolean checkADCredentialsHaveGroupName(List<AdCredentials> adCredentials) {
        boolean results = false;
        for (AdCredentials adCredentail : adCredentials) {
            if (!StringUtils.isEmpty((CharSequence)adCredentail.getAdGroupName())) continue;
            logger.debug("In adcredntials " + adCredentail.getAdUrl() + " group name is empty so checkADCredentialsHaveGroupName return true");
            results = true;
            break;
        }
        return results;
    }

    private void saveAuditHistory(Cloud cloud, int cloudId, String userName) {
        this.saveStatisticToDatabase(cloud, "Blocked", "AUTO", userName, "AD Sync", System.currentTimeMillis(), PCActionTypes.AD_USER_MIGRATION.getActionTypeValue());
        List<Device> blockedDevices = this.blockUnblockDevicebyUserName(cloudId, cloud.getCloudName(), userName, true);
        if (blockedDevices != null) {
            for (Device device : blockedDevices) {
                logger.debug("....blocking devices....");
                this.auditHistoryService.saveStatisticToDatabase(cloudId, cloud.getCloudName(), "blocked Asset:" + device.getDeviceName() + " of User:", "AUTO", userName, "AD Sync", System.currentTimeMillis(), PCActionTypes.DEVICE_BLOCK.getActionTypeValue());
            }
        }
    }

    private void blockDeviceByUserAndAudit(Cloud cloud, Device device, User user, DateTime dt1, long noOfDays) {
        logger.debug("...blockDeviceByUserAndAudit.........");
        this.deviceDao.blockUnblockDevice(cloud.getCloudId(), cloud.getCloudName(), device, true);
        this.deviceDao.updateDeviceStatusInOverview(cloud.getCloudId(), device.getDeviceUUID(), true);
        this.authorizationDao.deleteAuthTokenByUserAndUniqueID(cloud.getCloudId(), user, device.getDeviceUUID());
        this.auditHistoryService.saveStatisticToDatabase(cloud.getCloudId(), cloud.getCloudName(), "blocked Asset:" + device.getDeviceName() + " owned by User:", "AUTO", user.getUserName(), "which was Last heard from on: " + String.valueOf(dt1), System.currentTimeMillis(), PCActionTypes.DEVICE_BLOCK.getActionTypeValue());
        this.sendEmail(cloud, "auto-device-blocked", "automatic asset-aging", user.getUserName(), device.getDeviceName(), user, noOfDays, cloud.getCloudName());
    }

    private void changeUserStatusByADStatus(Cloud cloud, int cloudId, User user, Person userInAD) {
        if (!userInAD.isAccountStatus()) {
            if (user.isActive()) {
                user.setActive(false);
                logger.debug("In AD user is not active but user is active in DB so change the status" + user.isActive());
                this.updateStatusInDevice(cloud, cloudId, user);
            }
        } else if (!user.isActive()) {
            logger.debug("In AD user is active but user is in active so change the status");
            user.setActive(true);
            this.saveStatisticToDatabase(cloud, "unblocked", "AUTO", user.getUserName(), "AD Sync", System.currentTimeMillis(), PCActionTypes.AD_USER_MIGRATION.getActionTypeValue());
        }
    }

    private void updateStatusInDevice(Cloud cloud, int cloudId, User user) {
        this.saveStatisticToDatabase(cloud, "Blocked", "AUTO", user.getUserName(), "AD Sync", System.currentTimeMillis(), PCActionTypes.AD_USER_MIGRATION.getActionTypeValue());
        List<Device> blockedDevices = this.blockUnblockDevicebyUserName(cloudId, cloud.getCloudName(), user.getUserName(), true);
        if (blockedDevices != null) {
            for (Device device : blockedDevices) {
                logger.debug("....blocking devices....");
                this.auditHistoryService.saveStatisticToDatabase(cloudId, cloud.getCloudName(), "blocked Asset:" + device.getDeviceName() + " of User:", "AUTO", user.getUserName(), "AD Sync", System.currentTimeMillis(), PCActionTypes.DEVICE_BLOCK.getActionTypeValue());
            }
        }
    }

    private void saveStatisticToDatabase(Cloud cloud, String action, String actionByUser, String actionOnUser, String actionUsingObject, long timeStamp, int actionType) {
        AuditHistory audit = new AuditHistory();
        audit.setAction(action);
        audit.setActionByUserName(actionByUser);
        audit.setActionOnObject(actionOnUser);
        audit.setTimestamp(timeStamp);
        audit.setActionUsingObject(actionUsingObject);
        audit.setActionType(actionType);
        this.auditHistoryDao.saveAudit(cloud.getCloudId(), cloud.getCloudName(), audit);
    }

    private void saveStatisticToDatabase(int cloudId, String cloudName, String action, String actionByUser, String actionOnUser) {
        AuditHistory audit = new AuditHistory();
        audit.setAction(action);
        audit.setActionByUserName(actionByUser);
        audit.setActionOnObject(actionOnUser);
        audit.setTimestamp(System.currentTimeMillis());
        audit.setActionUsingObject("Portal");
        this.auditHistoryDao.saveAudit(cloudId, cloudName, audit);
    }

    @Override
    public List<SearchUserElement> searchUsersWithDevices(int cloudId, String userName, User currentUser, boolean isSite) {
        ArrayList<SearchUserElement> userElementList = new ArrayList<SearchUserElement>();
        ArrayList<String> list = new ArrayList<String>(Arrays.asList(userName.split(",")));
        HashSet<String> removeSet = new HashSet<String>();
        removeSet.addAll(list);
        list.clear();
        list.addAll(removeSet);
        List users = null;
        users = this.userDao.searchUsers(cloudId, list, isSite);
        this.getValidUsersByUserList(currentUser, users);
        for (User user : users) {
            if (user == null) continue;
            List devicesList = this.deviceDao.getAllDeviceByUserName(cloudId, user.getUserName());
            ArrayList<String> deviceNameList = new ArrayList<String>();
            if (devicesList != null) {
                for (Device device : devicesList) {
                    deviceNameList.add(device.getDeviceName());
                }
            }
            SearchUserElement ue = new SearchUserElement();
            BeanUtils.copyProperties((Object)user, (Object)ue);
            ue.setShareEnabled(user.isShareEnabled());
            ue.setDeviceNameList(deviceNameList);
            if (user.isGuest() || user.isSuperAdmin()) continue;
            userElementList.add(ue);
        }
        return userElementList;
    }

    @Override
    public List<UserElement> getUserListByNames(Cloud cloud, List<String> userNames, User currentUser, HttpServletResponse response, CloudLicenseTo cl, String oppType) throws Exception {
        ArrayList<UserElement> userElementList = new ArrayList<UserElement>();
        int cloudId = cloud.getCloudId();
        ArrayList<UserElement> userListWithBlockFail = new ArrayList<UserElement>();
        for (String userName : userNames) {
            if (StringUtils.isEmpty((CharSequence)userName)) continue;
            User user2 = this.userDao.getUserByName(cloudId, userName);
            UserElement ue = new UserElement();
            if (userName.equalsIgnoreCase(currentUser.getUserName())) {
                ue.setUserName(userName);
                ue.setStatus("CurrentUser");
                userListWithBlockFail.add(ue);
            } else if (user2 != null) {
                if (!(!currentUser.isReadOnlyAdmin() || currentUser.getBackupPoliciesAdmin() != null && currentUser.getBackupPoliciesAdmin().contains(user2.getPolicyName()) || currentUser.getSyncPoliciesAdmin() != null && currentUser.getSyncPoliciesAdmin().contains(user2.getSyncPolicyName()) || currentUser.getOdbPoliciesAdmin() != null && (currentUser.getOdbPoliciesAdmin().contains(user2.getExchangePolicyName()) || currentUser.getOdbPoliciesAdmin().contains(user2.getOneDrivePolicyName()) || currentUser.getOdbPoliciesAdmin().contains(user2.getSpPolicyName())))) {
                    logger.debug("The user={} is not found in the Delegated admin", (Object)user2.getUserName());
                    ue.setUserName(userName);
                    ue.setStatus("User does not exist or invalid");
                } else {
                    ue.setUserName(user2.getUserName());
                    ue.setEmailId(user2.getEmailId());
                    ue.setActive(user2.isActive());
                    ue.setDeleted(user2.isDeleted());
                    ue.setLocalUser(user2.isLocalUser());
                    ue.setLastModifiedTimestamp(user2.getLastModifiedTimestamp());
                    if (ue.isActive()) {
                        ue.setStatus(CPHelperConstant.USER_STATUS.ACTIVE.toString());
                    } else if (!ue.isActive() && !ue.isDeleted()) {
                        ue.setStatus(CPHelperConstant.USER_STATUS.BLOCKED.toString());
                    } else {
                        ue.setStatus(CPHelperConstant.USER_STATUS.DELETED.toString());
                    }
                }
            } else {
                ue.setUserName(userName);
                ue.setStatus("User does not exist or invalid");
            }
            userElementList.add(ue);
        }
        userElementList.removeAll(Collections.singleton(null));
        Collections.sort(userElementList, new Comparator<UserElement>(this){

            @Override
            public int compare(UserElement u1, UserElement u2) {
                if (u1 == null || u2 == null || u1.getUserName() == null || u2.getUserName() == null) {
                    return -1;
                }
                return new CompareToBuilder().append((Object)u1.getStatus(), (Object)u2.getStatus()).append((Object)u1.getUserName().toLowerCase(), (Object)u2.getUserName().toLowerCase()).toComparison();
            }
        });
        if (StringUtils.isNotEmpty((CharSequence)oppType) && oppType.equals("block")) {
            userListWithBlockFail.addAll(userElementList.stream().filter(user -> Objects.nonNull(user.getUserName()) && Objects.nonNull(user.getStatus()) && !user.getStatus().equals(CPHelperConstant.USER_STATUS.ACTIVE.toString())).collect(Collectors.toList()));
        } else {
            userListWithBlockFail.addAll(userElementList.stream().filter(user -> Objects.nonNull(user.getUserName()) && Objects.nonNull(user.getStatus()) && !user.getStatus().equals(CPHelperConstant.USER_STATUS.BLOCKED.toString())).collect(Collectors.toList()));
        }
        if (!CollectionUtils.isEmpty(userListWithBlockFail)) {
            logger.debug("...userListWithBlockFail is exists..." + userListWithBlockFail.size());
            this.createUsersExcelBlockFail(cloudId, userListWithBlockFail);
        }
        return userElementList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isLoggedInUserAllowedToChangeUserPassword(int cloudId, String cloudName, UserElement userElement, User currentUser) {
        if (this.registry.get(cloudId).isPasswordChangeEnforce()) {
            if (currentUser.isAdmin() || currentUser.isSuperAdmin()) {
                if (userElement == null) return false;
                if (userElement.isAdmin()) return false;
                if (userElement.isSuperAdmin()) return false;
                if (!this.registry.get(cloudId).isCanAdminChangeUserPassword()) return false;
                return true;
            }
            if (!currentUser.isReadOnlyAdmin()) return false;
            CloudProperties cloudProperties = this.cloudDao.getCloudProperties(cloudId);
            if (!cloudProperties.isCanDelegatedAdminChangeUserPassword()) return false;
            if (userElement == null) return false;
            String policyName = userElement.getPolicyName();
            String syncPolicyName = userElement.getSyncPolicyName();
            String exchangePolicyName = userElement.getExchangePolicyName();
            String oneDrivePolicyName = userElement.getOneDrivePolicyName();
            String spPolicyName = userElement.getSpPolicyName();
            List currentAdminODBPolicies = currentUser.getOdbPoliciesAdmin();
            if (!currentUser.isReadOnlyAdmin()) return false;
            if (currentUser.getBackupPoliciesAdmin() != null) {
                if (currentUser.getBackupPoliciesAdmin().contains(policyName)) return true;
            }
            if (currentUser.getSyncPoliciesAdmin() != null) {
                if (currentUser.getSyncPoliciesAdmin().contains(syncPolicyName)) return true;
            }
            if (currentAdminODBPolicies == null) return false;
            if (currentAdminODBPolicies.contains(exchangePolicyName)) return true;
            if (currentAdminODBPolicies.contains(oneDrivePolicyName)) return true;
            if (!currentAdminODBPolicies.contains(spPolicyName)) return false;
            return true;
        }
        if (userElement == null) return false;
        if (userElement.isAdmin()) return false;
        if (userElement.isSuperAdmin()) {
            return false;
        }
        if (!currentUser.isAdmin()) {
            if (!currentUser.isSuperAdmin()) return false;
        }
        if (userElement.isBpCanAdminChangeUserPassword()) return true;
        if (userElement.isExCanAdminChangeUserPassword()) return true;
        if (userElement.isGdriveCanAdminChangeUserPassword()) return true;
        if (userElement.isGmailCanAdminChangeUserPassword()) return true;
        if (userElement.isOdCanAdminChangeUserPassword()) return true;
        if (!userElement.isSyncCanAdminChangeUserPassword()) return false;
        return true;
    }

    @Override
    public boolean createUserWithoutExcel(CloudLicenseTo cl, int cloudId, int skipValue, List<String> policyNames, boolean incloudBlockedDevices, String productType) {
        List<Object> userList = new ArrayList();
        userList = this.getAllUsersWithoutdevice(cloudId, skipValue, policyNames, incloudBlockedDevices, productType);
        if (CollectionUtils.isEmpty(userList)) {
            logger.debug("Invalid users.....");
            return false;
        }
        this.createUsersExcelForXlsx(cl, cloudId, userList, new User(), false);
        return true;
    }

    @Override
    public User getOneADUser(int cloudId, String cloudName) {
        return this.userDao.getOneADUser(cloudId, cloudName);
    }

    @Override
    public void saveMigrationStatus(int cloudId, MigrationStatus migrationStatus) {
        this.migrationStatusDao.saveMigrationStatus(cloudId, migrationStatus);
    }

    public MigrationStatusDao getMigrationStatusDao() {
        return this.migrationStatusDao;
    }

    public void setMigrationStatusDao(MigrationStatusDao migrationStatusDao) {
        this.migrationStatusDao = migrationStatusDao;
    }

    @Override
    public List<String> getUserNamesByBackupPoliciesAdmin(int cloudId, List<String> backupPoliciesAdmin) {
        return this.userDao.getUserNamesByBackupPoliciesAdmin(cloudId, backupPoliciesAdmin);
    }

    @Override
    public List<String> getUserNamesByOfficePoliciesAdmin(int cloudId, List<String> officePoliciesAdmin) {
        return this.userDao.getUserNamesByOfficePoliciesAdmin(cloudId, officePoliciesAdmin);
    }

    @Override
    public boolean createExcelForUsers(CloudLicenseTo cl, int cloudId, String userName, User user, boolean onlyActiveUsers, boolean site) {
        ArrayList<UserElement> userList = new ArrayList();
        if (StringUtils.isEmpty((CharSequence)userName)) {
            userList = this.getAllUsers(cloudId, cl.getCloud().getCloudName(), onlyActiveUsers, site);
            userList = userList.stream().filter(mixedUser -> StringUtils.isEmpty((CharSequence)mixedUser.getUserType())).collect(Collectors.toList());
        } else {
            userList = this.searchUserbyUsernameOrDisplaynameOrEmailId(cloudId, userName, onlyActiveUsers, site);
            userList = userList.stream().filter(mixedUser -> StringUtils.isEmpty((CharSequence)mixedUser.getUserType())).collect(Collectors.toList());
            logger.debug(userName);
        }
        if (CollectionUtils.isEmpty(userList)) {
            logger.debug("Invalid users.....");
            return false;
        }
        this.getValidUsers(user, userList, site);
        this.createUsersExcelForXlsx(cl, cloudId, userList, user, site);
        return true;
    }

    private void getValidUsers(User user, List<UserElement> userList, boolean isSite) {
        if (user != null && user.isReadOnlyAdmin()) {
            ArrayList<UserElement> inValidUsers = new ArrayList<UserElement>();
            List odbPolicyNames = user.getOdbPoliciesAdmin();
            ArrayList<String> spPolicyNames = new ArrayList<String>();
            if (!CollectionUtils.isEmpty((Collection)odbPolicyNames)) {
                for (String odbPolicyName : odbPolicyNames) {
                    if (!odbPolicyName.startsWith("SP_")) continue;
                    spPolicyNames.add(odbPolicyName);
                }
            }
            for (UserElement userElement : userList) {
                boolean isValidUser = false;
                if (!isSite && !CollectionUtils.isEmpty((Collection)user.getBackupPoliciesAdmin()) && !StringUtils.isEmpty((CharSequence)userElement.getPolicyName()) && user.getBackupPoliciesAdmin().contains(userElement.getPolicyName())) {
                    isValidUser = true;
                    logger.debug("...userName..." + userElement.getUserName() + "...backuppolicy have access to readonly admin..");
                }
                if (!isSite && !CollectionUtils.isEmpty((Collection)user.getSyncPoliciesAdmin()) && !StringUtils.isEmpty((CharSequence)userElement.getSyncPolicyName()) && user.getSyncPoliciesAdmin().contains(userElement.getSyncPolicyName())) {
                    isValidUser = true;
                    logger.debug("...userName..." + userElement.getUserName() + "...SyncPolicy have access to readonly admin..");
                }
                if (isSite && !CollectionUtils.isEmpty(spPolicyNames) && spPolicyNames.contains(userElement.getSpPolicyName())) {
                    isValidUser = true;
                    logger.debug("...userName..." + userElement.getUserName() + "...site have access to readonly admin..");
                }
                if (!(isSite || CollectionUtils.isEmpty((Collection)user.getOdbPoliciesAdmin()) || StringUtils.isEmpty((CharSequence)userElement.getOneDrivePolicyName()) && StringUtils.isEmpty((CharSequence)userElement.getExchangePolicyName()) || !user.getOdbPoliciesAdmin().contains(userElement.getOneDrivePolicyName()) && !user.getOdbPoliciesAdmin().contains(userElement.getExchangePolicyName()))) {
                    isValidUser = true;
                    logger.debug("...userName..." + userElement.getUserName() + "...OdbPolicy have access to readonly admin..");
                }
                if (isValidUser) continue;
                inValidUsers.add(userElement);
            }
            logger.debug(".......Users list count..." + userList.size() + "...inValidUsers.." + inValidUsers.size());
            userList.removeAll(inValidUsers);
            logger.debug(".......Users list count after..." + userList.size());
        }
    }

    private void getValidUsersByUserList(User user, List<User> userList) {
        if (user != null && user.isReadOnlyAdmin()) {
            ArrayList<User> inValidUsers = new ArrayList<User>();
            for (User userElement : userList) {
                boolean isValidUser = false;
                if (!CollectionUtils.isEmpty((Collection)user.getBackupPoliciesAdmin()) && !StringUtils.isEmpty((CharSequence)userElement.getPolicyName()) && user.getBackupPoliciesAdmin().contains(userElement.getPolicyName())) {
                    isValidUser = true;
                    logger.debug("...userName..." + userElement.getUserName() + "...backuppolicy have access to readonly admin..");
                }
                if (!CollectionUtils.isEmpty((Collection)user.getSyncPoliciesAdmin()) && !StringUtils.isEmpty((CharSequence)userElement.getSyncPolicyName()) && user.getSyncPoliciesAdmin().contains(userElement.getSyncPolicyName())) {
                    isValidUser = true;
                    logger.debug("...userName..." + userElement.getUserName() + "...SyncPolicy have access to readonly admin..");
                }
                if (!CollectionUtils.isEmpty((Collection)user.getOdbPoliciesAdmin()) && !StringUtils.isEmpty((CharSequence)userElement.getOneDrivePolicyName()) && user.getOdbPoliciesAdmin().contains(userElement.getOneDrivePolicyName())) {
                    isValidUser = true;
                    logger.debug("...userName..." + userElement.getUserName() + "...OdbPolicy have access to readonly admin..");
                }
                if (isValidUser) continue;
                inValidUsers.add(userElement);
            }
            logger.debug(".......Users list count..." + userList.size() + "...inValidUsers.." + inValidUsers.size());
            userList.removeAll(inValidUsers);
            logger.debug(".......Users list count after..." + userList.size());
        }
    }

    private boolean isODBEnabled(List<CloudCustomisableDetails> licenseDetails) {
        boolean isODBEnabled = false;
        for (CloudCustomisableDetails license : licenseDetails) {
            if (license == null || !"ODB Enabled".equalsIgnoreCase(license.getName())) continue;
            isODBEnabled = true;
            break;
        }
        return isODBEnabled;
    }

    private boolean isBackupEnabled(List<CloudCustomisableDetails> licenseDetails) {
        boolean isBackupEnabled = false;
        for (CloudCustomisableDetails license : licenseDetails) {
            if (license == null || !BACKUP_ENABLED.equalsIgnoreCase(license.getName())) continue;
            isBackupEnabled = true;
            break;
        }
        return isBackupEnabled;
    }

    private boolean isO365Enabled(List<CloudCustomisableDetails> licenseDetails) {
        boolean isO365Enabled = false;
        for (CloudCustomisableDetails license : licenseDetails) {
            if (license == null || !"OneDrive Backup Enabled".equalsIgnoreCase(license.getName())) continue;
            isO365Enabled = true;
            break;
        }
        return isO365Enabled;
    }

    private boolean isSyncEnabled(List<CloudCustomisableDetails> licenseDetails) {
        boolean isSyncEnabled = false;
        for (CloudCustomisableDetails license : licenseDetails) {
            if (license == null || !SYNC_ENABLED.equalsIgnoreCase(license.getName())) continue;
            isSyncEnabled = true;
            break;
        }
        return isSyncEnabled;
    }

    private boolean createSoftBlockedUsersExcelForXlsx(int cloudId, List<UserElement> userList) {
        File f = new File(this.registry.get(cloudId).getPropertyFileValueParacloudMountPoint() + "/reports/SoftBlockedUsers.xlsx");
        if (f.exists()) {
            f.delete();
        }
        if (!userList.isEmpty()) {
            boolean bl;
            XSSFWorkbook workbook = new XSSFWorkbook();
            try {
                boolean success;
                List<List> recordToAdd = this.updateSoftBlockedUsers(userList);
                this.createExcelForUserXlsx(recordToAdd, workbook);
                bl = success = this.writeExcelForSoftBlockedUserXlsx(cloudId, workbook);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        workbook.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    logger.trace(EXCEPTION + String.valueOf(e));
                    logger.error(EXCEPTION + e.getMessage());
                    return false;
                }
            }
            workbook.close();
            return bl;
        }
        return false;
    }

    private void createUsersExcelForXlsx(CloudLicenseTo cl, int cloudId, List<UserElement> userList, User user, boolean site) {
        if (!userList.isEmpty()) {
            try (XSSFWorkbook workbook = new XSSFWorkbook();){
                List<List> recordToAdd = this.updateUserElementValuesToExcel(cl, userList, user, site);
                this.createExcelForUserXlsx(recordToAdd, workbook);
                this.writeExcelForUserXlsx(cl.getCloud().getCloudId(), workbook);
            }
            catch (Exception e) {
                logger.trace(EXCEPTION + String.valueOf(e));
                logger.error(EXCEPTION + e.getMessage());
            }
        }
    }

    private boolean isSharePointBackupEnabled(List<CloudCustomisableDetails> list) {
        boolean isSharePointBackupEnabled = false;
        list.removeAll(Collections.singleton(null));
        if (!CollectionUtils.isEmpty(list)) {
            for (CloudCustomisableDetails cloudPluginDetails : list) {
                if (cloudPluginDetails == null || StringUtils.isEmpty((CharSequence)cloudPluginDetails.getName()) || !"Sharepoint Backup Enabled".equalsIgnoreCase(cloudPluginDetails.getName())) continue;
                isSharePointBackupEnabled = true;
                break;
            }
        }
        return isSharePointBackupEnabled;
    }

    private boolean isLicenseEnabled(Cloud cl, String licenseName) {
        boolean isLicenseScanEnabled = false;
        List list = cl.getCloudCustomisableDetails();
        list.removeAll(Collections.singleton(null));
        if (!CollectionUtils.isEmpty((Collection)list)) {
            for (CloudCustomisableDetails cloudPluginDetails : list) {
                if (cloudPluginDetails == null || StringUtils.isEmpty((CharSequence)cloudPluginDetails.getName()) || !licenseName.equalsIgnoreCase(cloudPluginDetails.getName())) continue;
                isLicenseScanEnabled = true;
                break;
            }
        }
        return isLicenseScanEnabled;
    }

    private List<List> updateUserElementValuesToExcel(CloudLicenseTo cl, List<UserElement> userList, User user, boolean site) {
        boolean isMSPEnv = false;
        List list = cl.getCloud().getCloudCustomisableDetails();
        boolean isODBEnabled = this.isODBEnabled(list);
        boolean isBackupEnabled = this.isBackupEnabled(list);
        boolean isSyncEnabled = this.isSyncEnabled(list);
        boolean isOdbBkpEnabled = this.isOneDriveForBusinessBackupEnabled(list);
        boolean isExchangeBackupEnabled = this.isExchangeBackupEnabled(list);
        boolean isSharePointBackupEnabled = this.isSharePointBackupEnabled(list);
        boolean isGmailBackupEnabled = this.isLicenseEnabled(cl.getCloud(), gmail_Backup_Enabled);
        boolean isGdriveBackupEnabled = this.isLicenseEnabled(cl.getCloud(), gdrive_Backup_Enabled);
        for (CloudCustomisableDetails customisableDetail : list) {
            if (!MSP_LICENSE.equalsIgnoreCase(customisableDetail.getName())) continue;
            isMSPEnv = true;
        }
        logger.debug("is MSP enabled={}", (Object)isMSPEnv);
        List<BackupPolicy> backupPolicies = this.getAllBackupPolicies(cl.getCloud().getCloudId());
        List policyWithConsentEnabled = backupPolicies.stream().filter(policy -> policy.isUserConsentEnabled()).map(policyNameM -> policyNameM.getPolicyName()).collect(Collectors.toList());
        CloudProperties cloudProperties = this.cloudDao.getCloudProperties(cl.getCloud().getCloudId());
        Boolean isShowUserConsentFieldInPolicies = cloudProperties.isShowUserConsentFieldInPolicies();
        ArrayList<List> recordToAdd = new ArrayList<List>();
        if (!isMSPEnv || user.isAdmin()) {
            headerRow = this.createHeaderRowForUserXlsx(isODBEnabled, isBackupEnabled, isSyncEnabled, isOdbBkpEnabled, isExchangeBackupEnabled, isSharePointBackupEnabled, isShowUserConsentFieldInPolicies, site, isGmailBackupEnabled, isGdriveBackupEnabled);
            recordToAdd.add(headerRow);
        } else if (isMSPEnv && user.isReadOnlyAdmin()) {
            headerRow = this.createHeaderRowForUserXlsxMSPEnv(isBackupEnabled);
            recordToAdd.add(headerRow);
        }
        for (UserElement userElement : userList) {
            List<String> firstRow;
            String consentGiven = "";
            String consentGivenTime = "";
            if (userElement.getPolicyName() != null && policyWithConsentEnabled.contains(userElement.getPolicyName())) {
                if (StringUtils.isNotEmpty((CharSequence)userElement.getConsentGiven()) && userElement.getConsentGiven().equals("yes")) {
                    consentGiven = "Y";
                    if (userElement.getConsentGivenTime() != 0L) {
                        consentGivenTime = UserManagementServiceImpl.getDateInFormat(userElement.getConsentGivenTime());
                    }
                } else {
                    consentGiven = "NA";
                }
            }
            if (!isMSPEnv || user.isAdmin()) {
                firstRow = this.loadDataOnRowForUserXlsx(userElement, isODBEnabled, isBackupEnabled, isSyncEnabled, isOdbBkpEnabled, isExchangeBackupEnabled, isSharePointBackupEnabled, consentGiven, isShowUserConsentFieldInPolicies, consentGivenTime, site, isGmailBackupEnabled, isGdriveBackupEnabled);
                recordToAdd.add(firstRow);
                continue;
            }
            if (!isMSPEnv || !user.isReadOnlyAdmin()) continue;
            firstRow = this.loadDataOnRowForUserXlsxMSPEnv(userElement, isBackupEnabled);
            recordToAdd.add(firstRow);
        }
        return recordToAdd;
    }

    private List<List> updateSoftBlockedUsers(List<UserElement> userList) {
        ArrayList<List> recordToAdd = new ArrayList<List>();
        ArrayList<String> headerRow = new ArrayList<String>();
        headerRow.add("User ID");
        headerRow.add("Email ID");
        headerRow.add("Soft Blocked Date");
        headerRow.add("Soft Blocked Time");
        recordToAdd.add(headerRow);
        for (UserElement userElement : userList) {
            ArrayList<String> firstRow = new ArrayList<String>();
            firstRow.add(userElement.getUserName());
            firstRow.add(userElement.getEmailId());
            if (userElement.isSoftBlockEnabled() && userElement.getSoftBlockedTime() > 0L) {
                firstRow.add(UserManagementServiceImpl.getDateInFormat(userElement.getSoftBlockedTime(), DD_MMM_YYYY));
                firstRow.add(UserManagementServiceImpl.getDateInFormat(userElement.getSoftBlockedTime(), HH_MM_SS));
            } else {
                firstRow.add("-");
                firstRow.add("-");
            }
            recordToAdd.add(firstRow);
        }
        return recordToAdd;
    }

    private static String getDateInFormat(Long deviceCreatedDate, String format) {
        String dateStringFormat = "";
        if (deviceCreatedDate == null || deviceCreatedDate == 0L) {
            return dateStringFormat;
        }
        try {
            SimpleDateFormat df2 = new SimpleDateFormat(format);
            Date dateD = new Date(deviceCreatedDate);
            dateStringFormat = df2.format(dateD);
        }
        catch (Exception e) {
            logger.error("INVALID_DATE_VALUE" + deviceCreatedDate);
            logger.trace("INVALID_DATE_VALUE" + String.valueOf(e));
            logger.error("INVALID_DATE_VALUE " + e.getMessage());
        }
        return dateStringFormat;
    }

    private boolean isExchangeBackupEnabled(List<CloudCustomisableDetails> list) {
        boolean isExpiredFileDeleteEnabled = false;
        list.removeAll(Collections.singleton(null));
        if (!CollectionUtils.isEmpty(list)) {
            for (CloudCustomisableDetails cloudPluginDetails : list) {
                if (cloudPluginDetails == null || StringUtils.isEmpty((CharSequence)cloudPluginDetails.getName()) || !"Exchange Backup Enabled".equalsIgnoreCase(cloudPluginDetails.getName())) continue;
                isExpiredFileDeleteEnabled = true;
                break;
            }
        }
        return isExpiredFileDeleteEnabled;
    }

    private boolean isOneDriveForBusinessBackupEnabled(List<CloudCustomisableDetails> list) {
        boolean isExpiredFileDeleteEnabled = false;
        list.removeAll(Collections.singleton(null));
        if (!CollectionUtils.isEmpty(list)) {
            for (CloudCustomisableDetails cloudPluginDetails : list) {
                if (cloudPluginDetails == null || StringUtils.isEmpty((CharSequence)cloudPluginDetails.getName()) || !"OneDrive Backup Enabled".equalsIgnoreCase(cloudPluginDetails.getName())) continue;
                isExpiredFileDeleteEnabled = true;
                break;
            }
        }
        return isExpiredFileDeleteEnabled;
    }

    List<String> createHeaderRowForUserXlsx(boolean isODBEnabled, boolean isBackupEnabled, boolean isSyncEnabled, boolean isOdbBkpEnabled, boolean isExchangeBkpEnabled, boolean isSpBkpEnabled, boolean isShowUserConsentFieldInPolicies, boolean site, boolean isGmailBackupEnabled, boolean isGdriveBackupEnabled) {
        ArrayList<String> headerRow = new ArrayList<String>();
        if (site) {
            headerRow.add("Site ID");
            headerRow.add("Site Status");
            headerRow.add("Created Timestamp");
        } else {
            headerRow.add("User ID");
            headerRow.add("Display Name");
            headerRow.add("Email ID");
            headerRow.add("Department");
            headerRow.add("Location");
            headerRow.add("User Type");
            headerRow.add("User Status");
            headerRow.add("Is Local User");
            headerRow.add("Created Timestamp");
            headerRow.add("Last Modified Time");
            headerRow.add("Last Logged In Time");
            headerRow.add("Soft Blocked");
            headerRow.add("Soft Blocked Date");
            headerRow.add("Soft Blocked Time");
        }
        if (isShowUserConsentFieldInPolicies) {
            headerRow.add("Consent Given");
            headerRow.add("Consent Given Time");
        }
        if (isODBEnabled | isExchangeBkpEnabled & !site) {
            headerRow.add("Odb Login Id");
            headerRow.add("Backup Target Assigned");
            headerRow.add("Reason");
        }
        if (isBackupEnabled & !site) {
            headerRow.add("Is Backup Enabled");
            headerRow.add("Backup Policy Name");
            headerRow.add("Backup Policies Admin");
        }
        if (isSyncEnabled & !site) {
            headerRow.add("Is Sync Enabled");
            headerRow.add("Sync Policy Name");
            headerRow.add("Sync Policies Admin");
        }
        if (isOdbBkpEnabled & !site) {
            headerRow.add("Is OneDrive Backup Enabled");
            headerRow.add("OneDrive Policy Name");
        }
        if (isExchangeBkpEnabled & !site) {
            headerRow.add("Is Exchange Backup Enabled");
            headerRow.add("Exchange Policy Name");
        }
        if (isGmailBackupEnabled) {
            headerRow.add("Is Gmail Backup Enabled");
            headerRow.add("Gmail Policy Name");
        }
        if (isGdriveBackupEnabled) {
            headerRow.add("Is Gdrive Backup Enabled");
            headerRow.add("Gdrive Policy Name");
        }
        if (site) {
            headerRow.add("Is SharePoint Backup Enabled");
            headerRow.add("SharePoint Policy Name");
        }
        return headerRow;
    }

    List<String> createHeaderRowForUserXlsxMSPEnv(boolean isBackupEnabled) {
        ArrayList<String> headerRow = new ArrayList<String>();
        headerRow.add("User ID");
        if (isBackupEnabled) {
            headerRow.add("Policy");
        }
        headerRow.add("User Status");
        headerRow.add("Created Timestamp");
        headerRow.add("Last Modified Time");
        headerRow.add("Last Logged In Time");
        return headerRow;
    }

    List<String> loadDataOnRowForUserXlsx(UserElement userElement, boolean isODBEnabled, boolean isBackupEnabled, boolean isSyncEnabled, boolean isOdbBkpEnabled, boolean isExchangeBackupEnabled, boolean isSharePointBackupEnabled, String consentGiven, boolean isShowUserConsentFieldInPolicies, String consentGivenTime, boolean site, boolean isGmailBackupEnabled, boolean isGdriveEnabled) {
        ArrayList<String> firstRow;
        block72: {
            firstRow = new ArrayList<String>();
            firstRow.add(userElement.getUserName());
            if (site) {
                if (!userElement.isDeleted()) {
                    if (userElement.isActive()) {
                        firstRow.add("Active");
                    } else {
                        firstRow.add("Blocked");
                    }
                } else {
                    firstRow.add("Deleted");
                }
                try {
                    createdTimeDate = userElement.getCreatedTimestamp();
                    if (!StringUtils.isEmpty((CharSequence)createdTimeDate)) {
                        long dateLong = Long.parseLong(createdTimeDate);
                        firstRow.add(this.getDate(dateLong));
                        break block72;
                    }
                    firstRow.add("-");
                }
                catch (Exception e) {
                    logger.error(EXCEPTION + e.getMessage());
                    logger.error(EXCEPTION + String.valueOf(e));
                }
            } else {
                if (!StringUtils.isEmpty((CharSequence)userElement.getDisplayName())) {
                    firstRow.add(userElement.getDisplayName());
                } else {
                    firstRow.add("-");
                }
                if (!StringUtils.isEmpty((CharSequence)userElement.getEmailId())) {
                    firstRow.add(userElement.getEmailId());
                } else {
                    firstRow.add("-");
                }
                if (!StringUtils.isEmpty((CharSequence)userElement.getDepartment())) {
                    firstRow.add(userElement.getDepartment());
                } else {
                    firstRow.add("-");
                }
                try {
                    if (!StringUtils.isEmpty((CharSequence)userElement.getLocation())) {
                        firstRow.add(userElement.getLocation());
                    } else {
                        firstRow.add("-");
                    }
                }
                catch (Exception e) {
                    logger.error(EXCEPTION + e.getMessage());
                    logger.error(EXCEPTION + String.valueOf(e));
                }
                if (userElement.isAdmin()) {
                    firstRow.add(ADMIN);
                } else if (userElement.isReadOnlyAdmin()) {
                    firstRow.add(READ_ONLY_ADMIN);
                } else if (userElement.isGuest()) {
                    firstRow.add("Guest User");
                } else {
                    firstRow.add(USER);
                }
                if (!userElement.isDeleted()) {
                    if (userElement.isActive()) {
                        firstRow.add("Active");
                    } else {
                        firstRow.add("Blocked");
                    }
                } else {
                    firstRow.add("Deleted");
                }
                if (userElement.isLocalUser()) {
                    firstRow.add("Y");
                } else {
                    firstRow.add("N");
                }
                try {
                    createdTimeDate = userElement.getCreatedTimestamp();
                    if (!StringUtils.isEmpty((CharSequence)createdTimeDate)) {
                        long dateLong = Long.parseLong(createdTimeDate);
                        firstRow.add(this.getDate(dateLong));
                    } else {
                        firstRow.add("-");
                    }
                    String lastModifiedTime = userElement.getLastModifiedTimestamp();
                    if (!StringUtils.isEmpty((CharSequence)lastModifiedTime)) {
                        long dateLong = Long.parseLong(lastModifiedTime);
                        firstRow.add(this.getDate(dateLong));
                    } else {
                        firstRow.add("");
                    }
                    String lastLoggedInDateInString = userElement.getLastLoggedInTime();
                    if (!StringUtils.isEmpty((CharSequence)lastLoggedInDateInString)) {
                        long dateLong = Long.parseLong(lastLoggedInDateInString);
                        firstRow.add(this.getDate(dateLong));
                    } else {
                        firstRow.add("-");
                    }
                    boolean sofitBlockEnabled = userElement.isSoftBlockEnabled();
                    if (userElement.isSoftBlockEnabled() && userElement.getSoftBlockedTime() > 0L) {
                        firstRow.add("Yes");
                    } else {
                        firstRow.add("No");
                    }
                    if (userElement.isSoftBlockEnabled() && userElement.getSoftBlockedTime() > 0L) {
                        firstRow.add(UserManagementServiceImpl.getDateInFormat(userElement.getSoftBlockedTime(), DD_MMM_YYYY));
                        firstRow.add(UserManagementServiceImpl.getDateInFormat(userElement.getSoftBlockedTime(), HH_MM_SS));
                    } else {
                        firstRow.add("-");
                        firstRow.add("-");
                    }
                }
                catch (Exception e) {
                    logger.trace(EXCEPTION + String.valueOf(e));
                    logger.error(EXCEPTION + e.getMessage());
                }
            }
        }
        if (isShowUserConsentFieldInPolicies) {
            firstRow.add(consentGiven);
            firstRow.add(consentGivenTime);
        }
        if (isODBEnabled | isExchangeBackupEnabled & !site) {
            firstRow.add(userElement.getOdbLoginId());
            if (userElement.isBackupTargetAssigned()) {
                firstRow.add("Yes");
                firstRow.add("");
            } else {
                firstRow.add("No");
                firstRow.add(this.getCommentsForErrorCode(userElement.getBackupTargetErrorCode()));
            }
        }
        if (isBackupEnabled & !site) {
            if (userElement.isBackupEnabled()) {
                firstRow.add("Y");
            } else {
                firstRow.add("N");
            }
            firstRow.add(userElement.getPolicyName());
            BackupPoliciesAdminList backupPolicyAdminList = userElement.getBackupPoliciesAdminList();
            if (backupPolicyAdminList != null) {
                List backupPoliciesAdmin = backupPolicyAdminList.getBackupPoliciesAdmin();
                String backupPolicies = backupPoliciesAdmin.stream().collect(Collectors.joining(","));
                firstRow.add(backupPolicies);
            } else {
                firstRow.add("-");
            }
        }
        logger.debug("...sync enabled....." + isSyncEnabled + "..." + userElement.isSyncEnabled() + "...");
        if (isSyncEnabled & !site) {
            if (userElement.isSyncEnabled()) {
                firstRow.add("Y");
            } else {
                firstRow.add("N");
            }
            firstRow.add(userElement.getSyncPolicyName());
            SyncPoliciesAdminList syncPolicyAdminList = userElement.getSyncPoliciesAdminList();
            if (syncPolicyAdminList != null) {
                List syncPoliciesAdmin = syncPolicyAdminList.getSyncPoliciesAdmin();
                String syncPolicies = syncPoliciesAdmin.stream().collect(Collectors.joining(","));
                firstRow.add(syncPolicies);
            } else {
                firstRow.add("-");
            }
        }
        if (isOdbBkpEnabled & !site) {
            if (userElement.isOnedriveBkpEnabled()) {
                firstRow.add("Y");
            } else {
                firstRow.add("N");
            }
            firstRow.add(userElement.getOneDrivePolicyName());
        }
        if (isExchangeBackupEnabled & !site) {
            if (userElement.isExchangeBkpEnabled()) {
                firstRow.add("Y");
            } else {
                firstRow.add("N");
            }
            firstRow.add(userElement.getExchangePolicyName());
        }
        if (isGmailBackupEnabled) {
            if (userElement.isGmailBkpEnabled()) {
                firstRow.add("Y");
            } else {
                firstRow.add("N");
            }
            firstRow.add(userElement.getGmailPolicyName());
        }
        if (isGdriveEnabled) {
            if (userElement.isGdriveBkpEnabled()) {
                firstRow.add("Y");
            } else {
                firstRow.add("N");
            }
            firstRow.add(userElement.getGdrivePolicyName());
        }
        if (site) {
            if (userElement.isSite()) {
                firstRow.add("Y");
            } else {
                firstRow.add("N");
            }
            firstRow.add(userElement.getSpPolicyName());
        }
        return firstRow;
    }

    List<String> loadDataOnRowForUserXlsxMSPEnv(UserElement userElement, boolean isBackupEnabled) {
        long dateLong;
        ArrayList<String> firstRow = new ArrayList<String>();
        if (!StringUtils.isEmpty((CharSequence)userElement.getEmailId())) {
            firstRow.add(userElement.getEmailId());
        } else {
            firstRow.add("");
        }
        if (isBackupEnabled) {
            if (userElement.isSuspended()) {
                firstRow.add("No Backup");
            } else {
                firstRow.add("Backup");
            }
        }
        if (!userElement.isDeleted()) {
            if (userElement.isActive()) {
                firstRow.add("Active");
            } else {
                firstRow.add("Deactivated");
            }
        } else {
            firstRow.add("Deleted");
        }
        try {
            String createdTimeDate = userElement.getCreatedTimestamp();
            if (!StringUtils.isEmpty((CharSequence)createdTimeDate)) {
                dateLong = Long.parseLong(createdTimeDate);
                firstRow.add(this.getDate(dateLong));
            } else {
                firstRow.add("");
            }
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + String.valueOf(e));
            logger.error(EXCEPTION + e.getMessage());
        }
        try {
            String lastModifiedTime = userElement.getLastModifiedTimestamp();
            if (!StringUtils.isEmpty((CharSequence)lastModifiedTime)) {
                dateLong = Long.parseLong(lastModifiedTime);
                firstRow.add(this.getDate(dateLong));
            } else {
                firstRow.add("");
            }
            String lastLoggedInDateInString = userElement.getLastLoggedInTime();
            if (!StringUtils.isEmpty((CharSequence)lastLoggedInDateInString)) {
                long dateLong2 = Long.parseLong(lastLoggedInDateInString);
                firstRow.add(this.getDate(dateLong2));
            } else {
                firstRow.add("");
            }
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + String.valueOf(e));
            logger.error(EXCEPTION + e.getMessage());
        }
        return firstRow;
    }

    void createExcelForUserXlsx(List<List> l1, XSSFWorkbook workbook) throws Exception {
        XSSFSheet firstSheet = workbook.createSheet("FIRST SHEET");
        int rownum = 0;
        try {
            for (int j = 0; j < l1.size(); ++j) {
                XSSFRow row = firstSheet.createRow(rownum);
                List l2 = l1.get(j);
                for (int k = 0; k < l2.size(); ++k) {
                    Cell cell = row.createCell(k);
                    cell.setCellValue((String)l2.get(k));
                    if (rownum != 0) continue;
                    XSSFCellStyle cellStyle = workbook.createCellStyle();
                    cellStyle.setFillForegroundColor((short)51);
                    cellStyle.setFillPattern((short)1);
                    XSSFFont font = workbook.createFont();
                    font.setFontName("Arial");
                    font.setFontHeightInPoints((short)10);
                    font.setBoldweight((short)10);
                    cellStyle.setFont((Font)font);
                    cell.setCellStyle((CellStyle)cellStyle);
                }
                ++rownum;
            }
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + String.valueOf(e));
            logger.error(EXCEPTION + e.getMessage());
        }
    }

    public void SetPermission(File folder, Path p) throws IOException {
        Set<PosixFilePermission> perms = Files.readAttributes(Paths.get(folder.getAbsolutePath(), new String[0]), PosixFileAttributes.class, new LinkOption[0]).permissions();
        perms.add(PosixFilePermission.OWNER_WRITE);
        perms.add(PosixFilePermission.OWNER_READ);
        perms.add(PosixFilePermission.GROUP_READ);
        perms.add(PosixFilePermission.OTHERS_READ);
        Files.setPosixFilePermissions(p, perms);
    }

    void writeExcelForUserXlsx(int cloudId, XSSFWorkbook workbook) {
        try (FileOutputStream fos = new FileOutputStream(new File(this.registry.get(cloudId).getPropertyFileValueParacloudMountPoint() + "/reports/Users.xlsx"));){
            XSSFCellStyle hsfstyle = workbook.createCellStyle();
            hsfstyle.setBorderBottom((short)1);
            hsfstyle.setFillBackgroundColor((short)245);
            workbook.write((OutputStream)fos);
            File f = new File(this.registry.get(cloudId).getPropertyFileValueParacloudMountPoint() + "/reports/Users.xlsx");
            this.SetPermission(f, Paths.get(f.getAbsolutePath(), new String[0]));
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + String.valueOf(e));
            logger.error(EXCEPTION + e.getMessage());
        }
    }

    boolean writeExcelForSoftBlockedUserXlsx(int cloudId, XSSFWorkbook workbook) {
        try (FileOutputStream fos = new FileOutputStream(new File(this.registry.get(cloudId).getPropertyFileValueParacloudMountPoint() + "/reports/SoftBlockedUsers.xlsx"));){
            XSSFCellStyle hsfstyle = workbook.createCellStyle();
            hsfstyle.setBorderBottom((short)1);
            hsfstyle.setFillBackgroundColor((short)245);
            workbook.write((OutputStream)fos);
            File f = new File(this.registry.get(cloudId).getPropertyFileValueParacloudMountPoint() + "/reports/SoftBlockedUsers.xlsx");
            this.SetPermission(f, Paths.get(f.getAbsolutePath(), new String[0]));
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + String.valueOf(e));
            logger.error(EXCEPTION + e.getMessage());
            return false;
        }
        return true;
    }

    private String getDate(long dateVal) {
        String date = "";
        try {
            SimpleDateFormat df2 = new SimpleDateFormat(DD_MMM_YYYY_HH_MM_SS, Locale.ENGLISH);
            Date dateD = new Date(dateVal);
            date = df2.format(dateD);
        }
        catch (NumberFormatException e) {
            logger.trace(NUMBER_FORMAT_EXCEPTION + String.valueOf(e));
            logger.error(NUMBER_FORMAT_EXCEPTION + e.getMessage());
        }
        return date;
    }

    private String generatePassWordhash(String passHash) {
        Security.addProvider((Provider)new BouncyCastleProvider());
        byte[] digesta = null;
        try {
            MessageDigest mda = MessageDigest.getInstance("SHA-512", "BC");
            digesta = mda.digest(passHash.getBytes());
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException e) {
            logger.trace("getSHA512hash : " + String.valueOf(e));
            logger.trace(e.getMessage());
        }
        return Hex.encodeHexString((byte[])digesta);
    }

    @Override
    public void removeUsersByName(int cloudId, List<String> userNames) {
        this.userDao.deleteUsersByName(cloudId, userNames);
        this.deletedUserDao.removeDeletedUser(cloudId, userNames);
    }

    @Override
    public boolean createUserFromAAD(int cloudId, String cloudName, AADUserElement aadUserElement, String migratedBy, boolean isSyncEnabled, boolean isBackupEnabled, boolean isOdbBackupEnabled, boolean isExchangeEnabled, boolean isSharepointEnabled, Cloud cloud) throws Exception {
        boolean userMigrated = false;
        try {
            User userFromDB = this.userDao.getUserByUserNameOrEmail(cloudId, aadUserElement.getUserPrincipalName());
            if (userFromDB == null && aadUserElement.getMail() != null) {
                userFromDB = this.userDao.getUserByUserNameOrEmail(cloudId, aadUserElement.getMail());
            }
            if (userFromDB != null && userFromDB.isGuest()) {
                this.userDao.removeUserbyID(cloudId, userFromDB.getUserId().toString());
            }
            User existingUser = this.userDao.getUserByUserNameOrEmail(cloudId, aadUserElement.getUserName());
            if ((long)cloud.getNoOfBackupUsersAllowed() <= this.countOfPresentBackupUsers(cloudId, cloudName, true)) {
                isBackupEnabled = false;
            }
            if ((long)cloud.getNoOfSyncUsersAllowed() <= this.countOfPresentSyncUsers(cloudId, cloudName, true)) {
                isSyncEnabled = false;
            }
            boolean odbBkpEnabled = false;
            boolean exchangeBkpEnabled = false;
            if (isOdbBackupEnabled) {
                odbBkpEnabled = true;
            }
            if (isExchangeEnabled) {
                exchangeBkpEnabled = true;
            }
            if ((long)cloud.getNoOfOneDriveUsersAllowed() <= this.userDao.countOfPresentOnedriveUsers(cloudId, true)) {
                odbBkpEnabled = false;
            }
            if ((long)cloud.getNoOfExchangeUsersAllowed() <= this.userDao.countOfPresentExchangeUsers(cloudId, true)) {
                exchangeBkpEnabled = false;
            }
            if ((long)cloud.getNoOfSPSitesAllowed() <= this.userDao.countOfPresentSite(cloudId, true)) {
                isSharepointEnabled = false;
            }
            if (!(isBackupEnabled || isSyncEnabled || odbBkpEnabled || exchangeBkpEnabled || isSharepointEnabled)) {
                throw new UserLimitReachedException("user limit reached");
            }
            PortalProperties portalProperties = this.portalPropertiesDao.getPortalProperties(cloudId, this.registry.get(cloudId).getPropertyValueComponentName());
            User user = new User();
            UUID uuid = UUID.randomUUID();
            String recoveryKey = String.valueOf(uuid);
            user.setSecurityRecoveryKey(recoveryKey);
            user.setActive(true);
            user.setAdmin(false);
            user.setBackupEnabled(isBackupEnabled);
            user.setSyncEnabled(isSyncEnabled);
            user.setOnedriveBkpEnabled(odbBkpEnabled);
            user.setExchangeBkpEnabled(exchangeBkpEnabled);
            user.setFirstLogin(true);
            user.setShareEnabled(true);
            user.setUserName(aadUserElement.getUserPrincipalName());
            if (StringUtils.isEmpty((CharSequence)aadUserElement.getMail())) {
                user.setEmailId(aadUserElement.getUserPrincipalName());
            } else {
                user.setEmailId(aadUserElement.getMail());
            }
            user.setCreatedTimestamp(String.valueOf(System.currentTimeMillis()));
            user.setDisplayName(aadUserElement.getDisplayName());
            user.setMigratedBy(migratedBy);
            user.setLocalUser(false);
            user.setLocation(aadUserElement.getOfficeLocation());
            user.setDepartment(aadUserElement.getDepartment());
            user.setAccountStatus(true);
            user.setUserNameLowerCase(aadUserElement.getUserPrincipalName().toLowerCase());
            user.setAadLoginId(aadUserElement.getUserPrincipalName());
            user.setBackupEnabled(isBackupEnabled);
            user.setSyncEnabled(isSyncEnabled);
            user.setOnedriveBkpEnabled(odbBkpEnabled);
            user.setExchangeBkpEnabled(exchangeBkpEnabled);
            user.setSharePointBkpEnabled(isSharepointEnabled);
            if (!StringUtils.isEmpty((CharSequence)aadUserElement.getDefaultSharepointPolicy())) {
                user.setSpPolicyName(aadUserElement.getDefaultSharepointPolicy());
            }
            if (!StringUtils.isEmpty((CharSequence)aadUserElement.getDefaultPolicy())) {
                user.setPolicyName(aadUserElement.getDefaultPolicy());
            }
            if (!StringUtils.isEmpty((CharSequence)aadUserElement.getDefaultSyncPolicy())) {
                user.setSyncPolicyName(aadUserElement.getDefaultSyncPolicy());
            }
            if (!StringUtils.isEmpty((CharSequence)aadUserElement.getDefaultOdbPolicy())) {
                user.setOneDrivePolicyName(aadUserElement.getDefaultOdbPolicy());
            }
            if (!StringUtils.isEmpty((CharSequence)aadUserElement.getDefaultExchangePolicy())) {
                user.setExchangePolicyName(aadUserElement.getDefaultExchangePolicy());
            }
            String googleSecretKey = this.getGoogleSecurityKey();
            logger.debug(isSyncEnabled + "....googleSecretKey for AAD ....." + googleSecretKey + "....policyname...." + aadUserElement.getDefaultExchangePolicy());
            user.setGoogleSecretKey(googleSecretKey);
            UserElement userElement = new UserElement();
            if (portalProperties.getComponentsProperties().get("BLUDRIVE_MODE").toString().equals("false")) {
                user.setSyncAccessType("WEBANDENDPOINT");
                logger.debug("....BLUDRIVE_MODE is false so set ..WEBANDENDPOINT");
            } else {
                user.setSyncAccessType("WEBONLY");
                logger.debug("....BLUDRIVE_MODE is true so set ..WEBONLY");
            }
            BeanUtils.copyProperties((Object)user, (Object)userElement);
            UserElement createduserElement = this.createUser(cloudId, cloudName, userElement, true, this.userDao);
            if (createduserElement != null) {
                userMigrated = true;
                MigrationStatus migrationStatus = new MigrationStatus();
                migrationStatus.setMigratedBy(migratedBy);
                migrationStatus.setMigratededTimestamp(System.currentTimeMillis());
                migrationStatus.setMigrated(true);
                migrationStatus.setUserName(user.getUserName());
                migrationStatus.setEmailId(user.getEmailId());
                this.migrationStatusDao.saveMigrationStatus(cloudId, migrationStatus);
            }
        }
        catch (UserLimitReachedException e) {
            throw new UserLimitReachedException("user limit reached");
        }
        catch (Exception e) {
            logger.error(EXCEPTION + String.valueOf(e));
            logger.debug(EXCEPTION + e.getMessage());
            throw new Exception(e);
        }
        return userMigrated;
    }

    private String getGoogleSecurityKey() {
        SecureRandom random = new SecureRandom();
        byte[] bytes = new byte[20];
        random.nextBytes(bytes);
        Base32 base32 = new Base32();
        String googleSecretKey = base32.encodeToString(bytes);
        return googleSecretKey;
    }

    @Override
    public SyncPolicyElement getSyncPolicyElement(int cloudId, String cloudName, String syncPolicyName) {
        SyncPolicyElement syncPolicyElement = this.getSyncPolicyElement(cloudId, this.syncPolicyDao.getSyncPolicy(cloudId, cloudName, syncPolicyName));
        return syncPolicyElement;
    }

    @Override
    public List<User> getUsersWithoutDevices(int cloudId) {
        List users = this.userDao.getAllOneDriveBkpEnabledUsers(cloudId);
        if (CollectionUtils.isEmpty((Collection)users)) {
            logger.debug("...no users found for odbBkp........");
            return new ArrayList<User>();
        }
        ArrayList<User> usersWithoutDrive = new ArrayList<User>();
        for (User user : users) {
            Device device = this.deviceDao.getOneDriveDeviceforUser(cloudId, user.getUserName());
            if (device != null) continue;
            usersWithoutDrive.add(user);
            if (usersWithoutDrive.size() < 100) continue;
            return usersWithoutDrive;
        }
        return usersWithoutDrive;
    }

    @Override
    public boolean createTextForBlackListAndMappedUser(int cloudId, String cloudName, boolean isAllUser, boolean secAdmin, boolean newOdbUser, boolean failedMailBox) {
        try {
            Object userList;
            AbstractCollection blackListUsersNames;
            List blackListUsers;
            logger.debug("...isAllUser..." + isAllUser + "....secAdmin..." + secAdmin);
            logger.debug("...newOdbUser..." + newOdbUser + "....failedMailBox..." + failedMailBox);
            List allUsersList = this.userDao.getAllUsers(cloudId, cloudName, false);
            HashSet<String> userSet = new HashSet<String>();
            for (User user : allUsersList) {
                List deviceBackupOverViews = this.deviceDao.getDeviceBkpOverviewForUserName(cloudId, user.getUserName());
                if (!user.isActive() || CollectionUtils.isEmpty((Collection)deviceBackupOverViews)) continue;
                Iterator iterator = deviceBackupOverViews.iterator();
                while (iterator.hasNext()) {
                    DeviceBackupOverView overView = (DeviceBackupOverView)iterator.next();
                    if (!overView.getOsType().equalsIgnoreCase("OUTLOOK") && !overView.getOsType().equalsIgnoreCase("ONEDRIVE")) continue;
                    boolean userEligible = false;
                    if (overView.getStorageUtilized() <= 0L) {
                        this.deviceDao.updatedeviceToken(cloudId, overView.getDeviceUUID());
                        logger.debug(".....0mb device user..." + overView.getUserName() + "....device...." + overView.getDeviceName());
                        userEligible = true;
                    } else {
                        BackupBatch backupBatch = this.backupBatchDao.getLastSuccessfullBackup(cloudId, overView.getDeviceUUID());
                        if (backupBatch != null && "0".equals(backupBatch.getTotalNoOfFiles())) {
                            userEligible = true;
                            logger.debug(".....last backup was 0 files for user..." + overView.getUserName() + "....device...." + overView.getDeviceName());
                        }
                    }
                    if (!userEligible) continue;
                    logger.debug("....useradded...." + user.getEmailId());
                    userSet.add(user.getEmailId());
                }
            }
            if (failedMailBox) {
                List userList2 = this.userDao.getAllFailedMailBox(cloudId);
                HashSet<String> emaildIds = new HashSet<String>();
                for (User user : userList2) {
                    emaildIds.add(user.getEmailId());
                }
                emaildIds.addAll(userSet);
                return this.createTextFileForOdb(emaildIds, "Failed MailBox");
            }
            if (secAdmin) {
                Object blackListUserData2;
                if (isAllUser) {
                    Iterator users;
                    HashSet<String> mappedUserList = new HashSet<String>();
                    ArrayList usersList = new ArrayList();
                    int i = 0;
                    while (!CollectionUtils.isEmpty((Collection)((Object)(users = this.userDao.getAllUsers(cloudId, cloudName, i, false, "false"))))) {
                        usersList.addAll(users);
                        ++i;
                    }
                    for (User userData : usersList) {
                        this.getListOfUserName(mappedUserList, userData);
                    }
                    mappedUserList.addAll(userSet);
                    return this.createTextFileForOdb(mappedUserList, "Mapped Users");
                }
                HashSet<String> blackListUserList = new HashSet<String>();
                blackListUsers = this.userDao.getAllO365BlockedListUser(cloudId);
                logger.debug("........" + blackListUsers.size());
                blackListUsersNames = new ArrayList();
                for (Object blackListUserData2 : blackListUsers) {
                    blackListUsersNames.add(blackListUserData2.getUserName());
                }
                userList = this.userDao.getAllUsersForNames(cloudId, blackListUsersNames);
                blackListUserData2 = userList.iterator();
                while (blackListUserData2.hasNext()) {
                    User user = (User)blackListUserData2.next();
                    this.getListOfUserName(blackListUserList, user);
                }
                blackListUserList.addAll(userSet);
                return this.createTextFileForOdb(blackListUserList, "Black List Users");
            }
            boolean muxedEnabled = false;
            if (StringUtils.isNotEmpty((CharSequence)this.registry.get(cloudId).getOneDriveBackupType()) && this.registry.get(cloudId).getOneDriveBackupType().equalsIgnoreCase("MUX")) {
                muxedEnabled = true;
            }
            logger.debug(".muxedEnabled..." + muxedEnabled);
            blackListUsers = this.userDao.getAllBackupTargetNotAssignedUser(cloudId);
            blackListUsersNames = new HashSet();
            for (Object blackListUserData2 : blackListUsers) {
                if (blackListUserData2 == null) continue;
                if (!muxedEnabled) {
                    if (blackListUsersNames.contains(blackListUserData2.getEmailId())) continue;
                    blackListUsersNames.add(blackListUserData2.getEmailId());
                    continue;
                }
                if (StringUtils.isNotEmpty((CharSequence)blackListUserData2.getOdbLoginId()) && !blackListUsersNames.contains(blackListUserData2.getOdbLoginId())) {
                    blackListUsersNames.add(blackListUserData2.getOdbLoginId());
                }
                if (blackListUserData2.getBackupTargetErrorCode() != 0) continue;
                blackListUserData2.setBackupTargetErrorCode(204);
                this.userDao.saveUser(cloudId, cloudName, (User)blackListUserData2);
            }
            userList = this.userDao.getAllFailedMailBox(cloudId);
            Iterator iterator = userList.iterator();
            while (iterator.hasNext()) {
                User user = (User)iterator.next();
                if (!user.isNewOdbUser()) continue;
                blackListUsersNames.add(user.getEmailId());
            }
            blackListUsersNames.addAll(userSet);
            return this.createTextFileForOdb((Set<String>)((Object)blackListUsersNames), "size=50000");
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + String.valueOf(e));
            logger.error(EXCEPTION + e.getMessage());
            return false;
        }
    }

    private void getListOfOdbOrEmailIdFromUser(List<String> odbOrEmailIdList, User userData) {
        odbOrEmailIdList.add(userData.getEmailId());
    }

    private void getListOfUserName(Set<String> odbOrEmailIdList, User userData) {
        if (!StringUtils.isEmpty((CharSequence)userData.getOdbLoginId())) {
            odbOrEmailIdList.add(userData.getOdbLoginId());
        } else {
            odbOrEmailIdList.add(userData.getEmailId());
        }
    }

    private boolean createTextFileForOdb(Set<String> odbOrEmailIdList, String excelHeader) {
        boolean result = false;
        if (!CollectionUtils.isEmpty(odbOrEmailIdList)) {
            try {
                FileWriter fileWriter = new FileWriter("/var/www/odbInfo/BlackList_And_Active_User.txt");
                fileWriter.write(excelHeader);
                for (String emailId : odbOrEmailIdList) {
                    fileWriter.write("\n" + emailId);
                }
                fileWriter.close();
                result = true;
            }
            catch (IOException e1) {
                logger.error(EXCEPTION + String.valueOf(e1));
                logger.debug(EXCEPTION + e1.getMessage());
            }
        }
        return result;
    }

    @Override
    public BackupPolicy getBackupPolicy(int cloudId, String policyName) {
        return this.userDao.getBackupPolicyByPolicyName(cloudId, policyName);
    }

    @Override
    public SyncPolicy getSyncPolicyByPolicyName(int cloudId, String policyName) {
        return this.userDao.getSyncPolicyByPolicyName(cloudId, policyName);
    }

    @Override
    public long getSyncPolicyMappedUserCountbyPolicyName(int cloudId, String policyName) {
        return this.userDao.getSyncPolicyMappedUserCountbyPolicyName(cloudId, policyName);
    }

    @Override
    public void mapODBIdsByFilePath(UserListElement userListElement) {
        if (userListElement != null && !CollectionUtils.isEmpty((Collection)userListElement.getUserList())) {
            for (UserElement userElement : userListElement.getUserList()) {
                try {
                    User userByUserNameOrEmail = this.userDao.getUserByUserNameOrEmail(1, userElement.getEmailId());
                    if (userByUserNameOrEmail == null) continue;
                    userByUserNameOrEmail.setOdbLoginId(userElement.getOdbLoginId());
                    logger.debug("Updating " + userElement.getEmailId() + " ODB Id as :" + userElement.getOdbLoginId());
                }
                catch (Exception e) {
                    logger.trace(EXCEPTION + String.valueOf(e));
                    logger.error(EXCEPTION + e.getMessage());
                }
            }
        } else {
            logger.debug("userListElement is empty......");
        }
    }

    private boolean isAADEnabled(List<CloudCustomisableDetails> list) {
        boolean isAADEnabled = false;
        for (CloudCustomisableDetails customisableDetails : list) {
            if (!"AAD Enabled".equals(customisableDetails.getName())) continue;
            isAADEnabled = true;
            break;
        }
        return isAADEnabled;
    }

    @Override
    public UserElement getUserByUserName(Cloud cloud, String userName) {
        ArrayList<MiniCloudElement> cloudElements = new ArrayList<MiniCloudElement>();
        UserElement usrElement = new UserElement();
        int cloudId = cloud.getCloudId();
        String cloudName = cloud.getCloudName();
        User user = this.userDao.getUserByUserName(cloudId, userName);
        if (user == null && this.isAADEnabled(cloud.getCloudCustomisableDetails())) {
            user = this.userDao.getUserByUserNameOrAADLoginId(cloudId, userName);
        }
        if (user != null) {
            OfficeBackupPolicyElement officeBackupPolicyElement;
            SyncPolicyElement syncPolicyElement;
            BackupPolicyElement backupPolicyElement;
            BaseController.printLogs("USer not null :" + user.getUserName() + " user active:" + user.isActive(), this.registry.get(cloudId).isBrevityLogging());
            List ucacList = this.userMiniCloudMappingDao.getAccessControlMappingsByUser(cloudId, cloudName, user.getUserId());
            if (!CollectionUtils.isEmpty((Collection)ucacList)) {
                for (UserCloudAccessControl ucac : ucacList) {
                    MiniCloudElement cloudElement = new MiniCloudElement();
                    MiniCloud cloud1 = this.miniCloudDao.getMiniCloudByID(cloudId, cloudName, ucac.getMiniCloudFK());
                    if (cloud1 == null) continue;
                    BeanUtils.copyProperties((Object)cloud1, (Object)cloudElement);
                    cloudElements.add(cloudElement);
                }
            }
            if (StringUtils.isEmpty((CharSequence)user.getLastModifiedTimestamp())) {
                usrElement.setLastModifiedTimestamp(user.getCreatedTimestamp());
            }
            MiniCloudElementList miniCloudElementList = new MiniCloudElementList();
            miniCloudElementList.setMiniClouds(cloudElements);
            usrElement.setMiniCloudElementList(miniCloudElementList);
            BeanUtils.copyProperties((Object)user, (Object)usrElement);
            usrElement.setShareEnabled(user.isShareEnabled());
            PciAuthorizationTokens authorizationTokens = this.pciAuthorizationTokensDao.getPciAuthorizationTokensForUserId(cloudId, cloudName, user.getUserId());
            if (!StringUtils.isEmpty((CharSequence)usrElement.getPolicyName()) && (backupPolicyElement = this.getBackupPolicyElement(cloudId, this.backupPolicyDao.getBackupPolicy(cloudId, cloudName, user.getPolicyName()))) != null) {
                usrElement.setBackupPolicyElement(this.getBackupPolicyElement(cloudId, this.backupPolicyDao.getBackupPolicy(cloudId, cloudName, user.getPolicyName())));
            }
            if (!StringUtils.isEmpty((CharSequence)usrElement.getSyncPolicyName()) && (syncPolicyElement = this.getSyncPolicyElement(cloudId, this.syncPolicyDao.getSyncPolicy(cloudId, cloudName, user.getSyncPolicyName()))) != null) {
                usrElement.setSyncPolicyElement(this.getSyncPolicyElement(cloudId, this.syncPolicyDao.getSyncPolicy(cloudId, cloudName, user.getSyncPolicyName())));
            }
            if (!StringUtils.isEmpty((CharSequence)usrElement.getOneDrivePolicyName()) && (officeBackupPolicyElement = this.getOfficeBackupPolicyElement(cloudId, this.userDao.getOfficeBackupPolicyByPolicyName(cloudId, user.getOneDrivePolicyName()))) != null) {
                usrElement.setOfficeBackupPolicyElement(officeBackupPolicyElement);
            }
            if (user.isReadOnlyAdmin()) {
                BackupPoliciesAdminList backupPolicyAdminList = new BackupPoliciesAdminList();
                backupPolicyAdminList.setBackupPoliciesAdmin(user.getBackupPoliciesAdmin());
                usrElement.setBackupPoliciesAdminList(backupPolicyAdminList);
                SyncPoliciesAdminList syncPolicyAdminList = new SyncPoliciesAdminList();
                syncPolicyAdminList.setSyncPoliciesAdmin(user.getSyncPoliciesAdmin());
                usrElement.setSyncPoliciesAdminList(syncPolicyAdminList);
                OdbPolicesAdminList odbPolicesAdminList = new OdbPolicesAdminList();
                odbPolicesAdminList.setOdbPoliciesAdminForUser(user.getOdbPoliciesAdmin());
                usrElement.setOdbPoliciesAdminList(odbPolicesAdminList);
                SpPolicesAdminList spPolicesAdminList = new SpPolicesAdminList();
                spPolicesAdminList.setSpPoliciesAdmin(user.getSpPoliciesAdmin());
                usrElement.setSpPoliciesAdminList(spPolicesAdminList);
            }
            if (authorizationTokens != null) {
                usrElement.setExternalStorageAuthorized(true);
            } else {
                usrElement.setExternalStorageAuthorized(false);
            }
        } else {
            return null;
        }
        return usrElement;
    }

    @Override
    public UserElement getUserByAADLoginId(Cloud cloud, String aadLoginId) {
        int cloudId = cloud.getCloudId();
        String cloudName = cloud.getCloudName();
        ArrayList<MiniCloudElement> cloudElements = new ArrayList<MiniCloudElement>();
        UserElement usrElement = new UserElement();
        User user = this.userDao.getUserByAADLoginId(cloudId, aadLoginId);
        if (user != null) {
            OfficeBackupPolicyElement officeBackupPolicyElement;
            SyncPolicyElement syncPolicyElement;
            BackupPolicyElement backupPolicyElement;
            BaseController.printLogs("USer not null :" + user.getUserName(), this.registry.get(cloudId).isBrevityLogging());
            List ucacList = this.userMiniCloudMappingDao.getAccessControlMappingsByUser(cloudId, cloudName, user.getUserId());
            if (!CollectionUtils.isEmpty((Collection)ucacList)) {
                for (UserCloudAccessControl ucac : ucacList) {
                    MiniCloudElement cloudElement = new MiniCloudElement();
                    MiniCloud cloud1 = this.miniCloudDao.getMiniCloudByID(cloudId, cloudName, ucac.getMiniCloudFK());
                    if (cloud == null) continue;
                    BeanUtils.copyProperties((Object)cloud1, (Object)cloudElement);
                    cloudElements.add(cloudElement);
                }
            }
            if (StringUtils.isEmpty((CharSequence)user.getLastModifiedTimestamp())) {
                usrElement.setLastModifiedTimestamp(user.getCreatedTimestamp());
            }
            MiniCloudElementList miniCloudElementList = new MiniCloudElementList();
            miniCloudElementList.setMiniClouds(cloudElements);
            usrElement.setMiniCloudElementList(miniCloudElementList);
            BeanUtils.copyProperties((Object)user, (Object)usrElement);
            usrElement.setShareEnabled(user.isShareEnabled());
            PciAuthorizationTokens authorizationTokens = this.pciAuthorizationTokensDao.getPciAuthorizationTokensForUserId(cloudId, cloudName, user.getUserId());
            if (!StringUtils.isEmpty((CharSequence)usrElement.getPolicyName()) && (backupPolicyElement = this.getBackupPolicyElement(cloudId, this.backupPolicyDao.getBackupPolicy(cloudId, cloudName, user.getPolicyName()))) != null) {
                usrElement.setBackupPolicyElement(this.getBackupPolicyElement(cloudId, this.backupPolicyDao.getBackupPolicy(cloudId, cloudName, user.getPolicyName())));
            }
            if (!StringUtils.isEmpty((CharSequence)usrElement.getSyncPolicyName()) && (syncPolicyElement = this.getSyncPolicyElement(cloudId, this.syncPolicyDao.getSyncPolicy(cloudId, cloudName, user.getSyncPolicyName()))) != null) {
                usrElement.setSyncPolicyElement(this.getSyncPolicyElement(cloudId, this.syncPolicyDao.getSyncPolicy(cloudId, cloudName, user.getSyncPolicyName())));
            }
            if (user.isOnedriveBkpEnabled() && !StringUtils.isEmpty((CharSequence)user.getOneDrivePolicyName()) && (officeBackupPolicyElement = this.getOfficeBackupPolicyElement(cloudId, this.userDao.getOfficeBackupPolicyByPolicyName(cloudId, user.getOneDrivePolicyName()))) != null) {
                usrElement.setOfficeBackupPolicyElement(officeBackupPolicyElement);
            }
            if (user.isReadOnlyAdmin()) {
                BackupPoliciesAdminList backupPolicyAdminList = new BackupPoliciesAdminList();
                backupPolicyAdminList.setBackupPoliciesAdmin(user.getBackupPoliciesAdmin());
                usrElement.setBackupPoliciesAdminList(backupPolicyAdminList);
                SyncPoliciesAdminList syncPolicyAdminList = new SyncPoliciesAdminList();
                syncPolicyAdminList.setSyncPoliciesAdmin(user.getSyncPoliciesAdmin());
                usrElement.setSyncPoliciesAdminList(syncPolicyAdminList);
                OdbPolicesAdminList odbPolicesAdminList = new OdbPolicesAdminList();
                odbPolicesAdminList.setOdbPoliciesAdminForUser(user.getOdbPoliciesAdmin());
                usrElement.setOdbPoliciesAdminList(odbPolicesAdminList);
                SpPolicesAdminList spPolicesAdminList = new SpPolicesAdminList();
                spPolicesAdminList.setSpPoliciesAdmin(user.getSpPoliciesAdmin());
                usrElement.setSpPoliciesAdminList(spPolicesAdminList);
            }
            if (authorizationTokens != null) {
                usrElement.setExternalStorageAuthorized(true);
            } else {
                usrElement.setExternalStorageAuthorized(false);
            }
        } else {
            return null;
        }
        return usrElement;
    }

    @Override
    public void autoDeviceBlockBasedOnPolicy(Cloud cloud) {
        int cloudId = cloud.getCloudId();
        List allActiveUsers = this.userDao.getAllActiveUsers(cloudId);
        for (User user : allActiveUsers) {
            try {
                BackupPolicy backupPolicy;
                if (user == null || !user.isBackupEnabled() || StringUtils.isEmpty((CharSequence)user.getPolicyName()) || (backupPolicy = this.userDao.getBackupPolicyByPolicyName(cloudId, user.getPolicyName())) == null || backupPolicy.getNoOfDaysToKeepDeviceNotHeard() == 0L || backupPolicy.getNoOfDaysToKeepDeviceNotHeard() == -1L) continue;
                List allOverviews = this.deviceDao.getAllOverviews(cloudId, user.getUserName());
                for (DeviceBackupOverView bkpOverview : allOverviews) {
                    boolean userUnderLegalHold;
                    if (!StringUtils.isEmpty((CharSequence)bkpOverview.getDeviceType()) && !bkpOverview.getDeviceType().equalsIgnoreCase("BACKUP")) continue;
                    if (bkpOverview.getLastHeardTime() == 0L) {
                        bkpOverview.setLastHeardTime(Long.valueOf(bkpOverview.getEpaInstallationDate()).longValue());
                    }
                    if (bkpOverview == null || bkpOverview.isDeviceBolcked() || bkpOverview.getLastHeardTime() == 0L) continue;
                    SimpleDateFormat format = new SimpleDateFormat(DD_MMM_YYYY_HH_MM_SS);
                    Device device = this.deviceDao.getDeviceInfoByUUID(cloud.getCloudId(), "", bkpOverview.getDeviceUUID());
                    long deviceLastModifiedTime = device.getLastModifiedTimestamp();
                    long lastHeardTimeProxy = bkpOverview.getLastHeardTime();
                    if (deviceLastModifiedTime > bkpOverview.getLastHeardTime()) {
                        lastHeardTimeProxy = deviceLastModifiedTime;
                    }
                    Date yourDate = format.parse(UserManagementServiceImpl.getDateInFormat(lastHeardTimeProxy));
                    yourDate.setHours(0);
                    yourDate.setMinutes(0);
                    DateTime dt1 = new DateTime((Object)yourDate);
                    DateTime dt2 = new DateTime();
                    int daysDifference = Days.daysBetween((ReadableInstant)dt1, (ReadableInstant)dt2).getDays();
                    if (daysDifference == 0 || (long)daysDifference <= backupPolicy.getNoOfDaysToKeepDeviceNotHeard() || (userUnderLegalHold = this.isUserUnderLegalHoldForUserName(cloudId, device.getUserName()))) continue;
                    this.blockDeviceByUserAndAudit(cloud, device, user, dt1, backupPolicy.getNoOfDaysToKeepDeviceNotHeard());
                }
            }
            catch (Exception e) {
                logger.error("Failed to block" + e.getMessage());
                logger.trace("Failed to block" + String.valueOf(e));
            }
        }
    }

    @Override
    public List<User> getUsersForDataMigration(int cloudId) {
        return this.userDao.getUsersForDataMigration(cloudId);
    }

    private static String getDateInFormat(Long deviceCreatedDate) {
        String dateStringFormat = "";
        if (deviceCreatedDate == null || deviceCreatedDate == 0L) {
            return dateStringFormat;
        }
        try {
            SimpleDateFormat df2 = new SimpleDateFormat(DD_MMM_YYYY_HH_MM_SS);
            Date dateD = new Date(deviceCreatedDate);
            dateStringFormat = df2.format(dateD);
        }
        catch (Exception e) {
            logger.error("Invalid date value ...." + deviceCreatedDate);
            logger.trace("Invalid date value ...." + String.valueOf(e));
            logger.error("Invalid date value ...." + e.getMessage());
        }
        return dateStringFormat;
    }

    @Override
    public List<UserElement> getAllBlockedUsersForDataMigration(int cloudId, int skipValue) {
        ArrayList<UserElement> userElementList = new ArrayList<UserElement>();
        List usersList = this.userDao.getUsersForDataMigration(cloudId, skipValue);
        ArrayList<String> userNamesWithoutDevices = new ArrayList<String>();
        List<UserElement> userElementWithoutDevicesList = this.getAllUsersWithoutdevice(cloudId, skipValue, new ArrayList<String>(), false, null);
        for (UserElement userElement : userElementWithoutDevicesList) {
            userNamesWithoutDevices.add(userElement.getUserName());
        }
        logger.debug(" user names list ... " + usersList.size());
        for (User user : usersList) {
            logger.debug(" user names ... " + user.getUserName());
            if (userNamesWithoutDevices.contains(user.getUserName())) {
                logger.debug("user does not have any device:" + user.getUserName());
                continue;
            }
            if (user.isGuest() || user.isSuperAdmin()) continue;
            UserElement ue = new UserElement();
            BeanUtils.copyProperties((Object)user, (Object)ue);
            ue.setShareEnabled(user.isShareEnabled());
            userElementList.add(ue);
        }
        return userElementList;
    }

    @Override
    public boolean startMigration(int cloudId, String userName, String destOdbId) {
        return this.userDao.startMigration(cloudId, userName, destOdbId);
    }

    @Override
    public List<User> getUsersWithoutOutlookDevices(int cloudId) {
        List users = this.userDao.getAllExchangeBkpEnabledUsers(cloudId);
        if (CollectionUtils.isEmpty((Collection)users)) {
            logger.debug("...no users found for odbBkp........");
            return new ArrayList<User>();
        }
        ArrayList<User> usersWithoutDrive = new ArrayList<User>();
        for (User user : users) {
            Device device = this.deviceDao.getUsersWithoutOutlookDevices(cloudId, user.getUserName());
            if (device != null) continue;
            usersWithoutDrive.add(user);
            if (usersWithoutDrive.size() < 100) continue;
            return usersWithoutDrive;
        }
        return usersWithoutDrive;
    }

    @Override
    public List<User> getAllOneDriveBkpEnabledUsers(int cloudId) {
        List users = this.userDao.getAllOneDriveBkpEnabledUsers(cloudId);
        if (CollectionUtils.isEmpty((Collection)users)) {
            logger.debug("...no users found for odbBkp........");
            return new ArrayList<User>();
        }
        return users;
    }

    @Override
    public void updateMigrationStatusAndFolderName(int cloudId, String userName, String migratedFolderName) {
        this.userDao.updateMigrationStatusAndFolderName(cloudId, userName, migratedFolderName);
    }

    private OfficeBackupPolicyElement getOfficeBackupPolicyElement(int cloudId, OfficeBackupPolicy backupPolicy) {
        OfficeBackupPolicyElement element = null;
        ArrayList<String> folderPaths = new ArrayList<String>();
        ArrayList<String> userExcludedFolderPaths = new ArrayList<String>();
        ArrayList<String> scheduleNames = new ArrayList<String>();
        ArrayList calloutScriptStrs = new ArrayList();
        if (backupPolicy == null) {
            return null;
        }
        if (CollectionUtils.isEmpty((Collection)backupPolicy.getSchedules()) && CollectionUtils.isEmpty((Collection)backupPolicy.getBackupFolders())) {
            return null;
        }
        for (Schedule schedule : backupPolicy.getSchedules()) {
            scheduleNames.add(schedule.getScheduleName());
        }
        for (BackupFolders backupFolder : backupPolicy.getBackupFolders()) {
            BackupFolderElement backupFolderElement = new BackupFolderElement();
            if (backupFolder == null) continue;
            backupFolderElement.setFolderPath(backupFolder.getFolderPath());
            backupFolderElement.setOsType(backupFolder.getOs());
            folderPaths.add(backupFolder.getFolderPath());
        }
        if (backupPolicy != null) {
            List searchFlterNames;
            ArrayList searchFilters;
            element = new OfficeBackupPolicyElement();
            BeanUtils.copyProperties((Object)backupPolicy, (Object)element);
            element.setPolicygroupName(backupPolicy.getPolicyName());
            element.setBackupFolderPaths(new ArrayList());
            element.getBackupFolderPaths().addAll(folderPaths);
            if (!org.springframework.util.StringUtils.isEmpty((Object)backupPolicy.getExcludedFolders())) {
                for (ExcludedFolders userExcludedFolders : backupPolicy.getExcludedFolders()) {
                    ExcludedFolderElement userExcludedFolderElement = new ExcludedFolderElement();
                    if (userExcludedFolders == null) continue;
                    userExcludedFolderElement.setFolderPath(userExcludedFolders.getFolderPath());
                    userExcludedFolderPaths.add(userExcludedFolders.getFolderPath());
                }
                if (!userExcludedFolderPaths.isEmpty()) {
                    element.setExcludedFolderpaths(userExcludedFolderPaths);
                }
            }
            element.setCalloutScripts(calloutScriptStrs);
            ArrayList filters = backupPolicy.getInclusionFilter();
            List filterNames = filters.stream().filter(filter -> Objects.nonNull(filter.getFilterName())).map(filter -> filter.getFilterName()).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(filterNames)) {
                element.setFilterInclusionName(filterNames);
            }
            if (!CollectionUtils.isEmpty((Collection)(searchFilters = backupPolicy.getSearchInclusionFilter())) && !CollectionUtils.isEmpty(searchFlterNames = searchFilters.stream().filter(filter -> Objects.nonNull(filter.getFilterName())).map(filter -> filter.getFilterName()).collect(Collectors.toList()))) {
                element.setSearchFilterInclusionName(searchFlterNames);
            }
            element.setScheduleNames(new ArrayList());
            element.getScheduleNames().addAll(scheduleNames);
            element.setEndpointUiPreferences((List)backupPolicy.getEndpointUiPreferences());
            ArrayList list = backupPolicy.getPrivacyGateways();
            PrivacyGatewayMappingElement mappingElement = new PrivacyGatewayMappingElement();
            ArrayList<String> pgList = new ArrayList<String>();
            for (PrivacyGateway privacyGateway : list) {
                if (privacyGateway == null) continue;
                mappingElement.setGatewayNwThrottlingName("PGThrottle-name");
                pgList.add(privacyGateway.getGatewayName());
            }
            mappingElement.setPrivacyGatewayNames(new ArrayList());
            mappingElement.setPrivacyGatewayNames(pgList);
            element.setPrivacyGatewayMappingElement(mappingElement);
            mappingElement = new PrivacyGatewayMappingElement();
            element.setSearchAlgoForPg(backupPolicy.getSearchAlgoForPg());
            element.setContentIndexEnabled(backupPolicy.isContentIndexEnabled());
        }
        logger.debug(element.isContentIndexEnabled() + "...content index enabled ... " + backupPolicy.isContentIndexEnabled());
        return element;
    }

    @Override
    public void updateMailBoxFailStatus(int cloudId, String userName, boolean failMailBox, int errorCode) {
        this.userDao.updateMailBoxFailStatus(cloudId, userName, failMailBox, errorCode);
    }

    private String getCommentsForErrorCode(int errorCode) {
        String comments = "";
        if (errorCode == 0) {
            return "Newly created user";
        }
        if (errorCode == 201) {
            comments = "User not present in SharePoint";
        }
        if (errorCode == 202) {
            comments = "User OneDrive license invalid";
        }
        if (errorCode == 203) {
            comments = "Insufficient space in OneDrive subscription to use for backup";
        }
        if (errorCode == 404) {
            comments = "User site not found. Make sure the email ID provided is valid";
        }
        if (errorCode == 403) {
            comments = "OneDrive permission denied";
        }
        if (errorCode == 204) {
            comments = "OneDrive target not assigned";
        }
        return comments;
    }

    @Override
    public void mapODBIdAndErrorCode(UserListElement userListElement, Cloud cloud) {
        if (userListElement != null && !CollectionUtils.isEmpty((Collection)userListElement.getUserList())) {
            for (UserElement userElement : userListElement.getUserList()) {
                try {
                    boolean muxedEnabled = false;
                    if (StringUtils.isNotEmpty((CharSequence)this.registry.get(cloud.getCloudId()).getOneDriveBackupType()) && this.registry.get(cloud.getCloudId()).getOneDriveBackupType().equalsIgnoreCase("MUX")) {
                        muxedEnabled = true;
                    }
                    logger.debug(muxedEnabled + ":mux enabled................odb-login-id:" + userElement.getOdbLoginId());
                    String emailId = userElement.getEmailId();
                    logger.debug(emailId + ".....email and odb..." + userElement.getOdbLoginId());
                    if (StringUtils.isEmpty((CharSequence)emailId)) {
                        emailId = userElement.getOdbLoginId();
                    }
                    logger.debug(emailId + ".....email and odb1..." + userElement.getOdbLoginId());
                    List userList = !muxedEnabled ? this.userDao.getUserByODBLoginIdOrEmailId(1, emailId) : this.userDao.getUserByODBLoginId(1, emailId);
                    for (User userByUserNameOrEmail : userList) {
                        if (userByUserNameOrEmail == null) continue;
                        if (cloud.getGraphApiEnabled() != 1 && !muxedEnabled && StringUtils.isNotEmpty((CharSequence)userElement.getOdbLoginId())) {
                            userByUserNameOrEmail.setOdbLoginId(userElement.getOdbLoginId());
                        }
                        this.updateUserBkpTargetStatus(userElement, userByUserNameOrEmail);
                    }
                }
                catch (Exception e) {
                    logger.trace(EXCEPTION + String.valueOf(e));
                    logger.error(EXCEPTION + e.getMessage());
                }
            }
        } else {
            logger.debug("userListElement is empty......");
        }
    }

    private void updateUserBkpTargetStatus(UserElement userElement, User userByUserNameOrEmail) {
        int backupTargetErrorCode = userElement.getBackupTargetErrorCode();
        boolean backupTargetAssigned = false;
        if (userElement.getBackupTargetErrorCode() == 0) {
            backupTargetAssigned = true;
            logger.debug("Updating " + userElement.getEmailId() + " ODB Id as :" + userElement.getOdbLoginId());
        }
        boolean failedMailBox = true;
        if (userElement.getBackupTargetErrorCode() == 444) {
            failedMailBox = false;
            logger.debug("userByUserNameOrEmail..." + userByUserNameOrEmail.getUserName());
            logger.debug("Updating " + userElement.getEmailId() + " failedMailBox :" + userElement.getOdbLoginId());
            this.userDao.updateUserfailedMailBox(1, userByUserNameOrEmail.getUserName(), failedMailBox);
            this.deviceDao.removeO365BlackListUser(1, userByUserNameOrEmail.getUserName());
        }
        if (backupTargetErrorCode == 450) {
            this.deviceDao.removeO365BlackListUser(1, userByUserNameOrEmail.getUserName());
        } else {
            this.userDao.updateUserBkpTargetStatus(1, userByUserNameOrEmail.getUserName(), backupTargetErrorCode, backupTargetAssigned, userByUserNameOrEmail.getOdbLoginId());
        }
        logger.debug(userByUserNameOrEmail.getUserName() + "......target errorcode....." + backupTargetErrorCode);
    }

    private void createUsersExcelBlockFail(int cloudId, List<UserElement> userList) {
        if (!CollectionUtils.isEmpty(userList)) {
            try (XSSFWorkbook workbook = new XSSFWorkbook();){
                List<List> recordToAdd = this.updateUserElementValuesToExcelForBlockFail(userList);
                this.createExcelForUserXlsx(recordToAdd, workbook);
                this.writeExcelForUserXlsxForBlackFail(cloudId, workbook);
            }
            catch (Exception e) {
                logger.trace(EXCEPTION + String.valueOf(e));
                logger.error(EXCEPTION + e.getMessage());
            }
        }
    }

    private List<List> updateUserElementValuesToExcelForBlockFail(List<UserElement> userList) {
        ArrayList<List> recordToAdd = new ArrayList<List>();
        List<String> headerRow = this.createHeaderRowForUserXlsxForBlockFail();
        recordToAdd.add(headerRow);
        for (UserElement userElement : userList) {
            List<String> firstRow = this.loadDataOnRowForUserXlsxForBlackFail(userElement);
            recordToAdd.add(firstRow);
        }
        return recordToAdd;
    }

    List<String> createHeaderRowForUserXlsxForBlockFail() {
        ArrayList<String> headerRow = new ArrayList<String>();
        headerRow.add("Username");
        headerRow.add("Status");
        return headerRow;
    }

    List<String> loadDataOnRowForUserXlsxForBlackFail(UserElement userElement) {
        ArrayList<String> firstRow = new ArrayList<String>();
        firstRow.add(userElement.getUserName());
        if (!userElement.isLocalUser()) {
            firstRow.add("Not a Local User. Please remove from in AD or AAD group or Disable the user from AD or AAD");
        } else {
            firstRow.add(userElement.getStatus());
        }
        return firstRow;
    }

    void writeExcelForUserXlsxForBlackFail(int cloudId, XSSFWorkbook workbook) {
        try (FileOutputStream fos = new FileOutputStream(new File(this.registry.get(cloudId).getPropertyFileValueParacloudMountPoint() + "/reports/Users_Block_Fail.xlsx"));){
            XSSFCellStyle hsfstyle = workbook.createCellStyle();
            hsfstyle.setBorderBottom((short)1);
            hsfstyle.setFillBackgroundColor((short)245);
            workbook.write((OutputStream)fos);
            File f = new File(this.registry.get(cloudId).getPropertyFileValueParacloudMountPoint() + "/reports/Users_Block_Fail.xlsx");
            this.SetPermission(f, Paths.get(f.getAbsolutePath(), new String[0]));
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + String.valueOf(e));
            logger.error(EXCEPTION + e.getMessage());
        }
    }

    @Override
    public boolean mapODBIds(int cloudId, String userName, String odbId) {
        return this.userDao.updateODBId(cloudId, userName, odbId);
    }

    @Override
    public List<UserElement> loadAllUsersEmailIds(int cloudId) {
        List loadAllUsersEmailIds = this.userDao.loadAllUsersEmailIds(cloudId);
        ArrayList<UserElement> elements = new ArrayList<UserElement>();
        for (String emailId : loadAllUsersEmailIds) {
            UserElement element = new UserElement();
            element.setEmailId(emailId);
            elements.add(element);
        }
        return elements;
    }

    @Override
    public List<UserElement> getAllUnMapedUsers(int cloudId) {
        List userNames = this.userDao.getAllUnMapedUserNames(cloudId);
        ArrayList<UserElement> elements = new ArrayList<UserElement>();
        for (String emailId : userNames) {
            UserElement element = new UserElement();
            element.setUserName(emailId);
            elements.add(element);
        }
        return elements;
    }

    @Override
    public List<UserElement> searchUsersForReport(int cloudId, String userName) {
        ArrayList<UserElement> userElementList = new ArrayList<UserElement>();
        ArrayList<String> list = new ArrayList<String>(Arrays.asList(userName.split(",")));
        HashSet<String> removeSet = new HashSet<String>();
        removeSet.addAll(list);
        list.clear();
        list.addAll(removeSet);
        List users = this.userDao.searchUsersForReport(cloudId, list);
        for (User user : users) {
            if (user == null) continue;
            UserElement ue = new UserElement();
            BeanUtils.copyProperties((Object)user, (Object)ue);
            ue.setShareEnabled(user.isShareEnabled());
            userElementList.add(ue);
        }
        return userElementList;
    }

    @Override
    public List<User> getAllExchangeBkpEnabledUsers(int cloudId) {
        List users = this.userDao.getAllExchangeBkpEnabledUsers(cloudId);
        if (CollectionUtils.isEmpty((Collection)users)) {
            logger.debug("...no users found for odbBkp........");
            return new ArrayList<User>();
        }
        return users;
    }

    @Override
    public long countOfPresentBackupUsers(int cloudId, String cloudName, boolean active) {
        return this.userDao.countOfPresentBackupUsers(cloudId, cloudName, active, true);
    }

    @Override
    public long countOfPresentSyncUsers(int cloudId, String cloudName, boolean active) {
        return this.userDao.countOfPresentSyncUsers(cloudId, cloudName, active);
    }

    @Override
    public long countOfPresentODBBackupUsers(int cloudId, String cloudName, boolean active) {
        return this.userDao.countOfPresentODBBackupUsers(cloudId, cloudName, active);
    }

    @Override
    public OfficeBackupPolicy getOfficeBackupPolicy(int cloudId, String policyName) {
        return this.userDao.getOfficeBackupPolicyByPolicyName(cloudId, policyName);
    }

    @Override
    public long countOfPresentSite(int cloudId, boolean active) {
        return this.userDao.countOfPresentSite(cloudId, active);
    }

    @Override
    public User getSiteByName(int cloudId, String username) {
        return this.userDao.getSiteByName(cloudId, username);
    }

    @Override
    public List<UserElement> getAllSoftBlockUsers(int cloudId, int skipValue, User logedInUser) {
        List usersList = this.userDao.getAllSoftBlockUsers(cloudId, "", skipValue);
        logger.debug("Fetched {} soft-block users", (Object)usersList.size());
        List elements = usersList.stream().map(user -> {
            UserElement ue = new UserElement();
            BeanUtils.copyProperties((Object)user, (Object)ue);
            ue.setShareEnabled(user.isShareEnabled());
            return ue;
        }).collect(Collectors.toList());
        Set officeLegalHold = this.userDao.getAllLegalHoldOfficePolicies(cloudId).stream().filter(OfficeBackupPolicy::isLegalHoldEnabled).map(OfficeBackupPolicy::getPolicyName).collect(Collectors.toSet());
        Set backupLegalHold = this.userDao.getAllLegalHoldBackupPolicies(cloudId).stream().filter(BackupPolicy::isLegalHoldEnabled).map(Policy::getPolicyName).collect(Collectors.toSet());
        Set gmailLegalHold = this.userDao.getAllLegalHoldGmailBkpPolicies(cloudId).stream().filter(GmailBackupPolicy::isLegalHoldEnabled).map(GmailBackupPolicy::getPolicyName).collect(Collectors.toSet());
        ArrayList<UserElement> filtered = new ArrayList<UserElement>();
        for (UserElement userElement : elements) {
            if (userElement.isBackupEnabled() && backupLegalHold.contains(userElement.getPolicyName()) || userElement.isExchangeBkpEnabled() && officeLegalHold.contains(userElement.getExchangePolicyName()) || userElement.isOnedriveBkpEnabled() && officeLegalHold.contains(userElement.getOneDrivePolicyName()) || userElement.isSite() && officeLegalHold.contains(userElement.getSpPolicyName()) || userElement.isGmailBkpEnabled() && gmailLegalHold.contains(userElement.getGmailPolicyName()) || userElement.isGdriveBkpEnabled() && gmailLegalHold.contains(userElement.getGdrivePolicyName())) continue;
            filtered.add(userElement);
        }
        filtered.forEach(ue -> logger.debug("User: {}, BackupPolicy: {}, ExchangePolicy: {}, OneDrivePolicy: {}, SharePointPolicy: {}, GmailPolicy: {}, GDrivePolicy: {}", (Object)ue.getUserName(), (Object)ue.getPolicyName(), (Object)ue.getExchangePolicyName(), (Object)ue.getOneDrivePolicyName(), (Object)ue.getSpPolicyName(), (Object)ue.getGmailPolicyName(), (Object)ue.getGdrivePolicyName()));
        this.getValidUsers(logedInUser, filtered, false);
        return filtered;
    }

    @Override
    public boolean createExcelforSoftBlockUsers(int cloudId, User logedInUser) {
        List<UserElement> userList = this.getAllSoftBlockUsers(cloudId, 0, logedInUser);
        userList.removeAll(Collections.singleton(null));
        Collections.sort(userList, new Comparator<UserElement>(this){

            @Override
            public int compare(UserElement u1, UserElement u2) {
                if (u1 == null || u2 == null || u1.getUserName() == null || u2.getUserName() == null) {
                    return -1;
                }
                return new CompareToBuilder().append((Object)UserManagementServiceImpl.getStatus(u1.isActive()), (Object)UserManagementServiceImpl.getStatus(u2.isActive())).append((Object)u1.getUserName().toLowerCase(), (Object)u2.getUserName().toLowerCase()).toComparison();
            }
        });
        return this.createSoftBlockedUsersExcelForXlsx(cloudId, userList);
    }

    private static String getStatus(boolean val) {
        if (val) {
            return "Active";
        }
        return "Blocked";
    }

    @Override
    public long getAllSoftBlockUsersCount(int cloudId, List<String> policyNames) {
        return this.userDao.getAllSoftBlockUsersCount(cloudId, policyNames);
    }

    @Override
    public List<UserElement> getAllUsersForReadOnlyWithPagination(int cloudId, int pagNum, List<String> policyNames, List<String> syncPolicyNames, List<String> odbPolicyNames, List<String> gmailPolicyNames, List<String> gdrivePolicyNames, boolean isSite, String pagination) {
        ArrayList<UserElement> userElementList = new ArrayList<UserElement>();
        List usersList = this.userDao.getAllUsersForReadOnlyWithPagination(cloudId, policyNames, syncPolicyNames, odbPolicyNames, gmailPolicyNames, gdrivePolicyNames, pagNum, isSite, pagination);
        logger.debug(" user names list ... " + usersList.size());
        for (User user : usersList) {
            UserElement ue = new UserElement();
            BeanUtils.copyProperties((Object)user, (Object)ue);
            ue.setShareEnabled(user.isShareEnabled());
            if (!user.isGuest() && !user.isSuperAdmin()) {
                userElementList.add(ue);
            }
            ue.setPasswdHash(null);
            ue.setSecurityRecoveryKey(null);
            ue.setGoogleSecretKey(null);
            ue.setUserNameLowerCase(null);
            ue.setUserPrinicipalName(null);
            ue.setAzureUniqueId(null);
        }
        return userElementList;
    }

    @Override
    public List<BackupPolicy> getAllBackupPolicies(int cloudId) {
        return this.backupPolicyDao.getAllBackupPolicies(cloudId);
    }

    private String getDecryptePassword(String ldapPwdEnc) {
        String decryptedPwd = null;
        if (!StringUtils.isEmpty((CharSequence)ldapPwdEnc)) {
            try {
                decryptedPwd = this.decrypt(ldapPwdEnc, SECRET_KEY);
            }
            catch (Exception e) {
                logger.trace(EXCEPTION + String.valueOf(e));
                logger.error("ERROR in decryption ... " + e.getMessage());
                e.printStackTrace();
            }
        }
        return decryptedPwd;
    }

    public String decrypt(String encryptedPassword, String key) throws Exception {
        int ivSize = 16;
        int keySize = 16;
        logger.info(" encrypted password is " + encryptedPassword);
        byte[] payload = java.util.Base64.getDecoder().decode(encryptedPassword);
        byte[] iv = new byte[ivSize];
        System.arraycopy(payload, 0, iv, 0, iv.length);
        IvParameterSpec ivParameterSpec = new IvParameterSpec(iv);
        int encryptedSize = payload.length - ivSize;
        byte[] encryptedBytes = new byte[encryptedSize];
        System.arraycopy(payload, ivSize, encryptedBytes, 0, encryptedSize);
        byte[] keyBytes = new byte[keySize];
        MessageDigest md = MessageDigest.getInstance("MD5");
        md.update(key.getBytes());
        System.arraycopy(md.digest(), 0, keyBytes, 0, keyBytes.length);
        SecretKeySpec secretKeySpec = new SecretKeySpec(keyBytes, "AES");
        Cipher cipherDecrypt = Cipher.getInstance("AES/CBC/PKCS5Padding");
        cipherDecrypt.init(2, (Key)secretKeySpec, ivParameterSpec);
        byte[] decrypted = cipherDecrypt.doFinal(encryptedBytes);
        return new String(decrypted);
    }

    private String generaterandompswd() {
        String characters = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789@.";
        String pwd = RandomStringUtils.random((int)8, (String)characters);
        return pwd;
    }

    @Override
    public UserElement getUserElementByUserName(Cloud cloud, String userName) {
        UserElement usrElement = new UserElement();
        int cloudId = cloud.getCloudId();
        User user = this.userDao.getUserByUserName(cloudId, userName);
        if (user == null) {
            return null;
        }
        BeanUtils.copyProperties((Object)user, (Object)usrElement);
        return usrElement;
    }

    @Override
    public void autoDeviceDeleteBasedOnPolicy(Cloud cloud) {
        int cloudId = cloud.getCloudId();
        String cloudName = cloud.getCloudName();
        List allBlockedDevices = this.deviceDao.getAllBlockedNotDeletedDevices(cloudId);
        this.autodeleteDevicesBasedOnPolicy(cloud, cloudId, cloudName, allBlockedDevices);
    }

    private void autodeleteDevicesBasedOnPolicy(Cloud cloud, int cloudId, String cloudName, List<Device> allBlockedDevices) {
        for (Device device : allBlockedDevices) {
            long noOfDaysToKeepUserDeviceNotActive = 0L;
            User user = this.userDao.getUserByUserName(cloudId, device.getUserName());
            if (StringUtils.isEmpty((CharSequence)device.getDeviceType()) || device.getDeviceType().equalsIgnoreCase(CPHelperConstant.PARABLU_PRODUCT_TYPE.BACKUP.getProductType())) {
                if (!StringUtils.isEmpty((CharSequence)user.getPolicyName())) {
                    BackupPolicy backupPolicy = this.userDao.getBackupPolicyByPolicyName(cloudId, user.getPolicyName());
                    noOfDaysToKeepUserDeviceNotActive = backupPolicy.getNoOfDaysToKeepUserDeviceNotActive();
                }
            } else if (!StringUtils.isEmpty((CharSequence)device.getDeviceType()) && device.getDeviceType().equalsIgnoreCase("ONEDRIVE")) {
                if (!StringUtils.isEmpty((CharSequence)user.getOneDrivePolicyName())) {
                    OfficeBackupPolicy policy = this.userDao.getOfficeBackupPolicyByPolicyName(cloudId, user.getOneDrivePolicyName());
                    noOfDaysToKeepUserDeviceNotActive = policy.getNoOfDaysToKeepUserDeviceNotActive();
                }
            } else if (!StringUtils.isEmpty((CharSequence)device.getDeviceType()) && device.getDeviceType().equalsIgnoreCase("OUTLOOK")) {
                if (!StringUtils.isEmpty((CharSequence)user.getExchangePolicyName())) {
                    OfficeBackupPolicy policy = this.userDao.getOfficeBackupPolicyByPolicyName(cloudId, user.getExchangePolicyName());
                    noOfDaysToKeepUserDeviceNotActive = policy.getNoOfDaysToKeepUserDeviceNotActive();
                }
            } else if (!StringUtils.isEmpty((CharSequence)device.getDeviceType()) && device.getDeviceType().equalsIgnoreCase("SHAREPOINT")) {
                if (!StringUtils.isEmpty((CharSequence)user.getSpPolicyName())) {
                    OfficeBackupPolicy policy = this.userDao.getOfficeBackupPolicyByPolicyName(cloudId, user.getSpPolicyName());
                    noOfDaysToKeepUserDeviceNotActive = policy.getNoOfDaysToKeepUserDeviceNotActive();
                }
            } else if (!StringUtils.isEmpty((CharSequence)device.getDeviceType()) && device.getDeviceType().equalsIgnoreCase("GMAIL")) {
                if (!StringUtils.isEmpty((CharSequence)user.getGmailPolicyName())) {
                    GmailBackupPolicy policy = this.userDao.getGmailBackupPolicy(cloudId, user.getGmailPolicyName(), GmailBackupPolicy.TYPE.GMAIL.getProductType());
                    noOfDaysToKeepUserDeviceNotActive = policy.getNoOfDaysToKeepUserDeviceNotActive();
                }
            } else if (!StringUtils.isEmpty((CharSequence)device.getDeviceType()) && device.getDeviceType().equalsIgnoreCase("Google Drive") && !StringUtils.isEmpty((CharSequence)user.getGmailPolicyName())) {
                GmailBackupPolicy policy = this.userDao.getGmailBackupPolicy(cloudId, user.getGmailPolicyName(), GmailBackupPolicy.TYPE.GOOGLEDRIVE.getProductType());
                noOfDaysToKeepUserDeviceNotActive = policy.getNoOfDaysToKeepUserDeviceNotActive();
            }
            if (noOfDaysToKeepUserDeviceNotActive == 0L || noOfDaysToKeepUserDeviceNotActive == -1L) continue;
            logger.info("deviceUUID selected ForDelete->" + device.getDeviceUUID());
            long noOfDays = device.getLastModifiedTimestamp();
            long diff = System.currentTimeMillis() - noOfDays;
            long days = TimeUnit.DAYS.convert(diff, TimeUnit.MILLISECONDS);
            if (days < noOfDaysToKeepUserDeviceNotActive) continue;
            device.setBlocked(true);
            device.setDeleted(true);
            this.deviceDao.updatedeviceInfoInDeviceBkpOverview(cloudId, device);
            this.deviceDao.updateDeviceInfo(cloudId, cloudName, device);
            if (!StringUtils.isEmpty((CharSequence)device.getDeviceType()) && device.getDeviceType().equalsIgnoreCase("SHAREPOINT")) {
                user.setActive(false);
                user.setDeleted(true);
                this.userDao.updateUser(cloudId, cloudName, user);
                this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudName, "deleted a SharePoint Online site: " + device.getDeviceName() + " of User:", "AUTO", user.getUserName(), "automatic site-aging", System.currentTimeMillis(), PCActionTypes.AUTOMATIC_USER_AGING.getActionTypeValue());
                this.sendEmailSP(cloud, "auto-site-deleted", device.getUserName(), "automatic asset-aging", cloudName, noOfDaysToKeepUserDeviceNotActive);
                continue;
            }
            this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudName, "deleted asset:" + device.getDeviceName() + " of User:", "AUTO", user.getUserName(), "automatic asset-aging", System.currentTimeMillis(), PCActionTypes.AUTOMATIC_USER_AGING.getActionTypeValue());
            this.sendEmail(cloud, "auto-device-deleted", "automatic asset-aging", device.getUserName(), device.getDeviceName(), user, noOfDaysToKeepUserDeviceNotActive, cloudName);
            logger.info("calling unified with cloudName -->" + cloudName);
            DeleteDto deleteDto = new DeleteDto();
            deleteDto.setDeviceUUID(device.getDeviceUUID());
            deleteDto.setHost(cloudName + ".parablu.com");
            deleteDto.setUserName(device.getUserName());
            deleteDto.setCloudName(cloudName);
            deleteDto.setType(DeleteDto.TYPE.DEVICE);
            this.dataAgingService.deleteDetailsFromUserAndDevice(cloudId, deleteDto);
        }
    }

    @Override
    public void autoDeleteUser(Cloud cloud) {
        int cloudId = cloud.getCloudId();
        String cloudName = cloud.getCloudName();
        List allUsers = this.userDao.getAllUsers(cloudId, cloudName, false);
        CloudProperties cloudProperties = this.cloudDao.getCloudProperties(cloudId);
        String autoExpireUsers = cloudProperties.getAutoExpireUsers();
        boolean autoExpireFeautreDisabled = false;
        if (StringUtils.isEmpty((CharSequence)autoExpireUsers) || "DISABLED".equals(autoExpireUsers)) {
            autoExpireFeautreDisabled = true;
        }
        if (!autoExpireFeautreDisabled) {
            boolean expireAllUsers = false;
            boolean expireLocalUsers = false;
            if (!StringUtils.isEmpty((CharSequence)autoExpireUsers)) {
                if ("ALL USERS".equals(autoExpireUsers)) {
                    expireAllUsers = true;
                }
                if ("LOCAL USERS".equals(autoExpireUsers)) {
                    expireLocalUsers = true;
                }
            }
            for (User user : allUsers) {
                long diff;
                long days;
                String autoExpireType = user.getAutoExpireType();
                boolean autoExpireTypeDisabled = false;
                if (StringUtils.isEmpty((CharSequence)autoExpireType) || "DISABLED".equals(autoExpireType)) {
                    autoExpireTypeDisabled = true;
                }
                if (autoExpireTypeDisabled || expireLocalUsers && !user.isLocalUser() || user.getNoOfDaysForAutoBlock() <= 0L) continue;
                long noOfDays = 0L;
                if (StringUtils.isEmpty((CharSequence)user.getLastLoggedInTime())) {
                    user.setLastLoggedInTime(user.getCreatedTimestamp());
                }
                if ("EXPIRE_CREATED_TIME".equals(autoExpireType) && !StringUtils.isEmpty((CharSequence)user.getCreatedTimestamp())) {
                    noOfDays = Long.parseLong(user.getCreatedTimestamp());
                }
                if ("EXPIRE_IDLE_TIME".equals(autoExpireType) && !StringUtils.isEmpty((CharSequence)user.getLastLoggedInTime())) {
                    noOfDays = Long.parseLong(user.getLastLoggedInTime());
                }
                if ((days = TimeUnit.DAYS.convert(diff = System.currentTimeMillis() - noOfDays, TimeUnit.MILLISECONDS)) < user.getNoOfDaysForAutoBlock()) continue;
                logger.debug(user.getUserName() + "...userabout to delete.." + user.getNoOfDaysForAutoBlock() + "...created date more than days ..." + days);
                if (!user.isActive()) continue;
                user.setActive(false);
                this.userDao.saveUser(cloud.getCloudId(), cloud.getCloudName(), user);
                this.saveStatisticToDatabase(cloud, "Blocked", "AUTO", user.getUserName(), "automatic user-aging", System.currentTimeMillis(), PCActionTypes.AUTOMATIC_USER_AGING.getActionTypeValue());
            }
        }
    }

    @Override
    public void autoBlockSoftBlockedUsers(Cloud cloud) {
        int cloudId = cloud.getCloudId();
        String cloudName = cloud.getCloudName();
        List allSoftBlockedUsers = this.userDao.getAllSoftBlockUsers(cloudId, null, 0);
        CloudProperties cloudProperties = this.cloudDao.getCloudProperties(cloudId);
        boolean autoBlockSoftBlockedUsers = cloudProperties.isAutoBlockSoftBlockedUsers();
        int noOfDays = cloudProperties.getDaysToBlockSoftBlockedUsers();
        if (autoBlockSoftBlockedUsers && noOfDays > 0) {
            for (User user : allSoftBlockedUsers) {
                long diff;
                long days;
                if (user.getSoftBlockedTime() <= 0L || (days = TimeUnit.DAYS.convert(diff = System.currentTimeMillis() - user.getSoftBlockedTime(), TimeUnit.MILLISECONDS)) < (long)noOfDays) continue;
                logger.debug(user.getUserName() + "...user about to block.....soft block happened time  ..." + user.getSoftBlockedTime());
                if (!user.isActive()) continue;
                user.setActive(false);
                user.setSoftBlockEnabled(false);
                this.userDao.saveUser(cloudId, cloudName, user);
                this.saveStatisticToDatabase(cloud, "Blocked", "AUTO", user.getUserName(), "Auto Block-softBlocked Users", System.currentTimeMillis(), PCActionTypes.AUTOMATIC_USER_AGING.getActionTypeValue());
                this.multipleUserBlockOrDeleteMail(cloud, cloudName, cloudId, "Auto block", user.getUserName(), user.getEmailId(), "user-blocked");
                List<Device> blockedDevices = this.blockUnblockDevicebyUserName(cloudId, cloudName, user.getUserName(), true);
                if (blockedDevices == null) continue;
                for (Device device : blockedDevices) {
                    this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudName, "blocked Asset:" + device.getDeviceName() + " of User:", "AUTO", user.getUserName(), "Portal", System.currentTimeMillis(), PCActionTypes.DEVICE_BLOCK.getActionTypeValue());
                }
            }
        }
    }

    @Override
    public void updateTargetStatus(int cloudId, boolean targetAssigned, int backupTargetErrorCode, String userName) {
        this.userDao.updateTargetStatus(cloudId, targetAssigned, backupTargetErrorCode, userName);
    }

    @Override
    public long countOfPresentOnedriveUsers(int cloudId, boolean active) {
        return this.userDao.countOfPresentOnedriveUsers(cloudId, active);
    }

    @Override
    public long countOfPresentExchangeUsers(int cloudId, boolean active) {
        return this.userDao.countOfPresentExchangeUsers(cloudId, active);
    }

    @Override
    public List<UserElement> getAllBlockedUsers(int cloudId) {
        List blockedUsers = this.userDao.getAllBlockedUsers(cloudId);
        ArrayList<UserElement> blockedUserElements = new ArrayList<UserElement>();
        for (User blockedadmin : blockedUsers) {
            UserElement ue = new UserElement();
            BeanUtils.copyProperties((Object)blockedadmin, (Object)ue);
            blockedUserElements.add(ue);
        }
        return blockedUserElements;
    }

    @Override
    public List<UserElement> getAllReadOnlyAdmins(int cloudId) {
        List readOnlyAdmins = this.userDao.getAllReadOnlyAdmins(cloudId);
        ArrayList<UserElement> readOnlyAdminsElements = new ArrayList<UserElement>();
        for (User readOnlyadmin : readOnlyAdmins) {
            UserElement ue = new UserElement();
            BeanUtils.copyProperties((Object)readOnlyadmin, (Object)ue);
            BackupPoliciesAdminList backupPoliciesAdminList = new BackupPoliciesAdminList();
            ArrayList<String> backupPoliciesAdmin = new ArrayList<String>();
            for (String pn : readOnlyadmin.getBackupPoliciesAdmin()) {
                backupPoliciesAdmin.add(pn);
            }
            backupPoliciesAdminList.setBackupPoliciesAdmin(backupPoliciesAdmin);
            readOnlyAdminsElements.add(ue);
        }
        return readOnlyAdminsElements;
    }

    @Override
    public List<User> getExistingSites(int cloudId) {
        return this.userDao.getExistingSites(cloudId);
    }

    @Override
    public void createSite(int cloudId, User site) {
        this.userDao.createSite(cloudId, site);
    }

    @Override
    public User getUserBySiteId(int cloudId, String siteId) {
        return this.userDao.getUserBySiteId(cloudId, siteId);
    }

    @Override
    public List<User> getSitesWithoutDevices(int cloudId) {
        ArrayList<User> usersWithoutDrive = new ArrayList<User>();
        SharePointProperties spPointProperties = this.userDao.getSPProperties(cloudId);
        if (spPointProperties != null && spPointProperties.isAutoMigrationEnabled()) {
            List users = this.userDao.getExistingSites(cloudId);
            if (CollectionUtils.isEmpty((Collection)users)) {
                logger.debug("...no user sitesfound for sharepoint........");
                return new ArrayList<User>();
            }
            for (User user : users) {
                Device device = this.deviceDao.getSPDeviceforUser(cloudId, user.getUserName());
                if (device != null) continue;
                usersWithoutDrive.add(user);
            }
        }
        return usersWithoutDrive;
    }

    @Override
    public List<UserElement> getExistingSites(int cloudId, int skipValue) {
        List userSites = this.userDao.getActiveSPSites(cloudId);
        HashMap<String, String> userSiteMap = new HashMap<String, String>();
        HashSet<String> existingSites = new HashSet<String>();
        for (User user : userSites) {
            existingSites.add(user.getUserName());
            userSiteMap.put(user.getUserName(), user.getSpPolicyName());
        }
        List discoveredSites = this.userDao.getExistingSites(cloudId);
        ArrayList<User> userList = new ArrayList<User>();
        HashSet<String> existingDiscoveredSites = new HashSet<String>();
        for (User user : discoveredSites) {
            if (!existingSites.contains(user.getUserName())) continue;
            existingDiscoveredSites.add(user.getUserName());
            userList.add(user);
        }
        ArrayList<UserElement> elements = new ArrayList<UserElement>();
        for (User user : userList) {
            UserElement ue = new UserElement();
            BeanUtils.copyProperties((Object)user, (Object)ue);
            elements.add(ue);
        }
        return elements;
    }

    @Override
    public void updateSiteMapping(int cloudId, SiteElement siteElement, String loggedInuserName) {
        Map siteMap = siteElement.getSiteMap();
        List clouds = this.cloudDao.getAllClouds();
        for (Map.Entry entry : siteMap.entrySet()) {
            logger.debug("...site to be updated...." + (String)entry.getKey() + "..." + (String)entry.getValue());
            this.userDao.updateSiteMapping(cloudId, (String)entry.getKey(), (String)entry.getValue());
            this.saveStatisticToDatabase(cloudId, "", "assigned " + (String)entry.getValue() + "(SharePoint Online) Policy to ", loggedInuserName, (String)entry.getKey() + "SharePoint Online", PCActionTypes.CHANGE_BACKUP_POLICY.getActionTypeValue());
        }
    }

    @Override
    public void saveStatisticToDatabase(int cloudId, String cloudName, String action, String actionByUser, String actionOnUser, int actionType) {
        AuditHistory audit = new AuditHistory();
        audit.setAction(action);
        audit.setActionByUserName(actionByUser);
        audit.setActionOnObject(actionOnUser);
        audit.setTimestamp(System.currentTimeMillis());
        audit.setActionUsingObject("Portal");
        audit.setActionType(actionType);
        this.auditHistoryDao.saveAudit(cloudId, cloudName, audit);
    }

    public int validateSPUserRestrictions(int cloudId, Cloud cloud) {
        if ((long)cloud.getNoOfSPSitesAllowed() <= this.userDao.countOfPresentSite(cloudId, true)) {
            return 1536;
        }
        return 1500;
    }

    @Override
    public int validateExchangeUserRestrictions(int cloudId, Cloud cloud) {
        if ((long)cloud.getNoOfExchangeUsersAllowed() <= this.userDao.countOfPresentExchangeUsers(cloudId, true)) {
            return 1536;
        }
        return 1500;
    }

    @Override
    public int validateODBUserRestrictions(int cloudId, Cloud cloud) {
        if ((long)cloud.getNoOfOneDriveUsersAllowed() <= this.userDao.countOfPresentOnedriveUsers(cloudId, true)) {
            return 1536;
        }
        return 1500;
    }

    @Override
    public int createUserSite(int cloudId, SiteElement siteElement, String loggedInuserName) {
        int erroCode = 0;
        Map siteMap = siteElement.getSiteMap();
        List clouds = this.cloudDao.getAllClouds();
        Cloud cloud = (Cloud)clouds.get(0);
        boolean emptyExists = false;
        logger.debug("...gson element...." + new Gson().toJson((Object)siteElement));
        for (Map.Entry entry : siteMap.entrySet()) {
            logger.debug((String)entry.getValue() + "...user..name...." + (String)entry.getKey());
            if ("empty".equalsIgnoreCase((String)entry.getKey())) continue;
            User siteByName = this.userDao.getSiteByName(cloudId, (String)entry.getKey());
            if (siteByName != null) {
                logger.debug("..site already exists...." + (String)entry.getKey());
                if (siteByName.getSpPolicyName().equalsIgnoreCase((String)entry.getValue())) continue;
                this.userDao.updateSiteMapping(cloudId, (String)entry.getKey(), (String)entry.getValue());
                this.saveStatisticToDatabase(cloudId, "", "assigned " + (String)entry.getValue() + " Policy to ", loggedInuserName, (String)entry.getKey(), PCActionTypes.CHANGE_BACKUP_POLICY.getActionTypeValue());
                erroCode = 200;
                continue;
            }
            String policyName = (String)entry.getValue();
            int code = this.validateSPUserRestrictions(cloudId, cloud);
            logger.debug("...trying to validate users ... " + code);
            if (code == 1536) {
                logger.error("...unable to create site for policy..." + siteElement.getPolicyName());
                this.userDao.saveSPProperties(cloudId, siteElement);
                return code;
            }
            User user = this.userDao.createUserSite(cloudId, (String)entry.getKey(), policyName);
            DeviceElement deviceElement = new DeviceElement();
            String deviceUUID = MD5Generator.generateMD5OfString((String)user.getSiteId());
            deviceElement.setDeviceUUID(deviceUUID);
            String deviceName = (String)entry.getKey() + " (Microsoft SharePoint)";
            deviceElement.setDeviceName(deviceName);
            deviceElement.setUserName(user.getUserName());
            boolean isDeviceRegistered = this.deviceManagementService.registerSharepointBkpDevice(cloud, deviceElement, loggedInuserName);
            this.deviceManagementService.saveStatisticToDatabase(cloud.getCloudId(), cloud.getCloudName(), " registered a SharePoint Online site ", loggedInuserName, user.getUserName(), "Portal", System.currentTimeMillis(), PCActionTypes.LOGIN.getActionTypeValue());
            erroCode = 200;
        }
        this.userDao.saveSPProperties(cloudId, siteElement);
        if (CollectionUtils.isEmpty((Map)siteMap)) {
            erroCode = 200;
        }
        return erroCode;
    }

    @Override
    public List<UserElement> getAllUsersIncludingGuest(int cloudId, String cloudName) {
        ArrayList<UserElement> userElementList = new ArrayList<UserElement>();
        List usersList = this.userDao.getAllUsers(cloudId, cloudName);
        for (User user : usersList) {
            if (user == null) continue;
            UserElement ue = new UserElement();
            BeanUtils.copyProperties((Object)user, (Object)ue);
            ue.setShareEnabled(user.isShareEnabled());
            BackupPoliciesAdminList backupPolicyList = new BackupPoliciesAdminList();
            if (user.getBackupPoliciesAdmin() != null) {
                backupPolicyList.setBackupPoliciesAdmin(user.getBackupPoliciesAdmin());
                ue.setBackupPoliciesAdminList(backupPolicyList);
            }
            SyncPoliciesAdminList syncPolicyList = new SyncPoliciesAdminList();
            if (user.getSyncPoliciesAdmin() != null) {
                syncPolicyList.setSyncPoliciesAdmin(user.getSyncPoliciesAdmin());
                ue.setSyncPoliciesAdminList(syncPolicyList);
            }
            ue.setUserId(user.getUserId());
            userElementList.add(ue);
        }
        return userElementList;
    }

    @Override
    public void removeUserbyID(int cloudId, String userId) {
        this.userDao.removeUserbyID(cloudId, userId);
    }

    @Override
    public List<User> getActiveOneDriveUsers(int cloudId) {
        return this.userDao.getActiveOneDriveUsers(cloudId);
    }

    @Override
    public List<User> getActiveExchangeUsers(int cloudId) {
        return this.userDao.getActiveExchangeUsers(cloudId);
    }

    @Override
    public List<DeviceBackupOverView> getAllOverviewsBasedOnProductType(int cloudId, String productType) {
        return this.deviceDao.getAllOverviewsBasedOnProductType(cloudId, productType);
    }

    @Override
    public void blockOrUnblockUser(int cloudId, String userName, boolean active, boolean isMSPEnv) {
        this.userDao.blockOrUnblockUser(cloudId, userName, active, isMSPEnv);
    }

    @Override
    public void updateUserStatusInDeviceBkpOverview(int cloudId, String userName, Boolean isActive) {
        this.deviceDao.updateUserStatusInDeviceBkpOverview(cloudId, userName, isActive);
    }

    @Override
    public UserElement getUserByUserNameOrEmail(int cloudId, String userName) {
        UserElement usrElement = new UserElement();
        User user = this.userDao.getUserByUserNameOrEmail(cloudId, userName);
        if (user == null) {
            user = this.userDao.getUserByUserNameOrAADLoginId(cloudId, userName);
        }
        if (user != null) {
            BeanUtils.copyProperties((Object)user, (Object)usrElement);
        }
        return usrElement;
    }

    @Override
    public SiteElement getExistingSiteElement(int cloudId) {
        List userSites = this.userDao.getAllSPSites(cloudId);
        HashMap<String, String> userSiteMap = new HashMap<String, String>();
        HashSet<String> existingSites = new HashSet<String>();
        HashSet<String> blockedSites = new HashSet<String>();
        for (User user : userSites) {
            existingSites.add(user.getUserName());
            if (!user.isActive()) {
                blockedSites.add(user.getUserName());
            }
            userSiteMap.put(user.getUserName(), user.getSpPolicyName());
            logger.debug("...user and pol...." + user.getUserName() + ".." + user.getSpPolicyName());
        }
        List discoveredSites = this.userDao.getExistingSites(cloudId);
        HashSet<String> existingDiscoveredSites = new HashSet<String>();
        for (User user : discoveredSites) {
            if (existingSites.contains(user.getUserName())) continue;
            existingDiscoveredSites.add(user.getUserName());
            logger.debug("...existing..." + user.getUserName());
        }
        existingDiscoveredSites.removeAll(blockedSites);
        ArrayList existSites = new ArrayList(existingDiscoveredSites);
        SiteElement siteElement = new SiteElement();
        SharePointProperties spProperties = this.userDao.getSPProperties(cloudId);
        if (spProperties != null) {
            siteElement.setAutoMigrationEnabled(spProperties.isAutoMigrationEnabled());
            siteElement.setPolicyName(spProperties.getDefaultSPPolicyName());
            siteElement.setSiteMap(userSiteMap);
        }
        siteElement.setDiscoveredSites(existSites);
        return siteElement;
    }

    @Override
    public SharePointProperties getSharePointProperties(int cloudId) {
        SharePointProperties spPointProperties = this.userDao.getSPProperties(cloudId);
        return spPointProperties;
    }

    @Override
    public boolean checkIfMspEnvironment(String cloudName) {
        boolean isMSPEnvEnabled = false;
        List cloudCustomisableDetails = this.cloudDao.getCloudCustomisableDetails(cloudName);
        if (cloudCustomisableDetails != null && cloudCustomisableDetails.size() > 0) {
            logger.debug("process=Iterating through the cloudCustomisableDetails to check if MSP license is enabled");
            for (CloudCustomisableDetails cloudCustomisableDetail : cloudCustomisableDetails) {
                if (!MSP_LICENSE.equals(cloudCustomisableDetail.getName())) continue;
                isMSPEnvEnabled = true;
                break;
            }
        }
        return isMSPEnvEnabled;
    }

    @Override
    public void deleteSPToken(int cloudId, String siteId) {
        this.userDao.deleteSPToken(cloudId, siteId);
    }

    public void deleteODToken(int cloudId, String deviceUUID) {
        this.deviceDao.deleteODToken(cloudId, deviceUUID);
    }

    private String findUserDiff(User existingUserDetails, User updatedUserDetails) {
        logger.debug("process=checking the user changed fields");
        StringBuilder changedFields = new StringBuilder();
        ObjectDiffFinder objectDiffFinder = new ObjectDiffFinder();
        objectDiffFinder.finder((Object)existingUserDetails, (Object)updatedUserDetails);
        objectDiffFinder.visiter(objectDiffFinder);
        ArrayList changes = new ArrayList(objectDiffFinder.changes);
        HashMap<String, Object> fieldChanges = new HashMap<String, Object>();
        for (Map change : changes) {
            Set keys = change.keySet();
            String propertyName = "";
            String newValue = "";
            String oldValue = "";
            for (String key : keys) {
                if (!org.springframework.util.StringUtils.isEmpty(change.get(key)) && key.contains("newValue")) {
                    newValue = change.get(key).toString();
                }
                if (key.contains("propertyName")) {
                    propertyName = change.get(key).toString();
                }
                if (org.springframework.util.StringUtils.isEmpty(change.get(key)) || !key.contains("oldValue")) continue;
                oldValue = change.get(key).toString();
            }
            if (!StringUtils.isEmpty((CharSequence)propertyName)) {
                if (StringUtils.isEmpty((CharSequence)oldValue) && StringUtils.isEmpty((CharSequence)newValue)) {
                    logger.debug("oldValue and newValue both are empty.....");
                    continue;
                }
                if (propertyName.startsWith("/")) {
                    propertyName = propertyName.replaceFirst("/", "");
                }
                fieldChanges.put(propertyName, "\"" + oldValue + "\" => \"" + newValue + "\"");
                logger.debug("Actual Data" + propertyName + "\"" + oldValue + "\" => \"" + newValue + "\"");
                continue;
            }
            logger.debug("field changes is empty ");
        }
        if (existingUserDetails.isAdmin() && !updatedUserDetails.isAdmin() && !updatedUserDetails.isDelegatedAdmin() && !updatedUserDetails.isReadOnlyAdmin()) {
            fieldChanges.put(ACCOUNT_TYPE, "\"Admin\" => \"User\"");
        } else if (existingUserDetails.isAdmin() && !updatedUserDetails.isAdmin() && updatedUserDetails.isDelegatedAdmin() && updatedUserDetails.isReadOnlyAdmin()) {
            fieldChanges.put(ACCOUNT_TYPE, "\"Admin\" => \"Read Only Admin\"");
        } else if (existingUserDetails.isAdmin() && !updatedUserDetails.isAdmin() && !updatedUserDetails.isDelegatedAdmin() && updatedUserDetails.isReadOnlyAdmin()) {
            fieldChanges.put(ACCOUNT_TYPE, "\"Admin\" => \"Delegated Administrator\"");
        } else if (!existingUserDetails.isAdmin() && !existingUserDetails.isDelegatedAdmin() && !existingUserDetails.isReadOnlyAdmin() && updatedUserDetails.isAdmin()) {
            fieldChanges.put(ACCOUNT_TYPE, "\"User\" => \"Admin\"");
        } else if (!existingUserDetails.isAdmin() && existingUserDetails.isDelegatedAdmin() && existingUserDetails.isReadOnlyAdmin() && updatedUserDetails.isAdmin()) {
            fieldChanges.put(ACCOUNT_TYPE, "\"Read Only Admin\" => \"Admin\"");
        } else if (!existingUserDetails.isAdmin() && !existingUserDetails.isDelegatedAdmin() && existingUserDetails.isReadOnlyAdmin() && updatedUserDetails.isAdmin()) {
            fieldChanges.put(ACCOUNT_TYPE, "\"Delegated Administrator\" => \"Admin\"");
        } else if (!existingUserDetails.isAdmin() && !existingUserDetails.isDelegatedAdmin() && existingUserDetails.isReadOnlyAdmin() && !updatedUserDetails.isAdmin() && updatedUserDetails.isDelegatedAdmin() && updatedUserDetails.isReadOnlyAdmin()) {
            fieldChanges.put(ACCOUNT_TYPE, "\"Delegated Administrator\" => \"Read Only Admin\"");
        } else if (!(existingUserDetails.isAdmin() || existingUserDetails.isDelegatedAdmin() || !existingUserDetails.isReadOnlyAdmin() || updatedUserDetails.isAdmin() || updatedUserDetails.isDelegatedAdmin() || updatedUserDetails.isReadOnlyAdmin())) {
            fieldChanges.put(ACCOUNT_TYPE, "\"Delegated Administrator\" => \"User\"");
        } else if (!existingUserDetails.isAdmin() && !existingUserDetails.isDelegatedAdmin() && !existingUserDetails.isReadOnlyAdmin() && !updatedUserDetails.isAdmin() && updatedUserDetails.isDelegatedAdmin() && updatedUserDetails.isReadOnlyAdmin()) {
            fieldChanges.put(ACCOUNT_TYPE, "\"User\" => \"Read Only Admin\"");
        } else if (!(existingUserDetails.isAdmin() || existingUserDetails.isDelegatedAdmin() || existingUserDetails.isReadOnlyAdmin() || updatedUserDetails.isAdmin() || updatedUserDetails.isDelegatedAdmin() || !updatedUserDetails.isReadOnlyAdmin())) {
            fieldChanges.put(ACCOUNT_TYPE, "\"User\" => \"Delegated Administrator\"");
        } else if (!existingUserDetails.isAdmin() && existingUserDetails.isDelegatedAdmin() && existingUserDetails.isReadOnlyAdmin() && !updatedUserDetails.isAdmin() && !updatedUserDetails.isDelegatedAdmin() && !updatedUserDetails.isReadOnlyAdmin()) {
            fieldChanges.put(ACCOUNT_TYPE, "\"Read Only Admin\" => \"User\"");
        } else if (!existingUserDetails.isAdmin() && existingUserDetails.isDelegatedAdmin() && existingUserDetails.isReadOnlyAdmin() && !updatedUserDetails.isAdmin() && !updatedUserDetails.isDelegatedAdmin() && updatedUserDetails.isReadOnlyAdmin()) {
            fieldChanges.put(ACCOUNT_TYPE, "\"Read Only Admin\" => \"Delegated Administrator\"");
        }
        for (String field : fieldChanges.keySet()) {
            String key = field;
            key = key.contains("displayName") ? "Display name" : (key.contains("exchangeBkpEnabled") ? "Microsoft Exchange Backup" : (key.contains("onedriveBkpEnabled") ? "OneDrive for Business Backup" : (key.contains("sharePointBkpEnabled") ? "SharePoint Online Backup" : (key.contains("syncEnabled") ? "BluSync" : (key.contains("backupEnabled") ? "Backup" : (key.contains("spPolicyName") ? "SharePoint Online Policy Name" : (key.contains("exchangePolicyName") ? "Microsoft Exchange Policy Name" : (key.contains("oneDrivePolicyName") ? "OneDrive for Business Policy Name" : (key.contains("policyName") ? "Backup Policy Name" : (key.contains("syncPolicyName") ? "BluSync Policy Name" : (key.contains("department") ? "Department" : (key.contains("location") ? "Location" : (key.contains("emailId") ? "Email Address" : (key.contains(ACCOUNT_TYPE) ? "Account Type" : (key.equals("odbPoliciesAdmin") ? "Manage Office 365 Policies" : "")))))))))))))));
            if (!StringUtils.isEmpty((CharSequence)key)) {
                fieldChanges.get(field);
                changedFields.append(" (");
                changedFields.append(key);
                changedFields.append(" values ");
                changedFields.append((String)fieldChanges.get(field));
                changedFields.append(")");
                if (key.length() > 1) {
                    changedFields.append(", ");
                }
                logger.debug("changed fields are = " + changedFields.toString());
                continue;
            }
            logger.debug("Key is Empty for field change");
        }
        if (changedFields.length() > 0) {
            changedFields.replace(changedFields.length() - 1, changedFields.length(), " ");
        }
        String changedfield = changedFields.toString().replace("true", "enabled").replace("false", "disabled");
        logger.debug("the changed fields are " + changedfield);
        return changedfield;
    }

    public void deleteMailToken(int cloudId, String userName) {
        this.userDao.deleteMailToken(cloudId, userName);
    }

    @Override
    public List<User> getAllUsersByPolicyNames(int cloudId, List<String> policyNames, String productType) {
        return this.userDao.getAllUsersByPolicyNames(cloudId, policyNames, productType);
    }

    @Override
    public List<User> getAllUsersForProductType(int cloudId, String productType) {
        return this.userDao.getAllUsersForProductType(cloudId, productType);
    }

    @Override
    public List<User> getAllDelegatedAdmins(int cloudId, String cloudName) {
        return this.userDao.getAllDelegatedAdmins(cloudId, cloudName);
    }

    @Override
    public String getDelegatedAdminMailForUser(Cloud cloud, UserElement userElement) {
        if (null != userElement && StringUtils.isNotEmpty((CharSequence)userElement.getPolicyName()) && StringUtils.isNotEmpty((CharSequence)userElement.getUserName()) && !userElement.isAdmin() && !userElement.isReadOnlyAdmin() && !userElement.isDelegatedAdmin()) {
            logger.debug("user={} whose policyName is {}", (Object)userElement.getUserName(), (Object)userElement.getPolicyName());
            ArrayList<String> policyNames = new ArrayList<String>();
            policyNames.add(userElement.getPolicyName());
            List delegatedAdmins = this.userDao.getAllReadOnlyAdminsForPolicyName(cloud.getCloudId(), policyNames);
            if (null != delegatedAdmins && delegatedAdmins.size() > 0) {
                return ((User)delegatedAdmins.get(0)).getEmailId();
            }
        }
        return null;
    }

    @Override
    public List<String> filterPolicyNameByProductType(int cloudId, String cloudName, List<String> policyNames, String policyType) {
        List backupPolicies = new ArrayList();
        backupPolicies = this.backupPolicyDao.getAllBackupPoliciesByPagination(cloudId, policyNames, 0);
        return backupPolicies.stream().filter(policy -> policyType.equalsIgnoreCase(policy.getPolicyType())).map(Policy::getPolicyName).collect(Collectors.toList());
    }

    @Override
    public void sendServerDeviceBlockDeleteEmail(Cloud cloud, String action, String currentUserName, User user, String deviceName) {
        EmailProps email = new EmailProps();
        email.setAction(action);
        email.setActionOnUserType(User.TYPE.SERVER.toString());
        email.setActionBy(currentUserName);
        email.setActionOn(user.getUserName());
        email.setStartDate(DateUtil.getDateInddMMMyyyy((long)System.currentTimeMillis()));
        email.setDeviceName(deviceName);
        ArrayList<EmailRecipent> emailRecipents = new ArrayList<EmailRecipent>();
        EmailRecipent emailRecipent = new EmailRecipent();
        emailRecipent.setUserName(user.getUserName());
        emailRecipent.setEmail(user.getEmailId());
        emailRecipents.add(emailRecipent);
        email.setRecipents(emailRecipents);
        this.cloudMailService.sendMail(cloud, email);
    }

    @Override
    public List<User> getAllReadOnlyAdminsForPolicyName(int cloudId, List<String> policyNames) {
        return this.userDao.getAllReadOnlyAdminsForPolicyName(cloudId, policyNames);
    }

    private void sendEmail(Cloud cloud, String action, String currentUserName, String userName, String deviceName, User user, long noOfDays, String cloudName) {
        EmailProps email = new EmailProps();
        email.setAction(action);
        email.setActionBy(currentUserName);
        email.setActionOn(userName);
        email.setStartDate(DateUtil.getDateInddMMMyyyy((long)System.currentTimeMillis()));
        email.setDeviceName(deviceName);
        email.setNoOfDays(noOfDays);
        ArrayList<EmailRecipent> emailRecipents = new ArrayList<EmailRecipent>();
        EmailRecipent emailRecipent = new EmailRecipent();
        emailRecipent.setUserName(user.getUserName());
        emailRecipent.setEmail(user.getEmailId());
        emailRecipents.add(emailRecipent);
        email.setRecipents(emailRecipents);
        email.setCloudName(cloudName);
        this.cloudMailService.sendMail(cloud, email);
    }

    private void sendEmailSP(Cloud cloud, String action, String siteName, String userName, String cloudName, long noOfDays) {
        EmailProps email = new EmailProps();
        ArrayList<EmailRecipent> emailRecipents = new ArrayList<EmailRecipent>();
        email.setAction(action);
        EmailRecipent emailRecipent = new EmailRecipent();
        try {
            List<User> allAdmins = this.getAllAdmins(1, "");
            for (User adminUser : allAdmins) {
                emailRecipent = new EmailRecipent();
                emailRecipent.setUserName(adminUser.getUserName());
                emailRecipent.setEmail(adminUser.getEmailId());
                emailRecipents.add(emailRecipent);
                logger.debug("...admin...." + adminUser.getUserName());
            }
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + String.valueOf(e));
            logger.error(EXCEPTION + e.getMessage());
        }
        logger.debug("Toatal email recipents count...:" + emailRecipents.size());
        email.setActionBy(userName);
        email.setRecipents(emailRecipents);
        email.setUserName(siteName);
        email.setToUser(true);
        email.setToAdmins(true);
        email.setCloudName(cloudName);
        email.setNoOfDays(noOfDays);
        this.cloudMailService.sendMail(cloud, email);
    }

    private GmailBackupPolicyElement getGmailBackupPolicyElement(int cloudId, GmailBackupPolicy backupPolicy) {
        GmailBackupPolicyElement element = null;
        ArrayList<String> gmailfolderPaths = new ArrayList<String>();
        ArrayList<String> gmailuserExcludedFolderPaths = new ArrayList<String>();
        ArrayList<String> GmailScheduleNames = new ArrayList<String>();
        ArrayList calloutScriptStrs = new ArrayList();
        if (backupPolicy == null) {
            return null;
        }
        for (Schedule schedule : backupPolicy.getSchedules()) {
            GmailScheduleNames.add(schedule.getScheduleName());
        }
        for (BackupFolders backupFolder : backupPolicy.getBackupFolders()) {
            BackupFolderElement backupFolderElement = new BackupFolderElement();
            if (backupFolder == null) continue;
            backupFolderElement.setFolderPath(backupFolder.getFolderPath());
            backupFolderElement.setOsType(backupFolder.getOs());
            gmailfolderPaths.add(backupFolder.getFolderPath());
        }
        if (backupPolicy != null) {
            List searchFlterNames;
            ArrayList searchFilters;
            element = new GmailBackupPolicyElement();
            BeanUtils.copyProperties((Object)backupPolicy, (Object)element);
            element.setSearchFilterType(backupPolicy.getSearchFilterType());
            element.setPolicygroupName(backupPolicy.getPolicyName());
            element.setBackupFolderPaths(new ArrayList());
            element.getBackupFolderPaths().addAll(gmailfolderPaths);
            element.setFilters(new HashMap());
            element.setFilters(backupPolicy.getFilters());
            if (backupPolicy.getExcludedFolders() != null) {
                for (ExcludedFolders userExcludedFolders : backupPolicy.getExcludedFolders()) {
                    ExcludedFolderElement userExcludedFolderElement = new ExcludedFolderElement();
                    if (userExcludedFolders == null) continue;
                    userExcludedFolderElement.setFolderPath(userExcludedFolders.getFolderPath());
                    gmailuserExcludedFolderPaths.add(userExcludedFolders.getFolderPath());
                }
                if (!gmailuserExcludedFolderPaths.isEmpty()) {
                    element.setExcludedFolderpaths(gmailuserExcludedFolderPaths);
                }
            }
            element.setCalloutScripts(calloutScriptStrs);
            ArrayList filters = backupPolicy.getInclusionFilter();
            List filterNames = filters.stream().filter(filter -> Objects.nonNull(filter.getFilterName())).map(filter -> filter.getFilterName()).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(filterNames)) {
                element.setFilterInclusionName(filterNames);
            }
            if (!CollectionUtils.isEmpty((Collection)(searchFilters = backupPolicy.getSearchInclusionFilter())) && !CollectionUtils.isEmpty(searchFlterNames = searchFilters.stream().filter(filter -> Objects.nonNull(filter.getFilterName())).map(filter -> filter.getFilterName()).collect(Collectors.toList()))) {
                element.setSearchFilterInclusionName(searchFlterNames);
            }
            element.setScheduleNames(new ArrayList());
            element.getScheduleNames().addAll(GmailScheduleNames);
            element.setEndpointUiPreferences((List)backupPolicy.getEndpointUiPreferences());
            ArrayList list = backupPolicy.getPrivacyGateways();
            PrivacyGatewayMappingElement mappingElement = new PrivacyGatewayMappingElement();
            ArrayList<String> pgList = new ArrayList<String>();
            for (PrivacyGateway privacyGateway : list) {
                if (privacyGateway == null) continue;
                mappingElement.setGatewayNwThrottlingName("PGThrottle-name");
                pgList.add(privacyGateway.getGatewayName());
            }
            mappingElement.setPrivacyGatewayNames(new ArrayList());
            mappingElement.setPrivacyGatewayNames(pgList);
            element.setPrivacyGatewayMappingElement(mappingElement);
            element.setSearchAlgoForPg(backupPolicy.getSearchAlgoForPg());
            element.setContentIndexEnabled(backupPolicy.isContentIndexEnabled());
            element.setCanAdminRestore(backupPolicy.isCanAdminRestore());
        }
        element.setFilterType(backupPolicy.getFilterType());
        logger.debug(element.getFilterType() + "...filt......content index enabled ... " + backupPolicy.isContentIndexEnabled());
        return element;
    }

    @Override
    public List<User> getUsersWithoutDevicesBasedOnProductType(int cloudId, String deviceType) {
        List users = null;
        if (deviceType.equalsIgnoreCase(Device.TYPE.GMAIL.getProduct())) {
            users = this.userDao.getAllBkpEnabledUsersBasedOntype(cloudId, "gmailBkpEnabled");
        } else if (deviceType.equalsIgnoreCase(Device.TYPE.GOOGLEDRIVE.getProduct())) {
            users = this.userDao.getAllBkpEnabledUsersBasedOntype(cloudId, "gdriveBkpEnabled");
        }
        if (CollectionUtils.isEmpty((Collection)users)) {
            logger.debug("...no users found for gmail........");
            return new ArrayList<User>();
        }
        ArrayList<User> usersWithoutDrive = new ArrayList<User>();
        for (User user : users) {
            Device device = this.deviceDao.getUsersWithoutDevicesBasedOnProductType(cloudId, user.getUserName(), deviceType);
            if (device != null) continue;
            usersWithoutDrive.add(user);
            if (usersWithoutDrive.size() < 100) continue;
            return usersWithoutDrive;
        }
        return usersWithoutDrive;
    }

    @Override
    public GmailProperties getGmailProperties(int cloudId) {
        GmailProperties gmailProperties = this.userDao.getGmailProperties(cloudId);
        return gmailProperties;
    }

    @Override
    public long countOfPresentGmailBackupUsers(int cloudId, String cloudName, boolean active) {
        return this.userDao.countOfPresentGmailBackupUsers(cloudId, cloudName, active);
    }

    @Override
    public List<OdbMappingList> updateObdIdViaExcel(List<OdbMappingList> odbMappingList, int cloudId, String cloudName, User currentUser) {
        try {
            ArrayList<OdbMappingList> failedUserList = new ArrayList<OdbMappingList>();
            Object failedUsers = "";
            if (odbMappingList != null && !odbMappingList.isEmpty()) {
                for (OdbMappingList odbMapping : odbMappingList) {
                    if (!StringUtils.isNotBlank((CharSequence)odbMapping.getUserName()) || !StringUtils.isNotBlank((CharSequence)odbMapping.getOneDriveId())) continue;
                    boolean isMigrationStarted = this.mapODBIds(cloudId, odbMapping.getUserName(), odbMapping.getOneDriveId());
                    if (!isMigrationStarted) {
                        failedUsers = StringUtils.isEmpty((CharSequence)failedUsers) ? odbMapping.getUserName() : (String)failedUsers + "," + odbMapping.getUserName();
                        failedUserList.add(odbMapping);
                        continue;
                    }
                    logger.debug(currentUser.getUserName() + "user updated--> " + odbMapping.getUserName() + ".. successfully updated with oneDrive Id .... " + odbMapping.getOneDriveId());
                    this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudName, " update ODB Id for " + odbMapping.getUserName() + " as ", currentUser.getUserName(), odbMapping.getOneDriveId(), "Portal", System.currentTimeMillis(), PCActionTypes.UPDATED_ODB_ID.getActionTypeValue());
                }
            }
            if (!failedUserList.isEmpty()) {
                this.createUsersExcelMappingFailNew(cloudId, failedUserList);
            }
            return failedUserList;
        }
        catch (Exception e) {
            e.getCause();
            return new ArrayList<OdbMappingList>();
        }
    }

    private void createUsersExcelMappingFailNew(int cloudId, List<OdbMappingList> failedUserList) {
        if (!CollectionUtils.isEmpty(failedUserList)) {
            try (XSSFWorkbook workbook = new XSSFWorkbook();){
                List<List> recordToAdd = this.updateUserElementValuesToExcelForMappingFailNew(failedUserList);
                this.createExcelForUserXlsx(recordToAdd, workbook);
                this.writeExcelForodbMappingBlockedUserXlsx(cloudId, workbook);
            }
            catch (Exception e) {
                logger.trace(EXCEPTION + String.valueOf(e));
                logger.error(EXCEPTION + e.getMessage());
            }
        }
    }

    private List<List> updateUserElementValuesToExcelForMappingFailNew(List<OdbMappingList> failedUserList) {
        ArrayList<List> recordToAdd = new ArrayList<List>();
        List<String> headerRow = this.createHeaderRowForUserXlsxForBlockFail();
        recordToAdd.add(headerRow);
        for (OdbMappingList userElement : failedUserList) {
            recordToAdd.add(this.loadDataOnRowForUserXlsxForMappingFail(userElement));
        }
        return recordToAdd;
    }

    List<String> loadDataOnRowForUserXlsxForMappingFail(OdbMappingList userElement) {
        ArrayList<String> firstRow = new ArrayList<String>();
        firstRow.add(userElement.getUserName());
        firstRow.add("User does not exist or invalid");
        return firstRow;
    }

    boolean writeExcelForodbMappingBlockedUserXlsx(int cloudId, XSSFWorkbook workbook) {
        try (FileOutputStream fos = new FileOutputStream(new File(this.registry.get(cloudId).getPropertyFileValueParacloudMountPoint() + "/reports/OdbMappingFailedUsers.xlsx"));){
            XSSFCellStyle hsfstyle = workbook.createCellStyle();
            hsfstyle.setBorderBottom((short)1);
            hsfstyle.setFillBackgroundColor((short)245);
            workbook.write((OutputStream)fos);
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + String.valueOf(e));
            logger.error(EXCEPTION + e.getMessage());
            return false;
        }
        return true;
    }

    @Override
    public List<User> getExistingGraphUsers(int cloudId, String productType) {
        return this.userDao.getExistingGraphUsers(cloudId, productType);
    }

    @Override
    public void createGraphUser(int cloudId, User user, String productType) {
        this.userDao.createGraphUser(cloudId, user, productType);
    }

    @Override
    public GraphUserElement getExistingGraphUserElement(int cloudId, String productType) {
        CloudProperties cloudProperties;
        List users = this.userDao.getAllUsers(cloudId);
        HashMap<String, String> userMap = new HashMap<String, String>();
        HashSet<String> existingUsers = new HashSet<String>();
        HashSet<String> blockedUsers = new HashSet<String>();
        for (User user : users) {
            if ("ONEDRIVE".equalsIgnoreCase(productType) && !user.isOnedriveBkpEnabled() || "OUTLOOK".equalsIgnoreCase(productType) && !user.isExchangeBkpEnabled()) continue;
            existingUsers.add(user.getUserName());
            if (!user.isActive()) {
                blockedUsers.add(user.getUserName());
            }
            userMap.put(user.getUserName(), user.getSpPolicyName());
            logger.debug(productType + "...user and pol...." + user.getUserName() + ".." + user.getSpPolicyName());
        }
        List discoveredUsers = this.userDao.getExistingGraphUsers(cloudId, productType);
        HashSet<String> existingDiscoveredUsers = new HashSet<String>();
        for (User user : discoveredUsers) {
            if (existingUsers.contains(user.getUserName()) || existingDiscoveredUsers.add(user.getUserName())) continue;
            existingDiscoveredUsers.add(user.getUserName());
            logger.debug("...existing..." + user.getUserName());
        }
        existingDiscoveredUsers.removeAll(blockedUsers);
        ArrayList existUsers = new ArrayList(existingDiscoveredUsers);
        GraphUserElement graphUserElement = new GraphUserElement();
        MSGraphUserProperties msGraphUserProperties = this.userDao.getMSGraphUserProperties(cloudId);
        if (msGraphUserProperties == null) {
            cloudProperties = this.cloudDao.getCloudProperties(cloudId);
            if (cloudProperties != null) {
                graphUserElement.setDefaultExchangePolicyName(cloudProperties.getDefaultExchangePolicyName());
                graphUserElement.setDefaultOdbPolicyName(cloudProperties.getDefaultOdbPolicyName());
                this.userDao.saveMSGraphUserProperties(cloudId, graphUserElement);
            }
            msGraphUserProperties = this.userDao.getMSGraphUserProperties(cloudId);
        }
        if (msGraphUserProperties != null) {
            graphUserElement.setExAutoMigrationEnabled(msGraphUserProperties.isExAutoMigrationEnabled());
            graphUserElement.setOdbAutoMigrationEnabled(msGraphUserProperties.isOdbAutoMigrationEnabled());
            graphUserElement.setDefaultExchangePolicyName(msGraphUserProperties.getDefaultExchangePolicyName());
            graphUserElement.setDefaultOdbPolicyName(msGraphUserProperties.getDefaultOdbPolicyName());
            graphUserElement.setUserMap(userMap);
        }
        if ((StringUtils.isEmpty((CharSequence)graphUserElement.getDefaultExchangePolicyName()) || StringUtils.isEmpty((CharSequence)graphUserElement.getDefaultOdbPolicyName())) && (cloudProperties = this.cloudDao.getCloudProperties(cloudId)) != null) {
            graphUserElement.setDefaultExchangePolicyName(cloudProperties.getDefaultExchangePolicyName());
            graphUserElement.setDefaultOdbPolicyName(cloudProperties.getDefaultOdbPolicyName());
        }
        logger.debug(String.valueOf(msGraphUserProperties) + "...defaultproperties..." + graphUserElement.getDefaultExchangePolicyName());
        graphUserElement.setDiscoveredUsers(existUsers);
        return graphUserElement;
    }

    @Override
    public int createGraphUser(int cloudId, GraphUserElement graphUserElement, String loggedInuserName, String productType) {
        int erroCode = 0;
        Map userMap = graphUserElement.getUserMap();
        List clouds = this.cloudDao.getAllClouds();
        Cloud cloud = (Cloud)clouds.get(0);
        boolean emptyExists = false;
        boolean exchangeProd = false;
        boolean odbProd = false;
        if ("Exchange".equalsIgnoreCase(productType)) {
            exchangeProd = true;
        }
        if ("ODB".equalsIgnoreCase(productType)) {
            odbProd = true;
        }
        logger.debug(loggedInuserName + "...gson element...." + new Gson().toJson((Object)graphUserElement));
        for (Map.Entry entry : userMap.entrySet()) {
            logger.debug((String)entry.getValue() + "...user..name...." + (String)entry.getKey());
            if ("empty".equalsIgnoreCase((String)entry.getKey())) continue;
            int code = 0;
            if (exchangeProd) {
                code = this.validateExchangeUserRestrictions(cloudId, cloud);
            }
            if (odbProd) {
                code = this.validateODBUserRestrictions(cloudId, cloud);
            }
            long countOfPresentUsers = 0L;
            long noOfUsersAllowed = 0L;
            if (exchangeProd) {
                countOfPresentUsers = this.countOfPresentExchangeUsers(cloud.getCloudId(), true);
                noOfUsersAllowed = cloud.getNoOfExchangeUsersAllowed();
            } else {
                countOfPresentUsers = this.countOfPresentOnedriveUsers(cloud.getCloudId(), true);
                noOfUsersAllowed = cloud.getNoOfOneDriveUsersAllowed();
            }
            logger.debug(countOfPresentUsers + "...trying to-countOfPresentUsers usersla ... " + noOfUsersAllowed);
            logger.debug(productType + "...trying to- validate usersla ... " + code);
            if (countOfPresentUsers >= noOfUsersAllowed) {
                code = 1535;
                logger.error("...unable to create user for policy..." + graphUserElement.getDefaultExchangePolicyName() + "...." + graphUserElement.getDefaultOdbPolicyName());
                this.userDao.saveMSGraphUserProperties(cloudId, graphUserElement);
                return code;
            }
            User userByName = this.userDao.getUserByName(cloudId, (String)entry.getKey());
            if (userByName != null) {
                logger.debug(exchangeProd + "...." + odbProd + "..user-already exists latest...." + (String)entry.getKey());
                if (odbProd) {
                    this.userDao.updateUserPolicyMapping(cloudId, (String)entry.getKey(), (String)entry.getValue());
                    this.saveStatisticToDatabase(cloudId, "", " enabled OneDrive License and assigned " + (String)entry.getValue() + " Policy to ", loggedInuserName, (String)entry.getKey(), PCActionTypes.CHANGE_BACKUP_POLICY.getActionTypeValue());
                    erroCode = 200;
                    userByName.setOnedriveBkpEnabled(odbProd);
                    userByName.setOneDrivePolicyName(graphUserElement.getDefaultOdbPolicyName());
                    this.userDao.updateSMBUserLicense(cloudId, userByName);
                    this.userDao.removeMSGraphFromDiscovery(cloudId, (String)entry.getKey(), productType);
                }
                if (!exchangeProd) continue;
                userByName.setExchangeBkpEnabled(exchangeProd);
                userByName.setExchangePolicyName(graphUserElement.getDefaultExchangePolicyName());
                this.userDao.updateUserPolicyMapping(cloudId, (String)entry.getKey(), (String)entry.getValue());
                this.userDao.updateSMBUserLicense(cloudId, userByName);
                this.saveStatisticToDatabase(cloudId, "", " enabled Exchange License and  assigned " + (String)entry.getValue() + " Policy to ", loggedInuserName, (String)entry.getKey(), PCActionTypes.CHANGE_BACKUP_POLICY.getActionTypeValue());
                erroCode = 200;
                this.userDao.removeMSGraphFromDiscovery(cloudId, (String)entry.getKey(), productType);
                continue;
            }
            String policyName = (String)entry.getValue();
            logger.debug(exchangeProd + "...trying to odbProd-exchangeProd ... " + odbProd + "...." + productType);
            User user = this.userDao.createUserFromMSGraph(cloudId, (String)entry.getKey(), policyName, productType);
            MSGraphUserProperties msGraphUserProperties = this.userDao.getMSGraphUserProperties(cloudId);
            if (msGraphUserProperties != null) {
                if ("ODB".equalsIgnoreCase(productType) && msGraphUserProperties.isOdbAutoMigrationEnabled()) {
                    loggedInuserName = "AUTO";
                }
                if ("Exchange".equalsIgnoreCase(productType) && msGraphUserProperties.isExAutoMigrationEnabled()) {
                    loggedInuserName = "AUTO";
                }
            }
            this.saveStatisticToDatabaseForUser(cloud.getCloudId(), cloud.getCloudName(), " registered a User ", loggedInuserName, (String)entry.getKey(), "Portal", System.currentTimeMillis(), PCActionTypes.LOGIN.getActionTypeValue());
        }
        if (CollectionUtils.isEmpty((Map)userMap)) {
            erroCode = 200;
        }
        return erroCode;
    }

    @Override
    public List<UserDeviceCommentsElement> getComments(int cloudId, String username, String deviceUUID, int limit) {
        List notesList = this.userDao.getComments(cloudId, username, deviceUUID, limit);
        ArrayList<UserDeviceCommentsElement> notesListElemts = new ArrayList<UserDeviceCommentsElement>();
        for (UserDeviceComments userDeviceComments : notesList) {
            UserDeviceCommentsElement userDeviceCommentsElement = new UserDeviceCommentsElement();
            BeanUtils.copyProperties((Object)userDeviceComments, (Object)userDeviceCommentsElement);
            String compressedComment = userDeviceComments.getComment();
            userDeviceCommentsElement.setComment(UserManagementServiceImpl.decompress(compressedComment));
            notesListElemts.add(userDeviceCommentsElement);
        }
        return notesListElemts;
    }

    @Override
    public boolean saveComments(int cloudId, UserDeviceComments userDeviceComments) {
        String compressed = UserManagementServiceImpl.compress(userDeviceComments.getComment());
        userDeviceComments.setTimestamp(System.currentTimeMillis());
        userDeviceComments.setComment(compressed);
        return this.userDao.saveComments(cloudId, userDeviceComments);
    }

    public static String decompress(String base64Compressed) {
        try {
            int n;
            if (base64Compressed == null || base64Compressed.isEmpty()) {
                return base64Compressed;
            }
            byte[] compressed = java.util.Base64.getDecoder().decode(base64Compressed);
            if (compressed == null || compressed.length == 0) {
                return null;
            }
            ByteArrayInputStream bis = new ByteArrayInputStream(compressed);
            GZIPInputStream gis = new GZIPInputStream(bis);
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            byte[] tmp = new byte[256];
            while ((n = gis.read(tmp)) >= 0) {
                buffer.write(tmp, 0, n);
            }
            return buffer.toString("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            logger.error("error", (Throwable)e);
        }
        catch (IOException e) {
            logger.error("error", (Throwable)e);
        }
        catch (Exception e) {
            logger.error("error", (Throwable)e);
        }
        return null;
    }

    public static String compress(String str) {
        try {
            if (str == null || str.length() == 0) {
                return null;
            }
            ByteArrayOutputStream obj = new ByteArrayOutputStream();
            GZIPOutputStream gzip = new GZIPOutputStream(obj);
            gzip.write(str.getBytes("UTF-8"));
            gzip.close();
            return java.util.Base64.getEncoder().encodeToString(obj.toByteArray());
        }
        catch (UnsupportedEncodingException e) {
            logger.error("error", (Throwable)e);
        }
        catch (IOException e) {
            logger.error("error", (Throwable)e);
        }
        catch (Exception e) {
            logger.error("error", (Throwable)e);
        }
        return null;
    }

    @Override
    public TenantConsentStatus saveTenantStatus(int cloudId, TenantConsentStatus status) {
        return this.userDao.saveTenantStatus(cloudId, status);
    }

    @Override
    public TenantConsentStatus findTenantConsentStatus(int cloudId) {
        return this.userDao.findTenantConsentStatus(cloudId);
    }

    @Override
    public boolean isDeviceRegistered(int cloudId) {
        return this.userDao.isDeviceRegistered(cloudId);
    }

    @Override
    public MSGraphUserProperties getMSGraphUserProperties(int cloudId) {
        return this.userDao.getMSGraphUserProperties(cloudId);
    }

    @Override
    public void updateSMBUserLicense(int cloudId, User user) {
        this.userDao.updateSMBUserLicense(cloudId, user);
    }

    @Override
    public void removeMSGraphFromDiscovery(int cloudId, String siteName, String productType) {
        this.userDao.removeMSGraphFromDiscovery(cloudId, siteName, productType);
    }

    @Override
    public void saveMSGraphUserProperties(int cloudId, GraphUserElement graphUserElement) {
        this.userDao.saveMSGraphUserProperties(cloudId, graphUserElement);
    }

    protected String decodeBase64UTFString(String encodedString) {
        String decodedString = encodedString;
        try {
            decodedString = new String(Base64.decodeBase64((String)encodedString), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            logger.trace(String.valueOf(e));
            logger.error(e.getMessage());
            logger.debug("UnsupportedEncodingException", (Throwable)e);
        }
        return decodedString;
    }

    @Override
    public void updateTenantConsentStatusForAssetsConfigured(Cloud cloud, TenantConsentStatus tenantConsentStatus) {
        CloudProperties cloudProperties = this.cloudDao.getCloudProperties(cloud.getCloudId());
        String emailId = cloudProperties.getSmbEmailId();
        User spadmin = this.userDao.getUserInfoByName(cloud.getCloudId(), "spadmin");
        String spadminDecodedEmail = this.decodeBase64UTFString(spadmin.getEmailId());
        logger.debug(spadminDecodedEmail + "....emailId spadmin....." + spadmin.getEmailId());
        EmailProps email = new EmailProps();
        if (!StringUtils.isEmpty((CharSequence)cloudProperties.getCppProvisioningEmailId())) {
            email = new EmailProps();
            email.setAction("smb-cpp-device-configured");
            email.setCloudName(cloud.getCloudName());
            email.setUserName(emailId);
            email.setToAdmins(false);
            email.setToUser(true);
            email.setFileName(cloudProperties.geteCommerceId());
            email.setCloudURL(this.registry.get(cloud.getCloudId()).getPropertyFileValueCloudUrl() + "/portal/locallogin");
            EmailRecipent emailRecipent = new EmailRecipent();
            emailRecipent.setUserName(cloudProperties.getCppProvisioningEmailId());
            emailRecipent.setEmail(cloudProperties.getCppProvisioningEmailId());
            ArrayList<EmailRecipent> recipentsList = new ArrayList<EmailRecipent>();
            recipentsList.add(emailRecipent);
            emailRecipent = new EmailRecipent();
            emailRecipent.setUserName(spadminDecodedEmail);
            emailRecipent.setEmail(spadminDecodedEmail);
            recipentsList.add(emailRecipent);
            if (!"support@crashplan.com".equalsIgnoreCase(spadminDecodedEmail)) {
                emailRecipent = new EmailRecipent();
                emailRecipent.setUserName("support@crashplan.com");
                emailRecipent.setEmail("support@crashplan.com");
                recipentsList.add(emailRecipent);
            }
            logger.debug("calling smb-cpp-device-configured email.." + cloudProperties.getCppProvisioningEmailId());
            email.setRecipents(recipentsList);
            this.cloudMailService.sendMail(cloud, email);
            tenantConsentStatus.setAssetsConfigured(true);
            this.userDao.saveTenantStatus(cloud.getCloudId(), tenantConsentStatus);
        }
    }

    @Override
    public void saveStatisticToDatabase(int cloudId, String cloudName, String action, String userName, String actionOnUser, String deviceName, long currentTimeMillis, int actionTypeValue) {
        this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudName, "modified Configure users for SMB " + action + " ", userName, "", "Portal", System.currentTimeMillis(), PCActionTypes.CLOUD_UPDATE.getActionTypeValue());
    }

    @Override
    public void saveStatisticToDatabaseForUser(int cloudId, String cloudName, String action, String userName, String actionOnUser, String deviceName, long currentTimeMillis, int actionTypeValue) {
        this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudName, action + " ", userName, actionOnUser, "Portal", System.currentTimeMillis(), PCActionTypes.CLOUD_UPDATE.getActionTypeValue());
    }

    @Override
    public void removeExcessLicense(Cloud cloud) {
        long toBlock;
        long allowed = cloud.getNoOfExchangeUsersAllowed();
        long total = this.countOfPresentExchangeUsers(cloud.getCloudId(), true);
        String productType = "";
        if (total > allowed) {
            toBlock = total - allowed;
            productType = "Exchange";
            this.userDao.updateExcessSMBLicense(cloud, allowed, toBlock, productType);
        }
        allowed = cloud.getNoOfOneDriveUsersAllowed();
        total = this.countOfPresentOnedriveUsers(cloud.getCloudId(), true);
        if (total > allowed) {
            toBlock = total - allowed;
            productType = "ODB";
            this.userDao.updateExcessSMBLicense(cloud, allowed, toBlock, productType);
        }
        allowed = cloud.getNoOfSPSitesAllowed();
        total = this.countOfPresentSite(cloud.getCloudId(), true);
        if (total > allowed) {
            toBlock = total - allowed;
            productType = "Sharepoint";
            this.userDao.updateExcessSMBLicense(cloud, allowed, toBlock, productType);
        }
    }

    @Override
    public MSAppSetting getMSAppSettingsDetails(int cloudId) {
        return this.userDao.getMSAppSettingsDetails(cloudId);
    }
}

