/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.bluvault.udc.helper;

import com.parablu.pcbd.domain.BackUpImage;
import com.parablu.pcbd.domain.ConsolidatedImage;
import com.parablu.pcbd.domain.FileRevision;
import com.parablu.pcbd.domain.SearchIndex;
import java.util.ArrayList;
import java.util.List;

public class SearchIndexHelper {
    private SearchIndexHelper() {
    }

    public static List<SearchIndex> modifyIndexByListOfFile(int cloudId, String cloudName, List<FileRevision> fileListFromDatabase, boolean present, String status) {
        ArrayList<SearchIndex> searchIndexs = new ArrayList<SearchIndex>();
        if (fileListFromDatabase == null) {
            return searchIndexs;
        }
        for (FileRevision fileRevision : fileListFromDatabase) {
            SearchIndex searchIndex = new SearchIndex();
            searchIndex.setCloudId(cloudId);
            ConsolidatedImage consolidatedImage = fileRevision.getConsolidatedImage();
            searchIndex.setConsolidatedImageId(consolidatedImage.getId());
            searchIndex.setPresent(present);
            searchIndex.setAbstractFolderUrl(consolidatedImage.getDevicePath());
            searchIndex.setFileName(consolidatedImage.getFileName());
            searchIndex.setFolder(consolidatedImage.isFolder());
            searchIndex.setSize(String.valueOf(fileRevision.getSize()));
            searchIndex.setLastModifiedTime(consolidatedImage.getModifiedTime());
            searchIndex.setFsPath(fileRevision.getfSPath());
            searchIndex.setUserName(fileRevision.getUserName());
            searchIndex.setMiniCloud(consolidatedImage.isMiniCloud());
            searchIndex.setStatus(status);
            searchIndexs.add(searchIndex);
        }
        return searchIndexs;
    }

    private static List<SearchIndex> modifyIndexByFileName(int cloudId, String cloudName, BackUpImage backUpImage, boolean present, String status) {
        ArrayList<SearchIndex> searchIndexes = new ArrayList<SearchIndex>();
        if (backUpImage == null) {
            return searchIndexes;
        }
        SearchIndex searchIndex = new SearchIndex();
        searchIndex.setCloudId(cloudId);
        searchIndex.setPresent(present);
        searchIndex.setAbstractFolderUrl(backUpImage.getDevicePath());
        searchIndex.setFileName(backUpImage.getFileName());
        searchIndex.setFolder(backUpImage.isFolder());
        searchIndex.setSize(String.valueOf(backUpImage.getSize()));
        searchIndex.setLastModifiedTime(String.valueOf(backUpImage.getLastServerModifiedTime()));
        searchIndex.setFsPath(backUpImage.getfSPath());
        searchIndex.setUserName(backUpImage.getUserName());
        searchIndex.setStatus(status);
        searchIndexes.add(searchIndex);
        return searchIndexes;
    }

    public static List<SearchIndex> deleteIndexByFileName(int cloudId, String cloudName, BackUpImage backUpImage) {
        return SearchIndexHelper.modifyIndexByFileName(cloudId, cloudName, backUpImage, false, "DELETED");
    }

    public static List<SearchIndex> deleteIndexByListOfFile(int cloudId, String cloudName, List<FileRevision> fileRevisions) {
        return SearchIndexHelper.modifyIndexByListOfFile(cloudId, cloudName, fileRevisions, false, "DELETED");
    }

    public static List<SearchIndex> addorUpdateIndex(int cloudId, String cloudName, List<FileRevision> fileRevisions) {
        return SearchIndexHelper.modifyIndexByListOfFile(cloudId, cloudName, fileRevisions, true, "ACTIVE");
    }

    public static List<SearchIndex> addorUpdateIndex(int cloudId, String cloudName, BackUpImage backUpImage) {
        return SearchIndexHelper.modifyIndexByFileName(cloudId, cloudName, backUpImage, true, "ACTIVE");
    }
}

