/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.mt.controller;

import com.parablu.bluvault.ah.service.AuditHistoryService;
import com.parablu.cloud.security.service.AuthorizationService;
import com.parablu.cloud.security.service.LicenseService;
import com.parablu.cloud.security.to.CloudLicenseTo;
import com.parablu.helper.exceptions.BaseException;
import com.parablu.mt.service.LdapService;
import com.parablu.paracloud.constant.PCActionTypes;
import com.parablu.paracloud.element.AdElement;
import com.parablu.paracloud.element.LdapNameElement;
import com.parablu.paracloud.element.LdapUserElement;
import com.parablu.pcbd.domain.AuthorizationTokens;
import com.parablu.pcbd.domain.Person;
import com.parablu.pcbd.domain.User;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class MigrationToolController {
    private static Logger logger = LogManager.getLogger(MigrationToolController.class);
    protected static final String JSON_VIEW = "jsonview";
    @Autowired
    private LdapService ldapService;
    @Autowired
    private LicenseService licenseService;
    @Autowired
    protected AuthorizationService authorizationService;
    @Autowired
    private AuditHistoryService auditHistoryService;

    @RequestMapping(value={"cloud/{cloudName}/ldap/users"}, method={RequestMethod.POST})
    public ModelAndView ldapconnectivityUser(@PathVariable(value="cloudName") String cloudName, @RequestBody LdapNameElement ldapNameElement, HttpServletRequest request, HttpServletResponse response) {
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName(JSON_VIEW);
        String groupName = "";
        try {
            ArrayList<LdapUserElement> ldapUserElementList = new ArrayList<LdapUserElement>();
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return null;
            }
            int cloudId = cl.getCloud().getCloudId();
            boolean ldapConnection = this.ldapService.checkAdConnectionPortal(cloudId, response);
            if (!ldapConnection) {
                return null;
            }
            for (String name : ldapNameElement.getLdapUserNames()) {
                logger.debug(" Iterating through ..... " + name);
                Person person = this.ldapService.getPersonByUserName(name);
                if (person != null) {
                    User user = this.ldapService.getUserByName(1, name);
                    if (user == null) {
                        if (this.getLdapUserElement(person) == null || StringUtils.isEmpty((String)person.getEmailId())) continue;
                        LdapUserElement ldapUserElement = this.getLdapUserElement(person);
                        if (ldapUserElement.isAccountStatus()) {
                            ldapUserElementList.add(ldapUserElement);
                            continue;
                        }
                        logger.debug("User account is not active in AD ......." + ldapUserElement.getUserName());
                        continue;
                    }
                    logger.debug(" user exist but He/She is blocked or deleted..... " + name);
                    continue;
                }
                List<Person> list = this.ldapService.findUsersInGroup(name);
                if (!CollectionUtils.isEmpty(list)) {
                    for (Person personObj : list) {
                        if (this.getLdapUserElement(personObj) == null || StringUtils.isEmpty((String)personObj.getEmailId())) continue;
                        LdapUserElement userElement = this.getLdapUserElement(personObj);
                        if (userElement.isAccountStatus()) {
                            ldapUserElementList.add(userElement);
                            continue;
                        }
                        logger.debug("User account is not active in AD ......." + userElement.getUserName());
                    }
                    groupName = name;
                    logger.debug(" group name .............. " + groupName);
                    continue;
                }
                logger.debug(" PERSON NOT FOUND  ..... " + name);
            }
            response.addHeader("groupName", groupName);
            response.setStatus(200);
            modelAndView.addObject(ldapUserElementList);
        }
        catch (Exception e) {
            if (e.getMessage().contains("Communiation Exception")) {
                response.setStatus(503);
                response.setHeader("AD_Unrechable", "true");
                return modelAndView;
            }
            if (e.getMessage().contains("Authentication Exception")) {
                response.setStatus(417);
                response.setHeader("AD_Unauthorized", "true");
                return modelAndView;
            }
            logger.trace("error trying to load elements  ..........." + String.valueOf(e));
            response.setStatus(400);
            logger.error(" Exception  :" + e.getMessage());
        }
        return modelAndView;
    }

    private LdapUserElement getLdapUserElement(Person person) {
        if (!this.ldapService.checkPersonAlreadyExist(person.getFullName(), person.getEmailId())) {
            LdapUserElement ldapUserElement = new LdapUserElement();
            ldapUserElement.setUserName(person.getFullName());
            ldapUserElement.setEmailId(person.getEmailId());
            ldapUserElement.setOrganizationUnit(person.getOrganizationalUnit());
            ldapUserElement.setAccountStatus(person.isAccountStatus());
            ldapUserElement.setLocation(person.getLocation());
            ldapUserElement.setDepartment(person.getDepartment());
            ldapUserElement.setDisplayName(person.getDisplayName());
            logger.debug("...display name... " + person.getDisplayName());
            return ldapUserElement;
        }
        return null;
    }

    @RequestMapping(value={"cloud/{cloudName}/ad/save/"}, method={RequestMethod.POST})
    public void saveBackupPolicy(@PathVariable(value="cloudName") String cloudName1, @RequestBody AdElement adElement, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug("calling ad save..." + adElement.getUserDn());
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return;
            }
            int cloudId = cl.getCloud().getCloudId();
            String token = request.getHeader("token");
            String userName = request.getHeader("userName");
            if (StringUtils.isNotEmpty((String)userName)) {
                userName = this.decodeBase64UTFString(userName);
            }
            cloudName = cl.getCloud().getCloudName();
            AuthorizationTokens authorizationTokens = this.authorizationService.getTokenDetailsForToken(cloudId, cloudName, token);
            if (!this.authorizationService.getTokenDetailsForToken(cloudId, cloudName, token).getUser().isAdmin()) {
                logger.debug("not an admin user so return");
                response.setStatus(403);
                return;
            }
            if (authorizationTokens == null) {
                response.setStatus(401);
                return;
            }
            this.ldapService.saveAD(cloudId, adElement);
            this.auditHistoryService.saveStatisticToDatabase(cl.getCloud().getCloudId(), cloudName, "created new AD Credentials with domain name", authorizationTokens.getUser().getUserName(), adElement.getUserDn(), "Portal", System.currentTimeMillis(), PCActionTypes.AD_CREDENTIALS_CREATE.getActionTypeValue());
            response.setStatus(200);
        }
        catch (BaseException e) {
            response.setStatus(500);
            logger.trace("Error failed to ad save ..." + String.valueOf((Object)e));
            logger.error("Error failed to ad save ..." + e.getMessage());
        }
        logger.debug("end of calling /ad/save ...");
    }

    @RequestMapping(value={"cloud/{cloudName}/ad/load/"}, method={RequestMethod.GET})
    public ModelAndView getBackupPolicys(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        String id = request.getHeader("id");
        logger.debug("calling load /ad/load/ ..." + id);
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName(JSON_VIEW);
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                response.setStatus(400);
                return null;
            }
            if (StringUtils.isEmpty((String)id)) {
                response.setStatus(400);
                return null;
            }
            int cloudId = cl.getCloud().getCloudId();
            cloudName = cl.getCloud().getCloudName();
            String token = request.getHeader("token");
            String userName = request.getHeader("userName");
            if (StringUtils.isNotEmpty((String)userName)) {
                userName = this.decodeBase64UTFString(userName);
            }
            if (!this.authorizationService.getTokenDetailsForToken(cloudId, cloudName, token).getUser().isAdmin()) {
                logger.debug("not an admin user so return");
                response.setStatus(403);
                return null;
            }
            if (!this.performAuthorization(cloudId, cloudName, token, response, userName)) {
                return null;
            }
            AdElement adElement = this.ldapService.getADForId(cloudId, id);
            if (adElement == null) {
                response.setStatus(400);
                return null;
            }
            modelAndView.addObject((Object)adElement);
            response.setStatus(200);
        }
        catch (BaseException e) {
            response.setStatus(500);
            logger.trace("Error failed to load /ad/load/..." + String.valueOf((Object)e));
            logger.error("Error failed to load /ad/load/..." + e.getMessage());
        }
        logger.debug("end of loading /ad/load/ ...");
        return modelAndView;
    }

    @RequestMapping(value={"cloud/{cloudName}/ad/load/all/"}, method={RequestMethod.GET})
    public ModelAndView getAllBackupPolicy(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug("calling load all /ad/load/all ...");
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName(JSON_VIEW);
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                response.setStatus(400);
                return null;
            }
            int cloudId = cl.getCloud().getCloudId();
            cloudName = cl.getCloud().getCloudName();
            String token = request.getHeader("token");
            String userName = request.getHeader("userName");
            if (StringUtils.isNotEmpty((String)userName)) {
                userName = this.decodeBase64UTFString(userName);
            }
            if (!this.authorizationService.getTokenDetailsForToken(cloudId, cloudName, token).getUser().isAdmin()) {
                logger.debug("not a admin user  so return");
                response.setStatus(403);
                return null;
            }
            if (!this.performAuthorization(cloudId, cloudName, token, response, userName)) {
                return null;
            }
            List<AdElement> adElements = this.ldapService.getAllAdCredentials(cloudId);
            modelAndView.addObject(adElements);
            response.setStatus(200);
        }
        catch (BaseException e) {
            response.setStatus(500);
            logger.trace("Error failed to load all /ad/load/all  ..." + String.valueOf((Object)e));
            logger.error("Error failed to load all /ad/load/all  ..." + e.getMessage());
        }
        logger.debug("end of load all /ad/load/all ...");
        return modelAndView;
    }

    @RequestMapping(value={"cloud/{cloudName}/ad/delete/"}, method={RequestMethod.DELETE})
    public void deleteAD(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String adName = request.getHeader("userDn");
        logger.debug("calling delete /ad/delete/.." + adName);
        String cloudName = cloudName1;
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                response.setStatus(400);
                return;
            }
            int cloudId = cl.getCloud().getCloudId();
            String token = request.getHeader("token");
            String userName = request.getHeader("userName");
            if (StringUtils.isNotEmpty((String)userName)) {
                userName = this.decodeBase64UTFString(userName);
            }
            AuthorizationTokens authorizationTokens = this.authorizationService.getTokenDetailsForToken(cloudId, cloudName, token);
            if (!this.authorizationService.getTokenDetailsForToken(cloudId, cloudName, token).getUser().isAdmin()) {
                logger.debug("not a admin user so return");
                response.setStatus(403);
                return;
            }
            if (authorizationTokens == null) {
                response.setStatus(401);
                return;
            }
            this.ldapService.deleteADCredential(cloudId, adName);
            this.auditHistoryService.saveStatisticToDatabase(cl.getCloud().getCloudId(), cloudName, "deleted AD Credentials ", authorizationTokens.getUser().getUserName(), adName, "Portal", System.currentTimeMillis(), PCActionTypes.AD_CREDENTIALS_DELETE.getActionTypeValue());
            response.setStatus(200);
        }
        catch (BaseException e) {
            response.setStatus(500);
            logger.trace("Error failed to delete /ad/delete/ ..." + String.valueOf((Object)e));
            logger.error("Error failed to delete /ad/delete/ ..." + e.getMessage());
        }
        logger.debug("end of delete /ad/delete/ ...");
    }

    @RequestMapping(value={"cloud/{cloudName}/ad/edit"}, method={RequestMethod.POST})
    public void editAdCredentials(@PathVariable(value="cloudName") String cloudName1, @RequestBody AdElement adElement, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug("calling ad/edit..." + adElement.getUserDn());
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return;
            }
            if (StringUtils.isEmpty((String)adElement.getId())) {
                response.setStatus(400);
                return;
            }
            int cloudId = cl.getCloud().getCloudId();
            String token = request.getHeader("token");
            String userName = request.getHeader("userName");
            if (StringUtils.isNotEmpty((String)userName)) {
                userName = this.decodeBase64UTFString(userName);
            }
            cloudName = cl.getCloud().getCloudName();
            AuthorizationTokens authorizationTokens = this.authorizationService.getTokenDetailsForToken(cloudId, cloudName, token);
            if (!this.authorizationService.getTokenDetailsForToken(cloudId, cloudName, token).getUser().isAdmin()) {
                logger.debug("not a admin user so return");
                response.setStatus(403);
                return;
            }
            if (authorizationTokens == null) {
                response.setStatus(401);
                return;
            }
            this.ldapService.editAD(cloudId, adElement);
            this.auditHistoryService.saveStatisticToDatabase(cl.getCloud().getCloudId(), cloudName, "edited", authorizationTokens.getUser().getUserName(), adElement.getUserDn() + "'s AD credentials,", "Portal", System.currentTimeMillis(), PCActionTypes.AD_CREDENTIALS_UPDATE.getActionTypeValue());
            response.setStatus(200);
        }
        catch (BaseException e) {
            response.setStatus(500);
            logger.trace("Error failed to /ad/edit ..." + String.valueOf((Object)e));
            logger.error("Error failed to ad edit ..." + e.getMessage());
        }
        logger.debug("end of calling /ad edit ...");
    }

    public boolean checkLicense(CloudLicenseTo cloudLicense, HttpServletResponse response) {
        if (cloudLicense == null) {
            response.setStatus(400);
            return false;
        }
        int code = cloudLicense.getCloudLicenseStatus();
        switch (code) {
            case 1500: {
                return true;
            }
            case 1501: {
                response.setStatus(416);
                return false;
            }
            case 1504: {
                response.setStatus(419);
                return false;
            }
            case 1520: {
                response.setStatus(420);
                return false;
            }
            case 1521: {
                response.setStatus(421);
                return false;
            }
            case 1509: {
                response.setStatus(401);
                return false;
            }
            case 1502: {
                response.setStatus(418);
                return false;
            }
            case 1503: {
                response.setStatus(417);
                return false;
            }
            case 1522: {
                response.setStatus(423);
                return false;
            }
            case 1525: {
                response.setStatus(403);
                return false;
            }
        }
        response.setStatus(400);
        return false;
    }

    protected boolean performAuthorization(int cloudId, String cloudName, String token, HttpServletResponse response, String userName) {
        int status = this.authorizationService.validateToken(cloudId, cloudName, token, userName);
        logger.debug(cloudName + "  Validate ######  status " + status);
        switch (status) {
            case 0: {
                return true;
            }
            case 4: {
                logger.debug("  Validate ######  USER_BLOCKED ");
                response.setStatus(420);
                return false;
            }
            case 1: {
                logger.debug("  Validate ######  UNAUTHORIZED ");
                response.setStatus(401);
                return false;
            }
            case 2: {
                logger.debug("  Validate ######  TOKEN_EXPIRED ");
                response.setStatus(421);
                return false;
            }
            case 3: {
                logger.debug("  Validate ######  MULTIPLE_USER_LOGIN ");
                response.setStatus(424);
                return false;
            }
        }
        logger.debug("  Validate ######  HTTP_UNAUTHORIZED ");
        response.setStatus(401);
        return false;
    }

    protected String decodeBase64UTFString(String encodedString) {
        String decodedString = encodedString;
        try {
            decodedString = new String(Base64.decodeBase64((String)encodedString), "UTF-8");
        }
        catch (Exception e) {
            logger.debug("UnsupportedEncodingException", (Throwable)e);
        }
        return decodedString;
    }
}

