/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.bluvault.backup.util;

import com.parablu.paracloud.element.BackupElement;
import com.parablu.paracloud.element.FileElement;
import com.parablu.paracloud.util.PathConversionHelper;
import com.parablu.pcbd.domain.BackUpImage;
import com.parablu.pcbd.domain.Device;
import java.util.ArrayList;
import java.util.List;

public final class ObjectConversionHelper {
    private ObjectConversionHelper() {
    }

    public static List<FileElement> convertBackUpImageListToFileElementList(List<BackUpImage> filesNotToUpload, Boolean isAndroidDevice, boolean backupIdEnabled) {
        ArrayList<FileElement> filesNotToUploadFileElements = new ArrayList<FileElement>();
        if (filesNotToUpload == null || filesNotToUpload.isEmpty()) {
            return filesNotToUploadFileElements;
        }
        for (BackUpImage backUpImage : filesNotToUpload) {
            if (backUpImage == null) continue;
            FileElement element = new FileElement();
            element.setFileCompletePath(PathConversionHelper.getDeviceCompatiblePath((String)backUpImage.getDevicePath(), (boolean)isAndroidDevice));
            element.setFileName(backUpImage.getFileName());
            element.setExists(backUpImage.isPresent());
            element.setFolder(backUpImage.isFolder());
            element.setLastModifiedTimestamp(backUpImage.getLastClientModifiedTime());
            element.setMd5checksum(backUpImage.getMd5Checksum());
            element.setSize(String.valueOf(backUpImage.getSize()));
            if (backupIdEnabled) {
                element.setBackupId(backUpImage.getId().toString());
            }
            element.setMetaData("null");
            element.setFileUserOwner(backUpImage.getUserName());
            filesNotToUploadFileElements.add(element);
        }
        return filesNotToUploadFileElements;
    }

    public static BackupElement convertBackUpImageToBackupElement(BackUpImage backUpImage, Boolean isAndroidDevice) {
        BackupElement element = new BackupElement();
        if (backUpImage == null) {
            return element;
        }
        element.setFileCompletePath(PathConversionHelper.getDeviceCompatiblePath((String)backUpImage.getDevicePath(), (boolean)isAndroidDevice));
        element.setFileName(backUpImage.getFileName());
        element.setPresent(backUpImage.isPresent());
        element.setFolder(backUpImage.isFolder());
        element.setLastClientModifiedTime(backUpImage.getLastClientModifiedTime());
        element.setMd5Checksum(backUpImage.getMd5Checksum());
        element.setSize(backUpImage.getSize());
        element.setBaseBackup(backUpImage.isBaseBackup());
        return element;
    }

    public static void convertToBackUpImage(BackUpImage backUpImageold, String regID, BackUpImage backUpImageDeleted, Device device, boolean isBaseBackupFolder, String fsPath, String status, boolean present) {
        long timeMilliSec = System.currentTimeMillis();
        backUpImageDeleted.setDevicePath(backUpImageold.getDevicePath());
        backUpImageDeleted.setFileName(backUpImageold.getFileName());
        backUpImageDeleted.setDeviceUUID(device.getDeviceUUID());
        backUpImageDeleted.setLastServerModifiedTime(timeMilliSec);
        backUpImageDeleted.setFolder(backUpImageold.isFolder());
        backUpImageDeleted.setMd5Checksum(backUpImageold.getMd5Checksum());
        backUpImageDeleted.setPresent(present);
        backUpImageDeleted.setfSPath(fsPath);
        backUpImageDeleted.setStatus(status);
        backUpImageDeleted.setLastClientModifiedTime(backUpImageold.getLastClientModifiedTime());
        backUpImageDeleted.setBaseBackup(isBaseBackupFolder);
        backUpImageDeleted.setSize(backUpImageold.getSize());
    }

    public static void convertToBackUpImage(BackupElement fileElement, String regID, BackUpImage backUpImage, Device device, boolean isBaseBackupFolder, String fsPath, String status) {
        long timeMilliSec = System.currentTimeMillis();
        backUpImage.setDevicePath(fileElement.getFileCompletePath());
        backUpImage.setFileName(fileElement.getFileName());
        backUpImage.setDeviceUUID(device.getDeviceUUID());
        backUpImage.setLastServerModifiedTime(timeMilliSec);
        backUpImage.setFolder(fileElement.isFolder());
        backUpImage.setMd5Checksum(fileElement.getMd5Checksum());
        backUpImage.setPresent(fileElement.isPresent());
        backUpImage.setfSPath(fsPath);
        backUpImage.setStatus(status);
        backUpImage.setLastClientModifiedTime(fileElement.getLastClientModifiedTime());
        backUpImage.setBaseBackup(isBaseBackupFolder);
        backUpImage.setSize(fileElement.getSize());
        backUpImage.setUserName(device.getUserName());
    }
}

