/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.bluvault.backup.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class FileTypeHelpper {
    private static final List<String> videoFileExtenstions = new ArrayList<String>();
    private static final List<String> audioFileExtenstions;
    private static final List<String> imageFileExtenstions;
    private static final List<Object> supportedFileExtensions;

    private FileTypeHelpper() {
    }

    public static boolean isVideoFile(String fileName) {
        boolean isVideoFile = false;
        int extensionLocation = fileName.lastIndexOf(46);
        if (extensionLocation == -1) {
            return isVideoFile;
        }
        String fileExtension = fileName.substring(extensionLocation);
        isVideoFile = videoFileExtenstions.contains(fileExtension);
        return isVideoFile;
    }

    public static boolean isAudioFile(String fileName) {
        boolean isAudioFile = false;
        int extensionLocation = fileName.lastIndexOf(46);
        if (extensionLocation == -1) {
            return isAudioFile;
        }
        String fileExtension = fileName.substring(extensionLocation);
        isAudioFile = audioFileExtenstions.contains(fileExtension);
        return isAudioFile;
    }

    public static boolean isImageFile(String fileName) {
        boolean isImageFile = false;
        int extensionLocation = fileName.lastIndexOf(46);
        if (extensionLocation == -1) {
            return isImageFile;
        }
        String fileExtension = fileName.substring(extensionLocation);
        isImageFile = imageFileExtenstions.contains(fileExtension);
        return isImageFile;
    }

    public static boolean isSupportedFile(String fileName) {
        boolean isSupportedFile = false;
        int extensionLocation = fileName.lastIndexOf(46);
        if (extensionLocation == -1) {
            return isSupportedFile;
        }
        String fileExtension = fileName.substring(extensionLocation);
        isSupportedFile = supportedFileExtensions.contains(fileExtension);
        return isSupportedFile;
    }

    static {
        videoFileExtenstions.add(".mp4");
        videoFileExtenstions.add(".mp3");
        videoFileExtenstions.add(".3gp");
        videoFileExtenstions.add(".ts");
        videoFileExtenstions.add(".mkv");
        videoFileExtenstions.add(".webm");
        videoFileExtenstions.add(".m4v");
        audioFileExtenstions = new ArrayList<String>();
        audioFileExtenstions.add(".wav");
        imageFileExtenstions = new ArrayList<String>();
        imageFileExtenstions.add(".jpg");
        imageFileExtenstions.add(".jpeg");
        imageFileExtenstions.add(".tiff");
        imageFileExtenstions.add(".png");
        String[] array = new String[]{"AAI", "ART", "AVI", "AVS", "BMP", "BMP2", "BMP3", "CIM", "CMYK", "CMYKA", "CR2", "CRW", "DCR", "DCM", "DCX", "DNG", "DIB", "EMF", "GIF", "ICO", "JPEG", "JP2", "MPEG", "M2V", "MAT", "PSD", "PS", "PS2", "PS3", "PSB", "PNG", "PDF", "RGB", "SHTML", "SVG", "TTF", "TXT", "WMF"};
        supportedFileExtensions = Arrays.asList(array);
    }
}

