/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.bluvault.backup.service.impl;

import com.parablu.bluvault.backup.service.BackupDeleteTimerService;
import com.parablu.helper.constant.GeneralHelperConstant;
import com.parablu.paracloud.constant.PCActionTypes;
import com.parablu.paracloud.constant.PCHelperConstant;
import com.parablu.paracloud.element.FileElement;
import com.parablu.paracloud.util.DiskSpaceHelper;
import com.parablu.pcbd.dao.AuditHistoryDao;
import com.parablu.pcbd.dao.BackUpImageDao;
import com.parablu.pcbd.dao.DeviceDao;
import com.parablu.pcbd.dao.ExternalStorageBackupFileDao;
import com.parablu.pcbd.dao.ExternalStorageBackupFileImageDao;
import com.parablu.pcbd.dao.SearchIndexDao;
import com.parablu.pcbd.dao.UserDao;
import com.parablu.pcbd.domain.AuditHistory;
import com.parablu.pcbd.domain.BackUpImage;
import com.parablu.pcbd.domain.BackupPolicy;
import com.parablu.pcbd.domain.ChunkDetail;
import com.parablu.pcbd.domain.ChunkFile;
import com.parablu.pcbd.domain.Cloud;
import com.parablu.pcbd.domain.CloudSettings;
import com.parablu.pcbd.domain.DeletedBackupFile;
import com.parablu.pcbd.domain.DeletedSearchIndex;
import com.parablu.pcbd.domain.Device;
import com.parablu.pcbd.domain.ExternalStorageBackupFileImage;
import com.parablu.pcbd.domain.User;
import java.io.File;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bson.types.ObjectId;
import org.springframework.beans.BeanUtils;
import org.springframework.dao.OptimisticLockingFailureException;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class BackupDeleteTimerServiceImpl
implements BackupDeleteTimerService {
    Logger logger = LogManager.getLogger(BackupDeleteTimerServiceImpl.class);
    private BackUpImageDao backUpImageDao;
    private ExternalStorageBackupFileImageDao externalStorageBackupFileImageDao;
    private ExternalStorageBackupFileDao externalStorageBackupFileDao;
    private AuditHistoryDao auditHistoryDao;
    private DeviceDao deviceDao;
    private UserDao userDao;
    private SearchIndexDao searchIndexDao;
    private CloudSettings cloudSettings;
    private static final String EXCEPTION = "Exception  :";

    public SearchIndexDao getSearchIndexDao() {
        return this.searchIndexDao;
    }

    public void setSearchIndexDao(SearchIndexDao searchIndexDao) {
        this.searchIndexDao = searchIndexDao;
    }

    public UserDao getUserDao() {
        return this.userDao;
    }

    public void setUserDao(UserDao userDao) {
        this.userDao = userDao;
    }

    public DeviceDao getDeviceDao() {
        return this.deviceDao;
    }

    public void setDeviceDao(DeviceDao deviceDao) {
        this.deviceDao = deviceDao;
    }

    public void setAuditHistoryDao(AuditHistoryDao auditHistoryDao) {
        this.auditHistoryDao = auditHistoryDao;
    }

    public void setBackUpImageDao(BackUpImageDao backUpImageDao) {
        this.backUpImageDao = backUpImageDao;
    }

    public void setExternalStorageBackupFileImageDao(ExternalStorageBackupFileImageDao externalStorageBackupFileImageDao) {
        this.externalStorageBackupFileImageDao = externalStorageBackupFileImageDao;
    }

    @Override
    public List<BackUpImage> getFilesToDeleteFromDb(int cloudId, String cloudName, long timeOffset) {
        return this.backUpImageDao.getAllOlderRevisionsExcludingCurrentRevision(cloudId, cloudName, PCHelperConstant.REVISION_STATUS.DELETED.toString(), timeOffset);
    }

    @Override
    public void deleteListsFromTables(int cloudId, String cloudName, List<BackUpImage> backUpImages) {
        for (BackUpImage backUpImage : backUpImages) {
            this.backUpImageDao.deleteRevision(cloudId, cloudName, backUpImage);
        }
    }

    @Override
    public Long getCountOfAllLatestBackupRevisions(int cloudId, String cloudName, long revisionCount) {
        return this.backUpImageDao.getCountOfAllLatestRevisions(cloudId, cloudName, PCHelperConstant.REVISION_STATUS.DELETED.toString(), revisionCount);
    }

    @Override
    public void deleteOlderBackUpRevisionsBasedOnRevisionCount(int cloudId, String cloudName, Cloud cloud, int versionsTokeep, int offset, int limit) {
        ArrayList<String> fileNameList = new ArrayList<String>();
        ArrayList<String> filePathList = new ArrayList<String>();
        ArrayList<String> deviceUUIDList = new ArrayList<String>();
        List backUpImages = this.backUpImageDao.getAllLatestFiles(cloudId, cloudName, PCHelperConstant.REVISION_STATUS.DELETED.toString(), (long)cloud.getVersioningEnabled(), offset, limit);
        for (BackUpImage backUpImage : backUpImages) {
            fileNameList.add(backUpImage.getFileName());
            filePathList.add(backUpImage.getDevicePath());
            deviceUUIDList.add(backUpImage.getDeviceUUID());
        }
        List objects2 = this.backUpImageDao.getAllRevisionsStartingFrom(cloudId, cloudName, deviceUUIDList, fileNameList, filePathList, true, cloud.getVersioningEnabled());
        ArrayList<Long> backupIds3 = new ArrayList<Long>();
        for (Object object : objects2) {
            if (((BigInteger)object[1]).intValue() <= cloud.getVersioningEnabled()) continue;
            backupIds3.add(((BigInteger)object[0]).longValue());
        }
        List backUpImages2 = new ArrayList();
        if (!backupIds3.isEmpty()) {
            backUpImages2 = this.backUpImageDao.getAllBackups(cloudId, cloudName, backupIds3);
        }
        for (BackUpImage backUpImage2 : backUpImages2) {
            String filePath = PCHelperConstant.getPropertyFileValueParabluBackupFolderBasePath((String)cloud.getCloudName()) + backUpImage2.getDeviceUUID() + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + backUpImage2.getfSPath();
            File file = new File(filePath);
            file.delete();
            File thumbnailFile = new File(PCHelperConstant.getPropertyFileValueParabluThumbnailsBasePath((String)cloud.getCloudName()) + "backup" + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + backUpImage2.getDeviceUUID() + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + backUpImage2.getfSPath());
            thumbnailFile.delete();
            long fileSize = backUpImage2.getSize() * 1024L;
            this.backUpImageDao.deleteRevision(cloud.getCloudId(), cloudName, backUpImage2);
            if (backUpImage2.getStatus().equals(PCHelperConstant.REVISION_STATUS.DELETED.toString())) continue;
            DiskSpaceHelper.updateCloudSize((String)cloud.getCloudName(), (int)0, (long)fileSize);
        }
        List objects3 = this.backUpImageDao.getAllRevisionsStartingFrom(cloudId, cloudName, deviceUUIDList, fileNameList, filePathList, false, cloud.getVersioningEnabled());
        ArrayList<Long> backupIds4 = new ArrayList<Long>();
        for (Object[] object : objects3) {
            if (((BigInteger)object[1]).intValue() <= cloud.getVersioningEnabled()) continue;
            backupIds4.add(((BigInteger)object[0]).longValue());
        }
        if (!backupIds4.isEmpty()) {
            List backUpImages3 = this.backUpImageDao.getAllBackups(cloudId, cloudName, backupIds4);
            for (BackUpImage backImage : backUpImages3) {
                this.backUpImageDao.deleteRevision(cloud.getCloudId(), cloudName, backImage);
            }
        }
    }

    @Override
    public void deleteAllOlderBackUpRevision(int cloudId, String cloudName, Cloud cloud, int offset, int limit) {
        this.deleteOlderBackUpRevisionsBasedOnRevisionCount(cloudId, cloudName, cloud, 1, offset, limit);
    }

    @Override
    public void deleteBackUpEntryFromTrashDirectly(int cloudId, String cloudName, Cloud cloud, List<BackUpImage> backUpImages) {
        for (BackUpImage backUpImage : backUpImages) {
            String filePath = PCHelperConstant.getPropertyFileValueParabluBackupFolderBasePath((String)cloud.getCloudName()) + backUpImage.getDeviceUUID() + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + backUpImage.getfSPath();
            File file = new File(filePath);
            file.delete();
            File thumbnailFile = new File(PCHelperConstant.getPropertyFileValueParabluThumbnailsBasePath((String)cloud.getCloudName()) + "backup" + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + backUpImage.getDeviceUUID() + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + backUpImage.getfSPath());
            thumbnailFile.delete();
            long fileSize = backUpImage.getSize() * 1024L;
            ObjectId bkpImageId = backUpImage.getId();
            String userName = backUpImage.getUserName();
            this.backUpImageDao.deleteRevision(cloud.getCloudId(), cloudName, backUpImage);
            if (backUpImage.getStatus().equals(PCHelperConstant.REVISION_STATUS.DELETED.toString())) continue;
            DiskSpaceHelper.updateCloudSize((String)cloud.getCloudName(), (int)0, (long)fileSize);
            if (!backUpImage.isExternalStorage()) continue;
            ExternalStorageBackupFileImage externalStorageBackupFileImage = new ExternalStorageBackupFileImage();
            externalStorageBackupFileImage.setBackUpImageId(bkpImageId);
            externalStorageBackupFileImage.setUserName(userName);
            this.externalStorageBackupFileImageDao.saveExternalStorageBackupFileImage(cloudId, cloudName, externalStorageBackupFileImage);
        }
    }

    @Override
    public void deleteBackUpEntryFromTrashDirectly(int cloudId, String cloudName, Cloud cloud, FileElement fileElement, Device device) {
        List fileRevisions2;
        List fileRevisions;
        this.logger.debug(" LOG FOR DELETE INSIDED SERVICE ..... ");
        if (fileElement.getFileCompletePath() == null) {
            this.logger.debug(" LOG FOR DELETE INSIDED SERVICE ..getVersionsForNullPath ... ");
            fileRevisions = this.backUpImageDao.getVersionsForNullPath(cloudId, cloudName, fileElement.getFileName(), device.getId());
        } else {
            this.logger.debug(" LOG FOR DELETE INSIDED SERVICE ..getVersions ... ");
            boolean readPreference = false;
            if (PCHelperConstant.isReadPreferenceFromSecondary()) {
                readPreference = true;
            }
            fileRevisions = this.backUpImageDao.getVersions(cloudId, cloudName, fileElement.getFileName(), fileElement.getFileCompletePath(), device, readPreference);
        }
        this.logger.debug(" LOG FOR DELETE INSIDED SERVICE ..deleteBackUpEntryFromTrashDirectly ... ");
        this.deleteBackUpEntryFromTrashDirectly(cloud.getCloudId(), cloudName, cloud, fileRevisions);
        this.logger.debug(" AFTER DELETE ..deleteBackUpEntryFromTrashDirectly ... ");
        if (!fileElement.isFolder()) {
            return;
        }
        if (fileElement.getFileCompletePath() == null) {
            this.logger.debug(" AFTER DELETE ..getAllVersionsOfChildren1 ... ");
            fileRevisions2 = this.backUpImageDao.getAllVersionsOfChildren(cloudId, cloudName, fileElement.getFileName(), device.getId());
        } else {
            this.logger.debug(" AFTER DELETE ..getAllVersionsOfChildren2 ... ");
            fileRevisions2 = this.backUpImageDao.getAllVersionsOfChildren(cloudId, cloudName, fileElement.getFileCompletePath() + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + fileElement.getFileName(), device.getId());
        }
        this.logger.debug(" before DELETE ..deleteBackUpEntryFromTrashDirectly ... ");
        this.deleteBackUpEntryFromTrashDirectly(cloud.getCloudId(), cloudName, cloud, fileRevisions2);
        this.logger.debug(" after DELETE ..deleteBackUpEntryFromTrashDirectly ... ");
    }

    private String getDedupValue(String userName) {
        BackupPolicy backupPolicy;
        String dedupVal = null;
        User user = this.userDao.getUserInfoByName(1, userName);
        if (user != null && (backupPolicy = this.userDao.getBackupPolicyByPolicyName(1, user.getPolicyName())) != null) {
            dedupVal = backupPolicy.getDedup();
        }
        if (!StringUtils.isEmpty(dedupVal)) {
            this.logger.debug("...dedu...." + dedupVal);
            if ("DISABLED".equalsIgnoreCase(dedupVal)) {
                dedupVal = "GLOBAL".toString();
            }
        }
        return dedupVal;
    }

    @Override
    public void deleteBackupFilesFromDB(int cloudId, String cloudName, String deviceUUID, String userName, FileElement fileElement, Device device, boolean isSearchEnabled) {
        List<Object> backupImageList = new ArrayList();
        String deletedFolderType = "";
        int actionType = 0;
        String fileElementDevicePath = "";
        String dedupval = this.getDedupValue(userName);
        if (fileElement.isFolder()) {
            if (StringUtils.isEmpty((Object)fileElement.getFileCompletePath())) {
                List backupImageListDrive = this.backUpImageDao.getVersionsForNullPath(cloudId, cloudName, fileElement.getFileName(), device.getId());
                backupImageList.addAll(backupImageListDrive);
                deletedFolderType = device.getDeviceType().equals(Device.TYPE.SHAREPOINT.toString()) ? "Drive " + fileElement.getFileName() + " in Asset name " + device.getDeviceName() : "Drive " + fileElement.getFileName() + " of User " + device.getUserName() + " in Asset name " + device.getDeviceName();
                fileElementDevicePath = fileElement.getFileName();
                actionType = PCActionTypes.DRIVE_DELETE.getActionTypeValue();
            } else {
                List<BackUpImage> backupImageListFolder = this.getVersionsByFileName(cloudId, cloudName, fileElement, device);
                backupImageList.addAll(backupImageListFolder);
                fileElementDevicePath = fileElement.getFileCompletePath() + "/" + fileElement.getFileName();
                if (device.getDeviceType().equals(Device.TYPE.SHAREPOINT.toString())) {
                    deletedFolderType = "Folder " + fileElement.getFileCompletePath() + "/" + fileElement.getFileName() + " in Asset name " + device.getDeviceName();
                    actionType = PCActionTypes.FOLDER_DELETE.getActionTypeValue();
                } else {
                    deletedFolderType = "Folder " + fileElement.getFileCompletePath() + "/" + fileElement.getFileName() + " of User " + device.getUserName() + " in Asset name " + device.getDeviceName();
                    actionType = PCActionTypes.FOLDER_DELETE.getActionTypeValue();
                }
            }
            ArrayList<BackUpImage> backupImageListAllFoder = new ArrayList<BackUpImage>();
            this.getLatestFoldersRecursive(cloudName, userName, fileElementDevicePath, device, cloudId, backupImageListAllFoder);
            backupImageList.addAll(backupImageListAllFoder);
            this.logger.debug("BackupImage List val---->:" + backupImageList.size());
            this.deleteBackUpFolderEntryFromDB(cloudId, cloudName, backupImageList, device, userName);
            if (isSearchEnabled) {
                try {
                    this.logger.debug("..start addding to delete search index for folder...");
                    DeletedSearchIndex deletedSearchIndex = new DeletedSearchIndex();
                    deletedSearchIndex.setFolderDelete(true);
                    deletedSearchIndex.setDeviceId(device.getId());
                    deletedSearchIndex.setDeviceUUID(deviceUUID);
                    deletedSearchIndex.setCloudId(cloudId);
                    deletedSearchIndex.setCloudName(cloudName);
                    deletedSearchIndex.setUserName(device.getUserName());
                    deletedSearchIndex.setDevicePath(fileElementDevicePath);
                    this.searchIndexDao.addDeleteIndex(deletedSearchIndex);
                    this.logger.debug("..end of addding to delete search index for folder...");
                }
                catch (Exception exception) {
                    this.logger.error("...unabel to save delete index for folder " + exception.getMessage());
                }
            }
        } else {
            if (!StringUtils.isEmpty((Object)device.getDeviceType()) && device.getDeviceType().equalsIgnoreCase(Device.TYPE.OUTLOOK.name())) {
                BackUpImage backUpImage = this.backUpImageDao.getMailBackUpImageInfo(cloudId, device, new ObjectId(fileElement.getBackupId()));
                if (backUpImage != null) {
                    backupImageList.add(backUpImage);
                }
            } else {
                backupImageList = this.getVersionsByFileName(cloudId, cloudName, fileElement, device);
            }
            if (device.getDeviceType().equals(Device.TYPE.SHAREPOINT.toString())) {
                deletedFolderType = "file " + fileElement.getFileCompletePath() + "/" + fileElement.getFileName() + " in Asset name " + device.getDeviceName();
                actionType = PCActionTypes.FILE_DELETE.getActionTypeValue();
            }
            if (device.getDeviceType().equals(Device.TYPE.ONEDRIVE.toString())) {
                deletedFolderType = "file " + fileElement.getFileCompletePath() + "/" + fileElement.getFileName() + " of User " + device.getUserName() + " in Asset name " + device.getDeviceName();
                actionType = PCActionTypes.FILE_DELETE.getActionTypeValue();
            } else {
                deletedFolderType = "Mail " + fileElement.getFileCompletePath() + "/" + fileElement.getFileName() + " of User " + device.getUserName() + " in Asset name " + device.getDeviceName();
                actionType = PCActionTypes.FILE_DELETE.getActionTypeValue();
            }
            this.logger.debug("deleteBackupFilesFromDB ...BackupImage List :" + backupImageList.size());
            try {
                if (isSearchEnabled) {
                    this.logger.debug("..start addding to delete search index for file..." + backupImageList.size());
                    for (BackUpImage backUpImage : backupImageList) {
                        DeletedSearchIndex deletedSearchIndex = new DeletedSearchIndex();
                        deletedSearchIndex.setId(backUpImage.getId());
                        deletedSearchIndex.setDeviceId(device.getId());
                        deletedSearchIndex.setDeviceUUID(deviceUUID);
                        deletedSearchIndex.setCloudId(cloudId);
                        deletedSearchIndex.setCloudName(cloudName);
                        deletedSearchIndex.setUserName(device.getUserName());
                        deletedSearchIndex.setDevicePath(fileElementDevicePath);
                        deletedSearchIndex.setId(backUpImage.getId());
                        this.searchIndexDao.addDeleteIndex(deletedSearchIndex);
                    }
                    this.logger.debug("..end of addding to delete search index for file...");
                }
            }
            catch (Exception e) {
                this.logger.error("...unabel to save delete index for files " + e.getMessage());
            }
            this.deleteBackupImageForDeletedFile(cloudId, cloudName, backupImageList, device, dedupval);
        }
        try {
            this.saveStatisticToDatabase(cloudId, cloudName, "Deleted The Backup " + deletedFolderType, userName, "", actionType);
        }
        catch (Exception e) {
            this.logger.trace(EXCEPTION + e);
            this.logger.error(EXCEPTION + e.getMessage());
        }
    }

    private void getLatestFoldersRecursive(String cloudName, String userName, String filePath, Device device, int cloudId, List<BackUpImage> backupImages) {
        List backUpImagesTemp = this.backUpImageDao.getLatestFoldersRecursive(cloudId, cloudName, device, filePath);
        backupImages.addAll(backUpImagesTemp);
        System.setProperty("java.util.concurrent.ForkJoinPool.common.parallelism", "20");
        if (!CollectionUtils.isEmpty((Collection)backUpImagesTemp)) {
            Stream stream = backUpImagesTemp.parallelStream();
            stream.forEach(backUpImage -> {
                String devicePath = backUpImage.getDevicePath() + "/" + backUpImage.getFileName();
                this.logger.debug("Inside loop after getting folders..bkpimages list size:" + backUpImagesTemp.size());
                if (StringUtils.isEmpty((Object)backUpImage.getDevicePath())) {
                    devicePath = backUpImage.getFileName();
                }
                this.logger.debug("Inside loop to get getLatestFoldersRecursive:" + devicePath);
                this.getLatestFoldersRecursive(cloudName, userName, devicePath, device, cloudId, backupImages);
            });
        }
    }

    private List<BackUpImage> getVersionsByFileName(int cloudId, String cloudName, FileElement fileElement, Device device) {
        List backupImageList = this.backUpImageDao.getVersionsFilesToDelete(cloudId, cloudName, fileElement.getFileName(), fileElement.getFileCompletePath(), device);
        return backupImageList;
    }

    private void deleteBackupImageForDeletedFile(int cloudId, String cloudName, List<BackUpImage> backupImageFileList, Device device, String dedupVal) {
        ArrayList<BackUpImage> filteredBackupImageList = new ArrayList<BackUpImage>();
        this.deleteLatestVerFiles(cloudId, backupImageFileList, device, filteredBackupImageList, cloudName, dedupVal);
        this.deleteAllFiles(cloudId, backupImageFileList, device, cloudName, dedupVal);
    }

    private void deleteBackUpFolderEntryFromDB(int cloudId, String cloudName, List<BackUpImage> backupImageList, Device device, String userName) {
        for (BackUpImage backupImage : backupImageList) {
            try {
                DeletedBackupFile deletedBackupFile = new DeletedBackupFile();
                this.logger.debug("move backup image record to Deleted backup file ");
                BeanUtils.copyProperties((Object)backupImage, (Object)deletedBackupFile);
                this.logger.debug("Save in Deleted backup file ");
                this.backUpImageDao.saveDeletedBackupFileInDB(cloudId, cloudName, deletedBackupFile, device);
                this.logger.debug("delete record from Backup image");
                this.backUpImageDao.deleteBackupFile(cloudId, cloudName, backupImage, device);
            }
            catch (Exception e) {
                this.logger.trace(EXCEPTION + e);
                this.logger.error(EXCEPTION + e.getMessage());
            }
        }
    }

    private void deleteAllFiles(int cloudId, List<BackUpImage> backupImageFileList, Device device, String cloudName, String dedupVal) {
        long storageUtilized = 0L;
        for (BackUpImage backupImage : backupImageFileList) {
            DeletedBackupFile deletedBkpFile = new DeletedBackupFile();
            BeanUtils.copyProperties((Object)backupImage, (Object)deletedBkpFile);
            this.deRefChunks(backupImage, dedupVal);
            this.backUpImageDao.deleteBackupFile(cloudId, cloudName, backupImage, device);
            storageUtilized += backupImage.getSize();
        }
        storageUtilized = -storageUtilized;
        this.logger.debug("...Updating size..." + storageUtilized);
        this.deviceDao.updateSizeDeviceBackupOverView(cloudId, device.getDeviceUUID(), Long.valueOf(storageUtilized), null);
    }

    private void deleteLatestVerFiles(int cloudId, List<BackUpImage> backupImageFileList, Device device, List<BackUpImage> filteredBackupImageList, String cloudName, String dedupVal) {
        long storageUtilized = 0L;
        long latestVersionChange = 0L;
        for (BackUpImage backupImage : filteredBackupImageList) {
            DeletedBackupFile deletedBkpFile = new DeletedBackupFile();
            BeanUtils.copyProperties((Object)backupImage, (Object)deletedBkpFile);
            this.deRefChunks(backupImage, dedupVal);
            this.backUpImageDao.deleteBackupFile(cloudId, cloudName, backupImage, device);
            storageUtilized += backupImage.getSize();
            latestVersionChange += backupImage.getSize();
            backupImageFileList.remove(backupImage);
        }
        storageUtilized = -storageUtilized;
        latestVersionChange = -latestVersionChange;
        this.logger.debug("...Updating size..." + storageUtilized + "...latestVersionChange.." + latestVersionChange);
        this.deviceDao.updateSizeDeviceBackupOverView(cloudId, device.getDeviceUUID(), Long.valueOf(storageUtilized), Long.valueOf(latestVersionChange));
    }

    private void deRefChunks(BackUpImage backupImage, String dedupVal) {
        try {
            if (backupImage.getChunkFiles() != null && !CollectionUtils.isEmpty((Collection)backupImage.getChunkFiles())) {
                for (ChunkFile chunkFile : backupImage.getChunkFiles()) {
                    this.logger.debug(".............." + chunkFile.getMd5());
                    ChunkDetail chunkDetail = null;
                    if ((chunkDetail = this.getChunkDetailByBkpImageUploadTimeAndChunkUploadedTime(backupImage, dedupVal, chunkFile, chunkDetail)) == null) continue;
                    try {
                        chunkDetail.setRefCount(chunkDetail.getRefCount() - 1);
                        this.externalStorageBackupFileDao.updateChunkDetail(1, chunkDetail);
                        this.logger.debug(" Chunk updated succcessfully for delete ..........");
                    }
                    catch (OptimisticLockingFailureException e) {
                        this.logger.trace("" + (Object)((Object)e));
                        this.logger.error("Exception while removing backup image :" + e.getMessage());
                        int count = 0;
                        int maxTries = PCHelperConstant.getMaxRetryForChunkUpdate();
                        this.retryDereferenceChunk(chunkFile, count, maxTries, backupImage, dedupVal);
                    }
                }
            }
        }
        catch (Exception e) {
            this.logger.trace("" + e);
            this.logger.error("Exception while removing backup image :" + e.getMessage());
        }
    }

    private ChunkDetail getChunkDetailByBkpImageUploadTimeAndChunkUploadedTime(BackUpImage backupImage, String dedupVal, ChunkFile chunkFile, ChunkDetail chunkDetail) {
        List chunkDetailList = this.externalStorageBackupFileDao.getChunkDetailListForMd5(1, chunkFile.getMd5(), dedupVal, backupImage.getUserName(), false, true);
        this.logger.debug("chunkDetail list:" + chunkDetailList);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)chunkDetailList)) {
            if (this.cloudSettings == null) {
                this.cloudSettings = this.externalStorageBackupFileDao.getCloudSettings(1);
            }
            if (this.cloudSettings != null && this.cloudSettings.getDedupStartTime() != 0L) {
                this.logger.debug(this.cloudSettings.getDedupStartTime() + "cloudSettings.getDedupStartTime()+ :backupImage.getLastServerModifiedTime() :" + backupImage.getLastServerModifiedTime());
                chunkDetail = backupImage.getLastServerModifiedTime() > this.cloudSettings.getDedupStartTime() ? (ChunkDetail)chunkDetailList.stream().filter(chunkDetail1 -> chunkDetail1.getChunkCreatedTime() > this.cloudSettings.getDedupStartTime()).findFirst().orElse(null) : (ChunkDetail)chunkDetailList.stream().filter(chunkDetail1 -> chunkDetail1.getChunkCreatedTime() < this.cloudSettings.getDedupStartTime()).findFirst().orElse(null);
            } else {
                chunkDetail = (ChunkDetail)chunkDetailList.get(0);
            }
        }
        return chunkDetail;
    }

    private void retryDereferenceChunk(ChunkFile chunkFile, int count1, int maxTries, BackUpImage backupImage, String dedupVal) {
        int count = count1;
        while (true) {
            try {
                this.logger.debug(" retry chunk update ..............." + chunkFile.getMd5());
                ChunkDetail chunkDetailObj = null;
                chunkDetailObj = this.getChunkDetailByBkpImageUploadTimeAndChunkUploadedTime(backupImage, dedupVal, chunkFile, chunkDetailObj);
                chunkDetailObj.setRefCount(chunkDetailObj.getRefCount() - 1);
                this.logger.debug(chunkFile.getMd5() + " @@@@@@ ................ retry count " + count);
                this.externalStorageBackupFileDao.saveChunkDetail(1, chunkDetailObj);
            }
            catch (Exception ex) {
                this.logger.trace("" + ex);
                this.logger.error(" ex ..." + ex.getMessage());
                if (++count != maxTries) continue;
            }
            break;
        }
    }

    private List<BackUpImage> getFilteredBackupImageList(List<BackUpImage> backUpImages) {
        this.logger.debug("Inside getFilteredBackupImageList");
        ArrayList<BackUpImage> filteredBackUpImages = new ArrayList<BackUpImage>();
        Map<String, List<BackUpImage>> map = backUpImages.stream().collect(Collectors.groupingBy(BackUpImage::getFileName));
        for (Map.Entry<String, List<BackUpImage>> entry : map.entrySet()) {
            this.logger.debug(entry.getKey() + "...before..." + entry.getValue().size());
            List files = entry.getValue().stream().filter(file -> !file.getStatus().equalsIgnoreCase("DELETED")).collect(Collectors.toList());
            this.logger.debug(entry.getKey() + "...after..." + files.size());
            filteredBackUpImages.add(files.stream().sorted(Comparator.comparing(BackUpImage::getLastServerModifiedTime).reversed()).findFirst().get());
        }
        this.logger.debug("...after..." + filteredBackUpImages.size());
        return filteredBackUpImages;
    }

    private void saveStatisticToDatabase(int cloudId, String cloudName, String action, String actionByUser, String actionOnUser, int actionType) {
        AuditHistory audit = new AuditHistory();
        audit.setAction(action);
        audit.setActionByUserName(actionByUser);
        audit.setActionOnObject("");
        audit.setTimestamp(System.currentTimeMillis());
        audit.setActionUsingObject("Portal");
        audit.setActionType(actionType);
        this.logger.debug("Action type" + audit.getActionType());
        this.auditHistoryDao.saveAudit(cloudId, cloudName, audit);
    }

    public ExternalStorageBackupFileDao getExternalStorageBackupFileDao() {
        return this.externalStorageBackupFileDao;
    }

    public void setExternalStorageBackupFileDao(ExternalStorageBackupFileDao externalStorageBackupFileDao) {
        this.externalStorageBackupFileDao = externalStorageBackupFileDao;
    }
}

