/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.bluvault.backup.service.impl;

import com.parablu.bluvault.backup.service.BackupDataCleanerService;
import com.parablu.paracloud.constant.PCHelperConstant;
import com.parablu.paracloud.util.PathConversionHelper;
import com.parablu.pcbd.dao.AlertHistoryDao;
import com.parablu.pcbd.dao.AuditHistoryDao;
import com.parablu.pcbd.dao.BackUpImageDao;
import com.parablu.pcbd.dao.BackupAHDao;
import com.parablu.pcbd.dao.BackupBatchDao;
import com.parablu.pcbd.dao.BackupPolicyDao;
import com.parablu.pcbd.dao.DailyUserBackupOverviewDao;
import com.parablu.pcbd.dao.DeleteExternalStorageDao;
import com.parablu.pcbd.dao.DeletedUserDao;
import com.parablu.pcbd.dao.DeviceDao;
import com.parablu.pcbd.dao.ExternalStorageBackupFileDao;
import com.parablu.pcbd.dao.FileRevisionDao;
import com.parablu.pcbd.dao.OfficeBackupPolicyDao;
import com.parablu.pcbd.dao.UserDao;
import com.parablu.pcbd.dao.UserDefinedFoldersDao;
import com.parablu.pcbd.dao.UserSyncOverViewDao;
import com.parablu.pcbd.domain.BackUpImage;
import com.parablu.pcbd.domain.BackupBatch;
import com.parablu.pcbd.domain.BackupFile;
import com.parablu.pcbd.domain.BackupPolicy;
import com.parablu.pcbd.domain.ChunkDetail;
import com.parablu.pcbd.domain.ChunkFile;
import com.parablu.pcbd.domain.Cloud;
import com.parablu.pcbd.domain.CloudSettings;
import com.parablu.pcbd.domain.ConsolidatedImage;
import com.parablu.pcbd.domain.DeletedUser;
import com.parablu.pcbd.domain.Device;
import com.parablu.pcbd.domain.FileRevision;
import com.parablu.pcbd.domain.OfficeBackupPolicy;
import com.parablu.pcbd.domain.SyncOverView;
import com.parablu.pcbd.domain.User;
import com.parablu.pcbd.domain.UserSyncOverView;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bson.types.ObjectId;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.OptimisticLockingFailureException;
import org.springframework.util.CollectionUtils;

public class BackupDataCleanerServiceImpl
implements BackupDataCleanerService {
    private static Logger logger = LogManager.getLogger(BackupDataCleanerServiceImpl.class);
    public static final String CLOUD_PATH_SEPARATOR = System.getProperty("file.separator");
    private AlertHistoryDao alertHistoryDao;
    private AuditHistoryDao auditHistoryDao;
    private BackUpImageDao backUpImageDao;
    private BackupPolicyDao backupPolicyDao;
    private BackupBatchDao backupBatchDao;
    private ExternalStorageBackupFileDao externalStorageBackupFileDao;
    private UserDefinedFoldersDao userDefinedFoldersDao;
    private DeleteExternalStorageDao deleteExternalStorageDao;
    private DeletedUserDao deletedUserDao;
    private DeviceDao deviceDao;
    private BackupAHDao backupAHDao;
    private CloudSettings cloudSettings;
    @Autowired
    private FileRevisionDao fileRevisionDao;
    @Autowired
    private UserDao userDao;
    private DailyUserBackupOverviewDao dailyUserBackupOverviewDao;
    @Autowired
    private UserSyncOverViewDao userSyncOverViewDao;
    @Resource
    private OfficeBackupPolicyDao oneDriveBackupPolicyDao;

    public void setDailyUserBackupOverviewDao(DailyUserBackupOverviewDao dailyUserBackupOverviewDao) {
        this.dailyUserBackupOverviewDao = dailyUserBackupOverviewDao;
    }

    public void setAlertHistoryDao(AlertHistoryDao alertHistoryDao) {
        this.alertHistoryDao = alertHistoryDao;
    }

    public void setAuditHistoryDao(AuditHistoryDao auditHistoryDao) {
        this.auditHistoryDao = auditHistoryDao;
    }

    public void setExternalStorageBackupFileDao(ExternalStorageBackupFileDao externalStorageBackupFileDao) {
        this.externalStorageBackupFileDao = externalStorageBackupFileDao;
    }

    public void setUserDefinedFoldersDao(UserDefinedFoldersDao userDefinedFoldersDao) {
        this.userDefinedFoldersDao = userDefinedFoldersDao;
    }

    public void setFileRevisionDao(FileRevisionDao fileRevisionDao) {
        this.fileRevisionDao = fileRevisionDao;
    }

    public void setUserDao(UserDao userDao) {
        this.userDao = userDao;
    }

    public void setUserSyncOverViewDao(UserSyncOverViewDao userSyncOverViewDao) {
        this.userSyncOverViewDao = userSyncOverViewDao;
    }

    @Override
    public void deleteDBEntriesForDeletedUser(int cloudId, String cloudName, String userName) {
        boolean userUnderLegalHold = this.isUserUnderLegalHoldForUserName(cloudId, userName);
        logger.debug("deleting for user>>>>>>>>>>>" + userUnderLegalHold);
        if (!userUnderLegalHold) {
            logger.debug("deleting for user>>>>>>>>>>>");
            try {
                this.alertHistoryDao.deleteAlertHistoryForUser(cloudId, cloudName, userName);
            }
            catch (Exception e) {
                logger.trace("Delete job failed for alert history  " + e);
                logger.error("Delete job failed for alert history USER>>>>>>>" + userName + e.getMessage());
            }
            try {
                this.auditHistoryDao.deleteRecordsForUser(cloudId, cloudName, userName);
            }
            catch (Exception e) {
                logger.trace("Delete job failed for audit History " + e);
                logger.error("Delete job failed for audit History USER>>>>>>>" + userName + e.getMessage());
            }
            try {
                this.backupBatchDao.deleteRecordsForUser(cloudId, cloudName, userName);
            }
            catch (Exception e) {
                logger.trace("Delete job failed for backup batch " + e);
                logger.error("Delete job failed for backup batch USER>>>>>>>" + userName + e.getMessage());
            }
            try {
                this.externalStorageBackupFileDao.deleteTableForUser(cloudId, cloudName, userName);
            }
            catch (Exception e) {
                logger.trace("Delete job failed for externalStorageBackupFileDao" + e);
                logger.error("Delete job failed for externalStorageBackupFileDao USER>>>>>>>" + userName + e.getMessage());
            }
            try {
                this.userDefinedFoldersDao.deleteUserDefinedFoldersForUser(cloudId, cloudName, userName, PCHelperConstant.FOLDER_TYPE.EXCLUSION.toString());
                this.userDefinedFoldersDao.deleteUserDefinedFoldersForUser(cloudId, cloudName, userName, PCHelperConstant.FOLDER_TYPE.INCLUSION.toString());
            }
            catch (Exception e) {
                logger.trace("Delete job failed for userDefinedFoldersDao " + e);
                logger.error("Delete job failed for userDefinedFoldersDao USER>>>>>>>" + userName + e.getMessage());
            }
            try {
                this.backupAHDao.deleteAllActivityForUser(cloudId, cloudName, userName);
            }
            catch (Exception e) {
                logger.trace("Delete job failed for Backup Activity History " + e);
                logger.error("Delete job failed for Backup Activity History USER>>>>>>>" + userName + e.getMessage());
            }
            try {
                this.dailyUserBackupOverviewDao.deleteDailyUserBackupOverviewByUserName(cloudId, userName);
            }
            catch (Exception e) {
                logger.trace("Delete job failed for Daily User Backup Overview " + e);
                logger.error("Delete job failed forDaily User Backup Overview for USER" + userName + e.getMessage());
            }
            try {
                this.deviceDao.deleteAllDeviceByUserName(cloudId, cloudName, userName);
            }
            catch (Exception e) {
                logger.trace("Delete job failed for delete devices " + e);
                logger.error("" + userName + e.getMessage());
            }
            try {
                UserSyncOverView userSyncOverView;
                User user = this.userDao.getUserInfoByName(cloudId, userName);
                if (user != null && (userSyncOverView = user.getUserSyncOverView()) != null) {
                    long fileSize = new Double(userSyncOverView.getStorageUtilized()).longValue();
                    SyncOverView syncOverView = this.fileRevisionDao.getSyncOverview(1);
                    long total = syncOverView.getTotalSizeUploaded();
                    long actual = total - fileSize;
                    syncOverView.setTotalSizeUploaded(actual);
                    this.fileRevisionDao.saveSyncOverview(1, syncOverView);
                    this.userSyncOverViewDao.removeUserSyncOverViewToDB(cloudId, userSyncOverView);
                }
            }
            catch (Exception e) {
                logger.trace("Delete job failed for updating the sync size >>>> " + e);
                logger.error("Delete job failed for updating the sync size >>>> " + userName + e.getMessage());
            }
            try {
                List<ObjectId> allMySharedFilesIds = this.getAllMySharedFilesIds(cloudId, cloudName, userName);
                this.fileRevisionDao.removeRevisionsByUserName(1, userName, allMySharedFilesIds);
            }
            catch (Exception e) {
                logger.trace("Delete job failed for delete revisions >>>> " + e);
                logger.error("Delete job failed for delete revisions >>>> " + userName + e.getMessage());
            }
            try {
                List<Object> sharedConsolidatedFiles = new ArrayList();
                sharedConsolidatedFiles = this.getSharedConsIds(cloudId, cloudName, userName);
                this.fileRevisionDao.removeConsolidatedImagebyUserName(1, userName, sharedConsolidatedFiles);
            }
            catch (Exception e) {
                logger.trace("Delete job failed for delete ConsolidatedImage >>>> " + e);
                logger.error("Delete job failed for delete ConsolidatedImage >>>> " + userName + e.getMessage());
            }
        } else {
            logger.debug("...user under legalhold...." + userName);
        }
    }

    public void setBackUpImageDao(BackUpImageDao backUpImageDao) {
        this.backUpImageDao = backUpImageDao;
    }

    private void deleteFilesForOfficeProductByUsers(Cloud cloud, int cloudId, OfficeBackupPolicy backupPolicy, long noOfDaysAgoTimeStamp, OfficeBackupPolicy oneDrivePolicy) {
        ArrayList<String> policyNames = new ArrayList<String>();
        policyNames.add(oneDrivePolicy.getPolicyName());
        List userList = this.userDao.getAllUsersByPolicyNames(cloud.getCloudId(), policyNames, oneDrivePolicy.getPolicyType());
        if (!CollectionUtils.isEmpty((Collection)userList)) {
            for (User user : userList) {
                logger.debug(user.isActive() + "..user files to delete..." + user.getUserName());
                if (user == null || !user.isActive()) continue;
                boolean userUnderLegalHold = this.isUserUnderLegalHoldForUserName(cloudId, user.getUserName());
                logger.debug("deleting for user>>>>>>>>>>>" + userUnderLegalHold);
                if (userUnderLegalHold) continue;
                this.deleteFileByUserAndPolicy(cloud, cloudId, null, noOfDaysAgoTimeStamp, user, oneDrivePolicy);
            }
        }
    }

    @Override
    public void deleteODTableEntriesAndMarkchunksToDelete(int cloudId, String cloudName, String userName, List<BackupFile> deletedBackupFiles) {
        int count = 0;
        logger.debug("backup file Count before>>>>>>>>>>>>>>>>> check" + deletedBackupFiles.size());
        for (BackupFile backupFile : deletedBackupFiles) {
            boolean canBeDeleted = this.checkPrelimConditionsBeforeDelete(cloudId, cloudName, userName, backupFile);
            if (!canBeDeleted) continue;
            if (org.springframework.util.StringUtils.isEmpty((Object)backupFile.getDedupBackupId())) {
                ++count;
                StringBuilder chunkFileName = new StringBuilder(((ChunkFile)backupFile.getChunkFiles().get(0)).getFileName());
                int occurance = StringUtils.countMatches((String)chunkFileName.toString(), (String)".");
                if (occurance == 0) {
                    chunkFileName.append("." + backupFile.getId().toString());
                }
                this.deleteExternalStorageDao.insertBackupFileForDeletion(cloudId, chunkFileName.toString(), userName, backupFile.getMd5());
            }
            this.externalStorageBackupFileDao.deleteBackupFile(cloudId, cloudName, userName, backupFile.getId().toString());
        }
        logger.debug("backup file Count After>>>>>>>>>>>>>> check" + count);
    }

    private boolean checkPrelimConditionsBeforeDelete(int cloudId, String cloudName, String userName, BackupFile backupFile) {
        boolean canBeDeleted = true;
        BackupFile parentFile = this.externalStorageBackupFileDao.getBackupFileForDedupBackupId(cloudId, cloudName, userName, backupFile.getId().toString());
        if (parentFile != null) {
            logger.debug("inside parent file is not null>>>>>>>>" + parentFile.getFileName());
            canBeDeleted = false;
        }
        return canBeDeleted;
    }

    public void setDeleteExternalStorageDao(DeleteExternalStorageDao deleteExternalStorageDao) {
        this.deleteExternalStorageDao = deleteExternalStorageDao;
    }

    public void setBackupBatchDao(BackupBatchDao backupBatchDao) {
        this.backupBatchDao = backupBatchDao;
    }

    public void setDeviceDao(DeviceDao deviceDao) {
        this.deviceDao = deviceDao;
    }

    @Override
    public long getCountOfODTable(int cloudId, String cloudName, String userName) {
        return this.externalStorageBackupFileDao.getCountOfTheTable(cloudId, cloudName, userName);
    }

    @Override
    public List<BackupFile> getBackupFiles(int cloudId, String cloudName, String userName, int skipValue) {
        return this.externalStorageBackupFileDao.getBackupFiles(cloudId, cloudName, userName, skipValue);
    }

    @Override
    public List<ObjectId> getDeletedBackupIds(int cloudId, String cloudName, String userName, List<ObjectId> backupIds) {
        return this.backUpImageDao.getListOfDeletedBackupIds(cloudId, userName, backupIds);
    }

    @Override
    public boolean saveDeletedUser(int cloudId, String cloudName, String userName) {
        DeletedUser deletedUser = new DeletedUser();
        User user = this.userDao.getUserByName(cloudId, userName);
        BeanUtils.copyProperties((Object)user, (Object)deletedUser);
        ArrayList<String> deviceUUIDs = new ArrayList<String>();
        List allDevicesForUser = this.deviceDao.getAllDeviceByUserName(cloudId, userName);
        if (allDevicesForUser != null) {
            for (Device device : allDevicesForUser) {
                if (device == null || device.getDeviceUUID() == null) continue;
                deviceUUIDs.add(device.getDeviceUUID());
            }
        }
        deletedUser.setUserName(userName);
        deletedUser.setLastModifiedTimestamp(String.valueOf(System.currentTimeMillis()));
        deletedUser.setDeviceUUIDs(deviceUUIDs);
        this.deletedUserDao.saveDeletedUser(cloudId, cloudName, deletedUser);
        return false;
    }

    public void setDeletedUserDao(DeletedUserDao deletedUserDao) {
        this.deletedUserDao = deletedUserDao;
    }

    public void setBackupAHDao(BackupAHDao backupAHDao) {
        this.backupAHDao = backupAHDao;
    }

    @Override
    public void dereferenceChunksInBackupImages(int cloudId, String cloudName, String userName, Device device) {
        this.dereferanceBackupTable(cloudId, cloudName, userName, device);
        this.dereferanceSyncTable(cloudId, cloudName, userName);
    }

    private void dereferanceSyncTable(int cloudId, String cloudName, String userName) {
        List<ObjectId> allMySharedFilesIds = this.getAllMySharedFilesIds(cloudId, cloudName, userName);
        List backupFiles = this.externalStorageBackupFileDao.getAllSyncFiles(cloudId, cloudName, userName, allMySharedFilesIds);
        int counter = 1;
        String dedupVal = "USER";
        while (!CollectionUtils.isEmpty((Collection)backupFiles)) {
            logger.debug("Inside dereferencing chunk files in loop size is>>>" + backupFiles.size());
            ArrayList<ObjectId> objectIds = new ArrayList<ObjectId>();
            for (BackupFile backUpImage : backupFiles) {
                objectIds.add(backUpImage.getId());
                if (backUpImage.getChunkFiles() == null || CollectionUtils.isEmpty((Collection)backUpImage.getChunkFiles())) continue;
                for (ChunkFile chunkFile : backUpImage.getChunkFiles()) {
                    ChunkDetail chunkDetail = null;
                    chunkDetail = this.getChunkDetailByBkpImageUploadTimeAndChunkUploadedTime(backUpImage.getUserName(), backUpImage.getUploadedTimestamp(), dedupVal, chunkFile, chunkDetail, false);
                    if (chunkDetail == null) {
                        logger.debug("................chunk detail is empty for userName " + userName + " so search with userName case insesitive...........");
                        chunkDetail = this.getChunkDetailByBkpImageUploadTimeAndChunkUploadedTime(backUpImage.getUserName(), backUpImage.getUploadedTimestamp(), dedupVal, chunkFile, chunkDetail, true);
                    }
                    if (chunkDetail == null) continue;
                    try {
                        chunkDetail.setRefCount(chunkDetail.getRefCount() - 1);
                        this.externalStorageBackupFileDao.updateChunkDetail(1, chunkDetail);
                        logger.debug(" Chunk updated succcessfully for delete ..........");
                    }
                    catch (OptimisticLockingFailureException e) {
                        logger.trace("" + (Object)((Object)e));
                        logger.error("Exception while removing backup image :" + e.getMessage());
                        int count = 0;
                        int maxTries = PCHelperConstant.getMaxRetryForChunkUpdate();
                        this.retryDereferenceChunk(chunkFile, count, maxTries, backUpImage.getUserName(), backUpImage.getUploadedTimestamp(), dedupVal);
                    }
                }
            }
            this.externalStorageBackupFileDao.deleteSyncFiles(cloudId, objectIds, cloudName);
            backupFiles = this.externalStorageBackupFileDao.getAllSyncFiles(cloudId, cloudName, userName, allMySharedFilesIds);
            logger.debug("dereferencing the chunk in loop size is>>" + backupFiles.size() + "loop count:" + ++counter);
        }
    }

    private void dereferanceBackupTable(int cloudId, String cloudName, String userName1, Device device) {
        String userName = userName1;
        List backupImages = null;
        String destColle = null;
        if (device != null) {
            backupImages = this.backUpImageDao.getAllFilesForDevice(cloudId, cloudName, device);
            userName = device.getUserName();
        } else if (userName != null) {
            User user = this.userDao.getUserInfoByName(cloudId, userName);
            if (user != null) {
                destColle = user.getSyncDestinationCollection();
            }
            backupImages = this.backUpImageDao.getAllFilesForUserName(cloudId, cloudName, userName, destColle);
        }
        int counter = 1;
        String dedupVal = this.getDedupValue(userName);
        while (!CollectionUtils.isEmpty((Collection)backupImages)) {
            logger.debug("Inside dereferencing chunk files in loop size is>>>" + backupImages.size());
            ArrayList<ObjectId> objectIds = new ArrayList<ObjectId>();
            for (BackUpImage backUpImage : backupImages) {
                objectIds.add(backUpImage.getId());
                if (backUpImage.getChunkFiles() == null || CollectionUtils.isEmpty((Collection)backUpImage.getChunkFiles())) continue;
                for (ChunkFile chunkFile : backUpImage.getChunkFiles()) {
                    if (StringUtils.isEmpty((String)chunkFile.getMd5())) continue;
                    ChunkDetail chunkDetail = null;
                    chunkDetail = this.getChunkDetailByBkpImageUploadTimeAndChunkUploadedTime(backUpImage.getUserName(), backUpImage.getLastServerModifiedTime(), dedupVal, chunkFile, chunkDetail, false);
                    if (chunkDetail == null) {
                        logger.debug("................chunk detail is empty for userName " + userName + " so search with userName case insesitive...........");
                        chunkDetail = this.getChunkDetailByBkpImageUploadTimeAndChunkUploadedTime(backUpImage.getUserName(), backUpImage.getLastServerModifiedTime(), dedupVal, chunkFile, chunkDetail, true);
                    }
                    if (chunkDetail == null) continue;
                    try {
                        chunkDetail.setRefCount(chunkDetail.getRefCount() - 1);
                        this.externalStorageBackupFileDao.saveChunkDetail(1, chunkDetail);
                        logger.debug(chunkDetail.getId() + " Chunk updated succcessfully for delete NEW............" + chunkDetail.getRefCount() + "...." + chunkDetail.getEncodedName());
                    }
                    catch (OptimisticLockingFailureException e) {
                        logger.trace("" + (Object)((Object)e));
                        logger.error("Exception while removing backup image :" + e.getMessage());
                        int count = 0;
                        int maxTries = PCHelperConstant.getMaxRetryForChunkUpdate();
                        this.retryDereferenceChunk(chunkFile, count, maxTries, backUpImage.getUserName(), backUpImage.getLastServerModifiedTime(), dedupVal);
                    }
                }
            }
            this.backUpImageDao.bulkDeleteBackupFiles(cloudId, cloudName, objectIds, device, destColle);
            if (device != null) {
                backupImages = this.backUpImageDao.getAllFilesForDevice(cloudId, cloudName, device);
            } else if (userName != null) {
                backupImages = this.backUpImageDao.getAllFilesForUserName(cloudId, cloudName, userName, destColle);
            }
            logger.debug("dereferencing the chunk in loop size is>>" + backupImages.size() + "loop count:" + ++counter);
        }
    }

    private ChunkDetail getChunkDetailByBkpImageUploadTimeAndChunkUploadedTime(String userName, long serverModTime, String dedupVal, ChunkFile chunkFile, ChunkDetail chunkDetail, boolean caseInsensitiveCheck) {
        List chunkDetailList = this.externalStorageBackupFileDao.getChunkDetailListForMd5(1, chunkFile.getMd5(), dedupVal, userName, false, caseInsensitiveCheck);
        logger.debug("chunkDetail list:" + chunkDetailList);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)chunkDetailList)) {
            if (this.cloudSettings == null) {
                this.cloudSettings = this.externalStorageBackupFileDao.getCloudSettings(1);
            }
            if (this.cloudSettings != null && this.cloudSettings.getDedupStartTime() != 0L && serverModTime != 0L) {
                logger.debug(this.cloudSettings.getDedupStartTime() + "cloudSettings.getDedupStartTime()+ :backupImage.getLastServerModifiedTime() :" + serverModTime);
                chunkDetail = serverModTime > this.cloudSettings.getDedupStartTime() ? (ChunkDetail)chunkDetailList.stream().filter(chunkDetail1 -> chunkDetail1.getChunkCreatedTime() > this.cloudSettings.getDedupStartTime()).findFirst().orElse(null) : (ChunkDetail)chunkDetailList.stream().filter(chunkDetail1 -> chunkDetail1.getChunkCreatedTime() < this.cloudSettings.getDedupStartTime()).findFirst().orElse(null);
            } else {
                chunkDetail = (ChunkDetail)chunkDetailList.get(0);
            }
        }
        return chunkDetail;
    }

    private String getDedupValue(String userName) {
        BackupPolicy backupPolicy;
        String dedupVal = null;
        User user = this.userDao.getUserInfoByName(1, userName);
        if (user != null && (backupPolicy = this.userDao.getBackupPolicyByPolicyName(1, user.getPolicyName())) != null) {
            dedupVal = backupPolicy.getDedup();
        }
        return dedupVal;
    }

    private void retryDereferenceChunk(ChunkFile chunkFile, int count1, int maxTries, String userName, long serverModTime, String dedupVal) {
        int count = count1;
        while (true) {
            try {
                logger.debug(" retry chunk update ..............." + chunkFile.getMd5());
                ChunkDetail chunkDetailObj = null;
                chunkDetailObj = this.getChunkDetailByBkpImageUploadTimeAndChunkUploadedTime(userName, serverModTime, dedupVal, chunkFile, chunkDetailObj, false);
                if (chunkDetailObj == null) {
                    logger.debug("................chunk detail is empty for userName " + userName + " so search with userName case insesitive...........");
                    chunkDetailObj = this.getChunkDetailByBkpImageUploadTimeAndChunkUploadedTime(userName, serverModTime, dedupVal, chunkFile, chunkDetailObj, true);
                }
                if (chunkDetailObj != null) {
                    chunkDetailObj.setRefCount(chunkDetailObj.getRefCount() - 1);
                }
                logger.debug(chunkFile.getMd5() + " @@@@@@ ................ retry count " + count);
                this.externalStorageBackupFileDao.saveChunkDetail(1, chunkDetailObj);
            }
            catch (Exception ex) {
                logger.trace("" + ex);
                logger.error(" ex ..." + ex.getMessage());
                if (++count != maxTries) continue;
            }
            break;
        }
    }

    @Override
    public void deleteDBEntriesForDeletedDevice(int cloudId, Device device) {
        logger.debug("deleting DBEntries for Device");
        try {
            this.alertHistoryDao.deleteAlertHistoryForDevice(cloudId, device);
        }
        catch (Exception e) {
            logger.trace("Delete job failed for alert history  " + e);
            logger.error("Delete job failed for alert history USER>>>>>>>" + device.getDeviceUUID() + e.getMessage());
        }
        try {
            this.backupBatchDao.deleteRecordsForDevice(cloudId, device);
        }
        catch (Exception e) {
            logger.trace("Delete job failed for backup batch " + e);
            logger.error("Delete job failed for backup batch deviceUUID>>>>>>>" + device.getDeviceUUID() + e.getMessage());
        }
        try {
            this.dailyUserBackupOverviewDao.deleteDailyUserBackupOverviewByDeviceUUID(cloudId, device.getDeviceUUID());
        }
        catch (Exception e) {
            logger.trace("Delete job failed for Daily User BackupOverView  " + e);
            logger.error("Delete job failed for Daily User BackupOverView , deviceUUID>>>>>>>" + device.getDeviceUUID() + e.getMessage());
        }
        try {
            this.deviceDao.deleteLatestBkpInfoBuDeviceUUID(cloudId, device.getDeviceUUID());
        }
        catch (Exception e) {
            logger.trace("Delete job failed for deleteLatestBkpInfoBuDeviceUUID " + e);
            logger.error("Delete job failed for deleteLatestBkpInfoBuDeviceUUID deviceUUID>>>>>>>" + device.getDeviceUUID() + e.getMessage());
        }
        try {
            this.deviceDao.deleteDeviceByDeviceUUID(cloudId, device.getDeviceUUID());
        }
        catch (Exception e) {
            logger.trace("Delete job failed for delete devices " + e);
            logger.error("Delete job failed for delete devices deviceUUID>>>>>>>" + device.getDeviceUUID() + e.getMessage());
        }
    }

    @Override
    public boolean isDeletedUserCleaned(int cloudId, String cloudName, String userName) {
        List devices = this.deviceDao.getDeviceByUserName(cloudId, userName);
        BackUpImage backupImage = null;
        if (devices != null) {
            Device device;
            Iterator iterator = devices.iterator();
            while (iterator.hasNext() && (backupImage = this.backUpImageDao.getBackupimgaeByUserNameAndDevice(cloudId, userName, device = (Device)iterator.next())) == null) {
            }
        }
        BackupBatch backupBatch = this.backupBatchDao.getBackupBatchByUserName(cloudId, userName);
        List<ObjectId> allMySharedFilesIds = this.getAllMySharedFilesIds(cloudId, cloudName, userName);
        FileRevision fileRevision = this.externalStorageBackupFileDao.getSyncFileByUserName(cloudId, cloudName, userName, allMySharedFilesIds);
        if (backupImage != null || backupBatch != null || fileRevision != null) {
            return false;
        }
        return this.backUpImageDao.getDeletedBkpFileByUserName(cloudId, userName) == null;
    }

    @Override
    public void deleteBackupFileByPolicy(Cloud cloud) {
        int cloudId = cloud.getCloudId();
        List allBackupPolicies = this.backupPolicyDao.getAllBackupPolicies(cloud.getCloudId());
        for (BackupPolicy backupPolicy : allBackupPolicies) {
            if (backupPolicy == null || backupPolicy.isLegalHoldEnabled() || backupPolicy.getNoOfDaysToKeepDeletedFiles() == 0L || backupPolicy.getNoOfDaysToKeepDeletedFiles() == -1L) continue;
            long noOfDays = backupPolicy.getNoOfDaysToKeepDeletedFiles();
            logger.debug("...........backupPolicy.getNoOfDaysToKeepDeletedFiles().........." + noOfDays);
            Calendar cal = Calendar.getInstance();
            cal.add(6, -((int)noOfDays));
            long noOfDaysAgoTimeStamp = cal.getTimeInMillis();
            this.deleteFilesByUsers(cloud, cloudId, backupPolicy, noOfDaysAgoTimeStamp, null);
        }
        List allPolicies = this.oneDriveBackupPolicyDao.loadAllOneDriveBackupPolicies(cloud.getCloudId());
        for (OfficeBackupPolicy policy : allPolicies) {
            logger.debug(policy.getPolicyName() + "...........officebackupPolicy..........." + policy.getPurgeDeletedFilesOlderThan());
            if ((policy == null || policy.isLegalHoldEnabled() || policy.getPurgeDeletedMailsOlderThan() == 0 || policy.getPurgeDeletedMailsOlderThan() == -1) && (policy.getPurgeDeletedFilesOlderThan() == 0 || policy.getPurgeDeletedFilesOlderThan() == -1)) continue;
            long noOfDays = policy.getPurgeDeletedFilesOlderThan();
            logger.debug(policy.getPolicyName() + "...........officebackupPolicy.getNoOfDaysToKeepDeletedFiles().........." + noOfDays);
            Calendar cal = Calendar.getInstance();
            cal.add(6, -((int)noOfDays));
            long noOfDaysAgoTimeStamp = cal.getTimeInMillis();
            this.deleteFilesForOfficeProductByUsers(cloud, cloudId, null, noOfDaysAgoTimeStamp, policy);
        }
    }

    private String getDedupValueForOneDrive(User user) {
        OfficeBackupPolicy policy;
        String dedupVal = null;
        if (user != null && (policy = this.userDao.getOfficeBackupPolicyByPolicyName(1, user.getOneDrivePolicyName())) != null) {
            dedupVal = policy.getDedup();
        }
        return dedupVal;
    }

    private void deleteFilesByUsers(Cloud cloud, int cloudId, BackupPolicy backupPolicy, long noOfDaysAgoTimeStamp, OfficeBackupPolicy oneDrivePolicy) {
        List userList = this.userDao.getUsersByBackupPolicyName(cloud.getCloudId(), backupPolicy.getPolicyName());
        if (!CollectionUtils.isEmpty((Collection)userList)) {
            for (User user : userList) {
                if (user == null || !user.isActive()) continue;
                boolean userUnderLegalHold = this.isUserUnderLegalHoldForUserName(cloudId, user.getUserName());
                logger.debug(user.getUserName() + "...deleting for user>>>>>>>>>>>" + userUnderLegalHold);
                if (userUnderLegalHold) continue;
                this.deleteFileByUserAndPolicy(cloud, cloudId, backupPolicy, noOfDaysAgoTimeStamp, user, oneDrivePolicy);
            }
        }
    }

    public boolean isUserUnderLegalHoldForUserName(int cloudId, String userName) {
        boolean userUnderLegalHold = false;
        User user = this.userDao.getUserByName(cloudId, userName);
        BackupPolicy backupPolicy = this.userDao.getBackupPolicyByPolicyName(cloudId, user.getPolicyName());
        if (backupPolicy != null && backupPolicy.isLegalHoldEnabled()) {
            logger.debug("User cannot be admin He/She is under legal hold .......");
            userUnderLegalHold = true;
            return userUnderLegalHold;
        }
        OfficeBackupPolicy officeBackupPolicy = this.userDao.getOfficeBackupPolicyByPolicyName(cloudId, user.getOneDrivePolicyName());
        if (officeBackupPolicy != null && officeBackupPolicy.isLegalHoldEnabled()) {
            logger.debug("User cannot be admin He/She is under legal hold ......." + officeBackupPolicy.getPolicyName());
            userUnderLegalHold = true;
            return userUnderLegalHold;
        }
        return userUnderLegalHold;
    }

    private void deleteFileByUserAndPolicy(Cloud cloud, int cloudId, BackupPolicy backupPolicy, long noOfDaysAgoTimeStamp, User user, OfficeBackupPolicy officeBackupPolicy) {
        List devices = new ArrayList();
        String dedupVal = "";
        logger.debug(".....Inside backupPolicy...");
        if (officeBackupPolicy != null) {
            logger.debug(".....Inside ondrive policy...");
            dedupVal = this.getDedupValueForOneDrive(user);
            devices = this.deviceDao.getAllOfficeDevicesByUserNameForDelete(cloud.getCloudId(), user.getUserName());
        } else if (backupPolicy != null) {
            logger.debug(".....Inside backupPolicy...");
            devices = this.deviceDao.getAllBackupDeviceByUserName(cloud.getCloudId(), user.getUserName());
            dedupVal = this.getDedupValueForBackup(user);
        }
        if (CollectionUtils.isEmpty(devices)) {
            logger.debug("...no devices for user..." + user.getUserName());
        }
        for (Device device : devices) {
            Calendar cal;
            boolean userUnderLegalHold = this.isUserUnderLegalHoldForUserName(cloudId, device.getUserName());
            logger.debug(user.getUserName() + "deleting for user>>>>>>>>>>>" + userUnderLegalHold);
            logger.debug("deleting for use1r>>>>>>>>>>>" + device.getOsType());
            if (userUnderLegalHold) continue;
            int noOfDays = 0;
            if (officeBackupPolicy != null) {
                if (device.getOsType().equalsIgnoreCase(Device.TYPE.ONEDRIVE.name().toString())) {
                    noOfDaysAgoTimeStamp = officeBackupPolicy.getPurgeDeletedFilesOlderThan();
                    cal = Calendar.getInstance();
                    cal.add(6, -((int)noOfDaysAgoTimeStamp));
                    noOfDaysAgoTimeStamp = cal.getTimeInMillis();
                    noOfDays = officeBackupPolicy.getPurgeDeletedFilesOlderThan();
                } else if (device.getDeviceType().equalsIgnoreCase(Device.TYPE.OUTLOOK.name().toString())) {
                    noOfDaysAgoTimeStamp = officeBackupPolicy.getPurgeDeletedMailsOlderThan();
                    cal = Calendar.getInstance();
                    cal.add(6, -((int)noOfDaysAgoTimeStamp));
                    noOfDaysAgoTimeStamp = cal.getTimeInMillis();
                    noOfDays = officeBackupPolicy.getPurgeDeletedMailsOlderThan();
                } else if (device.getDeviceType().equalsIgnoreCase(Device.TYPE.SHAREPOINT.name().toString())) {
                    noOfDaysAgoTimeStamp = officeBackupPolicy.getPurgeDeletedFilesOlderThan();
                    cal = Calendar.getInstance();
                    cal.add(6, -((int)noOfDaysAgoTimeStamp));
                    noOfDaysAgoTimeStamp = cal.getTimeInMillis();
                    noOfDays = officeBackupPolicy.getPurgeDeletedMailsOlderThan();
                }
            }
            if (backupPolicy != null) {
                noOfDaysAgoTimeStamp = backupPolicy.getNoOfDaysToKeepDeletedFiles();
                cal = Calendar.getInstance();
                cal.add(6, -((int)noOfDaysAgoTimeStamp));
                noOfDaysAgoTimeStamp = cal.getTimeInMillis();
                noOfDays = (int)backupPolicy.getNoOfDaysToKeepDeletedFiles();
            }
            logger.debug(user.getUserName() + "....deleting for use1r>>>>>>>>>>>" + noOfDays);
            List<BackUpImage> backUpImages = this.getLatestFolderListRecursive(cloudId, cloud.getCloudName(), device, null, 0L);
            logger.debug(user.getUserName() + "....deleting for use1r2>>>>>>>>>>>" + backUpImages);
            if (CollectionUtils.isEmpty(backUpImages)) continue;
            block1: for (BackUpImage bkpFolder : backUpImages) {
                logger.debug(bkpFolder.getId().toString() + ".....$$$$$... started........" + bkpFolder.getFileName());
                boolean isDeletedBkpFileNotEmpty = true;
                ArrayList ids = new ArrayList();
                while (isDeletedBkpFileNotEmpty) {
                    List<BackUpImage> backupImageFileList = new ArrayList();
                    if (!StringUtils.isEmpty((String)bkpFolder.getDevicePath())) {
                        backupImageFileList = this.backUpImageDao.getAllChildFilesOfFolder(cloudId, bkpFolder.getDevicePath() + CLOUD_PATH_SEPARATOR + bkpFolder.getFileName(), device, ids);
                    } else {
                        logger.debug("....getAllChildFilesOfFolder...." + bkpFolder.getFileName());
                        backupImageFileList = this.backUpImageDao.getAllChildFilesOfFolder(cloudId, bkpFolder.getFileName(), device, ids);
                    }
                    if (CollectionUtils.isEmpty(backupImageFileList)) continue block1;
                    logger.debug(noOfDays + "....backupImageFile-List-new.....-------" + backupImageFileList.size());
                    this.deleteBackupImageForDeletedFile(cloudId, backupImageFileList, device, noOfDaysAgoTimeStamp, dedupVal, noOfDays);
                    if (!CollectionUtils.isEmpty(backupImageFileList)) {
                        ids.addAll(backupImageFileList.stream().map(file -> file.getId()).collect(Collectors.toList()));
                    }
                    backupImageFileList.clear();
                    logger.debug(".........$$$$$$$$$$$$$................" + ids.size());
                }
            }
        }
    }

    private void deleteBackupImageForDeletedFile(int cloudId, List<BackUpImage> backupImageFileList, Device device, long noOfDaysAgoTimeStamp, String dedupVal, int noOfDays) {
        this.getFilteredBackupImageList(backupImageFileList, noOfDaysAgoTimeStamp, device, dedupVal, noOfDays);
    }

    private List<BackUpImage> getFilteredBackupImageList(List<BackUpImage> backUpImages, long noOfDaysAgoTimeStamp, Device device, String dedupVal, int noOfDays) {
        logger.debug("Inside getFilteredBackupImageList");
        ArrayList<BackUpImage> filteredBackUpImages = new ArrayList<BackUpImage>();
        Map<String, List<BackUpImage>> map = backUpImages.stream().collect(Collectors.groupingBy(BackUpImage::getFileName));
        for (Map.Entry<String, List<BackUpImage>> entry : map.entrySet()) {
            logger.debug(entry.getKey() + "...before..." + entry.getValue().size());
            BackUpImage latestImage = entry.getValue().stream().sorted(Comparator.comparing(BackUpImage::getLastServerModifiedTime).reversed()).findFirst().get();
            logger.debug(dedupVal + "............fileName..$$$$$$$$$$......." + latestImage.getFileName() + ".........." + latestImage.getLastServerModifiedTime() + "...................noOfDaysAgoTimeStamp........." + noOfDaysAgoTimeStamp);
            logger.debug(latestImage.getStatus() + "...beforetatest..." + latestImage.getId().toString());
            if (latestImage == null || !latestImage.getStatus().equalsIgnoreCase("DELETED")) continue;
            logger.debug((latestImage.getLastServerModifiedTime() < noOfDaysAgoTimeStamp) + "............fileNamess........." + latestImage.getFileName() + ".........." + latestImage.getLastServerModifiedTime() + "...................noOfDaysAgoTimeStamp........." + noOfDaysAgoTimeStamp);
            boolean officeProduct = false;
            if (device.getDeviceType().equalsIgnoreCase(Device.TYPE.OUTLOOK.name().toString())) {
                officeProduct = true;
            } else if (device.getDeviceType().equalsIgnoreCase(Device.TYPE.SHAREPOINT.name().toString())) {
                officeProduct = true;
            } else if (device.getDeviceType().equalsIgnoreCase(Device.TYPE.ONEDRIVE.name().toString())) {
                officeProduct = true;
            }
            Calendar cal = Calendar.getInstance();
            cal.add(6, -noOfDays);
            noOfDaysAgoTimeStamp = cal.getTimeInMillis();
            logger.debug(latestImage.getSubject() + "....fileeliblefordelete..." + (latestImage.getLastServerModifiedTime() < noOfDaysAgoTimeStamp));
            if (latestImage.getLastServerModifiedTime() >= noOfDaysAgoTimeStamp) continue;
            logger.debug("..inside delet..." + noOfDaysAgoTimeStamp);
            List<BackUpImage> files = entry.getValue().stream().filter(file -> !file.getStatus().equalsIgnoreCase("DELETED")).collect(Collectors.toList());
            ArrayList<BackUpImage> qulifiedImagesToDelete = new ArrayList<BackUpImage>();
            logger.debug("..inside delet1..." + files.size());
            qulifiedImagesToDelete.addAll((Collection)entry.getValue());
            this.deleteLatestVerFiles(1, backUpImages, device, files, dedupVal, qulifiedImagesToDelete, officeProduct);
            this.deleteAllFiles(1, backUpImages, device, dedupVal, qulifiedImagesToDelete, officeProduct);
        }
        return filteredBackUpImages;
    }

    private void deleteLatestVerFiles(int cloudId, List<BackUpImage> backupImageFileList, Device device, List<BackUpImage> filteredBackupImageList, String dedupVal, List<BackUpImage> qulifiedImagesToDelete, boolean officeProduct) {
        long storageUtilized = 0L;
        long latestVersionChange = 0L;
        for (BackUpImage backupImage : filteredBackupImageList) {
            this.dereferenceChunkDetails(backupImage, dedupVal);
            this.deleteBackupImage(cloudId, backupImage, device);
            storageUtilized += backupImage.getSize();
            latestVersionChange += backupImage.getSize();
            backupImageFileList.remove(backupImage);
            qulifiedImagesToDelete.remove(backupImage);
        }
    }

    private void deleteAllFiles(int cloudId, List<BackUpImage> backupImageFileList, Device device, String dedupVal, List<BackUpImage> files1, boolean officeProduct) {
        long storageUtilized = 0L;
        for (BackUpImage backupImage : files1) {
            this.dereferenceChunkDetails(backupImage, dedupVal);
            this.deleteBackupImage(cloudId, backupImage, device);
            storageUtilized += backupImage.getSize();
            backupImageFileList.remove(backupImage);
        }
    }

    private void deleteBackupImage(int cloudId, BackUpImage backupImage, Device device) {
        try {
            this.backUpImageDao.deleteBackupFile(cloudId, "", backupImage, device);
        }
        catch (Exception e) {
            logger.trace("" + e);
            logger.error("Exception while deleting backup files with backupId:" + e.getMessage());
        }
    }

    private void dereferenceChunkDetails(BackUpImage deletedBkpFile, String dedupVal) {
        try {
            this.dereferenceChunkDetailsFromDeletedBackupFiles(deletedBkpFile, dedupVal);
        }
        catch (Exception e) {
            logger.debug("unable to delete chunk details from deleted backup file");
            logger.trace("Exception" + e);
            logger.error("Exception for deleting chunk details" + e.getMessage());
        }
    }

    private void dereferenceChunkDetailsFromDeletedBackupFiles(BackUpImage deletedBackupFile, String dedupVal) {
        if (deletedBackupFile.getChunkFiles() != null && !CollectionUtils.isEmpty((Collection)deletedBackupFile.getChunkFiles()) && "CLOUD".equalsIgnoreCase(deletedBackupFile.getStoragePlace())) {
            for (ChunkFile chunkFile : deletedBackupFile.getChunkFiles()) {
                if (StringUtils.isEmpty((String)chunkFile.getMd5())) continue;
                ChunkDetail chunkDetail = this.externalStorageBackupFileDao.getChunkDetailForMd5ForRestore(1, chunkFile.getMd5(), dedupVal, deletedBackupFile.getUserName(), true, false);
                if (chunkDetail == null) {
                    chunkDetail = this.externalStorageBackupFileDao.getChunkDetailForMd5ForRestore(1, chunkFile.getMd5(), dedupVal, deletedBackupFile.getUserName(), true, true);
                }
                if (chunkDetail == null) continue;
                try {
                    chunkDetail.setRefCount(chunkDetail.getRefCount() - 1);
                    this.externalStorageBackupFileDao.saveChunkDetail(1, chunkDetail);
                    logger.debug(" Chunk updated succcessfully for delete backup image..........");
                }
                catch (OptimisticLockingFailureException e) {
                    logger.trace("" + (Object)((Object)e));
                    logger.error("Exception while removing chunk details :" + e.getMessage());
                    int count = 0;
                    int maxTries = PCHelperConstant.getMaxRetryForChunkUpdate();
                    this.retryDereferenceChunkForDeleteBkpFile(chunkFile, count, maxTries, deletedBackupFile.getUserName(), dedupVal);
                }
            }
        }
    }

    private String getDedupValue(int cloudId, BackupPolicy backupPolicy) {
        String dedupVal = null;
        if (backupPolicy != null) {
            dedupVal = backupPolicy.getDedup();
        }
        return dedupVal;
    }

    private void retryDereferenceChunkForDeleteBkpFile(ChunkFile chunkFile, int count1, int maxTries, String userName, String dedupVal) {
        int count = count1;
        while (true) {
            try {
                logger.debug(" retry chunk update ..............." + chunkFile.getMd5());
                ChunkDetail chunkDetailObj = this.externalStorageBackupFileDao.getChunkDetailForMd5ForRestore(1, chunkFile.getMd5(), dedupVal, userName, true, false);
                if (chunkDetailObj == null) {
                    chunkDetailObj = this.externalStorageBackupFileDao.getChunkDetailForMd5ForRestore(1, chunkFile.getMd5(), dedupVal, userName, true, true);
                }
                chunkDetailObj.setRefCount(chunkDetailObj.getRefCount() - 1);
                logger.debug(chunkFile.getMd5() + " @@@@@@ ................ retry count " + count);
                this.externalStorageBackupFileDao.saveChunkDetail(1, chunkDetailObj);
            }
            catch (Exception ex) {
                logger.trace("" + ex);
                logger.error(" ex ..." + ex.getMessage());
                if (++count != maxTries) continue;
            }
            break;
        }
    }

    private List<BackUpImage> getLatestFolderListRecursive(int cloudId, String cloudName, Device device, String path, long serverModifiedTime) {
        String folderPath = "";
        if (!StringUtils.isEmpty((String)path)) {
            folderPath = PathConversionHelper.getServerCompatiblePath((String)path, (boolean)false);
        }
        ArrayList<BackUpImage> backUpImages = new ArrayList<BackUpImage>();
        ArrayList<BackUpImage> backUpImageList = new ArrayList<BackUpImage>();
        System.setProperty("java.util.concurrent.ForkJoinPool.common.parallelism", "10");
        this.getImmediateFolderChildren(cloudId, cloudName, device, folderPath, backUpImages);
        logger.debug("After getting all folders recursive final size:" + backUpImages.size());
        if (!CollectionUtils.isEmpty(backUpImages)) {
            backUpImageList.addAll(backUpImages);
        } else {
            logger.debug("There is no file to Restore for DeviceUUID .............. " + device.getDeviceUUID());
        }
        if (!CollectionUtils.isEmpty(backUpImageList)) {
            logger.debug("After getting all folders recursive final size:" + backUpImageList.size());
            return backUpImageList;
        }
        logger.debug("...empty....");
        return new ArrayList<BackUpImage>();
    }

    private void getImmediateFolderChildren(int cloudId, String cloudName, Device device, String folderPath, List<BackUpImage> backUpImages) {
        logger.debug("inside getting all folders in recursive mannergetLatestFoldersRecursiveWithoutStatusAll............devicePath:" + folderPath);
        List backUpImagesTemp = this.backUpImageDao.getLatestFoldersRecursiveWithoutStatusAll(cloudId, cloudName, device, folderPath);
        backUpImages.addAll(backUpImagesTemp);
        if (!CollectionUtils.isEmpty((Collection)backUpImagesTemp)) {
            Stream stream = backUpImagesTemp.parallelStream();
            stream.forEach(backUpImage -> {
                String devicePath = backUpImage.getDevicePath() + "/" + backUpImage.getFileName();
                logger.debug("Inside loop after getting folders..bkpimages list size:" + backUpImagesTemp.size());
                if (StringUtils.isEmpty((String)backUpImage.getDevicePath())) {
                    devicePath = backUpImage.getFileName();
                }
                logger.debug("Inside loop to get immediate folders deevicePath:" + devicePath);
                this.getImmediateFolderChildren(cloudId, cloudName, device, devicePath, backUpImages);
            });
        }
    }

    private String getDedupValueForBackup(User user) {
        BackupPolicy backupPolicy;
        String dedupVal = null;
        if (user != null && (backupPolicy = this.userDao.getBackupPolicyByPolicyName(1, user.getPolicyName())) != null) {
            dedupVal = backupPolicy.getDedup();
        }
        return dedupVal;
    }

    public BackupPolicyDao getBackupPolicyDao() {
        return this.backupPolicyDao;
    }

    public void setBackupPolicyDao(BackupPolicyDao backupPolicyDao) {
        this.backupPolicyDao = backupPolicyDao;
    }

    private List<ObjectId> getAllMySharedFilesIds(int cloudId, String cloudName, String userName) {
        List<Object> sharedConsolidatedFiles = new ArrayList();
        ArrayList<ObjectId> sharedRevisionIds = new ArrayList<ObjectId>();
        sharedConsolidatedFiles = this.getSharedConsIds(cloudId, cloudName, userName);
        if (!CollectionUtils.isEmpty(sharedConsolidatedFiles)) {
            List fileElements = this.fileRevisionDao.getLatestByRevisionsByConsoIds(cloudId, cloudName, sharedConsolidatedFiles, userName);
            for (FileRevision revisions : fileElements) {
                sharedRevisionIds.add(revisions.getId());
            }
        }
        return sharedRevisionIds;
    }

    private List<ObjectId> getSharedConsIds(int cloudId, String cloudName, String userName) {
        ArrayList<ObjectId> sharedConsolidatedFiles = new ArrayList<ObjectId>();
        List consolidatedImages = this.fileRevisionDao.getAllMySharedFiles(cloudId, cloudName, userName);
        for (ConsolidatedImage consolidatedImage : consolidatedImages) {
            sharedConsolidatedFiles.add(consolidatedImage.getId());
        }
        return sharedConsolidatedFiles;
    }
}

