/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.bluvault.backup.service.impl;

import com.parablu.bluvault.backup.service.BackupBatchAHService;
import com.parablu.paracloud.element.BackupBatchElement;
import com.parablu.paracloud.element.BackupHistoryFileElement;
import com.parablu.pcbd.dao.BackupAHDao;
import com.parablu.pcbd.domain.BackupAHBatch;
import com.parablu.pcbd.domain.BackupHistoryFileInfo;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bson.types.ObjectId;

public class BackupBatchAHServiceImpl
implements BackupBatchAHService {
    private BackupAHDao backupAHDao;
    Logger logger = LogManager.getLogger(BackupBatchAHServiceImpl.class);

    public BackupAHDao getBackupAHDao() {
        return this.backupAHDao;
    }

    public void setBackupAHDao(BackupAHDao backupAHDao) {
        this.backupAHDao = backupAHDao;
    }

    public static String formatFileSize(long size) {
        if (size <= 0L) {
            return "0";
        }
        String[] units = new String[]{"B", "kB", "MB", "GB", "TB"};
        int digitGroups = (int)(Math.log10(size) / Math.log10(1024.0));
        return new DecimalFormat("#,##0.#").format((double)size / Math.pow(1024.0, digitGroups)) + " " + units[digitGroups];
    }

    @Override
    public void saveBackupActivityHistory(int cloudId, String cloudName, String userName, BackupBatchElement backupBatchElement) {
        BackupAHBatch backupAHBatch = new BackupAHBatch();
        if ("-1".equals(backupBatchElement.getBatchId())) {
            return;
        }
        backupAHBatch.setBackupAHBatchId(new ObjectId(backupBatchElement.getBatchId()));
        List backupHistoryFileElements = backupBatchElement.getBackupHistoryFileElements();
        for (BackupHistoryFileElement bhFileElement : backupHistoryFileElements) {
            BackupHistoryFileInfo backupHistoryFileInfo = new BackupHistoryFileInfo();
            backupHistoryFileInfo.setFileName(bhFileElement.getFileName());
            backupHistoryFileInfo.setFilePath(bhFileElement.getFilePath());
            backupHistoryFileInfo.setSize(BackupBatchAHServiceImpl.formatFileSize(Long.parseLong(bhFileElement.getSize())));
            backupHistoryFileInfo.setStatus(bhFileElement.getStatus());
            backupHistoryFileInfo.setFailedReason(bhFileElement.getFailedReason());
            backupAHBatch.getBackUpHistoryFileInfosList().add(backupHistoryFileInfo);
        }
        this.backupAHDao.saveBackupActivityHistory(cloudId, cloudName, userName, backupAHBatch);
    }

    @Override
    public List<BackupHistoryFileElement> loadAllFilesForBatch(int cloudId, String batchID, String cloudName, String userName) {
        ArrayList<BackupHistoryFileElement> list = new ArrayList<BackupHistoryFileElement>();
        BackupAHBatch ahBatch = this.backupAHDao.loadAllFiles(cloudId, batchID, cloudName, userName);
        if (ahBatch != null) {
            List files = ahBatch.getBackUpHistoryFileInfosList();
            for (BackupHistoryFileInfo fileInfo : files) {
                BackupHistoryFileElement bhFileElement = new BackupHistoryFileElement();
                bhFileElement.setSize(fileInfo.getSize());
                bhFileElement.setStatus(fileInfo.getStatus());
                bhFileElement.setFilePath(fileInfo.getFilePath());
                bhFileElement.setFileName(fileInfo.getFileName());
                bhFileElement.setFailedReason(fileInfo.getFailedReason());
                list.add(bhFileElement);
            }
        }
        return list;
    }
}

