/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.bluvault.backup.delegate.impl;

import com.parablu.bluvault.backup.delegate.ChunkableBackupUploadDelegate;
import com.parablu.bluvault.backup.exception.ParacloudBackupException;
import com.parablu.bluvault.backup.service.BackupService;
import com.parablu.bluvault.backup.util.ObjectConversionHelper;
import com.parablu.bluvault.backup.util.ResourceFileHelper;
import com.parablu.helper.constant.GeneralHelperConstant;
import com.parablu.helper.utils.MD5Generator;
import com.parablu.paracloud.constant.PCHelperConstant;
import com.parablu.paracloud.element.BackupElement;
import com.parablu.paracloud.element.ChunkFileElement;
import com.parablu.paracloud.util.DiskSpaceHelper;
import com.parablu.paracloud.util.FileUtils;
import com.parablu.paracloud.util.PathConversionHelper;
import com.parablu.paracloud.util.PathGenerator;
import com.parablu.paracloud.util.ThumbnailHelper;
import com.parablu.pcbd.domain.BackUpImage;
import com.parablu.pcbd.domain.Device;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

public class ChunkableBackupUploadDelegateImpl
implements ChunkableBackupUploadDelegate {
    private static final String BACKUP = "backup";
    private Logger logger = LogManager.getLogger(ChunkableBackupUploadDelegateImpl.class);
    @Autowired
    private BackupService backupService;
    private static final String CHUNK = "chunk";
    private static final String IO_EXCEPTION = "IOException  :";
    private static final String CHUNK_SLASH = "chunk/";

    @Override
    public String uploadChunkableFileToBackUp(int cloudId, String cloudName, InputStream inputStream, ChunkFileElement fileElement, long size, long cloudSizeAllowedInBytes, Device device) {
        this.logger.debug("@@@@ Inside upload chunkable file ");
        String nextChunkName = "-1";
        try {
            String convertedPath = this.convertToServerPath(fileElement.getFileCompletePath(), device);
            fileElement.setFileCompletePath(convertedPath);
            if (!DiskSpaceHelper.isEnoughSpaceAvailable((String)cloudName, (long)size, (long)cloudSizeAllowedInBytes)) {
                throw new ParacloudBackupException("Enough space not avaiable", 507);
            }
            this.uploadFile(cloudId, cloudName, inputStream, fileElement, device);
        }
        catch (ParacloudBackupException e) {
            this.logger.error(" Exception inside uploadChunkableFileToBackUp ", (Object)e.getMessage());
            throw new ParacloudBackupException("Exception occured in uploadImpl" + (Object)((Object)e), e.getResponseCode());
        }
        catch (Exception e) {
            this.logger.error(" Exception inside uploadChunkableFileToBackUp Exception ", (Object)e.getMessage());
            throw new ParacloudBackupException("Exception occured in uploadImpl" + e, 500);
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
        String intermediateUploadFolder = device.getDeviceTempPath() + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + BACKUP + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + CHUNK;
        List areadyUploadedChunks = FileUtils.getExistingFileNamesForGivenPath((String)intermediateUploadFolder);
        List fileChunks = fileElement.getFileChunks();
        fileChunks.removeAll(areadyUploadedChunks);
        if (!CollectionUtils.isEmpty((Collection)fileChunks)) {
            nextChunkName = (String)fileChunks.get(0);
        }
        return nextChunkName;
    }

    private void uploadFile(int cloudId, String cloudName, InputStream inputStream, ChunkFileElement fileElement, Device device) throws IOException, NoSuchAlgorithmException {
        String fileName = fileElement.getFileName();
        String intermediateUploadFolder = device.getDeviceTempPath() + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + BACKUP + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + CHUNK;
        File intermediateFile = new File(intermediateUploadFolder + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + fileName);
        this.readFileItemAndUploadToTempPath(cloudId, cloudName, intermediateUploadFolder, intermediateFile, fileElement.getMd5checksum(), inputStream);
    }

    private String convertToServerPath(String fileCompletePath, Device device) {
        String ostype = device.getOsType();
        boolean type = ostype.equals("Android");
        String convertedPath = PathConversionHelper.getServerCompatiblePath((String)fileCompletePath, (boolean)type);
        return convertedPath;
    }

    private void readFileItemAndUploadToTempPath(int cloudId, String cloudName, String intermediateUploadCompleteFolderPath, File intermediateFile, String md5checksum, InputStream inputStream) throws IOException, NoSuchAlgorithmException {
        File intermediateFolder = new File(intermediateUploadCompleteFolderPath);
        if (!intermediateFolder.exists() && !intermediateFolder.mkdirs()) {
            throw new ParacloudBackupException(intermediateFolder + " folder  Folder Not Created", 500);
        }
        this.tranferFileFromStream(inputStream, intermediateFile, md5checksum);
    }

    private void tranferFileFromStream(InputStream inputStream, File intermediateFile, String md5Checksum) throws NoSuchAlgorithmException, IOException {
        byte[] b = new byte[4096];
        MessageDigest md = MessageDigest.getInstance("MD5");
        try {
            intermediateFile.createNewFile();
            try (FileOutputStream outstream = new FileOutputStream(intermediateFile);){
                int buff = -1;
                while ((buff = inputStream.read(b)) != -1) {
                    outstream.write(b, 0, buff);
                    md.update(b, 0, buff);
                }
            }
        }
        catch (FileNotFoundException e) {
            this.logger.error("Exception", (Object)e.getMessage());
            intermediateFile.delete();
            throw new ParacloudBackupException("IO Exception while creating tempFile" + e, 500);
        }
        catch (IOException e) {
            this.logger.trace(IO_EXCEPTION, (Throwable)e);
            this.logger.error(IO_EXCEPTION, (Object)e.getMessage());
            intermediateFile.delete();
            throw new ParacloudBackupException("IO Exception while transfering from client" + e, 500);
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
        String uploadedFileMd5Checksum = MD5Generator.generateMD5OfFile((File)intermediateFile);
        if (!uploadedFileMd5Checksum.equals(md5Checksum)) {
            intermediateFile.delete();
            this.logger.debug(uploadedFileMd5Checksum + " %%%%%%%%%%%%%%%%%%% " + md5Checksum);
            throw new ParacloudBackupException("File Upload Not Successful,due to MD5 mismatch", 500);
        }
    }

    private boolean checkIfRevisionHasBeenModified(BackupElement fileElement, BackUpImage backUpImage) {
        return backUpImage.getMd5Checksum().equals(fileElement.getMd5Checksum());
    }

    private boolean isRecordPresent(BackUpImage backUpImage) {
        return backUpImage != null && backUpImage.isPresent();
    }

    private String getFsPathForFile(String md5) {
        return PathGenerator.getFsPath((String)md5);
    }

    @Override
    public void mergeAllChunksAndUploadFileToBackUp(int cloudId, String cloudName, BackupElement backupElement, Device device) {
        String baseFolder = device.getDeviceTempPath() + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + BACKUP + GeneralHelperConstant.CLOUD_PATH_SEPARATOR;
        String intermediateMergeFolder = baseFolder + "merge";
        String intermediateChunkFolder = baseFolder + CHUNK_SLASH;
        this.logger.debug("^^^^^^^^^  MERGE FILE PATH " + baseFolder + CHUNK_SLASH);
        List fileNames = FileUtils.getExistingFileNamesForGivenPath((String)(baseFolder + CHUNK_SLASH));
        File mergeFolder = new File(intermediateMergeFolder);
        if (!mergeFolder.exists()) {
            mergeFolder.mkdir();
        }
        FileUtils.merge((List)fileNames, (String)intermediateChunkFolder, (String)(intermediateMergeFolder + "/" + backupElement.getFileName()));
        File file = new File(intermediateMergeFolder + "/" + backupElement.getFileName());
        String fileMd5 = "";
        try {
            fileMd5 = MD5Generator.generateMD5OfFile((File)file);
        }
        catch (Exception e) {
            this.logger.trace("Exception  :" + e);
            this.logger.error("Exception  :" + e.getMessage());
        }
        if (fileMd5.equals(backupElement.getMd5Checksum())) {
            BackUpImage backUpImage = this.readFromBackDb(cloudId, cloudName, backupElement, device);
            boolean lastRecordPresent = this.isRecordPresent(backUpImage);
            boolean noChange = false;
            if (lastRecordPresent) {
                noChange = this.checkIfRevisionHasBeenModified(backupElement, backUpImage);
            }
            if (lastRecordPresent && noChange) {
                return;
            }
            String newStatus = lastRecordPresent ? PCHelperConstant.REVISION_STATUS.MODIFIED.toString() : PCHelperConstant.REVISION_STATUS.ADDED.toString();
            backUpImage = new BackUpImage();
            String fsPath = this.getFsPathForFile(backupElement.getMd5Checksum());
            String convertedPath = this.convertToServerPath(backupElement.getFileCompletePath(), device);
            backupElement.setFileCompletePath(convertedPath);
            ObjectConversionHelper.convertToBackUpImage(backupElement, device.getDeviceUUID(), backUpImage, device, backupElement.isBaseBackup(), fsPath, newStatus);
            try {
                this.backupService.createRevisionForFile(cloudId, cloudName, file, backUpImage, backupElement.getSize());
            }
            catch (IOException e) {
                this.logger.trace(IO_EXCEPTION + e);
                this.logger.error(IO_EXCEPTION + e.getMessage());
            }
            ThumbnailHelper.createThumbnails((String)cloudName, (String)(PCHelperConstant.getPropertyFileValueParabluBackupFolderBasePath((String)cloudName) + backUpImage.getDeviceUUID() + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + backUpImage.getfSPath()), (String)(BACKUP + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + backUpImage.getDeviceUUID() + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + backUpImage.getfSPath()), (String)FilenameUtils.getExtension((String)backUpImage.getFileName()));
            ResourceFileHelper.deleteAllChildFilesExcludingDirectories(new File(baseFolder + CHUNK));
            ResourceFileHelper.deleteAllChildFilesExcludingDirectories(new File(baseFolder + "merge"));
        } else {
            this.logger.debug(backupElement.getMd5Checksum() + " MERGE NOT COMPLETED  MD5 mismatched " + fileMd5);
        }
    }

    private BackUpImage readFromBackDb(int cloudId, String cloudName, BackupElement fileElement, Device device) {
        BackUpImage backUpImage = this.backupService.readFromBackUpTable(cloudId, cloudName, fileElement.getFileCompletePath(), fileElement.getFileName(), device);
        return backUpImage;
    }
}

