/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.bluvault.backup.delegate.impl;

import com.parablu.bluvault.backup.delegate.BackupUploadDelegate;
import com.parablu.bluvault.backup.exception.ParacloudBackupException;
import com.parablu.bluvault.backup.service.BackupService;
import com.parablu.bluvault.backup.util.ObjectConversionHelper;
import com.parablu.bluvault.backup.util.ResourceFileHelper;
import com.parablu.helper.constant.GeneralHelperConstant;
import com.parablu.paracloud.constant.PCHelperConstant;
import com.parablu.paracloud.element.BackupElement;
import com.parablu.paracloud.util.DiskSpaceHelper;
import com.parablu.paracloud.util.PathConversionHelper;
import com.parablu.paracloud.util.PathGenerator;
import com.parablu.paracloud.util.ThumbnailHelper;
import com.parablu.pcbd.domain.BackUpImage;
import com.parablu.pcbd.domain.Device;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class BackupUploadDelegateImpl
implements BackupUploadDelegate {
    private static final String BACKUP = "backup";
    private Logger logger = LogManager.getLogger(BackupUploadDelegateImpl.class);
    @Autowired
    private BackupService backupService;
    private static final String EXCEPTION_OCCURED_IN_UPLOADIMPL = "Exception occured in uploadImpl";

    @Override
    public void uploadFileToBackUp(int cloudId, String cloudName, InputStream inputStream, BackupElement fileElement, long cloudSizeAllowedInBytes, Device device) {
        this.logger.trace("Uploading file ");
        String fileName = null;
        BackUpImage backUpImage = null;
        try {
            this.convertToServerPath(fileElement, device);
            fileName = fileElement.getFileName();
            if (!DiskSpaceHelper.isEnoughSpaceAvailable((String)cloudName, (long)fileElement.getSize(), (long)cloudSizeAllowedInBytes)) {
                throw new ParacloudBackupException("Enough space not avaiable", 507);
            }
            backUpImage = this.readFromBackDb(cloudId, cloudName, fileElement, device);
            boolean lastRecordPresent = this.isRecordPresent(backUpImage);
            boolean noChange = false;
            if (lastRecordPresent) {
                noChange = this.checkIfRevisionHasBeenModified(fileElement, backUpImage);
            }
            if (lastRecordPresent && noChange) {
                return;
            }
            String newStatus = lastRecordPresent ? PCHelperConstant.REVISION_STATUS.MODIFIED.toString() : PCHelperConstant.REVISION_STATUS.ADDED.toString();
            if (fileElement.isFolder()) {
                this.createFolder(cloudId, cloudName, fileElement, device.getDeviceUUID(), device, newStatus);
                return;
            }
            this.uploadFile(cloudId, cloudName, inputStream, fileElement, device, fileName, newStatus);
        }
        catch (ParacloudBackupException e) {
            this.logger.error("@ResourceFunnelException@", (Object)e.getMessage());
            throw new ParacloudBackupException(EXCEPTION_OCCURED_IN_UPLOADIMPL + (Object)((Object)e), e.getResponseCode());
        }
        catch (Exception e) {
            this.logger.error("@Exception@", (Object)e.getMessage());
            throw new ParacloudBackupException(EXCEPTION_OCCURED_IN_UPLOADIMPL + e, 500);
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
    }

    private void uploadFile(int cloudId, String cloudName, InputStream inputStream, BackupElement fileElement, Device device, String fileName, String newStatus) throws IOException, NoSuchAlgorithmException {
        String intermediateUploadFolder = device.getDeviceTempPath() + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + BACKUP;
        File intermediateFile = new File(intermediateUploadFolder + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + fileName);
        this.readFileItemAndUploadToTempPath(cloudId, cloudName, fileName, intermediateUploadFolder, intermediateFile, fileElement.getMd5Checksum(), inputStream, device.getDeviceUUID());
        long fileSizeinBytes = intermediateFile.length();
        long filesizeInKB = (long)Math.ceil((double)fileSizeinBytes / 1024.0);
        fileElement.setSize(filesizeInKB);
        BackUpImage backUpImage = new BackUpImage();
        String fsPath = this.getFsPathForFile(fileElement.getMd5Checksum());
        ObjectConversionHelper.convertToBackUpImage(fileElement, device.getDeviceUUID(), backUpImage, device, fileElement.isBaseBackup(), fsPath, newStatus);
        this.backupService.createRevisionForFile(cloudId, cloudName, intermediateFile, backUpImage, fileSizeinBytes);
        ThumbnailHelper.createThumbnails((String)cloudName, (String)(PCHelperConstant.getPropertyFileValueParabluBackupFolderBasePath((String)cloudName) + backUpImage.getDeviceUUID() + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + backUpImage.getfSPath()), (String)(BACKUP + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + backUpImage.getDeviceUUID() + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + backUpImage.getfSPath()), (String)FilenameUtils.getExtension((String)backUpImage.getFileName()));
    }

    private void convertToServerPath(BackupElement fileElement, Device device) {
        String ostype = device.getOsType();
        boolean type = ostype.equals("Android");
        String convertedPath = PathConversionHelper.getServerCompatiblePath((String)fileElement.getFileCompletePath(), (boolean)type);
        fileElement.setFileCompletePath(convertedPath);
    }

    private void readFileItemAndUploadToTempPath(int cloudId, String cloudName, String fileName, String intermediateUploadCompleteFolderPath, File intermediateFile, String md5checksum, InputStream inputStream, String deviceUUID) throws IOException, NoSuchAlgorithmException {
        File intermediateFolder = new File(intermediateUploadCompleteFolderPath);
        if (intermediateFolder.exists()) {
            ResourceFileHelper.deleteAllChildFilesExcludingDirectories(intermediateFolder);
        } else if (!intermediateFolder.mkdirs()) {
            throw new ParacloudBackupException("Upload Folder Not Created", 500);
        }
        this.tranferFileFromStream(inputStream, intermediateFile, md5checksum);
    }

    private void tranferFileFromStream(InputStream inputStream, File intermediateFile, String md5Checksum) throws NoSuchAlgorithmException, IOException {
        byte[] b = new byte[4096];
        MessageDigest md = MessageDigest.getInstance("MD5");
        try {
            intermediateFile.createNewFile();
            try (FileOutputStream outstream = new FileOutputStream(intermediateFile);){
                int buff = -1;
                while ((buff = inputStream.read(b)) != -1) {
                    outstream.write(b, 0, buff);
                    md.update(b, 0, buff);
                }
            }
        }
        catch (FileNotFoundException e) {
            this.logger.debug("Exception", (Throwable)e);
            intermediateFile.delete();
            throw new ParacloudBackupException("IO Exception while creating tempFile" + e, 500);
        }
        catch (IOException e) {
            this.logger.debug("Exception", (Throwable)e);
            intermediateFile.delete();
            throw new ParacloudBackupException("IO Exception while transfering from client" + e, 500);
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
        String uploadedFileMd5Checksum = new String(Hex.encodeHex((byte[])md.digest()));
        if (!uploadedFileMd5Checksum.equals(md5Checksum)) {
            intermediateFile.delete();
            throw new ParacloudBackupException("File Upload Not Successful,due to MD5 mismatch", 500);
        }
    }

    private boolean checkIfRevisionHasBeenModified(BackupElement fileElement, BackUpImage backUpImage) {
        if (backUpImage.isFolder() && fileElement.isFolder()) {
            return true;
        }
        return backUpImage.getMd5Checksum().equals(fileElement.getMd5Checksum());
    }

    private boolean isRecordPresent(BackUpImage backUpImage) {
        return backUpImage != null && backUpImage.isPresent();
    }

    private BackUpImage readFromBackDb(int cloudId, String cloudName, BackupElement fileElement, Device device) {
        BackUpImage backUpImage = this.backupService.readFromBackUpTable(cloudId, cloudName, fileElement.getFileCompletePath(), fileElement.getFileName(), device);
        return backUpImage;
    }

    private void createFolder(int cloudId, String cloudName, BackupElement fileElement, String regId, Device device, String status) {
        BackUpImage lastBackUpImage = new BackUpImage();
        String fsPath = this.getFsPathForFile(fileElement.getMd5Checksum());
        ObjectConversionHelper.convertToBackUpImage(fileElement, regId, lastBackUpImage, device, fileElement.isBaseBackup(), fsPath, status);
        this.backupService.createParentsAndSaveEntry(cloudId, cloudName, lastBackUpImage);
    }

    private String getFsPathForFile(String md5) {
        return PathGenerator.getFsPath((String)md5);
    }
}

