/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.bluvault.backup.delegate.impl;

import com.parablu.bluvault.backup.delegate.BackupDelegate;
import com.parablu.bluvault.backup.exception.ParacloudBackupException;
import com.parablu.bluvault.backup.service.BackupService;
import com.parablu.bluvault.backup.util.ObjectConversionHelper;
import com.parablu.bluvault.udc.controller.BaseController;
import com.parablu.bluvault.udc.service.DeviceManagementService;
import com.parablu.paracloud.constant.PCHelperConstant;
import com.parablu.paracloud.element.BackupListElement;
import com.parablu.paracloud.element.BackupValidationElement;
import com.parablu.paracloud.element.FileElement;
import com.parablu.paracloud.element.FileListElement;
import com.parablu.paracloud.element.KeyValueElement;
import com.parablu.paracloud.element.response.BackupListResponseElement;
import com.parablu.paracloud.util.PathConversionHelper;
import com.parablu.pcbd.domain.BackUpImage;
import com.parablu.pcbd.domain.BackUpImageStatistics;
import com.parablu.pcbd.domain.Device;
import com.parablu.share.service.SharedFileImageService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bson.types.ObjectId;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class BackupDelegateImpl
implements BackupDelegate {
    Logger logger = LogManager.getLogger(BackupDelegateImpl.class);
    private static final String WINDOWS_OS = "win";
    @Autowired
    private BackupService backupService;
    private static final String DEVICE_NOT_FOUND = "Device  not found ";
    @Autowired
    private SharedFileImageService sharedFileImageService;
    @Autowired
    private DeviceManagementService deviceManagementService;

    @Override
    public BackupListResponseElement validateBackUpFiles(int cloudId, String cloudName, String deviceRegid, BackupValidationElement backupListElement, boolean complete, Device device) {
        this.logger.debug("START of validate backup files.......");
        boolean isAndroidDevice = true;
        if (device == null) {
            throw new ParacloudBackupException(DEVICE_NOT_FOUND, 500);
        }
        String deviceOperatingSystem = device.getOsType();
        if (deviceOperatingSystem == null) {
            throw new ParacloudBackupException("Exception as dao record is null", 500);
        }
        deviceOperatingSystem = deviceOperatingSystem.toLowerCase();
        if (deviceOperatingSystem.contains(WINDOWS_OS)) {
            isAndroidDevice = false;
        }
        if (complete) {
            this.logger.debug("FIRST TIME CRAWL SO SENDING EMPTY ELEMENT LIST WITHOUT CRAWLING");
            return new BackupListResponseElement();
        }
        List newFileElements = backupListElement.getFilesToAddList().getFileElementList();
        List deletedFileElements = backupListElement.getFilesToDeleteList().getFileElementList();
        this.markDeleteFiles(cloudId, cloudName, isAndroidDevice, device, deletedFileElements);
        this.logger.debug("Before getting the file list from Query.....");
        List<BackUpImage> backupList = this.backupService.getExistingFieldsComparingWithTable(cloudId, cloudName, newFileElements, device);
        this.logger.debug("After getting the backupimage list from query...." + backupList.size());
        List<BackUpImage> backUpImagesForNotToUpload = this.getExistingBackupImageMatches(backupList, newFileElements, device);
        List<FileElement> filesNotToUpload = this.getFilesNotToBackUp(cloudId, cloudName, isAndroidDevice, device, newFileElements, backUpImagesForNotToUpload);
        BackupListResponseElement backupListResponseElement = new BackupListResponseElement();
        FileListElement fileNotToUploadListElement = new FileListElement();
        fileNotToUploadListElement.setFileElementList(filesNotToUpload);
        List<BackUpImage> backUpImagesForMd5Dedup = this.getExistingBackupImageMatchesForDedup(backupList, device);
        List<KeyValueElement> list = this.getFilesToBackUp(cloudId, cloudName, isAndroidDevice, device, newFileElements, backUpImagesForMd5Dedup);
        fileNotToUploadListElement.setMd5AndDedupedIdList(list);
        backupListResponseElement.setFilesNotToAddList(fileNotToUploadListElement);
        this.logger.debug("END of validate backup files.......");
        return backupListResponseElement;
    }

    private void markDeleteFiles(int cloudId, String cloudName, boolean isAndroidDevice, Device device, List<FileElement> deletedFileElements) {
        ArrayList<BackUpImage> backUpImages = new ArrayList<BackUpImage>();
        this.logger.debug(" before marking deleted files old............");
        for (FileElement fileElement : deletedFileElements) {
            if (isAndroidDevice) continue;
            fileElement.setFileCompletePath(PathConversionHelper.getServerCompatiblePath((String)fileElement.getFileCompletePath(), (boolean)isAndroidDevice));
        }
        List<BackUpImage> deletedBackUpImages = this.backupService.getExistingFieldsComparingWithTable(cloudId, cloudName, deletedFileElements, device);
        if (!CollectionUtils.isEmpty(deletedBackUpImages)) {
            this.logger.debug("DELETED files list ..........." + deletedBackUpImages.size());
        }
        for (BackUpImage backUpImage : deletedBackUpImages) {
            BackUpImage backUpImage2 = new BackUpImage();
            ObjectConversionHelper.convertToBackUpImage(backUpImage, device.getDeviceUUID(), backUpImage2, device, false, backUpImage.getfSPath(), PCHelperConstant.REVISION_STATUS.DELETED.toString(), false);
            backUpImage2.setUserName(backUpImage.getUserName());
            backUpImages.add(backUpImage2);
            if (backUpImages.size() <= 1000) continue;
            this.backupService.saveBatchEntry(cloudId, cloudName, backUpImages, device.getDestCollection());
            backUpImages.clear();
        }
        this.backupService.saveBatchEntry(cloudId, cloudName, backUpImages, device.getDestCollection());
        this.logger.debug("after marking  deleted files...........");
    }

    private List<FileElement> getFilesNotToBackUp(int cloudId, String cloudName, boolean isAndroidDevice, Device device, List<FileElement> newFileElements, List<BackUpImage> tempBackUpImage) {
        this.logger.debug("Inside get files not to upload........");
        ArrayList<FileElement> filesNotToUpload = new ArrayList<FileElement>();
        ArrayList<FileElement> filePathList = new ArrayList<FileElement>();
        for (FileElement fileElement : newFileElements) {
            if (!isAndroidDevice) {
                fileElement.setFileCompletePath(PathConversionHelper.getServerCompatiblePath((String)fileElement.getFileCompletePath(), (boolean)isAndroidDevice));
            }
            filePathList.add(fileElement);
        }
        if (!filePathList.isEmpty() && tempBackUpImage != null && !tempBackUpImage.isEmpty()) {
            filesNotToUpload.addAll(ObjectConversionHelper.convertBackUpImageListToFileElementList(tempBackUpImage, isAndroidDevice, false));
        }
        this.logger.debug("End of get files not to upload........");
        return filesNotToUpload;
    }

    private List<KeyValueElement> getFilesToBackUp(int cloudId, String cloudName, boolean isAndroidDevice, Device device, List<FileElement> newFileElements, List<BackUpImage> backupList) {
        ArrayList<String> md5checksums = new ArrayList<String>();
        for (FileElement fileElement : newFileElements) {
            if (fileElement.isFolder()) continue;
            if (!isAndroidDevice) {
                fileElement.setFileCompletePath(PathConversionHelper.getServerCompatiblePath((String)fileElement.getFileCompletePath(), (boolean)isAndroidDevice));
            }
            md5checksums.add(fileElement.getMd5checksum());
        }
        this.logger.debug("Md5 list size......" + backupList.size());
        ArrayList<KeyValueElement> md5AndBackupIds = new ArrayList<KeyValueElement>();
        if (!CollectionUtils.isEmpty(md5checksums)) {
            for (BackUpImage backUpImage : backupList) {
                if (backUpImage.isFolder()) continue;
                KeyValueElement element = new KeyValueElement();
                element.setKey(backUpImage.getMd5Checksum());
                element.setValue(backUpImage.getId().toString());
                md5AndBackupIds.add(element);
            }
        }
        return md5AndBackupIds;
    }

    @Override
    public BackupListElement getChildrenByFolder(int cloudId, String cloudName, String path, ObjectId deviceId) {
        Device device = this.deviceManagementService.getDeviceByObjectId(cloudId, cloudName, deviceId);
        return this.backupService.getChildrenByFolder(cloudId, cloudName, path, device);
    }

    @Override
    public void saveStatisticsForBackup(int cloudId, String cloudName, BackupValidationElement backupListElement, Device device, boolean firstCrawl) {
        if (device == null) {
            throw new ParacloudBackupException(DEVICE_NOT_FOUND, 500);
        }
        List newFileElements = backupListElement.getFilesToAddList().getFileElementList();
        BackUpImageStatistics imageStatistics = new BackUpImageStatistics();
        ArrayList<Map<String, StatisticsInfo>> list = new ArrayList<Map<String, StatisticsInfo>>();
        if (!CollectionUtils.isEmpty((Collection)newFileElements)) {
            String userName = device.getUserName();
            if (firstCrawl) {
                this.backupService.deleteStatisticsForUser(cloudId, cloudName, userName);
            }
            for (FileElement fileElement : newFileElements) {
                if (fileElement.isFolder()) continue;
                String extension = FilenameUtils.getExtension((String)fileElement.getFileName());
                Map<String, StatisticsInfo> statInfoForExt = this.getExtInfo(list, extension);
                StatisticsInfo info = statInfoForExt.get(extension);
                info.setNoOfFiles(info.getNoOfFiles() + 1);
                info.setExtensionName(extension);
                if (StringUtils.isEmpty((Object)fileElement.getSize())) continue;
                Double size = Double.parseDouble(fileElement.getSize());
                long filesizeInKB = (long)Math.ceil(size / 1024.0);
                imageStatistics.setSize(filesizeInKB);
                info.setSize(info.getSize() + filesizeInKB);
            }
            for (Map map : list) {
                for (Map.Entry entry : map.entrySet()) {
                    StatisticsInfo info = (StatisticsInfo)entry.getValue();
                    imageStatistics.setFileExtension(info.getExtensionName());
                    imageStatistics.setNoOfFiles(String.valueOf(info.getNoOfFiles()));
                    imageStatistics.setSize(info.getSize());
                    imageStatistics.setUserName(userName);
                    imageStatistics.setDeviceName(device.getDeviceName());
                    this.backupService.saveBackupStatistics(cloudId, cloudName, imageStatistics);
                }
            }
        }
    }

    private Map<String, StatisticsInfo> getExtInfo(List<Map<String, StatisticsInfo>> list, String extension) {
        Map<String, StatisticsInfo> statInfoForExt = null;
        for (Map<String, StatisticsInfo> statInfo : list) {
            if (StringUtils.isEmpty((Object)statInfo.get(extension))) continue;
            statInfoForExt = statInfo;
            break;
        }
        if (statInfoForExt == null) {
            statInfoForExt = new HashMap<String, StatisticsInfo>();
            statInfoForExt.put(extension, new StatisticsInfo());
            list.add(statInfoForExt);
        }
        return statInfoForExt;
    }

    @Override
    public BackupListResponseElement validateBackUpFilesNew(int cloudId, String cloudName, String deviceRegid, BackupValidationElement backupListElement1, boolean complete, Device device) {
        BackupValidationElement backupListElement = backupListElement1;
        this.logger.debug("START of validate backup files NEWWWW.......");
        boolean isAndroidDevice = true;
        if (device == null) {
            throw new ParacloudBackupException(DEVICE_NOT_FOUND, 500);
        }
        String deviceOperatingSystem = device.getOsType();
        if (deviceOperatingSystem == null) {
            throw new ParacloudBackupException("Exception as dao record is null", 500);
        }
        deviceOperatingSystem = deviceOperatingSystem.toLowerCase();
        if (deviceOperatingSystem.contains(WINDOWS_OS)) {
            isAndroidDevice = false;
        }
        if (complete) {
            this.logger.debug("FIRST TIME CRAWL SO SENDING EMPTY ELEMENT LIST WITHOUT CRAWLING");
            return new BackupListResponseElement();
        }
        ArrayList<FileElement> newFileElements = new ArrayList<FileElement>();
        List deletedFileElements = backupListElement.getFilesToDeleteList().getFileElementList();
        this.markDeleteFilesNew(cloudId, cloudName, isAndroidDevice, device, deletedFileElements);
        if (!PCHelperConstant.getPropertyFileValueIsCrawlEnabled()) {
            this.logger.debug(" DEdup check is disabled. so sending empty element");
            return new BackupListResponseElement();
        }
        this.logger.debug("Before getting the file list from Query.....");
        List<BackUpImage> backupList = this.backupService.getExistingFieldsComparingWithTable(cloudId, cloudName, newFileElements, device);
        BackupListResponseElement backupListResponseElement = new BackupListResponseElement();
        FileListElement fileNotToUploadListElement = new FileListElement();
        fileNotToUploadListElement.setFileElementList(new ArrayList());
        List<BackUpImage> backUpImagesForMd5Dedup = this.getExistingBackupImageMatchesForDedup(backupList, device);
        List<KeyValueElement> list = this.getFilesToBackUp(cloudId, cloudName, isAndroidDevice, device, newFileElements, backUpImagesForMd5Dedup);
        fileNotToUploadListElement.setMd5AndDedupedIdList(list);
        backupListResponseElement.setFilesNotToAddList(fileNotToUploadListElement);
        this.logger.debug("END of validate backup files.......");
        return backupListResponseElement;
    }

    private void markDeleteFilesNew(int cloudId, String cloudName, boolean isAndroidDevice, Device device, List<FileElement> deletedFileElements) {
        ArrayList<BackUpImage> backUpImages = new ArrayList<BackUpImage>();
        if (!CollectionUtils.isEmpty(deletedFileElements)) {
            this.logger.debug(" before marking deleted files new ............" + deletedFileElements.size());
        } else {
            this.logger.debug(" before marking deleted files new ............");
        }
        System.setProperty("java.util.concurrent.ForkJoinPool.common.parallelism", "5");
        this.logger.debug("....adding parallelism 5 threads...");
        deletedFileElements.parallelStream().forEach(fileElement -> {
            if (!isAndroidDevice) {
                fileElement.setFileCompletePath(PathConversionHelper.getServerCompatiblePath((String)fileElement.getFileCompletePath(), (boolean)isAndroidDevice));
            }
        });
        for (FileElement fileElement2 : deletedFileElements) {
            String sizeValue;
            BackUpImage oldBackupImage = new BackUpImage();
            oldBackupImage.setFileName(fileElement2.getFileName());
            oldBackupImage.setDevicePath(fileElement2.getFileCompletePath());
            oldBackupImage.setFolder(fileElement2.isFolder());
            if (!oldBackupImage.isFolder() && (sizeValue = fileElement2.getSize()) != null && sizeValue != "") {
                long fileSizeinBytes = Long.parseLong(sizeValue);
                long filesizeInKB = (long)Math.ceil((double)fileSizeinBytes / 1024.0);
                oldBackupImage.setSize(filesizeInKB);
            }
            BackUpImage backUpImage2 = new BackUpImage();
            ObjectConversionHelper.convertToBackUpImage(oldBackupImage, device.getDeviceUUID(), backUpImage2, device, false, oldBackupImage.getfSPath(), PCHelperConstant.REVISION_STATUS.DELETED.toString(), false);
            backUpImage2.setUserName(device.getUserName());
            backUpImages.add(backUpImage2);
            BaseController.printLogs((String)(oldBackupImage.getStoragePlace() + "after marking  deleted files new..check ........." + backUpImage2.getStoragePlace()), (boolean)PCHelperConstant.isBrevityLogging());
            if (backUpImages.size() <= 1000) continue;
            this.backupService.saveBatchEntry(cloudId, cloudName, backUpImages, device.getDestCollection());
            backUpImages.clear();
        }
        this.backupService.saveBatchEntry(cloudId, cloudName, backUpImages, device.getDestCollection());
        this.logger.debug("after marking  deleted files new...........");
    }

    private List<BackUpImage> getExistingBackupImageMatches(List<BackUpImage> list, List<FileElement> fileElementList, Device device) {
        ArrayList<BackUpImage> backUpImages = new ArrayList<BackUpImage>();
        block0: for (BackUpImage backUpImage : list) {
            if (backUpImage == null) continue;
            for (FileElement fileElement : fileElementList) {
                if (StringUtils.isEmpty((Object)fileElement.getFileCompletePath()) || !backUpImage.getFileName().equals(fileElement.getFileName()) || !backUpImage.getDevicePath().equals(fileElement.getFileCompletePath()) || !backUpImage.getDeviceUUID().equals(device.getDeviceUUID())) continue;
                backUpImages.add(backUpImage);
                continue block0;
            }
        }
        return backUpImages;
    }

    private List<BackUpImage> getExistingBackupImageMatchesForDedup(List<BackUpImage> list, Device device) {
        ArrayList<BackUpImage> backUpImages = new ArrayList<BackUpImage>();
        for (BackUpImage backUpImage : list) {
            if (backUpImage == null || backUpImage.getDeviceUUID() == null || device == null) continue;
            this.logger.debug("Before File matches with md5........" + backUpImage.getFileName() + "Listt   Size" + list.size());
            if (!backUpImage.getDeviceUUID().equals(device.getDeviceUUID())) continue;
            this.logger.debug("File matches with md5........" + backUpImage.getFileName());
            backUpImages.add(backUpImage);
        }
        this.logger.debug("After getting the Dedup file list.....");
        return backUpImages;
    }

    public class StatisticsInfo {
        private int noOfFiles;
        private long size;
        private String extensionName;

        public String getExtensionName() {
            return this.extensionName;
        }

        public void setExtensionName(String extensionName) {
            this.extensionName = extensionName;
        }

        public int getNoOfFiles() {
            return this.noOfFiles;
        }

        public void setNoOfFiles(int noOfFiles) {
            this.noOfFiles = noOfFiles;
        }

        public long getSize() {
            return this.size;
        }

        public void setSize(long size) {
            this.size = size;
        }
    }
}

