/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.bluvault.backup.controller;

import com.parablu.bluvault.ah.service.AuditHistoryService;
import com.parablu.bluvault.backup.service.BackupService;
import com.parablu.bluvault.udc.controller.BaseController;
import com.parablu.bluvault.udc.service.AlertHistoryService;
import com.parablu.bluvault.udc.service.CloudSettingsService;
import com.parablu.bluvault.udc.service.DeviceManagementService;
import com.parablu.bluvault.udc.service.EventHubManagementService;
import com.parablu.bluvault.udc.service.UserManagementService;
import com.parablu.cloud.security.service.LicenseService;
import com.parablu.cloud.security.to.CloudLicenseTo;
import com.parablu.helper.exceptions.BaseException;
import com.parablu.mail.service.CloudMailService;
import com.parablu.paracloud.constant.PCActionTypes;
import com.parablu.paracloud.constant.PCHelperConstant;
import com.parablu.paracloud.element.BackupLogElement;
import com.parablu.paracloud.element.BackupStatusElement;
import com.parablu.paracloud.element.DeviceElement;
import com.parablu.paracloud.element.EmailProps;
import com.parablu.paracloud.element.EmailRecipent;
import com.parablu.paracloud.element.FileElement;
import com.parablu.paracloud.element.UserElement;
import com.parablu.paracloud.util.DateUtil;
import com.parablu.pcbd.domain.AlertHistory;
import com.parablu.pcbd.domain.AuthorizationTokens;
import com.parablu.pcbd.domain.BackUpImage;
import com.parablu.pcbd.domain.BackupAttempt;
import com.parablu.pcbd.domain.BackupBatch;
import com.parablu.pcbd.domain.BackupFile;
import com.parablu.pcbd.domain.BackupLog;
import com.parablu.pcbd.domain.BackupPolicy;
import com.parablu.pcbd.domain.Cloud;
import com.parablu.pcbd.domain.CloudCustomisableDetails;
import com.parablu.pcbd.domain.Device;
import com.parablu.pcbd.domain.DeviceBackupOverView;
import com.parablu.pcbd.domain.EventHub;
import com.parablu.pcbd.domain.MailBackupBatch;
import com.parablu.pcbd.domain.ReBackUpImage;
import com.parablu.pcbd.domain.RestoreEvents;
import com.parablu.pcbd.domain.RestoreHistory;
import com.parablu.pcbd.domain.User;
import java.io.IOException;
import java.io.InputStream;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bson.types.ObjectId;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class BackupBatchController
extends BaseController {
    private static Logger logger = LogManager.getLogger(BackupBatchController.class);
    @Autowired
    private LicenseService licenseService;
    @Autowired
    private DeviceManagementService deviceManagementService;
    @Autowired
    private CloudMailService cloudMailService;
    @Autowired
    private AlertHistoryService alertHistoryService;
    @Autowired
    private BackupService backupService;
    @Autowired
    private UserManagementService userManagementService;
    @Autowired
    private EventHubManagementService eventHubManagementService;
    @Autowired
    private AuditHistoryService auditHistoryService;
    @Autowired
    private CloudSettingsService cloudSettingService;
    private static final String BATCH_ID = "batchId";
    private static final String BACKUP = "BACKUP";
    private static final String COMPLETED = "COMPLETED";
    private static final int FAIRNESS_CODE = 555;
    private static final String STARTED = "STARTED";
    public static final String DD_MMM_YYYY_HH_MM_SS = "dd-MMM-yyyy HH:mm:ss";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"cloud/{cloudName}/backupBatch/save"}, method={RequestMethod.POST})
    public void saveBackupBatch(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug("calling backup Batch ...");
        try {
            int count;
            AuthorizationTokens authorizationTokens;
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return;
            }
            boolean isFirstAttempt = false;
            int cloudId = cl.getCloud().getCloudId();
            cloudName = cl.getCloud().getCloudName();
            String token = request.getHeader("token");
            String batchStatus = request.getHeader("batchStatus");
            String batchId = request.getHeader(BATCH_ID);
            String jobType = request.getHeader("jobType");
            String noOfFiles = request.getHeader("noOfFiles");
            String deviceName = request.getHeader("deviceName");
            String deviceUUID = request.getHeader("deviceUUID");
            String errorCode = request.getHeader("errorCode");
            String restoreByPortal = request.getHeader("restoreByPortal");
            String destFolder = request.getHeader("destFolder");
            logger.debug(".....destFolder....." + destFolder);
            String uploadedFiles = request.getHeader("uploadedFiles");
            String totalNoOfFiles = request.getHeader("totalNoOfFiles");
            String crawlTimestamp = request.getHeader("crawlTimestamp");
            logger.debug(".....totalNoOfFiles....." + totalNoOfFiles);
            String fullBackup = request.getHeader("isFullBackup");
            String restoredDeviceUUID = request.getHeader("restoreDeviceUUID");
            String restoreFolder = request.getHeader("restoreFolder");
            String totalSizeRestore = request.getHeader("totalSizeRestore");
            String actionBy = request.getHeader("actionBy");
            logger.debug(".totalSizeRestore.." + totalSizeRestore);
            String diskSpaceDetails = null;
            String configuredBackupFolders = null;
            if (request.getHeader("diskSpaceDetails") != null) {
                diskSpaceDetails = request.getHeader("diskSpaceDetails");
            }
            String headerEncoding = request.getHeader("header-encoding");
            String headerRestoreEncoding = request.getHeader("header-encoding-restore");
            String headerEncodingForRestoreDest = request.getHeader("header-encoding-restoredestpath");
            if (!StringUtils.isEmpty((String)request.getHeader("restoreFolder")) && "base64".equalsIgnoreCase(headerRestoreEncoding)) {
                restoreFolder = this.decodeBase64UTFString(request.getHeader("restoreFolder"));
            }
            String deletedFilesSize = request.getHeader("deletedFilesSize");
            String newFilesSize = request.getHeader("newFilesSize");
            long deletedFiles = 0L;
            long encryptedFiles = 0L;
            long newFiles = 0L;
            long modifiedFiles = 0L;
            boolean policyStorageExceeded = false;
            if (StringUtils.isNotEmpty((String)deletedFilesSize)) {
                deletedFiles = Long.parseLong(deletedFilesSize);
            }
            if (StringUtils.isNotEmpty((String)newFilesSize)) {
                newFiles = Long.parseLong(newFilesSize);
            }
            if (!StringUtils.isEmpty((String)request.getHeader("configuredBackupFolder"))) {
                configuredBackupFolders = "base64".equalsIgnoreCase(headerEncoding) ? this.decodeBase64UTFString(request.getHeader("configuredBackupFolder")) : request.getHeader("configuredBackupFolder");
            }
            if (!StringUtils.isEmpty((String)destFolder) && "base64".equalsIgnoreCase(headerEncodingForRestoreDest)) {
                destFolder = this.decodeBase64UTFString(destFolder);
            }
            logger.debug(".....destFolder....." + destFolder);
            String failedFilesLogsEnabled = request.getHeader("failedFilesLog");
            boolean isFullBackup = false;
            if (!StringUtils.isEmpty((String)fullBackup)) {
                isFullBackup = Boolean.parseBoolean(fullBackup);
            }
            boolean isLatestAgent = false;
            logger.debug(batchId + "....isLatestAgent..............." + request.getHeader("isLatestAgent") + ".........batchStatus...." + batchStatus);
            if (!StringUtils.isEmpty((String)request.getHeader("isLatestAgent"))) {
                isLatestAgent = Boolean.parseBoolean(request.getHeader("isLatestAgent"));
            }
            logger.debug("....restoredInDiffPath...." + request.getHeader("restoredInDiffPath"));
            boolean restoredInDiffPath = false;
            if (!StringUtils.isEmpty((String)request.getHeader("restoredInDiffPath"))) {
                restoredInDiffPath = Boolean.parseBoolean(request.getHeader("restoredInDiffPath"));
            }
            if ((authorizationTokens = this.authorizationService.getTokenDetailsForToken(cloudId, cloudName, token)) == null) {
                response.setStatus(421);
                return;
            }
            if (authorizationTokens.getUser() != null && authorizationTokens.getUser().isSuspended() && (batchStatus.equalsIgnoreCase(STARTED) || batchStatus.equalsIgnoreCase("SCANNING"))) {
                logger.debug("User is suspended.....");
                response.setStatus(400);
                return;
            }
            Device device = this.deviceManagementService.getDeviceByNameForUserId(cloudId, cloudName, deviceName, authorizationTokens.getUser().getUserId(), deviceUUID);
            logger.debug(" ************ " + batchId);
            User user = authorizationTokens.getUser();
            if (!StringUtils.isEmpty((String)batchId) && "-1".equals(batchId) && jobType.equalsIgnoreCase(BACKUP)) {
                this.backupService.updateBackupBatch(cloudId, device.getDeviceUUID(), user.getUserName());
                response.setStatus(200);
                response.setHeader(BATCH_ID, batchId);
                logger.debug(" *****Batch id is -1 updated previous started ******* ");
                return;
            }
            ServletInputStream input = null;
            input = request.getInputStream();
            if (!StringUtils.isEmpty((String)failedFilesLogsEnabled) && "failedFilesLog".equalsIgnoreCase(failedFilesLogsEnabled)) {
                try {
                    this.backupService.storeFailedFilesLogForRequestId(deviceUUID, batchId, (InputStream)input);
                }
                catch (Exception e) {
                    logger.error("Error failed to save logs ..." + e.getMessage());
                }
                finally {
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (IOException e) {
                            logger.debug(e + "");
                        }
                    }
                }
            }
            BackupBatch backupBatch = new BackupBatch();
            backupBatch.setUserName(user.getUserName());
            backupBatch.setDeviceName(device.getDeviceName());
            backupBatch.setDeviceUUID(device.getDeviceUUID());
            backupBatch.setJobType(jobType);
            backupBatch.setNoOfFiles(Long.parseLong(noOfFiles));
            if (batchStatus.equalsIgnoreCase(STARTED) || batchStatus.equalsIgnoreCase("SCANNING") || batchStatus.equals(COMPLETED) || batchStatus.equals("STARTED/COMPLETED")) {
                backupBatch.setFullBackup(isFullBackup);
            }
            BackupBatch previousBackupBatch = this.backupService.getLastBackupOnly(cloudId, cloudName, user, device, false);
            boolean addNewAttempt = false;
            if ("STARTED/COMPLETED".equalsIgnoreCase(batchStatus) && jobType.equalsIgnoreCase(BACKUP) && StringUtils.isEmpty((String)batchId) && previousBackupBatch != null && (previousBackupBatch.getStatus().equalsIgnoreCase("INTERRUPTED") || previousBackupBatch.getStatus().equalsIgnoreCase("ABORTED") && previousBackupBatch.getErrorCode().equalsIgnoreCase("543")) && errorCode.equalsIgnoreCase("543")) {
                logger.debug(".........target not assigned set status.......");
                org.springframework.beans.BeanUtils.copyProperties((Object)previousBackupBatch, (Object)backupBatch);
                if (previousBackupBatch.getStatus().equalsIgnoreCase("INTERRUPTED")) {
                    logger.debug(".........target not assigned set status INTERRUPTED.......");
                    backupBatch.setStatus("INTERRUPTED");
                    batchStatus = "INTERRUPTED";
                }
                backupBatch.setErrorCode(errorCode);
                addNewAttempt = true;
            } else if (StringUtils.isEmpty((String)batchId)) {
                logger.debug(".........inside new entry.......");
                isFirstAttempt = true;
                backupBatch.setUserName(user.getUserName());
                backupBatch.setBatchStartTimestamp(System.currentTimeMillis());
                backupBatch.setTotalNoOfFiles(totalNoOfFiles);
                backupBatch.setUploadedFiles("0/" + totalNoOfFiles);
            } else {
                logger.debug("......... inside else.......");
                backupBatch = this.backupService.getBackupBatch(cloudId, cloudName, batchId);
            }
            logger.debug(".....totalSizeToUpload......" + request.getHeader("totalSizeToUpload"));
            logger.debug(".....totalSizeToUpload batch......" + backupBatch.getTotalSizeToUpload());
            if (StringUtils.isNotEmpty((String)request.getHeader("totalSizeToUpload")) && backupBatch.getTotalSizeToUpload() == 0L) {
                long totalSizeToUpload = Long.parseLong(request.getHeader("totalSizeToUpload"));
                backupBatch.setTotalSizeToUpload(totalSizeToUpload);
            }
            backupBatch.setStatus(batchStatus);
            if (backupBatch != null && StringUtils.isNotEmpty((String)backupBatch.getStatus()) && backupBatch.getStatus().equalsIgnoreCase("SCANNING") && previousBackupBatch != null && (previousBackupBatch.getStatus().equalsIgnoreCase("SCANNING") || previousBackupBatch.getStatus().equalsIgnoreCase(STARTED))) {
                this.backupService.updateBackupBatch(cloudId, previousBackupBatch.getId().toString(), "ABORTED", "1207", previousBackupBatch);
            }
            if (backupBatch != null && StringUtils.isNotEmpty((String)backupBatch.getStatus()) && backupBatch.getStatus().equalsIgnoreCase("SCANNING")) {
                backupBatch.setTotalNoOfFiles(totalNoOfFiles);
                backupBatch.setUploadedFiles("0/" + totalNoOfFiles);
            }
            backupBatch.setBatchEndTimestamp(System.currentTimeMillis());
            if (backupBatch != null && StringUtils.isNotEmpty((String)backupBatch.getStatus()) && !backupBatch.getStatus().equalsIgnoreCase("SCANNING")) {
                logger.debug("....backupBatch.getTotalNoOfFiles()....." + backupBatch.getTotalNoOfFiles());
                if (!StringUtils.isEmpty((String)backupBatch.getTotalNoOfFiles()) && Long.parseLong(backupBatch.getTotalNoOfFiles()) == 0L) {
                    backupBatch.setTotalNoOfFiles(totalNoOfFiles);
                }
                backupBatch.setUploadedFiles(this.getActualUploadedFiles(uploadedFiles) + "/" + backupBatch.getTotalNoOfFiles());
            }
            if ("STARTED/COMPLETED".equalsIgnoreCase(batchStatus) && jobType.equalsIgnoreCase(BACKUP)) {
                this.eventHubManagementService.deleteActionBasedOnBackupBatchStatus(cloudId, cloudName, backupBatch.getDeviceUUID(), "STARTED/COMPLETED", backupBatch, errorCode);
                if (errorCode.equalsIgnoreCase("543")) {
                    logger.debug(".........target not assigned set status to aborted.......");
                    backupBatch.setStatus("ABORTED");
                } else {
                    backupBatch.setStatus(COMPLETED);
                }
            } else if (errorCode.equalsIgnoreCase("1992") || errorCode.equalsIgnoreCase("1208")) {
                backupBatch.setStatus("PAUSED");
            } else if (errorCode.equalsIgnoreCase("911")) {
                backupBatch.setStatus("EXITED");
            } else if (errorCode.equalsIgnoreCase("543")) {
                backupBatch.setStatus("INTERRUPTED");
            }
            logger.debug("...errorCode...." + errorCode);
            logger.debug(user.getUserName() + "...errorCode username...." + device.getUserName());
            backupBatch.setErrorCode(errorCode);
            if ("1992".equalsIgnoreCase(errorCode) && !user.getUserName().equalsIgnoreCase(device.getUserName())) {
                errorCode = "1208";
                backupBatch.setErrorCode(errorCode);
            }
            if ("1207".equalsIgnoreCase(errorCode) && !user.getUserName().equalsIgnoreCase(device.getUserName())) {
                errorCode = "1209";
                backupBatch.setErrorCode(errorCode);
            }
            backupBatch.setCrawlTimestamp(crawlTimestamp);
            if (!StringUtils.isEmpty((String)diskSpaceDetails)) {
                backupBatch.setDiskSpaceDetails(diskSpaceDetails);
            }
            if (!StringUtils.isEmpty((String)configuredBackupFolders)) {
                backupBatch.setConfiguredBackupFolder(configuredBackupFolders);
            }
            logger.debug("jobType......" + jobType + "......uploadedFiles.." + uploadedFiles);
            if ("RESTORE".equalsIgnoreCase(jobType) && !"STARTED/COMPLETED".equalsIgnoreCase(batchStatus)) {
                backupBatch.setUploadedFiles(uploadedFiles);
                if (!isLatestAgent && !StringUtils.isEmpty((String)batchStatus)) {
                    if (batchStatus.equalsIgnoreCase(COMPLETED)) {
                        backupBatch.setErrorCode("200");
                    } else if (batchStatus.equalsIgnoreCase("FAILED")) {
                        backupBatch.setErrorCode("200");
                        backupBatch.setStatus(COMPLETED);
                    }
                }
            }
            if ("STARTED/COMPLETED".equalsIgnoreCase(batchStatus) && jobType.equalsIgnoreCase("RESTORE")) {
                logger.debug("........status changing to.....");
                batchStatus = "FAILED";
                backupBatch.setStatus("FAILED");
                backupBatch.setId(null);
                restoreByPortal = "FAILED";
                backupBatch.setBatchStartTimestamp(System.currentTimeMillis());
            }
            logger.debug(backupBatch.getStatus() + "...delbatchfolder... " + batchId + "...." + backupBatch.getId());
            encryptedFiles = backupBatch.getEncryptedFilesSize();
            backupBatch.setEncryptedFilesSize(encryptedFiles);
            backupBatch.setNewFilesSize(newFiles);
            backupBatch.setDeletedFilesSize(deletedFiles);
            logger.debug("encryptedFiles..........." + encryptedFiles);
            logger.debug("encryptedFiles..........." + encryptedFiles);
            logger.debug("deletedFiles..........." + deletedFiles);
            Boolean isrwLicenseEnabled = this.isLicenseEnabled(cl.getCloud(), "RW License Allowed");
            logger.debug("isrwLicenseEnabled....." + isrwLicenseEnabled);
            BackupPolicy backupPolicy = null;
            if (user != null && !StringUtils.isEmpty((String)user.getPolicyName())) {
                backupPolicy = this.backupService.getBackupPolicy(cloudId, cloudName, user.getPolicyName());
            }
            if ((count = this.backupService.getSuccessFullBackupBatchCount(cloudId, cloudName, deviceUUID)) > 15 && COMPLETED.equalsIgnoreCase(backupBatch.getStatus().toString()) && isrwLicenseEnabled.booleanValue() && backupPolicy != null && backupPolicy.isRwDetectionEnabled()) {
                long noOfFilesBackedup = 0L;
                if (backupBatch != null && StringUtils.isNotEmpty((String)backupBatch.getTotalNoOfFiles())) {
                    noOfFilesBackedup = Long.parseLong(backupBatch.getTotalNoOfFiles());
                }
                long ransomwareDetectionFilesCount = this.cloudSettingService.getCloudPropertyElement(cloudId).getRansomwareDetectionFilesCount();
                logger.debug(ransomwareDetectionFilesCount + "noOfFilesBackedup........" + noOfFilesBackedup + "...increamental backup count........" + count);
                if (count > 15 && (noOfFilesBackedup >= ransomwareDetectionFilesCount || deletedFiles >= ransomwareDetectionFilesCount)) {
                    modifiedFiles = noOfFilesBackedup - newFiles;
                    logger.debug("...........modifiedFiles....." + modifiedFiles);
                    int ransomwareDetectionPercentage = this.cloudSettingService.getCloudPropertyElement(cloudId).getRansomwareDetectionPercentage();
                    try {
                        if (noOfFilesBackedup != 0L) {
                            noOfFilesBackedup = (long)ransomwareDetectionPercentage * noOfFilesBackedup / 100L;
                        }
                    }
                    catch (Exception e) {
                        logger.trace("Exception  :" + e);
                        logger.error("Exception  :" + e.getMessage());
                    }
                    Device deviceInfo = this.deviceManagementService.getDeviceByDeviceUUID(cloudId, cloudName, deviceUUID);
                    long currentTime = System.currentTimeMillis();
                    boolean deletedFilesDetected = false;
                    boolean encryptedFilesDetected = false;
                    boolean newFilesDetected = false;
                    boolean modifiedFilesDetected = false;
                    if (deletedFiles >= 1L && deletedFiles >= noOfFilesBackedup) {
                        deviceInfo.setUnusualActivity(true);
                        deletedFilesDetected = true;
                    }
                    if (newFiles >= 1L && newFiles >= noOfFilesBackedup) {
                        deviceInfo.setUnusualActivity(true);
                        newFilesDetected = true;
                    }
                    if (encryptedFiles >= 1L && encryptedFiles >= noOfFilesBackedup) {
                        deviceInfo.setUnusualActivity(true);
                        encryptedFilesDetected = true;
                    }
                    if (modifiedFiles >= 1L && modifiedFiles >= noOfFilesBackedup) {
                        deviceInfo.setUnusualActivity(true);
                        modifiedFilesDetected = true;
                    }
                    this.deviceManagementService.updateDevice(cloudId, deviceInfo);
                    if (encryptedFilesDetected || deletedFilesDetected || newFilesDetected || modifiedFilesDetected) {
                        String ransomwarepossible = "other";
                        if (encryptedFilesDetected && deletedFilesDetected && newFilesDetected && modifiedFilesDetected) {
                            ransomwarepossible = "Possible Ransomware";
                        }
                        if (newFilesDetected || encryptedFilesDetected || deletedFilesDetected || modifiedFilesDetected) {
                            this.auditHistoryService.saveUnusualStatisticToDatabase(cloudId, cloudName, ransomwarepossible, encryptedFiles, user.getUserName(), deviceInfo.getDeviceName(), "Endpoint", currentTime, PCActionTypes.UNUSUAL_ACTIVITY.getActionTypeValue(), backupBatch.getTotalNoOfFiles(), backupBatch.getBatchStartTimestamp(), deviceInfo.getDeviceUUID(), deviceInfo.getOsType(), true, batchId, encryptedFilesDetected, encryptedFilesDetected, newFilesDetected, deletedFiles, newFiles, modifiedFilesDetected, modifiedFiles);
                        }
                        if (newFilesDetected || encryptedFilesDetected || deletedFilesDetected || modifiedFilesDetected) {
                            this.auditHistoryService.saveStatisticToDatabaseForUDA(cloudId, cloudName, ransomwarepossible, encryptedFiles, user.getUserName(), deviceInfo.getDeviceName(), "Endpoint", currentTime, PCActionTypes.UNUSUAL_ACTIVITY.getActionTypeValue(), backupBatch.getTotalNoOfFiles(), backupBatch.getBatchStartTimestamp(), deviceInfo.getDeviceUUID(), deviceInfo.getOsType(), true, batchId, encryptedFilesDetected, encryptedFilesDetected, newFilesDetected, deletedFiles, newFiles, modifiedFiles);
                        }
                    }
                }
            }
            this.updateBatch(cloudName, cloudId, backupBatch, isFirstAttempt, addNewAttempt, policyStorageExceeded);
            logger.debug(backupBatch.getStatus() + "...delbatchfolder... " + batchId + "...." + backupBatch.getId().toString());
            if ("RESTORE".equalsIgnoreCase(jobType)) {
                logger.debug(backupBatch.getStatus() + "...delbatchfolder... " + batchId + "...." + backupBatch.getId().toString());
                if (!STARTED.equalsIgnoreCase(backupBatch.getStatus().toString())) {
                    try {
                        String deviceUUIDVal = restoredDeviceUUID;
                        if (StringUtils.isEmpty((String)deviceUUIDVal)) {
                            deviceUUIDVal = device.getDeviceUUID();
                        }
                        logger.debug(restoredDeviceUUID + "..before saving deletefolders for batch...." + deviceUUIDVal);
                        this.backupService.saveRestoreDetailsForDelFolders(cloudId, backupBatch.getId(), deviceUUIDVal);
                    }
                    catch (Exception e) {
                        logger.error(".... error trying to save restore del folders ..." + e.getMessage());
                    }
                }
                DeviceElement deviceElement = this.deviceManagementService.getDeviceInfo(cloudId, cloudName, restoredDeviceUUID);
                this.saveRestoreHistory(cloudName, cloudId, restoredDeviceUUID, restoreFolder, backupBatch, deviceElement, totalSizeRestore, destFolder, restoredInDiffPath, actionBy);
            }
            this.eventHubManagementService.deleteActionBasedOnBackupBatchStatus(cloudId, cloudName, backupBatch.getDeviceUUID(), backupBatch.getStatus(), backupBatch, errorCode);
            logger.debug("[backupBatch][" + backupBatch.getUserName() + "][" + backupBatch.getDeviceUUID() + "][" + backupBatch.getId() + "][" + backupBatch.getStatus() + "][" + backupBatch.getBatchStartTimestamp() + "][" + backupBatch.getBatchEndTimestamp() + "]");
            if (STARTED.equalsIgnoreCase(batchStatus)) {
                AlertHistory alertHistory = new AlertHistory();
                alertHistory.setUser(user);
                alertHistory.setDevice(device);
                alertHistory.setJobType(jobType);
                alertHistory.setBatchStartTimestamp(System.currentTimeMillis());
                alertHistory.setBatchEndTimestamp(System.currentTimeMillis());
                if (jobType.equalsIgnoreCase(BACKUP)) {
                    alertHistory.setAction("Backup Initiated on " + DateUtil.getDateInddMMMyyyy((long)System.currentTimeMillis()) + " by " + user.getUserName());
                } else if (jobType.equalsIgnoreCase("RESTORE")) {
                    alertHistory.setAction("Restore Initiated on " + DateUtil.getDateInddMMMyyyy((long)System.currentTimeMillis()) + " by " + user.getUserName());
                    NotifierEmailBodyElement notifierEmailBodyElement = new NotifierEmailBodyElement();
                    notifierEmailBodyElement.setDeviceName(device.getDeviceName());
                    notifierEmailBodyElement.setRestoreFolder(restoreFolder);
                    notifierEmailBodyElement.setBatchStartTimestamp(backupBatch.getBatchStartTimestamp());
                    DeviceElement deviceElement = this.deviceManagementService.getDeviceInfo(cloudId, cloudName, restoredDeviceUUID);
                    this.saveRestoreHistory(cloudName, cloudId, restoredDeviceUUID, restoreFolder, backupBatch, deviceElement, totalSizeRestore, destFolder, restoredInDiffPath, actionBy);
                    this.sendEmailNotifierForRestore(cloudId, cloudName, user, backupBatch.getUserName(), notifierEmailBodyElement, deviceElement, "restore-initiated", actionBy);
                    this.backupService.deleteRestoredFilesCollById(cloudId, backupBatch.getId().toString());
                }
                this.alertHistoryService.saveAlertHistory(cloudId, cloudName, alertHistory);
            }
            if ("RESTORE".equalsIgnoreCase(jobType) && !STARTED.equalsIgnoreCase(batchStatus) && !"STARTED/COMPLETED".equalsIgnoreCase(batchStatus)) {
                try {
                    String deviceUUIDVal = restoredDeviceUUID;
                    if (StringUtils.isEmpty((String)deviceUUIDVal)) {
                        RestoreHistory restoreHistory = this.backupService.getRestoreHistoryById(cloudId, backupBatch.getId());
                        if (restoreHistory != null) {
                            logger.debug(".... restore uuuid not found so calling histor.. ..." + restoreHistory.getDeviceUUID());
                            deviceUUIDVal = restoreHistory.getDeviceUUID();
                        } else {
                            logger.debug(".... restore uuuid not found no restore histor.. ..." + device.getDeviceUUID());
                            deviceUUIDVal = device.getDeviceUUID();
                        }
                    }
                    logger.debug(restoredDeviceUUID + "..before saving deletefolders for batch...." + deviceUUIDVal);
                    this.backupService.saveRestoreDetailsForDelFolders(cloudId, backupBatch.getId(), deviceUUIDVal);
                }
                catch (Exception e) {
                    logger.error(".... exception......" + e.getMessage());
                }
                DeviceElement deviceElement = this.deviceManagementService.getDeviceInfo(cloudId, cloudName, restoredDeviceUUID);
                this.saveRestoreHistory(cloudName, cloudId, restoredDeviceUUID, restoreFolder, backupBatch, deviceElement, totalSizeRestore, destFolder, restoredInDiffPath, actionBy);
                this.eventHubManagementService.removeRestoreProgress(cloudId, deviceUUID);
            }
            if ("RESTORE".equalsIgnoreCase(jobType) && COMPLETED.equalsIgnoreCase(backupBatch.getStatus())) {
                logger.debug(device.getUserName() + " @#@#  Restore aCompleted ........." + device.getDeviceName());
                DeviceBackupOverView overView = this.deviceManagementService.getDeviceBkpOverviewForDeviceUUID(cloudId, deviceUUID);
                long noOfSuccessfulRestores = overView.getNoOfSuccessfulRestores();
                overView.setNoOfSuccessfulRestores(noOfSuccessfulRestores + 1L);
                this.deviceManagementService.updateDeviceBackupOverView(cloudId, overView);
                this.eventHubManagementService.removeRestoreProgress(cloudId, deviceUUID);
                DeviceElement deviceElement = this.deviceManagementService.getDeviceInfo(cloudId, cloudName, restoredDeviceUUID);
                this.saveRestoreHistory(cloudName, cloudId, restoredDeviceUUID, restoreFolder, backupBatch, deviceElement, totalSizeRestore, destFolder, restoredInDiffPath, actionBy);
                NotifierEmailBodyElement notifierEmailBodyElement = new NotifierEmailBodyElement();
                notifierEmailBodyElement.setDeviceName(device.getDeviceName());
                notifierEmailBodyElement.setRestoreFolder(restoreFolder);
                if (StringUtils.isNotEmpty((String)totalSizeRestore)) {
                    notifierEmailBodyElement.setRestoreSize(BackupBatchController.formatFileSizeIncludeKB(Long.parseLong(totalSizeRestore) / 1024L));
                } else {
                    notifierEmailBodyElement.setRestoreSize("0.00 KB");
                }
                notifierEmailBodyElement.setBatchStartTimestamp(backupBatch.getBatchStartTimestamp());
                notifierEmailBodyElement.setBatchEndTimestamp(backupBatch.getBatchEndTimestamp());
                if (StringUtils.isNotEmpty((String)backupBatch.getUploadedFiles())) {
                    notifierEmailBodyElement.setNoOfFilesBackedUp(String.valueOf(backupBatch.getUploadedFiles()));
                } else {
                    notifierEmailBodyElement.setNoOfFilesBackedUp("0");
                }
                notifierEmailBodyElement.setRestoreStatus(backupBatch.getStatus());
                this.sendEmailNotifierForRestore(cloudId, cloudName, user, backupBatch.getUserName(), notifierEmailBodyElement, deviceElement, "restore-completed", actionBy);
            }
            this.updateRestoreEventStatus(cloudId, restoreByPortal, device, backupBatch);
            if (BACKUP.equalsIgnoreCase(jobType)) {
                DeviceBackupOverView overView = this.deviceManagementService.getDeviceBkpOverviewForDeviceUUID(cloudId, deviceUUID);
                if (overView == null) {
                    logger.debug(" No device backup ....");
                    this.deviceManagementService.saveDeviceBackupOverView(cloudId, device);
                } else {
                    logger.debug(" update device backup ....");
                    if (StringUtils.isEmpty((String)overView.getFirstBkpStartTime())) {
                        String firstBkpStartTime = this.getDateInFormat(backupBatch.getBatchStartTimestamp());
                        overView.setFirstBkpStartTime(firstBkpStartTime);
                    }
                    if (StringUtils.isEmpty((String)batchId)) {
                        overView.setCurrentlyRunningBkpNoOfFiles(0L);
                        overView.setCurrentlyRunningBkpTotalSizeOfFiles(0L);
                    }
                    String lastBkpStartTime = this.getDateInFormat(backupBatch.getBatchStartTimestamp());
                    overView.setLastBkpStartTime(lastBkpStartTime);
                    if (backupBatch.getBatchEndTimestamp() > 0L) {
                        overView.setLastBkpEndTime(this.getDateInFormat(backupBatch.getBatchEndTimestamp()));
                    } else {
                        overView.setLastBkpEndTime(this.getDateInFormat(System.currentTimeMillis()));
                    }
                    overView.setLastBkpStatus(backupBatch.getStatus());
                    overView.setTotalNoOfFiles(backupBatch.getTotalNoOfFiles());
                    logger.debug("TotalNoOfFiles : " + backupBatch.getTotalNoOfFiles() + " UploadedFiles : " + backupBatch.getUploadedFiles());
                    overView.setNoOfFilesRemaining(this.getNoOfFilesRemaining(backupBatch.getTotalNoOfFiles(), backupBatch.getUploadedFiles()));
                    if (backupBatch.getTotalSizeToUpload() != 0L) {
                        overView.setTotalSizeToUpload(backupBatch.getTotalSizeToUpload() / 1024L);
                    }
                    logger.debug("Backup/Restore Status*" + backupBatch.getStatus() + "**");
                    if (COMPLETED.equalsIgnoreCase(backupBatch.getStatus())) {
                        if (StringUtils.isEmpty((String)overView.getLastSuccessfulBkp())) {
                            NotifierEmailBodyElement notifierEmailBodyElement = new NotifierEmailBodyElement();
                            notifierEmailBodyElement.setDeviceName(deviceName);
                            notifierEmailBodyElement.setNoOfFilesBackedUp(backupBatch.getTotalNoOfFiles());
                            if (!StringUtils.isEmpty((String)backupBatch.getUploadedSize())) {
                                notifierEmailBodyElement.setTotalBackupSize(BackupBatchController.formatFileSize(Long.parseLong(backupBatch.getUploadedSize())));
                            } else {
                                notifierEmailBodyElement.setTotalBackupSize("0");
                            }
                            this.sendEmail("first-backup-completed", user.getUserName(), user.getUserName(), user.getEmailId(), notifierEmailBodyElement, overView.getDeviceUUID());
                        }
                        String lastSuccessfulBkp = this.getDateInFormat(backupBatch.getBatchEndTimestamp());
                        overView.setLastSuccessfulBkp(lastSuccessfulBkp);
                        overView.setLastSuccessfulBackupStartTime(backupBatch.getBatchStartTimestamp());
                        overView.setLastSuccessfulBackupEndTime(backupBatch.getBatchEndTimestamp());
                        logger.debug(device.getUserName() + " @#@# Backup  Completed ........." + device.getDeviceName());
                        long noOfSuccessfulBackups = overView.getNoOfSuccessfulBackups();
                        overView.setNoOfSuccessfulBackups(noOfSuccessfulBackups + 1L);
                        if (StringUtils.isEmpty((String)overView.getFirstBkpEndTime())) {
                            logger.debug(" ..firstbkp empty....");
                            Long firstBkpEndTime = this.deviceManagementService.getFirstBackupEndDate(cloudId, device.getUserName(), device.getDeviceUUID());
                            logger.debug(" ..firstbkp empty...." + firstBkpEndTime);
                            if (firstBkpEndTime != null) {
                                String firstSuccessfulEndBkp = this.getDateInFormat(firstBkpEndTime);
                                overView.setFirstBkpEndTime(firstSuccessfulEndBkp);
                            } else {
                                overView.setFirstBkpEndTime(lastSuccessfulBkp);
                            }
                            if (StringUtils.isNotEmpty((String)backupBatch.getUploadedSize())) {
                                overView.setFirstFullBkpTotalSizeOfFiles(Long.parseLong(backupBatch.getUploadedSize()) / 1024L);
                            } else {
                                overView.setFirstFullBkpTotalSizeOfFiles(0L);
                            }
                            overView.setFirstFullBkpNoOfFiles(this.getActualUploadedFiles(backupBatch.getUploadedFiles()));
                        }
                        if (StringUtils.isNotEmpty((String)backupBatch.getUploadedSize())) {
                            overView.setLastSucessfulBkpTotalSizeOfFiles(Long.parseLong(backupBatch.getUploadedSize()) / 1024L);
                        } else {
                            overView.setLastSucessfulBkpTotalSizeOfFiles(0L);
                        }
                        overView.setLastSucessfulBkpNoOfFiles(this.getActualUploadedFiles(backupBatch.getUploadedFiles()));
                        overView.setCurrentlyRunningBkpNoOfFiles(0L);
                        overView.setCurrentlyRunningBkpTotalSizeOfFiles(0L);
                    }
                    overView.setReason(backupBatch.getErrorCode());
                    if (!StringUtils.isEmpty((String)backupBatch.getStatus()) && backupBatch.getStatus().equals("ABORTED")) {
                        overView.setCurrentlyRunningBkpNoOfFiles(0L);
                        overView.setCurrentlyRunningBkpTotalSizeOfFiles(0L);
                    }
                    this.deviceManagementService.updateDeviceBackupOverView(cloudId, overView);
                }
            }
            response.setStatus(200);
            response.setHeader(BATCH_ID, backupBatch.getId().toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.trace("Error failed to save backupBatch ..." + e);
            response.setStatus(500);
            logger.error("Error failed to save backupBatch ..." + e.getMessage());
        }
        logger.debug("end of calling backup Batch ...");
    }

    private void updateRestoreEventStatus(int cloudId, String restoreByPortal, Device device, BackupBatch batch) {
        if (!StringUtils.isEmpty((String)restoreByPortal)) {
            logger.debug("....restoreByPortal..." + restoreByPortal);
            if (restoreByPortal.equals(STARTED)) {
                this.eventHubManagementService.updateRestoreEventsStatus(cloudId, device.getDeviceUUID(), STARTED);
            } else if (COMPLETED.equalsIgnoreCase(restoreByPortal)) {
                this.eventHubManagementService.updateRestoreEventsStatus(cloudId, device.getDeviceUUID(), COMPLETED);
            } else if ("FAILED".equalsIgnoreCase(restoreByPortal)) {
                batch.setStatus("FAILED");
                logger.debug("......&&&&&$$$$$$$$$$$$......" + batch.getStatus());
                this.backupService.saveBackupBatch(cloudId, "", batch);
                this.eventHubManagementService.updateRestoreEventsStatus(cloudId, device.getDeviceUUID(), "FAILED");
            }
        }
    }

    public static String formatFileSizeIncludeKB(long size) {
        double k = size;
        double m = (double)size / 1024.0;
        double g = (double)size / 1024.0 / 1024.0;
        double t = (double)size / 1024.0 / 1024.0 / 1024.0;
        DecimalFormat dec = new DecimalFormat("0.00");
        String hrSize = t > 1.0 ? dec.format(t).concat(" TB") : (g > 1.0 ? dec.format(g).concat(" GB") : (m > 1.0 ? dec.format(m).concat(" MB") : dec.format(k).concat(" KB")));
        return hrSize;
    }

    public static double getGBSizeinMb(long size) {
        double m = (double)size * 1024.0;
        DecimalFormat dec = new DecimalFormat("0.00");
        return Double.parseDouble(dec.format(m));
    }

    private void saveRestoreHistory(String cloudName, int cloudId, String restoredDeviceUUID, String restoreFolder, BackupBatch backupBatch, DeviceElement deviceElement, String totalSizeRestore, String destFolder, boolean restoredInDiffPath, String actionBy) {
        RestoreHistory restoreHistoy = new RestoreHistory();
        try {
            if (backupBatch.getId() != null) {
                RestoreHistory history = this.backupService.getRestoreHistoryById(cloudId, backupBatch.getId());
                if (history == null) {
                    logger.debug("...totalSizeRestore...." + totalSizeRestore);
                    BeanUtils.copyProperties((Object)restoreHistoy, (Object)backupBatch);
                    if (!StringUtils.isEmpty((String)restoreFolder)) {
                        restoreHistoy.setRestoreFolder(restoreFolder);
                    }
                    this.updateRestoreHistoryValues(backupBatch, deviceElement, totalSizeRestore, destFolder, restoredInDiffPath, restoreHistoy, actionBy);
                    this.backupService.saveRestoreHistory(cloudId, cloudName, restoreHistoy);
                } else {
                    logger.debug("......restore history already exists :" + backupBatch.getId() + "...." + backupBatch.getStatus());
                    history.setRestoredSize(totalSizeRestore);
                    history.setDestFolder(destFolder);
                    restoreHistoy.setRestoredInDiffPath(restoredInDiffPath);
                    this.backupService.saveRestoreHistory(cloudId, cloudName, history);
                }
            } else {
                BeanUtils.copyProperties((Object)restoreHistoy, (Object)backupBatch);
                this.updateRestoreHistoryValues(backupBatch, deviceElement, totalSizeRestore, destFolder, restoredInDiffPath, restoreHistoy, actionBy);
                this.backupService.saveRestoreHistory(cloudId, cloudName, restoreHistoy);
            }
        }
        catch (Exception e) {
            logger.trace("Error failed to saveRestoreHistory..." + e);
            logger.error("Error failed to saveRestoreHistory ..." + e.getMessage());
        }
    }

    private void updateRestoreHistoryValues(BackupBatch backupBatch, DeviceElement deviceElement, String totalSizeRestore, String destFolder, boolean restoredInDiffPath, RestoreHistory restoreHistoy, String actionBy) {
        if (StringUtils.isNotEmpty((String)actionBy)) {
            restoreHistoy.setRestoreByUserName(actionBy);
        } else {
            restoreHistoy.setRestoreByUserName(backupBatch.getUserName());
        }
        restoreHistoy.setUserName(deviceElement.getUserName());
        restoreHistoy.setDeviceName(deviceElement.getDeviceName());
        restoreHistoy.setDeviceUUID(deviceElement.getDeviceUUID());
        restoreHistoy.setRestoreByDeviceName(backupBatch.getDeviceName());
        restoreHistoy.setRestoreByDeviceUUID(backupBatch.getDeviceUUID());
        restoreHistoy.setRestoredSize(totalSizeRestore);
        restoreHistoy.setDestFolder(destFolder);
        restoreHistoy.setRestoredInDiffPath(restoredInDiffPath);
    }

    long getActualUploadedFiles(String uploadedFiles) {
        if (StringUtils.isEmpty((String)uploadedFiles)) {
            uploadedFiles = "0/0";
        }
        String[] parts = uploadedFiles.split("/");
        return Long.parseLong(parts[0]);
    }

    private void sendEmailNotifierForRestore(int cloudId, String cloudName, User user1, String restoreBy, NotifierEmailBodyElement notifierEmailBodyElement, DeviceElement deviceElement, String action, String actionBy) {
        try {
            String emailId = user1.getEmailId();
            String actionOn = deviceElement.getUserName();
            String actionByUsername = user1.getUserName();
            notifierEmailBodyElement.setRestoreDeviceName(deviceElement.getDeviceName());
            notifierEmailBodyElement.setNotifyAllAdmins(true);
            notifierEmailBodyElement.setCloudId(cloudId);
            notifierEmailBodyElement.setCloudName(cloudName);
            if (StringUtils.isNotEmpty((String)actionBy)) {
                actionByUsername = actionBy;
            } else if (!deviceElement.getUserName().equalsIgnoreCase(actionByUsername)) {
                UserElement user = this.userManagementService.getUserInfo(cloudId, cloudName, deviceElement.getUserName());
                emailId = user.getEmailId();
            }
            if (StringUtils.isEmpty((String)actionBy)) {
                actionByUsername = restoreBy;
            }
            notifierEmailBodyElement.setUserName(actionByUsername);
            this.sendEmail(action, actionOn, actionByUsername, emailId, notifierEmailBodyElement, deviceElement.getDeviceUUID());
        }
        catch (BaseException e) {
            logger.error("Base Exception.." + e.getMessage());
            logger.error("Base Exception.." + (Object)((Object)e));
        }
    }

    @RequestMapping(value={"cloud/{cloudName}/get/backupstatus"}, method={RequestMethod.GET})
    public ModelAndView getBackupStatusForDevice(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug("calling get backup Status ...");
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("xmlview");
        try {
            String token;
            CloudLicenseTo cl;
            String deviceName = request.getHeader("deviceName");
            String deviceUUID = request.getHeader("deviceUUID");
            String lastsuccessfulBackup = request.getHeader("isLastSuccessfullBackup");
            boolean isLastsuccessfulBackup = false;
            if (StringUtils.isNotEmpty((String)lastsuccessfulBackup) && lastsuccessfulBackup.equalsIgnoreCase("true")) {
                isLastsuccessfulBackup = true;
            }
            if (!this.checkLicense(cl = this.licenseService.validateLicense(cloudName), response)) {
                return null;
            }
            int cloudId = cl.getCloud().getCloudId();
            AuthorizationTokens authorizationTokens = this.authorizationService.getTokenDetailsForToken(cloudId, cloudName = cl.getCloud().getCloudName(), token = request.getHeader("token"));
            if (authorizationTokens == null) {
                response.setStatus(421);
                return null;
            }
            User user = authorizationTokens.getUser();
            List<String> noBackupPolicyNames = Arrays.asList(PCHelperConstant.getNoBackupPolicyName().split(","));
            if (noBackupPolicyNames.contains(user.getPolicyName())) {
                logger.debug("policy belong to a no backup one so send bad request");
                response.setStatus(400);
                return null;
            }
            Device device = this.deviceManagementService.getDeviceByNameForUserId(cloudId, cloudName, deviceName, user.getUserId(), deviceUUID);
            if (device == null) {
                response.setStatus(421);
                logger.debug(" Device is Empty so return ..... ");
                return null;
            }
            logger.debug(" ************ " + deviceName);
            boolean hadAnySuccessBkpRecently = this.checkForAnySuccessBkpRecently(cloudId, cloudName1, device, user);
            if (hadAnySuccessBkpRecently) {
                response.setStatus(555);
                logger.debug("...Fairness algo check .. Backup already completed... ");
                return null;
            }
            if (device.isQuarantineDevice()) {
                response.setStatus(510);
                logger.debug(" Device is QUARANTINED so return ..... ");
                return null;
            }
            BackupBatch backupBatch = this.backupService.getLastBackupOnly(cloudId, cloudName, user, device, isLastsuccessfulBackup);
            if (!(backupBatch == null || StringUtils.isEmpty((String)backupBatch.getDeviceUUID()) || StringUtils.isEmpty((String)backupBatch.getUserName()) || backupBatch.getDeviceUUID().equalsIgnoreCase(deviceUUID) && backupBatch.getUserName().equalsIgnoreCase(user.getUserName()))) {
                logger.debug("BACKUP BATCH belongs to different user and device .... ");
                response.setStatus(400);
                return null;
            }
            DeviceBackupOverView overView = this.deviceManagementService.getDeviceBkpOverviewForDeviceUUID(cloudId, deviceUUID);
            List<Object> rebkpIds = new ArrayList<ObjectId>();
            BackupStatusElement backupStatusElement = new BackupStatusElement();
            BackupLogElement backupLogElement = new BackupLogElement();
            if (overView != null && overView.getFirstBkpStartTime() != null) {
                backupStatusElement.setFirstBackupStartTime(overView.getFirstBkpStartTime());
            }
            if (backupBatch != null) {
                backupStatusElement.setStatus(backupBatch.getStatus());
                backupStatusElement.setCrawlTimestamp(backupBatch.getCrawlTimestamp());
                backupStatusElement.setFullBackup(backupBatch.isFullBackup());
                backupStatusElement.setErrorCode(backupBatch.getErrorCode());
                response.setHeader(BATCH_ID, backupBatch.getId().toString());
                if (StringUtils.isNotEmpty((String)(backupBatch.getTotalSizeToUpload() + ""))) {
                    backupStatusElement.setTotalSizeToUpload(backupBatch.getTotalSizeToUpload());
                }
                BackupLog backupLog = this.backupService.getBackupLogForBatchId(cloudId, cloudName, backupBatch, deviceUUID);
                List<Object> allReBkpList = new ArrayList();
                logger.debug("Backup batch is not null>>>so get previous backup log");
                if (backupBatch != null && (backupBatch.getStatus().equalsIgnoreCase(COMPLETED) || backupBatch.getStatus().equalsIgnoreCase("ABORTED")) && !CollectionUtils.isEmpty(allReBkpList = this.backupService.getAllReBkpList(cloudId, device.getId().toString()))) {
                    rebkpIds = allReBkpList.stream().map(line -> line.getId()).collect(Collectors.toList());
                }
                if (backupLog != null) {
                    FileElement backupElement;
                    logger.debug("Backup log is not null");
                    backupLogElement.setId(backupLog.getId().toString());
                    backupLogElement.setRestartId(backupLog.getRestartId());
                    ArrayList<FileElement> backupElementList = new ArrayList<FileElement>();
                    for (BackupFile backupFile : backupLog.getFailedFiles()) {
                        backupElement = new FileElement();
                        if (backupFile.getSize() != null) {
                            backupElement.setSize(backupFile.getSize().toString());
                        }
                        backupElement.setFileCompletePath(backupFile.getFilePath());
                        backupElement.setFileName(backupFile.getFileName());
                        backupElement.setLastModifiedTimestamp(backupFile.getUploadedTimestamp().longValue());
                        backupElement.setMd5checksum(backupFile.getMd5());
                        backupElement.setFolder(false);
                        backupElementList.add(backupElement);
                    }
                    if (backupBatch != null && (backupBatch.getStatus().equalsIgnoreCase(COMPLETED) || backupBatch.getStatus().equalsIgnoreCase("ABORTED"))) {
                        for (ReBackUpImage reBackUpImage : allReBkpList) {
                            logger.debug(".........rebackup.......new changes......" + reBackUpImage.getFileName());
                            backupElement = new FileElement();
                            backupElement.setFileCompletePath(reBackUpImage.getDevicePath());
                            backupElement.setFileName(reBackUpImage.getFileName());
                            BackUpImage backUpImage = this.backupService.getBackupFileForID(cloudId, reBackUpImage.getId(), device);
                            if (backUpImage != null) {
                                backupElement.setMd5checksum(backUpImage.getMd5Checksum());
                            }
                            backupElement.setFolder(false);
                            backupElementList.add(backupElement);
                        }
                    }
                    backupLogElement.setFailedFiles(backupElementList);
                    backupStatusElement.setBackupLogElement(backupLogElement);
                } else if (!CollectionUtils.isEmpty(allReBkpList) && backupBatch != null && (backupBatch.getStatus().equalsIgnoreCase(COMPLETED) || backupBatch.getStatus().equalsIgnoreCase("ABORTED"))) {
                    backupLogElement.setId(backupBatch.getId().toString());
                    ArrayList<FileElement> backupElementList = new ArrayList<FileElement>();
                    for (ReBackUpImage reBackUpImage : allReBkpList) {
                        logger.debug(".........rebackup............." + reBackUpImage.getFileName());
                        FileElement backupElement = new FileElement();
                        backupElement.setFileCompletePath(reBackUpImage.getDevicePath());
                        backupElement.setFileName(reBackUpImage.getFileName());
                        BackUpImage backUpImage = this.backupService.getBackupFileForID(cloudId, reBackUpImage.getId(), device);
                        if (backUpImage != null) {
                            backupElement.setMd5checksum(backUpImage.getMd5Checksum());
                        }
                        backupElement.setFolder(false);
                        backupElementList.add(backupElement);
                    }
                    backupLogElement.setFailedFiles(backupElementList);
                    backupStatusElement.setBackupLogElement(backupLogElement);
                }
            }
            modelAndView.addObject((Object)backupStatusElement);
            if (backupBatch != null && (backupBatch.getStatus().equalsIgnoreCase(COMPLETED) || backupBatch.getStatus().equalsIgnoreCase("ABORTED"))) {
                this.backupService.removeReBkpByIds(cloudId, rebkpIds);
            }
        }
        catch (Exception e) {
            logger.trace("Error failed to get backup status ..." + e);
            response.setStatus(500);
            logger.error("Error failed to get backup status ...", (Throwable)e);
            return modelAndView;
        }
        logger.debug("Beofre decrememnting crawl limit");
        return modelAndView;
    }

    private void sendEmail(String action, String actionOn, String actionBy, String emailId, NotifierEmailBodyElement bodyElement, String deviceUUID) {
        EmailProps email = new EmailProps();
        ArrayList<EmailRecipent> emailRecipents = new ArrayList<EmailRecipent>();
        email.setAction(action);
        email.setActionBy(actionBy);
        email.setActionOn(actionOn);
        email.setDeviceUUID(deviceUUID);
        email.setDeviceName(bodyElement.getDeviceName());
        email.setBodyData(bodyElement.getRestoreDeviceName());
        email.setFileName(bodyElement.getRestoreFolder());
        email.setBackupsDone(bodyElement.getNoOfFilesBackedUp());
        email.setTotalStorageUtilized(bodyElement.getTotalBackupSize());
        email.setToAdmins(bodyElement.isNotifyAllAdmins());
        email.setUserName(bodyElement.getUserName());
        email.setNoOfFilesRestored(bodyElement.getNoOfFilesBackedUp());
        email.setRestoreSize(bodyElement.getRestoreSize());
        if (StringUtils.isNotEmpty((String)bodyElement.getRestoreStatus())) {
            email.setRestoreStatus(bodyElement.getRestoreStatus().toLowerCase());
        } else {
            email.setRestoreStatus("");
        }
        String bkpStartTime = this.getDateFromTimeStamp(bodyElement.getBatchStartTimestamp());
        String bkpEndTime = this.getDateFromTimeStamp(bodyElement.getBatchEndTimestamp());
        logger.error("bkpEndTime...." + bkpStartTime);
        logger.error("action...." + action + "......actionBy......." + actionBy);
        logger.error("status...." + bodyElement.getRestoreStatus());
        if (bkpStartTime != null) {
            email.setBatchStartTime(bkpStartTime.toString() + "(GMT" + this.gettimeZoneInUTC() + ")");
        } else {
            email.setBatchStartTime("");
        }
        if (bkpEndTime != null) {
            email.setBatchEndTime(bkpEndTime.toString() + "(GMT" + this.gettimeZoneInUTC() + ")");
        } else {
            email.setBatchEndTime("");
        }
        EmailRecipent emailRecipent = new EmailRecipent();
        emailRecipent.setUserName(actionOn);
        emailRecipent.setEmail(emailId);
        emailRecipents.add(emailRecipent);
        try {
            logger.debug(" @@@ Before sending mail ");
            email.setRecipents(emailRecipents);
            this.cloudMailService.sendMail(email);
        }
        catch (Exception e) {
            logger.trace("Exception  :" + e);
            logger.error("Exception  :" + e.getMessage());
        }
    }

    private String gettimeZoneInUTC() {
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"), Locale.getDefault());
        Date currentLocalTime = calendar.getTime();
        logger.debug("currentLocalTime" + currentLocalTime);
        SimpleDateFormat date = new SimpleDateFormat("Z");
        String localTime = date.format(currentLocalTime);
        logger.debug("GMT" + localTime);
        return localTime;
    }

    private String getDateFromTimeStamp(long timestamp) {
        String bkpEndTime = null;
        try {
            logger.debug("bodyElement.getBatchStartTimestamp()" + timestamp);
            Date date = new Date(timestamp);
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DD_MMM_YYYY_HH_MM_SS);
            bkpEndTime = simpleDateFormat.format(date);
        }
        catch (Exception e1) {
            logger.error("error....", (Throwable)e1);
            e1.printStackTrace();
        }
        return bkpEndTime;
    }

    private String getDateInFormat(Long deviceCreatedDate) {
        SimpleDateFormat df2 = new SimpleDateFormat(DD_MMM_YYYY_HH_MM_SS);
        Date dateD = new Date(deviceCreatedDate);
        return df2.format(dateD);
    }

    private static String formatFileSize(long size) {
        if (size <= 0L) {
            return "0";
        }
        String[] units = new String[]{"B", "KB", "MB", "GB", "TB"};
        int digitGroups = (int)(Math.log10(size) / Math.log10(1024.0));
        return new DecimalFormat("#,##0.#").format((double)size / Math.pow(1024.0, digitGroups)) + " " + units[digitGroups];
    }

    private String getNoOfFilesRemaining(String totalNoOfFilesFromBatch, String uploadedFilesBatchTemp) {
        String uploadedFilesBatch = uploadedFilesBatchTemp;
        Integer noOfFilesRemaining = 0;
        logger.debug(" Files *************dfsdfs********* " + uploadedFilesBatch);
        if (StringUtils.isEmpty((String)uploadedFilesBatch)) {
            uploadedFilesBatch = "0/" + totalNoOfFilesFromBatch;
        }
        String[] parts = uploadedFilesBatch.split("/");
        try {
            Integer actualNoOfFiles = Integer.parseInt(parts[1]);
            Integer noOfFilesBackedup = Integer.parseInt(parts[0]);
            noOfFilesRemaining = actualNoOfFiles - noOfFilesBackedup;
        }
        catch (Exception e) {
            logger.trace("Exception  :" + e);
            logger.error("Exception  :" + e.getMessage());
        }
        return noOfFilesRemaining.toString();
    }

    @RequestMapping(value={"cloud/{cloudName}/updateReport"}, method={RequestMethod.POST})
    public void updateReport(@PathVariable(value="cloudName") String cloudName, HttpServletRequest request, HttpServletResponse response) {
        logger.debug("calling backup Batch ...");
        CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
        if (!this.checkLicense(cl, response)) {
            return;
        }
        int cloudId = cl.getCloud().getCloudId();
        this.deviceManagementService.updateOverviewReport(cloudId);
    }

    @RequestMapping(value={"cloud/{cloudName}/updateFirstEndReport"}, method={RequestMethod.POST})
    public void updateFirstBkpEndTimeOverviewReport(@PathVariable(value="cloudName") String cloudName, HttpServletRequest request, HttpServletResponse response) {
        logger.debug("calling updateFirstBkpEndTimeOverviewReport ...");
        CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
        if (!this.checkLicense(cl, response)) {
            return;
        }
        int cloudId = cl.getCloud().getCloudId();
        this.deviceManagementService.updateFirstBkpEndTimeOverviewReport(cloudId);
    }

    @RequestMapping(value={"cloud/{cloudName}/updateAllDeviceOverviewReport"}, method={RequestMethod.POST})
    public void updateAllDeviceOverviewReport(@PathVariable(value="cloudName") String cloudName, HttpServletRequest request, HttpServletResponse response) {
        logger.debug("calling updateAllDeviceOverviewReport ...");
        CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
        if (!this.checkLicense(cl, response)) {
            return;
        }
        int cloudId = cl.getCloud().getCloudId();
        this.deviceManagementService.updateAllDeviceOverviewReport(cloudId);
    }

    private boolean checkForAnySuccessBkpRecently(int cloudId, String cloudName, Device device, User user) {
        long firstSuccessTime;
        long lastSuccessTime;
        long successTimeToCompare;
        boolean hadAnySuccessBkpRecently = false;
        String deviceUUID = device.getDeviceUUID();
        DeviceBackupOverView overView = this.deviceManagementService.getDeviceBkpOverviewForDeviceUUID(1, deviceUUID);
        int DaysToWaitForNextBackup = 0;
        if (overView != null && (successTimeToCompare = (lastSuccessTime = overView.getLastSuccessfulBackupEndTime()) > 0L ? lastSuccessTime : (firstSuccessTime = BackupBatchController.getTime(overView.getFirstBkpEndTime()))) > 0L) {
            BackupPolicy backupPolicy;
            long noOfDaysSinceLastBackup = TimeUnit.DAYS.convert(System.currentTimeMillis() - successTimeToCompare, TimeUnit.MILLISECONDS);
            if (user != null && !StringUtils.isEmpty((String)user.getPolicyName()) && (backupPolicy = this.backupService.getBackupPolicy(cloudId, cloudName, user.getPolicyName())) != null && !StringUtils.isEmpty((String)backupPolicy.getDaysToWaitForNextBackup())) {
                DaysToWaitForNextBackup = Integer.parseInt(backupPolicy.getDaysToWaitForNextBackup());
            }
            if (noOfDaysSinceLastBackup < (long)DaysToWaitForNextBackup) {
                logger.error(user.getUserName() + "...Device already had a successful backup before " + noOfDaysSinceLastBackup + " days......" + deviceUUID);
                hadAnySuccessBkpRecently = true;
            }
        }
        return hadAnySuccessBkpRecently;
    }

    private static long getTime(String strdate) {
        if (StringUtils.isEmpty((String)strdate)) {
            return 0L;
        }
        long milliseconds = 0L;
        SimpleDateFormat f = new SimpleDateFormat(DD_MMM_YYYY_HH_MM_SS);
        try {
            Date d = f.parse(strdate);
            milliseconds = d.getTime();
        }
        catch (ParseException e) {
            logger.trace("parse exception..." + e);
            logger.error(" exception val.." + e.getMessage());
        }
        return milliseconds;
    }

    @RequestMapping(value={"versions/{versionNumber}/clouds/{cloudName}/device/isBkpRunning/{deviceUUID}"}, method={RequestMethod.GET})
    public ModelAndView checkDeviceBkpIsRunning(@PathVariable(value="cloudName") String cloudName, @PathVariable(value="deviceUUID") String deviceUUID, HttpServletRequest request, HttpServletResponse response) {
        logger.debug("calling checkDeviceBkpIsRunning... ");
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        try {
            List actionsFromDb;
            EventHub eventHub;
            String token;
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                response.setStatus(400);
                return null;
            }
            int cloudId = cl.getCloud().getCloudId();
            if (!this.performAuthorization(cloudId, cloudName, token = request.getHeader("token"), response)) {
                return null;
            }
            boolean isBackupRunning = false;
            boolean isPrevBkpPaused = false;
            DeviceBackupOverView backupOverView = this.deviceManagementService.getDeviceBkpOverviewForDeviceUUID(cloudId, deviceUUID);
            if (backupOverView != null) {
                String lastBkpStatus = backupOverView.getLastBkpStatus();
                isBackupRunning = StringUtils.isNotEmpty((String)lastBkpStatus) && !backupOverView.isDeviceBolcked() && (STARTED.equalsIgnoreCase(lastBkpStatus) || "SCANNING".equalsIgnoreCase(lastBkpStatus));
                isPrevBkpPaused = StringUtils.isNotEmpty((String)lastBkpStatus) && !backupOverView.isDeviceBolcked() && "PAUSED".equalsIgnoreCase(lastBkpStatus);
                logger.debug("....lastbkp status ... " + isPrevBkpPaused + "...." + lastBkpStatus);
                eventHub = new EventHub();
                eventHub.setActionToUserName(backupOverView.getUserName());
                eventHub.setActionToDeviceUUID(backupOverView.getDeviceUUID());
                actionsFromDb = this.eventHubManagementService.getActionsByUserNameAndAction(cloudId, cloudName, eventHub);
                if (!CollectionUtils.isEmpty((Collection)actionsFromDb)) {
                    if (actionsFromDb.contains("PAUSE_BACKUP")) {
                        logger.debug("Already its paused backup....");
                        isBackupRunning = false;
                        modelAndView.addObject("action", (Object)"PAUSE_BACKUP");
                    } else if (actionsFromDb.contains("STOP_BACKUP")) {
                        logger.debug("Already its stoped backup....");
                        modelAndView.addObject("action", (Object)"STOP_BACKUP");
                        isBackupRunning = false;
                    }
                }
                modelAndView.addObject("status", (Object)lastBkpStatus);
            } else {
                logger.debug("Device bkpOverview is empty for deviceUUID :" + deviceUUID);
            }
            boolean isFullBkpRunning = false;
            logger.debug("... value for bkp type.... " + backupOverView.getDeviceType());
            if (Device.TYPE.ONEDRIVE.name().equalsIgnoreCase(backupOverView.getDeviceType()) || Device.TYPE.OUTLOOK.name().equalsIgnoreCase(backupOverView.getDeviceType())) {
                eventHub = new EventHub();
                eventHub.setActionBy(backupOverView.getUserName());
                eventHub.setActionStatus(PCHelperConstant.EVENTHUB_ACTION_STATUS.CREATED.toString());
                eventHub.setActionToUserName(backupOverView.getUserName());
                eventHub.setActionToDeviceUUID(backupOverView.getDeviceUUID());
                actionsFromDb = this.eventHubManagementService.getActionsByUserNameAndAction(cloudId, cloudName, eventHub);
                logger.debug("... value for bkp.... " + actionsFromDb);
                if (!CollectionUtils.isEmpty((Collection)actionsFromDb)) {
                    for (String action : actionsFromDb) {
                        if (!action.equalsIgnoreCase("FULL_BACKUP")) continue;
                        isFullBkpRunning = true;
                        break;
                    }
                }
            }
            boolean isBkpDeferred = false;
            if ("INTERRUPTED".equals(backupOverView.getLastBkpStatus()) && "1996".equals(backupOverView.getReason())) {
                isBkpDeferred = true;
            }
            logger.debug(isBackupRunning + "... final values ... " + isFullBkpRunning);
            if (isFullBkpRunning) {
                isBackupRunning = true;
            }
            modelAndView.addObject((Object)isBackupRunning);
            response.addHeader("isFullBkpRunning", Boolean.valueOf(isFullBkpRunning).toString());
            RestoreEvents restoreEventByUUID = this.eventHubManagementService.getRestoreEventByUUID(cloudId, deviceUUID);
            boolean isAllowBackup = true;
            if (restoreEventByUUID != null && restoreEventByUUID.isSuspendBackup()) {
                isAllowBackup = false;
            }
            if (isBkpDeferred) {
                isAllowBackup = false;
            }
            response.addHeader("isPrevBkpPaused", Boolean.valueOf(isPrevBkpPaused).toString());
            response.addHeader("isAllowBackup", Boolean.valueOf(isAllowBackup).toString());
            logger.debug(".....isallow backup.... " + isAllowBackup);
            response.setStatus(200);
        }
        catch (BaseException e) {
            response.setStatus(500);
            logger.trace("Exception while loading device backup status" + e.getMessage());
            logger.error("Exception while loading device backup status" + (Object)((Object)e));
        }
        logger.debug("end of checkDeviceBkpIsRunning... ");
        return modelAndView;
    }

    @RequestMapping(value={"versions/{versionNumber}/clouds/{cloudName}/device/isRestoreRunning/{deviceUUID}/"}, method={RequestMethod.GET})
    public ModelAndView checkMailRestoreIsRunning(@PathVariable(value="cloudName") String cloudName, @PathVariable(value="deviceUUID") String deviceUUID, HttpServletRequest request, HttpServletResponse response) {
        logger.debug("calling checkMailRestoreIsRunning... ");
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        try {
            String token;
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                response.setStatus(400);
                return null;
            }
            int cloudId = cl.getCloud().getCloudId();
            if (!this.performAuthorization(cloudId, cloudName, token = request.getHeader("token"), response)) {
                return null;
            }
            boolean isRestoreRunning = false;
            Device device = this.deviceManagementService.getDeviceByDeviceUUID(cloudId, cloudName, deviceUUID);
            if (device != null && device.getDeviceType() == null || device.getDeviceType().equalsIgnoreCase(BACKUP)) {
                BackupBatch backupBatch = this.eventHubManagementService.getBackupBatch(cl.getCloud().getCloudId(), deviceUUID);
                if (backupBatch != null) {
                    isRestoreRunning = true;
                }
            } else {
                MailBackupBatch mailBackupBatch = this.eventHubManagementService.getMailBackupBatch(cl.getCloud().getCloudId(), deviceUUID);
                if (mailBackupBatch != null) {
                    isRestoreRunning = true;
                }
            }
            logger.debug(isRestoreRunning + "...  is Restore running values ... " + deviceUUID);
            modelAndView.addObject((Object)isRestoreRunning);
            response.addHeader("isRestoreRunning", Boolean.valueOf(isRestoreRunning).toString());
            response.setStatus(200);
        }
        catch (Exception e) {
            response.setStatus(500);
            logger.trace("Exception while loading device backup status" + e.getMessage());
            logger.error("Exception while loading device backup status" + e);
        }
        logger.debug("end of checkMailRestoreIsRunning... ");
        return modelAndView;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/save/logs/"}, method={RequestMethod.POST})
    public ModelAndView saveLogFileInDB(HttpServletRequest request, HttpServletResponse httpResponse) {
        logger.debug("#######Inside save logs in back bone @@@@@....  ");
        ServletInputStream input = null;
        String deviceUUID = null;
        String batchId = null;
        try {
            input = request.getInputStream();
            deviceUUID = request.getHeader("devideviceUUID");
            batchId = request.getHeader(BATCH_ID);
            this.backupService.storeFailedFilesLogForRequestId(deviceUUID, batchId, (InputStream)input);
        }
        catch (Exception e) {
            logger.debug("Exception occured ", (Throwable)e);
            httpResponse.setStatus(500);
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException e) {
                    logger.debug("IOException occured ", (Throwable)e);
                }
            }
        }
        httpResponse.setStatus(200);
        this.closeInputStreamIfExists(request);
        return null;
    }

    protected void closeInputStreamIfExists(HttpServletRequest request) {
        try {
            if (request.getInputStream() != null) {
                request.getInputStream().close();
            }
        }
        catch (IOException e) {
            logger.debug("", (Throwable)e);
        }
    }

    private void updateBatch(String cloudName, int cloudId, BackupBatch backupBatch, boolean isFirstAttempt, boolean addNewAttempt, boolean policyStorageExceeded) {
        block16: {
            logger.debug("status={}", (Object)backupBatch.getStatus());
            logger.debug("error code={}", (Object)backupBatch.getErrorCode());
            this.backupService.saveBackupBatch(cloudId, cloudName, backupBatch);
            try {
                if (backupBatch == null || !backupBatch.getJobType().equals(BACKUP)) break block16;
                logger.debug(".........status........" + backupBatch.getStatus());
                if (isFirstAttempt) {
                    this.saveFirstAttempt(cloudName, cloudId, backupBatch);
                    break block16;
                }
                if ((backupBatch.getStatus().equals("INTERRUPTED") || backupBatch.getStatus().equals("ABORTED")) && backupBatch.getErrorCode().equalsIgnoreCase("543") && addNewAttempt) {
                    BackupAttempt attempt = this.backupService.getLastBackupAttemptById(cloudId, backupBatch.getId().toString());
                    BackupAttempt newBkpAttempt = new BackupAttempt();
                    org.springframework.beans.BeanUtils.copyProperties((Object)attempt, (Object)newBkpAttempt);
                    newBkpAttempt.setStatus(backupBatch.getStatus());
                    newBkpAttempt.setBatchStartTimestamp(System.currentTimeMillis());
                    newBkpAttempt.setBatchEndTimestamp(System.currentTimeMillis());
                    newBkpAttempt.setErrorCode(backupBatch.getErrorCode());
                    newBkpAttempt.setUploadedSize("0");
                    newBkpAttempt.setTotalNoOfFiles(0L);
                    newBkpAttempt.setId(null);
                    if (policyStorageExceeded) {
                        newBkpAttempt.setErrorCode("1947");
                    }
                    this.backupService.saveBackupAttempt(cloudId, cloudName, newBkpAttempt);
                    break block16;
                }
                if (!backupBatch.getStatus().equals(STARTED)) {
                    BackupAttempt bkpAttempt = this.backupService.getLastBackupAttemptById(cloudId, backupBatch.getId().toString());
                    if (bkpAttempt != null) {
                        bkpAttempt.setErrorCode(backupBatch.getErrorCode());
                        logger.debug(bkpAttempt.getStatus() + "Size...attempt1....." + bkpAttempt.getUploadedSize());
                        logger.debug("Size...batch1....." + backupBatch.getUploadedSize());
                        bkpAttempt.setStatus(backupBatch.getStatus());
                        if (policyStorageExceeded) {
                            bkpAttempt.setErrorCode("1947");
                        }
                        bkpAttempt.setBatchEndTimestamp(System.currentTimeMillis());
                        this.backupService.saveBackupAttempt(cloudId, cloudName, bkpAttempt);
                    }
                    break block16;
                }
                BackupAttempt attempt = this.backupService.getLastBackupAttemptById(cloudId, backupBatch.getId().toString());
                if (attempt != null && attempt.getStatus().equals(BackupBatch.STATUS.STARTED.name())) {
                    logger.debug("..new attempt came but last attempt is in started state so change the intruupted..");
                    attempt.setBatchEndTimestamp(backupBatch.getBatchEndTimestamp());
                    attempt.setStatus(BackupBatch.STATUS.INTERRUPTED.name().toUpperCase());
                    attempt.setErrorCode("909");
                    if (policyStorageExceeded) {
                        attempt.setErrorCode("1947");
                    }
                    this.backupService.saveBackupAttempt(cloudId, cloudName, attempt);
                }
                if (attempt == null) break block16;
                BackupAttempt lastBkpAttempt = new BackupAttempt();
                org.springframework.beans.BeanUtils.copyProperties((Object)backupBatch, (Object)lastBkpAttempt);
                lastBkpAttempt.setBatchStartTimestamp(System.currentTimeMillis());
                lastBkpAttempt.setBatchEndTimestamp(System.currentTimeMillis());
                lastBkpAttempt.setNoOfFiles(0L);
                lastBkpAttempt.setTotalNoOfFiles(0L);
                lastBkpAttempt.setUploadedSize("0");
                lastBkpAttempt.setBatchId(backupBatch.getId().toString());
                lastBkpAttempt.setId(null);
                lastBkpAttempt.setErrorCode(backupBatch.getErrorCode());
                String currentUploadedFilesStatus = "";
                int uploadedFiles = 0;
                if (StringUtils.isEmpty((String)lastBkpAttempt.getUploadedFiles())) {
                    currentUploadedFilesStatus = uploadedFiles + "/" + lastBkpAttempt.getTotalNoOfFiles();
                } else {
                    String[] parts = lastBkpAttempt.getUploadedFiles().split("/");
                    try {
                        Integer prevBkpFiles = Integer.parseInt(parts[0]);
                        int updatedUploadedFiles = 0;
                        if (prevBkpFiles != null) {
                            updatedUploadedFiles = uploadedFiles + prevBkpFiles;
                        }
                        currentUploadedFilesStatus = updatedUploadedFiles + "/" + lastBkpAttempt.getTotalNoOfFiles();
                    }
                    catch (Exception e) {
                        logger.trace("Exception  :" + e);
                        logger.error("Exception  :" + e.getMessage());
                    }
                }
                logger.debug(".......currentUploadedFilesStatus.new....." + currentUploadedFilesStatus);
                lastBkpAttempt.setUploadedFiles(currentUploadedFilesStatus);
                if (policyStorageExceeded) {
                    lastBkpAttempt.setErrorCode("1947");
                }
                this.backupService.saveBackupAttempt(cloudId, cloudName, lastBkpAttempt);
            }
            catch (Exception e) {
                logger.trace("Error failed to save BackupAttempt ..." + e.getMessage(), (Throwable)e);
                logger.error("Error failed to save BackupAttempt ..." + e);
            }
        }
    }

    private void saveFirstAttempt(String cloudName, int cloudId, BackupBatch backupBatch) {
        BackupAttempt attempt = new BackupAttempt();
        org.springframework.beans.BeanUtils.copyProperties((Object)backupBatch, (Object)attempt);
        attempt.setBatchId(backupBatch.getId().toString());
        attempt.setId(null);
        attempt.setErrorCode("0");
        if (backupBatch.getErrorCode().equalsIgnoreCase("543") || backupBatch.getErrorCode().equalsIgnoreCase("1212")) {
            attempt.setErrorCode(backupBatch.getErrorCode());
        }
        this.backupService.saveBackupAttempt(cloudId, cloudName, attempt);
    }

    private boolean isLicenseEnabled(Cloud cl, String licenseName) {
        boolean isLicenseScanEnabled = false;
        List list = cl.getCloudCustomisableDetails();
        list.removeAll(Collections.singleton(null));
        if (!CollectionUtils.isEmpty((Collection)list)) {
            for (CloudCustomisableDetails cloudPluginDetails : list) {
                if (cloudPluginDetails == null || StringUtils.isEmpty((String)cloudPluginDetails.getName()) || !licenseName.equalsIgnoreCase(cloudPluginDetails.getName())) continue;
                isLicenseScanEnabled = true;
                break;
            }
        }
        logger.debug("licenseName " + licenseName + isLicenseScanEnabled);
        return isLicenseScanEnabled;
    }

    @RequestMapping(value={"/backupbatch/"}, method={RequestMethod.GET})
    public ResponseEntity<BackupBatch> getBackupBatch(HttpServletRequest request, HttpServletResponse response) {
        logger.debug("Entering CloudSettingsController.pingCloud");
        try {
            String backupId = request.getHeader("backup-id");
            BackupBatch backupBatch = this.backupService.getBackupBatch(1, "", backupId);
            ResponseEntity entity = new ResponseEntity((Object)backupBatch, HttpStatus.OK);
            return entity;
        }
        catch (Exception e) {
            logger.error("Excecption::", (Throwable)e);
            response.setStatus(400);
            return new ResponseEntity(HttpStatus.NO_CONTENT);
        }
    }

    @RequestMapping(value={"cloud/{cloudName}/get/restorestatus"}, method={RequestMethod.GET})
    public void getRestoreStatusForDevice(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug("calling get restore Status ...");
        try {
            String token;
            String deviceUUID = request.getHeader("deviceUUID");
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return;
            }
            cloudName = cl.getCloud().getCloudName();
            AuthorizationTokens authorizationTokens = this.authorizationService.getTokenDetailsForToken(1, cloudName, token = request.getHeader("token"));
            if (authorizationTokens == null) {
                response.setStatus(421);
                return;
            }
            User user = authorizationTokens.getUser();
            BackupBatch backupBatch = this.backupService.getLastRestoreBatch(1, deviceUUID);
            if (!(backupBatch == null || StringUtils.isEmpty((String)backupBatch.getDeviceUUID()) || StringUtils.isEmpty((String)backupBatch.getUserName()) || backupBatch.getDeviceUUID().equalsIgnoreCase(deviceUUID) && backupBatch.getUserName().equalsIgnoreCase(user.getUserName()))) {
                logger.debug("BACKUP BATCH belongs to different user and device .... ");
                response.setStatus(400);
                return;
            }
            if (backupBatch != null) {
                response.setHeader("restoreStatus", backupBatch.getStatus());
            }
            response.setStatus(200);
        }
        catch (Exception e) {
            response.setStatus(500);
            logger.error("Error failed to get restore status ...", (Throwable)e);
            return;
        }
    }

    class NotifierEmailBodyElement {
        private int cloudId;
        private String cloudName;
        private String userName;
        private String deviceName;
        private String restoreDeviceName;
        private String restoreFolder;
        private String noOfFilesBackedUp;
        private String totalBackupSize;
        private boolean notifyAllAdmins;
        private long batchStartTimestamp;
        private long batchEndTimestamp;
        private String restoreSize;
        private String restoreStatus;

        NotifierEmailBodyElement() {
        }

        public long getBatchEndTimestamp() {
            return this.batchEndTimestamp;
        }

        public void setBatchEndTimestamp(long batchEndTimestamp) {
            this.batchEndTimestamp = batchEndTimestamp;
        }

        public String getRestoreSize() {
            return this.restoreSize;
        }

        public void setRestoreSize(String restoreSize) {
            this.restoreSize = restoreSize;
        }

        public String getDeviceName() {
            return this.deviceName;
        }

        public void setDeviceName(String deviceName) {
            this.deviceName = deviceName;
        }

        public String getRestoreDeviceName() {
            return this.restoreDeviceName;
        }

        public void setRestoreDeviceName(String restoreDeviceName) {
            this.restoreDeviceName = restoreDeviceName;
        }

        public String getRestoreFolder() {
            return this.restoreFolder;
        }

        public void setRestoreFolder(String restoreFolder) {
            this.restoreFolder = restoreFolder;
        }

        public String getTotalBackupSize() {
            return this.totalBackupSize;
        }

        public void setTotalBackupSize(String totalBackupSize) {
            this.totalBackupSize = totalBackupSize;
        }

        public String getNoOfFilesBackedUp() {
            return this.noOfFilesBackedUp;
        }

        public void setNoOfFilesBackedUp(String noOfFilesBackedUp) {
            this.noOfFilesBackedUp = noOfFilesBackedUp;
        }

        public boolean isNotifyAllAdmins() {
            return this.notifyAllAdmins;
        }

        public void setNotifyAllAdmins(boolean notifyAllAdmins) {
            this.notifyAllAdmins = notifyAllAdmins;
        }

        public String getUserName() {
            return this.userName;
        }

        public void setUserName(String userName) {
            this.userName = userName;
        }

        public int getCloudId() {
            return this.cloudId;
        }

        public void setCloudId(int cloudId) {
            this.cloudId = cloudId;
        }

        public String getCloudName() {
            return this.cloudName;
        }

        public void setCloudName(String cloudName) {
            this.cloudName = cloudName;
        }

        public long getBatchStartTimestamp() {
            return this.batchStartTimestamp;
        }

        public void setBatchStartTimestamp(long batchStartTimestamp) {
            this.batchStartTimestamp = batchStartTimestamp;
        }

        public String getRestoreStatus() {
            return this.restoreStatus;
        }

        public void setRestoreStatus(String restoreStatus) {
            this.restoreStatus = restoreStatus;
        }
    }
}

