/*
 * Decompiled with CFR 0.152.
 */
package com.pg.controller;

import com.google.api.client.repackaged.org.apache.commons.codec.binary.Base64;
import com.microsoft.aad.adal4j.AuthenticationCallback;
import com.microsoft.aad.adal4j.AuthenticationContext;
import com.microsoft.aad.adal4j.AuthenticationResult;
import com.microsoft.aad.adal4j.ClientCredential;
import com.microsoft.graph.http.GraphServiceException;
import com.microsoft.graph.models.Drive;
import com.microsoft.graph.models.DriveItem;
import com.microsoft.graph.models.ListItem;
import com.microsoft.graph.models.MailFolder;
import com.microsoft.graph.models.Site;
import com.microsoft.graph.models.TodoTaskList;
import com.microsoft.graph.models.User;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.DriveItemCollectionPage;
import com.microsoft.graph.requests.DriveItemCollectionRequest;
import com.microsoft.graph.requests.GraphServiceClient;
import com.microsoft.graph.requests.ListCollectionPage;
import com.microsoft.graph.requests.ListCollectionRequest;
import com.microsoft.graph.requests.ListCollectionRequestBuilder;
import com.microsoft.graph.requests.MailFolderCollectionPage;
import com.microsoft.graph.requests.MailFolderCollectionRequest;
import com.microsoft.graph.requests.MailFolderCollectionRequestBuilder;
import com.microsoft.graph.requests.MailFolderRequestBuilder;
import com.microsoft.graph.requests.SiteCollectionPage;
import com.microsoft.graph.requests.SiteCollectionRequest;
import com.microsoft.graph.requests.SiteCollectionRequestBuilder;
import com.microsoft.graph.requests.TodoTaskListCollectionPage;
import com.microsoft.graph.requests.TodoTaskListCollectionRequest;
import com.microsoft.graph.requests.UserCollectionPage;
import com.microsoft.graph.requests.UserCollectionRequest;
import com.microsoft.graph.requests.UserRequestBuilder;
import com.parablu.paracloud.element.RestoreEventsElement;
import com.parablu.paracloud.element.RestoreProgressEventsElement;
import com.parablu.pcbd.domain.AuditHistory;
import com.parablu.pcbd.domain.BackUpImage;
import com.parablu.pcbd.domain.BackupBatch;
import com.parablu.pcbd.domain.Cloud;
import com.parablu.pcbd.domain.CloudCustomisableDetails;
import com.parablu.pcbd.domain.Device;
import com.parablu.pcbd.domain.EWSAppSetting;
import com.parablu.pcbd.domain.EventHub;
import com.parablu.pcbd.domain.MailBackupBatch;
import com.parablu.pcbd.domain.OTPValidation;
import com.parablu.pcbd.domain.OfficeBackupPolicy;
import com.parablu.pcbd.domain.PstBatch;
import com.parablu.pcbd.domain.RestoreProgressEvents;
import com.pg.controller.C2CGraphClient;
import com.pg.controller.Graph;
import com.pg.domain.BackupFile;
import com.pg.domain.FileInfo;
import com.pg.element.FileElement;
import com.pg.element.SiteElement;
import com.pg.exception.ParacloudBackupException;
import com.pg.helper.constant.PCHelperConstant;
import com.pg.odb.util.OneDriveUtil;
import com.pg.paracloud.to.DownloadFileTO;
import com.pg.paracloud.to.DownloadTO;
import com.pg.service.DownloadService;
import com.pg.service.UtilService;
import com.pg.sync.service.SyncDownloadService;
import com.pg.sync.service.impl.SyncDownloadServiceImpl;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import microsoft.exchange.webservices.data.core.ExchangeService;
import microsoft.exchange.webservices.data.core.enumeration.misc.ConnectingIdType;
import microsoft.exchange.webservices.data.core.enumeration.misc.ExchangeVersion;
import microsoft.exchange.webservices.data.core.enumeration.property.WellKnownFolderName;
import microsoft.exchange.webservices.data.core.enumeration.search.FolderTraversal;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceLocalException;
import microsoft.exchange.webservices.data.core.service.folder.Folder;
import microsoft.exchange.webservices.data.misc.ImpersonatedUserId;
import microsoft.exchange.webservices.data.property.complex.FolderId;
import microsoft.exchange.webservices.data.property.complex.Mailbox;
import microsoft.exchange.webservices.data.search.FindFoldersResults;
import microsoft.exchange.webservices.data.search.FolderView;
import okhttp3.Call;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.map.HashedMap;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONObject;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class CommonDownloadController {
    private static Logger logger = LogManager.getLogger(CommonDownloadController.class);
    private static final String RESOURCE = "https://outlook.office365.com";
    private static final String AUTHORITY = "https://login.microsoftonline.com/";
    private static final String EWS_URL = "https://outlook.office365.com/EWS/Exchange.asmx";
    private static final long TWO_MIN_IN_MILLI = 300000L;
    private static final String IN_PLACE_ARCHIVE = "In-Place Archive/";
    @Autowired
    private UtilService utilService;
    @Autowired
    private DownloadService downloadService;
    @Autowired
    private SyncDownloadService syncDownloadService;
    private String ewsToken = null;
    private static final String MICROSOFT_EXCHANGE = " Microsoft Exchange";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/cloud/{cloudName}/portal/download/files/"}, method={RequestMethod.GET})
    public void downloadFileForPortal(final @PathVariable(value="cloudName") String cloudName, HttpServletRequest request, final HttpServletResponse response) {
        final String browserType = request.getHeader("user-agent");
        InputStream inputStream = null;
        try {
            boolean isDownload;
            boolean isSync = false;
            String assetName = null;
            String isSyncFlag = request.getParameter("isSync");
            final DownloadFileTO downloadFileTO = this.getRequestParameters(request, cloudName);
            String loginUserName = request.getParameter("loginUserName");
            logger.debug(loginUserName + "...loginUserName.." + request.getHeader("loginUserName"));
            String attachmentId = request.getParameter("attachmentId");
            String accesskey = request.getParameter("accessKey");
            String uniqueId = request.getParameter("userId");
            String checkStatus = request.getParameter("checkStatus");
            logger.debug(accesskey + "...unique id..." + uniqueId + "....");
            boolean isView = false;
            String isDownloadFlag = request.getParameter("isDownload");
            if (StringUtils.isEmpty((String)isDownloadFlag)) {
                isDownloadFlag = request.getHeader("isDownload");
            }
            String attachName = request.getParameter("attachName");
            String moveToDownload = request.getParameter("moveToDownloads");
            boolean moveToDownloads = false;
            logger.debug("movetodownloads is ..." + moveToDownload);
            if (!StringUtils.isEmpty((String)moveToDownload)) {
                moveToDownloads = Boolean.valueOf(moveToDownload);
            }
            if (!StringUtils.isEmpty((String)loginUserName)) {
                loginUserName = this.decodeBase64UTFString(loginUserName);
            }
            if (!StringUtils.isEmpty((String)attachName)) {
                attachName = this.decodeBase64UTFString(attachName);
            }
            if (!StringUtils.isEmpty((String)isDownloadFlag) && !(isDownload = Boolean.parseBoolean(isDownloadFlag))) {
                isView = true;
            }
            if (!StringUtils.isEmpty((String)accesskey)) {
                if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)uniqueId)) {
                    com.parablu.pcbd.domain.User u = this.utilService.getUserInfoByName(1, uniqueId);
                    if (u != null) {
                        uniqueId = u.getEmailId();
                    }
                    OTPValidation otpValidation = this.utilService.getOTPForUniqueId(1, uniqueId);
                    logger.debug("otp value:" + otpValidation);
                    if (otpValidation == null || !accesskey.equalsIgnoreCase(otpValidation.getToken())) {
                        logger.error("access key validation not successfull.." + otpValidation);
                        response.setStatus(451);
                        return;
                    }
                    if (accesskey.equalsIgnoreCase(otpValidation.getToken()) && otpValidation.getModifiedTime() + 300000L < System.currentTimeMillis()) {
                        logger.error("access key validation not successfull..");
                        response.setStatus(451);
                        return;
                    }
                } else {
                    logger.error("unique id not found....");
                    response.setStatus(451);
                    return;
                }
            }
            if (!StringUtils.isEmpty((String)isSyncFlag)) {
                isSync = Boolean.parseBoolean(isSyncFlag);
                downloadFileTO.setSync(isSync);
            } else {
                response.setStatus(400);
            }
            String deviceUUID = request.getParameter("deviceUUID");
            if (StringUtils.isEmpty((String)deviceUUID)) {
                deviceUUID = request.getHeader("deviceUUID");
            }
            DownloadTO downloadTO = null;
            final Cloud cloud = this.utilService.getCloud(1);
            logger.debug(deviceUUID + "<<<Downloading backup file>>>" + request.getParameter("backupID"));
            downloadFileTO.setDeviceUUID(deviceUUID);
            downloadFileTO.setBackupID(request.getParameter("backupID"));
            if (StringUtils.isEmpty((String)downloadFileTO.getUserName())) {
                downloadFileTO.setUserName(loginUserName);
            }
            downloadFileTO.setAttachmentId(attachmentId);
            if (!StringUtils.isEmpty((String)attachName) && !"EMPTY".equalsIgnoreCase(attachName)) {
                downloadFileTO.setAttachName(attachName);
            }
            downloadFileTO.setMoveToDownloads(moveToDownloads);
            downloadFileTO.setActionBy(loginUserName);
            if (moveToDownloads) {
                final String loginUserNameFinal = loginUserName;
                Thread daemonThread = null;
                Runnable daemonRunner = new Runnable(){

                    @Override
                    public void run() {
                        DownloadTO downloadTO = CommonDownloadController.this.backupFileDownloadForPortal(downloadFileTO, cloud, cloudName, response, browserType);
                        String action = "Downloaded file ";
                        int actionType = 4;
                        if (downloadTO.isPathInsideMC()) {
                            String mcName = downloadTO.getMcName();
                            CommonDownloadController.this.saveAuditHistoryMC(downloadFileTO, loginUserNameFinal, cloud, mcName, action, actionType);
                        } else {
                            Device device = CommonDownloadController.this.utilService.getDeviceForUUID(cloud.getCloudId(), downloadFileTO.getDeviceUUID());
                            CommonDownloadController.this.saveAuditHistory(downloadFileTO.getFilePath(), downloadFileTO.getFileName(), loginUserNameFinal, cloud, action, actionType, device.getDeviceName());
                        }
                    }
                };
                daemonThread = new Thread(daemonRunner);
                daemonThread.start();
                response.setStatus(203);
                return;
            }
            downloadTO = this.backupFileDownloadForPortal(downloadFileTO, cloud, cloudName, response, browserType);
            logger.debug("...attachname...." + attachName);
            if (downloadTO != null) {
                logger.debug(" File size after  ...." + downloadTO.getSize());
            }
            if (downloadTO != null && downloadTO.getSize() > 0L) {
                Device device;
                response.setStatus(200);
                if (!StringUtils.isEmpty((String)downloadTO.getFilePath())) {
                    downloadFileTO.setFilePath(downloadTO.getFilePath());
                }
                if (!StringUtils.isEmpty((String)downloadTO.getFileName())) {
                    downloadFileTO.setFileName(downloadTO.getFileName());
                }
                if (isSync) {
                    long fileSizeInKB = (long)Math.ceil((double)downloadTO.getSize() / 1024.0);
                    this.utilService.saveSyncOverview(cloud.getCloudId(), 0L, fileSizeInKB, 0L, 1L);
                }
                String action = "Downloaded file ";
                int actionType = 4;
                if (!StringUtils.isEmpty((String)isDownloadFlag) && isDownloadFlag.equalsIgnoreCase("false")) {
                    action = "Viewed file ";
                    actionType = 115;
                }
                if ((device = this.utilService.getDeviceForUUID(cloud.getCloudId(), downloadFileTO.getDeviceUUID())) != null) {
                    assetName = device.getDeviceName();
                }
                if (!StringUtils.isEmpty(assetName) && assetName.contains(MICROSOFT_EXCHANGE)) {
                    action = "Downloaded mail";
                    actionType = 118;
                }
                if (StringUtils.isEmpty((String)checkStatus) || checkStatus.equalsIgnoreCase("false")) {
                    if (downloadTO.isPathInsideMC()) {
                        String mcName = downloadTO.getMcName();
                        this.saveAuditHistoryMC(downloadFileTO, loginUserName, cloud, mcName, action, actionType);
                    } else {
                        this.saveAuditHistory(downloadFileTO.getFilePath(), downloadFileTO.getFileName(), loginUserName, cloud, action, actionType, assetName);
                    }
                }
                this.downloadService.updateModifiedTimeForFileAndParentFolder(downloadFileTO, cloud, System.currentTimeMillis(), downloadTO.getMcName(), downloadTO.isPathInsideMC());
            } else if (response.getStatus() == 451) {
                this.saveAuditHistoryForFailedFile(downloadFileTO, loginUserName, cloud, assetName);
                logger.debug("file download failed file md5 is blocked >>>>>>>>>>>$$$$$$$$$$$$ ");
            } else if (response.getStatus() == 204) {
                logger.debug("file download failed  >>>>>>>>>>>$$$$$$$$$$$$ ");
            } else {
                logger.debug("file download file input stream is null>>>>>>>>>>>$$$$$$$$$$$$ ");
                response.setStatus(449);
            }
        }
        catch (ParacloudBackupException e) {
            e.printStackTrace();
            logger.trace("" + (Object)((Object)e));
            logger.debug(" File not found during download  ...." + e.getMessage());
            response.setStatus(449);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.trace("" + e);
            logger.error("  UNALBE TO DOWNLOAD FILE ", (Throwable)e);
            response.setStatus(500);
        }
        finally {
            IOUtils.closeQuietly(inputStream);
        }
        logger.debug(" end of  download file  Completed for portal ....");
    }

    private void saveAuditHistoryForFailedFile(DownloadFileTO downloadFileTO, String loginUserName, Cloud cloud, String assetName) {
        if (!StringUtils.isEmpty((String)loginUserName)) {
            AuditHistory auditHistory = new AuditHistory();
            StringBuilder action = new StringBuilder("Download failed.File has been quarantined");
            auditHistory.setAction(action.toString());
            auditHistory.setActionByUserName(loginUserName);
            auditHistory.setActionOnObject(downloadFileTO.getFilePath() + "/" + downloadFileTO.getFileName() + " for asset name : " + assetName);
            auditHistory.setTimestamp(System.currentTimeMillis());
            auditHistory.setActionUsingObject("Portal");
            auditHistory.setActionType(4);
            logger.debug("Action type" + auditHistory.getActionType());
            this.utilService.saveAudit(cloud.getCloudId(), auditHistory);
        }
    }

    @GetMapping(value={"/cloud/{cloudName}/portal/download/files/photo/"})
    @ResponseBody
    public ModelAndView getPhoto(@PathVariable(value="cloudName") String cloudName, HttpServletRequest request, HttpServletResponse response) throws IOException {
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        try {
            boolean isSync = false;
            String isSyncFlag = request.getParameter("isSync");
            DownloadFileTO downloadFileTO = this.getRequestParameters(request, cloudName);
            String loginUserName = request.getParameter("loginUserName");
            String attachmentId = request.getParameter("attachmentId");
            loginUserName = this.decodeBase64UTFString(loginUserName);
            logger.debug(attachmentId + "...loginUserName..." + loginUserName + "....");
            if (!StringUtils.isEmpty((String)isSyncFlag)) {
                isSync = Boolean.parseBoolean(isSyncFlag);
                downloadFileTO.setSync(isSync);
            } else {
                response.setStatus(400);
            }
            Object downloadTO = null;
            Cloud cloud = this.utilService.getCloud(1);
            logger.debug("<<<Downloading backup file>>>" + request.getParameter("backupID"));
            downloadFileTO.setBackupID(request.getParameter("backupID"));
            if (StringUtils.isEmpty((String)downloadFileTO.getUserName())) {
                downloadFileTO.setUserName(loginUserName);
            }
            downloadFileTO.setAttachmentId(attachmentId);
            logger.debug(" end of  download file  Completed for portalModelAndView ....");
            byte[] out = this.backupFileDownloadPhotoForPortal(downloadFileTO, cloud, cloudName);
            modelAndView.addObject((Object)out);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.trace("" + e);
            logger.error("  UNALBE TO DOWNLOAD FILE " + e.getMessage());
            response.setStatus(500);
            byte[] byteaa = new byte[]{0, 1, 2};
            modelAndView.addObject((Object)byteaa);
        }
        return modelAndView;
    }

    @RequestMapping(value={"versions/{versionNumber}/clouds/{cloudName}/restoreEvents/"}, method={RequestMethod.POST})
    public ModelAndView createRestoreActions(@PathVariable(value="cloudName") String cloudName1, @RequestBody RestoreEventsElement restoreEventsElement, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        ModelAndView modelAndView = new ModelAndView();
        logger.debug(restoreEventsElement.isRestoreLinks() + "calling versions/{versionNumber}/clouds/{cloudName}/eventHub/events/...  to edit action" + restoreEventsElement.getActionBy());
        try {
            Cloud cloud = this.utilService.getCloud(1);
            cloudName = cloud.getCloudName();
            int cloudId = cloud.getCloudId();
            String currentUser = request.getHeader("currentUser");
            if (StringUtils.isNotEmpty((String)currentUser)) {
                currentUser = this.decodeBase64UTFString(currentUser);
            }
            logger.debug(restoreEventsElement.getActionOnDeviceUUID() + "calling clouds/{cloudName}/eventHub/events/...  to edit action" + restoreEventsElement.getDestinationDeviceUUID());
            Device device = this.utilService.getDeviceForUUID(cloudId, restoreEventsElement.getActionOnDeviceUUID());
            Device destinationDevice = this.utilService.getDeviceForUUID(cloudId, restoreEventsElement.getDestinationDeviceUUID());
            if (device == null && !restoreEventsElement.isGlobalSearch()) {
                response.setStatus(406);
                logger.error("...invalid device.....");
                return null;
            }
            logger.debug(restoreEventsElement.getFileElement().isFolder() + "..sss...backupid.. dev.. " + restoreEventsElement.getFileElement().getBackupId() + "....." + restoreEventsElement.getFileElement().isDevice() + "..office policy name:" + restoreEventsElement.getOfficePolicyName());
            logger.debug(restoreEventsElement.isSuspendBackup() + "..sss...actionby.... " + restoreEventsElement.getActionBy().toString());
            if (StringUtils.isEmpty((String)restoreEventsElement.getFileElement().getFileCompletePath())) {
                logger.debug("....restore-update....");
                if (!StringUtils.isEmpty((String)restoreEventsElement.getFileElement().getBackupId())) {
                    logger.debug("....restore-update1....");
                    BackUpImage bkpImage = this.utilService.getBackupImageFile(cloudId, restoreEventsElement.getFileElement().getBackupId(), device);
                    logger.debug("....restore-update2....");
                    if (bkpImage != null) {
                        logger.debug("....restore-update3....");
                        restoreEventsElement.getFileElement().setFileCompletePath(bkpImage.getDevicePath() + "/" + bkpImage.getFileName());
                    }
                }
            }
            RestoreEventsElement updateRestoreEvents = null;
            updateRestoreEvents = device != null ? this.utilService.updateRestoreEvents(cloudId, restoreEventsElement, device.getUserName(), device.getDeviceType()) : this.utilService.updateRestoreEvents(cloudId, restoreEventsElement, null, null);
            if (updateRestoreEvents != null) {
                logger.debug("....inplace restore..failed..");
                modelAndView.addObject((Object)updateRestoreEvents);
                response.setStatus(417);
                return modelAndView;
            }
            logger.debug("....inplace restore....");
            String restorePath = "in place restore ";
            if (!restoreEventsElement.isInPlaceRestore()) {
                restorePath = restoreEventsElement.getDestinationPath();
            }
            String actionOnUser = this.constructActionOnUser(device, destinationDevice, restoreEventsElement, false);
            if (destinationDevice == null) {
                if (StringUtils.isNotEmpty((String)restoreEventsElement.getEventType()) && restoreEventsElement.getEventType().equalsIgnoreCase("LARGE_FILE_DOWNLOAD")) {
                    String action = "Downloaded Item";
                    String filePath = restoreEventsElement.getFileElement().getFileCompletePath();
                    String fileName = restoreEventsElement.getFileElement().getFileName();
                    fileName = this.decodeBase64UTFString(fileName);
                    if (!StringUtils.isEmpty((String)filePath) && !filePath.startsWith("null")) {
                        filePath = this.decodeBase64UTFString(filePath);
                    }
                    int actionType = 11;
                    this.saveAuditHistory(filePath, fileName, currentUser, cloud, action, actionType, device.getDeviceName());
                } else {
                    this.utilService.saveStatisticToDatabase(cloudId, cloudName, "exported pst for", currentUser, actionOnUser, "Portal", System.currentTimeMillis(), 92);
                }
            } else {
                this.utilService.saveStatisticToDatabase(cloudId, cloudName, "initiated restore for", currentUser, actionOnUser, "Portal", System.currentTimeMillis(), 92);
            }
            response.setStatus(200);
        }
        catch (Exception e) {
            logger.error(".....errorr trying ...", (Throwable)e);
            response.setStatus(500);
        }
        return modelAndView;
    }

    @RequestMapping(value={"versions/{versionNumber}/clouds/{cloudName}/restoreEventsProgress/{deviceUUID}"}, method={RequestMethod.GET})
    public ModelAndView getRestoreProgressEvents(@PathVariable(value="cloudName") String cloudName1, @PathVariable(value="deviceUUID") String deviceUUID, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        ModelAndView modelAndView = new ModelAndView();
        response.setContentType("text/html; charset=UTF-8");
        logger.debug("calling versions/{versionNumber}/clouds/{cloudName}/restoreEventsProgress/...  to get restoreEvents of " + deviceUUID);
        try {
            Cloud cloud = this.utilService.getCloud(1);
            cloudName = cloud.getCloudName();
            int cloudId = cloud.getCloudId();
            String loginUserName = request.getHeader("loginUserName");
            String batchId = request.getHeader("batchId");
            logger.debug(batchId + ".... deviceuuid and user ..." + deviceUUID + "...." + loginUserName);
            RestoreProgressEvents restoreProgressEvents = this.utilService.getRestoreEventProgressByUUID(cloudId, deviceUUID, loginUserName);
            RestoreProgressEventsElement restoreProgressEventsElement = null;
            if (restoreProgressEvents == null) {
                logger.error("... restore not started ... ");
                restoreProgressEventsElement = new RestoreProgressEventsElement();
                restoreProgressEventsElement.setDeviceUUID(deviceUUID);
                restoreProgressEventsElement.setFolderName("");
                restoreProgressEventsElement.setUserName("");
                restoreProgressEventsElement.setCurrentFolderPath("");
                restoreProgressEventsElement.setRestoredFiles(0L);
                restoreProgressEventsElement.setRestoredFilesForFolder(0L);
                restoreProgressEventsElement.setRestoredPctForFolder(0L);
                restoreProgressEventsElement.setSize(0L);
                restoreProgressEventsElement.setSubject("");
                restoreProgressEventsElement.setTotalNoOfFilesForRestore(0L);
                restoreProgressEventsElement.setTotalNoOfRestoreFilesForFolder(0L);
                restoreProgressEventsElement.setTotalRestorePct(0L);
                modelAndView.addObject((Object)restoreProgressEventsElement);
                logger.debug("... backupbatch id ...." + batchId);
                if (!StringUtils.isEmpty((String)batchId) && !"undefined".equalsIgnoreCase(batchId)) {
                    BackupBatch backupBatch = this.utilService.getBackupBatchById(cloudId, batchId);
                    if (backupBatch != null && "RESTORE".equals(backupBatch.getJobType())) {
                        response.setStatus(202);
                    }
                } else {
                    response.setStatus(204);
                }
            } else {
                restoreProgressEventsElement = new RestoreProgressEventsElement();
                BeanUtils.copyProperties((Object)restoreProgressEvents, (Object)restoreProgressEventsElement);
                restoreProgressEventsElement.setBatchId(restoreProgressEvents.getBatchId());
                if (restoreProgressEventsElement.getTotalNoOfFilesForRestore() == 0L || restoreProgressEventsElement.getRestoredFiles() == 0L) {
                    restoreProgressEventsElement.setTotalRestorePct(0L);
                } else {
                    restoreProgressEventsElement.setTotalRestorePct(this.getPercentageCompleted(restoreProgressEventsElement.getTotalNoOfFilesForRestore(), restoreProgressEventsElement.getRestoredFiles()));
                }
                if (restoreProgressEventsElement.getRestoredFilesForFolder() == 0L || restoreProgressEventsElement.getTotalNoOfRestoreFilesForFolder() == 0L) {
                    restoreProgressEventsElement.setRestoredPctForFolder(0L);
                } else {
                    restoreProgressEventsElement.setRestoredPctForFolder(this.getPercentageCompleted(restoreProgressEventsElement.getTotalNoOfRestoreFilesForFolder(), restoreProgressEventsElement.getRestoredFilesForFolder()));
                }
                logger.debug("....pct... " + restoreProgressEventsElement.getTotalNoOfFilesForRestore() + "...." + restoreProgressEventsElement.getRestoredFiles() + "...." + restoreProgressEventsElement.getTotalRestorePct());
                modelAndView.addObject((Object)restoreProgressEventsElement);
                response.setStatus(200);
            }
            return modelAndView;
        }
        catch (Exception e) {
            logger.error("An exception occurred ={}", (Throwable)e);
            response.setStatus(500);
            return null;
        }
    }

    private long getPercentageCompleted(long totalNoOfFiles, long noOfFilesRemaining) {
        logger.debug("..calling getPercentageCompleted.." + totalNoOfFiles + "...." + noOfFilesRemaining);
        long percentage = 100L;
        percentage = noOfFilesRemaining * 100L / totalNoOfFiles;
        logger.debug("..percentage.." + percentage);
        return percentage;
    }

    @RequestMapping(value={"/cloud/{cloudName}/inPlaceRestore/mail/"}, method={RequestMethod.GET})
    public void inPlaceRestoreForMail(@PathVariable(value="cloudName") String cloudName, HttpServletRequest request, HttpServletResponse response) {
        logger.debug(" ... start of inplace restore  ....");
        String browserType = request.getHeader("user-agent");
        try {
            DownloadFileTO downloadFileTO = this.getRequestParameters(request, cloudName);
            String loginUserName = request.getParameter("loginUserName");
            String deviceUUID = request.getParameter("deviceUUID");
            String userName = request.getParameter("userName");
            if (userName == null || userName.equalsIgnoreCase("undefined")) {
                userName = "testmailsharedbox@parablu.com";
            }
            if (StringUtils.isEmpty((String)deviceUUID)) {
                deviceUUID = request.getHeader("deviceUUID");
            }
            loginUserName = this.decodeBase64UTFString(loginUserName);
            logger.debug(deviceUUID + "..uuid ....loginUserName..." + loginUserName + "...." + userName);
            Cloud cloud = this.utilService.getCloud(1);
            boolean isFolder = false;
            if (request.getParameter("isFolder") != null) {
                isFolder = Boolean.parseBoolean(request.getParameter("isFolder"));
            }
            String backupId = request.getParameter("backupID");
            logger.debug(isFolder + " bool <<<Downloading backup file>>>" + backupId);
            downloadFileTO.setBackupID(backupId);
            downloadFileTO.setActionBy(loginUserName);
            if (StringUtils.isEmpty((String)downloadFileTO.getUserName())) {
                downloadFileTO.setUserName(loginUserName);
            }
            com.parablu.pcbd.domain.User user = this.utilService.getUserInfoByName(1, userName);
            logger.debug("....user..... " + user.getUserName());
            BackupFile backupFile = this.downloadService.getBackupFileForId(cloud.getCloudId(), userName, backupId);
            if (backupFile == null) {
                logger.error(".... mail does not exists.... ");
                response.setStatus(507);
                return;
            }
            MailBackupBatch backupBatch = this.utilService.getMailBackupBatch(cloud.getCloudId(), backupFile.getDeviceUUID());
            if (backupBatch != null) {
                logger.error(".... Already a restore is  running .... ");
                response.setStatus(455);
                return;
            }
            backupBatch = new MailBackupBatch();
            backupBatch.setStatus(MailBackupBatch.STATUS.STARTED.name());
            backupBatch.setDeviceUUID(backupFile.getDeviceUUID());
            backupBatch.setBackupId(backupFile.getBackupId().toString());
            backupBatch.setFolder(isFolder);
            backupBatch.setUserName(userName);
            backupBatch.setOfficePolicyName(user.getOneDrivePolicyName());
            backupBatch.setRestoreByUserName(loginUserName);
            EventHub eventHub = new EventHub();
            eventHub.setActionBy(loginUserName);
            eventHub.setAction(PCHelperConstant.EVENTHUB_ACTION_STATUS.RESTORE_CREATED.toString());
            eventHub.setActionStatus(PCHelperConstant.EVENTHUB_ACTION_STATUS.RESTORE_CREATED.toString());
            eventHub.setActionToUserName(backupFile.getUserName());
            eventHub.setActionToDeviceUUID(backupFile.getDeviceUUID());
            eventHub.setOdStatus(EventHub.ODSTATUS.RESTORE_STARTED.toString());
            this.utilService.saveMailBackupBatch(cloud.getCloudId(), backupBatch, eventHub);
            response.setStatus(200);
        }
        catch (Exception e) {
            logger.error("..... UNALBE TO INITIATE A RESTORE .... " + e.getMessage());
            response.setStatus(500);
        }
        logger.debug(" ... end of inplace restore  ....");
    }

    private void saveAuditHistory(String filePath, String fileName, String loginUserName, Cloud cloud, String action, int actionType, String assetName) {
        if (!StringUtils.isEmpty((String)loginUserName)) {
            AuditHistory auditHistory = new AuditHistory();
            auditHistory.setAction(action.toString());
            auditHistory.setActionByUserName(loginUserName);
            if (StringUtils.isEmpty((String)filePath) || filePath.startsWith("null")) {
                auditHistory.setActionOnObject(fileName + " for asset name : " + assetName);
            } else {
                auditHistory.setActionOnObject(filePath + "/" + fileName + " for asset name : " + assetName);
            }
            auditHistory.setTimestamp(System.currentTimeMillis());
            auditHistory.setActionUsingObject("Portal");
            auditHistory.setActionType(actionType);
            logger.debug("Action type" + auditHistory.getActionType());
            this.utilService.saveAudit(cloud.getCloudId(), auditHistory);
        }
    }

    private void saveAuditHistoryMC(DownloadFileTO downloadFileTO, String loginUserName, Cloud cloud, String mcName, String action, int actionType) {
        if (!StringUtils.isEmpty((String)loginUserName)) {
            AuditHistory auditHistory = new AuditHistory();
            if (mcName.startsWith("_mc_")) {
                mcName = mcName.replaceFirst("_mc_", "");
            }
            auditHistory.setAction(action.toString());
            auditHistory.setActionByUserName(loginUserName);
            auditHistory.setActionOnObject(downloadFileTO.getFilePath() + "/" + downloadFileTO.getFileName() + " from minicloud " + mcName);
            auditHistory.setTimestamp(System.currentTimeMillis());
            auditHistory.setActionUsingObject("Portal");
            auditHistory.setMiniCloud(true);
            auditHistory.setMcName(mcName);
            auditHistory.setActionType(actionType);
            logger.debug("Action type" + auditHistory.getActionType());
            this.utilService.saveAudit(cloud.getCloudId(), auditHistory);
        }
    }

    private DownloadTO backupFileDownloadForPortal(DownloadFileTO downloadFileTO, Cloud cloud, String cloudName, HttpServletResponse response, String browserType) {
        if (!downloadFileTO.isFolder()) {
            return this.downloadService.downloadBackupFileForPortal(downloadFileTO, cloud, cloudName, response, browserType);
        }
        return this.downloadService.downloadBackupFolderForPortal(downloadFileTO, cloud, response, browserType, true, false);
    }

    private byte[] backupFileDownloadPhotoForPortal(DownloadFileTO downloadFileTO, Cloud cloud, String cloudName) {
        return this.downloadService.downloadContactsPhotoForPortal(downloadFileTO, cloud, cloudName, "");
    }

    private DownloadFileTO getRequestParameters(HttpServletRequest request, String cloudName) {
        DownloadFileTO downloadFileTO = new DownloadFileTO();
        String actionType = request.getParameter("actionType");
        String filePath = request.getParameter("filePath");
        if (!StringUtils.isEmpty((String)filePath)) {
            filePath = this.decodeBase64UTFString(request.getParameter("filePath"));
        }
        String userName = request.getParameter("userName");
        String fileName = request.getParameter("fileName");
        if (!StringUtils.isEmpty((String)fileName)) {
            fileName = this.decodeBase64UTFString(request.getParameter("fileName"));
        }
        if (!StringUtils.isEmpty((String)userName)) {
            userName = this.decodeBase64UTFString(userName);
        }
        String gatewayName = request.getParameter("gatewayName");
        String isFolder = request.getParameter("isFolder");
        if (!StringUtils.isEmpty((String)isFolder)) {
            downloadFileTO.setFolder(Boolean.parseBoolean(isFolder));
        }
        downloadFileTO.setCloudName(cloudName);
        downloadFileTO.setFileName(fileName);
        downloadFileTO.setFilePath(filePath);
        downloadFileTO.setGatewayName(gatewayName);
        downloadFileTO.setUserName(userName);
        downloadFileTO.setActionType(actionType);
        return downloadFileTO;
    }

    protected String decodeBase64UTFString(String encodedString) {
        String decodedString = encodedString;
        try {
            decodedString = new String(Base64.decodeBase64((String)encodedString), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            logger.trace("" + e);
            logger.error("" + e.getMessage());
            logger.debug("UnsupportedEncodingException", (Throwable)e);
        }
        return decodedString;
    }

    protected String encodeUTFBase64(String input) {
        try {
            return Base64.encodeBase64String((byte[])input.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            logger.debug("UnsupportedEncodingException", (Throwable)e);
            return input;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/cloud/{cloudName}/download/folderAsZip/"}, method={RequestMethod.GET})
    public void downloadSyncPortalFile(@PathVariable(value="cloudName") String cloudName, HttpServletRequest request, final HttpServletResponse response) {
        InputStream inputStream = null;
        final String browserType = request.getHeader("user-agent");
        logger.debug(".......download folder as zip....");
        try {
            Device device;
            String fileName = "";
            String syncRevisionId = "";
            String filePath = "";
            String userName = "";
            String gatewayName = "";
            String sourceDeviceUUID = "";
            String assetName = null;
            boolean isFolder = false;
            boolean isSync = false;
            String loginUserName = null;
            Map parameters = request.getParameterMap();
            for (String key : parameters.keySet()) {
                String[] vals;
                logger.debug("....key...." + key);
                for (String val : vals = (String[])parameters.get(key)) {
                    logger.debug("....val...." + val);
                    if ("fileName".equalsIgnoreCase(key)) {
                        fileName = val;
                    }
                    if ("syncRevisionId".equalsIgnoreCase(key)) {
                        syncRevisionId = val;
                    }
                    if ("filePath".equalsIgnoreCase(key)) {
                        filePath = val;
                    }
                    if ("userName".equalsIgnoreCase(key)) {
                        userName = val;
                        userName = this.decodeBase64UTFString(userName);
                    }
                    if ("isFolder".equalsIgnoreCase(key)) {
                        isFolder = Boolean.parseBoolean(val);
                    }
                    if ("isSync".equalsIgnoreCase(key)) {
                        isSync = Boolean.parseBoolean(val);
                    }
                    if ("deviceUUID".equalsIgnoreCase(key)) {
                        sourceDeviceUUID = val;
                    }
                    if (!"loginUserName".equalsIgnoreCase(key)) continue;
                    loginUserName = val;
                    loginUserName = this.decodeBase64UTFString(loginUserName);
                }
            }
            final DownloadFileTO downloadFileTO = this.getRequestParameters(request, cloudName);
            boolean isrestoreDeletedFile = false;
            String restoreDeletedFileStr = request.getParameter("restoreDeletedFile");
            if (!StringUtils.isEmpty((String)restoreDeletedFileStr)) {
                isrestoreDeletedFile = Boolean.valueOf(restoreDeletedFileStr);
                logger.debug("...isrestoreDeletedFile..........." + isrestoreDeletedFile);
            }
            boolean folderSearch = false;
            String folderSearchStr = request.getParameter("folderSearch");
            if (!StringUtils.isEmpty((String)folderSearchStr)) {
                folderSearch = Boolean.valueOf(folderSearchStr);
                logger.debug("...folderSearch..........." + isrestoreDeletedFile);
            }
            logger.debug("...isrestoreDeletedFile..........." + isrestoreDeletedFile);
            downloadFileTO.setBackupID(syncRevisionId);
            downloadFileTO.setDeviceUUID(sourceDeviceUUID);
            downloadFileTO.setActionBy(loginUserName);
            logger.debug(syncRevisionId + " Filename ..." + downloadFileTO.getFileName());
            logger.debug(syncRevisionId + "  DOWNLOAD FILE  STARTED for portal1 ...." + fileName);
            String deviceUUID = "Portal";
            Object downloadTO = null;
            final String saltKey = this.utilService.getEncryptionKey(1, "sync");
            final Cloud cloud = this.utilService.getCloud(1);
            response.addHeader("Pragma", "public");
            response.addHeader("Expires", String.valueOf(200));
            response.addHeader("Cache-Control", "must-revalidate, post-check=0, pre-check=0");
            String zipFileName = downloadFileTO.getFileName() + ".zip";
            String encodedFileName = URLEncoder.encode(zipFileName, StandardCharsets.UTF_8.toString());
            if (browserType.contains("Firefox")) {
                response.setHeader("Content-Disposition", "attachment; filename*=UTF-8''" + encodedFileName);
            } else if (browserType.contains("Chrome")) {
                response.setHeader("Content-Disposition", "attachment; filename=" + encodedFileName);
            } else {
                response.setHeader("Content-Disposition", "attachment; filename=\"" + encodedFileName + "\"");
            }
            response.addHeader("Content-Transfer-Encoding", "binary");
            response.addHeader("filename", downloadFileTO.getFileName() + ".zip");
            response.addHeader("Content-Transfer-Encodingsdasda", "binary");
            response.setContentType("application/octet-stream");
            response.addHeader("loggedinUserName", loginUserName);
            if (!StringUtils.isEmpty((String)downloadFileTO.getDeviceUUID()) && (device = this.utilService.getDeviceForUUID(cloud.getCloudId(), downloadFileTO.getDeviceUUID())) != null) {
                assetName = device.getDeviceName();
            }
            final String userNameFinal = userName;
            final String revIdFinal = syncRevisionId;
            final boolean isSyncFinal = isSync;
            final boolean isrestoreDeletedFilesFinal = isrestoreDeletedFile;
            final boolean folderSearchFinal = folderSearch;
            Thread daemonThread = null;
            Runnable daemonRunner = new Runnable(){

                @Override
                public void run() {
                    CommonDownloadController.this.downloadFolderAsZip(cloud, userNameFinal, downloadFileTO.getFileName(), downloadFileTO.getFilePath(), saltKey, "Portal", revIdFinal, response, browserType, isSyncFinal, downloadFileTO, isrestoreDeletedFilesFinal, folderSearchFinal);
                }
            };
            daemonThread = new Thread(daemonRunner);
            daemonThread.start();
            logger.debug("header name....." + response.getHeader("file-download-path"));
            logger.debug(userName + "...header name....." + response.getHeader("filename"));
            response.setStatus(200);
            String action = "Downloaded Folder ";
            int actionType = 11;
            boolean isPathInsideMC = this.syncDownloadService.isPathInsideMC(cloud.getCloudId(), downloadFileTO.getFilePath() + "/" + downloadFileTO.getFileName());
            logger.debug(loginUserName + "...audit history added...." + isPathInsideMC);
            if (isPathInsideMC) {
                String mcName = this.syncDownloadService.getMCName(downloadFileTO.getFilePath() + "/" + downloadFileTO.getFileName());
                this.saveAuditHistoryMC(downloadFileTO, loginUserName, cloud, mcName, action, actionType);
            } else {
                this.saveAuditHistory(downloadFileTO.getFilePath(), downloadFileTO.getFileName(), loginUserName, cloud, action, actionType, assetName);
            }
        }
        catch (Exception e) {
            logger.error("error trying to download folder... e={}", (Throwable)e);
            response.setStatus(500);
        }
        finally {
            IOUtils.closeQuietly(inputStream);
        }
        logger.debug(" end of  download file  Completed for portal ....");
    }

    private DownloadTO downloadFolderAsZip(Cloud cloud, String userName, String fileName, String filePath, String saltKey, String deviceUUID, String syncRevisionId, HttpServletResponse response, String browserType, boolean isSync, DownloadFileTO downloadFileTO, boolean isrestoreDeletedFile, boolean folderSearch) {
        if (isSync) {
            downloadFileTO.setUserName(userName);
            downloadFileTO.setFileName(fileName);
            downloadFileTO.setFilePath(filePath);
            downloadFileTO.setSync(true);
            return this.syncDownloadService.downloadZipSyncFileForPortal(downloadFileTO, cloud, response, browserType, isrestoreDeletedFile, syncRevisionId);
        }
        return this.downloadService.downloadBackupFolderForPortal(downloadFileTO, cloud, response, browserType, isrestoreDeletedFile, folderSearch);
    }

    public void setSyncDownloadService(SyncDownloadServiceImpl syncDownloadService) {
        this.syncDownloadService = syncDownloadService;
    }

    @RequestMapping(value={"/cloud/{cloudName}/delete/zipFile/"}, method={RequestMethod.DELETE})
    public void deleteZipFile(@PathVariable(value="cloudName") String cloudName, HttpServletRequest request, HttpServletResponse response) {
        String filePath = request.getHeader("filePath");
        try {
            logger.debug("filePath...." + filePath);
            File file = new File(filePath);
            if (file.exists()) {
                response.setStatus(200);
            } else {
                logger.debug("File not presnt..." + filePath);
                response.setStatus(507);
            }
        }
        catch (ParacloudBackupException e) {
            logger.trace("" + (Object)((Object)e));
            logger.debug(" File not found during download  ...." + e.getMessage());
            response.setStatus(449);
        }
        catch (Exception e) {
            logger.trace("" + e);
            response.setStatus(500);
        }
        logger.debug(" end of  download file  delete for portal ....");
    }

    @RequestMapping(value={"versions/{versionNumber}/clouds/{cloudName}/mail/folders/{deviceUUID}"}, method={RequestMethod.GET})
    public ModelAndView getMailFolders(@PathVariable(value="cloudName") String cloudName1, @PathVariable(value="deviceUUID") String deviceUUID, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        ModelAndView modelAndView = new ModelAndView();
        response.setContentType("text/html; charset=UTF-8");
        String folderpath = request.getHeader("folderpath");
        folderpath = StringEscapeUtils.unescapeHtml3((String)folderpath);
        logger.debug(folderpath + " head calling versions/{versionNumber}/clouds/{cloudName}/mail/folders/{deviceUUID}...  to get child folders of " + deviceUUID);
        try {
            Cloud cloud = this.utilService.getCloud(1);
            cloudName = cloud.getCloudName();
            int cloudId = cloud.getCloudId();
            Device device = this.utilService.getDeviceForUUID(cloudId, deviceUUID);
            if (device == null) {
                response.setStatus(406);
                logger.error("...invalid device.....");
                return null;
            }
            com.parablu.pcbd.domain.User userObj = this.utilService.getUserInfoByName(1, device.getUserName());
            logger.debug(".... trying to get folders..... " + device.getUserName());
            GraphServiceClient<Request> graphClient = Graph.getInstance().getGraphClient();
            String emailId = userObj.getEmailId();
            User userFound = null;
            ArrayList<QueryOption> requestOptions = new ArrayList<QueryOption>();
            requestOptions.add(new QueryOption("$filter", (Object)("mail eq '" + emailId + "'")));
            UserCollectionPage iUserCollectionPage = (UserCollectionPage)((UserCollectionRequest)graphClient.users().buildRequest(requestOptions)).top(1).get();
            for (User userObjVal : iUserCollectionPage.getCurrentPage()) {
                logger.debug(userObjVal.userPrincipalName + "... vals..." + userObjVal.givenName);
                if (!emailId.equalsIgnoreCase(userObjVal.mail) || !emailId.equalsIgnoreCase(userObjVal.userPrincipalName)) continue;
                userFound = userObjVal;
                break;
            }
            if (userFound == null) {
                for (User user : iUserCollectionPage.getCurrentPage()) {
                    if (!emailId.equalsIgnoreCase(user.mail)) continue;
                    userFound = user;
                    break;
                }
            }
            OfficeBackupPolicy officeBackupPolicy = this.utilService.getOfficeBackupPolicyForUser(cloudId, device.getUserName(), device.getDeviceType());
            boolean taskEnabled = false;
            if (officeBackupPolicy != null && officeBackupPolicy.isTasksEnabled()) {
                taskEnabled = true;
            }
            String userId = userFound.id;
            if (StringUtils.isEmpty((String)folderpath)) {
                logger.debug(device.getUserName() + "....emptypath...." + taskEnabled);
                List<String> folders = CommonDownloadController.getParentMailFolders(graphClient, userId);
                if (taskEnabled) {
                    folders.add("To Do");
                }
                Collections.sort(folders);
                modelAndView.addObject(folders);
            } else {
                Object exisfolderPathMap = new HashedMap();
                List<Object> childFolders = new ArrayList();
                logger.debug("....tasks....." + folderpath);
                if (folderpath.equalsIgnoreCase("To Do")) {
                    TodoTaskListCollectionPage taskListsPage = (TodoTaskListCollectionPage)((TodoTaskListCollectionRequest)graphClient.users(userId).todo().lists().buildRequest(new Option[0])).get();
                    List taskLists = taskListsPage.getCurrentPage();
                    if (taskLists != null && !taskLists.isEmpty()) {
                        for (TodoTaskList firstTaskList : taskLists) {
                            logger.debug("Task List: " + firstTaskList.displayName);
                            childFolders.add(firstTaskList.displayName);
                        }
                    }
                } else {
                    String folderId = (String)exisfolderPathMap.get(folderpath);
                    exisfolderPathMap = CommonDownloadController.getExistingFoldersID(graphClient, userId);
                    if (StringUtils.isEmpty((String)folderId)) {
                        folderId = (String)exisfolderPathMap.get(folderpath);
                    }
                    logger.debug(folderpath + "..... id ..." + folderId);
                    childFolders = CommonDownloadController.getExistingChildFolders(graphClient, userId, folderId);
                }
                Collections.sort(childFolders);
                modelAndView.addObject(childFolders);
                logger.debug("...size of child.." + childFolders.size());
            }
            response.setStatus(200);
            return modelAndView;
        }
        catch (GraphServiceException e) {
            e.printStackTrace();
            logger.error("...error trying to get folders......" + e.getMessage());
            response.setStatus(502);
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("...error trying to get folders......" + e.getMessage());
            response.setStatus(500);
            return null;
        }
    }

    private static List<String> getExistingChildFolders(GraphServiceClient<Request> graphClient, String userId, String folderId) {
        MailFolder mailFolder;
        ArrayList<String> childFolderName = new ArrayList<String>();
        String deltaLink = "";
        if (StringUtils.isEmpty((String)folderId)) {
            return childFolderName;
        }
        ArrayList listItems = new ArrayList();
        MailFolderCollectionPage mailFolderCollectionPage = (MailFolderCollectionPage)((MailFolderCollectionRequest)graphClient.users(userId).mailFolders(folderId).childFolders().buildRequest(new Option[0])).get();
        boolean isNextPageExists = false;
        List mailcurrentPage = null;
        ArrayList listFolderItems = new ArrayList();
        do {
            mailcurrentPage = mailFolderCollectionPage.getCurrentPage();
            listFolderItems.addAll(mailcurrentPage);
            if (mailFolderCollectionPage.getNextPage() == null) break;
            mailFolderCollectionPage = (MailFolderCollectionPage)((MailFolderCollectionRequest)((MailFolderCollectionRequestBuilder)mailFolderCollectionPage.getNextPage()).buildRequest(new Option[0])).get();
        } while (listFolderItems.size() > 0 && (isNextPageExists = true));
        for (MailFolder fol : listFolderItems) {
            String folderName = fol.displayName;
            logger.debug(fol.parentFolderId + "...all name... " + folderName);
            if (folderName.contains("Contacts") || folderName.contains("Calendar") || folderName.contains("Yammer Root") || folderName.contains("Outbox") || folderName.contains("Journal") || folderName.contains("Team Chat") || folderName.contains("Files") || folderName.contains("Companies") || folderName.contains("PersonMetadata") || folderName.contains("Feeds") || folderName.contains("Inbound") || folderName.contains("Outbound") || folderName.contains("Recipient Cache") || folderName.contains("Conversation History")) continue;
            childFolderName.add(fol.displayName);
        }
        logger.debug(folderId + "...total folders.. " + childFolderName.size());
        if (!StringUtils.isEmpty((String)folderId) && (mailFolder = graphClient.users(userId).mailFolders(folderId).buildRequest(new Option[0]).get()) != null) {
            logger.debug("^^^^^^^^mail folders^^^^^^^^^" + mailFolder.displayName);
        }
        return childFolderName;
    }

    static Map<String, String> getExistingFoldersID(GraphServiceClient<Request> graphClient, String userId) {
        UserRequestBuilder users = graphClient.users(userId);
        MailFolderCollectionRequestBuilder mailFolders = users.mailFolders();
        String deltaLink = "";
        MailFolderCollectionPage deltaPage = (MailFolderCollectionPage)((MailFolderCollectionRequest)mailFolders.buildRequest(new Option[0])).get();
        boolean isNextPageExists = false;
        List currentPage = null;
        ArrayList listItems = new ArrayList();
        boolean i = false;
        do {
            currentPage = deltaPage.getCurrentPage();
            listItems.addAll(currentPage);
            if (deltaPage.getNextPage() == null) break;
            deltaPage = (MailFolderCollectionPage)((MailFolderCollectionRequest)((MailFolderCollectionRequestBuilder)deltaPage.getNextPage()).buildRequest(new Option[0])).get();
        } while (listItems.size() > 0 && (isNextPageExists = true));
        String rootId = CommonDownloadController.getRootFolderId(userId);
        HashMap<String, String> folderPathMap = new HashMap<String, String>();
        HashMap folderValueKeyMap = new HashMap();
        ArrayList sublistItems = new ArrayList();
        listItems.forEach(fol -> {
            MailFolder folderval = ((MailFolderRequestBuilder)mailFolders.byId(fol.parentFolderId)).buildRequest(new Option[0]).get();
            if (folderval.id.equalsIgnoreCase(rootId)) {
                folderPathMap.put(fol.displayName, fol.id);
                folderValueKeyMap.put(fol.id, fol.displayName);
            }
            if (fol.childFolderCount > 0) {
                logger.debug(".....path...." + fol.displayName);
                CommonDownloadController.addChildFolders(sublistItems, folderPathMap, folderValueKeyMap, fol, graphClient, userId);
            }
        });
        logger.debug("...total folders.. " + folderPathMap.size());
        return folderPathMap;
    }

    private static void addChildFolders(List<MailFolder> sublistItems, Map<String, String> folderPathMap, Map<String, String> folderValueKeyMap, MailFolder fol, GraphServiceClient<Request> graphClient, String userPrincId) {
        MailFolderCollectionPage iMailFolderCollectionPage2 = (MailFolderCollectionPage)((MailFolderCollectionRequest)((MailFolderRequestBuilder)graphClient.users(userPrincId).mailFolders().byId(fol.id)).childFolders().buildRequest(new Option[0])).get();
        boolean isNextPageExists = false;
        List mailcurrentPage = null;
        ArrayList listFolderItems = new ArrayList();
        do {
            mailcurrentPage = iMailFolderCollectionPage2.getCurrentPage();
            listFolderItems.addAll(mailcurrentPage);
            if (iMailFolderCollectionPage2.getNextPage() == null) break;
            iMailFolderCollectionPage2 = (MailFolderCollectionPage)((MailFolderCollectionRequest)((MailFolderCollectionRequestBuilder)iMailFolderCollectionPage2.getNextPage()).buildRequest(new Option[0])).get();
        } while (listFolderItems.size() > 0 && (isNextPageExists = true));
        String parentPath1 = folderValueKeyMap.get(fol.id);
        if (StringUtils.isEmpty((String)parentPath1)) {
            String pathva = fol.displayName;
            if (!StringUtils.isEmpty((String)parentPath1)) {
                pathva = parentPath1 + "/" + fol.displayName;
            }
            logger.debug("..chi path.." + pathva);
            folderPathMap.put(pathva, fol.id);
            folderValueKeyMap.put(fol.id, pathva);
        }
        for (MailFolder chfol : listFolderItems) {
            String parentPath = folderValueKeyMap.get(fol.id);
            logger.debug("...parentPAth.." + chfol.displayName + "..." + parentPath);
            String path = CommonDownloadController.getPath(fol, chfol, parentPath);
            logger.debug("..childpath.. " + chfol.displayName + "..." + path);
            folderPathMap.put(path, chfol.id);
            folderValueKeyMap.put(chfol.id, path);
            if (chfol.childFolderCount <= 0) continue;
            CommonDownloadController.addChildFolders(sublistItems, folderPathMap, folderValueKeyMap, chfol, graphClient, userPrincId);
            sublistItems.addAll(listFolderItems);
        }
        sublistItems.addAll(listFolderItems);
    }

    public static String getRootFolderId(String userId) {
        String rootFolderId;
        block11: {
            rootFolderId = "";
            String siteUrl = "https://graph.microsoft.com/v1.0/users/" + userId + "/mailFolders/msgfolderroot";
            try {
                Request request1 = new Request.Builder().url(siteUrl).build();
                OkHttpClient okHttpClient = Graph.getInstance().getOkHttpClient();
                Call call1 = okHttpClient.newCall(request1);
                Response response1 = call1.execute();
                int responseCode1 = response1.code();
                System.out.println("...response code..." + responseCode1);
                String bodyStr = response1.body().string();
                System.out.println("...." + bodyStr);
                JSONObject jsonObject = new JSONObject(bodyStr);
                rootFolderId = (String)jsonObject.get("id");
            }
            catch (GraphServiceException e) {
                if (e.getResponseCode() != 429) break block11;
                logger.error(" ...inside GraphServiceException and 429 case... ");
                try {
                    Thread.sleep(120000L);
                }
                catch (InterruptedException okHttpClient) {
                    // empty catch block
                }
                boolean success = true;
                do {
                    try {
                        Request request1 = new Request.Builder().url(siteUrl).build();
                        OkHttpClient okHttpClient = Graph.getInstance().getOkHttpClient();
                        Call call1 = okHttpClient.newCall(request1);
                        Response response1 = call1.execute();
                        int responseCode1 = response1.code();
                        System.out.println("...response code..." + responseCode1);
                        String bodyStr = response1.body().string();
                        System.out.println("...." + bodyStr);
                        JSONObject jsonObject = new JSONObject(bodyStr);
                        rootFolderId = (String)jsonObject.get("id");
                        success = false;
                    }
                    catch (GraphServiceException ew) {
                        if (ew.getResponseCode() != 429) continue;
                        success = true;
                        try {
                            Thread.sleep(120000L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    catch (Exception eee) {
                        logger.error("...error trying to get ee..." + eee.getMessage());
                    }
                } while (success);
                logger.error("GraphServiceException....", (Throwable)e);
            }
            catch (Exception e) {
                logger.error("graph exception to delete:", (Throwable)e);
            }
        }
        return rootFolderId;
    }

    private static String getPath(MailFolder fol, MailFolder chfol, String parentPath) {
        String path = fol.displayName + "/" + chfol.displayName;
        if (!StringUtils.isEmpty((String)parentPath)) {
            path = parentPath + "/" + chfol.displayName;
        }
        return path;
    }

    private static List<String> getParentMailFolders(GraphServiceClient<Request> graphClient, String userId) {
        HashSet<String> parentPaths = new HashSet<String>();
        MailFolderCollectionPage mailFolderPage = (MailFolderCollectionPage)((MailFolderCollectionRequest)graphClient.users(userId).mailFolders().buildRequest(new Option[0])).select("id,displayName,parentFolderId").get();
        while (mailFolderPage != null) {
            List mailFolders = mailFolderPage.getCurrentPage();
            for (MailFolder folder : mailFolders) {
                parentPaths.add(folder.displayName);
            }
            MailFolderCollectionRequestBuilder nextPageRequestBuilder = (MailFolderCollectionRequestBuilder)mailFolderPage.getNextPage();
            mailFolderPage = nextPageRequestBuilder != null ? (MailFolderCollectionPage)((MailFolderCollectionRequest)nextPageRequestBuilder.buildRequest(new Option[0])).get() : null;
        }
        List<String> foldersToCheck = Arrays.asList("Contacts", "Calendar", "Yammer Root", "Outbox", "Journal", "Team Chat", "Files", "Companies", "PersonMetadata", "Feeds", "Inbound", "Outbound", "Recipient Cache", "Conversation History");
        List<String> folderNames = parentPaths.stream().filter(folderName -> foldersToCheck.stream().noneMatch(folderName::contains)).collect(Collectors.toList());
        logger.debug("...total folders.. " + folderNames.size());
        Collections.sort(folderNames);
        for (String entry : folderNames) {
            logger.debug("...all paths....." + entry);
        }
        return folderNames;
    }

    @RequestMapping(value={"versions/{versionNumber}/clouds/{cloudName}/onedrive/folders/{deviceUUID}"}, method={RequestMethod.GET})
    public ModelAndView getOneDriveFolders(@PathVariable(value="cloudName") String cloudName1, @PathVariable(value="deviceUUID") String deviceUUID, HttpServletRequest request, HttpServletResponse response) {
        ModelAndView modelAndView = new ModelAndView();
        response.setContentType("text/html; charset=UTF-8");
        String folderpath = request.getHeader("folderpath");
        logger.debug(folderpath + " head calling versions/{versionNumber}/clouds/{cloudName}/onedrive/folders/{deviceUUID}...  to get child folders of " + deviceUUID);
        try {
            Cloud cloud = this.utilService.getCloud(1);
            int cloudId = cloud.getCloudId();
            Device device = this.utilService.getDeviceForUUID(cloudId, deviceUUID);
            if (device == null) {
                response.setStatus(406);
                logger.error("...invalid device.....");
                return null;
            }
            GraphServiceClient<Request> graphClient = Graph.getInstance().getGraphClient();
            com.parablu.pcbd.domain.User user = this.utilService.getUserInfoByName(cloudId, device.getUserName());
            String emailId = user.getEmailId();
            List<String> folders = this.getFoldersForOneDrivePath(cloudId, emailId, folderpath, graphClient);
            modelAndView.addObject(folders);
            response.setStatus(200);
            return modelAndView;
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("...unable to get folders...." + e.getMessage());
            response.setStatus(500);
            return null;
        }
    }

    @RequestMapping(value={"versions/{versionNumber}/clouds/{cloudName}/site/folders/{deviceUUID}"}, method={RequestMethod.GET})
    public ModelAndView getSiteFolders(@PathVariable(value="cloudName") String cloudName1, @PathVariable(value="deviceUUID") String deviceUUID, HttpServletRequest request, HttpServletResponse response) {
        ModelAndView modelAndView = new ModelAndView();
        response.setContentType("text/html; charset=UTF-8");
        String folderpath = request.getHeader("folderpath");
        logger.debug(folderpath + " head calling versions/{versionNumber}/clouds/{cloudName}/site/folders/{deviceUUID}...  to get child folders of " + deviceUUID);
        try {
            Cloud cloud = this.utilService.getCloud(1);
            int cloudId = cloud.getCloudId();
            com.parablu.pcbd.domain.User user = null;
            Device device = this.utilService.getDeviceForUUID(cloudId, deviceUUID);
            if (device == null) {
                String deviceName = this.decodeBase64UTFString(deviceUUID);
                logger.debug("...device name check...." + deviceName);
                if (!StringUtils.isEmpty((String)deviceName)) {
                    user = this.utilService.getUserSite(cloudId, deviceName);
                }
            }
            if (device == null && user == null) {
                response.setStatus(406);
                logger.error("...invalid device.....");
                return null;
            }
            GraphServiceClient<Request> graphClient = Graph.getInstance().getGraphClient();
            if (user == null) {
                user = this.utilService.getUserInfoByName(cloudId, device.getUserName());
            }
            String siteId = user.getSiteId();
            logger.debug("...calling siteId...." + user.getSiteId());
            List<Object> folders = new ArrayList();
            ArrayList<String> listIds = new ArrayList<String>();
            HashMap<String, String> listMap = new HashMap<String, String>();
            String listId = "";
            String listName = "";
            try {
                logger.debug(cloud.getGraphApiEnabled() + "... before site..." + siteId);
                ListCollectionPage listCollectionPage = (ListCollectionPage)((ListCollectionRequest)Graph.getInstance().getGraphClient().sites(siteId).lists().buildRequest(new Option[0])).get();
                List currentListPageVal = null;
                ListCollectionRequestBuilder nextListPage = (ListCollectionRequestBuilder)listCollectionPage.getNextPage();
                do {
                    currentListPageVal = listCollectionPage.getCurrentPage();
                    for (com.microsoft.graph.models.List list : listCollectionPage.getCurrentPage()) {
                        if (!"documentLibrary".equals(list.list.template)) continue;
                        listIds.add(list.id);
                        listMap.put(list.id, list.name);
                        logger.debug(list.name + "....list.." + list.displayName + ".." + list.id);
                        if (!StringUtils.isEmpty((String)folderpath)) {
                            if (!folderpath.startsWith("/" + list.name) && !folderpath.startsWith(list.name)) continue;
                            listId = list.id;
                            listName = "/" + list.name;
                            continue;
                        }
                        folders.add(list.name);
                    }
                    nextListPage = (ListCollectionRequestBuilder)listCollectionPage.getNextPage();
                    if (nextListPage == null) continue;
                    listCollectionPage = (ListCollectionPage)((ListCollectionRequest)nextListPage.buildRequest(new Option[0])).get();
                } while (currentListPageVal.size() > 0 && nextListPage != null && listCollectionPage != null && nextListPage != null);
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.debug("..error..." + e.getMessage());
            }
            if (!StringUtils.isEmpty((String)folderpath)) {
                folders = CommonDownloadController.getFoldersForSitePathLatest(cloudId, siteId, listId, folderpath, graphClient, listName);
            }
            modelAndView.addObject(folders);
            response.setStatus(200);
            return modelAndView;
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("...unable to get folders...." + e.getMessage());
            response.setStatus(500);
            return null;
        }
    }

    @RequestMapping(value={"versions/{versionNumber}/clouds/{cloudName}/onedrive/folders"}, method={RequestMethod.GET})
    public ModelAndView getOneDriveFoldersForUserName(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        ModelAndView modelAndView = new ModelAndView();
        response.setContentType("text/html; charset=UTF-8");
        String folderpath = request.getHeader("folderpath");
        String userName = this.decodeBase64UTFString(request.getHeader("userName"));
        String c2cRestore = request.getHeader("c2cRestore");
        boolean c2cRestoreBool = false;
        if (!StringUtils.isEmpty((String)request.getHeader("folderpath"))) {
            folderpath = this.decodeBase64UTFString(request.getHeader("folderpath"));
        }
        if (!StringUtils.isEmpty((String)c2cRestore) && "true".equalsIgnoreCase(c2cRestore)) {
            c2cRestoreBool = true;
        }
        logger.debug(folderpath + " head calling versions/{versionNumber}/clouds/{cloudName}/onedrive/folders...  to get child folders of " + userName);
        try {
            Cloud cloud = this.utilService.getCloud(1);
            int cloudId = cloud.getCloudId();
            GraphServiceClient<Request> graphClient = null;
            if (cloud.getGraphApiEnabled() == 1) {
                graphClient = c2cRestoreBool ? OneDriveUtil.getC2CGraphClient() : Graph.getInstance().getGraphClient();
            }
            com.parablu.pcbd.domain.User user = this.utilService.getUserInfoByName(cloudId, userName);
            String emailId = user.getEmailId();
            List<String> folders = this.getFoldersForOneDrivePath(cloudId, emailId, folderpath, graphClient);
            modelAndView.addObject(folders);
            response.setStatus(200);
            return modelAndView;
        }
        catch (Exception e) {
            logger.error("...unable to get folders....", (Throwable)e);
            response.setStatus(500);
            return null;
        }
    }

    private List<String> getFoldersForOneDrivePath(int cloudId, String userMail, String path, GraphServiceClient<Request> graphClient) {
        ArrayList<String> folders = new ArrayList<String>();
        try {
            User userObj;
            User userFound = null;
            ArrayList<QueryOption> requestOptions = new ArrayList<QueryOption>();
            requestOptions.add(new QueryOption("$filter", (Object)("mail eq '" + userMail + "'")));
            UserCollectionPage iUserCollectionPage = (UserCollectionPage)((UserCollectionRequest)graphClient.users().buildRequest(requestOptions)).top(1).get();
            Iterator iterator = iUserCollectionPage.getCurrentPage().iterator();
            if (iterator.hasNext()) {
                userObj = (User)iterator.next();
                logger.debug(userObj.userPrincipalName + "... vals..." + userObj.givenName);
                userFound = userObj;
            }
            if (userFound == null) {
                requestOptions = new ArrayList();
                requestOptions.add(new QueryOption("$filter", (Object)("userPrincipalName eq '" + userMail + "'")));
                iUserCollectionPage = (UserCollectionPage)((UserCollectionRequest)graphClient.users().buildRequest(requestOptions)).top(1).get();
                iterator = iUserCollectionPage.getCurrentPage().iterator();
                if (iterator.hasNext()) {
                    userObj = (User)iterator.next();
                    logger.debug(userObj.userPrincipalName + "... vals..." + userObj.givenName);
                    userFound = userObj;
                }
            }
            if (userFound == null) {
                logger.error("... user not found ...");
                return new ArrayList<String>();
            }
            Drive drive = graphClient.users(userFound.id).drive().buildRequest(new Option[0]).get();
            String driveId = drive.id;
            DriveItem item = null;
            DriveItemCollectionPage iDriveItemCollectionPage = null;
            if (StringUtils.isEmpty((String)path) || path.equalsIgnoreCase("/")) {
                iDriveItemCollectionPage = (DriveItemCollectionPage)((DriveItemCollectionRequest)graphClient.drives(driveId).root().children().buildRequest(new Option[0])).get();
            } else {
                item = (DriveItem)graphClient.customRequest("/drives/" + driveId + "/root:/" + path, DriveItem.class).buildRequest(new Option[0]).get();
                iDriveItemCollectionPage = (DriveItemCollectionPage)((DriveItemCollectionRequest)graphClient.users(userFound.id).drive().items(item.id).children().buildRequest(new Option[0])).get();
            }
            if (iDriveItemCollectionPage != null) {
                List currentPage = iDriveItemCollectionPage.getCurrentPage();
                for (DriveItem driveItem : currentPage) {
                    if (driveItem.folder == null) continue;
                    logger.debug("..... items... " + driveItem.name);
                    folders.add(driveItem.name);
                }
            }
        }
        catch (GraphServiceException e) {
            logger.error(".... error trying to get folders... " + e.getMessage());
        }
        return folders;
    }

    private static List<String> getFoldersForOneDrivePath(String siteId, String driveId, String path, GraphServiceClient<Request> graphClient) {
        ArrayList<String> folders = new ArrayList<String>();
        try {
            DriveItem item = null;
            DriveItemCollectionPage iDriveItemCollectionPage = null;
            if (StringUtils.isEmpty((String)path) || path.equalsIgnoreCase("/")) {
                iDriveItemCollectionPage = (DriveItemCollectionPage)((DriveItemCollectionRequest)graphClient.sites(siteId).drives(driveId).root().children().buildRequest(new Option[0])).get();
            } else {
                item = (DriveItem)graphClient.customRequest("/drives/" + driveId + "/root:/" + path, DriveItem.class).buildRequest(new Option[0]).get();
                iDriveItemCollectionPage = (DriveItemCollectionPage)((DriveItemCollectionRequest)graphClient.sites(siteId).drives(driveId).items(item.id).children().buildRequest(new Option[0])).get();
            }
            if (iDriveItemCollectionPage != null) {
                List currentPage = iDriveItemCollectionPage.getCurrentPage();
                for (DriveItem driveItem : currentPage) {
                    if (driveItem.folder == null) continue;
                    logger.debug("..... items... " + driveItem.name);
                    folders.add(driveItem.name);
                }
            }
        }
        catch (GraphServiceException e) {
            logger.debug(".... error trying to get folders... " + e.getMessage());
        }
        return folders;
    }

    private List<String> getFoldersForSitePath(int cloudId, String siteId, String driveId, String path, GraphServiceClient<Request> graphClient) {
        ArrayList<String> folders = new ArrayList<String>();
        try {
            DriveItem item = null;
            DriveItemCollectionPage iDriveItemCollectionPage = null;
            logger.debug(path + "....driveid...." + driveId);
            if (StringUtils.isEmpty((String)path) || path.equalsIgnoreCase("/")) {
                iDriveItemCollectionPage = (DriveItemCollectionPage)((DriveItemCollectionRequest)graphClient.sites(siteId).drives(driveId).root().children().buildRequest(new Option[0])).get();
            } else {
                item = (DriveItem)graphClient.customRequest("/sites/" + siteId + "/drives/" + driveId + "/root:/" + path, DriveItem.class).buildRequest(new Option[0]).get();
                logger.debug(path + "....driveid...." + item.name);
                iDriveItemCollectionPage = (DriveItemCollectionPage)((DriveItemCollectionRequest)graphClient.sites(siteId).drives(driveId).items(item.id).children().buildRequest(new Option[0])).get();
            }
            if (iDriveItemCollectionPage != null) {
                List currentPage = iDriveItemCollectionPage.getCurrentPage();
                for (DriveItem driveItem : currentPage) {
                    if (driveItem.folder == null) continue;
                    logger.debug("..... items... " + driveItem.name);
                    folders.add(driveItem.name);
                }
            }
        }
        catch (GraphServiceException e) {
            logger.error(".... error trying to get folders... " + e.getMessage());
        }
        return folders;
    }

    private static List<String> getFoldersForSitePathLatest(int cloudId, String siteId, String listId, String path, GraphServiceClient<Request> graphClient, String listName) {
        ArrayList<String> folders = new ArrayList<String>();
        try {
            Object item = null;
            DriveItemCollectionPage iDriveItemCollectionPage = null;
            logger.debug(listId + "....path........" + path);
            logger.debug(listId + "....before path........" + path + "....listname..." + listName);
            if (!StringUtils.isEmpty((String)path)) {
                path = path.replaceAll("Shared Documents", "");
            }
            if (listName.startsWith("/")) {
                listName = listName.replaceFirst("/", "");
            }
            path = path.replaceFirst(listName, "");
            logger.debug(listId + "....after path........" + path + "....listname..." + listName);
            if (StringUtils.isEmpty((String)path) || path.equalsIgnoreCase("/")) {
                iDriveItemCollectionPage = (DriveItemCollectionPage)((DriveItemCollectionRequest)graphClient.sites(siteId).lists(listId).drive().root().children().buildRequest(new Option[0])).get();
            } else {
                ListItem listItem = (ListItem)graphClient.customRequest("/sites/" + siteId + "/lists/" + listId + "/drive/root:/" + path, ListItem.class).buildRequest(new Option[0]).get();
                logger.debug(listItem.id + "....." + siteId + "...dri..." + listItem.name);
                iDriveItemCollectionPage = (DriveItemCollectionPage)((DriveItemCollectionRequest)graphClient.sites(siteId).lists(listId).drive().items(listItem.id).children().buildRequest(new Option[0])).get();
            }
            if (iDriveItemCollectionPage != null) {
                List currentPage = iDriveItemCollectionPage.getCurrentPage();
                for (DriveItem driveItem : currentPage) {
                    if (driveItem.folder == null) continue;
                    logger.debug("..... items... " + driveItem.name);
                    folders.add(driveItem.name);
                }
            }
        }
        catch (GraphServiceException e) {
            logger.debug(".... error trying to get folders... " + e.getMessage());
        }
        return folders;
    }

    @RequestMapping(value={"/cloud/{cloudName}/get/fileAsStream/"}, method={RequestMethod.GET})
    public void writeFileInResponse(@PathVariable(value="cloudName") String cloudName, HttpServletRequest request, HttpServletResponse response) {
        String fullyQualifiedPath = request.getParameter("file-download-path");
        String browserType = "";
        browserType = request.getParameter("browser-type");
        try {
            if (StringUtils.isEmpty((String)fullyQualifiedPath)) {
                return;
            }
            fullyQualifiedPath = this.decodeBase64UTFString(fullyQualifiedPath);
            logger.debug("calling the api.....get/fileAsStream dwonload path:" + fullyQualifiedPath);
            File file = new File(fullyQualifiedPath);
            if (!file.exists()) {
                return;
            }
            String encodedFileName = URLEncoder.encode(file.getName(), StandardCharsets.UTF_8.toString());
            if (browserType.contains("Firefox")) {
                response.setHeader("Content-Disposition", "attachment; filename*=UTF-8''" + encodedFileName);
            } else if (browserType.contains("Chrome")) {
                response.setHeader("Content-Disposition", "attachment; filename=" + encodedFileName);
            } else {
                response.setHeader("Content-Disposition", "attachment; filename=\"" + encodedFileName + "\"");
            }
            response.addHeader("Content-Transfer-Encoding", "binary");
            response.addHeader("Content-Length", String.valueOf(file.length()));
            response.setStatus(200);
            try {
                logger.debug("beofre writng  the file.." + file.getAbsolutePath());
                this.writeDataToStream(file, response);
            }
            catch (IOException e) {
                logger.error("could not wrote file.. ", (Throwable)e);
                response.setStatus(500);
            }
        }
        catch (Exception e) {
            logger.error("exception writinr the file", (Throwable)e);
            response.setStatus(500);
        }
    }

    private void writeDataToStream(File file, HttpServletResponse response) throws IOException {
        try {
            int buff;
            FileInputStream fis = new FileInputStream(file);
            BufferedInputStream fif = new BufferedInputStream(fis);
            byte[] b = new byte[4096];
            while ((buff = ((InputStream)fif).read(b)) != -1) {
                response.getOutputStream().write(b, 0, buff);
                response.getOutputStream().flush();
            }
            ((InputStream)fif).close();
            logger.debug("finished writing to stream file...." + file.getName());
            file.delete();
            logger.debug("deleting  file  under path ....." + file.getPath());
        }
        catch (Exception e) {
            logger.debug("Exception   " + e);
            logger.error("Exception   " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/cloud/{cloudName}/download/folderAsPst/"}, method={RequestMethod.GET})
    public void downloadPst(@PathVariable(value="cloudName") String cloudName, HttpServletRequest request, HttpServletResponse response) {
        InputStream inputStream = null;
        String browserType = request.getHeader("user-agent");
        logger.debug(".......download as pst...." + request.getHeader("pstName"));
        try {
            String fileName = "";
            String syncRevisionId = "";
            String userName = "";
            String sourceDeviceUUID = "";
            boolean isFolder = false;
            boolean isSync = false;
            Map parameters = request.getParameterMap();
            String batchId = "";
            String pstName = request.getHeader("pstName");
            syncRevisionId = request.getHeader("syncRevisionId");
            boolean isrestoreDeletedFile = false;
            String restoreDeletedFileStr = request.getParameter("restoreDeletedFile");
            if (!StringUtils.isEmpty((String)restoreDeletedFileStr)) {
                isrestoreDeletedFile = Boolean.valueOf(restoreDeletedFileStr);
                logger.debug("...isrestoreDeletedFile..........." + isrestoreDeletedFile);
            }
            for (String key : parameters.keySet()) {
                String[] vals;
                logger.debug("....key...." + key);
                for (String val : vals = (String[])parameters.get(key)) {
                    logger.debug("....val...." + val);
                    if ("fileName".equalsIgnoreCase(key)) {
                        fileName = val;
                    }
                    if ("syncRevisionId".equalsIgnoreCase(key)) {
                        syncRevisionId = val;
                    }
                    if ("userName".equalsIgnoreCase(key)) {
                        userName = val;
                        userName = this.decodeBase64UTFString(userName);
                    }
                    if ("isFolder".equalsIgnoreCase(key)) {
                        isFolder = Boolean.parseBoolean(val);
                    }
                    if ("isSync".equalsIgnoreCase(key)) {
                        isSync = Boolean.parseBoolean(val);
                    }
                    if ("deviceUUID".equalsIgnoreCase(key)) {
                        sourceDeviceUUID = val;
                    }
                    if ("batchId".equalsIgnoreCase(key)) {
                        batchId = val;
                    }
                    if (!"pstName".equalsIgnoreCase(key)) continue;
                    pstName = val;
                }
            }
            int cloudId = 1;
            String backupId = syncRevisionId;
            DownloadFileTO downloadFileTO = this.getRequestParameters(request, cloudName);
            downloadFileTO.setBackupID(backupId);
            downloadFileTO.setDeviceUUID(sourceDeviceUUID);
            logger.debug(backupId + " Filename ..." + downloadFileTO.getFileName());
            logger.debug(batchId + "  DOWNLOAD FILE  STARTED for portal1 ...." + pstName);
            String deviceUUID = "Portal";
            DownloadTO downloadTO = null;
            if (!StringUtils.isEmpty((String)batchId)) {
                PstBatch pstBatch = this.utilService.getPstBatch(batchId);
                sourceDeviceUUID = pstBatch.getDeviceUUID();
                downloadFileTO.setDeviceUUID(sourceDeviceUUID);
                if (!StringUtils.isEmpty((String)pstName)) {
                    downloadFileTO.setFileName(pstName);
                } else {
                    downloadFileTO.setFileName(userName + "_search_results");
                }
                logger.debug(pstName + "..pstbatch...." + pstBatch.getDeviceUUID());
            }
            String saltKey = this.utilService.getEncryptionKey(1, "backup");
            Cloud cloud = this.utilService.getCloud(1);
            response.addHeader("Pragma", "public");
            response.addHeader("Expires", String.valueOf(200));
            response.addHeader("Cache-Control", "must-revalidate, post-check=0, pre-check=0");
            Device device = this.utilService.getDeviceForUUID(cloudId, sourceDeviceUUID);
            BackUpImage backUpImage = null;
            String dowloadFile = downloadFileTO.getFileName() + ".pst";
            if (!StringUtils.isEmpty((String)backupId)) {
                if (!backupId.contains(",")) {
                    backUpImage = this.utilService.getBackupImageFile(cloudId, backupId, device);
                    if (backUpImage != null && dowloadFile.equalsIgnoreCase(".pst")) {
                        downloadFileTO.setFileName(backUpImage.getFileName());
                        dowloadFile = backUpImage.getFileName() + ".pst";
                    }
                } else {
                    backUpImage = null;
                    downloadFileTO.setFileName(device.getUserName());
                    dowloadFile = device.getUserName() + ".pst";
                }
            }
            if (backUpImage != null && !backUpImage.isFolder()) {
                dowloadFile = backUpImage.getFileName() + ".pst";
                downloadFileTO.setFileName(backUpImage.getFileName());
            }
            if (!StringUtils.isEmpty((String)pstName)) {
                downloadFileTO.setFileName(pstName);
            }
            if (browserType.contains("Firefox")) {
                response.setHeader("Content-Disposition", "attachment; filename*=UTF-8''" + dowloadFile);
            } else if (browserType.contains("Chrome")) {
                response.setHeader("Content-Disposition", "attachment; filename=" + dowloadFile);
            } else {
                response.setHeader("Content-Disposition", "attachment; filename=\"" + dowloadFile + "\"");
            }
            response.addHeader("Content-Transfer-Encoding", "binary");
            response.addHeader("filename", dowloadFile);
            response.addHeader("Content-Transfer-Encodingsdasda", "binary");
            response.setContentType("application/octet-stream");
            downloadTO = this.downloadFolderAsPst(cloud, userName, downloadFileTO.getFileName(), downloadFileTO.getFilePath(), saltKey, deviceUUID, response, browserType, downloadFileTO, batchId, isrestoreDeletedFile);
            response.addHeader("file-download-path", downloadTO.getPath());
            logger.debug("header name....." + response.getHeader("file-download-path"));
            logger.debug("header name....." + response.getHeader("filename"));
            response.setStatus(200);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("error trying to download folder..." + e);
            response.setStatus(500);
        }
        finally {
            IOUtils.closeQuietly(inputStream);
        }
        logger.debug(" end of  download file  Completed for portal ....");
    }

    private DownloadTO downloadFolderAsPst(Cloud cloud, String userName, String fileName, String filePath, String saltKey, String deviceUUID, HttpServletResponse response, String browserType, DownloadFileTO downloadFileTO, String pstBatchId, boolean isrestoreDeletedFile) {
        return this.downloadService.downloadPstBackupFolderForPortal(downloadFileTO, cloud, response, browserType, pstBatchId, isrestoreDeletedFile);
    }

    private boolean isODBEnabled(List<CloudCustomisableDetails> licenseDetails) {
        boolean isODBEnabled = false;
        for (CloudCustomisableDetails license : licenseDetails) {
            if (license == null || !"ODB Enabled".equalsIgnoreCase(license.getName())) continue;
            isODBEnabled = true;
            break;
        }
        return isODBEnabled;
    }

    @RequestMapping(value={"/cloud/{cloudName}/createSites/"}, method={RequestMethod.GET})
    public ModelAndView createLatestSites(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        logger.debug(".....start of /cloud/{cloudName}/createSites/ ... ");
        try {
            Cloud cloud = this.utilService.getCloud(1);
            int cloudId = cloud.getCloudId();
            Graph graph = Graph.getInstance();
            GraphServiceClient<Request> graphClient = graph.getGraphClient();
            SiteCollectionPage siteCollectionPage = (SiteCollectionPage)((SiteCollectionRequest)graphClient.sites().buildRequest(new Option[0])).get();
            String siteId = "";
            List currentPageVal = null;
            SiteCollectionRequestBuilder nextPage = (SiteCollectionRequestBuilder)siteCollectionPage.getNextPage();
            HashMap<String, String> siteMap = new HashMap<String, String>();
            HashMap<String, String> siteDispMap = new HashMap<String, String>();
            do {
                currentPageVal = siteCollectionPage.getCurrentPage();
                for (Site site : siteCollectionPage.getCurrentPage()) {
                    if (!site.webUrl.contains("sites/")) continue;
                    logger.debug(site.name + "....insidennn..." + site.displayName + "...s" + site.description);
                    Iterator siteName = site.name;
                    String siteUrlName = StringUtils.substringAfterLast((String)site.webUrl, (String)"sites/");
                    siteUrlName = URLDecoder.decode(siteUrlName);
                    siteUrlName = StringEscapeUtils.unescapeHtml3((String)siteUrlName);
                    logger.debug(siteUrlName + "....siteurlname..." + (String)((Object)siteName));
                    if (((String)((Object)siteName)).equalsIgnoreCase(siteUrlName)) {
                        siteMap.put(site.name, site.id);
                        siteDispMap.put(site.id, site.name);
                    } else {
                        siteMap.put(siteUrlName, site.id);
                        siteDispMap.put(site.id, site.name);
                    }
                    siteId = site.id;
                    logger.debug(site.webUrl + "..foundsite..." + siteId);
                }
                nextPage = (SiteCollectionRequestBuilder)siteCollectionPage.getNextPage();
                if (nextPage == null) continue;
                siteCollectionPage = (SiteCollectionPage)((SiteCollectionRequest)nextPage.buildRequest(new Option[0])).get();
            } while (currentPageVal.size() > 0 && nextPage != null && siteCollectionPage != null && nextPage != null);
            logger.debug("...after iteration...." + siteMap.size());
            List<com.parablu.pcbd.domain.User> usersWithoutDeviceList = this.utilService.getExistingSites(cloud.getCloudId());
            logger.debug("...after getExistingSites...." + siteMap.size());
            HashSet<String> userSet = new HashSet<String>();
            if (!CollectionUtils.isEmpty(usersWithoutDeviceList)) {
                for (com.parablu.pcbd.domain.User user : usersWithoutDeviceList) {
                    try {
                        if (user == null) continue;
                        userSet.add(user.getUserName());
                        siteMap.remove(user.getUserName());
                    }
                    catch (Exception exception) {}
                }
            } else {
                logger.debug("....no existing sites.....");
            }
            logger.debug("...before iteration...." + siteMap.size());
            for (Map.Entry site : siteMap.entrySet()) {
                logger.debug((String)siteDispMap.get(site.getValue()) + "...iterating sit ...." + (String)site.getKey());
                com.parablu.pcbd.domain.User siteUser = new com.parablu.pcbd.domain.User();
                siteUser.setUserName((String)site.getKey());
                siteUser.setSite(true);
                siteUser.setSiteId((String)site.getValue());
                siteUser.setUserNameLowerCase(((String)site.getKey()).toLowerCase());
                siteUser.setDisplayName((String)siteDispMap.get(site.getValue()));
                siteUser.setActive(true);
                siteUser.setBackupEnabled(true);
                siteUser.setSpPolicyName("STATISTICS_SP_POLICY");
                siteUser.setCreatedTimestamp("" + System.currentTimeMillis());
                siteUser.setLastModifiedTimestamp(Long.toString(System.currentTimeMillis()));
                logger.debug((String)siteDispMap.get(siteUser.getUserName()) + "...dispvalues...." + siteUser.getDisplayName());
                this.utilService.createSite(cloud.getCloudId(), siteUser);
            }
            response.setStatus(200);
            SiteElement siteElement = this.utilService.getExistingSiteElement(cloudId);
            modelAndView.addObject((Object)siteElement);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("...unable to get folders...." + e.getMessage());
            response.setStatus(500);
        }
        logger.debug(".....end of /cloud/{cloudName}/createSites/ ... ");
        return modelAndView;
    }

    private String constructActionOnUser(Device sourceDevice, Device destinationDevice, RestoreEventsElement restoreEventsElement, boolean cpSavings) {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            if (StringUtils.isEmpty((String)restoreEventsElement.getDestinationDeviceUUID())) {
                if (restoreEventsElement.isGlobalSearch()) {
                    stringBuilder.append("source - [Global Search] ");
                } else {
                    stringBuilder.append("source - [user: ").append(sourceDevice.getUserName()).append("] [asset Name: ").append(sourceDevice.getDeviceName()).append("]} ");
                    stringBuilder.append("restore source path - [");
                    if (restoreEventsElement.getFileElement().getFileName().isEmpty()) {
                        stringBuilder.append("export complete mailbox] ");
                    } else {
                        stringBuilder.append(restoreEventsElement.getFileElement().getFileName()).append("] ");
                    }
                }
                stringBuilder.append("with pst file name - [");
                if (restoreEventsElement.getFileElement().getFileCompletePath().isEmpty()) {
                    stringBuilder.append(restoreEventsElement.getFileElement().getFileName());
                } else {
                    stringBuilder.append(this.decodeBase64UTFString(restoreEventsElement.getFileElement().getFileCompletePath()));
                }
                stringBuilder.append("]");
            } else {
                if (destinationDevice.getDeviceType().equals(Device.TYPE.SHAREPOINT.toString())) {
                    stringBuilder.append("{Source - [Asset Name: ").append(sourceDevice.getDeviceName()).append("]} ");
                    stringBuilder.append("{Destination - [Asset Name: ").append(destinationDevice.getDeviceName()).append("]} ");
                } else {
                    stringBuilder.append("{Source - [User: ").append(sourceDevice.getUserName()).append("] [Asset Name: ").append(sourceDevice.getDeviceName()).append("]} ");
                    stringBuilder.append("{Destination - [User: ").append(destinationDevice.getUserName()).append("] [Asset Name: ").append(destinationDevice.getDeviceName()).append("]} ");
                }
                if (!cpSavings) {
                    stringBuilder.append("{Restore Source Path: ");
                    if (restoreEventsElement.getFileElement().getFileCompletePath().isEmpty()) {
                        stringBuilder.append("All Drives} ");
                    } else {
                        stringBuilder.append(restoreEventsElement.getFileElement().getFileCompletePath()).append("} ");
                    }
                    if (!restoreEventsElement.isInPlaceRestore()) {
                        stringBuilder.append("{Restore Destination Path: ").append(restoreEventsElement.getDestinationPath()).append("} ");
                    }
                }
                if (cpSavings) {
                    stringBuilder.append("{Restore Destination Path: ").append(restoreEventsElement.getDestinationPath()).append("} ");
                    if (!StringUtils.isEmpty((String)restoreEventsElement.getFileElement().getFileName())) {
                        stringBuilder.append("with file name - [");
                        stringBuilder.append(restoreEventsElement.getFileElement().getFileName());
                    } else {
                        stringBuilder.append(restoreEventsElement.getFileElement().getFileCompletePath());
                    }
                }
                stringBuilder.append("]");
                if (!cpSavings) {
                    stringBuilder.append("{Properties: ");
                    stringBuilder.append("[Disallow new backups during this restore: ").append(restoreEventsElement.isSuspendBackup()).append("] ");
                    stringBuilder.append("[In place Restore: ").append(restoreEventsElement.isInPlaceRestore()).append("] ");
                    if (restoreEventsElement.getRestoreDataBefore() != 0L) {
                        Date date = new Date(restoreEventsElement.getRestoreDataBefore());
                        stringBuilder.append("[Restore Before: ").append(date).append("]");
                    }
                    if (!destinationDevice.getDeviceType().equals(Device.TYPE.SHAREPOINT.toString())) {
                        stringBuilder.append("[Restore Links: ").append(restoreEventsElement.isInPlaceRestore()).append("]");
                    }
                    stringBuilder.append("[Restore Deleted Files: ").append(restoreEventsElement.isRestoreDeletedFiles()).append("]");
                    stringBuilder.append("}");
                }
            }
        }
        catch (Exception e) {
            logger.error("Failed to construct Audit History" + e.getMessage());
            e.printStackTrace();
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/cloud/{cloudName}/download/pstFile/"}, method={RequestMethod.GET})
    public void downloadPstFileForPortal(@PathVariable(value="cloudName") String cloudName, HttpServletRequest request, HttpServletResponse response) {
        String browserType = request.getParameter("user-agent");
        String fileName = request.getParameter("fileName");
        String loginUserName = request.getParameter("loginUserName");
        Cloud cloud = this.utilService.getCloud(1);
        fileName = this.decodeBase64UTFString(fileName);
        loginUserName = this.decodeBase64UTFString(loginUserName);
        logger.debug(browserType + "...param values..." + fileName);
        InputStream inputStream = null;
        try {
            response.addHeader("Pragma", "public");
            response.addHeader("Expires", String.valueOf(200));
            response.addHeader("Cache-Control", "must-revalidate, post-check=0, pre-check=0");
            if (browserType.contains("Firefox")) {
                response.setHeader("Content-Disposition", "attachment; filename*=UTF-8''" + fileName);
            } else if (browserType.contains("Chrome")) {
                response.setHeader("Content-Disposition", "attachment; filename=" + fileName);
            } else {
                response.setHeader("Content-Disposition", "attachment; filename=\"" + fileName + "\"");
            }
            response.addHeader("Content-Transfer-Encoding", "binary");
            response.addHeader("filename", fileName);
            response.addHeader("Content-Transfer-Encodingsdasda", "binary");
            this.writeDataToStreamForPg(response, fileName, loginUserName);
            response.setContentType("application/octet-stream");
            AuditHistory auditHistory = new AuditHistory();
            auditHistory.setAction("Downloaded pst");
            auditHistory.setActionByUserName(loginUserName);
            auditHistory.setActionOnObject("file name: " + fileName);
            auditHistory.setTimestamp(System.currentTimeMillis());
            auditHistory.setActionUsingObject("Portal");
            auditHistory.setActionType(4);
            logger.debug("Action type" + auditHistory.getActionType());
            this.utilService.saveAudit(cloud.getCloudId(), auditHistory);
            response.setStatus(200);
        }
        catch (ParacloudBackupException e) {
            logger.trace("" + (Object)((Object)e));
            logger.debug(" File not found during download  ...." + e.getMessage());
            response.setStatus(449);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.trace("" + e);
            logger.error("  UNALBE TO DOWNLOAD FILE " + e.getMessage());
            response.setStatus(500);
        }
        finally {
            IOUtils.closeQuietly(inputStream);
        }
        logger.debug(" end of  download file  Completed for portal ....");
    }

    private void writeDataToStreamForPg(HttpServletResponse response, String fileName, String userName) throws IOException {
        int buff;
        logger.debug("....sending file....." + fileName);
        FileInputStream fifTemp = new FileInputStream(new File("/parablu/Downloads/" + userName.toLowerCase() + "/" + fileName));
        byte[] b = new byte[4096];
        while ((buff = ((InputStream)fifTemp).read(b)) != -1) {
            response.getOutputStream().write(b, 0, buff);
            response.getOutputStream().flush();
        }
        ((InputStream)fifTemp).close();
        logger.debug("...finished file" + fileName);
    }

    @RequestMapping(value={"/cloud/{cloudName}/restore/mail/attach/"}, method={RequestMethod.GET})
    public void inPlaceRestoreForMailWithAttachments(@PathVariable(value="cloudName") String cloudName, HttpServletRequest request, HttpServletResponse response) {
        logger.debug(" ... start of /cloud/{cloudName}/restore/mail/attach/  ....");
        String browserType = request.getHeader("user-agent");
        try {
            String userMail;
            boolean isSync = false;
            String isSyncFlag = request.getParameter("isSync");
            DownloadFileTO downloadFileTO = this.getRequestParameters(request, cloudName);
            String loginUserName = request.getParameter("loginUserName");
            String attachName = request.getParameter("attachName");
            String mailFoldPath = request.getParameter("mailFoldPath");
            String customPath = request.getParameter("customPath");
            if (!StringUtils.isEmpty((String)loginUserName)) {
                loginUserName = this.decodeBase64UTFString(loginUserName);
            }
            String userName = downloadFileTO.getUserName();
            logger.debug(attachName + "...loginUserName..." + loginUserName + "...." + userName);
            String backupId = request.getParameter("backupID");
            logger.debug(userName + "...backupID....." + backupId);
            if (!StringUtils.isEmpty((String)isSyncFlag)) {
                isSync = Boolean.parseBoolean(isSyncFlag);
                downloadFileTO.setSync(isSync);
            } else {
                response.setStatus(400);
            }
            String deviceUUID = request.getParameter("deviceUUID");
            if (StringUtils.isEmpty((String)deviceUUID)) {
                deviceUUID = request.getHeader("deviceUUID");
            }
            Cloud cloud = this.utilService.getCloud(1);
            com.parablu.pcbd.domain.User user = this.utilService.getUserInfoByName(1, userName);
            if (!StringUtils.isEmpty((String)mailFoldPath)) {
                mailFoldPath = this.decodeBase64UTFString(mailFoldPath);
            }
            logger.debug(mailFoldPath + "....userlatest..... " + user.getUserName());
            logger.debug(mailFoldPath + "...mailFoldPath-customPath....." + customPath);
            int cloudId = cloud.getCloudId();
            BackupFile backupFile = this.downloadService.getBackupFileForId(cloudId, userName, backupId);
            if (backupFile == null) {
                logger.error(".... mail does not exists.... ");
                response.setStatus(507);
                return;
            }
            Device device = this.utilService.getDeviceForUUID(cloudId, deviceUUID);
            BackUpImage bkpImage = this.utilService.getBackupImageFile(cloudId, backupId, device);
            String mailUserName = userMail = user.getEmailId();
            Map<String, String> existingFolders = new HashMap<String, String>();
            String path = bkpImage.getDevicePath();
            String orgPath = bkpImage.getDevicePath();
            if (!StringUtils.isEmpty((String)mailFoldPath)) {
                orgPath = mailFoldPath;
            }
            boolean pathChanged = false;
            if (orgPath.startsWith("/")) {
                orgPath = orgPath.replaceFirst("/", "");
            }
            if (orgPath.endsWith("/")) {
                orgPath = orgPath.substring(0, orgPath.lastIndexOf("/"));
            }
            if (!orgPath.equalsIgnoreCase(bkpImage.getDevicePath())) {
                pathChanged = true;
            }
            logger.debug("..pathchanged....." + orgPath + "....." + bkpImage.getDevicePath() + "......" + pathChanged);
            ExchangeService service = null;
            String idForFolder = "";
            try {
                String exiFolder = orgPath;
                do {
                    try {
                        EWSAppSetting appSetting = this.utilService.getEwsAppSettingDetail(cloudId);
                        this.getEWSAccesToken(appSetting, false);
                        String token = this.ewsToken;
                        logger.debug(mailUserName + "...got-ewstoken...." + token);
                        service = CommonDownloadController.getAuthenticatedService(token, mailUserName);
                        existingFolders = this.getExistingFolders(service, mailUserName, false);
                        idForFolder = CommonDownloadController.getKeyFromValue(existingFolders, exiFolder);
                        if (StringUtils.isEmpty((String)idForFolder)) {
                            logger.debug("....create folder....." + exiFolder);
                            this.createFoldersInMail(service, existingFolders, exiFolder, mailUserName, false);
                            existingFolders = new HashMap();
                            existingFolders = this.getExistingFolders(service, mailUserName, false);
                            idForFolder = CommonDownloadController.getKeyFromValue(existingFolders, exiFolder);
                        }
                    }
                    catch (Exception e) {
                        logger.error("....unable to create folder so retry....");
                        this.createFoldersInMail(service, existingFolders, exiFolder, mailUserName, false);
                        existingFolders = new HashMap();
                        existingFolders = this.getExistingFolders(service, mailUserName, false);
                        idForFolder = CommonDownloadController.getKeyFromValue(existingFolders, exiFolder);
                    }
                    logger.debug(exiFolder + "... exist id exists .. " + idForFolder);
                } while (StringUtils.isEmpty((String)idForFolder));
            }
            catch (Exception e) {
                this.createFoldersInMail(service, existingFolders, path, mailUserName);
                existingFolders = new HashMap();
                existingFolders = this.getExistingFolders(service, mailUserName, false);
                idForFolder = CommonDownloadController.getKeyFromValue(existingFolders, path);
            }
            logger.debug(backupFile.getFilePath() + "... exist id exists  .. " + idForFolder);
            OfficeBackupPolicy officeBackupPolicy = this.utilService.getOfficeBackupPolicyForUser(cloudId, device.getUserName(), device.getDeviceType());
            String userId = this.getUserId(mailUserName);
            this.syncDownloadService.inPlaceRestoreAttachmentForExchangeFromCloud(cloud, userName, mailUserName, backupFile, idForFolder, device.getDestCollection(), false, userId, false, officeBackupPolicy, bkpImage.getOdItemId(), true, true, mailFoldPath, pathChanged);
            logger.debug(mailFoldPath + "...oditemid.... " + bkpImage.getId().toString());
            RestoreEventsElement restoreEventsElement = new RestoreEventsElement();
            FileElement fileElement = new FileElement();
            fileElement.setFileCompletePath(path);
            restoreEventsElement.setDestinationDeviceUUID(device.getDeviceUUID());
            fileElement.setFileName(bkpImage.getDevicePath() + "/" + backupFile.getFileName());
            restoreEventsElement.setFileElement(fileElement);
            restoreEventsElement.setDestinationPath(mailFoldPath);
            String actionOnUser = this.constructActionOnUser(device, device, restoreEventsElement, true);
            logger.debug(mailFoldPath + "...mail restore...." + path);
            this.utilService.saveStatisticToDatabase(cloud.getCloudId(), cloudName, "initiated restore for", loginUserName, actionOnUser, "Portal", System.currentTimeMillis(), 92);
            response.setStatus(200);
        }
        catch (Exception e) {
            logger.error("..... UNALBE TO INITIATE A RESTORE .... " + e.getMessage());
            response.setStatus(500);
        }
        logger.debug(" ... end of inplace restore mail  ....");
    }

    private void createFoldersInMail(ExchangeService service, Map<String, String> existingFolders, String exiFolder, String userMail, boolean isInplace) {
        logger.debug("..... aaa-exiFolder.... " + exiFolder);
        Path pathsp = Paths.get(exiFolder, new String[0]);
        String[] paths = (String[])StreamSupport.stream(pathsp.spliterator(), false).map(Path::toString).toArray(String[]::new);
        String checkPath = "";
        boolean isParent = false;
        EWSAppSetting appSetting = this.utilService.getEwsAppSettingDetail(1);
        this.getEWSAccesToken(appSetting, false);
        String token = this.ewsToken;
        service = CommonDownloadController.getAuthenticatedService(token, userMail);
        existingFolders = new HashMap<String, String>();
        existingFolders = this.getExistingFolders(service, userMail, isInplace);
        for (String folPath : paths) {
            logger.debug(checkPath + "..... aaa .... " + folPath);
            if (!StringUtils.isEmpty((String)checkPath)) {
                checkPath = checkPath + "/" + folPath;
            } else {
                checkPath = folPath;
                isParent = true;
            }
            boolean pathExists = existingFolders.containsValue(checkPath);
            logger.debug(checkPath + ".....pathexists.... " + pathExists);
            if (!pathExists) {
                try {
                    existingFolders = new HashMap<String, String>();
                    existingFolders = this.getExistingFolders(service, userMail, isInplace);
                    pathExists = existingFolders.containsValue(checkPath);
                    if (pathExists) continue;
                    if (isParent) {
                        logger.debug("....parent....." + checkPath);
                        Folder folder = new Folder(service);
                        folder.setDisplayName(checkPath.replaceAll("/", ""));
                        Mailbox userMailboxObj = new Mailbox(userMail);
                        FolderId parentId = new FolderId(WellKnownFolderName.MsgFolderRoot, userMailboxObj);
                        service.createFolder(folder, parentId);
                    } else {
                        String parentpath = checkPath.substring(0, checkPath.lastIndexOf(47));
                        String child = checkPath.substring(checkPath.lastIndexOf("/"));
                        logger.debug(parentpath + "....child....." + child);
                        logger.debug(parentpath + "..parentpathandchild.." + child);
                        logger.debug(parentpath + "..parentpathandchild22.." + child);
                        Folder folder = new Folder(service);
                        logger.debug(child.replaceAll("/", "") + "....child foldername..." + child);
                        folder.setDisplayName(child.replaceAll("/", ""));
                        FolderId parentId = new FolderId();
                        String keyFromValue = CommonDownloadController.getKeyFromValue(existingFolders, parentpath);
                        logger.debug(child + "...createdfolder....." + parentpath + child);
                        logger.debug(keyFromValue + "...wait for 20 sec...");
                        parentId.setUniqueId(keyFromValue);
                        service.createFolder(folder, parentId);
                        logger.debug("...createdfolder1....." + parentpath + child);
                        logger.debug("...wait for 20 sec...");
                    }
                    Thread.sleep(20000L);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                    if (e1.getMessage().contains("The remote server returned an error: (401)Unauthorized")) {
                        this.getEWSAccesToken(appSetting, true);
                        token = this.ewsToken;
                        service = CommonDownloadController.getAuthenticatedService(token, userMail);
                    }
                    logger.error("... ERRORR...... " + e1.getMessage());
                }
            }
            isParent = false;
        }
    }

    private void getEWSAccesToken(EWSAppSetting ewsAppSetting, boolean getFresh) {
        logger.debug("getEWSAccesToken....");
        try {
            if (getFresh) {
                this.utilService.updateEWSToken(1);
                this.ewsToken = this.utilService.getEWSToken(1);
            }
            if (this.ewsToken == null) {
                this.ewsToken = this.utilService.getEWSToken(1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Error getting ews token......", (Throwable)e);
        }
    }

    private String getUserId(String mailUserName) {
        String emailId = mailUserName;
        String userId = "";
        User userFound = null;
        ArrayList<QueryOption> requestOptions = new ArrayList<QueryOption>();
        requestOptions.add(new QueryOption("$filter", (Object)("mail eq '" + emailId + "'")));
        UserCollectionPage iUserCollectionPage = (UserCollectionPage)((UserCollectionRequest)Graph.getInstance().getGraphClient().users().buildRequest(requestOptions)).top(1).get();
        for (User userObjVal : iUserCollectionPage.getCurrentPage()) {
            logger.debug(userObjVal.userPrincipalName + "... user val..." + userObjVal.givenName);
            if (!emailId.equalsIgnoreCase(userObjVal.mail) || !emailId.equalsIgnoreCase(userObjVal.userPrincipalName)) continue;
            userFound = userObjVal;
            break;
        }
        if (userFound == null) {
            for (User user : iUserCollectionPage.getCurrentPage()) {
                if (!emailId.equalsIgnoreCase(user.mail)) continue;
                userFound = user;
                break;
            }
        }
        userId = userFound.id;
        return userId;
    }

    private static Map<String, String> addInPlaceArchiveFolders(ExchangeService service, String userMail) {
        HashedMap existingFolders = new HashedMap();
        Mailbox userMailbox = new Mailbox(userMail);
        String uniqId = "";
        try {
            Folder archfolder = Folder.bind((ExchangeService)service, (WellKnownFolderName)WellKnownFolderName.ArchiveMsgFolderRoot);
            uniqId = archfolder.getId().getUniqueId();
            existingFolders.put("In-Place Archive", uniqId);
            FolderId folderId = new FolderId(WellKnownFolderName.ArchiveMsgFolderRoot, userMailbox);
            FindFoldersResults inPlaceFolders = service.findFolders(folderId, new FolderView(Integer.MAX_VALUE));
            for (Folder folder : inPlaceFolders.getFolders()) {
                if (StringUtils.isEmpty((String)folder.getDisplayName()) || "PersonMetadata".equalsIgnoreCase(folder.getDisplayName()) || "Tasks".equalsIgnoreCase(folder.getDisplayName()) || "ExternalContacts".equalsIgnoreCase(folder.getDisplayName()) || "Files".equalsIgnoreCase(folder.getDisplayName()) || "Calendar".equalsIgnoreCase(folder.getDisplayName())) continue;
                String folderPath = IN_PLACE_ARCHIVE + folder.getDisplayName();
                existingFolders.put(folderPath, folder.getId().getUniqueId());
                CommonDownloadController.findAllSubFolders(service, folder.getId(), folder.getDisplayName(), (Map<String, String>)existingFolders);
            }
            existingFolders.put("In-Place Archive", uniqId);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        return existingFolders;
    }

    private static void findAllSubFolders(ExchangeService service, FolderId parentFolderId, String parentPath, Map<String, String> existingFolders) {
        try {
            FindFoldersResults foundFolders = service.findFolders(parentFolderId, new FolderView(Integer.MAX_VALUE));
            for (Folder subFolder : foundFolders) {
                if (StringUtils.isEmpty((String)subFolder.getDisplayName()) || "PersonMetadata".equalsIgnoreCase(subFolder.getDisplayName()) || "Tasks".equalsIgnoreCase(subFolder.getDisplayName()) || "ExternalContacts".equalsIgnoreCase(subFolder.getDisplayName()) || "Files".equalsIgnoreCase(subFolder.getDisplayName()) || "Calendar".equalsIgnoreCase(subFolder.getDisplayName())) continue;
                String path = IN_PLACE_ARCHIVE + parentPath + "/" + subFolder.getDisplayName();
                logger.debug("...before replacepath..." + path);
                path = path.replaceAll(IN_PLACE_ARCHIVE, "");
                for (int i = 0; i < 15; ++i) {
                    if (!path.startsWith("/")) continue;
                    path = path.replaceFirst("/", "");
                }
                logger.debug("...after replacepath..." + path);
                path = IN_PLACE_ARCHIVE + path;
                logger.debug(path + ".....folder...." + subFolder.getDisplayName());
                existingFolders.put(path, subFolder.getId().getUniqueId());
                CommonDownloadController.findAllSubFolders(service, subFolder.getId(), path, existingFolders);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Map<String, String> getExistingFolders(ExchangeService service, String userMail, boolean inplace) {
        EWSAppSetting appSetting = this.utilService.getEwsAppSettingDetail(1);
        String token = CommonDownloadController.getEWSAccesToken(appSetting);
        logger.debug(userMail + "...got-ewstoken...." + token);
        service = CommonDownloadController.getAuthenticatedService(token, userMail);
        HashMap<String, String> folderMap = new HashMap();
        try {
            inplace = false;
            if (inplace) {
                folderMap = CommonDownloadController.addInPlaceArchiveFolders(service, userMail);
            }
            FolderView folderView = new FolderView(100);
            FolderId folderIds = new FolderId(WellKnownFolderName.MsgFolderRoot, new Mailbox(userMail));
            folderView.setTraversal(FolderTraversal.Deep);
            FindFoldersResults findFolders = service.findFolders(folderIds, new FolderView(Integer.MAX_VALUE));
            for (Folder folder : findFolders.getFolders()) {
                String parentName;
                String folderName = folder.getDisplayName();
                if (folderName.equalsIgnoreCase("Calendar") || folderName.equalsIgnoreCase("Contacts") || folderName.equalsIgnoreCase("Yammer Root")) continue;
                if (folder.getParentFolderId() != null && !StringUtils.isEmpty((String)(parentName = (String)folderMap.get(folder.getParentFolderId().getUniqueId())))) {
                    folderName = parentName + "/" + folderName;
                }
                folderMap.put(folder.getId().getUniqueId(), folderName);
                CommonDownloadController.findAllSubFoldersList(service, folder.getId(), folderName, folderMap);
            }
        }
        catch (ServiceLocalException ee) {
            ee.printStackTrace();
            logger.error("....error in getting existing folders...." + ee.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(userMail + "... ERRORR...... " + e.getMessage());
        }
        return folderMap;
    }

    public static synchronized String getEWSAccesToken(EWSAppSetting ewsAppSetting) {
        String accessToken = "";
        try {
            long now = System.currentTimeMillis();
            ExecutorService es = Executors.newFixedThreadPool(2);
            AuthenticationContext context = new AuthenticationContext(AUTHORITY + ewsAppSetting.getTenantId(), false, es);
            AuthenticationCallback<AuthenticationResult> callback = new AuthenticationCallback<AuthenticationResult>(){

                public void onSuccess(AuthenticationResult result) {
                    logger.debug("received token");
                }

                public void onFailure(Throwable exc) {
                    throw new RuntimeException(exc);
                }
            };
            logger.debug("requesting token");
            Future future = context.acquireToken(RESOURCE, new ClientCredential(ewsAppSetting.getClientId(), ewsAppSetting.getClientSecretKey()), (AuthenticationCallback)callback);
            AuthenticationResult result = (AuthenticationResult)future.get(30L, TimeUnit.SECONDS);
            accessToken = result.getAccessToken();
        }
        catch (Exception e) {
            logger.error("... ERRORR...... " + e.getMessage());
        }
        return accessToken;
    }

    public static ExchangeService getAuthenticatedService(String token, String senderAddr) {
        ExchangeService service = null;
        try {
            service = new ExchangeService(ExchangeVersion.Exchange2010_SP2);
            service.getHttpHeaders().put("Authorization", "Bearer " + token);
            service.getHttpHeaders().put("X-AnchorMailbox", senderAddr);
            service.setUrl(new URI(EWS_URL));
            service.setImpersonatedUserId(new ImpersonatedUserId(ConnectingIdType.PrincipalName, senderAddr));
        }
        catch (Exception e) {
            logger.error("... ERRORR...... " + e.getMessage());
        }
        return service;
    }

    private void createFoldersInMail(ExchangeService service, Map<String, String> existingFolders, String exiFolder, String userMail) {
        Path pathsp = Paths.get(exiFolder, new String[0]);
        String[] paths = (String[])StreamSupport.stream(pathsp.spliterator(), false).map(Path::toString).toArray(String[]::new);
        String checkPath = "";
        boolean isParent = false;
        for (String folPath : paths) {
            System.out.println("..... aaa .... " + folPath);
            if (!StringUtils.isEmpty((String)checkPath)) {
                checkPath = checkPath + "/" + folPath;
            } else {
                checkPath = folPath;
                isParent = true;
            }
            boolean pathExists = existingFolders.containsValue(checkPath);
            logger.debug(checkPath + ".....pathexists.... " + pathExists);
            if (!pathExists) {
                try {
                    if (isParent) {
                        Folder folder = new Folder(service);
                        folder.setDisplayName(checkPath.replaceAll("/", ""));
                        Mailbox userMailboxObj = new Mailbox(userMail);
                        FolderId parentId = new FolderId(WellKnownFolderName.MsgFolderRoot, userMailboxObj);
                        service.createFolder(folder, parentId);
                    } else {
                        String parentpath = checkPath.substring(0, checkPath.lastIndexOf(47));
                        String child = checkPath.substring(checkPath.lastIndexOf(47));
                        System.out.println(parentpath + "..." + child);
                        Folder folder = new Folder(service);
                        folder.setDisplayName(child.replaceAll("/", ""));
                        FolderId parentId = new FolderId();
                        String keyFromValue = CommonDownloadController.getKeyFromValue(existingFolders, parentpath);
                        parentId.setUniqueId(keyFromValue);
                        service.createFolder(folder, parentId);
                    }
                    existingFolders = new HashMap<String, String>();
                    existingFolders = this.getExistingFolders(service, userMail, false);
                }
                catch (Exception e1) {
                    logger.error("... ERRORR...... " + e1.getMessage());
                }
            }
            isParent = false;
        }
    }

    public static String getKeyFromValue(Map<String, String> folderMap, Object value) {
        for (String key : folderMap.keySet()) {
            if (!folderMap.get(key).equals(value)) continue;
            return key;
        }
        return null;
    }

    private static void findAllSubFoldersList(ExchangeService service, FolderId parentFolderId, String parentPath, Map<String, String> existingFolders) {
        try {
            FindFoldersResults foundFolders = service.findFolders(parentFolderId, new FolderView(Integer.MAX_VALUE));
            for (Folder subFolder : foundFolders) {
                String path = parentPath + "/" + subFolder.getDisplayName();
                for (int i = 0; i < 15; ++i) {
                    if (!path.startsWith("/")) continue;
                    path = path.replaceFirst("/", "");
                }
                existingFolders.put(subFolder.getId().getUniqueId(), path);
                CommonDownloadController.findAllSubFoldersList(service, subFolder.getId(), path, existingFolders);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @RequestMapping(value={"/cloud/{cloudName}/restore/od/"}, method={RequestMethod.GET})
    public void inPlaceRestoreForOnedrive(@PathVariable(value="cloudName") String cloudName, HttpServletRequest request, HttpServletResponse response) {
        block37: {
            logger.debug(" ... start of/cloud/{cloudName}/restore/od/  ....");
            try {
                boolean isSync = false;
                String isSyncFlag = request.getParameter("isSync");
                DownloadFileTO downloadFileTO = this.getRequestParameters(request, cloudName);
                RestoreEventsElement restoreEventsElement = new RestoreEventsElement();
                String loginUserName = request.getParameter("loginUserName");
                String attachName = request.getParameter("attachName");
                if (!StringUtils.isEmpty((String)loginUserName)) {
                    loginUserName = this.decodeBase64UTFString(loginUserName);
                }
                String userName = downloadFileTO.getUserName();
                logger.debug(attachName + "...loginUserName..." + loginUserName + "...." + userName);
                String mailFoldPath = request.getParameter("mailFoldPath");
                if (!StringUtils.isEmpty((String)mailFoldPath)) {
                    mailFoldPath = this.decodeBase64UTFString(mailFoldPath);
                }
                String backupId = request.getParameter("backupID");
                logger.debug(userName + "...backupID....." + backupId);
                if (!StringUtils.isEmpty((String)isSyncFlag)) {
                    isSync = Boolean.parseBoolean(isSyncFlag);
                    downloadFileTO.setSync(isSync);
                } else {
                    response.setStatus(400);
                }
                String deviceUUID = request.getParameter("deviceUUID");
                if (StringUtils.isEmpty((String)deviceUUID)) {
                    deviceUUID = request.getHeader("deviceUUID");
                }
                Cloud cloud = this.utilService.getCloud(1);
                com.parablu.pcbd.domain.User user = this.utilService.getUserInfoByName(1, userName);
                logger.debug(mailFoldPath + "....user..... " + user.getUserName());
                int cloudId = cloud.getCloudId();
                BackupFile backupFile = this.downloadService.getBackupFileForId(cloudId, userName, backupId);
                if (backupFile == null) {
                    logger.error(".... mail does not exists.... ");
                    response.setStatus(507);
                    return;
                }
                Device device = this.utilService.getDeviceForUUID(cloudId, deviceUUID);
                BackUpImage bkpImage = this.utilService.getBackupImageFile(cloudId, backupId, device);
                String orgDevicePath = bkpImage.getDevicePath();
                backupFile.setOdItemId(bkpImage.getOdItemId());
                String drivUserName = device.getUserName();
                String path = backupFile.getFilePath();
                logger.debug(mailFoldPath + "....user..... " + user.getUserName());
                if (!StringUtils.isEmpty((String)mailFoldPath)) {
                    path = mailFoldPath;
                } else {
                    restoreEventsElement.setInPlaceRestore(true);
                }
                logger.debug(path + "....userafterpath..... " + user.getUserName());
                path = path.replaceFirst("Files", "");
                if (path.startsWith("//")) {
                    path = path.replaceFirst("/", "");
                }
                if (path.endsWith("/")) {
                    path = path.substring(0, path.lastIndexOf("/"));
                }
                logger.debug(path + "....userafterpath1..... " + user.getUserName());
                String destPath = path;
                OfficeBackupPolicy officeBackupPolicy = this.utilService.getOfficeBackupPolicyForUser(cloudId, device.getUserName(), device.getDeviceType());
                if (device.getOsType().equalsIgnoreCase(Device.TYPE.ONEDRIVE.name())) {
                    if (bkpImage != null && StringUtils.isEmpty((String)bkpImage.getStoragePlace())) {
                        FileInfo fileInfo = this.downloadService.getFileFromPG(cloudId, userName, backupFile.getId().toString());
                        logger.debug("..... file is in pg....." + path);
                        this.syncDownloadService.inPlaceRestoreForOndriveFromPg(cloud, backupFile, fileInfo, path, drivUserName, officeBackupPolicy, false, true);
                    } else {
                        logger.debug("..... file is in cloud....." + path);
                        this.syncDownloadService.inPlaceRestoreForOndriveFromCloud(cloud, backupFile, path, drivUserName, officeBackupPolicy, false, true);
                    }
                    FileElement fileElement = new FileElement();
                    fileElement.setFileCompletePath(path);
                    restoreEventsElement.setDestinationDeviceUUID(device.getDeviceUUID());
                    fileElement.setFileName(orgDevicePath + "/" + backupFile.getFileName());
                    restoreEventsElement.setFileElement(fileElement);
                    restoreEventsElement.setDestinationPath(destPath);
                    String actionOnUser = this.constructActionOnUser(device, device, restoreEventsElement, true);
                    logger.debug(destPath + "...od restore...." + path);
                    this.utilService.saveStatisticToDatabase(cloud.getCloudId(), cloudName, "initiated restore for", loginUserName, actionOnUser, "Portal", System.currentTimeMillis(), 92);
                    break block37;
                }
                if (!device.getOsType().equalsIgnoreCase(Device.TYPE.SHAREPOINT.name())) break block37;
                String customPath = "/" + path;
                String siteId = user.getSiteId();
                ArrayList<String> listIds = new ArrayList<String>();
                HashMap<String, String> listMap = new HashMap<String, String>();
                String listId = "";
                String listNameForFileRestore = "";
                boolean singleFileRestore = true;
                Drive drive = null;
                try {
                    ListCollectionPage listCollectionPage = (ListCollectionPage)((ListCollectionRequest)Graph.getInstance().getGraphClient().sites(siteId).lists().buildRequest(new Option[0])).get();
                    List currentListPageVal = null;
                    ListCollectionRequestBuilder nextListPage = (ListCollectionRequestBuilder)listCollectionPage.getNextPage();
                    do {
                        currentListPageVal = listCollectionPage.getCurrentPage();
                        for (com.microsoft.graph.models.List list : listCollectionPage.getCurrentPage()) {
                            if (!"documentLibrary".equals(list.list.template)) continue;
                            listIds.add(list.id);
                            listMap.put(list.id, list.name);
                            if (customPath.startsWith("//")) {
                                customPath = customPath.replaceFirst("/", "");
                            }
                            logger.debug(customPath + "%%%%" + list.name + "....list.." + list.displayName + ".." + list.id);
                            if (!customPath.startsWith("/" + list.name) && !customPath.equals(list.name)) continue;
                            listId = list.id;
                            logger.debug(".....listrestore...." + customPath);
                            customPath = customPath.replaceFirst("/" + list.name, "");
                            logger.debug(".....listrestore12...." + customPath);
                            break;
                        }
                        if ((nextListPage = (ListCollectionRequestBuilder)listCollectionPage.getNextPage()) == null) continue;
                        listCollectionPage = (ListCollectionPage)((ListCollectionRequest)nextListPage.buildRequest(new Option[0])).get();
                    } while (StringUtils.isEmpty((String)siteId) && currentListPageVal.size() > 0 && nextListPage != null && listCollectionPage != null && nextListPage != null);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    logger.debug("..error..." + e.getMessage());
                }
                logger.debug(listId + "...beforecustompath..." + customPath);
                if (customPath.startsWith("/")) {
                    customPath = customPath.substring(1);
                }
                logger.debug("...beforecustompath1..." + customPath);
                customPath = StringEscapeUtils.unescapeHtml3((String)customPath);
                customPath = FilenameUtils.separatorsToUnix((String)customPath);
                customPath = customPath.replaceAll("//", "/");
                logger.debug("...beforecustompath2..." + customPath);
                drive = Graph.getInstance().getGraphClient().sites(siteId).lists(listId).drive().buildRequest(new Option[0]).get();
                boolean filerestored = false;
                String restoreFolder = "";
                restoreFolder = backupFile.getFileName();
                if (bkpImage != null && StringUtils.isEmpty((String)bkpImage.getStoragePlace())) {
                    FileInfo fileInfo = this.downloadService.getFileFromPG(cloudId, userName, backupFile.getId().toString());
                    logger.debug("..... file is in pg....." + path);
                    filerestored = this.syncDownloadService.inPlaceRestoreForSPFromPg(cloud, backupFile, fileInfo, customPath, loginUserName, siteId, listId, true, true, false, restoreFolder);
                } else {
                    logger.debug("..... file is in cloud....." + path);
                    filerestored = this.syncDownloadService.inPlaceRestoreForSPFromCloud(cloud, backupFile, customPath, loginUserName, siteId, listId, true, true, false, restoreFolder);
                }
                if (filerestored && officeBackupPolicy != null && officeBackupPolicy.isCreateLinkEnabled()) {
                    String deletepath = "";
                    String fileUrl = "";
                    String driveId = drive.id;
                    String customUrlVal = "";
                    boolean samFolderRest = false;
                    if (backupFile.getFilePath().equalsIgnoreCase("Files")) {
                        deletepath = backupFile.getFileName();
                        deletepath = deletepath.replaceFirst("Shared Documents", "");
                        deletepath = deletepath.replaceFirst("/Shared Documents", "");
                        fileUrl = "https://graph.microsoft.com/v1.0/drives/" + driveId + "/root/children/" + deletepath + ".url/content";
                        customUrlVal = "/drives/" + driveId + "/root/children/" + deletepath;
                        samFolderRest = true;
                    } else {
                        String folderPath = backupFile.getFilePath().replaceAll("Files/", "");
                        deletepath = folderPath + "/" + backupFile.getFileName();
                        deletepath = deletepath.replaceFirst("Shared Documents", "");
                        deletepath = deletepath.replaceFirst("/Shared Documents", "");
                        fileUrl = "https://graph.microsoft.com/v1.0/drives/" + driveId + "/root:/" + deletepath + ".url:/content";
                        customUrlVal = "/drives/" + driveId + "/root:/" + deletepath;
                        folderPath = folderPath.replaceFirst("Shared Documents", "");
                        folderPath = folderPath.replaceFirst("/Shared Documents", "");
                        com.microsoft.graph.models.List listObj = Graph.getInstance().getGraphClient().sites(siteId).lists(listId).buildRequest(new Option[0]).get();
                        if (listObj != null) {
                            folderPath = folderPath.replaceFirst(listObj.name, "");
                            folderPath = folderPath.replaceFirst("/listObj.name", "");
                        }
                        logger.debug("....testval..." + folderPath + "....." + customPath);
                        if (customPath.startsWith("/")) {
                            customPath = customPath.replaceFirst("/", "");
                        }
                        if (folderPath.startsWith("/")) {
                            folderPath = folderPath.replaceFirst("/", "");
                        }
                        if (folderPath.equalsIgnoreCase(customPath)) {
                            samFolderRest = true;
                        }
                    }
                    boolean deleteOrgLink = true;
                    logger.debug(deleteOrgLink + "...delete...fileurl...." + fileUrl);
                    logger.debug(samFolderRest + "...pathforrestore..." + customPath + "...." + deletepath);
                    DriveItem item = null;
                    try {
                        com.microsoft.graph.models.List listObj = Graph.getInstance().getGraphClient().sites(siteId).lists(listId).buildRequest(new Option[0]).get();
                        if (listObj != null) {
                            logger.debug(deletepath + ".....list name...." + listObj.name);
                            deletepath = deletepath.replaceFirst(listObj.name, "");
                            customUrlVal = customUrlVal.replaceFirst(listObj.name, "");
                            customUrlVal = customUrlVal.replaceFirst("/listObj.name", "");
                            logger.debug(".....list name after...." + deletepath);
                        }
                        if (samFolderRest && (item = (DriveItem)C2CGraphClient.getInstance().getGraphClient().customRequest("/drives/" + driveId + "/root:/" + deletepath + ".url", DriveItem.class).buildRequest(new Option[0]).get()) != null && deleteOrgLink) {
                            logger.debug(customUrlVal + "....file exists...." + item.id);
                            CommonDownloadController.deleteFile(driveId, item.id);
                            customUrlVal = customUrlVal.replaceFirst("Shared Documents", "");
                            customUrlVal = customUrlVal.replaceFirst("/Shared Documents", "");
                            logger.debug("...customurlpath...." + customUrlVal);
                            item = (DriveItem)Graph.getInstance().getGraphClient().customRequest(customUrlVal, DriveItem.class).buildRequest(new Option[0]).get();
                            if (item != null) {
                                logger.debug(customUrlVal + ".....itemnotnull...." + backupFile.getBackupId());
                                this.utilService.updateOdItemId(1, backupFile.getBackupId(), backupFile.getOdItemId(), device.getDestCollection());
                            } else {
                                logger.debug(".....itemnotnull...." + customUrlVal);
                            }
                        }
                    }
                    catch (GraphServiceException ee) {
                        logger.debug("....item not found..." + ee.getResponseCode());
                    }
                }
                if (filerestored) {
                    // empty if block
                }
                FileElement fileElement = new FileElement();
                fileElement.setFileCompletePath(path);
                restoreEventsElement.setDestinationDeviceUUID(device.getDeviceUUID());
                fileElement.setFileName(orgDevicePath + "/" + backupFile.getFileName());
                restoreEventsElement.setFileElement(fileElement);
                restoreEventsElement.setDestinationPath(destPath);
                String actionOnUser = this.constructActionOnUser(device, device, restoreEventsElement, true);
                logger.debug(destPath + "...od restore...." + path);
                this.utilService.saveStatisticToDatabase(cloud.getCloudId(), cloudName, "initiated restore for", loginUserName, actionOnUser, "Portal", System.currentTimeMillis(), 92);
                response.setStatus(200);
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error("..... UNALBE TO INITIATE A RESTORE .... " + e.getMessage());
                response.setStatus(500);
            }
        }
        logger.debug(" ... end of /cloud/{cloudName}/restore/od/   ....");
    }

    private static int deleteFile(String driveId, String itemId) {
        String fileUrl = "https://graph.microsoft.com/v1.0/drives/" + driveId + "/items/" + itemId;
        logger.debug("...delete url...." + fileUrl);
        int responseCode = 0;
        try {
            OkHttpClient okHttpClient = Graph.getInstance().getOkHttpClient();
            Request request = new Request.Builder().url(fileUrl).delete().build();
            Call call = okHttpClient.newCall(request);
            Response response = call.execute();
            responseCode = response.code();
            logger.debug("...deleted usinggraph...." + responseCode);
            response.close();
        }
        catch (GraphServiceException e) {
            logger.error("GraphServiceException....", (Throwable)e);
        }
        catch (Exception e) {
            logger.error("graph exception to delete:", (Object)e.getMessage());
        }
        return responseCode;
    }
}

