/*
 * Decompiled with CFR 0.152.
 */
package com.pg.helper.utils;

import com.pg.helper.constant.PCHelperConstant;
import java.net.InetSocketAddress;
import net.spy.memcached.MemcachedClient;
import net.spy.memcached.internal.OperationFuture;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CacheHelper {
    private static Logger logger = LogManager.getLogger(CacheHelper.class);
    private static MemcachedClient memcachedClient;
    private static final String PRIVACY_GETEWAY = "privacy_gateway_";
    private static final String SYNC = "_sync";
    private static final String BACKUP = "_backup";
    private static final String OD = "od_";
    private static CacheHelper singleton;

    private CacheHelper() {
    }

    public static CacheHelper getInstance() {
        return singleton;
    }

    private static MemcachedClient getMemCachedClient() {
        try {
            if (memcachedClient == null) {
                memcachedClient = new MemcachedClient(new InetSocketAddress[]{new InetSocketAddress(PCHelperConstant.getPropertyFileValueMemcachedUrl(), (int)Integer.valueOf(PCHelperConstant.getPropertyFileValueMemcachedPort()))});
            }
        }
        catch (Exception e) {
            logger.trace((Object)e);
            logger.error(" error trying to set memcached client............ " + e.getMessage());
        }
        return memcachedClient;
    }

    public static void addValueToCache(String key, Object value) {
        OperationFuture mutatedValue = CacheHelper.getMemCachedClient().set(key.toLowerCase(), 0, value);
        logger.debug("value set without exception:" + mutatedValue.toString());
    }

    public static Object getValueFromCache(String key) {
        return CacheHelper.getMemCachedClient().get(key.toLowerCase());
    }

    public void removeKeyFromCache(String key) {
        CacheHelper.getMemCachedClient().delete(key.toLowerCase());
    }

    public Long getCachedDiskSpace(String cloudName) {
        String key = cloudName.toLowerCase() + "size";
        String stringVal = (String)CacheHelper.getMemCachedClient().get(key);
        if (stringVal == null) {
            return null;
        }
        Long val = Long.valueOf(stringVal.trim());
        logger.debug("getCachedDiskSpace Key: " + key + " ..and val: " + val);
        return val;
    }

    public void updatePGSize(String cloudName, boolean isBackup, long size) {
        String key = isBackup ? PRIVACY_GETEWAY + cloudName.toLowerCase() + BACKUP : PRIVACY_GETEWAY + cloudName.toLowerCase() + SYNC;
        Long sizeVal = (Long)CacheHelper.getMemCachedClient().get(key);
        if (sizeVal == null) {
            CacheHelper.addValueToCache(key, size);
        } else {
            Long updatedSize = sizeVal + size;
            CacheHelper.getMemCachedClient().set(key, 0, (Object)updatedSize);
            logger.debug("updated size.... " + key + " and val: " + updatedSize);
        }
    }

    public void updateCloudSize(String cloudName, boolean isBackup, Double size) {
        String key = isBackup ? OD + cloudName.toLowerCase() + BACKUP : OD + cloudName.toLowerCase() + SYNC;
        Double sizeVal = (Double)CacheHelper.getMemCachedClient().get(key);
        if (sizeVal == null) {
            CacheHelper.addValueToCache(key, size);
        } else {
            Double updatedSize = sizeVal + size;
            CacheHelper.getMemCachedClient().set(key, 0, (Object)updatedSize);
            logger.debug("updateCloudSize for.... " + key + " ... and val: " + updatedSize);
        }
    }

    static {
        singleton = new CacheHelper();
    }
}

