/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.bluvault.udc.service.impl;

import com.parablu.bluvault.udc.service.EventHubManagementService;
import com.parablu.paracloud.constant.CPHelperConstant;
import com.parablu.paracloud.element.BackupFolderElement;
import com.parablu.paracloud.element.FileElement;
import com.parablu.paracloud.element.RestoreEventsElement;
import com.parablu.pcbd.dao.AuditHistoryDao;
import com.parablu.pcbd.dao.BackUpImageDao;
import com.parablu.pcbd.dao.BackupBatchDao;
import com.parablu.pcbd.dao.BackupFoldersDao;
import com.parablu.pcbd.dao.BackupOverViewDao;
import com.parablu.pcbd.dao.BackupPolicyDao;
import com.parablu.pcbd.dao.DeviceDao;
import com.parablu.pcbd.dao.EventHubDao;
import com.parablu.pcbd.dao.InclusionFilterDao;
import com.parablu.pcbd.dao.OfficeBackupPolicyDao;
import com.parablu.pcbd.dao.UserDao;
import com.parablu.pcbd.domain.ApiGateWayProperties;
import com.parablu.pcbd.domain.AuditHistory;
import com.parablu.pcbd.domain.BackupAttempt;
import com.parablu.pcbd.domain.BackupBatch;
import com.parablu.pcbd.domain.BackupFolders;
import com.parablu.pcbd.domain.BackupPolicy;
import com.parablu.pcbd.domain.Cloud;
import com.parablu.pcbd.domain.Device;
import com.parablu.pcbd.domain.DeviceBackupOverView;
import com.parablu.pcbd.domain.EventHub;
import com.parablu.pcbd.domain.FileInfo;
import com.parablu.pcbd.domain.GmailBackupPolicy;
import com.parablu.pcbd.domain.MailBackupBatch;
import com.parablu.pcbd.domain.ODBBackupBatch;
import com.parablu.pcbd.domain.OfficeBackupPolicy;
import com.parablu.pcbd.domain.RestoreEvents;
import com.parablu.pcbd.domain.RestoreHistory;
import com.parablu.pcbd.domain.RestoreProgressEvents;
import com.parablu.pcbd.domain.Schedule;
import com.parablu.pcbd.domain.User;
import com.parablu.pcsd.dao.SyncPolicyDao;
import jakarta.annotation.Resource;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bson.types.ObjectId;
import org.springframework.beans.BeanUtils;

public class EventHubManagementServiceImpl
implements EventHubManagementService {
    private static Logger logger = LogManager.getLogger(EventHubManagementServiceImpl.class);
    private static final String STARTED = "STARTED";
    @Resource
    private EventHubDao eventHubDao;
    @Resource
    private DeviceDao deviceDao;
    @Resource
    SyncPolicyDao syncPolicyDao;
    @Resource
    BackupPolicyDao backupPolicyDao;
    @Resource
    private BackupFoldersDao backupFoldersDao;
    @Resource
    private InclusionFilterDao inclusionFilterDao;
    @Resource
    private AuditHistoryDao auditHistoryDao;
    @Resource
    private UserDao userDao;
    @Resource
    private BackUpImageDao backUpImageDao;
    @Resource
    private BackupOverViewDao backupOverViewDao;
    @Resource
    private BackupBatchDao backupBatchDao;
    @Resource
    private OfficeBackupPolicyDao oneDriveBackupPolicyDao;

    public void setDeviceDao(DeviceDao deviceDao) {
        this.deviceDao = deviceDao;
    }

    public void setBackupBatchDao(BackupBatchDao backupBatchDao) {
        this.backupBatchDao = backupBatchDao;
    }

    public void setBackupOverViewDao(BackupOverViewDao backupOverViewDao) {
        this.backupOverViewDao = backupOverViewDao;
    }

    public void setBackUpImageDao(BackUpImageDao backUpImageDao) {
        this.backUpImageDao = backUpImageDao;
    }

    public void setUserDao(UserDao userDao) {
        this.userDao = userDao;
    }

    public EventHubDao getEventHubDao() {
        return this.eventHubDao;
    }

    public void setEventHubDao(EventHubDao eventHubDao) {
        this.eventHubDao = eventHubDao;
    }

    @Override
    public void saveAction(int cloudId, String cloudName, EventHub eventHub) {
        this.eventHubDao.saveAction(cloudId, cloudName, eventHub);
    }

    @Override
    public void changeStatus(int cloudId, String cloudName, EventHub eventHub) {
        this.eventHubDao.changeStatus(cloudId, cloudName, eventHub);
    }

    @Override
    public List<String> getActionsByUserNameAndAction(int cloudId, String cloudName, EventHub eventHub) {
        List eventHubList = this.eventHubDao.getActionsByUserNameAndActionByDeviceUUID(cloudId, cloudName, eventHub);
        return eventHubList.stream().filter(line -> Objects.nonNull(line.getAction())).map(line -> line.getAction()).collect(Collectors.toList());
    }

    @Override
    public void deleteAction(int cloudId, String cloudName, EventHub eventHub) {
        this.eventHubDao.deleteAction(cloudId, cloudName, eventHub);
    }

    @Override
    public void deleteAllLogEvents(int cloudId, String cloudName, EventHub eventHub) {
        eventHub.setAction(CPHelperConstant.EVENTHUB_ACTION.PULL_AGENTLOGS.toString());
        this.eventHubDao.deleteAction(cloudId, cloudName, eventHub);
        eventHub.setAction(CPHelperConstant.EVENTHUB_ACTION.PULL_HISTORICAL_LOGS.toString());
        this.eventHubDao.deleteAction(cloudId, cloudName, eventHub);
    }

    @Override
    public boolean checkActionIsPresent(int cloudId, String cloudName, EventHub eventHub) {
        return this.eventHubDao.checkActionIsPresent(cloudId, cloudName, eventHub);
    }

    @Override
    public void saveActionFromBackupFolder(int cloudId, String cloudName, BackupFolderElement backupFolderElement, String userName) {
        BackupFolders existingBackupFolders = this.backupFoldersDao.getBackupFolders(cloudId, cloudName, backupFolderElement.getFolderPath());
        List backupPolicyList = this.backupPolicyDao.getAllBackupPolicies(cloudId);
        backupPolicyList.forEach(backupPolicy -> {
            if (backupPolicy.getBackupFolders().contains(existingBackupFolders)) {
                this.backupPolicyDao.updatePolicyModifiedTime(cloudId, backupPolicy.getId());
            }
        });
    }

    @Override
    public void saveActionFromBackupScheduler(int cloudId, String cloudName, Schedule schedule, String userName) {
        List backupPolicyList = this.backupPolicyDao.getAllBackupPolicies(cloudId);
        backupPolicyList.forEach(backupPolicy -> backupPolicy.getSchedules().forEach(schedules -> {
            if (schedules.getScheduleName().equals(schedule.getScheduleName())) {
                this.backupPolicyDao.updatePolicyModifiedTime(cloudId, backupPolicy.getId());
            }
        }));
    }

    @Override
    public List<String> getActionForDevice(int cloudId, String cloudName, EventHub eventHub, long timeStampOfPolicyModified, long devicePolicyUpdatedTime) {
        logger.debug("Inisde getActionForDevice ..............");
        List eventHubList = this.eventHubDao.getActionsByUserNameAndActionByDeviceUUID(cloudId, cloudName, eventHub);
        List<String> actions = eventHubList.stream().filter(action -> Objects.nonNull(action.getAction())).map(action -> action.getAction()).collect(Collectors.toList());
        for (String acc : actions) {
            logger.debug("....acccccc...." + acc);
        }
        if (actions.contains(CPHelperConstant.EVENTHUB_ACTION.BACKUPPOLICY_REFRESH.toString())) {
            logger.debug("Actions contains backupPolicy refresh so return");
            return actions;
        }
        return this.checkPolicyModifiedAndReturnActions(cloudId, cloudName, eventHub, actions, timeStampOfPolicyModified, devicePolicyUpdatedTime);
    }

    private List<String> checkPolicyModifiedAndReturnActions(int cloudId, String cloudName, EventHub eventHub, List<String> actions, long timeStampOfPolicyModified, long devicePolicyUpdatedTime) {
        logger.debug(devicePolicyUpdatedTime + "....device...usertime...." + timeStampOfPolicyModified);
        if (devicePolicyUpdatedTime < timeStampOfPolicyModified) {
            actions.add(CPHelperConstant.EVENTHUB_ACTION.BACKUPPOLICY_REFRESH.toString());
            eventHub.setAction(CPHelperConstant.EVENTHUB_ACTION.BACKUPPOLICY_REFRESH.toString());
            this.eventHubDao.saveAction(cloudId, cloudName, eventHub);
        }
        return actions;
    }

    @Override
    public void deleteAllActionByDeviceUUID(int cloudId, EventHub eventHub) {
        this.eventHubDao.deleteAllActionByDeviceUUID(cloudId, eventHub);
    }

    @Override
    public void deleteActionBasedOnBackupBatchStatus(int cloudId, String cloudName, String deviceUUID, String action, BackupBatch backupBatch, String errorCode) {
        if (action.equalsIgnoreCase(STARTED) || action.equalsIgnoreCase("STARTED/COMPLETED") || action.equalsIgnoreCase("FAILED")) {
            this.eventHubDao.deleteActionBasedOnBackupBatchStatus(cloudId, deviceUUID, CPHelperConstant.EVENTHUB_ACTION.START_BACKUP.toString());
        } else if (errorCode.equalsIgnoreCase("1208") || errorCode.equalsIgnoreCase("1209")) {
            this.deleteEvent(cloudId, deviceUUID, errorCode, backupBatch.getUserName());
        }
    }

    private void deleteEvent(int cloudId, String deviceUUID, String errorCode, String userName) {
        logger.debug("Deleteing based on error code...");
        EventHub eventHub = new EventHub();
        eventHub.setActionToDeviceUUID(deviceUUID);
        eventHub.setActionToUserName(userName);
        if (errorCode.equalsIgnoreCase("1208")) {
            eventHub.setAction(CPHelperConstant.EVENTHUB_ACTION.PAUSE_BACKUP.toString());
        } else if (errorCode.equalsIgnoreCase("1209")) {
            eventHub.setAction(CPHelperConstant.EVENTHUB_ACTION.STOP_BACKUP.toString());
        }
        this.eventHubDao.deleteAction(cloudId, "", eventHub);
        logger.debug("if admin stops or pause backup also delete started state event also");
        this.eventHubDao.deleteActionBasedOnBackupBatchStatus(cloudId, deviceUUID, CPHelperConstant.EVENTHUB_ACTION.START_BACKUP.toString());
    }

    void saveStatisticToDatabase(int cloudId, String cloudName, String action, String actionByUser, String actionOnUser, String actionUsingObject, long timeStamp, int actionType) {
        AuditHistory audit = new AuditHistory();
        audit.setAction(action);
        audit.setActionByUserName(actionByUser);
        audit.setActionOnObject(actionOnUser);
        audit.setTimestamp(timeStamp);
        audit.setActionUsingObject(actionUsingObject);
        audit.setActionType(actionType);
        this.auditHistoryDao.saveAudit(cloudId, cloudName, audit);
    }

    @Override
    public void updateBackupBatchForStopAndPauseBkp(int cloudId, String actionToDeviceUUID, String errorCode, String status, String policyName) {
        this.eventHubDao.updateBackupBatchForStopAndPauseBkp(cloudId, actionToDeviceUUID, errorCode, status, policyName);
    }

    @Override
    public RestoreEventsElement getRestoreEventByUUIDAndFolder(int cloudId, String deviceUUID, String destinationFolder) {
        RestoreEvents restoreEventByUUIDAndFolder = this.eventHubDao.getRestoreEventsByDestUUIDAndFolder(cloudId, deviceUUID, destinationFolder);
        RestoreEventsElement elements = null;
        if (restoreEventByUUIDAndFolder != null) {
            try {
                elements = new RestoreEventsElement();
                logger.debug(restoreEventByUUIDAndFolder.getFileInfo().getFilePath() + "...Inside loop...." + String.valueOf(restoreEventByUUIDAndFolder.getId()));
                BeanUtils.copyProperties((Object)restoreEventByUUIDAndFolder, (Object)elements);
                elements.setScanRestoreFiles(restoreEventByUUIDAndFolder.isScanRestoreFiles());
                elements.setSuspendBackup(restoreEventByUUIDAndFolder.isSuspendBackup());
                FileElement fileElement = new FileElement();
                fileElement.setFileCompletePath(restoreEventByUUIDAndFolder.getFileInfo().getFilePath());
                fileElement.setFolder(restoreEventByUUIDAndFolder.getFileInfo().isFolder());
                fileElement.setBackupId(restoreEventByUUIDAndFolder.getFileInfo().getId());
                RestoreProgressEvents restoreProgressByEvents = this.eventHubDao.getRestoreProgressByEvents(cloudId, deviceUUID);
                elements.setStatus("QUEUE");
                if (restoreProgressByEvents != null) {
                    elements.setStatus(STARTED);
                }
                elements.setFileElement(fileElement);
            }
            catch (Exception e) {
                logger.debug("Exception on service......");
            }
        }
        return elements;
    }

    @Override
    public RestoreEventsElement updateRestoreEvents(int cloudId, RestoreEventsElement restoreEventsElement, String userName) {
        RestoreEventsElement eventsElement = this.getRestoreEventByUUIDAndFolder(cloudId, restoreEventsElement.getDestinationDeviceUUID(), "");
        if (eventsElement != null) {
            logger.debug(".....eventsElement..." + eventsElement.toString());
            return eventsElement;
        }
        this.saveRestoreEvents(cloudId, restoreEventsElement, userName);
        return eventsElement;
    }

    @Override
    public void deleteRestoreEventsByUUID(int cloudId, String deviceUUID) {
        logger.debug("...Inside delete restore events ..." + deviceUUID);
        this.eventHubDao.deleteRestoreEventsByDestUUID(cloudId, deviceUUID);
        this.eventHubDao.deleteActionBasedOnBackupBatchStatus(cloudId, deviceUUID, CPHelperConstant.EVENTHUB_ACTION.START_RESTORE.toString());
    }

    @Override
    public void saveRestoreEvents(int cloudId, RestoreEventsElement restoreEventsElement, String userName) {
        RestoreEvents restoreEvents = new RestoreEvents();
        FileElement fileElement = restoreEventsElement.getFileElement();
        FileInfo fileInfo = new FileInfo();
        fileInfo.setId(fileElement.getBackupId());
        fileInfo.setFolder(fileElement.isFolder());
        fileInfo.setFilePath(fileElement.getFileCompletePath());
        restoreEvents.setDestinationDeviceUUID(restoreEventsElement.getDestinationDeviceUUID());
        restoreEvents.setActionOnDeviceUUID(restoreEventsElement.getActionOnDeviceUUID());
        restoreEvents.setDestinationPath(restoreEventsElement.getDestinationPath());
        restoreEvents.setActionBy(restoreEventsElement.getActionBy());
        restoreEvents.setFileInfo(fileInfo);
        restoreEvents.setInPlaceRestore(restoreEventsElement.isInPlaceRestore());
        logger.debug(".........restoreEventsElement........" + restoreEventsElement.isRestoreAllVersions());
        restoreEvents.setRestoreAllVersions(restoreEventsElement.isRestoreAllVersions());
        restoreEvents.setRestoreDataBefore(restoreEventsElement.getRestoreDataBefore());
        restoreEvents.setStatus("QUEUE");
        restoreEvents.setNoOfThreads(restoreEventsElement.getNoOfThreads());
        restoreEvents.setSuspendBackup(restoreEventsElement.getSuspendBackup());
        restoreEvents.setRestoreDeletedFiles(restoreEventsElement.isRestoreDeletedFiles());
        restoreEvents.setOverwriteNewerFiles(restoreEventsElement.isOverwriteNewerFiles());
        restoreEvents.setScanRestoreFiles(restoreEventsElement.isScanRestoreFiles());
        logger.debug(".........Restore DeletedFiles........" + restoreEvents.isRestoreDeletedFiles());
        logger.debug(".........Restore OverwriteNewerFiles........" + restoreEventsElement.isOverwriteNewerFiles());
        logger.debug(".........restoreEvents........" + restoreEvents.isRestoreAllVersions());
        this.eventHubDao.saveRestoreEvents(cloudId, restoreEvents);
        EventHub eventHub = new EventHub();
        eventHub.setAction(CPHelperConstant.EVENTHUB_ACTION.START_RESTORE.toString());
        eventHub.setActionToDeviceUUID(restoreEvents.getDestinationDeviceUUID());
        eventHub.setActionToUserName(userName);
        boolean checkActionIsPresent = this.checkActionIsPresent(cloudId, "", eventHub);
        logger.debug("....checkActionIsPresent..." + checkActionIsPresent);
        if (!checkActionIsPresent) {
            eventHub.setActionBy(restoreEventsElement.getActionBy());
            this.eventHubDao.saveAction(cloudId, "", eventHub);
        }
    }

    @Override
    public void updateRestoreEventsStatus(int cloudId, String deviceUUID, String status) {
        logger.debug("..updating status for deviceUUID..." + deviceUUID + "...status as..." + status);
        RestoreEvents restoreEventByUUID = this.eventHubDao.getRestoreEventsByDestUUIDAndFolder(cloudId, deviceUUID, "");
        if (restoreEventByUUID != null && !StringUtils.isEmpty((CharSequence)restoreEventByUUID.getStatus())) {
            if (status.equals(STARTED) && !status.equalsIgnoreCase(restoreEventByUUID.getStatus())) {
                logger.debug("..old status.." + status);
                restoreEventByUUID.setStatus(status);
                this.eventHubDao.saveRestoreEvents(cloudId, restoreEventByUUID);
                this.eventHubDao.deleteActionBasedOnBackupBatchStatus(cloudId, deviceUUID, CPHelperConstant.EVENTHUB_ACTION.START_RESTORE.toString());
            } else if (status.equals("COMPLETED") || status.equals("FAILED")) {
                logger.debug("ststus " + status + "...deleting action.......");
                this.eventHubDao.deleteRestoreEvents(cloudId, restoreEventByUUID);
                this.eventHubDao.removeRestoreProgressById(cloudId, restoreEventByUUID.getId());
                this.eventHubDao.deleteActionBasedOnBackupBatchStatus(cloudId, deviceUUID, CPHelperConstant.EVENTHUB_ACTION.START_RESTORE.toString());
            } else {
                logger.debug("..restore events is empty for deviceUUID :" + deviceUUID);
            }
        }
    }

    @Override
    public MailBackupBatch getMailBackupBatch(int cloudId, String deviceUUID) {
        return this.eventHubDao.getMailBackupBatch(cloudId, deviceUUID);
    }

    @Override
    public BackupBatch getBackupBatch(int cloudId, String deviceUUID) {
        return this.eventHubDao.getBackupBatch(cloudId, deviceUUID);
    }

    @Override
    public void updateBackupBatchForStopRestore(int cloudId, String actionToDeviceUUID, String errorCode, String status) {
        this.eventHubDao.updateBackupBatchForStopRestore(cloudId, actionToDeviceUUID, errorCode, status);
    }

    @Override
    public RestoreEvents getRestoreEventByUUID(int cloudId, String deviceUUID) {
        return this.eventHubDao.getRestoreEventsByDestUUIDAndFolder(cloudId, deviceUUID);
    }

    @Override
    public void removeRestoreProgress(int cloudId, String deviceUUID) {
        this.eventHubDao.removeRestoreProgress(cloudId, deviceUUID);
    }

    @Override
    public void updateBackupBatchForStopRestore(int cloudId, String actionToDeviceUUID, String errorCode) {
        this.eventHubDao.updateBackupBatchForStopRestore(cloudId, actionToDeviceUUID, errorCode);
    }

    @Override
    public void deleteRestoreEventsByBatchId(int cloudId, String batchId) {
        RestoreEvents restoreEvents = this.eventHubDao.getRestoreEventForBatchId(cloudId, batchId);
        if (restoreEvents != null) {
            String deviceUUID = restoreEvents.getDestinationDeviceUUID();
            this.eventHubDao.deleteRestoreEventsByDestUUID(cloudId, deviceUUID);
            this.eventHubDao.deleteActionBasedOnBackupBatchStatus(cloudId, deviceUUID, CPHelperConstant.EVENTHUB_ACTION.START_RESTORE.toString());
        }
    }

    @Override
    public void deleteBatchFromOdServer(String deviceUUID, String policyName) {
        this.eventHubDao.deleteBatchFromOdServer(deviceUUID, policyName);
    }

    @Override
    public void deleteEventHubForDeviceUUID(int cloudId, String deviceUUID, String action) {
        this.eventHubDao.deleteEventHubForDeviceUUID(cloudId, deviceUUID, action);
    }

    @Override
    public String saveBatchDetails(int cloudId, String policyName, Device device, boolean isFullBackup, Cloud cloudFinal) {
        logger.debug("********QUEUE**saveBatchDetails*******");
        String userName = device.getUserName();
        long batchStartTime = System.currentTimeMillis();
        ODBBackupBatch backupBatch = new ODBBackupBatch();
        backupBatch.setDeviceUUID(device.getDeviceUUID());
        backupBatch.setUserName(userName);
        backupBatch.setNoOfFiles(0L);
        backupBatch.setBatchStartTimestamp(batchStartTime);
        backupBatch.setStatus("QUEUED");
        String batchId = this.eventHubDao.saveBatchDetails(cloudId, backupBatch, policyName, batchStartTime);
        BackupBatch backupBatchOrg = new BackupBatch();
        BeanUtils.copyProperties((Object)backupBatch, (Object)backupBatchOrg);
        backupBatchOrg.setBatchStartTimestamp(backupBatch.getBatchStartTimestamp());
        backupBatchOrg.setId(new ObjectId(batchId));
        this.startQueuedBackupBatch(backupBatchOrg, cloudFinal, 0, 0L, 0, batchStartTime, isFullBackup, device);
        logger.debug("********QUEUE**completedsaveBatchDetails*******");
        return batchId;
    }

    public BackupBatch startQueuedBackupBatch(BackupBatch backupBatchOdb, Cloud cloud, int uploadedFiles, long totalFiles, int errorCode, long batchStartTimestamp, boolean fullBackup, Device device) {
        logger.debug("calling start backup Batch ..." + uploadedFiles);
        BackupBatch backupBatch = new BackupBatch();
        try {
            int tot;
            int cloudId = cloud.getCloudId();
            String jobType = "BACKUP";
            String totalNoOfFiles = "" + backupBatchOdb.getNoOfFiles();
            String deviceUUID = backupBatchOdb.getDeviceUUID();
            logger.debug(" ************ " + backupBatchOdb.getErrorCode());
            if (!StringUtils.isEmpty((CharSequence)totalNoOfFiles) && (long)(tot = Integer.parseInt(totalNoOfFiles)) < totalFiles) {
                totalNoOfFiles = "" + totalFiles;
            }
            backupBatch.setId(backupBatchOdb.getId());
            backupBatch.setUserName(backupBatchOdb.getUserName());
            backupBatch.setDeviceName(backupBatchOdb.getDeviceName());
            backupBatch.setDeviceUUID(deviceUUID);
            backupBatch.setStatus(CPHelperConstant.BACKUP_STATUS.QUEUED.toString());
            backupBatch.setDeviceType(device.getDeviceType());
            backupBatch.setJobType(jobType);
            backupBatch.setBatchStartTimestamp(batchStartTimestamp);
            backupBatch.setDeviceName(device.getDeviceName());
            backupBatch.setBatchEndTimestamp(System.currentTimeMillis());
            backupBatch.setErrorCode(backupBatchOdb.getErrorCode());
            backupBatch.setFullBackup(fullBackup);
            this.eventHubDao.saveBackupBatch(cloudId, backupBatch);
            BackupAttempt attempt = new BackupAttempt();
            BeanUtils.copyProperties((Object)backupBatch, (Object)attempt);
            attempt.setBatchId(backupBatch.getId().toString());
            attempt.setId(null);
            attempt.setErrorCode("0");
            attempt.setBatchStartTimestamp(batchStartTimestamp);
            attempt.setStatus(CPHelperConstant.BACKUP_STATUS.QUEUED.toString());
            this.eventHubDao.saveBackupAttempt(cloudId, attempt);
            this.updateBackupOverview(cloudId, "BACKUP", deviceUUID, device, backupBatch, errorCode);
            logger.debug(" after updateoverview..");
        }
        catch (Exception e) {
            logger.trace("Error failed to save backupBatch ..." + String.valueOf(e));
            logger.error("Error failed to save backupBatch ..." + e.getMessage());
        }
        logger.debug("end of calling method backup Batch ...");
        return backupBatch;
    }

    private void updateBackupOverview(int cloudId, String jobType, String deviceUUID, Device device, BackupBatch backupBatch, int errorCode) {
        DeviceBackupOverView overView = this.deviceDao.getDeviceBkpOverviewForDeviceUUID(cloudId, deviceUUID);
        if (overView == null) {
            logger.debug(" No device backup ....");
            this.saveDeviceBackupOverView(cloudId, device);
        } else {
            logger.debug(String.valueOf(backupBatch) + " update device backup ...." + backupBatch.getBatchStartTimestamp());
            if (StringUtils.isEmpty((CharSequence)overView.getFirstBkpStartTime())) {
                String firstBkpStartTime = this.getDateInFormat(backupBatch.getBatchStartTimestamp());
                overView.setFirstBkpStartTime(firstBkpStartTime);
            }
            String lastBkpStartTime = this.getDateInFormat(backupBatch.getBatchStartTimestamp());
            overView.setLastBkpStartTime(lastBkpStartTime);
            if (backupBatch.getBatchEndTimestamp() > 0L) {
                overView.setLastBkpEndTime(this.getDateInFormat(backupBatch.getBatchEndTimestamp()));
            } else {
                overView.setLastBkpEndTime(this.getDateInFormat(System.currentTimeMillis()));
            }
            overView.setLastBkpStatus(backupBatch.getStatus());
            overView.setTotalNoOfFiles(backupBatch.getTotalNoOfFiles());
            logger.debug("TotalNoOfFiles : " + backupBatch.getTotalNoOfFiles() + " UploadedFiles : " + backupBatch.getUploadedFiles());
            overView.setNoOfFilesRemaining(this.getNoOfFilesRemaining(backupBatch.getTotalNoOfFiles(), backupBatch.getUploadedFiles()));
            logger.debug(overView.getNoOfSuccessfulBackups() + "Backup/Restore Status*" + backupBatch.getStatus() + "**");
            logger.debug(errorCode + "...noofsuccessfulbkps... " + overView.getNoOfSuccessfulBackups());
            if (BackupBatch.STATUS.COMPLETED.toString().equalsIgnoreCase(backupBatch.getStatus())) {
                String lastSuccessfulBkp = this.getDateInFormat(backupBatch.getBatchEndTimestamp());
                overView.setLastSuccessfulBkp(lastSuccessfulBkp);
                overView.setLastSuccessfulBackupStartTime(backupBatch.getBatchStartTimestamp());
                overView.setLastSuccessfulBackupEndTime(backupBatch.getBatchEndTimestamp());
                logger.debug(device.getUserName() + " @#@# Backup  Completed ........." + device.getDeviceName());
                logger.debug("...totalfilllll....." + backupBatch.getUploadedFiles() + "..." + backupBatch.getTotalNoOfFiles());
                long noOfSuccessfulBackups = overView.getNoOfSuccessfulBackups();
                overView.setNoOfSuccessfulBackups(noOfSuccessfulBackups + 1L);
                if (StringUtils.isEmpty((CharSequence)overView.getFirstBkpEndTime())) {
                    logger.debug(" ..firstbkp empty....");
                    Long firstBkpEndTime = this.eventHubDao.getFirstBackupEndDate(cloudId, device.getUserName(), device.getDeviceUUID());
                    logger.debug(" ..firstbkp empty...." + firstBkpEndTime);
                    if (firstBkpEndTime != null) {
                        String firstSuccessfulEndBkp = this.getDateInFormat(firstBkpEndTime);
                        overView.setFirstBkpEndTime(firstSuccessfulEndBkp);
                    } else {
                        overView.setFirstBkpEndTime(lastSuccessfulBkp);
                    }
                    if (StringUtils.isNotEmpty((CharSequence)backupBatch.getUploadedSize())) {
                        overView.setFirstFullBkpTotalSizeOfFiles(Long.parseLong(backupBatch.getUploadedSize()) / 1024L);
                    } else {
                        overView.setFirstFullBkpTotalSizeOfFiles(0L);
                    }
                    overView.setFirstFullBkpNoOfFiles(this.getActualUploadedFiles(backupBatch.getUploadedFiles()));
                }
                if (StringUtils.isNotEmpty((CharSequence)backupBatch.getUploadedSize())) {
                    overView.setLastSucessfulBkpTotalSizeOfFiles(Long.parseLong(backupBatch.getUploadedSize()) / 1024L);
                } else {
                    overView.setLastSucessfulBkpTotalSizeOfFiles(0L);
                }
                overView.setLastSucessfulBkpNoOfFiles(this.getActualUploadedFiles(backupBatch.getUploadedFiles()));
                overView.setCurrentlyRunningBkpNoOfFiles(0L);
                overView.setCurrentlyRunningBkpTotalSizeOfFiles(0L);
            }
            overView.setReason(backupBatch.getErrorCode());
            if (!StringUtils.isEmpty((CharSequence)backupBatch.getStatus()) && backupBatch.getStatus().equals("ABORTED")) {
                overView.setCurrentlyRunningBkpNoOfFiles(0L);
                overView.setCurrentlyRunningBkpTotalSizeOfFiles(0L);
            }
            overView.setTotalSizeToUpload(backupBatch.getTotalSizeToUpload());
            logger.debug("...end noofsuccessfulbkps... " + overView.getNoOfSuccessfulBackups());
            this.eventHubDao.updateDeviceBackupOverView(cloudId, overView);
        }
    }

    private String getDateInFormat(Long deviceCreatedDate) {
        SimpleDateFormat df2 = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss");
        Date dateD = new Date(deviceCreatedDate);
        return df2.format(dateD);
    }

    private String getNoOfFilesRemaining(String totalNoOfFilesFromBatch, String uploadedFilesBatchTemp) {
        Object uploadedFilesBatch = uploadedFilesBatchTemp;
        Integer noOfFilesRemaining = 0;
        logger.debug(" Files ********************** " + (String)uploadedFilesBatch);
        if (StringUtils.isEmpty((CharSequence)uploadedFilesBatch)) {
            uploadedFilesBatch = "0/" + totalNoOfFilesFromBatch;
        }
        String[] parts = ((String)uploadedFilesBatch).split("/");
        try {
            Integer actualNoOfFiles = Integer.parseInt(parts[1]);
            Integer noOfFilesBackedup = Integer.parseInt(parts[0]);
            noOfFilesRemaining = actualNoOfFiles - noOfFilesBackedup;
        }
        catch (Exception e) {
            logger.trace("Exception  :" + String.valueOf(e));
            logger.error("Exception  :" + e.getMessage());
        }
        return noOfFilesRemaining.toString();
    }

    long getActualUploadedFiles(String uploadedFiles) {
        if (StringUtils.isEmpty((CharSequence)uploadedFiles)) {
            uploadedFiles = "0/0";
        }
        String[] parts = uploadedFiles.split("/");
        return Long.parseLong(parts[0]);
    }

    public void saveDeviceBackupOverView(int cloudId, Device device) {
        DeviceBackupOverView backupOverView = new DeviceBackupOverView();
        User user = this.userDao.getUserByName(cloudId, device.getUserName());
        ObjectId deviceId = device.getId();
        Object[] arr = this.eventHubDao.getBackupDateHistoryElement(cloudId, "", device.getUserName(), device.getDeviceUUID());
        if (arr[0] != null) {
            String lastSuccessfulBkp = this.getDateInFormat((Long)arr[0]);
            backupOverView.setLastSuccessfulBkp(lastSuccessfulBkp);
        }
        if (arr[1] != null) {
            String firstSuccessfulBkp = this.getDateInFormat((Long)arr[1]);
            backupOverView.setFirstBkpStartTime(firstSuccessfulBkp);
        }
        if (arr[2] != null) {
            backupOverView.setLastBkpStatus(arr[2].toString());
            backupOverView.setReason(arr[3].toString());
            backupOverView.setLastBkpStartTime(this.getDateInFormat((Long)arr[4]));
        }
        backupOverView.setTotalNoOfFiles(arr[5].toString());
        backupOverView.setNoOfFilesRemaining(arr[6].toString());
        String userName = user.getUserName();
        long storageUsed = this.backUpImageDao.getTotalSizeUsedByUserForDevice(cloudId, userName, deviceId);
        if (StringUtils.isEmpty((CharSequence)user.getPolicyName())) {
            BackupPolicy policy = this.userDao.getBackupPolicyByPolicyName(1, user.getPolicyName());
            if (!StringUtils.isEmpty((CharSequence)user.getPolicyName())) {
                // empty if block
            }
        }
        backupOverView.setStorageUtilized(storageUsed);
        Object[] countArr = this.eventHubDao.getCountForJobType(cloudId, device.getDeviceUUID(), device.getUserName());
        if (countArr[1] != null) {
            Long noOfSuccessfulBackups = (Long)countArr[1];
            logger.debug(" ############### ....  ..... " + noOfSuccessfulBackups);
            backupOverView.setNoOfSuccessfulBackups(noOfSuccessfulBackups.longValue());
        }
        if (countArr[0] != null) {
            Long noOfSuccessfulRestores = (Long)countArr[0];
            logger.debug(" #####@@@@@@######### ....  ..... " + noOfSuccessfulRestores);
            backupOverView.setNoOfSuccessfulRestores(noOfSuccessfulRestores.longValue());
        }
        device.setUserId(user.getUserId());
        device.setUserName(user.getUserName());
        backupOverView.setUserName(user.getUserName());
        backupOverView.setEmailId(user.getEmailId());
        backupOverView.setUserActive(user.isActive());
        backupOverView.setUserDeleted(user.isDeleted());
        backupOverView.setPolicyName(user.getPolicyName());
        backupOverView.setDeviceBolcked(device.isBlocked());
        backupOverView.setDeviceUUID(device.getDeviceUUID());
        backupOverView.setClientVersion(device.getClientVersion());
        backupOverView.setEpaInstallationDate(device.getDeviceCreatedDate());
        backupOverView.setDeviceName(device.getDeviceName());
        backupOverView.setDeviceDeleted(device.isDeleted());
        this.backupOverViewDao.saveDeviceBackupOverView(cloudId, backupOverView);
        this.deviceDao.updateDevice(cloudId, device);
    }

    @Override
    public void resumeBackup(String policyNameFinal, Device device, Cloud cloudFinal) {
        this.eventHubDao.resumeBackup(policyNameFinal, device, cloudFinal);
    }

    @Override
    public OfficeBackupPolicy getOfficeBackupPolicyForNameAndType(int cloudId, String policyName, String policyType) {
        return this.eventHubDao.getOfficeBackupPolicyForNameAndType(cloudId, policyName, policyType);
    }

    @Override
    public RestoreHistory getRestoreHistoryForUUID(int cloudId, String deviceUUID) {
        RestoreEvents restoreEvents = this.eventHubDao.getRestoreEventsBySourceUUID(cloudId, deviceUUID);
        RestoreHistory restoreHistory = null;
        if (restoreEvents != null) {
            logger.debug(deviceUUID + "....getRestoreHistoryByIdorUUID events exists check latest.." + String.valueOf(restoreEvents.getId()));
            restoreHistory = this.backupBatchDao.getRestoreHistoryByIdorUUID(cloudId, restoreEvents.getId(), deviceUUID);
        }
        return restoreHistory;
    }

    @Override
    public void removeRestoreProgressbyBatchID(int cloudId, String batchId) {
        this.eventHubDao.removeRestoreProgressbyBatchID(cloudId, batchId);
    }

    @Override
    public ApiGateWayProperties getApiGateWayProperties(int cloudId) {
        return this.eventHubDao.getApiGateWayProperties(cloudId);
    }

    @Override
    public GmailBackupPolicy getGmailBackupPolicy(int cloudId, String cloudName, String policyName, String policyType) {
        GmailBackupPolicy backupPolicy = this.oneDriveBackupPolicyDao.getGmailBackupPolicy(cloudId, policyName, policyType);
        return backupPolicy;
    }
}

