/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.bluvault.udc.service.impl;

import com.azure.core.credential.TokenCredential;
import com.azure.core.http.ProxyOptions;
import com.azure.identity.ClientSecretCredential;
import com.azure.identity.ClientSecretCredentialBuilder;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.api.client.googleapis.javanet.GoogleNetHttpTransport;
import com.google.api.client.googleapis.json.GoogleJsonResponseException;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.gson.GsonFactory;
import com.google.api.services.admin.directory.Directory;
import com.google.api.services.admin.directory.model.Member;
import com.google.api.services.admin.directory.model.Members;
import com.google.auth.Credentials;
import com.google.auth.http.HttpCredentialsAdapter;
import com.google.auth.oauth2.GoogleCredentials;
import com.microsoft.aad.adal4j.AuthenticationContext;
import com.microsoft.aad.adal4j.AuthenticationResult;
import com.microsoft.graph.authentication.IAuthenticationProvider;
import com.microsoft.graph.authentication.TokenCredentialAuthProvider;
import com.microsoft.graph.requests.GraphServiceClient;
import com.parablu.bluvault.ah.service.AuditHistoryService;
import com.parablu.bluvault.udc.service.AADManagementService;
import com.parablu.bluvault.udc.service.DeviceManagementService;
import com.parablu.cloud.security.service.impl.UserValidateService;
import com.parablu.helper.exceptions.BaseException;
import com.parablu.helper.utils.AAdCredentialsElementDiffFinder;
import com.parablu.paracloud.constant.CPHelperConstant;
import com.parablu.paracloud.constant.CloudConfigRegistry;
import com.parablu.paracloud.constant.PCActionTypes;
import com.parablu.paracloud.element.AADAuthorizationTokenElement;
import com.parablu.paracloud.element.AADUserElement;
import com.parablu.paracloud.element.AADUserNamesList;
import com.parablu.paracloud.element.GraphGroupDeltaItemTO;
import com.parablu.paracloud.element.GraphGroupDeltaPageTO;
import com.parablu.paracloud.element.GraphGroupInfo;
import com.parablu.paracloud.element.GraphResponseForMemberOf;
import com.parablu.paracloud.element.GroupMapping;
import com.parablu.paracloud.element.IdentityProviderSettingsElement;
import com.parablu.paracloud.element.OktaUserElement;
import com.parablu.paracloud.element.UserElement;
import com.parablu.pcbd.dao.AADDao;
import com.parablu.pcbd.dao.AuditHistoryDao;
import com.parablu.pcbd.dao.AuthorizationDao;
import com.parablu.pcbd.dao.BackupPolicyDao;
import com.parablu.pcbd.dao.CloudDao;
import com.parablu.pcbd.dao.DeviceDao;
import com.parablu.pcbd.dao.MigrationStatusDao;
import com.parablu.pcbd.dao.PortalPropertiesDao;
import com.parablu.pcbd.dao.SettingsDao;
import com.parablu.pcbd.dao.UserDao;
import com.parablu.pcbd.domain.AADAuthorizationToken;
import com.parablu.pcbd.domain.AuditHistory;
import com.parablu.pcbd.domain.Cloud;
import com.parablu.pcbd.domain.CloudCustomisableDetails;
import com.parablu.pcbd.domain.CloudProperties;
import com.parablu.pcbd.domain.Device;
import com.parablu.pcbd.domain.IdentityProviderSettings;
import com.parablu.pcbd.domain.MSAppSetting;
import com.parablu.pcbd.domain.MigrationStatus;
import com.parablu.pcbd.domain.PortalProperties;
import com.parablu.pcbd.domain.Proxy;
import com.parablu.pcbd.domain.User;
import com.parablu.pcsd.dao.SyncPolicyDao;
import jakarta.annotation.Resource;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.invoke.CallSite;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import okhttp3.Authenticator;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.Route;
import org.apache.commons.codec.binary.Base32;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.DefaultProxyRoutePlanner;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class AADManagementServiceImpl
extends UserValidateService
implements AADManagementService {
    private static Logger logger = LogManager.getLogger(AADManagementServiceImpl.class);
    public static final String AUTHORITY = "https://login.microsoftonline.com/common/";
    public static final String GRAPH_VERSION = "v1.0/";
    public static final String GRAPH_VERSION_BETA = "beta/";
    public static final String GRAPH_ME = "me";
    public static final String GRAPH_HOME = "https://graph.microsoft.com/";
    public static final String GRAPH_MEMBER_OF = "me/memberOf";
    public static final String GRAPH_USER_MEMBER_OF = "/memberOf";
    public static final String GRAPH_USERS = "/users/";
    public static final String GRAPH_GROUP_DELTA = "groups/delta";
    private static final String TOKEN_URL = "https://login.windows.net/";
    private static final String OAUTH2_TOKEN_URL = "/oauth2/token";
    private static final String TOKEN = "/token";
    private static final String UTF_8 = "UTF-8";
    private static final String REFRESH_TOKEN = "refresh_token";
    public static final String CONTENT_TYPE = "Content-Type";
    private static final String EXCEPTION = " Exception  :";
    private static final String BACK_UP_ENABLED = "Backup Enabled";
    private static final String SYNC_ENABLED = "Sync Enabled";
    private static final String AUTHORIZATION_CODE = "authorization_code";
    private static final String LOGIN_URL = "https://login.microsoftonline.com/";
    private static final String OKTA_LOGIN_URL = "/oauth2/v1";
    private static final String ONE_LOGIN_URL = "/oidc/2";
    private static final String HTTPS = "https://";
    private static final String ONE_LOGIN_USER_INFO = "/me";
    private static final String OKTA_USER_INFO = "/userinfo";
    public static final String GRAPH_USER = "/users";
    private static final String ODB_BACKUP_ENABLED = "OneDrive Backup Enabled";
    private static final String GMAIL_BACKUP_ENABLED = "GMAIL Backup Enabled";
    private static final String GDRIVE_BACKUP_ENABLED = "GDRIVE Backup Enabled";
    private static final String EXCHANGE_BACKUP_ENABLED = "Exchange Backup Enabled";
    private static final String SHARE_POINT_BACKUP_ENABLED = "Sharepoint Backup Enabled";
    private static final String CRASHPLAN_LOGIN_URL = "/api/v3/oauth";
    private static final String NONCE = "67b704cc7bb57e09e49a6c6f";
    private static final String MICROSOFT = "Microsoft";
    private static final String OKTA = "okta";
    private static final String ONE_LOGIN = "OneLogin";
    private static final JsonFactory JSON_FACTORY = GsonFactory.getDefaultInstance();
    private AADDao aadDao;
    private UserDao userDao;
    private BackupPolicyDao backupPolicyDao;
    private SyncPolicyDao syncPolicyDao;
    private MigrationStatusDao migrationStatusDao;
    private SettingsDao settingsDao;
    @Autowired
    private DeviceManagementService deviceManagementService;
    @Autowired
    private AuditHistoryService auditHistoryService;
    @Autowired
    private RestTemplate restTemplate;
    @Resource
    private PortalPropertiesDao portalPropertiesDao;
    @Resource
    private CloudDao cloudDao;
    @Resource
    private DeviceDao deviceDao;
    @Autowired
    CloudConfigRegistry registry;
    @Resource
    private AuditHistoryDao auditHistoryDao;
    @Resource
    private AuthorizationDao authorizationDao;

    public PortalPropertiesDao getPortalPropertiesDao() {
        return this.portalPropertiesDao;
    }

    public void setPortalPropertiesDao(PortalPropertiesDao portalPropertiesDao) {
        this.portalPropertiesDao = portalPropertiesDao;
    }

    public CloudDao getCloudDao() {
        return this.cloudDao;
    }

    public void setCloudDao(CloudDao cloudDao) {
        this.cloudDao = cloudDao;
    }

    public DeviceDao getDeviceDao() {
        return this.deviceDao;
    }

    public void setDeviceDao(DeviceDao deviceDao) {
        this.deviceDao = deviceDao;
    }

    public AuthorizationDao getAuthorizationDao() {
        return this.authorizationDao;
    }

    public void setAuthorizationDao(AuthorizationDao authorizationDao) {
        this.authorizationDao = authorizationDao;
    }

    public AuditHistoryDao getAuditHistoryDao() {
        return this.auditHistoryDao;
    }

    public void setAuditHistoryDao(AuditHistoryDao auditHistoryDao) {
        this.auditHistoryDao = auditHistoryDao;
    }

    public AADDao getAadDao() {
        return this.aadDao;
    }

    public void setAadDao(AADDao aadDao) {
        this.aadDao = aadDao;
    }

    @Override
    public IdentityProviderSettingsElement getAADCredentials(int cloudId) {
        logger.debug("......Inside getAADCredentials....");
        IdentityProviderSettingsElement aadCredentialsElement = null;
        IdentityProviderSettings aadCredentials = this.aadDao.getAADCredentials(cloudId);
        if (aadCredentials != null) {
            aadCredentialsElement = new IdentityProviderSettingsElement();
            BeanUtils.copyProperties((Object)aadCredentials, (Object)aadCredentialsElement);
            ArrayList<GroupMapping> aadCredPrdouctPolicies = new ArrayList<GroupMapping>();
            if (!CollectionUtils.isEmpty((Collection)aadCredentials.getGroupMapping())) {
                for (GroupMapping GroupMapping2 : aadCredentials.getGroupMapping()) {
                    logger.debug(".....aadcredpolicy..." + GroupMapping2.getGroupName() + "...." + GroupMapping2.getPolicyName());
                    GroupMapping credPrdouctPolicy = new GroupMapping();
                    BeanUtils.copyProperties((Object)GroupMapping2, (Object)credPrdouctPolicy);
                    credPrdouctPolicy.setId(this.generateKey(GroupMapping2));
                    aadCredPrdouctPolicies.add(credPrdouctPolicy);
                }
            }
            aadCredentialsElement.setGroupMapping(aadCredPrdouctPolicies);
            AADAuthorizationToken token = this.aadDao.getAADAuthorizationtoken(cloudId);
            if (token == null) {
                aadCredentialsElement.setAuthRequired(true);
            } else if (!org.springframework.util.StringUtils.isEmpty((Object)token.getUser_principal())) {
                aadCredentialsElement.setUser_principal(token.getUser_principal());
            }
        }
        return aadCredentialsElement;
    }

    @Override
    public IdentityProviderSettingsElement getCrashPlanCredentials(int cloudId) {
        logger.debug("......Inside getAADCredentials....");
        IdentityProviderSettingsElement aadCredentialsElement = null;
        IdentityProviderSettings aadCredentials = this.aadDao.getCrashPlanIDPCredentials(cloudId);
        if (aadCredentials != null) {
            aadCredentialsElement = new IdentityProviderSettingsElement();
            BeanUtils.copyProperties((Object)aadCredentials, (Object)aadCredentialsElement);
            ArrayList<GroupMapping> aadCredPrdouctPolicies = new ArrayList<GroupMapping>();
            if (!CollectionUtils.isEmpty((Collection)aadCredentials.getGroupMapping())) {
                for (GroupMapping GroupMapping2 : aadCredentials.getGroupMapping()) {
                    logger.debug(".....aadcredpolicy..." + GroupMapping2.getGroupName() + "...." + GroupMapping2.getPolicyName());
                    GroupMapping credPrdouctPolicy = new GroupMapping();
                    BeanUtils.copyProperties((Object)GroupMapping2, (Object)credPrdouctPolicy);
                    credPrdouctPolicy.setId(this.generateKey(GroupMapping2));
                    aadCredPrdouctPolicies.add(credPrdouctPolicy);
                }
            }
            aadCredentialsElement.setGroupMapping(aadCredPrdouctPolicies);
            AADAuthorizationToken token = this.aadDao.getAADAuthorizationtoken(cloudId);
            if (token == null) {
                aadCredentialsElement.setAuthRequired(true);
            } else if (!org.springframework.util.StringUtils.isEmpty((Object)token.getUser_principal())) {
                aadCredentialsElement.setUser_principal(token.getUser_principal());
            }
        }
        return aadCredentialsElement;
    }

    @Override
    public AADAuthorizationToken getAADAuthorizationToken(int cloudId) {
        logger.debug("......Inside getAADCredentials......");
        return this.aadDao.getAADAuthorizationtoken(cloudId);
    }

    @Override
    public boolean saveAADCredentials(Cloud cloud, IdentityProviderSettingsElement aadCredentials, String currentUserName) {
        logger.debug("......Inside saveAADCredentials....");
        int cloudId = cloud.getCloudId();
        IdentityProviderSettingsElement existingAADCredentialsElement = this.getAADCredentials(cloudId);
        if (aadCredentials != null) {
            try {
                List existingAADCredentials = this.aadDao.getAllAADCredentials(cloudId);
                this.aadDao.removeAADCredentials(cloudId);
                IdentityProviderSettings credentials = new IdentityProviderSettings();
                ArrayList<GroupMapping> aadCredPrdouctPolicies = new ArrayList<GroupMapping>();
                if (!CollectionUtils.isEmpty((Collection)aadCredentials.getGroupMapping())) {
                    for (GroupMapping GroupMapping2 : aadCredentials.getGroupMapping()) {
                        logger.debug(GroupMapping2.getId() + ".....aadcredpolicy..." + GroupMapping2.getGroupName() + "...." + GroupMapping2.getPolicyName());
                        GroupMapping credPrdouctPolicy = new GroupMapping();
                        BeanUtils.copyProperties((Object)GroupMapping2, (Object)credPrdouctPolicy);
                        aadCredPrdouctPolicies.add(credPrdouctPolicy);
                    }
                }
                BeanUtils.copyProperties((Object)aadCredentials, (Object)credentials);
                if (StringUtils.isNotEmpty((CharSequence)aadCredentials.getSecretKey())) {
                    credentials.setSecretKey(aadCredentials.getSecretKey());
                } else if (existingAADCredentialsElement != null) {
                    credentials.setSecretKey(existingAADCredentialsElement.getSecretKey());
                }
                if (StringUtils.isNotEmpty((CharSequence)aadCredentials.getApiToken())) {
                    credentials.setApiToken(aadCredentials.getApiToken());
                } else if (existingAADCredentialsElement != null) {
                    credentials.setApiToken(existingAADCredentialsElement.getApiToken());
                }
                if (credentials.getLoginMode().equalsIgnoreCase(OKTA)) {
                    ArrayList<GroupMapping> groupMappingNew = new ArrayList<GroupMapping>();
                    if (!CollectionUtils.isEmpty((Collection)credentials.getGroupMapping()) && credentials.getGroupMapping().size() > 0) {
                        for (GroupMapping group : credentials.getGroupMapping()) {
                            String GroupId = AADManagementServiceImpl.getOktaGroupIdByGroupName(credentials.getTenentId(), credentials.getApiToken(), group.getGroupName());
                            if (org.springframework.util.StringUtils.isEmpty((Object)GroupId)) {
                                logger.debug("Failed to get the group ID......");
                                return false;
                            }
                            group.setGroupID(GroupId);
                            groupMappingNew.add(group);
                        }
                    }
                    credentials.setGroupMapping(groupMappingNew);
                }
                this.aadDao.saveAADCredentials(cloudId, credentials);
                this.cloudDao.saveCloudPropertiesPolicy(cloudId, aadCredentials);
                this.resetDefaultPoliciesInPCHelper(cloudId, aadCredentials);
                StringBuilder groupConfigurationFieldChange = new StringBuilder();
                this.checkDefaultPolicy(aadCredentials, groupConfigurationFieldChange, cloudId);
                if (existingAADCredentials == null || existingAADCredentials.isEmpty()) {
                    this.addAuditHistory(cloud, aadCredentials, currentUserName, groupConfigurationFieldChange);
                }
                this.checkpolicyIsChangedorNot(aadCredentials, cloudId, groupConfigurationFieldChange);
                if (existingAADCredentials != null && existingAADCredentials.size() > 0) {
                    this.addAuditHistoryForEdit(cloud, aadCredentials, currentUserName, existingAADCredentialsElement, existingAADCredentials, credentials, groupConfigurationFieldChange);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.debug("failed during save ad credentials" + String.valueOf(e));
                logger.error("failed during save ad credentials......" + e.getMessage());
                return false;
            }
        }
        return true;
    }

    private void addAuditHistoryForEdit(Cloud cloud, IdentityProviderSettingsElement aadCredentials, String currentUserName, IdentityProviderSettingsElement existingAADCredentialsElement, List<IdentityProviderSettings> existingAADCredentials, IdentityProviderSettings credentials, StringBuilder groupConfigurationFieldChange) {
        String auditString;
        logger.debug("existing IdP/AAD Credentials" + String.valueOf(existingAADCredentials));
        IdentityProviderSettings localAADCredentials = existingAADCredentials.get(0);
        ArrayList<GroupMapping> modifiedList = new ArrayList<GroupMapping>();
        if (!CollectionUtils.isEmpty((Collection)localAADCredentials.getGroupMapping())) {
            for (GroupMapping GroupMapping2 : localAADCredentials.getGroupMapping()) {
                GroupMapping2.setId(this.generateKey(GroupMapping2));
                modifiedList.add(GroupMapping2);
            }
        }
        localAADCredentials.setGroupMapping(modifiedList);
        if (localAADCredentials != null && aadCredentials.isManyToManyMappingEnabled() != localAADCredentials.isManyToManyMappingEnabled()) {
            groupConfigurationFieldChange.append("(Many to Many mapping values " + localAADCredentials.isManyToManyMappingEnabled() + " => " + aadCredentials.isManyToManyMappingEnabled() + ")");
        }
        if (localAADCredentials != null && aadCredentials.isManyToManyMappingEnabled()) {
            auditString = this.findManyToManyAADGroupDifference(localAADCredentials, credentials);
            groupConfigurationFieldChange.append(auditString);
        }
        auditString = this.findManyToManyAADGroupDifference(existingAADCredentials.get(0), credentials);
        logger.info("auditString va-----" + auditString);
        AAdCredentialsElementDiffFinder aadCredentialsElementDiffFinder = new AAdCredentialsElementDiffFinder();
        String changedFields = aadCredentialsElementDiffFinder.findDiff(existingAADCredentialsElement, aadCredentials);
        logger.info("auditString bb-----" + changedFields);
        StringBuilder groupConfigurationFieldChangeFinal = new StringBuilder();
        if (org.springframework.util.StringUtils.hasText((String)changedFields) || org.springframework.util.StringUtils.hasText((String)auditString) || org.springframework.util.StringUtils.hasText((CharSequence)groupConfigurationFieldChange)) {
            String loginMode = aadCredentials.getLoginMode();
            if (MICROSOFT.equalsIgnoreCase(loginMode)) {
                loginMode = "Microsoft Entra";
            } else if ("Google".equalsIgnoreCase(loginMode)) {
                loginMode = "Google Identity";
            }
            groupConfigurationFieldChangeFinal.append("Modified IdP Configuration [Type: ");
            groupConfigurationFieldChangeFinal.append(loginMode);
            groupConfigurationFieldChangeFinal.append("]: ");
        }
        if (org.springframework.util.StringUtils.hasText((String)changedFields)) {
            groupConfigurationFieldChangeFinal.append(changedFields);
        }
        if (org.springframework.util.StringUtils.hasText((String)auditString)) {
            groupConfigurationFieldChangeFinal.append(auditString);
        }
        if (!org.springframework.util.StringUtils.isEmpty((Object)auditString) || !org.springframework.util.StringUtils.isEmpty((Object)changedFields)) {
            logger.debug(org.springframework.util.StringUtils.hasText((CharSequence)groupConfigurationFieldChange) + "...value before...." + groupConfigurationFieldChange.toString());
            if (org.springframework.util.StringUtils.hasText((CharSequence)groupConfigurationFieldChange)) {
                groupConfigurationFieldChangeFinal.append(", modified ");
            }
        }
        groupConfigurationFieldChangeFinal.append(groupConfigurationFieldChange.toString());
        auditString = groupConfigurationFieldChangeFinal.toString();
        logger.info("auditString-----" + auditString);
        if (org.springframework.util.StringUtils.hasText((String)auditString)) {
            this.saveStatisticToDatabase(cloud, auditString, currentUserName, "", "", System.currentTimeMillis(), PCActionTypes.AAD_GROUP_CONFIGURATION_MODIFY.getActionTypeValue());
        }
    }

    private void addAuditHistory(Cloud cloud, IdentityProviderSettingsElement aadCredentials, String currentUserName, StringBuilder groupConfigurationFieldChange) {
        logger.info("No existing IdP credentials found for cloudName: " + cloud.getCloudName());
        StringBuilder initialAuditString = new StringBuilder();
        String loginMode = aadCredentials.getLoginMode();
        if (MICROSOFT.equalsIgnoreCase(loginMode)) {
            loginMode = "Microsoft Entra";
        } else if ("Google".equalsIgnoreCase(loginMode)) {
            loginMode = "Google Identity";
        }
        initialAuditString.append("Initial IdP Configuration [Type: ");
        initialAuditString.append(loginMode);
        initialAuditString.append("]: ");
        AAdCredentialsElementDiffFinder aadCredentialsElementDiffFinder = new AAdCredentialsElementDiffFinder();
        String newConfigFields = aadCredentialsElementDiffFinder.findDiff(new IdentityProviderSettingsElement(), aadCredentials);
        if (org.springframework.util.StringUtils.hasText((String)newConfigFields)) {
            initialAuditString.append(newConfigFields);
        }
        if (org.springframework.util.StringUtils.hasText((CharSequence)groupConfigurationFieldChange)) {
            initialAuditString.append(groupConfigurationFieldChange.toString());
        }
        if (!CollectionUtils.isEmpty((Collection)aadCredentials.getGroupMapping())) {
            StringBuilder groupMappingDetails = new StringBuilder();
            for (GroupMapping groupMapping : aadCredentials.getGroupMapping()) {
                if (groupMappingDetails.length() > 0) {
                    groupMappingDetails.append(", ");
                }
                groupMappingDetails.append("Group: ").append(groupMapping.getGroupName()).append(" => Policy: ").append(groupMapping.getPolicyName());
            }
            if (groupMappingDetails.length() > 0) {
                initialAuditString.append(", Group Mappings: [").append(groupMappingDetails.toString()).append("]");
            }
        }
        if (aadCredentials.isManyToManyMappingEnabled()) {
            initialAuditString.append("(Many to Many mapping values => ").append(aadCredentials.isManyToManyMappingEnabled()).append(")");
        } else {
            initialAuditString.append("(Many to Many mapping values => false)");
        }
        logger.info("Initial IdP setup auditString: " + initialAuditString.toString());
        if (org.springframework.util.StringUtils.hasText((String)initialAuditString.toString())) {
            this.saveStatisticToDatabase(cloud, initialAuditString.toString(), currentUserName, "", "", System.currentTimeMillis(), PCActionTypes.AAD_GROUP_CONFIGURATION_MODIFY.getActionTypeValue());
        }
    }

    private void checkDefaultPolicy(IdentityProviderSettingsElement aadCredentials, StringBuilder groupConfigurationFieldChange, int cloudId) {
        logger.info("......Inside checkDefaultPolicy....");
        CloudProperties cloudProperties = this.cloudDao.getCloudProperties(cloudId);
        if (cloudProperties != null) {
            if (!Objects.equals(cloudProperties.getDefaultExchangePolicyName(), aadCredentials.getDefaultExchangePolicyName())) {
                groupConfigurationFieldChange.append("(Default Exchange Policy Name values ").append(cloudProperties.getDefaultExchangePolicyName()).append(" => ").append(aadCredentials.getDefaultExchangePolicyName()).append(")");
            }
            if (!Objects.equals(cloudProperties.getDefaultBkpPolicyName(), aadCredentials.getDefaultBkpPolicyName())) {
                groupConfigurationFieldChange.append("(Default Backup Policy Name values ").append(cloudProperties.getDefaultBkpPolicyName()).append(" => ").append(aadCredentials.getDefaultBkpPolicyName()).append(")");
            }
            if (!Objects.equals(cloudProperties.getDefaultOdbPolicyName(), aadCredentials.getDefaultOdbPolicyName())) {
                groupConfigurationFieldChange.append("(Default Onedrive Policy Name values ").append(cloudProperties.getDefaultOdbPolicyName()).append(" => ").append(aadCredentials.getDefaultOdbPolicyName()).append(")");
            }
            if (!Objects.equals(cloudProperties.getDefaultSharepointPolicyName(), aadCredentials.getDefaultSharepointPolicyName())) {
                groupConfigurationFieldChange.append("(Default Sharepoint Policy Name values ").append(cloudProperties.getDefaultSharepointPolicyName()).append(" => ").append(aadCredentials.getDefaultSharepointPolicyName()).append(")");
            }
            if (!Objects.equals(cloudProperties.getDefaultGmailPolicyName(), aadCredentials.getDefaultGmailPolicyName())) {
                groupConfigurationFieldChange.append("(Default Gmail Policy Name values ").append(cloudProperties.getDefaultGmailPolicyName()).append(" => ").append(aadCredentials.getDefaultGmailPolicyName()).append(")");
            }
            if (!Objects.equals(cloudProperties.getDefaultGdrivePolicyName(), aadCredentials.getDefaultGdrivePolicyName())) {
                groupConfigurationFieldChange.append("(Default Gdrive Policy Name values ").append(cloudProperties.getDefaultGdrivePolicyName()).append(" => ").append(aadCredentials.getDefaultGdrivePolicyName()).append(")");
            }
        }
    }

    private void checkpolicyIsChangedorNot(IdentityProviderSettingsElement aadCredentials, int cloudId, StringBuilder groupConfigurationFieldChange) {
        CloudProperties cloudProperties = this.cloudDao.getCloudProperties(cloudId);
        if (cloudProperties != null) {
            if (!Objects.equals(cloudProperties.getDefaultExchangePolicyName(), aadCredentials.getDefaultExchangePolicyName())) {
                groupConfigurationFieldChange.append("(Default Exchange Policy Name values " + cloudProperties.getDefaultExchangePolicyName() + " => " + aadCredentials.getDefaultExchangePolicyName() + ")");
            }
            if (!Objects.equals(cloudProperties.getDefaultBkpPolicyName(), aadCredentials.getDefaultBkpPolicyName())) {
                groupConfigurationFieldChange.append("(Default Backup Policy Name values " + cloudProperties.getDefaultBkpPolicyName() + " => " + aadCredentials.getDefaultBkpPolicyName() + ")");
            }
            if (!Objects.equals(cloudProperties.getDefaultOdbPolicyName(), aadCredentials.getDefaultOdbPolicyName())) {
                groupConfigurationFieldChange.append("(Default Onedrive Policy Name values " + cloudProperties.getDefaultOdbPolicyName() + " => " + aadCredentials.getDefaultOdbPolicyName() + ")");
            }
            if (!Objects.equals(cloudProperties.getDefaultSharepointPolicyName(), aadCredentials.getDefaultSharepointPolicyName())) {
                groupConfigurationFieldChange.append("(Default Sharepoint Policy Name values " + cloudProperties.getDefaultSharepointPolicyName() + " => " + aadCredentials.getDefaultSharepointPolicyName() + ")");
            }
            if (!Objects.equals(cloudProperties.getDefaultGmailPolicyName(), aadCredentials.getDefaultGmailPolicyName())) {
                groupConfigurationFieldChange.append("(Default Gmail Policy Name values " + cloudProperties.getDefaultGmailPolicyName() + " => " + aadCredentials.getDefaultGmailPolicyName() + ")");
            }
            if (!Objects.equals(cloudProperties.getDefaultGdrivePolicyName(), aadCredentials.getDefaultGdrivePolicyName())) {
                groupConfigurationFieldChange.append("(Default Gdrive Policy Name values " + cloudProperties.getDefaultGdrivePolicyName() + " => " + aadCredentials.getDefaultGdrivePolicyName() + ")");
            }
        }
    }

    private void resetDefaultPoliciesInPCHelper(int cloudId, IdentityProviderSettingsElement aadCredentials) {
        this.registry.get(cloudId).setPropertyFileValueDefaultBkpPolicy(aadCredentials.getDefaultBkpPolicyName());
        this.registry.get(cloudId).setPropertyFileValueDefaultSyncPolicy(aadCredentials.getDefaultSyncPolicyName());
        this.registry.get(cloudId).setPropertyFileValueDefaultOdbPolicy(aadCredentials.getDefaultOdbPolicyName());
        this.registry.get(cloudId).setPropertyFileValueDefaultExchangePolicy(aadCredentials.getDefaultExchangePolicyName());
        this.registry.get(cloudId).setPropertyFileDefaultSharepointPolicy(aadCredentials.getDefaultSharepointPolicyName());
        this.registry.get(cloudId).setDefaultGmailPolicy(aadCredentials.getDefaultGmailPolicyName());
        this.registry.get(cloudId).setDefaultGdrivePolicyName(aadCredentials.getDefaultGdrivePolicyName());
    }

    @Override
    public AADAuthorizationTokenElement saveAADAuthorizationtoken(int cloudId, AADAuthorizationTokenElement aadAuthorizationTokenElement) {
        logger.debug("......Inside saveAADAuthorizationtoken...." + aadAuthorizationTokenElement.toString());
        if (aadAuthorizationTokenElement != null) {
            AADAuthorizationToken authorizationToken = this.aadDao.getAADAuthorizationtoken(cloudId);
            if (authorizationToken == null) {
                authorizationToken = new AADAuthorizationToken();
            }
            BeanUtils.copyProperties((Object)aadAuthorizationTokenElement, (Object)authorizationToken);
            try {
                AADUserElement aadUserElement = this.getAADUserByAccessToken(cloudId, authorizationToken.getAccess_token());
                if (aadUserElement != null && !org.springframework.util.StringUtils.isEmpty((Object)aadUserElement.getMail())) {
                    authorizationToken.setUser_principal(aadUserElement.getMail());
                }
            }
            catch (Exception e) {
                logger.debug("failed getUserInfoFromGraph" + String.valueOf(e));
                logger.error("failed getUserInfoFromGraph......" + e.getMessage());
            }
            logger.debug("......Inside saveAADAuthorizationtoken...." + authorizationToken.toString());
            this.aadDao.saveAADAuthorizationtoken(cloudId, authorizationToken);
            aadAuthorizationTokenElement.setUser_principal(authorizationToken.getUser_principal());
        }
        return aadAuthorizationTokenElement;
    }

    @Override
    public AADUserElement getAADUserByAccessToken(int cloudId, String accessToken) throws IOException, JsonParseException, JsonMappingException {
        String userInfoFromGraph = this.getUserInfoFromGraph(cloudId, accessToken);
        logger.debug(".....userInfoFromGraph......." + userInfoFromGraph);
        ObjectMapper mapper = new ObjectMapper();
        mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        AADUserElement aadUserElement = (AADUserElement)mapper.readValue(userInfoFromGraph, AADUserElement.class);
        return aadUserElement;
    }

    public UserDao getUserDao() {
        return this.userDao;
    }

    public void setUserDao(UserDao userDao) {
        this.userDao = userDao;
    }

    public BackupPolicyDao getBackupPolicyDao() {
        return this.backupPolicyDao;
    }

    public void setBackupPolicyDao(BackupPolicyDao backupPolicyDao) {
        this.backupPolicyDao = backupPolicyDao;
    }

    public SyncPolicyDao getSyncPolicyDao() {
        return this.syncPolicyDao;
    }

    public void setSyncPolicyDao(SyncPolicyDao syncPolicyDao) {
        this.syncPolicyDao = syncPolicyDao;
    }

    public MigrationStatusDao getMigrationStatusDao() {
        return this.migrationStatusDao;
    }

    public void setMigrationStatusDao(MigrationStatusDao migrationStatusDao) {
        this.migrationStatusDao = migrationStatusDao;
    }

    public Object getAccessTokenFromUserCredentials(int cloudId, String username, String password, String clientID) {
        logger.debug("...clientID...." + clientID);
        AuthenticationResult result = null;
        ExecutorService service = Executors.newSingleThreadExecutor();
        try (Closeable close = service::shutdown;){
            AuthenticationContext context = new AuthenticationContext(AUTHORITY, false, service);
            if (this.getProxy(cloudId) != null) {
                context.setProxy(this.getProxy(cloudId));
            }
            Future future = context.acquireToken(GRAPH_HOME, clientID, username, password, null);
            result = (AuthenticationResult)future.get();
        }
        catch (Exception exp) {
            logger.error("Exception while getting AccessToken From UserCredentials................." + String.valueOf(exp));
            logger.trace("Exception while getting AccessToken From UserCredentials................." + exp.getMessage());
        }
        return result;
    }

    @Override
    public Object getAADUser(Cloud cloud, String userName, String password) {
        AADUserElement user = null;
        try {
            String userString;
            ObjectMapper mapper = new ObjectMapper();
            mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
            IdentityProviderSettings aadCredentials = this.aadDao.getAADCredentials(cloud.getCloudId());
            if (aadCredentials == null) {
                logger.debug("AAD crediential is empty so return");
                return user;
            }
            AuthenticationResult authenticationResult = (AuthenticationResult)this.getAccessTokenFromUserCredentials(cloud.getCloudId(), userName, password, aadCredentials.getClientIdForLogin());
            if (authenticationResult != null && !org.springframework.util.StringUtils.isEmpty((Object)authenticationResult.getAccessToken()) && (user = (AADUserElement)mapper.readValue(userString = this.getUserInfoFromGraph(cloud.getCloudId(), authenticationResult.getAccessToken()), AADUserElement.class)) != null) {
                boolean bkpEnabled = false;
                boolean syncEnabled = false;
                if (!CollectionUtils.isEmpty((Collection)aadCredentials.getGroupMapping())) {
                    Object searchString = "";
                    String displayName = "displayName:";
                    String OR = "";
                    for (GroupMapping mapping2 : aadCredentials.getGroupMapping()) {
                        String groupName = mapping2.getGroupName();
                        if (org.springframework.util.StringUtils.isEmpty((Object)groupName)) continue;
                        searchString = (String)searchString + OR;
                        searchString = (String)searchString + "%22" + displayName + groupName + "%22";
                        OR = "%20OR%20";
                    }
                    String userGroupInfo = this.getUserGroupsFromUserToken(cloud.getCloudId(), authenticationResult.getAccessToken(), (String)searchString);
                    if (!org.springframework.util.StringUtils.isEmpty((Object)userGroupInfo)) {
                        GraphResponseForMemberOf forMemberOf = (GraphResponseForMemberOf)mapper.readValue(userGroupInfo, GraphResponseForMemberOf.class);
                        if (!CollectionUtils.isEmpty((Collection)aadCredentials.getGroupMapping().stream().filter(mapping -> !org.springframework.util.StringUtils.isEmpty((Object)mapping.getGroupName())).collect(Collectors.toList()))) {
                            List groupInfo = forMemberOf.getGroupInfo();
                            List groupNames = groupInfo.stream().map(group -> group.getDisplayName().toLowerCase()).collect(Collectors.toList());
                            for (GroupMapping mapping3 : aadCredentials.getGroupMapping()) {
                                String groupName = mapping3.getGroupName();
                                if (org.springframework.util.StringUtils.isEmpty((Object)groupName)) {
                                    if (CPHelperConstant.PARABLU_PRODUCT_TYPE.BACKUP.getProductType().equalsIgnoreCase(mapping3.getProductType())) {
                                        bkpEnabled = true;
                                    }
                                    if (CPHelperConstant.PARABLU_PRODUCT_TYPE.SYNC.getProductType().equalsIgnoreCase(mapping3.getProductType())) {
                                        syncEnabled = true;
                                        continue;
                                    }
                                    bkpEnabled = true;
                                    syncEnabled = true;
                                    continue;
                                }
                                if (CollectionUtils.isEmpty(groupNames) || !groupNames.contains(groupName.toLowerCase())) continue;
                                if (CPHelperConstant.PARABLU_PRODUCT_TYPE.BACKUP.getProductType().equalsIgnoreCase(mapping3.getProductType())) {
                                    bkpEnabled = true;
                                    continue;
                                }
                                if (CPHelperConstant.PARABLU_PRODUCT_TYPE.SYNC.getProductType().equalsIgnoreCase(mapping3.getProductType())) {
                                    syncEnabled = true;
                                    continue;
                                }
                                bkpEnabled = true;
                                syncEnabled = true;
                            }
                        }
                    }
                }
                for (GroupMapping mapping4 : aadCredentials.getGroupMapping()) {
                    if (!"".equals(mapping4.getGroupName())) continue;
                    if (CPHelperConstant.PARABLU_PRODUCT_TYPE.BACKUP.getProductType().equalsIgnoreCase(mapping4.getProductType())) {
                        bkpEnabled = true;
                        continue;
                    }
                    if (mapping4.getProductType().equalsIgnoreCase(CPHelperConstant.PARABLU_PRODUCT_TYPE.SYNC.getProductType())) {
                        syncEnabled = true;
                        continue;
                    }
                    bkpEnabled = true;
                    syncEnabled = true;
                }
                if (bkpEnabled && syncEnabled) {
                    user.setProductType("BOTH");
                } else if (bkpEnabled) {
                    user.setProductType("BACKUP");
                } else if (syncEnabled) {
                    user.setProductType("SYNC");
                }
            }
        }
        catch (Exception e) {
            logger.error("Exception while getting userInfo from UserName and Password................." + String.valueOf(e));
            logger.trace("Exception while getting userInfo from UserName and Password................." + e.getMessage());
        }
        return user;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getUserInfoFromGraph(int cloudId, String accessToken) {
        CloseableHttpResponse result;
        CloseableHttpClient httpclient;
        StringBuilder response;
        block15: {
            response = new StringBuilder();
            httpclient = null;
            HttpGet httpGet = null;
            result = null;
            try {
                String url = "https://graph.microsoft.com/beta/me";
                Proxy proxy = this.settingsDao.getProxy(cloudId);
                if (proxy != null || !org.springframework.util.StringUtils.isEmpty((Object)this.registry.get(cloudId).getProxyHost()) && !org.springframework.util.StringUtils.isEmpty((Object)this.registry.get(cloudId).getProxyPort())) {
                    logger.debug("host :" + this.registry.get(cloudId).getProxyHost());
                    logger.debug("port :" + this.registry.get(cloudId).getProxyPort());
                    HttpHost proxyval = new HttpHost(this.registry.get(cloudId).getProxyHost(), this.registry.get(cloudId).getProxyPort(), "http");
                    DefaultProxyRoutePlanner routePlanner = new DefaultProxyRoutePlanner(proxyval);
                    httpclient = HttpClients.custom().setRoutePlanner((HttpRoutePlanner)routePlanner).build();
                } else {
                    httpclient = HttpClients.custom().build();
                }
                httpGet = new HttpGet(url);
                httpGet.addHeader("Authorization", "Bearer " + accessToken);
                httpGet.addHeader("Accept", "application/json");
                result = httpclient.execute((HttpUriRequest)httpGet);
                int httpResponseCode = result.getStatusLine().getStatusCode();
                logger.debug("Status code ..." + httpResponseCode);
                if (httpResponseCode == 200) {
                    InputStream inputStream = result.getEntity().getContent();
                    try (BufferedReader in = new BufferedReader(new InputStreamReader(inputStream));){
                        String inputLine;
                        while ((inputLine = in.readLine()) != null) {
                            response.append(inputLine);
                        }
                    }
                }
                if (httpGet == null) break block15;
            }
            catch (Exception e) {
                block16: {
                    try {
                        logger.error("Exception while getting userInfo ................." + String.valueOf(e));
                        logger.trace("Exception while getting userInfo ................." + e.getMessage());
                        if (httpGet == null) break block16;
                    }
                    catch (Throwable throwable) {
                        if (httpGet != null) {
                            httpGet.releaseConnection();
                        }
                        this.closeResponse(result);
                        this.closeHttpClient(httpclient);
                        throw throwable;
                    }
                    httpGet.releaseConnection();
                }
                this.closeResponse(result);
                this.closeHttpClient(httpclient);
            }
            httpGet.releaseConnection();
        }
        this.closeResponse(result);
        this.closeHttpClient(httpclient);
        return response.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getUserGroupsFromUserToken(int cloudId, String accessToken, String searchString) {
        CloseableHttpResponse result;
        CloseableHttpClient httpclient;
        StringBuilder response;
        block14: {
            response = new StringBuilder();
            httpclient = null;
            HttpGet httpGet = null;
            result = null;
            try {
                String encodedSearchString = URLEncoder.encode(searchString, StandardCharsets.UTF_8.toString());
                searchString = searchString.replace("\"", "%22");
                searchString = searchString.replace(" ", "%20");
                searchString = searchString.replace("|", "%7C");
                String url = "https://graph.microsoft.com/v1.0/me/memberOf/microsoft.graph.group?$count=true&$orderby=displayName&$search=" + searchString + "&$select=displayName,id";
                Proxy proxy = this.settingsDao.getProxy(cloudId);
                logger.debug("URL::" + url);
                if (proxy != null || !org.springframework.util.StringUtils.isEmpty((Object)this.registry.get(cloudId).getProxyHost()) && !org.springframework.util.StringUtils.isEmpty((Object)this.registry.get(cloudId).getProxyPort())) {
                    logger.debug("host :" + this.registry.get(cloudId).getProxyHost());
                    logger.debug("port :" + this.registry.get(cloudId).getProxyPort());
                    HttpHost proxyval = new HttpHost(this.registry.get(cloudId).getProxyHost(), this.registry.get(cloudId).getProxyPort(), "http");
                    DefaultProxyRoutePlanner routePlanner = new DefaultProxyRoutePlanner(proxyval);
                    httpclient = HttpClients.custom().setRoutePlanner((HttpRoutePlanner)routePlanner).build();
                } else {
                    httpclient = HttpClients.custom().build();
                }
                httpGet = new HttpGet(url);
                httpGet.addHeader("Authorization", "Bearer " + accessToken);
                httpGet.addHeader("Accept", "application/json");
                httpGet.addHeader("ConsistencyLevel", "eventual");
                result = httpclient.execute((HttpUriRequest)httpGet);
                int httpResponseCode = result.getStatusLine().getStatusCode();
                logger.debug("getUserGroupsFromGraph ........response code ......... " + httpResponseCode);
                InputStream inputStream = result.getEntity().getContent();
                try (BufferedReader in = new BufferedReader(new InputStreamReader(inputStream));){
                    String inputLine;
                    while ((inputLine = in.readLine()) != null) {
                        response.append(inputLine);
                    }
                }
                if (httpGet == null) break block14;
            }
            catch (Exception e) {
                try {
                    throw new BaseException("Exception while getting groups " + e.getMessage(), 500);
                }
                catch (Throwable throwable) {
                    if (httpGet != null) {
                        httpGet.releaseConnection();
                    }
                    this.closeResponse(result);
                    this.closeHttpClient(httpclient);
                    throw throwable;
                }
            }
            httpGet.releaseConnection();
        }
        this.closeResponse(result);
        this.closeHttpClient(httpclient);
        logger.debug("getUserGroupsFromGraph ........... body..........." + response.toString());
        return response.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getAllGroupInfo(int cloudId, String accessToken) {
        CloseableHttpResponse result;
        CloseableHttpClient httpclient;
        StringBuilder response;
        block14: {
            response = new StringBuilder();
            httpclient = null;
            HttpGet httpGet = null;
            result = null;
            try {
                String url = "https://graph.microsoft.com/v1.0/me/memberOf";
                Proxy proxy = this.settingsDao.getProxy(cloudId);
                if (proxy != null || !org.springframework.util.StringUtils.isEmpty((Object)this.registry.get(cloudId).getProxyHost()) && !org.springframework.util.StringUtils.isEmpty((Object)this.registry.get(cloudId).getProxyPort())) {
                    logger.debug("host :" + this.registry.get(cloudId).getProxyHost());
                    logger.debug("port :" + this.registry.get(cloudId).getProxyPort());
                    HttpHost proxyval = new HttpHost(this.registry.get(cloudId).getProxyHost(), this.registry.get(cloudId).getProxyPort(), "http");
                    DefaultProxyRoutePlanner routePlanner = new DefaultProxyRoutePlanner(proxyval);
                    httpclient = HttpClients.custom().setRoutePlanner((HttpRoutePlanner)routePlanner).build();
                } else {
                    httpclient = HttpClients.custom().build();
                }
                httpGet = new HttpGet(url);
                httpGet.addHeader("Authorization", "Bearer " + accessToken);
                httpGet.addHeader("Accept", "application/json");
                result = httpclient.execute((HttpUriRequest)httpGet);
                int httpResponseCode = result.getStatusLine().getStatusCode();
                logger.debug("getUserGroupsFromGraph ........response code ......... " + httpResponseCode);
                InputStream inputStream = result.getEntity().getContent();
                try (BufferedReader in = new BufferedReader(new InputStreamReader(inputStream));){
                    String inputLine;
                    while ((inputLine = in.readLine()) != null) {
                        response.append(inputLine);
                    }
                }
                if (httpGet == null) break block14;
            }
            catch (Exception e) {
                try {
                    throw new BaseException("Exception while getting groups " + e.getMessage(), 500);
                }
                catch (Throwable throwable) {
                    if (httpGet != null) {
                        httpGet.releaseConnection();
                    }
                    this.closeResponse(result);
                    this.closeHttpClient(httpclient);
                    throw throwable;
                }
            }
            httpGet.releaseConnection();
        }
        this.closeResponse(result);
        this.closeHttpClient(httpclient);
        logger.debug("getUserGroupsFromGraph ........... body..........." + response.toString());
        return response.toString();
    }

    @Override
    public List<AADUserElement> getAADUsersFromUserNames(Cloud cloud, AADUserNamesList aadUserNameList) {
        int cloudId = cloud.getCloudId();
        AADAuthorizationToken aadToken = this.aadDao.getAADAuthorizationtoken(cloudId);
        if (aadToken == null || org.springframework.util.StringUtils.isEmpty((Object)aadToken.getAccess_token())) {
            logger.debug("aadAuthToken or accessToken is empty so return....");
            return null;
        }
        ArrayList<AADUserElement> aadUsersList = new ArrayList<AADUserElement>();
        for (String userName : aadUserNameList.getAadUserNames()) {
            User user = this.userDao.getUserByUserNameOrAADLoginId(cloudId, userName);
            if (user == null || user != null && user.isGuest()) {
                AADUserElement aadUser = this.getAADUserFromUserName(cloud, userName);
                if (aadUser != null) {
                    if (org.springframework.util.StringUtils.isEmpty((Object)aadUser.getProductType())) {
                        logger.debug("user is not part any group " + aadUser.getUserPrincipalName());
                        continue;
                    }
                    aadUser.setUserName(userName);
                    aadUser.setUserPrincipalName(null);
                    aadUsersList.add(aadUser);
                    continue;
                }
                logger.debug("...........User " + userName + " .........  Not found in AAD Or token expired.........");
                continue;
            }
            logger.debug("$##############################" + userName + " ........present in our db....");
        }
        logger.debug("...........aadUsersList size... " + aadUsersList.size());
        return aadUsersList;
    }

    @Override
    public AADUserElement getAADUserFromUserName(Cloud cloud, String userName) {
        int cloudId = cloud.getCloudId();
        AADAuthorizationToken aadToken = this.aadDao.getAADAuthorizationtoken(cloudId);
        if (aadToken == null || org.springframework.util.StringUtils.isEmpty((Object)aadToken.getAccess_token())) {
            logger.debug("aadAuthToken or accessToken is empty so return....");
            return null;
        }
        boolean isSyncEnabled = false;
        boolean isBackupEnabled = false;
        boolean isOdbBackupEnabled = false;
        boolean isExchangeEnabled = false;
        boolean isSharepointEnabled = false;
        boolean isGmailEnabled = false;
        boolean isGdriveEnabled = false;
        for (CloudCustomisableDetails customisableDetails : cloud.getCloudCustomisableDetails()) {
            if (customisableDetails.getName().equalsIgnoreCase(SYNC_ENABLED)) {
                isSyncEnabled = true;
            }
            if (customisableDetails.getName().equalsIgnoreCase(BACK_UP_ENABLED)) {
                isBackupEnabled = true;
            }
            if (ODB_BACKUP_ENABLED.equalsIgnoreCase(customisableDetails.getName())) {
                isOdbBackupEnabled = true;
            }
            if (EXCHANGE_BACKUP_ENABLED.equalsIgnoreCase(customisableDetails.getName())) {
                isExchangeEnabled = true;
            }
            if (SHARE_POINT_BACKUP_ENABLED.equalsIgnoreCase(customisableDetails.getName())) {
                isSharepointEnabled = true;
            }
            if (GMAIL_BACKUP_ENABLED.equalsIgnoreCase(customisableDetails.getName())) {
                isGmailEnabled = true;
            }
            if (!GDRIVE_BACKUP_ENABLED.equalsIgnoreCase(customisableDetails.getName())) continue;
            isGdriveEnabled = true;
        }
        AADUserElement aadUser = null;
        User user = this.userDao.getUserByUserNameOrAADLoginId(cloudId, userName);
        if (user == null || user != null && user.isGuest()) {
            aadUser = this.getAADUserFromUserName(cloudId, userName, aadToken);
            if (aadUser != null) {
                logger.debug(isBackupEnabled + "...........User " + aadUser.getUserName() + " .........found in AAD");
                String productType = "";
                IdentityProviderSettings aadCredentials = this.aadDao.getAADCredentials(cloudId);
                logger.debug(".................." + aadCredentials.toString());
                if (!CollectionUtils.isEmpty((Collection)aadCredentials.getGroupMapping())) {
                    boolean bkpEnabled = false;
                    boolean syncEnabled = false;
                    boolean odbEnabled = false;
                    boolean exchangeEnabled = false;
                    boolean spEnabled = false;
                    boolean gmailEnabled = false;
                    boolean gdriveEnabled = false;
                    if (!CollectionUtils.isEmpty((Collection)aadCredentials.getGroupMapping().stream().filter(mapping -> !org.springframework.util.StringUtils.isEmpty((Object)mapping.getGroupName())).collect(Collectors.toList()))) {
                        List<String> userMemberOf = this.getAADUserGroupInfo(cloudId, userName, aadToken);
                        if (!CollectionUtils.isEmpty(userMemberOf)) {
                            for (String group : userMemberOf) {
                                logger.debug("User is memeber of ............" + group.toLowerCase());
                                for (GroupMapping mapping2 : aadCredentials.getGroupMapping()) {
                                    String groupName = mapping2.getGroupName();
                                    if (!groupName.equals(group)) continue;
                                    if (mapping2.getProductType().equalsIgnoreCase(CPHelperConstant.PARABLU_PRODUCT_TYPE.BACKUP.getProductType())) {
                                        bkpEnabled = true;
                                        continue;
                                    }
                                    if (mapping2.getProductType().equalsIgnoreCase(CPHelperConstant.PARABLU_PRODUCT_TYPE.SYNC.getProductType())) {
                                        syncEnabled = true;
                                        continue;
                                    }
                                    if (mapping2.getProductType().equalsIgnoreCase(CPHelperConstant.PARABLU_PRODUCT_TYPE.ODB.getProductType())) {
                                        odbEnabled = true;
                                        continue;
                                    }
                                    if (mapping2.getProductType().equalsIgnoreCase(CPHelperConstant.PARABLU_PRODUCT_TYPE.EXCHANGE.getProductType())) {
                                        exchangeEnabled = true;
                                        continue;
                                    }
                                    if (mapping2.getProductType().equalsIgnoreCase(CPHelperConstant.PARABLU_PRODUCT_TYPE.SHAREPOINT.getProductType())) {
                                        spEnabled = true;
                                        continue;
                                    }
                                    if (mapping2.getProductType().equalsIgnoreCase(CPHelperConstant.PARABLU_PRODUCT_TYPE.GMAIL.getProductType())) {
                                        gmailEnabled = true;
                                        continue;
                                    }
                                    if (mapping2.getProductType().equalsIgnoreCase(CPHelperConstant.PARABLU_PRODUCT_TYPE.GOOGLEDRIVE.getProductType())) {
                                        gdriveEnabled = true;
                                        continue;
                                    }
                                    isBackupEnabled = bkpEnabled;
                                    isSyncEnabled = syncEnabled;
                                    odbEnabled = isOdbBackupEnabled;
                                    exchangeEnabled = isExchangeEnabled;
                                    spEnabled = isSharepointEnabled;
                                    gmailEnabled = isGmailEnabled;
                                    gdriveEnabled = isGdriveEnabled;
                                }
                            }
                        }
                    } else if (!aadCredentials.getGroupMapping().isEmpty()) {
                        productType = ((GroupMapping)aadCredentials.getGroupMapping().get(0)).getProductType();
                    }
                    for (GroupMapping mapping3 : aadCredentials.getGroupMapping()) {
                        if (!"".equals(mapping3.getGroupName())) continue;
                        if (mapping3.getProductType().equalsIgnoreCase(CPHelperConstant.PARABLU_PRODUCT_TYPE.BACKUP.getProductType())) {
                            bkpEnabled = true;
                            continue;
                        }
                        if (mapping3.getProductType().equalsIgnoreCase(CPHelperConstant.PARABLU_PRODUCT_TYPE.SYNC.getProductType())) {
                            syncEnabled = true;
                            continue;
                        }
                        if (mapping3.getProductType().equalsIgnoreCase(CPHelperConstant.PARABLU_PRODUCT_TYPE.ODB.getProductType())) {
                            odbEnabled = true;
                            continue;
                        }
                        if (mapping3.getProductType().equalsIgnoreCase(CPHelperConstant.PARABLU_PRODUCT_TYPE.EXCHANGE.getProductType())) {
                            exchangeEnabled = true;
                            continue;
                        }
                        if (mapping3.getProductType().equalsIgnoreCase(CPHelperConstant.PARABLU_PRODUCT_TYPE.SHAREPOINT.getProductType())) {
                            spEnabled = true;
                            continue;
                        }
                        bkpEnabled = isBackupEnabled;
                        syncEnabled = isSyncEnabled;
                        odbEnabled = isOdbBackupEnabled;
                        exchangeEnabled = isExchangeEnabled;
                        spEnabled = isSharepointEnabled;
                        gmailEnabled = isGmailEnabled;
                        gdriveEnabled = isGdriveEnabled;
                    }
                    if (bkpEnabled && syncEnabled && odbEnabled && exchangeEnabled && spEnabled && gmailEnabled && gdriveEnabled) {
                        productType = "ALL";
                    } else if (!(!bkpEnabled || syncEnabled || odbEnabled || exchangeEnabled || spEnabled)) {
                        productType = "BACKUP";
                    } else if (!(bkpEnabled || !syncEnabled || odbEnabled || exchangeEnabled || spEnabled)) {
                        productType = "SYNC";
                    } else if (!(bkpEnabled || syncEnabled || !odbEnabled || exchangeEnabled || spEnabled)) {
                        productType = "ODB";
                    } else if (!(bkpEnabled || syncEnabled || odbEnabled || !exchangeEnabled || spEnabled)) {
                        productType = "MAIL";
                    } else if (!(bkpEnabled || syncEnabled || odbEnabled || exchangeEnabled || !spEnabled)) {
                        productType = "SP";
                    } else if (!(bkpEnabled || !syncEnabled || odbEnabled || exchangeEnabled || spEnabled)) {
                        logger.debug("...check the compination....." + bkpEnabled + ".." + syncEnabled + ".." + odbEnabled + ".." + exchangeEnabled + ".." + spEnabled);
                    } else if (bkpEnabled || syncEnabled || odbEnabled || exchangeEnabled || spEnabled || gmailEnabled || gdriveEnabled) {
                        productType = "ANY";
                    }
                    aadUser.setBackupEnabled(isBackupEnabled);
                    aadUser.setExchangeBkpEnabled(isExchangeEnabled);
                    aadUser.setOnedriveBkpEnabled(isOdbBackupEnabled);
                    aadUser.setSyncEnabled(isSyncEnabled);
                    aadUser.setSharePointBkpEnabled(isSharepointEnabled);
                    aadUser.setGdriveBkpEnabled(gdriveEnabled);
                    aadUser.setGmailBkpEnabled(gmailEnabled);
                    aadUser.setProductType(productType);
                    logger.debug("...........User " + userName + " .........   found in AAD..." + productType);
                } else {
                    if (isBackupEnabled && isSyncEnabled && isOdbBackupEnabled && isExchangeEnabled && isSharepointEnabled) {
                        productType = "ALL";
                    } else if (!(!isBackupEnabled || isSyncEnabled || isOdbBackupEnabled || isExchangeEnabled || isSharepointEnabled)) {
                        productType = "BACKUP";
                    } else if (!(isBackupEnabled || !isSyncEnabled || isOdbBackupEnabled || isExchangeEnabled || isSharepointEnabled)) {
                        productType = "SYNC";
                    } else if (!(isBackupEnabled || isSyncEnabled || !isOdbBackupEnabled || isExchangeEnabled || isSharepointEnabled)) {
                        productType = "ODB";
                    } else if (!(isBackupEnabled || isSyncEnabled || isOdbBackupEnabled || !isExchangeEnabled || isSharepointEnabled)) {
                        productType = "MAIL";
                    } else if (!(isBackupEnabled || isSyncEnabled || isOdbBackupEnabled || isExchangeEnabled || !isSharepointEnabled)) {
                        productType = "SP";
                    } else if (isBackupEnabled && !isSyncEnabled && isOdbBackupEnabled && isExchangeEnabled && isSharepointEnabled) {
                        productType = "BACKUPODB";
                    } else if (!(isBackupEnabled || !isSyncEnabled || isOdbBackupEnabled || isExchangeEnabled || isSharepointEnabled)) {
                        logger.debug("...check the compination....." + isBackupEnabled + ".." + isSyncEnabled + ".." + isOdbBackupEnabled + ".." + isExchangeEnabled + ".." + isSharepointEnabled);
                    } else if (isBackupEnabled || isSyncEnabled || isOdbBackupEnabled || isExchangeEnabled || isSharepointEnabled) {
                        productType = "ANY";
                    }
                    aadUser.setBackupEnabled(isBackupEnabled);
                    aadUser.setSyncEnabled(isSyncEnabled);
                    aadUser.setExchangeBkpEnabled(isExchangeEnabled);
                    aadUser.setOnedriveBkpEnabled(isOdbBackupEnabled);
                    aadUser.setSharePointBkpEnabled(isSharepointEnabled);
                    aadUser.setGdriveBkpEnabled(isGdriveEnabled);
                    aadUser.setGmailBkpEnabled(isGmailEnabled);
                    aadUser.setProductType(productType);
                }
            }
        } else {
            aadUser = new AADUserElement();
            aadUser.setUserName(user.getUserName());
            aadUser.setUserPrincipalName(user.getUserName());
            logger.debug("$##############################" + userName + " ........present in our db....");
        }
        if (aadUser != null) {
            logger.debug("AAD User Element ...." + aadUser.toString());
        }
        return aadUser;
    }

    private void getAADUserElementWithLicenseDetails(Cloud cloud, AADUserElement aadUserElement) {
        boolean isSyncEnabled = false;
        boolean isBackupEnabled = false;
        boolean isOdbBackupEnabled = false;
        boolean isExchangeEnabled = false;
        boolean isSharepointEnabled = false;
        boolean gmailBkpEnabled = false;
        boolean gdriveBackupEnabled = false;
        int cloudId = cloud.getCloudId();
        for (CloudCustomisableDetails customisableDetails : cloud.getCloudCustomisableDetails()) {
            if (customisableDetails.getName().equalsIgnoreCase(SYNC_ENABLED)) {
                isSyncEnabled = true;
            }
            if (customisableDetails.getName().equalsIgnoreCase(BACK_UP_ENABLED)) {
                isBackupEnabled = true;
            }
            if (ODB_BACKUP_ENABLED.equalsIgnoreCase(customisableDetails.getName())) {
                isOdbBackupEnabled = true;
            }
            if (EXCHANGE_BACKUP_ENABLED.equalsIgnoreCase(customisableDetails.getName())) {
                isExchangeEnabled = true;
            }
            if (SHARE_POINT_BACKUP_ENABLED.equalsIgnoreCase(customisableDetails.getName())) {
                isSharepointEnabled = true;
            }
            if (GMAIL_BACKUP_ENABLED.equalsIgnoreCase(customisableDetails.getName())) {
                gmailBkpEnabled = true;
            }
            if (!GDRIVE_BACKUP_ENABLED.equalsIgnoreCase(customisableDetails.getName())) continue;
            gdriveBackupEnabled = true;
        }
        aadUserElement.setBackupEnabled(isBackupEnabled);
        aadUserElement.setSyncEnabled(isSyncEnabled);
        aadUserElement.setOnedriveBkpEnabled(isOdbBackupEnabled);
        aadUserElement.setExchangeBkpEnabled(isExchangeEnabled);
        aadUserElement.setSharePointBkpEnabled(isSharepointEnabled);
        aadUserElement.setGmailBkpEnabled(gmailBkpEnabled);
        aadUserElement.setGdriveBkpEnabled(gdriveBackupEnabled);
        aadUserElement.setDefaultExchangePolicy(this.registry.get(cloudId).getPropertyFileValueDefaultExchangePolicy());
        aadUserElement.setDefaultGdrivePolicy(this.registry.get(cloudId).getDefaultGdrivePolicyName());
        aadUserElement.setDefaultGmailPolicy(this.registry.get(cloudId).getDefaultGmailPolicy());
        aadUserElement.setDefaultOdbPolicy(this.registry.get(cloudId).getPropertyFileValueDefaultOdbPolicy());
        aadUserElement.setDefaultSyncPolicy(this.registry.get(cloudId).getPropertyFileValueDefaultSyncPolicy());
    }

    @Override
    public AADUserElement getAADUserFromUserNameToSync(Cloud cloud, String userName) {
        AADAuthorizationToken aadToken = this.aadDao.getAADAuthorizationtoken(cloud.getCloudId());
        if (aadToken == null || org.springframework.util.StringUtils.isEmpty((Object)aadToken.getAccess_token())) {
            logger.debug("aadAuthToken or accessToken is empty so return....");
            return null;
        }
        AADUserElement aadUser = null;
        aadUser = this.getAADUserFromUserName(cloud.getCloudId(), userName, aadToken);
        List licenseDetails = cloud.getCloudCustomisableDetails();
        int cloudId = cloud.getCloudId();
        if (aadUser != null) {
            logger.debug(aadUser.getId() + "...........User . .........found in AAD.." + aadUser.getUserPrincipalName() + "....user..." + userName);
            String productType = "";
            IdentityProviderSettings aadCredentials = this.aadDao.getAADCredentials(cloud.getCloudId());
            logger.debug(".................." + aadCredentials.toString());
            if (!aadCredentials.isManyToManyMappingEnabled() && !CollectionUtils.isEmpty((Collection)aadCredentials.getGroupMapping())) {
                boolean bkpEnabled = false;
                boolean syncEnabled = false;
                boolean exchangeEnabled = false;
                boolean oneDriveEnabled = false;
                boolean sharePointEnabled = false;
                boolean gmailBkpEnabled = false;
                boolean gdriveBkpEnabled = false;
                if (!CollectionUtils.isEmpty((Collection)aadCredentials.getGroupMapping().stream().filter(mapping -> !org.springframework.util.StringUtils.isEmpty((Object)mapping.getGroupName())).collect(Collectors.toList()))) {
                    List<String> userMemberOf = this.getAADUserGroupInfo(cloud.getCloudId(), userName, aadToken);
                    if (!CollectionUtils.isEmpty(userMemberOf)) {
                        for (String group : userMemberOf) {
                            for (GroupMapping mapping2 : aadCredentials.getGroupMapping()) {
                                String groupName = mapping2.getGroupName();
                                if (!groupName.equalsIgnoreCase(group)) continue;
                                String type = mapping2.getProductType();
                                logger.debug(groupName + ".....element groupconfig...." + mapping2.getProductType());
                                logger.debug(this.registry.get(cloudId).getPropertyFileValueDefaultO365PolicyName() + "...od policyname...." + this.registry.get(cloudId).getPropertyFileValueDefaultOdbPolicy());
                                if (type.equalsIgnoreCase(CPHelperConstant.PARABLU_PRODUCT_TYPE.BACKUP.getProductType()) && this.isLiecnseEnabled(licenseDetails, BACK_UP_ENABLED)) {
                                    bkpEnabled = true;
                                    aadUser.setDefaultPolicy(this.registry.get(cloudId).getPropertyFileValueDefaultBkpPolicy());
                                } else if (type.equalsIgnoreCase(CPHelperConstant.PARABLU_PRODUCT_TYPE.SYNC.getProductType()) && this.isLiecnseEnabled(licenseDetails, SYNC_ENABLED)) {
                                    syncEnabled = true;
                                    aadUser.setDefaultSyncPolicy(this.registry.get(cloudId).getPropertyFileValueDefaultSyncPolicy());
                                } else if (type.equalsIgnoreCase(CPHelperConstant.PARABLU_PRODUCT_TYPE.ODB.getProductType()) && this.isLiecnseEnabled(licenseDetails, ODB_BACKUP_ENABLED)) {
                                    oneDriveEnabled = true;
                                    aadUser.setDefaultOdbPolicy(this.registry.get(cloudId).getPropertyFileValueDefaultOdbPolicy());
                                } else if (type.equalsIgnoreCase(CPHelperConstant.PARABLU_PRODUCT_TYPE.SHAREPOINT.getProductType()) && this.isLiecnseEnabled(licenseDetails, SHARE_POINT_BACKUP_ENABLED)) {
                                    sharePointEnabled = true;
                                    aadUser.setDefaultSharepointPolicy(this.registry.get(cloudId).getPropertyFileValueDefaultSpPolicy());
                                } else if (type.equalsIgnoreCase(CPHelperConstant.PARABLU_PRODUCT_TYPE.EXCHANGE.getProductType()) && this.isLiecnseEnabled(licenseDetails, EXCHANGE_BACKUP_ENABLED)) {
                                    exchangeEnabled = true;
                                    aadUser.setDefaultExchangePolicy(this.registry.get(cloudId).getPropertyFileValueDefaultExchangePolicy());
                                } else if (type.equalsIgnoreCase(CPHelperConstant.PARABLU_PRODUCT_TYPE.GMAIL.getProductType()) && this.isLiecnseEnabled(licenseDetails, GMAIL_BACKUP_ENABLED)) {
                                    gmailBkpEnabled = true;
                                    aadUser.setDefaultGmailPolicy(this.registry.get(cloudId).getDefaultGmailPolicy());
                                } else if (type.equalsIgnoreCase(CPHelperConstant.PARABLU_PRODUCT_TYPE.GOOGLEDRIVE.getProductType()) && this.isLiecnseEnabled(licenseDetails, GDRIVE_BACKUP_ENABLED)) {
                                    gdriveBkpEnabled = true;
                                    aadUser.setDefaultGdrivePolicy(this.registry.get(cloudId).getDefaultGdrivePolicyName());
                                } else {
                                    bkpEnabled = true;
                                    syncEnabled = true;
                                    exchangeEnabled = true;
                                    oneDriveEnabled = true;
                                    sharePointEnabled = true;
                                    gmailBkpEnabled = true;
                                    gdriveBkpEnabled = true;
                                    aadUser.setDefaultPolicy(this.registry.get(cloudId).getPropertyFileValueDefaultBkpPolicy());
                                    aadUser.setDefaultSyncPolicy(this.registry.get(cloudId).getPropertyFileValueDefaultSyncPolicy());
                                    aadUser.setDefaultOdbPolicy(this.registry.get(cloudId).getPropertyFileValueDefaultOdbPolicy());
                                    aadUser.setDefaultExchangePolicy(this.registry.get(cloudId).getPropertyFileValueDefaultExchangePolicy());
                                    aadUser.setDefaultSharepointPolicy(this.registry.get(cloudId).getPropertyFileValueDefaultSpPolicy());
                                    aadUser.setDefaultGdrivePolicy(this.registry.get(cloudId).getDefaultGdrivePolicyName());
                                    aadUser.setDefaultGmailPolicy(this.registry.get(cloudId).getDefaultGmailPolicy());
                                }
                                aadUser.setDefaultPolicy(this.registry.get(cloudId).getPropertyFileValueDefaultBkpPolicy());
                                aadUser.setDefaultSyncPolicy(this.registry.get(cloudId).getPropertyFileValueDefaultSyncPolicy());
                                aadUser.setDefaultOdbPolicy(this.registry.get(cloudId).getPropertyFileValueDefaultOdbPolicy());
                                aadUser.setDefaultSharepointPolicy(this.registry.get(cloudId).getPropertyFileValueDefaultSpPolicy());
                                aadUser.setDefaultExchangePolicy(this.registry.get(cloudId).getPropertyFileValueDefaultExchangePolicy());
                                aadUser.setDefaultGdrivePolicy(this.registry.get(cloudId).getDefaultGdrivePolicyName());
                                aadUser.setDefaultGmailPolicy(this.registry.get(cloudId).getDefaultGmailPolicy());
                            }
                        }
                    }
                } else if (!aadCredentials.getGroupMapping().isEmpty()) {
                    productType = ((GroupMapping)aadCredentials.getGroupMapping().get(0)).getProductType();
                }
                logger.debug(bkpEnabled + ".." + syncEnabled + "..." + exchangeEnabled + ",...." + oneDriveEnabled + "..." + sharePointEnabled + ".......checkmemberof....................");
                aadUser.setBackupEnabled(bkpEnabled);
                aadUser.setSyncEnabled(syncEnabled);
                aadUser.setExchangeBkpEnabled(exchangeEnabled);
                aadUser.setOnedriveBkpEnabled(oneDriveEnabled);
                aadUser.setSharePointBkpEnabled(sharePointEnabled);
                aadUser.setGmailBkpEnabled(gmailBkpEnabled);
                aadUser.setGdriveBkpEnabled(gdriveBkpEnabled);
                for (GroupMapping mapping3 : aadCredentials.getGroupMapping()) {
                    String groupName = mapping3.getGroupName();
                    if (!org.springframework.util.StringUtils.isEmpty((Object)groupName)) continue;
                    if (mapping3.getProductType().equalsIgnoreCase(CPHelperConstant.PARABLU_PRODUCT_TYPE.BACKUP.getProductType())) {
                        bkpEnabled = true;
                        aadUser.setBackupEnabled(bkpEnabled);
                        aadUser.setDefaultPolicy(this.registry.get(cloudId).getPropertyFileValueDefaultBkpPolicy());
                        continue;
                    }
                    if (mapping3.getProductType().equalsIgnoreCase(CPHelperConstant.PARABLU_PRODUCT_TYPE.SYNC.getProductType())) {
                        syncEnabled = true;
                        aadUser.setSyncEnabled(syncEnabled);
                        aadUser.setDefaultSyncPolicy(this.registry.get(cloudId).getPropertyFileValueDefaultSyncPolicy());
                        continue;
                    }
                    if (mapping3.getProductType().equalsIgnoreCase(CPHelperConstant.PARABLU_PRODUCT_TYPE.ODB.getProductType())) {
                        oneDriveEnabled = true;
                        aadUser.setOnedriveBkpEnabled(oneDriveEnabled);
                        aadUser.setDefaultOdbPolicy(this.registry.get(cloudId).getPropertyFileValueDefaultOdbPolicy());
                        continue;
                    }
                    if (mapping3.getProductType().equalsIgnoreCase(CPHelperConstant.PARABLU_PRODUCT_TYPE.EXCHANGE.getProductType())) {
                        exchangeEnabled = true;
                        aadUser.setExchangeBkpEnabled(exchangeEnabled);
                        aadUser.setDefaultExchangePolicy(this.registry.get(cloudId).getPropertyFileValueDefaultExchangePolicy());
                        continue;
                    }
                    if (mapping3.getProductType().equalsIgnoreCase(CPHelperConstant.PARABLU_PRODUCT_TYPE.GMAIL.getProductType())) {
                        aadUser.setGmailBkpEnabled(true);
                        gmailBkpEnabled = true;
                        aadUser.setDefaultGmailPolicy(this.registry.get(cloudId).getDefaultGmailPolicy());
                        continue;
                    }
                    if (mapping3.getProductType().equalsIgnoreCase(CPHelperConstant.PARABLU_PRODUCT_TYPE.GOOGLEDRIVE.getProductType())) {
                        aadUser.setGdriveBkpEnabled(true);
                        gdriveBkpEnabled = true;
                        aadUser.setDefaultGdrivePolicy(this.registry.get(cloudId).getDefaultGdrivePolicyName());
                        continue;
                    }
                    bkpEnabled = true;
                    syncEnabled = true;
                    exchangeEnabled = true;
                    oneDriveEnabled = true;
                    gmailBkpEnabled = true;
                    gdriveBkpEnabled = true;
                    aadUser.setDefaultPolicy(this.registry.get(cloudId).getPropertyFileValueDefaultBkpPolicy());
                    aadUser.setDefaultSyncPolicy(this.registry.get(cloudId).getPropertyFileValueDefaultSyncPolicy());
                    aadUser.setDefaultOdbPolicy(this.registry.get(cloudId).getPropertyFileValueDefaultOdbPolicy());
                    aadUser.setDefaultExchangePolicy(this.registry.get(cloudId).getPropertyFileValueDefaultExchangePolicy());
                    aadUser.setDefaultGdrivePolicy(this.registry.get(cloudId).getDefaultGdrivePolicyName());
                    aadUser.setDefaultGmailPolicy(this.registry.get(cloudId).getDefaultGmailPolicy());
                }
                if (bkpEnabled && syncEnabled) {
                    productType = "BOTH";
                    aadUser.setDefaultPolicy(this.registry.get(cloudId).getPropertyFileValueDefaultBkpPolicy());
                    aadUser.setDefaultSyncPolicy(this.registry.get(cloudId).getPropertyFileValueDefaultSyncPolicy());
                    aadUser.setDefaultOdbPolicy(this.registry.get(cloudId).getPropertyFileValueDefaultO365PolicyName());
                } else if (bkpEnabled) {
                    productType = "BACKUP";
                    aadUser.setDefaultPolicy(this.registry.get(cloudId).getPropertyFileValueDefaultBkpPolicy());
                } else if (syncEnabled) {
                    productType = "SYNC";
                    aadUser.setDefaultSyncPolicy(this.registry.get(cloudId).getPropertyFileValueDefaultSyncPolicy());
                } else if (oneDriveEnabled) {
                    productType = "ODB";
                    aadUser.setDefaultOdbPolicy(this.registry.get(cloudId).getPropertyFileValueDefaultO365PolicyName());
                } else if (exchangeEnabled) {
                    productType = "MAIL";
                    aadUser.setDefaultExchangePolicy(this.registry.get(cloudId).getPropertyFileValueDefaultExchangePolicy());
                } else if (gmailBkpEnabled) {
                    productType = CPHelperConstant.PARABLU_PRODUCT_TYPE.GMAIL.getProductType();
                    aadUser.setDefaultGmailPolicy(this.registry.get(cloudId).getDefaultGmailPolicy());
                } else if (gdriveBkpEnabled) {
                    productType = CPHelperConstant.PARABLU_PRODUCT_TYPE.GOOGLEDRIVE.getProductType();
                    aadUser.setDefaultGdrivePolicy(this.registry.get(cloudId).getDefaultGdrivePolicyName());
                }
            } else {
                List<String> userMemberOf;
                boolean bkpEnabled = false;
                boolean syncEnabled = false;
                boolean exchangeEnabled = false;
                boolean oneDriveEnabled = false;
                boolean sharePointEnabled = false;
                boolean gmailBkpEnabled = false;
                boolean gdriveBkpEnabled = false;
                if (!CollectionUtils.isEmpty((Collection)aadCredentials.getGroupMapping()) && !CollectionUtils.isEmpty(userMemberOf = this.getAADUserGroupInfo(cloud.getCloudId(), userName, aadToken))) {
                    for (String group : userMemberOf) {
                        for (GroupMapping GroupMapping2 : aadCredentials.getGroupMapping()) {
                            if (!GroupMapping2.getGroupName().equalsIgnoreCase(group.toLowerCase())) continue;
                            String productTypeAAd = GroupMapping2.getProductType();
                            String groupName = GroupMapping2.getGroupName();
                            logger.debug(groupName + ".....element groupconfig...." + group.toLowerCase());
                            logger.debug(this.registry.get(cloudId).getPropertyFileValueDefaultO365PolicyName() + "...od policyname...." + this.registry.get(cloudId).getPropertyFileValueDefaultOdbPolicy());
                            logger.debug("...product type ..." + productTypeAAd);
                            if (productTypeAAd.equalsIgnoreCase(CPHelperConstant.PARABLU_PRODUCT_TYPE.BACKUP.getProductType()) && this.isLiecnseEnabled(licenseDetails, BACK_UP_ENABLED)) {
                                bkpEnabled = true;
                                aadUser.setDefaultPolicy(GroupMapping2.getPolicyName());
                            } else if (productTypeAAd.equalsIgnoreCase(CPHelperConstant.PARABLU_PRODUCT_TYPE.SYNC.getProductType()) && this.isLiecnseEnabled(licenseDetails, SYNC_ENABLED)) {
                                syncEnabled = true;
                                aadUser.setDefaultSyncPolicy(GroupMapping2.getPolicyName());
                            } else if (productTypeAAd.equalsIgnoreCase(CPHelperConstant.PARABLU_PRODUCT_TYPE.ODB.getProductType()) && this.isLiecnseEnabled(licenseDetails, ODB_BACKUP_ENABLED)) {
                                oneDriveEnabled = true;
                                aadUser.setDefaultOdbPolicy(GroupMapping2.getPolicyName());
                            } else if (productTypeAAd.equalsIgnoreCase(CPHelperConstant.PARABLU_PRODUCT_TYPE.SHAREPOINT.getProductType()) && this.isLiecnseEnabled(licenseDetails, SHARE_POINT_BACKUP_ENABLED)) {
                                sharePointEnabled = true;
                                aadUser.setDefaultSharepointPolicy(GroupMapping2.getPolicyName());
                            } else if (productTypeAAd.equalsIgnoreCase(CPHelperConstant.PARABLU_PRODUCT_TYPE.EXCHANGE.getProductType()) && this.isLiecnseEnabled(licenseDetails, EXCHANGE_BACKUP_ENABLED)) {
                                exchangeEnabled = true;
                                aadUser.setDefaultExchangePolicy(GroupMapping2.getPolicyName());
                            } else if (productTypeAAd.equalsIgnoreCase(CPHelperConstant.PARABLU_PRODUCT_TYPE.GMAIL.getProductType()) && this.isLiecnseEnabled(licenseDetails, GMAIL_BACKUP_ENABLED)) {
                                aadUser.setGmailBkpEnabled(true);
                                gmailBkpEnabled = true;
                                aadUser.setDefaultGmailPolicy(GroupMapping2.getPolicyName());
                            } else if (productTypeAAd.equalsIgnoreCase(CPHelperConstant.PARABLU_PRODUCT_TYPE.GOOGLEDRIVE.getProductType()) && this.isLiecnseEnabled(licenseDetails, GDRIVE_BACKUP_ENABLED)) {
                                aadUser.setGdriveBkpEnabled(true);
                                gdriveBkpEnabled = true;
                                aadUser.setDefaultGdrivePolicy(GroupMapping2.getPolicyName());
                            } else {
                                logger.debug(".....check this logic.....");
                                aadUser.setDefaultPolicy(this.registry.get(cloudId).getPropertyFileValueDefaultBkpPolicy());
                                aadUser.setDefaultSyncPolicy(this.registry.get(cloudId).getPropertyFileValueDefaultSyncPolicy());
                                aadUser.setDefaultOdbPolicy(this.registry.get(cloudId).getPropertyFileValueDefaultOdbPolicy());
                                aadUser.setDefaultSharepointPolicy(this.registry.get(cloudId).getPropertyFileValueDefaultSpPolicy());
                                aadUser.setDefaultExchangePolicy(this.registry.get(cloudId).getPropertyFileValueDefaultExchangePolicy());
                                aadUser.setDefaultGdrivePolicy(this.registry.get(cloudId).getDefaultGdrivePolicyName());
                                aadUser.setDefaultGmailPolicy(this.registry.get(cloudId).getDefaultGmailPolicy());
                            }
                            if (!bkpEnabled) {
                                aadUser.setDefaultPolicy(this.registry.get(cloudId).getPropertyFileValueDefaultBkpPolicy());
                            }
                            if (!syncEnabled) {
                                aadUser.setDefaultSyncPolicy(this.registry.get(cloudId).getPropertyFileValueDefaultSyncPolicy());
                            }
                            if (!oneDriveEnabled) {
                                aadUser.setDefaultOdbPolicy(this.registry.get(cloudId).getPropertyFileValueDefaultOdbPolicy());
                            }
                            if (!exchangeEnabled) {
                                aadUser.setDefaultExchangePolicy(this.registry.get(cloudId).getPropertyFileValueDefaultExchangePolicy());
                            }
                            if (!sharePointEnabled) {
                                aadUser.setDefaultSharepointPolicy(this.registry.get(cloudId).getPropertyFileValueDefaultSpPolicy());
                            }
                            if (!gmailBkpEnabled) {
                                aadUser.setDefaultGdrivePolicy(this.registry.get(cloudId).getDefaultGdrivePolicyName());
                            }
                            if (gdriveBkpEnabled) continue;
                            aadUser.setDefaultGmailPolicy(this.registry.get(cloudId).getDefaultGmailPolicy());
                        }
                    }
                }
                logger.debug(bkpEnabled + ".." + syncEnabled + "..." + exchangeEnabled + ",...." + oneDriveEnabled + "..." + sharePointEnabled + "..." + aadUser.getDefaultOdbPolicy() + ".......checkmemberof new policy...................." + this.registry.get(cloudId).getPropertyFileValueDefaultOdbPolicy());
                aadUser.setBackupEnabled(bkpEnabled);
                aadUser.setSyncEnabled(syncEnabled);
                aadUser.setExchangeBkpEnabled(exchangeEnabled);
                aadUser.setOnedriveBkpEnabled(oneDriveEnabled);
                aadUser.setSharePointBkpEnabled(sharePointEnabled);
                aadUser.setGmailBkpEnabled(gmailBkpEnabled);
                aadUser.setGdriveBkpEnabled(gdriveBkpEnabled);
            }
            aadUser.setProductType(productType);
            if (!aadCredentials.isManyToManyMappingEnabled()) {
                aadUser.setDefaultPolicy(this.registry.get(cloudId).getPropertyFileValueDefaultBkpPolicy());
                aadUser.setDefaultSyncPolicy(this.registry.get(cloudId).getPropertyFileValueDefaultSyncPolicy());
                aadUser.setDefaultOdbPolicy(this.registry.get(cloudId).getPropertyFileValueDefaultOdbPolicy());
                aadUser.setDefaultExchangePolicy(this.registry.get(cloudId).getPropertyFileValueDefaultExchangePolicy());
                aadUser.setDefaultGdrivePolicy(this.registry.get(cloudId).getDefaultGdrivePolicyName());
                aadUser.setDefaultGmailPolicy(this.registry.get(cloudId).getDefaultGmailPolicy());
            }
        } else {
            logger.debug("...........User " + userName + " .........  Not found in AAD");
        }
        return aadUser;
    }

    private boolean isLiecnseEnabled(List<CloudCustomisableDetails> licenseDetails, String licenseName) {
        boolean isODBEnabled = false;
        for (CloudCustomisableDetails license : licenseDetails) {
            if (license == null || !licenseName.equalsIgnoreCase(license.getName())) continue;
            isODBEnabled = true;
            break;
        }
        return isODBEnabled;
    }

    @Override
    public void synUserAttributes(Cloud cloud) {
        int cloudId = cloud.getCloudId();
        CloudProperties cloudProperties = this.cloudDao.getCloudProperties(cloudId);
        IdentityProviderSettings aadCredentials = this.aadDao.getAADCredentials(cloudId);
        AADAuthorizationToken authToken = this.aadDao.getAADAuthorizationtoken(cloudId);
        if (aadCredentials != null && authToken != null && !org.springframework.util.StringUtils.isEmpty((Object)authToken.getAccess_token())) {
            List<AADUserElement> aadUserElements = this.syncNewGroupChanges(cloud, aadCredentials, authToken);
            if (CollectionUtils.isEmpty(aadUserElements)) {
                logger.debug("....no users to sync check the group....");
                return;
            }
            aadCredentials = this.aadDao.getAADCredentials(cloudId);
            Set groupsInDB = aadCredentials.getGroupMapping().stream().map(GroupMapping::getGroupName).filter(group -> !org.springframework.util.StringUtils.isEmpty((Object)group)).collect(Collectors.toSet());
            if (aadCredentials.isManyToManyMappingEnabled()) {
                groupsInDB = new HashSet();
                List GroupMappingList = aadCredentials.getGroupMapping();
                if (!CollectionUtils.isEmpty((Collection)GroupMappingList)) {
                    groupsInDB = GroupMappingList.stream().map(aadPolicy -> aadPolicy.getGroupName()).collect(Collectors.toSet());
                }
            }
            if (CollectionUtils.isEmpty(groupsInDB)) {
                logger.debug("Group name is empty after collection so retun..");
                return;
            }
            ArrayList<AADUserElement> result = new ArrayList<AADUserElement>();
            HashSet<String> titles = new HashSet<String>();
            aadUserElements.removeAll(Collections.singleton(null));
            for (AADUserElement item : aadUserElements) {
                if (item == null || !titles.add(item.getUserPrincipalName())) continue;
                logger.debug(item.getId() + "....AADUserElement....." + item.getUserPrincipalName());
                result.add(item);
            }
            logger.debug(aadUserElements.size() + "...overall list before and after.." + result.size());
            aadUserElements = result;
            Map<String, AADUserElement> aadMap = aadUserElements.stream().collect(Collectors.toMap(aaduser -> aaduser.getUserPrincipalName().toLowerCase(), aaduser -> aaduser));
            Map<Object, Object> aadMapWithEmail = new HashMap();
            try {
                aadMapWithEmail = aadUserElements.stream().filter(aaduser -> aaduser.getMail() != null).collect(Collectors.toMap(aaduser -> aaduser.getMail().toLowerCase(), aaduser -> aaduser));
                logger.debug("after convert to aadMapWithEmail..." + aadMapWithEmail.size());
            }
            catch (Exception e) {
                logger.error("error getting the mail add:", (Throwable)e);
            }
            List allUsers = this.userDao.getAllUsers(cloudId);
            ArrayList<User> guestUsers = new ArrayList<User>();
            HashMap<String, User> userMap = new HashMap<String, User>();
            for (User user : allUsers) {
                if (!user.isLocalUser() && !user.isGuest()) {
                    String userName = user.getUserName();
                    if (!org.springframework.util.StringUtils.isEmpty((Object)user.getAadLoginId())) {
                        userName = user.getAadLoginId();
                    }
                    logger.debug("....localusers....." + user.getUserName());
                    userMap.put(userName.toLowerCase(), user);
                    continue;
                }
                if (!user.isGuest()) continue;
                guestUsers.add(user);
            }
            for (User user : guestUsers) {
                logger.debug("guest user..." + user.getUserName());
                logger.debug("guest user.mail.." + user.getEmailId());
                if (aadMap.containsKey(user.getUserName()) || aadMap.containsKey(user.getUserName().toLowerCase())) {
                    logger.debug("removeUserbyID.........." + String.valueOf(user.getUserId()));
                    this.userDao.removeUserbyID(cloudId, user.getUserId().toString());
                    continue;
                }
                if (!aadMapWithEmail.containsKey(user.getUserName().toLowerCase()) && !aadMapWithEmail.containsKey(user.getUserName())) continue;
                logger.debug("removeUserbyID.........." + String.valueOf(user.getUserId()));
                this.userDao.removeUserbyID(cloudId, user.getUserId().toString());
            }
            logger.debug(aadMap.size() + ".....map diff ..." + userMap.size());
            for (Map.Entry entry : userMap.entrySet()) {
                User existingUser = (User)entry.getValue();
                if (aadMap.containsKey(entry.getKey())) {
                    long totalGdriveBkpUsers;
                    int noOfGdriveUsersAllowed;
                    long totalGmailBkpUsers;
                    int noOfGmailUsersAllowed;
                    long totalExchangekpUsers;
                    int noOfExchangeUsersAllowed;
                    long totalOdbBkpUsers;
                    int noOfOneDriveUsersAllowed;
                    long totalSyncUsers;
                    int noOfSyncUsersAllowed;
                    boolean limitReached;
                    AADUserElement aadUserElement = aadMap.get(entry.getKey());
                    logger.debug(aadUserElement.isAccountEnabled() + "...already in user iteration..." + (String)entry.getKey());
                    boolean anyChange = false;
                    if (!anyChange && aadUserElement.isBackupEnabled() != existingUser.isBackupEnabled()) {
                        anyChange = true;
                        limitReached = this.checkBackupLimitReached(cloud, existingUser, aadUserElement);
                        if (limitReached) {
                            anyChange = false;
                        }
                    }
                    if (!anyChange && aadUserElement.isSyncEnabled() != existingUser.isSyncEnabled()) {
                        logger.debug("$#%#$%#$%#$%$#" + aadUserElement.getUserName() + ",,," + aadUserElement.isSyncEnabled() + "....." + existingUser.isSyncEnabled());
                        anyChange = true;
                        limitReached = this.checkSyncLimitReached(cloud, existingUser, aadUserElement);
                        if (limitReached) {
                            anyChange = false;
                        }
                    }
                    if (!anyChange && aadUserElement.isOnedriveBkpEnabled() != existingUser.isOnedriveBkpEnabled()) {
                        anyChange = true;
                        limitReached = this.checkOneDriveLimitReached(cloud, existingUser, aadUserElement);
                        if (limitReached) {
                            anyChange = false;
                        }
                    }
                    if (!anyChange && aadUserElement.isExchangeBkpEnabled() != existingUser.isExchangeBkpEnabled()) {
                        anyChange = true;
                        limitReached = this.checkExchangeLimitReached(cloud, existingUser, aadUserElement);
                        if (limitReached) {
                            anyChange = false;
                        }
                    }
                    if (!anyChange && aadUserElement.isSharePointBkpEnabled() != existingUser.isSharePointBkpEnabled()) {
                        anyChange = true;
                    }
                    if (!anyChange && aadUserElement.isGmailBkpEnabled() != existingUser.isGmailBkpEnabled()) {
                        anyChange = true;
                    }
                    if (!anyChange && aadUserElement.isGdriveBkpEnabled() != existingUser.isGdriveBkpEnabled()) {
                        anyChange = true;
                    }
                    if (existingUser.isSoftBlockEnabled()) {
                        anyChange = true;
                    }
                    if (!anyChange) continue;
                    logger.debug("...inside anyChange...........");
                    if (aadUserElement.isSyncEnabled() && ((long)(noOfSyncUsersAllowed = cloud.getNoOfSyncUsersAllowed()) == (totalSyncUsers = this.userDao.countOfPresentSyncUsers(cloud.getCloudId(), cloud.getCloudName(), true)) && !existingUser.isSyncEnabled() || (long)noOfSyncUsersAllowed < totalSyncUsers)) {
                        logger.debug(" SYNC USER LIMIT REACHED........");
                        aadUserElement.setSyncEnabled(false);
                    }
                    this.checkOneDriveLimitReached(cloud, existingUser, aadUserElement);
                    if (aadUserElement.isOnedriveBkpEnabled() && this.isLiecnseEnabled(cloud.getCloudCustomisableDetails(), ODB_BACKUP_ENABLED) && ((long)(noOfOneDriveUsersAllowed = cloud.getNoOfOneDriveUsersAllowed()) == (totalOdbBkpUsers = this.userDao.countOfPresentOnedriveUsers(cloud.getCloudId(), true)) && !existingUser.isOnedriveBkpEnabled() || (long)noOfOneDriveUsersAllowed < totalOdbBkpUsers)) {
                        logger.debug("onedrive  USER LIMIT REACHED........");
                        aadUserElement.setOnedriveBkpEnabled(false);
                    }
                    if (aadUserElement.isExchangeBkpEnabled() && this.isLiecnseEnabled(cloud.getCloudCustomisableDetails(), EXCHANGE_BACKUP_ENABLED) && ((long)(noOfExchangeUsersAllowed = cloud.getNoOfExchangeUsersAllowed()) == (totalExchangekpUsers = this.userDao.countOfPresentExchangeUsers(cloud.getCloudId(), true)) && !existingUser.isExchangeBkpEnabled() || (long)noOfExchangeUsersAllowed < totalExchangekpUsers)) {
                        logger.debug("exchange USER LIMIT REACHED........");
                        aadUserElement.setExchangeBkpEnabled(false);
                    }
                    if (aadUserElement.isGmailBkpEnabled() && this.isLiecnseEnabled(cloud.getCloudCustomisableDetails(), GMAIL_BACKUP_ENABLED) && ((long)(noOfGmailUsersAllowed = cloud.getNoOfGmailUsersAllowed()) == (totalGmailBkpUsers = this.userDao.countOfPresentGmailBackupUsers(cloud.getCloudId(), cloud.getCloudName(), true)) && !existingUser.isGmailBkpEnabled() || (long)noOfGmailUsersAllowed < totalGmailBkpUsers)) {
                        logger.debug("Gmail USER LIMIT REACHED........");
                        aadUserElement.setGmailBkpEnabled(false);
                    }
                    if (aadUserElement.isGdriveBkpEnabled() && this.isLiecnseEnabled(cloud.getCloudCustomisableDetails(), GDRIVE_BACKUP_ENABLED) && ((long)(noOfGdriveUsersAllowed = cloud.getNoOfGdriveUsersAllowed()) == (totalGdriveBkpUsers = this.userDao.countOfPresentGdriveBackupUsers(cloud.getCloudId(), cloud.getCloudName(), true)) && !existingUser.isGdriveBkpEnabled() || (long)noOfGdriveUsersAllowed < totalGdriveBkpUsers)) {
                        logger.debug("Gdriev USER LIMIT REACHED........");
                        aadUserElement.setGdriveBkpEnabled(false);
                    }
                    boolean previStatus = existingUser.isActive();
                    StringBuilder changesInAAD = new StringBuilder();
                    existingUser.setBackupEnabled(aadUserElement.isBackupEnabled());
                    existingUser.setSyncEnabled(aadUserElement.isSyncEnabled());
                    existingUser.setOnedriveBkpEnabled(aadUserElement.isOnedriveBkpEnabled());
                    existingUser.setExchangeBkpEnabled(aadUserElement.isExchangeBkpEnabled());
                    existingUser.setSharePointBkpEnabled(aadUserElement.isSharePointBkpEnabled());
                    existingUser.setGmailBkpEnabled(aadUserElement.isGmailBkpEnabled());
                    existingUser.setGdriveBkpEnabled(aadUserElement.isGdriveBkpEnabled());
                    existingUser.setSoftBlockEnabled(false);
                    if (!aadUserElement.isAccountEnabled() && cloudProperties != null && cloudProperties.isSoftBlockEnabled() && !existingUser.isSoftBlockEnabled()) {
                        existingUser.setSoftBlockEnabled(true);
                    }
                    existingUser.setActive(true);
                    this.userDao.saveUser(cloud.getCloudId(), cloud.getCloudName(), existingUser);
                    this.deviceDao.updateUserStatusInDeviceBkpOverview(cloudId, existingUser.getUserName(), Boolean.valueOf(existingUser.isActive()));
                    this.blockDevice(existingUser, cloud.getCloudName(), cloudId);
                    this.setAuditForAADBlockedOrUnblocked(cloud.getCloudId(), cloud.getCloudName(), existingUser.getUserName(), existingUser.isActive(), previStatus);
                    continue;
                }
                logger.debug("...inside blocking existing user" + (String)entry.getKey());
                if (cloudProperties != null && cloudProperties.isSoftBlockEnabled()) {
                    if (existingUser.isSoftBlockEnabled()) continue;
                    existingUser.setSoftBlockEnabled(true);
                    existingUser.setSoftBlockedTime(System.currentTimeMillis());
                    this.userDao.saveUser(cloud.getCloudId(), cloud.getCloudName(), existingUser);
                    continue;
                }
                boolean previStatus = existingUser.isActive();
                existingUser.setBackupEnabled(false);
                existingUser.setSyncEnabled(false);
                existingUser.setOnedriveBkpEnabled(false);
                existingUser.setActive(false);
                this.userDao.saveUser(cloud.getCloudId(), cloud.getCloudName(), existingUser);
                this.deviceDao.updateUserInfoInDeviceBkpOverview(cloud.getCloudId(), existingUser);
                this.setAuditForAADBlockedOrUnblocked(cloud.getCloudId(), cloud.getCloudName(), existingUser.getUserName(), existingUser.isActive(), previStatus);
                this.changeDeviceStatusAndAduit(cloud, existingUser);
            }
            for (Map.Entry entry : aadMap.entrySet()) {
                if (userMap.containsKey(entry.getKey())) continue;
                logger.debug("...adding new user to user collection..." + (String)entry.getKey());
                AADUserElement aadUserElement = aadMap.get(entry.getKey());
                this.updateOrCreateAADUserInfo(cloud, aadUserElement, aadCredentials);
            }
        } else {
            logger.debug("Either aadCredentials or authToken or accessToken is Empty so no Sync");
        }
    }

    private boolean checkBackupLimitReached(Cloud cloud, User existingUser, AADUserElement aadUserElement) {
        long totalBkpUsers;
        int noOfBkpUsersAllowed;
        boolean limitReached = false;
        if (aadUserElement.isBackupEnabled() && ((long)(noOfBkpUsersAllowed = cloud.getNoOfBackupUsersAllowed()) == (totalBkpUsers = this.userDao.countOfPresentBackupUsers(cloud.getCloudId(), cloud.getCloudName(), true, true)) && !existingUser.isBackupEnabled() || (long)noOfBkpUsersAllowed < totalBkpUsers)) {
            logger.debug(" BACKUP USER LIMIT REACHED........");
            aadUserElement.setBackupEnabled(false);
            limitReached = true;
        }
        return limitReached;
    }

    private boolean checkOneDriveLimitReached(Cloud cloud, User existingUser, AADUserElement aadUserElement) {
        long totalOdbBkpUsers;
        int noOfOneDriveUsersAllowed;
        boolean limitReached = false;
        if (aadUserElement.isOnedriveBkpEnabled() && this.isLiecnseEnabled(cloud.getCloudCustomisableDetails(), ODB_BACKUP_ENABLED) && ((long)(noOfOneDriveUsersAllowed = cloud.getNoOfOneDriveUsersAllowed()) == (totalOdbBkpUsers = this.userDao.countOfPresentOnedriveUsers(cloud.getCloudId(), true)) && !existingUser.isOnedriveBkpEnabled() || (long)noOfOneDriveUsersAllowed < totalOdbBkpUsers)) {
            logger.debug("onedrive  USER LIMIT REACHED........");
            aadUserElement.setOnedriveBkpEnabled(false);
            limitReached = true;
        }
        return limitReached;
    }

    private boolean checkExchangeLimitReached(Cloud cloud, User existingUser, AADUserElement aadUserElement) {
        long totalExchangekpUsers;
        int noOfExchangeUsersAllowed;
        boolean limitReached = false;
        if (aadUserElement.isExchangeBkpEnabled() && this.isLiecnseEnabled(cloud.getCloudCustomisableDetails(), EXCHANGE_BACKUP_ENABLED) && ((long)(noOfExchangeUsersAllowed = cloud.getNoOfExchangeUsersAllowed()) == (totalExchangekpUsers = this.userDao.countOfPresentExchangeUsers(cloud.getCloudId(), true)) && !existingUser.isExchangeBkpEnabled() || (long)noOfExchangeUsersAllowed < totalExchangekpUsers)) {
            logger.debug("exchange USER LIMIT REACHED........");
            aadUserElement.setExchangeBkpEnabled(false);
            limitReached = true;
        }
        return limitReached;
    }

    private boolean checkSyncLimitReached(Cloud cloud, User existingUser, AADUserElement aadUserElement) {
        long totalSyncUsers;
        int noOfSyncUsersAllowed;
        boolean limitReached = false;
        if (aadUserElement.isSyncEnabled() && ((long)(noOfSyncUsersAllowed = cloud.getNoOfSyncUsersAllowed()) == (totalSyncUsers = this.userDao.countOfPresentSyncUsers(cloud.getCloudId(), cloud.getCloudName(), true)) && !existingUser.isSyncEnabled() || (long)noOfSyncUsersAllowed < totalSyncUsers)) {
            logger.debug(" SYNC USER LIMIT REACHED........");
            aadUserElement.setSyncEnabled(false);
            limitReached = true;
        }
        return limitReached;
    }

    private List<AADUserElement> syncNewGroupChanges(Cloud cloud, IdentityProviderSettings aadCredentials, AADAuthorizationToken authToken) {
        ArrayList<AADUserElement> aadUserElements = new ArrayList<AADUserElement>();
        try {
            Set groupsInDB = aadCredentials.getGroupMapping().stream().map(GroupMapping::getGroupName).filter(group -> !org.springframework.util.StringUtils.isEmpty((Object)group)).collect(Collectors.toSet());
            if (aadCredentials.isManyToManyMappingEnabled()) {
                groupsInDB = new HashSet();
                List GroupMappingList = aadCredentials.getGroupMapping();
                if (!CollectionUtils.isEmpty((Collection)GroupMappingList)) {
                    for (GroupMapping GroupMapping2 : GroupMappingList) {
                        groupsInDB.add(GroupMapping2.getGroupName());
                    }
                }
            }
            if (CollectionUtils.isEmpty(groupsInDB)) {
                logger.debug("Group name is empty so retun..");
                return aadUserElements;
            }
            groupsInDB = groupsInDB.stream().map(String::toLowerCase).collect(Collectors.toSet());
            for (String groupDisplayName : groupsInDB) {
                String groupId = null;
                try {
                    try (CloseableHttpClient client = HttpClients.createDefault();){
                        String filter = "displayName eq '" + groupDisplayName + "'";
                        String encodedFilter = URLEncoder.encode(filter, StandardCharsets.UTF_8.toString());
                        String groupUrl = "https://graph.microsoft.com/v1.0/groups?$filter=" + encodedFilter;
                        int maxRetries = 1;
                        boolean retried = false;
                        HttpGet getGroup = new HttpGet(groupUrl);
                        getGroup.addHeader("Authorization", "Bearer " + authToken.getAccess_token());
                        getGroup.addHeader("Accept", "application/json");
                        try {
                            while (true) {
                                CloseableHttpResponse response = client.execute((HttpUriRequest)getGroup);
                                try {
                                    int statusCode = response.getStatusLine().getStatusCode();
                                    String respStr = EntityUtils.toString((HttpEntity)response.getEntity());
                                    logger.debug("Raw JSON response: " + respStr);
                                    if (statusCode == 401 || respStr.contains("token is expired") || respStr.contains("InvalidAuthenticationToken")) {
                                        if (!retried && maxRetries > 0) {
                                            logger.warn("Token expired or unauthorized. Attempting to refresh token and retry...");
                                            authToken = this.getAccessTokenAndUpdateInDB(cloud.getCloudId(), authToken);
                                            getGroup.setHeader("Authorization", "Bearer " + authToken.getAccess_token());
                                            retried = true;
                                            --maxRetries;
                                            continue;
                                        }
                                        logger.error("Authorization failed even after retrying. Aborting.");
                                    } else {
                                        JSONObject respJson = new JSONObject(respStr);
                                        JSONArray groups = respJson.optJSONArray("value");
                                        if (groups == null || groups.length() == 0) {
                                            logger.debug("No group found with name: " + groupDisplayName);
                                        } else {
                                            groupId = groups.getJSONObject(0).getString("id");
                                            logger.debug("GroupId: " + groupId);
                                        }
                                    }
                                }
                                finally {
                                    if (response == null) continue;
                                    response.close();
                                    continue;
                                }
                                break;
                            }
                        }
                        catch (Exception e) {
                            logger.error("Exception fetching groupId: " + e.getMessage(), (Throwable)e);
                        }
                    }
                    int userCount = 0;
                    Object membersUrl = "https://graph.microsoft.com/v1.0/groups/" + groupId + "/members";
                    String nextLink = "";
                    if (groupId != null) {
                        do {
                            try (CloseableHttpClient client = HttpClients.createDefault();){
                                logger.debug("...groups..." + groupId);
                                HttpGet getMembers = new HttpGet((String)membersUrl);
                                getMembers.addHeader("Authorization", "Bearer " + authToken.getAccess_token());
                                getMembers.addHeader("Accept", "application/json");
                                try (CloseableHttpResponse response = client.execute((HttpUriRequest)getMembers);){
                                    logger.debug(String.valueOf(getMembers) + "......Raw JSON response: " + String.valueOf(response));
                                    String respStr = EntityUtils.toString((HttpEntity)response.getEntity());
                                    logger.debug("Raw JSON response: " + respStr);
                                    JSONObject respJson = new JSONObject(respStr);
                                    JSONArray users = respJson.getJSONArray("value");
                                    if (!org.springframework.util.StringUtils.isEmpty((Object)respJson.optString("@odata.nextLink"))) {
                                        nextLink = respJson.optString("@odata.nextLink");
                                        membersUrl = nextLink;
                                    } else {
                                        nextLink = null;
                                    }
                                    for (int i = 0; i < users.length(); ++i) {
                                        JSONObject user = users.getJSONObject(i);
                                        logger.debug("User: " + user.optString("displayName") + ", userPrincipalName: " + user.optString("userPrincipalName") + ", id: " + user.optString("id"));
                                        AADUserElement aadUser = this.getAADUserFromUserNameToSync(cloud, user.optString("id"));
                                        aadUserElements.add(aadUser);
                                        ++userCount;
                                    }
                                }
                            }
                        } while (!org.springframework.util.StringUtils.isEmpty((Object)nextLink));
                    }
                    logger.debug(aadUserElements.size() + "*******userlist***" + userCount);
                }
                catch (Exception ee) {
                    ee.printStackTrace();
                    logger.error("....erorror....." + ee.getMessage());
                }
            }
        }
        catch (Exception e) {
            logger.error(" Exception  :..........." + String.valueOf(e));
            logger.debug(" Exception  :...........", (Throwable)e);
            aadUserElements = new ArrayList();
        }
        return aadUserElements;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private GraphGroupDeltaPageTO getGroupDelta(int cloudId, AADAuthorizationToken authToken, String nextLink) {
        StringBuilder response = new StringBuilder();
        GraphGroupDeltaPageTO graphGroupDeltaPageTO = null;
        boolean retry = false;
        int retryCount = 0;
        CloseableHttpClient httpclient = null;
        HttpGet httpGet = null;
        CloseableHttpResponse result = null;
        ObjectMapper mapper = new ObjectMapper();
        do {
            block27: {
                block25: {
                    block26: {
                        block23: {
                            block24: {
                                GraphGroupDeltaPageTO graphGroupDeltaPageTO2;
                                block20: {
                                    block21: {
                                        try {
                                            mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
                                            String url = null;
                                            url = !org.springframework.util.StringUtils.isEmpty((Object)nextLink) ? nextLink : "https://graph.microsoft.com/v1.0/groups/delta";
                                            Proxy proxy = this.settingsDao.getProxy(cloudId);
                                            if (proxy != null || !org.springframework.util.StringUtils.isEmpty((Object)this.registry.get(cloudId).getProxyHost()) && !org.springframework.util.StringUtils.isEmpty((Object)this.registry.get(cloudId).getProxyPort())) {
                                                logger.debug("host :" + this.registry.get(cloudId).getProxyHost());
                                                logger.debug("port :" + this.registry.get(cloudId).getProxyPort());
                                                HttpHost proxyval = new HttpHost(this.registry.get(cloudId).getProxyHost(), this.registry.get(cloudId).getProxyPort(), "http");
                                                DefaultProxyRoutePlanner routePlanner = new DefaultProxyRoutePlanner(proxyval);
                                                httpclient = HttpClients.custom().setRoutePlanner((HttpRoutePlanner)routePlanner).build();
                                            } else {
                                                httpclient = HttpClients.custom().build();
                                            }
                                            httpGet = new HttpGet(url);
                                            httpGet.addHeader("Authorization", "Bearer " + authToken.getAccess_token());
                                            httpGet.addHeader("Accept", "application/json");
                                            result = httpclient.execute((HttpUriRequest)httpGet);
                                            int httpResponseCode = result.getStatusLine().getStatusCode();
                                            logger.debug("..getAADUserFromUserName ........httpclient response code ......... " + httpResponseCode);
                                            if (httpResponseCode == 401) {
                                                retry = true;
                                                ++retryCount;
                                                AADAuthorizationToken accessTokenAndUpdateInDB = this.getAccessTokenAndUpdateInDB(cloudId, authToken);
                                                if (accessTokenAndUpdateInDB == null) {
                                                    logger.debug("token is expired so return");
                                                    graphGroupDeltaPageTO2 = null;
                                                    if (httpGet == null) break block20;
                                                    break block21;
                                                }
                                                this.getGroupDelta(cloudId, authToken, nextLink);
                                            } else if (httpResponseCode == 200) {
                                                InputStream inputStream = result.getEntity().getContent();
                                                try (BufferedReader in = new BufferedReader(new InputStreamReader(inputStream));){
                                                    String inputLine;
                                                    while ((inputLine = in.readLine()) != null) {
                                                        response.append(inputLine);
                                                    }
                                                }
                                                graphGroupDeltaPageTO = (GraphGroupDeltaPageTO)mapper.readValue(response.toString(), GraphGroupDeltaPageTO.class);
                                                if (httpGet == null) break block23;
                                                break block24;
                                            }
                                            if (httpGet == null) break block25;
                                            break block26;
                                        }
                                        catch (Exception e) {
                                            logger.trace(String.valueOf(e));
                                            logger.error(" ERROR trying to get AADUser From UserName " + e.getMessage());
                                            retry = true;
                                            ++retryCount;
                                            break block27;
                                        }
                                    }
                                    httpGet.releaseConnection();
                                }
                                this.closeResponse(result);
                                this.closeHttpClient(httpclient);
                                return graphGroupDeltaPageTO2;
                            }
                            httpGet.releaseConnection();
                        }
                        this.closeResponse(result);
                        this.closeHttpClient(httpclient);
                        return graphGroupDeltaPageTO;
                    }
                    httpGet.releaseConnection();
                }
                this.closeResponse(result);
                this.closeHttpClient(httpclient);
                break block27;
                finally {
                    if (httpGet != null) {
                        httpGet.releaseConnection();
                    }
                    this.closeResponse(result);
                    this.closeHttpClient(httpclient);
                }
            }
            if (!retry) return graphGroupDeltaPageTO;
        } while (retryCount < 2);
        return graphGroupDeltaPageTO;
    }

    @Override
    public AADUserElement getAADUsersFromUserName(int cloudId, String userName) {
        AADUserElement aadUser = null;
        AADAuthorizationToken aadToken = this.aadDao.getAADAuthorizationtoken(cloudId);
        if (aadToken == null || org.springframework.util.StringUtils.isEmpty((Object)aadToken.getAccess_token())) {
            logger.debug("aadAuthToken or accessToken is empty so return....");
            return null;
        }
        User user = this.userDao.getUserByUserNameOrAADLoginId(cloudId, userName);
        if (user == null || user != null && user.isGuest()) {
            aadUser = this.getAADUserFromUserName(cloudId, userName, aadToken);
            if (aadUser != null) {
                logger.debug("...........User " + aadUser.getUserName() + " .........found in AAD");
            } else {
                logger.debug("...........User " + userName + " .........  Not found in AAD");
            }
        } else {
            logger.debug("$##############################" + userName + " ........present in our db....");
        }
        return aadUser;
    }

    @Override
    public boolean checkTokenExpired(int cloudId) {
        boolean isTokenExpired = false;
        AADAuthorizationToken aadToken = this.aadDao.getAADAuthorizationtoken(cloudId);
        if (aadToken == null || org.springframework.util.StringUtils.isEmpty((Object)aadToken.getAccess_token())) {
            logger.debug("aadAuthToken or accessToken is empty so return....");
            return isTokenExpired;
        }
        AADAuthorizationToken accessTokenAndUpdateInDB = this.getAccessTokenAndUpdateInDB(cloudId, aadToken);
        if (accessTokenAndUpdateInDB == null) {
            logger.debug("..token is expred so send the mail");
            isTokenExpired = true;
        }
        return isTokenExpired;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private AADUserElement getAADUserFromUserName(int cloudId, String userName, AADAuthorizationToken authToken) {
        StringBuilder response = new StringBuilder();
        CloseableHttpClient httpclient = null;
        HttpGet httpGet = null;
        CloseableHttpResponse result = null;
        AADUserElement aadUser = null;
        boolean retry = false;
        int retryCount = 0;
        ObjectMapper mapper = new ObjectMapper();
        do {
            block32: {
                block23: {
                    block24: {
                        block30: {
                            block31: {
                                block28: {
                                    block29: {
                                        AADUserElement aADUserElement;
                                        block26: {
                                            block27: {
                                                DefaultProxyRoutePlanner routePlanner;
                                                block21: {
                                                    block22: {
                                                        try {
                                                            mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
                                                            String url = this.getUserInfoUrl(userName);
                                                            logger.debug("url to get the user from aad:" + url);
                                                            Proxy proxy = this.settingsDao.getProxy(cloudId);
                                                            if (proxy != null || !org.springframework.util.StringUtils.isEmpty((Object)this.registry.get(cloudId).getProxyHost()) && !org.springframework.util.StringUtils.isEmpty((Object)this.registry.get(cloudId).getProxyPort())) {
                                                                logger.debug("host :" + this.registry.get(cloudId).getProxyHost());
                                                                logger.debug("port :" + this.registry.get(cloudId).getProxyPort());
                                                                HttpHost proxyval = new HttpHost(this.registry.get(cloudId).getProxyHost(), this.registry.get(cloudId).getProxyPort(), "http");
                                                                routePlanner = new DefaultProxyRoutePlanner(proxyval);
                                                                httpclient = HttpClients.custom().setRoutePlanner((HttpRoutePlanner)routePlanner).build();
                                                            } else {
                                                                httpclient = HttpClients.custom().build();
                                                            }
                                                            httpGet = new HttpGet(url);
                                                            httpGet.addHeader("Authorization", "Bearer " + authToken.getAccess_token());
                                                            httpGet.addHeader("Accept", "application/json");
                                                            result = httpclient.execute((HttpUriRequest)httpGet);
                                                            int httpResponseCode = result.getStatusLine().getStatusCode();
                                                            logger.debug("getAADUserFromUserName ........response code ......... " + httpResponseCode);
                                                            if (httpResponseCode == 401) {
                                                                retry = true;
                                                                ++retryCount;
                                                                if ((authToken = this.getAccessTokenAndUpdateInDB(cloudId, authToken)) == null) {
                                                                    logger.debug("..token is expred ....");
                                                                    routePlanner = null;
                                                                    if (httpGet == null) break block21;
                                                                    break block22;
                                                                }
                                                                this.getAADUserFromUserName(cloudId, userName, authToken);
                                                                if (httpGet == null) break block23;
                                                                break block24;
                                                            }
                                                            if (httpResponseCode == 200) {
                                                                InputStream inputStream = result.getEntity().getContent();
                                                                try (BufferedReader in = new BufferedReader(new InputStreamReader(inputStream));){
                                                                    String inputLine;
                                                                    while ((inputLine = in.readLine()) != null) {
                                                                        response.append(inputLine);
                                                                    }
                                                                }
                                                                aadUser = (AADUserElement)mapper.readValue(response.toString(), AADUserElement.class);
                                                                if (aadUser != null && !aadUser.isAccountEnabled()) {
                                                                    logger.debug("...aaduseractiveornot....." + aadUser.getUserPrincipalName() + "...." + aadUser.isAccountEnabled());
                                                                    aADUserElement = null;
                                                                    if (httpGet == null) break block26;
                                                                    break block27;
                                                                }
                                                                if (httpGet == null) break block28;
                                                                break block29;
                                                            }
                                                            logger.debug("..........user not fount.........");
                                                            if (httpGet == null) break block30;
                                                            break block31;
                                                        }
                                                        catch (Exception e) {
                                                            logger.trace(String.valueOf(e));
                                                            logger.error(" ERROR trying to get AADUser From UserName " + e.getMessage());
                                                            retry = true;
                                                            ++retryCount;
                                                            break block32;
                                                        }
                                                    }
                                                    httpGet.releaseConnection();
                                                }
                                                this.closeResponse(result);
                                                this.closeHttpClient(httpclient);
                                                return routePlanner;
                                            }
                                            httpGet.releaseConnection();
                                        }
                                        this.closeResponse(result);
                                        this.closeHttpClient(httpclient);
                                        return aADUserElement;
                                    }
                                    httpGet.releaseConnection();
                                }
                                this.closeResponse(result);
                                this.closeHttpClient(httpclient);
                                return aadUser;
                            }
                            httpGet.releaseConnection();
                        }
                        this.closeResponse(result);
                        this.closeHttpClient(httpclient);
                        return aadUser;
                    }
                    httpGet.releaseConnection();
                }
                this.closeResponse(result);
                this.closeHttpClient(httpclient);
                break block32;
                finally {
                    if (httpGet != null) {
                        httpGet.releaseConnection();
                    }
                    this.closeResponse(result);
                    this.closeHttpClient(httpclient);
                }
            }
            if (!retry) return aadUser;
        } while (retryCount < 2);
        return aadUser;
    }

    private void closeHttpClient(CloseableHttpClient httpclient) {
        if (httpclient != null) {
            try {
                httpclient.close();
            }
            catch (IOException e) {
                logger.error("error in closing http client:" + e.getMessage());
            }
        }
    }

    private void closeResponse(CloseableHttpResponse result) {
        if (result != null) {
            try {
                result.close();
            }
            catch (IOException e) {
                logger.error("error in closing http client:" + e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<String> getAADUserGroupInfo(int cloudId, String userName, AADAuthorizationToken authToken) {
        StringBuilder response = new StringBuilder();
        ArrayList<String> userMemeberOf = new ArrayList<String>();
        HashSet userMemeberOfSet = new HashSet();
        boolean retry = false;
        int retryCount = 0;
        CloseableHttpClient httpclient = null;
        HttpGet httpGet = null;
        CloseableHttpResponse result = null;
        ObjectMapper mapper = new ObjectMapper();
        if (userName.contains("#")) {
            userName.replace("#", "%23");
        }
        if (userName.contains("%")) {
            userName.replace("%", "%25");
        }
        Object url = "https://graph.microsoft.com/v1.0//users/" + userName + GRAPH_USER_MEMBER_OF;
        boolean isSkipTokenAvailable = false;
        do {
            block34: {
                block35: {
                    block32: {
                        block33: {
                            block30: {
                                block31: {
                                    List<String> list;
                                    block27: {
                                        block28: {
                                            try {
                                                mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
                                                logger.debug(".....url...." + (String)url);
                                                Proxy proxy = this.settingsDao.getProxy(cloudId);
                                                if (proxy != null || !org.springframework.util.StringUtils.isEmpty((Object)this.registry.get(cloudId).getProxyHost()) && !org.springframework.util.StringUtils.isEmpty((Object)this.registry.get(cloudId).getProxyPort())) {
                                                    logger.debug("host :" + this.registry.get(cloudId).getProxyHost());
                                                    logger.debug("port :" + this.registry.get(cloudId).getProxyPort());
                                                    HttpHost proxyval = new HttpHost(this.registry.get(cloudId).getProxyHost(), this.registry.get(cloudId).getProxyPort(), "http");
                                                    DefaultProxyRoutePlanner routePlanner = new DefaultProxyRoutePlanner(proxyval);
                                                    httpclient = HttpClients.custom().setRoutePlanner((HttpRoutePlanner)routePlanner).build();
                                                } else {
                                                    httpclient = HttpClients.custom().build();
                                                }
                                                httpGet = new HttpGet((String)url);
                                                httpGet.addHeader("Authorization", "Bearer " + authToken.getAccess_token());
                                                httpGet.addHeader("Accept", "application/json");
                                                result = httpclient.execute((HttpUriRequest)httpGet);
                                                int httpResponseCode = result.getStatusLine().getStatusCode();
                                                logger.debug(userName + "..........getAADUserFromUserName ........response code ......... " + httpResponseCode);
                                                if (httpResponseCode == 401) {
                                                    retry = true;
                                                    ++retryCount;
                                                    AADAuthorizationToken accessTokenAndUpdateInDB = this.getAccessTokenAndUpdateInDB(cloudId, authToken);
                                                    if (accessTokenAndUpdateInDB == null) {
                                                        logger.debug("token is expired so return");
                                                        list = null;
                                                        if (httpGet == null) break block27;
                                                        break block28;
                                                    }
                                                    this.getAADUserGroupInfo(cloudId, userName, authToken);
                                                } else if (httpResponseCode == 200) {
                                                    InputStream inputStream = result.getEntity().getContent();
                                                    try (BufferedReader in = new BufferedReader(new InputStreamReader(inputStream));){
                                                        String inputLine;
                                                        while ((inputLine = in.readLine()) != null) {
                                                            response.append(inputLine);
                                                        }
                                                    }
                                                    GraphResponseForMemberOf forMemberOf = (GraphResponseForMemberOf)mapper.readValue(response.toString(), GraphResponseForMemberOf.class);
                                                    if (forMemberOf != null && !CollectionUtils.isEmpty((Collection)forMemberOf.getGroupInfo())) {
                                                        List groupInfo = forMemberOf.getGroupInfo();
                                                        List userMemberList = groupInfo.stream().map(group -> group.getDisplayName().toLowerCase()).collect(Collectors.toList());
                                                        userMemeberOf.addAll(userMemberList);
                                                        userMemeberOfSet.addAll(userMemberList);
                                                    }
                                                    response = new StringBuilder();
                                                    if (!org.springframework.util.StringUtils.isEmpty((Object)forMemberOf.getNextLink())) {
                                                        logger.debug((String)url + ".... link available....." + forMemberOf.getNextLink());
                                                        if (((String)url).equalsIgnoreCase(forMemberOf.getNextLink())) {
                                                            logger.debug((String)url + ".... link available.but same...." + String.valueOf(userMemeberOfSet));
                                                            isSkipTokenAvailable = false;
                                                            if (httpGet == null) break block30;
                                                            break block31;
                                                        }
                                                        url = forMemberOf.getNextLink();
                                                        isSkipTokenAvailable = true;
                                                    }
                                                    if (org.springframework.util.StringUtils.isEmpty((Object)forMemberOf.getNextLink())) {
                                                        logger.debug("....no link available.....");
                                                        isSkipTokenAvailable = false;
                                                        if (httpGet == null) break block32;
                                                        break block33;
                                                    }
                                                }
                                                if (httpGet == null) break block34;
                                                break block35;
                                            }
                                            catch (Exception e) {
                                                logger.trace(String.valueOf(e));
                                                logger.error(" ERROR trying to get getAADUserGroupInfo " + e.getMessage());
                                                retry = true;
                                                ++retryCount;
                                                continue;
                                            }
                                        }
                                        httpGet.releaseConnection();
                                    }
                                    this.closeResponse(result);
                                    this.closeHttpClient(httpclient);
                                    return list;
                                }
                                httpGet.releaseConnection();
                            }
                            this.closeResponse(result);
                            this.closeHttpClient(httpclient);
                            return userMemeberOf;
                        }
                        httpGet.releaseConnection();
                    }
                    this.closeResponse(result);
                    this.closeHttpClient(httpclient);
                    return userMemeberOf;
                }
                httpGet.releaseConnection();
            }
            this.closeResponse(result);
            this.closeHttpClient(httpclient);
            continue;
            finally {
                if (httpGet != null) {
                    httpGet.releaseConnection();
                }
                this.closeResponse(result);
                this.closeHttpClient(httpclient);
            }
        } while (retry && retryCount < 2 || isSkipTokenAvailable);
        return userMemeberOf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AADAuthorizationToken getAccessTokenAndUpdateInDB(int cloudId, AADAuthorizationToken aadAuthToken) {
        CloseableHttpResponse result;
        CloseableHttpClient httpclient;
        block11: {
            int httpResponseCode;
            String refreshToken;
            String accessToken;
            HttpPost httPost;
            block9: {
                AADAuthorizationToken aADAuthorizationToken;
                block10: {
                    IdentityProviderSettings aadCredentials = this.aadDao.getAADCredentials(cloudId);
                    httpclient = null;
                    httPost = null;
                    result = null;
                    accessToken = "";
                    refreshToken = "";
                    logger.debug("  getAccessToken............HttpURLConnection.............................");
                    Proxy proxy = this.settingsDao.getProxy(cloudId);
                    if (proxy != null || !org.springframework.util.StringUtils.isEmpty((Object)this.registry.get(cloudId).getProxyHost()) && !org.springframework.util.StringUtils.isEmpty((Object)this.registry.get(cloudId).getProxyPort())) {
                        logger.debug("host :" + this.registry.get(cloudId).getProxyHost());
                        logger.debug("port :" + this.registry.get(cloudId).getProxyPort());
                        HttpHost proxyval = new HttpHost(this.registry.get(cloudId).getProxyHost(), this.registry.get(cloudId).getProxyPort(), "http");
                        DefaultProxyRoutePlanner routePlanner = new DefaultProxyRoutePlanner(proxyval);
                        httpclient = HttpClients.custom().setRoutePlanner((HttpRoutePlanner)routePlanner).build();
                    } else {
                        httpclient = HttpClients.custom().build();
                    }
                    String loginUrl = TOKEN_URL + aadCredentials.getTenentId() + OAUTH2_TOKEN_URL;
                    httPost = new HttpPost(loginUrl);
                    logger.debug("...loginUrl..." + loginUrl);
                    ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
                    params.add(new BasicNameValuePair("grant_type", REFRESH_TOKEN));
                    params.add(new BasicNameValuePair("client_id", aadCredentials.getClientId()));
                    params.add(new BasicNameValuePair(REFRESH_TOKEN, aadAuthToken.getRefresh_token()));
                    params.add(new BasicNameValuePair("client_secret", aadCredentials.getSecretKey()));
                    httPost.setEntity((HttpEntity)new UrlEncodedFormEntity(params, UTF_8));
                    httPost.setHeader(CONTENT_TYPE, "application/x-www-form-urlencoded");
                    result = httpclient.execute((HttpUriRequest)httPost);
                    httpResponseCode = result.getStatusLine().getStatusCode();
                    logger.debug("......getAccessTokenAndUpdateInDB....." + httpResponseCode);
                    if (httpResponseCode != 400) break block9;
                    logger.error("TOKEN has expired so remap the token...... ");
                    aADAuthorizationToken = null;
                    if (httPost == null) break block10;
                    httPost.releaseConnection();
                }
                this.closeResponse(result);
                this.closeHttpClient(httpclient);
                return aADAuthorizationToken;
            }
            try {
                String line;
                InputStream inputStream = result.getEntity().getContent();
                BufferedReader rd = new BufferedReader(new InputStreamReader(inputStream));
                StringBuilder response = new StringBuilder("");
                while ((line = rd.readLine()) != null) {
                    response.append(line);
                }
                rd.close();
                JSONObject jsonObject = new JSONObject(response.toString());
                accessToken = jsonObject.optString("access_token");
                logger.debug(httpResponseCode + "...aceestoken................." + accessToken);
                refreshToken = jsonObject.optString(REFRESH_TOKEN);
                this.aadDao.updateRefreshToken(1, refreshToken, accessToken);
                aadAuthToken.setAccess_token(accessToken);
                aadAuthToken.setRefresh_token(refreshToken);
                if (httPost == null) break block11;
            }
            catch (Exception e) {
                block12: {
                    try {
                        logger.trace(String.valueOf(e));
                        logger.error(" ERROR trying to get access token ...HttpURLConnection " + e.getMessage());
                        if (httPost == null) break block12;
                    }
                    catch (Throwable throwable) {
                        if (httPost != null) {
                            httPost.releaseConnection();
                        }
                        this.closeResponse(result);
                        this.closeHttpClient(httpclient);
                        throw throwable;
                    }
                    httPost.releaseConnection();
                }
                this.closeResponse(result);
                this.closeHttpClient(httpclient);
            }
            httPost.releaseConnection();
        }
        this.closeResponse(result);
        this.closeHttpClient(httpclient);
        return aadAuthToken;
    }

    private void updateOrCreateAADUserInfo(Cloud cloud, AADUserElement aadUserElement, IdentityProviderSettings aadCredentials) {
        try {
            User existingUser;
            boolean gdriveBackupEnabled;
            boolean gmailBkpEnabled;
            boolean sharePointBkpEnabled;
            boolean exchangeBkpEnabled;
            boolean odbBkpEnabled;
            boolean isBackupEnabled;
            boolean isSyncEnabled;
            CloudProperties cloudProperties;
            block28: {
                logger.debug(aadUserElement.getDefaultOdbPolicy() + "............updateOrCreateAADUserInfo......................." + aadUserElement.getUserPrincipalName() + "...." + this.registry.get(cloud.getCloudId()).getPropertyFileValueDefaultOdbPolicy());
                cloudProperties = this.cloudDao.getCloudProperties(cloud.getCloudId());
                isSyncEnabled = false;
                isBackupEnabled = false;
                odbBkpEnabled = false;
                exchangeBkpEnabled = false;
                sharePointBkpEnabled = false;
                gmailBkpEnabled = false;
                gdriveBackupEnabled = false;
                User user = new User();
                UUID uuid = UUID.randomUUID();
                String recoveryKey = String.valueOf(uuid);
                user.setSecurityRecoveryKey(recoveryKey);
                user.setActive(true);
                user.setSoftBlockEnabled(false);
                user.setAdmin(false);
                user.setBackupEnabled(aadUserElement.isBackupEnabled());
                user.setSyncEnabled(aadUserElement.isSyncEnabled());
                user.setFirstLogin(true);
                user.setShareEnabled(true);
                user.setUserName(aadUserElement.getUserPrincipalName());
                if (org.springframework.util.StringUtils.isEmpty((Object)aadUserElement.getMail())) {
                    user.setEmailId(aadUserElement.getUserPrincipalName());
                } else {
                    user.setEmailId(aadUserElement.getMail());
                }
                user.setCreatedTimestamp(String.valueOf(System.currentTimeMillis()));
                user.setDisplayName(aadUserElement.getDisplayName());
                user.setMigratedBy("AUTO");
                user.setLocalUser(false);
                user.setLocation(aadUserElement.getOfficeLocation());
                user.setDepartment(aadUserElement.getDepartment());
                user.setAccountStatus(true);
                user.setUserNameLowerCase(aadUserElement.getUserPrincipalName().toLowerCase());
                user.setPolicyName(aadUserElement.getDefaultPolicy());
                user.setSyncPolicyName(aadUserElement.getDefaultSyncPolicy());
                user.setOnedriveBkpEnabled(aadUserElement.isOnedriveBkpEnabled());
                user.setExchangeBkpEnabled(aadUserElement.isExchangeBkpEnabled());
                user.setSharePointBkpEnabled(aadUserElement.isSharePointBkpEnabled());
                user.setOneDrivePolicyName(aadUserElement.getDefaultOdbPolicy());
                user.setExchangePolicyName(aadUserElement.getDefaultExchangePolicy());
                user.setSpPolicyName(aadUserElement.getDefaultSharepointPolicy());
                user.setGmailPolicyName(aadUserElement.getDefaultGmailPolicy());
                user.setGdrivePolicyName(aadUserElement.getDefaultGdrivePolicy());
                UserElement userElement = new UserElement();
                BeanUtils.copyProperties((Object)user, (Object)userElement);
                existingUser = null;
                try {
                    long totalGdrivekpUsers;
                    int noOfGdriveUsersAllowed;
                    long totalGmailUsers;
                    int noOfGmailUsersAllowed;
                    long totalExchangekpUsers;
                    int noOfExchangeUsersAllowed;
                    long totalOdbBkpUsers;
                    int noOfOdbBkpUsersAllowed;
                    long totalBkpUsers;
                    int noOfBkpUsersAllowed;
                    long totalSyncUsers;
                    int noOfSyncUsersAllowed;
                    isSyncEnabled = aadUserElement.isSyncEnabled();
                    isBackupEnabled = aadUserElement.isBackupEnabled();
                    odbBkpEnabled = aadUserElement.isOnedriveBkpEnabled();
                    exchangeBkpEnabled = aadUserElement.isExchangeBkpEnabled();
                    sharePointBkpEnabled = aadUserElement.isSharePointBkpEnabled();
                    StringBuilder userdetails = new StringBuilder();
                    gmailBkpEnabled = aadUserElement.isGmailBkpEnabled();
                    gdriveBackupEnabled = aadUserElement.isGdriveBkpEnabled();
                    if (aadUserElement.isSyncEnabled() && (long)(noOfSyncUsersAllowed = cloud.getNoOfSyncUsersAllowed()) <= (totalSyncUsers = this.userDao.countOfPresentSyncUsers(cloud.getCloudId(), cloud.getCloudName(), true))) {
                        logger.debug(" SYNC USER LIMIT REACHED........");
                        isSyncEnabled = false;
                    }
                    if (aadUserElement.isBackupEnabled() && (long)(noOfBkpUsersAllowed = cloud.getNoOfBackupUsersAllowed()) <= (totalBkpUsers = this.userDao.countOfPresentBackupUsers(cloud.getCloudId(), cloud.getCloudName(), true, true))) {
                        logger.debug(" BACKUP USER LIMIT REACHED........");
                        isBackupEnabled = false;
                    }
                    if (aadUserElement.isOnedriveBkpEnabled() && (long)(noOfOdbBkpUsersAllowed = cloud.getNoOfOneDriveUsersAllowed()) <= (totalOdbBkpUsers = this.userDao.countOfPresentOnedriveUsers(cloud.getCloudId(), true))) {
                        logger.debug("Onedrive USER LIMIT REACHED........");
                        odbBkpEnabled = false;
                    }
                    if (aadUserElement.isExchangeBkpEnabled() && (long)(noOfExchangeUsersAllowed = cloud.getNoOfExchangeUsersAllowed()) <= (totalExchangekpUsers = this.userDao.countOfPresentExchangeUsers(cloud.getCloudId(), true))) {
                        logger.debug("exchange USER LIMIT REACHED........");
                        exchangeBkpEnabled = false;
                    }
                    if (aadUserElement.isGmailBkpEnabled() && (long)(noOfGmailUsersAllowed = cloud.getNoOfGmailUsersAllowed()) <= (totalGmailUsers = this.userDao.countOfPresentGmailBackupUsers(cloud.getCloudId(), "", true))) {
                        logger.debug("gmail USER LIMIT REACHED........");
                        gmailBkpEnabled = false;
                    }
                    if (aadUserElement.isGdriveBkpEnabled() && (long)(noOfGdriveUsersAllowed = cloud.getNoOfGdriveUsersAllowed()) <= (totalGdrivekpUsers = this.userDao.countOfPresentGdriveBackupUsers(cloud.getCloudId(), "", true))) {
                        logger.debug("gdrive USER LIMIT REACHED........");
                        gdriveBackupEnabled = false;
                    }
                    PortalProperties portalProperties = this.portalPropertiesDao.getPortalProperties(cloud.getCloudId(), this.registry.get(cloud.getCloudId()).getPropertyValueComponentName());
                    logger.debug(".....BLUDRIVE_MODE..." + String.valueOf(portalProperties.getComponentsProperties().get("BLUDRIVE_MODE")));
                    if (portalProperties.getComponentsProperties().get("BLUDRIVE_MODE").toString().equals("false")) {
                        user.setSyncAccessType("WEBANDENDPOINT");
                        logger.debug("....BLUDRIVE_MODE is false so set ..WEBANDENDPOINT");
                    } else {
                        user.setSyncAccessType("WEBONLY");
                        logger.debug("....BLUDRIVE_MODE is true so set ..WEBONLY");
                    }
                    user.setOnedriveBkpEnabled(odbBkpEnabled);
                    user.setExchangeBkpEnabled(exchangeBkpEnabled);
                    user.setBackupEnabled(isBackupEnabled);
                    user.setSyncEnabled(isSyncEnabled);
                    user.setGmailBkpEnabled(gmailBkpEnabled);
                    user.setGdriveBkpEnabled(gdriveBackupEnabled);
                    String googleSecretKey = this.getGoogleSecurityKey();
                    logger.debug("googleSecretKey for AAD ....." + googleSecretKey);
                    user.setGoogleSecretKey(googleSecretKey);
                    userElement.setGoogleSecretKey(googleSecretKey);
                    userElement.setOnedriveBkpEnabled(odbBkpEnabled);
                    userElement.setExchangeBkpEnabled(exchangeBkpEnabled);
                    userElement.setSharePointBkpEnabled(sharePointBkpEnabled);
                    userElement.setBackupEnabled(isBackupEnabled);
                    userElement.setSyncEnabled(isSyncEnabled);
                    userElement.setGmailBkpEnabled(gmailBkpEnabled);
                    userElement.setGdriveBkpEnabled(gdriveBackupEnabled);
                    userElement.setAzureUniqueId(aadUserElement.getId());
                    userElement.setUserPrinicipalName(aadUserElement.getUserPrincipalName());
                    userElement.setSyncAccessType(user.getSyncAccessType());
                    logger.debug("...aad creating user...." + userElement.getUserName() + ".." + isBackupEnabled + "..." + isSyncEnabled + "..." + odbBkpEnabled + "..." + exchangeBkpEnabled + "..." + sharePointBkpEnabled);
                    if (!(isBackupEnabled || isSyncEnabled || odbBkpEnabled || exchangeBkpEnabled || sharePointBkpEnabled || gmailBkpEnabled || gdriveBackupEnabled)) {
                        logger.error("...user limit reached ....");
                        return;
                    }
                    logger.debug("...acturalcreating user...." + userElement.getUserName() + ".." + isBackupEnabled + "..." + isSyncEnabled + "..." + odbBkpEnabled + "..." + exchangeBkpEnabled);
                    UserElement createduserElement = this.createUser(cloud.getCloudId(), cloud.getCloudName(), userElement, true, this.userDao);
                    if (createduserElement != null) {
                        MigrationStatus migrationStatus = new MigrationStatus();
                        migrationStatus.setMigratedBy("AUTO");
                        migrationStatus.setMigratededTimestamp(System.currentTimeMillis());
                        migrationStatus.setMigrated(true);
                        migrationStatus.setUserName(user.getUserName());
                        migrationStatus.setEmailId(user.getEmailId());
                        userElement.setOnedriveBkpEnabled(odbBkpEnabled);
                        userElement.setExchangeBkpEnabled(exchangeBkpEnabled);
                        userElement.setSharePointBkpEnabled(sharePointBkpEnabled);
                        userElement.setBackupEnabled(isBackupEnabled);
                        userElement.setSyncEnabled(isSyncEnabled);
                        this.migrationStatusDao.saveMigrationStatus(cloud.getCloudId(), migrationStatus);
                        String loginMode = aadCredentials.getLoginMode();
                        if (MICROSOFT.equalsIgnoreCase(loginMode)) {
                            loginMode = "Microsoft Entra";
                        } else if ("Google".equalsIgnoreCase(loginMode)) {
                            loginMode = "Google Identity";
                        }
                        String autitText = "IdP [" + loginMode + "]";
                        this.saveStatisticToDatabase(cloud.getCloudId(), cloud.getCloudName(), "Migrated ", "Auto", aadUserElement.getUserPrincipalName() + userdetails.toString(), autitText, System.currentTimeMillis(), PCActionTypes.ADD_USER_MIGRATION.getActionTypeValue());
                    }
                }
                catch (BaseException e) {
                    logger.debug("...error message " + e.getMessage());
                    if (e.getErrorStatus() != 1200) break block28;
                    logger.debug("User already exists......");
                    existingUser = this.userDao.getUserByUserNameOrAADLoginId(cloud.getCloudId(), aadUserElement.getUserPrincipalName());
                }
            }
            if (existingUser != null) {
                logger.debug("...inside updating existing user" + odbBkpEnabled + ".." + exchangeBkpEnabled);
                boolean previStatus = existingUser.isActive();
                existingUser.setBackupEnabled(isBackupEnabled);
                existingUser.setSyncEnabled(isSyncEnabled);
                existingUser.setOnedriveBkpEnabled(odbBkpEnabled);
                existingUser.setExchangeBkpEnabled(exchangeBkpEnabled);
                existingUser.setSharePointBkpEnabled(sharePointBkpEnabled);
                existingUser.setGmailBkpEnabled(gmailBkpEnabled);
                existingUser.setGdriveBkpEnabled(gdriveBackupEnabled);
                if (!(isBackupEnabled || isSyncEnabled || odbBkpEnabled || exchangeBkpEnabled || sharePointBkpEnabled)) {
                    if (cloudProperties != null && cloudProperties.isSoftBlockEnabled()) {
                        if (!existingUser.isSoftBlockEnabled()) {
                            existingUser.setSoftBlockEnabled(true);
                            existingUser.setSoftBlockedTime(System.currentTimeMillis());
                        }
                    } else {
                        existingUser.setActive(false);
                    }
                } else if (!existingUser.isActive()) {
                    long countOfPresentUsers = this.userDao.countOfPresentUsers(cloud.getCloudId(), cloud.getCloudName(), true);
                    int noOfUsersAllowed = cloud.getNoOfUsersAllowed();
                    if ((long)noOfUsersAllowed <= countOfPresentUsers) {
                        logger.debug(noOfUsersAllowed + "..User limit reached........." + countOfPresentUsers);
                        return;
                    }
                    existingUser.setActive(true);
                    existingUser.setSoftBlockEnabled(false);
                }
                this.userDao.saveUser(cloud.getCloudId(), cloud.getCloudName(), existingUser);
                this.deviceDao.updateUserInfoInDeviceBkpOverview(cloud.getCloudId(), existingUser);
                this.setAuditForAADBlockedOrUnblocked(cloud.getCloudId(), cloud.getCloudName(), existingUser.getUserName(), existingUser.isActive(), previStatus);
                if (!existingUser.isActive()) {
                    this.changeDeviceStatusAndAduit(cloud, existingUser);
                }
            }
        }
        catch (Exception e) {
            logger.error(EXCEPTION + String.valueOf(e));
            logger.debug(EXCEPTION + e.getMessage());
        }
    }

    private void auditFieldsForUser(UserElement userElement, StringBuilder userdetails) {
        if (userElement.isBackupEnabled()) {
            userdetails.append(" Backup Enabled ==> " + userElement.isBackupEnabled() + ", ");
            userdetails.append("Backup Policy ==> " + userElement.getPolicyName());
        }
        if (!org.springframework.util.StringUtils.isEmpty((Object)userdetails.toString())) {
            userdetails.append(" ,");
        }
        if (userElement.isOnedriveBkpEnabled()) {
            userdetails.append(" Onedrive for Business  Enabled ==> " + userElement.isOnedriveBkpEnabled() + ", ");
            userdetails.append("Onedrive Backup Policy ==> " + userElement.getOneDrivePolicyName());
        }
        if (!org.springframework.util.StringUtils.isEmpty((Object)userdetails.toString())) {
            userdetails.append(" ,");
        }
        if (userElement.isExchangeBkpEnabled()) {
            userdetails.append(" Exchange Backup Enabled ==> " + userElement.isExchangeBkpEnabled() + ", ");
            userdetails.append(" Exchange Backup Policy ==> " + userElement.getExchangePolicyName());
        }
        if (!org.springframework.util.StringUtils.isEmpty((Object)userdetails.toString())) {
            userdetails.append(" ,");
        }
        if (userElement.isSharePointBkpEnabled()) {
            userdetails.append(" Sharepoint Backup Enabled ==> " + userElement.isSharePointBkpEnabled() + ", ");
            userdetails.append(" Sharepoint Backup Policy ==> " + userElement.getSpPolicyName());
        }
    }

    private void changeDeviceStatusAndAduit(Cloud cloud, User user) {
        List<Device> blockedDevices = this.blockUnblockDevicebyUserName(cloud.getCloudId(), cloud.getCloudName(), user.getUserName(), true);
        if (blockedDevices != null) {
            for (Device device : blockedDevices) {
                this.saveStatisticToDatabase(cloud, "Blocked asset", "AUTO", device.getDeviceName(), "IdP Sync", System.currentTimeMillis(), PCActionTypes.ADD_USER_MIGRATION.getActionTypeValue());
            }
        }
    }

    private List<Device> blockUnblockDevicebyUserName(int cloudId, String cloudName, String userName, boolean toBlock) {
        List devices = new ArrayList();
        ArrayList<Device> blockedDevice = new ArrayList<Device>();
        devices = this.deviceDao.getDeviceByUserName(cloudId, userName);
        if (!CollectionUtils.isEmpty(devices)) {
            for (Device device : devices) {
                if (device.isBlocked()) continue;
                this.deviceDao.blockUnblockDevice(cloudId, cloudName, device, toBlock);
                this.deviceDao.updateDeviceStatusInOverview(cloudId, device.getDeviceUUID(), toBlock);
                if (toBlock) {
                    User user = this.userDao.getUserByName(cloudId, device.getUserName());
                    this.authorizationDao.deleteAuthTokenByUserAndUniqueID(cloudId, user, device.getDeviceUUID());
                }
                blockedDevice.add(device);
            }
        }
        return blockedDevice;
    }

    private void saveStatisticToDatabase(Cloud cloud, String action, String actionByUser, String actionOnUser, String actionUsingObject, long timeStamp, int actionType) {
        AuditHistory audit = new AuditHistory();
        audit.setAction(action);
        audit.setActionByUserName(actionByUser);
        audit.setActionOnObject(actionOnUser);
        audit.setTimestamp(timeStamp);
        audit.setActionUsingObject("Portal");
        audit.setActionType(actionType);
        this.auditHistoryDao.saveAudit(cloud.getCloudId(), cloud.getCloudName(), audit);
    }

    public void saveStatisticToDatabase(int cloudId, String cloudName, String action, String actionByUser, String actionOnUser, String actionUsingObject, long timeStamp, int actionType) {
        AuditHistory audit = new AuditHistory();
        audit.setAction(action);
        audit.setActionByUserName(actionByUser);
        audit.setActionOnObject(actionOnUser);
        audit.setTimestamp(timeStamp);
        audit.setActionUsingObject(actionUsingObject);
        audit.setActionType(actionType);
        this.userDao.saveAudit(cloudId, cloudName, audit);
    }

    private void setAuditForAADBlockedOrUnblocked(int cloudId, String cloudName, String userName, boolean isActive, boolean previStatus) {
        if (!isActive && previStatus) {
            this.saveStatisticToDatabase(cloudId, cloudName, "BLOCKED", "AUTO", userName, "IdP", System.currentTimeMillis(), PCActionTypes.AAD_USER_BLOCKED.getActionTypeValue());
        } else if (isActive && !previStatus) {
            this.saveStatisticToDatabase(cloudId, cloudName, "UNBLOCKED", "AUTO", userName, "IdP", System.currentTimeMillis(), PCActionTypes.AAD_USER_UNBLOCKED.getActionTypeValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getGroupFromIDGraph(int cloudId, String accessToken, String groupId, AADAuthorizationToken aadAuthToken) {
        StringBuilder response;
        block18: {
            response = new StringBuilder();
            CloseableHttpClient httpclient = null;
            HttpGet httpGet = null;
            CloseableHttpResponse result = null;
            try {
                Object routePlanner;
                String url = "https://graph.microsoft.com/v1.0/groups/" + groupId;
                Proxy proxy = this.settingsDao.getProxy(cloudId);
                if (proxy != null || !org.springframework.util.StringUtils.isEmpty((Object)this.registry.get(cloudId).getProxyHost()) && !org.springframework.util.StringUtils.isEmpty((Object)this.registry.get(cloudId).getProxyPort())) {
                    logger.debug("host :" + this.registry.get(cloudId).getProxyHost());
                    logger.debug("port :" + this.registry.get(cloudId).getProxyPort());
                    HttpHost proxyval = new HttpHost(this.registry.get(cloudId).getProxyHost(), this.registry.get(cloudId).getProxyPort(), "http");
                    routePlanner = new DefaultProxyRoutePlanner(proxyval);
                    httpclient = HttpClients.custom().setRoutePlanner((HttpRoutePlanner)routePlanner).build();
                } else {
                    httpclient = HttpClients.custom().build();
                }
                httpGet = new HttpGet(url);
                httpGet.addHeader("Authorization", "Bearer " + accessToken);
                httpGet.addHeader("Accept", "application/json");
                result = httpclient.execute((HttpUriRequest)httpGet);
                int httpResponseCode = result.getStatusLine().getStatusCode();
                logger.debug("....getGroupFromIDGraph httpResponseCode code ..." + httpResponseCode);
                if (httpResponseCode == 404) {
                    routePlanner = "";
                    return routePlanner;
                }
                if (httpResponseCode == 401) {
                    logger.debug("...inside update...");
                    aadAuthToken = this.getAccessTokenAndUpdateInDB(cloudId, aadAuthToken);
                    routePlanner = this.getGroupFromIDGraph(cloudId, aadAuthToken.getAccess_token(), groupId, aadAuthToken);
                    return routePlanner;
                }
                logger.debug(url + "....getGroupFromIDGraph Status code ..." + httpResponseCode);
                if (httpResponseCode != 200) break block18;
                InputStream inputStream = result.getEntity().getContent();
                try (BufferedReader in = new BufferedReader(new InputStreamReader(inputStream));){
                    String inputLine;
                    while ((inputLine = in.readLine()) != null) {
                        response.append(inputLine);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (httpGet != null) {
                    httpGet.releaseConnection();
                }
            }
        }
        logger.debug("....responsefrom getGroupFromIDGraph..." + response.toString());
        return response.toString();
    }

    private void getUserProductType(Cloud cloud, AADUserElement user, ObjectMapper mapper, IdentityProviderSettings aadCredentials, String accessToken) throws IOException, JsonParseException, JsonMappingException {
        boolean bkpEnabled = false;
        boolean syncEnabled = false;
        boolean exchangeEnabled = false;
        boolean oneDriveEnabled = false;
        boolean sharePointEnabled = false;
        boolean gmailBkpEnabled = false;
        boolean gdriveBkpEnabled = false;
        String searchString = "";
        String displayName = "displayName:";
        String OR = "";
        int cloudId = cloud.getCloudId();
        List licenseDetails = cloud.getCloudCustomisableDetails();
        if (!CollectionUtils.isEmpty((Collection)aadCredentials.getGroupMapping())) {
            if (!aadCredentials.isManyToManyMappingEnabled()) {
                if (!CollectionUtils.isEmpty((Collection)aadCredentials.getGroupMapping())) {
                    groupNames = new ArrayList<String>();
                    if (aadCredentials.getLoginMode().equalsIgnoreCase(MICROSOFT)) {
                        groupNames = this.getUserGroupNames(cloud, mapper, aadCredentials, accessToken, searchString, displayName, OR, groupNames);
                    } else if (aadCredentials.getLoginMode().equalsIgnoreCase(OKTA)) {
                        groupNames = this.getoktaGroupNamesfromUserId(cloudId, aadCredentials, user.getId());
                    }
                    logger.debug("...group name list...." + groupNames.size());
                    if (CollectionUtils.isEmpty(groupNames)) {
                        logger.error("....emptygroups...contact parablu....");
                        return;
                    }
                    for (GroupMapping mapping : aadCredentials.getGroupMapping()) {
                        groupName = mapping.getGroupName();
                        if (org.springframework.util.StringUtils.isEmpty((Object)groupName)) {
                            if (CPHelperConstant.PARABLU_PRODUCT_TYPE.BACKUP.getProductType().equalsIgnoreCase(mapping.getProductType())) {
                                bkpEnabled = true;
                                continue;
                            }
                            if (CPHelperConstant.PARABLU_PRODUCT_TYPE.SYNC.getProductType().equalsIgnoreCase(mapping.getProductType())) {
                                syncEnabled = true;
                                continue;
                            }
                            if (CPHelperConstant.PARABLU_PRODUCT_TYPE.ODB.getProductType().equalsIgnoreCase(mapping.getProductType())) {
                                oneDriveEnabled = true;
                                continue;
                            }
                            if (CPHelperConstant.PARABLU_PRODUCT_TYPE.EXCHANGE.getProductType().equalsIgnoreCase(mapping.getProductType())) {
                                exchangeEnabled = true;
                                continue;
                            }
                            if (CPHelperConstant.PARABLU_PRODUCT_TYPE.SHAREPOINT.getProductType().equalsIgnoreCase(mapping.getProductType())) {
                                sharePointEnabled = true;
                                continue;
                            }
                            bkpEnabled = true;
                            syncEnabled = true;
                            oneDriveEnabled = true;
                            exchangeEnabled = true;
                            sharePointEnabled = true;
                            gmailBkpEnabled = true;
                            gdriveBkpEnabled = true;
                            continue;
                        }
                        if (CollectionUtils.isEmpty(groupNames) || !groupNames.contains(groupName.toLowerCase())) continue;
                        if (CPHelperConstant.PARABLU_PRODUCT_TYPE.BACKUP.getProductType().equalsIgnoreCase(mapping.getProductType())) {
                            bkpEnabled = true;
                            user.setDefaultPolicy(this.registry.get(cloudId).getPropertyFileValueDefaultBkpPolicy());
                            continue;
                        }
                        if (CPHelperConstant.PARABLU_PRODUCT_TYPE.SYNC.getProductType().equalsIgnoreCase(mapping.getProductType())) {
                            syncEnabled = true;
                            user.setDefaultSyncPolicy(this.registry.get(cloudId).getPropertyFileValueDefaultSyncPolicy());
                            continue;
                        }
                        if (CPHelperConstant.PARABLU_PRODUCT_TYPE.ODB.getProductType().equalsIgnoreCase(mapping.getProductType())) {
                            oneDriveEnabled = true;
                            user.setDefaultOdbPolicy(this.registry.get(cloudId).getPropertyFileValueDefaultOdbPolicy());
                            continue;
                        }
                        if (CPHelperConstant.PARABLU_PRODUCT_TYPE.EXCHANGE.getProductType().equalsIgnoreCase(mapping.getProductType())) {
                            exchangeEnabled = true;
                            user.setDefaultExchangePolicy(this.registry.get(cloudId).getPropertyFileValueDefaultExchangePolicy());
                            continue;
                        }
                        if (CPHelperConstant.PARABLU_PRODUCT_TYPE.SHAREPOINT.getProductType().equalsIgnoreCase(mapping.getProductType())) {
                            sharePointEnabled = true;
                            user.setDefaultSharepointPolicy(this.registry.get(cloudId).getPropertyFileValueDefaultSpPolicy());
                            continue;
                        }
                        if (mapping.getProductType().equalsIgnoreCase(CPHelperConstant.PARABLU_PRODUCT_TYPE.GMAIL.getProductType())) {
                            user.setGmailBkpEnabled(true);
                            gmailBkpEnabled = true;
                            user.setDefaultGmailPolicy(this.registry.get(cloudId).getDefaultGmailPolicy());
                            continue;
                        }
                        if (mapping.getProductType().equalsIgnoreCase(CPHelperConstant.PARABLU_PRODUCT_TYPE.GOOGLEDRIVE.getProductType())) {
                            user.setGdriveBkpEnabled(true);
                            gdriveBkpEnabled = true;
                            user.setDefaultGdrivePolicy(this.registry.get(cloudId).getDefaultGdrivePolicyName());
                            continue;
                        }
                        bkpEnabled = true;
                        syncEnabled = true;
                        oneDriveEnabled = true;
                        exchangeEnabled = true;
                        sharePointEnabled = true;
                        gmailBkpEnabled = true;
                        gdriveBkpEnabled = true;
                    }
                }
            } else if (aadCredentials.isManyToManyMappingEnabled()) {
                if (!CollectionUtils.isEmpty((Collection)aadCredentials.getGroupMapping())) {
                    groupNames = new ArrayList();
                    if (aadCredentials.getLoginMode().equalsIgnoreCase(MICROSOFT)) {
                        groupNames = this.getUserGroupNames(cloud, mapper, aadCredentials, accessToken, searchString, displayName, OR, groupNames);
                    } else if (aadCredentials.getLoginMode().equalsIgnoreCase(OKTA)) {
                        groupNames = this.getoktaGroupNamesfromUserId(cloudId, aadCredentials, user.getId());
                    }
                    if (!CollectionUtils.isEmpty(groupNames)) {
                        for (GroupMapping GroupMapping2 : aadCredentials.getGroupMapping()) {
                            groupName = GroupMapping2.getGroupName();
                            if (CollectionUtils.isEmpty(groupNames) || !groupNames.contains(groupName.toLowerCase())) continue;
                            String productTypeAAd = GroupMapping2.getProductType();
                            logger.debug(groupName + ".....element groupconfig....");
                            logger.debug(this.registry.get(cloudId).getPropertyFileValueDefaultO365PolicyName() + "...od policyname...." + this.registry.get(cloudId).getPropertyFileValueDefaultOdbPolicy());
                            logger.debug("...product type ..." + productTypeAAd);
                            if (productTypeAAd.equalsIgnoreCase(CPHelperConstant.PARABLU_PRODUCT_TYPE.BACKUP.getProductType()) && this.isLiecnseEnabled(licenseDetails, BACK_UP_ENABLED)) {
                                bkpEnabled = true;
                                user.setDefaultPolicy(GroupMapping2.getPolicyName());
                                continue;
                            }
                            if (productTypeAAd.equalsIgnoreCase(CPHelperConstant.PARABLU_PRODUCT_TYPE.SYNC.getProductType()) && this.isLiecnseEnabled(licenseDetails, SYNC_ENABLED)) {
                                syncEnabled = true;
                                user.setDefaultSyncPolicy(GroupMapping2.getPolicyName());
                                continue;
                            }
                            if (productTypeAAd.equalsIgnoreCase(CPHelperConstant.PARABLU_PRODUCT_TYPE.ODB.getProductType()) && this.isLiecnseEnabled(licenseDetails, ODB_BACKUP_ENABLED)) {
                                oneDriveEnabled = true;
                                user.setDefaultOdbPolicy(GroupMapping2.getPolicyName());
                                continue;
                            }
                            if (productTypeAAd.equalsIgnoreCase(CPHelperConstant.PARABLU_PRODUCT_TYPE.SHAREPOINT.getProductType()) && this.isLiecnseEnabled(licenseDetails, SHARE_POINT_BACKUP_ENABLED)) {
                                sharePointEnabled = true;
                                user.setDefaultSharepointPolicy(GroupMapping2.getPolicyName());
                                continue;
                            }
                            if (productTypeAAd.equalsIgnoreCase(CPHelperConstant.PARABLU_PRODUCT_TYPE.EXCHANGE.getProductType()) && this.isLiecnseEnabled(licenseDetails, EXCHANGE_BACKUP_ENABLED)) {
                                exchangeEnabled = true;
                                user.setDefaultExchangePolicy(GroupMapping2.getPolicyName());
                                continue;
                            }
                            if (productTypeAAd.equalsIgnoreCase(CPHelperConstant.PARABLU_PRODUCT_TYPE.GMAIL.getProductType())) {
                                user.setGmailBkpEnabled(true);
                                gmailBkpEnabled = true;
                                user.setDefaultGmailPolicy(GroupMapping2.getPolicyName());
                                continue;
                            }
                            if (productTypeAAd.equalsIgnoreCase(CPHelperConstant.PARABLU_PRODUCT_TYPE.GOOGLEDRIVE.getProductType())) {
                                user.setGdriveBkpEnabled(true);
                                gdriveBkpEnabled = true;
                                user.setDefaultGdrivePolicy(GroupMapping2.getPolicyName());
                                continue;
                            }
                            logger.debug(".....check this logic.....");
                        }
                    }
                }
                logger.debug(bkpEnabled + ".." + syncEnabled + "..." + exchangeEnabled + ",...." + oneDriveEnabled + "..." + sharePointEnabled + ".......checkmemberof new policy...................." + gmailBkpEnabled + gdriveBkpEnabled);
                logger.debug("default policies in order" + user.getDefaultPolicy());
            }
        } else {
            for (CloudCustomisableDetails customisableDetails : cloud.getCloudCustomisableDetails()) {
                if (customisableDetails.getName().equalsIgnoreCase(SYNC_ENABLED)) {
                    syncEnabled = true;
                }
                if (customisableDetails.getName().equalsIgnoreCase(BACK_UP_ENABLED)) {
                    bkpEnabled = true;
                }
                if (ODB_BACKUP_ENABLED.equalsIgnoreCase(customisableDetails.getName())) {
                    oneDriveEnabled = true;
                }
                if (EXCHANGE_BACKUP_ENABLED.equalsIgnoreCase(customisableDetails.getName())) {
                    exchangeEnabled = true;
                }
                if (SHARE_POINT_BACKUP_ENABLED.equalsIgnoreCase(customisableDetails.getName())) {
                    sharePointEnabled = true;
                }
                if (GMAIL_BACKUP_ENABLED.equalsIgnoreCase(customisableDetails.getName())) {
                    gmailBkpEnabled = true;
                }
                if (!GDRIVE_BACKUP_ENABLED.equalsIgnoreCase(customisableDetails.getName())) continue;
                gdriveBkpEnabled = true;
            }
        }
        user.setPassword(accessToken);
        if (!aadCredentials.isManyToManyMappingEnabled() && !CollectionUtils.isEmpty((Collection)aadCredentials.getGroupMapping())) {
            for (GroupMapping mapping : aadCredentials.getGroupMapping()) {
                String groupName = mapping.getGroupName();
                if (!org.springframework.util.StringUtils.isEmpty((Object)groupName)) continue;
                if (mapping.getProductType().equalsIgnoreCase(CPHelperConstant.PARABLU_PRODUCT_TYPE.BACKUP.getProductType())) {
                    bkpEnabled = true;
                    continue;
                }
                if (mapping.getProductType().equalsIgnoreCase(CPHelperConstant.PARABLU_PRODUCT_TYPE.SYNC.getProductType())) {
                    syncEnabled = true;
                    continue;
                }
                if (mapping.getProductType().equalsIgnoreCase(CPHelperConstant.PARABLU_PRODUCT_TYPE.ODB.getProductType())) {
                    oneDriveEnabled = true;
                    continue;
                }
                if (mapping.getProductType().equalsIgnoreCase(CPHelperConstant.PARABLU_PRODUCT_TYPE.EXCHANGE.getProductType())) {
                    exchangeEnabled = true;
                    continue;
                }
                if (mapping.getProductType().equalsIgnoreCase(CPHelperConstant.PARABLU_PRODUCT_TYPE.GMAIL.getProductType())) {
                    gmailBkpEnabled = true;
                    continue;
                }
                if (mapping.getProductType().equalsIgnoreCase(CPHelperConstant.PARABLU_PRODUCT_TYPE.GOOGLEDRIVE.getProductType())) {
                    gdriveBkpEnabled = true;
                    continue;
                }
                bkpEnabled = true;
                syncEnabled = true;
                oneDriveEnabled = true;
                exchangeEnabled = true;
            }
        }
        user.setSyncEnabled(syncEnabled);
        user.setBackupEnabled(bkpEnabled);
        user.setOnedriveBkpEnabled(oneDriveEnabled);
        user.setExchangeBkpEnabled(exchangeEnabled);
        user.setSharePointBkpEnabled(sharePointEnabled);
        user.setGmailBkpEnabled(gmailBkpEnabled);
        user.setGdriveBkpEnabled(gdriveBkpEnabled);
        logger.debug("user..." + user.isOnedriveBkpEnabled());
        if (bkpEnabled && syncEnabled) {
            user.setProductType("BOTH");
        } else if (bkpEnabled) {
            user.setProductType("BACKUP");
        } else if (syncEnabled) {
            user.setProductType("SYNC");
        } else if (oneDriveEnabled) {
            user.setProductType("ODB");
        } else if (exchangeEnabled) {
            user.setProductType("MAIL");
        } else if (gmailBkpEnabled) {
            user.setProductType(CPHelperConstant.PARABLU_PRODUCT_TYPE.GMAIL.getProductType());
        } else if (gdriveBkpEnabled) {
            user.setProductType(CPHelperConstant.PARABLU_PRODUCT_TYPE.GOOGLEDRIVE.getProductType());
        }
    }

    private List<String> getUserGroupNames(Cloud cloud, ObjectMapper mapper, IdentityProviderSettings aadCredentials, String accessToken, String searchString, String displayName, String OR, List<String> groupNames) throws JsonProcessingException, JsonMappingException {
        for (GroupMapping mapping2 : aadCredentials.getGroupMapping()) {
            String groupName = mapping2.getGroupName();
            if (org.springframework.util.StringUtils.isEmpty((Object)groupName)) continue;
            searchString = (String)searchString + OR;
            searchString = (String)searchString + "%22" + displayName + groupName + "%22";
            OR = "%20OR%20";
        }
        logger.debug("searchString:" + (String)searchString);
        String userGroupInfo = this.getUserGroupsFromUserToken(cloud.getCloudId(), accessToken, (String)searchString);
        if (!org.springframework.util.StringUtils.isEmpty((Object)userGroupInfo)) {
            GraphResponseForMemberOf forMemberOf = (GraphResponseForMemberOf)mapper.readValue(userGroupInfo, GraphResponseForMemberOf.class);
            if (!CollectionUtils.isEmpty((Collection)aadCredentials.getGroupMapping().stream().filter(mapping -> !org.springframework.util.StringUtils.isEmpty((Object)mapping.getGroupName())).collect(Collectors.toList()))) {
                List groupInfo = forMemberOf.getGroupInfo();
                if (org.springframework.util.StringUtils.isEmpty((Object)((GraphGroupInfo)groupInfo.get(0)).getDisplayName())) {
                    HashSet<String> groupNamesSet = new HashSet<String>();
                    for (GraphGroupInfo group2 : groupInfo) {
                        GraphGroupInfo graphGroupInfo;
                        AADAuthorizationToken aadAuthorizationToken = this.getAADAuthorizationToken(1);
                        logger.debug(aadAuthorizationToken.getAccess_token() + "....check group name...." + group2.getId());
                        if (aadAuthorizationToken == null) continue;
                        String groupStr = this.getGroupFromIDGraph(cloud.getCloudId(), aadAuthorizationToken.getAccess_token(), group2.getId(), aadAuthorizationToken);
                        logger.debug("....empty check group name...." + groupStr);
                        if (org.springframework.util.StringUtils.isEmpty((Object)groupStr) || (graphGroupInfo = (GraphGroupInfo)mapper.readValue(groupStr, GraphGroupInfo.class)) == null || org.springframework.util.StringUtils.isEmpty((Object)graphGroupInfo.getDisplayName())) continue;
                        groupNamesSet.add(graphGroupInfo.getDisplayName().toLowerCase());
                        logger.debug("..EXISTINGGROUPS...." + graphGroupInfo.getDisplayName().toLowerCase());
                    }
                    groupNames.addAll(groupNamesSet);
                } else {
                    groupNames = groupInfo.stream().map(group -> group.getDisplayName().toLowerCase()).collect(Collectors.toList());
                }
            }
        }
        return groupNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public AADUserElement getAADUserByCode(String code, Cloud cloud, boolean callFromPortal, String redirectUrlFromHeader, String accessToken) {
        AADUserElement aADUserElement;
        CloseableHttpClient httpclient;
        HttpPost httppost;
        CloseableHttpResponse response;
        block51: {
            block52: {
                block49: {
                    block50: {
                        MSAppSetting msAppSetting;
                        AADUserElement aadUserElement = null;
                        response = null;
                        httppost = null;
                        httpclient = null;
                        int cloudId = cloud.getCloudId();
                        IdentityProviderSettings aadCredentials = this.aadDao.getAADCredentials(cloud.getCloudId());
                        if (aadCredentials == null && (msAppSetting = this.aadDao.getMSAppSettingsDetails(cloud.getCloudId())) != null) {
                            aadCredentials = new IdentityProviderSettings();
                            BeanUtils.copyProperties((Object)msAppSetting, (Object)aadCredentials);
                            aadCredentials.setTenentId(msAppSetting.getTenantId());
                            aadCredentials.setClientId(msAppSetting.getClientId());
                            aadCredentials.setSecretKey(msAppSetting.getClientSecretKey());
                            aadCredentials.setGroupMapping(new ArrayList());
                        }
                        ArrayList<String> tenants = new ArrayList<String>();
                        if (cloud.getMultiTenantAADEnabled() == 1) {
                            if (!CollectionUtils.isEmpty((Collection)aadCredentials.getTenants())) {
                                tenants.addAll(aadCredentials.getTenants());
                            } else {
                                tenants.add(aadCredentials.getTenentId());
                            }
                        } else {
                            tenants.add(aadCredentials.getTenentId());
                        }
                        if (aadCredentials == null || CollectionUtils.isEmpty(tenants)) {
                            logger.debug("AAD credentials is empty....");
                            return aadUserElement;
                        }
                        String grantType = AUTHORIZATION_CODE;
                        String applicationID = aadCredentials.getClientId();
                        String redirectURI = aadCredentials.getEndpointRedirectURI();
                        if (callFromPortal) {
                            redirectURI = org.springframework.util.StringUtils.isEmpty((Object)redirectUrlFromHeader) ? aadCredentials.getPortalRedirectURI() : redirectUrlFromHeader;
                        }
                        try {
                            int statusCode;
                            if (StringUtils.isNotEmpty((CharSequence)accessToken)) {
                                ObjectMapper mapper = new ObjectMapper();
                                mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
                                aadUserElement = this.getAADUserElementByAccessToken(aadCredentials, accessToken, mapper, cloud, (String)tenants.get(0));
                                return aadUserElement;
                            }
                            Iterator mapper = tenants.iterator();
                            do {
                                if (!mapper.hasNext()) return aadUserElement;
                                String tenantId = (String)mapper.next();
                                String loginUrl = LOGIN_URL + tenantId + OAUTH2_TOKEN_URL;
                                if (this.registry.get(cloudId).isCPasIDP()) {
                                    loginUrl = HTTPS + tenantId + "/api/v3/oauth/token";
                                    cpCredentials = this.aadDao.getCrashPlanIDPCredentials(cloud.getCloudId());
                                    aadUserElement = this.getAADUserByCodeForCrashPlan(code, cpCredentials);
                                    if (!org.springframework.util.StringUtils.isEmpty((Object)aadCredentials.getLoginMode()) && aadCredentials.getLoginMode().equalsIgnoreCase(MICROSOFT)) {
                                        aadUserElement = this.getAADUserFromUserName(cloud, aadUserElement.getUserName());
                                    } else {
                                        this.getAADUserElementWithLicenseDetails(cloud, aadUserElement);
                                    }
                                } else if (!org.springframework.util.StringUtils.isEmpty((Object)aadCredentials.getLoginMode()) && aadCredentials.getLoginMode().equalsIgnoreCase(OKTA)) {
                                    loginUrl = HTTPS + tenantId + "/oauth2/v1/token";
                                } else if (!org.springframework.util.StringUtils.isEmpty((Object)aadCredentials.getLoginMode()) && aadCredentials.getLoginMode().equalsIgnoreCase(ONE_LOGIN)) {
                                    loginUrl = HTTPS + tenantId + "/oidc/2/token";
                                } else if (!org.springframework.util.StringUtils.isEmpty((Object)aadCredentials.getLoginMode()) && aadCredentials.getLoginMode().equalsIgnoreCase("Crashplan")) {
                                    loginUrl = HTTPS + tenantId + "/api/v3/oauth/token";
                                    cpCredentials = this.aadDao.getCrashPlanIDPCredentials(cloud.getCloudId());
                                    aadUserElement = this.getAADUserByCodeForCrashPlan(code, cpCredentials);
                                    aadUserElement = this.getAADUserFromUserName(cloud, aadUserElement.getUserName());
                                } else if (StringUtils.isNotBlank((CharSequence)aadCredentials.getLoginMode()) && aadCredentials.getLoginMode().equalsIgnoreCase("google")) {
                                    boolean success = this.aadDao.getServiceAccountJson(cloudId, this.registry.get(cloudId).getPropertyFileValueParacloudMountPoint() + "Serviceaccount", "serviceaccount.json");
                                    if (!success) {
                                        logger.error("error getting the service account file..");
                                        aADUserElement = aadUserElement;
                                        if (httppost == null) break block49;
                                        break block50;
                                    }
                                    aADUserElement = this.getAADUserByCodeForGoogle(code, cloud);
                                    if (httppost == null) break block51;
                                    break block52;
                                }
                                if (this.registry.get(cloudId).isCPasIDP()) {
                                    logger.debug("Crasplan as IdP so return with the user details:{},{},{}" + aadUserElement.getUserPrincipalName() + aadUserElement.isBackupEnabled());
                                    AADUserElement success = aadUserElement;
                                    return success;
                                }
                                logger.debug("Login url:" + loginUrl + "\nredirect uri:" + redirectURI);
                                Proxy proxy = this.settingsDao.getProxy(cloud.getCloudId());
                                if (proxy != null || !org.springframework.util.StringUtils.isEmpty((Object)this.registry.get(cloudId).getProxyHost()) && !org.springframework.util.StringUtils.isEmpty((Object)this.registry.get(cloudId).getProxyPort())) {
                                    logger.debug("host :" + this.registry.get(cloudId).getProxyHost());
                                    logger.debug("port :" + this.registry.get(cloudId).getProxyPort());
                                    HttpHost proxyval = new HttpHost(this.registry.get(cloudId).getProxyHost(), this.registry.get(cloudId).getProxyPort(), "http");
                                    DefaultProxyRoutePlanner routePlanner = new DefaultProxyRoutePlanner(proxyval);
                                    httpclient = HttpClients.custom().setRoutePlanner((HttpRoutePlanner)routePlanner).build();
                                } else {
                                    httpclient = HttpClients.custom().build();
                                }
                                httppost = new HttpPost(loginUrl);
                                logger.debug("...loginUrl..." + loginUrl);
                                ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
                                params.add(new BasicNameValuePair("grant_type", grantType));
                                params.add(new BasicNameValuePair("client_id", applicationID));
                                params.add(new BasicNameValuePair("code", code));
                                params.add(new BasicNameValuePair("redirect_uri", redirectURI));
                                params.add(new BasicNameValuePair("client_secret", aadCredentials.getSecretKey()));
                                httppost.setEntity((HttpEntity)new UrlEncodedFormEntity(params, UTF_8));
                                httppost.setHeader(CONTENT_TYPE, "application/x-www-form-urlencoded");
                                response = httpclient.execute((HttpUriRequest)httppost);
                                HttpEntity entity = response.getEntity();
                                logger.debug("Status code " + response.getStatusLine().getStatusCode());
                                statusCode = response.getStatusLine().getStatusCode();
                                if (statusCode == 200) {
                                    if (entity == null) continue;
                                    instream = entity.getContent();
                                    try {
                                        JSONObject json = new JSONObject(IOUtils.toString((InputStream)instream, (String)UTF_8));
                                        accessToken = json.getString("access_token");
                                        ObjectMapper mapper2 = new ObjectMapper();
                                        mapper2.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
                                        logger.debug("accessToken......." + accessToken);
                                        aadUserElement = this.getAADUserElementByAccessToken(aadCredentials, accessToken, mapper2, cloud, tenantId);
                                    }
                                    finally {
                                        if (instream != null) {
                                            instream.close();
                                        }
                                    }
                                } else {
                                    instream = entity.getContent();
                                    try {
                                        logger.debug(IOUtils.toString((InputStream)instream, (String)UTF_8));
                                    }
                                    finally {
                                        if (instream != null) {
                                            instream.close();
                                        }
                                    }
                                }
                            } while (statusCode != 200);
                            return aadUserElement;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            logger.error(EXCEPTION, (Throwable)e);
                            logger.debug(EXCEPTION + e.getMessage());
                            return aadUserElement;
                        }
                    }
                    httppost.releaseConnection();
                }
                this.closeResponseEntity((HttpResponse)response);
                this.closeHttpClient(httpclient);
                return aADUserElement;
            }
            httppost.releaseConnection();
        }
        this.closeResponseEntity((HttpResponse)response);
        this.closeHttpClient(httpclient);
        return aADUserElement;
        finally {
            if (httppost != null) {
                httppost.releaseConnection();
            }
            this.closeResponseEntity((HttpResponse)response);
            this.closeHttpClient(httpclient);
        }
    }

    public void closeResponseEntity(HttpResponse response) {
        block6: {
            try {
                logger.debug("inside closing response entity.....");
                if (response == null || response.getEntity() == null || !response.getEntity().isStreaming()) break block6;
                try {
                    if (response.getEntity().getContent() != null) {
                        response.getEntity().getContent().close();
                        EntityUtils.consume((HttpEntity)response.getEntity());
                    }
                }
                catch (IOException e) {
                    logger.error(e.getMessage());
                    logger.trace(String.valueOf(e));
                }
                catch (Exception e) {
                    logger.error("Exception in closing response entity");
                    logger.trace(String.valueOf(e));
                }
            }
            catch (Exception e) {
                logger.error("Exception in closing response entity outside");
                logger.trace(String.valueOf(e));
            }
        }
    }

    private AADUserElement getAADUserElementByAccessToken(IdentityProviderSettings aadCredentials, String accessToken, ObjectMapper mapper, Cloud cloud, String tenantId) throws IOException, JsonParseException, JsonMappingException {
        AADUserElement aadUserElement;
        if (!org.springframework.util.StringUtils.isEmpty((Object)aadCredentials.getLoginMode()) && aadCredentials.getLoginMode().equalsIgnoreCase(OKTA) || !org.springframework.util.StringUtils.isEmpty((Object)aadCredentials.getLoginMode()) && aadCredentials.getLoginMode().equalsIgnoreCase(ONE_LOGIN)) {
            String userString = this.getUserInfoFromOkta(cloud.getCloudId(), accessToken, aadCredentials);
            OktaUserElement oktaUserElement = new OktaUserElement();
            oktaUserElement = (OktaUserElement)mapper.readValue(userString, OktaUserElement.class);
            aadUserElement = new AADUserElement();
            BeanUtils.copyProperties((Object)oktaUserElement, (Object)aadUserElement);
            aadUserElement.setUserPrincipalName(aadUserElement.getMail());
            aadUserElement.setPassword(accessToken);
            if (aadCredentials.getLoginMode().equalsIgnoreCase(OKTA)) {
                if (aadUserElement != null) {
                    this.getUserProductType(cloud, aadUserElement, mapper, aadCredentials, accessToken);
                }
            } else {
                aadUserElement.setProductType("BOTH");
                for (CloudCustomisableDetails customisableDetails : cloud.getCloudCustomisableDetails()) {
                    if (customisableDetails.getName().equalsIgnoreCase(SYNC_ENABLED)) {
                        aadUserElement.setSyncEnabled(true);
                    }
                    if (customisableDetails.getName().equalsIgnoreCase(BACK_UP_ENABLED)) {
                        aadUserElement.setBackupEnabled(true);
                    }
                    if (ODB_BACKUP_ENABLED.equalsIgnoreCase(customisableDetails.getName())) {
                        aadUserElement.setOnedriveBkpEnabled(true);
                    }
                    if (EXCHANGE_BACKUP_ENABLED.equalsIgnoreCase(customisableDetails.getName())) {
                        aadUserElement.setExchangeBkpEnabled(true);
                    }
                    if (SHARE_POINT_BACKUP_ENABLED.equalsIgnoreCase(customisableDetails.getName())) {
                        aadUserElement.setSharePointBkpEnabled(true);
                    }
                    if (GMAIL_BACKUP_ENABLED.equalsIgnoreCase(customisableDetails.getName())) {
                        aadUserElement.setGmailBkpEnabled(true);
                    }
                    if (!GDRIVE_BACKUP_ENABLED.equalsIgnoreCase(customisableDetails.getName())) continue;
                    aadUserElement.setGdriveBkpEnabled(true);
                }
                aadUserElement.setBackupEnabled(true);
                aadUserElement.setSyncEnabled(true);
                aadUserElement.setOnedriveBkpEnabled(true);
                aadUserElement.setExchangeBkpEnabled(true);
                aadUserElement.setGmailBkpEnabled(true);
                aadUserElement.setGdriveBkpEnabled(true);
                aadUserElement.setPassword(accessToken);
                logger.debug(".......user mail id from okta/onelogin..." + aadUserElement.getMail());
            }
        } else {
            String userString = this.getUserInfoFromGraph(cloud.getCloudId(), accessToken);
            aadUserElement = (AADUserElement)mapper.readValue(userString, AADUserElement.class);
            if (aadUserElement != null) {
                if (cloud.getGraphAADEnabled() == 0) {
                    this.getUserProductType(cloud, aadUserElement, mapper, aadCredentials, accessToken);
                } else {
                    this.getNewAADUserProductType(cloud.getCloudId(), aadUserElement, aadCredentials);
                }
                aadUserElement.setPassword(accessToken);
            } else {
                logger.debug("AAD element is empty");
            }
        }
        return aadUserElement;
    }

    public AADUserElement getNewAADUserProductType(int cloudId, AADUserElement aadUser, IdentityProviderSettings aadCredentials) {
        logger.debug("...........User " + aadUser.getUserName() + " .........found in AAD");
        String productType = "";
        logger.debug(aadUser.getUserPrincipalName() + ".................." + aadCredentials.toString());
        if (!CollectionUtils.isEmpty((Collection)aadCredentials.getGroupMapping())) {
            boolean bkpEnabled = false;
            boolean syncEnabled = false;
            boolean exchangeEnabled = false;
            boolean oneDriveEnabled = false;
            boolean sharePointEnabled = false;
            if (!CollectionUtils.isEmpty((Collection)aadCredentials.getGroupMapping().stream().filter(mapping -> !org.springframework.util.StringUtils.isEmpty((Object)mapping.getGroupName())).collect(Collectors.toList()))) {
                List<String> userMemberOf = this.getNewAADUserMemberInfo(cloudId, aadUser.getId(), aadCredentials);
                if (!CollectionUtils.isEmpty(userMemberOf)) {
                    for (String group : userMemberOf) {
                        logger.debug("User is memeber of ............" + group.toLowerCase());
                        for (GroupMapping mapping2 : aadCredentials.getGroupMapping()) {
                            if (!group.equalsIgnoreCase(mapping2.getGroupName())) continue;
                            String trype = mapping2.getProductType();
                            if (CPHelperConstant.PARABLU_PRODUCT_TYPE.BACKUP.getProductType().equalsIgnoreCase(trype)) {
                                bkpEnabled = true;
                                aadUser.setBackupEnabled(true);
                                continue;
                            }
                            if (trype.equalsIgnoreCase(CPHelperConstant.PARABLU_PRODUCT_TYPE.SYNC.getProductType())) {
                                syncEnabled = true;
                                aadUser.setSyncEnabled(true);
                                continue;
                            }
                            if (trype.equalsIgnoreCase(CPHelperConstant.PARABLU_PRODUCT_TYPE.ODB.getProductType())) {
                                oneDriveEnabled = true;
                                aadUser.setOnedriveBkpEnabled(true);
                                continue;
                            }
                            if (trype.equalsIgnoreCase(CPHelperConstant.PARABLU_PRODUCT_TYPE.EXCHANGE.getProductType())) {
                                exchangeEnabled = true;
                                aadUser.setExchangeBkpEnabled(true);
                                continue;
                            }
                            if (trype.equalsIgnoreCase(CPHelperConstant.PARABLU_PRODUCT_TYPE.SHAREPOINT.getProductType())) {
                                sharePointEnabled = true;
                                aadUser.setSharePointBkpEnabled(true);
                                continue;
                            }
                            bkpEnabled = true;
                            syncEnabled = true;
                            oneDriveEnabled = true;
                            sharePointEnabled = true;
                            aadUser.setBackupEnabled(true);
                            aadUser.setSyncEnabled(true);
                            aadUser.setExchangeBkpEnabled(true);
                            aadUser.setOnedriveBkpEnabled(true);
                            aadUser.setSharePointBkpEnabled(true);
                        }
                    }
                }
            } else if (!aadCredentials.getGroupMapping().isEmpty()) {
                productType = ((GroupMapping)aadCredentials.getGroupMapping().get(0)).getProductType();
            }
            for (GroupMapping mapping3 : aadCredentials.getGroupMapping()) {
                if (!"".equals(mapping3.getGroupName())) continue;
                if (CPHelperConstant.PARABLU_PRODUCT_TYPE.BACKUP.getProductType().equalsIgnoreCase(mapping3.getProductType())) {
                    bkpEnabled = true;
                    continue;
                }
                if (mapping3.getProductType().equalsIgnoreCase(CPHelperConstant.PARABLU_PRODUCT_TYPE.SYNC.getProductType())) {
                    syncEnabled = true;
                    continue;
                }
                if (mapping3.getProductType().equalsIgnoreCase(CPHelperConstant.PARABLU_PRODUCT_TYPE.ODB.getProductType())) {
                    oneDriveEnabled = true;
                    continue;
                }
                if (mapping3.getProductType().equalsIgnoreCase(CPHelperConstant.PARABLU_PRODUCT_TYPE.EXCHANGE.getProductType())) {
                    exchangeEnabled = true;
                    continue;
                }
                bkpEnabled = true;
                syncEnabled = true;
                oneDriveEnabled = true;
                exchangeEnabled = true;
            }
            if (bkpEnabled && syncEnabled && oneDriveEnabled && exchangeEnabled) {
                productType = "BOTH";
            } else if (bkpEnabled) {
                productType = "BACKUP";
            } else if (syncEnabled) {
                productType = "SYNC";
            } else if (oneDriveEnabled) {
                productType = "ODB";
            } else if (exchangeEnabled) {
                productType = "MAIL";
            }
            aadUser.setBackupEnabled(bkpEnabled);
            aadUser.setSyncEnabled(syncEnabled);
            aadUser.setOnedriveBkpEnabled(oneDriveEnabled);
            aadUser.setExchangeBkpEnabled(exchangeEnabled);
            aadUser.setSharePointBkpEnabled(sharePointEnabled);
            aadUser.setProductType(productType);
            if (org.springframework.util.StringUtils.isEmpty((Object)productType)) {
                logger.debug("..user not part of any product...." + aadUser.getUserName());
                return null;
            }
            if (!org.springframework.util.StringUtils.isEmpty((Object)productType)) {
                return aadUser;
            }
        }
        if (aadUser != null) {
            logger.debug(aadUser.getProductType() + "...prod ..AAD User Element ...." + aadUser.toString());
        }
        return aadUser;
    }

    private List<String> getNewAADUserMemberInfo(int cloudId, String userName, IdentityProviderSettings aadCredentials) {
        ArrayList<String> tenants = new ArrayList<String>();
        if (!CollectionUtils.isEmpty((Collection)aadCredentials.getTenants())) {
            tenants.addAll(aadCredentials.getTenants());
        } else {
            tenants.add(aadCredentials.getTenentId());
        }
        String clientId = aadCredentials.getClientId();
        String secret = aadCredentials.getSecretKey();
        ArrayList<String> userMemeberOf = new ArrayList<String>();
        for (String tenantId : tenants) {
            Set groupsInDB = aadCredentials.getGroupMapping().stream().map(GroupMapping::getGroupName).filter(group -> !org.springframework.util.StringUtils.isEmpty((Object)group)).collect(Collectors.toSet());
            if (CollectionUtils.isEmpty(groupsInDB)) {
                logger.debug("Group name is empty so retun..");
                return new ArrayList<String>();
            }
            groupsInDB = groupsInDB.stream().map(String::toLowerCase).collect(Collectors.toSet());
            for (String groupName : groupsInDB) {
                logger.debug("..group nnmae.. " + groupName);
                String groupId = this.getNewGroupId(1, groupName, aadCredentials.getClientId(), aadCredentials.getSecretKey(), tenantId);
                logger.debug("..group nnmae1.. " + groupName + "..groupId.." + groupId);
                List<String> groupMembersInfo = this.getNewGroupMembersInfo(cloudId, groupId, clientId, secret, tenantId);
                if (CollectionUtils.isEmpty(groupMembersInfo) || !groupMembersInfo.contains(userName)) continue;
                userMemeberOf.add(groupName);
            }
        }
        logger.debug(userName + "...user-groups...." + userMemeberOf.size());
        return userMemeberOf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getUserInfoFromOkta(int cloudId, String accessToken, IdentityProviderSettings aadCredentials) {
        StringBuilder response;
        block18: {
            CloseableHttpResponse result;
            CloseableHttpClient httpclient;
            block17: {
                response = new StringBuilder();
                httpclient = null;
                HttpGet httpGet = null;
                result = null;
                String userInfo = OKTA_USER_INFO;
                String loginUrl = OKTA_LOGIN_URL;
                try {
                    if (aadCredentials.getLoginMode().equalsIgnoreCase(ONE_LOGIN)) {
                        userInfo = ONE_LOGIN_USER_INFO;
                        loginUrl = ONE_LOGIN_URL;
                    }
                    String url = HTTPS + aadCredentials.getTenentId() + loginUrl + userInfo;
                    logger.debug("url to get user from access token:" + url);
                    Proxy proxy = this.settingsDao.getProxy(cloudId);
                    if (proxy != null || !org.springframework.util.StringUtils.isEmpty((Object)this.registry.get(cloudId).getProxyHost()) && !org.springframework.util.StringUtils.isEmpty((Object)this.registry.get(cloudId).getProxyPort())) {
                        logger.debug("host :" + this.registry.get(cloudId).getProxyHost());
                        logger.debug("port :" + this.registry.get(cloudId).getProxyPort());
                        HttpHost proxyval = new HttpHost(this.registry.get(cloudId).getProxyHost(), this.registry.get(cloudId).getProxyPort(), "http");
                        DefaultProxyRoutePlanner routePlanner = new DefaultProxyRoutePlanner(proxyval);
                        httpclient = HttpClients.custom().setRoutePlanner((HttpRoutePlanner)routePlanner).build();
                    } else {
                        httpclient = HttpClients.custom().build();
                    }
                    httpGet = new HttpGet(url);
                    httpGet.addHeader("Authorization", "Bearer " + accessToken);
                    httpGet.addHeader("Accept", "application/json");
                    result = httpclient.execute((HttpUriRequest)httpGet);
                    int httpResponseCode = result.getStatusLine().getStatusCode();
                    logger.debug("Status code ..." + httpResponseCode);
                    if (httpResponseCode == 200) {
                        InputStream inputStream = result.getEntity().getContent();
                        try (BufferedReader in = new BufferedReader(new InputStreamReader(inputStream));){
                            String inputLine;
                            while ((inputLine = in.readLine()) != null) {
                                response.append(inputLine);
                            }
                        }
                    }
                    if (httpGet == null) break block17;
                }
                catch (Exception e) {
                    logger.error(EXCEPTION + String.valueOf(e));
                    logger.debug(EXCEPTION + e.getMessage());
                    break block18;
                }
                finally {
                    if (httpGet != null) {
                        httpGet.releaseConnection();
                    }
                    this.closeResponse(result);
                    this.closeHttpClient(httpclient);
                }
                httpGet.releaseConnection();
            }
            this.closeResponse(result);
            this.closeHttpClient(httpclient);
        }
        return response.toString();
    }

    private java.net.Proxy getProxy(int cloudId) {
        int port;
        String host;
        Proxy proxy = this.settingsDao.getProxy(cloudId);
        if (proxy != null) {
            String userNameVal = proxy.getUserName();
            String passwordVal = proxy.getPassword();
            host = proxy.getHost();
            port = Integer.parseInt(proxy.getPort());
        } else {
            String userNameVal = this.registry.get(cloudId).getProxyUserName();
            String passwordVal = this.registry.get(cloudId).getProxyPassword();
            host = this.registry.get(cloudId).getProxyHost();
            port = this.registry.get(cloudId).getProxyPort();
        }
        if (org.springframework.util.StringUtils.isEmpty((Object)host) || port <= 0) {
            return null;
        }
        return new java.net.Proxy(Proxy.Type.HTTP, new InetSocketAddress(host, port));
    }

    public SettingsDao getSettingsDao() {
        return this.settingsDao;
    }

    public void setSettingsDao(SettingsDao settingsDao) {
        this.settingsDao = settingsDao;
    }

    private String getGoogleSecurityKey() {
        SecureRandom random = new SecureRandom();
        byte[] bytes = new byte[20];
        random.nextBytes(bytes);
        Base32 base32 = new Base32();
        String googleSecretKey = base32.encodeToString(bytes);
        return googleSecretKey;
    }

    private String getUserInfoUrl(String userName) {
        if (userName.contains("#")) {
            userName = userName.replace("#", "%23");
        }
        String url = userName.startsWith("$") ? "https://graph.microsoft.com/beta//users('" + userName + "')" : "https://graph.microsoft.com/beta//users/" + userName;
        return url;
    }

    @Override
    public List<IdentityProviderSettingsElement> getAllAADCredentials(int cloudId) {
        ArrayList<IdentityProviderSettingsElement> aadCredentialsElementList = new ArrayList<IdentityProviderSettingsElement>();
        List aadCredentialsList = this.aadDao.getAllAADCredentials(cloudId);
        for (IdentityProviderSettings aadCredentials : aadCredentialsList) {
            if (aadCredentials == null) continue;
            IdentityProviderSettingsElement aadCredentialsElement = new IdentityProviderSettingsElement();
            BeanUtils.copyProperties((Object)aadCredentials, (Object)aadCredentialsElement);
            ArrayList<GroupMapping> GroupMappingList = new ArrayList<GroupMapping>();
            for (GroupMapping GroupMappingElement : aadCredentials.getGroupMapping()) {
                GroupMapping GroupMapping2 = new GroupMapping();
                GroupMapping2.setId(this.generateKey(GroupMappingElement));
                GroupMapping2.setProductType(GroupMappingElement.getProductType());
                GroupMapping2.setPolicyName(GroupMappingElement.getPolicyName());
                GroupMapping2.setGroupName(GroupMappingElement.getGroupName());
                GroupMappingList.add(GroupMapping2);
            }
            aadCredentialsElement.setId(aadCredentials.getId().toString());
            aadCredentialsElement.setGroupMapping(GroupMappingList);
            AADAuthorizationToken token = this.aadDao.getAADAuthorizationtoken(cloudId);
            if (token == null) {
                if (aadCredentials.getLoginMode().equalsIgnoreCase(MICROSOFT)) {
                    aadCredentialsElement.setAuthRequired(true);
                }
            } else if (!org.springframework.util.StringUtils.isEmpty((Object)token.getUser_principal())) {
                aadCredentialsElement.setUser_principal(token.getUser_principal());
            }
            aadCredentialsElementList.add(aadCredentialsElement);
        }
        return aadCredentialsElementList;
    }

    @Override
    public IdentityProviderSettingsElement getAADCredentials(int cloudId, String aadCredId) {
        IdentityProviderSettings aadCredentials = this.aadDao.getAADCredentials(cloudId, aadCredId);
        IdentityProviderSettingsElement aadCredentialsElement = null;
        if (aadCredentials != null) {
            aadCredentialsElement = new IdentityProviderSettingsElement();
            BeanUtils.copyProperties((Object)aadCredentials, (Object)aadCredentialsElement);
            aadCredentialsElement.setId(aadCredentials.getId().toString());
            AADAuthorizationToken token = this.aadDao.getAADAuthorizationtoken(cloudId);
            if (token == null) {
                aadCredentialsElement.setAuthRequired(true);
            } else if (!org.springframework.util.StringUtils.isEmpty((Object)token.getUser_principal())) {
                aadCredentialsElement.setUser_principal(token.getUser_principal());
            }
            for (GroupMapping groupMapping : aadCredentials.getGroupMapping()) {
            }
        }
        return aadCredentialsElement;
    }

    @Override
    public void deleteAADCredentials(int cloudId, String aadCredId) {
        this.aadDao.deleteAADCredentials(cloudId, aadCredId);
    }

    @Override
    public void syncNewUserAttributes(Cloud cloud) {
        int cloudId = cloud.getCloudId();
        CloudProperties cloudProperties = this.cloudDao.getCloudProperties(cloudId);
        IdentityProviderSettings aadCredentials = this.aadDao.getAADCredentials(cloudId);
        ArrayList<String> tenants = new ArrayList<String>();
        logger.debug("..before getting tenants...");
        if (aadCredentials != null) {
            if (cloud.getMultiTenantAADEnabled() == 1) {
                if (!CollectionUtils.isEmpty((Collection)aadCredentials.getTenants())) {
                    tenants.addAll(aadCredentials.getTenants());
                } else {
                    tenants.add(aadCredentials.getTenentId());
                }
            } else {
                tenants.add(aadCredentials.getTenentId());
            }
        }
        logger.debug("..after getting tenants..." + tenants.size());
        if (aadCredentials != null) {
            ArrayList<AADUserElement> aadUserElements = new ArrayList<AADUserElement>();
            for (String tenantId : tenants) {
                logger.debug("..processing tenantId..." + tenantId);
                List<AADUserElement> aadUserElementsList = this.syncAADNewGroupChanges(cloud, aadCredentials, tenantId);
                aadUserElements.addAll(aadUserElementsList);
            }
            if (CollectionUtils.isEmpty(aadUserElements)) {
                logger.debug("....no users to sync check the group....");
                return;
            }
            Set groupsInDB = aadCredentials.getGroupMapping().stream().map(GroupMapping::getGroupName).filter(group -> !org.springframework.util.StringUtils.isEmpty((Object)group)).collect(Collectors.toSet());
            if (aadCredentials.isManyToManyMappingEnabled()) {
                groupsInDB = new HashSet();
                List GroupMappingList = aadCredentials.getGroupMapping();
                if (!CollectionUtils.isEmpty((Collection)GroupMappingList)) {
                    groupsInDB = GroupMappingList.stream().map(aadPolicy -> aadPolicy.getGroupName()).collect(Collectors.toSet());
                }
            }
            if (CollectionUtils.isEmpty(groupsInDB)) {
                logger.debug("Group name is empty after collection so retun..");
                return;
            }
            ArrayList<AADUserElement> result = new ArrayList<AADUserElement>();
            HashSet<String> titles = new HashSet<String>();
            for (AADUserElement item : aadUserElements) {
                if (!titles.add(item.getUserPrincipalName())) continue;
                result.add(item);
            }
            logger.debug(aadUserElements.size() + "...overall list before and after.." + result.size());
            aadUserElements = result;
            Map<String, AADUserElement> aadMap = aadUserElements.stream().collect(Collectors.toMap(aaduser -> aaduser.getUserPrincipalName().toLowerCase(), aaduser -> aaduser));
            Map<Object, Object> aadMapWithEmail = new HashMap();
            try {
                aadMapWithEmail = aadUserElements.stream().filter(aaduser -> aaduser.getMail() != null).collect(Collectors.toMap(aaduser -> aaduser.getMail().toLowerCase(), aaduser -> aaduser));
                logger.debug("after convert to aadMapWithEmail..." + aadMapWithEmail.size());
            }
            catch (Exception e) {
                logger.error("error getting the mail add:", (Throwable)e);
            }
            List allUsers = this.userDao.getAllUsers(cloudId);
            ArrayList<User> guestUsers = new ArrayList<User>();
            HashMap<String, User> userMap = new HashMap<String, User>();
            for (User user : allUsers) {
                if (!user.isLocalUser() && !user.isGuest()) {
                    String userName = user.getUserName();
                    if (!org.springframework.util.StringUtils.isEmpty((Object)user.getAadLoginId())) {
                        userName = user.getAadLoginId();
                    }
                    userMap.put(userName.toLowerCase(), user);
                    continue;
                }
                if (!user.isGuest()) continue;
                guestUsers.add(user);
            }
            for (User user : guestUsers) {
                logger.debug("guest user..." + user.getUserName());
                logger.debug("guest user.mail.." + user.getEmailId());
                if (aadMap.containsKey(user.getUserName().toLowerCase()) || aadMap.containsKey(user.getUserName())) {
                    logger.debug("removeUserbyID.........." + String.valueOf(user.getUserId()));
                    this.userDao.removeUserbyID(cloudId, user.getUserId().toString());
                    continue;
                }
                if (!aadMapWithEmail.containsKey(user.getUserName().toLowerCase()) && !aadMapWithEmail.containsKey(user.getUserName())) continue;
                logger.debug("removeUserbyID.........." + String.valueOf(user.getUserId()));
                this.userDao.removeUserbyID(cloudId, user.getUserId().toString());
            }
            logger.debug(aadMap.size() + ".....map diff ..." + userMap.size());
            for (Map.Entry entry : userMap.entrySet()) {
                User existingUser = (User)entry.getValue();
                if (aadMap.containsKey(entry.getKey())) {
                    AADUserElement aadUserElement = aadMap.get(entry.getKey());
                    logger.debug("...already in user iteration...");
                    boolean anyChange = false;
                    if (!anyChange && aadUserElement.isBackupEnabled() != existingUser.isBackupEnabled()) {
                        anyChange = true;
                    }
                    if (!anyChange && aadUserElement.isSyncEnabled() != existingUser.isSyncEnabled()) {
                        anyChange = true;
                    }
                    if (!anyChange && aadUserElement.isOnedriveBkpEnabled() != existingUser.isOnedriveBkpEnabled()) {
                        anyChange = true;
                    }
                    if (!anyChange && aadUserElement.isExchangeBkpEnabled() != existingUser.isExchangeBkpEnabled()) {
                        anyChange = true;
                    }
                    if (existingUser.isSoftBlockEnabled()) {
                        anyChange = true;
                    }
                    if (anyChange) {
                        long totalExchangekpUsers;
                        int noOfExchangeUsersAllowed;
                        long totalBkpUsers;
                        int noOfBkpUsersAllowed;
                        long totalSyncUsers;
                        int noOfSyncUsersAllowed;
                        logger.debug("...inside anyChange...........");
                        if (aadUserElement.isSyncEnabled() && (long)(noOfSyncUsersAllowed = cloud.getNoOfSyncUsersAllowed()) <= (totalSyncUsers = this.userDao.countOfPresentSyncUsers(cloud.getCloudId(), cloud.getCloudName(), true))) {
                            logger.debug(" SYNC USER LIMIT REACHED........");
                            aadUserElement.setSyncEnabled(false);
                        }
                        if (aadUserElement.isBackupEnabled() && (long)(noOfBkpUsersAllowed = cloud.getNoOfBackupUsersAllowed()) <= (totalBkpUsers = this.userDao.countOfPresentBackupUsers(cloud.getCloudId(), cloud.getCloudName(), true, true))) {
                            logger.debug(" BACKUP USER LIMIT REACHED........");
                            aadUserElement.setBackupEnabled(false);
                        }
                        if (aadUserElement.isOnedriveBkpEnabled() && this.isLiecnseEnabled(cloud.getCloudCustomisableDetails(), ODB_BACKUP_ENABLED)) {
                            long totalOdbBkpUsers;
                            int noOfOneDriveUsersAllowed = cloud.getNoOfOneDriveUsersAllowed();
                            if ((long)noOfOneDriveUsersAllowed <= (totalOdbBkpUsers = this.userDao.countOfPresentOnedriveUsers(cloud.getCloudId(), true))) {
                                logger.debug("onedrive  USER LIMIT REACHED........");
                                aadUserElement.setOnedriveBkpEnabled(false);
                            }
                        } else if (aadUserElement.isExchangeBkpEnabled() && this.isLiecnseEnabled(cloud.getCloudCustomisableDetails(), EXCHANGE_BACKUP_ENABLED) && (long)(noOfExchangeUsersAllowed = cloud.getNoOfExchangeUsersAllowed()) <= (totalExchangekpUsers = this.userDao.countOfPresentExchangeUsers(cloud.getCloudId(), true))) {
                            logger.debug("exchange USER LIMIT REACHED........");
                            aadUserElement.setExchangeBkpEnabled(false);
                        }
                        if (!(aadUserElement.isBackupEnabled() || aadUserElement.isSyncEnabled() || aadUserElement.isOnedriveBkpEnabled() || aadUserElement.isExchangeBkpEnabled() || existingUser.isSoftBlockEnabled())) {
                            logger.error(existingUser.getUserName() + "...user limit reached ...." + existingUser.isSoftBlockEnabled());
                            continue;
                        }
                        boolean previStatus = existingUser.isActive();
                        existingUser.setBackupEnabled(aadUserElement.isBackupEnabled());
                        existingUser.setSyncEnabled(aadUserElement.isSyncEnabled());
                        existingUser.setOnedriveBkpEnabled(aadUserElement.isOnedriveBkpEnabled());
                        existingUser.setExchangeBkpEnabled(aadUserElement.isExchangeBkpEnabled());
                        existingUser.setLocation(aadUserElement.getOfficeLocation());
                        existingUser.setDepartment(aadUserElement.getDepartment());
                        existingUser.setSoftBlockEnabled(false);
                        existingUser.setActive(true);
                        this.userDao.saveUser(cloud.getCloudId(), cloud.getCloudName(), existingUser);
                        this.deviceDao.updateUserStatusInDeviceBkpOverview(cloudId, existingUser.getUserName(), Boolean.valueOf(existingUser.isActive()));
                        this.blockDevice(existingUser, cloud.getCloudName(), cloudId);
                        this.setAuditForAADBlockedOrUnblocked(cloud.getCloudId(), cloud.getCloudName(), existingUser.getUserName(), existingUser.isActive(), previStatus);
                        continue;
                    }
                    existingUser = this.userDao.getUserByUserNameOrAADLoginId(cloudId, (String)entry.getKey());
                    if (existingUser == null) continue;
                    logger.debug("..updating user location and department...");
                    existingUser.setLocation(aadUserElement.getOfficeLocation());
                    existingUser.setDepartment(aadUserElement.getDepartment());
                    this.userDao.saveUser(cloud.getCloudId(), cloud.getCloudName(), existingUser);
                    continue;
                }
                logger.debug("...inside blocking existing user" + (String)entry.getKey());
                if (cloudProperties != null && cloudProperties.isSoftBlockEnabled()) {
                    if (existingUser.isSoftBlockEnabled()) continue;
                    existingUser.setSoftBlockEnabled(true);
                    existingUser.setSoftBlockedTime(System.currentTimeMillis());
                    this.userDao.saveUser(cloud.getCloudId(), cloud.getCloudName(), existingUser);
                    continue;
                }
                boolean previStatus = existingUser.isActive();
                existingUser.setBackupEnabled(false);
                existingUser.setSyncEnabled(false);
                existingUser.setOnedriveBkpEnabled(false);
                existingUser.setActive(false);
                this.userDao.saveUser(cloud.getCloudId(), cloud.getCloudName(), existingUser);
                this.deviceDao.updateUserInfoInDeviceBkpOverview(cloud.getCloudId(), existingUser);
                this.setAuditForAADBlockedOrUnblocked(cloud.getCloudId(), cloud.getCloudName(), existingUser.getUserName(), existingUser.isActive(), previStatus);
                this.changeDeviceStatusAndAduit(cloud, existingUser);
            }
            for (Map.Entry entry : aadMap.entrySet()) {
                if (userMap.containsKey(entry.getKey())) continue;
                logger.debug("...adding new user to user collection..." + (String)entry.getKey());
                AADUserElement aadUserElement = aadMap.get(entry.getKey());
                this.updateOrCreateAADUserInfo(cloud, aadUserElement, aadCredentials);
            }
        } else {
            logger.debug("Either aadCredentials or authToken or accessToken is Empty so no Sync");
        }
    }

    private List<AADUserElement> syncAADNewGroupChanges(Cloud cloud, IdentityProviderSettings aadCredentials, String tenantId) {
        ArrayList<AADUserElement> aadUserElements = new ArrayList<AADUserElement>();
        HashMap<String, AADUserElement> aadMap = new HashMap<String, AADUserElement>();
        try {
            Set groupsInDB = aadCredentials.getGroupMapping().stream().map(GroupMapping::getGroupName).filter(group -> !org.springframework.util.StringUtils.isEmpty((Object)group)).collect(Collectors.toSet());
            if (CollectionUtils.isEmpty(groupsInDB)) {
                logger.debug("Group name is empty so retun..");
                return aadUserElements;
            }
            groupsInDB = groupsInDB.stream().map(String::toLowerCase).collect(Collectors.toSet());
            ArrayList<String> userGroupMembers = new ArrayList<String>();
            for (String groupName : groupsInDB) {
                logger.debug("..group nnmae.. " + groupName);
                String groupId = this.getNewGroupId(cloud.getCloudId(), groupName, aadCredentials.getClientId(), aadCredentials.getSecretKey(), tenantId);
                logger.debug("..group nnmae1.. " + groupName + "..groupId.." + groupId);
                List<String> groupMembersInfo = this.getNewGroupMembersInfo(cloud.getCloudId(), groupId, aadCredentials.getClientId(), aadCredentials.getSecretKey(), tenantId);
                userGroupMembers.addAll(groupMembersInfo);
            }
            logger.debug("...usermemberslist..." + userGroupMembers.size());
            for (String memberId : userGroupMembers) {
                logger.debug("Inside.....member..." + memberId);
                if (aadMap.get(memberId.toLowerCase()) == null) {
                    AADUserElement aadUser = this.getNewAADUserFromUserNameToSync(cloud.getCloudId(), memberId, aadCredentials.getClientId(), aadCredentials.getSecretKey(), tenantId);
                    if (aadUser == null) continue;
                    aadUserElements.add(aadUser);
                    aadMap.put(aadUser.getUserPrincipalName().toLowerCase(), aadUser);
                    continue;
                }
                logger.debug("user already present so leave...");
            }
        }
        catch (Exception e) {
            logger.error(" Exception  :...........", (Throwable)e);
            logger.debug(" Exception  :..........." + e.getMessage());
            aadUserElements = new ArrayList();
        }
        return aadUserElements;
    }

    public AADUserElement getNewAADUserFromUserNameToSync(int cloudId, String userName, String clientId, String secret, String tenantId) {
        AADUserElement aadUser = null;
        aadUser = this.getNewAADUserFromUserName(userName, clientId, secret, tenantId, cloudId);
        if (aadUser != null) {
            logger.debug(aadUser.getId() + "...........User . .........found in AAD.." + aadUser.getUserPrincipalName() + "....user..." + userName);
            String productType = "";
            IdentityProviderSettings aadCredentials = this.aadDao.getAADCredentials(cloudId);
            logger.debug(".................." + aadCredentials.toString());
            if (!CollectionUtils.isEmpty((Collection)aadCredentials.getGroupMapping())) {
                boolean bkpEnabled = false;
                boolean syncEnabled = false;
                boolean oneDriveEnabled = false;
                boolean exchangeEnabled = false;
                if (!CollectionUtils.isEmpty((Collection)aadCredentials.getGroupMapping().stream().filter(mapping -> !org.springframework.util.StringUtils.isEmpty((Object)mapping.getGroupName())).collect(Collectors.toList()))) {
                    List<String> userMemberOf = this.getNewAADUserGroupInfo(cloudId, userName, aadCredentials.getClientId(), aadCredentials.getSecretKey(), tenantId);
                    if (!CollectionUtils.isEmpty(userMemberOf)) {
                        for (String group : userMemberOf) {
                            for (GroupMapping mapping2 : aadCredentials.getGroupMapping()) {
                                String groupName = mapping2.getGroupName();
                                String type = mapping2.getProductType();
                                if (!StringUtils.isNotEmpty((CharSequence)type)) continue;
                                if (type.equalsIgnoreCase(CPHelperConstant.PARABLU_PRODUCT_TYPE.BACKUP.getProductType())) {
                                    bkpEnabled = true;
                                    aadUser.setDefaultPolicy(this.registry.get(cloudId).getPropertyFileValueDefaultBkpPolicy());
                                    continue;
                                }
                                if (type.equalsIgnoreCase(CPHelperConstant.PARABLU_PRODUCT_TYPE.SYNC.getProductType())) {
                                    syncEnabled = true;
                                    aadUser.setDefaultSyncPolicy(this.registry.get(cloudId).getPropertyFileValueDefaultSyncPolicy());
                                    continue;
                                }
                                if (type.equalsIgnoreCase(CPHelperConstant.PARABLU_PRODUCT_TYPE.ODB.getProductType())) {
                                    oneDriveEnabled = true;
                                    aadUser.setDefaultOdbPolicy(this.registry.get(cloudId).getPropertyFileValueDefaultOdbPolicy());
                                    continue;
                                }
                                if (type.equalsIgnoreCase(CPHelperConstant.PARABLU_PRODUCT_TYPE.EXCHANGE.getProductType())) {
                                    exchangeEnabled = true;
                                    aadUser.setDefaultExchangePolicy(this.registry.get(cloudId).getPropertyFileValueDefaultExchangePolicy());
                                    continue;
                                }
                                bkpEnabled = true;
                                syncEnabled = true;
                                exchangeEnabled = true;
                                oneDriveEnabled = true;
                                aadUser.setDefaultOdbPolicy(this.registry.get(cloudId).getPropertyFileValueDefaultOdbPolicy());
                                aadUser.setDefaultExchangePolicy(this.registry.get(cloudId).getPropertyFileValueDefaultExchangePolicy());
                                aadUser.setDefaultPolicy(this.registry.get(cloudId).getPropertyFileValueDefaultBkpPolicy());
                                aadUser.setDefaultSyncPolicy(this.registry.get(cloudId).getPropertyFileValueDefaultSyncPolicy());
                            }
                        }
                    }
                } else if (!aadCredentials.getGroupMapping().isEmpty()) {
                    productType = ((GroupMapping)aadCredentials.getGroupMapping().get(0)).getProductType();
                }
                aadUser.setBackupEnabled(bkpEnabled);
                aadUser.setSyncEnabled(syncEnabled);
                aadUser.setOnedriveBkpEnabled(oneDriveEnabled);
                aadUser.setExchangeBkpEnabled(exchangeEnabled);
                logger.debug(bkpEnabled + ".." + syncEnabled + "..." + oneDriveEnabled + ".......checkmemberof............................" + userName);
                for (GroupMapping mapping3 : aadCredentials.getGroupMapping()) {
                    String groupName = mapping3.getGroupName();
                    if (!org.springframework.util.StringUtils.isEmpty((Object)groupName)) continue;
                    if (mapping3.getProductType().equalsIgnoreCase(CPHelperConstant.PARABLU_PRODUCT_TYPE.BACKUP.getProductType())) {
                        bkpEnabled = true;
                        aadUser.setBackupEnabled(bkpEnabled);
                        aadUser.setDefaultPolicy(this.registry.get(cloudId).getPropertyFileValueDefaultBkpPolicy());
                        continue;
                    }
                    if (mapping3.getProductType().equalsIgnoreCase(CPHelperConstant.PARABLU_PRODUCT_TYPE.SYNC.getProductType())) {
                        syncEnabled = true;
                        aadUser.setSyncEnabled(syncEnabled);
                        aadUser.setDefaultSyncPolicy(this.registry.get(cloudId).getPropertyFileValueDefaultSyncPolicy());
                        continue;
                    }
                    if (mapping3.getProductType().equalsIgnoreCase(CPHelperConstant.PARABLU_PRODUCT_TYPE.ODB.getProductType())) {
                        oneDriveEnabled = true;
                        aadUser.setOnedriveBkpEnabled(oneDriveEnabled);
                        aadUser.setDefaultOdbPolicy(this.registry.get(cloudId).getPropertyFileValueDefaultOdbPolicy());
                        continue;
                    }
                    if (mapping3.getProductType().equalsIgnoreCase(CPHelperConstant.PARABLU_PRODUCT_TYPE.EXCHANGE.getProductType())) {
                        exchangeEnabled = true;
                        aadUser.setExchangeBkpEnabled(exchangeEnabled);
                        aadUser.setDefaultExchangePolicy(this.registry.get(cloudId).getPropertyFileValueDefaultExchangePolicy());
                        continue;
                    }
                    bkpEnabled = true;
                    syncEnabled = true;
                    exchangeEnabled = true;
                    oneDriveEnabled = true;
                    aadUser.setDefaultOdbPolicy(this.registry.get(cloudId).getPropertyFileValueDefaultOdbPolicy());
                    aadUser.setDefaultExchangePolicy(this.registry.get(cloudId).getPropertyFileValueDefaultExchangePolicy());
                    aadUser.setDefaultPolicy(this.registry.get(cloudId).getPropertyFileValueDefaultBkpPolicy());
                    aadUser.setDefaultSyncPolicy(this.registry.get(cloudId).getPropertyFileValueDefaultSyncPolicy());
                }
                if (bkpEnabled && syncEnabled) {
                    productType = "BOTH";
                    aadUser.setDefaultPolicy(this.registry.get(cloudId).getPropertyFileValueDefaultBkpPolicy());
                    aadUser.setDefaultSyncPolicy(this.registry.get(cloudId).getPropertyFileValueDefaultSyncPolicy());
                    aadUser.setDefaultOdbPolicy(this.registry.get(cloudId).getPropertyFileValueDefaultOdbPolicy());
                    aadUser.setDefaultExchangePolicy(this.registry.get(cloudId).getPropertyFileValueDefaultExchangePolicy());
                } else if (bkpEnabled) {
                    productType = "BACKUP";
                    aadUser.setDefaultPolicy(this.registry.get(cloudId).getPropertyFileValueDefaultBkpPolicy());
                } else if (syncEnabled) {
                    productType = "SYNC";
                    aadUser.setDefaultSyncPolicy(this.registry.get(cloudId).getPropertyFileValueDefaultSyncPolicy());
                } else if (oneDriveEnabled) {
                    productType = "ODB";
                    aadUser.setDefaultOdbPolicy(this.registry.get(cloudId).getPropertyFileValueDefaultOdbPolicy());
                } else if (exchangeEnabled) {
                    productType = "MAIL";
                    aadUser.setDefaultExchangePolicy(this.registry.get(cloudId).getPropertyFileValueDefaultExchangePolicy());
                }
            }
            aadUser.setProductType(productType);
        } else {
            logger.debug("...........User " + userName + " .........  Not found in AAD");
        }
        return aadUser;
    }

    public AADUserElement getNewAADUserFromUserName(int cloudId, String userName, String clientId, String secret, String tenantId) {
        AADUserElement aadUser = null;
        User user = this.userDao.getUserByUserNameOrAADLoginId(cloudId, userName);
        if (user == null || user != null && user.isGuest()) {
            aadUser = this.getNewAADUserFromUserName(userName, clientId, secret, tenantId, cloudId);
            if (aadUser != null) {
                logger.debug("...........User " + aadUser.getUserName() + " .........found in AAD");
                String productType = "";
                IdentityProviderSettings aadCredentials = this.aadDao.getAADCredentials(cloudId);
                logger.debug(".................." + aadCredentials.toString());
                if (!CollectionUtils.isEmpty((Collection)aadCredentials.getGroupMapping())) {
                    boolean bkpEnabled = false;
                    boolean syncEnabled = false;
                    boolean o365Enabled = false;
                    if (!CollectionUtils.isEmpty((Collection)aadCredentials.getGroupMapping().stream().filter(mapping -> !org.springframework.util.StringUtils.isEmpty((Object)mapping.getGroupName())).collect(Collectors.toList()))) {
                        List<String> userMemberOf = this.getNewAADUserGroupInfo(cloudId, userName, aadCredentials.getClientId(), aadCredentials.getSecretKey(), tenantId);
                        if (!CollectionUtils.isEmpty(userMemberOf)) {
                            for (String group : userMemberOf) {
                                logger.debug("User is memeber of ............" + group.toLowerCase());
                                for (GroupMapping groupMapping : aadCredentials.getGroupMapping()) {
                                    if (!groupMapping.getGroupName().equalsIgnoreCase(group.toLowerCase())) continue;
                                    if (groupMapping.getProductType().equalsIgnoreCase(CPHelperConstant.PARABLU_PRODUCT_TYPE.BACKUP.getProductType())) {
                                        bkpEnabled = true;
                                        continue;
                                    }
                                    if (groupMapping.getProductType().equalsIgnoreCase(CPHelperConstant.PARABLU_PRODUCT_TYPE.SYNC.getProductType())) {
                                        syncEnabled = true;
                                        continue;
                                    }
                                    if (groupMapping.getProductType().equals("O365")) {
                                        o365Enabled = true;
                                        continue;
                                    }
                                    bkpEnabled = true;
                                    syncEnabled = true;
                                }
                            }
                        }
                    } else if (!aadCredentials.getGroupMapping().isEmpty()) {
                        productType = ((GroupMapping)aadCredentials.getGroupMapping().get(0)).getProductType();
                    }
                    for (GroupMapping mapping2 : aadCredentials.getGroupMapping()) {
                        if (!"".equals(mapping2.getGroupName())) continue;
                        if (mapping2.getProductType().equalsIgnoreCase(CPHelperConstant.PARABLU_PRODUCT_TYPE.BACKUP.getProductType())) {
                            bkpEnabled = true;
                            continue;
                        }
                        if (mapping2.getProductType().equalsIgnoreCase(CPHelperConstant.PARABLU_PRODUCT_TYPE.SYNC.getProductType())) {
                            syncEnabled = true;
                            continue;
                        }
                        if (mapping2.getProductType().equals("O365")) {
                            o365Enabled = true;
                            continue;
                        }
                        bkpEnabled = true;
                        syncEnabled = true;
                    }
                    if (bkpEnabled && syncEnabled && o365Enabled) {
                        productType = "BOTH";
                    } else if (bkpEnabled) {
                        productType = "BACKUP";
                    } else if (syncEnabled) {
                        productType = "SYNC";
                    } else if (o365Enabled) {
                        productType = "O365";
                    }
                }
                aadUser.setProductType(productType);
            } else {
                logger.debug("...........User " + userName + " .........  Not found in AAD");
            }
        } else {
            logger.debug("$##############################" + userName + " ........present in our db....");
        }
        if (aadUser != null) {
            logger.debug("AAD User Element ...." + aadUser.toString());
        }
        return aadUser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AADUserElement getNewAADUserFromUserName(String userName, String clientId, String secret, String tenantId, int cloudId) {
        StringBuilder responseStr = new StringBuilder();
        CloseableHttpClient httpclient = null;
        Object httpGet = null;
        CloseableHttpResponse result = null;
        AADUserElement aadUser = null;
        boolean retry = false;
        int retryCount = 0;
        OkHttpClient okHttpClient = this.getOkHttpClient(cloudId, clientId, secret, tenantId);
        ObjectMapper mapper = new ObjectMapper();
        do {
            try {
                mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
                String url = this.getUserInfoUrl(userName);
                logger.debug(tenantId + "url to get the user from aad latest :" + url);
                HttpUrl.Builder httpBuilder = HttpUrl.parse((String)url).newBuilder();
                Request request = new Request.Builder().url(httpBuilder.build()).build();
                Response response = okHttpClient.newCall(request).execute();
                int httpResponseCode = response.code();
                logger.debug(tenantId + "...getNewAADUserFromUserName ........response code ......... " + httpResponseCode);
                if (httpResponseCode == 200) {
                    InputStream inputStream = response.body().byteStream();
                    try (BufferedReader in = new BufferedReader(new InputStreamReader(inputStream));){
                        String inputLine;
                        while ((inputLine = in.readLine()) != null) {
                            responseStr.append(inputLine);
                        }
                    }
                    aadUser = (AADUserElement)mapper.readValue(responseStr.toString(), AADUserElement.class);
                    break;
                }
                logger.debug("..........user not fount.........");
                break;
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.trace(String.valueOf(e));
                logger.error(" ERROR trying to get AADUser From UserName " + e.getMessage());
                retry = true;
            }
            finally {
                if (httpGet != null) {
                    httpGet.releaseConnection();
                }
                this.closeResponse(result);
                this.closeHttpClient(httpclient);
            }
        } while (retry && ++retryCount < 2);
        return aadUser;
    }

    public OkHttpClient getOkHttpClient(final int cloudId, String clientId, String secret, String tenantId) {
        String authorityHost = "https://login.microsoftonline.com";
        OkHttpClient httpClient = null;
        if (!org.springframework.util.StringUtils.isEmpty((Object)this.registry.get(cloudId).getProxyHost()) && this.registry.get(cloudId).getProxyPort() != 0) {
            Authenticator proxyAuthenticator = new Authenticator(){

                public Request authenticate(Route route, Response response) throws IOException {
                    String credential = okhttp3.Credentials.basic((String)AADManagementServiceImpl.this.registry.get(cloudId).getProxyUserName(), (String)AADManagementServiceImpl.this.registry.get(cloudId).getProxyPassword());
                    return response.request().newBuilder().header("Proxy-Authorization", credential).build();
                }
            };
            ProxyOptions proxyOptions = new ProxyOptions(ProxyOptions.Type.HTTP, new InetSocketAddress(this.registry.get(cloudId).getProxyHost(), this.registry.get(cloudId).getProxyPort()));
            ClientSecretCredential clientSecretCredential = ((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)new ClientSecretCredentialBuilder().clientId(clientId)).clientSecret(secret).tenantId(tenantId)).proxyOptions(proxyOptions)).authorityHost(authorityHost)).build();
            ArrayList<String> scopes = new ArrayList<String>();
            scopes.add("https://graph.microsoft.com/.default");
            TokenCredentialAuthProvider tokenCredAuthProvider = new TokenCredentialAuthProvider(scopes, (TokenCredential)clientSecretCredential);
            httpClient = com.microsoft.graph.httpcore.HttpClients.createDefault((IAuthenticationProvider)tokenCredAuthProvider).newBuilder().proxy(new java.net.Proxy(Proxy.Type.HTTP, new InetSocketAddress(this.registry.get(cloudId).getProxyHost(), this.registry.get(cloudId).getProxyPort()))).proxyAuthenticator(proxyAuthenticator).build();
        } else {
            ClientSecretCredential clientSecretCredential = ((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)new ClientSecretCredentialBuilder().clientId(clientId)).clientSecret(secret).tenantId(tenantId)).authorityHost(authorityHost)).build();
            ArrayList<String> scopes = new ArrayList<String>();
            scopes.add("https://graph.microsoft.com/.default");
            TokenCredentialAuthProvider tokenCredAuthProvider = new TokenCredentialAuthProvider(scopes, (TokenCredential)clientSecretCredential);
            httpClient = com.microsoft.graph.httpcore.HttpClients.createDefault((IAuthenticationProvider)tokenCredAuthProvider).newBuilder().build();
        }
        return httpClient;
    }

    public GraphServiceClient<Request> getGraphClient(String clientId, String secret, String tenantId) {
        String authorityHost = "https://login.microsoftonline.com";
        ClientSecretCredential clientSecretCredential = ((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)new ClientSecretCredentialBuilder().clientId(clientId)).clientSecret(secret).tenantId(tenantId)).authorityHost(authorityHost)).build();
        ArrayList<String> scopes = new ArrayList<String>();
        scopes.add("https://graph.microsoft.com/.default");
        TokenCredentialAuthProvider tokenCredAuthProvider = new TokenCredentialAuthProvider(scopes, (TokenCredential)clientSecretCredential);
        GraphServiceClient graphClient = GraphServiceClient.builder().authenticationProvider((IAuthenticationProvider)tokenCredAuthProvider).buildClient();
        return graphClient;
    }

    @Override
    public String getTenantIdForGraphAADUsersFromUserNames(Cloud cloud, String userName) {
        String tenantId = "";
        IdentityProviderSettings aadCredentials = this.aadDao.getAADCredentials(cloud.getCloudId());
        ArrayList<String> tenants = new ArrayList<String>();
        if (cloud.getMultiTenantAADEnabled() == 1) {
            if (!CollectionUtils.isEmpty((Collection)aadCredentials.getTenants())) {
                tenants.addAll(aadCredentials.getTenants());
            } else {
                tenants.add(aadCredentials.getTenentId());
            }
        } else {
            tenants.add(aadCredentials.getTenentId());
        }
        for (String tenantIdval : tenants) {
            logger.debug(userName + "...checking in tenant..." + tenantId);
            AADUserElement aadUser = this.getNewAADUserFromUserName(cloud.getCloudId(), userName, aadCredentials.getClientId(), aadCredentials.getSecretKey(), tenantIdval);
            if (aadUser == null) continue;
            tenantId = tenantIdval;
            break;
        }
        logger.debug("...user exists in ..." + tenantId);
        return tenantId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getNewAADUserGroupInfo(int cloudId, String userName, String clientId, String secret, String tenantId) {
        StringBuilder responseStr = new StringBuilder();
        ArrayList<String> userMemeberOf = new ArrayList<String>();
        HashSet userMemeberOfSet = new HashSet();
        boolean retry = false;
        int retryCount = 0;
        CloseableHttpClient httpclient = null;
        Object httpGet = null;
        CloseableHttpResponse result = null;
        ObjectMapper mapper = new ObjectMapper();
        Object url = "https://graph.microsoft.com/v1.0//users/" + userName + GRAPH_USER_MEMBER_OF;
        boolean isSkipTokenAvailable = false;
        OkHttpClient okHttpClient = this.getOkHttpClient(cloudId, clientId, secret, tenantId);
        do {
            try {
                mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
                logger.debug(".....url...." + (String)url);
                HttpUrl.Builder httpBuilder = HttpUrl.parse((String)url).newBuilder();
                Request request = new Request.Builder().url(httpBuilder.build()).build();
                Response response = okHttpClient.newCall(request).execute();
                int httpResponseCode = response.code();
                logger.debug(userName + "..........getAADUserFromUserName ........response code ......... " + httpResponseCode);
                if (httpResponseCode != 200) continue;
                InputStream inputStream = response.body().byteStream();
                try (BufferedReader in = new BufferedReader(new InputStreamReader(inputStream));){
                    String inputLine;
                    while ((inputLine = in.readLine()) != null) {
                        responseStr.append(inputLine);
                    }
                }
                GraphResponseForMemberOf forMemberOf = (GraphResponseForMemberOf)mapper.readValue(responseStr.toString(), GraphResponseForMemberOf.class);
                if (forMemberOf != null && !CollectionUtils.isEmpty((Collection)forMemberOf.getGroupInfo())) {
                    List groupInfo = forMemberOf.getGroupInfo();
                    List userMemberList = groupInfo.stream().map(group -> group.getDisplayName().toLowerCase()).collect(Collectors.toList());
                    userMemeberOf.addAll(userMemberList);
                    userMemeberOfSet.addAll(userMemberList);
                }
                responseStr = new StringBuilder();
                if (!org.springframework.util.StringUtils.isEmpty((Object)forMemberOf.getNextLink())) {
                    logger.debug((String)url + ".... link available....." + forMemberOf.getNextLink());
                    if (((String)url).equalsIgnoreCase(forMemberOf.getNextLink())) {
                        logger.debug((String)url + ".... link available.but same...." + String.valueOf(userMemeberOfSet));
                        isSkipTokenAvailable = false;
                        break;
                    }
                    url = forMemberOf.getNextLink();
                    isSkipTokenAvailable = true;
                }
                if (!org.springframework.util.StringUtils.isEmpty((Object)forMemberOf.getNextLink())) continue;
                logger.debug("....no link available.....");
                isSkipTokenAvailable = false;
                break;
            }
            catch (Exception e) {
                logger.trace(String.valueOf(e));
                logger.error(" ERROR trying to get getAADUserGroupInfo " + e.getMessage());
                retry = true;
                ++retryCount;
            }
            finally {
                if (httpGet != null) {
                    httpGet.releaseConnection();
                }
                this.closeResponse(result);
                this.closeHttpClient(httpclient);
            }
        } while (retry && retryCount < 2 || isSkipTokenAvailable);
        return userMemeberOf;
    }

    @Override
    public List<AADUserElement> getGraphAADUsersFromUserNames(Cloud cloud, AADUserNamesList aadUserNameList) {
        int cloudId = cloud.getCloudId();
        ArrayList<AADUserElement> aadUsersList = new ArrayList<AADUserElement>();
        IdentityProviderSettings aadCredentials = this.aadDao.getAADCredentials(cloudId);
        ArrayList<String> tenants = new ArrayList<String>();
        if (cloud.getMultiTenantAADEnabled() == 1) {
            if (!CollectionUtils.isEmpty((Collection)aadCredentials.getTenants())) {
                tenants.addAll(aadCredentials.getTenants());
            } else {
                tenants.add(aadCredentials.getTenentId());
            }
        } else {
            tenants.add(aadCredentials.getTenentId());
        }
        logger.debug("...tenants present..." + tenants.size());
        for (String userName : aadUserNameList.getAadUserNames()) {
            User user = this.userDao.getUserByUserNameOrAADLoginId(cloudId, userName);
            if (user == null || user != null && user.isGuest()) {
                AADUserElement aadUser = null;
                for (String tenantId : tenants) {
                    logger.debug("...checking in tenant..." + tenantId);
                    aadUser = this.getNewAADUserFromUserName(cloudId, userName, aadCredentials.getClientId(), aadCredentials.getSecretKey(), tenantId);
                    if (aadUser == null) continue;
                    break;
                }
                if (aadUser != null) {
                    if (org.springframework.util.StringUtils.isEmpty((Object)aadUser.getProductType())) {
                        logger.debug("user is not part any group " + aadUser.getUserPrincipalName());
                        continue;
                    }
                    aadUser.setUserName(userName);
                    aadUser.setUserPrincipalName(null);
                    aadUsersList.add(aadUser);
                    continue;
                }
                logger.debug("...........User " + userName + " .........  Not found in AAD Or token expired.........");
                continue;
            }
            logger.debug("$##############################" + userName + " ........present in our db....");
        }
        logger.debug("...........aadUsersList size... " + aadUsersList.size());
        return aadUsersList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<String> getGroupMembersInfo(int cloudId, String groupId, AADAuthorizationToken authToken) {
        StringBuilder response = new StringBuilder();
        HashSet userMemeberOfSet = new HashSet();
        boolean retry = false;
        int retryCount = 0;
        CloseableHttpClient httpclient = null;
        HttpGet httpGet = null;
        CloseableHttpResponse result = null;
        ObjectMapper mapper = new ObjectMapper();
        Object url = "https://graph.microsoft.com/v1.0/groups/" + groupId + "/members";
        boolean isSkipTokenAvailable = false;
        ArrayList<String> userMemberList = new ArrayList<String>();
        do {
            block35: {
                block36: {
                    block33: {
                        block34: {
                            block31: {
                                block32: {
                                    List<String> list;
                                    block28: {
                                        block29: {
                                            try {
                                                mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
                                                logger.debug(".....group members url...." + (String)url);
                                                Proxy proxy = this.settingsDao.getProxy(cloudId);
                                                if (proxy != null || !org.springframework.util.StringUtils.isEmpty((Object)this.registry.get(cloudId).getProxyHost()) && !org.springframework.util.StringUtils.isEmpty((Object)this.registry.get(cloudId).getProxyPort())) {
                                                    logger.debug("host :" + this.registry.get(cloudId).getProxyHost());
                                                    logger.debug("port :" + this.registry.get(cloudId).getProxyPort());
                                                    HttpHost proxyval = new HttpHost(this.registry.get(cloudId).getProxyHost(), this.registry.get(cloudId).getProxyPort(), "http");
                                                    DefaultProxyRoutePlanner routePlanner = new DefaultProxyRoutePlanner(proxyval);
                                                    httpclient = HttpClients.custom().setRoutePlanner((HttpRoutePlanner)routePlanner).build();
                                                } else {
                                                    httpclient = HttpClients.custom().build();
                                                }
                                                httpGet = new HttpGet((String)url);
                                                httpGet.addHeader("Authorization", "Bearer " + authToken.getAccess_token());
                                                httpGet.addHeader("Accept", "application/json");
                                                result = httpclient.execute((HttpUriRequest)httpGet);
                                                int httpResponseCode = result.getStatusLine().getStatusCode();
                                                logger.debug(groupId + "..........getAADUserFromUserName ........response code ......... " + httpResponseCode);
                                                if (httpResponseCode == 401) {
                                                    retry = true;
                                                    ++retryCount;
                                                    AADAuthorizationToken accessTokenAndUpdateInDB = this.getAccessTokenAndUpdateInDB(cloudId, authToken);
                                                    if (accessTokenAndUpdateInDB == null) {
                                                        logger.debug("token is expired so return");
                                                        list = null;
                                                        if (httpGet == null) break block28;
                                                        break block29;
                                                    }
                                                    this.getGroupMembersInfo(cloudId, groupId, authToken);
                                                } else if (httpResponseCode == 200) {
                                                    InputStream inputStream = result.getEntity().getContent();
                                                    try (BufferedReader in = new BufferedReader(new InputStreamReader(inputStream));){
                                                        String inputLine;
                                                        while ((inputLine = in.readLine()) != null) {
                                                            response.append(inputLine);
                                                        }
                                                    }
                                                    JSONObject jsonObject = new JSONObject(response.toString());
                                                    String arr = jsonObject.optString("value");
                                                    if (jsonObject != null) {
                                                        logger.debug("..jsonobject....." + jsonObject.toString());
                                                        if (!org.springframework.util.StringUtils.isEmpty((Object)jsonObject.optString("@odata.nextLink"))) {
                                                            logger.debug("..jsonobjectnext....." + jsonObject.optString("@odata.nextLink"));
                                                        }
                                                    }
                                                    logger.debug("..outputvaaaaa....." + arr);
                                                    JSONArray jsonArray = new JSONArray(arr);
                                                    for (int i = 0; i < jsonArray.length(); ++i) {
                                                        JSONObject object = (JSONObject)jsonArray.get(i);
                                                        Object displayName = object.get("mail");
                                                        logger.debug(String.valueOf(displayName) + "..objfound..." + String.valueOf(object));
                                                        if (displayName == null) continue;
                                                        logger.debug(String.valueOf(displayName) + "..founduser..." + String.valueOf(object));
                                                        userMemberList.add((String)object.get("id"));
                                                    }
                                                    String nextLink = "";
                                                    if (!org.springframework.util.StringUtils.isEmpty((Object)jsonObject.optString("@odata.nextLink"))) {
                                                        logger.debug("..jsonobjectnext....." + jsonObject.optString("@odata.nextLink"));
                                                        nextLink = jsonObject.optString("@odata.nextLink");
                                                    }
                                                    response = new StringBuilder();
                                                    if (!org.springframework.util.StringUtils.isEmpty((Object)nextLink)) {
                                                        logger.debug((String)url + ".... link available....." + nextLink);
                                                        if (((String)url).equalsIgnoreCase(nextLink)) {
                                                            logger.debug((String)url + ".... link available.but same...." + String.valueOf(userMemeberOfSet));
                                                            isSkipTokenAvailable = false;
                                                            if (httpGet == null) break block31;
                                                            break block32;
                                                        }
                                                        url = nextLink;
                                                        isSkipTokenAvailable = true;
                                                    }
                                                    if (org.springframework.util.StringUtils.isEmpty((Object)nextLink)) {
                                                        logger.debug("....no link available.....");
                                                        isSkipTokenAvailable = false;
                                                        if (httpGet == null) break block33;
                                                        break block34;
                                                    }
                                                }
                                                if (httpGet == null) break block35;
                                                break block36;
                                            }
                                            catch (Exception e) {
                                                logger.trace(String.valueOf(e));
                                                logger.error(" ERROR trying to get getAADUserGroupInfo " + e.getMessage());
                                                retry = true;
                                                ++retryCount;
                                                continue;
                                            }
                                        }
                                        httpGet.releaseConnection();
                                    }
                                    this.closeResponse(result);
                                    this.closeHttpClient(httpclient);
                                    return list;
                                }
                                httpGet.releaseConnection();
                            }
                            this.closeResponse(result);
                            this.closeHttpClient(httpclient);
                            return userMemberList;
                        }
                        httpGet.releaseConnection();
                    }
                    this.closeResponse(result);
                    this.closeHttpClient(httpclient);
                    return userMemberList;
                }
                httpGet.releaseConnection();
            }
            this.closeResponse(result);
            this.closeHttpClient(httpclient);
            continue;
            finally {
                if (httpGet != null) {
                    httpGet.releaseConnection();
                }
                this.closeResponse(result);
                this.closeHttpClient(httpclient);
            }
        } while (retry && retryCount < 2 || isSkipTokenAvailable);
        return userMemberList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<String> getNewGroupMembersInfo(int cloudId, String groupId, String clientId, String secretKey, String tenantId) {
        StringBuilder response = new StringBuilder();
        HashSet userMemeberOfSet = new HashSet();
        boolean retry = false;
        int retryCount = 0;
        CloseableHttpClient httpclient = null;
        Object httpGet = null;
        CloseableHttpResponse result = null;
        ObjectMapper mapper = new ObjectMapper();
        Object url = "https://graph.microsoft.com/v1.0/groups/" + groupId + "/members";
        boolean isSkipTokenAvailable = false;
        ArrayList<String> userMemberList = new ArrayList<String>();
        OkHttpClient okHttpClient = this.getOkHttpClient(cloudId, clientId, secretKey, tenantId);
        do {
            block26: {
                block27: {
                    block24: {
                        block25: {
                            block22: {
                                block23: {
                                    try {
                                        mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
                                        logger.debug(".....group members url...." + (String)url);
                                        Proxy proxy = this.settingsDao.getProxy(cloudId);
                                        if (proxy != null || !org.springframework.util.StringUtils.isEmpty((Object)this.registry.get(cloudId).getProxyHost()) && !org.springframework.util.StringUtils.isEmpty((Object)this.registry.get(cloudId).getProxyPort())) {
                                            logger.debug("host :" + this.registry.get(cloudId).getProxyHost());
                                            logger.debug("port :" + this.registry.get(cloudId).getProxyPort());
                                            HttpHost proxyval = new HttpHost(this.registry.get(cloudId).getProxyHost(), this.registry.get(cloudId).getProxyPort(), "http");
                                            DefaultProxyRoutePlanner routePlanner = new DefaultProxyRoutePlanner(proxyval);
                                            httpclient = HttpClients.custom().setRoutePlanner((HttpRoutePlanner)routePlanner).build();
                                        } else {
                                            httpclient = HttpClients.custom().build();
                                        }
                                        HttpUrl.Builder httpBuilder = HttpUrl.parse((String)url).newBuilder();
                                        Request request = new Request.Builder().url(httpBuilder.build()).build();
                                        Response responseObj = okHttpClient.newCall(request).execute();
                                        int httpResponseCode = responseObj.code();
                                        logger.debug(groupId + "..........getAADUserFromUserName ........response code ......... " + httpResponseCode);
                                        if (httpResponseCode == 200) {
                                            InputStream inputStream = responseObj.body().byteStream();
                                            try (BufferedReader in = new BufferedReader(new InputStreamReader(inputStream));){
                                                String inputLine;
                                                while ((inputLine = in.readLine()) != null) {
                                                    response.append(inputLine);
                                                }
                                            }
                                            JSONObject jsonObject = new JSONObject(response.toString());
                                            String arr = jsonObject.optString("value");
                                            logger.debug("..output....." + arr);
                                            JSONArray jsonArray = new JSONArray(arr);
                                            for (int i = 0; i < jsonArray.length(); ++i) {
                                                JSONObject object = (JSONObject)jsonArray.get(i);
                                                Object displayName = object.get("mail");
                                                logger.debug(String.valueOf(displayName) + "..objfound..." + String.valueOf(object));
                                                if (displayName == null) continue;
                                                logger.debug(String.valueOf(displayName) + "..founduser..." + String.valueOf(object));
                                                userMemberList.add((String)object.get("id"));
                                            }
                                            String nextLink = "";
                                            response = new StringBuilder();
                                            if (!org.springframework.util.StringUtils.isEmpty((Object)nextLink)) {
                                                logger.debug((String)url + ".... link available....." + nextLink);
                                                if (((String)url).equalsIgnoreCase(nextLink)) {
                                                    logger.debug((String)url + ".... link available.but same...." + String.valueOf(userMemeberOfSet));
                                                    isSkipTokenAvailable = false;
                                                    if (httpGet == null) break block22;
                                                    break block23;
                                                }
                                                url = nextLink;
                                                isSkipTokenAvailable = true;
                                            }
                                            if (org.springframework.util.StringUtils.isEmpty((Object)nextLink)) {
                                                logger.debug("....no link available.....");
                                                isSkipTokenAvailable = false;
                                                if (httpGet == null) break block24;
                                                break block25;
                                            }
                                        }
                                        if (httpGet == null) break block26;
                                        break block27;
                                    }
                                    catch (Exception e) {
                                        logger.trace(String.valueOf(e));
                                        logger.error(" ERROR trying to get getAADUserGroupInfo " + e.getMessage());
                                        retry = true;
                                        ++retryCount;
                                        continue;
                                    }
                                }
                                httpGet.releaseConnection();
                            }
                            this.closeResponse(result);
                            this.closeHttpClient(httpclient);
                            return userMemberList;
                        }
                        httpGet.releaseConnection();
                    }
                    this.closeResponse(result);
                    this.closeHttpClient(httpclient);
                    return userMemberList;
                }
                httpGet.releaseConnection();
            }
            this.closeResponse(result);
            this.closeHttpClient(httpclient);
            continue;
            finally {
                if (httpGet != null) {
                    httpGet.releaseConnection();
                }
                this.closeResponse(result);
                this.closeHttpClient(httpclient);
            }
        } while (retry && retryCount < 2 || isSkipTokenAvailable);
        return userMemberList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getNewGroupId(int cloudId, String groupName, String clientId, String secret, String tenantId) {
        StringBuilder response = new StringBuilder();
        CloseableHttpClient httpclient = null;
        Object httpGet = null;
        CloseableHttpResponse result = null;
        boolean retry = false;
        int retryCount = 0;
        OkHttpClient okHttpClient = this.getOkHttpClient(cloudId, clientId, secret, tenantId);
        ObjectMapper mapper = new ObjectMapper();
        do {
            block23: {
                block22: {
                    try {
                        mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
                        String groupNameenc = URLEncoder.encode("startswith(displayName, '" + groupName + "')", UTF_8);
                        String url = "https://graph.microsoft.com/v1.0/groups?$filter=" + groupNameenc;
                        logger.debug("url to get the user from aad:" + url);
                        Proxy proxy = this.settingsDao.getProxy(cloudId);
                        if (proxy != null || !org.springframework.util.StringUtils.isEmpty((Object)this.registry.get(cloudId).getProxyHost()) && !org.springframework.util.StringUtils.isEmpty((Object)this.registry.get(cloudId).getProxyPort())) {
                            logger.debug("host :" + this.registry.get(cloudId).getProxyHost());
                            logger.debug("port :" + this.registry.get(cloudId).getProxyPort());
                            HttpHost proxyval = new HttpHost(this.registry.get(cloudId).getProxyHost(), this.registry.get(cloudId).getProxyPort(), "http");
                            DefaultProxyRoutePlanner routePlanner = new DefaultProxyRoutePlanner(proxyval);
                            httpclient = HttpClients.custom().setRoutePlanner((HttpRoutePlanner)routePlanner).build();
                        } else {
                            httpclient = HttpClients.custom().build();
                        }
                        HttpUrl.Builder httpBuilder = HttpUrl.parse((String)url).newBuilder();
                        Request request = new Request.Builder().url(httpBuilder.build()).build();
                        Response responseObj = okHttpClient.newCall(request).execute();
                        int httpResponseCode = responseObj.code();
                        logger.debug("getAADUserFromUserName ........response code ......... " + httpResponseCode);
                        if (httpResponseCode == 200) {
                            InputStream inputStream = responseObj.body().byteStream();
                            try (BufferedReader in = new BufferedReader(new InputStreamReader(inputStream));){
                                String inputLine;
                                while ((inputLine = in.readLine()) != null) {
                                    response.append(inputLine);
                                }
                            }
                            JSONObject jsonObject = new JSONObject(response.toString());
                            String arr = jsonObject.optString("value");
                            logger.debug("..output....." + arr);
                            JSONArray jsonArray = new JSONArray(arr);
                            for (int i = 0; i < jsonArray.length(); ++i) {
                                JSONObject object = (JSONObject)jsonArray.get(i);
                                Object displayName = object.get("displayName");
                                logger.debug(String.valueOf(displayName) + "..objfound..." + String.valueOf(object));
                                if (displayName == null || !groupName.equalsIgnoreCase((String)displayName)) continue;
                                logger.debug(String.valueOf(displayName) + "..foundgroup..." + String.valueOf(object));
                                String string = (String)object.get("id");
                                if (httpGet != null) {
                                    httpGet.releaseConnection();
                                }
                                this.closeResponse(result);
                                this.closeHttpClient(httpclient);
                                return string;
                            }
                            if (httpGet != null) {
                                httpGet.releaseConnection();
                            }
                            this.closeResponse(result);
                            this.closeHttpClient(httpclient);
                            return "";
                        }
                        logger.debug("..........user not fount.........");
                        if (httpGet == null) break block22;
                    }
                    catch (Exception e) {
                        logger.trace(String.valueOf(e));
                        logger.error(" ERROR trying to get AADUser From UserName " + e.getMessage());
                        retry = true;
                        break block23;
                    }
                    httpGet.releaseConnection();
                }
                this.closeResponse(result);
                this.closeHttpClient(httpclient);
                return "";
                finally {
                    if (httpGet != null) {
                        httpGet.releaseConnection();
                    }
                    this.closeResponse(result);
                    this.closeHttpClient(httpclient);
                }
            }
            if (!retry) return "";
        } while (++retryCount < 2);
        return "";
    }

    private List<AADUserElement> processNewGroupItems(Cloud cloud, Set<String> groupsInDB, GraphGroupDeltaPageTO groupDelta) {
        for (String group : groupsInDB) {
            logger.debug("...groupsindb....." + group);
        }
        if (CollectionUtils.isEmpty(groupsInDB)) {
            logger.debug("...emptyy groups...");
            return new ArrayList<AADUserElement>();
        }
        List<GraphGroupDeltaItemTO> groupdeltaUserItemTOs = groupDelta.getItemList();
        if (CollectionUtils.isEmpty(groupdeltaUserItemTOs = groupdeltaUserItemTOs.stream().filter(p -> !org.springframework.util.StringUtils.isEmpty((Object)p.displayName) && groupsInDB.contains(p.displayName.toLowerCase())).collect(Collectors.toList()))) {
            logger.debug("groupdeltaUserItemTOs is empty");
            return new ArrayList<AADUserElement>();
        }
        ArrayList<AADUserElement> aaduserElementList = new ArrayList<AADUserElement>();
        groupdeltaUserItemTOs.forEach(groupDeltaItems -> {
            logger.debug("Inside....groupDeltaItems...." + groupDeltaItems.getDisplayName());
            List members = groupDeltaItems.getMembers();
            if (!CollectionUtils.isEmpty((Collection)groupDeltaItems.getMembers())) {
                members.forEach(member -> {
                    logger.debug("Inside.....member..." + String.valueOf(member));
                    if (member.isRemoved()) {
                        logger.error("user is removed so don't add him/her/it..." + member.getId());
                        return;
                    }
                    AADUserElement aadUser = this.getAADUserFromUserNameToSync(cloud, member.getId());
                    if (aadUser != null) {
                        logger.debug("....userandid details.." + aadUser.getUserName() + "..." + aadUser.getDisplayName() + "....." + member.getId());
                        aaduserElementList.add(aadUser);
                        logger.debug(aadUser.getDisplayName() + "$$$" + aadUser.getUserName() + "....aadUser....licenses:" + aadUser.isBackupEnabled() + ".isExchange:" + aadUser.isOnedriveBkpEnabled());
                    }
                });
            }
        });
        return aaduserElementList;
    }

    private void processGroupItems(Cloud cloud, Set<String> groupsInDB, GraphGroupDeltaPageTO groupDelta, IdentityProviderSettings aadCredentials) {
        List<GraphGroupDeltaItemTO> groupdeltaUserItemTOs = groupDelta.getItemList();
        if (CollectionUtils.isEmpty(groupdeltaUserItemTOs = groupdeltaUserItemTOs.stream().filter(p -> !org.springframework.util.StringUtils.isEmpty((Object)p.displayName) && groupsInDB.contains(p.displayName.toLowerCase())).collect(Collectors.toList()))) {
            logger.debug("groupdeltaUserItemTOs is empty");
        }
        groupdeltaUserItemTOs.forEach(groupDeltaItems -> {
            logger.debug("Inside........" + groupDeltaItems.getDisplayName());
            List members = groupDeltaItems.getMembers();
            members.forEach(member -> {
                logger.debug(member.getId() + "...Inside.....member..." + String.valueOf(member));
                AADUserElement aadUser = this.getAADUserFromUserNameToSync(cloud, member.getId());
                if (member.isRemoved() && aadUser != null) {
                    if (aadUser.getProductType().equalsIgnoreCase("")) {
                        this.changeAADUserStatus(cloud, aadUser.getUserPrincipalName(), false, false, false);
                    } else if (aadUser.getProductType().equalsIgnoreCase("BACKUP")) {
                        this.changeAADUserStatus(cloud, aadUser.getUserPrincipalName(), true, false, false);
                    } else if (aadUser.getProductType().equalsIgnoreCase("SYNC")) {
                        this.changeAADUserStatus(cloud, aadUser.getUserPrincipalName(), false, true, false);
                    } else if (aadUser.getProductType().equalsIgnoreCase("O365")) {
                        this.changeAADUserStatus(cloud, aadUser.getUserPrincipalName(), false, false, true);
                    } else if (aadUser.getProductType().equalsIgnoreCase("BOTH")) {
                        this.changeAADUserStatus(cloud, aadUser.getUserPrincipalName(), true, true, true);
                    }
                } else if (aadUser != null) {
                    this.updateOrCreateAADUserInfo(cloud, aadUser, aadCredentials);
                }
            });
        });
    }

    private void changeAADUserStatus(Cloud cloud, String userName, boolean isBackupEnabled, boolean isSyncEnabled, boolean isO365Enabled) {
        try {
            User existingUser = this.userDao.getUserByUserNameOrAADLoginId(cloud.getCloudId(), userName);
            if (existingUser != null) {
                boolean previStatus = existingUser.isActive();
                existingUser.setBackupEnabled(isBackupEnabled);
                if (!isBackupEnabled) {
                    existingUser.setActive(false);
                }
                if (!previStatus && (isBackupEnabled || isO365Enabled)) {
                    long countOfPresentUsers = this.userDao.countOfPresentUsers(cloud.getCloudId(), cloud.getCloudName(), true);
                    int noOfUsersAllowed = cloud.getNoOfUsersAllowed();
                    if ((long)noOfUsersAllowed <= countOfPresentUsers) {
                        logger.debug(noOfUsersAllowed + "..User limit reached........." + countOfPresentUsers);
                        throw new Exception("User limit reached....");
                    }
                    existingUser.setActive(true);
                }
                existingUser.setOnedriveBkpEnabled(isO365Enabled);
                if (isO365Enabled) {
                    existingUser.setOneDrivePolicyName(this.registry.get(cloud.getCloudId()).getPropertyFileValueDefaultOdbPolicy());
                }
                this.userDao.saveUser(cloud.getCloudId(), cloud.getCloudName(), existingUser);
                this.deviceDao.updateUserInfoInDeviceBkpOverview(cloud.getCloudId(), existingUser);
                this.setAuditForAADBlockedOrUnblocked(cloud.getCloudId(), cloud.getCloudName(), userName, existingUser.isActive(), previStatus);
                this.changeDeviceStatusAndAduit(cloud, existingUser);
            }
        }
        catch (Exception e) {
            logger.error(EXCEPTION + String.valueOf(e));
            logger.debug(EXCEPTION + e.getMessage());
        }
    }

    private boolean blockDevice(User userElement, String cloudName, int cloudId) {
        boolean blockDevice = false;
        try {
            boolean isBackupAndSyncDisabledPortal;
            List<Device> list = this.deviceManagementService.getDevicesByUserName(cloudId, userElement.getUserName());
            boolean bl = isBackupAndSyncDisabledPortal = !userElement.isBackupEnabled() && (!userElement.isSyncEnabled() || StringUtils.isNotEmpty((CharSequence)userElement.getSyncAccessType()) && !userElement.getSyncAccessType().equals("WEBANDENDPOINT"));
            if (!CollectionUtils.isEmpty(list)) {
                for (Device device : list) {
                    if (device.isBlocked()) continue;
                    if ((StringUtils.isEmpty((CharSequence)device.getDeviceType()) || device.getDeviceType().equalsIgnoreCase("BACKUP")) && isBackupAndSyncDisabledPortal) {
                        logger.debug("Backup and sync license is disabled for endpoint");
                        blockDevice = true;
                        device.setBlocked(true);
                        this.deviceManagementService.blockUnblockDevice(cloudId, cloudName, device, true);
                        this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudName, "blocked Asset:" + device.getDeviceName() + " of User:", "AUTO", userElement.getUserName(), "Portal", System.currentTimeMillis(), PCActionTypes.DEVICE_BLOCK.getActionTypeValue());
                        continue;
                    }
                    if (device.getDeviceType().equalsIgnoreCase("ONEDRIVE") && !userElement.isOnedriveBkpEnabled()) {
                        logger.debug("Onedrive license is disabled for endpoint");
                        device.setBlocked(true);
                        blockDevice = true;
                        this.deviceManagementService.blockUnblockDevice(cloudId, cloudName, device, true);
                        this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudName, "blocked Asset:" + device.getDeviceName() + " of User:", "AUTO", userElement.getUserName(), "Portal", System.currentTimeMillis(), PCActionTypes.DEVICE_BLOCK.getActionTypeValue());
                        continue;
                    }
                    if (!device.getDeviceType().equalsIgnoreCase("OUTLOOK") || userElement.isExchangeBkpEnabled()) continue;
                    logger.debug("Exchange license is disabled for endpoint");
                    device.setBlocked(true);
                    blockDevice = true;
                    this.deviceManagementService.blockUnblockDevice(cloudId, cloudName, device, true);
                    this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudName, "blocked Asset:" + device.getDeviceName() + " of User:", "AUTO", userElement.getUserName(), "Portal", System.currentTimeMillis(), PCActionTypes.DEVICE_BLOCK.getActionTypeValue());
                }
            }
        }
        catch (Exception e) {
            logger.error("error in blockDevice ", (Throwable)e);
            e.printStackTrace();
        }
        return blockDevice;
    }

    private String findAADGroupDifference(Map<String, String> existingAADGroupConfig, Map<String, String> newAADGroupConfig) {
        String oldValue;
        String oldValue2;
        String newValue;
        String key;
        logger.debug("Existing AAD/IdP Group Config: " + String.valueOf(existingAADGroupConfig));
        logger.debug("New AAD/IdP Group Config: " + String.valueOf(newAADGroupConfig));
        StringBuilder groupConfigurationFieldChange = new StringBuilder();
        for (Map.Entry<String, String> newEntry : newAADGroupConfig.entrySet()) {
            key = newEntry.getKey();
            newValue = newEntry.getValue();
            oldValue2 = existingAADGroupConfig.get(key);
            if (oldValue2 != null || key == null || key.isEmpty()) continue;
            newValue = this.replaceKeyword(newValue);
            groupConfigurationFieldChange.append("Added IdP Group Configuration: ").append("Group Name:").append("Product Type ( {").append(key).append(":").append(newValue).append("} )").append("\n");
        }
        for (Map.Entry<String, String> newEntry : newAADGroupConfig.entrySet()) {
            key = newEntry.getKey();
            newValue = newEntry.getValue();
            if (existingAADGroupConfig.containsKey(key) || !"".equals(key)) continue;
            newValue = this.replaceKeyword(newValue);
            groupConfigurationFieldChange.append("Added IdP Configuration: ").append("Product Type ( {").append(newValue).append("} )").append("\n");
        }
        for (Map.Entry<String, String> newEntry : newAADGroupConfig.entrySet()) {
            key = newEntry.getKey();
            newValue = newEntry.getValue();
            oldValue2 = existingAADGroupConfig.get(key);
            if (oldValue2 == null || oldValue2.equals(newValue) || !key.isEmpty()) continue;
            newValue = this.replaceKeyword(newValue);
            oldValue2 = this.replaceKeyword(oldValue2);
            groupConfigurationFieldChange.append("Modified IdP Configuration: ").append(" Product Type ( {").append(oldValue2).append(" => ").append(newValue).append("} )").append("\n");
        }
        for (Map.Entry<String, String> oldEntry : existingAADGroupConfig.entrySet()) {
            key = oldEntry.getKey();
            if (!"".equals(key) || newAADGroupConfig.containsKey(key)) continue;
            oldValue = this.replaceKeyword(oldEntry.getValue());
            groupConfigurationFieldChange.append("Removed IdP Configuration: ").append(" Product Type ( {").append(oldValue).append("} )");
        }
        for (Map.Entry<String, String> newEntry : newAADGroupConfig.entrySet()) {
            key = newEntry.getKey();
            newValue = newEntry.getValue();
            oldValue2 = existingAADGroupConfig.get(key);
            if (oldValue2 == null || oldValue2.equals(newValue) || key.isEmpty()) continue;
            newValue = this.replaceKeyword(newValue);
            oldValue2 = this.replaceKeyword(oldValue2);
            groupConfigurationFieldChange.append("Modified IdP Group Configuration: ").append("Group Name:").append(" Product Type ( {").append(key).append(":").append(oldValue2).append(" => ").append(newValue).append("} )").append("\n");
        }
        for (Map.Entry<String, String> oldEntry : existingAADGroupConfig.entrySet()) {
            key = oldEntry.getKey();
            if (newAADGroupConfig.containsKey(key) || key.isEmpty()) continue;
            oldValue = this.replaceKeyword(oldEntry.getValue());
            groupConfigurationFieldChange.append("Removed IdP Group Configuration: ").append("Group Name:").append(" Product Type ( {").append(key).append(":").append(oldValue).append("} )").append("\n");
        }
        String responseString = groupConfigurationFieldChange.toString();
        return responseString;
    }

    private String replaceKeyword(String value) {
        if (value != null) {
            value = value.replace("SP", "Sharepoint Online").replace("MAIL", "Microsoft Exchange").replace("ODB", "Onedrive for Business").replace("BOTH", "All").replace("BACKUP", "BluValt");
        }
        return value;
    }

    private String generateKey(GroupMapping policy) {
        return policy.getProductType() + "|" + policy.getPolicyName() + "|" + policy.getGroupName();
    }

    private String findManyToManyAADGroupDifference(IdentityProviderSettings existingAADCredentials, IdentityProviderSettings newAADCredentials) {
        StringBuilder changes = new StringBuilder();
        try {
            List existingList = existingAADCredentials.getGroupMapping();
            List newList = newAADCredentials.getGroupMapping();
            Map<String, GroupMapping> existingMap = existingList.stream().collect(Collectors.toMap(GroupMapping::getId, policy -> policy));
            Map<String, GroupMapping> newMap = newList.stream().collect(Collectors.toMap(GroupMapping::getId, policy -> policy));
            HashSet<String> allKeys = new HashSet<String>();
            allKeys.addAll(existingMap.keySet());
            allKeys.addAll(newMap.keySet());
            for (String key : allKeys) {
                GroupMapping oldPolicy = existingMap.get(key);
                GroupMapping newPolicy = newMap.get(key);
                ArrayList<CallSite> modifications = new ArrayList<CallSite>();
                if (oldPolicy == null) {
                    changes.append(" for Group :").append("Group Name ({ ").append("").append(" => " + newPolicy.getGroupName() + "}), ").append("Product Type ({ ").append("").append(" =>  " + newPolicy.getProductType() + "}), ").append("Policy Name ({ ").append("").append(" => " + newPolicy.getPolicyName() + " })\n");
                    continue;
                }
                if (newPolicy == null) {
                    changes.append(" for Group :" + oldPolicy.getGroupName()).append("Group Name ({ ").append(oldPolicy.getGroupName()).append(" => }), ").append("Product Type ({ ").append(oldPolicy.getProductType()).append(" =>  }), ").append("Policy Name ({ ").append(oldPolicy.getPolicyName()).append(" =>  })\n");
                    continue;
                }
                if (!Objects.equals(oldPolicy.getGroupName(), newPolicy.getGroupName())) {
                    modifications.add((CallSite)((Object)("Group Name ({ " + oldPolicy.getGroupName() + " => " + newPolicy.getGroupName() + " })")));
                }
                if (!Objects.equals(oldPolicy.getProductType(), newPolicy.getProductType())) {
                    modifications.add((CallSite)((Object)("Product Type ({ " + oldPolicy.getProductType() + " => " + newPolicy.getProductType() + " })")));
                }
                if (!Objects.equals(oldPolicy.getPolicyName(), newPolicy.getPolicyName())) {
                    modifications.add((CallSite)((Object)("Policy Name ({ " + oldPolicy.getPolicyName() + " => " + newPolicy.getPolicyName() + " })")));
                }
                if (modifications.isEmpty()) continue;
                changes.append(" for Group " + oldPolicy.getGroupName() + ":").append(String.join((CharSequence)", ", modifications)).append("\n");
            }
            return changes.toString();
        }
        catch (Exception e) {
            logger.debug("error..." + String.valueOf(e));
            return changes.toString();
        }
    }

    private AADUserElement getAADUserElementByAccessTokenForCrashplan(String accessToken) {
        AADUserElement aadUserElement = new AADUserElement();
        try {
            String[] parts = accessToken.split("\\.");
            if (parts.length != 3) {
                throw new IllegalArgumentException("Invalid JWT token");
            }
            String payload = new String(Base64.getUrlDecoder().decode(parts[1]), StandardCharsets.UTF_8);
            JSONObject payloadJson = new JSONObject(payload);
            String userId = payloadJson.getString("sub");
            logger.debug(userId + "...userId from crashplan:" + userId);
            aadUserElement.setUserName(userId);
            aadUserElement.setUserPrincipalName(userId);
            aadUserElement.setMail(userId);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("Failed to decode access token: " + e.getMessage());
        }
        return aadUserElement;
    }

    public AADUserElement getAADUserByCodeForCrashPlan(String code, IdentityProviderSettings aadCredentials) {
        AADUserElement aadUserElement;
        block22: {
            aadUserElement = null;
            try {
                BufferedReader br;
                String loginUrl = aadCredentials.getEndpointRedirectURI() + "/api/v3/oauth/token";
                URL url = URI.create(loginUrl).toURL();
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("POST");
                connection.setRequestProperty(CONTENT_TYPE, "application/x-www-form-urlencoded");
                connection.setRequestProperty("Authorization", this.getBasicAuthHeader(aadCredentials));
                connection.setDoOutput(true);
                String postData = "grant_type=authorization_code&code=" + code + "&nonce=67b704cc7bb57e09e49a6c6f";
                try (OutputStream os = connection.getOutputStream();){
                    byte[] input = postData.getBytes(StandardCharsets.UTF_8);
                    os.write(input, 0, input.length);
                }
                int responseCode = connection.getResponseCode();
                logger.debug(loginUrl + "..response code:" + responseCode);
                if (responseCode == 200) {
                    br = new BufferedReader(new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));
                    try {
                        String responseLine;
                        StringBuilder response = new StringBuilder();
                        while ((responseLine = br.readLine()) != null) {
                            response.append(responseLine.trim());
                        }
                        logger.debug("response:" + String.valueOf(response));
                        String accessToken = new JSONObject(response.toString()).getString("access_token");
                        logger.debug("accessToken:" + accessToken);
                        aadUserElement = this.getAADUserElementByAccessTokenForCrashplan(accessToken);
                        break block22;
                    }
                    finally {
                        br.close();
                    }
                }
                br = new BufferedReader(new InputStreamReader(connection.getErrorStream(), StandardCharsets.UTF_8));
                try {
                    String errorLine;
                    StringBuilder errorResponse = new StringBuilder();
                    while ((errorLine = br.readLine()) != null) {
                        errorResponse.append(errorLine.trim());
                    }
                    logger.error("Error: " + errorResponse.toString());
                }
                finally {
                    br.close();
                }
            }
            catch (Exception e) {
                logger.error("Error getting the access token from crashplan:", (Throwable)e);
                e.printStackTrace();
            }
        }
        return aadUserElement;
    }

    private String getBasicAuthHeader(IdentityProviderSettings aadCredentials) {
        String auth = aadCredentials.getClientId() + ":" + aadCredentials.getSecretKey();
        return "Basic " + Base64.getEncoder().encodeToString(auth.getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public void syncGmailGroups(Cloud cloud) {
        int cloudId = cloud.getCloudId();
        CloudProperties cloudProperties = this.cloudDao.getCloudProperties(cloudId);
        IdentityProviderSettings aadCredentials = this.aadDao.getAADCredentials(cloudId);
        AADAuthorizationToken authToken = this.aadDao.getAADAuthorizationtoken(cloudId);
        boolean success = false;
        try {
            AADUserElement aadUserElement;
            logger.debug("inside sync gmail groups.....");
            success = this.aadDao.getServiceAccountJson(cloudId, this.registry.get(cloudId).getPropertyFileValueParacloudMountPoint() + "Serviceaccount", "serviceaccount.json");
            if (!success) {
                logger.error("error getting the service account file..");
                return;
            }
            IdentityProviderSettings workspaceSettings = this.aadDao.getGworkspaceSettings(cloudId);
            logger.debug("admin email name:" + workspaceSettings.getAdminMail());
            NetHttpTransport HTTP_TRANSPORT = GoogleNetHttpTransport.newTrustedTransport();
            ArrayList<String> collection = new ArrayList<String>();
            collection.add("https://www.googleapis.com/auth/admin.directory.group.readonly");
            collection.add("https://www.googleapis.com/auth/admin.directory.user.readonly");
            FileInputStream keyFileStream = new FileInputStream(this.registry.get(cloudId).getPropertyFileValueParacloudMountPoint() + "Serviceaccount/serviceaccount.json");
            ArrayList<AADUserElement> aadUserElements = new ArrayList<AADUserElement>();
            GoogleCredentials credentials = GoogleCredentials.fromStream((InputStream)keyFileStream).createScoped(collection).createDelegated(workspaceSettings.getAdminMail());
            HttpCredentialsAdapter requestInitializer = new HttpCredentialsAdapter((Credentials)credentials);
            Directory service = new Directory.Builder((HttpTransport)HTTP_TRANSPORT, JSON_FACTORY, (HttpRequestInitializer)requestInitializer).setApplicationName("Directory API Service Account").build();
            boolean isManyToManyEnabled = workspaceSettings.isManyToManyMappingEnabled();
            for (GroupMapping groupConfig : workspaceSettings.getGroupMapping()) {
                try {
                    Members members;
                    Directory.Members.List request = service.members().list(groupConfig.getGroupName());
                    do {
                        List memberList;
                        if ((memberList = (members = (Members)request.execute()).getMembers()) == null || memberList.isEmpty()) {
                            logger.debug("No members found in the group.");
                            continue;
                        }
                        logger.debug("Members of the group '" + String.valueOf(groupConfig) + "':");
                        for (Member member : memberList) {
                            aadUserElement = new AADUserElement();
                            for (AADUserElement aadUserElement1 : aadUserElements) {
                                if (!aadUserElement1.getMail().equalsIgnoreCase(member.getEmail())) continue;
                                aadUserElement = aadUserElement1;
                                aadUserElements.remove(aadUserElement1);
                                break;
                            }
                            logger.debug(member.getEmail());
                            aadUserElement.setUserName(member.getEmail());
                            aadUserElement.setUserPrincipalName(member.getEmail());
                            aadUserElement.setMail(member.getEmail());
                            if (groupConfig.getProductType().equalsIgnoreCase(CPHelperConstant.PARABLU_PRODUCT_TYPE.GMAIL.getProductType())) {
                                aadUserElement.setGmailBkpEnabled(true);
                                if (isManyToManyEnabled) {
                                    aadUserElement.setDefaultGmailPolicy(groupConfig.getPolicyName());
                                } else {
                                    aadUserElement.setDefaultGmailPolicy(this.registry.get(cloud.getCloudId()).getDefaultGmailPolicy());
                                }
                            }
                            if (groupConfig.getProductType().equalsIgnoreCase(CPHelperConstant.PARABLU_PRODUCT_TYPE.GOOGLEDRIVE.getProductType())) {
                                aadUserElement.setGdriveBkpEnabled(true);
                                if (isManyToManyEnabled) {
                                    aadUserElement.setDefaultGdrivePolicy(groupConfig.getPolicyName());
                                } else {
                                    aadUserElement.setDefaultGdrivePolicy(this.registry.get(cloud.getCloudId()).getDefaultGdrivePolicyName());
                                }
                            }
                            if (groupConfig.getProductType().equalsIgnoreCase(CPHelperConstant.PARABLU_PRODUCT_TYPE.EXCHANGE.getProductType())) {
                                aadUserElement.setExchangeBkpEnabled(true);
                                if (isManyToManyEnabled) {
                                    aadUserElement.setDefaultExchangePolicy(groupConfig.getPolicyName());
                                } else {
                                    aadUserElement.setDefaultExchangePolicy(this.registry.get(cloud.getCloudId()).getPropertyFileValueDefaultExchangePolicy());
                                }
                            }
                            if (groupConfig.getProductType().equalsIgnoreCase(CPHelperConstant.PARABLU_PRODUCT_TYPE.ODB.getProductType())) {
                                aadUserElement.setOnedriveBkpEnabled(true);
                                if (isManyToManyEnabled) {
                                    aadUserElement.setDefaultOdbPolicy(groupConfig.getPolicyName());
                                } else {
                                    aadUserElement.setDefaultOdbPolicy(this.registry.get(cloud.getCloudId()).getPropertyFileValueDefaultOdbPolicy());
                                }
                            }
                            if (groupConfig.getProductType().equalsIgnoreCase(CPHelperConstant.PARABLU_PRODUCT_TYPE.BACKUP.getProductType())) {
                                aadUserElement.setBackupEnabled(true);
                                if (isManyToManyEnabled) {
                                    aadUserElement.setDefaultPolicy(groupConfig.getPolicyName());
                                } else {
                                    aadUserElement.setDefaultPolicy(this.registry.get(cloud.getCloudId()).getPropertyFileValueDefaultBkpPolicy());
                                }
                            }
                            if (groupConfig.getProductType().equalsIgnoreCase(CPHelperConstant.PARABLU_PRODUCT_TYPE.SYNC.getProductType())) {
                                aadUserElement.setSyncEnabled(true);
                                if (isManyToManyEnabled) {
                                    aadUserElement.setDefaultSyncPolicy(groupConfig.getPolicyName());
                                } else {
                                    aadUserElement.setDefaultSyncPolicy(this.registry.get(cloud.getCloudId()).getPropertyFileValueDefaultSyncPolicy());
                                }
                            }
                            if (StringUtils.isEmpty((CharSequence)aadUserElement.getDefaultGdrivePolicy())) {
                                aadUserElement.setDefaultGdrivePolicy(this.registry.get(cloud.getCloudId()).getDefaultGdrivePolicyName());
                            }
                            if (StringUtils.isEmpty((CharSequence)aadUserElement.getDefaultGmailPolicy())) {
                                aadUserElement.setDefaultGmailPolicy(this.registry.get(cloud.getCloudId()).getDefaultGmailPolicy());
                            }
                            if (StringUtils.isEmpty((CharSequence)aadUserElement.getDefaultOdbPolicy())) {
                                aadUserElement.setDefaultOdbPolicy(this.registry.get(cloud.getCloudId()).getPropertyFileValueDefaultOdbPolicy());
                            }
                            if (StringUtils.isEmpty((CharSequence)aadUserElement.getDefaultExchangePolicy())) {
                                aadUserElement.setDefaultExchangePolicy(this.registry.get(cloudId).getPropertyFileValueDefaultExchangePolicy());
                            }
                            if (StringUtils.isEmpty((CharSequence)aadUserElement.getDefaultSharepointPolicy())) {
                                aadUserElement.setDefaultSharepointPolicy(this.registry.get(cloudId).getPropertyFileValueDefaultSpPolicy());
                            }
                            if (StringUtils.isEmpty((CharSequence)aadUserElement.getDefaultPolicy())) {
                                aadUserElement.setDefaultPolicy(this.registry.get(cloudId).getPropertyFileValueDefaultBkpPolicy());
                            }
                            if (StringUtils.isEmpty((CharSequence)aadUserElement.getDefaultSyncPolicy())) {
                                aadUserElement.setDefaultSyncPolicy(this.registry.get(cloudId).getPropertyFileValueDefaultSyncPolicy());
                            }
                            aadUserElements.add(aadUserElement);
                            request.setPageToken(members.getNextPageToken());
                        }
                    } while (members.getNextPageToken() != null);
                }
                catch (IOException e) {
                    logger.error(".error......", (Throwable)e);
                }
            }
            Map<String, AADUserElement> aadMap = aadUserElements.stream().collect(Collectors.toMap(aaduser -> aaduser.getUserPrincipalName().toLowerCase(), aaduser -> aaduser));
            Map<Object, Object> aadMapWithEmail = new HashMap();
            try {
                aadMapWithEmail = aadUserElements.stream().filter(aaduser -> aaduser.getMail() != null).collect(Collectors.toMap(aaduser -> aaduser.getMail().toLowerCase(), aaduser -> aaduser));
                logger.debug("after convert to aadMapWithEmail..." + aadMapWithEmail.size());
            }
            catch (Exception e) {
                logger.error("error getting the mail add:", (Throwable)e);
            }
            List allUsers = this.userDao.getAllUsers(cloudId);
            ArrayList<User> guestUsers = new ArrayList<User>();
            HashMap<String, User> userMap = new HashMap<String, User>();
            for (User user : allUsers) {
                if (!user.isLocalUser() && !user.isGuest()) {
                    String userName = user.getUserName();
                    if (!org.springframework.util.StringUtils.isEmpty((Object)user.getAadLoginId())) {
                        userName = user.getAadLoginId();
                    }
                    userMap.put(userName.toLowerCase(), user);
                    continue;
                }
                if (!user.isGuest()) continue;
                guestUsers.add(user);
            }
            for (User user : guestUsers) {
                logger.debug("guest user..." + user.getUserName());
                logger.debug("guest user.mail.." + user.getEmailId());
                if (aadMap.containsKey(user.getUserName()) || aadMap.containsKey(user.getUserName().toLowerCase())) {
                    logger.debug("removeUserbyID.........." + String.valueOf(user.getUserId()));
                    this.userDao.removeUserbyID(cloudId, user.getUserId().toString());
                    continue;
                }
                if (!aadMapWithEmail.containsKey(user.getUserName().toLowerCase()) && !aadMapWithEmail.containsKey(user.getUserName())) continue;
                logger.debug("removeUserbyID.........." + String.valueOf(user.getUserId()));
                this.userDao.removeUserbyID(cloudId, user.getUserId().toString());
            }
            logger.debug(aadMap.size() + ".....map diff ..." + userMap.size());
            for (Map.Entry entry : userMap.entrySet()) {
                User existingUser = (User)entry.getValue();
                if (aadMap.containsKey(entry.getKey())) {
                    long totalBkpUsers;
                    int noOfBkpUsersAllowed;
                    long totalSyncUsers;
                    int noOfSyncUsersAllowed;
                    long totalExchangekpUsers;
                    int noOfExchangeUsersAllowed;
                    long totalOdbBkpUsers;
                    int noOfOneDriveUsersAllowed;
                    AADUserElement aadUserElement2 = aadMap.get(entry.getKey());
                    logger.debug("...already in user iteration..." + (String)entry.getKey());
                    boolean anyChange = false;
                    if (!anyChange && aadUserElement2.isGmailBkpEnabled() != existingUser.isGmailBkpEnabled()) {
                        anyChange = true;
                    }
                    if (!anyChange && aadUserElement2.isGdriveBkpEnabled() != existingUser.isGdriveBkpEnabled()) {
                        anyChange = true;
                    }
                    if (!anyChange && aadUserElement2.isOnedriveBkpEnabled() != existingUser.isOnedriveBkpEnabled()) {
                        anyChange = true;
                    }
                    if (!anyChange && aadUserElement2.isExchangeBkpEnabled() != existingUser.isExchangeBkpEnabled()) {
                        anyChange = true;
                    }
                    if (!anyChange && aadUserElement2.isSharePointBkpEnabled() != existingUser.isSharePointBkpEnabled()) {
                        anyChange = true;
                    }
                    if (!anyChange && aadUserElement2.isBackupEnabled() != existingUser.isBackupEnabled()) {
                        anyChange = true;
                    }
                    if (!anyChange && aadUserElement2.isSyncEnabled() != existingUser.isSyncEnabled()) {
                        anyChange = true;
                    }
                    if (existingUser.isSoftBlockEnabled()) {
                        anyChange = true;
                    }
                    if (!anyChange) continue;
                    logger.debug("...inside anyChange...........");
                    if (aadUserElement2.isGmailBkpEnabled() && this.isLiecnseEnabled(cloud.getCloudCustomisableDetails(), GMAIL_BACKUP_ENABLED) && ((long)(noOfOneDriveUsersAllowed = cloud.getNoOfGmailUsersAllowed()) == (totalOdbBkpUsers = this.userDao.countOfPresentGmailBackupUsers(cloud.getCloudId(), "", true)) && !existingUser.isGmailBkpEnabled() || (long)noOfOneDriveUsersAllowed < totalOdbBkpUsers)) {
                        logger.debug("gmail  USER LIMIT REACHED........");
                        aadUserElement2.setGmailBkpEnabled(false);
                    }
                    if (aadUserElement2.isGdriveBkpEnabled() && this.isLiecnseEnabled(cloud.getCloudCustomisableDetails(), GDRIVE_BACKUP_ENABLED) && ((long)(noOfExchangeUsersAllowed = cloud.getNoOfGdriveUsersAllowed()) == (totalExchangekpUsers = this.userDao.countOfPresentGdriveBackupUsers(cloud.getCloudId(), "", true)) && !existingUser.isGdriveBkpEnabled() || (long)noOfExchangeUsersAllowed < totalExchangekpUsers)) {
                        logger.debug("gdrive USER LIMIT REACHED........");
                        aadUserElement2.setGdriveBkpEnabled(false);
                    }
                    if (aadUserElement2.isSyncEnabled() && ((long)(noOfSyncUsersAllowed = cloud.getNoOfSyncUsersAllowed()) == (totalSyncUsers = this.userDao.countOfPresentSyncUsers(cloud.getCloudId(), cloud.getCloudName(), true)) && !existingUser.isSyncEnabled() || (long)noOfSyncUsersAllowed < totalSyncUsers)) {
                        logger.debug(" SYNC USER LIMIT REACHED........");
                        aadUserElement2.setSyncEnabled(false);
                    }
                    if (aadUserElement2.isOnedriveBkpEnabled() && this.isLiecnseEnabled(cloud.getCloudCustomisableDetails(), ODB_BACKUP_ENABLED) && ((long)(noOfOneDriveUsersAllowed = cloud.getNoOfOneDriveUsersAllowed()) == (totalOdbBkpUsers = this.userDao.countOfPresentOnedriveUsers(cloud.getCloudId(), true)) && !existingUser.isOnedriveBkpEnabled() || (long)noOfOneDriveUsersAllowed < totalOdbBkpUsers)) {
                        logger.debug("onedrive  USER LIMIT REACHED........");
                        aadUserElement2.setOnedriveBkpEnabled(false);
                    }
                    if (aadUserElement2.isExchangeBkpEnabled() && this.isLiecnseEnabled(cloud.getCloudCustomisableDetails(), EXCHANGE_BACKUP_ENABLED) && ((long)(noOfExchangeUsersAllowed = cloud.getNoOfExchangeUsersAllowed()) == (totalExchangekpUsers = this.userDao.countOfPresentExchangeUsers(cloud.getCloudId(), true)) && !existingUser.isExchangeBkpEnabled() || (long)noOfExchangeUsersAllowed < totalExchangekpUsers)) {
                        logger.debug("exchange USER LIMIT REACHED........");
                        aadUserElement2.setExchangeBkpEnabled(false);
                    }
                    if (aadUserElement2.isBackupEnabled() && ((long)(noOfBkpUsersAllowed = cloud.getNoOfBackupUsersAllowed()) == (totalBkpUsers = this.userDao.countOfPresentBackupUsers(cloud.getCloudId(), cloud.getCloudName(), true, true)) && !existingUser.isBackupEnabled() || (long)noOfBkpUsersAllowed < totalBkpUsers)) {
                        logger.debug(" BACKUP USER LIMIT REACHED........");
                        aadUserElement2.setBackupEnabled(false);
                    }
                    boolean previStatus = existingUser.isActive();
                    existingUser.setGmailBkpEnabled(aadUserElement2.isGmailBkpEnabled());
                    existingUser.setGdriveBkpEnabled(aadUserElement2.isGdriveBkpEnabled());
                    existingUser.setOnedriveBkpEnabled(aadUserElement2.isOnedriveBkpEnabled());
                    existingUser.setExchangeBkpEnabled(aadUserElement2.isExchangeBkpEnabled());
                    existingUser.setShareEnabled(aadUserElement2.isSharePointBkpEnabled());
                    existingUser.setBackupEnabled(aadUserElement2.isBackupEnabled());
                    existingUser.setSyncEnabled(aadUserElement2.isSyncEnabled());
                    existingUser.setSoftBlockEnabled(false);
                    existingUser.setActive(true);
                    this.userDao.saveUser(cloud.getCloudId(), cloud.getCloudName(), existingUser);
                    this.deviceDao.updateUserStatusInDeviceBkpOverview(cloudId, existingUser.getUserName(), Boolean.valueOf(existingUser.isActive()));
                    this.blockDevice(existingUser, cloud.getCloudName(), cloudId);
                    this.setAuditForAADBlockedOrUnblocked(cloud.getCloudId(), cloud.getCloudName(), existingUser.getUserName(), existingUser.isActive(), previStatus);
                    continue;
                }
                logger.debug("...inside blocking existing user" + (String)entry.getKey());
                if (cloudProperties != null && cloudProperties.isSoftBlockEnabled()) {
                    if (existingUser.isSoftBlockEnabled()) continue;
                    existingUser.setSoftBlockEnabled(true);
                    existingUser.setSoftBlockedTime(System.currentTimeMillis());
                    this.userDao.saveUser(cloud.getCloudId(), cloud.getCloudName(), existingUser);
                    continue;
                }
                boolean previStatus = existingUser.isActive();
                existingUser.setGmailBkpEnabled(false);
                existingUser.setGdriveBkpEnabled(false);
                existingUser.setOnedriveBkpEnabled(false);
                existingUser.setExchangeBkpEnabled(false);
                existingUser.setShareEnabled(false);
                existingUser.setBackupEnabled(false);
                existingUser.setSyncEnabled(false);
                existingUser.setActive(false);
                this.userDao.saveUser(cloud.getCloudId(), cloud.getCloudName(), existingUser);
                this.deviceDao.updateUserInfoInDeviceBkpOverview(cloud.getCloudId(), existingUser);
                this.setAuditForAADBlockedOrUnblocked(cloud.getCloudId(), cloud.getCloudName(), existingUser.getUserName(), existingUser.isActive(), previStatus);
                this.changeDeviceStatusAndAduit(cloud, existingUser);
            }
            for (Map.Entry entry : aadMap.entrySet()) {
                if (userMap.containsKey(entry.getKey())) continue;
                logger.debug("...adding new user to user collection..." + (String)entry.getKey());
                aadUserElement = aadMap.get(entry.getKey());
                this.updateOrCreateAADUserInfo(cloud, aadUserElement, aadCredentials);
            }
        }
        catch (IOException | GeneralSecurityException e) {
            logger.error("Service account json not found.", (Throwable)e);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean saveServiceAccountFileInDb(int cloudId, String fileName, String filePath) {
        File f = null;
        try {
            this.aadDao.saveJsonFile(cloudId, fileName, filePath, System.currentTimeMillis());
            f = new File(filePath + "/" + fileName);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            logger.error("error to save file .." + e.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            if (f.exists()) {
                f.delete();
            }
        }
    }

    private AADUserElement getAADUserByCodeForGoogle(String code, Cloud cloud) {
        AADUserElement aadUserElement = new AADUserElement();
        try {
            logger.info("google login");
            IdentityProviderSettings aadCredentials = this.aadDao.getAADCredentials(cloud.getCloudId());
            if (aadCredentials.getLoginMode().equalsIgnoreCase("GOOGLE")) {
                String tokenUrl = "https://oauth2.googleapis.com/token";
                HttpHeaders headers = new HttpHeaders();
                headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
                LinkedMultiValueMap body = new LinkedMultiValueMap();
                body.add((Object)"code", (Object)code);
                body.add((Object)"client_id", (Object)aadCredentials.getClientId());
                body.add((Object)"client_secret", (Object)aadCredentials.getSecretKey());
                body.add((Object)"redirect_uri", (Object)aadCredentials.getPortalRedirectURI());
                body.add((Object)"grant_type", (Object)AUTHORIZATION_CODE);
                org.springframework.http.HttpEntity request = new org.springframework.http.HttpEntity((Object)body, (MultiValueMap)headers);
                ResponseEntity response = this.restTemplate.postForEntity(tokenUrl, (Object)request, String.class, new Object[0]);
                ObjectMapper mapper = new ObjectMapper();
                JsonNode rootNode = mapper.readTree((String)response.getBody());
                String idToken = rootNode.get("id_token").asText();
                logger.info("google login: token generate success");
                ResponseEntity responseEntity = this.restTemplate.getForEntity("https://www.googleapis.com/oauth2/v3/tokeninfo?id_token=" + idToken, String.class, new Object[0]);
                if (responseEntity.getStatusCode().is2xxSuccessful()) {
                    JsonNode rootNode1 = mapper.readTree((String)responseEntity.getBody());
                    logger.info("google login: got user id from google:" + rootNode1.get("email").asText());
                    aadUserElement.setUserName(rootNode1.get("email").asText());
                    aadUserElement.setUserPrincipalName(rootNode1.get("email").asText());
                    aadUserElement.setMail(rootNode1.get("email").asText());
                    aadUserElement = this.getGmailUserfromGoogleWorkspace(cloud, rootNode1.get("email").asText(), aadUserElement);
                }
            }
        }
        catch (Exception e) {
            logger.error("Error getting the access token from google:", (Throwable)e);
            e.printStackTrace();
        }
        return aadUserElement;
    }

    private AADUserElement getGmailUserfromGoogleWorkspace(Cloud cloud, String userName, AADUserElement aadUserElement) {
        try {
            IdentityProviderSettings workspaceSettings = this.aadDao.getGworkspaceSettings(cloud.getCloudId());
            logger.debug("admin email name:" + workspaceSettings.getAdminMail());
            NetHttpTransport HTTP_TRANSPORT = null;
            HTTP_TRANSPORT = GoogleNetHttpTransport.newTrustedTransport();
            ArrayList<String> collection = new ArrayList<String>();
            collection.add("https://www.googleapis.com/auth/admin.directory.group.readonly");
            collection.add("https://www.googleapis.com/auth/admin.directory.user.readonly");
            FileInputStream keyFileStream = null;
            keyFileStream = new FileInputStream(this.registry.get(cloud.getCloudId()).getPropertyFileValueParacloudMountPoint() + "Serviceaccount/serviceaccount.json");
            ArrayList aadUserElements = new ArrayList();
            GoogleCredentials credentials = null;
            credentials = GoogleCredentials.fromStream((InputStream)keyFileStream).createScoped(collection).createDelegated(workspaceSettings.getAdminMail());
            HttpCredentialsAdapter requestInitializer = new HttpCredentialsAdapter((Credentials)credentials);
            Directory service = new Directory.Builder((HttpTransport)HTTP_TRANSPORT, JSON_FACTORY, (HttpRequestInitializer)requestInitializer).setApplicationName("Directory API Service Account").build();
            logger.debug(String.valueOf(workspaceSettings.getGroupMapping()) + "admin email name:" + workspaceSettings.getAdminMail());
            if (CollectionUtils.isEmpty((Collection)workspaceSettings.getGroupMapping())) {
                this.setLicensesToUser(cloud, aadUserElement, workspaceSettings);
                return aadUserElement;
            }
            boolean isManyToManyEnabled = workspaceSettings.isManyToManyMappingEnabled();
            for (GroupMapping group : workspaceSettings.getGroupMapping()) {
                try {
                    if (!org.springframework.util.StringUtils.isEmpty((Object)group.getGroupName())) {
                        Member member = (Member)service.members().get(group.getGroupName(), userName).execute();
                        if (group.getProductType().equalsIgnoreCase(CPHelperConstant.PARABLU_PRODUCT_TYPE.GOOGLEDRIVE.getProductType())) {
                            aadUserElement.setGdriveBkpEnabled(true);
                            if (isManyToManyEnabled) {
                                aadUserElement.setDefaultGdrivePolicy(group.getPolicyName());
                            } else {
                                aadUserElement.setDefaultGdrivePolicy(this.registry.get(cloud.getCloudId()).getDefaultGdrivePolicyName());
                            }
                        }
                        if (group.getProductType().equalsIgnoreCase(CPHelperConstant.PARABLU_PRODUCT_TYPE.GMAIL.getProductType())) {
                            aadUserElement.setGmailBkpEnabled(true);
                            if (isManyToManyEnabled) {
                                aadUserElement.setDefaultGmailPolicy(group.getPolicyName());
                            } else {
                                aadUserElement.setDefaultGmailPolicy(this.registry.get(cloud.getCloudId()).getDefaultGmailPolicy());
                            }
                        }
                        if (group.getProductType().equalsIgnoreCase(CPHelperConstant.PARABLU_PRODUCT_TYPE.EXCHANGE.getProductType())) {
                            aadUserElement.setExchangeBkpEnabled(true);
                            if (isManyToManyEnabled) {
                                aadUserElement.setDefaultExchangePolicy(group.getPolicyName());
                            } else {
                                aadUserElement.setDefaultExchangePolicy(this.registry.get(cloud.getCloudId()).getPropertyFileValueDefaultExchangePolicy());
                            }
                        }
                        if (group.getProductType().equalsIgnoreCase(CPHelperConstant.PARABLU_PRODUCT_TYPE.ODB.getProductType())) {
                            aadUserElement.setOnedriveBkpEnabled(true);
                            if (isManyToManyEnabled) {
                                aadUserElement.setDefaultOdbPolicy(group.getPolicyName());
                            } else {
                                aadUserElement.setDefaultOdbPolicy(this.registry.get(cloud.getCloudId()).getPropertyFileValueDefaultOdbPolicy());
                            }
                        }
                        if (group.getProductType().equalsIgnoreCase(CPHelperConstant.PARABLU_PRODUCT_TYPE.SHAREPOINT.getProductType())) {
                            aadUserElement.setSharePointBkpEnabled(true);
                            if (isManyToManyEnabled) {
                                aadUserElement.setDefaultSharepointPolicy(group.getPolicyName());
                            } else {
                                aadUserElement.setDefaultSharepointPolicy(this.registry.get(cloud.getCloudId()).getPropertyFileValueDefaultSpPolicy());
                            }
                        }
                        if (group.getProductType().equalsIgnoreCase(CPHelperConstant.PARABLU_PRODUCT_TYPE.BACKUP.getProductType())) {
                            aadUserElement.setBackupEnabled(true);
                            if (isManyToManyEnabled) {
                                aadUserElement.setDefaultPolicy(group.getPolicyName());
                            } else {
                                aadUserElement.setDefaultPolicy(this.registry.get(cloud.getCloudId()).getPropertyFileValueDefaultBkpPolicy());
                            }
                        }
                        if (group.getProductType().equalsIgnoreCase(CPHelperConstant.PARABLU_PRODUCT_TYPE.SYNC.getProductType())) {
                            aadUserElement.setSyncEnabled(true);
                            if (isManyToManyEnabled) {
                                aadUserElement.setDefaultSyncPolicy(group.getPolicyName());
                            } else {
                                aadUserElement.setDefaultSyncPolicy(this.registry.get(cloud.getCloudId()).getPropertyFileValueDefaultSyncPolicy());
                            }
                        }
                        logger.debug("member present::::" + member.getEmail());
                        continue;
                    }
                    logger.debug("Set licenses since group name is empty");
                    this.setLicensesToUser(cloud, aadUserElement, workspaceSettings);
                }
                catch (GoogleJsonResponseException e) {
                    logger.error("error:", (Throwable)e);
                    if (e.getStatusCode() != 404) continue;
                    logger.error("User not part of the group:" + userName);
                }
                catch (IOException e) {
                    logger.error("Unable to get the user details:", (Throwable)e);
                    e.printStackTrace();
                }
            }
        }
        catch (IOException | GeneralSecurityException e) {
            logger.error("couldn't get group details", (Throwable)e);
        }
        return aadUserElement;
    }

    private void setLicensesToUser(Cloud cloud, AADUserElement aadUserElement, IdentityProviderSettings workspaceSettings) {
        if (this.isLiecnseEnabled(cloud.getCloudCustomisableDetails(), GMAIL_BACKUP_ENABLED)) {
            aadUserElement.setGmailBkpEnabled(true);
        }
        if (this.isLiecnseEnabled(cloud.getCloudCustomisableDetails(), GDRIVE_BACKUP_ENABLED)) {
            aadUserElement.setGdriveBkpEnabled(true);
        }
        if (this.isLiecnseEnabled(cloud.getCloudCustomisableDetails(), ODB_BACKUP_ENABLED)) {
            aadUserElement.setOnedriveBkpEnabled(true);
        }
        if (this.isLiecnseEnabled(cloud.getCloudCustomisableDetails(), EXCHANGE_BACKUP_ENABLED)) {
            aadUserElement.setExchangeBkpEnabled(true);
        }
        if (this.isLiecnseEnabled(cloud.getCloudCustomisableDetails(), SHARE_POINT_BACKUP_ENABLED)) {
            aadUserElement.setSharePointBkpEnabled(true);
        }
        if (this.isLiecnseEnabled(cloud.getCloudCustomisableDetails(), SYNC_ENABLED)) {
            aadUserElement.setSyncEnabled(true);
        }
        if (this.isLiecnseEnabled(cloud.getCloudCustomisableDetails(), BACK_UP_ENABLED)) {
            aadUserElement.setBackupEnabled(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isAADUserValid(String userName, int cloudId, IdentityProviderSettings workspaceSettings) {
        boolean bl;
        CloseableHttpResponse result;
        HttpGet httpGet;
        CloseableHttpClient httpclient;
        block24: {
            block25: {
                boolean routePlanner22;
                block22: {
                    block23: {
                        boolean routePlanner22;
                        block20: {
                            block21: {
                                block26: {
                                    AADAuthorizationToken authToken = this.aadDao.getAADAuthorizationtoken(cloudId);
                                    if (authToken == null || org.springframework.util.StringUtils.isEmpty((Object)authToken.getAccess_token())) {
                                        logger.debug("aadAuthToken or accessToken is empty so return....");
                                        return false;
                                    }
                                    StringBuilder response = new StringBuilder();
                                    httpclient = null;
                                    httpGet = null;
                                    result = null;
                                    ObjectMapper mapper = new ObjectMapper();
                                    try {
                                        mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
                                        String url = this.getUserInfoUrl(userName);
                                        logger.debug("url to get the user from aad:" + url);
                                        Proxy proxy = this.settingsDao.getProxy(cloudId);
                                        if (proxy != null || !org.springframework.util.StringUtils.isEmpty((Object)this.registry.get(cloudId).getProxyHost()) && !org.springframework.util.StringUtils.isEmpty((Object)this.registry.get(cloudId).getProxyPort())) {
                                            logger.debug("host :" + this.registry.get(cloudId).getProxyHost());
                                            logger.debug("port :" + this.registry.get(cloudId).getProxyPort());
                                            HttpHost proxyval = new HttpHost(this.registry.get(cloudId).getProxyHost(), this.registry.get(cloudId).getProxyPort(), "http");
                                            DefaultProxyRoutePlanner routePlanner22 = new DefaultProxyRoutePlanner(proxyval);
                                            httpclient = HttpClients.custom().setRoutePlanner((HttpRoutePlanner)routePlanner22).build();
                                        } else {
                                            httpclient = HttpClients.custom().build();
                                        }
                                        httpGet = new HttpGet(url);
                                        httpGet.addHeader("Authorization", "Bearer " + authToken.getAccess_token());
                                        httpGet.addHeader("Accept", "application/json");
                                        result = httpclient.execute((HttpUriRequest)httpGet);
                                        if (workspaceSettings == null || CollectionUtils.isEmpty((Collection)workspaceSettings.getGroupMapping())) {
                                            int httpResponseCode = result.getStatusLine().getStatusCode();
                                            if (httpResponseCode == 200) {
                                                logger.debug("..........user found........");
                                                routePlanner22 = true;
                                                if (httpGet == null) break block20;
                                                break block21;
                                            }
                                            logger.debug("..........user not fount.........");
                                            routePlanner22 = false;
                                            if (httpGet == null) break block22;
                                            break block23;
                                        }
                                        int httpResponseCode = result.getStatusLine().getStatusCode();
                                        if (httpResponseCode == 200) {
                                            logger.debug("..........user found........");
                                            List<String> userMemberList = this.getAADUserGroupInfo(cloudId, userName, authToken);
                                            if (!CollectionUtils.isEmpty(userMemberList)) {
                                                for (String group : userMemberList) {
                                                    logger.debug("User is memeber of ............" + group.toLowerCase());
                                                    for (GroupMapping mapping : workspaceSettings.getGroupMapping()) {
                                                        String groupName = mapping.getGroupName();
                                                        if (!groupName.equals(group)) continue;
                                                        boolean bl2 = true;
                                                        if (httpGet != null) {
                                                            httpGet.releaseConnection();
                                                        }
                                                        this.closeResponse(result);
                                                        this.closeHttpClient(httpclient);
                                                        return bl2;
                                                    }
                                                }
                                            }
                                        } else {
                                            logger.debug("..........user not found.........");
                                            bl = false;
                                            if (httpGet == null) break block24;
                                            break block25;
                                        }
                                        if (httpGet == null) break block26;
                                    }
                                    catch (Exception e) {
                                        logger.trace(String.valueOf(e));
                                        logger.error(" ERROR trying to get AADUser From UserName " + e.getMessage());
                                        boolean bl3 = false;
                                        return bl3;
                                    }
                                    httpGet.releaseConnection();
                                }
                                this.closeResponse(result);
                                this.closeHttpClient(httpclient);
                                return false;
                            }
                            httpGet.releaseConnection();
                        }
                        this.closeResponse(result);
                        this.closeHttpClient(httpclient);
                        return routePlanner22;
                    }
                    httpGet.releaseConnection();
                }
                this.closeResponse(result);
                this.closeHttpClient(httpclient);
                return routePlanner22;
            }
            httpGet.releaseConnection();
        }
        this.closeResponse(result);
        this.closeHttpClient(httpclient);
        return bl;
        finally {
            if (httpGet != null) {
                httpGet.releaseConnection();
            }
            this.closeResponse(result);
            this.closeHttpClient(httpclient);
        }
    }

    public static List<String> extractGroupNames(String responseBody, IdentityProviderSettings aadCredentials1) {
        ObjectMapper mapper = new ObjectMapper();
        ArrayList<String> groupNames = new ArrayList<String>();
        try {
            JsonNode root = mapper.readTree(responseBody);
            List<String> groupIdsFromApp = AADManagementServiceImpl.getGroupNamesFromApp(aadCredentials1.getTenentId(), aadCredentials1.getApiToken(), aadCredentials1.getClientId());
            for (JsonNode groupNode : root) {
                JsonNode nameNode = groupNode.path("profile").path("name");
                String groupId = groupNode.path("id").asText();
                if (org.springframework.util.StringUtils.isEmpty((Object)groupId) || !groupIdsFromApp.contains(groupId) || nameNode.isMissingNode()) continue;
                groupNames.add(nameNode.asText().toLowerCase());
            }
        }
        catch (JsonMappingException e) {
            logger.error("error to get groupNames..." + String.valueOf((Object)e));
        }
        catch (JsonProcessingException e) {
            logger.error("error to get groupNames..." + String.valueOf((Object)e));
        }
        catch (Exception e) {
            logger.error("error to get groupNames..." + String.valueOf(e));
        }
        return groupNames;
    }

    public static List<String> extractGroupIDs(String responseBody) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        JsonNode root = mapper.readTree(responseBody);
        ArrayList<String> groupIds = new ArrayList<String>();
        for (JsonNode groupNode : root) {
            String groupId = groupNode.path("id").asText();
            groupIds.add(groupId);
        }
        return groupIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getoktaGroupNamesfromUserId(int cloudId, IdentityProviderSettings aadCredentials1, String userId) {
        List<String> groupNames;
        block11: {
            CloseableHttpResponse result;
            CloseableHttpClient httpclient;
            block10: {
                StringBuilder response = new StringBuilder();
                httpclient = null;
                HttpGet httpGet = null;
                result = null;
                groupNames = new ArrayList<String>();
                try {
                    String tenantID = aadCredentials1.getTenentId();
                    String clientID = aadCredentials1.getClientId();
                    String secret = aadCredentials1.getSecretKey();
                    String url = HTTPS + tenantID + "/api/v1/users/" + userId + "/groups";
                    logger.debug("url to get groups info" + url);
                    Proxy proxy = this.settingsDao.getProxy(cloudId);
                    if (proxy != null || !org.springframework.util.StringUtils.isEmpty((Object)this.registry.get(cloudId).getProxyHost()) && !org.springframework.util.StringUtils.isEmpty((Object)this.registry.get(cloudId).getProxyPort())) {
                        logger.debug("host :" + this.registry.get(cloudId).getProxyHost());
                        logger.debug("port :" + this.registry.get(cloudId).getProxyPort());
                        HttpHost proxyval = new HttpHost(this.registry.get(cloudId).getProxyHost(), this.registry.get(cloudId).getProxyPort(), "http");
                        DefaultProxyRoutePlanner routePlanner = new DefaultProxyRoutePlanner(proxyval);
                        httpclient = HttpClients.custom().setRoutePlanner((HttpRoutePlanner)routePlanner).build();
                    } else {
                        httpclient = HttpClients.custom().build();
                    }
                    httpGet = new HttpGet(url);
                    httpGet.setHeader("Authorization", "SSWS " + aadCredentials1.getApiToken());
                    httpGet.addHeader("Accept", "application/json");
                    result = httpclient.execute((HttpUriRequest)httpGet);
                    int httpResponseCode = result.getStatusLine().getStatusCode();
                    logger.debug("Status code ..." + httpResponseCode);
                    HttpEntity entity = result.getEntity();
                    String responseBody = null;
                    if (entity != null) {
                        responseBody = EntityUtils.toString((HttpEntity)entity);
                    }
                    if (httpResponseCode == 200 && !org.springframework.util.StringUtils.isEmpty((Object)responseBody)) {
                        groupNames = AADManagementServiceImpl.extractGroupNames(responseBody, aadCredentials1);
                    }
                    if (httpGet == null) break block10;
                }
                catch (Exception e) {
                    logger.error(EXCEPTION + String.valueOf(e));
                    logger.debug(EXCEPTION + e.getMessage());
                    break block11;
                }
                finally {
                    if (httpGet != null) {
                        httpGet.releaseConnection();
                    }
                    this.closeResponse(result);
                    this.closeHttpClient(httpclient);
                }
                httpGet.releaseConnection();
            }
            this.closeResponse(result);
            this.closeHttpClient(httpclient);
        }
        return groupNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<OktaUserElement> getUsersFromOktagroup(int cloudId, IdentityProviderSettings aadCredentials1, String groupID) {
        ArrayList<OktaUserElement> oktaUserElements;
        block12: {
            CloseableHttpResponse result;
            CloseableHttpClient httpclient;
            block11: {
                StringBuilder response = new StringBuilder();
                httpclient = null;
                HttpGet httpGet = null;
                result = null;
                String tenantID = aadCredentials1.getTenentId();
                String clientID = aadCredentials1.getClientId();
                String secret = aadCredentials1.getSecretKey();
                oktaUserElements = new ArrayList<OktaUserElement>();
                try {
                    String url = HTTPS + tenantID + "/api/v1/groups/" + groupID + GRAPH_USER;
                    logger.debug("url to get user in group" + url);
                    Proxy proxy = this.settingsDao.getProxy(cloudId);
                    if (proxy != null || !org.springframework.util.StringUtils.isEmpty((Object)this.registry.get(cloudId).getProxyHost()) && !org.springframework.util.StringUtils.isEmpty((Object)this.registry.get(cloudId).getProxyPort())) {
                        logger.debug("host :" + this.registry.get(cloudId).getProxyHost());
                        logger.debug("port :" + this.registry.get(cloudId).getProxyPort());
                        HttpHost proxyval = new HttpHost(this.registry.get(cloudId).getProxyHost(), this.registry.get(cloudId).getProxyPort(), "http");
                        DefaultProxyRoutePlanner routePlanner = new DefaultProxyRoutePlanner(proxyval);
                        httpclient = HttpClients.custom().setRoutePlanner((HttpRoutePlanner)routePlanner).build();
                    } else {
                        httpclient = HttpClients.custom().build();
                    }
                    httpGet = new HttpGet(url);
                    httpGet.setHeader("Authorization", "SSWS " + aadCredentials1.getApiToken());
                    httpGet.addHeader("Accept", "application/json");
                    result = httpclient.execute((HttpUriRequest)httpGet);
                    int httpResponseCode = result.getStatusLine().getStatusCode();
                    logger.debug("Status code ..." + httpResponseCode);
                    HttpEntity entity = result.getEntity();
                    String responseBody = null;
                    if (entity != null) {
                        responseBody = EntityUtils.toString((HttpEntity)entity);
                    }
                    if (httpResponseCode == 200 && !org.springframework.util.StringUtils.isEmpty((Object)responseBody)) {
                        ObjectMapper mapper = new ObjectMapper();
                        JsonNode root = mapper.readTree(responseBody);
                        ArrayList groupNames = new ArrayList();
                        logger.debug("Users in group ID ");
                        for (JsonNode user : root) {
                            JsonNode profile = user.path("profile");
                            String login = user.path("profile").path("login").asText();
                            String firstName = user.path("profile").path("firstName").asText();
                            String lastName = user.path("profile").path("lastName").asText();
                            OktaUserElement oktaUserElement = (OktaUserElement)mapper.treeToValue((TreeNode)profile, OktaUserElement.class);
                            oktaUserElements.add(oktaUserElement);
                        }
                    }
                    if (httpGet == null) break block11;
                }
                catch (Exception e) {
                    logger.error(EXCEPTION + String.valueOf(e));
                    logger.debug(EXCEPTION + e.getMessage());
                    break block12;
                }
                finally {
                    if (httpGet != null) {
                        httpGet.releaseConnection();
                    }
                    this.closeResponse(result);
                    this.closeHttpClient(httpclient);
                }
                httpGet.releaseConnection();
            }
            this.closeResponse(result);
            this.closeHttpClient(httpclient);
        }
        return oktaUserElements;
    }

    public static List<String> getGroupNamesFromApp(String oktaDomain, String apiToken, String appId) {
        String url = HTTPS + oktaDomain + "/api/v1/apps/" + appId + "/groups";
        CloseableHttpClient client = HttpClients.createDefault();
        HttpGet request = new HttpGet(url);
        request.setHeader("Authorization", "SSWS " + apiToken);
        request.setHeader("Accept", "application/json");
        logger.debug("url............" + url);
        try {
            String responseBody;
            CloseableHttpResponse response = client.execute((HttpUriRequest)request);
            int httpResponseCode = response.getStatusLine().getStatusCode();
            logger.debug("httpResponseCode............" + httpResponseCode);
            if (httpResponseCode == 200 && !org.springframework.util.StringUtils.isEmpty((Object)(responseBody = EntityUtils.toString((HttpEntity)response.getEntity())))) {
                List<String> groupIds = AADManagementServiceImpl.extractGroupIDs(responseBody);
                return groupIds;
            }
        }
        catch (IOException e) {
            logger.error("Error to get okta GroupID:", (Throwable)e);
        }
        catch (Exception e) {
            logger.error("Error to get okta GroupID:", (Throwable)e);
        }
        return null;
    }

    public static String getOktaGroupIdByGroupName(String oktaDomain, String apiToken, String groupName) {
        String encodedName = URLEncoder.encode(groupName, StandardCharsets.UTF_8);
        String url = HTTPS + oktaDomain + "/api/v1/groups?q=" + encodedName;
        CloseableHttpClient client = HttpClients.createDefault();
        HttpGet request = new HttpGet(url);
        request.setHeader("Authorization", "SSWS " + apiToken);
        request.setHeader("Accept", "application/json");
        logger.debug("url............" + url);
        try {
            String responseBody;
            ObjectMapper mapper;
            JsonNode groups;
            CloseableHttpResponse response = client.execute((HttpUriRequest)request);
            int httpResponseCode = response.getStatusLine().getStatusCode();
            if (httpResponseCode == 200 && (groups = (mapper = new ObjectMapper()).readTree(responseBody = EntityUtils.toString((HttpEntity)response.getEntity()))) != null) {
                for (JsonNode group : groups) {
                    String name = group.path("profile").path("name").asText();
                    if (!name.equalsIgnoreCase(groupName)) continue;
                    return group.path("id").asText();
                }
            }
        }
        catch (IOException e) {
            logger.error("Error to get okta GroupID:", (Throwable)e);
        }
        catch (Exception e) {
            logger.error("Error to get okta GroupID:", (Throwable)e);
        }
        return null;
    }

    @Override
    public void syncOktaGroups(Cloud cloud) {
        int cloudId = cloud.getCloudId();
        CloudProperties cloudProperties = this.cloudDao.getCloudProperties(cloudId);
        IdentityProviderSettings aadCredentials = this.aadDao.getAADCredentials(cloudId);
        try {
            IdentityProviderSettings workspaceSettings = this.aadDao.getGworkspaceSettings(cloudId);
            Set groupsInDB = workspaceSettings.getGroupMapping().stream().map(GroupMapping::getGroupName).filter(group -> !org.springframework.util.StringUtils.isEmpty((Object)group)).collect(Collectors.toSet());
            ArrayList<AADUserElement> aadUserElements = new ArrayList<AADUserElement>();
            if (CollectionUtils.isEmpty(groupsInDB)) {
                logger.debug("Group name is empty so retun..");
                return;
            }
            List<String> groupIds = AADManagementServiceImpl.getGroupNamesFromApp(workspaceSettings.getTenentId(), workspaceSettings.getApiToken(), workspaceSettings.getClientId());
            boolean isManyToManyEnabled = workspaceSettings.isManyToManyMappingEnabled();
            for (GroupMapping groupConfig : workspaceSettings.getGroupMapping()) {
                try {
                    if (!groupIds.contains(groupConfig.getGroupID())) {
                        logger.debug("Group name is not assigned to app so skip sync");
                        continue;
                    }
                    List<OktaUserElement> oktaUserElements = this.getUsersFromOktagroup(cloudId, aadCredentials, groupConfig.getGroupID());
                    if (oktaUserElements == null || oktaUserElements.isEmpty()) {
                        logger.debug("No members found in the group.");
                        continue;
                    }
                    logger.debug("Members of the group '" + String.valueOf(groupConfig) + "':");
                    for (OktaUserElement member : oktaUserElements) {
                        AADUserElement aadUserElement = new AADUserElement();
                        for (AADUserElement aadUserElement1 : aadUserElements) {
                            if (!aadUserElement1.getMail().equalsIgnoreCase(member.getMail())) continue;
                            aadUserElement = aadUserElement1;
                            aadUserElements.remove(aadUserElement1);
                            break;
                        }
                        logger.debug(member.getMail());
                        aadUserElement.setUserName(member.getMail());
                        aadUserElement.setUserPrincipalName(member.getMail());
                        aadUserElement.setMail(member.getMail());
                        if (groupConfig.getProductType().equalsIgnoreCase(CPHelperConstant.PARABLU_PRODUCT_TYPE.GMAIL.getProductType())) {
                            aadUserElement.setGmailBkpEnabled(true);
                            if (isManyToManyEnabled) {
                                aadUserElement.setDefaultGmailPolicy(groupConfig.getPolicyName());
                            } else {
                                aadUserElement.setDefaultGmailPolicy(this.registry.get(cloud.getCloudId()).getDefaultGmailPolicy());
                            }
                        }
                        if (groupConfig.getProductType().equalsIgnoreCase(CPHelperConstant.PARABLU_PRODUCT_TYPE.GOOGLEDRIVE.getProductType())) {
                            aadUserElement.setGdriveBkpEnabled(true);
                            if (isManyToManyEnabled) {
                                aadUserElement.setDefaultGdrivePolicy(groupConfig.getPolicyName());
                            } else {
                                aadUserElement.setDefaultGdrivePolicy(this.registry.get(cloud.getCloudId()).getDefaultGdrivePolicyName());
                            }
                        }
                        if (groupConfig.getProductType().equalsIgnoreCase(CPHelperConstant.PARABLU_PRODUCT_TYPE.EXCHANGE.getProductType())) {
                            aadUserElement.setExchangeBkpEnabled(true);
                            if (isManyToManyEnabled) {
                                aadUserElement.setDefaultExchangePolicy(groupConfig.getPolicyName());
                            } else {
                                aadUserElement.setDefaultExchangePolicy(this.registry.get(cloud.getCloudId()).getPropertyFileValueDefaultExchangePolicy());
                            }
                        }
                        if (groupConfig.getProductType().equalsIgnoreCase(CPHelperConstant.PARABLU_PRODUCT_TYPE.ODB.getProductType())) {
                            aadUserElement.setOnedriveBkpEnabled(true);
                            if (isManyToManyEnabled) {
                                aadUserElement.setDefaultOdbPolicy(groupConfig.getPolicyName());
                            } else {
                                aadUserElement.setDefaultOdbPolicy(this.registry.get(cloud.getCloudId()).getPropertyFileValueDefaultOdbPolicy());
                            }
                        }
                        if (groupConfig.getProductType().equalsIgnoreCase(CPHelperConstant.PARABLU_PRODUCT_TYPE.BACKUP.getProductType())) {
                            aadUserElement.setBackupEnabled(true);
                            if (isManyToManyEnabled) {
                                aadUserElement.setDefaultPolicy(groupConfig.getPolicyName());
                            } else {
                                aadUserElement.setDefaultPolicy(this.registry.get(cloud.getCloudId()).getPropertyFileValueDefaultBkpPolicy());
                            }
                        }
                        if (groupConfig.getProductType().equalsIgnoreCase(CPHelperConstant.PARABLU_PRODUCT_TYPE.SYNC.getProductType())) {
                            aadUserElement.setSyncEnabled(true);
                            if (isManyToManyEnabled) {
                                aadUserElement.setDefaultSyncPolicy(groupConfig.getPolicyName());
                            } else {
                                aadUserElement.setDefaultSyncPolicy(this.registry.get(cloud.getCloudId()).getPropertyFileValueDefaultSyncPolicy());
                            }
                        }
                        if (StringUtils.isEmpty((CharSequence)aadUserElement.getDefaultGdrivePolicy())) {
                            aadUserElement.setDefaultGdrivePolicy(this.registry.get(cloud.getCloudId()).getDefaultGdrivePolicyName());
                        }
                        if (StringUtils.isEmpty((CharSequence)aadUserElement.getDefaultGmailPolicy())) {
                            aadUserElement.setDefaultGmailPolicy(this.registry.get(cloud.getCloudId()).getDefaultGmailPolicy());
                        }
                        if (StringUtils.isEmpty((CharSequence)aadUserElement.getDefaultOdbPolicy())) {
                            aadUserElement.setDefaultOdbPolicy(this.registry.get(cloud.getCloudId()).getPropertyFileValueDefaultOdbPolicy());
                        }
                        if (StringUtils.isEmpty((CharSequence)aadUserElement.getDefaultExchangePolicy())) {
                            aadUserElement.setDefaultExchangePolicy(this.registry.get(cloudId).getPropertyFileValueDefaultExchangePolicy());
                        }
                        if (StringUtils.isEmpty((CharSequence)aadUserElement.getDefaultSharepointPolicy())) {
                            aadUserElement.setDefaultSharepointPolicy(this.registry.get(cloudId).getPropertyFileValueDefaultSpPolicy());
                        }
                        if (StringUtils.isEmpty((CharSequence)aadUserElement.getDefaultPolicy())) {
                            aadUserElement.setDefaultPolicy(this.registry.get(cloudId).getPropertyFileValueDefaultBkpPolicy());
                        }
                        if (StringUtils.isEmpty((CharSequence)aadUserElement.getDefaultSyncPolicy())) {
                            aadUserElement.setDefaultSyncPolicy(this.registry.get(cloudId).getPropertyFileValueDefaultSyncPolicy());
                        }
                        aadUserElements.add(aadUserElement);
                    }
                }
                catch (Exception e) {
                    logger.error(".error......", (Throwable)e);
                }
            }
            Map<String, AADUserElement> aadMap = aadUserElements.stream().collect(Collectors.toMap(aaduser -> aaduser.getUserPrincipalName().toLowerCase(), aaduser -> aaduser));
            Map<Object, Object> aadMapWithEmail = new HashMap();
            try {
                aadMapWithEmail = aadUserElements.stream().filter(aaduser -> aaduser.getMail() != null).collect(Collectors.toMap(aaduser -> aaduser.getMail().toLowerCase(), aaduser -> aaduser));
                logger.debug("after convert to aadMapWithEmail..." + aadMapWithEmail.size());
            }
            catch (Exception e) {
                logger.error("error getting the mail add:", (Throwable)e);
            }
            List allUsers = this.userDao.getAllUsers(cloudId);
            ArrayList<User> guestUsers = new ArrayList<User>();
            HashMap<String, User> userMap = new HashMap<String, User>();
            for (User user : allUsers) {
                if (!user.isLocalUser() && !user.isGuest()) {
                    String userName = user.getUserName();
                    if (!org.springframework.util.StringUtils.isEmpty((Object)user.getAadLoginId())) {
                        userName = user.getAadLoginId();
                    }
                    userMap.put(userName.toLowerCase(), user);
                    continue;
                }
                if (!user.isGuest()) continue;
                guestUsers.add(user);
            }
            for (User user : guestUsers) {
                logger.debug("guest user..." + user.getUserName());
                logger.debug("guest user.mail.." + user.getEmailId());
                if (aadMap.containsKey(user.getUserName()) || aadMap.containsKey(user.getUserName().toLowerCase())) {
                    logger.debug("removeUserbyID.........." + String.valueOf(user.getUserId()));
                    this.userDao.removeUserbyID(cloudId, user.getUserId().toString());
                    continue;
                }
                if (!aadMapWithEmail.containsKey(user.getUserName().toLowerCase()) && !aadMapWithEmail.containsKey(user.getUserName())) continue;
                logger.debug("removeUserbyID.........." + String.valueOf(user.getUserId()));
                this.userDao.removeUserbyID(cloudId, user.getUserId().toString());
            }
            logger.debug(aadMap.size() + ".....map diff ..." + userMap.size());
            for (Map.Entry entry : userMap.entrySet()) {
                User existingUser = (User)entry.getValue();
                if (aadMap.containsKey(entry.getKey())) {
                    long totalBkpUsers;
                    int noOfBkpUsersAllowed;
                    long totalSyncUsers;
                    int noOfSyncUsersAllowed;
                    long totalExchangekpUsers;
                    int noOfExchangeUsersAllowed;
                    long totalOdbBkpUsers;
                    int noOfOneDriveUsersAllowed;
                    AADUserElement aadUserElement = aadMap.get(entry.getKey());
                    logger.debug("...already in user iteration..." + (String)entry.getKey());
                    boolean anyChange = false;
                    if (!anyChange && aadUserElement.isGmailBkpEnabled() != existingUser.isGmailBkpEnabled()) {
                        anyChange = true;
                    }
                    if (!anyChange && aadUserElement.isGdriveBkpEnabled() != existingUser.isGdriveBkpEnabled()) {
                        anyChange = true;
                    }
                    if (!anyChange && aadUserElement.isOnedriveBkpEnabled() != existingUser.isOnedriveBkpEnabled()) {
                        anyChange = true;
                    }
                    if (!anyChange && aadUserElement.isExchangeBkpEnabled() != existingUser.isExchangeBkpEnabled()) {
                        anyChange = true;
                    }
                    if (!anyChange && aadUserElement.isSharePointBkpEnabled() != existingUser.isSharePointBkpEnabled()) {
                        anyChange = true;
                    }
                    if (!anyChange && aadUserElement.isBackupEnabled() != existingUser.isBackupEnabled()) {
                        anyChange = true;
                    }
                    if (!anyChange && aadUserElement.isSyncEnabled() != existingUser.isSyncEnabled()) {
                        anyChange = true;
                    }
                    if (existingUser.isSoftBlockEnabled()) {
                        anyChange = true;
                    }
                    if (!anyChange) continue;
                    logger.debug("...inside anyChange...........");
                    if (aadUserElement.isGmailBkpEnabled() && this.isLiecnseEnabled(cloud.getCloudCustomisableDetails(), GMAIL_BACKUP_ENABLED) && ((long)(noOfOneDriveUsersAllowed = cloud.getNoOfGmailUsersAllowed()) == (totalOdbBkpUsers = this.userDao.countOfPresentGmailBackupUsers(cloud.getCloudId(), "", true)) && !existingUser.isGmailBkpEnabled() || (long)noOfOneDriveUsersAllowed < totalOdbBkpUsers)) {
                        logger.debug("gmail  USER LIMIT REACHED........");
                        aadUserElement.setGmailBkpEnabled(false);
                    }
                    if (aadUserElement.isGdriveBkpEnabled() && this.isLiecnseEnabled(cloud.getCloudCustomisableDetails(), GDRIVE_BACKUP_ENABLED) && ((long)(noOfExchangeUsersAllowed = cloud.getNoOfGdriveUsersAllowed()) == (totalExchangekpUsers = this.userDao.countOfPresentGdriveBackupUsers(cloud.getCloudId(), "", true)) && !existingUser.isGdriveBkpEnabled() || (long)noOfExchangeUsersAllowed < totalExchangekpUsers)) {
                        logger.debug("gdrive USER LIMIT REACHED........");
                        aadUserElement.setGdriveBkpEnabled(false);
                    }
                    if (aadUserElement.isSyncEnabled() && ((long)(noOfSyncUsersAllowed = cloud.getNoOfSyncUsersAllowed()) == (totalSyncUsers = this.userDao.countOfPresentSyncUsers(cloud.getCloudId(), cloud.getCloudName(), true)) && !existingUser.isSyncEnabled() || (long)noOfSyncUsersAllowed < totalSyncUsers)) {
                        logger.debug(" SYNC USER LIMIT REACHED........");
                        aadUserElement.setSyncEnabled(false);
                    }
                    if (aadUserElement.isOnedriveBkpEnabled() && this.isLiecnseEnabled(cloud.getCloudCustomisableDetails(), ODB_BACKUP_ENABLED) && ((long)(noOfOneDriveUsersAllowed = cloud.getNoOfOneDriveUsersAllowed()) == (totalOdbBkpUsers = this.userDao.countOfPresentOnedriveUsers(cloud.getCloudId(), true)) && !existingUser.isOnedriveBkpEnabled() || (long)noOfOneDriveUsersAllowed < totalOdbBkpUsers)) {
                        logger.debug("onedrive  USER LIMIT REACHED........");
                        aadUserElement.setOnedriveBkpEnabled(false);
                    }
                    if (aadUserElement.isExchangeBkpEnabled() && this.isLiecnseEnabled(cloud.getCloudCustomisableDetails(), EXCHANGE_BACKUP_ENABLED) && ((long)(noOfExchangeUsersAllowed = cloud.getNoOfExchangeUsersAllowed()) == (totalExchangekpUsers = this.userDao.countOfPresentExchangeUsers(cloud.getCloudId(), true)) && !existingUser.isExchangeBkpEnabled() || (long)noOfExchangeUsersAllowed < totalExchangekpUsers)) {
                        logger.debug("exchange USER LIMIT REACHED........");
                        aadUserElement.setExchangeBkpEnabled(false);
                    }
                    if (aadUserElement.isBackupEnabled() && ((long)(noOfBkpUsersAllowed = cloud.getNoOfBackupUsersAllowed()) == (totalBkpUsers = this.userDao.countOfPresentBackupUsers(cloud.getCloudId(), cloud.getCloudName(), true, true)) && !existingUser.isBackupEnabled() || (long)noOfBkpUsersAllowed < totalBkpUsers)) {
                        logger.debug(" BACKUP USER LIMIT REACHED........");
                        aadUserElement.setBackupEnabled(false);
                    }
                    boolean previStatus = existingUser.isActive();
                    existingUser.setGmailBkpEnabled(aadUserElement.isGmailBkpEnabled());
                    existingUser.setGdriveBkpEnabled(aadUserElement.isGdriveBkpEnabled());
                    existingUser.setOnedriveBkpEnabled(aadUserElement.isOnedriveBkpEnabled());
                    existingUser.setExchangeBkpEnabled(aadUserElement.isExchangeBkpEnabled());
                    existingUser.setShareEnabled(aadUserElement.isSharePointBkpEnabled());
                    existingUser.setBackupEnabled(aadUserElement.isBackupEnabled());
                    existingUser.setSyncEnabled(aadUserElement.isSyncEnabled());
                    existingUser.setSoftBlockEnabled(false);
                    existingUser.setActive(true);
                    this.userDao.saveUser(cloud.getCloudId(), cloud.getCloudName(), existingUser);
                    this.deviceDao.updateUserStatusInDeviceBkpOverview(cloudId, existingUser.getUserName(), Boolean.valueOf(existingUser.isActive()));
                    this.blockDevice(existingUser, cloud.getCloudName(), cloudId);
                    this.setAuditForAADBlockedOrUnblocked(cloud.getCloudId(), cloud.getCloudName(), existingUser.getUserName(), existingUser.isActive(), previStatus);
                    continue;
                }
                logger.debug("...inside blocking existing user" + (String)entry.getKey());
                if (cloudProperties != null && cloudProperties.isSoftBlockEnabled()) {
                    if (existingUser.isSoftBlockEnabled()) continue;
                    existingUser.setSoftBlockEnabled(true);
                    existingUser.setSoftBlockedTime(System.currentTimeMillis());
                    this.userDao.saveUser(cloud.getCloudId(), cloud.getCloudName(), existingUser);
                    continue;
                }
                boolean previStatus = existingUser.isActive();
                existingUser.setGmailBkpEnabled(false);
                existingUser.setGdriveBkpEnabled(false);
                existingUser.setOnedriveBkpEnabled(false);
                existingUser.setExchangeBkpEnabled(false);
                existingUser.setShareEnabled(false);
                existingUser.setBackupEnabled(false);
                existingUser.setSyncEnabled(false);
                existingUser.setActive(false);
                this.userDao.saveUser(cloud.getCloudId(), cloud.getCloudName(), existingUser);
                this.deviceDao.updateUserInfoInDeviceBkpOverview(cloud.getCloudId(), existingUser);
                this.setAuditForAADBlockedOrUnblocked(cloud.getCloudId(), cloud.getCloudName(), existingUser.getUserName(), existingUser.isActive(), previStatus);
                this.changeDeviceStatusAndAduit(cloud, existingUser);
            }
            for (Map.Entry entry : aadMap.entrySet()) {
                if (userMap.containsKey(entry.getKey())) continue;
                logger.debug("...adding new user to user collection..." + (String)entry.getKey());
                AADUserElement aadUserElement = aadMap.get(entry.getKey());
                this.updateOrCreateAADUserInfo(cloud, aadUserElement, aadCredentials);
            }
        }
        catch (Exception e) {
            logger.error("error to sync okta groups", (Throwable)e);
            return;
        }
    }

    public boolean checkIFokataUserIsValid(String userName, IdentityProviderSettings workspaceSettings, int cloudId) {
        block8: {
            String encodedUserName = URLEncoder.encode(userName, StandardCharsets.UTF_8);
            String url = HTTPS + workspaceSettings.getTenentId() + "/api/v1/users?q=" + encodedUserName;
            CloseableHttpClient client = HttpClients.createDefault();
            HttpGet request = new HttpGet(url);
            request.setHeader("Authorization", "SSWS " + workspaceSettings.getApiToken());
            request.setHeader("Accept", "application/json");
            String userId = null;
            try {
                CloseableHttpResponse response = client.execute((HttpUriRequest)request);
                int httpResponseCode = response.getStatusLine().getStatusCode();
                if (CollectionUtils.isEmpty((Collection)workspaceSettings.getGroupMapping())) {
                    if (httpResponseCode == 200) {
                        return true;
                    }
                    break block8;
                }
                if (httpResponseCode != 200) break block8;
                String responseBody = EntityUtils.toString((HttpEntity)response.getEntity());
                ObjectMapper objectMapper = new ObjectMapper();
                if (org.springframework.util.StringUtils.isEmpty((Object)responseBody)) break block8;
                JsonNode rootNode = objectMapper.readTree(responseBody);
                if (rootNode.isArray() && rootNode.size() > 0) {
                    JsonNode firstUser = rootNode.get(0);
                    userId = firstUser.get("id").asText();
                    if (!org.springframework.util.StringUtils.isEmpty((Object)userId)) {
                        List<String> groupNames = this.getoktaGroupNamesfromUserId(cloudId, workspaceSettings, userId);
                        for (GroupMapping group : workspaceSettings.getGroupMapping()) {
                            if (!groupNames.contains(group.getGroupName().toLowerCase())) continue;
                            return true;
                        }
                    }
                    break block8;
                }
                return false;
            }
            catch (IOException e) {
                logger.error("Error to get okta GroupID:", (Throwable)e);
            }
            catch (Exception e) {
                logger.error("Error to get okta GroupID:", (Throwable)e);
            }
        }
        return false;
    }
}

