/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.bluvault.udc.helper;

import com.azure.core.credential.TokenCredential;
import com.azure.core.http.ProxyOptions;
import com.azure.identity.ClientSecretCredential;
import com.azure.identity.ClientSecretCredentialBuilder;
import com.microsoft.graph.authentication.IAuthenticationProvider;
import com.microsoft.graph.authentication.TokenCredentialAuthProvider;
import com.microsoft.graph.httpcore.HttpClients;
import com.microsoft.graph.requests.GraphServiceClient;
import com.parablu.paracloud.constant.CloudConfigRegistry;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.ArrayList;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GraphClientProvider {
    private static final Logger logger = LogManager.getLogger(GraphClientProvider.class);
    private final int cloudId;
    private final CloudConfigRegistry registry;

    public GraphClientProvider(int cloudId, CloudConfigRegistry registry) {
        this.cloudId = cloudId;
        this.registry = registry;
    }

    public GraphServiceClient<Request> createGraphClient() {
        OkHttpClient httpClient = this.createOkHttpClient();
        TokenCredentialAuthProvider authProvider = this.createAuthProvider();
        return GraphServiceClient.builder().authenticationProvider((IAuthenticationProvider)authProvider).httpClient((Object)httpClient).buildClient();
    }

    public OkHttpClient createOkHttpClient() {
        TokenCredentialAuthProvider authProvider = this.createAuthProvider();
        OkHttpClient.Builder builder = HttpClients.createDefault((IAuthenticationProvider)authProvider).newBuilder();
        if (this.hasProxy()) {
            Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(this.registry.get(this.cloudId).getProxyHost(), this.registry.get(this.cloudId).getProxyPort()));
            builder.proxy(proxy);
            logger.debug("Proxy applied for Graph client: " + String.valueOf(proxy.address()));
        }
        return builder.build();
    }

    private TokenCredentialAuthProvider createAuthProvider() {
        String authorityHost = "https://login.microsoftonline.com";
        ClientSecretCredentialBuilder credentialBuilder = (ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)new ClientSecretCredentialBuilder().clientId(this.registry.get(this.cloudId).getMSClientId())).clientSecret(this.registry.get(this.cloudId).getMSClientSecret()).tenantId(this.registry.get(this.cloudId).getMSTenantId())).authorityHost(authorityHost);
        if (this.hasProxy()) {
            ProxyOptions proxyOptions = new ProxyOptions(ProxyOptions.Type.HTTP, new InetSocketAddress(this.registry.get(this.cloudId).getProxyHost(), this.registry.get(this.cloudId).getProxyPort()));
            credentialBuilder.proxyOptions(proxyOptions);
            logger.debug("ProxyOptions applied to ClientSecretCredential");
        }
        ClientSecretCredential credential = credentialBuilder.build();
        ArrayList<String> scopes = new ArrayList<String>();
        scopes.add("https://graph.microsoft.com/.default");
        return new TokenCredentialAuthProvider(scopes, (TokenCredential)credential);
    }

    private boolean hasProxy() {
        String host = this.registry.get(this.cloudId).getProxyHost();
        int port = this.registry.get(this.cloudId).getProxyPort();
        return host != null && !host.isEmpty() && port > 0;
    }
}

